/* libntkresolv.c generated by valac 0.20.1, the Vala compiler
 * generated from libntkresolv.vala, do not modify */

/*
 *  This file is part of Netsukuku.
 *  (c) Copyright 2014 Luca Dionisi aka lukisi <luca.dionisi@gmail.com>
 *
 *  Netsukuku is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Netsukuku is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Netsukuku.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <tasklet.h>
#include <syslog.h>
#include <zcd.h>
#include <andns-rpc.h>
#include <netsukuku-rpc.h>
#include <gee.h>
#include <unistd.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define NTKRESOLV_TYPE_NTK_ADDR (ntkresolv_ntk_addr_get_type ())
#define NTKRESOLV_NTK_ADDR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NTKRESOLV_TYPE_NTK_ADDR, NtkresolvNtkAddr))
#define NTKRESOLV_NTK_ADDR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NTKRESOLV_TYPE_NTK_ADDR, NtkresolvNtkAddrClass))
#define NTKRESOLV_IS_NTK_ADDR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NTKRESOLV_TYPE_NTK_ADDR))
#define NTKRESOLV_IS_NTK_ADDR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NTKRESOLV_TYPE_NTK_ADDR))
#define NTKRESOLV_NTK_ADDR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NTKRESOLV_TYPE_NTK_ADDR, NtkresolvNtkAddrClass))

typedef struct _NtkresolvNtkAddr NtkresolvNtkAddr;
typedef struct _NtkresolvNtkAddrClass NtkresolvNtkAddrClass;
typedef struct _NtkresolvNtkAddrPrivate NtkresolvNtkAddrPrivate;

#define NTKRESOLV_TYPE_NTK_INET_ADDR (ntkresolv_ntk_inet_addr_get_type ())
#define NTKRESOLV_NTK_INET_ADDR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NTKRESOLV_TYPE_NTK_INET_ADDR, NtkresolvNtkInetAddr))
#define NTKRESOLV_NTK_INET_ADDR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NTKRESOLV_TYPE_NTK_INET_ADDR, NtkresolvNtkInetAddrClass))
#define NTKRESOLV_IS_NTK_INET_ADDR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NTKRESOLV_TYPE_NTK_INET_ADDR))
#define NTKRESOLV_IS_NTK_INET_ADDR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NTKRESOLV_TYPE_NTK_INET_ADDR))
#define NTKRESOLV_NTK_INET_ADDR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NTKRESOLV_TYPE_NTK_INET_ADDR, NtkresolvNtkInetAddrClass))

typedef struct _NtkresolvNtkInetAddr NtkresolvNtkInetAddr;
typedef struct _NtkresolvNtkInetAddrClass NtkresolvNtkInetAddrClass;
typedef struct _NtkresolvNtkInetAddrPrivate NtkresolvNtkInetAddrPrivate;

#define NTKRESOLV_TYPE_IP_FAMILY (ntkresolv_ip_family_get_type ())

#define NTKRESOLV_TYPE_IP_PROTOCOL (ntkresolv_ip_protocol_get_type ())

#define NTKRESOLV_TYPE_SOCKET_TYPE (ntkresolv_socket_type_get_type ())

#define NTKRESOLV_TYPE_NTK_ADDR_INFO (ntkresolv_ntk_addr_info_get_type ())
#define NTKRESOLV_NTK_ADDR_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NTKRESOLV_TYPE_NTK_ADDR_INFO, NtkresolvNtkAddrInfo))
#define NTKRESOLV_NTK_ADDR_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NTKRESOLV_TYPE_NTK_ADDR_INFO, NtkresolvNtkAddrInfoClass))
#define NTKRESOLV_IS_NTK_ADDR_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NTKRESOLV_TYPE_NTK_ADDR_INFO))
#define NTKRESOLV_IS_NTK_ADDR_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NTKRESOLV_TYPE_NTK_ADDR_INFO))
#define NTKRESOLV_NTK_ADDR_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NTKRESOLV_TYPE_NTK_ADDR_INFO, NtkresolvNtkAddrInfoClass))

typedef struct _NtkresolvNtkAddrInfo NtkresolvNtkAddrInfo;
typedef struct _NtkresolvNtkAddrInfoClass NtkresolvNtkAddrInfoClass;
typedef struct _NtkresolvNtkAddrInfoPrivate NtkresolvNtkAddrInfoPrivate;

#define NTKRESOLV_TYPE_RESOLV_CALL (ntkresolv_resolv_call_get_type ())
#define NTKRESOLV_RESOLV_CALL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NTKRESOLV_TYPE_RESOLV_CALL, NtkresolvResolvCall))
#define NTKRESOLV_RESOLV_CALL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NTKRESOLV_TYPE_RESOLV_CALL, NtkresolvResolvCallClass))
#define NTKRESOLV_IS_RESOLV_CALL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NTKRESOLV_TYPE_RESOLV_CALL))
#define NTKRESOLV_IS_RESOLV_CALL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NTKRESOLV_TYPE_RESOLV_CALL))
#define NTKRESOLV_RESOLV_CALL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NTKRESOLV_TYPE_RESOLV_CALL, NtkresolvResolvCallClass))

typedef struct _NtkresolvResolvCall NtkresolvResolvCall;
typedef struct _NtkresolvResolvCallClass NtkresolvResolvCallClass;
typedef struct _NtkresolvResolvCallPrivate NtkresolvResolvCallPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define NTKRESOLV_TYPE_INVERSE_CALL (ntkresolv_inverse_call_get_type ())
#define NTKRESOLV_INVERSE_CALL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NTKRESOLV_TYPE_INVERSE_CALL, NtkresolvInverseCall))
#define NTKRESOLV_INVERSE_CALL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NTKRESOLV_TYPE_INVERSE_CALL, NtkresolvInverseCallClass))
#define NTKRESOLV_IS_INVERSE_CALL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NTKRESOLV_TYPE_INVERSE_CALL))
#define NTKRESOLV_IS_INVERSE_CALL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NTKRESOLV_TYPE_INVERSE_CALL))
#define NTKRESOLV_INVERSE_CALL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NTKRESOLV_TYPE_INVERSE_CALL, NtkresolvInverseCallClass))

typedef struct _NtkresolvInverseCall NtkresolvInverseCall;
typedef struct _NtkresolvInverseCallClass NtkresolvInverseCallClass;
typedef struct _NtkresolvInverseCallPrivate NtkresolvInverseCallPrivate;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _NtkresolvNtkAddr {
	GObject parent_instance;
	NtkresolvNtkAddrPrivate * priv;
};

struct _NtkresolvNtkAddrClass {
	GObjectClass parent_class;
};

struct _NtkresolvNtkInetAddr {
	NtkresolvNtkAddr parent_instance;
	NtkresolvNtkInetAddrPrivate * priv;
	guint8 addr[4];
	guint16 port;
};

struct _NtkresolvNtkInetAddrClass {
	NtkresolvNtkAddrClass parent_class;
};

typedef enum  {
	NTKRESOLV_IP_FAMILY_IPV4,
	NTKRESOLV_IP_FAMILY_IPV6,
	NTKRESOLV_IP_FAMILY_UNSPEC
} NtkresolvIpFamily;

typedef enum  {
	NTKRESOLV_IP_PROTOCOL_IP,
	NTKRESOLV_IP_PROTOCOL_TCP,
	NTKRESOLV_IP_PROTOCOL_UDP
} NtkresolvIpProtocol;

typedef enum  {
	NTKRESOLV_SOCKET_TYPE_DATAGRAM,
	NTKRESOLV_SOCKET_TYPE_STREAM,
	NTKRESOLV_SOCKET_TYPE_UNSPEC
} NtkresolvSocketType;

struct _NtkresolvNtkAddrInfo {
	GObject parent_instance;
	NtkresolvNtkAddrInfoPrivate * priv;
	NtkresolvIpFamily family;
	NtkresolvSocketType socket_type;
	NtkresolvIpProtocol protocol;
	NtkresolvNtkAddr* address;
};

struct _NtkresolvNtkAddrInfoClass {
	GObjectClass parent_class;
};

typedef enum  {
	NTKRESOLV_NTKRESOLV_ERROR_GENERIC
} NtkresolvNtkresolvError;
#define NTKRESOLV_NTKRESOLV_ERROR ntkresolv_ntkresolv_error_quark ()
struct _NtkresolvResolvCall {
	GObject parent_instance;
	NtkresolvResolvCallPrivate * priv;
	gchar* node;
	gchar* service;
	NtkresolvNtkAddrInfo* _hints;
	gchar* tcpaddress;
	GeeList* retval;
	GError* e;
	gboolean completed;
	gboolean started;
};

struct _NtkresolvResolvCallClass {
	GObjectClass parent_class;
};

struct _NtkresolvInverseCall {
	GObject parent_instance;
	NtkresolvInverseCallPrivate * priv;
	NtkresolvIpFamily family;
	NtkresolvNtkAddr* addr;
	gchar* tcpaddress;
	GeeList* retval;
	GError* e;
	gboolean completed;
	gboolean started;
};

struct _NtkresolvInverseCallClass {
	GObjectClass parent_class;
};


static gpointer ntkresolv_ntk_addr_parent_class = NULL;
static gpointer ntkresolv_ntk_inet_addr_parent_class = NULL;
static gpointer ntkresolv_ntk_addr_info_parent_class = NULL;
static gpointer ntkresolv_resolv_call_parent_class = NULL;
extern GeeArrayList* ntkresolv_lst_dispatched_resolv;
GeeArrayList* ntkresolv_lst_dispatched_resolv = NULL;
static gpointer ntkresolv_inverse_call_parent_class = NULL;
extern GeeArrayList* ntkresolv_lst_dispatched_inverse;
GeeArrayList* ntkresolv_lst_dispatched_inverse = NULL;

gchar* ntkresolv_tasklet_id (void);
void ntkresolv_log_debug (const gchar* msg);
void ntkresolv_log_info (const gchar* msg);
void ntkresolv_log_notice (const gchar* msg);
void ntkresolv_log_warn (const gchar* msg);
void ntkresolv_log_error (const gchar* msg);
void ntkresolv_log_critical (const gchar* msg);
GType ntkresolv_ntk_addr_get_type (void) G_GNUC_CONST;
enum  {
	NTKRESOLV_NTK_ADDR_DUMMY_PROPERTY
};
NtkresolvNtkAddr* ntkresolv_ntk_addr_new (void);
NtkresolvNtkAddr* ntkresolv_ntk_addr_construct (GType object_type);
GType ntkresolv_ntk_inet_addr_get_type (void) G_GNUC_CONST;
enum  {
	NTKRESOLV_NTK_INET_ADDR_DUMMY_PROPERTY
};
NtkresolvNtkInetAddr* ntkresolv_ntk_inet_addr_new (guint8* addr, int addr_length1, guint16 port);
NtkresolvNtkInetAddr* ntkresolv_ntk_inet_addr_construct (GType object_type, guint8* addr, int addr_length1, guint16 port);
NtkresolvNtkInetAddr* ntkresolv_ntk_inet_addr_new_from_pointer (guint8* addr, guint16 port);
NtkresolvNtkInetAddr* ntkresolv_ntk_inet_addr_construct_from_pointer (GType object_type, guint8* addr, guint16 port);
static void ntkresolv_ntk_inet_addr_finalize (GObject* obj);
GType ntkresolv_ip_family_get_type (void) G_GNUC_CONST;
GType ntkresolv_ip_protocol_get_type (void) G_GNUC_CONST;
GType ntkresolv_socket_type_get_type (void) G_GNUC_CONST;
GType ntkresolv_ntk_addr_info_get_type (void) G_GNUC_CONST;
enum  {
	NTKRESOLV_NTK_ADDR_INFO_DUMMY_PROPERTY
};
NtkresolvNtkAddrInfo* ntkresolv_ntk_addr_info_new (void);
NtkresolvNtkAddrInfo* ntkresolv_ntk_addr_info_construct (GType object_type);
static void ntkresolv_ntk_addr_info_finalize (GObject* obj);
GQuark ntkresolv_ntkresolv_error_quark (void);
void ntkresolv_init (gboolean tasklet_initialized);
GType ntkresolv_resolv_call_get_type (void) G_GNUC_CONST;
enum  {
	NTKRESOLV_RESOLV_CALL_DUMMY_PROPERTY
};
NtkresolvResolvCall* ntkresolv_resolv_call_new (const gchar* node, const gchar* service, NtkresolvNtkAddrInfo* _hints, const gchar* tcpaddress);
NtkresolvResolvCall* ntkresolv_resolv_call_construct (GType object_type, const gchar* node, const gchar* service, NtkresolvNtkAddrInfo* _hints, const gchar* tcpaddress);
static void ntkresolv_resolv_call_finalize (GObject* obj);
GeeList* ntkresolv_resolv (const gchar* node, const gchar* service, NtkresolvNtkAddrInfo* _hints, const gchar* tcpaddress, GError** error);
static void _______lambda2_ (GObject* tpar1, GError** error);
GeeList* ntkresolv_tasklet_resolv (const gchar* node, const gchar* service, NtkresolvNtkAddrInfo* _hints, const gchar* tcpaddress, GError** error);
static void ________lambda2__tasklets_tasklet_callback (GObject* obj1, GObject* obj2, GObject* obj3, GObject* obj4, gpointer self, GError** error);
gchar* netsukuku_inet_utils_crypto_hash (const gchar* hostname);
const gchar* andns_andna_response_code_to_string (AndnsAndnaResponseCode self);
GType ntkresolv_inverse_call_get_type (void) G_GNUC_CONST;
enum  {
	NTKRESOLV_INVERSE_CALL_DUMMY_PROPERTY
};
NtkresolvInverseCall* ntkresolv_inverse_call_new (NtkresolvIpFamily family, NtkresolvNtkAddr* addr, const gchar* tcpaddress);
NtkresolvInverseCall* ntkresolv_inverse_call_construct (GType object_type, NtkresolvIpFamily family, NtkresolvNtkAddr* addr, const gchar* tcpaddress);
static void ntkresolv_inverse_call_finalize (GObject* obj);
GeeList* ntkresolv_inverse (NtkresolvIpFamily family, NtkresolvNtkAddr* addr, const gchar* tcpaddress, GError** error);
static void _______lambda3_ (GObject* tpar1, GError** error);
GeeList* ntkresolv_tasklet_inverse (NtkresolvIpFamily family, NtkresolvNtkAddr* addr, const gchar* tcpaddress, GError** error);
static void ________lambda3__tasklets_tasklet_callback (GObject* obj1, GObject* obj2, GObject* obj3, GObject* obj4, gpointer self, GError** error);


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


gchar* ntkresolv_tasklet_id (void) {
	gchar* result = NULL;
	TaskletsTasklet* _tmp0_ = NULL;
	TaskletsTasklet* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* ret;
	const gchar* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint len;
	const gchar* _tmp16_;
	const gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	_tmp0_ = tasklets_tasklet_self ();
	_tmp1_ = _tmp0_;
	_tmp2_ = tasklets_tasklet_get_id (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("%i", _tmp3_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp1_);
	ret = _tmp5_;
	_tmp6_ = ret;
	_tmp7_ = strlen (_tmp6_);
	_tmp8_ = _tmp7_;
	len = _tmp8_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp9_;
			_tmp9_ = TRUE;
			while (TRUE) {
				gboolean _tmp10_;
				gint _tmp12_;
				gint _tmp13_;
				const gchar* _tmp14_;
				gchar* _tmp15_;
				_tmp10_ = _tmp9_;
				if (!_tmp10_) {
					gint _tmp11_;
					_tmp11_ = i;
					i = _tmp11_ + 1;
				}
				_tmp9_ = FALSE;
				_tmp12_ = i;
				_tmp13_ = len;
				if (!(_tmp12_ < (5 - _tmp13_))) {
					break;
				}
				_tmp14_ = ret;
				_tmp15_ = g_strconcat (" ", _tmp14_, NULL);
				_g_free0 (ret);
				ret = _tmp15_;
			}
		}
	}
	_tmp16_ = ret;
	_tmp17_ = string_to_string (_tmp16_);
	_tmp18_ = g_strconcat ("[", _tmp17_, "] ", NULL);
	result = _tmp18_;
	_g_free0 (ret);
	return result;
}


void ntkresolv_log_debug (const gchar* msg) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = ntkresolv_tasklet_id ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (_tmp1_, "DEBUG ", NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = msg;
	_tmp5_ = g_strconcat (_tmp3_, _tmp4_, NULL);
	_tmp6_ = _tmp5_;
	syslog (LOG_DEBUG, _tmp6_, NULL);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
}


void ntkresolv_log_info (const gchar* msg) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = ntkresolv_tasklet_id ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (_tmp1_, "INFO ", NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = msg;
	_tmp5_ = g_strconcat (_tmp3_, _tmp4_, NULL);
	_tmp6_ = _tmp5_;
	syslog (LOG_INFO, _tmp6_, NULL);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
}


void ntkresolv_log_notice (const gchar* msg) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = ntkresolv_tasklet_id ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (_tmp1_, "INFO+ ", NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = msg;
	_tmp5_ = g_strconcat (_tmp3_, _tmp4_, NULL);
	_tmp6_ = _tmp5_;
	syslog (LOG_NOTICE, _tmp6_, NULL);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
}


void ntkresolv_log_warn (const gchar* msg) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = ntkresolv_tasklet_id ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (_tmp1_, "INFO++ ", NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = msg;
	_tmp5_ = g_strconcat (_tmp3_, _tmp4_, NULL);
	_tmp6_ = _tmp5_;
	syslog (LOG_WARNING, _tmp6_, NULL);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
}


void ntkresolv_log_error (const gchar* msg) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = ntkresolv_tasklet_id ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (_tmp1_, "ERROR ", NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = msg;
	_tmp5_ = g_strconcat (_tmp3_, _tmp4_, NULL);
	_tmp6_ = _tmp5_;
	syslog (LOG_ERR, _tmp6_, NULL);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
}


void ntkresolv_log_critical (const gchar* msg) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = ntkresolv_tasklet_id ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (_tmp1_, "ERROR+ ", NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = msg;
	_tmp5_ = g_strconcat (_tmp3_, _tmp4_, NULL);
	_tmp6_ = _tmp5_;
	syslog (LOG_CRIT, _tmp6_, NULL);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
}


NtkresolvNtkAddr* ntkresolv_ntk_addr_construct (GType object_type) {
	NtkresolvNtkAddr * self = NULL;
	self = (NtkresolvNtkAddr*) g_object_new (object_type, NULL);
	return self;
}


NtkresolvNtkAddr* ntkresolv_ntk_addr_new (void) {
	return ntkresolv_ntk_addr_construct (NTKRESOLV_TYPE_NTK_ADDR);
}


static void ntkresolv_ntk_addr_class_init (NtkresolvNtkAddrClass * klass) {
	ntkresolv_ntk_addr_parent_class = g_type_class_peek_parent (klass);
}


static void ntkresolv_ntk_addr_instance_init (NtkresolvNtkAddr * self) {
}


GType ntkresolv_ntk_addr_get_type (void) {
	static volatile gsize ntkresolv_ntk_addr_type_id__volatile = 0;
	if (g_once_init_enter (&ntkresolv_ntk_addr_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NtkresolvNtkAddrClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ntkresolv_ntk_addr_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NtkresolvNtkAddr), 0, (GInstanceInitFunc) ntkresolv_ntk_addr_instance_init, NULL };
		GType ntkresolv_ntk_addr_type_id;
		ntkresolv_ntk_addr_type_id = g_type_register_static (G_TYPE_OBJECT, "NtkresolvNtkAddr", &g_define_type_info, 0);
		g_once_init_leave (&ntkresolv_ntk_addr_type_id__volatile, ntkresolv_ntk_addr_type_id);
	}
	return ntkresolv_ntk_addr_type_id__volatile;
}


NtkresolvNtkInetAddr* ntkresolv_ntk_inet_addr_construct (GType object_type, guint8* addr, int addr_length1, guint16 port) {
	NtkresolvNtkInetAddr * self = NULL;
	guint8* _tmp0_;
	gint _tmp0__length1;
	guint16 _tmp10_;
	self = (NtkresolvNtkInetAddr*) ntkresolv_ntk_addr_construct (object_type);
	_tmp0_ = addr;
	_tmp0__length1 = addr_length1;
	_vala_assert (_tmp0__length1 == 4, "addr.length == 4");
	{
		gint i;
		i = 0;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				gboolean _tmp2_;
				gint _tmp4_;
				gint _tmp5_;
				guint8* _tmp6_;
				gint _tmp6__length1;
				gint _tmp7_;
				guint8 _tmp8_;
				guint8 _tmp9_;
				_tmp2_ = _tmp1_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp4_ = i;
				if (!(_tmp4_ < 4)) {
					break;
				}
				_tmp5_ = i;
				_tmp6_ = addr;
				_tmp6__length1 = addr_length1;
				_tmp7_ = i;
				_tmp8_ = _tmp6_[_tmp7_];
				self->addr[_tmp5_] = _tmp8_;
				_tmp9_ = self->addr[_tmp5_];
			}
		}
	}
	_tmp10_ = port;
	self->port = _tmp10_;
	return self;
}


NtkresolvNtkInetAddr* ntkresolv_ntk_inet_addr_new (guint8* addr, int addr_length1, guint16 port) {
	return ntkresolv_ntk_inet_addr_construct (NTKRESOLV_TYPE_NTK_INET_ADDR, addr, addr_length1, port);
}


NtkresolvNtkInetAddr* ntkresolv_ntk_inet_addr_construct_from_pointer (GType object_type, guint8* addr, guint16 port) {
	NtkresolvNtkInetAddr * self = NULL;
	guint16 _tmp9_;
	self = (NtkresolvNtkInetAddr*) ntkresolv_ntk_addr_construct (object_type);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_;
				gint _tmp3_;
				gint _tmp4_;
				guint8* _tmp5_;
				gint _tmp6_;
				guint8 _tmp7_;
				guint8 _tmp8_;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = i;
				if (!(_tmp3_ < 4)) {
					break;
				}
				_tmp4_ = i;
				_tmp5_ = addr;
				_tmp6_ = i;
				_tmp7_ = _tmp5_[_tmp6_];
				self->addr[_tmp4_] = _tmp7_;
				_tmp8_ = self->addr[_tmp4_];
			}
		}
	}
	_tmp9_ = port;
	self->port = _tmp9_;
	return self;
}


NtkresolvNtkInetAddr* ntkresolv_ntk_inet_addr_new_from_pointer (guint8* addr, guint16 port) {
	return ntkresolv_ntk_inet_addr_construct_from_pointer (NTKRESOLV_TYPE_NTK_INET_ADDR, addr, port);
}


static void ntkresolv_ntk_inet_addr_class_init (NtkresolvNtkInetAddrClass * klass) {
	ntkresolv_ntk_inet_addr_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = ntkresolv_ntk_inet_addr_finalize;
}


static void ntkresolv_ntk_inet_addr_instance_init (NtkresolvNtkInetAddr * self) {
}


static void ntkresolv_ntk_inet_addr_finalize (GObject* obj) {
	NtkresolvNtkInetAddr * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NTKRESOLV_TYPE_NTK_INET_ADDR, NtkresolvNtkInetAddr);
	G_OBJECT_CLASS (ntkresolv_ntk_inet_addr_parent_class)->finalize (obj);
}


GType ntkresolv_ntk_inet_addr_get_type (void) {
	static volatile gsize ntkresolv_ntk_inet_addr_type_id__volatile = 0;
	if (g_once_init_enter (&ntkresolv_ntk_inet_addr_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NtkresolvNtkInetAddrClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ntkresolv_ntk_inet_addr_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NtkresolvNtkInetAddr), 0, (GInstanceInitFunc) ntkresolv_ntk_inet_addr_instance_init, NULL };
		GType ntkresolv_ntk_inet_addr_type_id;
		ntkresolv_ntk_inet_addr_type_id = g_type_register_static (NTKRESOLV_TYPE_NTK_ADDR, "NtkresolvNtkInetAddr", &g_define_type_info, 0);
		g_once_init_leave (&ntkresolv_ntk_inet_addr_type_id__volatile, ntkresolv_ntk_inet_addr_type_id);
	}
	return ntkresolv_ntk_inet_addr_type_id__volatile;
}


GType ntkresolv_ip_family_get_type (void) {
	static volatile gsize ntkresolv_ip_family_type_id__volatile = 0;
	if (g_once_init_enter (&ntkresolv_ip_family_type_id__volatile)) {
		static const GEnumValue values[] = {{NTKRESOLV_IP_FAMILY_IPV4, "NTKRESOLV_IP_FAMILY_IPV4", "ipv4"}, {NTKRESOLV_IP_FAMILY_IPV6, "NTKRESOLV_IP_FAMILY_IPV6", "ipv6"}, {NTKRESOLV_IP_FAMILY_UNSPEC, "NTKRESOLV_IP_FAMILY_UNSPEC", "unspec"}, {0, NULL, NULL}};
		GType ntkresolv_ip_family_type_id;
		ntkresolv_ip_family_type_id = g_enum_register_static ("NtkresolvIpFamily", values);
		g_once_init_leave (&ntkresolv_ip_family_type_id__volatile, ntkresolv_ip_family_type_id);
	}
	return ntkresolv_ip_family_type_id__volatile;
}


GType ntkresolv_ip_protocol_get_type (void) {
	static volatile gsize ntkresolv_ip_protocol_type_id__volatile = 0;
	if (g_once_init_enter (&ntkresolv_ip_protocol_type_id__volatile)) {
		static const GEnumValue values[] = {{NTKRESOLV_IP_PROTOCOL_IP, "NTKRESOLV_IP_PROTOCOL_IP", "ip"}, {NTKRESOLV_IP_PROTOCOL_TCP, "NTKRESOLV_IP_PROTOCOL_TCP", "tcp"}, {NTKRESOLV_IP_PROTOCOL_UDP, "NTKRESOLV_IP_PROTOCOL_UDP", "udp"}, {0, NULL, NULL}};
		GType ntkresolv_ip_protocol_type_id;
		ntkresolv_ip_protocol_type_id = g_enum_register_static ("NtkresolvIpProtocol", values);
		g_once_init_leave (&ntkresolv_ip_protocol_type_id__volatile, ntkresolv_ip_protocol_type_id);
	}
	return ntkresolv_ip_protocol_type_id__volatile;
}


GType ntkresolv_socket_type_get_type (void) {
	static volatile gsize ntkresolv_socket_type_type_id__volatile = 0;
	if (g_once_init_enter (&ntkresolv_socket_type_type_id__volatile)) {
		static const GEnumValue values[] = {{NTKRESOLV_SOCKET_TYPE_DATAGRAM, "NTKRESOLV_SOCKET_TYPE_DATAGRAM", "datagram"}, {NTKRESOLV_SOCKET_TYPE_STREAM, "NTKRESOLV_SOCKET_TYPE_STREAM", "stream"}, {NTKRESOLV_SOCKET_TYPE_UNSPEC, "NTKRESOLV_SOCKET_TYPE_UNSPEC", "unspec"}, {0, NULL, NULL}};
		GType ntkresolv_socket_type_type_id;
		ntkresolv_socket_type_type_id = g_enum_register_static ("NtkresolvSocketType", values);
		g_once_init_leave (&ntkresolv_socket_type_type_id__volatile, ntkresolv_socket_type_type_id);
	}
	return ntkresolv_socket_type_type_id__volatile;
}


NtkresolvNtkAddrInfo* ntkresolv_ntk_addr_info_construct (GType object_type) {
	NtkresolvNtkAddrInfo * self = NULL;
	self = (NtkresolvNtkAddrInfo*) g_object_new (object_type, NULL);
	return self;
}


NtkresolvNtkAddrInfo* ntkresolv_ntk_addr_info_new (void) {
	return ntkresolv_ntk_addr_info_construct (NTKRESOLV_TYPE_NTK_ADDR_INFO);
}


static void ntkresolv_ntk_addr_info_class_init (NtkresolvNtkAddrInfoClass * klass) {
	ntkresolv_ntk_addr_info_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = ntkresolv_ntk_addr_info_finalize;
}


static void ntkresolv_ntk_addr_info_instance_init (NtkresolvNtkAddrInfo * self) {
}


static void ntkresolv_ntk_addr_info_finalize (GObject* obj) {
	NtkresolvNtkAddrInfo * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NTKRESOLV_TYPE_NTK_ADDR_INFO, NtkresolvNtkAddrInfo);
	_g_object_unref0 (self->address);
	G_OBJECT_CLASS (ntkresolv_ntk_addr_info_parent_class)->finalize (obj);
}


GType ntkresolv_ntk_addr_info_get_type (void) {
	static volatile gsize ntkresolv_ntk_addr_info_type_id__volatile = 0;
	if (g_once_init_enter (&ntkresolv_ntk_addr_info_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NtkresolvNtkAddrInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ntkresolv_ntk_addr_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NtkresolvNtkAddrInfo), 0, (GInstanceInitFunc) ntkresolv_ntk_addr_info_instance_init, NULL };
		GType ntkresolv_ntk_addr_info_type_id;
		ntkresolv_ntk_addr_info_type_id = g_type_register_static (G_TYPE_OBJECT, "NtkresolvNtkAddrInfo", &g_define_type_info, 0);
		g_once_init_leave (&ntkresolv_ntk_addr_info_type_id__volatile, ntkresolv_ntk_addr_info_type_id);
	}
	return ntkresolv_ntk_addr_info_type_id__volatile;
}


GQuark ntkresolv_ntkresolv_error_quark (void) {
	return g_quark_from_static_string ("ntkresolv_ntkresolv_error-quark");
}


/** There are 2 ways to use this library. One is for applications that do not
      * use the library 'tasklet' on their own. The other is for those that do.
      *
      * 1.
      * Call directly the method 'resolv' from any thread.
      *
      * 2.
      * After having initialized the Tasklet system, call once the method 'init'.
      * Then call the method 'tasklet_resolv' from any tasklet.
      *
      * If you use this library from another library and you don't know whether
      * the calling application is using the library 'tasklet' on its own, then
      * you should call once the method 'init' and then 'tasklet_resolv'. But in
      * this case you cannot guarantee that the function is going to work in the
      * case that it is called concurrently from several threads.
      */
void ntkresolv_init (gboolean tasklet_initialized) {
	gboolean _tmp0_;
	_tmp0_ = tasklet_initialized;
	if (!_tmp0_) {
		tasklets_tasklet_init (64);
	}
	zcd_serializer_init ();
	andns_rpc_andns_init ();
	netsukuku_rpc_ntk_init ();
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


NtkresolvResolvCall* ntkresolv_resolv_call_construct (GType object_type, const gchar* node, const gchar* service, NtkresolvNtkAddrInfo* _hints, const gchar* tcpaddress) {
	NtkresolvResolvCall * self = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	NtkresolvNtkAddrInfo* _tmp4_;
	NtkresolvNtkAddrInfo* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	g_return_val_if_fail (node != NULL, NULL);
	g_return_val_if_fail (tcpaddress != NULL, NULL);
	self = (NtkresolvResolvCall*) g_object_new (object_type, NULL);
	_tmp0_ = node;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->node);
	self->node = _tmp1_;
	_tmp2_ = service;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (self->service);
	self->service = _tmp3_;
	_tmp4_ = _hints;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (self->_hints);
	self->_hints = _tmp5_;
	_tmp6_ = tcpaddress;
	_tmp7_ = g_strdup (_tmp6_);
	_g_free0 (self->tcpaddress);
	self->tcpaddress = _tmp7_;
	self->completed = FALSE;
	self->started = FALSE;
	return self;
}


NtkresolvResolvCall* ntkresolv_resolv_call_new (const gchar* node, const gchar* service, NtkresolvNtkAddrInfo* _hints, const gchar* tcpaddress) {
	return ntkresolv_resolv_call_construct (NTKRESOLV_TYPE_RESOLV_CALL, node, service, _hints, tcpaddress);
}


static void ntkresolv_resolv_call_class_init (NtkresolvResolvCallClass * klass) {
	ntkresolv_resolv_call_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = ntkresolv_resolv_call_finalize;
}


static void ntkresolv_resolv_call_instance_init (NtkresolvResolvCall * self) {
	self->e = NULL;
}


static void ntkresolv_resolv_call_finalize (GObject* obj) {
	NtkresolvResolvCall * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NTKRESOLV_TYPE_RESOLV_CALL, NtkresolvResolvCall);
	_g_free0 (self->node);
	_g_free0 (self->service);
	_g_object_unref0 (self->_hints);
	_g_free0 (self->tcpaddress);
	_g_object_unref0 (self->retval);
	_g_error_free0 (self->e);
	G_OBJECT_CLASS (ntkresolv_resolv_call_parent_class)->finalize (obj);
}


GType ntkresolv_resolv_call_get_type (void) {
	static volatile gsize ntkresolv_resolv_call_type_id__volatile = 0;
	if (g_once_init_enter (&ntkresolv_resolv_call_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NtkresolvResolvCallClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ntkresolv_resolv_call_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NtkresolvResolvCall), 0, (GInstanceInitFunc) ntkresolv_resolv_call_instance_init, NULL };
		GType ntkresolv_resolv_call_type_id;
		ntkresolv_resolv_call_type_id = g_type_register_static (G_TYPE_OBJECT, "NtkresolvResolvCall", &g_define_type_info, 0);
		g_once_init_leave (&ntkresolv_resolv_call_type_id__volatile, ntkresolv_resolv_call_type_id);
	}
	return ntkresolv_resolv_call_type_id__volatile;
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static void _______lambda2_ (GObject* tpar1, GError** error) {
	GObject* _tmp0_;
	NtkresolvResolvCall* _tmp1_;
	NtkresolvResolvCall* tasklet_req;
	GError * _inner_error_ = NULL;
	_tmp0_ = tpar1;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, NTKRESOLV_TYPE_RESOLV_CALL, NtkresolvResolvCall));
	tasklet_req = _tmp1_;
	{
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		NtkresolvNtkAddrInfo* _tmp4_;
		const gchar* _tmp5_;
		GeeList* _tmp6_ = NULL;
		GeeList* _tmp7_;
		_tmp2_ = tasklet_req->node;
		_tmp3_ = tasklet_req->service;
		_tmp4_ = tasklet_req->_hints;
		_tmp5_ = tasklet_req->tcpaddress;
		_tmp6_ = ntkresolv_tasklet_resolv (_tmp2_, _tmp3_, _tmp4_, _tmp5_, &_inner_error_);
		_tmp7_ = _tmp6_;
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		_g_object_unref0 (tasklet_req->retval);
		tasklet_req->retval = _tmp7_;
		tasklet_req->completed = TRUE;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		GError* _tmp9_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _g_error_copy0 (_tmp8_);
		_g_error_free0 (tasklet_req->e);
		tasklet_req->e = _tmp9_;
		tasklet_req->completed = TRUE;
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (tasklet_req);
		return;
	}
	_g_object_unref0 (tasklet_req);
}


static void ________lambda2__tasklets_tasklet_callback (GObject* obj1, GObject* obj2, GObject* obj3, GObject* obj4, gpointer self, GError** error) {
	_______lambda2_ (obj1, error);
}


GeeList* ntkresolv_resolv (const gchar* node, const gchar* service, NtkresolvNtkAddrInfo* _hints, const gchar* tcpaddress, GError** error) {
	GeeList* result = NULL;
	gboolean _tmp0_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (node != NULL, NULL);
	g_return_val_if_fail (tcpaddress != NULL, NULL);
	_tmp0_ = tasklets_tasklet_init (64);
	if (_tmp0_) {
		GeeArrayList* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		NtkresolvNtkAddrInfo* _tmp4_;
		const gchar* _tmp5_;
		NtkresolvResolvCall* _tmp6_;
		NtkresolvResolvCall* my_req;
		GeeArrayList* _tmp7_;
		NtkresolvResolvCall* _tmp8_;
		NtkresolvResolvCall* _tmp47_;
		GError* _tmp48_;
		NtkresolvResolvCall* _tmp52_;
		GeeList* _tmp53_;
		GeeList* _tmp54_;
		ntkresolv_init (TRUE);
		_tmp1_ = gee_array_list_new (NTKRESOLV_TYPE_RESOLV_CALL, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
		_g_object_unref0 (ntkresolv_lst_dispatched_resolv);
		ntkresolv_lst_dispatched_resolv = _tmp1_;
		_tmp2_ = node;
		_tmp3_ = service;
		_tmp4_ = _hints;
		_tmp5_ = tcpaddress;
		_tmp6_ = ntkresolv_resolv_call_new (_tmp2_, _tmp3_, _tmp4_, _tmp5_);
		my_req = _tmp6_;
		_tmp7_ = ntkresolv_lst_dispatched_resolv;
		_tmp8_ = my_req;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp7_, _tmp8_);
		while (TRUE) {
			GeeArrayList* _tmp9_;
			GeeArrayList* todel;
			GeeArrayList* _tmp44_;
			gboolean _tmp45_;
			gboolean _tmp46_;
			_tmp9_ = gee_array_list_new (NTKRESOLV_TYPE_RESOLV_CALL, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
			todel = _tmp9_;
			{
				GeeArrayList* _tmp10_;
				GeeArrayList* _tmp11_;
				GeeArrayList* _req_list;
				GeeArrayList* _tmp12_;
				gint _tmp13_;
				gint _tmp14_;
				gint _req_size;
				gint _req_index;
				_tmp10_ = ntkresolv_lst_dispatched_resolv;
				_tmp11_ = _g_object_ref0 (_tmp10_);
				_req_list = _tmp11_;
				_tmp12_ = _req_list;
				_tmp13_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp12_);
				_tmp14_ = _tmp13_;
				_req_size = _tmp14_;
				_req_index = -1;
				while (TRUE) {
					gint _tmp15_;
					gint _tmp16_;
					gint _tmp17_;
					GeeArrayList* _tmp18_;
					gint _tmp19_;
					gpointer _tmp20_ = NULL;
					NtkresolvResolvCall* req;
					NtkresolvResolvCall* _tmp21_;
					gboolean _tmp22_;
					NtkresolvResolvCall* _tmp25_;
					gboolean _tmp26_;
					_tmp15_ = _req_index;
					_req_index = _tmp15_ + 1;
					_tmp16_ = _req_index;
					_tmp17_ = _req_size;
					if (!(_tmp16_ < _tmp17_)) {
						break;
					}
					_tmp18_ = _req_list;
					_tmp19_ = _req_index;
					_tmp20_ = gee_abstract_list_get ((GeeAbstractList*) _tmp18_, _tmp19_);
					req = (NtkresolvResolvCall*) _tmp20_;
					_tmp21_ = req;
					_tmp22_ = _tmp21_->completed;
					if (_tmp22_) {
						GeeArrayList* _tmp23_;
						NtkresolvResolvCall* _tmp24_;
						_tmp23_ = todel;
						_tmp24_ = req;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp23_, _tmp24_);
					}
					_tmp25_ = req;
					_tmp26_ = _tmp25_->started;
					if (!_tmp26_) {
						NtkresolvResolvCall* _tmp27_;
						TaskletsTasklet* _tmp28_ = NULL;
						TaskletsTasklet* _tmp29_;
						NtkresolvResolvCall* _tmp30_;
						_tmp27_ = req;
						_tmp28_ = tasklets_tasklet_tasklet_callback (________lambda2__tasklets_tasklet_callback, NULL, (GObject*) _tmp27_, NULL, NULL, NULL);
						_tmp29_ = _tmp28_;
						_g_object_unref0 (_tmp29_);
						_tmp30_ = req;
						_tmp30_->started = TRUE;
					}
					_g_object_unref0 (req);
				}
				_g_object_unref0 (_req_list);
			}
			{
				GeeArrayList* _tmp31_;
				GeeArrayList* _tmp32_;
				GeeArrayList* _req_list;
				GeeArrayList* _tmp33_;
				gint _tmp34_;
				gint _tmp35_;
				gint _req_size;
				gint _req_index;
				_tmp31_ = todel;
				_tmp32_ = _g_object_ref0 (_tmp31_);
				_req_list = _tmp32_;
				_tmp33_ = _req_list;
				_tmp34_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp33_);
				_tmp35_ = _tmp34_;
				_req_size = _tmp35_;
				_req_index = -1;
				while (TRUE) {
					gint _tmp36_;
					gint _tmp37_;
					gint _tmp38_;
					GeeArrayList* _tmp39_;
					gint _tmp40_;
					gpointer _tmp41_ = NULL;
					NtkresolvResolvCall* req;
					GeeArrayList* _tmp42_;
					NtkresolvResolvCall* _tmp43_;
					_tmp36_ = _req_index;
					_req_index = _tmp36_ + 1;
					_tmp37_ = _req_index;
					_tmp38_ = _req_size;
					if (!(_tmp37_ < _tmp38_)) {
						break;
					}
					_tmp39_ = _req_list;
					_tmp40_ = _req_index;
					_tmp41_ = gee_abstract_list_get ((GeeAbstractList*) _tmp39_, _tmp40_);
					req = (NtkresolvResolvCall*) _tmp41_;
					_tmp42_ = ntkresolv_lst_dispatched_resolv;
					_tmp43_ = req;
					gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp42_, _tmp43_);
					_g_object_unref0 (req);
				}
				_g_object_unref0 (_req_list);
			}
			_tmp44_ = ntkresolv_lst_dispatched_resolv;
			_tmp45_ = gee_collection_get_is_empty ((GeeCollection*) _tmp44_);
			_tmp46_ = _tmp45_;
			if (_tmp46_) {
				_g_object_unref0 (todel);
				break;
			}
			tasklets_tasklet_nap ((glong) 0, (glong) 1000);
			_g_object_unref0 (todel);
		}
		tasklets_tasklet_kill ();
		_tmp47_ = my_req;
		_tmp48_ = _tmp47_->e;
		if (_tmp48_ != NULL) {
			NtkresolvResolvCall* _tmp49_;
			GError* _tmp50_;
			GError* _tmp51_;
			_tmp49_ = my_req;
			_tmp50_ = _tmp49_->e;
			_tmp51_ = _g_error_copy0 (_tmp50_);
			_inner_error_ = _tmp51_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (my_req);
			return NULL;
		}
		_tmp52_ = my_req;
		_tmp53_ = _tmp52_->retval;
		_tmp54_ = _g_object_ref0 (_tmp53_);
		result = _tmp54_;
		_g_object_unref0 (my_req);
		return result;
	} else {
		const gchar* _tmp55_;
		const gchar* _tmp56_;
		NtkresolvNtkAddrInfo* _tmp57_;
		const gchar* _tmp58_;
		NtkresolvResolvCall* _tmp59_;
		NtkresolvResolvCall* my_req;
		GeeArrayList* _tmp60_;
		NtkresolvResolvCall* _tmp61_;
		NtkresolvResolvCall* _tmp64_;
		GError* _tmp65_;
		NtkresolvResolvCall* _tmp69_;
		GeeList* _tmp70_;
		GeeList* _tmp71_;
		_tmp55_ = node;
		_tmp56_ = service;
		_tmp57_ = _hints;
		_tmp58_ = tcpaddress;
		_tmp59_ = ntkresolv_resolv_call_new (_tmp55_, _tmp56_, _tmp57_, _tmp58_);
		my_req = _tmp59_;
		_tmp60_ = ntkresolv_lst_dispatched_resolv;
		_tmp61_ = my_req;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp60_, _tmp61_);
		while (TRUE) {
			NtkresolvResolvCall* _tmp62_;
			gboolean _tmp63_;
			_tmp62_ = my_req;
			_tmp63_ = _tmp62_->completed;
			if (!(!_tmp63_)) {
				break;
			}
			usleep ((guint) 10000);
		}
		_tmp64_ = my_req;
		_tmp65_ = _tmp64_->e;
		if (_tmp65_ != NULL) {
			NtkresolvResolvCall* _tmp66_;
			GError* _tmp67_;
			GError* _tmp68_;
			_tmp66_ = my_req;
			_tmp67_ = _tmp66_->e;
			_tmp68_ = _g_error_copy0 (_tmp67_);
			_inner_error_ = _tmp68_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (my_req);
			return NULL;
		}
		_tmp69_ = my_req;
		_tmp70_ = _tmp69_->retval;
		_tmp71_ = _g_object_ref0 (_tmp70_);
		result = _tmp71_;
		_g_object_unref0 (my_req);
		return result;
	}
}


GeeList* ntkresolv_tasklet_resolv (const gchar* node, const gchar* service, NtkresolvNtkAddrInfo* _hints, const gchar* tcpaddress, GError** error) {
	GeeList* result = NULL;
	NtkresolvNtkAddrInfo* hints = NULL;
	NtkresolvNtkAddrInfo* _tmp0_;
	NetsukukuAndnaServiceKey* _tmp7_;
	NetsukukuAndnaServiceKey* _tmp8_;
	NetsukukuAndnaServiceKey* _tmp9_;
	NetsukukuAndnaServiceKey* serv_key;
	gboolean _tmp10_ = FALSE;
	const gchar* _tmp11_;
	gboolean _tmp14_;
	const gchar* _tmp23_;
	guint16 _tmp24_;
	AndnsAndnaResolveTCPClient* _tmp25_;
	AndnsAndnaResolveTCPClient* client;
	AndnsAndnaResolveTCPClient* _tmp26_;
	const gchar* _tmp27_;
	gchar* _tmp28_ = NULL;
	gchar* _tmp29_;
	NetsukukuAndnaServiceKey* _tmp30_;
	AndnsAndnaQuery* _tmp31_;
	AndnsAndnaQuery* _tmp32_;
	AndnsAndnaQuery* query;
	gint32 _tmp33_ = 0;
	gint id;
	GeeArrayList* _tmp34_;
	GeeArrayList* ret;
	AndnsAndnaResolveTCPClient* _tmp35_;
	gint _tmp36_;
	AndnsIAndnaQueryHandler* _tmp37_ = NULL;
	AndnsIAndnaQueryHandler* _tmp38_;
	AndnsAndnaQuery* _tmp39_;
	AndnsAndnaResponse* _tmp40_ = NULL;
	AndnsAndnaResponse* _tmp41_;
	AndnsAndnaResponse* resp;
	AndnsAndnaResponse* _tmp42_;
	AndnsAndnaResponseCode _tmp43_;
	AndnsAndnaResponseCode _tmp44_;
	AndnsAndnaResponse* _tmp45_;
	AndnsAndnaResponseCode _tmp46_;
	AndnsAndnaResponseCode _tmp47_;
	AndnsAndnaResponse* _tmp53_;
	GeeArrayList* _tmp54_;
	GeeArrayList* _tmp55_;
	gint _tmp56_;
	gint _tmp57_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (node != NULL, NULL);
	g_return_val_if_fail (tcpaddress != NULL, NULL);
	_tmp0_ = _hints;
	if (_tmp0_ == NULL) {
		NtkresolvNtkAddrInfo* _tmp1_;
		NtkresolvNtkAddrInfo* _tmp2_;
		NtkresolvNtkAddrInfo* _tmp3_;
		NtkresolvNtkAddrInfo* _tmp4_;
		_tmp1_ = ntkresolv_ntk_addr_info_new ();
		_g_object_unref0 (hints);
		hints = _tmp1_;
		_tmp2_ = hints;
		_tmp2_->family = NTKRESOLV_IP_FAMILY_IPV4;
		_tmp3_ = hints;
		_tmp3_->protocol = NTKRESOLV_IP_PROTOCOL_IP;
		_tmp4_ = hints;
		_tmp4_->socket_type = NTKRESOLV_SOCKET_TYPE_UNSPEC;
	} else {
		NtkresolvNtkAddrInfo* _tmp5_;
		NtkresolvNtkAddrInfo* _tmp6_;
		_tmp5_ = _hints;
		_tmp6_ = _g_object_ref0 (_tmp5_);
		_g_object_unref0 (hints);
		hints = _tmp6_;
	}
	_tmp7_ = netsukuku_andna_service_key_get_NULL_SERV_KEY ();
	_tmp8_ = _tmp7_;
	_tmp9_ = _g_object_ref0 (_tmp8_);
	serv_key = _tmp9_;
	_tmp11_ = service;
	if (_tmp11_ != NULL) {
		NtkresolvNtkAddrInfo* _tmp12_;
		NtkresolvIpProtocol _tmp13_;
		_tmp12_ = hints;
		_tmp13_ = _tmp12_->protocol;
		_tmp10_ = _tmp13_ != NTKRESOLV_IP_PROTOCOL_IP;
	} else {
		_tmp10_ = FALSE;
	}
	_tmp14_ = _tmp10_;
	if (_tmp14_) {
		const gchar* _tmp15_ = NULL;
		NtkresolvNtkAddrInfo* _tmp16_;
		NtkresolvIpProtocol _tmp17_;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* proto;
		const gchar* _tmp20_;
		const gchar* _tmp21_;
		NetsukukuAndnaServiceKey* _tmp22_;
		_tmp16_ = hints;
		_tmp17_ = _tmp16_->protocol;
		if (_tmp17_ == NTKRESOLV_IP_PROTOCOL_TCP) {
			_tmp15_ = "tcp";
		} else {
			_tmp15_ = "udp";
		}
		_tmp18_ = _tmp15_;
		_tmp19_ = g_strdup (_tmp18_);
		proto = _tmp19_;
		_tmp20_ = service;
		_tmp21_ = proto;
		_tmp22_ = netsukuku_andna_service_key_new (_tmp20_, _tmp21_);
		_g_object_unref0 (serv_key);
		serv_key = _tmp22_;
		_g_free0 (proto);
	}
	_tmp23_ = tcpaddress;
	_tmp24_ = (guint16) 53000;
	_tmp25_ = andns_andna_resolve_tcp_client_new (_tmp23_, &_tmp24_, NULL, TRUE);
	client = _tmp25_;
	_tmp26_ = client;
	andns_andna_resolve_tcp_client_set_retry_connect (_tmp26_, FALSE);
	_tmp27_ = node;
	_tmp28_ = netsukuku_inet_utils_crypto_hash (_tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = serv_key;
	_tmp31_ = andns_andna_query_new_name_to_ip_ntk (FALSE, FALSE, ANDNS_ANDNA_QUERY_PROTOCOL_TCP, ANDNS_ANDNA_QUERY_IP_VERSION_IPV4, _tmp29_, _tmp30_);
	_tmp32_ = _tmp31_;
	_g_free0 (_tmp29_);
	query = _tmp32_;
	_tmp33_ = g_random_int_range ((gint32) 0, (gint32) 32767);
	id = (gint) _tmp33_;
	_tmp34_ = gee_array_list_new (NTKRESOLV_TYPE_NTK_ADDR_INFO, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	ret = _tmp34_;
	_tmp35_ = client;
	_tmp36_ = id;
	_tmp37_ = andns_iandna_resolve_root_dispatcher_get_query_handler ((AndnsIAndnaResolveRootDispatcher*) _tmp35_, _tmp36_);
	_tmp38_ = _tmp37_;
	_tmp39_ = query;
	_tmp40_ = andns_iandna_query_handler_resolve (_tmp38_, _tmp39_, &_inner_error_);
	_tmp41_ = _tmp40_;
	_g_object_unref0 (_tmp38_);
	resp = _tmp41_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (ret);
		_g_object_unref0 (query);
		_g_object_unref0 (client);
		_g_object_unref0 (serv_key);
		_g_object_unref0 (hints);
		return NULL;
	}
	_tmp42_ = resp;
	_tmp43_ = andns_andna_response_get_rcode (_tmp42_);
	_tmp44_ = _tmp43_;
	if (_tmp44_ == ANDNS_ANDNA_RESPONSE_CODE_NO_DOMAIN) {
		result = (GeeList*) ret;
		_g_object_unref0 (resp);
		_g_object_unref0 (query);
		_g_object_unref0 (client);
		_g_object_unref0 (serv_key);
		_g_object_unref0 (hints);
		return result;
	}
	_tmp45_ = resp;
	_tmp46_ = andns_andna_response_get_rcode (_tmp45_);
	_tmp47_ = _tmp46_;
	if (_tmp47_ != ANDNS_ANDNA_RESPONSE_CODE_NO_ERROR) {
		AndnsAndnaResponse* _tmp48_;
		AndnsAndnaResponseCode _tmp49_;
		AndnsAndnaResponseCode _tmp50_;
		GEnumValue* _tmp51_;
		GError* _tmp52_;
		_tmp48_ = resp;
		_tmp49_ = andns_andna_response_get_rcode (_tmp48_);
		_tmp50_ = _tmp49_;
		_tmp51_ = g_enum_get_value (g_type_class_ref (ANDNS_TYPE_ANDNA_RESPONSE_CODE), _tmp50_);
		_tmp52_ = g_error_new_literal (NTKRESOLV_NTKRESOLV_ERROR, NTKRESOLV_NTKRESOLV_ERROR_GENERIC, (_tmp51_ != NULL) ? _tmp51_->value_name : NULL);
		_inner_error_ = _tmp52_;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (resp);
		_g_object_unref0 (ret);
		_g_object_unref0 (query);
		_g_object_unref0 (client);
		_g_object_unref0 (serv_key);
		_g_object_unref0 (hints);
		return NULL;
	}
	_tmp53_ = resp;
	_tmp54_ = andns_andna_response_get_answers (_tmp53_);
	_tmp55_ = _tmp54_;
	_tmp56_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp55_);
	_tmp57_ = _tmp56_;
	if (_tmp57_ == 0) {
		GError* _tmp58_;
		_tmp58_ = g_error_new_literal (NTKRESOLV_NTKRESOLV_ERROR, NTKRESOLV_NTKRESOLV_ERROR_GENERIC, "Response Code is NoError but list is empty.");
		_inner_error_ = _tmp58_;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (resp);
		_g_object_unref0 (ret);
		_g_object_unref0 (query);
		_g_object_unref0 (client);
		_g_object_unref0 (serv_key);
		_g_object_unref0 (hints);
		return NULL;
	}
	{
		AndnsAndnaResponse* _tmp59_;
		GeeArrayList* _tmp60_;
		GeeArrayList* _tmp61_;
		GeeArrayList* _tmp62_;
		GeeArrayList* _a_list;
		GeeArrayList* _tmp63_;
		gint _tmp64_;
		gint _tmp65_;
		gint _a_size;
		gint _a_index;
		_tmp59_ = resp;
		_tmp60_ = andns_andna_response_get_answers (_tmp59_);
		_tmp61_ = _tmp60_;
		_tmp62_ = _g_object_ref0 (_tmp61_);
		_a_list = _tmp62_;
		_tmp63_ = _a_list;
		_tmp64_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp63_);
		_tmp65_ = _tmp64_;
		_a_size = _tmp65_;
		_a_index = -1;
		while (TRUE) {
			gint _tmp66_;
			gint _tmp67_;
			gint _tmp68_;
			GeeArrayList* _tmp69_;
			gint _tmp70_;
			gpointer _tmp71_ = NULL;
			AndnsAndnaResponseAnswer* a;
			NtkresolvNtkAddrInfo* _tmp72_;
			NtkresolvNtkAddrInfo* ainfo;
			NtkresolvNtkAddrInfo* _tmp73_;
			NtkresolvNtkAddrInfo* _tmp74_;
			NtkresolvNtkAddrInfo* _tmp75_;
			NtkresolvIpProtocol _tmp76_;
			NtkresolvNtkAddrInfo* _tmp77_;
			NtkresolvNtkAddrInfo* _tmp78_;
			NtkresolvSocketType _tmp79_;
			NtkresolvNtkAddrInfo* _tmp80_;
			AndnsAndnaResponseAnswer* _tmp81_;
			AndnsAndnaResponseAnswer* _tmp82_;
			guint16 _tmp83_;
			guint16 _tmp84_;
			NtkresolvNtkInetAddr* _tmp85_;
			GeeArrayList* _tmp86_;
			NtkresolvNtkAddrInfo* _tmp87_;
			_tmp66_ = _a_index;
			_a_index = _tmp66_ + 1;
			_tmp67_ = _a_index;
			_tmp68_ = _a_size;
			if (!(_tmp67_ < _tmp68_)) {
				break;
			}
			_tmp69_ = _a_list;
			_tmp70_ = _a_index;
			_tmp71_ = gee_abstract_list_get ((GeeAbstractList*) _tmp69_, _tmp70_);
			a = (AndnsAndnaResponseAnswer*) _tmp71_;
			_tmp72_ = ntkresolv_ntk_addr_info_new ();
			ainfo = _tmp72_;
			_tmp73_ = ainfo;
			_tmp73_->family = NTKRESOLV_IP_FAMILY_IPV4;
			_tmp74_ = ainfo;
			_tmp75_ = hints;
			_tmp76_ = _tmp75_->protocol;
			_tmp74_->protocol = _tmp76_;
			_tmp77_ = ainfo;
			_tmp78_ = hints;
			_tmp79_ = _tmp78_->socket_type;
			_tmp77_->socket_type = _tmp79_;
			_tmp80_ = ainfo;
			_tmp81_ = a;
			_tmp82_ = a;
			_tmp83_ = andns_andna_response_answer_get_port_number (_tmp82_);
			_tmp84_ = _tmp83_;
			_tmp85_ = ntkresolv_ntk_inet_addr_new (_tmp81_->ipv4_ip, 4, _tmp84_);
			_g_object_unref0 (_tmp80_->address);
			_tmp80_->address = (NtkresolvNtkAddr*) _tmp85_;
			_tmp86_ = ret;
			_tmp87_ = ainfo;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp86_, _tmp87_);
			_g_object_unref0 (ainfo);
			_g_object_unref0 (a);
		}
		_g_object_unref0 (_a_list);
	}
	result = (GeeList*) ret;
	_g_object_unref0 (resp);
	_g_object_unref0 (query);
	_g_object_unref0 (client);
	_g_object_unref0 (serv_key);
	_g_object_unref0 (hints);
	return result;
}


NtkresolvInverseCall* ntkresolv_inverse_call_construct (GType object_type, NtkresolvIpFamily family, NtkresolvNtkAddr* addr, const gchar* tcpaddress) {
	NtkresolvInverseCall * self = NULL;
	NtkresolvIpFamily _tmp0_;
	NtkresolvNtkAddr* _tmp1_;
	NtkresolvNtkAddr* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_val_if_fail (addr != NULL, NULL);
	g_return_val_if_fail (tcpaddress != NULL, NULL);
	self = (NtkresolvInverseCall*) g_object_new (object_type, NULL);
	_tmp0_ = family;
	self->family = _tmp0_;
	_tmp1_ = addr;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->addr);
	self->addr = _tmp2_;
	_tmp3_ = tcpaddress;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (self->tcpaddress);
	self->tcpaddress = _tmp4_;
	self->completed = FALSE;
	self->started = FALSE;
	return self;
}


NtkresolvInverseCall* ntkresolv_inverse_call_new (NtkresolvIpFamily family, NtkresolvNtkAddr* addr, const gchar* tcpaddress) {
	return ntkresolv_inverse_call_construct (NTKRESOLV_TYPE_INVERSE_CALL, family, addr, tcpaddress);
}


static void ntkresolv_inverse_call_class_init (NtkresolvInverseCallClass * klass) {
	ntkresolv_inverse_call_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = ntkresolv_inverse_call_finalize;
}


static void ntkresolv_inverse_call_instance_init (NtkresolvInverseCall * self) {
	self->e = NULL;
}


static void ntkresolv_inverse_call_finalize (GObject* obj) {
	NtkresolvInverseCall * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NTKRESOLV_TYPE_INVERSE_CALL, NtkresolvInverseCall);
	_g_object_unref0 (self->addr);
	_g_free0 (self->tcpaddress);
	_g_object_unref0 (self->retval);
	_g_error_free0 (self->e);
	G_OBJECT_CLASS (ntkresolv_inverse_call_parent_class)->finalize (obj);
}


GType ntkresolv_inverse_call_get_type (void) {
	static volatile gsize ntkresolv_inverse_call_type_id__volatile = 0;
	if (g_once_init_enter (&ntkresolv_inverse_call_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NtkresolvInverseCallClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ntkresolv_inverse_call_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NtkresolvInverseCall), 0, (GInstanceInitFunc) ntkresolv_inverse_call_instance_init, NULL };
		GType ntkresolv_inverse_call_type_id;
		ntkresolv_inverse_call_type_id = g_type_register_static (G_TYPE_OBJECT, "NtkresolvInverseCall", &g_define_type_info, 0);
		g_once_init_leave (&ntkresolv_inverse_call_type_id__volatile, ntkresolv_inverse_call_type_id);
	}
	return ntkresolv_inverse_call_type_id__volatile;
}


static void _______lambda3_ (GObject* tpar1, GError** error) {
	GObject* _tmp0_;
	NtkresolvInverseCall* _tmp1_;
	NtkresolvInverseCall* tasklet_req;
	GError * _inner_error_ = NULL;
	_tmp0_ = tpar1;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, NTKRESOLV_TYPE_INVERSE_CALL, NtkresolvInverseCall));
	tasklet_req = _tmp1_;
	{
		NtkresolvIpFamily _tmp2_;
		NtkresolvNtkAddr* _tmp3_;
		const gchar* _tmp4_;
		GeeList* _tmp5_ = NULL;
		GeeList* _tmp6_;
		_tmp2_ = tasklet_req->family;
		_tmp3_ = tasklet_req->addr;
		_tmp4_ = tasklet_req->tcpaddress;
		_tmp5_ = ntkresolv_tasklet_inverse (_tmp2_, _tmp3_, _tmp4_, &_inner_error_);
		_tmp6_ = _tmp5_;
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
		_g_object_unref0 (tasklet_req->retval);
		tasklet_req->retval = _tmp6_;
		tasklet_req->completed = TRUE;
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		GError* _tmp8_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _g_error_copy0 (_tmp7_);
		_g_error_free0 (tasklet_req->e);
		tasklet_req->e = _tmp8_;
		tasklet_req->completed = TRUE;
		_g_error_free0 (e);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (tasklet_req);
		return;
	}
	_g_object_unref0 (tasklet_req);
}


static void ________lambda3__tasklets_tasklet_callback (GObject* obj1, GObject* obj2, GObject* obj3, GObject* obj4, gpointer self, GError** error) {
	_______lambda3_ (obj1, error);
}


GeeList* ntkresolv_inverse (NtkresolvIpFamily family, NtkresolvNtkAddr* addr, const gchar* tcpaddress, GError** error) {
	GeeList* result = NULL;
	gboolean _tmp0_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (addr != NULL, NULL);
	g_return_val_if_fail (tcpaddress != NULL, NULL);
	_tmp0_ = tasklets_tasklet_init (64);
	if (_tmp0_) {
		GeeArrayList* _tmp1_;
		NtkresolvIpFamily _tmp2_;
		NtkresolvNtkAddr* _tmp3_;
		const gchar* _tmp4_;
		NtkresolvInverseCall* _tmp5_;
		NtkresolvInverseCall* my_req;
		GeeArrayList* _tmp6_;
		NtkresolvInverseCall* _tmp7_;
		NtkresolvInverseCall* _tmp46_;
		GError* _tmp47_;
		NtkresolvInverseCall* _tmp51_;
		GeeList* _tmp52_;
		GeeList* _tmp53_;
		ntkresolv_init (TRUE);
		_tmp1_ = gee_array_list_new (NTKRESOLV_TYPE_INVERSE_CALL, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
		_g_object_unref0 (ntkresolv_lst_dispatched_inverse);
		ntkresolv_lst_dispatched_inverse = _tmp1_;
		_tmp2_ = family;
		_tmp3_ = addr;
		_tmp4_ = tcpaddress;
		_tmp5_ = ntkresolv_inverse_call_new (_tmp2_, _tmp3_, _tmp4_);
		my_req = _tmp5_;
		_tmp6_ = ntkresolv_lst_dispatched_inverse;
		_tmp7_ = my_req;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp6_, _tmp7_);
		while (TRUE) {
			GeeArrayList* _tmp8_;
			GeeArrayList* todel;
			GeeArrayList* _tmp43_;
			gboolean _tmp44_;
			gboolean _tmp45_;
			_tmp8_ = gee_array_list_new (NTKRESOLV_TYPE_INVERSE_CALL, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
			todel = _tmp8_;
			{
				GeeArrayList* _tmp9_;
				GeeArrayList* _tmp10_;
				GeeArrayList* _req_list;
				GeeArrayList* _tmp11_;
				gint _tmp12_;
				gint _tmp13_;
				gint _req_size;
				gint _req_index;
				_tmp9_ = ntkresolv_lst_dispatched_inverse;
				_tmp10_ = _g_object_ref0 (_tmp9_);
				_req_list = _tmp10_;
				_tmp11_ = _req_list;
				_tmp12_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp11_);
				_tmp13_ = _tmp12_;
				_req_size = _tmp13_;
				_req_index = -1;
				while (TRUE) {
					gint _tmp14_;
					gint _tmp15_;
					gint _tmp16_;
					GeeArrayList* _tmp17_;
					gint _tmp18_;
					gpointer _tmp19_ = NULL;
					NtkresolvInverseCall* req;
					NtkresolvInverseCall* _tmp20_;
					gboolean _tmp21_;
					NtkresolvInverseCall* _tmp24_;
					gboolean _tmp25_;
					_tmp14_ = _req_index;
					_req_index = _tmp14_ + 1;
					_tmp15_ = _req_index;
					_tmp16_ = _req_size;
					if (!(_tmp15_ < _tmp16_)) {
						break;
					}
					_tmp17_ = _req_list;
					_tmp18_ = _req_index;
					_tmp19_ = gee_abstract_list_get ((GeeAbstractList*) _tmp17_, _tmp18_);
					req = (NtkresolvInverseCall*) _tmp19_;
					_tmp20_ = req;
					_tmp21_ = _tmp20_->completed;
					if (_tmp21_) {
						GeeArrayList* _tmp22_;
						NtkresolvInverseCall* _tmp23_;
						_tmp22_ = todel;
						_tmp23_ = req;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp22_, _tmp23_);
					}
					_tmp24_ = req;
					_tmp25_ = _tmp24_->started;
					if (!_tmp25_) {
						NtkresolvInverseCall* _tmp26_;
						TaskletsTasklet* _tmp27_ = NULL;
						TaskletsTasklet* _tmp28_;
						NtkresolvInverseCall* _tmp29_;
						_tmp26_ = req;
						_tmp27_ = tasklets_tasklet_tasklet_callback (________lambda3__tasklets_tasklet_callback, NULL, (GObject*) _tmp26_, NULL, NULL, NULL);
						_tmp28_ = _tmp27_;
						_g_object_unref0 (_tmp28_);
						_tmp29_ = req;
						_tmp29_->started = TRUE;
					}
					_g_object_unref0 (req);
				}
				_g_object_unref0 (_req_list);
			}
			{
				GeeArrayList* _tmp30_;
				GeeArrayList* _tmp31_;
				GeeArrayList* _req_list;
				GeeArrayList* _tmp32_;
				gint _tmp33_;
				gint _tmp34_;
				gint _req_size;
				gint _req_index;
				_tmp30_ = todel;
				_tmp31_ = _g_object_ref0 (_tmp30_);
				_req_list = _tmp31_;
				_tmp32_ = _req_list;
				_tmp33_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp32_);
				_tmp34_ = _tmp33_;
				_req_size = _tmp34_;
				_req_index = -1;
				while (TRUE) {
					gint _tmp35_;
					gint _tmp36_;
					gint _tmp37_;
					GeeArrayList* _tmp38_;
					gint _tmp39_;
					gpointer _tmp40_ = NULL;
					NtkresolvInverseCall* req;
					GeeArrayList* _tmp41_;
					NtkresolvInverseCall* _tmp42_;
					_tmp35_ = _req_index;
					_req_index = _tmp35_ + 1;
					_tmp36_ = _req_index;
					_tmp37_ = _req_size;
					if (!(_tmp36_ < _tmp37_)) {
						break;
					}
					_tmp38_ = _req_list;
					_tmp39_ = _req_index;
					_tmp40_ = gee_abstract_list_get ((GeeAbstractList*) _tmp38_, _tmp39_);
					req = (NtkresolvInverseCall*) _tmp40_;
					_tmp41_ = ntkresolv_lst_dispatched_inverse;
					_tmp42_ = req;
					gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp41_, _tmp42_);
					_g_object_unref0 (req);
				}
				_g_object_unref0 (_req_list);
			}
			_tmp43_ = ntkresolv_lst_dispatched_inverse;
			_tmp44_ = gee_collection_get_is_empty ((GeeCollection*) _tmp43_);
			_tmp45_ = _tmp44_;
			if (_tmp45_) {
				_g_object_unref0 (todel);
				break;
			}
			tasklets_tasklet_nap ((glong) 0, (glong) 1000);
			_g_object_unref0 (todel);
		}
		tasklets_tasklet_kill ();
		_tmp46_ = my_req;
		_tmp47_ = _tmp46_->e;
		if (_tmp47_ != NULL) {
			NtkresolvInverseCall* _tmp48_;
			GError* _tmp49_;
			GError* _tmp50_;
			_tmp48_ = my_req;
			_tmp49_ = _tmp48_->e;
			_tmp50_ = _g_error_copy0 (_tmp49_);
			_inner_error_ = _tmp50_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (my_req);
			return NULL;
		}
		_tmp51_ = my_req;
		_tmp52_ = _tmp51_->retval;
		_tmp53_ = _g_object_ref0 (_tmp52_);
		result = _tmp53_;
		_g_object_unref0 (my_req);
		return result;
	} else {
		NtkresolvIpFamily _tmp54_;
		NtkresolvNtkAddr* _tmp55_;
		const gchar* _tmp56_;
		NtkresolvInverseCall* _tmp57_;
		NtkresolvInverseCall* my_req;
		GeeArrayList* _tmp58_;
		NtkresolvInverseCall* _tmp59_;
		NtkresolvInverseCall* _tmp62_;
		GError* _tmp63_;
		NtkresolvInverseCall* _tmp67_;
		GeeList* _tmp68_;
		GeeList* _tmp69_;
		_tmp54_ = family;
		_tmp55_ = addr;
		_tmp56_ = tcpaddress;
		_tmp57_ = ntkresolv_inverse_call_new (_tmp54_, _tmp55_, _tmp56_);
		my_req = _tmp57_;
		_tmp58_ = ntkresolv_lst_dispatched_inverse;
		_tmp59_ = my_req;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp58_, _tmp59_);
		while (TRUE) {
			NtkresolvInverseCall* _tmp60_;
			gboolean _tmp61_;
			_tmp60_ = my_req;
			_tmp61_ = _tmp60_->completed;
			if (!(!_tmp61_)) {
				break;
			}
			usleep ((guint) 10000);
		}
		_tmp62_ = my_req;
		_tmp63_ = _tmp62_->e;
		if (_tmp63_ != NULL) {
			NtkresolvInverseCall* _tmp64_;
			GError* _tmp65_;
			GError* _tmp66_;
			_tmp64_ = my_req;
			_tmp65_ = _tmp64_->e;
			_tmp66_ = _g_error_copy0 (_tmp65_);
			_inner_error_ = _tmp66_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (my_req);
			return NULL;
		}
		_tmp67_ = my_req;
		_tmp68_ = _tmp67_->retval;
		_tmp69_ = _g_object_ref0 (_tmp68_);
		result = _tmp69_;
		_g_object_unref0 (my_req);
		return result;
	}
}


GeeList* ntkresolv_tasklet_inverse (NtkresolvIpFamily family, NtkresolvNtkAddr* addr, const gchar* tcpaddress, GError** error) {
	GeeList* result = NULL;
	AndnsAndnaQueryIPVersion ipversion;
	guint8* addr_bytes;
	gint addr_bytes_length1;
	gint _addr_bytes_size_;
	NtkresolvIpFamily _tmp0_;
	const gchar* _tmp2_;
	guint16 _tmp3_;
	AndnsAndnaResolveTCPClient* _tmp4_;
	AndnsAndnaResolveTCPClient* client;
	AndnsAndnaResolveTCPClient* _tmp5_;
	AndnsAndnaQueryIPVersion _tmp6_;
	guint8* _tmp7_;
	gint _tmp7__length1;
	AndnsAndnaQuery* _tmp8_;
	AndnsAndnaQuery* query;
	gint32 _tmp9_ = 0;
	gint id;
	GeeArrayList* _tmp10_;
	GeeArrayList* ret;
	AndnsAndnaResolveTCPClient* _tmp11_;
	gint _tmp12_;
	AndnsIAndnaQueryHandler* _tmp13_ = NULL;
	AndnsIAndnaQueryHandler* _tmp14_;
	AndnsAndnaQuery* _tmp15_;
	AndnsAndnaResponse* _tmp16_ = NULL;
	AndnsAndnaResponse* _tmp17_;
	AndnsAndnaResponse* resp;
	AndnsAndnaResponse* _tmp18_;
	AndnsAndnaResponseCode _tmp19_;
	AndnsAndnaResponseCode _tmp20_;
	AndnsAndnaResponse* _tmp21_;
	AndnsAndnaResponseCode _tmp22_;
	AndnsAndnaResponseCode _tmp23_;
	AndnsAndnaResponse* _tmp29_;
	GeeArrayList* _tmp30_;
	GeeArrayList* _tmp31_;
	gint _tmp32_;
	gint _tmp33_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (addr != NULL, NULL);
	g_return_val_if_fail (tcpaddress != NULL, NULL);
	ipversion = ANDNS_ANDNA_QUERY_IP_VERSION_IPV4;
	addr_bytes = NULL;
	addr_bytes_length1 = 0;
	_addr_bytes_size_ = addr_bytes_length1;
	_tmp0_ = family;
	if (_tmp0_ == NTKRESOLV_IP_FAMILY_IPV6) {
	} else {
		NtkresolvNtkAddr* _tmp1_;
		_tmp1_ = addr;
		addr_bytes = (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, NTKRESOLV_TYPE_NTK_INET_ADDR) ? ((NtkresolvNtkInetAddr*) _tmp1_) : NULL)->addr;
		addr_bytes_length1 = 4;
		_addr_bytes_size_ = addr_bytes_length1;
	}
	_tmp2_ = tcpaddress;
	_tmp3_ = (guint16) 53000;
	_tmp4_ = andns_andna_resolve_tcp_client_new (_tmp2_, &_tmp3_, NULL, TRUE);
	client = _tmp4_;
	_tmp5_ = client;
	andns_andna_resolve_tcp_client_set_retry_connect (_tmp5_, FALSE);
	_tmp6_ = ipversion;
	_tmp7_ = addr_bytes;
	_tmp7__length1 = addr_bytes_length1;
	_tmp8_ = andns_andna_query_new_ip_to_name_ntk (FALSE, ANDNS_ANDNA_QUERY_PROTOCOL_TCP, _tmp6_, _tmp7_, _tmp7__length1);
	query = _tmp8_;
	_tmp9_ = g_random_int_range ((gint32) 0, (gint32) 32767);
	id = (gint) _tmp9_;
	_tmp10_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	ret = _tmp10_;
	_tmp11_ = client;
	_tmp12_ = id;
	_tmp13_ = andns_iandna_resolve_root_dispatcher_get_query_handler ((AndnsIAndnaResolveRootDispatcher*) _tmp11_, _tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = query;
	_tmp16_ = andns_iandna_query_handler_resolve (_tmp14_, _tmp15_, &_inner_error_);
	_tmp17_ = _tmp16_;
	_g_object_unref0 (_tmp14_);
	resp = _tmp17_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (ret);
		_g_object_unref0 (query);
		_g_object_unref0 (client);
		return NULL;
	}
	_tmp18_ = resp;
	_tmp19_ = andns_andna_response_get_rcode (_tmp18_);
	_tmp20_ = _tmp19_;
	if (_tmp20_ == ANDNS_ANDNA_RESPONSE_CODE_NO_DOMAIN) {
		result = (GeeList*) ret;
		_g_object_unref0 (resp);
		_g_object_unref0 (query);
		_g_object_unref0 (client);
		return result;
	}
	_tmp21_ = resp;
	_tmp22_ = andns_andna_response_get_rcode (_tmp21_);
	_tmp23_ = _tmp22_;
	if (_tmp23_ != ANDNS_ANDNA_RESPONSE_CODE_NO_ERROR) {
		AndnsAndnaResponse* _tmp24_;
		AndnsAndnaResponseCode _tmp25_;
		AndnsAndnaResponseCode _tmp26_;
		GEnumValue* _tmp27_;
		GError* _tmp28_;
		_tmp24_ = resp;
		_tmp25_ = andns_andna_response_get_rcode (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = g_enum_get_value (g_type_class_ref (ANDNS_TYPE_ANDNA_RESPONSE_CODE), _tmp26_);
		_tmp28_ = g_error_new_literal (NTKRESOLV_NTKRESOLV_ERROR, NTKRESOLV_NTKRESOLV_ERROR_GENERIC, (_tmp27_ != NULL) ? _tmp27_->value_name : NULL);
		_inner_error_ = _tmp28_;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (resp);
		_g_object_unref0 (ret);
		_g_object_unref0 (query);
		_g_object_unref0 (client);
		return NULL;
	}
	_tmp29_ = resp;
	_tmp30_ = andns_andna_response_get_answers (_tmp29_);
	_tmp31_ = _tmp30_;
	_tmp32_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp31_);
	_tmp33_ = _tmp32_;
	if (_tmp33_ == 0) {
		GError* _tmp34_;
		_tmp34_ = g_error_new_literal (NTKRESOLV_NTKRESOLV_ERROR, NTKRESOLV_NTKRESOLV_ERROR_GENERIC, "Response Code is NoError but list is empty.");
		_inner_error_ = _tmp34_;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (resp);
		_g_object_unref0 (ret);
		_g_object_unref0 (query);
		_g_object_unref0 (client);
		return NULL;
	}
	{
		AndnsAndnaResponse* _tmp35_;
		GeeArrayList* _tmp36_;
		GeeArrayList* _tmp37_;
		GeeArrayList* _tmp38_;
		GeeArrayList* _a_list;
		GeeArrayList* _tmp39_;
		gint _tmp40_;
		gint _tmp41_;
		gint _a_size;
		gint _a_index;
		_tmp35_ = resp;
		_tmp36_ = andns_andna_response_get_answers (_tmp35_);
		_tmp37_ = _tmp36_;
		_tmp38_ = _g_object_ref0 (_tmp37_);
		_a_list = _tmp38_;
		_tmp39_ = _a_list;
		_tmp40_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp39_);
		_tmp41_ = _tmp40_;
		_a_size = _tmp41_;
		_a_index = -1;
		while (TRUE) {
			gint _tmp42_;
			gint _tmp43_;
			gint _tmp44_;
			GeeArrayList* _tmp45_;
			gint _tmp46_;
			gpointer _tmp47_ = NULL;
			AndnsAndnaResponseAnswer* a;
			GeeArrayList* _tmp48_;
			AndnsAndnaResponseAnswer* _tmp49_;
			const gchar* _tmp50_;
			const gchar* _tmp51_;
			_tmp42_ = _a_index;
			_a_index = _tmp42_ + 1;
			_tmp43_ = _a_index;
			_tmp44_ = _a_size;
			if (!(_tmp43_ < _tmp44_)) {
				break;
			}
			_tmp45_ = _a_list;
			_tmp46_ = _a_index;
			_tmp47_ = gee_abstract_list_get ((GeeAbstractList*) _tmp45_, _tmp46_);
			a = (AndnsAndnaResponseAnswer*) _tmp47_;
			_tmp48_ = ret;
			_tmp49_ = a;
			_tmp50_ = andns_andna_response_answer_get_hostname (_tmp49_);
			_tmp51_ = _tmp50_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp48_, _tmp51_);
			_g_object_unref0 (a);
		}
		_g_object_unref0 (_a_list);
	}
	result = (GeeList*) ret;
	_g_object_unref0 (resp);
	_g_object_unref0 (query);
	_g_object_unref0 (client);
	return result;
}



