/* libnss_andna.c generated by valac 0.20.1, the Vala compiler
 * generated from libnss_andna.vala, do not modify */

/*
 *  This file is part of Netsukuku.
 *  (c) Copyright 2014 Luca Dionisi aka lukisi <luca.dionisi@gmail.com>
 *
 *  Netsukuku is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Netsukuku is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Netsukuku.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <syslog.h>
#include "sysconf.h"
#include <nss.h>
#include <errno.h>
#include <netdb.h>
#include <gee.h>
#include "ntkresolv.h"
#include <sys/socket.h>
#include <netinet/in.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_key_file_free0(var) ((var == NULL) ? NULL : (var = (g_key_file_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	NOT_ANDNA_ERROR_GENERIC
} NotAndnaError;
#define NOT_ANDNA_ERROR not_andna_error_quark ()
typedef enum  {
	NOT_FOUND_ERROR_GENERIC
} NotFoundError;
#define NOT_FOUND_ERROR not_found_error_quark ()
typedef enum  {
	ONLY_ALIASES_ERROR_GENERIC
} OnlyAliasesError;
#define ONLY_ALIASES_ERROR only_aliases_error_quark ()
typedef enum  {
	BUFFER_ERROR_GENERIC
} BufferError;
#define BUFFER_ERROR buffer_error_quark ()

extern gchar* andnaserver;
gchar* andnaserver = NULL;
extern gboolean initialized;
gboolean initialized = FALSE;

#define LOG_LEAD "nss_andna "
void log_debug (const gchar* msg);
void log_info (const gchar* msg);
void log_notice (const gchar* msg);
void log_warn (const gchar* msg);
void log_error (const gchar* msg);
void log_critical (const gchar* msg);
void init (void);
enum nss_status return_unavail_eperm (gint* h_errnop);
enum nss_status return_unavail_esrch (gint* h_errnop);
enum nss_status return_notfound_eperm (gint* h_errnop);
enum nss_status return_unavail_enoent (gint* h_errnop);
enum nss_status return_notfound_enoent (gint* h_errnop);
enum nss_status return_tryagain_erange (gint* h_errnop);
enum nss_status return_tryagain_eagain (gint* h_errnop);
enum nss_status return_success (void);
GQuark not_andna_error_quark (void);
GQuark not_found_error_quark (void);
GQuark only_aliases_error_quark (void);
GQuark buffer_error_quark (void);
void set_success (struct hostent* ret, gchar* buf, const gchar* name, GeeList* ips);
enum nss_status _nss_andna_gethostbyname2_r (const gchar* name, gint af, struct hostent* ret, gchar* buffer, gsize buflen, struct hostent** _result_, gint* h_errnop);
enum nss_status _nss_andna_gethostbyname_r (const gchar* name, struct hostent* ret, gchar* buffer, gsize buflen, struct hostent** _result_, gint* h_errnop);
GeeArrayList* get_ips (const gchar* origname, GError** error);
gboolean prepare_buffer (GeeList* ips, const gchar* name, guint8* buffer, guint buflen, gchar** h_name, gchar*** h_aliases, gchar*** h_addr_list);
enum nss_status _nss_andna_gethostbyaddr_r (void* addr, socklen_t len, gint type, struct hostent* ret, gchar* buffer, gsize buflen, struct hostent** _result_, gint* h_errnop);
void set_host_ent_from_addr (struct in_addr* addr, struct hostent* ret, gchar* buffer, gsize buflen, const gchar* service, NtkresolvNtkAddrInfo* hints, GError** error);
gboolean prepare_buffer_from_addr (GeeList* names, NtkresolvNtkInetAddr* ip, guint8* buffer, guint buflen, gchar** h_name, gchar*** h_aliases, gchar*** h_addr_list);


void log_debug (const gchar* msg) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_strconcat (LOG_LEAD "DEBUG ", _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	syslog (LOG_DEBUG, _tmp2_, NULL);
	_g_free0 (_tmp2_);
}


void log_info (const gchar* msg) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_strconcat (LOG_LEAD "INFO ", _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	syslog (LOG_INFO, _tmp2_, NULL);
	_g_free0 (_tmp2_);
}


void log_notice (const gchar* msg) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_strconcat (LOG_LEAD "INFO+ ", _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	syslog (LOG_NOTICE, _tmp2_, NULL);
	_g_free0 (_tmp2_);
}


void log_warn (const gchar* msg) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_strconcat (LOG_LEAD "INFO++ ", _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	syslog (LOG_WARNING, _tmp2_, NULL);
	_g_free0 (_tmp2_);
}


void log_error (const gchar* msg) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_strconcat (LOG_LEAD "ERROR ", _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	syslog (LOG_ERR, _tmp2_, NULL);
	_g_free0 (_tmp2_);
}


void log_critical (const gchar* msg) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_strconcat (LOG_LEAD "ERROR+ ", _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	syslog (LOG_CRIT, _tmp2_, NULL);
	_g_free0 (_tmp2_);
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


void init (void) {
	gboolean _tmp0_;
	gchar* _tmp1_;
	gchar* fname;
	GKeyFile* _tmp2_;
	GKeyFile* conf;
	GError * _inner_error_ = NULL;
	_tmp0_ = initialized;
	if (_tmp0_) {
		return;
	}
	_tmp1_ = g_strdup (SYSCONF_DIR "/ntkresolv/ntkresolv.ini");
	fname = _tmp1_;
	_tmp2_ = g_key_file_new ();
	conf = _tmp2_;
	{
		gboolean file_found;
		gboolean _tmp11_;
		file_found = FALSE;
		{
			GKeyFile* _tmp3_;
			const gchar* _tmp4_;
			_tmp3_ = conf;
			_tmp4_ = fname;
			g_key_file_load_from_file (_tmp3_, _tmp4_, G_KEY_FILE_NONE, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_KEY_FILE_ERROR) {
					goto __catch1_g_key_file_error;
				}
				goto __finally1;
			}
			file_found = TRUE;
		}
		goto __finally1;
		__catch1_g_key_file_error:
		{
			GError* e = NULL;
			GError* _tmp5_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp5_ = e;
			if (g_error_matches (_tmp5_, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_NOT_FOUND)) {
			} else {
				GError* _tmp6_;
				const gchar* _tmp7_;
				const gchar* _tmp8_ = NULL;
				gchar* _tmp9_ = NULL;
				gchar* _tmp10_;
				_tmp6_ = e;
				_tmp7_ = _tmp6_->message;
				_tmp8_ = string_to_string (_tmp7_);
				_tmp9_ = g_strconcat ("KeyFileError ", _tmp8_, NULL);
				_tmp10_ = _tmp9_;
				log_warn (_tmp10_);
				_g_free0 (_tmp10_);
			}
			_g_error_free0 (e);
		}
		__finally1:
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		_tmp11_ = file_found;
		if (_tmp11_) {
			gboolean _tmp12_ = FALSE;
			GKeyFile* _tmp13_;
			gboolean _tmp14_ = FALSE;
			gboolean _tmp18_;
			_tmp13_ = conf;
			_tmp14_ = g_key_file_has_group (_tmp13_, "NTKRESOLV");
			if (_tmp14_) {
				GKeyFile* _tmp15_;
				gboolean _tmp16_ = FALSE;
				gboolean _tmp17_;
				_tmp15_ = conf;
				_tmp16_ = g_key_file_has_key (_tmp15_, "NTKRESOLV", "ANDNASERVER", &_inner_error_);
				_tmp17_ = _tmp16_;
				if (_inner_error_ != NULL) {
					goto __catch0_g_error;
				}
				_tmp12_ = _tmp17_;
			} else {
				_tmp12_ = FALSE;
			}
			_tmp18_ = _tmp12_;
			if (_tmp18_) {
				GKeyFile* _tmp19_;
				gchar* _tmp20_ = NULL;
				gchar* _tmp21_;
				const gchar* _tmp22_;
				const gchar* _tmp23_ = NULL;
				gchar* _tmp24_ = NULL;
				gchar* _tmp25_;
				_tmp19_ = conf;
				_tmp20_ = g_key_file_get_string (_tmp19_, "NTKRESOLV", "ANDNASERVER", &_inner_error_);
				_tmp21_ = _tmp20_;
				if (_inner_error_ != NULL) {
					goto __catch0_g_error;
				}
				_g_free0 (andnaserver);
				andnaserver = _tmp21_;
				_tmp22_ = andnaserver;
				_tmp23_ = string_to_string (_tmp22_);
				_tmp24_ = g_strconcat ("Initialized andnaserver ", _tmp23_, ".", NULL);
				_tmp25_ = _tmp24_;
				log_debug (_tmp25_);
				_g_free0 (_tmp25_);
			} else {
				log_warn ("Missing server in ini file.");
			}
		} else {
			log_warn ("Didn't read ini file.");
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp26_;
		const gchar* _tmp27_;
		const gchar* _tmp28_ = NULL;
		gchar* _tmp29_ = NULL;
		gchar* _tmp30_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp26_ = e;
		_tmp27_ = _tmp26_->message;
		_tmp28_ = string_to_string (_tmp27_);
		_tmp29_ = g_strconcat ("Error ", _tmp28_, NULL);
		_tmp30_ = _tmp29_;
		log_warn (_tmp30_);
		_g_free0 (_tmp30_);
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		_g_key_file_free0 (conf);
		_g_free0 (fname);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	initialized = TRUE;
	_g_key_file_free0 (conf);
	_g_free0 (fname);
}


enum nss_status return_unavail_eperm (gint* h_errnop) {
	enum nss_status result = 0;
	gint* _tmp0_;
	gint _tmp1_;
	_tmp0_ = h_errnop;
	*_tmp0_ = EPERM;
	_tmp1_ = *_tmp0_;
	log_debug ("returning unavail eperm");
	result = NSS_STATUS_UNAVAIL;
	return result;
}


enum nss_status return_unavail_esrch (gint* h_errnop) {
	enum nss_status result = 0;
	gint* _tmp0_;
	gint _tmp1_;
	_tmp0_ = h_errnop;
	*_tmp0_ = ESRCH;
	_tmp1_ = *_tmp0_;
	log_debug ("returning unavail esrch");
	result = NSS_STATUS_UNAVAIL;
	return result;
}


enum nss_status return_notfound_eperm (gint* h_errnop) {
	enum nss_status result = 0;
	gint* _tmp0_;
	gint _tmp1_;
	_tmp0_ = h_errnop;
	*_tmp0_ = EPERM;
	_tmp1_ = *_tmp0_;
	log_debug ("returning notfound eperm");
	result = NSS_STATUS_NOTFOUND;
	return result;
}


enum nss_status return_unavail_enoent (gint* h_errnop) {
	enum nss_status result = 0;
	gint* _tmp0_;
	gint _tmp1_;
	_tmp0_ = h_errnop;
	*_tmp0_ = ENOENT;
	_tmp1_ = *_tmp0_;
	log_debug ("returning unavail enoent");
	result = NSS_STATUS_UNAVAIL;
	return result;
}


enum nss_status return_notfound_enoent (gint* h_errnop) {
	enum nss_status result = 0;
	gint* _tmp0_;
	gint _tmp1_;
	_tmp0_ = h_errnop;
	*_tmp0_ = ENOENT;
	_tmp1_ = *_tmp0_;
	log_debug ("returning notfound enoent");
	result = NSS_STATUS_NOTFOUND;
	return result;
}


enum nss_status return_tryagain_erange (gint* h_errnop) {
	enum nss_status result = 0;
	gint* _tmp0_;
	gint _tmp1_;
	_tmp0_ = h_errnop;
	*_tmp0_ = ERANGE;
	_tmp1_ = *_tmp0_;
	log_debug ("returning tryagain erange");
	result = NSS_STATUS_TRYAGAIN;
	return result;
}


enum nss_status return_tryagain_eagain (gint* h_errnop) {
	enum nss_status result = 0;
	gint* _tmp0_;
	gint _tmp1_;
	_tmp0_ = h_errnop;
	*_tmp0_ = EAGAIN;
	_tmp1_ = *_tmp0_;
	log_debug ("returning tryagain eagain");
	result = NSS_STATUS_TRYAGAIN;
	return result;
}


enum nss_status return_success (void) {
	enum nss_status result = 0;
	log_debug ("returning success");
	result = NSS_STATUS_SUCCESS;
	return result;
}


GQuark not_andna_error_quark (void) {
	return g_quark_from_static_string ("not_andna_error-quark");
}


GQuark not_found_error_quark (void) {
	return g_quark_from_static_string ("not_found_error-quark");
}


GQuark only_aliases_error_quark (void) {
	return g_quark_from_static_string ("only_aliases_error-quark");
}


GQuark buffer_error_quark (void) {
	return g_quark_from_static_string ("buffer_error-quark");
}


static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res_length1;
	_tmp3_ = res;
	_tmp3__length1 = res_length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void set_success (struct hostent* ret, gchar* buf, const gchar* name, GeeList* ips) {
	struct hostent* _tmp0_;
	struct hostent* _tmp1_;
	gchar* h_name = NULL;
	gchar** h_aliases = NULL;
	gchar** h_addr_list;
	gchar* _tmp2_;
	guint8* buffer;
	gchar** x = NULL;
	gchar* p = NULL;
	guint pos;
	guint* _tmp3_ = NULL;
	guint* pos_ip;
	gint pos_ip_length1;
	gint _pos_ip_size_;
	guint8* _tmp4_;
	guint _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	guint8* _tmp8_;
	gint _tmp8__length1;
	guint8* _tmp9_;
	gint _tmp9__length1;
	guint8* _tmp14_;
	guint _tmp15_;
	guint8 _tmp16_;
	guint8* _tmp17_;
	guint _tmp18_;
	gchar* _tmp19_;
	gchar** _tmp20_;
	gchar* _tmp21_;
	gchar** _tmp22_;
	guint _tmp23_;
	guint _tmp24_;
	guint _tmp25_;
	gint ip_count;
	guint8* _tmp63_;
	guint _tmp64_;
	gchar* _tmp65_;
	gchar** _tmp66_;
	gchar* _tmp67_;
	guint _tmp68_;
	struct hostent* _tmp69_;
	gchar* _tmp70_;
	struct hostent* _tmp71_;
	gchar** _tmp72_;
	struct hostent* _tmp73_;
	gchar** _tmp74_;
	g_return_if_fail (name != NULL);
	g_return_if_fail (ips != NULL);
	_tmp0_ = ret;
	(*_tmp0_).h_addrtype = AF_INET;
	_tmp1_ = ret;
	(*_tmp1_).h_length = 4;
	h_addr_list = NULL;
	_tmp2_ = buf;
	buffer = (guint8*) _tmp2_;
	pos = (guint) 0;
	_tmp3_ = g_new0 (guint, 1);
	pos_ip = _tmp3_;
	pos_ip_length1 = 1;
	_pos_ip_size_ = pos_ip_length1;
	_tmp4_ = buffer;
	_tmp5_ = pos;
	p = ((gchar*) _tmp4_) + _tmp5_;
	_tmp6_ = p;
	h_name = _tmp6_;
	_tmp7_ = name;
	_tmp8_ = string_get_data (_tmp7_, &_tmp8__length1);
	_tmp9_ = _tmp8_;
	_tmp9__length1 = _tmp8__length1;
	{
		guint8* o_collection = NULL;
		gint o_collection_length1 = 0;
		gint _o_collection_size_ = 0;
		gint o_it = 0;
		o_collection = _tmp9_;
		o_collection_length1 = _tmp9__length1;
		for (o_it = 0; o_it < _tmp9__length1; o_it = o_it + 1) {
			guint8 o = 0U;
			o = o_collection[o_it];
			{
				guint8* _tmp10_;
				guint _tmp11_;
				guint8 _tmp12_;
				guint8 _tmp13_;
				_tmp10_ = buffer;
				_tmp11_ = pos;
				pos = _tmp11_ + 1;
				_tmp12_ = o;
				_tmp10_[_tmp11_] = _tmp12_;
				_tmp13_ = _tmp10_[_tmp11_];
			}
		}
	}
	_tmp14_ = buffer;
	_tmp15_ = pos;
	pos = _tmp15_ + 1;
	_tmp14_[_tmp15_] = (guint8) '\0';
	_tmp16_ = _tmp14_[_tmp15_];
	_tmp17_ = buffer;
	_tmp18_ = pos;
	p = ((gchar*) _tmp17_) + _tmp18_;
	_tmp19_ = p;
	x = (gchar**) _tmp19_;
	_tmp20_ = x;
	*_tmp20_ = NULL;
	_tmp21_ = *_tmp20_;
	_tmp22_ = x;
	h_aliases = _tmp22_;
	_tmp23_ = pos;
	pos = _tmp23_ + ((guint) sizeof (gchar*));
	_tmp24_ = pos;
	_tmp25_ = pos;
	pos = _tmp24_ + (((guint) sizeof (void*)) - (_tmp25_ % ((guint) sizeof (void*))));
	ip_count = 0;
	{
		GeeList* _tmp26_;
		GeeList* _tmp27_;
		GeeList* _ip_list;
		GeeList* _tmp28_;
		gint _tmp29_;
		gint _tmp30_;
		gint _ip_size;
		gint _ip_index;
		_tmp26_ = ips;
		_tmp27_ = _g_object_ref0 (_tmp26_);
		_ip_list = _tmp27_;
		_tmp28_ = _ip_list;
		_tmp29_ = gee_collection_get_size ((GeeCollection*) _tmp28_);
		_tmp30_ = _tmp29_;
		_ip_size = _tmp30_;
		_ip_index = -1;
		while (TRUE) {
			gint _tmp31_;
			gint _tmp32_;
			gint _tmp33_;
			GeeList* _tmp34_;
			gint _tmp35_;
			gpointer _tmp36_ = NULL;
			NtkresolvNtkInetAddr* ip;
			guint* _tmp37_;
			gint _tmp37__length1;
			gint _tmp38_;
			guint _tmp39_;
			guint _tmp40_;
			NtkresolvNtkInetAddr* _tmp41_;
			_tmp31_ = _ip_index;
			_ip_index = _tmp31_ + 1;
			_tmp32_ = _ip_index;
			_tmp33_ = _ip_size;
			if (!(_tmp32_ < _tmp33_)) {
				break;
			}
			_tmp34_ = _ip_list;
			_tmp35_ = _ip_index;
			_tmp36_ = gee_list_get (_tmp34_, _tmp35_);
			ip = (NtkresolvNtkInetAddr*) _tmp36_;
			_tmp37_ = pos_ip;
			_tmp37__length1 = pos_ip_length1;
			_tmp38_ = ip_count;
			ip_count = _tmp38_ + 1;
			_tmp39_ = pos;
			_tmp37_[_tmp38_] = _tmp39_;
			_tmp40_ = _tmp37_[_tmp38_];
			_tmp41_ = ip;
			{
				guint8* o_collection = NULL;
				gint o_collection_length1 = 0;
				gint _o_collection_size_ = 0;
				gint o_it = 0;
				o_collection = _tmp41_->addr;
				o_collection_length1 = 4;
				for (o_it = 0; o_it < 4; o_it = o_it + 1) {
					guint8 o = 0U;
					o = o_collection[o_it];
					{
						guint8* _tmp42_;
						guint _tmp43_;
						guint8 _tmp44_;
						guint8 _tmp45_;
						_tmp42_ = buffer;
						_tmp43_ = pos;
						pos = _tmp43_ + 1;
						_tmp44_ = o;
						_tmp42_[_tmp43_] = _tmp44_;
						_tmp45_ = _tmp42_[_tmp43_];
					}
				}
			}
			_g_object_unref0 (ip);
		}
		_g_object_unref0 (_ip_list);
	}
	{
		gint ip_num;
		ip_num = 0;
		{
			gboolean _tmp46_;
			_tmp46_ = TRUE;
			while (TRUE) {
				gboolean _tmp47_;
				gint _tmp49_;
				gint _tmp50_;
				guint8* _tmp51_;
				guint _tmp52_;
				gchar* _tmp53_;
				gchar** _tmp54_;
				guint8* _tmp55_;
				guint* _tmp56_;
				gint _tmp56__length1;
				gint _tmp57_;
				guint _tmp58_;
				gchar* _tmp59_;
				gint _tmp60_;
				guint _tmp62_;
				_tmp47_ = _tmp46_;
				if (!_tmp47_) {
					gint _tmp48_;
					_tmp48_ = ip_num;
					ip_num = _tmp48_ + 1;
				}
				_tmp46_ = FALSE;
				_tmp49_ = ip_num;
				_tmp50_ = ip_count;
				if (!(_tmp49_ < _tmp50_)) {
					break;
				}
				_tmp51_ = buffer;
				_tmp52_ = pos;
				p = ((gchar*) _tmp51_) + _tmp52_;
				_tmp53_ = p;
				x = (gchar**) _tmp53_;
				_tmp54_ = x;
				_tmp55_ = buffer;
				_tmp56_ = pos_ip;
				_tmp56__length1 = pos_ip_length1;
				_tmp57_ = ip_num;
				_tmp58_ = _tmp56_[_tmp57_];
				*_tmp54_ = ((gchar*) _tmp55_) + _tmp58_;
				_tmp59_ = *_tmp54_;
				_tmp60_ = ip_num;
				if (_tmp60_ == 0) {
					gchar** _tmp61_;
					_tmp61_ = x;
					h_addr_list = _tmp61_;
				}
				_tmp62_ = pos;
				pos = _tmp62_ + ((guint) sizeof (gchar*));
			}
		}
	}
	_tmp63_ = buffer;
	_tmp64_ = pos;
	p = ((gchar*) _tmp63_) + _tmp64_;
	_tmp65_ = p;
	x = (gchar**) _tmp65_;
	_tmp66_ = x;
	*_tmp66_ = NULL;
	_tmp67_ = *_tmp66_;
	_tmp68_ = pos;
	pos = _tmp68_ + ((guint) sizeof (gchar*));
	_tmp69_ = ret;
	_tmp70_ = h_name;
	(*_tmp69_).h_name = (const gchar*) _tmp70_;
	_tmp71_ = ret;
	_tmp72_ = h_aliases;
	(*_tmp71_).h_aliases = (gchar**) _tmp72_;
	_tmp73_ = ret;
	_tmp74_ = h_addr_list;
	(*_tmp73_).h_addr_list = (gchar**) _tmp74_;
	pos_ip = (g_free (pos_ip), NULL);
}


enum nss_status _nss_andna_gethostbyname2_r (const gchar* name, gint af, struct hostent* ret, gchar* buffer, gsize buflen, struct hostent** _result_, gint* h_errnop) {
	enum nss_status result = 0;
	const gchar* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	gint _tmp7_;
	g_return_val_if_fail (name != NULL, 0);
	init ();
	_tmp0_ = name;
	_tmp1_ = string_to_string (_tmp0_);
	_tmp2_ = af;
	_tmp3_ = g_strdup_printf ("%i", _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat ("name2: ", _tmp1_, ", ", _tmp4_, NULL);
	_tmp6_ = _tmp5_;
	log_debug (_tmp6_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_tmp7_ = af;
	if (_tmp7_ == AF_INET) {
		const gchar* _tmp8_;
		struct hostent* _tmp9_;
		gchar* _tmp10_;
		gsize _tmp11_;
		struct hostent** _tmp12_;
		gint* _tmp13_;
		enum nss_status _tmp14_ = 0;
		_tmp8_ = name;
		_tmp9_ = ret;
		_tmp10_ = buffer;
		_tmp11_ = buflen;
		_tmp12_ = _result_;
		_tmp13_ = h_errnop;
		_tmp14_ = _nss_andna_gethostbyname_r (_tmp8_, _tmp9_, _tmp10_, _tmp11_, _tmp12_, _tmp13_);
		result = _tmp14_;
		return result;
	} else {
		gint _tmp15_;
		_tmp15_ = af;
		if (_tmp15_ == AF_INET6) {
			gint* _tmp16_;
			enum nss_status _tmp17_ = 0;
			_tmp16_ = h_errnop;
			_tmp17_ = return_unavail_esrch (_tmp16_);
			result = _tmp17_;
			return result;
		} else {
			gint* _tmp18_;
			enum nss_status _tmp19_ = 0;
			log_debug ("name2: af is unknown");
			_tmp18_ = h_errnop;
			_tmp19_ = return_unavail_esrch (_tmp18_);
			result = _tmp19_;
			return result;
		}
	}
}


enum nss_status _nss_andna_gethostbyname_r (const gchar* name, struct hostent* ret, gchar* buffer, gsize buflen, struct hostent** _result_, gint* h_errnop) {
	enum nss_status result = 0;
	const gchar* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (name != NULL, 0);
	init ();
	_tmp0_ = name;
	_tmp1_ = string_to_string (_tmp0_);
	_tmp2_ = g_strconcat ("name: ", _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	log_debug (_tmp3_);
	_g_free0 (_tmp3_);
	{
		const gchar* _tmp4_;
		GeeArrayList* _tmp5_ = NULL;
		GeeArrayList* ips;
		guint ipsize;
		gsize _tmp6_;
		guint _tmp7_;
		GeeArrayList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		struct hostent* _tmp13_;
		gchar* _tmp14_;
		const gchar* _tmp15_;
		GeeArrayList* _tmp16_;
		enum nss_status _tmp17_ = 0;
		_tmp4_ = name;
		_tmp5_ = get_ips (_tmp4_, &_inner_error_);
		ips = _tmp5_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == NOT_ANDNA_ERROR) {
				goto __catch2_not_andna_error;
			}
			if (_inner_error_->domain == NOT_FOUND_ERROR) {
				goto __catch2_not_found_error;
			}
			if (_inner_error_->domain == ONLY_ALIASES_ERROR) {
				goto __catch2_only_aliases_error;
			}
			if (_inner_error_->domain == BUFFER_ERROR) {
				goto __catch2_buffer_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		ipsize = ((guint) sizeof (guint8)) * 4;
		_tmp6_ = buflen;
		_tmp7_ = ipsize;
		_tmp8_ = ips;
		_tmp9_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp8_);
		_tmp10_ = _tmp9_;
		if (_tmp6_ < ((gsize) (256 + ((_tmp7_ + ((guint) sizeof (gchar*))) * _tmp10_)))) {
			gint* _tmp11_;
			enum nss_status _tmp12_ = 0;
			_tmp11_ = h_errnop;
			_tmp12_ = return_tryagain_erange (_tmp11_);
			result = _tmp12_;
			_g_object_unref0 (ips);
			return result;
		}
		_tmp13_ = ret;
		_tmp14_ = buffer;
		_tmp15_ = name;
		_tmp16_ = ips;
		set_success (_tmp13_, _tmp14_, _tmp15_, (GeeList*) _tmp16_);
		_tmp17_ = return_success ();
		result = _tmp17_;
		_g_object_unref0 (ips);
		return result;
	}
	goto __finally2;
	__catch2_not_andna_error:
	{
		GError* e = NULL;
		gint* _tmp18_;
		enum nss_status _tmp19_ = 0;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp18_ = h_errnop;
		_tmp19_ = return_unavail_eperm (_tmp18_);
		result = _tmp19_;
		_g_error_free0 (e);
		return result;
	}
	goto __finally2;
	__catch2_not_found_error:
	{
		GError* e = NULL;
		gint* _tmp20_;
		enum nss_status _tmp21_ = 0;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp20_ = h_errnop;
		_tmp21_ = return_notfound_eperm (_tmp20_);
		result = _tmp21_;
		_g_error_free0 (e);
		return result;
	}
	goto __finally2;
	__catch2_only_aliases_error:
	{
		GError* e = NULL;
		gint* _tmp22_;
		enum nss_status _tmp23_ = 0;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp22_ = h_errnop;
		_tmp23_ = return_notfound_eperm (_tmp22_);
		result = _tmp23_;
		_g_error_free0 (e);
		return result;
	}
	goto __finally2;
	__catch2_buffer_error:
	{
		GError* e = NULL;
		gint* _tmp24_;
		enum nss_status _tmp25_ = 0;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp24_ = h_errnop;
		_tmp25_ = return_tryagain_erange (_tmp24_);
		result = _tmp25_;
		_g_error_free0 (e);
		return result;
	}
	__finally2:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return 0;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* end;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
		_tmp4_ = offset;
		_tmp5_ = len;
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
		string_length = _tmp6_;
	} else {
		gint _tmp7_;
		gint _tmp8_;
		_tmp7_ = strlen (self);
		_tmp8_ = _tmp7_;
		string_length = (glong) _tmp8_;
	}
	_tmp9_ = offset;
	if (_tmp9_ < ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
		_tmp10_ = string_length;
		_tmp11_ = offset;
		offset = _tmp10_ + _tmp11_;
		_tmp12_ = offset;
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
	} else {
		glong _tmp13_;
		glong _tmp14_;
		_tmp13_ = offset;
		_tmp14_ = string_length;
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
	}
	_tmp15_ = len;
	if (_tmp15_ < ((glong) 0)) {
		glong _tmp16_;
		glong _tmp17_;
		_tmp16_ = string_length;
		_tmp17_ = offset;
		len = _tmp16_ - _tmp17_;
	}
	_tmp18_ = offset;
	_tmp19_ = len;
	_tmp20_ = string_length;
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
	_tmp21_ = offset;
	_tmp22_ = len;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
	result = _tmp23_;
	return result;
}


GeeArrayList* get_ips (const gchar* origname, GError** error) {
	GeeArrayList* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* name;
	const gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	gboolean _tmp12_;
	const gchar* _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	gchar* _tmp26_ = NULL;
	gchar* _tmp27_;
	gchar* _tmp28_ = NULL;
	gchar* _tmp29_;
	gboolean _tmp30_;
	const gchar* _tmp32_;
	const gchar* _tmp33_;
	gint _tmp34_;
	gint _tmp35_;
	gchar* _tmp36_ = NULL;
	GeeArrayList* _tmp37_;
	GeeArrayList* ips;
	GeeList* resp = NULL;
	GeeList* _tmp49_;
	gint _tmp50_;
	gint _tmp51_;
	GeeArrayList* _tmp75_;
	gint _tmp76_;
	gint _tmp77_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (origname != NULL, NULL);
	_tmp0_ = origname;
	_tmp1_ = g_strdup (_tmp0_);
	name = _tmp1_;
	_tmp2_ = name;
	_tmp3_ = strlen (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ < 5) {
		GError* _tmp5_;
		_tmp5_ = g_error_new_literal (NOT_ANDNA_ERROR, NOT_ANDNA_ERROR_GENERIC, "not for ANDNA");
		_inner_error_ = _tmp5_;
		if ((((_inner_error_->domain == NOT_ANDNA_ERROR) || (_inner_error_->domain == NOT_FOUND_ERROR)) || (_inner_error_->domain == ONLY_ALIASES_ERROR)) || (_inner_error_->domain == BUFFER_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (name);
			return NULL;
		} else {
			_g_free0 (name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp6_ = name;
	_tmp7_ = name;
	_tmp8_ = strlen (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = string_substring (_tmp6_, (glong) (_tmp9_ - 1), (glong) (-1));
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strcmp0 (_tmp11_, ".") == 0;
	_g_free0 (_tmp11_);
	if (_tmp12_) {
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gchar* _tmp17_ = NULL;
		_tmp13_ = name;
		_tmp14_ = name;
		_tmp15_ = strlen (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = string_substring (_tmp13_, (glong) 0, (glong) (_tmp16_ - 1));
		_g_free0 (name);
		name = _tmp17_;
	}
	_tmp18_ = name;
	_tmp19_ = strlen (_tmp18_);
	_tmp20_ = _tmp19_;
	if (_tmp20_ < 5) {
		GError* _tmp21_;
		_tmp21_ = g_error_new_literal (NOT_ANDNA_ERROR, NOT_ANDNA_ERROR_GENERIC, "not for ANDNA");
		_inner_error_ = _tmp21_;
		if ((((_inner_error_->domain == NOT_ANDNA_ERROR) || (_inner_error_->domain == NOT_FOUND_ERROR)) || (_inner_error_->domain == ONLY_ALIASES_ERROR)) || (_inner_error_->domain == BUFFER_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (name);
			return NULL;
		} else {
			_g_free0 (name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp22_ = name;
	_tmp23_ = name;
	_tmp24_ = strlen (_tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = string_substring (_tmp22_, (glong) (_tmp25_ - 4), (glong) (-1));
	_tmp27_ = _tmp26_;
	_tmp28_ = g_utf8_strup (_tmp27_, (gssize) (-1));
	_tmp29_ = _tmp28_;
	_tmp30_ = g_strcmp0 (_tmp29_, ".NTK") != 0;
	_g_free0 (_tmp29_);
	_g_free0 (_tmp27_);
	if (_tmp30_) {
		GError* _tmp31_;
		_tmp31_ = g_error_new_literal (NOT_ANDNA_ERROR, NOT_ANDNA_ERROR_GENERIC, "not for ANDNA");
		_inner_error_ = _tmp31_;
		if ((((_inner_error_->domain == NOT_ANDNA_ERROR) || (_inner_error_->domain == NOT_FOUND_ERROR)) || (_inner_error_->domain == ONLY_ALIASES_ERROR)) || (_inner_error_->domain == BUFFER_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (name);
			return NULL;
		} else {
			_g_free0 (name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp32_ = name;
	_tmp33_ = name;
	_tmp34_ = strlen (_tmp33_);
	_tmp35_ = _tmp34_;
	_tmp36_ = string_substring (_tmp32_, (glong) 0, (glong) (_tmp35_ - 4));
	_g_free0 (name);
	name = _tmp36_;
	log_debug ("name: is for andna...");
	_tmp37_ = gee_array_list_new (NTKRESOLV_TYPE_NTK_INET_ADDR, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	ips = _tmp37_;
	{
		const gchar* _tmp38_;
		_tmp38_ = andnaserver;
		if (_tmp38_ == NULL) {
			const gchar* _tmp39_;
			GeeList* _tmp40_ = NULL;
			GeeList* _tmp41_;
			_tmp39_ = name;
			_tmp40_ = ntkresolv_resolv (_tmp39_, NULL, NULL, "127.0.0.1", &_inner_error_);
			_tmp41_ = _tmp40_;
			if (_inner_error_ != NULL) {
				goto __catch3_g_error;
			}
			_g_object_unref0 (resp);
			resp = _tmp41_;
		} else {
			const gchar* _tmp42_;
			const gchar* _tmp43_;
			GeeList* _tmp44_ = NULL;
			GeeList* _tmp45_;
			_tmp42_ = name;
			_tmp43_ = andnaserver;
			_tmp44_ = ntkresolv_resolv (_tmp42_, NULL, NULL, _tmp43_, &_inner_error_);
			_tmp45_ = _tmp44_;
			if (_inner_error_ != NULL) {
				goto __catch3_g_error;
			}
			_g_object_unref0 (resp);
			resp = _tmp45_;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		GError* _tmp46_;
		const gchar* _tmp47_;
		GError* _tmp48_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp46_ = e;
		_tmp47_ = _tmp46_->message;
		_tmp48_ = g_error_new_literal (NOT_FOUND_ERROR, NOT_FOUND_ERROR_GENERIC, _tmp47_);
		_inner_error_ = _tmp48_;
		_g_error_free0 (e);
		goto __finally3;
	}
	__finally3:
	if (_inner_error_ != NULL) {
		if ((((_inner_error_->domain == NOT_ANDNA_ERROR) || (_inner_error_->domain == NOT_FOUND_ERROR)) || (_inner_error_->domain == ONLY_ALIASES_ERROR)) || (_inner_error_->domain == BUFFER_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (resp);
			_g_object_unref0 (ips);
			_g_free0 (name);
			return NULL;
		} else {
			_g_object_unref0 (resp);
			_g_object_unref0 (ips);
			_g_free0 (name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp49_ = resp;
	_tmp50_ = gee_collection_get_size ((GeeCollection*) _tmp49_);
	_tmp51_ = _tmp50_;
	if (_tmp51_ == 0) {
		const gchar* _tmp52_;
		const gchar* _tmp53_ = NULL;
		gchar* _tmp54_ = NULL;
		gchar* _tmp55_;
		GError* _tmp56_;
		GError* _tmp57_;
		_tmp52_ = name;
		_tmp53_ = string_to_string (_tmp52_);
		_tmp54_ = g_strconcat (_tmp53_, " not found.", NULL);
		_tmp55_ = _tmp54_;
		_tmp56_ = g_error_new_literal (NOT_FOUND_ERROR, NOT_FOUND_ERROR_GENERIC, _tmp55_);
		_tmp57_ = _tmp56_;
		_g_free0 (_tmp55_);
		_inner_error_ = _tmp57_;
		if ((((_inner_error_->domain == NOT_ANDNA_ERROR) || (_inner_error_->domain == NOT_FOUND_ERROR)) || (_inner_error_->domain == ONLY_ALIASES_ERROR)) || (_inner_error_->domain == BUFFER_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (resp);
			_g_object_unref0 (ips);
			_g_free0 (name);
			return NULL;
		} else {
			_g_object_unref0 (resp);
			_g_object_unref0 (ips);
			_g_free0 (name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	{
		GeeList* _tmp58_;
		GeeList* _tmp59_;
		GeeList* _ainfo_list;
		GeeList* _tmp60_;
		gint _tmp61_;
		gint _tmp62_;
		gint _ainfo_size;
		gint _ainfo_index;
		_tmp58_ = resp;
		_tmp59_ = _g_object_ref0 (_tmp58_);
		_ainfo_list = _tmp59_;
		_tmp60_ = _ainfo_list;
		_tmp61_ = gee_collection_get_size ((GeeCollection*) _tmp60_);
		_tmp62_ = _tmp61_;
		_ainfo_size = _tmp62_;
		_ainfo_index = -1;
		while (TRUE) {
			gint _tmp63_;
			gint _tmp64_;
			gint _tmp65_;
			GeeList* _tmp66_;
			gint _tmp67_;
			gpointer _tmp68_ = NULL;
			NtkresolvNtkAddrInfo* ainfo;
			NtkresolvNtkAddrInfo* _tmp69_;
			NtkresolvNtkAddr* _tmp70_;
			NtkresolvNtkInetAddr* _tmp71_;
			NtkresolvNtkInetAddr* addr;
			NtkresolvNtkInetAddr* _tmp72_;
			_tmp63_ = _ainfo_index;
			_ainfo_index = _tmp63_ + 1;
			_tmp64_ = _ainfo_index;
			_tmp65_ = _ainfo_size;
			if (!(_tmp64_ < _tmp65_)) {
				break;
			}
			_tmp66_ = _ainfo_list;
			_tmp67_ = _ainfo_index;
			_tmp68_ = gee_list_get (_tmp66_, _tmp67_);
			ainfo = (NtkresolvNtkAddrInfo*) _tmp68_;
			_tmp69_ = ainfo;
			_tmp70_ = _tmp69_->address;
			_tmp71_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp70_, NTKRESOLV_TYPE_NTK_INET_ADDR) ? ((NtkresolvNtkInetAddr*) _tmp70_) : NULL);
			addr = _tmp71_;
			_tmp72_ = addr;
			if (_tmp72_ == NULL) {
			} else {
				GeeArrayList* _tmp73_;
				NtkresolvNtkInetAddr* _tmp74_;
				_tmp73_ = ips;
				_tmp74_ = addr;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp73_, _tmp74_);
			}
			_g_object_unref0 (addr);
			_g_object_unref0 (ainfo);
		}
		_g_object_unref0 (_ainfo_list);
	}
	_tmp75_ = ips;
	_tmp76_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp75_);
	_tmp77_ = _tmp76_;
	if (_tmp77_ == 0) {
		GError* _tmp78_;
		_tmp78_ = g_error_new_literal (ONLY_ALIASES_ERROR, ONLY_ALIASES_ERROR_GENERIC, "No IPv4 addresses.");
		_inner_error_ = _tmp78_;
		if ((((_inner_error_->domain == NOT_ANDNA_ERROR) || (_inner_error_->domain == NOT_FOUND_ERROR)) || (_inner_error_->domain == ONLY_ALIASES_ERROR)) || (_inner_error_->domain == BUFFER_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (resp);
			_g_object_unref0 (ips);
			_g_free0 (name);
			return NULL;
		} else {
			_g_object_unref0 (resp);
			_g_object_unref0 (ips);
			_g_free0 (name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = ips;
	_g_object_unref0 (resp);
	_g_free0 (name);
	return result;
}


gboolean prepare_buffer (GeeList* ips, const gchar* name, guint8* buffer, guint buflen, gchar** h_name, gchar*** h_aliases, gchar*** h_addr_list) {
	gchar* _vala_h_name = NULL;
	gchar** _vala_h_aliases = NULL;
	gchar** _vala_h_addr_list = NULL;
	gboolean result = FALSE;
	guint ipsize;
	const gchar* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint minima;
	guint _tmp3_;
	guint _tmp4_;
	guint _tmp5_;
	guint _tmp6_;
	guint _tmp7_;
	GeeList* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	guint _tmp11_;
	guint _tmp12_;
	guint _tmp13_;
	gchar** x = NULL;
	gchar* p = NULL;
	guint pos;
	GeeList* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	guint* _tmp17_ = NULL;
	guint* pos_ip;
	gint pos_ip_length1;
	gint _pos_ip_size_;
	guint8* _tmp18_;
	guint _tmp19_;
	gchar* _tmp20_;
	const gchar* _tmp21_;
	guint8* _tmp22_;
	gint _tmp22__length1;
	guint8* _tmp23_;
	gint _tmp23__length1;
	guint8* _tmp28_;
	guint _tmp29_;
	guint8 _tmp30_;
	guint8* _tmp31_;
	guint _tmp32_;
	gchar* _tmp33_;
	gchar** _tmp34_;
	gchar* _tmp35_;
	gchar** _tmp36_;
	guint _tmp37_;
	guint _tmp38_;
	guint _tmp39_;
	gint ip_count;
	guint8* _tmp77_;
	guint _tmp78_;
	gchar* _tmp79_;
	gchar** _tmp80_;
	gchar* _tmp81_;
	guint _tmp82_;
	g_return_val_if_fail (ips != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	ipsize = ((guint) sizeof (guint8)) * 4;
	_tmp0_ = name;
	_tmp1_ = strlen (_tmp0_);
	_tmp2_ = _tmp1_;
	minima = (guint) _tmp2_;
	_tmp3_ = minima;
	minima = _tmp3_ + 1;
	_tmp4_ = minima;
	minima = _tmp4_ + ((guint) sizeof (gchar*));
	_tmp5_ = minima;
	minima = _tmp5_ + ((guint) sizeof (guint32));
	_tmp6_ = minima;
	_tmp7_ = ipsize;
	_tmp8_ = ips;
	_tmp9_ = gee_collection_get_size ((GeeCollection*) _tmp8_);
	_tmp10_ = _tmp9_;
	minima = _tmp6_ + ((_tmp7_ + ((guint) sizeof (gchar*))) * _tmp10_);
	_tmp11_ = minima;
	minima = _tmp11_ + ((guint) sizeof (gchar*));
	_tmp12_ = buflen;
	_tmp13_ = minima;
	if (_tmp12_ < _tmp13_) {
		result = FALSE;
		if (h_name) {
			*h_name = _vala_h_name;
		}
		if (h_aliases) {
			*h_aliases = _vala_h_aliases;
		}
		if (h_addr_list) {
			*h_addr_list = _vala_h_addr_list;
		}
		return result;
	}
	pos = (guint) 0;
	_tmp14_ = ips;
	_tmp15_ = gee_collection_get_size ((GeeCollection*) _tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = g_new0 (guint, _tmp16_);
	pos_ip = _tmp17_;
	pos_ip_length1 = _tmp16_;
	_pos_ip_size_ = pos_ip_length1;
	_tmp18_ = buffer;
	_tmp19_ = pos;
	p = ((gchar*) _tmp18_) + _tmp19_;
	_tmp20_ = p;
	_vala_h_name = _tmp20_;
	_tmp21_ = name;
	_tmp22_ = string_get_data (_tmp21_, &_tmp22__length1);
	_tmp23_ = _tmp22_;
	_tmp23__length1 = _tmp22__length1;
	{
		guint8* o_collection = NULL;
		gint o_collection_length1 = 0;
		gint _o_collection_size_ = 0;
		gint o_it = 0;
		o_collection = _tmp23_;
		o_collection_length1 = _tmp23__length1;
		for (o_it = 0; o_it < _tmp23__length1; o_it = o_it + 1) {
			guint8 o = 0U;
			o = o_collection[o_it];
			{
				guint8* _tmp24_;
				guint _tmp25_;
				guint8 _tmp26_;
				guint8 _tmp27_;
				_tmp24_ = buffer;
				_tmp25_ = pos;
				pos = _tmp25_ + 1;
				_tmp26_ = o;
				_tmp24_[_tmp25_] = _tmp26_;
				_tmp27_ = _tmp24_[_tmp25_];
			}
		}
	}
	_tmp28_ = buffer;
	_tmp29_ = pos;
	pos = _tmp29_ + 1;
	_tmp28_[_tmp29_] = (guint8) '\0';
	_tmp30_ = _tmp28_[_tmp29_];
	_tmp31_ = buffer;
	_tmp32_ = pos;
	p = ((gchar*) _tmp31_) + _tmp32_;
	_tmp33_ = p;
	x = (gchar**) _tmp33_;
	_tmp34_ = x;
	*_tmp34_ = NULL;
	_tmp35_ = *_tmp34_;
	_tmp36_ = x;
	_vala_h_aliases = _tmp36_;
	_tmp37_ = pos;
	pos = _tmp37_ + ((guint) sizeof (gchar*));
	_tmp38_ = pos;
	_tmp39_ = pos;
	pos = _tmp38_ + (((guint) sizeof (void*)) - (_tmp39_ % ((guint) sizeof (void*))));
	ip_count = 0;
	{
		GeeList* _tmp40_;
		GeeList* _tmp41_;
		GeeList* _ip_list;
		GeeList* _tmp42_;
		gint _tmp43_;
		gint _tmp44_;
		gint _ip_size;
		gint _ip_index;
		_tmp40_ = ips;
		_tmp41_ = _g_object_ref0 (_tmp40_);
		_ip_list = _tmp41_;
		_tmp42_ = _ip_list;
		_tmp43_ = gee_collection_get_size ((GeeCollection*) _tmp42_);
		_tmp44_ = _tmp43_;
		_ip_size = _tmp44_;
		_ip_index = -1;
		while (TRUE) {
			gint _tmp45_;
			gint _tmp46_;
			gint _tmp47_;
			GeeList* _tmp48_;
			gint _tmp49_;
			gpointer _tmp50_ = NULL;
			NtkresolvNtkInetAddr* ip;
			guint* _tmp51_;
			gint _tmp51__length1;
			gint _tmp52_;
			guint _tmp53_;
			guint _tmp54_;
			NtkresolvNtkInetAddr* _tmp55_;
			_tmp45_ = _ip_index;
			_ip_index = _tmp45_ + 1;
			_tmp46_ = _ip_index;
			_tmp47_ = _ip_size;
			if (!(_tmp46_ < _tmp47_)) {
				break;
			}
			_tmp48_ = _ip_list;
			_tmp49_ = _ip_index;
			_tmp50_ = gee_list_get (_tmp48_, _tmp49_);
			ip = (NtkresolvNtkInetAddr*) _tmp50_;
			_tmp51_ = pos_ip;
			_tmp51__length1 = pos_ip_length1;
			_tmp52_ = ip_count;
			ip_count = _tmp52_ + 1;
			_tmp53_ = pos;
			_tmp51_[_tmp52_] = _tmp53_;
			_tmp54_ = _tmp51_[_tmp52_];
			_tmp55_ = ip;
			{
				guint8* o_collection = NULL;
				gint o_collection_length1 = 0;
				gint _o_collection_size_ = 0;
				gint o_it = 0;
				o_collection = _tmp55_->addr;
				o_collection_length1 = 4;
				for (o_it = 0; o_it < 4; o_it = o_it + 1) {
					guint8 o = 0U;
					o = o_collection[o_it];
					{
						guint8* _tmp56_;
						guint _tmp57_;
						guint8 _tmp58_;
						guint8 _tmp59_;
						_tmp56_ = buffer;
						_tmp57_ = pos;
						pos = _tmp57_ + 1;
						_tmp58_ = o;
						_tmp56_[_tmp57_] = _tmp58_;
						_tmp59_ = _tmp56_[_tmp57_];
					}
				}
			}
			_g_object_unref0 (ip);
		}
		_g_object_unref0 (_ip_list);
	}
	{
		gint ip_num;
		ip_num = 0;
		{
			gboolean _tmp60_;
			_tmp60_ = TRUE;
			while (TRUE) {
				gboolean _tmp61_;
				gint _tmp63_;
				gint _tmp64_;
				guint8* _tmp65_;
				guint _tmp66_;
				gchar* _tmp67_;
				gchar** _tmp68_;
				guint8* _tmp69_;
				guint* _tmp70_;
				gint _tmp70__length1;
				gint _tmp71_;
				guint _tmp72_;
				gchar* _tmp73_;
				gint _tmp74_;
				guint _tmp76_;
				_tmp61_ = _tmp60_;
				if (!_tmp61_) {
					gint _tmp62_;
					_tmp62_ = ip_num;
					ip_num = _tmp62_ + 1;
				}
				_tmp60_ = FALSE;
				_tmp63_ = ip_num;
				_tmp64_ = ip_count;
				if (!(_tmp63_ < _tmp64_)) {
					break;
				}
				_tmp65_ = buffer;
				_tmp66_ = pos;
				p = ((gchar*) _tmp65_) + _tmp66_;
				_tmp67_ = p;
				x = (gchar**) _tmp67_;
				_tmp68_ = x;
				_tmp69_ = buffer;
				_tmp70_ = pos_ip;
				_tmp70__length1 = pos_ip_length1;
				_tmp71_ = ip_num;
				_tmp72_ = _tmp70_[_tmp71_];
				*_tmp68_ = ((gchar*) _tmp69_) + _tmp72_;
				_tmp73_ = *_tmp68_;
				_tmp74_ = ip_num;
				if (_tmp74_ == 0) {
					gchar** _tmp75_;
					_tmp75_ = x;
					_vala_h_addr_list = _tmp75_;
				}
				_tmp76_ = pos;
				pos = _tmp76_ + ((guint) sizeof (gchar*));
			}
		}
	}
	_tmp77_ = buffer;
	_tmp78_ = pos;
	p = ((gchar*) _tmp77_) + _tmp78_;
	_tmp79_ = p;
	x = (gchar**) _tmp79_;
	_tmp80_ = x;
	*_tmp80_ = NULL;
	_tmp81_ = *_tmp80_;
	_tmp82_ = pos;
	pos = _tmp82_ + ((guint) sizeof (gchar*));
	result = TRUE;
	pos_ip = (g_free (pos_ip), NULL);
	if (h_name) {
		*h_name = _vala_h_name;
	}
	if (h_aliases) {
		*h_aliases = _vala_h_aliases;
	}
	if (h_addr_list) {
		*h_addr_list = _vala_h_addr_list;
	}
	return result;
}


enum nss_status _nss_andna_gethostbyaddr_r (void* addr, socklen_t len, gint type, struct hostent* ret, gchar* buffer, gsize buflen, struct hostent** _result_, gint* h_errnop) {
	enum nss_status result = 0;
	gint _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gboolean _tmp5_ = FALSE;
	gint _tmp6_;
	gboolean _tmp8_;
	GError * _inner_error_ = NULL;
	init ();
	_tmp0_ = type;
	_tmp1_ = g_strdup_printf ("%i", _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat ("addr: type = ", _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	log_debug (_tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	_tmp6_ = type;
	if (_tmp6_ == AF_INET) {
		socklen_t _tmp7_;
		_tmp7_ = len;
		_tmp5_ = ((gulong) _tmp7_) == sizeof (struct in_addr);
	} else {
		_tmp5_ = FALSE;
	}
	_tmp8_ = _tmp5_;
	if (_tmp8_) {
		{
			void* _tmp9_;
			struct in_addr* in_addr;
			struct in_addr* _tmp10_;
			struct hostent* _tmp11_;
			gchar* _tmp12_;
			gsize _tmp13_;
			struct hostent** _tmp14_;
			struct hostent* _tmp15_;
			struct hostent* _tmp16_;
			enum nss_status _tmp17_ = 0;
			_tmp9_ = addr;
			in_addr = _tmp9_;
			_tmp10_ = in_addr;
			_tmp11_ = ret;
			_tmp12_ = buffer;
			_tmp13_ = buflen;
			set_host_ent_from_addr (_tmp10_, _tmp11_, _tmp12_, _tmp13_, NULL, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == NOT_ANDNA_ERROR) {
					goto __catch4_not_andna_error;
				}
				if (_inner_error_->domain == NOT_FOUND_ERROR) {
					goto __catch4_not_found_error;
				}
				if (_inner_error_->domain == BUFFER_ERROR) {
					goto __catch4_buffer_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
			_tmp14_ = _result_;
			_tmp15_ = ret;
			*_tmp14_ = _tmp15_;
			_tmp16_ = *_tmp14_;
			_tmp17_ = return_success ();
			result = _tmp17_;
			return result;
		}
		goto __finally4;
		__catch4_not_andna_error:
		{
			GError* e = NULL;
			gint* _tmp18_;
			enum nss_status _tmp19_ = 0;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp18_ = h_errnop;
			_tmp19_ = return_unavail_eperm (_tmp18_);
			result = _tmp19_;
			_g_error_free0 (e);
			return result;
		}
		goto __finally4;
		__catch4_not_found_error:
		{
			GError* e = NULL;
			gint* _tmp20_;
			enum nss_status _tmp21_ = 0;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp20_ = h_errnop;
			_tmp21_ = return_notfound_eperm (_tmp20_);
			result = _tmp21_;
			_g_error_free0 (e);
			return result;
		}
		goto __finally4;
		__catch4_buffer_error:
		{
			GError* e = NULL;
			gint* _tmp22_;
			enum nss_status _tmp23_ = 0;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp22_ = h_errnop;
			_tmp23_ = return_tryagain_erange (_tmp22_);
			result = _tmp23_;
			_g_error_free0 (e);
			return result;
		}
		__finally4:
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	} else {
		gint* _tmp24_;
		enum nss_status _tmp25_ = 0;
		_tmp24_ = h_errnop;
		_tmp25_ = return_unavail_esrch (_tmp24_);
		result = _tmp25_;
		return result;
	}
}


void set_host_ent_from_addr (struct in_addr* addr, struct hostent* ret, gchar* buffer, gsize buflen, const gchar* service, NtkresolvNtkAddrInfo* hints, GError** error) {
	struct in_addr* _tmp0_;
	guint32* s_addr_p;
	guint8* addr_bytes;
	guint8 _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	guint8 _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	guint8 _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	guint8 _tmp10_;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_;
	guint8 _tmp15_;
	struct hostent* _tmp17_;
	struct hostent* _tmp18_;
	NtkresolvNtkInetAddr* _tmp19_;
	NtkresolvNtkInetAddr* ntk_addr;
	GeeList* resp = NULL;
	gboolean _tmp20_ = FALSE;
	gboolean _tmp21_ = FALSE;
	gboolean _tmp22_ = FALSE;
	guint8 _tmp23_;
	gboolean _tmp25_;
	gboolean _tmp27_;
	gboolean _tmp29_;
	gboolean _tmp31_ = FALSE;
	gboolean _tmp32_ = FALSE;
	gboolean _tmp33_ = FALSE;
	guint8 _tmp34_;
	gboolean _tmp36_;
	gboolean _tmp38_;
	gboolean _tmp40_;
	gchar* h_name = NULL;
	gchar** h_aliases = NULL;
	gchar** h_addr_list = NULL;
	GeeList* _tmp73_;
	NtkresolvNtkInetAddr* _tmp74_;
	gchar* _tmp75_;
	gsize _tmp76_;
	gchar* _tmp77_ = NULL;
	gchar** _tmp78_ = NULL;
	gchar** _tmp79_ = NULL;
	gboolean _tmp80_ = FALSE;
	struct hostent* _tmp82_;
	gchar* _tmp83_;
	struct hostent* _tmp84_;
	gchar** _tmp85_;
	struct hostent* _tmp86_;
	gchar** _tmp87_;
	GError * _inner_error_ = NULL;
	_tmp0_ = addr;
	s_addr_p = &(*_tmp0_).s_addr;
	addr_bytes = (guint8*) s_addr_p;
	_tmp1_ = addr_bytes[0];
	_tmp2_ = g_strdup_printf ("%hhu", _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = addr_bytes[1];
	_tmp5_ = g_strdup_printf ("%hhu", _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = addr_bytes[2];
	_tmp8_ = g_strdup_printf ("%hhu", _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = addr_bytes[3];
	_tmp11_ = g_strdup_printf ("%hhu", _tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strconcat ("addr: ", _tmp3_, ".", _tmp6_, ".", _tmp9_, ".", _tmp12_, NULL);
	_tmp14_ = _tmp13_;
	log_debug (_tmp14_);
	_g_free0 (_tmp14_);
	_g_free0 (_tmp12_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp3_);
	_tmp15_ = addr_bytes[0];
	if (((gint) _tmp15_) != 10) {
		GError* _tmp16_;
		_tmp16_ = g_error_new_literal (NOT_ANDNA_ERROR, NOT_ANDNA_ERROR_GENERIC, "not for ANDNA");
		_inner_error_ = _tmp16_;
		if (((_inner_error_->domain == NOT_ANDNA_ERROR) || (_inner_error_->domain == NOT_FOUND_ERROR)) || (_inner_error_->domain == BUFFER_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	log_debug ("addr: is for andna.");
	_tmp17_ = ret;
	(*_tmp17_).h_addrtype = AF_INET;
	_tmp18_ = ret;
	(*_tmp18_).h_length = 4;
	_tmp19_ = ntkresolv_ntk_inet_addr_new_from_pointer (addr_bytes, (guint16) 0);
	ntk_addr = _tmp19_;
	_tmp23_ = addr_bytes[0];
	if (((gint) _tmp23_) == 10) {
		guint8 _tmp24_;
		_tmp24_ = addr_bytes[1];
		_tmp22_ = ((gint) _tmp24_) == 0;
	} else {
		_tmp22_ = FALSE;
	}
	_tmp25_ = _tmp22_;
	if (_tmp25_) {
		guint8 _tmp26_;
		_tmp26_ = addr_bytes[2];
		_tmp21_ = ((gint) _tmp26_) == 0;
	} else {
		_tmp21_ = FALSE;
	}
	_tmp27_ = _tmp21_;
	if (_tmp27_) {
		guint8 _tmp28_;
		_tmp28_ = addr_bytes[3];
		_tmp20_ = ((gint) _tmp28_) == 0;
	} else {
		_tmp20_ = FALSE;
	}
	_tmp29_ = _tmp20_;
	if (_tmp29_) {
		GError* _tmp30_;
		_tmp30_ = g_error_new_literal (NOT_FOUND_ERROR, NOT_FOUND_ERROR_GENERIC, "IP address not found.");
		_inner_error_ = _tmp30_;
		if (((_inner_error_->domain == NOT_ANDNA_ERROR) || (_inner_error_->domain == NOT_FOUND_ERROR)) || (_inner_error_->domain == BUFFER_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (resp);
			_g_object_unref0 (ntk_addr);
			return;
		} else {
			_g_object_unref0 (resp);
			_g_object_unref0 (ntk_addr);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp34_ = addr_bytes[0];
	if (((gint) _tmp34_) == 10) {
		guint8 _tmp35_;
		_tmp35_ = addr_bytes[1];
		_tmp33_ = ((gint) _tmp35_) == 1;
	} else {
		_tmp33_ = FALSE;
	}
	_tmp36_ = _tmp33_;
	if (_tmp36_) {
		guint8 _tmp37_;
		_tmp37_ = addr_bytes[2];
		_tmp32_ = ((gint) _tmp37_) == 1;
	} else {
		_tmp32_ = FALSE;
	}
	_tmp38_ = _tmp32_;
	if (_tmp38_) {
		guint8 _tmp39_;
		_tmp39_ = addr_bytes[3];
		_tmp31_ = ((gint) _tmp39_) == 1;
	} else {
		_tmp31_ = FALSE;
	}
	_tmp40_ = _tmp31_;
	if (_tmp40_) {
		GeeArrayList* _tmp41_;
		GeeList* _tmp42_;
		_tmp41_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
		_g_object_unref0 (resp);
		resp = (GeeList*) _tmp41_;
		_tmp42_ = resp;
		gee_collection_add ((GeeCollection*) _tmp42_, "presente");
	} else {
		GeeList* _tmp54_;
		gint _tmp55_;
		gint _tmp56_;
		{
			const gchar* _tmp43_;
			_tmp43_ = andnaserver;
			if (_tmp43_ == NULL) {
				NtkresolvNtkInetAddr* _tmp44_;
				GeeList* _tmp45_ = NULL;
				GeeList* _tmp46_;
				_tmp44_ = ntk_addr;
				_tmp45_ = ntkresolv_inverse (NTKRESOLV_IP_FAMILY_IPV4, (NtkresolvNtkAddr*) _tmp44_, "127.0.0.1", &_inner_error_);
				_tmp46_ = _tmp45_;
				if (_inner_error_ != NULL) {
					goto __catch5_g_error;
				}
				_g_object_unref0 (resp);
				resp = _tmp46_;
			} else {
				NtkresolvNtkInetAddr* _tmp47_;
				const gchar* _tmp48_;
				GeeList* _tmp49_ = NULL;
				GeeList* _tmp50_;
				_tmp47_ = ntk_addr;
				_tmp48_ = andnaserver;
				_tmp49_ = ntkresolv_inverse (NTKRESOLV_IP_FAMILY_IPV4, (NtkresolvNtkAddr*) _tmp47_, _tmp48_, &_inner_error_);
				_tmp50_ = _tmp49_;
				if (_inner_error_ != NULL) {
					goto __catch5_g_error;
				}
				_g_object_unref0 (resp);
				resp = _tmp50_;
			}
		}
		goto __finally5;
		__catch5_g_error:
		{
			GError* e = NULL;
			GError* _tmp51_;
			const gchar* _tmp52_;
			GError* _tmp53_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp51_ = e;
			_tmp52_ = _tmp51_->message;
			_tmp53_ = g_error_new_literal (NOT_FOUND_ERROR, NOT_FOUND_ERROR_GENERIC, _tmp52_);
			_inner_error_ = _tmp53_;
			_g_error_free0 (e);
			goto __finally5;
		}
		__finally5:
		if (_inner_error_ != NULL) {
			if (((_inner_error_->domain == NOT_ANDNA_ERROR) || (_inner_error_->domain == NOT_FOUND_ERROR)) || (_inner_error_->domain == BUFFER_ERROR)) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (resp);
				_g_object_unref0 (ntk_addr);
				return;
			} else {
				_g_object_unref0 (resp);
				_g_object_unref0 (ntk_addr);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp54_ = resp;
		_tmp55_ = gee_collection_get_size ((GeeCollection*) _tmp54_);
		_tmp56_ = _tmp55_;
		if (_tmp56_ == 0) {
			GError* _tmp57_;
			_tmp57_ = g_error_new_literal (NOT_FOUND_ERROR, NOT_FOUND_ERROR_GENERIC, "IP address not found.");
			_inner_error_ = _tmp57_;
			if (((_inner_error_->domain == NOT_ANDNA_ERROR) || (_inner_error_->domain == NOT_FOUND_ERROR)) || (_inner_error_->domain == BUFFER_ERROR)) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (resp);
				_g_object_unref0 (ntk_addr);
				return;
			} else {
				_g_object_unref0 (resp);
				_g_object_unref0 (ntk_addr);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp58_;
			_tmp58_ = TRUE;
			while (TRUE) {
				gboolean _tmp59_;
				gint _tmp61_;
				GeeList* _tmp62_;
				gint _tmp63_;
				gint _tmp64_;
				GeeList* _tmp65_;
				gint _tmp66_;
				GeeList* _tmp67_;
				gint _tmp68_;
				gpointer _tmp69_ = NULL;
				gchar* _tmp70_;
				gchar* _tmp71_;
				gchar* _tmp72_;
				_tmp59_ = _tmp58_;
				if (!_tmp59_) {
					gint _tmp60_;
					_tmp60_ = i;
					i = _tmp60_ + 1;
				}
				_tmp58_ = FALSE;
				_tmp61_ = i;
				_tmp62_ = resp;
				_tmp63_ = gee_collection_get_size ((GeeCollection*) _tmp62_);
				_tmp64_ = _tmp63_;
				if (!(_tmp61_ < _tmp64_)) {
					break;
				}
				_tmp65_ = resp;
				_tmp66_ = i;
				_tmp67_ = resp;
				_tmp68_ = i;
				_tmp69_ = gee_list_get (_tmp67_, _tmp68_);
				_tmp70_ = (gchar*) _tmp69_;
				_tmp71_ = g_strconcat (_tmp70_, ".NTK", NULL);
				_tmp72_ = _tmp71_;
				gee_list_set (_tmp65_, _tmp66_, _tmp72_);
				_g_free0 (_tmp72_);
				_g_free0 (_tmp70_);
			}
		}
	}
	_tmp73_ = resp;
	_tmp74_ = ntk_addr;
	_tmp75_ = buffer;
	_tmp76_ = buflen;
	_tmp80_ = prepare_buffer_from_addr (_tmp73_, _tmp74_, (guint8*) _tmp75_, (guint) _tmp76_, &_tmp77_, &_tmp78_, &_tmp79_);
	h_name = _tmp77_;
	h_aliases = _tmp78_;
	h_addr_list = _tmp79_;
	if (!_tmp80_) {
		GError* _tmp81_;
		_tmp81_ = g_error_new_literal (BUFFER_ERROR, BUFFER_ERROR_GENERIC, "Not enough space.");
		_inner_error_ = _tmp81_;
		if (((_inner_error_->domain == NOT_ANDNA_ERROR) || (_inner_error_->domain == NOT_FOUND_ERROR)) || (_inner_error_->domain == BUFFER_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (resp);
			_g_object_unref0 (ntk_addr);
			return;
		} else {
			_g_object_unref0 (resp);
			_g_object_unref0 (ntk_addr);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp82_ = ret;
	_tmp83_ = h_name;
	(*_tmp82_).h_name = (const gchar*) _tmp83_;
	_tmp84_ = ret;
	_tmp85_ = h_aliases;
	(*_tmp84_).h_aliases = (gchar**) _tmp85_;
	_tmp86_ = ret;
	_tmp87_ = h_addr_list;
	(*_tmp86_).h_addr_list = (gchar**) _tmp87_;
	_g_object_unref0 (resp);
	_g_object_unref0 (ntk_addr);
}


gboolean prepare_buffer_from_addr (GeeList* names, NtkresolvNtkInetAddr* ip, guint8* buffer, guint buflen, gchar** h_name, gchar*** h_aliases, gchar*** h_addr_list) {
	gchar* _vala_h_name = NULL;
	gchar** _vala_h_aliases = NULL;
	gchar** _vala_h_addr_list = NULL;
	gboolean result = FALSE;
	GeeList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint ipsize;
	GeeList* _tmp10_;
	gpointer _tmp11_ = NULL;
	gchar* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	guint _tmp15_;
	guint minima;
	guint _tmp16_;
	guint _tmp33_;
	guint _tmp34_;
	guint _tmp35_;
	guint _tmp36_;
	guint _tmp37_;
	guint _tmp38_;
	guint _tmp39_;
	gchar** x = NULL;
	gchar* p = NULL;
	guint pos;
	GeeList* _tmp40_;
	gint _tmp41_;
	gint _tmp42_;
	guint* _tmp43_ = NULL;
	guint* pos_alias;
	gint pos_alias_length1;
	gint _pos_alias_size_;
	guint8* _tmp44_;
	guint _tmp45_;
	gchar* _tmp46_;
	GeeList* _tmp47_;
	gpointer _tmp48_ = NULL;
	gchar* canonical_name;
	const gchar* _tmp49_;
	guint8* _tmp50_;
	gint _tmp50__length1;
	guint8* _tmp51_;
	gint _tmp51__length1;
	guint8* _tmp56_;
	guint _tmp57_;
	guint8 _tmp58_;
	guint8* _tmp102_;
	guint _tmp103_;
	gchar* _tmp104_;
	gchar** _tmp105_;
	gchar* _tmp106_;
	gchar** _tmp107_;
	guint _tmp108_;
	guint _tmp109_;
	guint _tmp110_;
	guint _tmp111_;
	guint pos_ip;
	NtkresolvNtkInetAddr* _tmp112_;
	guint8* _tmp117_;
	guint _tmp118_;
	gchar* _tmp119_;
	gchar** _tmp120_;
	guint8* _tmp121_;
	guint _tmp122_;
	gchar* _tmp123_;
	guint _tmp124_;
	guint8* _tmp125_;
	guint _tmp126_;
	gchar* _tmp127_;
	gchar** _tmp128_;
	gchar* _tmp129_;
	guint _tmp130_;
	g_return_val_if_fail (names != NULL, FALSE);
	g_return_val_if_fail (ip != NULL, FALSE);
	_tmp0_ = names;
	_tmp1_ = gee_collection_get_size ((GeeCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	_vala_assert (_tmp2_ > 0, "names.size > 0");
	{
		guint i;
		i = (guint) 0;
		{
			gboolean _tmp3_;
			_tmp3_ = TRUE;
			while (TRUE) {
				gboolean _tmp4_;
				guint _tmp6_;
				guint8* _tmp7_;
				guint _tmp8_;
				guint8 _tmp9_;
				_tmp4_ = _tmp3_;
				if (!_tmp4_) {
					guint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp6_ = i;
				if (!(_tmp6_ < ((guint) 1024))) {
					break;
				}
				_tmp7_ = buffer;
				_tmp8_ = i;
				_tmp7_[_tmp8_] = (guint8) ' ';
				_tmp9_ = _tmp7_[_tmp8_];
			}
		}
	}
	ipsize = ((guint) sizeof (guint8)) * 4;
	_tmp10_ = names;
	_tmp11_ = gee_list_get (_tmp10_, 0);
	_tmp12_ = (gchar*) _tmp11_;
	_tmp13_ = strlen (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = (guint) _tmp14_;
	_g_free0 (_tmp12_);
	minima = _tmp15_;
	_tmp16_ = minima;
	minima = _tmp16_ + 1;
	{
		gint i;
		i = 1;
		{
			gboolean _tmp17_;
			_tmp17_ = TRUE;
			while (TRUE) {
				gboolean _tmp18_;
				gint _tmp20_;
				GeeList* _tmp21_;
				gint _tmp22_;
				gint _tmp23_;
				guint _tmp24_;
				GeeList* _tmp25_;
				gint _tmp26_;
				gpointer _tmp27_ = NULL;
				gchar* _tmp28_;
				gint _tmp29_;
				gint _tmp30_;
				guint _tmp31_;
				guint _tmp32_;
				_tmp18_ = _tmp17_;
				if (!_tmp18_) {
					gint _tmp19_;
					_tmp19_ = i;
					i = _tmp19_ + 1;
				}
				_tmp17_ = FALSE;
				_tmp20_ = i;
				_tmp21_ = names;
				_tmp22_ = gee_collection_get_size ((GeeCollection*) _tmp21_);
				_tmp23_ = _tmp22_;
				if (!(_tmp20_ < _tmp23_)) {
					break;
				}
				_tmp24_ = minima;
				_tmp25_ = names;
				_tmp26_ = i;
				_tmp27_ = gee_list_get (_tmp25_, _tmp26_);
				_tmp28_ = (gchar*) _tmp27_;
				_tmp29_ = strlen (_tmp28_);
				_tmp30_ = _tmp29_;
				minima = _tmp24_ + _tmp30_;
				_g_free0 (_tmp28_);
				_tmp31_ = minima;
				minima = _tmp31_ + 1;
				_tmp32_ = minima;
				minima = _tmp32_ + ((guint) sizeof (gchar*));
			}
		}
	}
	_tmp33_ = minima;
	minima = _tmp33_ + ((guint) sizeof (gchar*));
	_tmp34_ = minima;
	minima = _tmp34_ + ((guint) sizeof (guint32));
	_tmp35_ = minima;
	_tmp36_ = ipsize;
	minima = _tmp35_ + (_tmp36_ + ((guint) sizeof (gchar*)));
	_tmp37_ = minima;
	minima = _tmp37_ + ((guint) sizeof (gchar*));
	_tmp38_ = buflen;
	_tmp39_ = minima;
	if (_tmp38_ < _tmp39_) {
		result = FALSE;
		if (h_name) {
			*h_name = _vala_h_name;
		}
		if (h_aliases) {
			*h_aliases = _vala_h_aliases;
		}
		if (h_addr_list) {
			*h_addr_list = _vala_h_addr_list;
		}
		return result;
	}
	pos = (guint) 0;
	_tmp40_ = names;
	_tmp41_ = gee_collection_get_size ((GeeCollection*) _tmp40_);
	_tmp42_ = _tmp41_;
	_tmp43_ = g_new0 (guint, _tmp42_ - 1);
	pos_alias = _tmp43_;
	pos_alias_length1 = _tmp42_ - 1;
	_pos_alias_size_ = pos_alias_length1;
	_tmp44_ = buffer;
	_tmp45_ = pos;
	p = ((gchar*) _tmp44_) + _tmp45_;
	_tmp46_ = p;
	_vala_h_name = _tmp46_;
	_tmp47_ = names;
	_tmp48_ = gee_list_get (_tmp47_, 0);
	canonical_name = (gchar*) _tmp48_;
	_tmp49_ = canonical_name;
	_tmp50_ = string_get_data (_tmp49_, &_tmp50__length1);
	_tmp51_ = _tmp50_;
	_tmp51__length1 = _tmp50__length1;
	{
		guint8* o_collection = NULL;
		gint o_collection_length1 = 0;
		gint _o_collection_size_ = 0;
		gint o_it = 0;
		o_collection = _tmp51_;
		o_collection_length1 = _tmp51__length1;
		for (o_it = 0; o_it < _tmp51__length1; o_it = o_it + 1) {
			guint8 o = 0U;
			o = o_collection[o_it];
			{
				guint8* _tmp52_;
				guint _tmp53_;
				guint8 _tmp54_;
				guint8 _tmp55_;
				_tmp52_ = buffer;
				_tmp53_ = pos;
				pos = _tmp53_ + 1;
				_tmp54_ = o;
				_tmp52_[_tmp53_] = _tmp54_;
				_tmp55_ = _tmp52_[_tmp53_];
			}
		}
	}
	_tmp56_ = buffer;
	_tmp57_ = pos;
	pos = _tmp57_ + 1;
	_tmp56_[_tmp57_] = (guint8) '\0';
	_tmp58_ = _tmp56_[_tmp57_];
	{
		gint i;
		i = 1;
		{
			gboolean _tmp59_;
			_tmp59_ = TRUE;
			while (TRUE) {
				gboolean _tmp60_;
				gint _tmp62_;
				GeeList* _tmp63_;
				gint _tmp64_;
				gint _tmp65_;
				GeeList* _tmp66_;
				gint _tmp67_;
				gpointer _tmp68_ = NULL;
				gchar* alias_name;
				guint* _tmp69_;
				gint _tmp69__length1;
				gint _tmp70_;
				guint _tmp71_;
				guint _tmp72_;
				const gchar* _tmp73_;
				guint8* _tmp74_;
				gint _tmp74__length1;
				guint8* _tmp75_;
				gint _tmp75__length1;
				guint8* _tmp80_;
				guint _tmp81_;
				guint8 _tmp82_;
				_tmp60_ = _tmp59_;
				if (!_tmp60_) {
					gint _tmp61_;
					_tmp61_ = i;
					i = _tmp61_ + 1;
				}
				_tmp59_ = FALSE;
				_tmp62_ = i;
				_tmp63_ = names;
				_tmp64_ = gee_collection_get_size ((GeeCollection*) _tmp63_);
				_tmp65_ = _tmp64_;
				if (!(_tmp62_ < _tmp65_)) {
					break;
				}
				_tmp66_ = names;
				_tmp67_ = i;
				_tmp68_ = gee_list_get (_tmp66_, _tmp67_);
				alias_name = (gchar*) _tmp68_;
				_tmp69_ = pos_alias;
				_tmp69__length1 = pos_alias_length1;
				_tmp70_ = i;
				_tmp71_ = pos;
				_tmp69_[_tmp70_ - 1] = _tmp71_;
				_tmp72_ = _tmp69_[_tmp70_ - 1];
				_tmp73_ = alias_name;
				_tmp74_ = string_get_data (_tmp73_, &_tmp74__length1);
				_tmp75_ = _tmp74_;
				_tmp75__length1 = _tmp74__length1;
				{
					guint8* o_collection = NULL;
					gint o_collection_length1 = 0;
					gint _o_collection_size_ = 0;
					gint o_it = 0;
					o_collection = _tmp75_;
					o_collection_length1 = _tmp75__length1;
					for (o_it = 0; o_it < _tmp75__length1; o_it = o_it + 1) {
						guint8 o = 0U;
						o = o_collection[o_it];
						{
							guint8* _tmp76_;
							guint _tmp77_;
							guint8 _tmp78_;
							guint8 _tmp79_;
							_tmp76_ = buffer;
							_tmp77_ = pos;
							pos = _tmp77_ + 1;
							_tmp78_ = o;
							_tmp76_[_tmp77_] = _tmp78_;
							_tmp79_ = _tmp76_[_tmp77_];
						}
					}
				}
				_tmp80_ = buffer;
				_tmp81_ = pos;
				pos = _tmp81_ + 1;
				_tmp80_[_tmp81_] = (guint8) '\0';
				_tmp82_ = _tmp80_[_tmp81_];
				_g_free0 (alias_name);
			}
		}
	}
	{
		gint i;
		i = 1;
		{
			gboolean _tmp83_;
			_tmp83_ = TRUE;
			while (TRUE) {
				gboolean _tmp84_;
				gint _tmp86_;
				GeeList* _tmp87_;
				gint _tmp88_;
				gint _tmp89_;
				guint8* _tmp90_;
				guint _tmp91_;
				gchar* _tmp92_;
				gchar** _tmp93_;
				guint8* _tmp94_;
				guint* _tmp95_;
				gint _tmp95__length1;
				gint _tmp96_;
				guint _tmp97_;
				gchar* _tmp98_;
				gint _tmp99_;
				guint _tmp101_;
				_tmp84_ = _tmp83_;
				if (!_tmp84_) {
					gint _tmp85_;
					_tmp85_ = i;
					i = _tmp85_ + 1;
				}
				_tmp83_ = FALSE;
				_tmp86_ = i;
				_tmp87_ = names;
				_tmp88_ = gee_collection_get_size ((GeeCollection*) _tmp87_);
				_tmp89_ = _tmp88_;
				if (!(_tmp86_ < _tmp89_)) {
					break;
				}
				_tmp90_ = buffer;
				_tmp91_ = pos;
				p = ((gchar*) _tmp90_) + _tmp91_;
				_tmp92_ = p;
				x = (gchar**) _tmp92_;
				_tmp93_ = x;
				_tmp94_ = buffer;
				_tmp95_ = pos_alias;
				_tmp95__length1 = pos_alias_length1;
				_tmp96_ = i;
				_tmp97_ = _tmp95_[_tmp96_ - 1];
				*_tmp93_ = ((gchar*) _tmp94_) + _tmp97_;
				_tmp98_ = *_tmp93_;
				_tmp99_ = i;
				if (_tmp99_ == 1) {
					gchar** _tmp100_;
					_tmp100_ = x;
					_vala_h_addr_list = _tmp100_;
				}
				_tmp101_ = pos;
				pos = _tmp101_ + ((guint) sizeof (gchar*));
			}
		}
	}
	_tmp102_ = buffer;
	_tmp103_ = pos;
	p = ((gchar*) _tmp102_) + _tmp103_;
	_tmp104_ = p;
	x = (gchar**) _tmp104_;
	_tmp105_ = x;
	*_tmp105_ = NULL;
	_tmp106_ = *_tmp105_;
	_tmp107_ = x;
	_vala_h_aliases = _tmp107_;
	_tmp108_ = pos;
	pos = _tmp108_ + ((guint) sizeof (gchar*));
	_tmp109_ = pos;
	_tmp110_ = pos;
	pos = _tmp109_ + (((guint) sizeof (void*)) - (_tmp110_ % ((guint) sizeof (void*))));
	_tmp111_ = pos;
	pos_ip = _tmp111_;
	_tmp112_ = ip;
	{
		guint8* o_collection = NULL;
		gint o_collection_length1 = 0;
		gint _o_collection_size_ = 0;
		gint o_it = 0;
		o_collection = _tmp112_->addr;
		o_collection_length1 = 4;
		for (o_it = 0; o_it < 4; o_it = o_it + 1) {
			guint8 o = 0U;
			o = o_collection[o_it];
			{
				guint8* _tmp113_;
				guint _tmp114_;
				guint8 _tmp115_;
				guint8 _tmp116_;
				_tmp113_ = buffer;
				_tmp114_ = pos;
				pos = _tmp114_ + 1;
				_tmp115_ = o;
				_tmp113_[_tmp114_] = _tmp115_;
				_tmp116_ = _tmp113_[_tmp114_];
			}
		}
	}
	_tmp117_ = buffer;
	_tmp118_ = pos;
	p = ((gchar*) _tmp117_) + _tmp118_;
	_tmp119_ = p;
	x = (gchar**) _tmp119_;
	_tmp120_ = x;
	_tmp121_ = buffer;
	_tmp122_ = pos_ip;
	*_tmp120_ = ((gchar*) _tmp121_) + _tmp122_;
	_tmp123_ = *_tmp120_;
	_tmp124_ = pos;
	pos = _tmp124_ + ((guint) sizeof (gchar*));
	_tmp125_ = buffer;
	_tmp126_ = pos;
	p = ((gchar*) _tmp125_) + _tmp126_;
	_tmp127_ = p;
	x = (gchar**) _tmp127_;
	_tmp128_ = x;
	*_tmp128_ = NULL;
	_tmp129_ = *_tmp128_;
	_tmp130_ = pos;
	pos = _tmp130_ + ((guint) sizeof (gchar*));
	result = TRUE;
	_g_free0 (canonical_name);
	pos_alias = (g_free (pos_alias), NULL);
	if (h_name) {
		*h_name = _vala_h_name;
	}
	if (h_aliases) {
		*h_aliases = _vala_h_aliases;
	}
	if (h_addr_list) {
		*h_addr_list = _vala_h_addr_list;
	}
	return result;
}



