/*
 *  This file is part of Netsukuku.
 *  (c) Copyright 2013 Luca Dionisi aka lukisi <luca.dionisi@gmail.com>
 *
 *  Netsukuku is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Netsukuku is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Netsukuku.  If not, see <http://www.gnu.org/licenses/>.
 */

using Gtk;
using Gee;
using zcd;
using Netsukuku;

namespace Monitor
{
    public class NodeCoordinator : Object
    {
        private AddressManagerFakeRmtGetter client_getter;
        private InfoNode info_node;
        private SpinButton txt_lvl;
        private Label lbl_info;

        public NodeCoordinator(Builder builder, Box box_parent, AddressManagerFakeRmtGetter client_getter)
        {
            this.client_getter = client_getter;
            builder.connect_signals (this);
            txt_lvl = builder.get_object ("txt_lvl") as SpinButton;
            lbl_info = builder.get_object ("lbl_info") as Label;
            Widget widget_coordinator = builder.get_object ("widget_root") as Widget;
            widget_coordinator.reparent(box_parent);

            info_node = client_getter.get_client().maproute.report_yourself();
        }

        private int impl_start_operations()
        {
            while (true)
            {
                try { refresh_coordinator();
                } catch (Error e) {}

                if (nap_until_condition(1000,
                    () => {
                        return t_op_aborting;
                    })) break;
            }
            return 0;
        }

        private Thread<int>? t_op;
        private bool t_op_aborting;
        public void start_operations()
        {
            if (t_op == null)
            {
                t_op_aborting = false;
                t_op = new Thread<int>(null, impl_start_operations);
            }
        }

        public void stop_operations()
        {
            if (t_op != null)
            {
                t_op_aborting = true;
                t_op.join();
                t_op = null;
            }
        }

        /** retrieve and display data
          */
        private void refresh_coordinator() throws Error
        {
            try
            {
                AsyncQueue<int> q = new AsyncQueue<int>();
                MainContext.@default().invoke(() => {
                        txt_lvl.adjustment.upper = info_node.levels;
                        q.push(txt_lvl.get_value_as_int());
                        return false;});
                int lvl = q.pop();

                CoordinatorInfo ret = client_getter.get_client().coordinator.report_status(lvl);
                string info = @"Last Eldership $(ret.last_assigned_eldership), Reserved [";
                foreach (int b in ret.pos) info += @"$(b), ";
                info += "]";
                MainContext.@default().invoke(() => {
                        lbl_info.label = info;
                        return false;});
            }
            catch (Error e)
            {
                string e_message = e.message;
                MainContext.@default().invoke(() => {lbl_info.label = e_message; return false;});
            }
        }
    }
}
