/* tunnel.c generated by valac 0.20.1, the Vala compiler
 * generated from tunnel.vala, do not modify */

/*
 *  This file is part of Netsukuku.
 *  (c) Copyright 2011 Luca Dionisi aka lukisi <luca.dionisi@gmail.com>
 *
 *  Netsukuku is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Netsukuku is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Netsukuku.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <zcd.h>
#include <stdlib.h>
#include <string.h>
#include <netsukuku-rpc.h>
#include <gee.h>
#include <tasklet.h>
#include <math.h>
#include <float.h>


#define NETSUKUKU_TYPE_BASE_TUNNEL (netsukuku_base_tunnel_get_type ())
#define NETSUKUKU_BASE_TUNNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_BASE_TUNNEL, NetsukukuBaseTunnel))
#define NETSUKUKU_BASE_TUNNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_BASE_TUNNEL, NetsukukuBaseTunnelClass))
#define NETSUKUKU_IS_BASE_TUNNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_BASE_TUNNEL))
#define NETSUKUKU_IS_BASE_TUNNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_BASE_TUNNEL))
#define NETSUKUKU_BASE_TUNNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_BASE_TUNNEL, NetsukukuBaseTunnelClass))

typedef struct _NetsukukuBaseTunnel NetsukukuBaseTunnel;
typedef struct _NetsukukuBaseTunnelClass NetsukukuBaseTunnelClass;
typedef struct _NetsukukuBaseTunnelPrivate NetsukukuBaseTunnelPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define NETSUKUKU_TYPE_DUMMY_TUNNEL (netsukuku_dummy_tunnel_get_type ())
#define NETSUKUKU_DUMMY_TUNNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_DUMMY_TUNNEL, NetsukukuDummyTunnel))
#define NETSUKUKU_DUMMY_TUNNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_DUMMY_TUNNEL, NetsukukuDummyTunnelClass))
#define NETSUKUKU_IS_DUMMY_TUNNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_DUMMY_TUNNEL))
#define NETSUKUKU_IS_DUMMY_TUNNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_DUMMY_TUNNEL))
#define NETSUKUKU_DUMMY_TUNNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_DUMMY_TUNNEL, NetsukukuDummyTunnelClass))

typedef struct _NetsukukuDummyTunnel NetsukukuDummyTunnel;
typedef struct _NetsukukuDummyTunnelClass NetsukukuDummyTunnelClass;
typedef struct _NetsukukuDummyTunnelPrivate NetsukukuDummyTunnelPrivate;

#define NETSUKUKU_TYPE_STRUCT_HELPER_TUNNELMANAGER_INITIATE (netsukuku_struct_helper_tunnelmanager_initiate_get_type ())

#define NETSUKUKU_TYPE_TUNNEL_MANAGER (netsukuku_tunnel_manager_get_type ())
#define NETSUKUKU_TUNNEL_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_TUNNEL_MANAGER, NetsukukuTunnelManager))
#define NETSUKUKU_TUNNEL_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_TUNNEL_MANAGER, NetsukukuTunnelManagerClass))
#define NETSUKUKU_IS_TUNNEL_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_TUNNEL_MANAGER))
#define NETSUKUKU_IS_TUNNEL_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_TUNNEL_MANAGER))
#define NETSUKUKU_TUNNEL_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_TUNNEL_MANAGER, NetsukukuTunnelManagerClass))

typedef struct _NetsukukuTunnelManager NetsukukuTunnelManager;
typedef struct _NetsukukuTunnelManagerClass NetsukukuTunnelManagerClass;
typedef struct _Netsukukustruct_helper_TunnelManager_initiate Netsukukustruct_helper_TunnelManager_initiate;

#define NETSUKUKU_TYPE_TUNNEL_INFO (netsukuku_tunnel_info_get_type ())
#define NETSUKUKU_TUNNEL_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_TUNNEL_INFO, NetsukukuTunnelInfo))
#define NETSUKUKU_TUNNEL_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_TUNNEL_INFO, NetsukukuTunnelInfoClass))
#define NETSUKUKU_IS_TUNNEL_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_TUNNEL_INFO))
#define NETSUKUKU_IS_TUNNEL_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_TUNNEL_INFO))
#define NETSUKUKU_TUNNEL_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_TUNNEL_INFO, NetsukukuTunnelInfoClass))

typedef struct _NetsukukuTunnelInfo NetsukukuTunnelInfo;
typedef struct _NetsukukuTunnelInfoClass NetsukukuTunnelInfoClass;
typedef struct _NetsukukuTunnelInfoPrivate NetsukukuTunnelInfoPrivate;
typedef struct _NetsukukuTunnelManagerPrivate NetsukukuTunnelManagerPrivate;
typedef struct _Block7Data Block7Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block8Data Block8Data;
typedef struct _Block9Data Block9Data;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef void (*NetsukukuCallbackSendDelegate) (zcdISerializable* msg, void* user_data, GError** error);
typedef zcdISerializable* (*NetsukukuCallbackRecvDelegate) (void* user_data, GError** error);
struct _NetsukukuBaseTunnel {
	GObject parent_instance;
	NetsukukuBaseTunnelPrivate * priv;
};

struct _NetsukukuBaseTunnelClass {
	GObjectClass parent_class;
	gchar* (*request) (NetsukukuBaseTunnel* self, NetsukukuCallbackSendDelegate cb_send, void* cb_send_target, NetsukukuCallbackRecvDelegate cb_recv, void* cb_recv_target, const gchar* my_address, const gchar* dest_address, GError** error);
	gchar* (*serve) (NetsukukuBaseTunnel* self, NetsukukuCallbackSendDelegate cb_send, void* cb_send_target, NetsukukuCallbackRecvDelegate cb_recv, void* cb_recv_target, const gchar* my_address, const gchar* dest_address, GError** error);
	void (*close) (NetsukukuBaseTunnel* self, const gchar* nic_name, const gchar* my_address, const gchar* dest_address, GError** error);
};

typedef NetsukukuBaseTunnel* (*NetsukukuCreateTunnelDelegate) (void* user_data);
struct _NetsukukuDummyTunnel {
	NetsukukuBaseTunnel parent_instance;
	NetsukukuDummyTunnelPrivate * priv;
};

struct _NetsukukuDummyTunnelClass {
	NetsukukuBaseTunnelClass parent_class;
};

struct _Netsukukustruct_helper_TunnelManager_initiate {
	NetsukukuTunnelManager* self;
	gchar* dest_addr;
	gchar* my_addr;
	gint peer_handler_id;
	gint my_handler_id;
};

struct _NetsukukuTunnelInfo {
	GObject parent_instance;
	NetsukukuTunnelInfoPrivate * priv;
};

struct _NetsukukuTunnelInfoClass {
	GObjectClass parent_class;
};

struct _NetsukukuTunnelInfoPrivate {
	gchar* _nic_name;
	gchar* _my_addr;
	gchar* _dest_addr;
};

struct _NetsukukuTunnelManager {
	GObject parent_instance;
	NetsukukuTunnelManagerPrivate * priv;
};

struct _NetsukukuTunnelManagerClass {
	GObjectClass parent_class;
};

struct _NetsukukuTunnelManagerPrivate {
	gchar* _my_addr;
	GeeHashMap* handlers;
	GeeHashMap* active_tunnels;
};

struct _Block7Data {
	int _ref_count_;
	NetsukukuTunnelManager * self;
	NetsukukuAddressManagerTCPClient* peer_client;
	gint peer_handler_id;
	gint my_handler_id;
};

struct _Block8Data {
	int _ref_count_;
	NetsukukuTunnelManager * self;
	NetsukukuAddressManagerTCPClient* peer_server;
};

struct _Block9Data {
	int _ref_count_;
	Block8Data * _data8_;
	gint my_handler_id;
	gint peer_handler_id;
};


static gpointer netsukuku_base_tunnel_parent_class = NULL;
static NetsukukuCreateTunnelDelegate netsukuku_base_tunnel_registered_class_linux;
static gpointer netsukuku_base_tunnel_registered_class_linux_target;
static GDestroyNotify netsukuku_base_tunnel_registered_class_linux_target_destroy_notify;
static NetsukukuCreateTunnelDelegate netsukuku_base_tunnel_registered_class_linux = NULL;
static gpointer netsukuku_base_tunnel_registered_class_linux_target = NULL;
static GDestroyNotify netsukuku_base_tunnel_registered_class_linux_target_destroy_notify = NULL;
static NetsukukuBaseTunnel* netsukuku_base_tunnel__instance;
static NetsukukuBaseTunnel* netsukuku_base_tunnel__instance = NULL;
static gpointer netsukuku_dummy_tunnel_parent_class = NULL;
static gpointer netsukuku_tunnel_info_parent_class = NULL;
static gpointer netsukuku_tunnel_manager_parent_class = NULL;
static NetsukukuITunnelManagerIface* netsukuku_tunnel_manager_netsukuku_itunnel_manager_parent_iface = NULL;

GType netsukuku_base_tunnel_get_type (void) G_GNUC_CONST;
enum  {
	NETSUKUKU_BASE_TUNNEL_DUMMY_PROPERTY
};
void netsukuku_base_tunnel_register_class (const gchar* k, NetsukukuCreateTunnelDelegate create_new_nic, void* create_new_nic_target);
NetsukukuBaseTunnel* netsukuku_base_tunnel_create_instance (void);
const gchar* netsukuku_settings_get_NETWORK_IMPLEMENTATION (void);
NetsukukuBaseTunnel* netsukuku_base_tunnel_get_instance (void);
NetsukukuBaseTunnel* netsukuku_base_tunnel_construct (GType object_type);
gchar* netsukuku_base_tunnel_request (NetsukukuBaseTunnel* self, NetsukukuCallbackSendDelegate cb_send, void* cb_send_target, NetsukukuCallbackRecvDelegate cb_recv, void* cb_recv_target, const gchar* my_address, const gchar* dest_address, GError** error);
static gchar* netsukuku_base_tunnel_real_request (NetsukukuBaseTunnel* self, NetsukukuCallbackSendDelegate cb_send, void* cb_send_target, NetsukukuCallbackRecvDelegate cb_recv, void* cb_recv_target, const gchar* my_address, const gchar* dest_address, GError** error);
gchar* netsukuku_base_tunnel_serve (NetsukukuBaseTunnel* self, NetsukukuCallbackSendDelegate cb_send, void* cb_send_target, NetsukukuCallbackRecvDelegate cb_recv, void* cb_recv_target, const gchar* my_address, const gchar* dest_address, GError** error);
static gchar* netsukuku_base_tunnel_real_serve (NetsukukuBaseTunnel* self, NetsukukuCallbackSendDelegate cb_send, void* cb_send_target, NetsukukuCallbackRecvDelegate cb_recv, void* cb_recv_target, const gchar* my_address, const gchar* dest_address, GError** error);
void netsukuku_base_tunnel_close (NetsukukuBaseTunnel* self, const gchar* nic_name, const gchar* my_address, const gchar* dest_address, GError** error);
static void netsukuku_base_tunnel_real_close (NetsukukuBaseTunnel* self, const gchar* nic_name, const gchar* my_address, const gchar* dest_address, GError** error);
static void netsukuku_base_tunnel_finalize (GObject* obj);
GType netsukuku_dummy_tunnel_get_type (void) G_GNUC_CONST;
enum  {
	NETSUKUKU_DUMMY_TUNNEL_DUMMY_PROPERTY
};
NetsukukuDummyTunnel* netsukuku_dummy_tunnel_new (void);
NetsukukuDummyTunnel* netsukuku_dummy_tunnel_construct (GType object_type);
static gchar* netsukuku_dummy_tunnel_real_serve (NetsukukuBaseTunnel* base, NetsukukuCallbackSendDelegate cb_send, void* cb_send_target, NetsukukuCallbackRecvDelegate cb_recv, void* cb_recv_target, const gchar* my_address, const gchar* dest_address, GError** error);
static gchar* netsukuku_dummy_tunnel_real_request (NetsukukuBaseTunnel* base, NetsukukuCallbackSendDelegate cb_send, void* cb_send_target, NetsukukuCallbackRecvDelegate cb_recv, void* cb_recv_target, const gchar* my_address, const gchar* dest_address, GError** error);
static void netsukuku_dummy_tunnel_real_close (NetsukukuBaseTunnel* base, const gchar* nic_name, const gchar* my_address, const gchar* dest_address, GError** error);
GType netsukuku_struct_helper_tunnelmanager_initiate_get_type (void) G_GNUC_CONST;
GType netsukuku_tunnel_manager_get_type (void) G_GNUC_CONST;
Netsukukustruct_helper_TunnelManager_initiate* netsukuku_struct_helper_tunnelmanager_initiate_dup (const Netsukukustruct_helper_TunnelManager_initiate* self);
void netsukuku_struct_helper_tunnelmanager_initiate_free (Netsukukustruct_helper_TunnelManager_initiate* self);
void netsukuku_struct_helper_tunnelmanager_initiate_copy (const Netsukukustruct_helper_TunnelManager_initiate* self, Netsukukustruct_helper_TunnelManager_initiate* dest);
void netsukuku_struct_helper_tunnelmanager_initiate_destroy (Netsukukustruct_helper_TunnelManager_initiate* self);
GType netsukuku_tunnel_info_get_type (void) G_GNUC_CONST;
#define NETSUKUKU_TUNNEL_INFO_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), NETSUKUKU_TYPE_TUNNEL_INFO, NetsukukuTunnelInfoPrivate))
enum  {
	NETSUKUKU_TUNNEL_INFO_DUMMY_PROPERTY,
	NETSUKUKU_TUNNEL_INFO_NIC_NAME,
	NETSUKUKU_TUNNEL_INFO_MY_ADDR,
	NETSUKUKU_TUNNEL_INFO_DEST_ADDR
};
NetsukukuTunnelInfo* netsukuku_tunnel_info_new (const gchar* nic_name, const gchar* my_addr, const gchar* dest_addr);
NetsukukuTunnelInfo* netsukuku_tunnel_info_construct (GType object_type, const gchar* nic_name, const gchar* my_addr, const gchar* dest_addr);
static void netsukuku_tunnel_info_set_nic_name (NetsukukuTunnelInfo* self, const gchar* value);
static void netsukuku_tunnel_info_set_my_addr (NetsukukuTunnelInfo* self, const gchar* value);
static void netsukuku_tunnel_info_set_dest_addr (NetsukukuTunnelInfo* self, const gchar* value);
gboolean netsukuku_tunnel_info_equal_func (NetsukukuTunnelInfo* a, NetsukukuTunnelInfo* b);
const gchar* netsukuku_tunnel_info_get_nic_name (NetsukukuTunnelInfo* self);
const gchar* netsukuku_tunnel_info_get_my_addr (NetsukukuTunnelInfo* self);
const gchar* netsukuku_tunnel_info_get_dest_addr (NetsukukuTunnelInfo* self);
gboolean netsukuku_tunnel_info_equals (NetsukukuTunnelInfo* self, NetsukukuTunnelInfo* other);
static void netsukuku_tunnel_info_finalize (GObject* obj);
static void _vala_netsukuku_tunnel_info_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_netsukuku_tunnel_info_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define NETSUKUKU_TUNNEL_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), NETSUKUKU_TYPE_TUNNEL_MANAGER, NetsukukuTunnelManagerPrivate))
enum  {
	NETSUKUKU_TUNNEL_MANAGER_DUMMY_PROPERTY,
	NETSUKUKU_TUNNEL_MANAGER_MY_ADDR
};
NetsukukuTunnelManager* netsukuku_tunnel_manager_new (const gchar* my_addr);
NetsukukuTunnelManager* netsukuku_tunnel_manager_construct (GType object_type, const gchar* my_addr);
static void netsukuku_tunnel_manager_set_my_addr (NetsukukuTunnelManager* self, const gchar* value);
GeeCollection* netsukuku_tunnel_manager_get_active_tunnels (NetsukukuTunnelManager* self);
static gchar* netsukuku_tunnel_manager_real_choose_tunnel_protocol (NetsukukuITunnelManager* base, GeeList* protocols, GError** error);
static gint netsukuku_tunnel_manager_real_request_tunnel (NetsukukuITunnelManager* base, const gchar* protocol, gint peer_handler_id, zcdCallerInfo* _rpc_caller, GError** error);
void netsukuku_tunnel_manager_initiate (NetsukukuTunnelManager* self, const gchar* dest_addr, const gchar* my_addr, gint peer_handler_id, gint my_handler_id);
static void netsukuku_tunnel_manager_impl_initiate (NetsukukuTunnelManager* self, const gchar* dest_addr, const gchar* my_addr, gint peer_handler_id, gint my_handler_id, GError** error);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void __lambda17_ (Block7Data* _data7_, zcdISerializable* mesg, GError** error);
static void ___lambda17__netsukuku_callback_send_delegate (zcdISerializable* msg, gpointer self, GError** error);
static zcdISerializable* __lambda18_ (Block7Data* _data7_, GError** error);
static zcdISerializable* ___lambda18__netsukuku_callback_recv_delegate (gpointer self, GError** error);
static void* netsukuku_tunnel_manager_helper_initiate (void* v, GError** error);
static void netsukuku_tunnel_manager_real_handshake (NetsukukuITunnelManager* base, zcdISerializable* mesg, gint handler_id, GError** error);
static void netsukuku_tunnel_manager_real_close_tunnel (NetsukukuITunnelManager* base, const gchar* nic_name, zcdCallerInfo* _rpc_caller, GError** error);
static void netsukuku_tunnel_manager_close_my_tunnel (NetsukukuTunnelManager* self, const gchar* nic_name, const gchar* my_address, const gchar* dest_address);
void netsukuku_log_warn (const gchar* msg);
gchar* netsukuku_tunnel_manager_call_request_tunnel (NetsukukuTunnelManager* self, const gchar* dest_addr, GError** error);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
const gchar* netsukuku_tunnel_manager_get_my_addr (NetsukukuTunnelManager* self);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static void ___lambda19_ (Block9Data* _data9_, zcdISerializable* mesg, GError** error);
static void ____lambda19__netsukuku_callback_send_delegate (zcdISerializable* msg, gpointer self, GError** error);
static zcdISerializable* ___lambda20_ (Block9Data* _data9_, GError** error);
static zcdISerializable* ____lambda20__netsukuku_callback_recv_delegate (gpointer self, GError** error);
void netsukuku_tunnel_manager_call_close_tunnel (NetsukukuTunnelManager* self, const gchar* dest_addr, const gchar* nic_name);
static void netsukuku_tunnel_manager_finalize (GObject* obj);
static void _vala_netsukuku_tunnel_manager_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_netsukuku_tunnel_manager_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


void netsukuku_base_tunnel_register_class (const gchar* k, NetsukukuCreateTunnelDelegate create_new_nic, void* create_new_nic_target) {
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gboolean _tmp3_;
	g_return_if_fail (k != NULL);
	_tmp1_ = k;
	if (g_strcmp0 (_tmp1_, "linux") == 0) {
		NetsukukuCreateTunnelDelegate _tmp2_;
		void* _tmp2__target;
		_tmp2_ = netsukuku_base_tunnel_registered_class_linux;
		_tmp2__target = netsukuku_base_tunnel_registered_class_linux_target;
		_tmp0_ = _tmp2_ == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		NetsukukuCreateTunnelDelegate _tmp4_;
		void* _tmp4__target;
		_tmp4_ = create_new_nic;
		_tmp4__target = create_new_nic_target;
		(netsukuku_base_tunnel_registered_class_linux_target_destroy_notify == NULL) ? NULL : (netsukuku_base_tunnel_registered_class_linux_target_destroy_notify (netsukuku_base_tunnel_registered_class_linux_target), NULL);
		netsukuku_base_tunnel_registered_class_linux = NULL;
		netsukuku_base_tunnel_registered_class_linux_target = NULL;
		netsukuku_base_tunnel_registered_class_linux_target_destroy_notify = NULL;
		netsukuku_base_tunnel_registered_class_linux = _tmp4_;
		netsukuku_base_tunnel_registered_class_linux_target = _tmp4__target;
		netsukuku_base_tunnel_registered_class_linux_target_destroy_notify = NULL;
	}
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


NetsukukuBaseTunnel* netsukuku_base_tunnel_create_instance (void) {
	NetsukukuBaseTunnel* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* impl;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	gboolean _tmp6_;
	const gchar* _tmp9_;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
	_tmp0_ = netsukuku_settings_get_NETWORK_IMPLEMENTATION ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup (_tmp1_);
	impl = _tmp2_;
	_tmp4_ = impl;
	if (g_strcmp0 (_tmp4_, "linux") == 0) {
		NetsukukuCreateTunnelDelegate _tmp5_;
		void* _tmp5__target;
		_tmp5_ = netsukuku_base_tunnel_registered_class_linux;
		_tmp5__target = netsukuku_base_tunnel_registered_class_linux_target;
		_tmp3_ = _tmp5_ != NULL;
	} else {
		_tmp3_ = FALSE;
	}
	_tmp6_ = _tmp3_;
	if (_tmp6_) {
		NetsukukuCreateTunnelDelegate _tmp7_;
		void* _tmp7__target;
		NetsukukuBaseTunnel* _tmp8_ = NULL;
		_tmp7_ = netsukuku_base_tunnel_registered_class_linux;
		_tmp7__target = netsukuku_base_tunnel_registered_class_linux_target;
		_tmp8_ = _tmp7_ (_tmp7__target);
		result = _tmp8_;
		_g_free0 (impl);
		return result;
	}
	_tmp9_ = impl;
	_tmp10_ = string_to_string (_tmp9_);
	_tmp11_ = g_strconcat ("No valid real implementation of class BaseTunnel for ", _tmp10_, ". Is your system supported?", NULL);
	_tmp12_ = _tmp11_;
	g_error ("tunnel.vala:37: %s", _tmp12_);
	_g_free0 (_tmp12_);
	_g_free0 (impl);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


NetsukukuBaseTunnel* netsukuku_base_tunnel_get_instance (void) {
	NetsukukuBaseTunnel* result = NULL;
	NetsukukuBaseTunnel* _tmp0_;
	NetsukukuBaseTunnel* _tmp2_;
	NetsukukuBaseTunnel* _tmp3_;
	_tmp0_ = netsukuku_base_tunnel__instance;
	if (_tmp0_ == NULL) {
		NetsukukuBaseTunnel* _tmp1_ = NULL;
		_tmp1_ = netsukuku_base_tunnel_create_instance ();
		_g_object_unref0 (netsukuku_base_tunnel__instance);
		netsukuku_base_tunnel__instance = _tmp1_;
	}
	_tmp2_ = netsukuku_base_tunnel__instance;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}


NetsukukuBaseTunnel* netsukuku_base_tunnel_construct (GType object_type) {
	NetsukukuBaseTunnel * self = NULL;
	self = (NetsukukuBaseTunnel*) g_object_new (object_type, NULL);
	return self;
}


/** Requests a tunnel.
          *  Usually, the other end (that we call the server) is executing in the meantime
          *  the method 'serve'.
          *  The implementor can use the callback functions cb_send(mesg) and cb_recv() to
          *  communicate with the other end during the phases of establishing the
          *  tunnel.
          *  When the method exits, if all goes well, there must exist a new NIC that
          *  represents the working tunnel.
          *  The return-value is the name of the new NIC.
          */
static gchar* netsukuku_base_tunnel_real_request (NetsukukuBaseTunnel* self, NetsukukuCallbackSendDelegate cb_send, void* cb_send_target, NetsukukuCallbackRecvDelegate cb_recv, void* cb_recv_target, const gchar* my_address, const gchar* dest_address, GError** error) {
	g_critical ("Type `%s' does not implement abstract method `netsukuku_base_tunnel_request'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


gchar* netsukuku_base_tunnel_request (NetsukukuBaseTunnel* self, NetsukukuCallbackSendDelegate cb_send, void* cb_send_target, NetsukukuCallbackRecvDelegate cb_recv, void* cb_recv_target, const gchar* my_address, const gchar* dest_address, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return NETSUKUKU_BASE_TUNNEL_GET_CLASS (self)->request (self, cb_send, cb_send_target, cb_recv, cb_recv_target, my_address, dest_address, error);
}


/** Serves a tunnel.
          *  Usually, the other end (that we call the client) is executing in the meantime
          *  the method 'request'.
          *  The implementor can use the callback functions cb_send(mesg) and cb_recv() to
          *  communicate with the other end during the phases of establishing the
          *  tunnel.
          *  When the method exits, if all goes well, there must exist a new NIC that
          *  represents the working tunnel.
          *  The return-value is the name of the new NIC.
          */
static gchar* netsukuku_base_tunnel_real_serve (NetsukukuBaseTunnel* self, NetsukukuCallbackSendDelegate cb_send, void* cb_send_target, NetsukukuCallbackRecvDelegate cb_recv, void* cb_recv_target, const gchar* my_address, const gchar* dest_address, GError** error) {
	g_critical ("Type `%s' does not implement abstract method `netsukuku_base_tunnel_serve'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


gchar* netsukuku_base_tunnel_serve (NetsukukuBaseTunnel* self, NetsukukuCallbackSendDelegate cb_send, void* cb_send_target, NetsukukuCallbackRecvDelegate cb_recv, void* cb_recv_target, const gchar* my_address, const gchar* dest_address, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return NETSUKUKU_BASE_TUNNEL_GET_CLASS (self)->serve (self, cb_send, cb_send_target, cb_recv, cb_recv_target, my_address, dest_address, error);
}


/** Closes a tunnel.
          */
static void netsukuku_base_tunnel_real_close (NetsukukuBaseTunnel* self, const gchar* nic_name, const gchar* my_address, const gchar* dest_address, GError** error) {
	g_critical ("Type `%s' does not implement abstract method `netsukuku_base_tunnel_close'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void netsukuku_base_tunnel_close (NetsukukuBaseTunnel* self, const gchar* nic_name, const gchar* my_address, const gchar* dest_address, GError** error) {
	g_return_if_fail (self != NULL);
	NETSUKUKU_BASE_TUNNEL_GET_CLASS (self)->close (self, nic_name, my_address, dest_address, error);
}


static void netsukuku_base_tunnel_class_init (NetsukukuBaseTunnelClass * klass) {
	netsukuku_base_tunnel_parent_class = g_type_class_peek_parent (klass);
	NETSUKUKU_BASE_TUNNEL_CLASS (klass)->request = netsukuku_base_tunnel_real_request;
	NETSUKUKU_BASE_TUNNEL_CLASS (klass)->serve = netsukuku_base_tunnel_real_serve;
	NETSUKUKU_BASE_TUNNEL_CLASS (klass)->close = netsukuku_base_tunnel_real_close;
	G_OBJECT_CLASS (klass)->finalize = netsukuku_base_tunnel_finalize;
}


static void netsukuku_base_tunnel_instance_init (NetsukukuBaseTunnel * self) {
}


static void netsukuku_base_tunnel_finalize (GObject* obj) {
	NetsukukuBaseTunnel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_BASE_TUNNEL, NetsukukuBaseTunnel);
	G_OBJECT_CLASS (netsukuku_base_tunnel_parent_class)->finalize (obj);
}


GType netsukuku_base_tunnel_get_type (void) {
	static volatile gsize netsukuku_base_tunnel_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_base_tunnel_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuBaseTunnelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_base_tunnel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuBaseTunnel), 0, (GInstanceInitFunc) netsukuku_base_tunnel_instance_init, NULL };
		GType netsukuku_base_tunnel_type_id;
		netsukuku_base_tunnel_type_id = g_type_register_static (G_TYPE_OBJECT, "NetsukukuBaseTunnel", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&netsukuku_base_tunnel_type_id__volatile, netsukuku_base_tunnel_type_id);
	}
	return netsukuku_base_tunnel_type_id__volatile;
}


NetsukukuDummyTunnel* netsukuku_dummy_tunnel_construct (GType object_type) {
	NetsukukuDummyTunnel * self = NULL;
	self = (NetsukukuDummyTunnel*) netsukuku_base_tunnel_construct (object_type);
	return self;
}


NetsukukuDummyTunnel* netsukuku_dummy_tunnel_new (void) {
	return netsukuku_dummy_tunnel_construct (NETSUKUKU_TYPE_DUMMY_TUNNEL);
}


static gchar* netsukuku_dummy_tunnel_real_serve (NetsukukuBaseTunnel* base, NetsukukuCallbackSendDelegate cb_send, void* cb_send_target, NetsukukuCallbackRecvDelegate cb_recv, void* cb_recv_target, const gchar* my_address, const gchar* dest_address, GError** error) {
	NetsukukuDummyTunnel * self;
	gchar* result = NULL;
	gchar* _tmp0_;
	self = (NetsukukuDummyTunnel*) base;
	g_return_val_if_fail (my_address != NULL, NULL);
	g_return_val_if_fail (dest_address != NULL, NULL);
	_tmp0_ = g_strdup ("dummy");
	result = _tmp0_;
	return result;
}


static gchar* netsukuku_dummy_tunnel_real_request (NetsukukuBaseTunnel* base, NetsukukuCallbackSendDelegate cb_send, void* cb_send_target, NetsukukuCallbackRecvDelegate cb_recv, void* cb_recv_target, const gchar* my_address, const gchar* dest_address, GError** error) {
	NetsukukuDummyTunnel * self;
	gchar* result = NULL;
	gchar* _tmp0_;
	self = (NetsukukuDummyTunnel*) base;
	g_return_val_if_fail (my_address != NULL, NULL);
	g_return_val_if_fail (dest_address != NULL, NULL);
	_tmp0_ = g_strdup ("dummy");
	result = _tmp0_;
	return result;
}


static void netsukuku_dummy_tunnel_real_close (NetsukukuBaseTunnel* base, const gchar* nic_name, const gchar* my_address, const gchar* dest_address, GError** error) {
	NetsukukuDummyTunnel * self;
	self = (NetsukukuDummyTunnel*) base;
	g_return_if_fail (nic_name != NULL);
	g_return_if_fail (my_address != NULL);
	g_return_if_fail (dest_address != NULL);
}


static void netsukuku_dummy_tunnel_class_init (NetsukukuDummyTunnelClass * klass) {
	netsukuku_dummy_tunnel_parent_class = g_type_class_peek_parent (klass);
	NETSUKUKU_BASE_TUNNEL_CLASS (klass)->serve = netsukuku_dummy_tunnel_real_serve;
	NETSUKUKU_BASE_TUNNEL_CLASS (klass)->request = netsukuku_dummy_tunnel_real_request;
	NETSUKUKU_BASE_TUNNEL_CLASS (klass)->close = netsukuku_dummy_tunnel_real_close;
}


static void netsukuku_dummy_tunnel_instance_init (NetsukukuDummyTunnel * self) {
}


GType netsukuku_dummy_tunnel_get_type (void) {
	static volatile gsize netsukuku_dummy_tunnel_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_dummy_tunnel_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuDummyTunnelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_dummy_tunnel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuDummyTunnel), 0, (GInstanceInitFunc) netsukuku_dummy_tunnel_instance_init, NULL };
		GType netsukuku_dummy_tunnel_type_id;
		netsukuku_dummy_tunnel_type_id = g_type_register_static (NETSUKUKU_TYPE_BASE_TUNNEL, "NetsukukuDummyTunnel", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_dummy_tunnel_type_id__volatile, netsukuku_dummy_tunnel_type_id);
	}
	return netsukuku_dummy_tunnel_type_id__volatile;
}


void netsukuku_struct_helper_tunnelmanager_initiate_copy (const Netsukukustruct_helper_TunnelManager_initiate* self, Netsukukustruct_helper_TunnelManager_initiate* dest) {
	NetsukukuTunnelManager* _tmp0_;
	NetsukukuTunnelManager* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	_tmp0_ = (*self).self;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 ((*dest).self);
	(*dest).self = _tmp1_;
	_tmp2_ = (*self).dest_addr;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).dest_addr);
	(*dest).dest_addr = _tmp3_;
	_tmp4_ = (*self).my_addr;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 ((*dest).my_addr);
	(*dest).my_addr = _tmp5_;
	_tmp6_ = (*self).peer_handler_id;
	(*dest).peer_handler_id = _tmp6_;
	_tmp7_ = (*self).my_handler_id;
	(*dest).my_handler_id = _tmp7_;
}


void netsukuku_struct_helper_tunnelmanager_initiate_destroy (Netsukukustruct_helper_TunnelManager_initiate* self) {
	_g_object_unref0 ((*self).self);
	_g_free0 ((*self).dest_addr);
	_g_free0 ((*self).my_addr);
}


Netsukukustruct_helper_TunnelManager_initiate* netsukuku_struct_helper_tunnelmanager_initiate_dup (const Netsukukustruct_helper_TunnelManager_initiate* self) {
	Netsukukustruct_helper_TunnelManager_initiate* dup;
	dup = g_new0 (Netsukukustruct_helper_TunnelManager_initiate, 1);
	netsukuku_struct_helper_tunnelmanager_initiate_copy (self, dup);
	return dup;
}


void netsukuku_struct_helper_tunnelmanager_initiate_free (Netsukukustruct_helper_TunnelManager_initiate* self) {
	netsukuku_struct_helper_tunnelmanager_initiate_destroy (self);
	g_free (self);
}


GType netsukuku_struct_helper_tunnelmanager_initiate_get_type (void) {
	static volatile gsize netsukuku_struct_helper_tunnelmanager_initiate_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_struct_helper_tunnelmanager_initiate_type_id__volatile)) {
		GType netsukuku_struct_helper_tunnelmanager_initiate_type_id;
		netsukuku_struct_helper_tunnelmanager_initiate_type_id = g_boxed_type_register_static ("Netsukukustruct_helper_TunnelManager_initiate", (GBoxedCopyFunc) netsukuku_struct_helper_tunnelmanager_initiate_dup, (GBoxedFreeFunc) netsukuku_struct_helper_tunnelmanager_initiate_free);
		g_once_init_leave (&netsukuku_struct_helper_tunnelmanager_initiate_type_id__volatile, netsukuku_struct_helper_tunnelmanager_initiate_type_id);
	}
	return netsukuku_struct_helper_tunnelmanager_initiate_type_id__volatile;
}


NetsukukuTunnelInfo* netsukuku_tunnel_info_construct (GType object_type, const gchar* nic_name, const gchar* my_addr, const gchar* dest_addr) {
	NetsukukuTunnelInfo * self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_val_if_fail (nic_name != NULL, NULL);
	g_return_val_if_fail (my_addr != NULL, NULL);
	g_return_val_if_fail (dest_addr != NULL, NULL);
	self = (NetsukukuTunnelInfo*) g_object_new (object_type, NULL);
	_tmp0_ = nic_name;
	netsukuku_tunnel_info_set_nic_name (self, _tmp0_);
	_tmp1_ = my_addr;
	netsukuku_tunnel_info_set_my_addr (self, _tmp1_);
	_tmp2_ = dest_addr;
	netsukuku_tunnel_info_set_dest_addr (self, _tmp2_);
	return self;
}


NetsukukuTunnelInfo* netsukuku_tunnel_info_new (const gchar* nic_name, const gchar* my_addr, const gchar* dest_addr) {
	return netsukuku_tunnel_info_construct (NETSUKUKU_TYPE_TUNNEL_INFO, nic_name, my_addr, dest_addr);
}


gboolean netsukuku_tunnel_info_equal_func (NetsukukuTunnelInfo* a, NetsukukuTunnelInfo* b) {
	gboolean result = FALSE;
	NetsukukuTunnelInfo* _tmp0_;
	NetsukukuTunnelInfo* _tmp1_;
	gboolean _tmp2_ = FALSE;
	NetsukukuTunnelInfo* _tmp3_;
	gboolean _tmp5_;
	NetsukukuTunnelInfo* _tmp6_;
	const gchar* _tmp7_;
	NetsukukuTunnelInfo* _tmp8_;
	const gchar* _tmp9_;
	NetsukukuTunnelInfo* _tmp10_;
	const gchar* _tmp11_;
	NetsukukuTunnelInfo* _tmp12_;
	const gchar* _tmp13_;
	NetsukukuTunnelInfo* _tmp14_;
	const gchar* _tmp15_;
	NetsukukuTunnelInfo* _tmp16_;
	const gchar* _tmp17_;
	_tmp0_ = a;
	_tmp1_ = b;
	if (_tmp0_ == _tmp1_) {
		result = TRUE;
		return result;
	}
	_tmp3_ = a;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		NetsukukuTunnelInfo* _tmp4_;
		_tmp4_ = b;
		_tmp2_ = _tmp4_ == NULL;
	}
	_tmp5_ = _tmp2_;
	if (_tmp5_) {
		result = FALSE;
		return result;
	}
	_tmp6_ = a;
	_tmp7_ = _tmp6_->priv->_nic_name;
	_tmp8_ = b;
	_tmp9_ = _tmp8_->priv->_nic_name;
	if (g_strcmp0 (_tmp7_, _tmp9_) != 0) {
		result = FALSE;
		return result;
	}
	_tmp10_ = a;
	_tmp11_ = _tmp10_->priv->_my_addr;
	_tmp12_ = b;
	_tmp13_ = _tmp12_->priv->_my_addr;
	if (g_strcmp0 (_tmp11_, _tmp13_) != 0) {
		result = FALSE;
		return result;
	}
	_tmp14_ = a;
	_tmp15_ = _tmp14_->priv->_dest_addr;
	_tmp16_ = b;
	_tmp17_ = _tmp16_->priv->_dest_addr;
	if (g_strcmp0 (_tmp15_, _tmp17_) != 0) {
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


gboolean netsukuku_tunnel_info_equals (NetsukukuTunnelInfo* self, NetsukukuTunnelInfo* other) {
	gboolean result = FALSE;
	NetsukukuTunnelInfo* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = other;
	_tmp1_ = netsukuku_tunnel_info_equal_func (self, _tmp0_);
	result = _tmp1_;
	return result;
}


const gchar* netsukuku_tunnel_info_get_nic_name (NetsukukuTunnelInfo* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_nic_name;
	result = _tmp0_;
	return result;
}


static void netsukuku_tunnel_info_set_nic_name (NetsukukuTunnelInfo* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_nic_name);
	self->priv->_nic_name = _tmp1_;
	g_object_notify ((GObject *) self, "nic-name");
}


const gchar* netsukuku_tunnel_info_get_my_addr (NetsukukuTunnelInfo* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_my_addr;
	result = _tmp0_;
	return result;
}


static void netsukuku_tunnel_info_set_my_addr (NetsukukuTunnelInfo* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_my_addr);
	self->priv->_my_addr = _tmp1_;
	g_object_notify ((GObject *) self, "my-addr");
}


const gchar* netsukuku_tunnel_info_get_dest_addr (NetsukukuTunnelInfo* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_dest_addr;
	result = _tmp0_;
	return result;
}


static void netsukuku_tunnel_info_set_dest_addr (NetsukukuTunnelInfo* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_dest_addr);
	self->priv->_dest_addr = _tmp1_;
	g_object_notify ((GObject *) self, "dest-addr");
}


static void netsukuku_tunnel_info_class_init (NetsukukuTunnelInfoClass * klass) {
	netsukuku_tunnel_info_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (NetsukukuTunnelInfoPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_netsukuku_tunnel_info_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_netsukuku_tunnel_info_set_property;
	G_OBJECT_CLASS (klass)->finalize = netsukuku_tunnel_info_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETSUKUKU_TUNNEL_INFO_NIC_NAME, g_param_spec_string ("nic-name", "nic-name", "nic-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETSUKUKU_TUNNEL_INFO_MY_ADDR, g_param_spec_string ("my-addr", "my-addr", "my-addr", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETSUKUKU_TUNNEL_INFO_DEST_ADDR, g_param_spec_string ("dest-addr", "dest-addr", "dest-addr", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void netsukuku_tunnel_info_instance_init (NetsukukuTunnelInfo * self) {
	self->priv = NETSUKUKU_TUNNEL_INFO_GET_PRIVATE (self);
}


static void netsukuku_tunnel_info_finalize (GObject* obj) {
	NetsukukuTunnelInfo * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_TUNNEL_INFO, NetsukukuTunnelInfo);
	_g_free0 (self->priv->_nic_name);
	_g_free0 (self->priv->_my_addr);
	_g_free0 (self->priv->_dest_addr);
	G_OBJECT_CLASS (netsukuku_tunnel_info_parent_class)->finalize (obj);
}


GType netsukuku_tunnel_info_get_type (void) {
	static volatile gsize netsukuku_tunnel_info_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_tunnel_info_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuTunnelInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_tunnel_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuTunnelInfo), 0, (GInstanceInitFunc) netsukuku_tunnel_info_instance_init, NULL };
		GType netsukuku_tunnel_info_type_id;
		netsukuku_tunnel_info_type_id = g_type_register_static (G_TYPE_OBJECT, "NetsukukuTunnelInfo", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_tunnel_info_type_id__volatile, netsukuku_tunnel_info_type_id);
	}
	return netsukuku_tunnel_info_type_id__volatile;
}


static void _vala_netsukuku_tunnel_info_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	NetsukukuTunnelInfo * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETSUKUKU_TYPE_TUNNEL_INFO, NetsukukuTunnelInfo);
	switch (property_id) {
		case NETSUKUKU_TUNNEL_INFO_NIC_NAME:
		g_value_set_string (value, netsukuku_tunnel_info_get_nic_name (self));
		break;
		case NETSUKUKU_TUNNEL_INFO_MY_ADDR:
		g_value_set_string (value, netsukuku_tunnel_info_get_my_addr (self));
		break;
		case NETSUKUKU_TUNNEL_INFO_DEST_ADDR:
		g_value_set_string (value, netsukuku_tunnel_info_get_dest_addr (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_netsukuku_tunnel_info_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	NetsukukuTunnelInfo * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETSUKUKU_TYPE_TUNNEL_INFO, NetsukukuTunnelInfo);
	switch (property_id) {
		case NETSUKUKU_TUNNEL_INFO_NIC_NAME:
		netsukuku_tunnel_info_set_nic_name (self, g_value_get_string (value));
		break;
		case NETSUKUKU_TUNNEL_INFO_MY_ADDR:
		netsukuku_tunnel_info_set_my_addr (self, g_value_get_string (value));
		break;
		case NETSUKUKU_TUNNEL_INFO_DEST_ADDR:
		netsukuku_tunnel_info_set_dest_addr (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


NetsukukuTunnelManager* netsukuku_tunnel_manager_construct (GType object_type, const gchar* my_addr) {
	NetsukukuTunnelManager * self = NULL;
	const gchar* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeHashMap* _tmp2_;
	g_return_val_if_fail (my_addr != NULL, NULL);
	self = (NetsukukuTunnelManager*) g_object_new (object_type, NULL);
	_tmp0_ = my_addr;
	netsukuku_tunnel_manager_set_my_addr (self, _tmp0_);
	_tmp1_ = gee_hash_map_new (G_TYPE_INT, NULL, NULL, TASKLETS_TYPE_CHANNEL, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->handlers);
	self->priv->handlers = _tmp1_;
	_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NETSUKUKU_TYPE_TUNNEL_INFO, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->active_tunnels);
	self->priv->active_tunnels = _tmp2_;
	return self;
}


NetsukukuTunnelManager* netsukuku_tunnel_manager_new (const gchar* my_addr) {
	return netsukuku_tunnel_manager_construct (NETSUKUKU_TYPE_TUNNEL_MANAGER, my_addr);
}


GeeCollection* netsukuku_tunnel_manager_get_active_tunnels (NetsukukuTunnelManager* self) {
	GeeCollection* result = NULL;
	GeeHashMap* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->active_tunnels;
	_tmp1_ = gee_abstract_map_get_values ((GeeMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


static gchar* netsukuku_tunnel_manager_real_choose_tunnel_protocol (NetsukukuITunnelManager* base, GeeList* protocols, GError** error) {
	NetsukukuTunnelManager * self;
	gchar* result = NULL;
	GeeList* _tmp0_;
	gboolean _tmp1_ = FALSE;
	self = (NetsukukuTunnelManager*) base;
	g_return_val_if_fail (protocols != NULL, NULL);
	_tmp0_ = protocols;
	_tmp1_ = gee_collection_contains ((GeeCollection*) _tmp0_, "tinc");
	if (_tmp1_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("tinc");
		result = _tmp2_;
		return result;
	}
	result = NULL;
	return result;
}


/** Remotable method. Called to instruct a node to serve a tunnel.
          */
static gint netsukuku_tunnel_manager_real_request_tunnel (NetsukukuITunnelManager* base, const gchar* protocol, gint peer_handler_id, zcdCallerInfo* _rpc_caller, GError** error) {
	NetsukukuTunnelManager * self;
	gint result = 0;
	zcdCallerInfo* _tmp0_;
	zcdCallerInfo* _tmp1_;
	GType _tmp2_ = 0UL;
	gboolean _tmp3_ = FALSE;
	zcdCallerInfo* _tmp4_;
	zcdCallerInfo* _tmp5_;
	zcdCallerInfo* rpc_caller;
	const gchar* _tmp6_;
	zcdCallerInfo* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* my_addr;
	zcdCallerInfo* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* dest_addr;
	gdouble _tmp14_ = 0.0;
	gint32 _tmp15_ = 0;
	gint my_handler_id;
	TaskletsChannel* _tmp16_;
	TaskletsChannel* handler_channel;
	GeeHashMap* _tmp17_;
	gint _tmp18_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuTunnelManager*) base;
	g_return_val_if_fail (protocol != NULL, 0);
	_tmp0_ = _rpc_caller;
	_vala_assert (_tmp0_ != NULL, "_rpc_caller != null");
	_tmp1_ = _rpc_caller;
	_tmp2_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp1_);
	_tmp3_ = g_type_is_a (_tmp2_, ZCD_TYPE_CALLER_INFO);
	_vala_assert (_tmp3_, "_rpc_caller.get_type().is_a(typeof(CallerInfo))");
	_tmp4_ = _rpc_caller;
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, ZCD_TYPE_CALLER_INFO, zcdCallerInfo));
	rpc_caller = _tmp5_;
	_tmp6_ = protocol;
	if (g_strcmp0 (_tmp6_, "tinc") != 0) {
		GError* _tmp7_;
		_tmp7_ = g_error_new_literal (NETSUKUKU_TUNNEL_ERROR, NETSUKUKU_TUNNEL_ERROR_GENERIC, "Invalid protocol.");
		_inner_error_ = _tmp7_;
		if (_inner_error_->domain == NETSUKUKU_TUNNEL_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (rpc_caller);
			return 0;
		} else {
			_g_object_unref0 (rpc_caller);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	_tmp8_ = rpc_caller;
	_tmp9_ = _tmp8_->my_ip;
	_tmp10_ = g_strdup (_tmp9_);
	my_addr = _tmp10_;
	_tmp11_ = rpc_caller;
	_tmp12_ = _tmp11_->caller_ip;
	_tmp13_ = g_strdup (_tmp12_);
	dest_addr = _tmp13_;
	_tmp14_ = pow ((gdouble) 2, (gdouble) 32);
	_tmp15_ = g_random_int_range ((gint32) 0, (gint32) (((gint) _tmp14_) - 1));
	my_handler_id = (gint) _tmp15_;
	_tmp16_ = tasklets_channel_new (NULL);
	handler_channel = _tmp16_;
	_tmp17_ = self->priv->handlers;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp17_, (gpointer) ((gintptr) my_handler_id), handler_channel);
	_tmp18_ = peer_handler_id;
	netsukuku_tunnel_manager_initiate (self, dest_addr, my_addr, _tmp18_, my_handler_id);
	result = my_handler_id;
	_g_object_unref0 (handler_channel);
	_g_free0 (dest_addr);
	_g_free0 (my_addr);
	_g_object_unref0 (rpc_caller);
	return result;
}


/** Executed on a Tasklet to serve a tunnel.
          */
static Block7Data* block7_data_ref (Block7Data* _data7_) {
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}


static void block7_data_unref (void * _userdata_) {
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		NetsukukuTunnelManager * self;
		self = _data7_->self;
		_g_object_unref0 (_data7_->peer_client);
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}


static void __lambda17_ (Block7Data* _data7_, zcdISerializable* mesg, GError** error) {
	NetsukukuTunnelManager * self;
	NetsukukuITunnelManager* _tmp0_;
	NetsukukuITunnelManager* _tmp1_;
	zcdISerializable* _tmp2_;
	gint _tmp3_;
	GError * _inner_error_ = NULL;
	self = _data7_->self;
	g_return_if_fail (mesg != NULL);
	_tmp0_ = netsukuku_iaddress_manager_root_dispatcher_get_tunnel_manager ((NetsukukuIAddressManagerRootDispatcher*) _data7_->peer_client);
	_tmp1_ = _tmp0_;
	_tmp2_ = mesg;
	_tmp3_ = _data7_->peer_handler_id;
	netsukuku_itunnel_manager_handshake (_tmp1_, _tmp2_, _tmp3_, &_inner_error_);
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == NETSUKUKU_TUNNEL_ERROR) || (_inner_error_->domain == ZCD_RPC_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void ___lambda17__netsukuku_callback_send_delegate (zcdISerializable* msg, gpointer self, GError** error) {
	__lambda17_ (self, msg, error);
}


static zcdISerializable* __lambda18_ (Block7Data* _data7_, GError** error) {
	NetsukukuTunnelManager * self;
	zcdISerializable* result = NULL;
	GeeHashMap* _tmp0_;
	gint _tmp1_;
	gpointer _tmp2_ = NULL;
	TaskletsChannel* _tmp3_;
	GValue _tmp4_ = {0};
	zcdISerializable* _tmp5_;
	self = _data7_->self;
	_tmp0_ = self->priv->handlers;
	_tmp1_ = _data7_->my_handler_id;
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, (gpointer) ((gintptr) _tmp1_));
	_tmp3_ = (TaskletsChannel*) _tmp2_;
	tasklets_channel_recv (_tmp3_, &_tmp4_);
	_tmp5_ = g_value_get_object (&_tmp4_);
	_g_object_unref0 (_tmp3_);
	result = _tmp5_;
	return result;
}


static zcdISerializable* ___lambda18__netsukuku_callback_recv_delegate (gpointer self, GError** error) {
	zcdISerializable* result;
	result = __lambda18_ (self, error);
	return result;
}


static void netsukuku_tunnel_manager_impl_initiate (NetsukukuTunnelManager* self, const gchar* dest_addr, const gchar* my_addr, gint peer_handler_id, gint my_handler_id, GError** error) {
	Block7Data* _data7_;
	gint _tmp0_;
	gint _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	NetsukukuAddressManagerTCPClient* _tmp4_;
	NetsukukuCallbackSendDelegate cb_send;
	void* cb_send_target;
	GDestroyNotify cb_send_target_destroy_notify;
	NetsukukuCallbackRecvDelegate cb_recv;
	void* cb_recv_target;
	GDestroyNotify cb_recv_target_destroy_notify;
	NetsukukuBaseTunnel* _tmp5_ = NULL;
	NetsukukuBaseTunnel* ktunnel;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* nic_name;
	GeeHashMap* _tmp9_;
	gboolean _tmp10_ = FALSE;
	GeeHashMap* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	NetsukukuTunnelInfo* _tmp14_;
	NetsukukuTunnelInfo* _tmp15_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dest_addr != NULL);
	g_return_if_fail (my_addr != NULL);
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->self = g_object_ref (self);
	_tmp0_ = peer_handler_id;
	_data7_->peer_handler_id = _tmp0_;
	_tmp1_ = my_handler_id;
	_data7_->my_handler_id = _tmp1_;
	tasklets_tasklet_declare_self ("TunnelManager.initiate");
	_tmp2_ = dest_addr;
	_tmp3_ = my_addr;
	_tmp4_ = netsukuku_address_manager_tcp_client_new (_tmp2_, NULL, _tmp3_, FALSE);
	_data7_->peer_client = _tmp4_;
	cb_send = ___lambda17__netsukuku_callback_send_delegate;
	cb_send_target = block7_data_ref (_data7_);
	cb_send_target_destroy_notify = block7_data_unref;
	cb_recv = ___lambda18__netsukuku_callback_recv_delegate;
	cb_recv_target = block7_data_ref (_data7_);
	cb_recv_target_destroy_notify = block7_data_unref;
	_tmp5_ = netsukuku_base_tunnel_get_instance ();
	ktunnel = _tmp5_;
	_tmp6_ = my_addr;
	_tmp7_ = dest_addr;
	_tmp8_ = netsukuku_base_tunnel_serve (ktunnel, cb_send, cb_send_target, cb_recv, cb_recv_target, _tmp6_, _tmp7_, &_inner_error_);
	nic_name = _tmp8_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (ktunnel);
		(cb_recv_target_destroy_notify == NULL) ? NULL : (cb_recv_target_destroy_notify (cb_recv_target), NULL);
		cb_recv = NULL;
		cb_recv_target = NULL;
		cb_recv_target_destroy_notify = NULL;
		(cb_send_target_destroy_notify == NULL) ? NULL : (cb_send_target_destroy_notify (cb_send_target), NULL);
		cb_send = NULL;
		cb_send_target = NULL;
		cb_send_target_destroy_notify = NULL;
		block7_data_unref (_data7_);
		_data7_ = NULL;
		return;
	}
	_tmp9_ = self->priv->active_tunnels;
	_tmp10_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp9_, nic_name);
	_vala_assert (!_tmp10_, "! active_tunnels.has_key(nic_name)");
	_tmp11_ = self->priv->active_tunnels;
	_tmp12_ = my_addr;
	_tmp13_ = dest_addr;
	_tmp14_ = netsukuku_tunnel_info_new (nic_name, _tmp12_, _tmp13_);
	_tmp15_ = _tmp14_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp11_, nic_name, _tmp15_);
	_g_object_unref0 (_tmp15_);
	_g_free0 (nic_name);
	_g_object_unref0 (ktunnel);
	(cb_recv_target_destroy_notify == NULL) ? NULL : (cb_recv_target_destroy_notify (cb_recv_target), NULL);
	cb_recv = NULL;
	cb_recv_target = NULL;
	cb_recv_target_destroy_notify = NULL;
	(cb_send_target_destroy_notify == NULL) ? NULL : (cb_send_target_destroy_notify (cb_send_target), NULL);
	cb_send = NULL;
	cb_send_target = NULL;
	cb_send_target_destroy_notify = NULL;
	block7_data_unref (_data7_);
	_data7_ = NULL;
}


static void* netsukuku_tunnel_manager_helper_initiate (void* v, GError** error) {
	void* result = NULL;
	void* _tmp0_;
	Netsukukustruct_helper_TunnelManager_initiate* tuple_p;
	NetsukukuTunnelManager* _tmp1_;
	NetsukukuTunnelManager* _tmp2_;
	NetsukukuTunnelManager* self_save;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* dest_addr_save;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* my_addr_save;
	gint _tmp7_;
	gint peer_handler_id_save;
	gint _tmp8_;
	gint my_handler_id_save;
	GError * _inner_error_ = NULL;
	_tmp0_ = v;
	tuple_p = (Netsukukustruct_helper_TunnelManager_initiate*) _tmp0_;
	_tmp1_ = (*tuple_p).self;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	self_save = _tmp2_;
	_tmp3_ = (*tuple_p).dest_addr;
	_tmp4_ = g_strdup (_tmp3_);
	dest_addr_save = _tmp4_;
	_tmp5_ = (*tuple_p).my_addr;
	_tmp6_ = g_strdup (_tmp5_);
	my_addr_save = _tmp6_;
	_tmp7_ = (*tuple_p).peer_handler_id;
	peer_handler_id_save = _tmp7_;
	_tmp8_ = (*tuple_p).my_handler_id;
	my_handler_id_save = _tmp8_;
	tasklets_tasklet_schedule_back ();
	netsukuku_tunnel_manager_impl_initiate (self_save, dest_addr_save, my_addr_save, peer_handler_id_save, my_handler_id_save, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (my_addr_save);
		_g_free0 (dest_addr_save);
		_g_object_unref0 (self_save);
		return NULL;
	}
	result = NULL;
	_g_free0 (my_addr_save);
	_g_free0 (dest_addr_save);
	_g_object_unref0 (self_save);
	return result;
}


void netsukuku_tunnel_manager_initiate (NetsukukuTunnelManager* self, const gchar* dest_addr, const gchar* my_addr, gint peer_handler_id, gint my_handler_id) {
	Netsukukustruct_helper_TunnelManager_initiate arg = {0};
	NetsukukuTunnelManager* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	TaskletsTasklet* _tmp7_ = NULL;
	TaskletsTasklet* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dest_addr != NULL);
	g_return_if_fail (my_addr != NULL);
	memset (&arg, 0, sizeof (Netsukukustruct_helper_TunnelManager_initiate));
	_tmp0_ = _g_object_ref0 (self);
	_g_object_unref0 (arg.self);
	arg.self = _tmp0_;
	_tmp1_ = dest_addr;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (arg.dest_addr);
	arg.dest_addr = _tmp2_;
	_tmp3_ = my_addr;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (arg.my_addr);
	arg.my_addr = _tmp4_;
	_tmp5_ = peer_handler_id;
	arg.peer_handler_id = _tmp5_;
	_tmp6_ = my_handler_id;
	arg.my_handler_id = _tmp6_;
	_tmp7_ = tasklets_tasklet_spawn ((TaskletsSpawnable) netsukuku_tunnel_manager_helper_initiate, &arg, FALSE, -1);
	_tmp8_ = _tmp7_;
	_g_object_unref0 (_tmp8_);
	netsukuku_struct_helper_tunnelmanager_initiate_destroy (&arg);
}


/** Remotable method. Called to pass a message during the handshake phase,
          * following a particular protocol (e.g. tinc on linux).
          */
static void netsukuku_tunnel_manager_real_handshake (NetsukukuITunnelManager* base, zcdISerializable* mesg, gint handler_id, GError** error) {
	NetsukukuTunnelManager * self;
	GeeHashMap* _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	self = (NetsukukuTunnelManager*) base;
	g_return_if_fail (mesg != NULL);
	_tmp0_ = self->priv->handlers;
	_tmp1_ = handler_id;
	_tmp2_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, (gpointer) ((gintptr) _tmp1_));
	if (_tmp2_) {
		GeeHashMap* _tmp3_;
		gint _tmp4_;
		gpointer _tmp5_ = NULL;
		TaskletsChannel* _tmp6_;
		zcdISerializable* _tmp7_;
		GValue _tmp8_ = {0};
		_tmp3_ = self->priv->handlers;
		_tmp4_ = handler_id;
		_tmp5_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp3_, (gpointer) ((gintptr) _tmp4_));
		_tmp6_ = (TaskletsChannel*) _tmp5_;
		_tmp7_ = mesg;
		g_value_init (&_tmp8_, ZCD_TYPE_ISERIALIZABLE);
		g_value_set_object (&_tmp8_, _tmp7_);
		tasklets_channel_send (_tmp6_, &_tmp8_);
		G_IS_VALUE (&_tmp8_) ? (g_value_unset (&_tmp8_), NULL) : NULL;
		_g_object_unref0 (_tmp6_);
	}
}


/** Remotable method. Called to instruct a node to close a tunnel.
          */
static void netsukuku_tunnel_manager_real_close_tunnel (NetsukukuITunnelManager* base, const gchar* nic_name, zcdCallerInfo* _rpc_caller, GError** error) {
	NetsukukuTunnelManager * self;
	zcdCallerInfo* _tmp0_;
	zcdCallerInfo* _tmp1_;
	GType _tmp2_ = 0UL;
	gboolean _tmp3_ = FALSE;
	zcdCallerInfo* _tmp4_;
	zcdCallerInfo* _tmp5_;
	zcdCallerInfo* rpc_caller;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* my_addr;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* dest_addr;
	const gchar* _tmp10_;
	self = (NetsukukuTunnelManager*) base;
	g_return_if_fail (nic_name != NULL);
	_tmp0_ = _rpc_caller;
	_vala_assert (_tmp0_ != NULL, "_rpc_caller != null");
	_tmp1_ = _rpc_caller;
	_tmp2_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp1_);
	_tmp3_ = g_type_is_a (_tmp2_, ZCD_TYPE_CALLER_INFO);
	_vala_assert (_tmp3_, "_rpc_caller.get_type().is_a(typeof(CallerInfo))");
	_tmp4_ = _rpc_caller;
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, ZCD_TYPE_CALLER_INFO, zcdCallerInfo));
	rpc_caller = _tmp5_;
	_tmp6_ = rpc_caller->my_ip;
	_tmp7_ = g_strdup (_tmp6_);
	my_addr = _tmp7_;
	_tmp8_ = rpc_caller->caller_ip;
	_tmp9_ = g_strdup (_tmp8_);
	dest_addr = _tmp9_;
	_tmp10_ = nic_name;
	netsukuku_tunnel_manager_close_my_tunnel (self, _tmp10_, my_addr, dest_addr);
	_g_free0 (dest_addr);
	_g_free0 (my_addr);
	_g_object_unref0 (rpc_caller);
}


static void netsukuku_tunnel_manager_close_my_tunnel (NetsukukuTunnelManager* self, const gchar* nic_name, const gchar* my_address, const gchar* dest_address) {
	gboolean _tmp0_ = FALSE;
	GeeHashMap* _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp14_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (nic_name != NULL);
	g_return_if_fail (my_address != NULL);
	g_return_if_fail (dest_address != NULL);
	_tmp1_ = self->priv->active_tunnels;
	_tmp2_ = nic_name;
	_tmp3_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp1_, _tmp2_);
	if (_tmp3_) {
		GeeHashMap* _tmp4_;
		const gchar* _tmp5_;
		gpointer _tmp6_ = NULL;
		NetsukukuTunnelInfo* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		NetsukukuTunnelInfo* _tmp11_;
		NetsukukuTunnelInfo* _tmp12_;
		gboolean _tmp13_ = FALSE;
		_tmp4_ = self->priv->active_tunnels;
		_tmp5_ = nic_name;
		_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp4_, _tmp5_);
		_tmp7_ = (NetsukukuTunnelInfo*) _tmp6_;
		_tmp8_ = nic_name;
		_tmp9_ = my_address;
		_tmp10_ = dest_address;
		_tmp11_ = netsukuku_tunnel_info_new (_tmp8_, _tmp9_, _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = netsukuku_tunnel_info_equals (_tmp7_, _tmp12_);
		_tmp0_ = _tmp13_;
		_g_object_unref0 (_tmp12_);
		_g_object_unref0 (_tmp7_);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp14_ = _tmp0_;
	if (_tmp14_) {
		NetsukukuBaseTunnel* _tmp15_ = NULL;
		NetsukukuBaseTunnel* ktunnel;
		GeeHashMap* _tmp35_;
		const gchar* _tmp36_;
		_tmp15_ = netsukuku_base_tunnel_get_instance ();
		ktunnel = _tmp15_;
		{
			NetsukukuBaseTunnel* _tmp16_;
			const gchar* _tmp17_;
			const gchar* _tmp18_;
			const gchar* _tmp19_;
			_tmp16_ = ktunnel;
			_tmp17_ = nic_name;
			_tmp18_ = my_address;
			_tmp19_ = dest_address;
			netsukuku_base_tunnel_close (_tmp16_, _tmp17_, _tmp18_, _tmp19_, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == NETSUKUKU_TUNNEL_ERROR) {
					goto __catch113_netsukuku_tunnel_error;
				}
				_g_object_unref0 (ktunnel);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		goto __finally113;
		__catch113_netsukuku_tunnel_error:
		{
			GError* e = NULL;
			const gchar* _tmp20_;
			const gchar* _tmp21_ = NULL;
			const gchar* _tmp22_;
			const gchar* _tmp23_ = NULL;
			const gchar* _tmp24_;
			const gchar* _tmp25_ = NULL;
			gchar* _tmp26_ = NULL;
			gchar* _tmp27_;
			GError* _tmp28_;
			const gchar* _tmp29_;
			const gchar* _tmp30_ = NULL;
			gchar* _tmp31_ = NULL;
			gchar* _tmp32_;
			gchar* _tmp33_;
			gchar* _tmp34_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp20_ = my_address;
			_tmp21_ = string_to_string (_tmp20_);
			_tmp22_ = dest_address;
			_tmp23_ = string_to_string (_tmp22_);
			_tmp24_ = nic_name;
			_tmp25_ = string_to_string (_tmp24_);
			_tmp26_ = g_strconcat ("TunnelManager: ", _tmp21_, " to ", _tmp23_, ": ", _tmp25_, NULL);
			_tmp27_ = _tmp26_;
			_tmp28_ = e;
			_tmp29_ = _tmp28_->message;
			_tmp30_ = string_to_string (_tmp29_);
			_tmp31_ = g_strconcat (" has encountered problem during close: ", _tmp30_, NULL);
			_tmp32_ = _tmp31_;
			_tmp33_ = g_strconcat (_tmp27_, _tmp32_, NULL);
			_tmp34_ = _tmp33_;
			netsukuku_log_warn (_tmp34_);
			_g_free0 (_tmp34_);
			_g_free0 (_tmp32_);
			_g_free0 (_tmp27_);
			netsukuku_log_warn ("TunnelManager: Ignoring problem.");
			_g_error_free0 (e);
		}
		__finally113:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (ktunnel);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp35_ = self->priv->active_tunnels;
		_tmp36_ = nic_name;
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp35_, _tmp36_, NULL);
		_g_object_unref0 (ktunnel);
	}
}


/** Helper client-side **/
static Block8Data* block8_data_ref (Block8Data* _data8_) {
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}


static void block8_data_unref (void * _userdata_) {
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		NetsukukuTunnelManager * self;
		self = _data8_->self;
		_g_object_unref0 (_data8_->peer_server);
		_g_object_unref0 (self);
		g_slice_free (Block8Data, _data8_);
	}
}


static Block9Data* block9_data_ref (Block9Data* _data9_) {
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}


static void block9_data_unref (void * _userdata_) {
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		NetsukukuTunnelManager * self;
		self = _data9_->_data8_->self;
		block8_data_unref (_data9_->_data8_);
		_data9_->_data8_ = NULL;
		g_slice_free (Block9Data, _data9_);
	}
}


static void ___lambda19_ (Block9Data* _data9_, zcdISerializable* mesg, GError** error) {
	Block8Data* _data8_;
	NetsukukuTunnelManager * self;
	NetsukukuAddressManagerTCPClient* _tmp0_;
	NetsukukuITunnelManager* _tmp1_;
	NetsukukuITunnelManager* _tmp2_;
	zcdISerializable* _tmp3_;
	gint _tmp4_;
	GError * _inner_error_ = NULL;
	_data8_ = _data9_->_data8_;
	self = _data8_->self;
	g_return_if_fail (mesg != NULL);
	_tmp0_ = _data8_->peer_server;
	_tmp1_ = netsukuku_iaddress_manager_root_dispatcher_get_tunnel_manager ((NetsukukuIAddressManagerRootDispatcher*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = mesg;
	_tmp4_ = _data9_->peer_handler_id;
	netsukuku_itunnel_manager_handshake (_tmp2_, _tmp3_, _tmp4_, &_inner_error_);
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == NETSUKUKU_TUNNEL_ERROR) || (_inner_error_->domain == ZCD_RPC_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void ____lambda19__netsukuku_callback_send_delegate (zcdISerializable* msg, gpointer self, GError** error) {
	___lambda19_ (self, msg, error);
}


static zcdISerializable* ___lambda20_ (Block9Data* _data9_, GError** error) {
	Block8Data* _data8_;
	NetsukukuTunnelManager * self;
	zcdISerializable* result = NULL;
	GeeHashMap* _tmp0_;
	gint _tmp1_;
	gpointer _tmp2_ = NULL;
	TaskletsChannel* _tmp3_;
	GValue _tmp4_ = {0};
	zcdISerializable* _tmp5_;
	_data8_ = _data9_->_data8_;
	self = _data8_->self;
	_tmp0_ = self->priv->handlers;
	_tmp1_ = _data9_->my_handler_id;
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, (gpointer) ((gintptr) _tmp1_));
	_tmp3_ = (TaskletsChannel*) _tmp2_;
	tasklets_channel_recv (_tmp3_, &_tmp4_);
	_tmp5_ = g_value_get_object (&_tmp4_);
	_g_object_unref0 (_tmp3_);
	result = _tmp5_;
	return result;
}


static zcdISerializable* ____lambda20__netsukuku_callback_recv_delegate (gpointer self, GError** error) {
	zcdISerializable* result;
	result = ___lambda20_ (self, error);
	return result;
}


gchar* netsukuku_tunnel_manager_call_request_tunnel (NetsukukuTunnelManager* self, const gchar* dest_addr, GError** error) {
	gchar* result = NULL;
	Block8Data* _data8_;
	gchar* nic_name = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	NetsukukuAddressManagerTCPClient* _tmp2_;
	GeeArrayList* _tmp3_;
	GeeArrayList* protocols;
	GeeArrayList* _tmp4_;
	NetsukukuAddressManagerTCPClient* _tmp5_;
	NetsukukuITunnelManager* _tmp6_;
	NetsukukuITunnelManager* _tmp7_;
	GeeArrayList* _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* proto;
	const gchar* _tmp10_;
	GeeHashMap* _tmp32_;
	const gchar* _tmp33_;
	const gchar* _tmp34_;
	const gchar* _tmp35_;
	const gchar* _tmp36_;
	NetsukukuTunnelInfo* _tmp37_;
	NetsukukuTunnelInfo* _tmp38_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (dest_addr != NULL, NULL);
	_data8_ = g_slice_new0 (Block8Data);
	_data8_->_ref_count_ = 1;
	_data8_->self = g_object_ref (self);
	_tmp0_ = dest_addr;
	_tmp1_ = self->priv->_my_addr;
	_tmp2_ = netsukuku_address_manager_tcp_client_new (_tmp0_, NULL, _tmp1_, TRUE);
	_data8_->peer_server = _tmp2_;
	_tmp3_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	protocols = _tmp3_;
	_tmp4_ = protocols;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp4_, "tinc");
	_tmp5_ = _data8_->peer_server;
	_tmp6_ = netsukuku_iaddress_manager_root_dispatcher_get_tunnel_manager ((NetsukukuIAddressManagerRootDispatcher*) _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = protocols;
	_tmp9_ = netsukuku_itunnel_manager_choose_tunnel_protocol (_tmp7_, (GeeList*) _tmp8_, &_inner_error_);
	proto = _tmp9_;
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == NETSUKUKU_TUNNEL_ERROR) || (_inner_error_->domain == ZCD_RPC_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (protocols);
			_g_free0 (nic_name);
			block8_data_unref (_data8_);
			_data8_ = NULL;
			return NULL;
		} else {
			_g_object_unref0 (protocols);
			_g_free0 (nic_name);
			block8_data_unref (_data8_);
			_data8_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp10_ = proto;
	if (g_strcmp0 (_tmp10_, "tinc") == 0) {
		Block9Data* _data9_;
		gdouble _tmp11_ = 0.0;
		gint32 _tmp12_ = 0;
		TaskletsChannel* _tmp13_;
		TaskletsChannel* handler_channel;
		GeeHashMap* _tmp14_;
		gint _tmp15_;
		TaskletsChannel* _tmp16_;
		NetsukukuAddressManagerTCPClient* _tmp17_;
		NetsukukuITunnelManager* _tmp18_;
		NetsukukuITunnelManager* _tmp19_;
		const gchar* _tmp20_;
		gint _tmp21_;
		gint _tmp22_ = 0;
		NetsukukuCallbackSendDelegate cb_send;
		void* cb_send_target;
		GDestroyNotify cb_send_target_destroy_notify;
		NetsukukuCallbackRecvDelegate cb_recv;
		void* cb_recv_target;
		GDestroyNotify cb_recv_target_destroy_notify;
		NetsukukuBaseTunnel* _tmp23_ = NULL;
		NetsukukuBaseTunnel* ktunnel;
		NetsukukuBaseTunnel* _tmp24_;
		NetsukukuCallbackSendDelegate _tmp25_;
		void* _tmp25__target;
		NetsukukuCallbackRecvDelegate _tmp26_;
		void* _tmp26__target;
		const gchar* _tmp27_;
		const gchar* _tmp28_;
		gchar* _tmp29_ = NULL;
		gchar* _tmp30_;
		_data9_ = g_slice_new0 (Block9Data);
		_data9_->_ref_count_ = 1;
		_data9_->_data8_ = block8_data_ref (_data8_);
		_tmp11_ = pow ((gdouble) 2, (gdouble) 32);
		_tmp12_ = g_random_int_range ((gint32) 0, (gint32) (((gint) _tmp11_) - 1));
		_data9_->my_handler_id = (gint) _tmp12_;
		_tmp13_ = tasklets_channel_new (NULL);
		handler_channel = _tmp13_;
		_tmp14_ = self->priv->handlers;
		_tmp15_ = _data9_->my_handler_id;
		_tmp16_ = handler_channel;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp14_, (gpointer) ((gintptr) _tmp15_), _tmp16_);
		_tmp17_ = _data8_->peer_server;
		_tmp18_ = netsukuku_iaddress_manager_root_dispatcher_get_tunnel_manager ((NetsukukuIAddressManagerRootDispatcher*) _tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = proto;
		_tmp21_ = _data9_->my_handler_id;
		_tmp22_ = netsukuku_itunnel_manager_request_tunnel (_tmp19_, _tmp20_, _tmp21_, NULL, &_inner_error_);
		_data9_->peer_handler_id = _tmp22_;
		if (_inner_error_ != NULL) {
			if ((_inner_error_->domain == NETSUKUKU_TUNNEL_ERROR) || (_inner_error_->domain == ZCD_RPC_ERROR)) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (handler_channel);
				block9_data_unref (_data9_);
				_data9_ = NULL;
				_g_free0 (proto);
				_g_object_unref0 (protocols);
				_g_free0 (nic_name);
				block8_data_unref (_data8_);
				_data8_ = NULL;
				return NULL;
			} else {
				_g_object_unref0 (handler_channel);
				block9_data_unref (_data9_);
				_data9_ = NULL;
				_g_free0 (proto);
				_g_object_unref0 (protocols);
				_g_free0 (nic_name);
				block8_data_unref (_data8_);
				_data8_ = NULL;
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		cb_send = ____lambda19__netsukuku_callback_send_delegate;
		cb_send_target = block9_data_ref (_data9_);
		cb_send_target_destroy_notify = block9_data_unref;
		cb_recv = ____lambda20__netsukuku_callback_recv_delegate;
		cb_recv_target = block9_data_ref (_data9_);
		cb_recv_target_destroy_notify = block9_data_unref;
		_tmp23_ = netsukuku_base_tunnel_get_instance ();
		ktunnel = _tmp23_;
		_tmp24_ = ktunnel;
		_tmp25_ = cb_send;
		_tmp25__target = cb_send_target;
		_tmp26_ = cb_recv;
		_tmp26__target = cb_recv_target;
		_tmp27_ = self->priv->_my_addr;
		_tmp28_ = dest_addr;
		_tmp29_ = netsukuku_base_tunnel_request (_tmp24_, _tmp25_, _tmp25__target, _tmp26_, _tmp26__target, _tmp27_, _tmp28_, &_inner_error_);
		_tmp30_ = _tmp29_;
		if (_inner_error_ != NULL) {
			if ((_inner_error_->domain == NETSUKUKU_TUNNEL_ERROR) || (_inner_error_->domain == ZCD_RPC_ERROR)) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (ktunnel);
				(cb_recv_target_destroy_notify == NULL) ? NULL : (cb_recv_target_destroy_notify (cb_recv_target), NULL);
				cb_recv = NULL;
				cb_recv_target = NULL;
				cb_recv_target_destroy_notify = NULL;
				(cb_send_target_destroy_notify == NULL) ? NULL : (cb_send_target_destroy_notify (cb_send_target), NULL);
				cb_send = NULL;
				cb_send_target = NULL;
				cb_send_target_destroy_notify = NULL;
				_g_object_unref0 (handler_channel);
				block9_data_unref (_data9_);
				_data9_ = NULL;
				_g_free0 (proto);
				_g_object_unref0 (protocols);
				_g_free0 (nic_name);
				block8_data_unref (_data8_);
				_data8_ = NULL;
				return NULL;
			} else {
				_g_object_unref0 (ktunnel);
				(cb_recv_target_destroy_notify == NULL) ? NULL : (cb_recv_target_destroy_notify (cb_recv_target), NULL);
				cb_recv = NULL;
				cb_recv_target = NULL;
				cb_recv_target_destroy_notify = NULL;
				(cb_send_target_destroy_notify == NULL) ? NULL : (cb_send_target_destroy_notify (cb_send_target), NULL);
				cb_send = NULL;
				cb_send_target = NULL;
				cb_send_target_destroy_notify = NULL;
				_g_object_unref0 (handler_channel);
				block9_data_unref (_data9_);
				_data9_ = NULL;
				_g_free0 (proto);
				_g_object_unref0 (protocols);
				_g_free0 (nic_name);
				block8_data_unref (_data8_);
				_data8_ = NULL;
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_g_free0 (nic_name);
		nic_name = _tmp30_;
		_g_object_unref0 (ktunnel);
		(cb_recv_target_destroy_notify == NULL) ? NULL : (cb_recv_target_destroy_notify (cb_recv_target), NULL);
		cb_recv = NULL;
		cb_recv_target = NULL;
		cb_recv_target_destroy_notify = NULL;
		(cb_send_target_destroy_notify == NULL) ? NULL : (cb_send_target_destroy_notify (cb_send_target), NULL);
		cb_send = NULL;
		cb_send_target = NULL;
		cb_send_target_destroy_notify = NULL;
		_g_object_unref0 (handler_channel);
		block9_data_unref (_data9_);
		_data9_ = NULL;
	} else {
		GError* _tmp31_;
		_tmp31_ = g_error_new_literal (NETSUKUKU_TUNNEL_ERROR, NETSUKUKU_TUNNEL_ERROR_GENERIC, "Invalid protocol");
		_inner_error_ = _tmp31_;
		if ((_inner_error_->domain == NETSUKUKU_TUNNEL_ERROR) || (_inner_error_->domain == ZCD_RPC_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (proto);
			_g_object_unref0 (protocols);
			_g_free0 (nic_name);
			block8_data_unref (_data8_);
			_data8_ = NULL;
			return NULL;
		} else {
			_g_free0 (proto);
			_g_object_unref0 (protocols);
			_g_free0 (nic_name);
			block8_data_unref (_data8_);
			_data8_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp32_ = self->priv->active_tunnels;
	_tmp33_ = nic_name;
	_tmp34_ = nic_name;
	_tmp35_ = self->priv->_my_addr;
	_tmp36_ = dest_addr;
	_tmp37_ = netsukuku_tunnel_info_new (_tmp34_, _tmp35_, _tmp36_);
	_tmp38_ = _tmp37_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp32_, _tmp33_, _tmp38_);
	_g_object_unref0 (_tmp38_);
	result = nic_name;
	_g_free0 (proto);
	_g_object_unref0 (protocols);
	block8_data_unref (_data8_);
	_data8_ = NULL;
	return result;
}


void netsukuku_tunnel_manager_call_close_tunnel (NetsukukuTunnelManager* self, const gchar* dest_addr, const gchar* nic_name) {
	gboolean _tmp0_ = FALSE;
	GeeHashMap* _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp14_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dest_addr != NULL);
	g_return_if_fail (nic_name != NULL);
	_tmp1_ = self->priv->active_tunnels;
	_tmp2_ = nic_name;
	_tmp3_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp1_, _tmp2_);
	if (_tmp3_) {
		GeeHashMap* _tmp4_;
		const gchar* _tmp5_;
		gpointer _tmp6_ = NULL;
		NetsukukuTunnelInfo* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		NetsukukuTunnelInfo* _tmp11_;
		NetsukukuTunnelInfo* _tmp12_;
		gboolean _tmp13_ = FALSE;
		_tmp4_ = self->priv->active_tunnels;
		_tmp5_ = nic_name;
		_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp4_, _tmp5_);
		_tmp7_ = (NetsukukuTunnelInfo*) _tmp6_;
		_tmp8_ = nic_name;
		_tmp9_ = self->priv->_my_addr;
		_tmp10_ = dest_addr;
		_tmp11_ = netsukuku_tunnel_info_new (_tmp8_, _tmp9_, _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = netsukuku_tunnel_info_equals (_tmp7_, _tmp12_);
		_tmp0_ = _tmp13_;
		_g_object_unref0 (_tmp12_);
		_g_object_unref0 (_tmp7_);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp14_ = _tmp0_;
	if (_tmp14_) {
		gboolean done;
		const gchar* _tmp28_;
		const gchar* _tmp29_;
		const gchar* _tmp30_;
		gboolean _tmp31_;
		done = FALSE;
		{
			const gchar* _tmp15_;
			const gchar* _tmp16_;
			NetsukukuAddressManagerTCPClient* _tmp17_;
			NetsukukuAddressManagerTCPClient* peer_server;
			NetsukukuAddressManagerTCPClient* _tmp18_;
			NetsukukuITunnelManager* _tmp19_;
			NetsukukuITunnelManager* _tmp20_;
			const gchar* _tmp21_;
			_tmp15_ = dest_addr;
			_tmp16_ = self->priv->_my_addr;
			_tmp17_ = netsukuku_address_manager_tcp_client_new (_tmp15_, NULL, _tmp16_, FALSE);
			peer_server = _tmp17_;
			_tmp18_ = peer_server;
			_tmp19_ = netsukuku_iaddress_manager_root_dispatcher_get_tunnel_manager ((NetsukukuIAddressManagerRootDispatcher*) _tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = nic_name;
			netsukuku_itunnel_manager_close_tunnel (_tmp20_, _tmp21_, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (peer_server);
				goto __catch114_g_error;
			}
			done = TRUE;
			_g_object_unref0 (peer_server);
		}
		goto __finally114;
		__catch114_g_error:
		{
			const gchar* _tmp22_;
			const gchar* _tmp23_ = NULL;
			const gchar* _tmp24_;
			const gchar* _tmp25_ = NULL;
			gchar* _tmp26_ = NULL;
			gchar* _tmp27_;
			g_clear_error (&_inner_error_);
			_inner_error_ = NULL;
			_tmp22_ = self->priv->_my_addr;
			_tmp23_ = string_to_string (_tmp22_);
			_tmp24_ = dest_addr;
			_tmp25_ = string_to_string (_tmp24_);
			_tmp26_ = g_strconcat ("TunnelManager: ", _tmp23_, " communication fail to ", _tmp25_, NULL);
			_tmp27_ = _tmp26_;
			netsukuku_log_warn (_tmp27_);
			_g_free0 (_tmp27_);
		}
		__finally114:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp28_ = nic_name;
		_tmp29_ = self->priv->_my_addr;
		_tmp30_ = dest_addr;
		netsukuku_tunnel_manager_close_my_tunnel (self, _tmp28_, _tmp29_, _tmp30_);
		_tmp31_ = done;
		if (!_tmp31_) {
			{
				const gchar* _tmp32_;
				const gchar* _tmp33_;
				NetsukukuAddressManagerTCPClient* _tmp34_;
				NetsukukuAddressManagerTCPClient* peer_server;
				NetsukukuAddressManagerTCPClient* _tmp35_;
				NetsukukuITunnelManager* _tmp36_;
				NetsukukuITunnelManager* _tmp37_;
				const gchar* _tmp38_;
				_tmp32_ = dest_addr;
				_tmp33_ = self->priv->_my_addr;
				_tmp34_ = netsukuku_address_manager_tcp_client_new (_tmp32_, NULL, _tmp33_, FALSE);
				peer_server = _tmp34_;
				_tmp35_ = peer_server;
				_tmp36_ = netsukuku_iaddress_manager_root_dispatcher_get_tunnel_manager ((NetsukukuIAddressManagerRootDispatcher*) _tmp35_);
				_tmp37_ = _tmp36_;
				_tmp38_ = nic_name;
				netsukuku_itunnel_manager_close_tunnel (_tmp37_, _tmp38_, NULL, &_inner_error_);
				if (_inner_error_ != NULL) {
					_g_object_unref0 (peer_server);
					goto __catch115_g_error;
				}
				_g_object_unref0 (peer_server);
			}
			goto __finally115;
			__catch115_g_error:
			{
				const gchar* _tmp39_;
				const gchar* _tmp40_ = NULL;
				const gchar* _tmp41_;
				const gchar* _tmp42_ = NULL;
				gchar* _tmp43_ = NULL;
				gchar* _tmp44_;
				g_clear_error (&_inner_error_);
				_inner_error_ = NULL;
				_tmp39_ = self->priv->_my_addr;
				_tmp40_ = string_to_string (_tmp39_);
				_tmp41_ = dest_addr;
				_tmp42_ = string_to_string (_tmp41_);
				_tmp43_ = g_strconcat ("TunnelManager: ", _tmp40_, " communication fail to ", _tmp42_, NULL);
				_tmp44_ = _tmp43_;
				netsukuku_log_warn (_tmp44_);
				_g_free0 (_tmp44_);
			}
			__finally115:
			if (_inner_error_ != NULL) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
}


const gchar* netsukuku_tunnel_manager_get_my_addr (NetsukukuTunnelManager* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_my_addr;
	result = _tmp0_;
	return result;
}


static void netsukuku_tunnel_manager_set_my_addr (NetsukukuTunnelManager* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_my_addr);
	self->priv->_my_addr = _tmp1_;
	g_object_notify ((GObject *) self, "my-addr");
}


static void netsukuku_tunnel_manager_class_init (NetsukukuTunnelManagerClass * klass) {
	netsukuku_tunnel_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (NetsukukuTunnelManagerPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_netsukuku_tunnel_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_netsukuku_tunnel_manager_set_property;
	G_OBJECT_CLASS (klass)->finalize = netsukuku_tunnel_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETSUKUKU_TUNNEL_MANAGER_MY_ADDR, g_param_spec_string ("my-addr", "my-addr", "my-addr", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void netsukuku_tunnel_manager_netsukuku_itunnel_manager_interface_init (NetsukukuITunnelManagerIface * iface) {
	netsukuku_tunnel_manager_netsukuku_itunnel_manager_parent_iface = g_type_interface_peek_parent (iface);
	iface->choose_tunnel_protocol = (gchar* (*)(NetsukukuITunnelManager*, GeeList*, GError**)) netsukuku_tunnel_manager_real_choose_tunnel_protocol;
	iface->request_tunnel = (gint (*)(NetsukukuITunnelManager*, const gchar*, gint, zcdCallerInfo*, GError**)) netsukuku_tunnel_manager_real_request_tunnel;
	iface->handshake = (void (*)(NetsukukuITunnelManager*, zcdISerializable*, gint, GError**)) netsukuku_tunnel_manager_real_handshake;
	iface->close_tunnel = (void (*)(NetsukukuITunnelManager*, const gchar*, zcdCallerInfo*, GError**)) netsukuku_tunnel_manager_real_close_tunnel;
}


static void netsukuku_tunnel_manager_instance_init (NetsukukuTunnelManager * self) {
	self->priv = NETSUKUKU_TUNNEL_MANAGER_GET_PRIVATE (self);
}


static void netsukuku_tunnel_manager_finalize (GObject* obj) {
	NetsukukuTunnelManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_TUNNEL_MANAGER, NetsukukuTunnelManager);
	_g_free0 (self->priv->_my_addr);
	_g_object_unref0 (self->priv->handlers);
	_g_object_unref0 (self->priv->active_tunnels);
	G_OBJECT_CLASS (netsukuku_tunnel_manager_parent_class)->finalize (obj);
}


GType netsukuku_tunnel_manager_get_type (void) {
	static volatile gsize netsukuku_tunnel_manager_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_tunnel_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuTunnelManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_tunnel_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuTunnelManager), 0, (GInstanceInitFunc) netsukuku_tunnel_manager_instance_init, NULL };
		static const GInterfaceInfo netsukuku_itunnel_manager_info = { (GInterfaceInitFunc) netsukuku_tunnel_manager_netsukuku_itunnel_manager_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType netsukuku_tunnel_manager_type_id;
		netsukuku_tunnel_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "NetsukukuTunnelManager", &g_define_type_info, 0);
		g_type_add_interface_static (netsukuku_tunnel_manager_type_id, NETSUKUKU_TYPE_ITUNNEL_MANAGER, &netsukuku_itunnel_manager_info);
		g_once_init_leave (&netsukuku_tunnel_manager_type_id__volatile, netsukuku_tunnel_manager_type_id);
	}
	return netsukuku_tunnel_manager_type_id__volatile;
}


static void _vala_netsukuku_tunnel_manager_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	NetsukukuTunnelManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETSUKUKU_TYPE_TUNNEL_MANAGER, NetsukukuTunnelManager);
	switch (property_id) {
		case NETSUKUKU_TUNNEL_MANAGER_MY_ADDR:
		g_value_set_string (value, netsukuku_tunnel_manager_get_my_addr (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_netsukuku_tunnel_manager_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	NetsukukuTunnelManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETSUKUKU_TYPE_TUNNEL_MANAGER, NetsukukuTunnelManager);
	switch (property_id) {
		case NETSUKUKU_TUNNEL_MANAGER_MY_ADDR:
		netsukuku_tunnel_manager_set_my_addr (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



