/*
 *  This file is part of Netsukuku.
 *  (c) Copyright 2011-2014 Luca Dionisi aka lukisi <luca.dionisi@gmail.com>
 *
 *  Netsukuku is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Netsukuku is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Netsukuku.  If not, see <http://www.gnu.org/licenses/>.
 */

using Gee;
using Netsukuku;
using Tasklets;
using zcd;

namespace Netsukuku
{
#if log_tasklet
    private string tasklet_id()
    {
        return @"[$(Tasklet.self().id)] ";
    }
#else
    private string tasklet_id()
    {
        return "";
    }
#endif
    internal void log_debug(string msg) {Posix.syslog(Posix.LOG_DEBUG, tasklet_id()+msg);}
    internal void log_info(string msg) {Posix.syslog(Posix.LOG_INFO, tasklet_id()+msg);}
    internal void log_notice(string msg) {Posix.syslog(Posix.LOG_NOTICE, tasklet_id()+msg);}
    internal void log_warn(string msg) {Posix.syslog(Posix.LOG_WARNING, tasklet_id()+msg);}
    internal void log_error(string msg) {Posix.syslog(Posix.LOG_ERR, tasklet_id()+msg);}
    internal void log_critical(string msg) {Posix.syslog(Posix.LOG_CRIT, tasklet_id()+msg);}

    namespace Crypto
    {
        public errordomain GCryptError {GENERIC}
        public uint32 fnv_32(uchar[] data) {return 0;}
    }

    public errordomain IncomingNodesError {GENERIC}

    public errordomain RPCError {
        FUNCTION_NOT_REMOTABLE,
        MALFORMED_PACKET,
        NETWORK_ERROR,
        NOT_VALID_MAP_YET,
        DROP,
        GENERIC
    }
    public ArrayList<int> valid_ids(int levels, int gsize, int lvl, PartialNIP partial_nip)
    {
        ArrayList<int> ret = new ArrayList<int>();
        for (int i = 0; i < gsize; i++) ret.add(i);
        return ret;
    }
    public string nip_to_str(int levels, int gsize, NIP nip) {return "";}
    public class Route : Object
    {
        public REM rem;
        public REM rem_at_gw;
        public Gee.List<HCoord> hops;
        public GNodeID gid;
        public Gee.List<HCoord> hops_with_gw;
    }
    public class RouteNode : Object
    {
        public bool is_empty() {return false;}
        public bool is_free() {return false;}
        public GNodeID? get_eldest_gid() {return null;}
        public int nroutes() {return 0;}
        public Route? best_route() {return null;}
        public Route? best_route_without(HCoord hop) {return null;}
        public Route? route_get_by_gw(AggregatedNeighbour aggregated_neighbour) {return null;}
    }
    public class MapRoute : Object
    {
        public AddressManager address_manager;
        public GNodeID[] id_myself {get; private set;}
        public int gsize;
        public int levels;
        public NIP me;
        public HCoord? nip_to_lvlid(NIP nip_caller) {return null;}
        public RouteNode? node_get(int lvl, int pos) {return null;}
        public Gee.List<HCoord> list_lvl_id_from_nip(Gee.List<HCoord> lvl_ids, NIP sender_nip) {return new ArrayList<HCoord>();}
        public Gee.List<HCoord> list_lvl_id_to_nip(Gee.List<HCoord> lvl_ids, NIP to_nip) {return new ArrayList<HCoord>();}
        public int nip_cmp(int[] nipA)
        {
            return NIP.nip_cmp(nipA, me.get_positions());
        }
        public void update_route_by_gw(HCoord dest, AggregatedNeighbour nr, REM rem_at_gw, Gee.List<HCoord> hops, GNodeID gid) {}
        public int busy_nodes_nb(int lvl) {return 1;}
        public void route_signal_rem_changed(int lvl, int dst) {}
        public void delete_routes_via_neighbour(AggregatedNeighbour aggregated_neighbour) {}
    }
    public class AddressManager : Object
    {
        public ArrayList<NetworkInterfaceManager> nics;
        public NetworkID? get_main_netid() {return null;}
        public bool is_in_my_network(NetworkID netid) {return true;}
        public IncomingNodes incoming_nodes;
        public bool do_i_act_as_gateway_for(NIP nip, int nodeid, NetworkID netid) {return false;}
        public int get_my_id() {return 0;}
        public AddressManagerFakeRmt get_broadcast_client() {return new FakeAddressManagerFakeRmt();}
        public bool is_preferred_network(NetworkID netid) {return false;}
        public bool is_mature;
    }
    public class NIC : Object
    {
        public string mac;
    }
    public class NetworkInterfaceManager : Object
    {
        public NIC nic_class {get; private set;}
        public string nic_name {get; private set;}
        public bool to_be_managed;
        public bool to_be_copied;
        public bool initialized;
    }
    public class AggregatedNeighbourManager : Object
    {
        public signal void aggregated_neighbour_new(AggregatedNeighbour aggregated_neighbour);
        public signal void aggregated_neighbour_new_before(AggregatedNeighbour aggregated_neighbour);
        public signal void aggregated_neighbour_deleted(AggregatedNeighbour aggregated_neighbour);
        public signal void aggregated_neighbour_deleted_after(AggregatedNeighbour aggregated_neighbour);
        public signal void aggregated_neighbour_rem_chged(AggregatedNeighbour aggregated_neighbour, REM old_rem);
        public signal void aggregated_neighbour_rem_chged_before(AggregatedNeighbour aggregated_neighbour, REM old_rem);
        public signal void aggregated_neighbour_going_new(AggregatedNeighbour aggregated_neighbour);
        public signal void aggregated_neighbour_going_deleted(AggregatedNeighbour aggregated_neighbour);
        public signal void aggregated_neighbour_going_rem_chged(AggregatedNeighbour aggregated_neighbour);
        public signal void aggregated_neighbour_colliding_new(AggregatedNeighbour aggregated_neighbour);
        public signal void aggregated_neighbour_colliding_deleted(AggregatedNeighbour aggregated_neighbour);
        public signal void aggregated_neighbour_colliding_rem_chged(AggregatedNeighbour aggregated_neighbour, REM old_rem);
        public signal void aggregated_neighbour_colliding_going_new(AggregatedNeighbour aggregated_neighbour);
        public signal void aggregated_neighbour_colliding_going_deleted(AggregatedNeighbour aggregated_neighbour);
        public signal void aggregated_neighbour_colliding_going_rem_chged(AggregatedNeighbour aggregated_neighbour);
        public Gee.List<AggregatedNeighbour> neighbour_list(bool? b=null, NetworkID? with_this_netid=null) {return new ArrayList<AggregatedNeighbour>();}
        public AggregatedNeighbour? key_to_neighbour(NIP nip, int nodeid) {return null;}
    }
    public class AggregatedNeighbour : Object
    {
        public NIP nip;
        public REM rem;
        public int mod_seq_num;
        public NetworkID netid;
        public string to_string() {return "";}
        public AddressManagerFakeRmt neighbour_client;
        public int nodeid;
        public AddressManagerFakeRmt create_neighbour_client(bool response=true)
        {return new FakeAddressManagerFakeRmt();}
        public static bool equal_func(AggregatedNeighbour? a, AggregatedNeighbour? b) { return true; }
        public static uint hash_func(AggregatedNeighbour a) { return 0; }
    }
    public class FakeAddressManagerFakeRmt : AddressManagerFakeRmt
    {
        public Etp etp;
        public override ISerializable rmt(RemoteCall data) {return null;}
    }
    public class IncomingNodes
    {
        public bool contains(NIP nip, int nodeid) {return false;}
        public RoutesSet? get_knowledge(NIP nip, int nodeid, int prev_seq_num) {return null;}
        public void update(NIP nip, int nodeid, Gee.List<string> macs, int? ttl=null) {}
        public void log_knowledge(NIP nip, int nodeid, int my_seq_num, RoutesSet destinations) {}
        public void purge() {}
    }
}

namespace Ntk.Test
{
    public class QspnTester : Object
    {
        string logger;
        const bool output = false;

        public void set_up ()
        {
            logger = "";
        }

        public void tear_down ()
        {
            logger = "";
        }

        public void test_basics ()
        {
            // I am 10.1.2.3 in a network with 3 levels and 255 gsize.
            TracerPacketList l1 = new TracerPacketList();
            l1.append(3, new NullREM());
            // I pass it to a neighbour: 10.3.4.5
            // For him I am hop 1 in level 2:
            TracerPacketList l2 = l1.clone();
            l2.group(2, 1);
            assert(! l2.contains(new NIP({5, 4, 3})));
            l2.append(5, new RTT(100));
            if (output) stdout.printf(@"\nTPL = $(l2)\n");
            // 
            RoutesSet r = new RoutesSet(4);
            r.add_replace(3, 1, new NullREM(), new ArrayList<HCoord>(HCoord.equal_func), new GNodeID(0, 0, 1234));
            r.add_replace(3, 2, new NullREM(), new ArrayList<HCoord>(HCoord.equal_func), new GNodeID(0, 0, 1234));
            r.add_replace(2, 1, new NullREM(), new ArrayList<HCoord>(HCoord.equal_func), new GNodeID(0, 0, 1234));
            bool has_one = false;
            bool has_two = false;
            foreach (int dst in r.per_level[3])
            {
                if (dst == 1) has_one = true;
                if (dst == 2) has_two = true;
                RouteInSet ris = r.get_value(3, dst);
                assert(ris.rem.get_type() == typeof(NullREM));
                assert(ris.hops.is_empty);
            }
            assert(has_one && has_two);
            //
            RouteInSet ris0;
            {
                uchar[] orig;
                {
                    int dst = 2;
                    REM rem = new NullREM();
                    Gee.List<HCoord> hops = new ArrayList<HCoord>(HCoord.equal_func);
                    hops.add(new HCoord(3, 4));
                    GNodeID gid = new GNodeID(1,1,12345);
                    RouteInSet ris = new RouteInSet(rem, hops, gid);
                    orig = ris.serialize();
                }
                uchar []dest = new uchar[orig.length];
                for (int i = 0; i < orig.length; i++) dest[i] = orig[i];
                ris0 = (RouteInSet)ISerializable.deserialize(dest);
            }
            assert(! ris0.hops.is_empty);
            assert(ris0.rem.get_type() == typeof(NullREM));
            {
                uchar[] orig;
                {
                    int dst = 2;
                    REM rem = new DeadREM();
                    Gee.List<HCoord> hops = new ArrayList<HCoord>(HCoord.equal_func);
                    GNodeID? gid = null;
                    RouteInSet ris = new RouteInSet(rem, hops, gid);
                    orig = ris.serialize();
                }
                uchar []dest = new uchar[orig.length];
                for (int i = 0; i < orig.length; i++) dest[i] = orig[i];
                ris0 = (RouteInSet)ISerializable.deserialize(dest);
            }
            assert(ris0.hops.is_empty);
            assert(ris0.rem.get_type() == typeof(DeadREM));
            // An empty RoutesSetPerLevel
            RoutesSetPerLevel rsl0;
            {
                uchar[] orig;
                {
                    RoutesSetPerLevel rsl = new RoutesSetPerLevel();
                    orig = rsl.serialize();
                }
                uchar []dest = new uchar[orig.length];
                for (int i = 0; i < orig.length; i++) dest[i] = orig[i];
                rsl0 = (RoutesSetPerLevel)ISerializable.deserialize(dest);
            }
            foreach (int i in rsl0) assert(false); // should be empty
            // Another RoutesSetPerLevel
            {
                uchar[] orig;
                {
                    int dst = 2;
                    REM rem = new NullREM();
                    Gee.List<HCoord> hops = new ArrayList<HCoord>(HCoord.equal_func);
                    hops.add(new HCoord(3, 4));
                    GNodeID gid = new GNodeID(1,1,12345);
                    RoutesSetPerLevel rsl = new RoutesSetPerLevel();
                    rsl.add_replace(dst, rem, hops, gid);
                    orig = rsl.serialize();
                }
                uchar []dest = new uchar[orig.length];
                for (int i = 0; i < orig.length; i++) dest[i] = orig[i];
                rsl0 = (RoutesSetPerLevel)ISerializable.deserialize(dest);
            }
            foreach (int i in rsl0)
            {
                assert(i == 2); // should have dst 2
                RouteInSet? ris = rsl0.get_value(i);
                assert(ris.rem.get_type() == typeof(NullREM));
                assert(ris.hops.size == 1);
                assert(ris.gid.ident == 12345);
            }
            // An empty RoutesSet with 4 levels
            RoutesSet rs0;
            {
                uchar[] orig;
                {
                    RoutesSet rs = new RoutesSet(4);
                    orig = rs.serialize();
                }
                uchar []dest = new uchar[orig.length];
                for (int i = 0; i < orig.length; i++) dest[i] = orig[i];
                rs0 = (RoutesSet)ISerializable.deserialize(dest);
            }
            assert(rs0.per_level.length == 4);
            foreach (int i in rs0.per_level[3]) assert(false); // should be empty
            // Another RouteSet
            {
                uchar[] orig;
                {
                    RoutesSet rs = new RoutesSet(4);
                    // 1st: a route to (1,2)
                    int lvl1 = 1;
                    int dst1 = 2;
                    REM rem1 = new NullREM();
                    Gee.List<HCoord> hops1 = new ArrayList<HCoord>(HCoord.equal_func);
                    hops1.add(new HCoord(3, 4));
                    GNodeID gid1 = new GNodeID(1,1,12345);
                    rs.add_replace(lvl1, dst1, rem1, hops1, gid1);
                    // 2nd: a route to (3,4)
                    int lvl2 = 3;
                    int dst2 = 4;
                    REM rem2 = new NullREM();
                    Gee.List<HCoord> hops2 = new ArrayList<HCoord>(HCoord.equal_func);
                    GNodeID gid2 = new GNodeID(1,1,54321);
                    rs.add_replace(lvl2, dst2, rem2, hops2, gid2);
                    // 3rd: no routes to (0,1)
                    rs.add_replace_no_route(0, 1);
                    orig = rs.serialize();
                }
                uchar []dest = new uchar[orig.length];
                for (int i = 0; i < orig.length; i++) dest[i] = orig[i];
                rs0 = (RoutesSet)ISerializable.deserialize(dest);
            }
            for (int lvl = 0; lvl < rs0.per_level.length; lvl++)
            {
                foreach (int dst in rs0.per_level[lvl])
                {
                    if (output) stdout.printf(@"one item in $lvl, $dst.\n");
                    RouteInSet? ris = rs0.get_value(lvl, dst);
                    if (output && ris == null) stdout.printf("no routes to it.\n");
                    if (output && ris != null) stdout.printf(@"REM = $(ris.rem).\n");
                }
            }
            RouteInSet ris12 = rs0.get_value(1, 2);
            assert(ris12.rem.get_type() == typeof(NullREM));
            assert(ris12.hops.size == 1);
            assert(ris12.gid.ident == 12345);
            RouteInSet ris34 = rs0.get_value(3, 4);
            assert(ris34.rem.get_type() == typeof(NullREM));
            assert(ris34.hops.size == 0);
            assert(ris34.gid.ident == 54321);
            RouteInSet ris01 = rs0.get_value(0, 1);
            assert(ris01.rem.get_type() == typeof(DeadREM));
        }

        public static int main(string[] args)
        {
            GLib.Test.init(ref args);
            GLib.Test.add_func ("/Qspn/Basics", () => {
                var x = new QspnTester();
                x.set_up();
                x.test_basics();
                x.tear_down();
            });
            GLib.Test.run();
            return 0;
        }
    }
}
