/*
 *  This file is part of Netsukuku.
 *  (c) Copyright 2011-2014 Luca Dionisi aka lukisi <luca.dionisi@gmail.com>
 *
 *  Netsukuku is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Netsukuku is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Netsukuku.  If not, see <http://www.gnu.org/licenses/>.
 */

using Gee;
using Netsukuku;
using Tasklets;
using zcd;
using Ntk.Test;

namespace Netsukuku
{
#if log_tasklet
    private string tasklet_id()
    {
        return @"[$(Tasklet.self().id)] ";
    }
#else
    private string tasklet_id()
    {
        return "";
    }
#endif
    internal void log_debug(string msg) {print_out(tasklet_id()+msg+"\n");}
    internal void log_info(string msg) {print_out(tasklet_id()+msg+"\n");}
    internal void log_notice(string msg) {print_out(tasklet_id()+msg+"\n");}
    internal void log_warn(string msg) {print_out(tasklet_id()+msg+"\n");}
    internal void log_error(string msg) {print_out(tasklet_id()+msg+"\n");}
    internal void log_critical(string msg) {print_out(tasklet_id()+msg+"\n");}

    namespace AndnaConst
    {
        // 30 days in millisec
        int64 MAX_TTL_ANDNA = (int64)1000 * (int64)60 * (int64)60 * (int64)24 * (int64)30;
    }

    public errordomain PeerToPeerError {
        REGISTER,
        GENERIC
    }

    public class RmtPeer : Object
    {
        public RmtPeer(PeerToPeer peer_to_peer_service, Object? key=null, NIP? hIP=null, AggregatedNeighbour? aggregated_neighbour=null)
        {
        }

        public virtual ISerializable rmt(RemoteCall data) throws Error
        {
            return new SerializableNone();
        }
    }

    public class PeerToPeerAll : Object
    {
        public virtual void peer_to_peer_register(PeerToPeer peer_to_peer) throws PeerToPeerError
        {
        }
    }

    public class PeerToPeer : Object
    {
        public PeerToPeer(AggregatedNeighbourManager aggregated_neighbour_manager,
                    MapRoute maproute, int pid)
        {
            this.maproute = maproute;
        }

        public weak MapRoute maproute;

        public virtual ISerializable _dispatch (Object? caller, RemoteCall data) throws GLib.Error
        {
            return null;
        }

        public signal void map_peer_to_peer_validated();

        public virtual NIP h(Object key)
        {
            return (NIP)key;
        }

        public Gee.List<int> list_ids(int center, int sign)
        {
            return new ArrayList<int>();
        }

        public void find_hook_peers(out int? ret_first_forward,
                                    out int? ret_first_back,
                                    out int? ret_last_back,
                                    int lvl, int num_dupl, int timeout=120000)
        {
        }

        public int get_number_of_participants(int lvl, int pos, int timeout)
        {
            return 0;
        }

        public Gee.List<NIP> find_nearest_to_register(NIP hash_nip, int num_dupl)
        {
            ArrayList<NIP> ret = new ArrayList<NIP>(PartialNIP.equal_func);
            return ret;
        }

        public HCoord? search_participant(NIP hIP, int path_sign=1) throws PeerToPeerError
        {
            return null;
        }

        public PartialNIP search_participant_as_nip(NIP hIP, int path_sign=1) throws PeerToPeerError
        {
            return null;
        }
    }

    public class OptionalPeerToPeer : PeerToPeer
    {
        //public MapPeerToPeer map_peer_to_peer;
        public bool will_participate;
        public OptionalPeerToPeer(AggregatedNeighbourManager aggregated_neighbour_manager,
                    MapRoute maproute, int pid)
        {
            base(aggregated_neighbour_manager, maproute, pid);
        }

        public bool hooked = false;
        public void participate()
        {
            hooked = true;
        }
        public bool participant;
    }

    delegate bool AcceptRecordCallback();
    delegate void RefuseRecordCallback();
    delegate void ForwardRecordCallback(
                        Object? obj1,
                        owned Gee.List<NIP>? replica_nodes=null);
    void check_hash_and_start_replica(
                        PeerToPeer service,
                        NIP hash_nip,
                        bool replicate,
                        Object? obj1,
                        int replica_nodes_max,
                        AcceptRecordCallback accept_callback,
                        ForwardRecordCallback forward_callback,
                        RefuseRecordCallback? refuse_callback=null)
                        throws PeerRefuseServiceError
    {}

    public class AggregatedNeighbourManager : Object
    {
    }

    public class AggregatedNeighbour : Object
    {
    }

    public class Counter : Object
    {
        public CounterCheckHostnameResponse ask_check_hostname
               (NIP nip,
                string hashed_hostname,
                PublicKey pubkey)
               throws RPCError, PeerRefuseServiceError
        {
            throw new PeerRefuseServiceError.GENERIC("not impl");
        }
    }

    public class MapRoute : Object
    {
        public MapRoute(int l, int s, NIP n)
        {
            levels = l;
            gsize = s;
            me = n;
        }
        public int levels;
        public int gsize;
        public NIP me;
        public PartialNIP? choose_fast(Gee.List<PartialNIP> choose_from)
        {
            return null;
        }
    }

    namespace Settings
    {
        public bool TESTING;
    }

    public const int COUNTER_DUPLICATION = 10;
    public const int ANDNA_DUPLICATION = 10;
    public const int MAX_HOSTNAMES = 256;
    public const int64 MAX_TTL_ANDNA = (int64)1000 * (int64)60 *
                                       (int64)60 * (int64)24 *
                                       (int64)30; // 30 days in millisec
    public const int64 MAX_TTL_OF_NEGATIVE = (int64)1000 * (int64)30;
                                             // 30 seconds in millisec
    public const int64 MAX_TTL_COUNTER = (int64)1000 * (int64)60 *
                                         (int64)60 * (int64)24 *
                                         (int64)30; // 30 days in millisec
    public const int64 MAX_WAIT_REFRESH_ANDNA = (int64)1000 * (int64)60 *
                                                (int64)60; // 1 hour in millisec
    public const int64 MAX_WAIT_REFRESH_COUNTER = (int64)1000 * (int64)60 *
                                                  (int64)60; // 1 hour in millisec
    public const int MAX_QUEUE_ANDNA = 5;
    public const int SPREAD_ANDNA = 9;

}

namespace Ntk.Test
{
    string logger;
    const bool output = false;
    public void print_out(string s)
    {
        if (output) print(s);
    }

    public class AndnaTester : Object
    {
        public void set_up ()
        {
            logger = "";
        }

        public void tear_down ()
        {
            logger = "";
        }

        public void test_crypto_hash ()
        {
            log_debug(Andna.crypto_hash("pippo"));
            log_debug(Andna.crypto_hash("plippo"));
            log_debug(Andna.crypto_hash("PiPPo"));
            assert(Andna.crypto_hash("pippo") == "cXJewoJPKqAvN1dcxJyZKA");
            assert(Andna.crypto_hash("PiPPo") == "cXJewoJPKqAvN1dcxJyZKA");
            assert(Andna.crypto_hash("pippo") != Andna.crypto_hash("plippo"));
        }

        public void test_signatures ()
        {
            // create keypair
            KeyPair keypair = new KeyPair();
            PublicKey pubkey = keypair.pub_key.to_pubkey();
            // get a nip
            NIP maproute_me = new NIP({1,2,3,4});
            // Counter.reset_my_counter_node
            // Counter.ask_set_data_for_pubk
            // Counter.hashednames
            ArrayList<string> hashednames = new ArrayList<string>();
            hashednames.add(Andna.crypto_hash("pegasus.lukisinet"));
            // Counter._sign
            // Counter.prepare_msg
            uchar[] message_prepared_in_client;
            {
                log_debug(@"nip $(maproute_me)");
                uchar[] message1 = maproute_me.hash_for_signature();
                foreach (string s in hashednames)
                    log_debug(@"hashedname $(s)");
                uchar[] message2 = (new ListString.with_backer(hashednames)).hash_for_signature();
                uchar[] message = new uchar[message1.length + message2.length];
                int im = 0;
                for (int i = 0; i < message1.length; i++) message[im++] = message1[i];
                for (int i = 0; i < message2.length; i++) message[im++] = message2[i];
                message_prepared_in_client = message;
            }
            log_debug(@"message_prepared_in_client $(Base64.encode(message_prepared_in_client))");
            // Counter._sign
            uchar[] signed = keypair.sign(message_prepared_in_client);
            SerializableBuffer signature = new SerializableBuffer((uint8[])(signed));
            // Counter.ask_set_data_for_pubk call peer().set_data_for_pubk
            // serialization
            RemoteCall rc = new RemoteCall();
            rc.method_name = "set_data_for_pubk";
            rc.add_parameter(maproute_me);
            rc.add_parameter(new ListString.with_backer(hashednames));
            rc.add_parameter(pubkey);
            rc.add_parameter(signature);
            // serialize and deserialize
            RemoteCall data = (RemoteCall)ISerializable.deserialize(rc.serialize());
            ISerializable iser0 = data.parameters[0];
            if (! iser0.get_type().is_a(typeof(NIP)))
                throw new RPCError.MALFORMED_PACKET(
                    "set_data_for_pubk parameter 1 is not a NIP.");
            NIP ported_nip = (NIP)iser0;
            ISerializable iser1 = data.parameters[1];
            if (! iser1.get_type().is_a(typeof(ListString)))
                throw new RPCError.MALFORMED_PACKET(
                    "set_data_for_pubk parameter 2 is not a List<string>.");
            ListString _hashed_hostnames = (ListString)iser1;
            Gee.List<string> ported_hashed_hostnames = _hashed_hostnames.backed;
            ISerializable iser2 = data.parameters[2];
            if (! iser2.get_type().is_a(typeof(PublicKey)))
                throw new RPCError.MALFORMED_PACKET(
                    "set_data_for_pubk parameter 3 is not a PublicKey.");
            PublicKey ported_pubkey = (PublicKey)iser2;
            ISerializable iser3 = data.parameters[3];
            if (! iser3.get_type().is_a(typeof(SerializableBuffer)))
                throw new RPCError.MALFORMED_PACKET(
                    "set_data_for_pubk parameter 4 is not a SerializableBuffer.");
            SerializableBuffer ported_signature = (SerializableBuffer)iser3;
            // Counter.set_data_for_pubk
            // Counter.prepare_msg
            uchar[] message_prepared_in_server;
            {
                log_debug(@"nip $(ported_nip)");
                uchar[] message1 = ported_nip.hash_for_signature();
                foreach (string s in ported_hashed_hostnames)
                    log_debug(@"hashedname $(s)");
                uchar[] message2 = (new ListString.with_backer(ported_hashed_hostnames)).hash_for_signature();
                uchar[] message = new uchar[message1.length + message2.length];
                int im = 0;
                for (int i = 0; i < message1.length; i++) message[im++] = message1[i];
                for (int i = 0; i < message2.length; i++) message[im++] = message2[i];
                message_prepared_in_server = message;
            }
            log_debug(@"message_prepared_in_server $(Base64.encode(message_prepared_in_server))");
            // Counter._verify
            PublicKeyWrapper pkw = new PublicKeyWrapper.from_pubk(ported_pubkey);
            bool ret = pkw.verify(message_prepared_in_server, (uchar[])(ported_signature.buffer));
            assert(ret);
        }

        public static int main(string[] args)
        {
            GLib.Test.init(ref args);
            Tasklet.init();
            GLib.Test.add_func ("/Andna/CryptoHash", () => {
                var x = new AndnaTester();
                x.set_up();
                x.test_crypto_hash();
                x.tear_down();
            });
            GLib.Test.add_func ("/Andna/Signatures", () => {
                var x = new AndnaTester();
                x.set_up();
                x.test_signatures();
                x.tear_down();
            });
            GLib.Test.run();
            Tasklet.kill();
            return 0;
        }
    }
}
