/* main.c generated by valac 0.20.1, the Vala compiler
 * generated from main.vala, do not modify */

/*
 *  This file is part of librpc.
 *  (c) Copyright 2013 Luca Dionisi aka lukisi <luca.dionisi@gmail.com>
 *
 *  librpc is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  librpc is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with librpc.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <stdio.h>
#include <glib/gstdio.h>
#include <gobject/gvaluecollector.h>


#define TYPE_ARGUMENT (argument_get_type ())
#define ARGUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ARGUMENT, Argument))
#define ARGUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ARGUMENT, ArgumentClass))
#define IS_ARGUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ARGUMENT))
#define IS_ARGUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ARGUMENT))
#define ARGUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ARGUMENT, ArgumentClass))

typedef struct _Argument Argument;
typedef struct _ArgumentClass ArgumentClass;
typedef struct _ArgumentPrivate ArgumentPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ParamSpecArgument ParamSpecArgument;

#define TYPE_METHOD (method_get_type ())
#define METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_METHOD, Method))
#define METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_METHOD, MethodClass))
#define IS_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_METHOD))
#define IS_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_METHOD))
#define METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_METHOD, MethodClass))

typedef struct _Method Method;
typedef struct _MethodClass MethodClass;
typedef struct _MethodPrivate MethodPrivate;
typedef struct _ParamSpecMethod ParamSpecMethod;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _argument_unref0(var) ((var == NULL) ? NULL : (var = (argument_unref (var), NULL)))
#define _method_unref0(var) ((var == NULL) ? NULL : (var = (method_unref (var), NULL)))
#define _g_match_info_free0(var) ((var == NULL) ? NULL : (var = (g_match_info_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Argument {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ArgumentPrivate * priv;
	gchar* argname;
	gchar* classname;
};

struct _ArgumentClass {
	GTypeClass parent_class;
	void (*finalize) (Argument *self);
};

struct _ParamSpecArgument {
	GParamSpec parent_instance;
};

struct _Method {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MethodPrivate * priv;
	gchar* returntype;
	gchar* name;
	Argument** args;
	gint args_length1;
	gint _args_size_;
	gboolean pass_caller;
	gchar** errors;
	gint errors_length1;
	gint _errors_size_;
};

struct _MethodClass {
	GTypeClass parent_class;
	void (*finalize) (Method *self);
};

struct _ParamSpecMethod {
	GParamSpec parent_instance;
};


static gpointer argument_parent_class = NULL;
static gpointer method_parent_class = NULL;
extern gchar** serializable_types;
extern gint serializable_types_length1;
gchar** serializable_types = NULL;
gint serializable_types_length1 = 0;
static gint _serializable_types_size_ = 0;
extern GeeHashMap* errordefs;
GeeHashMap* errordefs = NULL;
extern gchar** remotes;
extern gint remotes_length1;
gchar** remotes = NULL;
gint remotes_length1 = 0;
static gint _remotes_size_ = 0;
extern GeeHashMap* methods;
GeeHashMap* methods = NULL;
extern GeeHashMap* methods_rmt;
GeeHashMap* methods_rmt = NULL;
extern gchar* output;
gchar* output = NULL;
extern gchar* closepar;
gchar* closepar = NULL;

void _vala_main (void);
void buildpeercode (const gchar* if_name, const gchar* of_name);
gpointer argument_ref (gpointer instance);
void argument_unref (gpointer instance);
GParamSpec* param_spec_argument (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_argument (GValue* value, gpointer v_object);
void value_take_argument (GValue* value, gpointer v_object);
gpointer value_get_argument (const GValue* value);
GType argument_get_type (void) G_GNUC_CONST;
enum  {
	ARGUMENT_DUMMY_PROPERTY
};
Argument* argument_new (void);
Argument* argument_construct (GType object_type);
static void argument_finalize (Argument* obj);
gpointer method_ref (gpointer instance);
void method_unref (gpointer instance);
GParamSpec* param_spec_method (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_method (GValue* value, gpointer v_object);
void value_take_method (GValue* value, gpointer v_object);
gpointer value_get_method (const GValue* value);
GType method_get_type (void) G_GNUC_CONST;
enum  {
	METHOD_DUMMY_PROPERTY
};
Method* method_new (void);
Method* method_construct (GType object_type);
static void method_finalize (Method* obj);
void read_file_if (const gchar* if_name);
void write_file_of (void);
void write_file (const gchar* path, const gchar* contents);
gchar** read_file (const gchar* path, int* result_length1);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
void malformed (gint c);
gchar* get_keyword (const gchar* s);
static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add4 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add5 (gchar*** array, int* length, int* size, gchar* value);
gchar** get_two_keywords (const gchar* s, int* result_length1);
static void _vala_array_add6 (Argument*** array, int* length, int* size, Argument* value);
static void _vala_array_add7 (gchar*** array, int* length, int* size, gchar* value);
gchar* method_signature (Method* met);
gchar* rec_line (const gchar* m);
void stub_declare_abstract_method (Method* met);
gchar* indentlines (gchar* x, const gchar* prefix);
void wr (const gchar* m);
void stub_declare_method (Method* met);
void stub_add_parameters (Argument** args, int args_length1);
static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle);
void wr_line (const gchar* m);
void stub_launch_method_firstpart (Method* met);
void wr_block (const gchar* m);
void stub_launch_method_secondpart (Method* met);
gchar* recurse_remote_members (const gchar* classname);
gchar* rec_block (const gchar* m);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


void _vala_main (void) {
	buildpeercode ("peerbuilder.in", "out.vala");
}


int main (int argc, char ** argv) {
	g_type_init ();
	_vala_main ();
	return 0;
}


Argument* argument_construct (GType object_type) {
	Argument* self = NULL;
	self = (Argument*) g_type_create_instance (object_type);
	return self;
}


Argument* argument_new (void) {
	return argument_construct (TYPE_ARGUMENT);
}


static void value_argument_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_argument_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		argument_unref (value->data[0].v_pointer);
	}
}


static void value_argument_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = argument_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_argument_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_argument_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		Argument* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = argument_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_argument_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Argument** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = argument_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_argument (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecArgument* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_ARGUMENT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_argument (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ARGUMENT), NULL);
	return value->data[0].v_pointer;
}


void value_set_argument (GValue* value, gpointer v_object) {
	Argument* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ARGUMENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_ARGUMENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		argument_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		argument_unref (old);
	}
}


void value_take_argument (GValue* value, gpointer v_object) {
	Argument* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ARGUMENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_ARGUMENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		argument_unref (old);
	}
}


static void argument_class_init (ArgumentClass * klass) {
	argument_parent_class = g_type_class_peek_parent (klass);
	ARGUMENT_CLASS (klass)->finalize = argument_finalize;
}


static void argument_instance_init (Argument * self) {
	self->ref_count = 1;
}


static void argument_finalize (Argument* obj) {
	Argument * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ARGUMENT, Argument);
	_g_free0 (self->argname);
	_g_free0 (self->classname);
}


GType argument_get_type (void) {
	static volatile gsize argument_type_id__volatile = 0;
	if (g_once_init_enter (&argument_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_argument_init, value_argument_free_value, value_argument_copy_value, value_argument_peek_pointer, "p", value_argument_collect_value, "p", value_argument_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ArgumentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) argument_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Argument), 0, (GInstanceInitFunc) argument_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType argument_type_id;
		argument_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Argument", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&argument_type_id__volatile, argument_type_id);
	}
	return argument_type_id__volatile;
}


gpointer argument_ref (gpointer instance) {
	Argument* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void argument_unref (gpointer instance) {
	Argument* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		ARGUMENT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


Method* method_construct (GType object_type) {
	Method* self = NULL;
	self = (Method*) g_type_create_instance (object_type);
	return self;
}


Method* method_new (void) {
	return method_construct (TYPE_METHOD);
}


static void value_method_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_method_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		method_unref (value->data[0].v_pointer);
	}
}


static void value_method_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = method_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_method_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_method_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		Method* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = method_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_method_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Method** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = method_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_method (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecMethod* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_METHOD), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_method (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_METHOD), NULL);
	return value->data[0].v_pointer;
}


void value_set_method (GValue* value, gpointer v_object) {
	Method* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_METHOD));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_METHOD));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		method_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		method_unref (old);
	}
}


void value_take_method (GValue* value, gpointer v_object) {
	Method* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_METHOD));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_METHOD));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		method_unref (old);
	}
}


static void method_class_init (MethodClass * klass) {
	method_parent_class = g_type_class_peek_parent (klass);
	METHOD_CLASS (klass)->finalize = method_finalize;
}


static void method_instance_init (Method * self) {
	self->pass_caller = FALSE;
	self->ref_count = 1;
}


static void method_finalize (Method* obj) {
	Method * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_METHOD, Method);
	_g_free0 (self->returntype);
	_g_free0 (self->name);
	self->args = (_vala_array_free (self->args, self->args_length1, (GDestroyNotify) argument_unref), NULL);
	self->errors = (_vala_array_free (self->errors, self->errors_length1, (GDestroyNotify) g_free), NULL);
}


GType method_get_type (void) {
	static volatile gsize method_type_id__volatile = 0;
	if (g_once_init_enter (&method_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_method_init, value_method_free_value, value_method_copy_value, value_method_peek_pointer, "p", value_method_collect_value, "p", value_method_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (MethodClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) method_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Method), 0, (GInstanceInitFunc) method_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType method_type_id;
		method_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Method", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&method_type_id__volatile, method_type_id);
	}
	return method_type_id__volatile;
}


gpointer method_ref (gpointer instance) {
	Method* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void method_unref (gpointer instance) {
	Method* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		METHOD_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


void buildpeercode (const gchar* if_name, const gchar* of_name) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	g_return_if_fail (if_name != NULL);
	g_return_if_fail (of_name != NULL);
	_tmp0_ = if_name;
	read_file_if (_tmp0_);
	_tmp1_ = g_strdup ("");
	_g_free0 (output);
	output = _tmp1_;
	write_file_of ();
	_tmp2_ = of_name;
	_tmp3_ = output;
	write_file (_tmp2_, _tmp3_);
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add4 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add5 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gpointer _argument_ref0 (gpointer self) {
	return self ? argument_ref (self) : NULL;
}


static void _vala_array_add6 (Argument*** array, int* length, int* size, Argument* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (Argument*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add7 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


void read_file_if (const gchar* if_name) {
	const gchar* _tmp0_;
	gint _tmp1_ = 0;
	gchar** _tmp2_ = NULL;
	gchar** lines;
	gint lines_length1;
	gint _lines_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar* _tmp4_;
	gchar** _tmp5_ = NULL;
	GeeHashMap* _tmp6_;
	gchar** _tmp7_ = NULL;
	GeeHashMap* _tmp8_;
	GeeHashMap* _tmp9_;
	gint c;
	gchar** _tmp10_;
	gint _tmp10__length1;
	gint _tmp11_;
	const gchar* _tmp12_;
	gint _tmp41_;
	gchar** _tmp42_;
	gint _tmp42__length1;
	gint _tmp43_;
	const gchar* _tmp44_;
	gchar** _tmp58_;
	gint _tmp58__length1;
	gchar* _tmp59_;
	gchar** _tmp60_;
	gint _tmp60__length1;
	gchar* _tmp61_;
	gint _tmp62_;
	gchar** _tmp63_;
	gint _tmp63__length1;
	gint _tmp64_;
	const gchar* _tmp65_;
	g_return_if_fail (if_name != NULL);
	_tmp0_ = if_name;
	_tmp2_ = read_file (_tmp0_, &_tmp1_);
	lines = _tmp2_;
	lines_length1 = _tmp1_;
	_lines_size_ = lines_length1;
	_tmp3_ = lines;
	_tmp3__length1 = lines_length1;
	_tmp4_ = g_strdup ("");
	_vala_array_add1 (&lines, &lines_length1, &_lines_size_, _tmp4_);
	_tmp5_ = g_new0 (gchar*, 0 + 1);
	serializable_types = (_vala_array_free (serializable_types, serializable_types_length1, (GDestroyNotify) g_free), NULL);
	serializable_types = _tmp5_;
	serializable_types_length1 = 0;
	_serializable_types_size_ = serializable_types_length1;
	_tmp6_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, GEE_TYPE_ARRAY_LIST, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (errordefs);
	errordefs = _tmp6_;
	_tmp7_ = g_new0 (gchar*, 0 + 1);
	remotes = (_vala_array_free (remotes, remotes_length1, (GDestroyNotify) g_free), NULL);
	remotes = _tmp7_;
	remotes_length1 = 0;
	_remotes_size_ = remotes_length1;
	_tmp8_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, GEE_TYPE_ARRAY_LIST, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (methods);
	methods = _tmp8_;
	_tmp9_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, GEE_TYPE_ARRAY_LIST, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (methods_rmt);
	methods_rmt = _tmp9_;
	c = 0;
	_tmp10_ = lines;
	_tmp10__length1 = lines_length1;
	_tmp11_ = c;
	_tmp12_ = _tmp10_[_tmp11_];
	if (g_strcmp0 (_tmp12_, "errors:") != 0) {
		gint _tmp13_;
		_tmp13_ = c;
		malformed (_tmp13_);
	}
	while (TRUE) {
		gchar** _tmp14_;
		gint _tmp14__length1;
		gint _tmp15_;
		const gchar* _tmp16_;
		gboolean _tmp17_ = FALSE;
		gint _tmp18_;
		gchar** _tmp19_;
		gint _tmp19__length1;
		gint _tmp20_;
		const gchar* _tmp21_;
		gchar* _tmp22_ = NULL;
		gchar* dom;
		GeeHashMap* _tmp23_;
		const gchar* _tmp24_;
		GeeArrayList* _tmp25_;
		GeeArrayList* _tmp26_;
		_tmp14_ = lines;
		_tmp14__length1 = lines_length1;
		_tmp15_ = c;
		_tmp16_ = _tmp14_[_tmp15_ + 1];
		_tmp17_ = g_regex_match_simple ("^ [a-zA-Z_]", _tmp16_, 0, 0);
		if (!_tmp17_) {
			break;
		}
		_tmp18_ = c;
		c = _tmp18_ + 1;
		_tmp19_ = lines;
		_tmp19__length1 = lines_length1;
		_tmp20_ = c;
		_tmp21_ = _tmp19_[_tmp20_];
		_tmp22_ = get_keyword (_tmp21_);
		dom = _tmp22_;
		_tmp23_ = errordefs;
		_tmp24_ = dom;
		_tmp25_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
		_tmp26_ = _tmp25_;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp23_, _tmp24_, _tmp26_);
		_g_object_unref0 (_tmp26_);
		while (TRUE) {
			gchar** _tmp27_;
			gint _tmp27__length1;
			gint _tmp28_;
			const gchar* _tmp29_;
			gboolean _tmp30_ = FALSE;
			gint _tmp31_;
			gchar** _tmp32_;
			gint _tmp32__length1;
			gint _tmp33_;
			const gchar* _tmp34_;
			gchar* _tmp35_ = NULL;
			gchar* code;
			GeeHashMap* _tmp36_;
			const gchar* _tmp37_;
			gpointer _tmp38_ = NULL;
			GeeArrayList* _tmp39_;
			const gchar* _tmp40_;
			_tmp27_ = lines;
			_tmp27__length1 = lines_length1;
			_tmp28_ = c;
			_tmp29_ = _tmp27_[_tmp28_ + 1];
			_tmp30_ = g_regex_match_simple ("^  [a-zA-Z_]", _tmp29_, 0, 0);
			if (!_tmp30_) {
				break;
			}
			_tmp31_ = c;
			c = _tmp31_ + 1;
			_tmp32_ = lines;
			_tmp32__length1 = lines_length1;
			_tmp33_ = c;
			_tmp34_ = _tmp32_[_tmp33_];
			_tmp35_ = get_keyword (_tmp34_);
			code = _tmp35_;
			_tmp36_ = errordefs;
			_tmp37_ = dom;
			_tmp38_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp36_, _tmp37_);
			_tmp39_ = (GeeArrayList*) _tmp38_;
			_tmp40_ = code;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp39_, _tmp40_);
			_g_object_unref0 (_tmp39_);
			_g_free0 (code);
		}
		_g_free0 (dom);
	}
	_tmp41_ = c;
	c = _tmp41_ + 1;
	_tmp42_ = lines;
	_tmp42__length1 = lines_length1;
	_tmp43_ = c;
	_tmp44_ = _tmp42_[_tmp43_];
	if (g_strcmp0 (_tmp44_, "serializables:") != 0) {
		gint _tmp45_;
		_tmp45_ = c;
		malformed (_tmp45_);
	}
	while (TRUE) {
		gchar** _tmp46_;
		gint _tmp46__length1;
		gint _tmp47_;
		const gchar* _tmp48_;
		gboolean _tmp49_ = FALSE;
		gint _tmp50_;
		gchar** _tmp51_;
		gint _tmp51__length1;
		gint _tmp52_;
		const gchar* _tmp53_;
		gchar* _tmp54_ = NULL;
		gchar* ser;
		gchar** _tmp55_;
		gint _tmp55__length1;
		const gchar* _tmp56_;
		gchar* _tmp57_;
		_tmp46_ = lines;
		_tmp46__length1 = lines_length1;
		_tmp47_ = c;
		_tmp48_ = _tmp46_[_tmp47_ + 1];
		_tmp49_ = g_regex_match_simple ("^ [a-zA-Z_]", _tmp48_, 0, 0);
		if (!_tmp49_) {
			break;
		}
		_tmp50_ = c;
		c = _tmp50_ + 1;
		_tmp51_ = lines;
		_tmp51__length1 = lines_length1;
		_tmp52_ = c;
		_tmp53_ = _tmp51_[_tmp52_];
		_tmp54_ = get_keyword (_tmp53_);
		ser = _tmp54_;
		_tmp55_ = serializable_types;
		_tmp55__length1 = serializable_types_length1;
		_tmp56_ = ser;
		_tmp57_ = g_strdup (_tmp56_);
		_vala_array_add2 (&serializable_types, &serializable_types_length1, &_serializable_types_size_, _tmp57_);
		_g_free0 (ser);
	}
	_tmp58_ = serializable_types;
	_tmp58__length1 = serializable_types_length1;
	_tmp59_ = g_strdup ("RemoteCall");
	_vala_array_add3 (&serializable_types, &serializable_types_length1, &_serializable_types_size_, _tmp59_);
	_tmp60_ = serializable_types;
	_tmp60__length1 = serializable_types_length1;
	_tmp61_ = g_strdup ("SerializableBuffer");
	_vala_array_add4 (&serializable_types, &serializable_types_length1, &_serializable_types_size_, _tmp61_);
	_tmp62_ = c;
	c = _tmp62_ + 1;
	_tmp63_ = lines;
	_tmp63__length1 = lines_length1;
	_tmp64_ = c;
	_tmp65_ = _tmp63_[_tmp64_];
	if (g_strcmp0 (_tmp65_, "peers:") != 0) {
		gint _tmp66_;
		_tmp66_ = c;
		malformed (_tmp66_);
	}
	while (TRUE) {
		gchar** _tmp67_;
		gint _tmp67__length1;
		gint _tmp68_;
		const gchar* _tmp69_;
		gboolean _tmp70_ = FALSE;
		gint _tmp71_;
		gchar** _tmp72_;
		gint _tmp72__length1;
		gint _tmp73_;
		const gchar* _tmp74_;
		gchar* _tmp75_ = NULL;
		gchar* remote;
		gchar** _tmp76_;
		gint _tmp76__length1;
		const gchar* _tmp77_;
		gchar* _tmp78_;
		GeeHashMap* _tmp79_;
		const gchar* _tmp80_;
		GeeArrayList* _tmp81_;
		GeeArrayList* _tmp82_;
		gint _tmp83_;
		gchar** _tmp84_;
		gint _tmp84__length1;
		gint _tmp85_;
		const gchar* _tmp86_;
		_tmp67_ = lines;
		_tmp67__length1 = lines_length1;
		_tmp68_ = c;
		_tmp69_ = _tmp67_[_tmp68_ + 1];
		_tmp70_ = g_regex_match_simple ("^ [a-zA-Z_]", _tmp69_, 0, 0);
		if (!_tmp70_) {
			break;
		}
		_tmp71_ = c;
		c = _tmp71_ + 1;
		_tmp72_ = lines;
		_tmp72__length1 = lines_length1;
		_tmp73_ = c;
		_tmp74_ = _tmp72_[_tmp73_];
		_tmp75_ = get_keyword (_tmp74_);
		remote = _tmp75_;
		_tmp76_ = remotes;
		_tmp76__length1 = remotes_length1;
		_tmp77_ = remote;
		_tmp78_ = g_strdup (_tmp77_);
		_vala_array_add5 (&remotes, &remotes_length1, &_remotes_size_, _tmp78_);
		_tmp79_ = methods;
		_tmp80_ = remote;
		_tmp81_ = gee_array_list_new (TYPE_METHOD, (GBoxedCopyFunc) method_ref, method_unref, NULL, NULL, NULL);
		_tmp82_ = _tmp81_;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp79_, _tmp80_, _tmp82_);
		_g_object_unref0 (_tmp82_);
		_tmp83_ = c;
		c = _tmp83_ + 1;
		_tmp84_ = lines;
		_tmp84__length1 = lines_length1;
		_tmp85_ = c;
		_tmp86_ = _tmp84_[_tmp85_];
		if (g_strcmp0 (_tmp86_, "  methods:") != 0) {
			gint _tmp87_;
			_tmp87_ = c;
			malformed (_tmp87_);
		}
		while (TRUE) {
			gchar** _tmp88_;
			gint _tmp88__length1;
			gint _tmp89_;
			const gchar* _tmp90_;
			gboolean _tmp91_ = FALSE;
			gint _tmp92_;
			Method* _tmp93_;
			Method* m;
			gchar** _tmp94_;
			gint _tmp94__length1;
			gint _tmp95_;
			const gchar* _tmp96_;
			gint _tmp97_ = 0;
			gchar** _tmp98_ = NULL;
			gchar** meth;
			gint meth_length1;
			gint _meth_size_;
			Method* _tmp99_;
			gchar** _tmp100_;
			gint _tmp100__length1;
			const gchar* _tmp101_;
			gchar* _tmp102_;
			Method* _tmp103_;
			gchar** _tmp104_;
			gint _tmp104__length1;
			const gchar* _tmp105_;
			gchar* _tmp106_;
			Method* _tmp107_;
			Argument** _tmp108_ = NULL;
			Method* _tmp109_;
			gchar** _tmp110_ = NULL;
			GeeHashMap* _tmp111_;
			const gchar* _tmp112_;
			gpointer _tmp113_ = NULL;
			GeeArrayList* _tmp114_;
			Method* _tmp115_;
			gint _tmp116_;
			gchar** _tmp117_;
			gint _tmp117__length1;
			gint _tmp118_;
			const gchar* _tmp119_;
			gint _tmp145_;
			gchar** _tmp146_;
			gint _tmp146__length1;
			gint _tmp147_;
			const gchar* _tmp148_;
			gchar** _tmp151_;
			gint _tmp151__length1;
			gint _tmp152_;
			const gchar* _tmp153_;
			_tmp88_ = lines;
			_tmp88__length1 = lines_length1;
			_tmp89_ = c;
			_tmp90_ = _tmp88_[_tmp89_ + 1];
			_tmp91_ = g_regex_match_simple ("^   [a-zA-Z_]", _tmp90_, 0, 0);
			if (!_tmp91_) {
				break;
			}
			_tmp92_ = c;
			c = _tmp92_ + 1;
			_tmp93_ = method_new ();
			m = _tmp93_;
			_tmp94_ = lines;
			_tmp94__length1 = lines_length1;
			_tmp95_ = c;
			_tmp96_ = _tmp94_[_tmp95_];
			_tmp98_ = get_two_keywords (_tmp96_, &_tmp97_);
			meth = _tmp98_;
			meth_length1 = _tmp97_;
			_meth_size_ = meth_length1;
			_tmp99_ = m;
			_tmp100_ = meth;
			_tmp100__length1 = meth_length1;
			_tmp101_ = _tmp100_[0];
			_tmp102_ = g_strdup (_tmp101_);
			_g_free0 (_tmp99_->returntype);
			_tmp99_->returntype = _tmp102_;
			_tmp103_ = m;
			_tmp104_ = meth;
			_tmp104__length1 = meth_length1;
			_tmp105_ = _tmp104_[1];
			_tmp106_ = g_strdup (_tmp105_);
			_g_free0 (_tmp103_->name);
			_tmp103_->name = _tmp106_;
			_tmp107_ = m;
			_tmp108_ = g_new0 (Argument*, 0 + 1);
			_tmp107_->args = (_vala_array_free (_tmp107_->args, _tmp107_->args_length1, (GDestroyNotify) argument_unref), NULL);
			_tmp107_->args = _tmp108_;
			_tmp107_->args_length1 = 0;
			_tmp107_->_args_size_ = _tmp107_->args_length1;
			_tmp109_ = m;
			_tmp110_ = g_new0 (gchar*, 0 + 1);
			_tmp109_->errors = (_vala_array_free (_tmp109_->errors, _tmp109_->errors_length1, (GDestroyNotify) g_free), NULL);
			_tmp109_->errors = _tmp110_;
			_tmp109_->errors_length1 = 0;
			_tmp109_->_errors_size_ = _tmp109_->errors_length1;
			_tmp111_ = methods;
			_tmp112_ = remote;
			_tmp113_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp111_, _tmp112_);
			_tmp114_ = (GeeArrayList*) _tmp113_;
			_tmp115_ = m;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp114_, _tmp115_);
			_g_object_unref0 (_tmp114_);
			_tmp116_ = c;
			c = _tmp116_ + 1;
			_tmp117_ = lines;
			_tmp117__length1 = lines_length1;
			_tmp118_ = c;
			_tmp119_ = _tmp117_[_tmp118_];
			if (g_strcmp0 (_tmp119_, "    arguments:") != 0) {
				gint _tmp120_;
				_tmp120_ = c;
				malformed (_tmp120_);
			}
			while (TRUE) {
				gchar** _tmp121_;
				gint _tmp121__length1;
				gint _tmp122_;
				const gchar* _tmp123_;
				gboolean _tmp124_ = FALSE;
				gint _tmp125_;
				Argument* _tmp126_;
				Argument* a;
				gchar** _tmp127_;
				gint _tmp127__length1;
				gint _tmp128_;
				const gchar* _tmp129_;
				gint _tmp130_ = 0;
				gchar** _tmp131_ = NULL;
				gchar** arg;
				gint arg_length1;
				gint _arg_size_;
				Argument* _tmp132_;
				gchar** _tmp133_;
				gint _tmp133__length1;
				const gchar* _tmp134_;
				gchar* _tmp135_;
				Argument* _tmp136_;
				gchar** _tmp137_;
				gint _tmp137__length1;
				const gchar* _tmp138_;
				gchar* _tmp139_;
				Method* _tmp140_;
				Method* _tmp141_;
				Argument** _tmp142_;
				gint _tmp142__length1;
				Argument* _tmp143_;
				Argument* _tmp144_;
				_tmp121_ = lines;
				_tmp121__length1 = lines_length1;
				_tmp122_ = c;
				_tmp123_ = _tmp121_[_tmp122_ + 1];
				_tmp124_ = g_regex_match_simple ("^     [a-zA-Z_]", _tmp123_, 0, 0);
				if (!_tmp124_) {
					break;
				}
				_tmp125_ = c;
				c = _tmp125_ + 1;
				_tmp126_ = argument_new ();
				a = _tmp126_;
				_tmp127_ = lines;
				_tmp127__length1 = lines_length1;
				_tmp128_ = c;
				_tmp129_ = _tmp127_[_tmp128_];
				_tmp131_ = get_two_keywords (_tmp129_, &_tmp130_);
				arg = _tmp131_;
				arg_length1 = _tmp130_;
				_arg_size_ = arg_length1;
				_tmp132_ = a;
				_tmp133_ = arg;
				_tmp133__length1 = arg_length1;
				_tmp134_ = _tmp133_[0];
				_tmp135_ = g_strdup (_tmp134_);
				_g_free0 (_tmp132_->classname);
				_tmp132_->classname = _tmp135_;
				_tmp136_ = a;
				_tmp137_ = arg;
				_tmp137__length1 = arg_length1;
				_tmp138_ = _tmp137_[1];
				_tmp139_ = g_strdup (_tmp138_);
				_g_free0 (_tmp136_->argname);
				_tmp136_->argname = _tmp139_;
				_tmp140_ = m;
				_tmp141_ = m;
				_tmp142_ = _tmp141_->args;
				_tmp142__length1 = _tmp141_->args_length1;
				_tmp143_ = a;
				_tmp144_ = _argument_ref0 (_tmp143_);
				_vala_array_add6 (&_tmp140_->args, &_tmp140_->args_length1, &_tmp140_->_args_size_, _tmp144_);
				arg = (_vala_array_free (arg, arg_length1, (GDestroyNotify) g_free), NULL);
				_argument_unref0 (a);
			}
			_tmp145_ = c;
			c = _tmp145_ + 1;
			_tmp146_ = lines;
			_tmp146__length1 = lines_length1;
			_tmp147_ = c;
			_tmp148_ = _tmp146_[_tmp147_];
			if (g_strcmp0 (_tmp148_, "    pass_caller") == 0) {
				Method* _tmp149_;
				gint _tmp150_;
				_tmp149_ = m;
				_tmp149_->pass_caller = TRUE;
				_tmp150_ = c;
				c = _tmp150_ + 1;
			}
			_tmp151_ = lines;
			_tmp151__length1 = lines_length1;
			_tmp152_ = c;
			_tmp153_ = _tmp151_[_tmp152_];
			if (g_strcmp0 (_tmp153_, "    throws:") != 0) {
				gint _tmp154_;
				_tmp154_ = c;
				malformed (_tmp154_);
			}
			while (TRUE) {
				gchar** _tmp155_;
				gint _tmp155__length1;
				gint _tmp156_;
				const gchar* _tmp157_;
				gboolean _tmp158_ = FALSE;
				gint _tmp159_;
				gchar** _tmp160_;
				gint _tmp160__length1;
				gint _tmp161_;
				const gchar* _tmp162_;
				gchar* _tmp163_ = NULL;
				gchar* err;
				Method* _tmp164_;
				Method* _tmp165_;
				gchar** _tmp166_;
				gint _tmp166__length1;
				const gchar* _tmp167_;
				gchar* _tmp168_;
				_tmp155_ = lines;
				_tmp155__length1 = lines_length1;
				_tmp156_ = c;
				_tmp157_ = _tmp155_[_tmp156_ + 1];
				_tmp158_ = g_regex_match_simple ("^     [a-zA-Z_]", _tmp157_, 0, 0);
				if (!_tmp158_) {
					break;
				}
				_tmp159_ = c;
				c = _tmp159_ + 1;
				_tmp160_ = lines;
				_tmp160__length1 = lines_length1;
				_tmp161_ = c;
				_tmp162_ = _tmp160_[_tmp161_];
				_tmp163_ = get_keyword (_tmp162_);
				err = _tmp163_;
				_tmp164_ = m;
				_tmp165_ = m;
				_tmp166_ = _tmp165_->errors;
				_tmp166__length1 = _tmp165_->errors_length1;
				_tmp167_ = err;
				_tmp168_ = g_strdup (_tmp167_);
				_vala_array_add7 (&_tmp164_->errors, &_tmp164_->errors_length1, &_tmp164_->_errors_size_, _tmp168_);
				_g_free0 (err);
			}
			meth = (_vala_array_free (meth, meth_length1, (GDestroyNotify) g_free), NULL);
			_method_unref0 (m);
		}
		_g_free0 (remote);
	}
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
}


gchar* get_keyword (const gchar* s) {
	gchar* result = NULL;
	GMatchInfo* m = NULL;
	GRegex* _tmp0_;
	GRegex* r;
	const gchar* _tmp1_;
	GMatchInfo* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GMatchInfo* _tmp5_;
	gchar* _tmp6_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (s != NULL, NULL);
	_tmp0_ = g_regex_new ("[a-zA-Z0-9_]+", 0, 0, &_inner_error_);
	r = _tmp0_;
	if (_inner_error_ != NULL) {
		_g_match_info_free0 (m);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp1_ = s;
	_tmp3_ = g_regex_match (r, _tmp1_, 0, &_tmp2_);
	_g_match_info_free0 (m);
	m = _tmp2_;
	if (!_tmp3_) {
		gchar* _tmp4_;
		_tmp4_ = g_strdup ("");
		result = _tmp4_;
		_g_regex_unref0 (r);
		_g_match_info_free0 (m);
		return result;
	}
	_tmp5_ = m;
	_tmp6_ = g_match_info_fetch (_tmp5_, 0);
	result = _tmp6_;
	_g_regex_unref0 (r);
	_g_match_info_free0 (m);
	return result;
}


gchar** get_two_keywords (const gchar* s, int* result_length1) {
	gchar** result = NULL;
	GMatchInfo* m = NULL;
	GRegex* _tmp0_;
	GRegex* r;
	const gchar* _tmp1_;
	GMatchInfo* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GMatchInfo* _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	gchar** _tmp10_;
	gchar** _tmp11_ = NULL;
	gchar** _tmp12_;
	gint _tmp12__length1;
	gchar** _tmp13_;
	gint _tmp13__length1;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (s != NULL, NULL);
	_tmp0_ = g_regex_new ("[a-zA-Z0-9_.<>\\??]+ [a-zA-Z0-9_]+", 0, 0, &_inner_error_);
	r = _tmp0_;
	if (_inner_error_ != NULL) {
		_g_match_info_free0 (m);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp1_ = s;
	_tmp3_ = g_regex_match (r, _tmp1_, 0, &_tmp2_);
	_g_match_info_free0 (m);
	m = _tmp2_;
	if (!_tmp3_) {
		gchar** _tmp4_;
		gchar** _tmp5_ = NULL;
		gchar** _tmp6_;
		gint _tmp6__length1;
		_tmp5_ = _tmp4_ = g_strsplit (" ", " ", 0);
		_tmp6_ = _tmp5_;
		_tmp6__length1 = _vala_array_length (_tmp4_);
		if (result_length1) {
			*result_length1 = _tmp6__length1;
		}
		result = _tmp6_;
		_g_regex_unref0 (r);
		_g_match_info_free0 (m);
		return result;
	}
	_tmp7_ = m;
	_tmp8_ = g_match_info_fetch (_tmp7_, 0);
	_tmp9_ = _tmp8_;
	_tmp11_ = _tmp10_ = g_strsplit (_tmp9_, " ", 0);
	_tmp12_ = _tmp11_;
	_tmp12__length1 = _vala_array_length (_tmp10_);
	_g_free0 (_tmp9_);
	_tmp13_ = _tmp12_;
	_tmp13__length1 = _tmp12__length1;
	if (result_length1) {
		*result_length1 = _tmp13__length1;
	}
	result = _tmp13_;
	_g_regex_unref0 (r);
	_g_match_info_free0 (m);
	return result;
}


void malformed (gint c) {
	FILE* _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	_tmp0_ = stderr;
	_tmp1_ = c;
	_tmp2_ = g_strdup_printf ("%i", _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat ("Input file is malformed. Line ", _tmp3_, ".\n", NULL);
	_tmp5_ = _tmp4_;
	fprintf (_tmp0_, "%s", _tmp5_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	exit (1);
}


gchar** read_file (const gchar* path, int* result_length1) {
	gchar** result = NULL;
	gchar** _tmp0_ = NULL;
	gchar** ret;
	gint ret_length1;
	gint _ret_size_;
	const gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gchar** _tmp16_;
	gint _tmp16__length1;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	ret = _tmp0_;
	ret_length1 = 0;
	_ret_size_ = ret_length1;
	_tmp1_ = path;
	_tmp2_ = g_file_test (_tmp1_, G_FILE_TEST_EXISTS);
	if (_tmp2_) {
		{
			gchar* contents = NULL;
			const gchar* _tmp3_;
			gchar* _tmp4_ = NULL;
			gboolean _tmp5_ = FALSE;
			gboolean _tmp6_;
			const gchar* _tmp7_;
			gchar** _tmp8_;
			gchar** _tmp9_ = NULL;
			_tmp3_ = path;
			_tmp5_ = g_file_get_contents (_tmp3_, &_tmp4_, NULL, &_inner_error_);
			_g_free0 (contents);
			contents = _tmp4_;
			_tmp6_ = _tmp5_;
			if (_inner_error_ != NULL) {
				_g_free0 (contents);
				if (_inner_error_->domain == G_FILE_ERROR) {
					goto __catch0_g_file_error;
				}
				_g_free0 (contents);
				ret = (_vala_array_free (ret, ret_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_vala_assert (_tmp6_, "FileUtils.get_contents(path, out contents)");
			_tmp7_ = contents;
			_tmp9_ = _tmp8_ = g_strsplit (_tmp7_, "\n", 0);
			ret = (_vala_array_free (ret, ret_length1, (GDestroyNotify) g_free), NULL);
			ret = _tmp9_;
			ret_length1 = _vala_array_length (_tmp8_);
			_ret_size_ = ret_length1;
			_g_free0 (contents);
		}
		goto __finally0;
		__catch0_g_file_error:
		{
			GError* e = NULL;
			GQuark _tmp10_;
			const gchar* _tmp11_ = NULL;
			gint _tmp12_;
			const gchar* _tmp13_;
			gchar* _tmp14_ = NULL;
			gchar* _tmp15_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp10_ = e->domain;
			_tmp11_ = g_quark_to_string (_tmp10_);
			_tmp12_ = e->code;
			_tmp13_ = e->message;
			_tmp14_ = g_strdup_printf ("%s: %d: %s", _tmp11_, _tmp12_, _tmp13_);
			_tmp15_ = _tmp14_;
			g_error ("main.vala:176: %s", _tmp15_);
			_g_free0 (_tmp15_);
			_g_error_free0 (e);
		}
		__finally0:
		if (_inner_error_ != NULL) {
			ret = (_vala_array_free (ret, ret_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp16_ = ret;
	_tmp16__length1 = ret_length1;
	if (result_length1) {
		*result_length1 = _tmp16__length1;
	}
	result = _tmp16_;
	return result;
}


void write_file (const gchar* path, const gchar* contents) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (path != NULL);
	g_return_if_fail (contents != NULL);
	{
		const gchar* _tmp0_;
		const gchar* _tmp1_;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_;
		_tmp0_ = path;
		_tmp1_ = contents;
		_tmp2_ = g_file_set_contents (_tmp0_, _tmp1_, (gssize) (-1), &_inner_error_);
		_tmp3_ = _tmp2_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch1_g_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_vala_assert (_tmp3_, "FileUtils.set_contents(path, contents)");
	}
	goto __finally1;
	__catch1_g_file_error:
	{
		GError* e = NULL;
		GQuark _tmp4_;
		const gchar* _tmp5_ = NULL;
		gint _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = e->domain;
		_tmp5_ = g_quark_to_string (_tmp4_);
		_tmp6_ = e->code;
		_tmp7_ = e->message;
		_tmp8_ = g_strdup_printf ("%s: %d: %s", _tmp5_, _tmp6_, _tmp7_);
		_tmp9_ = _tmp8_;
		g_error ("main.vala:187: %s", _tmp9_);
		_g_free0 (_tmp9_);
		_g_error_free0 (e);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


gchar* method_signature (Method* met) {
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* ret;
	const gchar* _tmp1_;
	Method* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	gchar* _tmp7_;
	Method* _tmp8_;
	Argument** _tmp9_;
	gint _tmp9__length1;
	gchar* _tmp60_;
	gchar* str_throws;
	Method* _tmp61_;
	gchar** _tmp62_;
	gint _tmp62__length1;
	const gchar* _tmp77_;
	const gchar* _tmp78_;
	const gchar* _tmp79_ = NULL;
	gchar* _tmp80_ = NULL;
	gchar* _tmp81_;
	gchar* _tmp82_;
	g_return_val_if_fail (met != NULL, NULL);
	_tmp0_ = g_strdup ("");
	ret = _tmp0_;
	_tmp1_ = ret;
	_tmp2_ = met;
	_tmp3_ = _tmp2_->returntype;
	_tmp4_ = string_to_string (_tmp3_);
	_tmp5_ = rec_line (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strconcat (_tmp1_, _tmp6_, NULL);
	_g_free0 (ret);
	ret = _tmp7_;
	_g_free0 (_tmp6_);
	_tmp8_ = met;
	_tmp9_ = _tmp8_->args;
	_tmp9__length1 = _tmp8_->args_length1;
	if (_tmp9__length1 == 0) {
		const gchar* _tmp10_;
		Method* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_;
		gchar* _tmp18_;
		_tmp10_ = ret;
		_tmp11_ = met;
		_tmp12_ = _tmp11_->name;
		_tmp13_ = string_to_string (_tmp12_);
		_tmp14_ = g_strconcat (_tmp13_, " ()", NULL);
		_tmp15_ = _tmp14_;
		_tmp16_ = rec_line (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = g_strconcat (_tmp10_, _tmp17_, NULL);
		_g_free0 (ret);
		ret = _tmp18_;
		_g_free0 (_tmp17_);
		_g_free0 (_tmp15_);
	} else {
		const gchar* _tmp19_;
		Method* _tmp20_;
		const gchar* _tmp21_;
		const gchar* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* strprefix;
		gchar* _tmp27_;
		gchar* strsuffix;
		gchar* _tmp28_;
		gchar* prevline;
		Method* _tmp29_;
		Argument** _tmp30_;
		gint _tmp30__length1;
		const gchar* _tmp52_;
		const gchar* _tmp53_;
		const gchar* _tmp54_ = NULL;
		gchar* _tmp55_ = NULL;
		gchar* _tmp56_;
		gchar* _tmp57_ = NULL;
		gchar* _tmp58_;
		gchar* _tmp59_;
		_tmp19_ = ret;
		_tmp20_ = met;
		_tmp21_ = _tmp20_->name;
		_tmp22_ = string_to_string (_tmp21_);
		_tmp23_ = rec_line (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = g_strconcat (_tmp19_, _tmp24_, NULL);
		_g_free0 (ret);
		ret = _tmp25_;
		_g_free0 (_tmp24_);
		_tmp26_ = g_strdup ("(");
		strprefix = _tmp26_;
		_tmp27_ = g_strdup (",");
		strsuffix = _tmp27_;
		_tmp28_ = g_strdup ("");
		prevline = _tmp28_;
		_tmp29_ = met;
		_tmp30_ = _tmp29_->args;
		_tmp30__length1 = _tmp29_->args_length1;
		{
			Argument** arg_collection = NULL;
			gint arg_collection_length1 = 0;
			gint _arg_collection_size_ = 0;
			gint arg_it = 0;
			arg_collection = _tmp30_;
			arg_collection_length1 = _tmp30__length1;
			for (arg_it = 0; arg_it < _tmp30__length1; arg_it = arg_it + 1) {
				Argument* _tmp31_;
				Argument* arg = NULL;
				_tmp31_ = _argument_ref0 (arg_collection[arg_it]);
				arg = _tmp31_;
				{
					const gchar* _tmp32_;
					const gchar* _tmp41_;
					Argument* _tmp42_;
					const gchar* _tmp43_;
					const gchar* _tmp44_ = NULL;
					Argument* _tmp45_;
					const gchar* _tmp46_;
					const gchar* _tmp47_ = NULL;
					gchar* _tmp48_ = NULL;
					gchar* _tmp49_;
					gchar* _tmp50_;
					gchar* _tmp51_;
					_tmp32_ = prevline;
					if (g_strcmp0 (_tmp32_, "") != 0) {
						const gchar* _tmp33_;
						const gchar* _tmp34_;
						const gchar* _tmp35_ = NULL;
						gchar* _tmp36_ = NULL;
						gchar* _tmp37_;
						gchar* _tmp38_ = NULL;
						gchar* _tmp39_;
						gchar* _tmp40_;
						_tmp33_ = ret;
						_tmp34_ = prevline;
						_tmp35_ = string_to_string (_tmp34_);
						_tmp36_ = g_strconcat (_tmp35_, ",", NULL);
						_tmp37_ = _tmp36_;
						_tmp38_ = rec_line (_tmp37_);
						_tmp39_ = _tmp38_;
						_tmp40_ = g_strconcat (_tmp33_, _tmp39_, NULL);
						_g_free0 (ret);
						ret = _tmp40_;
						_g_free0 (_tmp39_);
						_g_free0 (_tmp37_);
					}
					_tmp41_ = strprefix;
					_tmp42_ = arg;
					_tmp43_ = _tmp42_->classname;
					_tmp44_ = string_to_string (_tmp43_);
					_tmp45_ = arg;
					_tmp46_ = _tmp45_->argname;
					_tmp47_ = string_to_string (_tmp46_);
					_tmp48_ = g_strconcat (_tmp44_, " ", _tmp47_, NULL);
					_tmp49_ = _tmp48_;
					_tmp50_ = g_strconcat (_tmp41_, _tmp49_, NULL);
					_g_free0 (prevline);
					prevline = _tmp50_;
					_g_free0 (_tmp49_);
					_tmp51_ = g_strdup (" ");
					_g_free0 (strprefix);
					strprefix = _tmp51_;
					_argument_unref0 (arg);
				}
			}
		}
		_tmp52_ = ret;
		_tmp53_ = prevline;
		_tmp54_ = string_to_string (_tmp53_);
		_tmp55_ = g_strconcat (_tmp54_, ")", NULL);
		_tmp56_ = _tmp55_;
		_tmp57_ = rec_line (_tmp56_);
		_tmp58_ = _tmp57_;
		_tmp59_ = g_strconcat (_tmp52_, _tmp58_, NULL);
		_g_free0 (ret);
		ret = _tmp59_;
		_g_free0 (_tmp58_);
		_g_free0 (_tmp56_);
		_g_free0 (prevline);
		_g_free0 (strsuffix);
		_g_free0 (strprefix);
	}
	_tmp60_ = g_strdup ("");
	str_throws = _tmp60_;
	_tmp61_ = met;
	_tmp62_ = _tmp61_->errors;
	_tmp62__length1 = _tmp61_->errors_length1;
	{
		gchar** err_collection = NULL;
		gint err_collection_length1 = 0;
		gint _err_collection_size_ = 0;
		gint err_it = 0;
		err_collection = _tmp62_;
		err_collection_length1 = _tmp62__length1;
		for (err_it = 0; err_it < _tmp62__length1; err_it = err_it + 1) {
			gchar* _tmp63_;
			gchar* err = NULL;
			_tmp63_ = g_strdup (err_collection[err_it]);
			err = _tmp63_;
			{
				GeeHashMap* _tmp64_;
				GeeSet* _tmp65_;
				GeeSet* _tmp66_;
				GeeSet* _tmp67_;
				const gchar* _tmp68_;
				gboolean _tmp69_ = FALSE;
				gboolean _tmp70_;
				_tmp64_ = errordefs;
				_tmp65_ = gee_abstract_map_get_keys ((GeeMap*) _tmp64_);
				_tmp66_ = _tmp65_;
				_tmp67_ = _tmp66_;
				_tmp68_ = err;
				_tmp69_ = gee_collection_contains ((GeeCollection*) _tmp67_, _tmp68_);
				_tmp70_ = _tmp69_;
				_g_object_unref0 (_tmp67_);
				if (_tmp70_) {
					const gchar* _tmp71_;
					const gchar* _tmp72_;
					const gchar* _tmp73_ = NULL;
					gchar* _tmp74_ = NULL;
					gchar* _tmp75_;
					gchar* _tmp76_;
					_tmp71_ = str_throws;
					_tmp72_ = err;
					_tmp73_ = string_to_string (_tmp72_);
					_tmp74_ = g_strconcat (", ", _tmp73_, NULL);
					_tmp75_ = _tmp74_;
					_tmp76_ = g_strconcat (_tmp71_, _tmp75_, NULL);
					_g_free0 (str_throws);
					str_throws = _tmp76_;
					_g_free0 (_tmp75_);
				}
				_g_free0 (err);
			}
		}
	}
	_tmp77_ = ret;
	_tmp78_ = str_throws;
	_tmp79_ = string_to_string (_tmp78_);
	_tmp80_ = g_strconcat ("  throws RPCError", _tmp79_, NULL);
	_tmp81_ = _tmp80_;
	_tmp82_ = g_strconcat (_tmp77_, _tmp81_, NULL);
	_g_free0 (ret);
	ret = _tmp82_;
	_g_free0 (_tmp81_);
	result = ret;
	_g_free0 (str_throws);
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* end;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
		_tmp4_ = offset;
		_tmp5_ = len;
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
		string_length = _tmp6_;
	} else {
		gint _tmp7_;
		gint _tmp8_;
		_tmp7_ = strlen (self);
		_tmp8_ = _tmp7_;
		string_length = (glong) _tmp8_;
	}
	_tmp9_ = offset;
	if (_tmp9_ < ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
		_tmp10_ = string_length;
		_tmp11_ = offset;
		offset = _tmp10_ + _tmp11_;
		_tmp12_ = offset;
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
	} else {
		glong _tmp13_;
		glong _tmp14_;
		_tmp13_ = offset;
		_tmp14_ = string_length;
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
	}
	_tmp15_ = len;
	if (_tmp15_ < ((glong) 0)) {
		glong _tmp16_;
		glong _tmp17_;
		_tmp16_ = string_length;
		_tmp17_ = offset;
		len = _tmp16_ - _tmp17_;
	}
	_tmp18_ = offset;
	_tmp19_ = len;
	_tmp20_ = string_length;
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
	_tmp21_ = offset;
	_tmp22_ = len;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
	result = _tmp23_;
	return result;
}


void stub_declare_abstract_method (Method* met) {
	Method* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* signature;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* writ;
	const gchar* _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	g_return_if_fail (met != NULL);
	_tmp0_ = met;
	_tmp1_ = method_signature (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, ";\n", NULL);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	signature = _tmp4_;
	_tmp5_ = g_strdup (signature);
	_tmp6_ = indentlines (_tmp5_, "                       ");
	writ = _tmp6_;
	_tmp7_ = writ;
	_tmp8_ = string_substring (_tmp7_, (glong) 23, (glong) (-1));
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat ("        public abstract", _tmp9_, NULL);
	_g_free0 (writ);
	writ = _tmp10_;
	_g_free0 (_tmp9_);
	_tmp11_ = writ;
	wr (_tmp11_);
	_g_free0 (writ);
	_g_free0 (signature);
}


void stub_declare_method (Method* met) {
	Method* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* signature;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* writ;
	const gchar* _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	g_return_if_fail (met != NULL);
	_tmp0_ = met;
	_tmp1_ = method_signature (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, "\n", NULL);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	signature = _tmp4_;
	_tmp5_ = g_strdup (signature);
	_tmp6_ = indentlines (_tmp5_, "              ");
	writ = _tmp6_;
	_tmp7_ = writ;
	_tmp8_ = string_substring (_tmp7_, (glong) 14, (glong) (-1));
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat ("        public", _tmp9_, NULL);
	_g_free0 (writ);
	writ = _tmp10_;
	_g_free0 (_tmp9_);
	_tmp11_ = writ;
	wr (_tmp11_);
	_g_free0 (writ);
	_g_free0 (signature);
}


static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


void stub_add_parameters (Argument** args, int args_length1) {
	Argument** _tmp0_;
	gint _tmp0__length1;
	_tmp0_ = args;
	_tmp0__length1 = args_length1;
	{
		Argument** arg_collection = NULL;
		gint arg_collection_length1 = 0;
		gint _arg_collection_size_ = 0;
		gint arg_it = 0;
		arg_collection = _tmp0_;
		arg_collection_length1 = _tmp0__length1;
		for (arg_it = 0; arg_it < _tmp0__length1; arg_it = arg_it + 1) {
			Argument* _tmp1_;
			Argument* arg = NULL;
			_tmp1_ = _argument_ref0 (arg_collection[arg_it]);
			arg = _tmp1_;
			{
				gboolean _tmp2_ = FALSE;
				Argument* _tmp3_;
				const gchar* _tmp4_;
				gint _tmp5_;
				gint _tmp6_;
				gboolean _tmp15_;
				_tmp3_ = arg;
				_tmp4_ = _tmp3_->classname;
				_tmp5_ = strlen (_tmp4_);
				_tmp6_ = _tmp5_;
				if (_tmp6_ > 1) {
					Argument* _tmp7_;
					const gchar* _tmp8_;
					Argument* _tmp9_;
					const gchar* _tmp10_;
					gint _tmp11_;
					gint _tmp12_;
					gchar* _tmp13_ = NULL;
					gchar* _tmp14_;
					_tmp7_ = arg;
					_tmp8_ = _tmp7_->classname;
					_tmp9_ = arg;
					_tmp10_ = _tmp9_->classname;
					_tmp11_ = strlen (_tmp10_);
					_tmp12_ = _tmp11_;
					_tmp13_ = string_substring (_tmp8_, (glong) (_tmp12_ - 1), (glong) (-1));
					_tmp14_ = _tmp13_;
					_tmp2_ = g_strcmp0 (_tmp14_, "?") == 0;
					_g_free0 (_tmp14_);
				} else {
					_tmp2_ = FALSE;
				}
				_tmp15_ = _tmp2_;
				if (_tmp15_) {
					Argument* _tmp16_;
					const gchar* _tmp17_;
					Argument* _tmp18_;
					const gchar* _tmp19_;
					gint _tmp20_;
					gint _tmp21_;
					gchar* _tmp22_ = NULL;
					gchar* nullclassname;
					const gchar* _tmp23_;
					gchar** _tmp24_;
					gint _tmp24__length1;
					_tmp16_ = arg;
					_tmp17_ = _tmp16_->classname;
					_tmp18_ = arg;
					_tmp19_ = _tmp18_->classname;
					_tmp20_ = strlen (_tmp19_);
					_tmp21_ = _tmp20_;
					_tmp22_ = string_substring (_tmp17_, (glong) 0, (glong) (_tmp21_ - 1));
					nullclassname = _tmp22_;
					_tmp23_ = nullclassname;
					_tmp24_ = serializable_types;
					_tmp24__length1 = serializable_types_length1;
					if (_vala_string_array_contains (_tmp24_, _tmp24__length1, _tmp23_)) {
						Argument* _tmp25_;
						const gchar* _tmp26_;
						const gchar* _tmp27_ = NULL;
						gchar* _tmp28_ = NULL;
						gchar* _tmp29_;
						Argument* _tmp30_;
						const gchar* _tmp31_;
						const gchar* _tmp32_ = NULL;
						gchar* _tmp33_ = NULL;
						gchar* _tmp34_;
						_tmp25_ = arg;
						_tmp26_ = _tmp25_->argname;
						_tmp27_ = string_to_string (_tmp26_);
						_tmp28_ = g_strconcat ("          if (", _tmp27_, " == null) rc.add_parameter(new SerializableNone());", NULL);
						_tmp29_ = _tmp28_;
						wr_line (_tmp29_);
						_g_free0 (_tmp29_);
						_tmp30_ = arg;
						_tmp31_ = _tmp30_->argname;
						_tmp32_ = string_to_string (_tmp31_);
						_tmp33_ = g_strconcat ("          else rc.add_parameter(", _tmp32_, ");", NULL);
						_tmp34_ = _tmp33_;
						wr_line (_tmp34_);
						_g_free0 (_tmp34_);
					} else {
						const gchar* _tmp35_;
						_tmp35_ = nullclassname;
						if (g_strcmp0 (_tmp35_, "int") == 0) {
							Argument* _tmp36_;
							const gchar* _tmp37_;
							const gchar* _tmp38_ = NULL;
							gchar* _tmp39_ = NULL;
							gchar* _tmp40_;
							Argument* _tmp41_;
							const gchar* _tmp42_;
							const gchar* _tmp43_ = NULL;
							gchar* _tmp44_ = NULL;
							gchar* _tmp45_;
							_tmp36_ = arg;
							_tmp37_ = _tmp36_->argname;
							_tmp38_ = string_to_string (_tmp37_);
							_tmp39_ = g_strconcat ("          if (", _tmp38_, " == null) rc.add_parameter(new SerializableNone());", NULL);
							_tmp40_ = _tmp39_;
							wr_line (_tmp40_);
							_g_free0 (_tmp40_);
							_tmp41_ = arg;
							_tmp42_ = _tmp41_->argname;
							_tmp43_ = string_to_string (_tmp42_);
							_tmp44_ = g_strconcat ("          else rc.add_parameter(new SerializableInt(", _tmp43_, "));", NULL);
							_tmp45_ = _tmp44_;
							wr_line (_tmp45_);
							_g_free0 (_tmp45_);
						} else {
							const gchar* _tmp46_;
							_tmp46_ = nullclassname;
							if (g_strcmp0 (_tmp46_, "bool") == 0) {
								Argument* _tmp47_;
								const gchar* _tmp48_;
								const gchar* _tmp49_ = NULL;
								gchar* _tmp50_ = NULL;
								gchar* _tmp51_;
								Argument* _tmp52_;
								const gchar* _tmp53_;
								const gchar* _tmp54_ = NULL;
								gchar* _tmp55_ = NULL;
								gchar* _tmp56_;
								_tmp47_ = arg;
								_tmp48_ = _tmp47_->argname;
								_tmp49_ = string_to_string (_tmp48_);
								_tmp50_ = g_strconcat ("          if (", _tmp49_, " == null) rc.add_parameter(new SerializableNone());", NULL);
								_tmp51_ = _tmp50_;
								wr_line (_tmp51_);
								_g_free0 (_tmp51_);
								_tmp52_ = arg;
								_tmp53_ = _tmp52_->argname;
								_tmp54_ = string_to_string (_tmp53_);
								_tmp55_ = g_strconcat ("          else rc.add_parameter(new SerializableBool(", _tmp54_, "));", NULL);
								_tmp56_ = _tmp55_;
								wr_line (_tmp56_);
								_g_free0 (_tmp56_);
							} else {
								const gchar* _tmp57_;
								_tmp57_ = nullclassname;
								if (g_strcmp0 (_tmp57_, "string") == 0) {
									Argument* _tmp58_;
									const gchar* _tmp59_;
									const gchar* _tmp60_ = NULL;
									gchar* _tmp61_ = NULL;
									gchar* _tmp62_;
									Argument* _tmp63_;
									const gchar* _tmp64_;
									const gchar* _tmp65_ = NULL;
									gchar* _tmp66_ = NULL;
									gchar* _tmp67_;
									_tmp58_ = arg;
									_tmp59_ = _tmp58_->argname;
									_tmp60_ = string_to_string (_tmp59_);
									_tmp61_ = g_strconcat ("          if (", _tmp60_, " == null) rc.add_parameter(new SerializableNone());", NULL);
									_tmp62_ = _tmp61_;
									wr_line (_tmp62_);
									_g_free0 (_tmp62_);
									_tmp63_ = arg;
									_tmp64_ = _tmp63_->argname;
									_tmp65_ = string_to_string (_tmp64_);
									_tmp66_ = g_strconcat ("          else rc.add_parameter(new SerializableString(", _tmp65_, "));", NULL);
									_tmp67_ = _tmp66_;
									wr_line (_tmp67_);
									_g_free0 (_tmp67_);
								}
							}
						}
					}
					_g_free0 (nullclassname);
				} else {
					Argument* _tmp68_;
					const gchar* _tmp69_;
					_tmp68_ = arg;
					_tmp69_ = _tmp68_->classname;
					if (g_strcmp0 (_tmp69_, "ISerializable") == 0) {
						Argument* _tmp70_;
						const gchar* _tmp71_;
						const gchar* _tmp72_ = NULL;
						gchar* _tmp73_ = NULL;
						gchar* _tmp74_;
						_tmp70_ = arg;
						_tmp71_ = _tmp70_->argname;
						_tmp72_ = string_to_string (_tmp71_);
						_tmp73_ = g_strconcat ("          rc.add_parameter(", _tmp72_, ");", NULL);
						_tmp74_ = _tmp73_;
						wr_line (_tmp74_);
						_g_free0 (_tmp74_);
					} else {
						Argument* _tmp75_;
						const gchar* _tmp76_;
						gchar** _tmp77_;
						gint _tmp77__length1;
						_tmp75_ = arg;
						_tmp76_ = _tmp75_->classname;
						_tmp77_ = serializable_types;
						_tmp77__length1 = serializable_types_length1;
						if (_vala_string_array_contains (_tmp77_, _tmp77__length1, _tmp76_)) {
							Argument* _tmp78_;
							const gchar* _tmp79_;
							const gchar* _tmp80_ = NULL;
							gchar* _tmp81_ = NULL;
							gchar* _tmp82_;
							_tmp78_ = arg;
							_tmp79_ = _tmp78_->argname;
							_tmp80_ = string_to_string (_tmp79_);
							_tmp81_ = g_strconcat ("          rc.add_parameter(", _tmp80_, ");", NULL);
							_tmp82_ = _tmp81_;
							wr_line (_tmp82_);
							_g_free0 (_tmp82_);
						} else {
							Argument* _tmp83_;
							const gchar* _tmp84_;
							_tmp83_ = arg;
							_tmp84_ = _tmp83_->classname;
							if (g_strcmp0 (_tmp84_, "int") == 0) {
								Argument* _tmp85_;
								const gchar* _tmp86_;
								const gchar* _tmp87_ = NULL;
								gchar* _tmp88_ = NULL;
								gchar* _tmp89_;
								_tmp85_ = arg;
								_tmp86_ = _tmp85_->argname;
								_tmp87_ = string_to_string (_tmp86_);
								_tmp88_ = g_strconcat ("          rc.add_parameter(new SerializableInt(", _tmp87_, "));", NULL);
								_tmp89_ = _tmp88_;
								wr_line (_tmp89_);
								_g_free0 (_tmp89_);
							} else {
								Argument* _tmp90_;
								const gchar* _tmp91_;
								_tmp90_ = arg;
								_tmp91_ = _tmp90_->classname;
								if (g_strcmp0 (_tmp91_, "bool") == 0) {
									Argument* _tmp92_;
									const gchar* _tmp93_;
									const gchar* _tmp94_ = NULL;
									gchar* _tmp95_ = NULL;
									gchar* _tmp96_;
									_tmp92_ = arg;
									_tmp93_ = _tmp92_->argname;
									_tmp94_ = string_to_string (_tmp93_);
									_tmp95_ = g_strconcat ("          rc.add_parameter(new SerializableBool(", _tmp94_, "));", NULL);
									_tmp96_ = _tmp95_;
									wr_line (_tmp96_);
									_g_free0 (_tmp96_);
								} else {
									Argument* _tmp97_;
									const gchar* _tmp98_;
									_tmp97_ = arg;
									_tmp98_ = _tmp97_->classname;
									if (g_strcmp0 (_tmp98_, "string") == 0) {
										Argument* _tmp99_;
										const gchar* _tmp100_;
										const gchar* _tmp101_ = NULL;
										gchar* _tmp102_ = NULL;
										gchar* _tmp103_;
										_tmp99_ = arg;
										_tmp100_ = _tmp99_->argname;
										_tmp101_ = string_to_string (_tmp100_);
										_tmp102_ = g_strconcat ("          rc.add_parameter(new SerializableString(", _tmp101_, "));", NULL);
										_tmp103_ = _tmp102_;
										wr_line (_tmp103_);
										_g_free0 (_tmp103_);
									} else {
										Argument* _tmp104_;
										const gchar* _tmp105_;
										_tmp104_ = arg;
										_tmp105_ = _tmp104_->classname;
										if (g_strcmp0 (_tmp105_, "Gee.List<string>") == 0) {
											Argument* _tmp106_;
											const gchar* _tmp107_;
											const gchar* _tmp108_ = NULL;
											Argument* _tmp109_;
											const gchar* _tmp110_;
											const gchar* _tmp111_ = NULL;
											gchar* _tmp112_ = NULL;
											gchar* _tmp113_;
											Argument* _tmp114_;
											const gchar* _tmp115_;
											const gchar* _tmp116_ = NULL;
											gchar* _tmp117_ = NULL;
											gchar* _tmp118_;
											_tmp106_ = arg;
											_tmp107_ = _tmp106_->argname;
											_tmp108_ = string_to_string (_tmp107_);
											_tmp109_ = arg;
											_tmp110_ = _tmp109_->argname;
											_tmp111_ = string_to_string (_tmp110_);
											_tmp112_ = g_strconcat ("          ListString _", _tmp108_, " = new ListString.with_backer(", _tmp111_, ");", NULL);
											_tmp113_ = _tmp112_;
											wr_line (_tmp113_);
											_g_free0 (_tmp113_);
											_tmp114_ = arg;
											_tmp115_ = _tmp114_->argname;
											_tmp116_ = string_to_string (_tmp115_);
											_tmp117_ = g_strconcat ("          rc.add_parameter(_", _tmp116_, ");", NULL);
											_tmp118_ = _tmp117_;
											wr_line (_tmp118_);
											_g_free0 (_tmp118_);
										} else {
											gboolean _tmp119_ = FALSE;
											Argument* _tmp120_;
											const gchar* _tmp121_;
											gint _tmp122_;
											gint _tmp123_;
											gboolean _tmp128_;
											_tmp120_ = arg;
											_tmp121_ = _tmp120_->classname;
											_tmp122_ = strlen (_tmp121_);
											_tmp123_ = _tmp122_;
											if (_tmp123_ > 9) {
												Argument* _tmp124_;
												const gchar* _tmp125_;
												gchar* _tmp126_ = NULL;
												gchar* _tmp127_;
												_tmp124_ = arg;
												_tmp125_ = _tmp124_->classname;
												_tmp126_ = string_substring (_tmp125_, (glong) 0, (glong) 9);
												_tmp127_ = _tmp126_;
												_tmp119_ = g_strcmp0 (_tmp127_, "Gee.List<") == 0;
												_g_free0 (_tmp127_);
											} else {
												_tmp119_ = FALSE;
											}
											_tmp128_ = _tmp119_;
											if (_tmp128_) {
												Argument* _tmp129_;
												const gchar* _tmp130_;
												const gchar* _tmp131_ = NULL;
												Argument* _tmp132_;
												const gchar* _tmp133_;
												const gchar* _tmp134_ = NULL;
												gchar* _tmp135_ = NULL;
												gchar* _tmp136_;
												Argument* _tmp137_;
												const gchar* _tmp138_;
												const gchar* _tmp139_ = NULL;
												gchar* _tmp140_ = NULL;
												gchar* _tmp141_;
												_tmp129_ = arg;
												_tmp130_ = _tmp129_->argname;
												_tmp131_ = string_to_string (_tmp130_);
												_tmp132_ = arg;
												_tmp133_ = _tmp132_->argname;
												_tmp134_ = string_to_string (_tmp133_);
												_tmp135_ = g_strconcat ("          ListISerializable _", _tmp131_, " = new ListISerializable.with_backer(", _tmp134_, ");", NULL);
												_tmp136_ = _tmp135_;
												wr_line (_tmp136_);
												_g_free0 (_tmp136_);
												_tmp137_ = arg;
												_tmp138_ = _tmp137_->argname;
												_tmp139_ = string_to_string (_tmp138_);
												_tmp140_ = g_strconcat ("          rc.add_parameter(_", _tmp139_, ");", NULL);
												_tmp141_ = _tmp140_;
												wr_line (_tmp141_);
												_g_free0 (_tmp141_);
											}
										}
									}
								}
							}
						}
					}
				}
				_argument_unref0 (arg);
			}
		}
	}
}


void stub_launch_method_firstpart (Method* met) {
	Method* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp44_;
	Method* _tmp45_;
	gchar** _tmp46_;
	gint _tmp46__length1;
	g_return_if_fail (met != NULL);
	_tmp0_ = met;
	_tmp1_ = _tmp0_->returntype;
	if (g_strcmp0 (_tmp1_, "void") == 0) {
		wr_line ("              filter_exception(");
	} else {
		gboolean _tmp2_ = FALSE;
		Method* _tmp3_;
		const gchar* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gboolean _tmp15_;
		_tmp3_ = met;
		_tmp4_ = _tmp3_->returntype;
		_tmp5_ = strlen (_tmp4_);
		_tmp6_ = _tmp5_;
		if (_tmp6_ > 1) {
			Method* _tmp7_;
			const gchar* _tmp8_;
			Method* _tmp9_;
			const gchar* _tmp10_;
			gint _tmp11_;
			gint _tmp12_;
			gchar* _tmp13_ = NULL;
			gchar* _tmp14_;
			_tmp7_ = met;
			_tmp8_ = _tmp7_->returntype;
			_tmp9_ = met;
			_tmp10_ = _tmp9_->returntype;
			_tmp11_ = strlen (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = string_substring (_tmp8_, (glong) (_tmp12_ - 1), (glong) (-1));
			_tmp14_ = _tmp13_;
			_tmp2_ = g_strcmp0 (_tmp14_, "?") == 0;
			_g_free0 (_tmp14_);
		} else {
			_tmp2_ = FALSE;
		}
		_tmp15_ = _tmp2_;
		if (_tmp15_) {
			wr_block ("\n" \
"                ISerializable ret =\n" \
"                    filter_exception(\n");
		} else {
			Method* _tmp16_;
			const gchar* _tmp17_;
			_tmp16_ = met;
			_tmp17_ = _tmp16_->returntype;
			if (g_strcmp0 (_tmp17_, "ISerializable") == 0) {
				wr_line ("              return");
				wr_line ("                  filter_exception(");
			} else {
				Method* _tmp18_;
				const gchar* _tmp19_;
				gchar** _tmp20_;
				gint _tmp20__length1;
				_tmp18_ = met;
				_tmp19_ = _tmp18_->returntype;
				_tmp20_ = serializable_types;
				_tmp20__length1 = serializable_types_length1;
				if (_vala_string_array_contains (_tmp20_, _tmp20__length1, _tmp19_)) {
					Method* _tmp21_;
					const gchar* _tmp22_;
					const gchar* _tmp23_ = NULL;
					gchar* _tmp24_ = NULL;
					gchar* _tmp25_;
					_tmp21_ = met;
					_tmp22_ = _tmp21_->returntype;
					_tmp23_ = string_to_string (_tmp22_);
					_tmp24_ = g_strconcat ("              return (", _tmp23_, ")", NULL);
					_tmp25_ = _tmp24_;
					wr_line (_tmp25_);
					_g_free0 (_tmp25_);
					wr_line ("                  filter_exception(");
				} else {
					Method* _tmp26_;
					const gchar* _tmp27_;
					_tmp26_ = met;
					_tmp27_ = _tmp26_->returntype;
					if (g_strcmp0 (_tmp27_, "int") == 0) {
						wr_line ("              return ((SerializableInt)");
						wr_line ("                  filter_exception(");
					} else {
						Method* _tmp28_;
						const gchar* _tmp29_;
						_tmp28_ = met;
						_tmp29_ = _tmp28_->returntype;
						if (g_strcmp0 (_tmp29_, "bool") == 0) {
							wr_line ("              return ((SerializableBool)");
							wr_line ("                  filter_exception(");
						} else {
							Method* _tmp30_;
							const gchar* _tmp31_;
							_tmp30_ = met;
							_tmp31_ = _tmp30_->returntype;
							if (g_strcmp0 (_tmp31_, "string") == 0) {
								wr_line ("              return ((SerializableString)");
								wr_line ("                  filter_exception(");
							} else {
								Method* _tmp32_;
								const gchar* _tmp33_;
								_tmp32_ = met;
								_tmp33_ = _tmp32_->returntype;
								if (g_strcmp0 (_tmp33_, "Gee.List<string>") == 0) {
									wr_line ("              ListString ret = (ListString)");
									wr_line ("                  filter_exception(");
								} else {
									gboolean _tmp34_ = FALSE;
									Method* _tmp35_;
									const gchar* _tmp36_;
									gint _tmp37_;
									gint _tmp38_;
									gboolean _tmp43_;
									_tmp35_ = met;
									_tmp36_ = _tmp35_->returntype;
									_tmp37_ = strlen (_tmp36_);
									_tmp38_ = _tmp37_;
									if (_tmp38_ > 9) {
										Method* _tmp39_;
										const gchar* _tmp40_;
										gchar* _tmp41_ = NULL;
										gchar* _tmp42_;
										_tmp39_ = met;
										_tmp40_ = _tmp39_->returntype;
										_tmp41_ = string_substring (_tmp40_, (glong) 0, (glong) 9);
										_tmp42_ = _tmp41_;
										_tmp34_ = g_strcmp0 (_tmp42_, "Gee.List<") == 0;
										_g_free0 (_tmp42_);
									} else {
										_tmp34_ = FALSE;
									}
									_tmp43_ = _tmp34_;
									if (_tmp43_) {
										wr_line ("              ListISerializable ret = (ListISerializable)");
										wr_line ("                  filter_exception(");
									}
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp44_ = g_strdup ("");
	_g_free0 (closepar);
	closepar = _tmp44_;
	_tmp45_ = met;
	_tmp46_ = _tmp45_->errors;
	_tmp46__length1 = _tmp45_->errors_length1;
	{
		gchar** err_collection = NULL;
		gint err_collection_length1 = 0;
		gint _err_collection_size_ = 0;
		gint err_it = 0;
		err_collection = _tmp46_;
		err_collection_length1 = _tmp46__length1;
		for (err_it = 0; err_it < _tmp46__length1; err_it = err_it + 1) {
			gchar* _tmp47_;
			gchar* err = NULL;
			_tmp47_ = g_strdup (err_collection[err_it]);
			err = _tmp47_;
			{
				GeeHashMap* _tmp48_;
				GeeSet* _tmp49_;
				GeeSet* _tmp50_;
				GeeSet* _tmp51_;
				const gchar* _tmp52_;
				gboolean _tmp53_ = FALSE;
				gboolean _tmp54_;
				_tmp48_ = errordefs;
				_tmp49_ = gee_abstract_map_get_keys ((GeeMap*) _tmp48_);
				_tmp50_ = _tmp49_;
				_tmp51_ = _tmp50_;
				_tmp52_ = err;
				_tmp53_ = gee_collection_contains ((GeeCollection*) _tmp51_, _tmp52_);
				_tmp54_ = _tmp53_;
				_g_object_unref0 (_tmp51_);
				if (_tmp54_) {
					const gchar* _tmp55_;
					const gchar* _tmp56_ = NULL;
					gchar* _tmp57_ = NULL;
					gchar* _tmp58_;
					const gchar* _tmp59_;
					gchar* _tmp60_;
					_tmp55_ = err;
					_tmp56_ = string_to_string (_tmp55_);
					_tmp57_ = g_strconcat ("                  filter_exception_", _tmp56_, "(", NULL);
					_tmp58_ = _tmp57_;
					wr_line (_tmp58_);
					_g_free0 (_tmp58_);
					_tmp59_ = closepar;
					_tmp60_ = g_strconcat (_tmp59_, ")", NULL);
					_g_free0 (closepar);
					closepar = _tmp60_;
				}
				_g_free0 (err);
			}
		}
	}
}


void stub_launch_method_secondpart (Method* met) {
	Method* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (met != NULL);
	_tmp0_ = met;
	_tmp1_ = _tmp0_->returntype;
	if (g_strcmp0 (_tmp1_, "void") == 0) {
		wr_line ("              );");
	} else {
		gboolean _tmp2_ = FALSE;
		Method* _tmp3_;
		const gchar* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gboolean _tmp15_;
		_tmp3_ = met;
		_tmp4_ = _tmp3_->returntype;
		_tmp5_ = strlen (_tmp4_);
		_tmp6_ = _tmp5_;
		if (_tmp6_ > 1) {
			Method* _tmp7_;
			const gchar* _tmp8_;
			Method* _tmp9_;
			const gchar* _tmp10_;
			gint _tmp11_;
			gint _tmp12_;
			gchar* _tmp13_ = NULL;
			gchar* _tmp14_;
			_tmp7_ = met;
			_tmp8_ = _tmp7_->returntype;
			_tmp9_ = met;
			_tmp10_ = _tmp9_->returntype;
			_tmp11_ = strlen (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = string_substring (_tmp8_, (glong) (_tmp12_ - 1), (glong) (-1));
			_tmp14_ = _tmp13_;
			_tmp2_ = g_strcmp0 (_tmp14_, "?") == 0;
			_g_free0 (_tmp14_);
		} else {
			_tmp2_ = FALSE;
		}
		_tmp15_ = _tmp2_;
		if (_tmp15_) {
			Method* _tmp16_;
			const gchar* _tmp17_;
			Method* _tmp18_;
			const gchar* _tmp19_;
			gint _tmp20_;
			gint _tmp21_;
			gchar* _tmp22_ = NULL;
			gchar* nullclassname;
			const gchar* _tmp23_;
			gchar** _tmp24_;
			gint _tmp24__length1;
			_tmp16_ = met;
			_tmp17_ = _tmp16_->returntype;
			_tmp18_ = met;
			_tmp19_ = _tmp18_->returntype;
			_tmp20_ = strlen (_tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = string_substring (_tmp17_, (glong) 0, (glong) (_tmp21_ - 1));
			nullclassname = _tmp22_;
			_tmp23_ = nullclassname;
			_tmp24_ = serializable_types;
			_tmp24__length1 = serializable_types_length1;
			if (_vala_string_array_contains (_tmp24_, _tmp24__length1, _tmp23_)) {
				const gchar* _tmp25_;
				const gchar* _tmp26_ = NULL;
				gchar* _tmp27_ = NULL;
				gchar* _tmp28_;
				wr_block ("\n" \
"                );\n" \
"                if (ret.get_type().is_a(typeof(SerializableNone))) ret" \
"urn null;\n");
				_tmp25_ = nullclassname;
				_tmp26_ = string_to_string (_tmp25_);
				_tmp27_ = g_strconcat ("              else return (", _tmp26_, ")ret;", NULL);
				_tmp28_ = _tmp27_;
				wr_line (_tmp28_);
				_g_free0 (_tmp28_);
			} else {
				const gchar* _tmp29_;
				_tmp29_ = nullclassname;
				if (g_strcmp0 (_tmp29_, "int") == 0) {
					wr_block ("\n" \
"                );\n" \
"                if (ret.get_type().is_a(typeof(SerializableNone))) ret" \
"urn null;\n");
					wr_line ("              else return ((SerializableInt)ret).i;");
				} else {
					const gchar* _tmp30_;
					_tmp30_ = nullclassname;
					if (g_strcmp0 (_tmp30_, "bool") == 0) {
						wr_block ("\n" \
"                );\n" \
"                if (ret.get_type().is_a(typeof(SerializableNone))) ret" \
"urn null;\n");
						wr_line ("              else return ((SerializableBool)ret).b;");
					} else {
						const gchar* _tmp31_;
						_tmp31_ = nullclassname;
						if (g_strcmp0 (_tmp31_, "string") == 0) {
							wr_block ("\n" \
"                );\n" \
"                if (ret.get_type().is_a(typeof(SerializableNone))) ret" \
"urn null;\n");
							wr_line ("              else return ((SerializableString)ret).s;");
						}
					}
				}
			}
			_g_free0 (nullclassname);
		} else {
			Method* _tmp32_;
			const gchar* _tmp33_;
			_tmp32_ = met;
			_tmp33_ = _tmp32_->returntype;
			if (g_strcmp0 (_tmp33_, "ISerializable") == 0) {
				wr_line ("              );");
			} else {
				Method* _tmp34_;
				const gchar* _tmp35_;
				gchar** _tmp36_;
				gint _tmp36__length1;
				_tmp34_ = met;
				_tmp35_ = _tmp34_->returntype;
				_tmp36_ = serializable_types;
				_tmp36__length1 = serializable_types_length1;
				if (_vala_string_array_contains (_tmp36_, _tmp36__length1, _tmp35_)) {
					wr_line ("              );");
				} else {
					Method* _tmp37_;
					const gchar* _tmp38_;
					_tmp37_ = met;
					_tmp38_ = _tmp37_->returntype;
					if (g_strcmp0 (_tmp38_, "int") == 0) {
						wr_line ("              )).i;");
					} else {
						Method* _tmp39_;
						const gchar* _tmp40_;
						_tmp39_ = met;
						_tmp40_ = _tmp39_->returntype;
						if (g_strcmp0 (_tmp40_, "bool") == 0) {
							wr_line ("              )).b;");
						} else {
							Method* _tmp41_;
							const gchar* _tmp42_;
							_tmp41_ = met;
							_tmp42_ = _tmp41_->returntype;
							if (g_strcmp0 (_tmp42_, "string") == 0) {
								wr_line ("              )).s;");
							} else {
								gboolean _tmp43_ = FALSE;
								Method* _tmp44_;
								const gchar* _tmp45_;
								gint _tmp46_;
								gint _tmp47_;
								gboolean _tmp52_;
								_tmp44_ = met;
								_tmp45_ = _tmp44_->returntype;
								_tmp46_ = strlen (_tmp45_);
								_tmp47_ = _tmp46_;
								if (_tmp47_ > 9) {
									Method* _tmp48_;
									const gchar* _tmp49_;
									gchar* _tmp50_ = NULL;
									gchar* _tmp51_;
									_tmp48_ = met;
									_tmp49_ = _tmp48_->returntype;
									_tmp50_ = string_substring (_tmp49_, (glong) 0, (glong) 9);
									_tmp51_ = _tmp50_;
									_tmp43_ = g_strcmp0 (_tmp51_, "Gee.List<") == 0;
									_g_free0 (_tmp51_);
								} else {
									_tmp43_ = FALSE;
								}
								_tmp52_ = _tmp43_;
								if (_tmp52_) {
									Method* _tmp53_;
									const gchar* _tmp54_;
									Method* _tmp55_;
									const gchar* _tmp56_;
									gint _tmp57_;
									gint _tmp58_;
									gchar* _tmp59_ = NULL;
									gchar* listof;
									const gchar* _tmp60_;
									const gchar* _tmp61_ = NULL;
									gchar* _tmp62_ = NULL;
									gchar* _tmp63_;
									_tmp53_ = met;
									_tmp54_ = _tmp53_->returntype;
									_tmp55_ = met;
									_tmp56_ = _tmp55_->returntype;
									_tmp57_ = strlen (_tmp56_);
									_tmp58_ = _tmp57_;
									_tmp59_ = string_substring (_tmp54_, (glong) 9, (glong) (_tmp58_ - 10));
									listof = _tmp59_;
									wr_line ("              );");
									_tmp60_ = listof;
									_tmp61_ = string_to_string (_tmp60_);
									_tmp62_ = g_strconcat ("              return (Gee.List<", _tmp61_, ">)ret.backed;", NULL);
									_tmp63_ = _tmp62_;
									wr_line (_tmp63_);
									_g_free0 (_tmp63_);
									_g_free0 (listof);
								}
							}
						}
					}
				}
			}
		}
	}
}


void write_file_of (void) {
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp19_;
	gint _tmp19__length1;
	gchar** _tmp57_;
	gint _tmp57__length1;
	_tmp0_ = remotes;
	_tmp0__length1 = remotes_length1;
	{
		gchar** remote_collection = NULL;
		gint remote_collection_length1 = 0;
		gint _remote_collection_size_ = 0;
		gint remote_it = 0;
		remote_collection = _tmp0_;
		remote_collection_length1 = _tmp0__length1;
		for (remote_it = 0; remote_it < _tmp0__length1; remote_it = remote_it + 1) {
			gchar* _tmp1_;
			gchar* remote = NULL;
			_tmp1_ = g_strdup (remote_collection[remote_it]);
			remote = _tmp1_;
			{
				const gchar* _tmp2_;
				const gchar* _tmp3_ = NULL;
				gchar* _tmp4_ = NULL;
				gchar* _tmp5_;
				wr_block ("\n\n");
				_tmp2_ = remote;
				_tmp3_ = string_to_string (_tmp2_);
				_tmp4_ = g_strconcat ("  public interface I", _tmp3_, "AsPeer : Object", NULL);
				_tmp5_ = _tmp4_;
				wr_line (_tmp5_);
				_g_free0 (_tmp5_);
				wr_line ("  {");
				{
					GeeHashMap* _tmp6_;
					const gchar* _tmp7_;
					gpointer _tmp8_ = NULL;
					GeeArrayList* _met_list;
					GeeArrayList* _tmp9_;
					gint _tmp10_;
					gint _tmp11_;
					gint _met_size;
					gint _met_index;
					_tmp6_ = methods;
					_tmp7_ = remote;
					_tmp8_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp6_, _tmp7_);
					_met_list = (GeeArrayList*) _tmp8_;
					_tmp9_ = _met_list;
					_tmp10_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp9_);
					_tmp11_ = _tmp10_;
					_met_size = _tmp11_;
					_met_index = -1;
					while (TRUE) {
						gint _tmp12_;
						gint _tmp13_;
						gint _tmp14_;
						GeeArrayList* _tmp15_;
						gint _tmp16_;
						gpointer _tmp17_ = NULL;
						Method* met;
						Method* _tmp18_;
						_tmp12_ = _met_index;
						_met_index = _tmp12_ + 1;
						_tmp13_ = _met_index;
						_tmp14_ = _met_size;
						if (!(_tmp13_ < _tmp14_)) {
							break;
						}
						_tmp15_ = _met_list;
						_tmp16_ = _met_index;
						_tmp17_ = gee_abstract_list_get ((GeeAbstractList*) _tmp15_, _tmp16_);
						met = (Method*) _tmp17_;
						_tmp18_ = met;
						stub_declare_abstract_method (_tmp18_);
						_method_unref0 (met);
					}
					_g_object_unref0 (_met_list);
				}
				wr_line ("  }");
				_g_free0 (remote);
			}
		}
	}
	_tmp19_ = remotes;
	_tmp19__length1 = remotes_length1;
	{
		gchar** remote_collection = NULL;
		gint remote_collection_length1 = 0;
		gint _remote_collection_size_ = 0;
		gint remote_it = 0;
		remote_collection = _tmp19_;
		remote_collection_length1 = _tmp19__length1;
		for (remote_it = 0; remote_it < _tmp19__length1; remote_it = remote_it + 1) {
			gchar* _tmp20_;
			gchar* remote = NULL;
			_tmp20_ = g_strdup (remote_collection[remote_it]);
			remote = _tmp20_;
			{
				const gchar* _tmp21_;
				const gchar* _tmp22_ = NULL;
				const gchar* _tmp23_;
				const gchar* _tmp24_ = NULL;
				gchar* _tmp25_ = NULL;
				gchar* _tmp26_;
				const gchar* _tmp27_;
				const gchar* _tmp28_ = NULL;
				gchar* _tmp29_ = NULL;
				gchar* _tmp30_;
				wr_block ("\n\n");
				_tmp21_ = remote;
				_tmp22_ = string_to_string (_tmp21_);
				_tmp23_ = remote;
				_tmp24_ = string_to_string (_tmp23_);
				_tmp25_ = g_strconcat ("  public class Rmt", _tmp22_, "Peer : RmtPeer, I", _tmp24_, "AsPeer", NULL);
				_tmp26_ = _tmp25_;
				wr_line (_tmp26_);
				_g_free0 (_tmp26_);
				wr_line ("  {");
				_tmp27_ = remote;
				_tmp28_ = string_to_string (_tmp27_);
				_tmp29_ = g_strconcat ("      public Rmt", _tmp28_, "Peer", NULL);
				_tmp30_ = _tmp29_;
				wr_line (_tmp30_);
				_g_free0 (_tmp30_);
				wr_block ("\n" \
"               (PeerToPeer peer_to_peer_service,\n" \
"                Object? key=null,\n" \
"                NIP? hIP=null,\n" \
"                AggregatedNeighbour? aggregated_neighbour=null)\n" \
"        {\n" \
"            base(peer_to_peer_service, key, hIP, aggregated_neighbour)" \
";\n" \
"        }\n" \
"\n");
				{
					GeeHashMap* _tmp31_;
					const gchar* _tmp32_;
					gpointer _tmp33_ = NULL;
					GeeArrayList* _met_list;
					GeeArrayList* _tmp34_;
					gint _tmp35_;
					gint _tmp36_;
					gint _met_size;
					gint _met_index;
					_tmp31_ = methods;
					_tmp32_ = remote;
					_tmp33_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp31_, _tmp32_);
					_met_list = (GeeArrayList*) _tmp33_;
					_tmp34_ = _met_list;
					_tmp35_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp34_);
					_tmp36_ = _tmp35_;
					_met_size = _tmp36_;
					_met_index = -1;
					while (TRUE) {
						gint _tmp37_;
						gint _tmp38_;
						gint _tmp39_;
						GeeArrayList* _tmp40_;
						gint _tmp41_;
						gpointer _tmp42_ = NULL;
						Method* met;
						Method* _tmp43_;
						Method* _tmp44_;
						const gchar* _tmp45_;
						const gchar* _tmp46_ = NULL;
						gchar* _tmp47_ = NULL;
						gchar* _tmp48_;
						Method* _tmp49_;
						Argument** _tmp50_;
						gint _tmp50__length1;
						Method* _tmp51_;
						const gchar* _tmp52_;
						const gchar* _tmp53_ = NULL;
						gchar* _tmp54_ = NULL;
						gchar* _tmp55_;
						Method* _tmp56_;
						_tmp37_ = _met_index;
						_met_index = _tmp37_ + 1;
						_tmp38_ = _met_index;
						_tmp39_ = _met_size;
						if (!(_tmp38_ < _tmp39_)) {
							break;
						}
						_tmp40_ = _met_list;
						_tmp41_ = _met_index;
						_tmp42_ = gee_abstract_list_get ((GeeAbstractList*) _tmp40_, _tmp41_);
						met = (Method*) _tmp42_;
						_tmp43_ = met;
						stub_declare_method (_tmp43_);
						wr_block ("\n        {\n            RemoteCall rc = new RemoteCall();\n");
						_tmp44_ = met;
						_tmp45_ = _tmp44_->name;
						_tmp46_ = string_to_string (_tmp45_);
						_tmp47_ = g_strconcat ("          rc.method_name = \"", _tmp46_, "\";", NULL);
						_tmp48_ = _tmp47_;
						wr_line (_tmp48_);
						_g_free0 (_tmp48_);
						_tmp49_ = met;
						_tmp50_ = _tmp49_->args;
						_tmp50__length1 = _tmp49_->args_length1;
						stub_add_parameters (_tmp50_, _tmp50__length1);
						wr_block ("\n            try {\n");
						_tmp51_ = met;
						stub_launch_method_firstpart (_tmp51_);
						_tmp52_ = closepar;
						_tmp53_ = string_to_string (_tmp52_);
						_tmp54_ = g_strconcat ("                  this.rmt(rc)", _tmp53_, NULL);
						_tmp55_ = _tmp54_;
						wr_line (_tmp55_);
						_g_free0 (_tmp55_);
						_tmp56_ = met;
						stub_launch_method_secondpart (_tmp56_);
						wr_block ("\n" \
"            }\n" \
"            catch (RPCError e) {throw e;}\n" \
"            catch (Error e)\n" \
"            {\n" \
"                throw new RPCError.GENERIC\n" \
"                    (@\"Unexpected error $(e.domain).$(e.code) '$(e.me" \
"ssage)'\");\n" \
"            }\n" \
"        }\n" \
"\n");
						_method_unref0 (met);
					}
					_g_object_unref0 (_met_list);
				}
				wr_block ("\n    }\n");
				_g_free0 (remote);
			}
		}
	}
	_tmp57_ = remotes;
	_tmp57__length1 = remotes_length1;
	{
		gchar** remote_collection = NULL;
		gint remote_collection_length1 = 0;
		gint _remote_collection_size_ = 0;
		gint remote_it = 0;
		remote_collection = _tmp57_;
		remote_collection_length1 = _tmp57__length1;
		for (remote_it = 0; remote_it < _tmp57__length1; remote_it = remote_it + 1) {
			gchar* _tmp58_;
			gchar* remote = NULL;
			_tmp58_ = g_strdup (remote_collection[remote_it]);
			remote = _tmp58_;
			{
				const gchar* _tmp59_;
				const gchar* _tmp60_ = NULL;
				const gchar* _tmp61_;
				const gchar* _tmp62_ = NULL;
				const gchar* _tmp63_;
				const gchar* _tmp64_ = NULL;
				gchar* _tmp65_ = NULL;
				gchar* _tmp66_;
				const gchar* _tmp67_;
				const gchar* _tmp68_ = NULL;
				gchar* _tmp69_ = NULL;
				gchar* _tmp70_;
				const gchar* _tmp71_;
				const gchar* _tmp72_ = NULL;
				gchar* _tmp73_ = NULL;
				gchar* _tmp74_;
				const gchar* _tmp75_;
				gchar* _tmp76_ = NULL;
				gchar* impl;
				const gchar* _tmp77_;
				wr_block ("\n\n");
				_tmp59_ = remote;
				_tmp60_ = string_to_string (_tmp59_);
				_tmp61_ = remote;
				_tmp62_ = string_to_string (_tmp61_);
				_tmp63_ = remote;
				_tmp64_ = string_to_string (_tmp63_);
				_tmp65_ = g_strconcat ("  public class ", _tmp60_, " : OptionalPeerToPeer, I", _tmp62_, "AsPeer, I", _tmp64_, NULL);
				_tmp66_ = _tmp65_;
				wr_line (_tmp66_);
				_g_free0 (_tmp66_);
				wr_block ("\n    {\n\n");
				_tmp67_ = remote;
				_tmp68_ = string_to_string (_tmp67_);
				_tmp69_ = g_strconcat ("      public Rmt", _tmp68_, "Peer", NULL);
				_tmp70_ = _tmp69_;
				wr_line (_tmp70_);
				_g_free0 (_tmp70_);
				wr_block ("\n" \
"               peer\n" \
"               (NIP? hIP=null,\n" \
"                Object? key=null,\n" \
"                AggregatedNeighbour? aggregated_neighbour=null)\n" \
"        {\n" \
"            assert(hIP != null || key != null);\n");
				_tmp71_ = remote;
				_tmp72_ = string_to_string (_tmp71_);
				_tmp73_ = g_strconcat ("          return new Rmt", _tmp72_, "Peer(this, key, hIP, aggregated_neighbour);", NULL);
				_tmp74_ = _tmp73_;
				wr_line (_tmp74_);
				_g_free0 (_tmp74_);
				wr_block ("\n        }\n\n");
				wr_block ("\n" \
"        /** This method could be called *directly* for a dispatcher th" \
"at does not need to transform\n" \
"          * an exception into a remotable.\n" \
"          */\n" \
"        public override ISerializable _dispatch(Object? caller, Remote" \
"Call data) throws Error\n" \
"        {\n" \
"            string[] pieces = data.method_name.split(\".\");\n");
				_tmp75_ = remote;
				_tmp76_ = recurse_remote_members (_tmp75_);
				impl = _tmp76_;
				_tmp77_ = impl;
				wr (_tmp77_);
				wr_block ("\n" \
"            return base._dispatch(caller, data);\n" \
"        }\n" \
"    }\n");
				_g_free0 (impl);
				_g_free0 (remote);
			}
		}
	}
}


gchar* recurse_remote_members (const gchar* classname) {
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* ret;
	g_return_val_if_fail (classname != NULL, NULL);
	_tmp0_ = g_strdup ("");
	ret = _tmp0_;
	{
		GeeHashMap* _tmp1_;
		const gchar* _tmp2_;
		gpointer _tmp3_ = NULL;
		GeeArrayList* _m_list;
		GeeArrayList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _m_size;
		gint _m_index;
		_tmp1_ = methods;
		_tmp2_ = classname;
		_tmp3_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, _tmp2_);
		_m_list = (GeeArrayList*) _tmp3_;
		_tmp4_ = _m_list;
		_tmp5_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_m_size = _tmp6_;
		_m_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			GeeArrayList* _tmp10_;
			gint _tmp11_;
			gpointer _tmp12_ = NULL;
			Method* m;
			const gchar* _tmp13_;
			Method* _tmp14_;
			const gchar* _tmp15_;
			const gchar* _tmp16_ = NULL;
			gchar* _tmp17_ = NULL;
			gchar* _tmp18_;
			gchar* _tmp19_ = NULL;
			gchar* _tmp20_;
			gchar* _tmp21_;
			const gchar* _tmp22_;
			gchar* _tmp23_ = NULL;
			gchar* _tmp24_;
			gchar* _tmp25_;
			const gchar* _tmp26_;
			gchar* _tmp27_ = NULL;
			gchar* _tmp28_;
			gchar* _tmp29_;
			const gchar* _tmp30_;
			gchar* _tmp31_ = NULL;
			gchar* _tmp32_;
			gchar* _tmp33_;
			const gchar* _tmp34_;
			Method* _tmp35_;
			const gchar* _tmp36_;
			const gchar* _tmp37_ = NULL;
			gchar* _tmp38_ = NULL;
			gchar* _tmp39_;
			gchar* _tmp40_ = NULL;
			gchar* _tmp41_;
			gchar* _tmp42_;
			const gchar* _tmp43_;
			Method* _tmp44_;
			Argument** _tmp45_;
			gint _tmp45__length1;
			gchar* _tmp46_ = NULL;
			gchar* _tmp47_;
			gchar* _tmp48_ = NULL;
			gchar* _tmp49_;
			gchar* _tmp50_ = NULL;
			gchar* _tmp51_;
			gchar* _tmp52_;
			const gchar* _tmp53_;
			gchar* _tmp54_ = NULL;
			gchar* _tmp55_;
			gchar* _tmp56_;
			Method* _tmp57_;
			Argument** _tmp58_;
			gint _tmp58__length1;
			gint argcount;
			Method* _tmp92_;
			Argument** _tmp93_;
			gint _tmp93__length1;
			gchar* _tmp676_;
			gchar* str_args;
			gchar* _tmp677_;
			gchar* str_args_next;
			Method* _tmp678_;
			Argument** _tmp679_;
			gint _tmp679__length1;
			Method* _tmp691_;
			gboolean _tmp692_;
			Method* _tmp699_;
			const gchar* _tmp700_;
			const gchar* _tmp701_ = NULL;
			const gchar* _tmp702_;
			const gchar* _tmp703_ = NULL;
			gchar* _tmp704_ = NULL;
			gchar* str_command;
			Method* _tmp705_;
			const gchar* _tmp706_;
			const gchar* _tmp907_;
			gchar* _tmp908_ = NULL;
			gchar* _tmp909_;
			gchar* _tmp910_;
			_tmp7_ = _m_index;
			_m_index = _tmp7_ + 1;
			_tmp8_ = _m_index;
			_tmp9_ = _m_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _m_list;
			_tmp11_ = _m_index;
			_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, _tmp11_);
			m = (Method*) _tmp12_;
			_tmp13_ = ret;
			_tmp14_ = m;
			_tmp15_ = _tmp14_->name;
			_tmp16_ = string_to_string (_tmp15_);
			_tmp17_ = g_strconcat ("          if (pieces[0] == \"", _tmp16_, "\")", NULL);
			_tmp18_ = _tmp17_;
			_tmp19_ = rec_line (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = g_strconcat (_tmp13_, _tmp20_, NULL);
			_g_free0 (ret);
			ret = _tmp21_;
			_g_free0 (_tmp20_);
			_g_free0 (_tmp18_);
			_tmp22_ = ret;
			_tmp23_ = rec_block ("\n            {\n");
			_tmp24_ = _tmp23_;
			_tmp25_ = g_strconcat (_tmp22_, _tmp24_, NULL);
			_g_free0 (ret);
			ret = _tmp25_;
			_g_free0 (_tmp24_);
			_tmp26_ = ret;
			_tmp27_ = rec_line ("              if (pieces.length != 1)");
			_tmp28_ = _tmp27_;
			_tmp29_ = g_strconcat (_tmp26_, _tmp28_, NULL);
			_g_free0 (ret);
			ret = _tmp29_;
			_g_free0 (_tmp28_);
			_tmp30_ = ret;
			_tmp31_ = rec_block ("\n                    throw new RPCError.MALFORMED_PACKET(\n");
			_tmp32_ = _tmp31_;
			_tmp33_ = g_strconcat (_tmp30_, _tmp32_, NULL);
			_g_free0 (ret);
			ret = _tmp33_;
			_g_free0 (_tmp32_);
			_tmp34_ = ret;
			_tmp35_ = m;
			_tmp36_ = _tmp35_->name;
			_tmp37_ = string_to_string (_tmp36_);
			_tmp38_ = g_strconcat ("                      \"", _tmp37_, " is a function.\");", NULL);
			_tmp39_ = _tmp38_;
			_tmp40_ = rec_line (_tmp39_);
			_tmp41_ = _tmp40_;
			_tmp42_ = g_strconcat (_tmp34_, _tmp41_, NULL);
			_g_free0 (ret);
			ret = _tmp42_;
			_g_free0 (_tmp41_);
			_g_free0 (_tmp39_);
			_tmp43_ = ret;
			_tmp44_ = m;
			_tmp45_ = _tmp44_->args;
			_tmp45__length1 = _tmp44_->args_length1;
			_tmp46_ = g_strdup_printf ("%i", _tmp45__length1);
			_tmp47_ = _tmp46_;
			_tmp48_ = g_strconcat ("              if (data.parameters.size != ", _tmp47_, ")", NULL);
			_tmp49_ = _tmp48_;
			_tmp50_ = rec_line (_tmp49_);
			_tmp51_ = _tmp50_;
			_tmp52_ = g_strconcat (_tmp43_, _tmp51_, NULL);
			_g_free0 (ret);
			ret = _tmp52_;
			_g_free0 (_tmp51_);
			_g_free0 (_tmp49_);
			_g_free0 (_tmp47_);
			_tmp53_ = ret;
			_tmp54_ = rec_block ("\n                    throw new RPCError.MALFORMED_PACKET(\n");
			_tmp55_ = _tmp54_;
			_tmp56_ = g_strconcat (_tmp53_, _tmp55_, NULL);
			_g_free0 (ret);
			ret = _tmp56_;
			_g_free0 (_tmp55_);
			_tmp57_ = m;
			_tmp58_ = _tmp57_->args;
			_tmp58__length1 = _tmp57_->args_length1;
			if (_tmp58__length1 == 0) {
				const gchar* _tmp59_;
				Method* _tmp60_;
				const gchar* _tmp61_;
				const gchar* _tmp62_ = NULL;
				gchar* _tmp63_ = NULL;
				gchar* _tmp64_;
				gchar* _tmp65_ = NULL;
				gchar* _tmp66_;
				gchar* _tmp67_;
				_tmp59_ = ret;
				_tmp60_ = m;
				_tmp61_ = _tmp60_->name;
				_tmp62_ = string_to_string (_tmp61_);
				_tmp63_ = g_strconcat ("                      \"", _tmp62_, " wants no parameters.\");", NULL);
				_tmp64_ = _tmp63_;
				_tmp65_ = rec_line (_tmp64_);
				_tmp66_ = _tmp65_;
				_tmp67_ = g_strconcat (_tmp59_, _tmp66_, NULL);
				_g_free0 (ret);
				ret = _tmp67_;
				_g_free0 (_tmp66_);
				_g_free0 (_tmp64_);
			} else {
				Method* _tmp68_;
				Argument** _tmp69_;
				gint _tmp69__length1;
				_tmp68_ = m;
				_tmp69_ = _tmp68_->args;
				_tmp69__length1 = _tmp68_->args_length1;
				if (_tmp69__length1 == 1) {
					const gchar* _tmp70_;
					Method* _tmp71_;
					const gchar* _tmp72_;
					const gchar* _tmp73_ = NULL;
					gchar* _tmp74_ = NULL;
					gchar* _tmp75_;
					gchar* _tmp76_ = NULL;
					gchar* _tmp77_;
					gchar* _tmp78_;
					_tmp70_ = ret;
					_tmp71_ = m;
					_tmp72_ = _tmp71_->name;
					_tmp73_ = string_to_string (_tmp72_);
					_tmp74_ = g_strconcat ("                      \"", _tmp73_, " wants 1 parameter.\");", NULL);
					_tmp75_ = _tmp74_;
					_tmp76_ = rec_line (_tmp75_);
					_tmp77_ = _tmp76_;
					_tmp78_ = g_strconcat (_tmp70_, _tmp77_, NULL);
					_g_free0 (ret);
					ret = _tmp78_;
					_g_free0 (_tmp77_);
					_g_free0 (_tmp75_);
				} else {
					const gchar* _tmp79_;
					Method* _tmp80_;
					const gchar* _tmp81_;
					const gchar* _tmp82_ = NULL;
					Method* _tmp83_;
					Argument** _tmp84_;
					gint _tmp84__length1;
					gchar* _tmp85_ = NULL;
					gchar* _tmp86_;
					gchar* _tmp87_ = NULL;
					gchar* _tmp88_;
					gchar* _tmp89_ = NULL;
					gchar* _tmp90_;
					gchar* _tmp91_;
					_tmp79_ = ret;
					_tmp80_ = m;
					_tmp81_ = _tmp80_->name;
					_tmp82_ = string_to_string (_tmp81_);
					_tmp83_ = m;
					_tmp84_ = _tmp83_->args;
					_tmp84__length1 = _tmp83_->args_length1;
					_tmp85_ = g_strdup_printf ("%i", _tmp84__length1);
					_tmp86_ = _tmp85_;
					_tmp87_ = g_strconcat ("                      \"", _tmp82_, " wants ", _tmp86_, " parameters.\");", NULL);
					_tmp88_ = _tmp87_;
					_tmp89_ = rec_line (_tmp88_);
					_tmp90_ = _tmp89_;
					_tmp91_ = g_strconcat (_tmp79_, _tmp90_, NULL);
					_g_free0 (ret);
					ret = _tmp91_;
					_g_free0 (_tmp90_);
					_g_free0 (_tmp88_);
					_g_free0 (_tmp86_);
				}
			}
			argcount = -1;
			_tmp92_ = m;
			_tmp93_ = _tmp92_->args;
			_tmp93__length1 = _tmp92_->args_length1;
			{
				Argument** arg_collection = NULL;
				gint arg_collection_length1 = 0;
				gint _arg_collection_size_ = 0;
				gint arg_it = 0;
				arg_collection = _tmp93_;
				arg_collection_length1 = _tmp93__length1;
				for (arg_it = 0; arg_it < _tmp93__length1; arg_it = arg_it + 1) {
					Argument* _tmp94_;
					Argument* arg = NULL;
					_tmp94_ = _argument_ref0 (arg_collection[arg_it]);
					arg = _tmp94_;
					{
						gint _tmp95_;
						const gchar* _tmp96_;
						gint _tmp97_;
						gchar* _tmp98_ = NULL;
						gchar* _tmp99_;
						gint _tmp100_;
						gchar* _tmp101_ = NULL;
						gchar* _tmp102_;
						gchar* _tmp103_ = NULL;
						gchar* _tmp104_;
						gchar* _tmp105_ = NULL;
						gchar* _tmp106_;
						gchar* _tmp107_;
						gboolean _tmp108_ = FALSE;
						Argument* _tmp109_;
						const gchar* _tmp110_;
						gint _tmp111_;
						gint _tmp112_;
						gboolean _tmp121_;
						_tmp95_ = argcount;
						argcount = _tmp95_ + 1;
						_tmp96_ = ret;
						_tmp97_ = argcount;
						_tmp98_ = g_strdup_printf ("%i", _tmp97_);
						_tmp99_ = _tmp98_;
						_tmp100_ = argcount;
						_tmp101_ = g_strdup_printf ("%i", _tmp100_);
						_tmp102_ = _tmp101_;
						_tmp103_ = g_strconcat ("              ISerializable iser", _tmp99_, " = data.parameters[", _tmp102_, "];", NULL);
						_tmp104_ = _tmp103_;
						_tmp105_ = rec_line (_tmp104_);
						_tmp106_ = _tmp105_;
						_tmp107_ = g_strconcat (_tmp96_, _tmp106_, NULL);
						_g_free0 (ret);
						ret = _tmp107_;
						_g_free0 (_tmp106_);
						_g_free0 (_tmp104_);
						_g_free0 (_tmp102_);
						_g_free0 (_tmp99_);
						_tmp109_ = arg;
						_tmp110_ = _tmp109_->classname;
						_tmp111_ = strlen (_tmp110_);
						_tmp112_ = _tmp111_;
						if (_tmp112_ > 1) {
							Argument* _tmp113_;
							const gchar* _tmp114_;
							Argument* _tmp115_;
							const gchar* _tmp116_;
							gint _tmp117_;
							gint _tmp118_;
							gchar* _tmp119_ = NULL;
							gchar* _tmp120_;
							_tmp113_ = arg;
							_tmp114_ = _tmp113_->classname;
							_tmp115_ = arg;
							_tmp116_ = _tmp115_->classname;
							_tmp117_ = strlen (_tmp116_);
							_tmp118_ = _tmp117_;
							_tmp119_ = string_substring (_tmp114_, (glong) (_tmp118_ - 1), (glong) (-1));
							_tmp120_ = _tmp119_;
							_tmp108_ = g_strcmp0 (_tmp120_, "?") == 0;
							_g_free0 (_tmp120_);
						} else {
							_tmp108_ = FALSE;
						}
						_tmp121_ = _tmp108_;
						if (_tmp121_) {
							Argument* _tmp122_;
							const gchar* _tmp123_;
							Argument* _tmp124_;
							const gchar* _tmp125_;
							gint _tmp126_;
							gint _tmp127_;
							gchar* _tmp128_ = NULL;
							gchar* nullclassname;
							const gchar* _tmp129_;
							gchar** _tmp130_;
							gint _tmp130__length1;
							_tmp122_ = arg;
							_tmp123_ = _tmp122_->classname;
							_tmp124_ = arg;
							_tmp125_ = _tmp124_->classname;
							_tmp126_ = strlen (_tmp125_);
							_tmp127_ = _tmp126_;
							_tmp128_ = string_substring (_tmp123_, (glong) 0, (glong) (_tmp127_ - 1));
							nullclassname = _tmp128_;
							_tmp129_ = nullclassname;
							_tmp130_ = serializable_types;
							_tmp130__length1 = serializable_types_length1;
							if (_vala_string_array_contains (_tmp130_, _tmp130__length1, _tmp129_)) {
								const gchar* _tmp131_;
								gint _tmp132_;
								gchar* _tmp133_ = NULL;
								gchar* _tmp134_;
								const gchar* _tmp135_;
								const gchar* _tmp136_ = NULL;
								gint _tmp137_;
								gchar* _tmp138_ = NULL;
								gchar* _tmp139_;
								gchar* _tmp140_ = NULL;
								gchar* _tmp141_;
								gchar* _tmp142_ = NULL;
								gchar* _tmp143_;
								gchar* _tmp144_;
								const gchar* _tmp145_;
								gchar* _tmp146_ = NULL;
								gchar* _tmp147_;
								gchar* _tmp148_;
								const gchar* _tmp149_;
								Method* _tmp150_;
								const gchar* _tmp151_;
								const gchar* _tmp152_ = NULL;
								gint _tmp153_;
								gchar* _tmp154_ = NULL;
								gchar* _tmp155_;
								const gchar* _tmp156_;
								const gchar* _tmp157_ = NULL;
								gchar* _tmp158_ = NULL;
								gchar* _tmp159_;
								gchar* _tmp160_ = NULL;
								gchar* _tmp161_;
								gchar* _tmp162_;
								const gchar* _tmp163_;
								const gchar* _tmp164_;
								const gchar* _tmp165_ = NULL;
								Argument* _tmp166_;
								const gchar* _tmp167_;
								const gchar* _tmp168_ = NULL;
								gchar* _tmp169_ = NULL;
								gchar* _tmp170_;
								gchar* _tmp171_ = NULL;
								gchar* _tmp172_;
								gchar* _tmp173_;
								const gchar* _tmp174_;
								gint _tmp175_;
								gchar* _tmp176_ = NULL;
								gchar* _tmp177_;
								const gchar* _tmp178_;
								const gchar* _tmp179_ = NULL;
								Argument* _tmp180_;
								const gchar* _tmp181_;
								const gchar* _tmp182_ = NULL;
								const gchar* _tmp183_;
								const gchar* _tmp184_ = NULL;
								gint _tmp185_;
								gchar* _tmp186_ = NULL;
								gchar* _tmp187_;
								gchar* _tmp188_ = NULL;
								gchar* _tmp189_;
								gchar* _tmp190_ = NULL;
								gchar* _tmp191_;
								gchar* _tmp192_;
								_tmp131_ = ret;
								_tmp132_ = argcount;
								_tmp133_ = g_strdup_printf ("%i", _tmp132_);
								_tmp134_ = _tmp133_;
								_tmp135_ = nullclassname;
								_tmp136_ = string_to_string (_tmp135_);
								_tmp137_ = argcount;
								_tmp138_ = g_strdup_printf ("%i", _tmp137_);
								_tmp139_ = _tmp138_;
								_tmp140_ = g_strconcat ("                  if (! iser", _tmp134_, ".get_type().is_a(typeof(", _tmp136_, ")) && ! iser", _tmp139_, ".get_type().is_a(typeof(SerializableNone)))", NULL);
								_tmp141_ = _tmp140_;
								_tmp142_ = rec_line (_tmp141_);
								_tmp143_ = _tmp142_;
								_tmp144_ = g_strconcat (_tmp131_, _tmp143_, NULL);
								_g_free0 (ret);
								ret = _tmp144_;
								_g_free0 (_tmp143_);
								_g_free0 (_tmp141_);
								_g_free0 (_tmp139_);
								_g_free0 (_tmp134_);
								_tmp145_ = ret;
								_tmp146_ = rec_line ("                      throw new RPCError.MALFORMED_PACKET(");
								_tmp147_ = _tmp146_;
								_tmp148_ = g_strconcat (_tmp145_, _tmp147_, NULL);
								_g_free0 (ret);
								ret = _tmp148_;
								_g_free0 (_tmp147_);
								_tmp149_ = ret;
								_tmp150_ = m;
								_tmp151_ = _tmp150_->name;
								_tmp152_ = string_to_string (_tmp151_);
								_tmp153_ = argcount;
								_tmp154_ = g_strdup_printf ("%i", _tmp153_ + 1);
								_tmp155_ = _tmp154_;
								_tmp156_ = nullclassname;
								_tmp157_ = string_to_string (_tmp156_);
								_tmp158_ = g_strconcat ("                          \"", _tmp152_, " parameter ", _tmp155_, " is not a ", _tmp157_, "?.\");", NULL);
								_tmp159_ = _tmp158_;
								_tmp160_ = rec_line (_tmp159_);
								_tmp161_ = _tmp160_;
								_tmp162_ = g_strconcat (_tmp149_, _tmp161_, NULL);
								_g_free0 (ret);
								ret = _tmp162_;
								_g_free0 (_tmp161_);
								_g_free0 (_tmp159_);
								_g_free0 (_tmp155_);
								_tmp163_ = ret;
								_tmp164_ = nullclassname;
								_tmp165_ = string_to_string (_tmp164_);
								_tmp166_ = arg;
								_tmp167_ = _tmp166_->argname;
								_tmp168_ = string_to_string (_tmp167_);
								_tmp169_ = g_strconcat ("                  ", _tmp165_, "? ", _tmp168_, " = null;", NULL);
								_tmp170_ = _tmp169_;
								_tmp171_ = rec_line (_tmp170_);
								_tmp172_ = _tmp171_;
								_tmp173_ = g_strconcat (_tmp163_, _tmp172_, NULL);
								_g_free0 (ret);
								ret = _tmp173_;
								_g_free0 (_tmp172_);
								_g_free0 (_tmp170_);
								_tmp174_ = ret;
								_tmp175_ = argcount;
								_tmp176_ = g_strdup_printf ("%i", _tmp175_);
								_tmp177_ = _tmp176_;
								_tmp178_ = nullclassname;
								_tmp179_ = string_to_string (_tmp178_);
								_tmp180_ = arg;
								_tmp181_ = _tmp180_->argname;
								_tmp182_ = string_to_string (_tmp181_);
								_tmp183_ = nullclassname;
								_tmp184_ = string_to_string (_tmp183_);
								_tmp185_ = argcount;
								_tmp186_ = g_strdup_printf ("%i", _tmp185_);
								_tmp187_ = _tmp186_;
								_tmp188_ = g_strconcat ("                  if (iser", _tmp177_, ".get_type().is_a(typeof(", _tmp179_, "))) ", _tmp182_, " = (", _tmp184_, ") iser", _tmp187_, ";", NULL);
								_tmp189_ = _tmp188_;
								_tmp190_ = rec_line (_tmp189_);
								_tmp191_ = _tmp190_;
								_tmp192_ = g_strconcat (_tmp174_, _tmp191_, NULL);
								_g_free0 (ret);
								ret = _tmp192_;
								_g_free0 (_tmp191_);
								_g_free0 (_tmp189_);
								_g_free0 (_tmp187_);
								_g_free0 (_tmp177_);
							} else {
								const gchar* _tmp193_;
								_tmp193_ = nullclassname;
								if (g_strcmp0 (_tmp193_, "int") == 0) {
									const gchar* _tmp194_;
									gint _tmp195_;
									gchar* _tmp196_ = NULL;
									gchar* _tmp197_;
									gint _tmp198_;
									gchar* _tmp199_ = NULL;
									gchar* _tmp200_;
									gchar* _tmp201_ = NULL;
									gchar* _tmp202_;
									gchar* _tmp203_ = NULL;
									gchar* _tmp204_;
									gchar* _tmp205_;
									const gchar* _tmp206_;
									gchar* _tmp207_ = NULL;
									gchar* _tmp208_;
									gchar* _tmp209_;
									const gchar* _tmp210_;
									Method* _tmp211_;
									const gchar* _tmp212_;
									const gchar* _tmp213_ = NULL;
									gint _tmp214_;
									gchar* _tmp215_ = NULL;
									gchar* _tmp216_;
									gchar* _tmp217_ = NULL;
									gchar* _tmp218_;
									gchar* _tmp219_ = NULL;
									gchar* _tmp220_;
									gchar* _tmp221_;
									const gchar* _tmp222_;
									Argument* _tmp223_;
									const gchar* _tmp224_;
									const gchar* _tmp225_ = NULL;
									gchar* _tmp226_ = NULL;
									gchar* _tmp227_;
									gchar* _tmp228_ = NULL;
									gchar* _tmp229_;
									gchar* _tmp230_;
									const gchar* _tmp231_;
									gint _tmp232_;
									gchar* _tmp233_ = NULL;
									gchar* _tmp234_;
									Argument* _tmp235_;
									const gchar* _tmp236_;
									const gchar* _tmp237_ = NULL;
									gint _tmp238_;
									gchar* _tmp239_ = NULL;
									gchar* _tmp240_;
									gchar* _tmp241_ = NULL;
									gchar* _tmp242_;
									gchar* _tmp243_ = NULL;
									gchar* _tmp244_;
									gchar* _tmp245_;
									_tmp194_ = ret;
									_tmp195_ = argcount;
									_tmp196_ = g_strdup_printf ("%i", _tmp195_);
									_tmp197_ = _tmp196_;
									_tmp198_ = argcount;
									_tmp199_ = g_strdup_printf ("%i", _tmp198_);
									_tmp200_ = _tmp199_;
									_tmp201_ = g_strconcat ("                  if (! iser", _tmp197_, ".get_type().is_a(typeof(SerializableInt)) && ! iser", _tmp200_, ".get_type().is_a(typeof(SerializableNone)))", NULL);
									_tmp202_ = _tmp201_;
									_tmp203_ = rec_line (_tmp202_);
									_tmp204_ = _tmp203_;
									_tmp205_ = g_strconcat (_tmp194_, _tmp204_, NULL);
									_g_free0 (ret);
									ret = _tmp205_;
									_g_free0 (_tmp204_);
									_g_free0 (_tmp202_);
									_g_free0 (_tmp200_);
									_g_free0 (_tmp197_);
									_tmp206_ = ret;
									_tmp207_ = rec_line ("                      throw new RPCError.MALFORMED_PACKET(");
									_tmp208_ = _tmp207_;
									_tmp209_ = g_strconcat (_tmp206_, _tmp208_, NULL);
									_g_free0 (ret);
									ret = _tmp209_;
									_g_free0 (_tmp208_);
									_tmp210_ = ret;
									_tmp211_ = m;
									_tmp212_ = _tmp211_->name;
									_tmp213_ = string_to_string (_tmp212_);
									_tmp214_ = argcount;
									_tmp215_ = g_strdup_printf ("%i", _tmp214_ + 1);
									_tmp216_ = _tmp215_;
									_tmp217_ = g_strconcat ("                          \"", _tmp213_, " parameter ", _tmp216_, " is not a int?.\");", NULL);
									_tmp218_ = _tmp217_;
									_tmp219_ = rec_line (_tmp218_);
									_tmp220_ = _tmp219_;
									_tmp221_ = g_strconcat (_tmp210_, _tmp220_, NULL);
									_g_free0 (ret);
									ret = _tmp221_;
									_g_free0 (_tmp220_);
									_g_free0 (_tmp218_);
									_g_free0 (_tmp216_);
									_tmp222_ = ret;
									_tmp223_ = arg;
									_tmp224_ = _tmp223_->argname;
									_tmp225_ = string_to_string (_tmp224_);
									_tmp226_ = g_strconcat ("                  int? ", _tmp225_, " = null;", NULL);
									_tmp227_ = _tmp226_;
									_tmp228_ = rec_line (_tmp227_);
									_tmp229_ = _tmp228_;
									_tmp230_ = g_strconcat (_tmp222_, _tmp229_, NULL);
									_g_free0 (ret);
									ret = _tmp230_;
									_g_free0 (_tmp229_);
									_g_free0 (_tmp227_);
									_tmp231_ = ret;
									_tmp232_ = argcount;
									_tmp233_ = g_strdup_printf ("%i", _tmp232_);
									_tmp234_ = _tmp233_;
									_tmp235_ = arg;
									_tmp236_ = _tmp235_->argname;
									_tmp237_ = string_to_string (_tmp236_);
									_tmp238_ = argcount;
									_tmp239_ = g_strdup_printf ("%i", _tmp238_);
									_tmp240_ = _tmp239_;
									_tmp241_ = g_strconcat ("                  if (iser", _tmp234_, ".get_type().is_a(typeof(SerializableInt))) ", _tmp237_, " = ((SerializableInt) iser", _tmp240_, ").i;", NULL);
									_tmp242_ = _tmp241_;
									_tmp243_ = rec_line (_tmp242_);
									_tmp244_ = _tmp243_;
									_tmp245_ = g_strconcat (_tmp231_, _tmp244_, NULL);
									_g_free0 (ret);
									ret = _tmp245_;
									_g_free0 (_tmp244_);
									_g_free0 (_tmp242_);
									_g_free0 (_tmp240_);
									_g_free0 (_tmp234_);
								} else {
									const gchar* _tmp246_;
									_tmp246_ = nullclassname;
									if (g_strcmp0 (_tmp246_, "bool") == 0) {
										const gchar* _tmp247_;
										gint _tmp248_;
										gchar* _tmp249_ = NULL;
										gchar* _tmp250_;
										gint _tmp251_;
										gchar* _tmp252_ = NULL;
										gchar* _tmp253_;
										gchar* _tmp254_ = NULL;
										gchar* _tmp255_;
										gchar* _tmp256_ = NULL;
										gchar* _tmp257_;
										gchar* _tmp258_;
										const gchar* _tmp259_;
										gchar* _tmp260_ = NULL;
										gchar* _tmp261_;
										gchar* _tmp262_;
										const gchar* _tmp263_;
										Method* _tmp264_;
										const gchar* _tmp265_;
										const gchar* _tmp266_ = NULL;
										gint _tmp267_;
										gchar* _tmp268_ = NULL;
										gchar* _tmp269_;
										gchar* _tmp270_ = NULL;
										gchar* _tmp271_;
										gchar* _tmp272_ = NULL;
										gchar* _tmp273_;
										gchar* _tmp274_;
										const gchar* _tmp275_;
										Argument* _tmp276_;
										const gchar* _tmp277_;
										const gchar* _tmp278_ = NULL;
										gchar* _tmp279_ = NULL;
										gchar* _tmp280_;
										gchar* _tmp281_ = NULL;
										gchar* _tmp282_;
										gchar* _tmp283_;
										const gchar* _tmp284_;
										gint _tmp285_;
										gchar* _tmp286_ = NULL;
										gchar* _tmp287_;
										Argument* _tmp288_;
										const gchar* _tmp289_;
										const gchar* _tmp290_ = NULL;
										gint _tmp291_;
										gchar* _tmp292_ = NULL;
										gchar* _tmp293_;
										gchar* _tmp294_ = NULL;
										gchar* _tmp295_;
										gchar* _tmp296_ = NULL;
										gchar* _tmp297_;
										gchar* _tmp298_;
										_tmp247_ = ret;
										_tmp248_ = argcount;
										_tmp249_ = g_strdup_printf ("%i", _tmp248_);
										_tmp250_ = _tmp249_;
										_tmp251_ = argcount;
										_tmp252_ = g_strdup_printf ("%i", _tmp251_);
										_tmp253_ = _tmp252_;
										_tmp254_ = g_strconcat ("                  if (! iser", _tmp250_, ".get_type().is_a(typeof(SerializableBool)) && ! iser", _tmp253_, ".get_type().is_a(typeof(SerializableNone)))", NULL);
										_tmp255_ = _tmp254_;
										_tmp256_ = rec_line (_tmp255_);
										_tmp257_ = _tmp256_;
										_tmp258_ = g_strconcat (_tmp247_, _tmp257_, NULL);
										_g_free0 (ret);
										ret = _tmp258_;
										_g_free0 (_tmp257_);
										_g_free0 (_tmp255_);
										_g_free0 (_tmp253_);
										_g_free0 (_tmp250_);
										_tmp259_ = ret;
										_tmp260_ = rec_line ("                      throw new RPCError.MALFORMED_PACKET(");
										_tmp261_ = _tmp260_;
										_tmp262_ = g_strconcat (_tmp259_, _tmp261_, NULL);
										_g_free0 (ret);
										ret = _tmp262_;
										_g_free0 (_tmp261_);
										_tmp263_ = ret;
										_tmp264_ = m;
										_tmp265_ = _tmp264_->name;
										_tmp266_ = string_to_string (_tmp265_);
										_tmp267_ = argcount;
										_tmp268_ = g_strdup_printf ("%i", _tmp267_ + 1);
										_tmp269_ = _tmp268_;
										_tmp270_ = g_strconcat ("                          \"", _tmp266_, " parameter ", _tmp269_, " is not a bool?.\");", NULL);
										_tmp271_ = _tmp270_;
										_tmp272_ = rec_line (_tmp271_);
										_tmp273_ = _tmp272_;
										_tmp274_ = g_strconcat (_tmp263_, _tmp273_, NULL);
										_g_free0 (ret);
										ret = _tmp274_;
										_g_free0 (_tmp273_);
										_g_free0 (_tmp271_);
										_g_free0 (_tmp269_);
										_tmp275_ = ret;
										_tmp276_ = arg;
										_tmp277_ = _tmp276_->argname;
										_tmp278_ = string_to_string (_tmp277_);
										_tmp279_ = g_strconcat ("                  bool? ", _tmp278_, " = null;", NULL);
										_tmp280_ = _tmp279_;
										_tmp281_ = rec_line (_tmp280_);
										_tmp282_ = _tmp281_;
										_tmp283_ = g_strconcat (_tmp275_, _tmp282_, NULL);
										_g_free0 (ret);
										ret = _tmp283_;
										_g_free0 (_tmp282_);
										_g_free0 (_tmp280_);
										_tmp284_ = ret;
										_tmp285_ = argcount;
										_tmp286_ = g_strdup_printf ("%i", _tmp285_);
										_tmp287_ = _tmp286_;
										_tmp288_ = arg;
										_tmp289_ = _tmp288_->argname;
										_tmp290_ = string_to_string (_tmp289_);
										_tmp291_ = argcount;
										_tmp292_ = g_strdup_printf ("%i", _tmp291_);
										_tmp293_ = _tmp292_;
										_tmp294_ = g_strconcat ("                  if (iser", _tmp287_, ".get_type().is_a(typeof(SerializableBool))) ", _tmp290_, " = ((SerializableBool) iser", _tmp293_, ").b;", NULL);
										_tmp295_ = _tmp294_;
										_tmp296_ = rec_line (_tmp295_);
										_tmp297_ = _tmp296_;
										_tmp298_ = g_strconcat (_tmp284_, _tmp297_, NULL);
										_g_free0 (ret);
										ret = _tmp298_;
										_g_free0 (_tmp297_);
										_g_free0 (_tmp295_);
										_g_free0 (_tmp293_);
										_g_free0 (_tmp287_);
									} else {
										const gchar* _tmp299_;
										_tmp299_ = nullclassname;
										if (g_strcmp0 (_tmp299_, "string") == 0) {
											const gchar* _tmp300_;
											gint _tmp301_;
											gchar* _tmp302_ = NULL;
											gchar* _tmp303_;
											gint _tmp304_;
											gchar* _tmp305_ = NULL;
											gchar* _tmp306_;
											gchar* _tmp307_ = NULL;
											gchar* _tmp308_;
											gchar* _tmp309_ = NULL;
											gchar* _tmp310_;
											gchar* _tmp311_;
											const gchar* _tmp312_;
											gchar* _tmp313_ = NULL;
											gchar* _tmp314_;
											gchar* _tmp315_;
											const gchar* _tmp316_;
											Method* _tmp317_;
											const gchar* _tmp318_;
											const gchar* _tmp319_ = NULL;
											gint _tmp320_;
											gchar* _tmp321_ = NULL;
											gchar* _tmp322_;
											gchar* _tmp323_ = NULL;
											gchar* _tmp324_;
											gchar* _tmp325_ = NULL;
											gchar* _tmp326_;
											gchar* _tmp327_;
											const gchar* _tmp328_;
											Argument* _tmp329_;
											const gchar* _tmp330_;
											const gchar* _tmp331_ = NULL;
											gchar* _tmp332_ = NULL;
											gchar* _tmp333_;
											gchar* _tmp334_ = NULL;
											gchar* _tmp335_;
											gchar* _tmp336_;
											const gchar* _tmp337_;
											gint _tmp338_;
											gchar* _tmp339_ = NULL;
											gchar* _tmp340_;
											Argument* _tmp341_;
											const gchar* _tmp342_;
											const gchar* _tmp343_ = NULL;
											gint _tmp344_;
											gchar* _tmp345_ = NULL;
											gchar* _tmp346_;
											gchar* _tmp347_ = NULL;
											gchar* _tmp348_;
											gchar* _tmp349_ = NULL;
											gchar* _tmp350_;
											gchar* _tmp351_;
											_tmp300_ = ret;
											_tmp301_ = argcount;
											_tmp302_ = g_strdup_printf ("%i", _tmp301_);
											_tmp303_ = _tmp302_;
											_tmp304_ = argcount;
											_tmp305_ = g_strdup_printf ("%i", _tmp304_);
											_tmp306_ = _tmp305_;
											_tmp307_ = g_strconcat ("                  if (! iser", _tmp303_, ".get_type().is_a(typeof(SerializableString)) && ! iser", _tmp306_, ".get_type().is_a(typeof(SerializableNone)))", NULL);
											_tmp308_ = _tmp307_;
											_tmp309_ = rec_line (_tmp308_);
											_tmp310_ = _tmp309_;
											_tmp311_ = g_strconcat (_tmp300_, _tmp310_, NULL);
											_g_free0 (ret);
											ret = _tmp311_;
											_g_free0 (_tmp310_);
											_g_free0 (_tmp308_);
											_g_free0 (_tmp306_);
											_g_free0 (_tmp303_);
											_tmp312_ = ret;
											_tmp313_ = rec_line ("                      throw new RPCError.MALFORMED_PACKET(");
											_tmp314_ = _tmp313_;
											_tmp315_ = g_strconcat (_tmp312_, _tmp314_, NULL);
											_g_free0 (ret);
											ret = _tmp315_;
											_g_free0 (_tmp314_);
											_tmp316_ = ret;
											_tmp317_ = m;
											_tmp318_ = _tmp317_->name;
											_tmp319_ = string_to_string (_tmp318_);
											_tmp320_ = argcount;
											_tmp321_ = g_strdup_printf ("%i", _tmp320_ + 1);
											_tmp322_ = _tmp321_;
											_tmp323_ = g_strconcat ("                          \"", _tmp319_, " parameter ", _tmp322_, " is not a string?.\");", NULL);
											_tmp324_ = _tmp323_;
											_tmp325_ = rec_line (_tmp324_);
											_tmp326_ = _tmp325_;
											_tmp327_ = g_strconcat (_tmp316_, _tmp326_, NULL);
											_g_free0 (ret);
											ret = _tmp327_;
											_g_free0 (_tmp326_);
											_g_free0 (_tmp324_);
											_g_free0 (_tmp322_);
											_tmp328_ = ret;
											_tmp329_ = arg;
											_tmp330_ = _tmp329_->argname;
											_tmp331_ = string_to_string (_tmp330_);
											_tmp332_ = g_strconcat ("                  string? ", _tmp331_, " = null;", NULL);
											_tmp333_ = _tmp332_;
											_tmp334_ = rec_line (_tmp333_);
											_tmp335_ = _tmp334_;
											_tmp336_ = g_strconcat (_tmp328_, _tmp335_, NULL);
											_g_free0 (ret);
											ret = _tmp336_;
											_g_free0 (_tmp335_);
											_g_free0 (_tmp333_);
											_tmp337_ = ret;
											_tmp338_ = argcount;
											_tmp339_ = g_strdup_printf ("%i", _tmp338_);
											_tmp340_ = _tmp339_;
											_tmp341_ = arg;
											_tmp342_ = _tmp341_->argname;
											_tmp343_ = string_to_string (_tmp342_);
											_tmp344_ = argcount;
											_tmp345_ = g_strdup_printf ("%i", _tmp344_);
											_tmp346_ = _tmp345_;
											_tmp347_ = g_strconcat ("                  if (iser", _tmp340_, ".get_type().is_a(typeof(SerializableString))) ", _tmp343_, " = ((SerializableString) iser", _tmp346_, ").s;", NULL);
											_tmp348_ = _tmp347_;
											_tmp349_ = rec_line (_tmp348_);
											_tmp350_ = _tmp349_;
											_tmp351_ = g_strconcat (_tmp337_, _tmp350_, NULL);
											_g_free0 (ret);
											ret = _tmp351_;
											_g_free0 (_tmp350_);
											_g_free0 (_tmp348_);
											_g_free0 (_tmp346_);
											_g_free0 (_tmp340_);
										}
									}
								}
							}
							_g_free0 (nullclassname);
						} else {
							Argument* _tmp352_;
							const gchar* _tmp353_;
							_tmp352_ = arg;
							_tmp353_ = _tmp352_->classname;
							if (g_strcmp0 (_tmp353_, "ISerializable") == 0) {
								const gchar* _tmp354_;
								gint _tmp355_;
								gchar* _tmp356_ = NULL;
								gchar* _tmp357_;
								Argument* _tmp358_;
								const gchar* _tmp359_;
								const gchar* _tmp360_ = NULL;
								gchar* _tmp361_ = NULL;
								gchar* _tmp362_;
								gchar* _tmp363_ = NULL;
								gchar* _tmp364_;
								gchar* _tmp365_;
								const gchar* _tmp366_;
								gchar* _tmp367_ = NULL;
								gchar* _tmp368_;
								gchar* _tmp369_;
								const gchar* _tmp370_;
								Method* _tmp371_;
								const gchar* _tmp372_;
								const gchar* _tmp373_ = NULL;
								gint _tmp374_;
								gchar* _tmp375_ = NULL;
								gchar* _tmp376_;
								Argument* _tmp377_;
								const gchar* _tmp378_;
								const gchar* _tmp379_ = NULL;
								gchar* _tmp380_ = NULL;
								gchar* _tmp381_;
								gchar* _tmp382_ = NULL;
								gchar* _tmp383_;
								gchar* _tmp384_;
								const gchar* _tmp385_;
								Argument* _tmp386_;
								const gchar* _tmp387_;
								const gchar* _tmp388_ = NULL;
								gint _tmp389_;
								gchar* _tmp390_ = NULL;
								gchar* _tmp391_;
								gchar* _tmp392_ = NULL;
								gchar* _tmp393_;
								gchar* _tmp394_ = NULL;
								gchar* _tmp395_;
								gchar* _tmp396_;
								_tmp354_ = ret;
								_tmp355_ = argcount;
								_tmp356_ = g_strdup_printf ("%i", _tmp355_);
								_tmp357_ = _tmp356_;
								_tmp358_ = arg;
								_tmp359_ = _tmp358_->classname;
								_tmp360_ = string_to_string (_tmp359_);
								_tmp361_ = g_strconcat ("              if (! iser", _tmp357_, ".get_type().is_a(typeof(", _tmp360_, ")))", NULL);
								_tmp362_ = _tmp361_;
								_tmp363_ = rec_line (_tmp362_);
								_tmp364_ = _tmp363_;
								_tmp365_ = g_strconcat (_tmp354_, _tmp364_, NULL);
								_g_free0 (ret);
								ret = _tmp365_;
								_g_free0 (_tmp364_);
								_g_free0 (_tmp362_);
								_g_free0 (_tmp357_);
								_tmp366_ = ret;
								_tmp367_ = rec_line ("                  throw new RPCError.MALFORMED_PACKET(");
								_tmp368_ = _tmp367_;
								_tmp369_ = g_strconcat (_tmp366_, _tmp368_, NULL);
								_g_free0 (ret);
								ret = _tmp369_;
								_g_free0 (_tmp368_);
								_tmp370_ = ret;
								_tmp371_ = m;
								_tmp372_ = _tmp371_->name;
								_tmp373_ = string_to_string (_tmp372_);
								_tmp374_ = argcount;
								_tmp375_ = g_strdup_printf ("%i", _tmp374_ + 1);
								_tmp376_ = _tmp375_;
								_tmp377_ = arg;
								_tmp378_ = _tmp377_->classname;
								_tmp379_ = string_to_string (_tmp378_);
								_tmp380_ = g_strconcat ("                      \"", _tmp373_, " parameter ", _tmp376_, " is not a ", _tmp379_, ".\");", NULL);
								_tmp381_ = _tmp380_;
								_tmp382_ = rec_line (_tmp381_);
								_tmp383_ = _tmp382_;
								_tmp384_ = g_strconcat (_tmp370_, _tmp383_, NULL);
								_g_free0 (ret);
								ret = _tmp384_;
								_g_free0 (_tmp383_);
								_g_free0 (_tmp381_);
								_g_free0 (_tmp376_);
								_tmp385_ = ret;
								_tmp386_ = arg;
								_tmp387_ = _tmp386_->argname;
								_tmp388_ = string_to_string (_tmp387_);
								_tmp389_ = argcount;
								_tmp390_ = g_strdup_printf ("%i", _tmp389_);
								_tmp391_ = _tmp390_;
								_tmp392_ = g_strconcat ("              ISerializable ", _tmp388_, " = iser", _tmp391_, ";", NULL);
								_tmp393_ = _tmp392_;
								_tmp394_ = rec_line (_tmp393_);
								_tmp395_ = _tmp394_;
								_tmp396_ = g_strconcat (_tmp385_, _tmp395_, NULL);
								_g_free0 (ret);
								ret = _tmp396_;
								_g_free0 (_tmp395_);
								_g_free0 (_tmp393_);
								_g_free0 (_tmp391_);
							} else {
								Argument* _tmp397_;
								const gchar* _tmp398_;
								gchar** _tmp399_;
								gint _tmp399__length1;
								_tmp397_ = arg;
								_tmp398_ = _tmp397_->classname;
								_tmp399_ = serializable_types;
								_tmp399__length1 = serializable_types_length1;
								if (_vala_string_array_contains (_tmp399_, _tmp399__length1, _tmp398_)) {
									const gchar* _tmp400_;
									gint _tmp401_;
									gchar* _tmp402_ = NULL;
									gchar* _tmp403_;
									Argument* _tmp404_;
									const gchar* _tmp405_;
									const gchar* _tmp406_ = NULL;
									gchar* _tmp407_ = NULL;
									gchar* _tmp408_;
									gchar* _tmp409_ = NULL;
									gchar* _tmp410_;
									gchar* _tmp411_;
									const gchar* _tmp412_;
									gchar* _tmp413_ = NULL;
									gchar* _tmp414_;
									gchar* _tmp415_;
									const gchar* _tmp416_;
									Method* _tmp417_;
									const gchar* _tmp418_;
									const gchar* _tmp419_ = NULL;
									gint _tmp420_;
									gchar* _tmp421_ = NULL;
									gchar* _tmp422_;
									Argument* _tmp423_;
									const gchar* _tmp424_;
									const gchar* _tmp425_ = NULL;
									gchar* _tmp426_ = NULL;
									gchar* _tmp427_;
									gchar* _tmp428_ = NULL;
									gchar* _tmp429_;
									gchar* _tmp430_;
									const gchar* _tmp431_;
									Argument* _tmp432_;
									const gchar* _tmp433_;
									const gchar* _tmp434_ = NULL;
									Argument* _tmp435_;
									const gchar* _tmp436_;
									const gchar* _tmp437_ = NULL;
									Argument* _tmp438_;
									const gchar* _tmp439_;
									const gchar* _tmp440_ = NULL;
									gint _tmp441_;
									gchar* _tmp442_ = NULL;
									gchar* _tmp443_;
									gchar* _tmp444_ = NULL;
									gchar* _tmp445_;
									gchar* _tmp446_ = NULL;
									gchar* _tmp447_;
									gchar* _tmp448_;
									_tmp400_ = ret;
									_tmp401_ = argcount;
									_tmp402_ = g_strdup_printf ("%i", _tmp401_);
									_tmp403_ = _tmp402_;
									_tmp404_ = arg;
									_tmp405_ = _tmp404_->classname;
									_tmp406_ = string_to_string (_tmp405_);
									_tmp407_ = g_strconcat ("              if (! iser", _tmp403_, ".get_type().is_a(typeof(", _tmp406_, ")))", NULL);
									_tmp408_ = _tmp407_;
									_tmp409_ = rec_line (_tmp408_);
									_tmp410_ = _tmp409_;
									_tmp411_ = g_strconcat (_tmp400_, _tmp410_, NULL);
									_g_free0 (ret);
									ret = _tmp411_;
									_g_free0 (_tmp410_);
									_g_free0 (_tmp408_);
									_g_free0 (_tmp403_);
									_tmp412_ = ret;
									_tmp413_ = rec_line ("                  throw new RPCError.MALFORMED_PACKET(");
									_tmp414_ = _tmp413_;
									_tmp415_ = g_strconcat (_tmp412_, _tmp414_, NULL);
									_g_free0 (ret);
									ret = _tmp415_;
									_g_free0 (_tmp414_);
									_tmp416_ = ret;
									_tmp417_ = m;
									_tmp418_ = _tmp417_->name;
									_tmp419_ = string_to_string (_tmp418_);
									_tmp420_ = argcount;
									_tmp421_ = g_strdup_printf ("%i", _tmp420_ + 1);
									_tmp422_ = _tmp421_;
									_tmp423_ = arg;
									_tmp424_ = _tmp423_->classname;
									_tmp425_ = string_to_string (_tmp424_);
									_tmp426_ = g_strconcat ("                      \"", _tmp419_, " parameter ", _tmp422_, " is not a ", _tmp425_, ".\");", NULL);
									_tmp427_ = _tmp426_;
									_tmp428_ = rec_line (_tmp427_);
									_tmp429_ = _tmp428_;
									_tmp430_ = g_strconcat (_tmp416_, _tmp429_, NULL);
									_g_free0 (ret);
									ret = _tmp430_;
									_g_free0 (_tmp429_);
									_g_free0 (_tmp427_);
									_g_free0 (_tmp422_);
									_tmp431_ = ret;
									_tmp432_ = arg;
									_tmp433_ = _tmp432_->classname;
									_tmp434_ = string_to_string (_tmp433_);
									_tmp435_ = arg;
									_tmp436_ = _tmp435_->argname;
									_tmp437_ = string_to_string (_tmp436_);
									_tmp438_ = arg;
									_tmp439_ = _tmp438_->classname;
									_tmp440_ = string_to_string (_tmp439_);
									_tmp441_ = argcount;
									_tmp442_ = g_strdup_printf ("%i", _tmp441_);
									_tmp443_ = _tmp442_;
									_tmp444_ = g_strconcat ("              ", _tmp434_, " ", _tmp437_, " = (", _tmp440_, ")iser", _tmp443_, ";", NULL);
									_tmp445_ = _tmp444_;
									_tmp446_ = rec_line (_tmp445_);
									_tmp447_ = _tmp446_;
									_tmp448_ = g_strconcat (_tmp431_, _tmp447_, NULL);
									_g_free0 (ret);
									ret = _tmp448_;
									_g_free0 (_tmp447_);
									_g_free0 (_tmp445_);
									_g_free0 (_tmp443_);
								} else {
									Argument* _tmp449_;
									const gchar* _tmp450_;
									_tmp449_ = arg;
									_tmp450_ = _tmp449_->classname;
									if (g_strcmp0 (_tmp450_, "int") == 0) {
										const gchar* _tmp451_;
										gint _tmp452_;
										gchar* _tmp453_ = NULL;
										gchar* _tmp454_;
										gchar* _tmp455_ = NULL;
										gchar* _tmp456_;
										gchar* _tmp457_ = NULL;
										gchar* _tmp458_;
										gchar* _tmp459_;
										const gchar* _tmp460_;
										gchar* _tmp461_ = NULL;
										gchar* _tmp462_;
										gchar* _tmp463_;
										const gchar* _tmp464_;
										Method* _tmp465_;
										const gchar* _tmp466_;
										const gchar* _tmp467_ = NULL;
										gint _tmp468_;
										gchar* _tmp469_ = NULL;
										gchar* _tmp470_;
										gchar* _tmp471_ = NULL;
										gchar* _tmp472_;
										gchar* _tmp473_ = NULL;
										gchar* _tmp474_;
										gchar* _tmp475_;
										const gchar* _tmp476_;
										Argument* _tmp477_;
										const gchar* _tmp478_;
										const gchar* _tmp479_ = NULL;
										gint _tmp480_;
										gchar* _tmp481_ = NULL;
										gchar* _tmp482_;
										gchar* _tmp483_ = NULL;
										gchar* _tmp484_;
										gchar* _tmp485_ = NULL;
										gchar* _tmp486_;
										gchar* _tmp487_;
										_tmp451_ = ret;
										_tmp452_ = argcount;
										_tmp453_ = g_strdup_printf ("%i", _tmp452_);
										_tmp454_ = _tmp453_;
										_tmp455_ = g_strconcat ("              if (! iser", _tmp454_, ".get_type().is_a(typeof(SerializableInt)))", NULL);
										_tmp456_ = _tmp455_;
										_tmp457_ = rec_line (_tmp456_);
										_tmp458_ = _tmp457_;
										_tmp459_ = g_strconcat (_tmp451_, _tmp458_, NULL);
										_g_free0 (ret);
										ret = _tmp459_;
										_g_free0 (_tmp458_);
										_g_free0 (_tmp456_);
										_g_free0 (_tmp454_);
										_tmp460_ = ret;
										_tmp461_ = rec_line ("                  throw new RPCError.MALFORMED_PACKET(");
										_tmp462_ = _tmp461_;
										_tmp463_ = g_strconcat (_tmp460_, _tmp462_, NULL);
										_g_free0 (ret);
										ret = _tmp463_;
										_g_free0 (_tmp462_);
										_tmp464_ = ret;
										_tmp465_ = m;
										_tmp466_ = _tmp465_->name;
										_tmp467_ = string_to_string (_tmp466_);
										_tmp468_ = argcount;
										_tmp469_ = g_strdup_printf ("%i", _tmp468_ + 1);
										_tmp470_ = _tmp469_;
										_tmp471_ = g_strconcat ("                      \"", _tmp467_, " parameter ", _tmp470_, " is not a int.\");", NULL);
										_tmp472_ = _tmp471_;
										_tmp473_ = rec_line (_tmp472_);
										_tmp474_ = _tmp473_;
										_tmp475_ = g_strconcat (_tmp464_, _tmp474_, NULL);
										_g_free0 (ret);
										ret = _tmp475_;
										_g_free0 (_tmp474_);
										_g_free0 (_tmp472_);
										_g_free0 (_tmp470_);
										_tmp476_ = ret;
										_tmp477_ = arg;
										_tmp478_ = _tmp477_->argname;
										_tmp479_ = string_to_string (_tmp478_);
										_tmp480_ = argcount;
										_tmp481_ = g_strdup_printf ("%i", _tmp480_);
										_tmp482_ = _tmp481_;
										_tmp483_ = g_strconcat ("              int ", _tmp479_, " = ((SerializableInt)iser", _tmp482_, ").i;", NULL);
										_tmp484_ = _tmp483_;
										_tmp485_ = rec_line (_tmp484_);
										_tmp486_ = _tmp485_;
										_tmp487_ = g_strconcat (_tmp476_, _tmp486_, NULL);
										_g_free0 (ret);
										ret = _tmp487_;
										_g_free0 (_tmp486_);
										_g_free0 (_tmp484_);
										_g_free0 (_tmp482_);
									} else {
										Argument* _tmp488_;
										const gchar* _tmp489_;
										_tmp488_ = arg;
										_tmp489_ = _tmp488_->classname;
										if (g_strcmp0 (_tmp489_, "bool") == 0) {
											const gchar* _tmp490_;
											gint _tmp491_;
											gchar* _tmp492_ = NULL;
											gchar* _tmp493_;
											gchar* _tmp494_ = NULL;
											gchar* _tmp495_;
											gchar* _tmp496_ = NULL;
											gchar* _tmp497_;
											gchar* _tmp498_;
											const gchar* _tmp499_;
											gchar* _tmp500_ = NULL;
											gchar* _tmp501_;
											gchar* _tmp502_;
											const gchar* _tmp503_;
											Method* _tmp504_;
											const gchar* _tmp505_;
											const gchar* _tmp506_ = NULL;
											gint _tmp507_;
											gchar* _tmp508_ = NULL;
											gchar* _tmp509_;
											gchar* _tmp510_ = NULL;
											gchar* _tmp511_;
											gchar* _tmp512_ = NULL;
											gchar* _tmp513_;
											gchar* _tmp514_;
											const gchar* _tmp515_;
											Argument* _tmp516_;
											const gchar* _tmp517_;
											const gchar* _tmp518_ = NULL;
											gint _tmp519_;
											gchar* _tmp520_ = NULL;
											gchar* _tmp521_;
											gchar* _tmp522_ = NULL;
											gchar* _tmp523_;
											gchar* _tmp524_ = NULL;
											gchar* _tmp525_;
											gchar* _tmp526_;
											_tmp490_ = ret;
											_tmp491_ = argcount;
											_tmp492_ = g_strdup_printf ("%i", _tmp491_);
											_tmp493_ = _tmp492_;
											_tmp494_ = g_strconcat ("              if (! iser", _tmp493_, ".get_type().is_a(typeof(SerializableBool)))", NULL);
											_tmp495_ = _tmp494_;
											_tmp496_ = rec_line (_tmp495_);
											_tmp497_ = _tmp496_;
											_tmp498_ = g_strconcat (_tmp490_, _tmp497_, NULL);
											_g_free0 (ret);
											ret = _tmp498_;
											_g_free0 (_tmp497_);
											_g_free0 (_tmp495_);
											_g_free0 (_tmp493_);
											_tmp499_ = ret;
											_tmp500_ = rec_line ("                  throw new RPCError.MALFORMED_PACKET(");
											_tmp501_ = _tmp500_;
											_tmp502_ = g_strconcat (_tmp499_, _tmp501_, NULL);
											_g_free0 (ret);
											ret = _tmp502_;
											_g_free0 (_tmp501_);
											_tmp503_ = ret;
											_tmp504_ = m;
											_tmp505_ = _tmp504_->name;
											_tmp506_ = string_to_string (_tmp505_);
											_tmp507_ = argcount;
											_tmp508_ = g_strdup_printf ("%i", _tmp507_ + 1);
											_tmp509_ = _tmp508_;
											_tmp510_ = g_strconcat ("                      \"", _tmp506_, " parameter ", _tmp509_, " is not a bool.\");", NULL);
											_tmp511_ = _tmp510_;
											_tmp512_ = rec_line (_tmp511_);
											_tmp513_ = _tmp512_;
											_tmp514_ = g_strconcat (_tmp503_, _tmp513_, NULL);
											_g_free0 (ret);
											ret = _tmp514_;
											_g_free0 (_tmp513_);
											_g_free0 (_tmp511_);
											_g_free0 (_tmp509_);
											_tmp515_ = ret;
											_tmp516_ = arg;
											_tmp517_ = _tmp516_->argname;
											_tmp518_ = string_to_string (_tmp517_);
											_tmp519_ = argcount;
											_tmp520_ = g_strdup_printf ("%i", _tmp519_);
											_tmp521_ = _tmp520_;
											_tmp522_ = g_strconcat ("              bool ", _tmp518_, " = ((SerializableBool)iser", _tmp521_, ").b;", NULL);
											_tmp523_ = _tmp522_;
											_tmp524_ = rec_line (_tmp523_);
											_tmp525_ = _tmp524_;
											_tmp526_ = g_strconcat (_tmp515_, _tmp525_, NULL);
											_g_free0 (ret);
											ret = _tmp526_;
											_g_free0 (_tmp525_);
											_g_free0 (_tmp523_);
											_g_free0 (_tmp521_);
										} else {
											Argument* _tmp527_;
											const gchar* _tmp528_;
											_tmp527_ = arg;
											_tmp528_ = _tmp527_->classname;
											if (g_strcmp0 (_tmp528_, "string") == 0) {
												const gchar* _tmp529_;
												gint _tmp530_;
												gchar* _tmp531_ = NULL;
												gchar* _tmp532_;
												gchar* _tmp533_ = NULL;
												gchar* _tmp534_;
												gchar* _tmp535_ = NULL;
												gchar* _tmp536_;
												gchar* _tmp537_;
												const gchar* _tmp538_;
												gchar* _tmp539_ = NULL;
												gchar* _tmp540_;
												gchar* _tmp541_;
												const gchar* _tmp542_;
												Method* _tmp543_;
												const gchar* _tmp544_;
												const gchar* _tmp545_ = NULL;
												gint _tmp546_;
												gchar* _tmp547_ = NULL;
												gchar* _tmp548_;
												gchar* _tmp549_ = NULL;
												gchar* _tmp550_;
												gchar* _tmp551_ = NULL;
												gchar* _tmp552_;
												gchar* _tmp553_;
												const gchar* _tmp554_;
												Argument* _tmp555_;
												const gchar* _tmp556_;
												const gchar* _tmp557_ = NULL;
												gint _tmp558_;
												gchar* _tmp559_ = NULL;
												gchar* _tmp560_;
												gchar* _tmp561_ = NULL;
												gchar* _tmp562_;
												gchar* _tmp563_ = NULL;
												gchar* _tmp564_;
												gchar* _tmp565_;
												_tmp529_ = ret;
												_tmp530_ = argcount;
												_tmp531_ = g_strdup_printf ("%i", _tmp530_);
												_tmp532_ = _tmp531_;
												_tmp533_ = g_strconcat ("              if (! iser", _tmp532_, ".get_type().is_a(typeof(SerializableString)))", NULL);
												_tmp534_ = _tmp533_;
												_tmp535_ = rec_line (_tmp534_);
												_tmp536_ = _tmp535_;
												_tmp537_ = g_strconcat (_tmp529_, _tmp536_, NULL);
												_g_free0 (ret);
												ret = _tmp537_;
												_g_free0 (_tmp536_);
												_g_free0 (_tmp534_);
												_g_free0 (_tmp532_);
												_tmp538_ = ret;
												_tmp539_ = rec_line ("                  throw new RPCError.MALFORMED_PACKET(");
												_tmp540_ = _tmp539_;
												_tmp541_ = g_strconcat (_tmp538_, _tmp540_, NULL);
												_g_free0 (ret);
												ret = _tmp541_;
												_g_free0 (_tmp540_);
												_tmp542_ = ret;
												_tmp543_ = m;
												_tmp544_ = _tmp543_->name;
												_tmp545_ = string_to_string (_tmp544_);
												_tmp546_ = argcount;
												_tmp547_ = g_strdup_printf ("%i", _tmp546_ + 1);
												_tmp548_ = _tmp547_;
												_tmp549_ = g_strconcat ("                      \"", _tmp545_, " parameter ", _tmp548_, " is not a string.\");", NULL);
												_tmp550_ = _tmp549_;
												_tmp551_ = rec_line (_tmp550_);
												_tmp552_ = _tmp551_;
												_tmp553_ = g_strconcat (_tmp542_, _tmp552_, NULL);
												_g_free0 (ret);
												ret = _tmp553_;
												_g_free0 (_tmp552_);
												_g_free0 (_tmp550_);
												_g_free0 (_tmp548_);
												_tmp554_ = ret;
												_tmp555_ = arg;
												_tmp556_ = _tmp555_->argname;
												_tmp557_ = string_to_string (_tmp556_);
												_tmp558_ = argcount;
												_tmp559_ = g_strdup_printf ("%i", _tmp558_);
												_tmp560_ = _tmp559_;
												_tmp561_ = g_strconcat ("              string ", _tmp557_, " = ((SerializableString)iser", _tmp560_, ").s;", NULL);
												_tmp562_ = _tmp561_;
												_tmp563_ = rec_line (_tmp562_);
												_tmp564_ = _tmp563_;
												_tmp565_ = g_strconcat (_tmp554_, _tmp564_, NULL);
												_g_free0 (ret);
												ret = _tmp565_;
												_g_free0 (_tmp564_);
												_g_free0 (_tmp562_);
												_g_free0 (_tmp560_);
											} else {
												Argument* _tmp566_;
												const gchar* _tmp567_;
												_tmp566_ = arg;
												_tmp567_ = _tmp566_->classname;
												if (g_strcmp0 (_tmp567_, "Gee.List<string>") == 0) {
													const gchar* _tmp568_;
													gint _tmp569_;
													gchar* _tmp570_ = NULL;
													gchar* _tmp571_;
													gchar* _tmp572_ = NULL;
													gchar* _tmp573_;
													gchar* _tmp574_ = NULL;
													gchar* _tmp575_;
													gchar* _tmp576_;
													const gchar* _tmp577_;
													gchar* _tmp578_ = NULL;
													gchar* _tmp579_;
													gchar* _tmp580_;
													const gchar* _tmp581_;
													Method* _tmp582_;
													const gchar* _tmp583_;
													const gchar* _tmp584_ = NULL;
													gint _tmp585_;
													gchar* _tmp586_ = NULL;
													gchar* _tmp587_;
													gchar* _tmp588_ = NULL;
													gchar* _tmp589_;
													gchar* _tmp590_ = NULL;
													gchar* _tmp591_;
													gchar* _tmp592_;
													const gchar* _tmp593_;
													Argument* _tmp594_;
													const gchar* _tmp595_;
													const gchar* _tmp596_ = NULL;
													gint _tmp597_;
													gchar* _tmp598_ = NULL;
													gchar* _tmp599_;
													gchar* _tmp600_ = NULL;
													gchar* _tmp601_;
													gchar* _tmp602_ = NULL;
													gchar* _tmp603_;
													gchar* _tmp604_;
													const gchar* _tmp605_;
													Argument* _tmp606_;
													const gchar* _tmp607_;
													const gchar* _tmp608_ = NULL;
													Argument* _tmp609_;
													const gchar* _tmp610_;
													const gchar* _tmp611_ = NULL;
													gchar* _tmp612_ = NULL;
													gchar* _tmp613_;
													gchar* _tmp614_ = NULL;
													gchar* _tmp615_;
													gchar* _tmp616_;
													_tmp568_ = ret;
													_tmp569_ = argcount;
													_tmp570_ = g_strdup_printf ("%i", _tmp569_);
													_tmp571_ = _tmp570_;
													_tmp572_ = g_strconcat ("              if (! iser", _tmp571_, ".get_type().is_a(typeof(ListString)))", NULL);
													_tmp573_ = _tmp572_;
													_tmp574_ = rec_line (_tmp573_);
													_tmp575_ = _tmp574_;
													_tmp576_ = g_strconcat (_tmp568_, _tmp575_, NULL);
													_g_free0 (ret);
													ret = _tmp576_;
													_g_free0 (_tmp575_);
													_g_free0 (_tmp573_);
													_g_free0 (_tmp571_);
													_tmp577_ = ret;
													_tmp578_ = rec_line ("                  throw new RPCError.MALFORMED_PACKET(");
													_tmp579_ = _tmp578_;
													_tmp580_ = g_strconcat (_tmp577_, _tmp579_, NULL);
													_g_free0 (ret);
													ret = _tmp580_;
													_g_free0 (_tmp579_);
													_tmp581_ = ret;
													_tmp582_ = m;
													_tmp583_ = _tmp582_->name;
													_tmp584_ = string_to_string (_tmp583_);
													_tmp585_ = argcount;
													_tmp586_ = g_strdup_printf ("%i", _tmp585_ + 1);
													_tmp587_ = _tmp586_;
													_tmp588_ = g_strconcat ("                      \"", _tmp584_, " parameter ", _tmp587_, " is not a List<string>.\");", NULL);
													_tmp589_ = _tmp588_;
													_tmp590_ = rec_line (_tmp589_);
													_tmp591_ = _tmp590_;
													_tmp592_ = g_strconcat (_tmp581_, _tmp591_, NULL);
													_g_free0 (ret);
													ret = _tmp592_;
													_g_free0 (_tmp591_);
													_g_free0 (_tmp589_);
													_g_free0 (_tmp587_);
													_tmp593_ = ret;
													_tmp594_ = arg;
													_tmp595_ = _tmp594_->argname;
													_tmp596_ = string_to_string (_tmp595_);
													_tmp597_ = argcount;
													_tmp598_ = g_strdup_printf ("%i", _tmp597_);
													_tmp599_ = _tmp598_;
													_tmp600_ = g_strconcat ("              ListString _", _tmp596_, " = (ListString)iser", _tmp599_, ";", NULL);
													_tmp601_ = _tmp600_;
													_tmp602_ = rec_line (_tmp601_);
													_tmp603_ = _tmp602_;
													_tmp604_ = g_strconcat (_tmp593_, _tmp603_, NULL);
													_g_free0 (ret);
													ret = _tmp604_;
													_g_free0 (_tmp603_);
													_g_free0 (_tmp601_);
													_g_free0 (_tmp599_);
													_tmp605_ = ret;
													_tmp606_ = arg;
													_tmp607_ = _tmp606_->argname;
													_tmp608_ = string_to_string (_tmp607_);
													_tmp609_ = arg;
													_tmp610_ = _tmp609_->argname;
													_tmp611_ = string_to_string (_tmp610_);
													_tmp612_ = g_strconcat ("              Gee.List<string> ", _tmp608_, " = _", _tmp611_, ".backed;", NULL);
													_tmp613_ = _tmp612_;
													_tmp614_ = rec_line (_tmp613_);
													_tmp615_ = _tmp614_;
													_tmp616_ = g_strconcat (_tmp605_, _tmp615_, NULL);
													_g_free0 (ret);
													ret = _tmp616_;
													_g_free0 (_tmp615_);
													_g_free0 (_tmp613_);
												} else {
													gboolean _tmp617_ = FALSE;
													Argument* _tmp618_;
													const gchar* _tmp619_;
													gint _tmp620_;
													gint _tmp621_;
													gboolean _tmp626_;
													_tmp618_ = arg;
													_tmp619_ = _tmp618_->classname;
													_tmp620_ = strlen (_tmp619_);
													_tmp621_ = _tmp620_;
													if (_tmp621_ > 9) {
														Argument* _tmp622_;
														const gchar* _tmp623_;
														gchar* _tmp624_ = NULL;
														gchar* _tmp625_;
														_tmp622_ = arg;
														_tmp623_ = _tmp622_->classname;
														_tmp624_ = string_substring (_tmp623_, (glong) 0, (glong) 9);
														_tmp625_ = _tmp624_;
														_tmp617_ = g_strcmp0 (_tmp625_, "Gee.List<") == 0;
														_g_free0 (_tmp625_);
													} else {
														_tmp617_ = FALSE;
													}
													_tmp626_ = _tmp617_;
													if (_tmp626_) {
														const gchar* _tmp627_;
														gint _tmp628_;
														gchar* _tmp629_ = NULL;
														gchar* _tmp630_;
														gchar* _tmp631_ = NULL;
														gchar* _tmp632_;
														gchar* _tmp633_ = NULL;
														gchar* _tmp634_;
														gchar* _tmp635_;
														const gchar* _tmp636_;
														gchar* _tmp637_ = NULL;
														gchar* _tmp638_;
														gchar* _tmp639_;
														const gchar* _tmp640_;
														Method* _tmp641_;
														const gchar* _tmp642_;
														const gchar* _tmp643_ = NULL;
														gint _tmp644_;
														gchar* _tmp645_ = NULL;
														gchar* _tmp646_;
														gchar* _tmp647_ = NULL;
														gchar* _tmp648_;
														gchar* _tmp649_ = NULL;
														gchar* _tmp650_;
														gchar* _tmp651_;
														const gchar* _tmp652_;
														Argument* _tmp653_;
														const gchar* _tmp654_;
														const gchar* _tmp655_ = NULL;
														gint _tmp656_;
														gchar* _tmp657_ = NULL;
														gchar* _tmp658_;
														gchar* _tmp659_ = NULL;
														gchar* _tmp660_;
														gchar* _tmp661_ = NULL;
														gchar* _tmp662_;
														gchar* _tmp663_;
														const gchar* _tmp664_;
														Argument* _tmp665_;
														const gchar* _tmp666_;
														const gchar* _tmp667_ = NULL;
														Argument* _tmp668_;
														const gchar* _tmp669_;
														const gchar* _tmp670_ = NULL;
														gchar* _tmp671_ = NULL;
														gchar* _tmp672_;
														gchar* _tmp673_ = NULL;
														gchar* _tmp674_;
														gchar* _tmp675_;
														_tmp627_ = ret;
														_tmp628_ = argcount;
														_tmp629_ = g_strdup_printf ("%i", _tmp628_);
														_tmp630_ = _tmp629_;
														_tmp631_ = g_strconcat ("              if (! iser", _tmp630_, ".get_type().is_a(typeof(ListISerializable)))", NULL);
														_tmp632_ = _tmp631_;
														_tmp633_ = rec_line (_tmp632_);
														_tmp634_ = _tmp633_;
														_tmp635_ = g_strconcat (_tmp627_, _tmp634_, NULL);
														_g_free0 (ret);
														ret = _tmp635_;
														_g_free0 (_tmp634_);
														_g_free0 (_tmp632_);
														_g_free0 (_tmp630_);
														_tmp636_ = ret;
														_tmp637_ = rec_line ("                  throw new RPCError.MALFORMED_PACKET(");
														_tmp638_ = _tmp637_;
														_tmp639_ = g_strconcat (_tmp636_, _tmp638_, NULL);
														_g_free0 (ret);
														ret = _tmp639_;
														_g_free0 (_tmp638_);
														_tmp640_ = ret;
														_tmp641_ = m;
														_tmp642_ = _tmp641_->name;
														_tmp643_ = string_to_string (_tmp642_);
														_tmp644_ = argcount;
														_tmp645_ = g_strdup_printf ("%i", _tmp644_ + 1);
														_tmp646_ = _tmp645_;
														_tmp647_ = g_strconcat ("                      \"", _tmp643_, " parameter ", _tmp646_, " is not a List<NIP>.\");", NULL);
														_tmp648_ = _tmp647_;
														_tmp649_ = rec_line (_tmp648_);
														_tmp650_ = _tmp649_;
														_tmp651_ = g_strconcat (_tmp640_, _tmp650_, NULL);
														_g_free0 (ret);
														ret = _tmp651_;
														_g_free0 (_tmp650_);
														_g_free0 (_tmp648_);
														_g_free0 (_tmp646_);
														_tmp652_ = ret;
														_tmp653_ = arg;
														_tmp654_ = _tmp653_->argname;
														_tmp655_ = string_to_string (_tmp654_);
														_tmp656_ = argcount;
														_tmp657_ = g_strdup_printf ("%i", _tmp656_);
														_tmp658_ = _tmp657_;
														_tmp659_ = g_strconcat ("              ListISerializable _", _tmp655_, " = (ListISerializable)iser", _tmp658_, ";", NULL);
														_tmp660_ = _tmp659_;
														_tmp661_ = rec_line (_tmp660_);
														_tmp662_ = _tmp661_;
														_tmp663_ = g_strconcat (_tmp652_, _tmp662_, NULL);
														_g_free0 (ret);
														ret = _tmp663_;
														_g_free0 (_tmp662_);
														_g_free0 (_tmp660_);
														_g_free0 (_tmp658_);
														_tmp664_ = ret;
														_tmp665_ = arg;
														_tmp666_ = _tmp665_->argname;
														_tmp667_ = string_to_string (_tmp666_);
														_tmp668_ = arg;
														_tmp669_ = _tmp668_->argname;
														_tmp670_ = string_to_string (_tmp669_);
														_tmp671_ = g_strconcat ("              Gee.List<NIP> ", _tmp667_, " = (Gee.List<NIP>)_", _tmp670_, ".backed;", NULL);
														_tmp672_ = _tmp671_;
														_tmp673_ = rec_line (_tmp672_);
														_tmp674_ = _tmp673_;
														_tmp675_ = g_strconcat (_tmp664_, _tmp674_, NULL);
														_g_free0 (ret);
														ret = _tmp675_;
														_g_free0 (_tmp674_);
														_g_free0 (_tmp672_);
													}
												}
											}
										}
									}
								}
							}
						}
						_argument_unref0 (arg);
					}
				}
			}
			_tmp676_ = g_strdup ("");
			str_args = _tmp676_;
			_tmp677_ = g_strdup ("");
			str_args_next = _tmp677_;
			_tmp678_ = m;
			_tmp679_ = _tmp678_->args;
			_tmp679__length1 = _tmp678_->args_length1;
			{
				Argument** arg_collection = NULL;
				gint arg_collection_length1 = 0;
				gint _arg_collection_size_ = 0;
				gint arg_it = 0;
				arg_collection = _tmp679_;
				arg_collection_length1 = _tmp679__length1;
				for (arg_it = 0; arg_it < _tmp679__length1; arg_it = arg_it + 1) {
					Argument* _tmp680_;
					Argument* arg = NULL;
					_tmp680_ = _argument_ref0 (arg_collection[arg_it]);
					arg = _tmp680_;
					{
						const gchar* _tmp681_;
						const gchar* _tmp682_;
						const gchar* _tmp683_ = NULL;
						Argument* _tmp684_;
						const gchar* _tmp685_;
						const gchar* _tmp686_ = NULL;
						gchar* _tmp687_ = NULL;
						gchar* _tmp688_;
						gchar* _tmp689_;
						gchar* _tmp690_;
						_tmp681_ = str_args;
						_tmp682_ = str_args_next;
						_tmp683_ = string_to_string (_tmp682_);
						_tmp684_ = arg;
						_tmp685_ = _tmp684_->argname;
						_tmp686_ = string_to_string (_tmp685_);
						_tmp687_ = g_strconcat (_tmp683_, _tmp686_, NULL);
						_tmp688_ = _tmp687_;
						_tmp689_ = g_strconcat (_tmp681_, _tmp688_, NULL);
						_g_free0 (str_args);
						str_args = _tmp689_;
						_g_free0 (_tmp688_);
						_tmp690_ = g_strdup (", ");
						_g_free0 (str_args_next);
						str_args_next = _tmp690_;
						_argument_unref0 (arg);
					}
				}
			}
			_tmp691_ = m;
			_tmp692_ = _tmp691_->pass_caller;
			if (_tmp692_) {
				const gchar* _tmp693_;
				const gchar* _tmp694_;
				const gchar* _tmp695_ = NULL;
				gchar* _tmp696_ = NULL;
				gchar* _tmp697_;
				gchar* _tmp698_;
				_tmp693_ = str_args;
				_tmp694_ = str_args_next;
				_tmp695_ = string_to_string (_tmp694_);
				_tmp696_ = g_strconcat (_tmp695_, "(CallerInfo)caller", NULL);
				_tmp697_ = _tmp696_;
				_tmp698_ = g_strconcat (_tmp693_, _tmp697_, NULL);
				_g_free0 (str_args);
				str_args = _tmp698_;
				_g_free0 (_tmp697_);
			}
			_tmp699_ = m;
			_tmp700_ = _tmp699_->name;
			_tmp701_ = string_to_string (_tmp700_);
			_tmp702_ = str_args;
			_tmp703_ = string_to_string (_tmp702_);
			_tmp704_ = g_strconcat (_tmp701_, "(", _tmp703_, ")", NULL);
			str_command = _tmp704_;
			_tmp705_ = m;
			_tmp706_ = _tmp705_->returntype;
			if (g_strcmp0 (_tmp706_, "void") == 0) {
				const gchar* _tmp707_;
				const gchar* _tmp708_;
				const gchar* _tmp709_ = NULL;
				gchar* _tmp710_ = NULL;
				gchar* _tmp711_;
				gchar* _tmp712_ = NULL;
				gchar* _tmp713_;
				gchar* _tmp714_;
				const gchar* _tmp715_;
				gchar* _tmp716_ = NULL;
				gchar* _tmp717_;
				gchar* _tmp718_;
				_tmp707_ = ret;
				_tmp708_ = str_command;
				_tmp709_ = string_to_string (_tmp708_);
				_tmp710_ = g_strconcat ("              ", _tmp709_, ";", NULL);
				_tmp711_ = _tmp710_;
				_tmp712_ = rec_line (_tmp711_);
				_tmp713_ = _tmp712_;
				_tmp714_ = g_strconcat (_tmp707_, _tmp713_, NULL);
				_g_free0 (ret);
				ret = _tmp714_;
				_g_free0 (_tmp713_);
				_g_free0 (_tmp711_);
				_tmp715_ = ret;
				_tmp716_ = rec_line ("              return new SerializableNone();");
				_tmp717_ = _tmp716_;
				_tmp718_ = g_strconcat (_tmp715_, _tmp717_, NULL);
				_g_free0 (ret);
				ret = _tmp718_;
				_g_free0 (_tmp717_);
			} else {
				gboolean _tmp719_ = FALSE;
				Method* _tmp720_;
				const gchar* _tmp721_;
				gint _tmp722_;
				gint _tmp723_;
				gboolean _tmp732_;
				_tmp720_ = m;
				_tmp721_ = _tmp720_->returntype;
				_tmp722_ = strlen (_tmp721_);
				_tmp723_ = _tmp722_;
				if (_tmp723_ > 1) {
					Method* _tmp724_;
					const gchar* _tmp725_;
					Method* _tmp726_;
					const gchar* _tmp727_;
					gint _tmp728_;
					gint _tmp729_;
					gchar* _tmp730_ = NULL;
					gchar* _tmp731_;
					_tmp724_ = m;
					_tmp725_ = _tmp724_->returntype;
					_tmp726_ = m;
					_tmp727_ = _tmp726_->returntype;
					_tmp728_ = strlen (_tmp727_);
					_tmp729_ = _tmp728_;
					_tmp730_ = string_substring (_tmp725_, (glong) (_tmp729_ - 1), (glong) (-1));
					_tmp731_ = _tmp730_;
					_tmp719_ = g_strcmp0 (_tmp731_, "?") == 0;
					_g_free0 (_tmp731_);
				} else {
					_tmp719_ = FALSE;
				}
				_tmp732_ = _tmp719_;
				if (_tmp732_) {
					Method* _tmp733_;
					const gchar* _tmp734_;
					Method* _tmp735_;
					const gchar* _tmp736_;
					gint _tmp737_;
					gint _tmp738_;
					gchar* _tmp739_ = NULL;
					gchar* nullclassname;
					const gchar* _tmp740_;
					gchar** _tmp741_;
					gint _tmp741__length1;
					_tmp733_ = m;
					_tmp734_ = _tmp733_->returntype;
					_tmp735_ = m;
					_tmp736_ = _tmp735_->returntype;
					_tmp737_ = strlen (_tmp736_);
					_tmp738_ = _tmp737_;
					_tmp739_ = string_substring (_tmp734_, (glong) 0, (glong) (_tmp738_ - 1));
					nullclassname = _tmp739_;
					_tmp740_ = nullclassname;
					_tmp741_ = serializable_types;
					_tmp741__length1 = serializable_types_length1;
					if (_vala_string_array_contains (_tmp741_, _tmp741__length1, _tmp740_)) {
						const gchar* _tmp742_;
						const gchar* _tmp743_;
						const gchar* _tmp744_ = NULL;
						const gchar* _tmp745_;
						const gchar* _tmp746_ = NULL;
						gchar* _tmp747_ = NULL;
						gchar* _tmp748_;
						gchar* _tmp749_ = NULL;
						gchar* _tmp750_;
						gchar* _tmp751_;
						const gchar* _tmp752_;
						gchar* _tmp753_ = NULL;
						gchar* _tmp754_;
						gchar* _tmp755_;
						const gchar* _tmp756_;
						gchar* _tmp757_ = NULL;
						gchar* _tmp758_;
						gchar* _tmp759_;
						_tmp742_ = ret;
						_tmp743_ = nullclassname;
						_tmp744_ = string_to_string (_tmp743_);
						_tmp745_ = str_command;
						_tmp746_ = string_to_string (_tmp745_);
						_tmp747_ = g_strconcat ("              ", _tmp744_, "? ret = ", _tmp746_, ";", NULL);
						_tmp748_ = _tmp747_;
						_tmp749_ = rec_line (_tmp748_);
						_tmp750_ = _tmp749_;
						_tmp751_ = g_strconcat (_tmp742_, _tmp750_, NULL);
						_g_free0 (ret);
						ret = _tmp751_;
						_g_free0 (_tmp750_);
						_g_free0 (_tmp748_);
						_tmp752_ = ret;
						_tmp753_ = rec_line ("              if (ret == null) return new SerializableNone();");
						_tmp754_ = _tmp753_;
						_tmp755_ = g_strconcat (_tmp752_, _tmp754_, NULL);
						_g_free0 (ret);
						ret = _tmp755_;
						_g_free0 (_tmp754_);
						_tmp756_ = ret;
						_tmp757_ = rec_line ("              return ret;");
						_tmp758_ = _tmp757_;
						_tmp759_ = g_strconcat (_tmp756_, _tmp758_, NULL);
						_g_free0 (ret);
						ret = _tmp759_;
						_g_free0 (_tmp758_);
					} else {
						const gchar* _tmp760_;
						_tmp760_ = nullclassname;
						if (g_strcmp0 (_tmp760_, "int") == 0) {
							const gchar* _tmp761_;
							const gchar* _tmp762_;
							const gchar* _tmp763_ = NULL;
							gchar* _tmp764_ = NULL;
							gchar* _tmp765_;
							gchar* _tmp766_ = NULL;
							gchar* _tmp767_;
							gchar* _tmp768_;
							const gchar* _tmp769_;
							gchar* _tmp770_ = NULL;
							gchar* _tmp771_;
							gchar* _tmp772_;
							const gchar* _tmp773_;
							gchar* _tmp774_ = NULL;
							gchar* _tmp775_;
							gchar* _tmp776_;
							_tmp761_ = ret;
							_tmp762_ = str_command;
							_tmp763_ = string_to_string (_tmp762_);
							_tmp764_ = g_strconcat ("              int? ret = ", _tmp763_, ";", NULL);
							_tmp765_ = _tmp764_;
							_tmp766_ = rec_line (_tmp765_);
							_tmp767_ = _tmp766_;
							_tmp768_ = g_strconcat (_tmp761_, _tmp767_, NULL);
							_g_free0 (ret);
							ret = _tmp768_;
							_g_free0 (_tmp767_);
							_g_free0 (_tmp765_);
							_tmp769_ = ret;
							_tmp770_ = rec_line ("              if (ret == null) return new SerializableNone();");
							_tmp771_ = _tmp770_;
							_tmp772_ = g_strconcat (_tmp769_, _tmp771_, NULL);
							_g_free0 (ret);
							ret = _tmp772_;
							_g_free0 (_tmp771_);
							_tmp773_ = ret;
							_tmp774_ = rec_line ("              return new SerializableInt(ret);");
							_tmp775_ = _tmp774_;
							_tmp776_ = g_strconcat (_tmp773_, _tmp775_, NULL);
							_g_free0 (ret);
							ret = _tmp776_;
							_g_free0 (_tmp775_);
						} else {
							const gchar* _tmp777_;
							_tmp777_ = nullclassname;
							if (g_strcmp0 (_tmp777_, "bool") == 0) {
								const gchar* _tmp778_;
								const gchar* _tmp779_;
								const gchar* _tmp780_ = NULL;
								gchar* _tmp781_ = NULL;
								gchar* _tmp782_;
								gchar* _tmp783_ = NULL;
								gchar* _tmp784_;
								gchar* _tmp785_;
								const gchar* _tmp786_;
								gchar* _tmp787_ = NULL;
								gchar* _tmp788_;
								gchar* _tmp789_;
								const gchar* _tmp790_;
								gchar* _tmp791_ = NULL;
								gchar* _tmp792_;
								gchar* _tmp793_;
								_tmp778_ = ret;
								_tmp779_ = str_command;
								_tmp780_ = string_to_string (_tmp779_);
								_tmp781_ = g_strconcat ("              bool? ret = ", _tmp780_, ";", NULL);
								_tmp782_ = _tmp781_;
								_tmp783_ = rec_line (_tmp782_);
								_tmp784_ = _tmp783_;
								_tmp785_ = g_strconcat (_tmp778_, _tmp784_, NULL);
								_g_free0 (ret);
								ret = _tmp785_;
								_g_free0 (_tmp784_);
								_g_free0 (_tmp782_);
								_tmp786_ = ret;
								_tmp787_ = rec_line ("              if (ret == null) return new SerializableNone();");
								_tmp788_ = _tmp787_;
								_tmp789_ = g_strconcat (_tmp786_, _tmp788_, NULL);
								_g_free0 (ret);
								ret = _tmp789_;
								_g_free0 (_tmp788_);
								_tmp790_ = ret;
								_tmp791_ = rec_line ("              return new SerializableBool(ret);");
								_tmp792_ = _tmp791_;
								_tmp793_ = g_strconcat (_tmp790_, _tmp792_, NULL);
								_g_free0 (ret);
								ret = _tmp793_;
								_g_free0 (_tmp792_);
							} else {
								const gchar* _tmp794_;
								_tmp794_ = nullclassname;
								if (g_strcmp0 (_tmp794_, "string") == 0) {
									const gchar* _tmp795_;
									const gchar* _tmp796_;
									const gchar* _tmp797_ = NULL;
									gchar* _tmp798_ = NULL;
									gchar* _tmp799_;
									gchar* _tmp800_ = NULL;
									gchar* _tmp801_;
									gchar* _tmp802_;
									const gchar* _tmp803_;
									gchar* _tmp804_ = NULL;
									gchar* _tmp805_;
									gchar* _tmp806_;
									const gchar* _tmp807_;
									gchar* _tmp808_ = NULL;
									gchar* _tmp809_;
									gchar* _tmp810_;
									_tmp795_ = ret;
									_tmp796_ = str_command;
									_tmp797_ = string_to_string (_tmp796_);
									_tmp798_ = g_strconcat ("              string? ret = ", _tmp797_, ";", NULL);
									_tmp799_ = _tmp798_;
									_tmp800_ = rec_line (_tmp799_);
									_tmp801_ = _tmp800_;
									_tmp802_ = g_strconcat (_tmp795_, _tmp801_, NULL);
									_g_free0 (ret);
									ret = _tmp802_;
									_g_free0 (_tmp801_);
									_g_free0 (_tmp799_);
									_tmp803_ = ret;
									_tmp804_ = rec_line ("              if (ret == null) return new SerializableNone();");
									_tmp805_ = _tmp804_;
									_tmp806_ = g_strconcat (_tmp803_, _tmp805_, NULL);
									_g_free0 (ret);
									ret = _tmp806_;
									_g_free0 (_tmp805_);
									_tmp807_ = ret;
									_tmp808_ = rec_line ("              return new SerializableString(ret);");
									_tmp809_ = _tmp808_;
									_tmp810_ = g_strconcat (_tmp807_, _tmp809_, NULL);
									_g_free0 (ret);
									ret = _tmp810_;
									_g_free0 (_tmp809_);
								}
							}
						}
					}
					_g_free0 (nullclassname);
				} else {
					Method* _tmp811_;
					const gchar* _tmp812_;
					_tmp811_ = m;
					_tmp812_ = _tmp811_->returntype;
					if (g_strcmp0 (_tmp812_, "ISerializable") == 0) {
						const gchar* _tmp813_;
						const gchar* _tmp814_;
						const gchar* _tmp815_ = NULL;
						gchar* _tmp816_ = NULL;
						gchar* _tmp817_;
						gchar* _tmp818_ = NULL;
						gchar* _tmp819_;
						gchar* _tmp820_;
						_tmp813_ = ret;
						_tmp814_ = str_command;
						_tmp815_ = string_to_string (_tmp814_);
						_tmp816_ = g_strconcat ("              return ", _tmp815_, ";", NULL);
						_tmp817_ = _tmp816_;
						_tmp818_ = rec_line (_tmp817_);
						_tmp819_ = _tmp818_;
						_tmp820_ = g_strconcat (_tmp813_, _tmp819_, NULL);
						_g_free0 (ret);
						ret = _tmp820_;
						_g_free0 (_tmp819_);
						_g_free0 (_tmp817_);
					} else {
						Method* _tmp821_;
						const gchar* _tmp822_;
						gchar** _tmp823_;
						gint _tmp823__length1;
						_tmp821_ = m;
						_tmp822_ = _tmp821_->returntype;
						_tmp823_ = serializable_types;
						_tmp823__length1 = serializable_types_length1;
						if (_vala_string_array_contains (_tmp823_, _tmp823__length1, _tmp822_)) {
							const gchar* _tmp824_;
							const gchar* _tmp825_;
							const gchar* _tmp826_ = NULL;
							gchar* _tmp827_ = NULL;
							gchar* _tmp828_;
							gchar* _tmp829_ = NULL;
							gchar* _tmp830_;
							gchar* _tmp831_;
							_tmp824_ = ret;
							_tmp825_ = str_command;
							_tmp826_ = string_to_string (_tmp825_);
							_tmp827_ = g_strconcat ("              return ", _tmp826_, ";", NULL);
							_tmp828_ = _tmp827_;
							_tmp829_ = rec_line (_tmp828_);
							_tmp830_ = _tmp829_;
							_tmp831_ = g_strconcat (_tmp824_, _tmp830_, NULL);
							_g_free0 (ret);
							ret = _tmp831_;
							_g_free0 (_tmp830_);
							_g_free0 (_tmp828_);
						} else {
							Method* _tmp832_;
							const gchar* _tmp833_;
							_tmp832_ = m;
							_tmp833_ = _tmp832_->returntype;
							if (g_strcmp0 (_tmp833_, "int") == 0) {
								const gchar* _tmp834_;
								const gchar* _tmp835_;
								const gchar* _tmp836_ = NULL;
								gchar* _tmp837_ = NULL;
								gchar* _tmp838_;
								gchar* _tmp839_ = NULL;
								gchar* _tmp840_;
								gchar* _tmp841_;
								_tmp834_ = ret;
								_tmp835_ = str_command;
								_tmp836_ = string_to_string (_tmp835_);
								_tmp837_ = g_strconcat ("              return new SerializableInt(", _tmp836_, ");", NULL);
								_tmp838_ = _tmp837_;
								_tmp839_ = rec_line (_tmp838_);
								_tmp840_ = _tmp839_;
								_tmp841_ = g_strconcat (_tmp834_, _tmp840_, NULL);
								_g_free0 (ret);
								ret = _tmp841_;
								_g_free0 (_tmp840_);
								_g_free0 (_tmp838_);
							} else {
								Method* _tmp842_;
								const gchar* _tmp843_;
								_tmp842_ = m;
								_tmp843_ = _tmp842_->returntype;
								if (g_strcmp0 (_tmp843_, "bool") == 0) {
									const gchar* _tmp844_;
									const gchar* _tmp845_;
									const gchar* _tmp846_ = NULL;
									gchar* _tmp847_ = NULL;
									gchar* _tmp848_;
									gchar* _tmp849_ = NULL;
									gchar* _tmp850_;
									gchar* _tmp851_;
									_tmp844_ = ret;
									_tmp845_ = str_command;
									_tmp846_ = string_to_string (_tmp845_);
									_tmp847_ = g_strconcat ("              return new SerializableBool(", _tmp846_, ");", NULL);
									_tmp848_ = _tmp847_;
									_tmp849_ = rec_line (_tmp848_);
									_tmp850_ = _tmp849_;
									_tmp851_ = g_strconcat (_tmp844_, _tmp850_, NULL);
									_g_free0 (ret);
									ret = _tmp851_;
									_g_free0 (_tmp850_);
									_g_free0 (_tmp848_);
								} else {
									Method* _tmp852_;
									const gchar* _tmp853_;
									_tmp852_ = m;
									_tmp853_ = _tmp852_->returntype;
									if (g_strcmp0 (_tmp853_, "string") == 0) {
										const gchar* _tmp854_;
										const gchar* _tmp855_;
										const gchar* _tmp856_ = NULL;
										gchar* _tmp857_ = NULL;
										gchar* _tmp858_;
										gchar* _tmp859_ = NULL;
										gchar* _tmp860_;
										gchar* _tmp861_;
										_tmp854_ = ret;
										_tmp855_ = str_command;
										_tmp856_ = string_to_string (_tmp855_);
										_tmp857_ = g_strconcat ("              return new SerializableString(", _tmp856_, ");", NULL);
										_tmp858_ = _tmp857_;
										_tmp859_ = rec_line (_tmp858_);
										_tmp860_ = _tmp859_;
										_tmp861_ = g_strconcat (_tmp854_, _tmp860_, NULL);
										_g_free0 (ret);
										ret = _tmp861_;
										_g_free0 (_tmp860_);
										_g_free0 (_tmp858_);
									} else {
										Method* _tmp862_;
										const gchar* _tmp863_;
										_tmp862_ = m;
										_tmp863_ = _tmp862_->returntype;
										if (g_strcmp0 (_tmp863_, "Gee.List<string>") == 0) {
											const gchar* _tmp864_;
											const gchar* _tmp865_;
											const gchar* _tmp866_ = NULL;
											gchar* _tmp867_ = NULL;
											gchar* _tmp868_;
											gchar* _tmp869_ = NULL;
											gchar* _tmp870_;
											gchar* _tmp871_;
											const gchar* _tmp872_;
											gchar* _tmp873_ = NULL;
											gchar* _tmp874_;
											gchar* _tmp875_;
											_tmp864_ = ret;
											_tmp865_ = str_command;
											_tmp866_ = string_to_string (_tmp865_);
											_tmp867_ = g_strconcat ("              Gee.List<string> _ret = ", _tmp866_, ";", NULL);
											_tmp868_ = _tmp867_;
											_tmp869_ = rec_line (_tmp868_);
											_tmp870_ = _tmp869_;
											_tmp871_ = g_strconcat (_tmp864_, _tmp870_, NULL);
											_g_free0 (ret);
											ret = _tmp871_;
											_g_free0 (_tmp870_);
											_g_free0 (_tmp868_);
											_tmp872_ = ret;
											_tmp873_ = rec_block ("\n" \
"                ListString ret = new ListString.with_backer(_ret);\n" \
"                return ret;\n");
											_tmp874_ = _tmp873_;
											_tmp875_ = g_strconcat (_tmp872_, _tmp874_, NULL);
											_g_free0 (ret);
											ret = _tmp875_;
											_g_free0 (_tmp874_);
										} else {
											gboolean _tmp876_ = FALSE;
											Method* _tmp877_;
											const gchar* _tmp878_;
											gint _tmp879_;
											gint _tmp880_;
											gboolean _tmp885_;
											_tmp877_ = m;
											_tmp878_ = _tmp877_->returntype;
											_tmp879_ = strlen (_tmp878_);
											_tmp880_ = _tmp879_;
											if (_tmp880_ > 9) {
												Method* _tmp881_;
												const gchar* _tmp882_;
												gchar* _tmp883_ = NULL;
												gchar* _tmp884_;
												_tmp881_ = m;
												_tmp882_ = _tmp881_->returntype;
												_tmp883_ = string_substring (_tmp882_, (glong) 0, (glong) 9);
												_tmp884_ = _tmp883_;
												_tmp876_ = g_strcmp0 (_tmp884_, "Gee.List<") == 0;
												_g_free0 (_tmp884_);
											} else {
												_tmp876_ = FALSE;
											}
											_tmp885_ = _tmp876_;
											if (_tmp885_) {
												Method* _tmp886_;
												const gchar* _tmp887_;
												Method* _tmp888_;
												const gchar* _tmp889_;
												gint _tmp890_;
												gint _tmp891_;
												gchar* _tmp892_ = NULL;
												gchar* listof;
												const gchar* _tmp893_;
												const gchar* _tmp894_;
												const gchar* _tmp895_ = NULL;
												const gchar* _tmp896_;
												const gchar* _tmp897_ = NULL;
												gchar* _tmp898_ = NULL;
												gchar* _tmp899_;
												gchar* _tmp900_ = NULL;
												gchar* _tmp901_;
												gchar* _tmp902_;
												const gchar* _tmp903_;
												gchar* _tmp904_ = NULL;
												gchar* _tmp905_;
												gchar* _tmp906_;
												_tmp886_ = m;
												_tmp887_ = _tmp886_->returntype;
												_tmp888_ = m;
												_tmp889_ = _tmp888_->returntype;
												_tmp890_ = strlen (_tmp889_);
												_tmp891_ = _tmp890_;
												_tmp892_ = string_substring (_tmp887_, (glong) 9, (glong) (_tmp891_ - 10));
												listof = _tmp892_;
												_tmp893_ = ret;
												_tmp894_ = listof;
												_tmp895_ = string_to_string (_tmp894_);
												_tmp896_ = str_command;
												_tmp897_ = string_to_string (_tmp896_);
												_tmp898_ = g_strconcat ("              Gee.List<", _tmp895_, "> _ret = ", _tmp897_, ";", NULL);
												_tmp899_ = _tmp898_;
												_tmp900_ = rec_line (_tmp899_);
												_tmp901_ = _tmp900_;
												_tmp902_ = g_strconcat (_tmp893_, _tmp901_, NULL);
												_g_free0 (ret);
												ret = _tmp902_;
												_g_free0 (_tmp901_);
												_g_free0 (_tmp899_);
												_tmp903_ = ret;
												_tmp904_ = rec_block ("\n" \
"                ListISerializable ret = new ListISerializable.with_bac" \
"ker(_ret);\n" \
"                return ret;\n");
												_tmp905_ = _tmp904_;
												_tmp906_ = g_strconcat (_tmp903_, _tmp905_, NULL);
												_g_free0 (ret);
												ret = _tmp906_;
												_g_free0 (_tmp905_);
												_g_free0 (listof);
											}
										}
									}
								}
							}
						}
					}
				}
			}
			_tmp907_ = ret;
			_tmp908_ = rec_block ("\n            }\n");
			_tmp909_ = _tmp908_;
			_tmp910_ = g_strconcat (_tmp907_, _tmp909_, NULL);
			_g_free0 (ret);
			ret = _tmp910_;
			_g_free0 (_tmp909_);
			_g_free0 (str_command);
			_g_free0 (str_args_next);
			_g_free0 (str_args);
			_method_unref0 (m);
		}
		_g_object_unref0 (_m_list);
	}
	result = ret;
	return result;
}


gchar* rec_block (const gchar* m) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (m != NULL, NULL);
	_tmp0_ = m;
	_tmp1_ = string_substring (_tmp0_, (glong) 1, (glong) (-1));
	result = _tmp1_;
	return result;
}


gchar* rec_line (const gchar* m) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_val_if_fail (m != NULL, NULL);
	_tmp0_ = m;
	_tmp1_ = g_strconcat ("  ", _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, "\n", NULL);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	result = _tmp4_;
	return result;
}


gchar* indentlines (gchar* x, const gchar* prefix) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	gboolean _tmp11_;
	gboolean finaleol;
	gboolean _tmp12_;
	GRegex* _tmp18_;
	GRegex* regex;
	GRegex* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	const gchar* _tmp24_;
	gchar* _tmp25_ = NULL;
	gchar* _tmp26_;
	GRegex* _tmp27_;
	GRegex* regex1;
	GRegex* _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	gint _tmp31_;
	gint _tmp32_;
	const gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_ = NULL;
	gchar* _tmp37_;
	gchar* _tmp38_;
	gboolean _tmp39_;
	const gchar* _tmp42_;
	gchar* _tmp43_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (x != NULL, NULL);
	g_return_val_if_fail (prefix != NULL, NULL);
	_tmp0_ = x;
	_tmp1_ = strlen (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = x;
		_tmp4_ = g_strdup (_tmp3_);
		result = _tmp4_;
		_g_free0 (x);
		return result;
	}
	_tmp5_ = x;
	_tmp6_ = x;
	_tmp7_ = strlen (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = string_substring (_tmp5_, (glong) (_tmp8_ - 1), (glong) (-1));
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strcmp0 (_tmp10_, "\n") == 0;
	_g_free0 (_tmp10_);
	finaleol = _tmp11_;
	_tmp12_ = finaleol;
	if (_tmp12_) {
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gchar* _tmp17_ = NULL;
		_tmp13_ = x;
		_tmp14_ = x;
		_tmp15_ = strlen (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = string_substring (_tmp13_, (glong) 0, (glong) (_tmp16_ - 1));
		_g_free0 (x);
		x = _tmp17_;
	}
	_tmp18_ = g_regex_new ("^", 0, 0, &_inner_error_);
	regex = _tmp18_;
	if (_inner_error_ != NULL) {
		_g_free0 (x);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp19_ = regex;
	_tmp20_ = x;
	_tmp21_ = x;
	_tmp22_ = strlen (_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = prefix;
	_tmp25_ = g_regex_replace (_tmp19_, _tmp20_, (gssize) _tmp23_, 0, _tmp24_, 0, &_inner_error_);
	_tmp26_ = _tmp25_;
	if (_inner_error_ != NULL) {
		_g_regex_unref0 (regex);
		_g_free0 (x);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_free0 (x);
	x = _tmp26_;
	_tmp27_ = g_regex_new ("\n", 0, 0, &_inner_error_);
	regex1 = _tmp27_;
	if (_inner_error_ != NULL) {
		_g_regex_unref0 (regex);
		_g_free0 (x);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp28_ = regex1;
	_tmp29_ = x;
	_tmp30_ = x;
	_tmp31_ = strlen (_tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = prefix;
	_tmp34_ = g_strconcat ("\n", _tmp33_, NULL);
	_tmp35_ = _tmp34_;
	_tmp36_ = g_regex_replace (_tmp28_, _tmp29_, (gssize) _tmp32_, 0, _tmp35_, 0, &_inner_error_);
	_tmp37_ = _tmp36_;
	_g_free0 (_tmp35_);
	_tmp38_ = _tmp37_;
	if (_inner_error_ != NULL) {
		_g_regex_unref0 (regex1);
		_g_regex_unref0 (regex);
		_g_free0 (x);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_free0 (x);
	x = _tmp38_;
	_tmp39_ = finaleol;
	if (_tmp39_) {
		const gchar* _tmp40_;
		gchar* _tmp41_;
		_tmp40_ = x;
		_tmp41_ = g_strconcat (_tmp40_, "\n", NULL);
		_g_free0 (x);
		x = _tmp41_;
	}
	_tmp42_ = x;
	_tmp43_ = g_strdup (_tmp42_);
	result = _tmp43_;
	_g_regex_unref0 (regex1);
	_g_regex_unref0 (regex);
	_g_free0 (x);
	return result;
}


void wr_block (const gchar* m) {
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	g_return_if_fail (m != NULL);
	_tmp0_ = m;
	_tmp1_ = string_substring (_tmp0_, (glong) 1, (glong) (-1));
	_tmp2_ = _tmp1_;
	wr (_tmp2_);
	_g_free0 (_tmp2_);
}


void wr_line (const gchar* m) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (m != NULL);
	_tmp0_ = m;
	_tmp1_ = g_strconcat ("  ", _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, "\n", NULL);
	_tmp4_ = _tmp3_;
	wr (_tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
}


void wr (const gchar* m) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (m != NULL);
	_tmp0_ = output;
	_tmp1_ = m;
	_tmp2_ = g_strconcat (_tmp0_, _tmp1_, NULL);
	_g_free0 (output);
	output = _tmp2_;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



