/*
 *  This file is part of Netsukuku.
 *  (c) Copyright 2011 Luca Dionisi aka lukisi <luca.dionisi@gmail.com>
 *
 *  Netsukuku is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Netsukuku is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Netsukuku.  If not, see <http://www.gnu.org/licenses/>.
 */

using Gee;
using zcd;
using Tasklets;

namespace Netsukuku
{
    /** The collection of NetworkInterfaceManagers handled by this node.
      */
    public class NetworkInterfaces : Object
    {
        private HashMap<string, NetworkInterfaceManager> _nics_by_nic_name;
        public GlueNetworkInterfaceManager glue_nic {get; private set;}
        public NetworkInterfaces()
        {
            _nics_by_nic_name = new HashMap<string, NetworkInterfaceManager>();
            glue_nic = new GlueNetworkInterfaceManager();
        }

        public NetworkInterfaceManager add(string nic_name, NIC nic_class,
                UnicastCallbackDelegate? udp_unicast_callback=null,
                BroadcastCallbackDelegate? udp_broadcast_callback=null)
        {
            // A new NIC is managed
            NetworkInterfaceManager nic_man = new NetworkInterfaceManager(nic_name, nic_class, udp_unicast_callback, udp_broadcast_callback);
            // Add the instance to my list
            _nics_by_nic_name[nic_name] = nic_man;
            return nic_man;
        }

        public void remove(NetworkInterfaceManager nic_man)
        {
            // We cease to manage an NIC
            _nics_by_nic_name.unset(nic_man.nic_name);
        }

        public Iterator<NetworkInterfaceManager> iterator()
        {
            return _nics_by_nic_name.values.iterator();
        }
    }
}
