/* network_linux.c generated by valac 0.20.1, the Vala compiler
 * generated from network_linux.vala, do not modify */

/*
 *  This file is part of Netsukuku.
 *  (c) Copyright 2011 Luca Dionisi aka lukisi <luca.dionisi@gmail.com>
 *
 *  Netsukuku is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Netsukuku is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Netsukuku.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <tasklet.h>
#include <glib/gstdio.h>
#include <stdio.h>
#include <errno.h>
#include <gee.h>
#include <gio/gio.h>
#include <zcd.h>
#include <netsukuku-rpc.h>
#include <math.h>
#include <float.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define NETSUKUKU_IMPL_LINUX_TYPE_STRUCT_HELPER_NTK_LINUX_SEQUENTIAL_COMMAND (netsukuku_impl_linux_struct_helper_ntk_linux_sequential_command_get_type ())
typedef struct _NetsukukuImplLinuxstruct_helper_ntk_linux_sequential_command NetsukukuImplLinuxstruct_helper_ntk_linux_sequential_command;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))

#define NETSUKUKU_TYPE_NIC (netsukuku_nic_get_type ())
#define NETSUKUKU_NIC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_NIC, NetsukukuNIC))
#define NETSUKUKU_NIC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_NIC, NetsukukuNICClass))
#define NETSUKUKU_IS_NIC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_NIC))
#define NETSUKUKU_IS_NIC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_NIC))
#define NETSUKUKU_NIC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_NIC, NetsukukuNICClass))

typedef struct _NetsukukuNIC NetsukukuNIC;
typedef struct _NetsukukuNICClass NetsukukuNICClass;
typedef struct _NetsukukuNICPrivate NetsukukuNICPrivate;

#define NETSUKUKU_IMPL_LINUX_TYPE_LINUX_NIC (netsukuku_impl_linux_linux_nic_get_type ())
#define NETSUKUKU_IMPL_LINUX_LINUX_NIC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_IMPL_LINUX_TYPE_LINUX_NIC, NetsukukuImplLinuxLinuxNIC))
#define NETSUKUKU_IMPL_LINUX_LINUX_NIC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_IMPL_LINUX_TYPE_LINUX_NIC, NetsukukuImplLinuxLinuxNICClass))
#define NETSUKUKU_IMPL_LINUX_IS_LINUX_NIC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_IMPL_LINUX_TYPE_LINUX_NIC))
#define NETSUKUKU_IMPL_LINUX_IS_LINUX_NIC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_IMPL_LINUX_TYPE_LINUX_NIC))
#define NETSUKUKU_IMPL_LINUX_LINUX_NIC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_IMPL_LINUX_TYPE_LINUX_NIC, NetsukukuImplLinuxLinuxNICClass))

typedef struct _NetsukukuImplLinuxLinuxNIC NetsukukuImplLinuxLinuxNIC;
typedef struct _NetsukukuImplLinuxLinuxNICClass NetsukukuImplLinuxLinuxNICClass;
typedef struct _NetsukukuImplLinuxLinuxNICPrivate NetsukukuImplLinuxLinuxNICPrivate;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_match_info_free0(var) ((var == NULL) ? NULL : (var = (g_match_info_free (var), NULL)))

#define NETSUKUKU_IMPL_LINUX_TYPE_STRUCT_HELPER_LINUXROUTE_ACTIVATE_MULTIPATH (netsukuku_impl_linux_struct_helper_linuxroute_activate_multipath_get_type ())

#define NETSUKUKU_TYPE_ROUTE_SETTER (netsukuku_route_setter_get_type ())
#define NETSUKUKU_ROUTE_SETTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_ROUTE_SETTER, NetsukukuRouteSetter))
#define NETSUKUKU_ROUTE_SETTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_ROUTE_SETTER, NetsukukuRouteSetterClass))
#define NETSUKUKU_IS_ROUTE_SETTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_ROUTE_SETTER))
#define NETSUKUKU_IS_ROUTE_SETTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_ROUTE_SETTER))
#define NETSUKUKU_ROUTE_SETTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_ROUTE_SETTER, NetsukukuRouteSetterClass))

typedef struct _NetsukukuRouteSetter NetsukukuRouteSetter;
typedef struct _NetsukukuRouteSetterClass NetsukukuRouteSetterClass;

#define NETSUKUKU_IMPL_LINUX_TYPE_LINUX_ROUTE (netsukuku_impl_linux_linux_route_get_type ())
#define NETSUKUKU_IMPL_LINUX_LINUX_ROUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_IMPL_LINUX_TYPE_LINUX_ROUTE, NetsukukuImplLinuxLinuxRoute))
#define NETSUKUKU_IMPL_LINUX_LINUX_ROUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_IMPL_LINUX_TYPE_LINUX_ROUTE, NetsukukuImplLinuxLinuxRouteClass))
#define NETSUKUKU_IMPL_LINUX_IS_LINUX_ROUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_IMPL_LINUX_TYPE_LINUX_ROUTE))
#define NETSUKUKU_IMPL_LINUX_IS_LINUX_ROUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_IMPL_LINUX_TYPE_LINUX_ROUTE))
#define NETSUKUKU_IMPL_LINUX_LINUX_ROUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_IMPL_LINUX_TYPE_LINUX_ROUTE, NetsukukuImplLinuxLinuxRouteClass))

typedef struct _NetsukukuImplLinuxLinuxRoute NetsukukuImplLinuxLinuxRoute;
typedef struct _NetsukukuImplLinuxLinuxRouteClass NetsukukuImplLinuxLinuxRouteClass;
typedef struct _NetsukukuImplLinuxstruct_helper_LinuxRoute_activate_multipath NetsukukuImplLinuxstruct_helper_LinuxRoute_activate_multipath;
typedef struct _NetsukukuRouteSetterPrivate NetsukukuRouteSetterPrivate;

#define NETSUKUKU_TYPE_BASE_ROUTE_SOLUTIONS (netsukuku_base_route_solutions_get_type ())
#define NETSUKUKU_BASE_ROUTE_SOLUTIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_BASE_ROUTE_SOLUTIONS, NetsukukuBaseRouteSolutions))
#define NETSUKUKU_BASE_ROUTE_SOLUTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_BASE_ROUTE_SOLUTIONS, NetsukukuBaseRouteSolutionsClass))
#define NETSUKUKU_IS_BASE_ROUTE_SOLUTIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_BASE_ROUTE_SOLUTIONS))
#define NETSUKUKU_IS_BASE_ROUTE_SOLUTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_BASE_ROUTE_SOLUTIONS))
#define NETSUKUKU_BASE_ROUTE_SOLUTIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_BASE_ROUTE_SOLUTIONS, NetsukukuBaseRouteSolutionsClass))

typedef struct _NetsukukuBaseRouteSolutions NetsukukuBaseRouteSolutions;
typedef struct _NetsukukuBaseRouteSolutionsClass NetsukukuBaseRouteSolutionsClass;

#define NETSUKUKU_TYPE_ROUTE_SOLUTIONS (netsukuku_route_solutions_get_type ())
#define NETSUKUKU_ROUTE_SOLUTIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_ROUTE_SOLUTIONS, NetsukukuRouteSolutions))
#define NETSUKUKU_ROUTE_SOLUTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_ROUTE_SOLUTIONS, NetsukukuRouteSolutionsClass))
#define NETSUKUKU_IS_ROUTE_SOLUTIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_ROUTE_SOLUTIONS))
#define NETSUKUKU_IS_ROUTE_SOLUTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_ROUTE_SOLUTIONS))
#define NETSUKUKU_ROUTE_SOLUTIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_ROUTE_SOLUTIONS, NetsukukuRouteSolutionsClass))

typedef struct _NetsukukuRouteSolutions NetsukukuRouteSolutions;
typedef struct _NetsukukuRouteSolutionsClass NetsukukuRouteSolutionsClass;

#define NETSUKUKU_TYPE_TUNNEL_ITEM (netsukuku_tunnel_item_get_type ())
#define NETSUKUKU_TUNNEL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_TUNNEL_ITEM, NetsukukuTunnelItem))
#define NETSUKUKU_TUNNEL_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_TUNNEL_ITEM, NetsukukuTunnelItemClass))
#define NETSUKUKU_IS_TUNNEL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_TUNNEL_ITEM))
#define NETSUKUKU_IS_TUNNEL_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_TUNNEL_ITEM))
#define NETSUKUKU_TUNNEL_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_TUNNEL_ITEM, NetsukukuTunnelItemClass))

typedef struct _NetsukukuTunnelItem NetsukukuTunnelItem;
typedef struct _NetsukukuTunnelItemClass NetsukukuTunnelItemClass;
typedef struct _NetsukukuImplLinuxLinuxRoutePrivate NetsukukuImplLinuxLinuxRoutePrivate;

#define NETSUKUKU_TYPE_ROUTE_SOLUTION (netsukuku_route_solution_get_type ())
#define NETSUKUKU_ROUTE_SOLUTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_ROUTE_SOLUTION, NetsukukuRouteSolution))
#define NETSUKUKU_ROUTE_SOLUTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_ROUTE_SOLUTION, NetsukukuRouteSolutionClass))
#define NETSUKUKU_IS_ROUTE_SOLUTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_ROUTE_SOLUTION))
#define NETSUKUKU_IS_ROUTE_SOLUTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_ROUTE_SOLUTION))
#define NETSUKUKU_ROUTE_SOLUTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_ROUTE_SOLUTION, NetsukukuRouteSolutionClass))

typedef struct _NetsukukuRouteSolution NetsukukuRouteSolution;
typedef struct _NetsukukuRouteSolutionClass NetsukukuRouteSolutionClass;

#define NETSUKUKU_TYPE_CONNECTIONS (netsukuku_connections_get_type ())
#define NETSUKUKU_CONNECTIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_CONNECTIONS, NetsukukuConnections))
#define NETSUKUKU_CONNECTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_CONNECTIONS, NetsukukuConnectionsClass))
#define NETSUKUKU_IS_CONNECTIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_CONNECTIONS))
#define NETSUKUKU_IS_CONNECTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_CONNECTIONS))
#define NETSUKUKU_CONNECTIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_CONNECTIONS, NetsukukuConnectionsClass))

typedef struct _NetsukukuConnections NetsukukuConnections;
typedef struct _NetsukukuConnectionsClass NetsukukuConnectionsClass;
typedef struct _NetsukukuConnectionsPrivate NetsukukuConnectionsPrivate;

#define NETSUKUKU_IMPL_LINUX_TYPE_LINUX_CONNECTIONS (netsukuku_impl_linux_linux_connections_get_type ())
#define NETSUKUKU_IMPL_LINUX_LINUX_CONNECTIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_IMPL_LINUX_TYPE_LINUX_CONNECTIONS, NetsukukuImplLinuxLinuxConnections))
#define NETSUKUKU_IMPL_LINUX_LINUX_CONNECTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_IMPL_LINUX_TYPE_LINUX_CONNECTIONS, NetsukukuImplLinuxLinuxConnectionsClass))
#define NETSUKUKU_IMPL_LINUX_IS_LINUX_CONNECTIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_IMPL_LINUX_TYPE_LINUX_CONNECTIONS))
#define NETSUKUKU_IMPL_LINUX_IS_LINUX_CONNECTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_IMPL_LINUX_TYPE_LINUX_CONNECTIONS))
#define NETSUKUKU_IMPL_LINUX_LINUX_CONNECTIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_IMPL_LINUX_TYPE_LINUX_CONNECTIONS, NetsukukuImplLinuxLinuxConnectionsClass))

typedef struct _NetsukukuImplLinuxLinuxConnections NetsukukuImplLinuxLinuxConnections;
typedef struct _NetsukukuImplLinuxLinuxConnectionsClass NetsukukuImplLinuxLinuxConnectionsClass;
typedef struct _NetsukukuImplLinuxLinuxConnectionsPrivate NetsukukuImplLinuxLinuxConnectionsPrivate;

#define NETSUKUKU_TYPE_BASE_TUNNEL (netsukuku_base_tunnel_get_type ())
#define NETSUKUKU_BASE_TUNNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_BASE_TUNNEL, NetsukukuBaseTunnel))
#define NETSUKUKU_BASE_TUNNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_BASE_TUNNEL, NetsukukuBaseTunnelClass))
#define NETSUKUKU_IS_BASE_TUNNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_BASE_TUNNEL))
#define NETSUKUKU_IS_BASE_TUNNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_BASE_TUNNEL))
#define NETSUKUKU_BASE_TUNNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_BASE_TUNNEL, NetsukukuBaseTunnelClass))

typedef struct _NetsukukuBaseTunnel NetsukukuBaseTunnel;
typedef struct _NetsukukuBaseTunnelClass NetsukukuBaseTunnelClass;
typedef struct _NetsukukuBaseTunnelPrivate NetsukukuBaseTunnelPrivate;

#define NETSUKUKU_IMPL_LINUX_TYPE_LINUX_TUNNEL (netsukuku_impl_linux_linux_tunnel_get_type ())
#define NETSUKUKU_IMPL_LINUX_LINUX_TUNNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_IMPL_LINUX_TYPE_LINUX_TUNNEL, NetsukukuImplLinuxLinuxTunnel))
#define NETSUKUKU_IMPL_LINUX_LINUX_TUNNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_IMPL_LINUX_TYPE_LINUX_TUNNEL, NetsukukuImplLinuxLinuxTunnelClass))
#define NETSUKUKU_IMPL_LINUX_IS_LINUX_TUNNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_IMPL_LINUX_TYPE_LINUX_TUNNEL))
#define NETSUKUKU_IMPL_LINUX_IS_LINUX_TUNNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_IMPL_LINUX_TYPE_LINUX_TUNNEL))
#define NETSUKUKU_IMPL_LINUX_LINUX_TUNNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_IMPL_LINUX_TYPE_LINUX_TUNNEL, NetsukukuImplLinuxLinuxTunnelClass))

typedef struct _NetsukukuImplLinuxLinuxTunnel NetsukukuImplLinuxLinuxTunnel;
typedef struct _NetsukukuImplLinuxLinuxTunnelClass NetsukukuImplLinuxLinuxTunnelClass;
typedef struct _NetsukukuImplLinuxLinuxTunnelPrivate NetsukukuImplLinuxLinuxTunnelPrivate;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _NetsukukuImplLinuxstruct_helper_ntk_linux_sequential_command {
	gchar* cmdline;
};

typedef enum  {
	NETSUKUKU_IMPL_LINUX_IPROUTE_COMMAND_ERROR_GENERIC
} NetsukukuImplLinuxIPROUTECommandError;
#define NETSUKUKU_IMPL_LINUX_IPROUTE_COMMAND_ERROR netsukuku_impl_linux_iproute_command_error_quark ()
typedef enum  {
	NETSUKUKU_IMPL_LINUX_IPTABLES_COMMAND_ERROR_GENERIC
} NetsukukuImplLinuxIPTABLESCommandError;
#define NETSUKUKU_IMPL_LINUX_IPTABLES_COMMAND_ERROR netsukuku_impl_linux_iptables_command_error_quark ()
struct _NetsukukuNIC {
	GObject parent_instance;
	NetsukukuNICPrivate * priv;
	gchar* name;
	GeeArrayList* addresses;
};

struct _NetsukukuNICClass {
	GObjectClass parent_class;
	void (*_up) (NetsukukuNIC* self);
	void (*_down) (NetsukukuNIC* self);
	void (*_add_address) (NetsukukuNIC* self, const gchar* address);
	void (*_remove_address) (NetsukukuNIC* self, const gchar* address);
	void (*_disable_filtering) (NetsukukuNIC* self);
	const gchar* (*_mac_getter) (NetsukukuNIC* self);
	gboolean (*_is_active_getter) (NetsukukuNIC* self);
};

struct _NetsukukuImplLinuxLinuxNIC {
	NetsukukuNIC parent_instance;
	NetsukukuImplLinuxLinuxNICPrivate * priv;
};

struct _NetsukukuImplLinuxLinuxNICClass {
	NetsukukuNICClass parent_class;
};

struct _NetsukukuImplLinuxLinuxNICPrivate {
	gchar* _mac;
};

typedef NetsukukuNIC* (*NetsukukuCreateNicDelegate) (const gchar* nic_name, void* user_data);
struct _NetsukukuImplLinuxstruct_helper_LinuxRoute_activate_multipath {
	NetsukukuImplLinuxLinuxRoute* self;
};

struct _NetsukukuRouteSetter {
	GObject parent_instance;
	NetsukukuRouteSetterPrivate * priv;
};

struct _NetsukukuRouteSetterClass {
	GObjectClass parent_class;
	void (*_add_outgoing_route) (NetsukukuRouteSetter* self, const gchar* ip, const gchar* cidr, NetsukukuRouteSolutions* route_solutions);
	void (*_add_forwarding_route) (NetsukukuRouteSetter* self, const gchar* ip, const gchar* cidr, const gchar* prev_hop, NetsukukuRouteSolutions* route_solutions, GError** error);
	void (*_add_forwarding_route_unreachable) (NetsukukuRouteSetter* self, const gchar* ip, const gchar* cidr, const gchar* prev_hop, GError** error);
	void (*_add_forwarding_route_drop) (NetsukukuRouteSetter* self, const gchar* ip, const gchar* cidr, const gchar* prev_hop, GError** error);
	void (*_change_outgoing_route) (NetsukukuRouteSetter* self, const gchar* ip, const gchar* cidr, NetsukukuRouteSolutions* route_solutions, NetsukukuRouteSolutions* old_route_solutions);
	void (*_change_forwarding_route) (NetsukukuRouteSetter* self, const gchar* ip, const gchar* cidr, const gchar* prev_hop, NetsukukuRouteSolutions* route_solutions, NetsukukuRouteSolutions* old_route_solutions, GError** error);
	void (*_change_forwarding_route_unreachable) (NetsukukuRouteSetter* self, const gchar* ip, const gchar* cidr, const gchar* prev_hop, NetsukukuRouteSolutions* old_route_solutions, GError** error);
	void (*_change_forwarding_route_drop) (NetsukukuRouteSetter* self, const gchar* ip, const gchar* cidr, const gchar* prev_hop, NetsukukuRouteSolutions* old_route_solutions, GError** error);
	void (*_change_forwarding_route_was_unreachable) (NetsukukuRouteSetter* self, const gchar* ip, const gchar* cidr, const gchar* prev_hop, NetsukukuRouteSolutions* route_solutions, GError** error);
	void (*_change_forwarding_route_drop_was_unreachable) (NetsukukuRouteSetter* self, const gchar* ip, const gchar* cidr, const gchar* prev_hop, GError** error);
	void (*_change_forwarding_route_was_drop) (NetsukukuRouteSetter* self, const gchar* ip, const gchar* cidr, const gchar* prev_hop, NetsukukuRouteSolutions* route_solutions, GError** error);
	void (*_change_forwarding_route_unreachable_was_drop) (NetsukukuRouteSetter* self, const gchar* ip, const gchar* cidr, const gchar* prev_hop, GError** error);
	void (*_remove_outgoing_route) (NetsukukuRouteSetter* self, const gchar* ip, const gchar* cidr, NetsukukuRouteSolutions* old_route_solutions);
	void (*_remove_forwarding_route) (NetsukukuRouteSetter* self, const gchar* ip, const gchar* cidr, const gchar* prev_hop, NetsukukuRouteSolutions* old_route_solutions, GError** error);
	void (*_remove_forwarding_route_was_unreachable) (NetsukukuRouteSetter* self, const gchar* ip, const gchar* cidr, const gchar* prev_hop, GError** error);
	void (*_remove_forwarding_route_was_drop) (NetsukukuRouteSetter* self, const gchar* ip, const gchar* cidr, const gchar* prev_hop, GError** error);
	void (*_forward_no_more_from) (NetsukukuRouteSetter* self, const gchar* prev_hop, GError** error);
	void (*_forward_no_more) (NetsukukuRouteSetter* self, GError** error);
	void (*_add_neighbour) (NetsukukuRouteSetter* self, const gchar* ip, const gchar* dev, const gchar* pref_src);
	void (*_change_neighbour) (NetsukukuRouteSetter* self, const gchar* ip, const gchar* dev, const gchar* pref_src, const gchar* old_dev);
	void (*_delete_neighbour) (NetsukukuRouteSetter* self, const gchar* ip, const gchar* old_dev);
	gboolean (*_igs_update_rules) (NetsukukuRouteSetter* self, const gchar* prev_mode, gboolean prev_announce_myself, GeeArrayList* prev_list_tunnels, const gchar* mode, gboolean announce_myself, GeeArrayList* list_tunnels, const gchar* pref_src, GError** error);
	gboolean (*check_ping) (NetsukukuRouteSetter* self, const gchar* ipstr);
	gboolean (*_reset_routes) (NetsukukuRouteSetter* self, const gchar* ip_whole_network, const gchar* cidr_whole_network);
	void (*activate_multipath) (NetsukukuRouteSetter* self);
	void (*ip_forward) (NetsukukuRouteSetter* self, gboolean enable);
};

struct _NetsukukuImplLinuxLinuxRoute {
	NetsukukuRouteSetter parent_instance;
	NetsukukuImplLinuxLinuxRoutePrivate * priv;
};

struct _NetsukukuImplLinuxLinuxRouteClass {
	NetsukukuRouteSetterClass parent_class;
};

struct _NetsukukuImplLinuxLinuxRoutePrivate {
	GeeHashMap* mac_table;
};

typedef NetsukukuRouteSetter* (*NetsukukuCreateRouteSetterDelegate) (void* user_data);
struct _NetsukukuConnections {
	GObject parent_instance;
	NetsukukuConnectionsPrivate * priv;
};

struct _NetsukukuConnectionsClass {
	GObjectClass parent_class;
	gboolean (*active_tcp_connections) (NetsukukuConnections* self, const gchar* ip);
};

struct _NetsukukuImplLinuxLinuxConnections {
	NetsukukuConnections parent_instance;
	NetsukukuImplLinuxLinuxConnectionsPrivate * priv;
};

struct _NetsukukuImplLinuxLinuxConnectionsClass {
	NetsukukuConnectionsClass parent_class;
};

typedef NetsukukuConnections* (*NetsukukuCreateConnectionsDelegate) (void* user_data);
typedef void (*NetsukukuCallbackSendDelegate) (zcdISerializable* msg, void* user_data, GError** error);
typedef zcdISerializable* (*NetsukukuCallbackRecvDelegate) (void* user_data, GError** error);
struct _NetsukukuBaseTunnel {
	GObject parent_instance;
	NetsukukuBaseTunnelPrivate * priv;
};

struct _NetsukukuBaseTunnelClass {
	GObjectClass parent_class;
	gchar* (*request) (NetsukukuBaseTunnel* self, NetsukukuCallbackSendDelegate cb_send, void* cb_send_target, NetsukukuCallbackRecvDelegate cb_recv, void* cb_recv_target, const gchar* my_address, const gchar* dest_address, GError** error);
	gchar* (*serve) (NetsukukuBaseTunnel* self, NetsukukuCallbackSendDelegate cb_send, void* cb_send_target, NetsukukuCallbackRecvDelegate cb_recv, void* cb_recv_target, const gchar* my_address, const gchar* dest_address, GError** error);
	void (*close) (NetsukukuBaseTunnel* self, const gchar* nic_name, const gchar* my_address, const gchar* dest_address, GError** error);
};

struct _NetsukukuImplLinuxLinuxTunnel {
	NetsukukuBaseTunnel parent_instance;
	NetsukukuImplLinuxLinuxTunnelPrivate * priv;
};

struct _NetsukukuImplLinuxLinuxTunnelClass {
	NetsukukuBaseTunnelClass parent_class;
};

struct _NetsukukuImplLinuxLinuxTunnelPrivate {
	GeeLinkedList* port_pool;
	GeeHashMap* used_ports;
};

typedef NetsukukuBaseTunnel* (*NetsukukuCreateTunnelDelegate) (void* user_data);

extern TaskletsChannel* netsukuku_impl_linux__sequential_command_channel;
TaskletsChannel* netsukuku_impl_linux__sequential_command_channel = NULL;
static gpointer netsukuku_impl_linux_linux_nic_parent_class = NULL;
extern gint netsukuku_impl_linux_NTK_TABLE;
gint netsukuku_impl_linux_NTK_TABLE = 200;
extern GRegex* netsukuku_impl_linux_NTK_IN_RT_TABLE;
GRegex* netsukuku_impl_linux_NTK_IN_RT_TABLE = NULL;
static gpointer netsukuku_impl_linux_linux_route_parent_class = NULL;
static gpointer netsukuku_impl_linux_linux_connections_parent_class = NULL;
static gpointer netsukuku_impl_linux_linux_tunnel_parent_class = NULL;

TaskletsCommandResult* netsukuku_impl_linux_exec_command (const gchar* cmdline, GError** error);
void netsukuku_log_trace (const gchar* msg);
GType netsukuku_impl_linux_struct_helper_ntk_linux_sequential_command_get_type (void) G_GNUC_CONST;
NetsukukuImplLinuxstruct_helper_ntk_linux_sequential_command* netsukuku_impl_linux_struct_helper_ntk_linux_sequential_command_dup (const NetsukukuImplLinuxstruct_helper_ntk_linux_sequential_command* self);
void netsukuku_impl_linux_struct_helper_ntk_linux_sequential_command_free (NetsukukuImplLinuxstruct_helper_ntk_linux_sequential_command* self);
void netsukuku_impl_linux_struct_helper_ntk_linux_sequential_command_copy (const NetsukukuImplLinuxstruct_helper_ntk_linux_sequential_command* self, NetsukukuImplLinuxstruct_helper_ntk_linux_sequential_command* dest);
void netsukuku_impl_linux_struct_helper_ntk_linux_sequential_command_destroy (NetsukukuImplLinuxstruct_helper_ntk_linux_sequential_command* self);
TaskletsChannel* netsukuku_impl_linux_get_sequential_command_channel (void);
void* netsukuku_impl_linux_helper_sequential_command (void* v);
void netsukuku_log_warn (const gchar* msg);
void netsukuku_impl_linux_sequential_command (const gchar* cmdline, gchar** cmdout, gchar** cmderr, gint* exit_status);
GQuark netsukuku_impl_linux_iproute_command_error_quark (void);
gchar* netsukuku_impl_linux_iproute (const gchar* args, GError** error);
const gchar* netsukuku_settings_get_IPROUTE_PATH (void);
void netsukuku_settings_set_IPROUTE_PATH (const gchar* value);
void netsukuku_impl_linux_iproute_exp (const gchar* args);
GQuark netsukuku_impl_linux_iptables_command_error_quark (void);
gchar* netsukuku_impl_linux_iptables (const gchar* args, GError** error);
const gchar* netsukuku_settings_get_IPTABLES_PATH (void);
void netsukuku_settings_set_IPTABLES_PATH (const gchar* value);
void netsukuku_impl_linux_iptables_exp (const gchar* args);
gboolean netsukuku_impl_linux_check_ping (const gchar* ipstr);
const gchar* netsukuku_settings_get_PING_PATH (void);
void netsukuku_settings_set_PING_PATH (const gchar* value);
void netsukuku_impl_linux_write_file (const gchar* pathname, guint8* buf, int buf_length1);
void netsukuku_log_error (const gchar* msg);
guint8* netsukuku_impl_linux_read_file (const gchar* pathname, gint maxlen, int* result_length1);
GType netsukuku_nic_get_type (void) G_GNUC_CONST;
GType netsukuku_impl_linux_linux_nic_get_type (void) G_GNUC_CONST;
#define NETSUKUKU_IMPL_LINUX_LINUX_NIC_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), NETSUKUKU_IMPL_LINUX_TYPE_LINUX_NIC, NetsukukuImplLinuxLinuxNICPrivate))
enum  {
	NETSUKUKU_IMPL_LINUX_LINUX_NIC_DUMMY_PROPERTY
};
static NetsukukuNIC* _netsukuku_impl_linux_linux_nic_create (const gchar* nic_name);
NetsukukuImplLinuxLinuxNIC* netsukuku_impl_linux_linux_nic_new (const gchar* nic_name);
NetsukukuImplLinuxLinuxNIC* netsukuku_impl_linux_linux_nic_construct (GType object_type, const gchar* nic_name);
void netsukuku_impl_linux_linux_nic_register (void);
void netsukuku_nic_register_class (const gchar* k, NetsukukuCreateNicDelegate create_new_nic, void* create_new_nic_target);
static NetsukukuNIC* __netsukuku_impl_linux_linux_nic_create_netsukuku_create_nic_delegate (const gchar* nic_name, gpointer self);
NetsukukuNIC* netsukuku_nic_construct (GType object_type, const gchar* nic_name);
static const gchar* netsukuku_impl_linux_linux_nic_real__mac_getter (NetsukukuNIC* base);
static gboolean netsukuku_impl_linux_linux_nic_real__is_active_getter (NetsukukuNIC* base);
static void netsukuku_impl_linux_linux_nic_real__up (NetsukukuNIC* base);
static void netsukuku_impl_linux_linux_nic_real__down (NetsukukuNIC* base);
static void netsukuku_impl_linux_linux_nic_real__add_address (NetsukukuNIC* base, const gchar* address);
static void netsukuku_impl_linux_linux_nic_real__remove_address (NetsukukuNIC* base, const gchar* address);
static void netsukuku_impl_linux_linux_nic_real__disable_filtering (NetsukukuNIC* base);
static void netsukuku_impl_linux_linux_nic_finalize (GObject* obj);
#define NETSUKUKU_IMPL_LINUX_RT_TABLE "/etc/iproute2/rt_tables"
void netsukuku_impl_linux_init_prdb (void);
GType netsukuku_impl_linux_struct_helper_linuxroute_activate_multipath_get_type (void) G_GNUC_CONST;
GType netsukuku_route_setter_get_type (void) G_GNUC_CONST;
GType netsukuku_impl_linux_linux_route_get_type (void) G_GNUC_CONST;
NetsukukuImplLinuxstruct_helper_LinuxRoute_activate_multipath* netsukuku_impl_linux_struct_helper_linuxroute_activate_multipath_dup (const NetsukukuImplLinuxstruct_helper_LinuxRoute_activate_multipath* self);
void netsukuku_impl_linux_struct_helper_linuxroute_activate_multipath_free (NetsukukuImplLinuxstruct_helper_LinuxRoute_activate_multipath* self);
void netsukuku_impl_linux_struct_helper_linuxroute_activate_multipath_copy (const NetsukukuImplLinuxstruct_helper_LinuxRoute_activate_multipath* self, NetsukukuImplLinuxstruct_helper_LinuxRoute_activate_multipath* dest);
void netsukuku_impl_linux_struct_helper_linuxroute_activate_multipath_destroy (NetsukukuImplLinuxstruct_helper_LinuxRoute_activate_multipath* self);
GType netsukuku_base_route_solutions_get_type (void) G_GNUC_CONST;
GType netsukuku_route_solutions_get_type (void) G_GNUC_CONST;
GType netsukuku_tunnel_item_get_type (void) G_GNUC_CONST;
#define NETSUKUKU_IMPL_LINUX_LINUX_ROUTE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), NETSUKUKU_IMPL_LINUX_TYPE_LINUX_ROUTE, NetsukukuImplLinuxLinuxRoutePrivate))
enum  {
	NETSUKUKU_IMPL_LINUX_LINUX_ROUTE_DUMMY_PROPERTY
};
static NetsukukuRouteSetter* _netsukuku_impl_linux_linux_route_create (void);
gboolean netsukuku_settings_get_TESTING (void);
NetsukukuImplLinuxLinuxRoute* netsukuku_impl_linux_linux_route_new (void);
NetsukukuImplLinuxLinuxRoute* netsukuku_impl_linux_linux_route_construct (GType object_type);
void netsukuku_impl_linux_linux_route_register (void);
void netsukuku_route_setter_register_class (const gchar* k, NetsukukuCreateRouteSetterDelegate create_new_route, void* create_new_route_target);
static NetsukukuRouteSetter* __netsukuku_impl_linux_linux_route_create_netsukuku_create_route_setter_delegate (gpointer self);
NetsukukuRouteSetter* netsukuku_route_setter_construct (GType object_type);
static void netsukuku_impl_linux_linux_route_impl_activate_multipath (NetsukukuImplLinuxLinuxRoute* self, GError** error);
static void* netsukuku_impl_linux_linux_route_helper_activate_multipath (void* v, GError** error);
static void netsukuku_impl_linux_linux_route_real_activate_multipath (NetsukukuRouteSetter* base);
gint _netsukuku_impl_linux_linux_route_table_for_macaddr (NetsukukuImplLinuxLinuxRoute* self, const gchar* _macaddr, GError** error);
void _netsukuku_impl_linux_linux_route_table_for_macaddr_remove_all (NetsukukuImplLinuxLinuxRoute* self, GError** error);
void _netsukuku_impl_linux_linux_route_table_for_macaddr_remove (NetsukukuImplLinuxLinuxRoute* self, const gchar* _macaddr, GError** error);
gchar* _netsukuku_impl_linux_linux_route_modify_routes_cmd (NetsukukuImplLinuxLinuxRoute* self, const gchar* command, const gchar* ip, const gchar* cidr, NetsukukuRouteSolutions* route_solutions, const gchar* table);
const gchar* netsukuku_route_solutions_get_pref_src (NetsukukuRouteSolutions* self);
GType netsukuku_route_solution_get_type (void) G_GNUC_CONST;
GeeCollection* netsukuku_route_solutions_get_values (NetsukukuRouteSolutions* self);
const gchar* netsukuku_route_solution_get_gateway (NetsukukuRouteSolution* self);
const gchar* netsukuku_route_solution_get_dev (NetsukukuRouteSolution* self);
gint netsukuku_route_solution_get_weight (NetsukukuRouteSolution* self);
gchar* _netsukuku_impl_linux_linux_route_modify_neighbour_cmd (NetsukukuImplLinuxLinuxRoute* self, const gchar* command, const gchar* ip, const gchar* dev, const gchar* pref_src);
static void netsukuku_impl_linux_linux_route_real__add_outgoing_route (NetsukukuRouteSetter* base, const gchar* ip, const gchar* cidr, NetsukukuRouteSolutions* route_solutions);
gboolean netsukuku_route_solutions_contains_gw (NetsukukuRouteSolutions* self, const gchar* gateway);
static void netsukuku_impl_linux_linux_route_real__add_forwarding_route (NetsukukuRouteSetter* base, const gchar* ip, const gchar* cidr, const gchar* prev_hop, NetsukukuRouteSolutions* route_solutions, GError** error);
static void netsukuku_impl_linux_linux_route_real__add_forwarding_route_unreachable (NetsukukuRouteSetter* base, const gchar* ip, const gchar* cidr, const gchar* prev_hop, GError** error);
static void netsukuku_impl_linux_linux_route_real__add_forwarding_route_drop (NetsukukuRouteSetter* base, const gchar* ip, const gchar* cidr, const gchar* prev_hop, GError** error);
static void netsukuku_impl_linux_linux_route_real__change_outgoing_route (NetsukukuRouteSetter* base, const gchar* ip, const gchar* cidr, NetsukukuRouteSolutions* route_solutions, NetsukukuRouteSolutions* old_route_solutions);
static void netsukuku_impl_linux_linux_route_real__change_forwarding_route (NetsukukuRouteSetter* base, const gchar* ip, const gchar* cidr, const gchar* prev_hop, NetsukukuRouteSolutions* route_solutions, NetsukukuRouteSolutions* old_route_solutions, GError** error);
static void netsukuku_impl_linux_linux_route_real__change_forwarding_route_unreachable (NetsukukuRouteSetter* base, const gchar* ip, const gchar* cidr, const gchar* prev_hop, NetsukukuRouteSolutions* old_route_solutions, GError** error);
static void netsukuku_impl_linux_linux_route_real__change_forwarding_route_drop (NetsukukuRouteSetter* base, const gchar* ip, const gchar* cidr, const gchar* prev_hop, NetsukukuRouteSolutions* old_route_solutions, GError** error);
static void netsukuku_impl_linux_linux_route_real__change_forwarding_route_was_unreachable (NetsukukuRouteSetter* base, const gchar* ip, const gchar* cidr, const gchar* prev_hop, NetsukukuRouteSolutions* route_solutions, GError** error);
static void netsukuku_impl_linux_linux_route_real__change_forwarding_route_drop_was_unreachable (NetsukukuRouteSetter* base, const gchar* ip, const gchar* cidr, const gchar* prev_hop, GError** error);
static void netsukuku_impl_linux_linux_route_real__change_forwarding_route_was_drop (NetsukukuRouteSetter* base, const gchar* ip, const gchar* cidr, const gchar* prev_hop, NetsukukuRouteSolutions* route_solutions, GError** error);
static void netsukuku_impl_linux_linux_route_real__change_forwarding_route_unreachable_was_drop (NetsukukuRouteSetter* base, const gchar* ip, const gchar* cidr, const gchar* prev_hop, GError** error);
static void netsukuku_impl_linux_linux_route_real__remove_outgoing_route (NetsukukuRouteSetter* base, const gchar* ip, const gchar* cidr, NetsukukuRouteSolutions* old_route_solutions);
static void netsukuku_impl_linux_linux_route_real__remove_forwarding_route (NetsukukuRouteSetter* base, const gchar* ip, const gchar* cidr, const gchar* prev_hop, NetsukukuRouteSolutions* old_route_solutions, GError** error);
static void netsukuku_impl_linux_linux_route_real__remove_forwarding_route_was_unreachable (NetsukukuRouteSetter* base, const gchar* ip, const gchar* cidr, const gchar* prev_hop, GError** error);
static void netsukuku_impl_linux_linux_route_real__remove_forwarding_route_was_drop (NetsukukuRouteSetter* base, const gchar* ip, const gchar* cidr, const gchar* prev_hop, GError** error);
static void netsukuku_impl_linux_linux_route_real__forward_no_more_from (NetsukukuRouteSetter* base, const gchar* _prev_hop, GError** error);
static void netsukuku_impl_linux_linux_route_real__forward_no_more (NetsukukuRouteSetter* base, GError** error);
static void netsukuku_impl_linux_linux_route_real__add_neighbour (NetsukukuRouteSetter* base, const gchar* ip, const gchar* dev, const gchar* pref_src);
static void netsukuku_impl_linux_linux_route_real__change_neighbour (NetsukukuRouteSetter* base, const gchar* ip, const gchar* dev, const gchar* pref_src, const gchar* old_dev);
static void netsukuku_impl_linux_linux_route_real__delete_neighbour (NetsukukuRouteSetter* base, const gchar* ip, const gchar* old_dev);
void _netsukuku_impl_linux_linux_route_disable_rp_filter (NetsukukuImplLinuxLinuxRoute* self, const gchar* nicname);
static gboolean netsukuku_impl_linux_linux_route_real__igs_update_rules (NetsukukuRouteSetter* base, const gchar* prev_mode, gboolean prev_announce_myself, GeeArrayList* prev_list_tunnels, const gchar* mode, gboolean announce_myself, GeeArrayList* list_tunnels, const gchar* pref_src, GError** error);
gchar* netsukuku_tunnel_item_to_string (NetsukukuTunnelItem* self);
const gchar* netsukuku_tunnel_item_get_ipstr (NetsukukuTunnelItem* self);
static gboolean netsukuku_impl_linux_linux_route_real_check_ping (NetsukukuRouteSetter* base, const gchar* ipstr);
gboolean netsukuku_impl_linux_linux_route_impl_check_ping (NetsukukuImplLinuxLinuxRoute* self, const gchar* ipstr);
gboolean netsukuku_route_setter_check_ping (NetsukukuRouteSetter* self, const gchar* ipstr);
static gboolean netsukuku_impl_linux_linux_route_real__reset_routes (NetsukukuRouteSetter* base, const gchar* ip_whole_network, const gchar* cidr_whole_network);
static void netsukuku_impl_linux_linux_route_real_ip_forward (NetsukukuRouteSetter* base, gboolean enable);
static void netsukuku_impl_linux_linux_route_finalize (GObject* obj);
GType netsukuku_connections_get_type (void) G_GNUC_CONST;
GType netsukuku_impl_linux_linux_connections_get_type (void) G_GNUC_CONST;
enum  {
	NETSUKUKU_IMPL_LINUX_LINUX_CONNECTIONS_DUMMY_PROPERTY
};
static NetsukukuConnections* _netsukuku_impl_linux_linux_connections_create (void);
NetsukukuImplLinuxLinuxConnections* netsukuku_impl_linux_linux_connections_new (void);
NetsukukuImplLinuxLinuxConnections* netsukuku_impl_linux_linux_connections_construct (GType object_type);
void netsukuku_impl_linux_linux_connections_register (void);
void netsukuku_connections_register_class (const gchar* k, NetsukukuCreateConnectionsDelegate create_new_connections, void* create_new_connections_target);
static NetsukukuConnections* __netsukuku_impl_linux_linux_connections_create_netsukuku_create_connections_delegate (gpointer self);
static gboolean netsukuku_impl_linux_linux_connections_real_active_tcp_connections (NetsukukuConnections* base, const gchar* ip);
void netsukuku_log_info (const gchar* msg);
NetsukukuConnections* netsukuku_connections_construct (GType object_type);
GType netsukuku_base_tunnel_get_type (void) G_GNUC_CONST;
GType netsukuku_impl_linux_linux_tunnel_get_type (void) G_GNUC_CONST;
#define NETSUKUKU_IMPL_LINUX_LINUX_TUNNEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), NETSUKUKU_IMPL_LINUX_TYPE_LINUX_TUNNEL, NetsukukuImplLinuxLinuxTunnelPrivate))
enum  {
	NETSUKUKU_IMPL_LINUX_LINUX_TUNNEL_DUMMY_PROPERTY
};
static NetsukukuBaseTunnel* _netsukuku_impl_linux_linux_tunnel_create (void);
NetsukukuImplLinuxLinuxTunnel* netsukuku_impl_linux_linux_tunnel_new (void);
NetsukukuImplLinuxLinuxTunnel* netsukuku_impl_linux_linux_tunnel_construct (GType object_type);
void netsukuku_impl_linux_linux_tunnel_register (void);
void netsukuku_base_tunnel_register_class (const gchar* k, NetsukukuCreateTunnelDelegate create_new_nic, void* create_new_nic_target);
static NetsukukuBaseTunnel* __netsukuku_impl_linux_linux_tunnel_create_netsukuku_create_tunnel_delegate (gpointer self);
NetsukukuBaseTunnel* netsukuku_base_tunnel_construct (GType object_type);
static gchar* netsukuku_impl_linux_linux_tunnel_real_serve (NetsukukuBaseTunnel* base, NetsukukuCallbackSendDelegate cb_send, void* cb_send_target, NetsukukuCallbackRecvDelegate cb_recv, void* cb_recv_target, const gchar* my_address, const gchar* dest_address, GError** error);
static gchar* netsukuku_impl_linux_linux_tunnel_real_request (NetsukukuBaseTunnel* base, NetsukukuCallbackSendDelegate cb_send, void* cb_send_target, NetsukukuCallbackRecvDelegate cb_recv, void* cb_recv_target, const gchar* my_address, const gchar* dest_address, GError** error);
static void netsukuku_impl_linux_linux_tunnel_real_close (NetsukukuBaseTunnel* base, const gchar* nic_name, const gchar* my_address, const gchar* dest_address, GError** error);
static void netsukuku_impl_linux_linux_tunnel_finalize (GObject* obj);


/** Launch a process and block this tasklet till it ends.
      * Returns exit status, stdout and stderr.
      */
static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


TaskletsCommandResult* netsukuku_impl_linux_exec_command (const gchar* cmdline, GError** error) {
	TaskletsCommandResult* result = NULL;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp6_;
	TaskletsCommandResult* _tmp7_ = NULL;
	TaskletsCommandResult* com_ret;
	gint _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
	gchar* report;
	const gchar* _tmp13_;
	const gchar* _tmp18_;
	const gchar* _tmp19_ = NULL;
	const gchar* _tmp20_;
	const gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	gboolean _tmp23_ = FALSE;
	const gchar* _tmp24_;
	gboolean _tmp26_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (cmdline != NULL, NULL);
	_tmp0_ = cmdline;
	_tmp1_ = string_contains (_tmp0_, "route flush cache");
	if (!_tmp1_) {
		const gchar* _tmp2_;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		_tmp2_ = cmdline;
		_tmp3_ = string_to_string (_tmp2_);
		_tmp4_ = g_strconcat ("ImplLinux: going to execute...: ", _tmp3_, NULL);
		_tmp5_ = _tmp4_;
		netsukuku_log_trace (_tmp5_);
		_g_free0 (_tmp5_);
	}
	_tmp6_ = cmdline;
	_tmp7_ = tasklets_tasklet_exec_command (_tmp6_, &_inner_error_);
	com_ret = _tmp7_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_SPAWN_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp8_ = com_ret->exit_status;
	_tmp9_ = g_strdup_printf ("%i", _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strconcat (" with exit value ", _tmp10_, " and stderr ", NULL);
	_tmp12_ = _tmp11_;
	_g_free0 (_tmp10_);
	report = _tmp12_;
	_tmp13_ = com_ret->cmderr;
	if (g_strcmp0 (_tmp13_, "") == 0) {
		const gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp14_ = report;
		_tmp15_ = g_strconcat (_tmp14_, "null", NULL);
		_g_free0 (report);
		report = _tmp15_;
	} else {
		const gchar* _tmp16_;
		gchar* _tmp17_;
		_tmp16_ = report;
		_tmp17_ = g_strconcat (_tmp16_, "NOT null", NULL);
		_g_free0 (report);
		report = _tmp17_;
	}
	_tmp18_ = report;
	_tmp19_ = string_to_string (_tmp18_);
	_tmp20_ = cmdline;
	_tmp21_ = string_to_string (_tmp20_);
	_tmp22_ = g_strconcat ("ImplLinux: completed", _tmp19_, ": ", _tmp21_, NULL);
	_g_free0 (report);
	report = _tmp22_;
	_tmp24_ = com_ret->cmderr;
	if (g_strcmp0 (_tmp24_, "") != 0) {
		_tmp23_ = TRUE;
	} else {
		gint _tmp25_;
		_tmp25_ = com_ret->exit_status;
		_tmp23_ = _tmp25_ != 0;
	}
	_tmp26_ = _tmp23_;
	if (_tmp26_) {
		const gchar* _tmp27_;
		_tmp27_ = report;
		netsukuku_log_trace (_tmp27_);
	}
	result = com_ret;
	_g_free0 (report);
	return result;
}


void netsukuku_impl_linux_struct_helper_ntk_linux_sequential_command_copy (const NetsukukuImplLinuxstruct_helper_ntk_linux_sequential_command* self, NetsukukuImplLinuxstruct_helper_ntk_linux_sequential_command* dest) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = (*self).cmdline;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).cmdline);
	(*dest).cmdline = _tmp1_;
}


void netsukuku_impl_linux_struct_helper_ntk_linux_sequential_command_destroy (NetsukukuImplLinuxstruct_helper_ntk_linux_sequential_command* self) {
	_g_free0 ((*self).cmdline);
}


NetsukukuImplLinuxstruct_helper_ntk_linux_sequential_command* netsukuku_impl_linux_struct_helper_ntk_linux_sequential_command_dup (const NetsukukuImplLinuxstruct_helper_ntk_linux_sequential_command* self) {
	NetsukukuImplLinuxstruct_helper_ntk_linux_sequential_command* dup;
	dup = g_new0 (NetsukukuImplLinuxstruct_helper_ntk_linux_sequential_command, 1);
	netsukuku_impl_linux_struct_helper_ntk_linux_sequential_command_copy (self, dup);
	return dup;
}


void netsukuku_impl_linux_struct_helper_ntk_linux_sequential_command_free (NetsukukuImplLinuxstruct_helper_ntk_linux_sequential_command* self) {
	netsukuku_impl_linux_struct_helper_ntk_linux_sequential_command_destroy (self);
	g_free (self);
}


GType netsukuku_impl_linux_struct_helper_ntk_linux_sequential_command_get_type (void) {
	static volatile gsize netsukuku_impl_linux_struct_helper_ntk_linux_sequential_command_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_impl_linux_struct_helper_ntk_linux_sequential_command_type_id__volatile)) {
		GType netsukuku_impl_linux_struct_helper_ntk_linux_sequential_command_type_id;
		netsukuku_impl_linux_struct_helper_ntk_linux_sequential_command_type_id = g_boxed_type_register_static ("NetsukukuImplLinuxstruct_helper_ntk_linux_sequential_command", (GBoxedCopyFunc) netsukuku_impl_linux_struct_helper_ntk_linux_sequential_command_dup, (GBoxedFreeFunc) netsukuku_impl_linux_struct_helper_ntk_linux_sequential_command_free);
		g_once_init_leave (&netsukuku_impl_linux_struct_helper_ntk_linux_sequential_command_type_id__volatile, netsukuku_impl_linux_struct_helper_ntk_linux_sequential_command_type_id);
	}
	return netsukuku_impl_linux_struct_helper_ntk_linux_sequential_command_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


TaskletsChannel* netsukuku_impl_linux_get_sequential_command_channel (void) {
	TaskletsChannel* result = NULL;
	TaskletsChannel* _tmp0_;
	TaskletsChannel* _tmp2_;
	TaskletsChannel* _tmp4_;
	TaskletsChannel* _tmp5_;
	_tmp0_ = netsukuku_impl_linux__sequential_command_channel;
	if (_tmp0_ == NULL) {
		TaskletsChannel* _tmp1_ = NULL;
		_tmp1_ = tasklets_channel_find ("ntk_linux_sequential_command_channel");
		_g_object_unref0 (netsukuku_impl_linux__sequential_command_channel);
		netsukuku_impl_linux__sequential_command_channel = _tmp1_;
	}
	_tmp2_ = netsukuku_impl_linux__sequential_command_channel;
	if (_tmp2_ == NULL) {
		TaskletsChannel* _tmp3_;
		_tmp3_ = tasklets_channel_new ("ntk_linux_sequential_command_channel");
		_g_object_unref0 (netsukuku_impl_linux__sequential_command_channel);
		netsukuku_impl_linux__sequential_command_channel = _tmp3_;
	}
	_tmp4_ = netsukuku_impl_linux__sequential_command_channel;
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TASKLETS_TYPE_CHANNEL, TaskletsChannel));
	result = _tmp5_;
	return result;
}


void* netsukuku_impl_linux_helper_sequential_command (void* v) {
	void* result = NULL;
	void* _tmp0_;
	Taskletsstruct_channel* ch_cont_p;
	Taskletsstruct_channel* _tmp1_;
	TaskletsChannel* _tmp2_;
	TaskletsChannel* _tmp3_;
	TaskletsChannel* ch;
	GError * _inner_error_ = NULL;
	tasklets_tasklet_declare_self ("ImplLinux.sequential_command dispatcher");
	_tmp0_ = v;
	ch_cont_p = (Taskletsstruct_channel*) _tmp0_;
	_tmp1_ = ch_cont_p;
	_tmp2_ = (*_tmp1_).self;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	ch = _tmp3_;
	tasklets_tasklet_schedule_back ();
	_g_object_unref0 (netsukuku_impl_linux__sequential_command_channel);
	netsukuku_impl_linux__sequential_command_channel = NULL;
	while (TRUE) {
		gchar* doing;
		const gchar* _tmp56_;
		doing = NULL;
		{
			NetsukukuImplLinuxstruct_helper_ntk_linux_sequential_command tuple_p = {0};
			NetsukukuImplLinuxstruct_helper_ntk_linux_sequential_command _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_ = NULL;
			gchar* _tmp11_;
			const gchar* _tmp12_;
			gchar* cmdout;
			gchar* cmderr;
			gint exit_status = 0;
			TaskletsChannel* _tmp39_ = NULL;
			TaskletsChannel* _tmp40_;
			gint _tmp41_;
			GValue _tmp42_ = {0};
			TaskletsChannel* _tmp43_ = NULL;
			TaskletsChannel* _tmp44_;
			const gchar* _tmp45_;
			GValue _tmp46_ = {0};
			TaskletsChannel* _tmp47_ = NULL;
			TaskletsChannel* _tmp48_;
			const gchar* _tmp49_;
			GValue _tmp50_ = {0};
			{
				TaskletsChannel* _tmp4_;
				GValue _tmp5_ = {0};
				GValue vv;
				void* _tmp6_ = NULL;
				NetsukukuImplLinuxstruct_helper_ntk_linux_sequential_command _tmp7_ = {0};
				_tmp4_ = ch;
				tasklets_channel_recv (_tmp4_, &_tmp5_);
				vv = _tmp5_;
				_tmp6_ = g_value_get_boxed (&vv);
				netsukuku_impl_linux_struct_helper_ntk_linux_sequential_command_copy ((NetsukukuImplLinuxstruct_helper_ntk_linux_sequential_command*) _tmp6_, &_tmp7_);
				netsukuku_impl_linux_struct_helper_ntk_linux_sequential_command_destroy (&tuple_p);
				tuple_p = _tmp7_;
				G_IS_VALUE (&vv) ? (g_value_unset (&vv), NULL) : NULL;
			}
			tasklets_ms_wait ((gint64) 10);
			_tmp8_ = tuple_p;
			_tmp9_ = _tmp8_.cmdline;
			_tmp10_ = string_to_string (_tmp9_);
			_tmp11_ = g_strdup (_tmp10_);
			_g_free0 (doing);
			doing = _tmp11_;
			_tmp12_ = doing;
			tasklets_tasklet_declare_self (_tmp12_);
			cmdout = NULL;
			cmderr = NULL;
			{
				NetsukukuImplLinuxstruct_helper_ntk_linux_sequential_command _tmp13_;
				const gchar* _tmp14_;
				TaskletsCommandResult* _tmp15_ = NULL;
				TaskletsCommandResult* com_ret;
				TaskletsCommandResult* _tmp16_;
				const gchar* _tmp17_;
				gchar* _tmp18_;
				TaskletsCommandResult* _tmp19_;
				const gchar* _tmp20_;
				gchar* _tmp21_;
				TaskletsCommandResult* _tmp22_;
				gint _tmp23_;
				_tmp13_ = tuple_p;
				_tmp14_ = _tmp13_.cmdline;
				_tmp15_ = netsukuku_impl_linux_exec_command (_tmp14_, &_inner_error_);
				com_ret = _tmp15_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == G_SPAWN_ERROR) {
						goto __catch63_g_spawn_error;
					}
					_g_free0 (cmderr);
					_g_free0 (cmdout);
					netsukuku_impl_linux_struct_helper_ntk_linux_sequential_command_destroy (&tuple_p);
					_g_free0 (doing);
					_g_object_unref0 (ch);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				_tmp16_ = com_ret;
				_tmp17_ = _tmp16_->cmdout;
				_tmp18_ = g_strdup (_tmp17_);
				_g_free0 (cmdout);
				cmdout = _tmp18_;
				_tmp19_ = com_ret;
				_tmp20_ = _tmp19_->cmderr;
				_tmp21_ = g_strdup (_tmp20_);
				_g_free0 (cmderr);
				cmderr = _tmp21_;
				_tmp22_ = com_ret;
				_tmp23_ = _tmp22_->exit_status;
				exit_status = _tmp23_;
				_g_object_unref0 (com_ret);
			}
			goto __finally63;
			__catch63_g_spawn_error:
			{
				GError* e = NULL;
				GError* _tmp24_;
				GQuark _tmp25_;
				const gchar* _tmp26_ = NULL;
				GError* _tmp27_;
				gint _tmp28_;
				gchar* _tmp29_ = NULL;
				gchar* _tmp30_;
				GError* _tmp31_;
				const gchar* _tmp32_;
				const gchar* _tmp33_ = NULL;
				gchar* _tmp34_ = NULL;
				gchar* _tmp35_;
				gchar* x;
				const gchar* _tmp36_;
				gchar* _tmp37_;
				gchar* _tmp38_;
				e = _inner_error_;
				_inner_error_ = NULL;
				exit_status = -1;
				_tmp24_ = e;
				_tmp25_ = _tmp24_->domain;
				_tmp26_ = g_quark_to_string (_tmp25_);
				_tmp27_ = e;
				_tmp28_ = _tmp27_->code;
				_tmp29_ = g_strdup_printf ("%i", _tmp28_);
				_tmp30_ = _tmp29_;
				_tmp31_ = e;
				_tmp32_ = _tmp31_->message;
				_tmp33_ = string_to_string (_tmp32_);
				_tmp34_ = g_strconcat ("Got ", _tmp26_, " ", _tmp30_, " ", _tmp33_, NULL);
				_tmp35_ = _tmp34_;
				_g_free0 (_tmp30_);
				x = _tmp35_;
				_tmp36_ = x;
				_tmp37_ = g_strdup (_tmp36_);
				_g_free0 (cmderr);
				cmderr = _tmp37_;
				_tmp38_ = g_strdup ("");
				_g_free0 (cmdout);
				cmdout = _tmp38_;
				_g_free0 (x);
				_g_error_free0 (e);
			}
			__finally63:
			if (_inner_error_ != NULL) {
				_g_free0 (cmderr);
				_g_free0 (cmdout);
				netsukuku_impl_linux_struct_helper_ntk_linux_sequential_command_destroy (&tuple_p);
				goto __catch62_g_error;
			}
			tasklets_ms_wait ((gint64) 10);
			_tmp39_ = netsukuku_impl_linux_get_sequential_command_channel ();
			_tmp40_ = _tmp39_;
			_tmp41_ = exit_status;
			g_value_init (&_tmp42_, G_TYPE_INT);
			g_value_set_int (&_tmp42_, _tmp41_);
			tasklets_channel_send (_tmp40_, &_tmp42_);
			G_IS_VALUE (&_tmp42_) ? (g_value_unset (&_tmp42_), NULL) : NULL;
			_g_object_unref0 (_tmp40_);
			_tmp43_ = netsukuku_impl_linux_get_sequential_command_channel ();
			_tmp44_ = _tmp43_;
			_tmp45_ = cmdout;
			g_value_init (&_tmp46_, G_TYPE_STRING);
			g_value_set_string (&_tmp46_, _tmp45_);
			tasklets_channel_send (_tmp44_, &_tmp46_);
			G_IS_VALUE (&_tmp46_) ? (g_value_unset (&_tmp46_), NULL) : NULL;
			_g_object_unref0 (_tmp44_);
			_tmp47_ = netsukuku_impl_linux_get_sequential_command_channel ();
			_tmp48_ = _tmp47_;
			_tmp49_ = cmderr;
			g_value_init (&_tmp50_, G_TYPE_STRING);
			g_value_set_string (&_tmp50_, _tmp49_);
			tasklets_channel_send (_tmp48_, &_tmp50_);
			G_IS_VALUE (&_tmp50_) ? (g_value_unset (&_tmp50_), NULL) : NULL;
			_g_object_unref0 (_tmp48_);
			tasklets_tasklet_schedule (NULL);
			_g_free0 (cmderr);
			_g_free0 (cmdout);
			netsukuku_impl_linux_struct_helper_ntk_linux_sequential_command_destroy (&tuple_p);
		}
		goto __finally62;
		__catch62_g_error:
		{
			GError* e = NULL;
			GError* _tmp51_;
			const gchar* _tmp52_;
			const gchar* _tmp53_ = NULL;
			gchar* _tmp54_ = NULL;
			gchar* _tmp55_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp51_ = e;
			_tmp52_ = _tmp51_->message;
			_tmp53_ = string_to_string (_tmp52_);
			_tmp54_ = g_strconcat ("Sequential command spawning reported an error: ", _tmp53_, NULL);
			_tmp55_ = _tmp54_;
			netsukuku_log_warn (_tmp55_);
			_g_free0 (_tmp55_);
			_g_error_free0 (e);
		}
		__finally62:
		if (_inner_error_ != NULL) {
			_g_free0 (doing);
			_g_object_unref0 (ch);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp56_ = doing;
		if (_tmp56_ != NULL) {
			const gchar* _tmp57_;
			_tmp57_ = doing;
			tasklets_tasklet_declare_finished (_tmp57_);
		}
		_g_free0 (doing);
	}
	_g_object_unref0 (ch);
	return result;
}


/** Launch a process and block this tasklet till it ends.
      * Makes sure that a previous call (from any other tasklet) has been completed.
      * Returns exit status, stdout and stderr.
      */
void netsukuku_impl_linux_sequential_command (const gchar* cmdline, gchar** cmdout, gchar** cmderr, gint* exit_status) {
	gchar* _vala_cmdout = NULL;
	gchar* _vala_cmderr = NULL;
	gint _vala_exit_status = 0;
	TaskletsChannel* _tmp0_ = NULL;
	TaskletsChannel* ch;
	NetsukukuImplLinuxstruct_helper_ntk_linux_sequential_command arg = {0};
	const gchar* _tmp1_;
	gchar* _tmp2_;
	NetsukukuImplLinuxstruct_helper_ntk_linux_sequential_command _tmp3_;
	GValue _tmp4_ = {0};
	TaskletsChannel* _tmp5_ = NULL;
	TaskletsChannel* _tmp6_;
	GValue _tmp7_ = {0};
	TaskletsChannel* _tmp8_ = NULL;
	TaskletsChannel* _tmp9_;
	GValue _tmp10_ = {0};
	TaskletsChannel* _tmp11_ = NULL;
	TaskletsChannel* _tmp12_;
	GValue _tmp13_ = {0};
	g_return_if_fail (cmdline != NULL);
	_tmp0_ = tasklets_tasklet_dispatcher_get_channel_for_helper ((TaskletsSpawnable) netsukuku_impl_linux_helper_sequential_command, -1);
	ch = _tmp0_;
	memset (&arg, 0, sizeof (NetsukukuImplLinuxstruct_helper_ntk_linux_sequential_command));
	_tmp1_ = cmdline;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (arg.cmdline);
	arg.cmdline = _tmp2_;
	_tmp3_ = arg;
	g_value_init (&_tmp4_, NETSUKUKU_IMPL_LINUX_TYPE_STRUCT_HELPER_NTK_LINUX_SEQUENTIAL_COMMAND);
	g_value_set_boxed (&_tmp4_, &_tmp3_);
	tasklets_channel_send (ch, &_tmp4_);
	G_IS_VALUE (&_tmp4_) ? (g_value_unset (&_tmp4_), NULL) : NULL;
	_tmp5_ = netsukuku_impl_linux_get_sequential_command_channel ();
	_tmp6_ = _tmp5_;
	tasklets_channel_recv (_tmp6_, &_tmp7_);
	_vala_exit_status = g_value_get_int (&_tmp7_);
	_g_object_unref0 (_tmp6_);
	_tmp8_ = netsukuku_impl_linux_get_sequential_command_channel ();
	_tmp9_ = _tmp8_;
	tasklets_channel_recv (_tmp9_, &_tmp10_);
	_g_free0 (_vala_cmdout);
	_vala_cmdout = g_value_get_string (&_tmp10_);
	_g_object_unref0 (_tmp9_);
	_tmp11_ = netsukuku_impl_linux_get_sequential_command_channel ();
	_tmp12_ = _tmp11_;
	tasklets_channel_recv (_tmp12_, &_tmp13_);
	_g_free0 (_vala_cmderr);
	_vala_cmderr = g_value_get_string (&_tmp13_);
	_g_object_unref0 (_tmp12_);
	netsukuku_impl_linux_struct_helper_ntk_linux_sequential_command_destroy (&arg);
	_g_object_unref0 (ch);
	if (cmdout) {
		*cmdout = _vala_cmdout;
	} else {
		_g_free0 (_vala_cmdout);
	}
	if (cmderr) {
		*cmderr = _vala_cmderr;
	} else {
		_g_free0 (_vala_cmderr);
	}
	if (exit_status) {
		*exit_status = _vala_exit_status;
	}
}


GQuark netsukuku_impl_linux_iproute_command_error_quark (void) {
	return g_quark_from_static_string ("netsukuku_impl_linux_iproute_command_error-quark");
}


/** An iproute wrapper
      */
gchar* netsukuku_impl_linux_iproute (const gchar* args, GError** error) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* cmd;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	gboolean _tmp6_;
	gchar* cmdout = NULL;
	gchar* cmderr = NULL;
	gint exit_status = 0;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	gint _tmp20_ = 0;
	gint _tmp21_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (args != NULL, NULL);
	_tmp0_ = netsukuku_settings_get_IPROUTE_PATH ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup (_tmp1_);
	cmd = _tmp2_;
	_tmp4_ = cmd;
	if (_tmp4_ == NULL) {
		_tmp3_ = TRUE;
	} else {
		const gchar* _tmp5_;
		_tmp5_ = cmd;
		_tmp3_ = g_strcmp0 (_tmp5_, "") == 0;
	}
	_tmp6_ = _tmp3_;
	if (_tmp6_) {
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp7_ = netsukuku_settings_get_IPROUTE_PATH ();
		_tmp8_ = _tmp7_;
		netsukuku_settings_set_IPROUTE_PATH ("ip");
		_tmp9_ = netsukuku_settings_get_IPROUTE_PATH ();
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strdup (_tmp10_);
		_g_free0 (cmd);
		cmd = _tmp11_;
	}
	_tmp12_ = cmd;
	_tmp13_ = g_strconcat (_tmp12_, " ", NULL);
	_tmp14_ = _tmp13_;
	_tmp15_ = args;
	_tmp16_ = g_strconcat (_tmp14_, _tmp15_, NULL);
	_tmp17_ = _tmp16_;
	netsukuku_impl_linux_sequential_command (_tmp17_, &_tmp18_, &_tmp19_, &_tmp20_);
	_g_free0 (cmdout);
	cmdout = _tmp18_;
	_g_free0 (cmderr);
	cmderr = _tmp19_;
	exit_status = _tmp20_;
	_g_free0 (_tmp17_);
	_g_free0 (_tmp14_);
	_tmp21_ = exit_status;
	if (_tmp21_ != 0) {
		const gchar* _tmp22_;
		GError* _tmp23_;
		_tmp22_ = cmderr;
		_tmp23_ = g_error_new_literal (NETSUKUKU_IMPL_LINUX_IPROUTE_COMMAND_ERROR, NETSUKUKU_IMPL_LINUX_IPROUTE_COMMAND_ERROR_GENERIC, _tmp22_);
		_inner_error_ = _tmp23_;
		if (_inner_error_->domain == NETSUKUKU_IMPL_LINUX_IPROUTE_COMMAND_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (cmderr);
			_g_free0 (cmdout);
			_g_free0 (cmd);
			return NULL;
		} else {
			_g_free0 (cmderr);
			_g_free0 (cmdout);
			_g_free0 (cmd);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = cmdout;
	_g_free0 (cmderr);
	_g_free0 (cmd);
	return result;
}


/** An iproute without exceptions
      */
void netsukuku_impl_linux_iproute_exp (const gchar* args) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (args != NULL);
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		_tmp0_ = args;
		_tmp1_ = netsukuku_impl_linux_iproute (_tmp0_, &_inner_error_);
		_tmp2_ = _tmp1_;
		_g_free0 (_tmp2_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == NETSUKUKU_IMPL_LINUX_IPROUTE_COMMAND_ERROR) {
				goto __catch64_netsukuku_impl_linux_iproute_command_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally64;
	__catch64_netsukuku_impl_linux_iproute_command_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		_tmp5_ = string_to_string (_tmp4_);
		_tmp6_ = g_strconcat ("Iproute: Got following exception, but proceeding anyway: ", _tmp5_, NULL);
		_tmp7_ = _tmp6_;
		netsukuku_log_warn (_tmp7_);
		_g_free0 (_tmp7_);
		_g_error_free0 (e);
	}
	__finally64:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


GQuark netsukuku_impl_linux_iptables_command_error_quark (void) {
	return g_quark_from_static_string ("netsukuku_impl_linux_iptables_command_error-quark");
}


/** An iptables wrapper
      */
gchar* netsukuku_impl_linux_iptables (const gchar* args, GError** error) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* cmd;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	gboolean _tmp6_;
	gchar* cmdout = NULL;
	gchar* cmderr = NULL;
	gint exit_status = 0;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	gint _tmp20_ = 0;
	gint _tmp21_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (args != NULL, NULL);
	_tmp0_ = netsukuku_settings_get_IPTABLES_PATH ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup (_tmp1_);
	cmd = _tmp2_;
	_tmp4_ = cmd;
	if (_tmp4_ == NULL) {
		_tmp3_ = TRUE;
	} else {
		const gchar* _tmp5_;
		_tmp5_ = cmd;
		_tmp3_ = g_strcmp0 (_tmp5_, "") == 0;
	}
	_tmp6_ = _tmp3_;
	if (_tmp6_) {
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp7_ = netsukuku_settings_get_IPTABLES_PATH ();
		_tmp8_ = _tmp7_;
		netsukuku_settings_set_IPTABLES_PATH ("iptables");
		_tmp9_ = netsukuku_settings_get_IPTABLES_PATH ();
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strdup (_tmp10_);
		_g_free0 (cmd);
		cmd = _tmp11_;
	}
	_tmp12_ = cmd;
	_tmp13_ = g_strconcat (_tmp12_, " ", NULL);
	_tmp14_ = _tmp13_;
	_tmp15_ = args;
	_tmp16_ = g_strconcat (_tmp14_, _tmp15_, NULL);
	_tmp17_ = _tmp16_;
	netsukuku_impl_linux_sequential_command (_tmp17_, &_tmp18_, &_tmp19_, &_tmp20_);
	_g_free0 (cmdout);
	cmdout = _tmp18_;
	_g_free0 (cmderr);
	cmderr = _tmp19_;
	exit_status = _tmp20_;
	_g_free0 (_tmp17_);
	_g_free0 (_tmp14_);
	_tmp21_ = exit_status;
	if (_tmp21_ != 0) {
		const gchar* _tmp22_;
		GError* _tmp23_;
		_tmp22_ = cmderr;
		_tmp23_ = g_error_new_literal (NETSUKUKU_IMPL_LINUX_IPTABLES_COMMAND_ERROR, NETSUKUKU_IMPL_LINUX_IPTABLES_COMMAND_ERROR_GENERIC, _tmp22_);
		_inner_error_ = _tmp23_;
		if (_inner_error_->domain == NETSUKUKU_IMPL_LINUX_IPTABLES_COMMAND_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (cmderr);
			_g_free0 (cmdout);
			_g_free0 (cmd);
			return NULL;
		} else {
			_g_free0 (cmderr);
			_g_free0 (cmdout);
			_g_free0 (cmd);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = cmdout;
	_g_free0 (cmderr);
	_g_free0 (cmd);
	return result;
}


/** An iptables without exceptions
      */
void netsukuku_impl_linux_iptables_exp (const gchar* args) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (args != NULL);
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		_tmp0_ = args;
		_tmp1_ = netsukuku_impl_linux_iptables (_tmp0_, &_inner_error_);
		_tmp2_ = _tmp1_;
		_g_free0 (_tmp2_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == NETSUKUKU_IMPL_LINUX_IPTABLES_COMMAND_ERROR) {
				goto __catch65_netsukuku_impl_linux_iptables_command_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally65;
	__catch65_netsukuku_impl_linux_iptables_command_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		_tmp5_ = string_to_string (_tmp4_);
		_tmp6_ = g_strconcat ("Iptables: Got following exception, but proceeding anyway: ", _tmp5_, NULL);
		_tmp7_ = _tmp6_;
		netsukuku_log_warn (_tmp7_);
		_g_free0 (_tmp7_);
		_g_error_free0 (e);
	}
	__finally65:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


/** Check reachability of an IP
      */
gboolean netsukuku_impl_linux_check_ping (const gchar* ipstr) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* cmd;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	gboolean _tmp6_;
	gint exit_status = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (ipstr != NULL, FALSE);
	_tmp0_ = netsukuku_settings_get_PING_PATH ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup (_tmp1_);
	cmd = _tmp2_;
	_tmp4_ = cmd;
	if (_tmp4_ == NULL) {
		_tmp3_ = TRUE;
	} else {
		const gchar* _tmp5_;
		_tmp5_ = cmd;
		_tmp3_ = g_strcmp0 (_tmp5_, "") == 0;
	}
	_tmp6_ = _tmp3_;
	if (_tmp6_) {
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp7_ = netsukuku_settings_get_PING_PATH ();
		_tmp8_ = _tmp7_;
		netsukuku_settings_set_PING_PATH ("ping");
		_tmp9_ = netsukuku_settings_get_PING_PATH ();
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strdup (_tmp10_);
		_g_free0 (cmd);
		cmd = _tmp11_;
	}
	{
		const gchar* _tmp12_;
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_;
		const gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_;
		TaskletsCommandResult* _tmp18_ = NULL;
		TaskletsCommandResult* _tmp19_;
		TaskletsCommandResult* com_ret;
		gint _tmp20_;
		_tmp12_ = cmd;
		_tmp13_ = string_to_string (_tmp12_);
		_tmp14_ = ipstr;
		_tmp15_ = string_to_string (_tmp14_);
		_tmp16_ = g_strconcat (_tmp13_, " -c 1 ", _tmp15_, " -W 1", NULL);
		_tmp17_ = _tmp16_;
		_tmp18_ = netsukuku_impl_linux_exec_command (_tmp17_, &_inner_error_);
		_tmp19_ = _tmp18_;
		_g_free0 (_tmp17_);
		com_ret = _tmp19_;
		if (_inner_error_ != NULL) {
			goto __catch66_g_error;
		}
		_tmp20_ = com_ret->exit_status;
		exit_status = _tmp20_;
		_g_object_unref0 (com_ret);
	}
	goto __finally66;
	__catch66_g_error:
	{
		GError* e = NULL;
		GQuark _tmp21_;
		const gchar* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		gint _tmp24_;
		gchar* _tmp25_ = NULL;
		gchar* _tmp26_;
		const gchar* _tmp27_;
		const gchar* _tmp28_ = NULL;
		gchar* _tmp29_ = NULL;
		gchar* _tmp30_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp21_ = e->domain;
		_tmp22_ = g_quark_to_string (_tmp21_);
		_tmp23_ = string_to_string (_tmp22_);
		_tmp24_ = e->code;
		_tmp25_ = g_strdup_printf ("%i", _tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = e->message;
		_tmp28_ = string_to_string (_tmp27_);
		_tmp29_ = g_strconcat ("linux: check_ping: ", _tmp23_, " ", _tmp26_, " ", _tmp28_, NULL);
		_tmp30_ = _tmp29_;
		g_error ("network_linux.vala:235: %s", _tmp30_);
		_g_free0 (_tmp30_);
		_g_free0 (_tmp26_);
		_g_error_free0 (e);
	}
	__finally66:
	if (_inner_error_ != NULL) {
		_g_free0 (cmd);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = exit_status == 0;
	_g_free0 (cmd);
	return result;
}


void netsukuku_impl_linux_write_file (const gchar* pathname, guint8* buf, int buf_length1) {
	const gchar* _tmp0_;
	FILE* _tmp1_ = NULL;
	FILE* fout;
	FILE* _tmp2_;
	FILE* _tmp8_;
	guint8* _tmp9_;
	gint _tmp9__length1;
	g_return_if_fail (pathname != NULL);
	_tmp0_ = pathname;
	_tmp1_ = g_fopen (_tmp0_, "w");
	fout = _tmp1_;
	_tmp2_ = fout;
	if (_tmp2_ == NULL) {
		gint _tmp3_;
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		_tmp3_ = errno;
		_tmp4_ = g_strerror (_tmp3_);
		_tmp5_ = string_to_string (_tmp4_);
		_tmp6_ = g_strconcat ("linux: write_file: ", _tmp5_, NULL);
		_tmp7_ = _tmp6_;
		netsukuku_log_error (_tmp7_);
		_g_free0 (_tmp7_);
		_vala_assert (FALSE, "false");
	}
	_tmp8_ = fout;
	_tmp9_ = buf;
	_tmp9__length1 = buf_length1;
	fwrite (_tmp9_, (gsize) 1, _tmp9__length1, _tmp8_);
	_fclose0 (fout);
}


guint8* netsukuku_impl_linux_read_file (const gchar* pathname, gint maxlen, int* result_length1) {
	guint8* result = NULL;
	gint _tmp0_;
	guint8* _tmp1_ = NULL;
	guint8* buf;
	gint buf_length1;
	gint _buf_size_;
	const gchar* _tmp2_;
	FILE* _tmp3_ = NULL;
	FILE* fin;
	FILE* _tmp4_;
	FILE* _tmp6_;
	guint8* _tmp7_;
	gint _tmp7__length1;
	gsize _tmp8_ = 0UL;
	gsize len;
	gsize _tmp9_;
	guint8* _tmp10_ = NULL;
	guint8* ret;
	gint ret_length1;
	gint _ret_size_;
	guint8* _tmp22_;
	gint _tmp22__length1;
	g_return_val_if_fail (pathname != NULL, NULL);
	_tmp0_ = maxlen;
	_tmp1_ = g_new0 (guint8, _tmp0_);
	buf = _tmp1_;
	buf_length1 = _tmp0_;
	_buf_size_ = buf_length1;
	_tmp2_ = pathname;
	_tmp3_ = g_fopen (_tmp2_, "r");
	fin = _tmp3_;
	_tmp4_ = fin;
	if (_tmp4_ == NULL) {
		guint8* _tmp5_;
		gint _tmp5__length1;
		_tmp5_ = NULL;
		_tmp5__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp5__length1;
		}
		result = _tmp5_;
		_fclose0 (fin);
		buf = (g_free (buf), NULL);
		return result;
	}
	_tmp6_ = fin;
	_tmp7_ = buf;
	_tmp7__length1 = buf_length1;
	_tmp8_ = fread (_tmp7_, (gsize) 1, _tmp7__length1, _tmp6_);
	len = _tmp8_;
	_tmp9_ = len;
	_tmp10_ = g_new0 (guint8, _tmp9_);
	ret = _tmp10_;
	ret_length1 = _tmp9_;
	_ret_size_ = ret_length1;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp11_;
			_tmp11_ = TRUE;
			while (TRUE) {
				gboolean _tmp12_;
				gint _tmp14_;
				gsize _tmp15_;
				guint8* _tmp16_;
				gint _tmp16__length1;
				gint _tmp17_;
				guint8* _tmp18_;
				gint _tmp18__length1;
				gint _tmp19_;
				guint8 _tmp20_;
				guint8 _tmp21_;
				_tmp12_ = _tmp11_;
				if (!_tmp12_) {
					gint _tmp13_;
					_tmp13_ = i;
					i = _tmp13_ + 1;
				}
				_tmp11_ = FALSE;
				_tmp14_ = i;
				_tmp15_ = len;
				if (!(((gsize) _tmp14_) < _tmp15_)) {
					break;
				}
				_tmp16_ = ret;
				_tmp16__length1 = ret_length1;
				_tmp17_ = i;
				_tmp18_ = buf;
				_tmp18__length1 = buf_length1;
				_tmp19_ = i;
				_tmp20_ = _tmp18_[_tmp19_];
				_tmp16_[_tmp17_] = _tmp20_;
				_tmp21_ = _tmp16_[_tmp17_];
			}
		}
	}
	_tmp22_ = ret;
	_tmp22__length1 = ret_length1;
	if (result_length1) {
		*result_length1 = _tmp22__length1;
	}
	result = _tmp22_;
	_fclose0 (fin);
	buf = (g_free (buf), NULL);
	return result;
}


static NetsukukuNIC* _netsukuku_impl_linux_linux_nic_create (const gchar* nic_name) {
	NetsukukuNIC* result = NULL;
	const gchar* _tmp0_;
	NetsukukuImplLinuxLinuxNIC* _tmp1_;
	g_return_val_if_fail (nic_name != NULL, NULL);
	_tmp0_ = nic_name;
	_tmp1_ = netsukuku_impl_linux_linux_nic_new (_tmp0_);
	result = (NetsukukuNIC*) _tmp1_;
	return result;
}


static NetsukukuNIC* __netsukuku_impl_linux_linux_nic_create_netsukuku_create_nic_delegate (const gchar* nic_name, gpointer self) {
	NetsukukuNIC* result;
	result = _netsukuku_impl_linux_linux_nic_create (nic_name);
	return result;
}


void netsukuku_impl_linux_linux_nic_register (void) {
	netsukuku_nic_register_class ("linux", __netsukuku_impl_linux_linux_nic_create_netsukuku_create_nic_delegate, NULL);
}


NetsukukuImplLinuxLinuxNIC* netsukuku_impl_linux_linux_nic_construct (GType object_type, const gchar* nic_name) {
	NetsukukuImplLinuxLinuxNIC * self = NULL;
	const gchar* _tmp0_;
	g_return_val_if_fail (nic_name != NULL, NULL);
	_tmp0_ = nic_name;
	self = (NetsukukuImplLinuxLinuxNIC*) netsukuku_nic_construct (object_type, _tmp0_);
	_g_free0 (self->priv->_mac);
	self->priv->_mac = NULL;
	return self;
}


NetsukukuImplLinuxLinuxNIC* netsukuku_impl_linux_linux_nic_new (const gchar* nic_name) {
	return netsukuku_impl_linux_linux_nic_construct (NETSUKUKU_IMPL_LINUX_TYPE_LINUX_NIC, nic_name);
}


static const gchar* netsukuku_impl_linux_linux_nic_real__mac_getter (NetsukukuNIC* base) {
	NetsukukuImplLinuxLinuxNIC * self;
	const gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp13_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuImplLinuxLinuxNIC*) base;
	_tmp0_ = self->priv->_mac;
	if (_tmp0_ == NULL) {
		{
			GRegex* _tmp1_;
			GRegex* r;
			const gchar* _tmp2_;
			const gchar* _tmp3_ = NULL;
			gchar* _tmp4_ = NULL;
			gchar* _tmp5_;
			gchar* _tmp6_ = NULL;
			gchar* _tmp7_;
			gchar* cmdout;
			GMatchInfo* match_info = NULL;
			GRegex* _tmp8_;
			const gchar* _tmp9_;
			GMatchInfo* _tmp10_ = NULL;
			GMatchInfo* _tmp11_;
			gchar* _tmp12_ = NULL;
			_tmp1_ = g_regex_new ("([a-fA-F0-9]{2}[:|\\-]?){6}", 0, 0, &_inner_error_);
			r = _tmp1_;
			if (_inner_error_ != NULL) {
				goto __catch67_g_error;
			}
			_tmp2_ = ((NetsukukuNIC*) self)->name;
			_tmp3_ = string_to_string (_tmp2_);
			_tmp4_ = g_strconcat ("link show ", _tmp3_, NULL);
			_tmp5_ = _tmp4_;
			_tmp6_ = netsukuku_impl_linux_iproute (_tmp5_, &_inner_error_);
			_tmp7_ = _tmp6_;
			_g_free0 (_tmp5_);
			cmdout = _tmp7_;
			if (_inner_error_ != NULL) {
				_g_regex_unref0 (r);
				goto __catch67_g_error;
			}
			_tmp8_ = r;
			_tmp9_ = cmdout;
			g_regex_match (_tmp8_, _tmp9_, 0, &_tmp10_);
			_g_match_info_free0 (match_info);
			match_info = _tmp10_;
			_tmp11_ = match_info;
			_tmp12_ = g_match_info_fetch (_tmp11_, 0);
			_g_free0 (self->priv->_mac);
			self->priv->_mac = _tmp12_;
			_g_match_info_free0 (match_info);
			_g_free0 (cmdout);
			_g_regex_unref0 (r);
		}
		goto __finally67;
		__catch67_g_error:
		{
			GError* e = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_g_error_free0 (e);
		}
		__finally67:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp13_ = self->priv->_mac;
	result = _tmp13_;
	return result;
}


static gboolean netsukuku_impl_linux_linux_nic_real__is_active_getter (NetsukukuNIC* base) {
	NetsukukuImplLinuxLinuxNIC * self;
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	self = (NetsukukuImplLinuxLinuxNIC*) base;
	{
		GRegex* _tmp0_;
		GRegex* r2;
		const gchar* _tmp1_;
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		gchar* cmdout;
		GRegex* _tmp7_;
		const gchar* _tmp8_;
		gboolean _tmp9_ = FALSE;
		_tmp0_ = g_regex_new ("<.*,(UP),.*>", 0, 0, &_inner_error_);
		r2 = _tmp0_;
		if (_inner_error_ != NULL) {
			goto __catch68_g_error;
		}
		_tmp1_ = ((NetsukukuNIC*) self)->name;
		_tmp2_ = string_to_string (_tmp1_);
		_tmp3_ = g_strconcat ("link show ", _tmp2_, NULL);
		_tmp4_ = _tmp3_;
		_tmp5_ = netsukuku_impl_linux_iproute (_tmp4_, &_inner_error_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		cmdout = _tmp6_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (r2);
			goto __catch68_g_error;
		}
		_tmp7_ = r2;
		_tmp8_ = cmdout;
		_tmp9_ = g_regex_match (_tmp7_, _tmp8_, 0, NULL);
		result = _tmp9_;
		_g_free0 (cmdout);
		_g_regex_unref0 (r2);
		return result;
	}
	goto __finally68;
	__catch68_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally68:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = FALSE;
	return result;
}


static void netsukuku_impl_linux_linux_nic_real__up (NetsukukuNIC* base) {
	NetsukukuImplLinuxLinuxNIC * self;
	GError * _inner_error_ = NULL;
	self = (NetsukukuImplLinuxLinuxNIC*) base;
	{
		const gchar* _tmp0_;
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		_tmp0_ = ((NetsukukuNIC*) self)->name;
		_tmp1_ = string_to_string (_tmp0_);
		_tmp2_ = g_strconcat ("link set ", _tmp1_, " up", NULL);
		_tmp3_ = _tmp2_;
		_tmp4_ = netsukuku_impl_linux_iproute (_tmp3_, &_inner_error_);
		_tmp5_ = _tmp4_;
		_g_free0 (_tmp5_);
		_g_free0 (_tmp3_);
		if (_inner_error_ != NULL) {
			goto __catch69_g_error;
		}
	}
	goto __finally69;
	__catch69_g_error:
	{
		GError* e = NULL;
		GQuark _tmp6_;
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		gint _tmp9_;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = e->domain;
		_tmp7_ = g_quark_to_string (_tmp6_);
		_tmp8_ = string_to_string (_tmp7_);
		_tmp9_ = e->code;
		_tmp10_ = g_strdup_printf ("%i", _tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = e->message;
		_tmp13_ = string_to_string (_tmp12_);
		_tmp14_ = g_strconcat ("LinuxNIC: _up: ", _tmp8_, " ", _tmp11_, " ", _tmp13_, NULL);
		_tmp15_ = _tmp14_;
		g_error ("network_linux.vala:310: %s", _tmp15_);
		_g_free0 (_tmp15_);
		_g_free0 (_tmp11_);
		_g_error_free0 (e);
	}
	__finally69:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void netsukuku_impl_linux_linux_nic_real__down (NetsukukuNIC* base) {
	NetsukukuImplLinuxLinuxNIC * self;
	GError * _inner_error_ = NULL;
	self = (NetsukukuImplLinuxLinuxNIC*) base;
	{
		const gchar* _tmp0_;
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		_tmp0_ = ((NetsukukuNIC*) self)->name;
		_tmp1_ = string_to_string (_tmp0_);
		_tmp2_ = g_strconcat ("link set ", _tmp1_, " down", NULL);
		_tmp3_ = _tmp2_;
		_tmp4_ = netsukuku_impl_linux_iproute (_tmp3_, &_inner_error_);
		_tmp5_ = _tmp4_;
		_g_free0 (_tmp5_);
		_g_free0 (_tmp3_);
		if (_inner_error_ != NULL) {
			goto __catch70_g_error;
		}
	}
	goto __finally70;
	__catch70_g_error:
	{
		GError* e = NULL;
		GQuark _tmp6_;
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		gint _tmp9_;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = e->domain;
		_tmp7_ = g_quark_to_string (_tmp6_);
		_tmp8_ = string_to_string (_tmp7_);
		_tmp9_ = e->code;
		_tmp10_ = g_strdup_printf ("%i", _tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = e->message;
		_tmp13_ = string_to_string (_tmp12_);
		_tmp14_ = g_strconcat ("LinuxNIC: _down: ", _tmp8_, " ", _tmp11_, " ", _tmp13_, NULL);
		_tmp15_ = _tmp14_;
		g_error ("network_linux.vala:318: %s", _tmp15_);
		_g_free0 (_tmp15_);
		_g_free0 (_tmp11_);
		_g_error_free0 (e);
	}
	__finally70:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void netsukuku_impl_linux_linux_nic_real__add_address (NetsukukuNIC* base, const gchar* address) {
	NetsukukuImplLinuxLinuxNIC * self;
	GError * _inner_error_ = NULL;
	self = (NetsukukuImplLinuxLinuxNIC*) base;
	g_return_if_fail (address != NULL);
	{
		const gchar* _tmp0_;
		const gchar* _tmp1_ = NULL;
		const gchar* _tmp2_;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		_tmp0_ = address;
		_tmp1_ = string_to_string (_tmp0_);
		_tmp2_ = ((NetsukukuNIC*) self)->name;
		_tmp3_ = string_to_string (_tmp2_);
		_tmp4_ = g_strconcat ("addr add ", _tmp1_, " dev ", _tmp3_, NULL);
		_tmp5_ = _tmp4_;
		_tmp6_ = netsukuku_impl_linux_iproute (_tmp5_, &_inner_error_);
		_tmp7_ = _tmp6_;
		_g_free0 (_tmp7_);
		_g_free0 (_tmp5_);
		if (_inner_error_ != NULL) {
			goto __catch71_g_error;
		}
	}
	goto __finally71;
	__catch71_g_error:
	{
		GError* e = NULL;
		GQuark _tmp8_;
		const gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		gint _tmp11_;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp8_ = e->domain;
		_tmp9_ = g_quark_to_string (_tmp8_);
		_tmp10_ = string_to_string (_tmp9_);
		_tmp11_ = e->code;
		_tmp12_ = g_strdup_printf ("%i", _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = e->message;
		_tmp15_ = string_to_string (_tmp14_);
		_tmp16_ = g_strconcat ("LinuxNIC: _add_address: ", _tmp10_, " ", _tmp13_, " ", _tmp15_, NULL);
		_tmp17_ = _tmp16_;
		g_error ("network_linux.vala:326: %s", _tmp17_);
		_g_free0 (_tmp17_);
		_g_free0 (_tmp13_);
		_g_error_free0 (e);
	}
	__finally71:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void netsukuku_impl_linux_linux_nic_real__remove_address (NetsukukuNIC* base, const gchar* address) {
	NetsukukuImplLinuxLinuxNIC * self;
	GError * _inner_error_ = NULL;
	self = (NetsukukuImplLinuxLinuxNIC*) base;
	g_return_if_fail (address != NULL);
	{
		const gchar* _tmp0_;
		const gchar* _tmp1_ = NULL;
		const gchar* _tmp2_;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		_tmp0_ = address;
		_tmp1_ = string_to_string (_tmp0_);
		_tmp2_ = ((NetsukukuNIC*) self)->name;
		_tmp3_ = string_to_string (_tmp2_);
		_tmp4_ = g_strconcat ("addr del ", _tmp1_, "/32 dev ", _tmp3_, NULL);
		_tmp5_ = _tmp4_;
		netsukuku_impl_linux_iproute_exp (_tmp5_);
		_g_free0 (_tmp5_);
	}
	goto __finally72;
	__catch72_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		GQuark _tmp7_;
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		GError* _tmp10_;
		gint _tmp11_;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_;
		GError* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->domain;
		_tmp8_ = g_quark_to_string (_tmp7_);
		_tmp9_ = string_to_string (_tmp8_);
		_tmp10_ = e;
		_tmp11_ = _tmp10_->code;
		_tmp12_ = g_strdup_printf ("%i", _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		_tmp16_ = string_to_string (_tmp15_);
		_tmp17_ = g_strconcat ("LinuxNIC: _remove_address: ", _tmp9_, " ", _tmp13_, " ", _tmp16_, NULL);
		_tmp18_ = _tmp17_;
		g_error ("network_linux.vala:334: %s", _tmp18_);
		_g_free0 (_tmp18_);
		_g_free0 (_tmp13_);
		_g_error_free0 (e);
	}
	__finally72:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res_length1;
	_tmp3_ = res;
	_tmp3__length1 = res_length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


static void netsukuku_impl_linux_linux_nic_real__disable_filtering (NetsukukuNIC* base) {
	NetsukukuImplLinuxLinuxNIC * self;
	gchar* _tmp0_;
	gchar* path0;
	const gchar* _tmp1_;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* path1;
	gchar* _tmp4_;
	gchar* content;
	GError * _inner_error_ = NULL;
	self = (NetsukukuImplLinuxLinuxNIC*) base;
	_tmp0_ = g_strdup ("/proc/sys/net/ipv4/conf/all/rp_filter");
	path0 = _tmp0_;
	_tmp1_ = ((NetsukukuNIC*) self)->name;
	_tmp2_ = string_to_string (_tmp1_);
	_tmp3_ = g_strconcat ("/proc/sys/net/ipv4/conf/", _tmp2_, "/rp_filter", NULL);
	path1 = _tmp3_;
	_tmp4_ = g_strdup ("0");
	content = _tmp4_;
	{
		guint8* _tmp5_;
		gint _tmp5__length1;
		guint8* _tmp6_;
		gint _tmp6__length1;
		_tmp5_ = string_get_data (content, &_tmp5__length1);
		_tmp6_ = _tmp5_;
		_tmp6__length1 = _tmp5__length1;
		netsukuku_impl_linux_write_file (path0, _tmp6_, _tmp6__length1);
	}
	goto __finally73;
	__catch73_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = string_to_string (content);
		_tmp8_ = string_to_string (path0);
		_tmp9_ = g_strconcat ("rp_filter: error (ignored) writing '", _tmp7_, "' in '", _tmp8_, "'", NULL);
		_tmp10_ = _tmp9_;
		netsukuku_log_error (_tmp10_);
		_g_free0 (_tmp10_);
		_g_error_free0 (e);
	}
	__finally73:
	if (_inner_error_ != NULL) {
		_g_free0 (content);
		_g_free0 (path1);
		_g_free0 (path0);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	{
		guint8* _tmp11_;
		gint _tmp11__length1;
		guint8* _tmp12_;
		gint _tmp12__length1;
		_tmp11_ = string_get_data (content, &_tmp11__length1);
		_tmp12_ = _tmp11_;
		_tmp12__length1 = _tmp11__length1;
		netsukuku_impl_linux_write_file (path0, _tmp12_, _tmp12__length1);
	}
	goto __finally74;
	__catch74_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp13_ = string_to_string (content);
		_tmp14_ = string_to_string (path1);
		_tmp15_ = g_strconcat ("rp_filter: error (ignored) writing '", _tmp13_, "' in '", _tmp14_, "'", NULL);
		_tmp16_ = _tmp15_;
		netsukuku_log_error (_tmp16_);
		_g_free0 (_tmp16_);
		_g_error_free0 (e);
	}
	__finally74:
	if (_inner_error_ != NULL) {
		_g_free0 (content);
		_g_free0 (path1);
		_g_free0 (path0);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (content);
	_g_free0 (path1);
	_g_free0 (path0);
}


static void netsukuku_impl_linux_linux_nic_class_init (NetsukukuImplLinuxLinuxNICClass * klass) {
	netsukuku_impl_linux_linux_nic_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (NetsukukuImplLinuxLinuxNICPrivate));
	NETSUKUKU_NIC_CLASS (klass)->_mac_getter = netsukuku_impl_linux_linux_nic_real__mac_getter;
	NETSUKUKU_NIC_CLASS (klass)->_is_active_getter = netsukuku_impl_linux_linux_nic_real__is_active_getter;
	NETSUKUKU_NIC_CLASS (klass)->_up = netsukuku_impl_linux_linux_nic_real__up;
	NETSUKUKU_NIC_CLASS (klass)->_down = netsukuku_impl_linux_linux_nic_real__down;
	NETSUKUKU_NIC_CLASS (klass)->_add_address = netsukuku_impl_linux_linux_nic_real__add_address;
	NETSUKUKU_NIC_CLASS (klass)->_remove_address = netsukuku_impl_linux_linux_nic_real__remove_address;
	NETSUKUKU_NIC_CLASS (klass)->_disable_filtering = netsukuku_impl_linux_linux_nic_real__disable_filtering;
	G_OBJECT_CLASS (klass)->finalize = netsukuku_impl_linux_linux_nic_finalize;
}


static void netsukuku_impl_linux_linux_nic_instance_init (NetsukukuImplLinuxLinuxNIC * self) {
	self->priv = NETSUKUKU_IMPL_LINUX_LINUX_NIC_GET_PRIVATE (self);
}


static void netsukuku_impl_linux_linux_nic_finalize (GObject* obj) {
	NetsukukuImplLinuxLinuxNIC * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_IMPL_LINUX_TYPE_LINUX_NIC, NetsukukuImplLinuxLinuxNIC);
	_g_free0 (self->priv->_mac);
	G_OBJECT_CLASS (netsukuku_impl_linux_linux_nic_parent_class)->finalize (obj);
}


GType netsukuku_impl_linux_linux_nic_get_type (void) {
	static volatile gsize netsukuku_impl_linux_linux_nic_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_impl_linux_linux_nic_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuImplLinuxLinuxNICClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_impl_linux_linux_nic_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuImplLinuxLinuxNIC), 0, (GInstanceInitFunc) netsukuku_impl_linux_linux_nic_instance_init, NULL };
		GType netsukuku_impl_linux_linux_nic_type_id;
		netsukuku_impl_linux_linux_nic_type_id = g_type_register_static (NETSUKUKU_TYPE_NIC, "NetsukukuImplLinuxLinuxNIC", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_impl_linux_linux_nic_type_id__volatile, netsukuku_impl_linux_linux_nic_type_id);
	}
	return netsukuku_impl_linux_linux_nic_type_id__volatile;
}


/** Initialize linux policy routing db.
      */
static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


void netsukuku_impl_linux_init_prdb (void) {
	GError * _inner_error_ = NULL;
	{
		GRegex* _tmp0_;
		gchar* _tmp3_;
		gchar* conf;
		GFile* _tmp4_ = NULL;
		GFile* ftable;
		gchar* rt_table_content = NULL;
		guint8* rt_table_content_arr = NULL;
		gint rt_table_content_arr_length1 = 0;
		gint _rt_table_content_arr_size_ = 0;
		GFile* _tmp5_;
		guint8* _tmp6_ = NULL;
		gsize _tmp7_;
		guint8* _tmp8_;
		gint _tmp8__length1;
		gchar* _tmp9_;
		GRegex* _tmp10_;
		const gchar* _tmp11_;
		gboolean _tmp12_ = FALSE;
		gchar* _tmp36_ = NULL;
		gchar* pres;
		const gchar* _tmp37_;
		gboolean _tmp38_ = FALSE;
		_tmp0_ = netsukuku_impl_linux_NTK_IN_RT_TABLE;
		if (_tmp0_ == NULL) {
			GRegex* _tmp1_;
			GRegex* _tmp2_;
			_tmp1_ = g_regex_new ("\\d+\\s+ntk", 0, 0, &_inner_error_);
			_tmp2_ = _tmp1_;
			if (_inner_error_ != NULL) {
				goto __catch75_g_error;
			}
			_g_regex_unref0 (netsukuku_impl_linux_NTK_IN_RT_TABLE);
			netsukuku_impl_linux_NTK_IN_RT_TABLE = _tmp2_;
		}
		_tmp3_ = g_strdup ("");
		conf = _tmp3_;
		_tmp4_ = g_file_new_for_commandline_arg (NETSUKUKU_IMPL_LINUX_RT_TABLE);
		ftable = _tmp4_;
		_tmp5_ = ftable;
		g_file_load_contents (_tmp5_, NULL, &_tmp6_, &_tmp7_, NULL, &_inner_error_);
		rt_table_content_arr = (g_free (rt_table_content_arr), NULL);
		rt_table_content_arr = _tmp6_;
		rt_table_content_arr_length1 = _tmp7_;
		_rt_table_content_arr_size_ = rt_table_content_arr_length1;
		if (_inner_error_ != NULL) {
			rt_table_content_arr = (g_free (rt_table_content_arr), NULL);
			_g_free0 (rt_table_content);
			_g_object_unref0 (ftable);
			_g_free0 (conf);
			goto __catch75_g_error;
		}
		_tmp8_ = rt_table_content_arr;
		_tmp8__length1 = rt_table_content_arr_length1;
		_tmp9_ = g_strdup ((const gchar*) _tmp8_);
		_g_free0 (rt_table_content);
		rt_table_content = _tmp9_;
		_tmp10_ = netsukuku_impl_linux_NTK_IN_RT_TABLE;
		_tmp11_ = rt_table_content;
		_tmp12_ = g_regex_match (_tmp10_, _tmp11_, 0, NULL);
		if (!_tmp12_) {
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
			gchar _tmp17_ = '\0';
			const gchar* _tmp20_;
			gchar* _tmp21_;
			const gchar* _tmp22_;
			gint _tmp23_;
			gchar* _tmp24_ = NULL;
			gchar* _tmp25_;
			gchar* _tmp26_ = NULL;
			gchar* _tmp27_;
			gchar* _tmp28_;
			GFile* _tmp29_ = NULL;
			GFile* fout;
			GFile* _tmp30_;
			GFileOutputStream* _tmp31_ = NULL;
			GFileOutputStream* fos;
			GFileOutputStream* _tmp32_;
			const gchar* _tmp33_;
			guint8* _tmp34_;
			gint _tmp34__length1;
			guint8* _tmp35_;
			gint _tmp35__length1;
			_tmp13_ = rt_table_content;
			_tmp14_ = rt_table_content;
			_tmp15_ = strlen (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = string_get (_tmp13_, (glong) (_tmp16_ - 1));
			if (_tmp17_ != '\n') {
				const gchar* _tmp18_;
				gchar* _tmp19_;
				_tmp18_ = conf;
				_tmp19_ = g_strconcat (_tmp18_, "\n", NULL);
				_g_free0 (conf);
				conf = _tmp19_;
			}
			_tmp20_ = conf;
			_tmp21_ = g_strconcat (_tmp20_, "# Added by netsukuku\n", NULL);
			_g_free0 (conf);
			conf = _tmp21_;
			_tmp22_ = conf;
			_tmp23_ = netsukuku_impl_linux_NTK_TABLE;
			_tmp24_ = g_strdup_printf ("%i", _tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = g_strconcat (_tmp25_, "\tntk\n", NULL);
			_tmp27_ = _tmp26_;
			_tmp28_ = g_strconcat (_tmp22_, _tmp27_, NULL);
			_g_free0 (conf);
			conf = _tmp28_;
			_g_free0 (_tmp27_);
			_g_free0 (_tmp25_);
			_tmp29_ = g_file_new_for_commandline_arg (NETSUKUKU_IMPL_LINUX_RT_TABLE);
			fout = _tmp29_;
			_tmp30_ = fout;
			_tmp31_ = g_file_append_to (_tmp30_, G_FILE_CREATE_NONE, NULL, &_inner_error_);
			fos = _tmp31_;
			if (_inner_error_ != NULL) {
				_g_object_unref0 (fout);
				rt_table_content_arr = (g_free (rt_table_content_arr), NULL);
				_g_free0 (rt_table_content);
				_g_object_unref0 (ftable);
				_g_free0 (conf);
				goto __catch75_g_error;
			}
			_tmp32_ = fos;
			_tmp33_ = conf;
			_tmp34_ = string_get_data (_tmp33_, &_tmp34__length1);
			_tmp35_ = _tmp34_;
			_tmp35__length1 = _tmp34__length1;
			g_output_stream_write ((GOutputStream*) _tmp32_, _tmp35_, (gsize) _tmp35__length1, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (fos);
				_g_object_unref0 (fout);
				rt_table_content_arr = (g_free (rt_table_content_arr), NULL);
				_g_free0 (rt_table_content);
				_g_object_unref0 (ftable);
				_g_free0 (conf);
				goto __catch75_g_error;
			}
			_g_object_unref0 (fos);
			_g_object_unref0 (fout);
		}
		_tmp36_ = netsukuku_impl_linux_iproute ("rule list", &_inner_error_);
		pres = _tmp36_;
		if (_inner_error_ != NULL) {
			rt_table_content_arr = (g_free (rt_table_content_arr), NULL);
			_g_free0 (rt_table_content);
			_g_object_unref0 (ftable);
			_g_free0 (conf);
			goto __catch75_g_error;
		}
		_tmp37_ = pres;
		_tmp38_ = string_contains (_tmp37_, " lookup ntk ");
		if (!_tmp38_) {
			gchar* _tmp39_ = NULL;
			gchar* _tmp40_;
			_tmp39_ = netsukuku_impl_linux_iproute ("rule add table ntk", &_inner_error_);
			_tmp40_ = _tmp39_;
			_g_free0 (_tmp40_);
			if (_inner_error_ != NULL) {
				_g_free0 (pres);
				rt_table_content_arr = (g_free (rt_table_content_arr), NULL);
				_g_free0 (rt_table_content);
				_g_object_unref0 (ftable);
				_g_free0 (conf);
				goto __catch75_g_error;
			}
		}
		_g_free0 (pres);
		rt_table_content_arr = (g_free (rt_table_content_arr), NULL);
		_g_free0 (rt_table_content);
		_g_object_unref0 (ftable);
		_g_free0 (conf);
	}
	goto __finally75;
	__catch75_g_error:
	{
		GError* e = NULL;
		GQuark _tmp41_;
		const gchar* _tmp42_ = NULL;
		gint _tmp43_;
		gchar* _tmp44_ = NULL;
		gchar* _tmp45_;
		const gchar* _tmp46_;
		const gchar* _tmp47_ = NULL;
		gchar* _tmp48_ = NULL;
		gchar* _tmp49_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp41_ = e->domain;
		_tmp42_ = g_quark_to_string (_tmp41_);
		_tmp43_ = e->code;
		_tmp44_ = g_strdup_printf ("%i", _tmp43_);
		_tmp45_ = _tmp44_;
		_tmp46_ = e->message;
		_tmp47_ = string_to_string (_tmp46_);
		_tmp48_ = g_strconcat ("LinuxNic.init_prdb: Caught exception ", _tmp42_, " code ", _tmp45_, ": ", _tmp47_, NULL);
		_tmp49_ = _tmp48_;
		g_error ("network_linux.vala:395: %s", _tmp49_);
		_g_free0 (_tmp49_);
		_g_free0 (_tmp45_);
		_g_error_free0 (e);
	}
	__finally75:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


void netsukuku_impl_linux_struct_helper_linuxroute_activate_multipath_copy (const NetsukukuImplLinuxstruct_helper_LinuxRoute_activate_multipath* self, NetsukukuImplLinuxstruct_helper_LinuxRoute_activate_multipath* dest) {
	NetsukukuImplLinuxLinuxRoute* _tmp0_;
	NetsukukuImplLinuxLinuxRoute* _tmp1_;
	_tmp0_ = (*self).self;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 ((*dest).self);
	(*dest).self = _tmp1_;
}


void netsukuku_impl_linux_struct_helper_linuxroute_activate_multipath_destroy (NetsukukuImplLinuxstruct_helper_LinuxRoute_activate_multipath* self) {
	_g_object_unref0 ((*self).self);
}


NetsukukuImplLinuxstruct_helper_LinuxRoute_activate_multipath* netsukuku_impl_linux_struct_helper_linuxroute_activate_multipath_dup (const NetsukukuImplLinuxstruct_helper_LinuxRoute_activate_multipath* self) {
	NetsukukuImplLinuxstruct_helper_LinuxRoute_activate_multipath* dup;
	dup = g_new0 (NetsukukuImplLinuxstruct_helper_LinuxRoute_activate_multipath, 1);
	netsukuku_impl_linux_struct_helper_linuxroute_activate_multipath_copy (self, dup);
	return dup;
}


void netsukuku_impl_linux_struct_helper_linuxroute_activate_multipath_free (NetsukukuImplLinuxstruct_helper_LinuxRoute_activate_multipath* self) {
	netsukuku_impl_linux_struct_helper_linuxroute_activate_multipath_destroy (self);
	g_free (self);
}


GType netsukuku_impl_linux_struct_helper_linuxroute_activate_multipath_get_type (void) {
	static volatile gsize netsukuku_impl_linux_struct_helper_linuxroute_activate_multipath_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_impl_linux_struct_helper_linuxroute_activate_multipath_type_id__volatile)) {
		GType netsukuku_impl_linux_struct_helper_linuxroute_activate_multipath_type_id;
		netsukuku_impl_linux_struct_helper_linuxroute_activate_multipath_type_id = g_boxed_type_register_static ("NetsukukuImplLinuxstruct_helper_LinuxRoute_activate_multipath", (GBoxedCopyFunc) netsukuku_impl_linux_struct_helper_linuxroute_activate_multipath_dup, (GBoxedFreeFunc) netsukuku_impl_linux_struct_helper_linuxroute_activate_multipath_free);
		g_once_init_leave (&netsukuku_impl_linux_struct_helper_linuxroute_activate_multipath_type_id__volatile, netsukuku_impl_linux_struct_helper_linuxroute_activate_multipath_type_id);
	}
	return netsukuku_impl_linux_struct_helper_linuxroute_activate_multipath_type_id__volatile;
}


static NetsukukuRouteSetter* _netsukuku_impl_linux_linux_route_create (void) {
	NetsukukuRouteSetter* result = NULL;
	gboolean _tmp0_;
	gboolean _tmp1_;
	NetsukukuImplLinuxLinuxRoute* _tmp2_;
	_tmp0_ = netsukuku_settings_get_TESTING ();
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		netsukuku_impl_linux_init_prdb ();
	}
	_tmp2_ = netsukuku_impl_linux_linux_route_new ();
	result = (NetsukukuRouteSetter*) _tmp2_;
	return result;
}


static NetsukukuRouteSetter* __netsukuku_impl_linux_linux_route_create_netsukuku_create_route_setter_delegate (gpointer self) {
	NetsukukuRouteSetter* result;
	result = _netsukuku_impl_linux_linux_route_create ();
	return result;
}


void netsukuku_impl_linux_linux_route_register (void) {
	netsukuku_route_setter_register_class ("linux", __netsukuku_impl_linux_linux_route_create_netsukuku_create_route_setter_delegate, NULL);
}


NetsukukuImplLinuxLinuxRoute* netsukuku_impl_linux_linux_route_construct (GType object_type) {
	NetsukukuImplLinuxLinuxRoute * self = NULL;
	GeeHashMap* _tmp0_;
	self = (NetsukukuImplLinuxLinuxRoute*) netsukuku_route_setter_construct (object_type);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_INT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->mac_table);
	self->priv->mac_table = _tmp0_;
	return self;
}


NetsukukuImplLinuxLinuxRoute* netsukuku_impl_linux_linux_route_new (void) {
	return netsukuku_impl_linux_linux_route_construct (NETSUKUKU_IMPL_LINUX_TYPE_LINUX_ROUTE);
}


static void netsukuku_impl_linux_linux_route_impl_activate_multipath (NetsukukuImplLinuxLinuxRoute* self, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	while (TRUE) {
		{
			gchar* _tmp0_ = NULL;
			gchar* _tmp1_;
			tasklets_ms_wait ((gint64) 1000);
			_tmp0_ = netsukuku_impl_linux_iproute ("route flush cache", &_inner_error_);
			_tmp1_ = _tmp0_;
			_g_free0 (_tmp1_);
			if (_inner_error_ != NULL) {
				goto __catch76_g_error;
			}
		}
		goto __finally76;
		__catch76_g_error:
		{
			GError* e = NULL;
			GError* _tmp2_;
			const gchar* _tmp3_;
			const gchar* _tmp4_ = NULL;
			gchar* _tmp5_ = NULL;
			gchar* _tmp6_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp2_ = e;
			_tmp3_ = _tmp2_->message;
			_tmp4_ = string_to_string (_tmp3_);
			_tmp5_ = g_strconcat ("LinuxRoute: Exception while keep_flushing: ", _tmp4_, NULL);
			_tmp6_ = _tmp5_;
			netsukuku_log_error (_tmp6_);
			_g_free0 (_tmp6_);
			_g_error_free0 (e);
		}
		__finally76:
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return;
		}
	}
}


static void* netsukuku_impl_linux_linux_route_helper_activate_multipath (void* v, GError** error) {
	void* result = NULL;
	void* _tmp0_;
	Taskletsstruct_channel* ch_cont_p;
	Taskletsstruct_channel* _tmp1_;
	TaskletsChannel* _tmp2_;
	TaskletsChannel* _tmp3_;
	TaskletsChannel* ch;
	GError * _inner_error_ = NULL;
	tasklets_tasklet_declare_self ("LinuxRoute.activate_multipath dispatcher");
	_tmp0_ = v;
	ch_cont_p = (Taskletsstruct_channel*) _tmp0_;
	_tmp1_ = ch_cont_p;
	_tmp2_ = (*_tmp1_).self;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	ch = _tmp3_;
	tasklets_tasklet_schedule_back ();
	while (TRUE) {
		gchar* doing;
		const gchar* _tmp17_;
		doing = NULL;
		{
			NetsukukuImplLinuxstruct_helper_LinuxRoute_activate_multipath tuple_p = {0};
			gchar* _tmp8_;
			const gchar* _tmp9_;
			NetsukukuImplLinuxstruct_helper_LinuxRoute_activate_multipath _tmp10_;
			NetsukukuImplLinuxLinuxRoute* _tmp11_;
			{
				TaskletsChannel* _tmp4_;
				GValue _tmp5_ = {0};
				GValue vv;
				void* _tmp6_ = NULL;
				NetsukukuImplLinuxstruct_helper_LinuxRoute_activate_multipath _tmp7_ = {0};
				_tmp4_ = ch;
				tasklets_channel_recv (_tmp4_, &_tmp5_);
				vv = _tmp5_;
				_tmp6_ = g_value_get_boxed (&vv);
				netsukuku_impl_linux_struct_helper_linuxroute_activate_multipath_copy ((NetsukukuImplLinuxstruct_helper_LinuxRoute_activate_multipath*) _tmp6_, &_tmp7_);
				netsukuku_impl_linux_struct_helper_linuxroute_activate_multipath_destroy (&tuple_p);
				tuple_p = _tmp7_;
				G_IS_VALUE (&vv) ? (g_value_unset (&vv), NULL) : NULL;
			}
			_tmp8_ = g_strdup ("activate_multipath()");
			_g_free0 (doing);
			doing = _tmp8_;
			_tmp9_ = doing;
			tasklets_tasklet_declare_self (_tmp9_);
			_tmp10_ = tuple_p;
			_tmp11_ = _tmp10_.self;
			netsukuku_impl_linux_linux_route_impl_activate_multipath (_tmp11_, &_inner_error_);
			if (_inner_error_ != NULL) {
				netsukuku_impl_linux_struct_helper_linuxroute_activate_multipath_destroy (&tuple_p);
				goto __catch77_g_error;
			}
			tasklets_tasklet_nap ((glong) 0, (glong) 100);
			netsukuku_impl_linux_struct_helper_linuxroute_activate_multipath_destroy (&tuple_p);
		}
		goto __finally77;
		__catch77_g_error:
		{
			GError* e = NULL;
			GError* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_ = NULL;
			gchar* _tmp15_ = NULL;
			gchar* _tmp16_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp12_ = e;
			_tmp13_ = _tmp12_->message;
			_tmp14_ = string_to_string (_tmp13_);
			_tmp15_ = g_strconcat ("LinuxRoute: activate_multipath microfunc reported an error: ", _tmp14_, NULL);
			_tmp16_ = _tmp15_;
			netsukuku_log_warn (_tmp16_);
			_g_free0 (_tmp16_);
			_g_error_free0 (e);
		}
		__finally77:
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (doing);
			_g_object_unref0 (ch);
			return NULL;
		}
		_tmp17_ = doing;
		if (_tmp17_ != NULL) {
			const gchar* _tmp18_;
			_tmp18_ = doing;
			tasklets_tasklet_declare_finished (_tmp18_);
		}
		_g_free0 (doing);
	}
	_g_object_unref0 (ch);
	return result;
}


static void netsukuku_impl_linux_linux_route_real_activate_multipath (NetsukukuRouteSetter* base) {
	NetsukukuImplLinuxLinuxRoute * self;
	TaskletsChannel* _tmp0_ = NULL;
	TaskletsChannel* ch;
	NetsukukuImplLinuxstruct_helper_LinuxRoute_activate_multipath arg = {0};
	NetsukukuImplLinuxLinuxRoute* _tmp1_;
	NetsukukuImplLinuxstruct_helper_LinuxRoute_activate_multipath _tmp2_;
	GValue _tmp3_ = {0};
	self = (NetsukukuImplLinuxLinuxRoute*) base;
	_tmp0_ = tasklets_tasklet_dispatcher_get_channel_for_helper ((TaskletsSpawnable) netsukuku_impl_linux_linux_route_helper_activate_multipath, -1);
	ch = _tmp0_;
	memset (&arg, 0, sizeof (NetsukukuImplLinuxstruct_helper_LinuxRoute_activate_multipath));
	_tmp1_ = _g_object_ref0 (self);
	_g_object_unref0 (arg.self);
	arg.self = _tmp1_;
	_tmp2_ = arg;
	g_value_init (&_tmp3_, NETSUKUKU_IMPL_LINUX_TYPE_STRUCT_HELPER_LINUXROUTE_ACTIVATE_MULTIPATH);
	g_value_set_boxed (&_tmp3_, &_tmp2_);
	tasklets_channel_send_async (ch, &_tmp3_);
	G_IS_VALUE (&_tmp3_) ? (g_value_unset (&_tmp3_), NULL) : NULL;
	netsukuku_impl_linux_struct_helper_linuxroute_activate_multipath_destroy (&arg);
	_g_object_unref0 (ch);
}


/** Makes sure that a routing table exists for packets coming from macaddr.
          * Returns the number of that table.
          */
gint _netsukuku_impl_linux_linux_route_table_for_macaddr (NetsukukuImplLinuxLinuxRoute* self, const gchar* _macaddr, GError** error) {
	gint result = 0;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* macaddr;
	gint idn = 0;
	GeeHashMap* _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (_macaddr != NULL, 0);
	_tmp0_ = _macaddr;
	_tmp1_ = g_utf8_strdown (_tmp0_, (gssize) (-1));
	macaddr = _tmp1_;
	_tmp2_ = self->priv->mac_table;
	_tmp3_ = macaddr;
	_tmp4_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp2_, _tmp3_);
	if (!_tmp4_) {
		const gchar* _tmp13_;
		const gchar* _tmp14_ = NULL;
		gint _tmp15_;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_;
		gint _tmp22_;
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_;
		gint _tmp25_;
		gchar* _tmp26_ = NULL;
		gchar* _tmp27_;
		gchar* _tmp28_ = NULL;
		gchar* _tmp29_;
		gchar* _tmp30_ = NULL;
		gchar* _tmp31_;
		GeeHashMap* _tmp32_;
		const gchar* _tmp33_;
		gint _tmp34_;
		idn = 199;
		while (TRUE) {
			GeeHashMap* _tmp5_;
			GeeCollection* _tmp6_;
			GeeCollection* _tmp7_;
			GeeCollection* _tmp8_;
			gint _tmp9_;
			gboolean _tmp10_ = FALSE;
			gboolean _tmp11_;
			gint _tmp12_;
			_tmp5_ = self->priv->mac_table;
			_tmp6_ = gee_abstract_map_get_values ((GeeMap*) _tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = _tmp7_;
			_tmp9_ = idn;
			_tmp10_ = gee_collection_contains (_tmp8_, (gpointer) ((gintptr) _tmp9_));
			_tmp11_ = !_tmp10_;
			_g_object_unref0 (_tmp8_);
			if (_tmp11_) {
				break;
			}
			_tmp12_ = idn;
			idn = _tmp12_ - 1;
		}
		_tmp13_ = macaddr;
		_tmp14_ = string_to_string (_tmp13_);
		_tmp15_ = idn;
		_tmp16_ = g_strdup_printf ("%i", _tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = g_strconcat ("-t mangle -A PREROUTING -m mac --mac-source ", _tmp14_, " -j MARK --set-mark ", _tmp17_, NULL);
		_tmp19_ = _tmp18_;
		_tmp20_ = netsukuku_impl_linux_iptables (_tmp19_, &_inner_error_);
		_tmp21_ = _tmp20_;
		_g_free0 (_tmp21_);
		_g_free0 (_tmp19_);
		_g_free0 (_tmp17_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (macaddr);
			return 0;
		}
		_tmp22_ = idn;
		_tmp23_ = g_strdup_printf ("%i", _tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = idn;
		_tmp26_ = g_strdup_printf ("%i", _tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = g_strconcat ("rule add fwmark ", _tmp24_, " table ", _tmp27_, NULL);
		_tmp29_ = _tmp28_;
		_tmp30_ = netsukuku_impl_linux_iproute (_tmp29_, &_inner_error_);
		_tmp31_ = _tmp30_;
		_g_free0 (_tmp31_);
		_g_free0 (_tmp29_);
		_g_free0 (_tmp27_);
		_g_free0 (_tmp24_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (macaddr);
			return 0;
		}
		_tmp32_ = self->priv->mac_table;
		_tmp33_ = macaddr;
		_tmp34_ = idn;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp32_, _tmp33_, (gpointer) ((gintptr) _tmp34_));
	} else {
		GeeHashMap* _tmp35_;
		const gchar* _tmp36_;
		gpointer _tmp37_ = NULL;
		_tmp35_ = self->priv->mac_table;
		_tmp36_ = macaddr;
		_tmp37_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp35_, _tmp36_);
		idn = (gint) ((gintptr) _tmp37_);
	}
	result = idn;
	_g_free0 (macaddr);
	return result;
}


/** Removes all routing table created for packets coming from any macaddr
          */
void _netsukuku_impl_linux_linux_route_table_for_macaddr_remove_all (NetsukukuImplLinuxLinuxRoute* self, GError** error) {
	GeeArrayList* _tmp0_;
	GeeArrayList* all_macs;
	GeeArrayList* _tmp1_;
	GeeHashMap* _tmp2_;
	GeeSet* _tmp3_;
	GeeSet* _tmp4_;
	GeeSet* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	all_macs = _tmp0_;
	_tmp1_ = all_macs;
	_tmp2_ = self->priv->mac_table;
	_tmp3_ = gee_abstract_map_get_keys ((GeeMap*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	gee_array_list_add_all (_tmp1_, (GeeCollection*) _tmp5_);
	_g_object_unref0 (_tmp5_);
	{
		GeeArrayList* _tmp6_;
		GeeArrayList* _tmp7_;
		GeeArrayList* _k_list;
		GeeArrayList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _k_size;
		gint _k_index;
		_tmp6_ = all_macs;
		_tmp7_ = _g_object_ref0 (_tmp6_);
		_k_list = _tmp7_;
		_tmp8_ = _k_list;
		_tmp9_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp8_);
		_tmp10_ = _tmp9_;
		_k_size = _tmp10_;
		_k_index = -1;
		while (TRUE) {
			gint _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			GeeArrayList* _tmp14_;
			gint _tmp15_;
			gpointer _tmp16_ = NULL;
			gchar* k;
			const gchar* _tmp17_;
			_tmp11_ = _k_index;
			_k_index = _tmp11_ + 1;
			_tmp12_ = _k_index;
			_tmp13_ = _k_size;
			if (!(_tmp12_ < _tmp13_)) {
				break;
			}
			_tmp14_ = _k_list;
			_tmp15_ = _k_index;
			_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) _tmp14_, _tmp15_);
			k = (gchar*) _tmp16_;
			_tmp17_ = k;
			_netsukuku_impl_linux_linux_route_table_for_macaddr_remove (self, _tmp17_, &_inner_error_);
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (k);
				_g_object_unref0 (_k_list);
				_g_object_unref0 (all_macs);
				return;
			}
			_g_free0 (k);
		}
		_g_object_unref0 (_k_list);
	}
	_g_object_unref0 (all_macs);
}


/** Makes sure that a routing table doesn't exist anymore for packets coming from macaddr
          */
void _netsukuku_impl_linux_linux_route_table_for_macaddr_remove (NetsukukuImplLinuxLinuxRoute* self, const gchar* _macaddr, GError** error) {
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* macaddr;
	GeeHashMap* _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (_macaddr != NULL);
	_tmp0_ = _macaddr;
	_tmp1_ = g_utf8_strdown (_tmp0_, (gssize) (-1));
	macaddr = _tmp1_;
	_tmp2_ = self->priv->mac_table;
	_tmp3_ = macaddr;
	_tmp4_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp2_, _tmp3_);
	if (_tmp4_) {
		GeeHashMap* _tmp5_;
		const gchar* _tmp6_;
		gpointer _tmp7_ = NULL;
		gint idn;
		const gchar* _tmp8_;
		const gchar* _tmp9_ = NULL;
		gint _tmp10_;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_;
		gint _tmp17_;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_;
		gint _tmp20_;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_;
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_;
		gchar* _tmp25_ = NULL;
		gchar* _tmp26_;
		GeeHashMap* _tmp27_;
		const gchar* _tmp28_;
		_tmp5_ = self->priv->mac_table;
		_tmp6_ = macaddr;
		_tmp7_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp5_, _tmp6_);
		idn = (gint) ((gintptr) _tmp7_);
		_tmp8_ = macaddr;
		_tmp9_ = string_to_string (_tmp8_);
		_tmp10_ = idn;
		_tmp11_ = g_strdup_printf ("%i", _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strconcat ("-t mangle -D PREROUTING -m mac --mac-source ", _tmp9_, " -j MARK --set-mark ", _tmp12_, NULL);
		_tmp14_ = _tmp13_;
		_tmp15_ = netsukuku_impl_linux_iptables (_tmp14_, &_inner_error_);
		_tmp16_ = _tmp15_;
		_g_free0 (_tmp16_);
		_g_free0 (_tmp14_);
		_g_free0 (_tmp12_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (macaddr);
			return;
		}
		_tmp17_ = idn;
		_tmp18_ = g_strdup_printf ("%i", _tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = idn;
		_tmp21_ = g_strdup_printf ("%i", _tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = g_strconcat ("rule del fwmark ", _tmp19_, " table ", _tmp22_, NULL);
		_tmp24_ = _tmp23_;
		_tmp25_ = netsukuku_impl_linux_iproute (_tmp24_, &_inner_error_);
		_tmp26_ = _tmp25_;
		_g_free0 (_tmp26_);
		_g_free0 (_tmp24_);
		_g_free0 (_tmp22_);
		_g_free0 (_tmp19_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (macaddr);
			return;
		}
		_tmp27_ = self->priv->mac_table;
		_tmp28_ = macaddr;
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp27_, _tmp28_, NULL);
	}
	_g_free0 (macaddr);
}


/** Returns proper iproute command arguments to add/change/delete routes
          */
gchar* _netsukuku_impl_linux_linux_route_modify_routes_cmd (NetsukukuImplLinuxLinuxRoute* self, const gchar* command, const gchar* ip, const gchar* cidr, NetsukukuRouteSolutions* route_solutions, const gchar* table) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* cmd;
	const gchar* _tmp7_;
	NetsukukuRouteSolutions* _tmp16_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (command != NULL, NULL);
	g_return_val_if_fail (ip != NULL, NULL);
	g_return_val_if_fail (cidr != NULL, NULL);
	_tmp0_ = command;
	_tmp1_ = string_to_string (_tmp0_);
	_tmp2_ = ip;
	_tmp3_ = string_to_string (_tmp2_);
	_tmp4_ = cidr;
	_tmp5_ = string_to_string (_tmp4_);
	_tmp6_ = g_strconcat ("route ", _tmp1_, " ", _tmp3_, "/", _tmp5_, NULL);
	cmd = _tmp6_;
	_tmp7_ = table;
	if (_tmp7_ != NULL) {
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp8_ = cmd;
		_tmp9_ = table;
		_tmp10_ = string_to_string (_tmp9_);
		_tmp11_ = g_strconcat (" table ", _tmp10_, NULL);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strconcat (_tmp8_, _tmp12_, NULL);
		_g_free0 (cmd);
		cmd = _tmp13_;
		_g_free0 (_tmp12_);
	} else {
		const gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp14_ = cmd;
		_tmp15_ = g_strconcat (_tmp14_, " table ntk", NULL);
		_g_free0 (cmd);
		cmd = _tmp15_;
	}
	_tmp16_ = route_solutions;
	if (_tmp16_ != NULL) {
		NetsukukuRouteSolutions* _tmp17_;
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		_tmp17_ = route_solutions;
		_tmp18_ = netsukuku_route_solutions_get_pref_src (_tmp17_);
		_tmp19_ = _tmp18_;
		if (_tmp19_ != NULL) {
			const gchar* _tmp20_;
			NetsukukuRouteSolutions* _tmp21_;
			const gchar* _tmp22_;
			const gchar* _tmp23_;
			const gchar* _tmp24_ = NULL;
			gchar* _tmp25_ = NULL;
			gchar* _tmp26_;
			gchar* _tmp27_;
			_tmp20_ = cmd;
			_tmp21_ = route_solutions;
			_tmp22_ = netsukuku_route_solutions_get_pref_src (_tmp21_);
			_tmp23_ = _tmp22_;
			_tmp24_ = string_to_string (_tmp23_);
			_tmp25_ = g_strconcat (" src ", _tmp24_, NULL);
			_tmp26_ = _tmp25_;
			_tmp27_ = g_strconcat (_tmp20_, _tmp26_, NULL);
			_g_free0 (cmd);
			cmd = _tmp27_;
			_g_free0 (_tmp26_);
		}
		{
			NetsukukuRouteSolutions* _tmp28_;
			GeeCollection* _tmp29_;
			GeeCollection* _tmp30_;
			GeeCollection* _tmp31_;
			GeeIterator* _tmp32_ = NULL;
			GeeIterator* _tmp33_;
			GeeIterator* _rs_it;
			_tmp28_ = route_solutions;
			_tmp29_ = netsukuku_route_solutions_get_values (_tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = _tmp30_;
			_tmp32_ = gee_iterable_iterator ((GeeIterable*) _tmp31_);
			_tmp33_ = _tmp32_;
			_g_object_unref0 (_tmp31_);
			_rs_it = _tmp33_;
			while (TRUE) {
				GeeIterator* _tmp34_;
				gboolean _tmp35_ = FALSE;
				GeeIterator* _tmp36_;
				gpointer _tmp37_ = NULL;
				NetsukukuRouteSolution* rs;
				const gchar* _tmp38_;
				NetsukukuRouteSolution* _tmp39_;
				const gchar* _tmp40_;
				const gchar* _tmp41_;
				const gchar* _tmp42_ = NULL;
				NetsukukuRouteSolution* _tmp43_;
				const gchar* _tmp44_;
				const gchar* _tmp45_;
				const gchar* _tmp46_ = NULL;
				NetsukukuRouteSolution* _tmp47_;
				gint _tmp48_;
				gint _tmp49_;
				gchar* _tmp50_ = NULL;
				gchar* _tmp51_;
				gchar* _tmp52_ = NULL;
				gchar* _tmp53_;
				gchar* _tmp54_;
				_tmp34_ = _rs_it;
				_tmp35_ = gee_iterator_next (_tmp34_);
				if (!_tmp35_) {
					break;
				}
				_tmp36_ = _rs_it;
				_tmp37_ = gee_iterator_get (_tmp36_);
				rs = (NetsukukuRouteSolution*) _tmp37_;
				_tmp38_ = cmd;
				_tmp39_ = rs;
				_tmp40_ = netsukuku_route_solution_get_gateway (_tmp39_);
				_tmp41_ = _tmp40_;
				_tmp42_ = string_to_string (_tmp41_);
				_tmp43_ = rs;
				_tmp44_ = netsukuku_route_solution_get_dev (_tmp43_);
				_tmp45_ = _tmp44_;
				_tmp46_ = string_to_string (_tmp45_);
				_tmp47_ = rs;
				_tmp48_ = netsukuku_route_solution_get_weight (_tmp47_);
				_tmp49_ = _tmp48_;
				_tmp50_ = g_strdup_printf ("%i", 1 + ((_tmp49_ * 255) / 1000));
				_tmp51_ = _tmp50_;
				_tmp52_ = g_strconcat (" nexthop via ", _tmp42_, " dev ", _tmp46_, " weight ", _tmp51_, NULL);
				_tmp53_ = _tmp52_;
				_tmp54_ = g_strconcat (_tmp38_, _tmp53_, NULL);
				_g_free0 (cmd);
				cmd = _tmp54_;
				_g_free0 (_tmp53_);
				_g_free0 (_tmp51_);
				_g_object_unref0 (rs);
			}
			_g_object_unref0 (_rs_it);
		}
	}
	result = cmd;
	return result;
}


/** Returns proper iproute command arguments to add/change/delete a neighbour
          */
gchar* _netsukuku_impl_linux_linux_route_modify_neighbour_cmd (NetsukukuImplLinuxLinuxRoute* self, const gchar* command, const gchar* ip, const gchar* dev, const gchar* pref_src) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* cmd;
	const gchar* _tmp5_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	const gchar* _tmp14_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (command != NULL, NULL);
	g_return_val_if_fail (ip != NULL, NULL);
	_tmp0_ = command;
	_tmp1_ = string_to_string (_tmp0_);
	_tmp2_ = ip;
	_tmp3_ = string_to_string (_tmp2_);
	_tmp4_ = g_strconcat ("route ", _tmp1_, " ", _tmp3_, NULL);
	cmd = _tmp4_;
	_tmp5_ = dev;
	if (_tmp5_ != NULL) {
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp6_ = cmd;
		_tmp7_ = dev;
		_tmp8_ = string_to_string (_tmp7_);
		_tmp9_ = g_strconcat (" dev ", _tmp8_, NULL);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strconcat (_tmp6_, _tmp10_, NULL);
		_g_free0 (cmd);
		cmd = _tmp11_;
		_g_free0 (_tmp10_);
	}
	_tmp12_ = cmd;
	_tmp13_ = g_strconcat (_tmp12_, " table ntk", NULL);
	_g_free0 (cmd);
	cmd = _tmp13_;
	_tmp14_ = pref_src;
	if (_tmp14_ != NULL) {
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_;
		gchar* _tmp20_;
		_tmp15_ = cmd;
		_tmp16_ = pref_src;
		_tmp17_ = string_to_string (_tmp16_);
		_tmp18_ = g_strconcat (" src ", _tmp17_, NULL);
		_tmp19_ = _tmp18_;
		_tmp20_ = g_strconcat (_tmp15_, _tmp19_, NULL);
		_g_free0 (cmd);
		cmd = _tmp20_;
		_g_free0 (_tmp19_);
	}
	result = cmd;
	return result;
}


/** Add a route (that was non existent) towards ip/cidr
          * for packets generated by this host.
          * The gateways are route_solutions
          */
static void netsukuku_impl_linux_linux_route_real__add_outgoing_route (NetsukukuRouteSetter* base, const gchar* ip, const gchar* cidr, NetsukukuRouteSolutions* route_solutions) {
	NetsukukuImplLinuxLinuxRoute * self;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gboolean _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	NetsukukuRouteSolutions* _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	self = (NetsukukuImplLinuxLinuxRoute*) base;
	g_return_if_fail (ip != NULL);
	g_return_if_fail (cidr != NULL);
	g_return_if_fail (route_solutions != NULL);
	_tmp1_ = cidr;
	if (g_strcmp0 (_tmp1_, "32") == 0) {
		NetsukukuRouteSolutions* _tmp2_;
		const gchar* _tmp3_;
		gboolean _tmp4_ = FALSE;
		_tmp2_ = route_solutions;
		_tmp3_ = ip;
		_tmp4_ = netsukuku_route_solutions_contains_gw (_tmp2_, _tmp3_);
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp5_ = _tmp0_;
	if (_tmp5_) {
		return;
	}
	_tmp6_ = ip;
	_tmp7_ = cidr;
	_tmp8_ = route_solutions;
	_tmp9_ = _netsukuku_impl_linux_linux_route_modify_routes_cmd (self, "add", _tmp6_, _tmp7_, _tmp8_, NULL);
	_tmp10_ = _tmp9_;
	netsukuku_impl_linux_iproute_exp (_tmp10_);
	_g_free0 (_tmp10_);
}


/** Add a route (that was non existent) towards ip/cidr
          * for packets coming from MAC prev_hop.
          * The gateways are route_solutions
          */
static void netsukuku_impl_linux_linux_route_real__add_forwarding_route (NetsukukuRouteSetter* base, const gchar* ip, const gchar* cidr, const gchar* prev_hop, NetsukukuRouteSolutions* route_solutions, GError** error) {
	NetsukukuImplLinuxLinuxRoute * self;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gboolean _tmp5_;
	const gchar* _tmp6_;
	gint _tmp7_ = 0;
	gint idn;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	NetsukukuRouteSolutions* _tmp10_;
	gint _tmp11_;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuImplLinuxLinuxRoute*) base;
	g_return_if_fail (ip != NULL);
	g_return_if_fail (cidr != NULL);
	g_return_if_fail (prev_hop != NULL);
	g_return_if_fail (route_solutions != NULL);
	_tmp1_ = cidr;
	if (g_strcmp0 (_tmp1_, "32") == 0) {
		NetsukukuRouteSolutions* _tmp2_;
		const gchar* _tmp3_;
		gboolean _tmp4_ = FALSE;
		_tmp2_ = route_solutions;
		_tmp3_ = ip;
		_tmp4_ = netsukuku_route_solutions_contains_gw (_tmp2_, _tmp3_);
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp5_ = _tmp0_;
	if (_tmp5_) {
		return;
	}
	_tmp6_ = prev_hop;
	_tmp7_ = _netsukuku_impl_linux_linux_route_table_for_macaddr (self, _tmp6_, &_inner_error_);
	idn = _tmp7_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp8_ = ip;
	_tmp9_ = cidr;
	_tmp10_ = route_solutions;
	_tmp11_ = idn;
	_tmp12_ = g_strdup_printf ("%i", _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = _netsukuku_impl_linux_linux_route_modify_routes_cmd (self, "add", _tmp8_, _tmp9_, _tmp10_, _tmp13_);
	_tmp15_ = _tmp14_;
	netsukuku_impl_linux_iproute_exp (_tmp15_);
	_g_free0 (_tmp15_);
	_g_free0 (_tmp13_);
}


/** Add a route (that was non existent) towards ip/cidr
          * for packets coming from MAC prev_hop.
          * In fact this route is UNREACHABLE
          */
static void netsukuku_impl_linux_linux_route_real__add_forwarding_route_unreachable (NetsukukuRouteSetter* base, const gchar* ip, const gchar* cidr, const gchar* prev_hop, GError** error) {
	NetsukukuImplLinuxLinuxRoute * self;
	const gchar* _tmp0_;
	gint _tmp1_ = 0;
	gint idn;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuImplLinuxLinuxRoute*) base;
	g_return_if_fail (ip != NULL);
	g_return_if_fail (cidr != NULL);
	g_return_if_fail (prev_hop != NULL);
	_tmp0_ = prev_hop;
	_tmp1_ = _netsukuku_impl_linux_linux_route_table_for_macaddr (self, _tmp0_, &_inner_error_);
	idn = _tmp1_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp2_ = g_strdup_printf ("%i", idn);
	_tmp3_ = _tmp2_;
	_tmp4_ = ip;
	_tmp5_ = string_to_string (_tmp4_);
	_tmp6_ = cidr;
	_tmp7_ = string_to_string (_tmp6_);
	_tmp8_ = g_strconcat ("route add table ", _tmp3_, " unreachable ", _tmp5_, "/", _tmp7_, NULL);
	_tmp9_ = _tmp8_;
	netsukuku_impl_linux_iproute_exp (_tmp9_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp3_);
}


/** Add a route (that was non existent) towards ip/cidr
          * for packets coming from MAC prev_hop.
          * In fact this route is DROP
          */
static void netsukuku_impl_linux_linux_route_real__add_forwarding_route_drop (NetsukukuRouteSetter* base, const gchar* ip, const gchar* cidr, const gchar* prev_hop, GError** error) {
	NetsukukuImplLinuxLinuxRoute * self;
	const gchar* _tmp0_;
	gint _tmp1_ = 0;
	gint idn;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuImplLinuxLinuxRoute*) base;
	g_return_if_fail (ip != NULL);
	g_return_if_fail (cidr != NULL);
	g_return_if_fail (prev_hop != NULL);
	_tmp0_ = prev_hop;
	_tmp1_ = _netsukuku_impl_linux_linux_route_table_for_macaddr (self, _tmp0_, &_inner_error_);
	idn = _tmp1_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp2_ = g_strdup_printf ("%i", idn);
	_tmp3_ = _tmp2_;
	_tmp4_ = ip;
	_tmp5_ = string_to_string (_tmp4_);
	_tmp6_ = cidr;
	_tmp7_ = string_to_string (_tmp6_);
	_tmp8_ = g_strconcat ("route add table ", _tmp3_, " blackhole ", _tmp5_, "/", _tmp7_, NULL);
	_tmp9_ = _tmp8_;
	netsukuku_impl_linux_iproute_exp (_tmp9_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp3_);
}


/** Change a route (that was existent) towards ip/cidr
          * for packets generated by this host.
          * The gateways are route_solutions.
          * The old gateways were old_route_solutions
          */
static void netsukuku_impl_linux_linux_route_real__change_outgoing_route (NetsukukuRouteSetter* base, const gchar* ip, const gchar* cidr, NetsukukuRouteSolutions* route_solutions, NetsukukuRouteSolutions* old_route_solutions) {
	NetsukukuImplLinuxLinuxRoute * self;
	const gchar* _tmp0_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	NetsukukuRouteSolutions* _tmp21_;
	gchar* _tmp22_ = NULL;
	gchar* _tmp23_;
	self = (NetsukukuImplLinuxLinuxRoute*) base;
	g_return_if_fail (ip != NULL);
	g_return_if_fail (cidr != NULL);
	g_return_if_fail (route_solutions != NULL);
	g_return_if_fail (old_route_solutions != NULL);
	_tmp0_ = cidr;
	if (g_strcmp0 (_tmp0_, "32") == 0) {
		NetsukukuRouteSolutions* _tmp1_;
		const gchar* _tmp2_;
		gboolean _tmp3_ = FALSE;
		_tmp1_ = route_solutions;
		_tmp2_ = ip;
		_tmp3_ = netsukuku_route_solutions_contains_gw (_tmp1_, _tmp2_);
		if (_tmp3_) {
			NetsukukuRouteSolutions* _tmp4_;
			const gchar* _tmp5_;
			gboolean _tmp6_ = FALSE;
			_tmp4_ = old_route_solutions;
			_tmp5_ = ip;
			_tmp6_ = netsukuku_route_solutions_contains_gw (_tmp4_, _tmp5_);
			if (_tmp6_) {
				return;
			} else {
				const gchar* _tmp7_;
				const gchar* _tmp8_;
				gchar* _tmp9_ = NULL;
				gchar* _tmp10_;
				_tmp7_ = ip;
				_tmp8_ = cidr;
				_tmp9_ = _netsukuku_impl_linux_linux_route_modify_routes_cmd (self, "del", _tmp7_, _tmp8_, NULL, NULL);
				_tmp10_ = _tmp9_;
				netsukuku_impl_linux_iproute_exp (_tmp10_);
				_g_free0 (_tmp10_);
				return;
			}
		} else {
			NetsukukuRouteSolutions* _tmp11_;
			const gchar* _tmp12_;
			gboolean _tmp13_ = FALSE;
			_tmp11_ = old_route_solutions;
			_tmp12_ = ip;
			_tmp13_ = netsukuku_route_solutions_contains_gw (_tmp11_, _tmp12_);
			if (_tmp13_) {
				const gchar* _tmp14_;
				const gchar* _tmp15_;
				NetsukukuRouteSolutions* _tmp16_;
				gchar* _tmp17_ = NULL;
				gchar* _tmp18_;
				_tmp14_ = ip;
				_tmp15_ = cidr;
				_tmp16_ = route_solutions;
				_tmp17_ = _netsukuku_impl_linux_linux_route_modify_routes_cmd (self, "add", _tmp14_, _tmp15_, _tmp16_, NULL);
				_tmp18_ = _tmp17_;
				netsukuku_impl_linux_iproute_exp (_tmp18_);
				_g_free0 (_tmp18_);
				return;
			}
		}
	}
	_tmp19_ = ip;
	_tmp20_ = cidr;
	_tmp21_ = route_solutions;
	_tmp22_ = _netsukuku_impl_linux_linux_route_modify_routes_cmd (self, "change", _tmp19_, _tmp20_, _tmp21_, NULL);
	_tmp23_ = _tmp22_;
	netsukuku_impl_linux_iproute_exp (_tmp23_);
	_g_free0 (_tmp23_);
}


/** Change a route (that was existent) towards ip/cidr
          * for packets coming from MAC prev_hop.
          * The gateways are route_solutions.
          * The old gateways were old_route_solutions
          */
static void netsukuku_impl_linux_linux_route_real__change_forwarding_route (NetsukukuRouteSetter* base, const gchar* ip, const gchar* cidr, const gchar* prev_hop, NetsukukuRouteSolutions* route_solutions, NetsukukuRouteSolutions* old_route_solutions, GError** error) {
	NetsukukuImplLinuxLinuxRoute * self;
	const gchar* _tmp0_;
	gint _tmp1_ = 0;
	gint idn;
	const gchar* _tmp2_;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	NetsukukuRouteSolutions* _tmp27_;
	gchar* _tmp28_ = NULL;
	gchar* _tmp29_;
	gchar* _tmp30_ = NULL;
	gchar* _tmp31_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuImplLinuxLinuxRoute*) base;
	g_return_if_fail (ip != NULL);
	g_return_if_fail (cidr != NULL);
	g_return_if_fail (prev_hop != NULL);
	g_return_if_fail (route_solutions != NULL);
	g_return_if_fail (old_route_solutions != NULL);
	_tmp0_ = prev_hop;
	_tmp1_ = _netsukuku_impl_linux_linux_route_table_for_macaddr (self, _tmp0_, &_inner_error_);
	idn = _tmp1_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp2_ = cidr;
	if (g_strcmp0 (_tmp2_, "32") == 0) {
		NetsukukuRouteSolutions* _tmp3_;
		const gchar* _tmp4_;
		gboolean _tmp5_ = FALSE;
		_tmp3_ = route_solutions;
		_tmp4_ = ip;
		_tmp5_ = netsukuku_route_solutions_contains_gw (_tmp3_, _tmp4_);
		if (_tmp5_) {
			NetsukukuRouteSolutions* _tmp6_;
			const gchar* _tmp7_;
			gboolean _tmp8_ = FALSE;
			_tmp6_ = old_route_solutions;
			_tmp7_ = ip;
			_tmp8_ = netsukuku_route_solutions_contains_gw (_tmp6_, _tmp7_);
			if (_tmp8_) {
				return;
			} else {
				const gchar* _tmp9_;
				const gchar* _tmp10_;
				gchar* _tmp11_ = NULL;
				gchar* _tmp12_;
				gchar* _tmp13_ = NULL;
				gchar* _tmp14_;
				_tmp9_ = ip;
				_tmp10_ = cidr;
				_tmp11_ = g_strdup_printf ("%i", idn);
				_tmp12_ = _tmp11_;
				_tmp13_ = _netsukuku_impl_linux_linux_route_modify_routes_cmd (self, "del", _tmp9_, _tmp10_, NULL, _tmp12_);
				_tmp14_ = _tmp13_;
				netsukuku_impl_linux_iproute_exp (_tmp14_);
				_g_free0 (_tmp14_);
				_g_free0 (_tmp12_);
				return;
			}
		} else {
			NetsukukuRouteSolutions* _tmp15_;
			const gchar* _tmp16_;
			gboolean _tmp17_ = FALSE;
			_tmp15_ = old_route_solutions;
			_tmp16_ = ip;
			_tmp17_ = netsukuku_route_solutions_contains_gw (_tmp15_, _tmp16_);
			if (_tmp17_) {
				const gchar* _tmp18_;
				const gchar* _tmp19_;
				NetsukukuRouteSolutions* _tmp20_;
				gchar* _tmp21_ = NULL;
				gchar* _tmp22_;
				gchar* _tmp23_ = NULL;
				gchar* _tmp24_;
				_tmp18_ = ip;
				_tmp19_ = cidr;
				_tmp20_ = route_solutions;
				_tmp21_ = g_strdup_printf ("%i", idn);
				_tmp22_ = _tmp21_;
				_tmp23_ = _netsukuku_impl_linux_linux_route_modify_routes_cmd (self, "add", _tmp18_, _tmp19_, _tmp20_, _tmp22_);
				_tmp24_ = _tmp23_;
				netsukuku_impl_linux_iproute_exp (_tmp24_);
				_g_free0 (_tmp24_);
				_g_free0 (_tmp22_);
				return;
			}
		}
	}
	_tmp25_ = ip;
	_tmp26_ = cidr;
	_tmp27_ = route_solutions;
	_tmp28_ = g_strdup_printf ("%i", idn);
	_tmp29_ = _tmp28_;
	_tmp30_ = _netsukuku_impl_linux_linux_route_modify_routes_cmd (self, "change", _tmp25_, _tmp26_, _tmp27_, _tmp29_);
	_tmp31_ = _tmp30_;
	netsukuku_impl_linux_iproute_exp (_tmp31_);
	_g_free0 (_tmp31_);
	_g_free0 (_tmp29_);
}


/** Change a route (that was existent) towards ip/cidr
          * for packets coming from MAC prev_hop.
          * In fact this route is UNREACHABLE
          * The old gateways were old_route_solutions
          */
static void netsukuku_impl_linux_linux_route_real__change_forwarding_route_unreachable (NetsukukuRouteSetter* base, const gchar* ip, const gchar* cidr, const gchar* prev_hop, NetsukukuRouteSolutions* old_route_solutions, GError** error) {
	NetsukukuImplLinuxLinuxRoute * self;
	const gchar* _tmp0_;
	gint _tmp1_ = 0;
	gint idn;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gboolean _tmp7_;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_ = NULL;
	const gchar* _tmp20_;
	const gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	gchar* _tmp23_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuImplLinuxLinuxRoute*) base;
	g_return_if_fail (ip != NULL);
	g_return_if_fail (cidr != NULL);
	g_return_if_fail (prev_hop != NULL);
	g_return_if_fail (old_route_solutions != NULL);
	_tmp0_ = prev_hop;
	_tmp1_ = _netsukuku_impl_linux_linux_route_table_for_macaddr (self, _tmp0_, &_inner_error_);
	idn = _tmp1_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp3_ = cidr;
	if (g_strcmp0 (_tmp3_, "32") == 0) {
		NetsukukuRouteSolutions* _tmp4_;
		const gchar* _tmp5_;
		gboolean _tmp6_ = FALSE;
		_tmp4_ = old_route_solutions;
		_tmp5_ = ip;
		_tmp6_ = netsukuku_route_solutions_contains_gw (_tmp4_, _tmp5_);
		_tmp2_ = _tmp6_;
	} else {
		_tmp2_ = FALSE;
	}
	_tmp7_ = _tmp2_;
	if (_tmp7_) {
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_ = NULL;
		const gchar* _tmp12_;
		const gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_;
		_tmp8_ = g_strdup_printf ("%i", idn);
		_tmp9_ = _tmp8_;
		_tmp10_ = ip;
		_tmp11_ = string_to_string (_tmp10_);
		_tmp12_ = cidr;
		_tmp13_ = string_to_string (_tmp12_);
		_tmp14_ = g_strconcat ("route add table ", _tmp9_, " unreachable ", _tmp11_, "/", _tmp13_, NULL);
		_tmp15_ = _tmp14_;
		netsukuku_impl_linux_iproute_exp (_tmp15_);
		_g_free0 (_tmp15_);
		_g_free0 (_tmp9_);
		return;
	}
	_tmp16_ = g_strdup_printf ("%i", idn);
	_tmp17_ = _tmp16_;
	_tmp18_ = ip;
	_tmp19_ = string_to_string (_tmp18_);
	_tmp20_ = cidr;
	_tmp21_ = string_to_string (_tmp20_);
	_tmp22_ = g_strconcat ("route change table ", _tmp17_, " unreachable ", _tmp19_, "/", _tmp21_, NULL);
	_tmp23_ = _tmp22_;
	netsukuku_impl_linux_iproute_exp (_tmp23_);
	_g_free0 (_tmp23_);
	_g_free0 (_tmp17_);
}


/** Change a route (that was existent) towards ip/cidr
          * for packets coming from MAC prev_hop.
          * In fact this route is DROP
          * The old gateways were old_route_solutions
          */
static void netsukuku_impl_linux_linux_route_real__change_forwarding_route_drop (NetsukukuRouteSetter* base, const gchar* ip, const gchar* cidr, const gchar* prev_hop, NetsukukuRouteSolutions* old_route_solutions, GError** error) {
	NetsukukuImplLinuxLinuxRoute * self;
	const gchar* _tmp0_;
	gint _tmp1_ = 0;
	gint idn;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gboolean _tmp7_;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_ = NULL;
	const gchar* _tmp20_;
	const gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	gchar* _tmp23_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuImplLinuxLinuxRoute*) base;
	g_return_if_fail (ip != NULL);
	g_return_if_fail (cidr != NULL);
	g_return_if_fail (prev_hop != NULL);
	g_return_if_fail (old_route_solutions != NULL);
	_tmp0_ = prev_hop;
	_tmp1_ = _netsukuku_impl_linux_linux_route_table_for_macaddr (self, _tmp0_, &_inner_error_);
	idn = _tmp1_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp3_ = cidr;
	if (g_strcmp0 (_tmp3_, "32") == 0) {
		NetsukukuRouteSolutions* _tmp4_;
		const gchar* _tmp5_;
		gboolean _tmp6_ = FALSE;
		_tmp4_ = old_route_solutions;
		_tmp5_ = ip;
		_tmp6_ = netsukuku_route_solutions_contains_gw (_tmp4_, _tmp5_);
		_tmp2_ = _tmp6_;
	} else {
		_tmp2_ = FALSE;
	}
	_tmp7_ = _tmp2_;
	if (_tmp7_) {
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_ = NULL;
		const gchar* _tmp12_;
		const gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_;
		_tmp8_ = g_strdup_printf ("%i", idn);
		_tmp9_ = _tmp8_;
		_tmp10_ = ip;
		_tmp11_ = string_to_string (_tmp10_);
		_tmp12_ = cidr;
		_tmp13_ = string_to_string (_tmp12_);
		_tmp14_ = g_strconcat ("route add table ", _tmp9_, " blackhole ", _tmp11_, "/", _tmp13_, NULL);
		_tmp15_ = _tmp14_;
		netsukuku_impl_linux_iproute_exp (_tmp15_);
		_g_free0 (_tmp15_);
		_g_free0 (_tmp9_);
		return;
	}
	_tmp16_ = g_strdup_printf ("%i", idn);
	_tmp17_ = _tmp16_;
	_tmp18_ = ip;
	_tmp19_ = string_to_string (_tmp18_);
	_tmp20_ = cidr;
	_tmp21_ = string_to_string (_tmp20_);
	_tmp22_ = g_strconcat ("route change table ", _tmp17_, " blackhole ", _tmp19_, "/", _tmp21_, NULL);
	_tmp23_ = _tmp22_;
	netsukuku_impl_linux_iproute_exp (_tmp23_);
	_g_free0 (_tmp23_);
	_g_free0 (_tmp17_);
}


/** Change a route (that was existent) towards ip/cidr
          * for packets coming from MAC prev_hop.
          * The gateways are route_solutions.
          * Previously the route was UNREACHABLE
          */
static void netsukuku_impl_linux_linux_route_real__change_forwarding_route_was_unreachable (NetsukukuRouteSetter* base, const gchar* ip, const gchar* cidr, const gchar* prev_hop, NetsukukuRouteSolutions* route_solutions, GError** error) {
	NetsukukuImplLinuxLinuxRoute * self;
	const gchar* _tmp0_;
	gint _tmp1_ = 0;
	gint idn;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gboolean _tmp7_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	NetsukukuRouteSolutions* _tmp18_;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuImplLinuxLinuxRoute*) base;
	g_return_if_fail (ip != NULL);
	g_return_if_fail (cidr != NULL);
	g_return_if_fail (prev_hop != NULL);
	g_return_if_fail (route_solutions != NULL);
	_tmp0_ = prev_hop;
	_tmp1_ = _netsukuku_impl_linux_linux_route_table_for_macaddr (self, _tmp0_, &_inner_error_);
	idn = _tmp1_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp3_ = cidr;
	if (g_strcmp0 (_tmp3_, "32") == 0) {
		NetsukukuRouteSolutions* _tmp4_;
		const gchar* _tmp5_;
		gboolean _tmp6_ = FALSE;
		_tmp4_ = route_solutions;
		_tmp5_ = ip;
		_tmp6_ = netsukuku_route_solutions_contains_gw (_tmp4_, _tmp5_);
		_tmp2_ = _tmp6_;
	} else {
		_tmp2_ = FALSE;
	}
	_tmp7_ = _tmp2_;
	if (_tmp7_) {
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_ = NULL;
		const gchar* _tmp12_;
		const gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_;
		_tmp8_ = g_strdup_printf ("%i", idn);
		_tmp9_ = _tmp8_;
		_tmp10_ = ip;
		_tmp11_ = string_to_string (_tmp10_);
		_tmp12_ = cidr;
		_tmp13_ = string_to_string (_tmp12_);
		_tmp14_ = g_strconcat ("route del table ", _tmp9_, " unreachable ", _tmp11_, "/", _tmp13_, NULL);
		_tmp15_ = _tmp14_;
		netsukuku_impl_linux_iproute_exp (_tmp15_);
		_g_free0 (_tmp15_);
		_g_free0 (_tmp9_);
		return;
	}
	_tmp16_ = ip;
	_tmp17_ = cidr;
	_tmp18_ = route_solutions;
	_tmp19_ = g_strdup_printf ("%i", idn);
	_tmp20_ = _tmp19_;
	_tmp21_ = _netsukuku_impl_linux_linux_route_modify_routes_cmd (self, "change", _tmp16_, _tmp17_, _tmp18_, _tmp20_);
	_tmp22_ = _tmp21_;
	netsukuku_impl_linux_iproute_exp (_tmp22_);
	_g_free0 (_tmp22_);
	_g_free0 (_tmp20_);
}


/** Change a route (that was existent) towards ip/cidr
          * for packets coming from MAC prev_hop.
          * In fact now this route is DROP
          * Previously the route was UNREACHABLE
          */
static void netsukuku_impl_linux_linux_route_real__change_forwarding_route_drop_was_unreachable (NetsukukuRouteSetter* base, const gchar* ip, const gchar* cidr, const gchar* prev_hop, GError** error) {
	NetsukukuImplLinuxLinuxRoute * self;
	const gchar* _tmp0_;
	gint _tmp1_ = 0;
	gint idn;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuImplLinuxLinuxRoute*) base;
	g_return_if_fail (ip != NULL);
	g_return_if_fail (cidr != NULL);
	g_return_if_fail (prev_hop != NULL);
	_tmp0_ = prev_hop;
	_tmp1_ = _netsukuku_impl_linux_linux_route_table_for_macaddr (self, _tmp0_, &_inner_error_);
	idn = _tmp1_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp2_ = g_strdup_printf ("%i", idn);
	_tmp3_ = _tmp2_;
	_tmp4_ = ip;
	_tmp5_ = string_to_string (_tmp4_);
	_tmp6_ = cidr;
	_tmp7_ = string_to_string (_tmp6_);
	_tmp8_ = g_strconcat ("route change table ", _tmp3_, " blackhole ", _tmp5_, "/", _tmp7_, NULL);
	_tmp9_ = _tmp8_;
	netsukuku_impl_linux_iproute_exp (_tmp9_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp3_);
}


/** Change a route (that was existent) towards ip/cidr
          * for packets coming from MAC prev_hop.
          * The gateways are route_solutions.
          * Previously the route was DROP
          */
static void netsukuku_impl_linux_linux_route_real__change_forwarding_route_was_drop (NetsukukuRouteSetter* base, const gchar* ip, const gchar* cidr, const gchar* prev_hop, NetsukukuRouteSolutions* route_solutions, GError** error) {
	NetsukukuImplLinuxLinuxRoute * self;
	const gchar* _tmp0_;
	gint _tmp1_ = 0;
	gint idn;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gboolean _tmp7_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	NetsukukuRouteSolutions* _tmp18_;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuImplLinuxLinuxRoute*) base;
	g_return_if_fail (ip != NULL);
	g_return_if_fail (cidr != NULL);
	g_return_if_fail (prev_hop != NULL);
	g_return_if_fail (route_solutions != NULL);
	_tmp0_ = prev_hop;
	_tmp1_ = _netsukuku_impl_linux_linux_route_table_for_macaddr (self, _tmp0_, &_inner_error_);
	idn = _tmp1_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp3_ = cidr;
	if (g_strcmp0 (_tmp3_, "32") == 0) {
		NetsukukuRouteSolutions* _tmp4_;
		const gchar* _tmp5_;
		gboolean _tmp6_ = FALSE;
		_tmp4_ = route_solutions;
		_tmp5_ = ip;
		_tmp6_ = netsukuku_route_solutions_contains_gw (_tmp4_, _tmp5_);
		_tmp2_ = _tmp6_;
	} else {
		_tmp2_ = FALSE;
	}
	_tmp7_ = _tmp2_;
	if (_tmp7_) {
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_ = NULL;
		const gchar* _tmp12_;
		const gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_;
		_tmp8_ = g_strdup_printf ("%i", idn);
		_tmp9_ = _tmp8_;
		_tmp10_ = ip;
		_tmp11_ = string_to_string (_tmp10_);
		_tmp12_ = cidr;
		_tmp13_ = string_to_string (_tmp12_);
		_tmp14_ = g_strconcat ("route del table ", _tmp9_, " blackhole ", _tmp11_, "/", _tmp13_, NULL);
		_tmp15_ = _tmp14_;
		netsukuku_impl_linux_iproute_exp (_tmp15_);
		_g_free0 (_tmp15_);
		_g_free0 (_tmp9_);
		return;
	}
	_tmp16_ = ip;
	_tmp17_ = cidr;
	_tmp18_ = route_solutions;
	_tmp19_ = g_strdup_printf ("%i", idn);
	_tmp20_ = _tmp19_;
	_tmp21_ = _netsukuku_impl_linux_linux_route_modify_routes_cmd (self, "change", _tmp16_, _tmp17_, _tmp18_, _tmp20_);
	_tmp22_ = _tmp21_;
	netsukuku_impl_linux_iproute_exp (_tmp22_);
	_g_free0 (_tmp22_);
	_g_free0 (_tmp20_);
}


/** Change a route (that was existent) towards ip/cidr
          * for packets coming from MAC prev_hop.
          * In fact now this route is UNREACHABLE
          * Previously the route was DROP
          */
static void netsukuku_impl_linux_linux_route_real__change_forwarding_route_unreachable_was_drop (NetsukukuRouteSetter* base, const gchar* ip, const gchar* cidr, const gchar* prev_hop, GError** error) {
	NetsukukuImplLinuxLinuxRoute * self;
	const gchar* _tmp0_;
	gint _tmp1_ = 0;
	gint idn;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuImplLinuxLinuxRoute*) base;
	g_return_if_fail (ip != NULL);
	g_return_if_fail (cidr != NULL);
	g_return_if_fail (prev_hop != NULL);
	_tmp0_ = prev_hop;
	_tmp1_ = _netsukuku_impl_linux_linux_route_table_for_macaddr (self, _tmp0_, &_inner_error_);
	idn = _tmp1_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp2_ = g_strdup_printf ("%i", idn);
	_tmp3_ = _tmp2_;
	_tmp4_ = ip;
	_tmp5_ = string_to_string (_tmp4_);
	_tmp6_ = cidr;
	_tmp7_ = string_to_string (_tmp6_);
	_tmp8_ = g_strconcat ("route change table ", _tmp3_, " unreachable ", _tmp5_, "/", _tmp7_, NULL);
	_tmp9_ = _tmp8_;
	netsukuku_impl_linux_iproute_exp (_tmp9_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp3_);
}


/** Remove a route (that was existent) towards ip/cidr
          * for packets generated by this host.
          * The old gateways were old_route_solutions
          */
static void netsukuku_impl_linux_linux_route_real__remove_outgoing_route (NetsukukuRouteSetter* base, const gchar* ip, const gchar* cidr, NetsukukuRouteSolutions* old_route_solutions) {
	NetsukukuImplLinuxLinuxRoute * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	self = (NetsukukuImplLinuxLinuxRoute*) base;
	g_return_if_fail (ip != NULL);
	g_return_if_fail (cidr != NULL);
	g_return_if_fail (old_route_solutions != NULL);
	_tmp0_ = ip;
	_tmp1_ = cidr;
	_tmp2_ = _netsukuku_impl_linux_linux_route_modify_routes_cmd (self, "del", _tmp0_, _tmp1_, NULL, NULL);
	_tmp3_ = _tmp2_;
	netsukuku_impl_linux_iproute_exp (_tmp3_);
	_g_free0 (_tmp3_);
}


/** Remove a route (that was existent) towards ip/cidr
          * for packets coming from MAC prev_hop.
          * The old gateways were old_route_solutions
          */
static void netsukuku_impl_linux_linux_route_real__remove_forwarding_route (NetsukukuRouteSetter* base, const gchar* ip, const gchar* cidr, const gchar* prev_hop, NetsukukuRouteSolutions* old_route_solutions, GError** error) {
	NetsukukuImplLinuxLinuxRoute * self;
	const gchar* _tmp0_;
	gint _tmp1_ = 0;
	gint idn;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuImplLinuxLinuxRoute*) base;
	g_return_if_fail (ip != NULL);
	g_return_if_fail (cidr != NULL);
	g_return_if_fail (prev_hop != NULL);
	g_return_if_fail (old_route_solutions != NULL);
	_tmp0_ = prev_hop;
	_tmp1_ = _netsukuku_impl_linux_linux_route_table_for_macaddr (self, _tmp0_, &_inner_error_);
	idn = _tmp1_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp2_ = ip;
	_tmp3_ = cidr;
	_tmp4_ = g_strdup_printf ("%i", idn);
	_tmp5_ = _tmp4_;
	_tmp6_ = _netsukuku_impl_linux_linux_route_modify_routes_cmd (self, "del", _tmp2_, _tmp3_, NULL, _tmp5_);
	_tmp7_ = _tmp6_;
	netsukuku_impl_linux_iproute_exp (_tmp7_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
}


/** Remove a route (that was existent) towards ip/cidr
          * for packets coming from MAC prev_hop.
          * Previously the route was UNREACHABLE
          */
static void netsukuku_impl_linux_linux_route_real__remove_forwarding_route_was_unreachable (NetsukukuRouteSetter* base, const gchar* ip, const gchar* cidr, const gchar* prev_hop, GError** error) {
	NetsukukuImplLinuxLinuxRoute * self;
	const gchar* _tmp0_;
	gint _tmp1_ = 0;
	gint idn;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuImplLinuxLinuxRoute*) base;
	g_return_if_fail (ip != NULL);
	g_return_if_fail (cidr != NULL);
	g_return_if_fail (prev_hop != NULL);
	_tmp0_ = prev_hop;
	_tmp1_ = _netsukuku_impl_linux_linux_route_table_for_macaddr (self, _tmp0_, &_inner_error_);
	idn = _tmp1_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp2_ = ip;
	_tmp3_ = cidr;
	_tmp4_ = g_strdup_printf ("%i", idn);
	_tmp5_ = _tmp4_;
	_tmp6_ = _netsukuku_impl_linux_linux_route_modify_routes_cmd (self, "del", _tmp2_, _tmp3_, NULL, _tmp5_);
	_tmp7_ = _tmp6_;
	netsukuku_impl_linux_iproute_exp (_tmp7_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
}


/** Remove a route (that was existent) towards ip/cidr
          * for packets coming from MAC prev_hop.
          * Previously the route was DROP
          */
static void netsukuku_impl_linux_linux_route_real__remove_forwarding_route_was_drop (NetsukukuRouteSetter* base, const gchar* ip, const gchar* cidr, const gchar* prev_hop, GError** error) {
	NetsukukuImplLinuxLinuxRoute * self;
	const gchar* _tmp0_;
	gint _tmp1_ = 0;
	gint idn;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuImplLinuxLinuxRoute*) base;
	g_return_if_fail (ip != NULL);
	g_return_if_fail (cidr != NULL);
	g_return_if_fail (prev_hop != NULL);
	_tmp0_ = prev_hop;
	_tmp1_ = _netsukuku_impl_linux_linux_route_table_for_macaddr (self, _tmp0_, &_inner_error_);
	idn = _tmp1_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp2_ = ip;
	_tmp3_ = cidr;
	_tmp4_ = g_strdup_printf ("%i", idn);
	_tmp5_ = _tmp4_;
	_tmp6_ = _netsukuku_impl_linux_linux_route_modify_routes_cmd (self, "del", _tmp2_, _tmp3_, NULL, _tmp5_);
	_tmp7_ = _tmp6_;
	netsukuku_impl_linux_iproute_exp (_tmp7_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
}


/** Stop forwarding (in fact it means delete all rules for...)
          * packets coming from MAC prev_hop.
          */
static void netsukuku_impl_linux_linux_route_real__forward_no_more_from (NetsukukuRouteSetter* base, const gchar* _prev_hop, GError** error) {
	NetsukukuImplLinuxLinuxRoute * self;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* prev_hop;
	GeeHashMap* _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	GError * _inner_error_ = NULL;
	self = (NetsukukuImplLinuxLinuxRoute*) base;
	g_return_if_fail (_prev_hop != NULL);
	_tmp0_ = _prev_hop;
	_tmp1_ = g_utf8_strdown (_tmp0_, (gssize) (-1));
	prev_hop = _tmp1_;
	_tmp2_ = self->priv->mac_table;
	_tmp3_ = prev_hop;
	_tmp4_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp2_, _tmp3_);
	if (_tmp4_) {
		const gchar* _tmp5_;
		gint _tmp6_ = 0;
		gint idn;
		const gchar* _tmp25_;
		_tmp5_ = prev_hop;
		_tmp6_ = _netsukuku_impl_linux_linux_route_table_for_macaddr (self, _tmp5_, &_inner_error_);
		idn = _tmp6_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (prev_hop);
			return;
		}
		{
			gint _tmp7_;
			gchar* _tmp8_ = NULL;
			gchar* _tmp9_;
			gchar* _tmp10_ = NULL;
			gchar* _tmp11_;
			gchar* _tmp12_ = NULL;
			gchar* _tmp13_;
			_tmp7_ = idn;
			_tmp8_ = g_strdup_printf ("%i", _tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = g_strconcat ("route flush table ", _tmp9_, NULL);
			_tmp11_ = _tmp10_;
			_tmp12_ = netsukuku_impl_linux_iproute (_tmp11_, &_inner_error_);
			_tmp13_ = _tmp12_;
			_g_free0 (_tmp13_);
			_g_free0 (_tmp11_);
			_g_free0 (_tmp9_);
			if (_inner_error_ != NULL) {
				goto __catch78_g_error;
			}
		}
		goto __finally78;
		__catch78_g_error:
		{
			GError* e = NULL;
			GError* _tmp14_;
			const gchar* _tmp15_;
			gboolean _tmp16_ = FALSE;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp14_ = e;
			_tmp15_ = _tmp14_->message;
			_tmp16_ = string_contains (_tmp15_, "Nothing to flush");
			if (!_tmp16_) {
				gint _tmp17_;
				gchar* _tmp18_ = NULL;
				gchar* _tmp19_;
				GError* _tmp20_;
				const gchar* _tmp21_;
				const gchar* _tmp22_ = NULL;
				gchar* _tmp23_ = NULL;
				gchar* _tmp24_;
				_tmp17_ = idn;
				_tmp18_ = g_strdup_printf ("%i", _tmp17_);
				_tmp19_ = _tmp18_;
				_tmp20_ = e;
				_tmp21_ = _tmp20_->message;
				_tmp22_ = string_to_string (_tmp21_);
				_tmp23_ = g_strconcat ("ip route flush table ", _tmp19_, ": reported ", _tmp22_, ". Perhaps better to abort?", NULL);
				_tmp24_ = _tmp23_;
				netsukuku_log_error (_tmp24_);
				_g_free0 (_tmp24_);
				_g_free0 (_tmp19_);
			}
			_g_error_free0 (e);
		}
		__finally78:
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (prev_hop);
			return;
		}
		_tmp25_ = prev_hop;
		_netsukuku_impl_linux_linux_route_table_for_macaddr_remove (self, _tmp25_, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (prev_hop);
			return;
		}
	}
	_g_free0 (prev_hop);
}


/** Delete all specific rules for any prev_hop.
          */
static void netsukuku_impl_linux_linux_route_real__forward_no_more (NetsukukuRouteSetter* base, GError** error) {
	NetsukukuImplLinuxLinuxRoute * self;
	GError * _inner_error_ = NULL;
	self = (NetsukukuImplLinuxLinuxRoute*) base;
	_netsukuku_impl_linux_linux_route_table_for_macaddr_remove_all (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


/** Adds a new neighbour with corresponding properties.
          */
static void netsukuku_impl_linux_linux_route_real__add_neighbour (NetsukukuRouteSetter* base, const gchar* ip, const gchar* dev, const gchar* pref_src) {
	NetsukukuImplLinuxLinuxRoute * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	self = (NetsukukuImplLinuxLinuxRoute*) base;
	g_return_if_fail (ip != NULL);
	g_return_if_fail (dev != NULL);
	g_return_if_fail (pref_src != NULL);
	_tmp0_ = ip;
	_tmp1_ = dev;
	_tmp2_ = pref_src;
	_tmp3_ = _netsukuku_impl_linux_linux_route_modify_neighbour_cmd (self, "add", _tmp0_, _tmp1_, _tmp2_);
	_tmp4_ = _tmp3_;
	netsukuku_impl_linux_iproute_exp (_tmp4_);
	_g_free0 (_tmp4_);
}


/** Edits the neighbour with the corresponding properties.
          */
static void netsukuku_impl_linux_linux_route_real__change_neighbour (NetsukukuRouteSetter* base, const gchar* ip, const gchar* dev, const gchar* pref_src, const gchar* old_dev) {
	NetsukukuImplLinuxLinuxRoute * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	self = (NetsukukuImplLinuxLinuxRoute*) base;
	g_return_if_fail (ip != NULL);
	g_return_if_fail (dev != NULL);
	g_return_if_fail (pref_src != NULL);
	g_return_if_fail (old_dev != NULL);
	_tmp0_ = ip;
	_tmp1_ = dev;
	_tmp2_ = pref_src;
	_tmp3_ = _netsukuku_impl_linux_linux_route_modify_neighbour_cmd (self, "change", _tmp0_, _tmp1_, _tmp2_);
	_tmp4_ = _tmp3_;
	netsukuku_impl_linux_iproute_exp (_tmp4_);
	_g_free0 (_tmp4_);
}


/** Removes the neighbour with the corresponding properties.
          */
static void netsukuku_impl_linux_linux_route_real__delete_neighbour (NetsukukuRouteSetter* base, const gchar* ip, const gchar* old_dev) {
	NetsukukuImplLinuxLinuxRoute * self;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	self = (NetsukukuImplLinuxLinuxRoute*) base;
	g_return_if_fail (ip != NULL);
	g_return_if_fail (old_dev != NULL);
	_tmp0_ = ip;
	_tmp1_ = _netsukuku_impl_linux_linux_route_modify_neighbour_cmd (self, "del", _tmp0_, NULL, NULL);
	_tmp2_ = _tmp1_;
	netsukuku_impl_linux_iproute_exp (_tmp2_);
	_g_free0 (_tmp2_);
}


/** IGS management **/
void _netsukuku_impl_linux_linux_route_disable_rp_filter (NetsukukuImplLinuxLinuxRoute* self, const gchar* nicname) {
	const gchar* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* path;
	gchar* _tmp3_;
	gchar* content;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (nicname != NULL);
	_tmp0_ = nicname;
	_tmp1_ = string_to_string (_tmp0_);
	_tmp2_ = g_strconcat ("/proc/sys/net/ipv4/conf/", _tmp1_, "/rp_filter", NULL);
	path = _tmp2_;
	_tmp3_ = g_strdup ("0");
	content = _tmp3_;
	{
		guint8* _tmp4_;
		gint _tmp4__length1;
		guint8* _tmp5_;
		gint _tmp5__length1;
		_tmp4_ = string_get_data (content, &_tmp4__length1);
		_tmp5_ = _tmp4_;
		_tmp5__length1 = _tmp4__length1;
		netsukuku_impl_linux_write_file (path, _tmp5_, _tmp5__length1);
	}
	goto __finally79;
	__catch79_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = string_to_string (content);
		_tmp7_ = string_to_string (path);
		_tmp8_ = g_strconcat ("rp_filter: error (ignored) writing '", _tmp6_, "' in '", _tmp7_, "'", NULL);
		_tmp9_ = _tmp8_;
		netsukuku_log_error (_tmp9_);
		_g_free0 (_tmp9_);
		_g_error_free0 (e);
	}
	__finally79:
	if (_inner_error_ != NULL) {
		_g_free0 (content);
		_g_free0 (path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (content);
	_g_free0 (path);
}


static gboolean netsukuku_impl_linux_linux_route_real__igs_update_rules (NetsukukuRouteSetter* base, const gchar* prev_mode, gboolean prev_announce_myself, GeeArrayList* prev_list_tunnels, const gchar* mode, gboolean announce_myself, GeeArrayList* list_tunnels, const gchar* pref_src, GError** error) {
	NetsukukuImplLinuxLinuxRoute * self;
	gboolean result = FALSE;
	gchar* _tmp1_;
	gchar* dbg_list_tunnels;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	const gchar* _tmp22_;
	gboolean _tmp23_ = FALSE;
	const gchar* _tmp24_;
	gboolean _tmp26_;
	gboolean _tmp27_ = FALSE;
	const gchar* _tmp28_;
	gboolean _tmp30_;
	gboolean _tmp31_ = FALSE;
	gboolean _tmp32_ = FALSE;
	const gchar* _tmp33_;
	gboolean _tmp35_;
	gboolean _tmp39_;
	gboolean _tmp169_ = FALSE;
	gboolean _tmp170_ = FALSE;
	const gchar* _tmp171_;
	gboolean _tmp173_;
	gboolean _tmp177_;
	gboolean _tmp306_ = FALSE;
	gboolean _tmp307_ = FALSE;
	const gchar* _tmp308_;
	gboolean _tmp310_;
	gboolean _tmp319_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuImplLinuxLinuxRoute*) base;
	g_return_val_if_fail (prev_mode != NULL, FALSE);
	g_return_val_if_fail (prev_list_tunnels != NULL, FALSE);
	g_return_val_if_fail (mode != NULL, FALSE);
	g_return_val_if_fail (list_tunnels != NULL, FALSE);
	g_return_val_if_fail (pref_src != NULL, FALSE);
	{
		TaskletsCommandResult* _tmp0_ = NULL;
		TaskletsCommandResult* com_ret;
		_tmp0_ = netsukuku_impl_linux_exec_command ("modprobe ipip", &_inner_error_);
		com_ret = _tmp0_;
		if (_inner_error_ != NULL) {
			goto __catch80_g_error;
		}
		_g_object_unref0 (com_ret);
	}
	goto __finally80;
	__catch80_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally80:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	_tmp1_ = g_strdup ("{");
	dbg_list_tunnels = _tmp1_;
	{
		GeeArrayList* _tmp2_;
		GeeArrayList* _tmp3_;
		GeeArrayList* _tun_list;
		GeeArrayList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _tun_size;
		gint _tun_index;
		_tmp2_ = list_tunnels;
		_tmp3_ = _g_object_ref0 (_tmp2_);
		_tun_list = _tmp3_;
		_tmp4_ = _tun_list;
		_tmp5_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_tun_size = _tmp6_;
		_tun_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			GeeArrayList* _tmp10_;
			gint _tmp11_;
			gpointer _tmp12_ = NULL;
			NetsukukuTunnelItem* tun;
			const gchar* _tmp13_;
			NetsukukuTunnelItem* _tmp14_;
			gchar* _tmp15_ = NULL;
			gchar* _tmp16_;
			gchar* _tmp17_ = NULL;
			gchar* _tmp18_;
			gchar* _tmp19_;
			_tmp7_ = _tun_index;
			_tun_index = _tmp7_ + 1;
			_tmp8_ = _tun_index;
			_tmp9_ = _tun_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _tun_list;
			_tmp11_ = _tun_index;
			_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, _tmp11_);
			tun = (NetsukukuTunnelItem*) _tmp12_;
			_tmp13_ = dbg_list_tunnels;
			_tmp14_ = tun;
			_tmp15_ = netsukuku_tunnel_item_to_string (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = g_strconcat (_tmp16_, ",", NULL);
			_tmp18_ = _tmp17_;
			_tmp19_ = g_strconcat (_tmp13_, _tmp18_, NULL);
			_g_free0 (dbg_list_tunnels);
			dbg_list_tunnels = _tmp19_;
			_g_free0 (_tmp18_);
			_g_free0 (_tmp16_);
			_g_object_unref0 (tun);
		}
		_g_object_unref0 (_tun_list);
	}
	_tmp20_ = dbg_list_tunnels;
	_tmp21_ = g_strconcat (_tmp20_, "}", NULL);
	_g_free0 (dbg_list_tunnels);
	dbg_list_tunnels = _tmp21_;
	_tmp22_ = mode;
	_vala_assert (g_strcmp0 (_tmp22_, "BOTH") != 0, "mode != \"BOTH\"");
	_tmp24_ = prev_mode;
	if (g_strcmp0 (_tmp24_, "NONE") == 0) {
		const gchar* _tmp25_;
		_tmp25_ = mode;
		_tmp23_ = g_strcmp0 (_tmp25_, "SHARE") == 0;
	} else {
		_tmp23_ = FALSE;
	}
	_tmp26_ = _tmp23_;
	if (_tmp26_) {
		netsukuku_impl_linux_iptables_exp ("-t nat -A POSTROUTING -s 10.0.0.0/8 ! -d 10.0.0.0/8 -j MASQUERADE");
		netsukuku_impl_linux_iproute_exp ("tunnel add ntk-share-inet mode ipip");
		netsukuku_impl_linux_iproute_exp ("link set tunl0 up");
		_netsukuku_impl_linux_linux_route_disable_rp_filter (self, "tunl0");
	}
	_tmp28_ = mode;
	if (g_strcmp0 (_tmp28_, "NONE") == 0) {
		const gchar* _tmp29_;
		_tmp29_ = prev_mode;
		_tmp27_ = g_strcmp0 (_tmp29_, "SHARE") == 0;
	} else {
		_tmp27_ = FALSE;
	}
	_tmp30_ = _tmp27_;
	if (_tmp30_) {
		netsukuku_impl_linux_iptables_exp ("-t nat -D POSTROUTING -s 10.0.0.0/8 ! -d 10.0.0.0/8 -j MASQUERADE");
		netsukuku_impl_linux_iproute_exp ("link set tunl0 down");
		netsukuku_impl_linux_iproute_exp ("tunnel del ntk-share-inet mode ipip");
	}
	_tmp33_ = prev_mode;
	if (g_strcmp0 (_tmp33_, "NONE") == 0) {
		const gchar* _tmp34_;
		_tmp34_ = mode;
		_tmp32_ = g_strcmp0 (_tmp34_, "USE") == 0;
	} else {
		_tmp32_ = FALSE;
	}
	_tmp35_ = _tmp32_;
	if (_tmp35_) {
		GeeArrayList* _tmp36_;
		gboolean _tmp37_;
		gboolean _tmp38_;
		_tmp36_ = list_tunnels;
		_tmp37_ = gee_collection_get_is_empty ((GeeCollection*) _tmp36_);
		_tmp38_ = _tmp37_;
		_tmp31_ = !_tmp38_;
	} else {
		_tmp31_ = FALSE;
	}
	_tmp39_ = _tmp31_;
	if (_tmp39_) {
		gint* _tmp40_ = NULL;
		gint* weights;
		gint weights_length1;
		gint _weights_size_;
		gint i;
		gchar* _tmp79_ = NULL;
		gchar* _tmp80_;
		gchar* _tmp129_;
		gchar* cmd;
		const gchar* _tmp168_;
		_tmp40_ = g_new0 (gint, 10);
		_tmp40_[0] = 1;
		_tmp40_[1] = 3;
		_tmp40_[2] = 6;
		_tmp40_[3] = 10;
		_tmp40_[4] = 30;
		_tmp40_[5] = 60;
		_tmp40_[6] = 100;
		_tmp40_[7] = 150;
		_tmp40_[8] = 200;
		_tmp40_[9] = 255;
		weights = _tmp40_;
		weights_length1 = 10;
		_weights_size_ = weights_length1;
		i = 0;
		{
			GeeArrayList* _tmp41_;
			GeeArrayList* _tmp42_;
			GeeArrayList* _tun_list;
			GeeArrayList* _tmp43_;
			gint _tmp44_;
			gint _tmp45_;
			gint _tun_size;
			gint _tun_index;
			_tmp41_ = list_tunnels;
			_tmp42_ = _g_object_ref0 (_tmp41_);
			_tun_list = _tmp42_;
			_tmp43_ = _tun_list;
			_tmp44_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp43_);
			_tmp45_ = _tmp44_;
			_tun_size = _tmp45_;
			_tun_index = -1;
			while (TRUE) {
				gint _tmp46_;
				gint _tmp47_;
				gint _tmp48_;
				GeeArrayList* _tmp49_;
				gint _tmp50_;
				gpointer _tmp51_ = NULL;
				NetsukukuTunnelItem* tun;
				NetsukukuTunnelItem* _tmp52_;
				const gchar* _tmp53_;
				const gchar* _tmp54_;
				gchar* _tmp55_;
				gchar* ipstr;
				gint _tmp56_;
				gchar* _tmp57_ = NULL;
				gchar* _tmp58_;
				gchar* _tmp59_ = NULL;
				gchar* _tmp60_;
				gchar* dev;
				const gchar* _tmp61_;
				const gchar* _tmp62_ = NULL;
				const gchar* _tmp63_;
				const gchar* _tmp64_ = NULL;
				gchar* _tmp65_ = NULL;
				gchar* _tmp66_;
				const gchar* _tmp67_;
				const gchar* _tmp68_ = NULL;
				gchar* _tmp69_ = NULL;
				gchar* _tmp70_;
				const gchar* _tmp71_;
				const gchar* _tmp72_;
				const gchar* _tmp73_ = NULL;
				const gchar* _tmp74_;
				const gchar* _tmp75_ = NULL;
				gchar* _tmp76_ = NULL;
				gchar* _tmp77_;
				gint _tmp78_;
				_tmp46_ = _tun_index;
				_tun_index = _tmp46_ + 1;
				_tmp47_ = _tun_index;
				_tmp48_ = _tun_size;
				if (!(_tmp47_ < _tmp48_)) {
					break;
				}
				_tmp49_ = _tun_list;
				_tmp50_ = _tun_index;
				_tmp51_ = gee_abstract_list_get ((GeeAbstractList*) _tmp49_, _tmp50_);
				tun = (NetsukukuTunnelItem*) _tmp51_;
				_tmp52_ = tun;
				_tmp53_ = netsukuku_tunnel_item_get_ipstr (_tmp52_);
				_tmp54_ = _tmp53_;
				_tmp55_ = g_strdup (_tmp54_);
				ipstr = _tmp55_;
				_tmp56_ = i;
				_tmp57_ = g_strdup_printf ("%i", _tmp56_);
				_tmp58_ = _tmp57_;
				_tmp59_ = g_strconcat ("ntk-to-inet-", _tmp58_, NULL);
				_tmp60_ = _tmp59_;
				_g_free0 (_tmp58_);
				dev = _tmp60_;
				_tmp61_ = dev;
				_tmp62_ = string_to_string (_tmp61_);
				_tmp63_ = ipstr;
				_tmp64_ = string_to_string (_tmp63_);
				_tmp65_ = g_strconcat ("tunnel add ", _tmp62_, " mode ipip remote ", _tmp64_, NULL);
				_tmp66_ = _tmp65_;
				netsukuku_impl_linux_iproute_exp (_tmp66_);
				_g_free0 (_tmp66_);
				_tmp67_ = dev;
				_tmp68_ = string_to_string (_tmp67_);
				_tmp69_ = g_strconcat ("link set ", _tmp68_, " up", NULL);
				_tmp70_ = _tmp69_;
				netsukuku_impl_linux_iproute_exp (_tmp70_);
				_g_free0 (_tmp70_);
				_netsukuku_impl_linux_linux_route_disable_rp_filter (self, "tunl0");
				_tmp71_ = dev;
				_netsukuku_impl_linux_linux_route_disable_rp_filter (self, _tmp71_);
				_tmp72_ = pref_src;
				_tmp73_ = string_to_string (_tmp72_);
				_tmp74_ = dev;
				_tmp75_ = string_to_string (_tmp74_);
				_tmp76_ = g_strconcat ("addr add ", _tmp73_, " dev ", _tmp75_, NULL);
				_tmp77_ = _tmp76_;
				netsukuku_impl_linux_iproute_exp (_tmp77_);
				_g_free0 (_tmp77_);
				_tmp78_ = i;
				i = _tmp78_ + 1;
				_g_free0 (dev);
				_g_free0 (ipstr);
				_g_object_unref0 (tun);
			}
			_g_object_unref0 (_tun_list);
		}
		_tmp79_ = netsukuku_impl_linux_iptables ("-t mangle -A OUTPUT -m conntrack --ctstate ESTABLISHED,RELATED  -j CON" \
"NMARK --restore-mark", &_inner_error_);
		_tmp80_ = _tmp79_;
		_g_free0 (_tmp80_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			weights = (g_free (weights), NULL);
			_g_free0 (dbg_list_tunnels);
			return FALSE;
		}
		i = 0;
		{
			GeeArrayList* _tmp81_;
			GeeArrayList* _tmp82_;
			GeeArrayList* _tun_list;
			GeeArrayList* _tmp83_;
			gint _tmp84_;
			gint _tmp85_;
			gint _tun_size;
			gint _tun_index;
			_tmp81_ = list_tunnels;
			_tmp82_ = _g_object_ref0 (_tmp81_);
			_tun_list = _tmp82_;
			_tmp83_ = _tun_list;
			_tmp84_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp83_);
			_tmp85_ = _tmp84_;
			_tun_size = _tmp85_;
			_tun_index = -1;
			while (TRUE) {
				gint _tmp86_;
				gint _tmp87_;
				gint _tmp88_;
				GeeArrayList* _tmp89_;
				gint _tmp90_;
				gpointer _tmp91_ = NULL;
				NetsukukuTunnelItem* tun;
				NetsukukuTunnelItem* _tmp92_;
				const gchar* _tmp93_;
				const gchar* _tmp94_;
				gchar* _tmp95_;
				gchar* ipstr;
				gint _tmp96_;
				gchar* _tmp97_ = NULL;
				gchar* _tmp98_;
				gchar* _tmp99_ = NULL;
				gchar* _tmp100_;
				gchar* dev;
				gint _tmp101_;
				gint tableid;
				const gchar* _tmp102_;
				const gchar* _tmp103_ = NULL;
				gint _tmp104_;
				gchar* _tmp105_ = NULL;
				gchar* _tmp106_;
				gchar* _tmp107_ = NULL;
				gchar* _tmp108_;
				gint _tmp109_;
				gchar* _tmp110_ = NULL;
				gchar* _tmp111_;
				gint _tmp112_;
				gchar* _tmp113_ = NULL;
				gchar* _tmp114_;
				gchar* _tmp115_ = NULL;
				gchar* _tmp116_;
				gint _tmp117_;
				gchar* _tmp118_ = NULL;
				gchar* _tmp119_;
				const gchar* _tmp120_;
				const gchar* _tmp121_ = NULL;
				const gchar* _tmp122_;
				const gchar* _tmp123_ = NULL;
				const gchar* _tmp124_;
				const gchar* _tmp125_ = NULL;
				gchar* _tmp126_ = NULL;
				gchar* _tmp127_;
				gint _tmp128_;
				_tmp86_ = _tun_index;
				_tun_index = _tmp86_ + 1;
				_tmp87_ = _tun_index;
				_tmp88_ = _tun_size;
				if (!(_tmp87_ < _tmp88_)) {
					break;
				}
				_tmp89_ = _tun_list;
				_tmp90_ = _tun_index;
				_tmp91_ = gee_abstract_list_get ((GeeAbstractList*) _tmp89_, _tmp90_);
				tun = (NetsukukuTunnelItem*) _tmp91_;
				_tmp92_ = tun;
				_tmp93_ = netsukuku_tunnel_item_get_ipstr (_tmp92_);
				_tmp94_ = _tmp93_;
				_tmp95_ = g_strdup (_tmp94_);
				ipstr = _tmp95_;
				_tmp96_ = i;
				_tmp97_ = g_strdup_printf ("%i", _tmp96_);
				_tmp98_ = _tmp97_;
				_tmp99_ = g_strconcat ("ntk-to-inet-", _tmp98_, NULL);
				_tmp100_ = _tmp99_;
				_g_free0 (_tmp98_);
				dev = _tmp100_;
				_tmp101_ = i;
				tableid = 99 - _tmp101_;
				_tmp102_ = dev;
				_tmp103_ = string_to_string (_tmp102_);
				_tmp104_ = tableid;
				_tmp105_ = g_strdup_printf ("%i", _tmp104_);
				_tmp106_ = _tmp105_;
				_tmp107_ = g_strconcat ("-t mangle -A POSTROUTING -o ", _tmp103_, " -m conntrack --ctstate NEW -j CONNMARK --set-mark ", _tmp106_, NULL);
				_tmp108_ = _tmp107_;
				netsukuku_impl_linux_iptables_exp (_tmp108_);
				_g_free0 (_tmp108_);
				_g_free0 (_tmp106_);
				_tmp109_ = tableid;
				_tmp110_ = g_strdup_printf ("%i", _tmp109_);
				_tmp111_ = _tmp110_;
				_tmp112_ = tableid;
				_tmp113_ = g_strdup_printf ("%i", _tmp112_);
				_tmp114_ = _tmp113_;
				_tmp115_ = g_strconcat ("rule add fwmark ", _tmp111_, " lookup ", _tmp114_, NULL);
				_tmp116_ = _tmp115_;
				netsukuku_impl_linux_iproute_exp (_tmp116_);
				_g_free0 (_tmp116_);
				_g_free0 (_tmp114_);
				_g_free0 (_tmp111_);
				_tmp117_ = tableid;
				_tmp118_ = g_strdup_printf ("%i", _tmp117_);
				_tmp119_ = _tmp118_;
				_tmp120_ = ipstr;
				_tmp121_ = string_to_string (_tmp120_);
				_tmp122_ = dev;
				_tmp123_ = string_to_string (_tmp122_);
				_tmp124_ = pref_src;
				_tmp125_ = string_to_string (_tmp124_);
				_tmp126_ = g_strconcat ("route add table ", _tmp119_, " default via ", _tmp121_, " dev ", _tmp123_, " src ", _tmp125_, " onlink", NULL);
				_tmp127_ = _tmp126_;
				netsukuku_impl_linux_iproute_exp (_tmp127_);
				_g_free0 (_tmp127_);
				_g_free0 (_tmp119_);
				_tmp128_ = i;
				i = _tmp128_ + 1;
				_g_free0 (dev);
				_g_free0 (ipstr);
				_g_object_unref0 (tun);
			}
			_g_object_unref0 (_tun_list);
		}
		_tmp129_ = g_strdup ("route add default ");
		cmd = _tmp129_;
		i = 0;
		{
			GeeArrayList* _tmp130_;
			GeeArrayList* _tmp131_;
			GeeArrayList* _tun_list;
			GeeArrayList* _tmp132_;
			gint _tmp133_;
			gint _tmp134_;
			gint _tun_size;
			gint _tun_index;
			_tmp130_ = list_tunnels;
			_tmp131_ = _g_object_ref0 (_tmp130_);
			_tun_list = _tmp131_;
			_tmp132_ = _tun_list;
			_tmp133_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp132_);
			_tmp134_ = _tmp133_;
			_tun_size = _tmp134_;
			_tun_index = -1;
			while (TRUE) {
				gint _tmp135_;
				gint _tmp136_;
				gint _tmp137_;
				GeeArrayList* _tmp138_;
				gint _tmp139_;
				gpointer _tmp140_ = NULL;
				NetsukukuTunnelItem* tun;
				NetsukukuTunnelItem* _tmp141_;
				const gchar* _tmp142_;
				const gchar* _tmp143_;
				gchar* _tmp144_;
				gchar* ipstr;
				gint _tmp145_;
				gchar* _tmp146_ = NULL;
				gchar* _tmp147_;
				gchar* _tmp148_ = NULL;
				gchar* _tmp149_;
				gchar* dev;
				gint* _tmp150_;
				gint _tmp150__length1;
				GeeArrayList* _tmp151_;
				gint _tmp152_;
				gint _tmp153_;
				gint _tmp154_;
				gint _tmp155_;
				gint weight;
				const gchar* _tmp156_;
				const gchar* _tmp157_;
				const gchar* _tmp158_ = NULL;
				const gchar* _tmp159_;
				const gchar* _tmp160_ = NULL;
				gint _tmp161_;
				gchar* _tmp162_ = NULL;
				gchar* _tmp163_;
				gchar* _tmp164_ = NULL;
				gchar* _tmp165_;
				gchar* _tmp166_;
				gint _tmp167_;
				_tmp135_ = _tun_index;
				_tun_index = _tmp135_ + 1;
				_tmp136_ = _tun_index;
				_tmp137_ = _tun_size;
				if (!(_tmp136_ < _tmp137_)) {
					break;
				}
				_tmp138_ = _tun_list;
				_tmp139_ = _tun_index;
				_tmp140_ = gee_abstract_list_get ((GeeAbstractList*) _tmp138_, _tmp139_);
				tun = (NetsukukuTunnelItem*) _tmp140_;
				_tmp141_ = tun;
				_tmp142_ = netsukuku_tunnel_item_get_ipstr (_tmp141_);
				_tmp143_ = _tmp142_;
				_tmp144_ = g_strdup (_tmp143_);
				ipstr = _tmp144_;
				_tmp145_ = i;
				_tmp146_ = g_strdup_printf ("%i", _tmp145_);
				_tmp147_ = _tmp146_;
				_tmp148_ = g_strconcat ("ntk-to-inet-", _tmp147_, NULL);
				_tmp149_ = _tmp148_;
				_g_free0 (_tmp147_);
				dev = _tmp149_;
				_tmp150_ = weights;
				_tmp150__length1 = weights_length1;
				_tmp151_ = list_tunnels;
				_tmp152_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp151_);
				_tmp153_ = _tmp152_;
				_tmp154_ = i;
				_tmp155_ = _tmp150_[(_tmp153_ - 1) - _tmp154_];
				weight = _tmp155_;
				_tmp156_ = cmd;
				_tmp157_ = ipstr;
				_tmp158_ = string_to_string (_tmp157_);
				_tmp159_ = dev;
				_tmp160_ = string_to_string (_tmp159_);
				_tmp161_ = weight;
				_tmp162_ = g_strdup_printf ("%i", _tmp161_);
				_tmp163_ = _tmp162_;
				_tmp164_ = g_strconcat ("nexthop via ", _tmp158_, " dev ", _tmp160_, " weight ", _tmp163_, " onlink ", NULL);
				_tmp165_ = _tmp164_;
				_tmp166_ = g_strconcat (_tmp156_, _tmp165_, NULL);
				_g_free0 (cmd);
				cmd = _tmp166_;
				_g_free0 (_tmp165_);
				_g_free0 (_tmp163_);
				_tmp167_ = i;
				i = _tmp167_ + 1;
				_g_free0 (dev);
				_g_free0 (ipstr);
				_g_object_unref0 (tun);
			}
			_g_object_unref0 (_tun_list);
		}
		_tmp168_ = cmd;
		netsukuku_impl_linux_iproute_exp (_tmp168_);
		_g_free0 (cmd);
		weights = (g_free (weights), NULL);
	}
	_tmp171_ = mode;
	if (g_strcmp0 (_tmp171_, "NONE") == 0) {
		const gchar* _tmp172_;
		_tmp172_ = prev_mode;
		_tmp170_ = g_strcmp0 (_tmp172_, "USE") == 0;
	} else {
		_tmp170_ = FALSE;
	}
	_tmp173_ = _tmp170_;
	if (_tmp173_) {
		GeeArrayList* _tmp174_;
		gboolean _tmp175_;
		gboolean _tmp176_;
		_tmp174_ = prev_list_tunnels;
		_tmp175_ = gee_collection_get_is_empty ((GeeCollection*) _tmp174_);
		_tmp176_ = _tmp175_;
		_tmp169_ = !_tmp176_;
	} else {
		_tmp169_ = FALSE;
	}
	_tmp177_ = _tmp169_;
	if (_tmp177_) {
		gint* _tmp178_ = NULL;
		gint* weights;
		gint weights_length1;
		gint _weights_size_;
		gint i;
		gchar* _tmp179_;
		gchar* cmd;
		const gchar* _tmp218_;
		gchar* _tmp267_ = NULL;
		gchar* _tmp268_;
		_tmp178_ = g_new0 (gint, 10);
		_tmp178_[0] = 1;
		_tmp178_[1] = 3;
		_tmp178_[2] = 6;
		_tmp178_[3] = 10;
		_tmp178_[4] = 30;
		_tmp178_[5] = 60;
		_tmp178_[6] = 100;
		_tmp178_[7] = 150;
		_tmp178_[8] = 200;
		_tmp178_[9] = 255;
		weights = _tmp178_;
		weights_length1 = 10;
		_weights_size_ = weights_length1;
		i = 0;
		_tmp179_ = g_strdup ("route del default ");
		cmd = _tmp179_;
		{
			GeeArrayList* _tmp180_;
			GeeArrayList* _tmp181_;
			GeeArrayList* _tun_list;
			GeeArrayList* _tmp182_;
			gint _tmp183_;
			gint _tmp184_;
			gint _tun_size;
			gint _tun_index;
			_tmp180_ = prev_list_tunnels;
			_tmp181_ = _g_object_ref0 (_tmp180_);
			_tun_list = _tmp181_;
			_tmp182_ = _tun_list;
			_tmp183_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp182_);
			_tmp184_ = _tmp183_;
			_tun_size = _tmp184_;
			_tun_index = -1;
			while (TRUE) {
				gint _tmp185_;
				gint _tmp186_;
				gint _tmp187_;
				GeeArrayList* _tmp188_;
				gint _tmp189_;
				gpointer _tmp190_ = NULL;
				NetsukukuTunnelItem* tun;
				NetsukukuTunnelItem* _tmp191_;
				const gchar* _tmp192_;
				const gchar* _tmp193_;
				gchar* _tmp194_;
				gchar* ipstr;
				gint _tmp195_;
				gchar* _tmp196_ = NULL;
				gchar* _tmp197_;
				gchar* _tmp198_ = NULL;
				gchar* _tmp199_;
				gchar* dev;
				gint* _tmp200_;
				gint _tmp200__length1;
				GeeArrayList* _tmp201_;
				gint _tmp202_;
				gint _tmp203_;
				gint _tmp204_;
				gint _tmp205_;
				gint weight;
				const gchar* _tmp206_;
				const gchar* _tmp207_;
				const gchar* _tmp208_ = NULL;
				const gchar* _tmp209_;
				const gchar* _tmp210_ = NULL;
				gint _tmp211_;
				gchar* _tmp212_ = NULL;
				gchar* _tmp213_;
				gchar* _tmp214_ = NULL;
				gchar* _tmp215_;
				gchar* _tmp216_;
				gint _tmp217_;
				_tmp185_ = _tun_index;
				_tun_index = _tmp185_ + 1;
				_tmp186_ = _tun_index;
				_tmp187_ = _tun_size;
				if (!(_tmp186_ < _tmp187_)) {
					break;
				}
				_tmp188_ = _tun_list;
				_tmp189_ = _tun_index;
				_tmp190_ = gee_abstract_list_get ((GeeAbstractList*) _tmp188_, _tmp189_);
				tun = (NetsukukuTunnelItem*) _tmp190_;
				_tmp191_ = tun;
				_tmp192_ = netsukuku_tunnel_item_get_ipstr (_tmp191_);
				_tmp193_ = _tmp192_;
				_tmp194_ = g_strdup (_tmp193_);
				ipstr = _tmp194_;
				_tmp195_ = i;
				_tmp196_ = g_strdup_printf ("%i", _tmp195_);
				_tmp197_ = _tmp196_;
				_tmp198_ = g_strconcat ("ntk-to-inet-", _tmp197_, NULL);
				_tmp199_ = _tmp198_;
				_g_free0 (_tmp197_);
				dev = _tmp199_;
				_tmp200_ = weights;
				_tmp200__length1 = weights_length1;
				_tmp201_ = list_tunnels;
				_tmp202_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp201_);
				_tmp203_ = _tmp202_;
				_tmp204_ = i;
				_tmp205_ = _tmp200_[(_tmp203_ - 1) - _tmp204_];
				weight = _tmp205_;
				_tmp206_ = cmd;
				_tmp207_ = ipstr;
				_tmp208_ = string_to_string (_tmp207_);
				_tmp209_ = dev;
				_tmp210_ = string_to_string (_tmp209_);
				_tmp211_ = weight;
				_tmp212_ = g_strdup_printf ("%i", _tmp211_);
				_tmp213_ = _tmp212_;
				_tmp214_ = g_strconcat ("nexthop via ", _tmp208_, " dev ", _tmp210_, " weight ", _tmp213_, " onlink ", NULL);
				_tmp215_ = _tmp214_;
				_tmp216_ = g_strconcat (_tmp206_, _tmp215_, NULL);
				_g_free0 (cmd);
				cmd = _tmp216_;
				_g_free0 (_tmp215_);
				_g_free0 (_tmp213_);
				_tmp217_ = i;
				i = _tmp217_ + 1;
				_g_free0 (dev);
				_g_free0 (ipstr);
				_g_object_unref0 (tun);
			}
			_g_object_unref0 (_tun_list);
		}
		_tmp218_ = cmd;
		netsukuku_impl_linux_iproute_exp (_tmp218_);
		i = 0;
		{
			GeeArrayList* _tmp219_;
			GeeArrayList* _tmp220_;
			GeeArrayList* _tun_list;
			GeeArrayList* _tmp221_;
			gint _tmp222_;
			gint _tmp223_;
			gint _tun_size;
			gint _tun_index;
			_tmp219_ = prev_list_tunnels;
			_tmp220_ = _g_object_ref0 (_tmp219_);
			_tun_list = _tmp220_;
			_tmp221_ = _tun_list;
			_tmp222_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp221_);
			_tmp223_ = _tmp222_;
			_tun_size = _tmp223_;
			_tun_index = -1;
			while (TRUE) {
				gint _tmp224_;
				gint _tmp225_;
				gint _tmp226_;
				GeeArrayList* _tmp227_;
				gint _tmp228_;
				gpointer _tmp229_ = NULL;
				NetsukukuTunnelItem* tun;
				NetsukukuTunnelItem* _tmp230_;
				const gchar* _tmp231_;
				const gchar* _tmp232_;
				gchar* _tmp233_;
				gchar* ipstr;
				gint _tmp234_;
				gchar* _tmp235_ = NULL;
				gchar* _tmp236_;
				gchar* _tmp237_ = NULL;
				gchar* _tmp238_;
				gchar* dev;
				gint _tmp239_;
				gint tableid;
				const gchar* _tmp240_;
				const gchar* _tmp241_ = NULL;
				gint _tmp242_;
				gchar* _tmp243_ = NULL;
				gchar* _tmp244_;
				gchar* _tmp245_ = NULL;
				gchar* _tmp246_;
				gint _tmp247_;
				gchar* _tmp248_ = NULL;
				gchar* _tmp249_;
				gint _tmp250_;
				gchar* _tmp251_ = NULL;
				gchar* _tmp252_;
				gchar* _tmp253_ = NULL;
				gchar* _tmp254_;
				gint _tmp255_;
				gchar* _tmp256_ = NULL;
				gchar* _tmp257_;
				const gchar* _tmp258_;
				const gchar* _tmp259_ = NULL;
				const gchar* _tmp260_;
				const gchar* _tmp261_ = NULL;
				const gchar* _tmp262_;
				const gchar* _tmp263_ = NULL;
				gchar* _tmp264_ = NULL;
				gchar* _tmp265_;
				gint _tmp266_;
				_tmp224_ = _tun_index;
				_tun_index = _tmp224_ + 1;
				_tmp225_ = _tun_index;
				_tmp226_ = _tun_size;
				if (!(_tmp225_ < _tmp226_)) {
					break;
				}
				_tmp227_ = _tun_list;
				_tmp228_ = _tun_index;
				_tmp229_ = gee_abstract_list_get ((GeeAbstractList*) _tmp227_, _tmp228_);
				tun = (NetsukukuTunnelItem*) _tmp229_;
				_tmp230_ = tun;
				_tmp231_ = netsukuku_tunnel_item_get_ipstr (_tmp230_);
				_tmp232_ = _tmp231_;
				_tmp233_ = g_strdup (_tmp232_);
				ipstr = _tmp233_;
				_tmp234_ = i;
				_tmp235_ = g_strdup_printf ("%i", _tmp234_);
				_tmp236_ = _tmp235_;
				_tmp237_ = g_strconcat ("ntk-to-inet-", _tmp236_, NULL);
				_tmp238_ = _tmp237_;
				_g_free0 (_tmp236_);
				dev = _tmp238_;
				_tmp239_ = i;
				tableid = 99 - _tmp239_;
				_tmp240_ = dev;
				_tmp241_ = string_to_string (_tmp240_);
				_tmp242_ = tableid;
				_tmp243_ = g_strdup_printf ("%i", _tmp242_);
				_tmp244_ = _tmp243_;
				_tmp245_ = g_strconcat ("-t mangle -D POSTROUTING -o ", _tmp241_, " -m conntrack --ctstate NEW -j CONNMARK --set-mark ", _tmp244_, NULL);
				_tmp246_ = _tmp245_;
				netsukuku_impl_linux_iptables_exp (_tmp246_);
				_g_free0 (_tmp246_);
				_g_free0 (_tmp244_);
				_tmp247_ = tableid;
				_tmp248_ = g_strdup_printf ("%i", _tmp247_);
				_tmp249_ = _tmp248_;
				_tmp250_ = tableid;
				_tmp251_ = g_strdup_printf ("%i", _tmp250_);
				_tmp252_ = _tmp251_;
				_tmp253_ = g_strconcat ("rule del fwmark ", _tmp249_, " lookup ", _tmp252_, NULL);
				_tmp254_ = _tmp253_;
				netsukuku_impl_linux_iproute_exp (_tmp254_);
				_g_free0 (_tmp254_);
				_g_free0 (_tmp252_);
				_g_free0 (_tmp249_);
				_tmp255_ = tableid;
				_tmp256_ = g_strdup_printf ("%i", _tmp255_);
				_tmp257_ = _tmp256_;
				_tmp258_ = ipstr;
				_tmp259_ = string_to_string (_tmp258_);
				_tmp260_ = dev;
				_tmp261_ = string_to_string (_tmp260_);
				_tmp262_ = pref_src;
				_tmp263_ = string_to_string (_tmp262_);
				_tmp264_ = g_strconcat ("route del table ", _tmp257_, " default via ", _tmp259_, " dev ", _tmp261_, " src ", _tmp263_, " onlink", NULL);
				_tmp265_ = _tmp264_;
				netsukuku_impl_linux_iproute_exp (_tmp265_);
				_g_free0 (_tmp265_);
				_g_free0 (_tmp257_);
				_tmp266_ = i;
				i = _tmp266_ + 1;
				_g_free0 (dev);
				_g_free0 (ipstr);
				_g_object_unref0 (tun);
			}
			_g_object_unref0 (_tun_list);
		}
		_tmp267_ = netsukuku_impl_linux_iptables ("-t mangle -D OUTPUT -m conntrack --ctstate ESTABLISHED,RELATED  -j CON" \
"NMARK --restore-mark", &_inner_error_);
		_tmp268_ = _tmp267_;
		_g_free0 (_tmp268_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (cmd);
			weights = (g_free (weights), NULL);
			_g_free0 (dbg_list_tunnels);
			return FALSE;
		}
		i = 0;
		{
			GeeArrayList* _tmp269_;
			GeeArrayList* _tmp270_;
			GeeArrayList* _tun_list;
			GeeArrayList* _tmp271_;
			gint _tmp272_;
			gint _tmp273_;
			gint _tun_size;
			gint _tun_index;
			_tmp269_ = prev_list_tunnels;
			_tmp270_ = _g_object_ref0 (_tmp269_);
			_tun_list = _tmp270_;
			_tmp271_ = _tun_list;
			_tmp272_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp271_);
			_tmp273_ = _tmp272_;
			_tun_size = _tmp273_;
			_tun_index = -1;
			while (TRUE) {
				gint _tmp274_;
				gint _tmp275_;
				gint _tmp276_;
				GeeArrayList* _tmp277_;
				gint _tmp278_;
				gpointer _tmp279_ = NULL;
				NetsukukuTunnelItem* tun;
				NetsukukuTunnelItem* _tmp280_;
				const gchar* _tmp281_;
				const gchar* _tmp282_;
				gchar* _tmp283_;
				gchar* ipstr;
				gint _tmp284_;
				gchar* _tmp285_ = NULL;
				gchar* _tmp286_;
				gchar* _tmp287_ = NULL;
				gchar* _tmp288_;
				gchar* dev;
				const gchar* _tmp289_;
				const gchar* _tmp290_ = NULL;
				const gchar* _tmp291_;
				const gchar* _tmp292_ = NULL;
				gchar* _tmp293_ = NULL;
				gchar* _tmp294_;
				const gchar* _tmp295_;
				const gchar* _tmp296_ = NULL;
				gchar* _tmp297_ = NULL;
				gchar* _tmp298_;
				const gchar* _tmp299_;
				const gchar* _tmp300_ = NULL;
				const gchar* _tmp301_;
				const gchar* _tmp302_ = NULL;
				gchar* _tmp303_ = NULL;
				gchar* _tmp304_;
				gint _tmp305_;
				_tmp274_ = _tun_index;
				_tun_index = _tmp274_ + 1;
				_tmp275_ = _tun_index;
				_tmp276_ = _tun_size;
				if (!(_tmp275_ < _tmp276_)) {
					break;
				}
				_tmp277_ = _tun_list;
				_tmp278_ = _tun_index;
				_tmp279_ = gee_abstract_list_get ((GeeAbstractList*) _tmp277_, _tmp278_);
				tun = (NetsukukuTunnelItem*) _tmp279_;
				_tmp280_ = tun;
				_tmp281_ = netsukuku_tunnel_item_get_ipstr (_tmp280_);
				_tmp282_ = _tmp281_;
				_tmp283_ = g_strdup (_tmp282_);
				ipstr = _tmp283_;
				_tmp284_ = i;
				_tmp285_ = g_strdup_printf ("%i", _tmp284_);
				_tmp286_ = _tmp285_;
				_tmp287_ = g_strconcat ("ntk-to-inet-", _tmp286_, NULL);
				_tmp288_ = _tmp287_;
				_g_free0 (_tmp286_);
				dev = _tmp288_;
				_tmp289_ = pref_src;
				_tmp290_ = string_to_string (_tmp289_);
				_tmp291_ = dev;
				_tmp292_ = string_to_string (_tmp291_);
				_tmp293_ = g_strconcat ("addr del ", _tmp290_, " dev ", _tmp292_, NULL);
				_tmp294_ = _tmp293_;
				netsukuku_impl_linux_iproute_exp (_tmp294_);
				_g_free0 (_tmp294_);
				_tmp295_ = dev;
				_tmp296_ = string_to_string (_tmp295_);
				_tmp297_ = g_strconcat ("link set ", _tmp296_, " down", NULL);
				_tmp298_ = _tmp297_;
				netsukuku_impl_linux_iproute_exp (_tmp298_);
				_g_free0 (_tmp298_);
				_tmp299_ = dev;
				_tmp300_ = string_to_string (_tmp299_);
				_tmp301_ = ipstr;
				_tmp302_ = string_to_string (_tmp301_);
				_tmp303_ = g_strconcat ("tunnel dek ", _tmp300_, " mode ipip remote ", _tmp302_, NULL);
				_tmp304_ = _tmp303_;
				netsukuku_impl_linux_iproute_exp (_tmp304_);
				_g_free0 (_tmp304_);
				_tmp305_ = i;
				i = _tmp305_ + 1;
				_g_free0 (dev);
				_g_free0 (ipstr);
				_g_object_unref0 (tun);
			}
			_g_object_unref0 (_tun_list);
		}
		_g_free0 (cmd);
		weights = (g_free (weights), NULL);
	}
	_tmp308_ = mode;
	if (g_strcmp0 (_tmp308_, "USE") == 0) {
		const gchar* _tmp309_;
		_tmp309_ = prev_mode;
		_tmp307_ = g_strcmp0 (_tmp309_, "USE") == 0;
	} else {
		_tmp307_ = FALSE;
	}
	_tmp310_ = _tmp307_;
	if (_tmp310_) {
		gboolean _tmp311_ = FALSE;
		GeeArrayList* _tmp312_;
		GeeArrayList* _tmp313_;
		gboolean _tmp314_ = FALSE;
		gboolean _tmp318_;
		_tmp312_ = prev_list_tunnels;
		_tmp313_ = list_tunnels;
		_tmp314_ = gee_collection_contains_all ((GeeCollection*) _tmp312_, (GeeCollection*) _tmp313_);
		if (_tmp314_) {
			GeeArrayList* _tmp315_;
			GeeArrayList* _tmp316_;
			gboolean _tmp317_ = FALSE;
			_tmp315_ = list_tunnels;
			_tmp316_ = prev_list_tunnels;
			_tmp317_ = gee_collection_contains_all ((GeeCollection*) _tmp315_, (GeeCollection*) _tmp316_);
			_tmp311_ = _tmp317_;
		} else {
			_tmp311_ = FALSE;
		}
		_tmp318_ = _tmp311_;
		_tmp306_ = !_tmp318_;
	} else {
		_tmp306_ = FALSE;
	}
	_tmp319_ = _tmp306_;
	if (_tmp319_) {
		gint* _tmp320_ = NULL;
		gint* weights;
		gint weights_length1;
		gint _weights_size_;
		GeeArrayList* _tmp321_;
		gboolean _tmp322_;
		gboolean _tmp323_;
		GeeArrayList* _tmp451_;
		gboolean _tmp452_;
		gboolean _tmp453_;
		_tmp320_ = g_new0 (gint, 10);
		_tmp320_[0] = 1;
		_tmp320_[1] = 3;
		_tmp320_[2] = 6;
		_tmp320_[3] = 10;
		_tmp320_[4] = 30;
		_tmp320_[5] = 60;
		_tmp320_[6] = 100;
		_tmp320_[7] = 150;
		_tmp320_[8] = 200;
		_tmp320_[9] = 255;
		weights = _tmp320_;
		weights_length1 = 10;
		_weights_size_ = weights_length1;
		_tmp321_ = prev_list_tunnels;
		_tmp322_ = gee_collection_get_is_empty ((GeeCollection*) _tmp321_);
		_tmp323_ = _tmp322_;
		if (!_tmp323_) {
			gint i;
			gchar* _tmp324_;
			gchar* cmd;
			const gchar* _tmp363_;
			gchar* _tmp412_ = NULL;
			gchar* _tmp413_;
			i = 0;
			_tmp324_ = g_strdup ("route del default ");
			cmd = _tmp324_;
			{
				GeeArrayList* _tmp325_;
				GeeArrayList* _tmp326_;
				GeeArrayList* _tun_list;
				GeeArrayList* _tmp327_;
				gint _tmp328_;
				gint _tmp329_;
				gint _tun_size;
				gint _tun_index;
				_tmp325_ = prev_list_tunnels;
				_tmp326_ = _g_object_ref0 (_tmp325_);
				_tun_list = _tmp326_;
				_tmp327_ = _tun_list;
				_tmp328_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp327_);
				_tmp329_ = _tmp328_;
				_tun_size = _tmp329_;
				_tun_index = -1;
				while (TRUE) {
					gint _tmp330_;
					gint _tmp331_;
					gint _tmp332_;
					GeeArrayList* _tmp333_;
					gint _tmp334_;
					gpointer _tmp335_ = NULL;
					NetsukukuTunnelItem* tun;
					NetsukukuTunnelItem* _tmp336_;
					const gchar* _tmp337_;
					const gchar* _tmp338_;
					gchar* _tmp339_;
					gchar* ipstr;
					gint _tmp340_;
					gchar* _tmp341_ = NULL;
					gchar* _tmp342_;
					gchar* _tmp343_ = NULL;
					gchar* _tmp344_;
					gchar* dev;
					gint* _tmp345_;
					gint _tmp345__length1;
					GeeArrayList* _tmp346_;
					gint _tmp347_;
					gint _tmp348_;
					gint _tmp349_;
					gint _tmp350_;
					gint weight;
					const gchar* _tmp351_;
					const gchar* _tmp352_;
					const gchar* _tmp353_ = NULL;
					const gchar* _tmp354_;
					const gchar* _tmp355_ = NULL;
					gint _tmp356_;
					gchar* _tmp357_ = NULL;
					gchar* _tmp358_;
					gchar* _tmp359_ = NULL;
					gchar* _tmp360_;
					gchar* _tmp361_;
					gint _tmp362_;
					_tmp330_ = _tun_index;
					_tun_index = _tmp330_ + 1;
					_tmp331_ = _tun_index;
					_tmp332_ = _tun_size;
					if (!(_tmp331_ < _tmp332_)) {
						break;
					}
					_tmp333_ = _tun_list;
					_tmp334_ = _tun_index;
					_tmp335_ = gee_abstract_list_get ((GeeAbstractList*) _tmp333_, _tmp334_);
					tun = (NetsukukuTunnelItem*) _tmp335_;
					_tmp336_ = tun;
					_tmp337_ = netsukuku_tunnel_item_get_ipstr (_tmp336_);
					_tmp338_ = _tmp337_;
					_tmp339_ = g_strdup (_tmp338_);
					ipstr = _tmp339_;
					_tmp340_ = i;
					_tmp341_ = g_strdup_printf ("%i", _tmp340_);
					_tmp342_ = _tmp341_;
					_tmp343_ = g_strconcat ("ntk-to-inet-", _tmp342_, NULL);
					_tmp344_ = _tmp343_;
					_g_free0 (_tmp342_);
					dev = _tmp344_;
					_tmp345_ = weights;
					_tmp345__length1 = weights_length1;
					_tmp346_ = list_tunnels;
					_tmp347_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp346_);
					_tmp348_ = _tmp347_;
					_tmp349_ = i;
					_tmp350_ = _tmp345_[(_tmp348_ - 1) - _tmp349_];
					weight = _tmp350_;
					_tmp351_ = cmd;
					_tmp352_ = ipstr;
					_tmp353_ = string_to_string (_tmp352_);
					_tmp354_ = dev;
					_tmp355_ = string_to_string (_tmp354_);
					_tmp356_ = weight;
					_tmp357_ = g_strdup_printf ("%i", _tmp356_);
					_tmp358_ = _tmp357_;
					_tmp359_ = g_strconcat ("nexthop via ", _tmp353_, " dev ", _tmp355_, " weight ", _tmp358_, " onlink ", NULL);
					_tmp360_ = _tmp359_;
					_tmp361_ = g_strconcat (_tmp351_, _tmp360_, NULL);
					_g_free0 (cmd);
					cmd = _tmp361_;
					_g_free0 (_tmp360_);
					_g_free0 (_tmp358_);
					_tmp362_ = i;
					i = _tmp362_ + 1;
					_g_free0 (dev);
					_g_free0 (ipstr);
					_g_object_unref0 (tun);
				}
				_g_object_unref0 (_tun_list);
			}
			_tmp363_ = cmd;
			netsukuku_impl_linux_iproute_exp (_tmp363_);
			i = 0;
			{
				GeeArrayList* _tmp364_;
				GeeArrayList* _tmp365_;
				GeeArrayList* _tun_list;
				GeeArrayList* _tmp366_;
				gint _tmp367_;
				gint _tmp368_;
				gint _tun_size;
				gint _tun_index;
				_tmp364_ = prev_list_tunnels;
				_tmp365_ = _g_object_ref0 (_tmp364_);
				_tun_list = _tmp365_;
				_tmp366_ = _tun_list;
				_tmp367_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp366_);
				_tmp368_ = _tmp367_;
				_tun_size = _tmp368_;
				_tun_index = -1;
				while (TRUE) {
					gint _tmp369_;
					gint _tmp370_;
					gint _tmp371_;
					GeeArrayList* _tmp372_;
					gint _tmp373_;
					gpointer _tmp374_ = NULL;
					NetsukukuTunnelItem* tun;
					NetsukukuTunnelItem* _tmp375_;
					const gchar* _tmp376_;
					const gchar* _tmp377_;
					gchar* _tmp378_;
					gchar* ipstr;
					gint _tmp379_;
					gchar* _tmp380_ = NULL;
					gchar* _tmp381_;
					gchar* _tmp382_ = NULL;
					gchar* _tmp383_;
					gchar* dev;
					gint _tmp384_;
					gint tableid;
					const gchar* _tmp385_;
					const gchar* _tmp386_ = NULL;
					gint _tmp387_;
					gchar* _tmp388_ = NULL;
					gchar* _tmp389_;
					gchar* _tmp390_ = NULL;
					gchar* _tmp391_;
					gint _tmp392_;
					gchar* _tmp393_ = NULL;
					gchar* _tmp394_;
					gint _tmp395_;
					gchar* _tmp396_ = NULL;
					gchar* _tmp397_;
					gchar* _tmp398_ = NULL;
					gchar* _tmp399_;
					gint _tmp400_;
					gchar* _tmp401_ = NULL;
					gchar* _tmp402_;
					const gchar* _tmp403_;
					const gchar* _tmp404_ = NULL;
					const gchar* _tmp405_;
					const gchar* _tmp406_ = NULL;
					const gchar* _tmp407_;
					const gchar* _tmp408_ = NULL;
					gchar* _tmp409_ = NULL;
					gchar* _tmp410_;
					gint _tmp411_;
					_tmp369_ = _tun_index;
					_tun_index = _tmp369_ + 1;
					_tmp370_ = _tun_index;
					_tmp371_ = _tun_size;
					if (!(_tmp370_ < _tmp371_)) {
						break;
					}
					_tmp372_ = _tun_list;
					_tmp373_ = _tun_index;
					_tmp374_ = gee_abstract_list_get ((GeeAbstractList*) _tmp372_, _tmp373_);
					tun = (NetsukukuTunnelItem*) _tmp374_;
					_tmp375_ = tun;
					_tmp376_ = netsukuku_tunnel_item_get_ipstr (_tmp375_);
					_tmp377_ = _tmp376_;
					_tmp378_ = g_strdup (_tmp377_);
					ipstr = _tmp378_;
					_tmp379_ = i;
					_tmp380_ = g_strdup_printf ("%i", _tmp379_);
					_tmp381_ = _tmp380_;
					_tmp382_ = g_strconcat ("ntk-to-inet-", _tmp381_, NULL);
					_tmp383_ = _tmp382_;
					_g_free0 (_tmp381_);
					dev = _tmp383_;
					_tmp384_ = i;
					tableid = 99 - _tmp384_;
					_tmp385_ = dev;
					_tmp386_ = string_to_string (_tmp385_);
					_tmp387_ = tableid;
					_tmp388_ = g_strdup_printf ("%i", _tmp387_);
					_tmp389_ = _tmp388_;
					_tmp390_ = g_strconcat ("-t mangle -D POSTROUTING -o ", _tmp386_, " -m conntrack --ctstate NEW -j CONNMARK --set-mark ", _tmp389_, NULL);
					_tmp391_ = _tmp390_;
					netsukuku_impl_linux_iptables_exp (_tmp391_);
					_g_free0 (_tmp391_);
					_g_free0 (_tmp389_);
					_tmp392_ = tableid;
					_tmp393_ = g_strdup_printf ("%i", _tmp392_);
					_tmp394_ = _tmp393_;
					_tmp395_ = tableid;
					_tmp396_ = g_strdup_printf ("%i", _tmp395_);
					_tmp397_ = _tmp396_;
					_tmp398_ = g_strconcat ("rule del fwmark ", _tmp394_, " lookup ", _tmp397_, NULL);
					_tmp399_ = _tmp398_;
					netsukuku_impl_linux_iproute_exp (_tmp399_);
					_g_free0 (_tmp399_);
					_g_free0 (_tmp397_);
					_g_free0 (_tmp394_);
					_tmp400_ = tableid;
					_tmp401_ = g_strdup_printf ("%i", _tmp400_);
					_tmp402_ = _tmp401_;
					_tmp403_ = ipstr;
					_tmp404_ = string_to_string (_tmp403_);
					_tmp405_ = dev;
					_tmp406_ = string_to_string (_tmp405_);
					_tmp407_ = pref_src;
					_tmp408_ = string_to_string (_tmp407_);
					_tmp409_ = g_strconcat ("route del table ", _tmp402_, " default via ", _tmp404_, " dev ", _tmp406_, " src ", _tmp408_, " onlink", NULL);
					_tmp410_ = _tmp409_;
					netsukuku_impl_linux_iproute_exp (_tmp410_);
					_g_free0 (_tmp410_);
					_g_free0 (_tmp402_);
					_tmp411_ = i;
					i = _tmp411_ + 1;
					_g_free0 (dev);
					_g_free0 (ipstr);
					_g_object_unref0 (tun);
				}
				_g_object_unref0 (_tun_list);
			}
			_tmp412_ = netsukuku_impl_linux_iptables ("-t mangle -D OUTPUT -m conntrack --ctstate ESTABLISHED,RELATED  -j CON" \
"NMARK --restore-mark", &_inner_error_);
			_tmp413_ = _tmp412_;
			_g_free0 (_tmp413_);
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (cmd);
				weights = (g_free (weights), NULL);
				_g_free0 (dbg_list_tunnels);
				return FALSE;
			}
			i = 0;
			{
				GeeArrayList* _tmp414_;
				GeeArrayList* _tmp415_;
				GeeArrayList* _tun_list;
				GeeArrayList* _tmp416_;
				gint _tmp417_;
				gint _tmp418_;
				gint _tun_size;
				gint _tun_index;
				_tmp414_ = prev_list_tunnels;
				_tmp415_ = _g_object_ref0 (_tmp414_);
				_tun_list = _tmp415_;
				_tmp416_ = _tun_list;
				_tmp417_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp416_);
				_tmp418_ = _tmp417_;
				_tun_size = _tmp418_;
				_tun_index = -1;
				while (TRUE) {
					gint _tmp419_;
					gint _tmp420_;
					gint _tmp421_;
					GeeArrayList* _tmp422_;
					gint _tmp423_;
					gpointer _tmp424_ = NULL;
					NetsukukuTunnelItem* tun;
					NetsukukuTunnelItem* _tmp425_;
					const gchar* _tmp426_;
					const gchar* _tmp427_;
					gchar* _tmp428_;
					gchar* ipstr;
					gint _tmp429_;
					gchar* _tmp430_ = NULL;
					gchar* _tmp431_;
					gchar* _tmp432_ = NULL;
					gchar* _tmp433_;
					gchar* dev;
					const gchar* _tmp434_;
					const gchar* _tmp435_ = NULL;
					const gchar* _tmp436_;
					const gchar* _tmp437_ = NULL;
					gchar* _tmp438_ = NULL;
					gchar* _tmp439_;
					const gchar* _tmp440_;
					const gchar* _tmp441_ = NULL;
					gchar* _tmp442_ = NULL;
					gchar* _tmp443_;
					const gchar* _tmp444_;
					const gchar* _tmp445_ = NULL;
					const gchar* _tmp446_;
					const gchar* _tmp447_ = NULL;
					gchar* _tmp448_ = NULL;
					gchar* _tmp449_;
					gint _tmp450_;
					_tmp419_ = _tun_index;
					_tun_index = _tmp419_ + 1;
					_tmp420_ = _tun_index;
					_tmp421_ = _tun_size;
					if (!(_tmp420_ < _tmp421_)) {
						break;
					}
					_tmp422_ = _tun_list;
					_tmp423_ = _tun_index;
					_tmp424_ = gee_abstract_list_get ((GeeAbstractList*) _tmp422_, _tmp423_);
					tun = (NetsukukuTunnelItem*) _tmp424_;
					_tmp425_ = tun;
					_tmp426_ = netsukuku_tunnel_item_get_ipstr (_tmp425_);
					_tmp427_ = _tmp426_;
					_tmp428_ = g_strdup (_tmp427_);
					ipstr = _tmp428_;
					_tmp429_ = i;
					_tmp430_ = g_strdup_printf ("%i", _tmp429_);
					_tmp431_ = _tmp430_;
					_tmp432_ = g_strconcat ("ntk-to-inet-", _tmp431_, NULL);
					_tmp433_ = _tmp432_;
					_g_free0 (_tmp431_);
					dev = _tmp433_;
					_tmp434_ = pref_src;
					_tmp435_ = string_to_string (_tmp434_);
					_tmp436_ = dev;
					_tmp437_ = string_to_string (_tmp436_);
					_tmp438_ = g_strconcat ("addr del ", _tmp435_, " dev ", _tmp437_, NULL);
					_tmp439_ = _tmp438_;
					netsukuku_impl_linux_iproute_exp (_tmp439_);
					_g_free0 (_tmp439_);
					_tmp440_ = dev;
					_tmp441_ = string_to_string (_tmp440_);
					_tmp442_ = g_strconcat ("link set ", _tmp441_, " down", NULL);
					_tmp443_ = _tmp442_;
					netsukuku_impl_linux_iproute_exp (_tmp443_);
					_g_free0 (_tmp443_);
					_tmp444_ = dev;
					_tmp445_ = string_to_string (_tmp444_);
					_tmp446_ = ipstr;
					_tmp447_ = string_to_string (_tmp446_);
					_tmp448_ = g_strconcat ("tunnel dek ", _tmp445_, " mode ipip remote ", _tmp447_, NULL);
					_tmp449_ = _tmp448_;
					netsukuku_impl_linux_iproute_exp (_tmp449_);
					_g_free0 (_tmp449_);
					_tmp450_ = i;
					i = _tmp450_ + 1;
					_g_free0 (dev);
					_g_free0 (ipstr);
					_g_object_unref0 (tun);
				}
				_g_object_unref0 (_tun_list);
			}
			_g_free0 (cmd);
		}
		_tmp451_ = list_tunnels;
		_tmp452_ = gee_collection_get_is_empty ((GeeCollection*) _tmp451_);
		_tmp453_ = _tmp452_;
		if (!_tmp453_) {
			gint i;
			gchar* _tmp492_ = NULL;
			gchar* _tmp493_;
			gchar* _tmp542_;
			gchar* cmd;
			const gchar* _tmp581_;
			i = 0;
			{
				GeeArrayList* _tmp454_;
				GeeArrayList* _tmp455_;
				GeeArrayList* _tun_list;
				GeeArrayList* _tmp456_;
				gint _tmp457_;
				gint _tmp458_;
				gint _tun_size;
				gint _tun_index;
				_tmp454_ = list_tunnels;
				_tmp455_ = _g_object_ref0 (_tmp454_);
				_tun_list = _tmp455_;
				_tmp456_ = _tun_list;
				_tmp457_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp456_);
				_tmp458_ = _tmp457_;
				_tun_size = _tmp458_;
				_tun_index = -1;
				while (TRUE) {
					gint _tmp459_;
					gint _tmp460_;
					gint _tmp461_;
					GeeArrayList* _tmp462_;
					gint _tmp463_;
					gpointer _tmp464_ = NULL;
					NetsukukuTunnelItem* tun;
					NetsukukuTunnelItem* _tmp465_;
					const gchar* _tmp466_;
					const gchar* _tmp467_;
					gchar* _tmp468_;
					gchar* ipstr;
					gint _tmp469_;
					gchar* _tmp470_ = NULL;
					gchar* _tmp471_;
					gchar* _tmp472_ = NULL;
					gchar* _tmp473_;
					gchar* dev;
					const gchar* _tmp474_;
					const gchar* _tmp475_ = NULL;
					const gchar* _tmp476_;
					const gchar* _tmp477_ = NULL;
					gchar* _tmp478_ = NULL;
					gchar* _tmp479_;
					const gchar* _tmp480_;
					const gchar* _tmp481_ = NULL;
					gchar* _tmp482_ = NULL;
					gchar* _tmp483_;
					const gchar* _tmp484_;
					const gchar* _tmp485_;
					const gchar* _tmp486_ = NULL;
					const gchar* _tmp487_;
					const gchar* _tmp488_ = NULL;
					gchar* _tmp489_ = NULL;
					gchar* _tmp490_;
					gint _tmp491_;
					_tmp459_ = _tun_index;
					_tun_index = _tmp459_ + 1;
					_tmp460_ = _tun_index;
					_tmp461_ = _tun_size;
					if (!(_tmp460_ < _tmp461_)) {
						break;
					}
					_tmp462_ = _tun_list;
					_tmp463_ = _tun_index;
					_tmp464_ = gee_abstract_list_get ((GeeAbstractList*) _tmp462_, _tmp463_);
					tun = (NetsukukuTunnelItem*) _tmp464_;
					_tmp465_ = tun;
					_tmp466_ = netsukuku_tunnel_item_get_ipstr (_tmp465_);
					_tmp467_ = _tmp466_;
					_tmp468_ = g_strdup (_tmp467_);
					ipstr = _tmp468_;
					_tmp469_ = i;
					_tmp470_ = g_strdup_printf ("%i", _tmp469_);
					_tmp471_ = _tmp470_;
					_tmp472_ = g_strconcat ("ntk-to-inet-", _tmp471_, NULL);
					_tmp473_ = _tmp472_;
					_g_free0 (_tmp471_);
					dev = _tmp473_;
					_tmp474_ = dev;
					_tmp475_ = string_to_string (_tmp474_);
					_tmp476_ = ipstr;
					_tmp477_ = string_to_string (_tmp476_);
					_tmp478_ = g_strconcat ("tunnel add ", _tmp475_, " mode ipip remote ", _tmp477_, NULL);
					_tmp479_ = _tmp478_;
					netsukuku_impl_linux_iproute_exp (_tmp479_);
					_g_free0 (_tmp479_);
					_tmp480_ = dev;
					_tmp481_ = string_to_string (_tmp480_);
					_tmp482_ = g_strconcat ("link set ", _tmp481_, " up", NULL);
					_tmp483_ = _tmp482_;
					netsukuku_impl_linux_iproute_exp (_tmp483_);
					_g_free0 (_tmp483_);
					_netsukuku_impl_linux_linux_route_disable_rp_filter (self, "tunl0");
					_tmp484_ = dev;
					_netsukuku_impl_linux_linux_route_disable_rp_filter (self, _tmp484_);
					_tmp485_ = pref_src;
					_tmp486_ = string_to_string (_tmp485_);
					_tmp487_ = dev;
					_tmp488_ = string_to_string (_tmp487_);
					_tmp489_ = g_strconcat ("addr add ", _tmp486_, " dev ", _tmp488_, NULL);
					_tmp490_ = _tmp489_;
					netsukuku_impl_linux_iproute_exp (_tmp490_);
					_g_free0 (_tmp490_);
					_tmp491_ = i;
					i = _tmp491_ + 1;
					_g_free0 (dev);
					_g_free0 (ipstr);
					_g_object_unref0 (tun);
				}
				_g_object_unref0 (_tun_list);
			}
			_tmp492_ = netsukuku_impl_linux_iptables ("-t mangle -A OUTPUT -m conntrack --ctstate ESTABLISHED,RELATED  -j CON" \
"NMARK --restore-mark", &_inner_error_);
			_tmp493_ = _tmp492_;
			_g_free0 (_tmp493_);
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				weights = (g_free (weights), NULL);
				_g_free0 (dbg_list_tunnels);
				return FALSE;
			}
			i = 0;
			{
				GeeArrayList* _tmp494_;
				GeeArrayList* _tmp495_;
				GeeArrayList* _tun_list;
				GeeArrayList* _tmp496_;
				gint _tmp497_;
				gint _tmp498_;
				gint _tun_size;
				gint _tun_index;
				_tmp494_ = list_tunnels;
				_tmp495_ = _g_object_ref0 (_tmp494_);
				_tun_list = _tmp495_;
				_tmp496_ = _tun_list;
				_tmp497_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp496_);
				_tmp498_ = _tmp497_;
				_tun_size = _tmp498_;
				_tun_index = -1;
				while (TRUE) {
					gint _tmp499_;
					gint _tmp500_;
					gint _tmp501_;
					GeeArrayList* _tmp502_;
					gint _tmp503_;
					gpointer _tmp504_ = NULL;
					NetsukukuTunnelItem* tun;
					NetsukukuTunnelItem* _tmp505_;
					const gchar* _tmp506_;
					const gchar* _tmp507_;
					gchar* _tmp508_;
					gchar* ipstr;
					gint _tmp509_;
					gchar* _tmp510_ = NULL;
					gchar* _tmp511_;
					gchar* _tmp512_ = NULL;
					gchar* _tmp513_;
					gchar* dev;
					gint _tmp514_;
					gint tableid;
					const gchar* _tmp515_;
					const gchar* _tmp516_ = NULL;
					gint _tmp517_;
					gchar* _tmp518_ = NULL;
					gchar* _tmp519_;
					gchar* _tmp520_ = NULL;
					gchar* _tmp521_;
					gint _tmp522_;
					gchar* _tmp523_ = NULL;
					gchar* _tmp524_;
					gint _tmp525_;
					gchar* _tmp526_ = NULL;
					gchar* _tmp527_;
					gchar* _tmp528_ = NULL;
					gchar* _tmp529_;
					gint _tmp530_;
					gchar* _tmp531_ = NULL;
					gchar* _tmp532_;
					const gchar* _tmp533_;
					const gchar* _tmp534_ = NULL;
					const gchar* _tmp535_;
					const gchar* _tmp536_ = NULL;
					const gchar* _tmp537_;
					const gchar* _tmp538_ = NULL;
					gchar* _tmp539_ = NULL;
					gchar* _tmp540_;
					gint _tmp541_;
					_tmp499_ = _tun_index;
					_tun_index = _tmp499_ + 1;
					_tmp500_ = _tun_index;
					_tmp501_ = _tun_size;
					if (!(_tmp500_ < _tmp501_)) {
						break;
					}
					_tmp502_ = _tun_list;
					_tmp503_ = _tun_index;
					_tmp504_ = gee_abstract_list_get ((GeeAbstractList*) _tmp502_, _tmp503_);
					tun = (NetsukukuTunnelItem*) _tmp504_;
					_tmp505_ = tun;
					_tmp506_ = netsukuku_tunnel_item_get_ipstr (_tmp505_);
					_tmp507_ = _tmp506_;
					_tmp508_ = g_strdup (_tmp507_);
					ipstr = _tmp508_;
					_tmp509_ = i;
					_tmp510_ = g_strdup_printf ("%i", _tmp509_);
					_tmp511_ = _tmp510_;
					_tmp512_ = g_strconcat ("ntk-to-inet-", _tmp511_, NULL);
					_tmp513_ = _tmp512_;
					_g_free0 (_tmp511_);
					dev = _tmp513_;
					_tmp514_ = i;
					tableid = 99 - _tmp514_;
					_tmp515_ = dev;
					_tmp516_ = string_to_string (_tmp515_);
					_tmp517_ = tableid;
					_tmp518_ = g_strdup_printf ("%i", _tmp517_);
					_tmp519_ = _tmp518_;
					_tmp520_ = g_strconcat ("-t mangle -A POSTROUTING -o ", _tmp516_, " -m conntrack --ctstate NEW -j CONNMARK --set-mark ", _tmp519_, NULL);
					_tmp521_ = _tmp520_;
					netsukuku_impl_linux_iptables_exp (_tmp521_);
					_g_free0 (_tmp521_);
					_g_free0 (_tmp519_);
					_tmp522_ = tableid;
					_tmp523_ = g_strdup_printf ("%i", _tmp522_);
					_tmp524_ = _tmp523_;
					_tmp525_ = tableid;
					_tmp526_ = g_strdup_printf ("%i", _tmp525_);
					_tmp527_ = _tmp526_;
					_tmp528_ = g_strconcat ("rule add fwmark ", _tmp524_, " lookup ", _tmp527_, NULL);
					_tmp529_ = _tmp528_;
					netsukuku_impl_linux_iproute_exp (_tmp529_);
					_g_free0 (_tmp529_);
					_g_free0 (_tmp527_);
					_g_free0 (_tmp524_);
					_tmp530_ = tableid;
					_tmp531_ = g_strdup_printf ("%i", _tmp530_);
					_tmp532_ = _tmp531_;
					_tmp533_ = ipstr;
					_tmp534_ = string_to_string (_tmp533_);
					_tmp535_ = dev;
					_tmp536_ = string_to_string (_tmp535_);
					_tmp537_ = pref_src;
					_tmp538_ = string_to_string (_tmp537_);
					_tmp539_ = g_strconcat ("route add table ", _tmp532_, " default via ", _tmp534_, " dev ", _tmp536_, " src ", _tmp538_, " onlink", NULL);
					_tmp540_ = _tmp539_;
					netsukuku_impl_linux_iproute_exp (_tmp540_);
					_g_free0 (_tmp540_);
					_g_free0 (_tmp532_);
					_tmp541_ = i;
					i = _tmp541_ + 1;
					_g_free0 (dev);
					_g_free0 (ipstr);
					_g_object_unref0 (tun);
				}
				_g_object_unref0 (_tun_list);
			}
			_tmp542_ = g_strdup ("route add default ");
			cmd = _tmp542_;
			i = 0;
			{
				GeeArrayList* _tmp543_;
				GeeArrayList* _tmp544_;
				GeeArrayList* _tun_list;
				GeeArrayList* _tmp545_;
				gint _tmp546_;
				gint _tmp547_;
				gint _tun_size;
				gint _tun_index;
				_tmp543_ = list_tunnels;
				_tmp544_ = _g_object_ref0 (_tmp543_);
				_tun_list = _tmp544_;
				_tmp545_ = _tun_list;
				_tmp546_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp545_);
				_tmp547_ = _tmp546_;
				_tun_size = _tmp547_;
				_tun_index = -1;
				while (TRUE) {
					gint _tmp548_;
					gint _tmp549_;
					gint _tmp550_;
					GeeArrayList* _tmp551_;
					gint _tmp552_;
					gpointer _tmp553_ = NULL;
					NetsukukuTunnelItem* tun;
					NetsukukuTunnelItem* _tmp554_;
					const gchar* _tmp555_;
					const gchar* _tmp556_;
					gchar* _tmp557_;
					gchar* ipstr;
					gint _tmp558_;
					gchar* _tmp559_ = NULL;
					gchar* _tmp560_;
					gchar* _tmp561_ = NULL;
					gchar* _tmp562_;
					gchar* dev;
					gint* _tmp563_;
					gint _tmp563__length1;
					GeeArrayList* _tmp564_;
					gint _tmp565_;
					gint _tmp566_;
					gint _tmp567_;
					gint _tmp568_;
					gint weight;
					const gchar* _tmp569_;
					const gchar* _tmp570_;
					const gchar* _tmp571_ = NULL;
					const gchar* _tmp572_;
					const gchar* _tmp573_ = NULL;
					gint _tmp574_;
					gchar* _tmp575_ = NULL;
					gchar* _tmp576_;
					gchar* _tmp577_ = NULL;
					gchar* _tmp578_;
					gchar* _tmp579_;
					gint _tmp580_;
					_tmp548_ = _tun_index;
					_tun_index = _tmp548_ + 1;
					_tmp549_ = _tun_index;
					_tmp550_ = _tun_size;
					if (!(_tmp549_ < _tmp550_)) {
						break;
					}
					_tmp551_ = _tun_list;
					_tmp552_ = _tun_index;
					_tmp553_ = gee_abstract_list_get ((GeeAbstractList*) _tmp551_, _tmp552_);
					tun = (NetsukukuTunnelItem*) _tmp553_;
					_tmp554_ = tun;
					_tmp555_ = netsukuku_tunnel_item_get_ipstr (_tmp554_);
					_tmp556_ = _tmp555_;
					_tmp557_ = g_strdup (_tmp556_);
					ipstr = _tmp557_;
					_tmp558_ = i;
					_tmp559_ = g_strdup_printf ("%i", _tmp558_);
					_tmp560_ = _tmp559_;
					_tmp561_ = g_strconcat ("ntk-to-inet-", _tmp560_, NULL);
					_tmp562_ = _tmp561_;
					_g_free0 (_tmp560_);
					dev = _tmp562_;
					_tmp563_ = weights;
					_tmp563__length1 = weights_length1;
					_tmp564_ = list_tunnels;
					_tmp565_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp564_);
					_tmp566_ = _tmp565_;
					_tmp567_ = i;
					_tmp568_ = _tmp563_[(_tmp566_ - 1) - _tmp567_];
					weight = _tmp568_;
					_tmp569_ = cmd;
					_tmp570_ = ipstr;
					_tmp571_ = string_to_string (_tmp570_);
					_tmp572_ = dev;
					_tmp573_ = string_to_string (_tmp572_);
					_tmp574_ = weight;
					_tmp575_ = g_strdup_printf ("%i", _tmp574_);
					_tmp576_ = _tmp575_;
					_tmp577_ = g_strconcat ("nexthop via ", _tmp571_, " dev ", _tmp573_, " weight ", _tmp576_, " onlink ", NULL);
					_tmp578_ = _tmp577_;
					_tmp579_ = g_strconcat (_tmp569_, _tmp578_, NULL);
					_g_free0 (cmd);
					cmd = _tmp579_;
					_g_free0 (_tmp578_);
					_g_free0 (_tmp576_);
					_tmp580_ = i;
					i = _tmp580_ + 1;
					_g_free0 (dev);
					_g_free0 (ipstr);
					_g_object_unref0 (tun);
				}
				_g_object_unref0 (_tun_list);
			}
			_tmp581_ = cmd;
			netsukuku_impl_linux_iproute_exp (_tmp581_);
			_g_free0 (cmd);
		}
		weights = (g_free (weights), NULL);
	}
	result = TRUE;
	_g_free0 (dbg_list_tunnels);
	return result;
}


static gboolean netsukuku_impl_linux_linux_route_real_check_ping (NetsukukuRouteSetter* base, const gchar* ipstr) {
	NetsukukuImplLinuxLinuxRoute * self;
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	self = (NetsukukuImplLinuxLinuxRoute*) base;
	g_return_val_if_fail (ipstr != NULL, FALSE);
	_tmp0_ = ipstr;
	_tmp1_ = netsukuku_impl_linux_check_ping (_tmp0_);
	result = _tmp1_;
	return result;
}


gboolean netsukuku_impl_linux_linux_route_impl_check_ping (NetsukukuImplLinuxLinuxRoute* self, const gchar* ipstr) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (ipstr != NULL, FALSE);
	_tmp0_ = ipstr;
	_tmp1_ = netsukuku_route_setter_check_ping ((NetsukukuRouteSetter*) self, _tmp0_);
	result = _tmp1_;
	return result;
}


static gboolean netsukuku_impl_linux_linux_route_real__reset_routes (NetsukukuRouteSetter* base, const gchar* ip_whole_network, const gchar* cidr_whole_network) {
	NetsukukuImplLinuxLinuxRoute * self;
	gboolean result = FALSE;
	const gchar* _tmp5_;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	GeeArrayList* _tmp11_;
	GeeArrayList* done;
	GError * _inner_error_ = NULL;
	self = (NetsukukuImplLinuxLinuxRoute*) base;
	g_return_val_if_fail (ip_whole_network != NULL, FALSE);
	g_return_val_if_fail (cidr_whole_network != NULL, FALSE);
	{
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		_tmp0_ = netsukuku_impl_linux_iproute ("route flush table ntk", &_inner_error_);
		_tmp1_ = _tmp0_;
		_g_free0 (_tmp1_);
		if (_inner_error_ != NULL) {
			goto __catch81_g_error;
		}
	}
	goto __finally81;
	__catch81_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		gboolean _tmp4_ = FALSE;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		_tmp4_ = string_contains (_tmp3_, "Nothing to flush");
		_vala_assert (_tmp4_, "e.message.contains(\"Nothing to flush\")");
		_g_error_free0 (e);
	}
	__finally81:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp5_ = ip_whole_network;
	_tmp6_ = string_to_string (_tmp5_);
	_tmp7_ = cidr_whole_network;
	_tmp8_ = string_to_string (_tmp7_);
	_tmp9_ = g_strconcat ("route add table ntk unreachable ", _tmp6_, "/", _tmp8_, NULL);
	_tmp10_ = _tmp9_;
	netsukuku_impl_linux_iproute_exp (_tmp10_);
	_g_free0 (_tmp10_);
	_tmp11_ = gee_array_list_new (G_TYPE_INT, NULL, NULL, NULL, NULL, NULL);
	done = _tmp11_;
	{
		GeeHashMap* _tmp12_;
		GeeCollection* _tmp13_;
		GeeCollection* _tmp14_;
		GeeCollection* _tmp15_;
		GeeIterator* _tmp16_ = NULL;
		GeeIterator* _tmp17_;
		GeeIterator* _idn_it;
		_tmp12_ = self->priv->mac_table;
		_tmp13_ = gee_abstract_map_get_values ((GeeMap*) _tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = _tmp14_;
		_tmp16_ = gee_iterable_iterator ((GeeIterable*) _tmp15_);
		_tmp17_ = _tmp16_;
		_g_object_unref0 (_tmp15_);
		_idn_it = _tmp17_;
		while (TRUE) {
			GeeIterator* _tmp18_;
			gboolean _tmp19_ = FALSE;
			GeeIterator* _tmp20_;
			gpointer _tmp21_ = NULL;
			gint idn;
			GeeArrayList* _tmp22_;
			gint _tmp23_;
			gboolean _tmp24_ = FALSE;
			_tmp18_ = _idn_it;
			_tmp19_ = gee_iterator_next (_tmp18_);
			if (!_tmp19_) {
				break;
			}
			_tmp20_ = _idn_it;
			_tmp21_ = gee_iterator_get (_tmp20_);
			idn = (gint) ((gintptr) _tmp21_);
			_tmp22_ = done;
			_tmp23_ = idn;
			_tmp24_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp22_, (gpointer) ((gintptr) _tmp23_));
			if (!_tmp24_) {
				GeeArrayList* _tmp25_;
				gint _tmp26_;
				_tmp25_ = done;
				_tmp26_ = idn;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp25_, (gpointer) ((gintptr) _tmp26_));
				{
					gint _tmp27_;
					gchar* _tmp28_ = NULL;
					gchar* _tmp29_;
					gchar* _tmp30_ = NULL;
					gchar* _tmp31_;
					gchar* _tmp32_ = NULL;
					gchar* _tmp33_;
					_tmp27_ = idn;
					_tmp28_ = g_strdup_printf ("%i", _tmp27_);
					_tmp29_ = _tmp28_;
					_tmp30_ = g_strconcat ("route flush table ", _tmp29_, NULL);
					_tmp31_ = _tmp30_;
					_tmp32_ = netsukuku_impl_linux_iproute (_tmp31_, &_inner_error_);
					_tmp33_ = _tmp32_;
					_g_free0 (_tmp33_);
					_g_free0 (_tmp31_);
					_g_free0 (_tmp29_);
					if (_inner_error_ != NULL) {
						goto __catch82_g_error;
					}
				}
				goto __finally82;
				__catch82_g_error:
				{
					GError* e = NULL;
					GError* _tmp34_;
					const gchar* _tmp35_;
					gboolean _tmp36_ = FALSE;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp34_ = e;
					_tmp35_ = _tmp34_->message;
					_tmp36_ = string_contains (_tmp35_, "Nothing to flush");
					_vala_assert (_tmp36_, "e.message.contains(\"Nothing to flush\")");
					_g_error_free0 (e);
				}
				__finally82:
				if (_inner_error_ != NULL) {
					_g_object_unref0 (_idn_it);
					_g_object_unref0 (done);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return FALSE;
				}
			}
		}
		_g_object_unref0 (_idn_it);
	}
	result = TRUE;
	_g_object_unref0 (done);
	return result;
}


static void netsukuku_impl_linux_linux_route_real_ip_forward (NetsukukuRouteSetter* base, gboolean enable) {
	NetsukukuImplLinuxLinuxRoute * self;
	gchar* _tmp0_;
	gchar* path;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* content;
	GError * _inner_error_ = NULL;
	self = (NetsukukuImplLinuxLinuxRoute*) base;
	_tmp0_ = g_strdup ("/proc/sys/net/ipv4/ip_forward");
	path = _tmp0_;
	_tmp2_ = enable;
	if (_tmp2_) {
		_tmp1_ = "1";
	} else {
		_tmp1_ = "0";
	}
	_tmp3_ = _tmp1_;
	_tmp4_ = g_strdup (_tmp3_);
	content = _tmp4_;
	{
		const gchar* _tmp5_;
		guint8* _tmp6_;
		gint _tmp6__length1;
		guint8* _tmp7_;
		gint _tmp7__length1;
		_tmp5_ = path;
		_tmp6_ = string_get_data (content, &_tmp6__length1);
		_tmp7_ = _tmp6_;
		_tmp7__length1 = _tmp6__length1;
		netsukuku_impl_linux_write_file (_tmp5_, _tmp7_, _tmp7__length1);
	}
	goto __finally83;
	__catch83_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_;
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp8_ = string_to_string (content);
		_tmp9_ = path;
		_tmp10_ = string_to_string (_tmp9_);
		_tmp11_ = g_strconcat ("ip_forward: error (ignored) writing '", _tmp8_, "' in '", _tmp10_, "'", NULL);
		_tmp12_ = _tmp11_;
		netsukuku_log_error (_tmp12_);
		_g_free0 (_tmp12_);
		_g_error_free0 (e);
	}
	__finally83:
	if (_inner_error_ != NULL) {
		_g_free0 (content);
		_g_free0 (path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (content);
	_g_free0 (path);
}


static void netsukuku_impl_linux_linux_route_class_init (NetsukukuImplLinuxLinuxRouteClass * klass) {
	netsukuku_impl_linux_linux_route_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (NetsukukuImplLinuxLinuxRoutePrivate));
	NETSUKUKU_ROUTE_SETTER_CLASS (klass)->activate_multipath = netsukuku_impl_linux_linux_route_real_activate_multipath;
	NETSUKUKU_ROUTE_SETTER_CLASS (klass)->_add_outgoing_route = netsukuku_impl_linux_linux_route_real__add_outgoing_route;
	NETSUKUKU_ROUTE_SETTER_CLASS (klass)->_add_forwarding_route = netsukuku_impl_linux_linux_route_real__add_forwarding_route;
	NETSUKUKU_ROUTE_SETTER_CLASS (klass)->_add_forwarding_route_unreachable = netsukuku_impl_linux_linux_route_real__add_forwarding_route_unreachable;
	NETSUKUKU_ROUTE_SETTER_CLASS (klass)->_add_forwarding_route_drop = netsukuku_impl_linux_linux_route_real__add_forwarding_route_drop;
	NETSUKUKU_ROUTE_SETTER_CLASS (klass)->_change_outgoing_route = netsukuku_impl_linux_linux_route_real__change_outgoing_route;
	NETSUKUKU_ROUTE_SETTER_CLASS (klass)->_change_forwarding_route = netsukuku_impl_linux_linux_route_real__change_forwarding_route;
	NETSUKUKU_ROUTE_SETTER_CLASS (klass)->_change_forwarding_route_unreachable = netsukuku_impl_linux_linux_route_real__change_forwarding_route_unreachable;
	NETSUKUKU_ROUTE_SETTER_CLASS (klass)->_change_forwarding_route_drop = netsukuku_impl_linux_linux_route_real__change_forwarding_route_drop;
	NETSUKUKU_ROUTE_SETTER_CLASS (klass)->_change_forwarding_route_was_unreachable = netsukuku_impl_linux_linux_route_real__change_forwarding_route_was_unreachable;
	NETSUKUKU_ROUTE_SETTER_CLASS (klass)->_change_forwarding_route_drop_was_unreachable = netsukuku_impl_linux_linux_route_real__change_forwarding_route_drop_was_unreachable;
	NETSUKUKU_ROUTE_SETTER_CLASS (klass)->_change_forwarding_route_was_drop = netsukuku_impl_linux_linux_route_real__change_forwarding_route_was_drop;
	NETSUKUKU_ROUTE_SETTER_CLASS (klass)->_change_forwarding_route_unreachable_was_drop = netsukuku_impl_linux_linux_route_real__change_forwarding_route_unreachable_was_drop;
	NETSUKUKU_ROUTE_SETTER_CLASS (klass)->_remove_outgoing_route = netsukuku_impl_linux_linux_route_real__remove_outgoing_route;
	NETSUKUKU_ROUTE_SETTER_CLASS (klass)->_remove_forwarding_route = netsukuku_impl_linux_linux_route_real__remove_forwarding_route;
	NETSUKUKU_ROUTE_SETTER_CLASS (klass)->_remove_forwarding_route_was_unreachable = netsukuku_impl_linux_linux_route_real__remove_forwarding_route_was_unreachable;
	NETSUKUKU_ROUTE_SETTER_CLASS (klass)->_remove_forwarding_route_was_drop = netsukuku_impl_linux_linux_route_real__remove_forwarding_route_was_drop;
	NETSUKUKU_ROUTE_SETTER_CLASS (klass)->_forward_no_more_from = netsukuku_impl_linux_linux_route_real__forward_no_more_from;
	NETSUKUKU_ROUTE_SETTER_CLASS (klass)->_forward_no_more = netsukuku_impl_linux_linux_route_real__forward_no_more;
	NETSUKUKU_ROUTE_SETTER_CLASS (klass)->_add_neighbour = netsukuku_impl_linux_linux_route_real__add_neighbour;
	NETSUKUKU_ROUTE_SETTER_CLASS (klass)->_change_neighbour = netsukuku_impl_linux_linux_route_real__change_neighbour;
	NETSUKUKU_ROUTE_SETTER_CLASS (klass)->_delete_neighbour = netsukuku_impl_linux_linux_route_real__delete_neighbour;
	NETSUKUKU_ROUTE_SETTER_CLASS (klass)->_igs_update_rules = netsukuku_impl_linux_linux_route_real__igs_update_rules;
	NETSUKUKU_ROUTE_SETTER_CLASS (klass)->check_ping = netsukuku_impl_linux_linux_route_real_check_ping;
	NETSUKUKU_ROUTE_SETTER_CLASS (klass)->_reset_routes = netsukuku_impl_linux_linux_route_real__reset_routes;
	NETSUKUKU_ROUTE_SETTER_CLASS (klass)->ip_forward = netsukuku_impl_linux_linux_route_real_ip_forward;
	G_OBJECT_CLASS (klass)->finalize = netsukuku_impl_linux_linux_route_finalize;
}


static void netsukuku_impl_linux_linux_route_instance_init (NetsukukuImplLinuxLinuxRoute * self) {
	self->priv = NETSUKUKU_IMPL_LINUX_LINUX_ROUTE_GET_PRIVATE (self);
}


static void netsukuku_impl_linux_linux_route_finalize (GObject* obj) {
	NetsukukuImplLinuxLinuxRoute * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_IMPL_LINUX_TYPE_LINUX_ROUTE, NetsukukuImplLinuxLinuxRoute);
	_g_object_unref0 (self->priv->mac_table);
	G_OBJECT_CLASS (netsukuku_impl_linux_linux_route_parent_class)->finalize (obj);
}


GType netsukuku_impl_linux_linux_route_get_type (void) {
	static volatile gsize netsukuku_impl_linux_linux_route_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_impl_linux_linux_route_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuImplLinuxLinuxRouteClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_impl_linux_linux_route_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuImplLinuxLinuxRoute), 0, (GInstanceInitFunc) netsukuku_impl_linux_linux_route_instance_init, NULL };
		GType netsukuku_impl_linux_linux_route_type_id;
		netsukuku_impl_linux_linux_route_type_id = g_type_register_static (NETSUKUKU_TYPE_ROUTE_SETTER, "NetsukukuImplLinuxLinuxRoute", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_impl_linux_linux_route_type_id__volatile, netsukuku_impl_linux_linux_route_type_id);
	}
	return netsukuku_impl_linux_linux_route_type_id__volatile;
}


static NetsukukuConnections* _netsukuku_impl_linux_linux_connections_create (void) {
	NetsukukuConnections* result = NULL;
	NetsukukuImplLinuxLinuxConnections* _tmp0_;
	_tmp0_ = netsukuku_impl_linux_linux_connections_new ();
	result = (NetsukukuConnections*) _tmp0_;
	return result;
}


static NetsukukuConnections* __netsukuku_impl_linux_linux_connections_create_netsukuku_create_connections_delegate (gpointer self) {
	NetsukukuConnections* result;
	result = _netsukuku_impl_linux_linux_connections_create ();
	return result;
}


void netsukuku_impl_linux_linux_connections_register (void) {
	netsukuku_connections_register_class ("linux", __netsukuku_impl_linux_linux_connections_create_netsukuku_create_connections_delegate, NULL);
}


static gboolean netsukuku_impl_linux_linux_connections_real_active_tcp_connections (NetsukukuConnections* base, const gchar* ip) {
	NetsukukuImplLinuxLinuxConnections * self;
	gboolean result = FALSE;
	const gchar* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	self = (NetsukukuImplLinuxLinuxConnections*) base;
	g_return_val_if_fail (ip != NULL, FALSE);
	_tmp0_ = ip;
	_tmp1_ = string_to_string (_tmp0_);
	_tmp2_ = g_strconcat ("Connections: issue: netstat -an | grep ^tcp | grep ESTABLISHED | grep ", _tmp1_, ":", NULL);
	_tmp3_ = _tmp2_;
	netsukuku_log_info (_tmp3_);
	_g_free0 (_tmp3_);
	result = FALSE;
	return result;
}


NetsukukuImplLinuxLinuxConnections* netsukuku_impl_linux_linux_connections_construct (GType object_type) {
	NetsukukuImplLinuxLinuxConnections * self = NULL;
	self = (NetsukukuImplLinuxLinuxConnections*) netsukuku_connections_construct (object_type);
	return self;
}


NetsukukuImplLinuxLinuxConnections* netsukuku_impl_linux_linux_connections_new (void) {
	return netsukuku_impl_linux_linux_connections_construct (NETSUKUKU_IMPL_LINUX_TYPE_LINUX_CONNECTIONS);
}


static void netsukuku_impl_linux_linux_connections_class_init (NetsukukuImplLinuxLinuxConnectionsClass * klass) {
	netsukuku_impl_linux_linux_connections_parent_class = g_type_class_peek_parent (klass);
	NETSUKUKU_CONNECTIONS_CLASS (klass)->active_tcp_connections = netsukuku_impl_linux_linux_connections_real_active_tcp_connections;
}


static void netsukuku_impl_linux_linux_connections_instance_init (NetsukukuImplLinuxLinuxConnections * self) {
}


GType netsukuku_impl_linux_linux_connections_get_type (void) {
	static volatile gsize netsukuku_impl_linux_linux_connections_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_impl_linux_linux_connections_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuImplLinuxLinuxConnectionsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_impl_linux_linux_connections_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuImplLinuxLinuxConnections), 0, (GInstanceInitFunc) netsukuku_impl_linux_linux_connections_instance_init, NULL };
		GType netsukuku_impl_linux_linux_connections_type_id;
		netsukuku_impl_linux_linux_connections_type_id = g_type_register_static (NETSUKUKU_TYPE_CONNECTIONS, "NetsukukuImplLinuxLinuxConnections", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_impl_linux_linux_connections_type_id__volatile, netsukuku_impl_linux_linux_connections_type_id);
	}
	return netsukuku_impl_linux_linux_connections_type_id__volatile;
}


static NetsukukuBaseTunnel* _netsukuku_impl_linux_linux_tunnel_create (void) {
	NetsukukuBaseTunnel* result = NULL;
	NetsukukuImplLinuxLinuxTunnel* _tmp0_;
	_tmp0_ = netsukuku_impl_linux_linux_tunnel_new ();
	result = (NetsukukuBaseTunnel*) _tmp0_;
	return result;
}


static NetsukukuBaseTunnel* __netsukuku_impl_linux_linux_tunnel_create_netsukuku_create_tunnel_delegate (gpointer self) {
	NetsukukuBaseTunnel* result;
	result = _netsukuku_impl_linux_linux_tunnel_create ();
	return result;
}


void netsukuku_impl_linux_linux_tunnel_register (void) {
	netsukuku_base_tunnel_register_class ("linux", __netsukuku_impl_linux_linux_tunnel_create_netsukuku_create_tunnel_delegate, NULL);
}


NetsukukuImplLinuxLinuxTunnel* netsukuku_impl_linux_linux_tunnel_construct (GType object_type) {
	NetsukukuImplLinuxLinuxTunnel * self = NULL;
	GeeLinkedList* _tmp0_;
	GeeHashMap* _tmp7_;
	self = (NetsukukuImplLinuxLinuxTunnel*) netsukuku_base_tunnel_construct (object_type);
	_tmp0_ = gee_linked_list_new (G_TYPE_INT, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->port_pool);
	self->priv->port_pool = _tmp0_;
	{
		gint i;
		i = 50655;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				gboolean _tmp2_;
				gint _tmp4_;
				GeeLinkedList* _tmp5_;
				gint _tmp6_;
				_tmp2_ = _tmp1_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp4_ = i;
				if (!(_tmp4_ < 50680)) {
					break;
				}
				_tmp5_ = self->priv->port_pool;
				_tmp6_ = i;
				gee_queue_offer ((GeeQueue*) _tmp5_, (gpointer) ((gintptr) _tmp6_));
			}
		}
	}
	_tmp7_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_INT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->used_ports);
	self->priv->used_ports = _tmp7_;
	return self;
}


NetsukukuImplLinuxLinuxTunnel* netsukuku_impl_linux_linux_tunnel_new (void) {
	return netsukuku_impl_linux_linux_tunnel_construct (NETSUKUKU_IMPL_LINUX_TYPE_LINUX_TUNNEL);
}


static gchar* netsukuku_impl_linux_linux_tunnel_real_serve (NetsukukuBaseTunnel* base, NetsukukuCallbackSendDelegate cb_send, void* cb_send_target, NetsukukuCallbackRecvDelegate cb_recv, void* cb_recv_target, const gchar* my_address, const gchar* dest_address, GError** error) {
	NetsukukuImplLinuxLinuxTunnel * self;
	gchar* result = NULL;
	GeeLinkedList* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GeeLinkedList* _tmp4_;
	gpointer _tmp5_ = NULL;
	gint my_port;
	NetsukukuCallbackRecvDelegate _tmp6_;
	void* _tmp6__target;
	zcdISerializable* _tmp7_ = NULL;
	zcdISerializable* _tmp8_;
	zcdSerializableString* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* nic_name;
	GeeHashMap* _tmp14_;
	const gchar* _tmp15_;
	gint _tmp16_;
	gchar* cmdout = NULL;
	gchar* cmderr = NULL;
	gint exit_status = 0;
	const gchar* _tmp17_;
	const gchar* _tmp18_ = NULL;
	const gchar* _tmp19_;
	const gchar* _tmp20_ = NULL;
	gint _tmp21_;
	gchar* _tmp22_ = NULL;
	gchar* _tmp23_;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_;
	gchar* _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
	gint _tmp28_ = 0;
	gint _tmp29_;
	const gchar* _tmp36_;
	const gchar* _tmp37_ = NULL;
	gchar* _tmp38_ = NULL;
	gchar* _tmp39_;
	gint _tmp40_ = 0;
	guint8* _tmp41_ = NULL;
	guint8* _tmp42_;
	gint _tmp42__length1;
	guint8* key;
	gint key_length1;
	gint _key_size_;
	guint8* _tmp43_;
	gint _tmp43__length1;
	NetsukukuCallbackRecvDelegate _tmp45_;
	void* _tmp45__target;
	zcdISerializable* _tmp46_ = NULL;
	zcdISerializable* _tmp47_;
	zcdSerializableBuffer* peer_key;
	NetsukukuCallbackSendDelegate _tmp48_;
	void* _tmp48__target;
	guint8* _tmp49_;
	gint _tmp49__length1;
	zcdSerializableBuffer* _tmp50_;
	zcdSerializableBuffer* _tmp51_;
	const gchar* _tmp52_;
	const gchar* _tmp53_ = NULL;
	gchar* _tmp54_ = NULL;
	gchar* _tmp55_;
	zcdSerializableBuffer* _tmp56_;
	guint8* _tmp57_;
	gint _tmp57__length1;
	guint8* _tmp58_;
	gint _tmp58__length1;
	const gchar* _tmp59_;
	const gchar* _tmp60_ = NULL;
	const gchar* _tmp61_;
	const gchar* _tmp62_ = NULL;
	gint _tmp63_;
	gchar* _tmp64_ = NULL;
	gchar* _tmp65_;
	gchar* _tmp66_ = NULL;
	gchar* _tmp67_;
	gchar* _tmp68_ = NULL;
	gchar* _tmp69_ = NULL;
	gint _tmp70_ = 0;
	gint _tmp71_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuImplLinuxLinuxTunnel*) base;
	g_return_val_if_fail (my_address != NULL, NULL);
	g_return_val_if_fail (dest_address != NULL, NULL);
	_tmp0_ = self->priv->port_pool;
	_tmp1_ = gee_collection_get_is_empty ((GeeCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GError* _tmp3_;
		_tmp3_ = g_error_new_literal (NETSUKUKU_TUNNEL_ERROR, NETSUKUKU_TUNNEL_ERROR_GENERIC, "tincd: no more free ports. too many instances?");
		_inner_error_ = _tmp3_;
		if ((_inner_error_->domain == NETSUKUKU_TUNNEL_ERROR) || (_inner_error_->domain == ZCD_RPC_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp4_ = self->priv->port_pool;
	_tmp5_ = gee_queue_poll ((GeeQueue*) _tmp4_);
	my_port = (gint) ((gintptr) _tmp5_);
	_tmp6_ = cb_recv;
	_tmp6__target = cb_recv_target;
	_tmp7_ = _tmp6_ (_tmp6__target, &_inner_error_);
	_tmp8_ = _tmp7_;
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == NETSUKUKU_TUNNEL_ERROR) || (_inner_error_->domain == ZCD_RPC_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp9_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, ZCD_TYPE_SERIALIZABLE_STRING, zcdSerializableString);
	_tmp10_ = zcd_serializable_string_get_s (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strdup (_tmp11_);
	_tmp13_ = _tmp12_;
	_g_object_unref0 (_tmp9_);
	nic_name = _tmp13_;
	_tmp14_ = self->priv->used_ports;
	_tmp15_ = nic_name;
	_tmp16_ = my_port;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp14_, _tmp15_, (gpointer) ((gintptr) _tmp16_));
	_tmp17_ = nic_name;
	_tmp18_ = string_to_string (_tmp17_);
	_tmp19_ = my_address;
	_tmp20_ = string_to_string (_tmp19_);
	_tmp21_ = my_port;
	_tmp22_ = g_strdup_printf ("%i", _tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = g_strconcat ("/etc/netsukuku/tinc configure_server ", _tmp18_, " ", _tmp20_, " ", _tmp23_, NULL);
	_tmp25_ = _tmp24_;
	netsukuku_impl_linux_sequential_command (_tmp25_, &_tmp26_, &_tmp27_, &_tmp28_);
	_g_free0 (cmdout);
	cmdout = _tmp26_;
	_g_free0 (cmderr);
	cmderr = _tmp27_;
	exit_status = _tmp28_;
	_g_free0 (_tmp25_);
	_g_free0 (_tmp23_);
	_tmp29_ = exit_status;
	if (_tmp29_ != 0) {
		const gchar* _tmp30_;
		const gchar* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
		gchar* _tmp33_;
		GError* _tmp34_;
		GError* _tmp35_;
		_tmp30_ = cmderr;
		_tmp31_ = string_to_string (_tmp30_);
		_tmp32_ = g_strconcat ("tincd: ", _tmp31_, NULL);
		_tmp33_ = _tmp32_;
		_tmp34_ = g_error_new_literal (NETSUKUKU_TUNNEL_ERROR, NETSUKUKU_TUNNEL_ERROR_GENERIC, _tmp33_);
		_tmp35_ = _tmp34_;
		_g_free0 (_tmp33_);
		_inner_error_ = _tmp35_;
		if ((_inner_error_->domain == NETSUKUKU_TUNNEL_ERROR) || (_inner_error_->domain == ZCD_RPC_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (cmderr);
			_g_free0 (cmdout);
			_g_free0 (nic_name);
			return NULL;
		} else {
			_g_free0 (cmderr);
			_g_free0 (cmdout);
			_g_free0 (nic_name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp36_ = nic_name;
	_tmp37_ = string_to_string (_tmp36_);
	_tmp38_ = g_strconcat ("/etc/tinc/", _tmp37_, "/hosts/node_server", NULL);
	_tmp39_ = _tmp38_;
	_tmp41_ = netsukuku_impl_linux_read_file (_tmp39_, 2000, &_tmp40_);
	_tmp42_ = _tmp41_;
	_tmp42__length1 = _tmp40_;
	_g_free0 (_tmp39_);
	key = _tmp42_;
	key_length1 = _tmp42__length1;
	_key_size_ = key_length1;
	_tmp43_ = key;
	_tmp43__length1 = key_length1;
	if (_tmp43_ == NULL) {
		GError* _tmp44_;
		_tmp44_ = g_error_new_literal (NETSUKUKU_TUNNEL_ERROR, NETSUKUKU_TUNNEL_ERROR_GENERIC, "tincd: key file not generated.");
		_inner_error_ = _tmp44_;
		if ((_inner_error_->domain == NETSUKUKU_TUNNEL_ERROR) || (_inner_error_->domain == ZCD_RPC_ERROR)) {
			g_propagate_error (error, _inner_error_);
			key = (g_free (key), NULL);
			_g_free0 (cmderr);
			_g_free0 (cmdout);
			_g_free0 (nic_name);
			return NULL;
		} else {
			key = (g_free (key), NULL);
			_g_free0 (cmderr);
			_g_free0 (cmdout);
			_g_free0 (nic_name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp45_ = cb_recv;
	_tmp45__target = cb_recv_target;
	_tmp46_ = _tmp45_ (_tmp45__target, &_inner_error_);
	_tmp47_ = _tmp46_;
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == NETSUKUKU_TUNNEL_ERROR) || (_inner_error_->domain == ZCD_RPC_ERROR)) {
			g_propagate_error (error, _inner_error_);
			key = (g_free (key), NULL);
			_g_free0 (cmderr);
			_g_free0 (cmdout);
			_g_free0 (nic_name);
			return NULL;
		} else {
			key = (g_free (key), NULL);
			_g_free0 (cmderr);
			_g_free0 (cmdout);
			_g_free0 (nic_name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	peer_key = G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, ZCD_TYPE_SERIALIZABLE_BUFFER, zcdSerializableBuffer);
	_tmp48_ = cb_send;
	_tmp48__target = cb_send_target;
	_tmp49_ = key;
	_tmp49__length1 = key_length1;
	_tmp50_ = zcd_serializable_buffer_new (_tmp49_, _tmp49__length1);
	_tmp51_ = _tmp50_;
	_tmp48_ ((zcdISerializable*) _tmp51_, _tmp48__target, &_inner_error_);
	_g_object_unref0 (_tmp51_);
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == NETSUKUKU_TUNNEL_ERROR) || (_inner_error_->domain == ZCD_RPC_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (peer_key);
			key = (g_free (key), NULL);
			_g_free0 (cmderr);
			_g_free0 (cmdout);
			_g_free0 (nic_name);
			return NULL;
		} else {
			_g_object_unref0 (peer_key);
			key = (g_free (key), NULL);
			_g_free0 (cmderr);
			_g_free0 (cmdout);
			_g_free0 (nic_name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp52_ = nic_name;
	_tmp53_ = string_to_string (_tmp52_);
	_tmp54_ = g_strconcat ("/etc/tinc/", _tmp53_, "/hosts/node_client", NULL);
	_tmp55_ = _tmp54_;
	_tmp56_ = peer_key;
	_tmp57_ = zcd_serializable_buffer_get_buffer (_tmp56_, &_tmp57__length1);
	_tmp58_ = _tmp57_;
	_tmp58__length1 = _tmp57__length1;
	netsukuku_impl_linux_write_file (_tmp55_, _tmp58_, _tmp58__length1);
	_g_free0 (_tmp55_);
	_tmp59_ = nic_name;
	_tmp60_ = string_to_string (_tmp59_);
	_tmp61_ = my_address;
	_tmp62_ = string_to_string (_tmp61_);
	_tmp63_ = my_port;
	_tmp64_ = g_strdup_printf ("%i", _tmp63_);
	_tmp65_ = _tmp64_;
	_tmp66_ = g_strconcat ("/etc/netsukuku/tinc start ", _tmp60_, " ", _tmp62_, " ", _tmp65_, NULL);
	_tmp67_ = _tmp66_;
	netsukuku_impl_linux_sequential_command (_tmp67_, &_tmp68_, &_tmp69_, &_tmp70_);
	_g_free0 (cmdout);
	cmdout = _tmp68_;
	_g_free0 (cmderr);
	cmderr = _tmp69_;
	exit_status = _tmp70_;
	_g_free0 (_tmp67_);
	_g_free0 (_tmp65_);
	_tmp71_ = exit_status;
	if (_tmp71_ != 0) {
		const gchar* _tmp72_;
		const gchar* _tmp73_ = NULL;
		gchar* _tmp74_ = NULL;
		gchar* _tmp75_;
		GError* _tmp76_;
		GError* _tmp77_;
		_tmp72_ = cmderr;
		_tmp73_ = string_to_string (_tmp72_);
		_tmp74_ = g_strconcat ("tincd: ", _tmp73_, NULL);
		_tmp75_ = _tmp74_;
		_tmp76_ = g_error_new_literal (NETSUKUKU_TUNNEL_ERROR, NETSUKUKU_TUNNEL_ERROR_GENERIC, _tmp75_);
		_tmp77_ = _tmp76_;
		_g_free0 (_tmp75_);
		_inner_error_ = _tmp77_;
		if ((_inner_error_->domain == NETSUKUKU_TUNNEL_ERROR) || (_inner_error_->domain == ZCD_RPC_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (peer_key);
			key = (g_free (key), NULL);
			_g_free0 (cmderr);
			_g_free0 (cmdout);
			_g_free0 (nic_name);
			return NULL;
		} else {
			_g_object_unref0 (peer_key);
			key = (g_free (key), NULL);
			_g_free0 (cmderr);
			_g_free0 (cmdout);
			_g_free0 (nic_name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = nic_name;
	_g_object_unref0 (peer_key);
	key = (g_free (key), NULL);
	_g_free0 (cmderr);
	_g_free0 (cmdout);
	return result;
}


static gchar* netsukuku_impl_linux_linux_tunnel_real_request (NetsukukuBaseTunnel* base, NetsukukuCallbackSendDelegate cb_send, void* cb_send_target, NetsukukuCallbackRecvDelegate cb_recv, void* cb_recv_target, const gchar* my_address, const gchar* dest_address, GError** error) {
	NetsukukuImplLinuxLinuxTunnel * self;
	gchar* result = NULL;
	GeeLinkedList* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GeeLinkedList* _tmp4_;
	gpointer _tmp5_ = NULL;
	gint my_port;
	gdouble _tmp6_ = 0.0;
	gint32 _tmp7_ = 0;
	gint tunnel_id;
	gint _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
	gchar* nic_name;
	GeeHashMap* _tmp13_;
	const gchar* _tmp14_;
	gint _tmp15_;
	NetsukukuCallbackSendDelegate _tmp16_;
	void* _tmp16__target;
	const gchar* _tmp17_;
	zcdSerializableString* _tmp18_;
	zcdSerializableString* _tmp19_;
	gchar* cmdout = NULL;
	gchar* cmderr = NULL;
	gint exit_status = 0;
	const gchar* _tmp20_;
	const gchar* _tmp21_ = NULL;
	const gchar* _tmp22_;
	const gchar* _tmp23_ = NULL;
	gint _tmp24_;
	gchar* _tmp25_ = NULL;
	gchar* _tmp26_;
	gchar* _tmp27_ = NULL;
	gchar* _tmp28_;
	gchar* _tmp29_ = NULL;
	gchar* _tmp30_ = NULL;
	gint _tmp31_ = 0;
	gint _tmp32_;
	const gchar* _tmp39_;
	const gchar* _tmp40_ = NULL;
	gchar* _tmp41_ = NULL;
	gchar* _tmp42_;
	gint _tmp43_ = 0;
	guint8* _tmp44_ = NULL;
	guint8* _tmp45_;
	gint _tmp45__length1;
	guint8* key;
	gint key_length1;
	gint _key_size_;
	guint8* _tmp46_;
	gint _tmp46__length1;
	NetsukukuCallbackSendDelegate _tmp48_;
	void* _tmp48__target;
	guint8* _tmp49_;
	gint _tmp49__length1;
	zcdSerializableBuffer* _tmp50_;
	zcdSerializableBuffer* _tmp51_;
	NetsukukuCallbackRecvDelegate _tmp52_;
	void* _tmp52__target;
	zcdISerializable* _tmp53_ = NULL;
	zcdISerializable* _tmp54_;
	zcdSerializableBuffer* peer_key;
	const gchar* _tmp55_;
	const gchar* _tmp56_ = NULL;
	gchar* _tmp57_ = NULL;
	gchar* _tmp58_;
	zcdSerializableBuffer* _tmp59_;
	guint8* _tmp60_;
	gint _tmp60__length1;
	guint8* _tmp61_;
	gint _tmp61__length1;
	const gchar* _tmp62_;
	const gchar* _tmp63_ = NULL;
	const gchar* _tmp64_;
	const gchar* _tmp65_ = NULL;
	gint _tmp66_;
	gchar* _tmp67_ = NULL;
	gchar* _tmp68_;
	gchar* _tmp69_ = NULL;
	gchar* _tmp70_;
	gchar* _tmp71_ = NULL;
	gchar* _tmp72_ = NULL;
	gint _tmp73_ = 0;
	gint _tmp74_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuImplLinuxLinuxTunnel*) base;
	g_return_val_if_fail (my_address != NULL, NULL);
	g_return_val_if_fail (dest_address != NULL, NULL);
	_tmp0_ = self->priv->port_pool;
	_tmp1_ = gee_collection_get_is_empty ((GeeCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GError* _tmp3_;
		_tmp3_ = g_error_new_literal (NETSUKUKU_TUNNEL_ERROR, NETSUKUKU_TUNNEL_ERROR_GENERIC, "tincd: no more free ports. too many instances?");
		_inner_error_ = _tmp3_;
		if ((_inner_error_->domain == NETSUKUKU_TUNNEL_ERROR) || (_inner_error_->domain == ZCD_RPC_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp4_ = self->priv->port_pool;
	_tmp5_ = gee_queue_poll ((GeeQueue*) _tmp4_);
	my_port = (gint) ((gintptr) _tmp5_);
	_tmp6_ = pow ((gdouble) 2, (gdouble) 32);
	_tmp7_ = g_random_int_range ((gint32) 0, (gint32) (((gint) _tmp6_) - 1));
	tunnel_id = (gint) _tmp7_;
	_tmp8_ = tunnel_id;
	_tmp9_ = g_strdup_printf ("%i", _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strconcat ("net_", _tmp10_, NULL);
	_tmp12_ = _tmp11_;
	_g_free0 (_tmp10_);
	nic_name = _tmp12_;
	_tmp13_ = self->priv->used_ports;
	_tmp14_ = nic_name;
	_tmp15_ = my_port;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp13_, _tmp14_, (gpointer) ((gintptr) _tmp15_));
	_tmp16_ = cb_send;
	_tmp16__target = cb_send_target;
	_tmp17_ = nic_name;
	_tmp18_ = zcd_serializable_string_new (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp16_ ((zcdISerializable*) _tmp19_, _tmp16__target, &_inner_error_);
	_g_object_unref0 (_tmp19_);
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == NETSUKUKU_TUNNEL_ERROR) || (_inner_error_->domain == ZCD_RPC_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (nic_name);
			return NULL;
		} else {
			_g_free0 (nic_name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp20_ = nic_name;
	_tmp21_ = string_to_string (_tmp20_);
	_tmp22_ = my_address;
	_tmp23_ = string_to_string (_tmp22_);
	_tmp24_ = my_port;
	_tmp25_ = g_strdup_printf ("%i", _tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = g_strconcat ("/etc/netsukuku/tinc configure_client ", _tmp21_, " ", _tmp23_, " ", _tmp26_, NULL);
	_tmp28_ = _tmp27_;
	netsukuku_impl_linux_sequential_command (_tmp28_, &_tmp29_, &_tmp30_, &_tmp31_);
	_g_free0 (cmdout);
	cmdout = _tmp29_;
	_g_free0 (cmderr);
	cmderr = _tmp30_;
	exit_status = _tmp31_;
	_g_free0 (_tmp28_);
	_g_free0 (_tmp26_);
	_tmp32_ = exit_status;
	if (_tmp32_ != 0) {
		const gchar* _tmp33_;
		const gchar* _tmp34_ = NULL;
		gchar* _tmp35_ = NULL;
		gchar* _tmp36_;
		GError* _tmp37_;
		GError* _tmp38_;
		_tmp33_ = cmderr;
		_tmp34_ = string_to_string (_tmp33_);
		_tmp35_ = g_strconcat ("tincd: ", _tmp34_, NULL);
		_tmp36_ = _tmp35_;
		_tmp37_ = g_error_new_literal (NETSUKUKU_TUNNEL_ERROR, NETSUKUKU_TUNNEL_ERROR_GENERIC, _tmp36_);
		_tmp38_ = _tmp37_;
		_g_free0 (_tmp36_);
		_inner_error_ = _tmp38_;
		if ((_inner_error_->domain == NETSUKUKU_TUNNEL_ERROR) || (_inner_error_->domain == ZCD_RPC_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (cmderr);
			_g_free0 (cmdout);
			_g_free0 (nic_name);
			return NULL;
		} else {
			_g_free0 (cmderr);
			_g_free0 (cmdout);
			_g_free0 (nic_name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp39_ = nic_name;
	_tmp40_ = string_to_string (_tmp39_);
	_tmp41_ = g_strconcat ("/etc/tinc/", _tmp40_, "/hosts/node_client", NULL);
	_tmp42_ = _tmp41_;
	_tmp44_ = netsukuku_impl_linux_read_file (_tmp42_, 2000, &_tmp43_);
	_tmp45_ = _tmp44_;
	_tmp45__length1 = _tmp43_;
	_g_free0 (_tmp42_);
	key = _tmp45_;
	key_length1 = _tmp45__length1;
	_key_size_ = key_length1;
	_tmp46_ = key;
	_tmp46__length1 = key_length1;
	if (_tmp46_ == NULL) {
		GError* _tmp47_;
		_tmp47_ = g_error_new_literal (NETSUKUKU_TUNNEL_ERROR, NETSUKUKU_TUNNEL_ERROR_GENERIC, "tincd: key file not generated.");
		_inner_error_ = _tmp47_;
		if ((_inner_error_->domain == NETSUKUKU_TUNNEL_ERROR) || (_inner_error_->domain == ZCD_RPC_ERROR)) {
			g_propagate_error (error, _inner_error_);
			key = (g_free (key), NULL);
			_g_free0 (cmderr);
			_g_free0 (cmdout);
			_g_free0 (nic_name);
			return NULL;
		} else {
			key = (g_free (key), NULL);
			_g_free0 (cmderr);
			_g_free0 (cmdout);
			_g_free0 (nic_name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp48_ = cb_send;
	_tmp48__target = cb_send_target;
	_tmp49_ = key;
	_tmp49__length1 = key_length1;
	_tmp50_ = zcd_serializable_buffer_new (_tmp49_, _tmp49__length1);
	_tmp51_ = _tmp50_;
	_tmp48_ ((zcdISerializable*) _tmp51_, _tmp48__target, &_inner_error_);
	_g_object_unref0 (_tmp51_);
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == NETSUKUKU_TUNNEL_ERROR) || (_inner_error_->domain == ZCD_RPC_ERROR)) {
			g_propagate_error (error, _inner_error_);
			key = (g_free (key), NULL);
			_g_free0 (cmderr);
			_g_free0 (cmdout);
			_g_free0 (nic_name);
			return NULL;
		} else {
			key = (g_free (key), NULL);
			_g_free0 (cmderr);
			_g_free0 (cmdout);
			_g_free0 (nic_name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp52_ = cb_recv;
	_tmp52__target = cb_recv_target;
	_tmp53_ = _tmp52_ (_tmp52__target, &_inner_error_);
	_tmp54_ = _tmp53_;
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == NETSUKUKU_TUNNEL_ERROR) || (_inner_error_->domain == ZCD_RPC_ERROR)) {
			g_propagate_error (error, _inner_error_);
			key = (g_free (key), NULL);
			_g_free0 (cmderr);
			_g_free0 (cmdout);
			_g_free0 (nic_name);
			return NULL;
		} else {
			key = (g_free (key), NULL);
			_g_free0 (cmderr);
			_g_free0 (cmdout);
			_g_free0 (nic_name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	peer_key = G_TYPE_CHECK_INSTANCE_CAST (_tmp54_, ZCD_TYPE_SERIALIZABLE_BUFFER, zcdSerializableBuffer);
	_tmp55_ = nic_name;
	_tmp56_ = string_to_string (_tmp55_);
	_tmp57_ = g_strconcat ("/etc/tinc/", _tmp56_, "/hosts/node_server", NULL);
	_tmp58_ = _tmp57_;
	_tmp59_ = peer_key;
	_tmp60_ = zcd_serializable_buffer_get_buffer (_tmp59_, &_tmp60__length1);
	_tmp61_ = _tmp60_;
	_tmp61__length1 = _tmp60__length1;
	netsukuku_impl_linux_write_file (_tmp58_, _tmp61_, _tmp61__length1);
	_g_free0 (_tmp58_);
	_tmp62_ = nic_name;
	_tmp63_ = string_to_string (_tmp62_);
	_tmp64_ = my_address;
	_tmp65_ = string_to_string (_tmp64_);
	_tmp66_ = my_port;
	_tmp67_ = g_strdup_printf ("%i", _tmp66_);
	_tmp68_ = _tmp67_;
	_tmp69_ = g_strconcat ("/etc/netsukuku/tinc start ", _tmp63_, " ", _tmp65_, " ", _tmp68_, NULL);
	_tmp70_ = _tmp69_;
	netsukuku_impl_linux_sequential_command (_tmp70_, &_tmp71_, &_tmp72_, &_tmp73_);
	_g_free0 (cmdout);
	cmdout = _tmp71_;
	_g_free0 (cmderr);
	cmderr = _tmp72_;
	exit_status = _tmp73_;
	_g_free0 (_tmp70_);
	_g_free0 (_tmp68_);
	_tmp74_ = exit_status;
	if (_tmp74_ != 0) {
		const gchar* _tmp75_;
		const gchar* _tmp76_ = NULL;
		gchar* _tmp77_ = NULL;
		gchar* _tmp78_;
		GError* _tmp79_;
		GError* _tmp80_;
		_tmp75_ = cmderr;
		_tmp76_ = string_to_string (_tmp75_);
		_tmp77_ = g_strconcat ("tincd: ", _tmp76_, NULL);
		_tmp78_ = _tmp77_;
		_tmp79_ = g_error_new_literal (NETSUKUKU_TUNNEL_ERROR, NETSUKUKU_TUNNEL_ERROR_GENERIC, _tmp78_);
		_tmp80_ = _tmp79_;
		_g_free0 (_tmp78_);
		_inner_error_ = _tmp80_;
		if ((_inner_error_->domain == NETSUKUKU_TUNNEL_ERROR) || (_inner_error_->domain == ZCD_RPC_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (peer_key);
			key = (g_free (key), NULL);
			_g_free0 (cmderr);
			_g_free0 (cmdout);
			_g_free0 (nic_name);
			return NULL;
		} else {
			_g_object_unref0 (peer_key);
			key = (g_free (key), NULL);
			_g_free0 (cmderr);
			_g_free0 (cmdout);
			_g_free0 (nic_name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = nic_name;
	_g_object_unref0 (peer_key);
	key = (g_free (key), NULL);
	_g_free0 (cmderr);
	_g_free0 (cmdout);
	return result;
}


static void netsukuku_impl_linux_linux_tunnel_real_close (NetsukukuBaseTunnel* base, const gchar* nic_name, const gchar* my_address, const gchar* dest_address, GError** error) {
	NetsukukuImplLinuxLinuxTunnel * self;
	gchar* cmdout = NULL;
	gchar* cmderr = NULL;
	gint exit_status = 0;
	const gchar* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_;
	const gchar* _tmp14_;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	gint _tmp20_ = 0;
	gint _tmp21_;
	GeeHashMap* _tmp28_;
	const gchar* _tmp29_;
	gpointer _tmp30_ = NULL;
	gint my_port;
	GeeLinkedList* _tmp31_;
	gint _tmp32_;
	GeeHashMap* _tmp33_;
	const gchar* _tmp34_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuImplLinuxLinuxTunnel*) base;
	g_return_if_fail (nic_name != NULL);
	g_return_if_fail (my_address != NULL);
	g_return_if_fail (dest_address != NULL);
	_tmp0_ = nic_name;
	_tmp1_ = string_to_string (_tmp0_);
	_tmp2_ = g_strconcat ("/etc/netsukuku/tinc stop ", _tmp1_, " none none", NULL);
	_tmp3_ = _tmp2_;
	netsukuku_impl_linux_sequential_command (_tmp3_, &_tmp4_, &_tmp5_, &_tmp6_);
	_g_free0 (cmdout);
	cmdout = _tmp4_;
	_g_free0 (cmderr);
	cmderr = _tmp5_;
	exit_status = _tmp6_;
	_g_free0 (_tmp3_);
	_tmp7_ = exit_status;
	if (_tmp7_ != 0) {
		const gchar* _tmp8_;
		const gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		GError* _tmp12_;
		GError* _tmp13_;
		_tmp8_ = cmderr;
		_tmp9_ = string_to_string (_tmp8_);
		_tmp10_ = g_strconcat ("tincd: ", _tmp9_, NULL);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_error_new_literal (NETSUKUKU_TUNNEL_ERROR, NETSUKUKU_TUNNEL_ERROR_GENERIC, _tmp11_);
		_tmp13_ = _tmp12_;
		_g_free0 (_tmp11_);
		_inner_error_ = _tmp13_;
		if (_inner_error_->domain == NETSUKUKU_TUNNEL_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (cmderr);
			_g_free0 (cmdout);
			return;
		} else {
			_g_free0 (cmderr);
			_g_free0 (cmdout);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp14_ = nic_name;
	_tmp15_ = string_to_string (_tmp14_);
	_tmp16_ = g_strconcat ("/etc/netsukuku/tinc remove ", _tmp15_, " none none", NULL);
	_tmp17_ = _tmp16_;
	netsukuku_impl_linux_sequential_command (_tmp17_, &_tmp18_, &_tmp19_, &_tmp20_);
	_g_free0 (cmdout);
	cmdout = _tmp18_;
	_g_free0 (cmderr);
	cmderr = _tmp19_;
	exit_status = _tmp20_;
	_g_free0 (_tmp17_);
	_tmp21_ = exit_status;
	if (_tmp21_ != 0) {
		const gchar* _tmp22_;
		const gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
		gchar* _tmp25_;
		GError* _tmp26_;
		GError* _tmp27_;
		_tmp22_ = cmderr;
		_tmp23_ = string_to_string (_tmp22_);
		_tmp24_ = g_strconcat ("tincd: ", _tmp23_, NULL);
		_tmp25_ = _tmp24_;
		_tmp26_ = g_error_new_literal (NETSUKUKU_TUNNEL_ERROR, NETSUKUKU_TUNNEL_ERROR_GENERIC, _tmp25_);
		_tmp27_ = _tmp26_;
		_g_free0 (_tmp25_);
		_inner_error_ = _tmp27_;
		if (_inner_error_->domain == NETSUKUKU_TUNNEL_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (cmderr);
			_g_free0 (cmdout);
			return;
		} else {
			_g_free0 (cmderr);
			_g_free0 (cmdout);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp28_ = self->priv->used_ports;
	_tmp29_ = nic_name;
	_tmp30_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp28_, _tmp29_);
	my_port = (gint) ((gintptr) _tmp30_);
	_tmp31_ = self->priv->port_pool;
	_tmp32_ = my_port;
	gee_queue_offer ((GeeQueue*) _tmp31_, (gpointer) ((gintptr) _tmp32_));
	_tmp33_ = self->priv->used_ports;
	_tmp34_ = nic_name;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp33_, _tmp34_, NULL);
	_g_free0 (cmderr);
	_g_free0 (cmdout);
}


static void netsukuku_impl_linux_linux_tunnel_class_init (NetsukukuImplLinuxLinuxTunnelClass * klass) {
	netsukuku_impl_linux_linux_tunnel_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (NetsukukuImplLinuxLinuxTunnelPrivate));
	NETSUKUKU_BASE_TUNNEL_CLASS (klass)->serve = netsukuku_impl_linux_linux_tunnel_real_serve;
	NETSUKUKU_BASE_TUNNEL_CLASS (klass)->request = netsukuku_impl_linux_linux_tunnel_real_request;
	NETSUKUKU_BASE_TUNNEL_CLASS (klass)->close = netsukuku_impl_linux_linux_tunnel_real_close;
	G_OBJECT_CLASS (klass)->finalize = netsukuku_impl_linux_linux_tunnel_finalize;
}


static void netsukuku_impl_linux_linux_tunnel_instance_init (NetsukukuImplLinuxLinuxTunnel * self) {
	self->priv = NETSUKUKU_IMPL_LINUX_LINUX_TUNNEL_GET_PRIVATE (self);
}


static void netsukuku_impl_linux_linux_tunnel_finalize (GObject* obj) {
	NetsukukuImplLinuxLinuxTunnel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_IMPL_LINUX_TYPE_LINUX_TUNNEL, NetsukukuImplLinuxLinuxTunnel);
	_g_object_unref0 (self->priv->port_pool);
	_g_object_unref0 (self->priv->used_ports);
	G_OBJECT_CLASS (netsukuku_impl_linux_linux_tunnel_parent_class)->finalize (obj);
}


/** Managing tunnels via tincd in linux
      */
GType netsukuku_impl_linux_linux_tunnel_get_type (void) {
	static volatile gsize netsukuku_impl_linux_linux_tunnel_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_impl_linux_linux_tunnel_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuImplLinuxLinuxTunnelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_impl_linux_linux_tunnel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuImplLinuxLinuxTunnel), 0, (GInstanceInitFunc) netsukuku_impl_linux_linux_tunnel_instance_init, NULL };
		GType netsukuku_impl_linux_linux_tunnel_type_id;
		netsukuku_impl_linux_linux_tunnel_type_id = g_type_register_static (NETSUKUKU_TYPE_BASE_TUNNEL, "NetsukukuImplLinuxLinuxTunnel", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_impl_linux_linux_tunnel_type_id__volatile, netsukuku_impl_linux_linux_tunnel_type_id);
	}
	return netsukuku_impl_linux_linux_tunnel_type_id__volatile;
}



