/* neighbour.c generated by valac 0.20.1, the Vala compiler
 * generated from neighbour.vala, do not modify */

/*
 *  This file is part of Netsukuku.
 *  (c) Copyright 2011 Luca Dionisi aka lukisi <luca.dionisi@gmail.com>
 *
 *  Netsukuku is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Netsukuku is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Netsukuku.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <netsukuku-rpc.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <zcd.h>
#include <float.h>
#include <math.h>
#include <tasklet.h>


#define NETSUKUKU_TYPE_NEIGHBOUR (netsukuku_neighbour_get_type ())
#define NETSUKUKU_NEIGHBOUR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_NEIGHBOUR, NetsukukuNeighbour))
#define NETSUKUKU_NEIGHBOUR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_NEIGHBOUR, NetsukukuNeighbourClass))
#define NETSUKUKU_IS_NEIGHBOUR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_NEIGHBOUR))
#define NETSUKUKU_IS_NEIGHBOUR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_NEIGHBOUR))
#define NETSUKUKU_NEIGHBOUR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_NEIGHBOUR, NetsukukuNeighbourClass))

typedef struct _NetsukukuNeighbour NetsukukuNeighbour;
typedef struct _NetsukukuNeighbourClass NetsukukuNeighbourClass;
typedef struct _NetsukukuNeighbourPrivate NetsukukuNeighbourPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define NETSUKUKU_TYPE_STRUCT_HELPER_NEIGHBOURMANAGER_SERIALIZED_STORE_XXX_NEIGHBOUR (netsukuku_struct_helper_neighbourmanager_serialized_store_xxx_neighbour_get_type ())

#define NETSUKUKU_TYPE_NEIGHBOUR_MANAGER (netsukuku_neighbour_manager_get_type ())
#define NETSUKUKU_NEIGHBOUR_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_NEIGHBOUR_MANAGER, NetsukukuNeighbourManager))
#define NETSUKUKU_NEIGHBOUR_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_NEIGHBOUR_MANAGER, NetsukukuNeighbourManagerClass))
#define NETSUKUKU_IS_NEIGHBOUR_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_NEIGHBOUR_MANAGER))
#define NETSUKUKU_IS_NEIGHBOUR_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_NEIGHBOUR_MANAGER))
#define NETSUKUKU_NEIGHBOUR_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_NEIGHBOUR_MANAGER, NetsukukuNeighbourManagerClass))

typedef struct _NetsukukuNeighbourManager NetsukukuNeighbourManager;
typedef struct _NetsukukuNeighbourManagerClass NetsukukuNeighbourManagerClass;
typedef struct _Netsukukustruct_helper_NeighbourManager_serialized_store_XXX_neighbour Netsukukustruct_helper_NeighbourManager_serialized_store_XXX_neighbour;

#define NETSUKUKU_TYPE_STRUCT_HELPER_NEIGHBOURMANAGER_STORE (netsukuku_struct_helper_neighbourmanager_store_get_type ())
typedef struct _Netsukukustruct_helper_NeighbourManager_store Netsukukustruct_helper_NeighbourManager_store;
typedef struct _NetsukukuNeighbourManagerPrivate NetsukukuNeighbourManagerPrivate;

#define NETSUKUKU_TYPE_RADAR (netsukuku_radar_get_type ())
#define NETSUKUKU_RADAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_RADAR, NetsukukuRadar))
#define NETSUKUKU_RADAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_RADAR, NetsukukuRadarClass))
#define NETSUKUKU_IS_RADAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_RADAR))
#define NETSUKUKU_IS_RADAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_RADAR))
#define NETSUKUKU_RADAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_RADAR, NetsukukuRadarClass))

typedef struct _NetsukukuRadar NetsukukuRadar;
typedef struct _NetsukukuRadarClass NetsukukuRadarClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

typedef enum  {
	NETSUKUKU_NEIGHBOUR_ERROR_DUPLICATE_INSERT,
	NETSUKUKU_NEIGHBOUR_ERROR_MISSING_REMOVE,
	NETSUKUKU_NEIGHBOUR_ERROR_MAX_EXCEED
} NetsukukuNeighbourError;
#define NETSUKUKU_NEIGHBOUR_ERROR netsukuku_neighbour_error_quark ()
struct _NetsukukuNeighbour {
	GObject parent_instance;
	NetsukukuNeighbourPrivate * priv;
};

struct _NetsukukuNeighbourClass {
	GObjectClass parent_class;
};

struct _NetsukukuNeighbourPrivate {
	NetsukukuNIP* _nip;
	gint _nodeid;
	gint _levels;
	gint _gsize;
	NetsukukuNetworkID* _netid;
	gboolean _is_primary;
	gboolean _is_auxiliary;
	gchar* _dev;
	GeeArrayList* _macs;
	NetsukukuREM* _rem;
	zcdRPCDispatcher* _rpcdispatcher;
};

struct _Netsukukustruct_helper_NeighbourManager_serialized_store_XXX_neighbour {
	NetsukukuNeighbourManager* self;
	gint function_code;
	NetsukukuNeighbour* val;
	gchar* key;
};

struct _Netsukukustruct_helper_NeighbourManager_store {
	NetsukukuNeighbourManager* self;
	gint bouquet_numb;
	GeeHashMap* detected_neighbours;
};

struct _NetsukukuNeighbourManager {
	GObject parent_instance;
	NetsukukuNeighbourManagerPrivate * priv;
};

struct _NetsukukuNeighbourManagerClass {
	GObjectClass parent_class;
	GeeList* (*neighbour_list) (NetsukukuNeighbourManager* self);
	void (*declare_dead) (NetsukukuNeighbourManager* self, NetsukukuNIP* nip, gint nodeid);
};

struct _NetsukukuNeighbourManagerPrivate {
	NetsukukuRadar* _radar;
	gint max_neighbours;
	gdouble rtt_variation_threshold;
	GeeHashMap* tnip_nodeid_table;
	gint number_of_scan_before_deleting;
	GeeHashMap* missing_neighbour_keys;
	GeeArrayList* declared_dead;
};


static gpointer netsukuku_neighbour_parent_class = NULL;
static gpointer netsukuku_neighbour_manager_parent_class = NULL;

GQuark netsukuku_neighbour_error_quark (void);
GType netsukuku_neighbour_get_type (void) G_GNUC_CONST;
#define NETSUKUKU_NEIGHBOUR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), NETSUKUKU_TYPE_NEIGHBOUR, NetsukukuNeighbourPrivate))
enum  {
	NETSUKUKU_NEIGHBOUR_DUMMY_PROPERTY,
	NETSUKUKU_NEIGHBOUR_NIP,
	NETSUKUKU_NEIGHBOUR_NODEID,
	NETSUKUKU_NEIGHBOUR_LEVELS,
	NETSUKUKU_NEIGHBOUR_GSIZE,
	NETSUKUKU_NEIGHBOUR_NETID,
	NETSUKUKU_NEIGHBOUR_IS_PRIMARY,
	NETSUKUKU_NEIGHBOUR_IS_AUXILIARY,
	NETSUKUKU_NEIGHBOUR_DEV,
	NETSUKUKU_NEIGHBOUR_REM,
	NETSUKUKU_NEIGHBOUR_RPCDISPATCHER
};
GeeList* netsukuku_neighbour_get_macs (NetsukukuNeighbour* self);
static NetsukukuNeighbour* netsukuku_neighbour_new_common (gint levels, gint gsize, NetsukukuNIP* nip, gint nodeid, NetsukukuNetworkID* netid, gboolean is_primary, gboolean is_auxiliary);
static NetsukukuNeighbour* netsukuku_neighbour_construct_common (GType object_type, gint levels, gint gsize, NetsukukuNIP* nip, gint nodeid, NetsukukuNetworkID* netid, gboolean is_primary, gboolean is_auxiliary);
static void netsukuku_neighbour_set_levels (NetsukukuNeighbour* self, gint value);
static void netsukuku_neighbour_set_gsize (NetsukukuNeighbour* self, gint value);
static void netsukuku_neighbour_set_nip (NetsukukuNeighbour* self, NetsukukuNIP* value);
static void netsukuku_neighbour_set_nodeid (NetsukukuNeighbour* self, gint value);
void netsukuku_neighbour_set_netid (NetsukukuNeighbour* self, NetsukukuNetworkID* value);
void netsukuku_neighbour_set_is_primary (NetsukukuNeighbour* self, gboolean value);
static void netsukuku_neighbour_set_is_auxiliary (NetsukukuNeighbour* self, gboolean value);
NetsukukuNeighbour* netsukuku_neighbour_new_with_local_dispatcher (gint levels, gint gsize, NetsukukuNIP* nip, gint nodeid, NetsukukuNetworkID* netid, gboolean is_primary, gboolean is_auxiliary, zcdRPCDispatcher* rpcdispatcher);
NetsukukuNeighbour* netsukuku_neighbour_construct_with_local_dispatcher (GType object_type, gint levels, gint gsize, NetsukukuNIP* nip, gint nodeid, NetsukukuNetworkID* netid, gboolean is_primary, gboolean is_auxiliary, zcdRPCDispatcher* rpcdispatcher);
static void netsukuku_neighbour_set_rpcdispatcher (NetsukukuNeighbour* self, zcdRPCDispatcher* value);
void netsukuku_neighbour_set_rem (NetsukukuNeighbour* self, NetsukukuREM* value);
NetsukukuNeighbour* netsukuku_neighbour_new_with_rtt (gint levels, gint gsize, NetsukukuNIP* nip, gint nodeid, NetsukukuNetworkID* netid, gboolean is_primary, gboolean is_auxiliary, const gchar* dev, GeeList* macs, gint avg_rtt);
NetsukukuNeighbour* netsukuku_neighbour_construct_with_rtt (GType object_type, gint levels, gint gsize, NetsukukuNIP* nip, gint nodeid, NetsukukuNetworkID* netid, gboolean is_primary, gboolean is_auxiliary, const gchar* dev, GeeList* macs, gint avg_rtt);
void netsukuku_neighbour_set_dev (NetsukukuNeighbour* self, const gchar* value);
NetsukukuNeighbour* netsukuku_neighbour_new_with_rem (gint levels, gint gsize, NetsukukuNIP* nip, gint nodeid, NetsukukuNetworkID* netid, gboolean is_primary, gboolean is_auxiliary, const gchar* dev, GeeList* macs, NetsukukuREM* rem);
NetsukukuNeighbour* netsukuku_neighbour_construct_with_rem (GType object_type, gint levels, gint gsize, NetsukukuNIP* nip, gint nodeid, NetsukukuNetworkID* netid, gboolean is_primary, gboolean is_auxiliary, const gchar* dev, GeeList* macs, NetsukukuREM* rem);
NetsukukuNeighbour* netsukuku_neighbour_new_with_deadrem (gint levels, gint gsize, NetsukukuNIP* nip, gint nodeid, NetsukukuNetworkID* netid, gboolean is_primary, gboolean is_auxiliary, const gchar* dev, GeeList* macs);
NetsukukuNeighbour* netsukuku_neighbour_construct_with_deadrem (GType object_type, gint levels, gint gsize, NetsukukuNIP* nip, gint nodeid, NetsukukuNetworkID* netid, gboolean is_primary, gboolean is_auxiliary, const gchar* dev, GeeList* macs);
gboolean netsukuku_neighbour_is_local (NetsukukuNeighbour* self);
zcdRPCDispatcher* netsukuku_neighbour_get_rpcdispatcher (NetsukukuNeighbour* self);
gboolean netsukuku_neighbour_equal_func (NetsukukuNeighbour* a, NetsukukuNeighbour* b);
gint netsukuku_neighbour_get_nodeid (NetsukukuNeighbour* self);
NetsukukuNIP* netsukuku_neighbour_get_nip (NetsukukuNeighbour* self);
gchar* netsukuku_neighbour_to_string (NetsukukuNeighbour* self);
gchar* netsukuku_nip_to_str (gint levels, gint gsize, NetsukukuNIP* nip);
gint netsukuku_neighbour_get_levels (NetsukukuNeighbour* self);
gint netsukuku_neighbour_get_gsize (NetsukukuNeighbour* self);
NetsukukuNetworkID* netsukuku_neighbour_get_netid (NetsukukuNeighbour* self);
NetsukukuREM* netsukuku_neighbour_get_rem (NetsukukuNeighbour* self);
const gchar* netsukuku_neighbour_get_dev (NetsukukuNeighbour* self);
NetsukukuNeighbour* netsukuku_neighbour_new (void);
NetsukukuNeighbour* netsukuku_neighbour_construct (GType object_type);
gboolean netsukuku_neighbour_get_is_primary (NetsukukuNeighbour* self);
gboolean netsukuku_neighbour_get_is_auxiliary (NetsukukuNeighbour* self);
static void netsukuku_neighbour_finalize (GObject* obj);
static void _vala_netsukuku_neighbour_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_netsukuku_neighbour_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType netsukuku_struct_helper_neighbourmanager_serialized_store_xxx_neighbour_get_type (void) G_GNUC_CONST;
GType netsukuku_neighbour_manager_get_type (void) G_GNUC_CONST;
Netsukukustruct_helper_NeighbourManager_serialized_store_XXX_neighbour* netsukuku_struct_helper_neighbourmanager_serialized_store_xxx_neighbour_dup (const Netsukukustruct_helper_NeighbourManager_serialized_store_XXX_neighbour* self);
void netsukuku_struct_helper_neighbourmanager_serialized_store_xxx_neighbour_free (Netsukukustruct_helper_NeighbourManager_serialized_store_XXX_neighbour* self);
void netsukuku_struct_helper_neighbourmanager_serialized_store_xxx_neighbour_copy (const Netsukukustruct_helper_NeighbourManager_serialized_store_XXX_neighbour* self, Netsukukustruct_helper_NeighbourManager_serialized_store_XXX_neighbour* dest);
void netsukuku_struct_helper_neighbourmanager_serialized_store_xxx_neighbour_destroy (Netsukukustruct_helper_NeighbourManager_serialized_store_XXX_neighbour* self);
GType netsukuku_struct_helper_neighbourmanager_store_get_type (void) G_GNUC_CONST;
Netsukukustruct_helper_NeighbourManager_store* netsukuku_struct_helper_neighbourmanager_store_dup (const Netsukukustruct_helper_NeighbourManager_store* self);
void netsukuku_struct_helper_neighbourmanager_store_free (Netsukukustruct_helper_NeighbourManager_store* self);
void netsukuku_struct_helper_neighbourmanager_store_copy (const Netsukukustruct_helper_NeighbourManager_store* self, Netsukukustruct_helper_NeighbourManager_store* dest);
void netsukuku_struct_helper_neighbourmanager_store_destroy (Netsukukustruct_helper_NeighbourManager_store* self);
GType netsukuku_radar_get_type (void) G_GNUC_CONST;
#define NETSUKUKU_NEIGHBOUR_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), NETSUKUKU_TYPE_NEIGHBOUR_MANAGER, NetsukukuNeighbourManagerPrivate))
enum  {
	NETSUKUKU_NEIGHBOUR_MANAGER_DUMMY_PROPERTY,
	NETSUKUKU_NEIGHBOUR_MANAGER_RADAR
};
NetsukukuNeighbourManager* netsukuku_neighbour_manager_new_fake (void);
NetsukukuNeighbourManager* netsukuku_neighbour_manager_construct_fake (GType object_type);
NetsukukuNeighbourManager* netsukuku_neighbour_manager_new (NetsukukuRadar* radar, gint max_neighbours);
NetsukukuNeighbourManager* netsukuku_neighbour_manager_construct (GType object_type, NetsukukuRadar* radar, gint max_neighbours);
gint netsukuku_settings_get_MAX_NEIGHBOURS (void);
void netsukuku_neighbour_manager_set_radar (NetsukukuNeighbourManager* self, NetsukukuRadar* value);
NetsukukuRadar* netsukuku_neighbour_manager_get_radar (NetsukukuNeighbourManager* self);
void netsukuku_neighbour_manager_store (NetsukukuNeighbourManager* self, gint bouquet_numb, GeeHashMap* detected_neighbours);
static void _netsukuku_neighbour_manager_store_netsukuku_radar_scan_done (NetsukukuRadar* _sender, gint bouquet_numb, GeeHashMap* detected_neighbours, gpointer self);
void netsukuku_neighbour_manager_empty (NetsukukuNeighbourManager* self);
static void _netsukuku_neighbour_manager_empty_netsukuku_radar_radar_stop (NetsukukuRadar* _sender, gpointer self);
static gchar* netsukuku_neighbour_manager_tnip_nodeid_key (NetsukukuNeighbourManager* self, NetsukukuNIP* key_nip, gint key_nodeid);
static void netsukuku_neighbour_manager_key_tnip_nodeid (NetsukukuNeighbourManager* self, const gchar* key, NetsukukuNIP** key_nip, gint* key_nodeid);
GeeList* netsukuku_neighbour_manager_neighbour_list (NetsukukuNeighbourManager* self);
static GeeList* netsukuku_neighbour_manager_real_neighbour_list (NetsukukuNeighbourManager* self);
static gboolean _netsukuku_neighbour_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self);
static void netsukuku_neighbour_manager_memorize (NetsukukuNeighbourManager* self, NetsukukuNeighbour* val, GError** error);
static void netsukuku_neighbour_manager_unmemorize (NetsukukuNeighbourManager* self, const gchar* skey, GError** error);
NetsukukuNeighbour* netsukuku_neighbour_manager_key_to_neighbour (NetsukukuNeighbourManager* self, NetsukukuNIP* nip, gint nodeid);
static gint netsukuku_neighbour_manager_table_compare_func (GeeMapEntry* a, GeeMapEntry* b);
static gboolean netsukuku_neighbour_manager_not_impl_equal_func (GObject* a, GObject* b);
GeeHashMap* _netsukuku_neighbour_manager_truncate (NetsukukuNeighbourManager* self, GeeHashMap* old_tnip_nodeid_table);
static gboolean _netsukuku_neighbour_manager_not_impl_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self);
static gint _netsukuku_neighbour_manager_table_compare_func_gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self);
static void netsukuku_neighbour_manager_serialized_store_add_neighbour (NetsukukuNeighbourManager* self, const gchar* key, NetsukukuNeighbour* val, GError** error);
void netsukuku_neighbour_manager_going_add (NetsukukuNeighbourManager* self, NetsukukuNeighbour* neighbour);
void netsukuku_neighbour_manager_add_neighbour (NetsukukuNeighbourManager* self, const gchar* key);
static void netsukuku_neighbour_manager_serialized_store_delete_neighbour (NetsukukuNeighbourManager* self, const gchar* key, GError** error);
void netsukuku_neighbour_manager_going_delete (NetsukukuNeighbourManager* self, NetsukukuNeighbour* neighbour);
void netsukuku_neighbour_manager_delete_neighbour (NetsukukuNeighbourManager* self, const gchar* key, NetsukukuNeighbour* old_val);
static void netsukuku_neighbour_manager_serialized_store_changed_rem_neighbour (NetsukukuNeighbourManager* self, const gchar* key, NetsukukuNeighbour* val, GError** error);
void netsukuku_neighbour_manager_going_rem_change (NetsukukuNeighbourManager* self, NetsukukuNeighbour* neighbour);
void netsukuku_neighbour_manager_rem_change_neighbour (NetsukukuNeighbourManager* self, const gchar* key, NetsukukuREM* old_rem);
static void netsukuku_neighbour_manager_serialized_store_changed_attrib_neighbour (NetsukukuNeighbourManager* self, const gchar* key, NetsukukuNeighbour* val, GError** error);
static void* netsukuku_neighbour_manager_helper_serialized_store_XXX_neighbour (void* v, GError** error);
void netsukuku_log_warn (const gchar* msg);
static void netsukuku_neighbour_manager_store_add_neighbour (NetsukukuNeighbourManager* self, const gchar* key, NetsukukuNeighbour* val);
static void netsukuku_neighbour_manager_store_delete_neighbour (NetsukukuNeighbourManager* self, const gchar* key);
static void netsukuku_neighbour_manager_store_changed_rem_neighbour (NetsukukuNeighbourManager* self, const gchar* key, NetsukukuNeighbour* val);
static void netsukuku_neighbour_manager_store_changed_attrib_neighbour (NetsukukuNeighbourManager* self, const gchar* key, NetsukukuNeighbour* val);
void netsukuku_neighbour_manager_declare_dead (NetsukukuNeighbourManager* self, NetsukukuNIP* nip, gint nodeid);
static void netsukuku_neighbour_manager_real_declare_dead (NetsukukuNeighbourManager* self, NetsukukuNIP* nip, gint nodeid);
static void netsukuku_neighbour_manager_impl_store (NetsukukuNeighbourManager* self, gint bouquet_numb, GeeHashMap* detected_neighbours, GError** error);
static void* netsukuku_neighbour_manager_helper_store (void* v, GError** error);
void netsukuku_log_debug (const gchar* msg);
void netsukuku_log_verbose (const gchar* msg);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void netsukuku_neighbour_manager_finalize (GObject* obj);
static void _vala_netsukuku_neighbour_manager_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_netsukuku_neighbour_manager_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GQuark netsukuku_neighbour_error_quark (void) {
	return g_quark_from_static_string ("netsukuku_neighbour_error-quark");
}


GeeList* netsukuku_neighbour_get_macs (NetsukukuNeighbour* self) {
	GeeList* result = NULL;
	GeeArrayList* _tmp0_;
	GeeBidirList* _tmp1_;
	GeeBidirList* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_macs;
	_tmp1_ = gee_abstract_bidir_list_get_read_only_view ((GeeAbstractBidirList*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = (GeeList*) _tmp2_;
	return result;
}


static NetsukukuNeighbour* netsukuku_neighbour_construct_common (GType object_type, gint levels, gint gsize, NetsukukuNIP* nip, gint nodeid, NetsukukuNetworkID* netid, gboolean is_primary, gboolean is_auxiliary) {
	NetsukukuNeighbour * self = NULL;
	gint _tmp0_;
	gint _tmp1_;
	NetsukukuNIP* _tmp2_;
	gint _tmp3_;
	NetsukukuNetworkID* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	g_return_val_if_fail (nip != NULL, NULL);
	g_return_val_if_fail (netid != NULL, NULL);
	self = (NetsukukuNeighbour*) g_object_new (object_type, NULL);
	_tmp0_ = levels;
	netsukuku_neighbour_set_levels (self, _tmp0_);
	_tmp1_ = gsize;
	netsukuku_neighbour_set_gsize (self, _tmp1_);
	_tmp2_ = nip;
	netsukuku_neighbour_set_nip (self, _tmp2_);
	_tmp3_ = nodeid;
	netsukuku_neighbour_set_nodeid (self, _tmp3_);
	_tmp4_ = netid;
	netsukuku_neighbour_set_netid (self, _tmp4_);
	_tmp5_ = is_primary;
	netsukuku_neighbour_set_is_primary (self, _tmp5_);
	_tmp6_ = is_auxiliary;
	netsukuku_neighbour_set_is_auxiliary (self, _tmp6_);
	return self;
}


static NetsukukuNeighbour* netsukuku_neighbour_new_common (gint levels, gint gsize, NetsukukuNIP* nip, gint nodeid, NetsukukuNetworkID* netid, gboolean is_primary, gboolean is_auxiliary) {
	return netsukuku_neighbour_construct_common (NETSUKUKU_TYPE_NEIGHBOUR, levels, gsize, nip, nodeid, netid, is_primary, is_auxiliary);
}


NetsukukuNeighbour* netsukuku_neighbour_construct_with_local_dispatcher (GType object_type, gint levels, gint gsize, NetsukukuNIP* nip, gint nodeid, NetsukukuNetworkID* netid, gboolean is_primary, gboolean is_auxiliary, zcdRPCDispatcher* rpcdispatcher) {
	NetsukukuNeighbour * self = NULL;
	gint _tmp0_;
	gint _tmp1_;
	NetsukukuNIP* _tmp2_;
	gint _tmp3_;
	NetsukukuNetworkID* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	zcdRPCDispatcher* _tmp7_;
	NetsukukuNullREM* _tmp8_;
	NetsukukuNullREM* _tmp9_;
	g_return_val_if_fail (nip != NULL, NULL);
	g_return_val_if_fail (netid != NULL, NULL);
	g_return_val_if_fail (rpcdispatcher != NULL, NULL);
	_tmp0_ = levels;
	_tmp1_ = gsize;
	_tmp2_ = nip;
	_tmp3_ = nodeid;
	_tmp4_ = netid;
	_tmp5_ = is_primary;
	_tmp6_ = is_auxiliary;
	self = (NetsukukuNeighbour*) netsukuku_neighbour_construct_common (object_type, _tmp0_, _tmp1_, _tmp2_, _tmp3_, _tmp4_, _tmp5_, _tmp6_);
	_tmp7_ = rpcdispatcher;
	netsukuku_neighbour_set_rpcdispatcher (self, _tmp7_);
	_tmp8_ = netsukuku_null_rem_new ();
	_tmp9_ = _tmp8_;
	netsukuku_neighbour_set_rem (self, (NetsukukuREM*) _tmp9_);
	_g_object_unref0 (_tmp9_);
	return self;
}


NetsukukuNeighbour* netsukuku_neighbour_new_with_local_dispatcher (gint levels, gint gsize, NetsukukuNIP* nip, gint nodeid, NetsukukuNetworkID* netid, gboolean is_primary, gboolean is_auxiliary, zcdRPCDispatcher* rpcdispatcher) {
	return netsukuku_neighbour_construct_with_local_dispatcher (NETSUKUKU_TYPE_NEIGHBOUR, levels, gsize, nip, nodeid, netid, is_primary, is_auxiliary, rpcdispatcher);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


NetsukukuNeighbour* netsukuku_neighbour_construct_with_rtt (GType object_type, gint levels, gint gsize, NetsukukuNIP* nip, gint nodeid, NetsukukuNetworkID* netid, gboolean is_primary, gboolean is_auxiliary, const gchar* dev, GeeList* macs, gint avg_rtt) {
	NetsukukuNeighbour * self = NULL;
	gint _tmp0_;
	gint _tmp1_;
	NetsukukuNIP* _tmp2_;
	gint _tmp3_;
	NetsukukuNetworkID* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	const gchar* _tmp7_;
	GeeArrayList* _tmp8_;
	gint _tmp22_;
	NetsukukuRTT* _tmp23_;
	NetsukukuRTT* _tmp24_;
	g_return_val_if_fail (nip != NULL, NULL);
	g_return_val_if_fail (netid != NULL, NULL);
	g_return_val_if_fail (dev != NULL, NULL);
	g_return_val_if_fail (macs != NULL, NULL);
	_tmp0_ = levels;
	_tmp1_ = gsize;
	_tmp2_ = nip;
	_tmp3_ = nodeid;
	_tmp4_ = netid;
	_tmp5_ = is_primary;
	_tmp6_ = is_auxiliary;
	self = (NetsukukuNeighbour*) netsukuku_neighbour_construct_common (object_type, _tmp0_, _tmp1_, _tmp2_, _tmp3_, _tmp4_, _tmp5_, _tmp6_);
	_tmp7_ = dev;
	netsukuku_neighbour_set_dev (self, _tmp7_);
	_tmp8_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_macs);
	self->priv->_macs = _tmp8_;
	{
		GeeList* _tmp9_;
		GeeList* _tmp10_;
		GeeList* _s_list;
		GeeList* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		gint _s_size;
		gint _s_index;
		_tmp9_ = macs;
		_tmp10_ = _g_object_ref0 (_tmp9_);
		_s_list = _tmp10_;
		_tmp11_ = _s_list;
		_tmp12_ = gee_collection_get_size ((GeeCollection*) _tmp11_);
		_tmp13_ = _tmp12_;
		_s_size = _tmp13_;
		_s_index = -1;
		while (TRUE) {
			gint _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
			GeeList* _tmp17_;
			gint _tmp18_;
			gpointer _tmp19_ = NULL;
			gchar* s;
			GeeArrayList* _tmp20_;
			const gchar* _tmp21_;
			_tmp14_ = _s_index;
			_s_index = _tmp14_ + 1;
			_tmp15_ = _s_index;
			_tmp16_ = _s_size;
			if (!(_tmp15_ < _tmp16_)) {
				break;
			}
			_tmp17_ = _s_list;
			_tmp18_ = _s_index;
			_tmp19_ = gee_list_get (_tmp17_, _tmp18_);
			s = (gchar*) _tmp19_;
			_tmp20_ = self->priv->_macs;
			_tmp21_ = s;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp20_, _tmp21_);
			_g_free0 (s);
		}
		_g_object_unref0 (_s_list);
	}
	_tmp22_ = avg_rtt;
	_tmp23_ = netsukuku_rtt_new (_tmp22_);
	_tmp24_ = _tmp23_;
	netsukuku_neighbour_set_rem (self, (NetsukukuREM*) _tmp24_);
	_g_object_unref0 (_tmp24_);
	return self;
}


NetsukukuNeighbour* netsukuku_neighbour_new_with_rtt (gint levels, gint gsize, NetsukukuNIP* nip, gint nodeid, NetsukukuNetworkID* netid, gboolean is_primary, gboolean is_auxiliary, const gchar* dev, GeeList* macs, gint avg_rtt) {
	return netsukuku_neighbour_construct_with_rtt (NETSUKUKU_TYPE_NEIGHBOUR, levels, gsize, nip, nodeid, netid, is_primary, is_auxiliary, dev, macs, avg_rtt);
}


NetsukukuNeighbour* netsukuku_neighbour_construct_with_rem (GType object_type, gint levels, gint gsize, NetsukukuNIP* nip, gint nodeid, NetsukukuNetworkID* netid, gboolean is_primary, gboolean is_auxiliary, const gchar* dev, GeeList* macs, NetsukukuREM* rem) {
	NetsukukuNeighbour * self = NULL;
	gint _tmp0_;
	gint _tmp1_;
	NetsukukuNIP* _tmp2_;
	gint _tmp3_;
	NetsukukuNetworkID* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	const gchar* _tmp7_;
	GeeArrayList* _tmp8_;
	NetsukukuREM* _tmp22_;
	g_return_val_if_fail (nip != NULL, NULL);
	g_return_val_if_fail (netid != NULL, NULL);
	g_return_val_if_fail (dev != NULL, NULL);
	g_return_val_if_fail (macs != NULL, NULL);
	g_return_val_if_fail (rem != NULL, NULL);
	_tmp0_ = levels;
	_tmp1_ = gsize;
	_tmp2_ = nip;
	_tmp3_ = nodeid;
	_tmp4_ = netid;
	_tmp5_ = is_primary;
	_tmp6_ = is_auxiliary;
	self = (NetsukukuNeighbour*) netsukuku_neighbour_construct_common (object_type, _tmp0_, _tmp1_, _tmp2_, _tmp3_, _tmp4_, _tmp5_, _tmp6_);
	_tmp7_ = dev;
	netsukuku_neighbour_set_dev (self, _tmp7_);
	_tmp8_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_macs);
	self->priv->_macs = _tmp8_;
	{
		GeeList* _tmp9_;
		GeeList* _tmp10_;
		GeeList* _s_list;
		GeeList* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		gint _s_size;
		gint _s_index;
		_tmp9_ = macs;
		_tmp10_ = _g_object_ref0 (_tmp9_);
		_s_list = _tmp10_;
		_tmp11_ = _s_list;
		_tmp12_ = gee_collection_get_size ((GeeCollection*) _tmp11_);
		_tmp13_ = _tmp12_;
		_s_size = _tmp13_;
		_s_index = -1;
		while (TRUE) {
			gint _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
			GeeList* _tmp17_;
			gint _tmp18_;
			gpointer _tmp19_ = NULL;
			gchar* s;
			GeeArrayList* _tmp20_;
			const gchar* _tmp21_;
			_tmp14_ = _s_index;
			_s_index = _tmp14_ + 1;
			_tmp15_ = _s_index;
			_tmp16_ = _s_size;
			if (!(_tmp15_ < _tmp16_)) {
				break;
			}
			_tmp17_ = _s_list;
			_tmp18_ = _s_index;
			_tmp19_ = gee_list_get (_tmp17_, _tmp18_);
			s = (gchar*) _tmp19_;
			_tmp20_ = self->priv->_macs;
			_tmp21_ = s;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp20_, _tmp21_);
			_g_free0 (s);
		}
		_g_object_unref0 (_s_list);
	}
	_tmp22_ = rem;
	netsukuku_neighbour_set_rem (self, _tmp22_);
	return self;
}


NetsukukuNeighbour* netsukuku_neighbour_new_with_rem (gint levels, gint gsize, NetsukukuNIP* nip, gint nodeid, NetsukukuNetworkID* netid, gboolean is_primary, gboolean is_auxiliary, const gchar* dev, GeeList* macs, NetsukukuREM* rem) {
	return netsukuku_neighbour_construct_with_rem (NETSUKUKU_TYPE_NEIGHBOUR, levels, gsize, nip, nodeid, netid, is_primary, is_auxiliary, dev, macs, rem);
}


NetsukukuNeighbour* netsukuku_neighbour_construct_with_deadrem (GType object_type, gint levels, gint gsize, NetsukukuNIP* nip, gint nodeid, NetsukukuNetworkID* netid, gboolean is_primary, gboolean is_auxiliary, const gchar* dev, GeeList* macs) {
	NetsukukuNeighbour * self = NULL;
	gint _tmp0_;
	gint _tmp1_;
	NetsukukuNIP* _tmp2_;
	gint _tmp3_;
	NetsukukuNetworkID* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	const gchar* _tmp7_;
	GeeArrayList* _tmp8_;
	NetsukukuDeadREM* _tmp22_;
	NetsukukuDeadREM* _tmp23_;
	g_return_val_if_fail (nip != NULL, NULL);
	g_return_val_if_fail (netid != NULL, NULL);
	g_return_val_if_fail (dev != NULL, NULL);
	g_return_val_if_fail (macs != NULL, NULL);
	_tmp0_ = levels;
	_tmp1_ = gsize;
	_tmp2_ = nip;
	_tmp3_ = nodeid;
	_tmp4_ = netid;
	_tmp5_ = is_primary;
	_tmp6_ = is_auxiliary;
	self = (NetsukukuNeighbour*) netsukuku_neighbour_construct_common (object_type, _tmp0_, _tmp1_, _tmp2_, _tmp3_, _tmp4_, _tmp5_, _tmp6_);
	_tmp7_ = dev;
	netsukuku_neighbour_set_dev (self, _tmp7_);
	_tmp8_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_macs);
	self->priv->_macs = _tmp8_;
	{
		GeeList* _tmp9_;
		GeeList* _tmp10_;
		GeeList* _s_list;
		GeeList* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		gint _s_size;
		gint _s_index;
		_tmp9_ = macs;
		_tmp10_ = _g_object_ref0 (_tmp9_);
		_s_list = _tmp10_;
		_tmp11_ = _s_list;
		_tmp12_ = gee_collection_get_size ((GeeCollection*) _tmp11_);
		_tmp13_ = _tmp12_;
		_s_size = _tmp13_;
		_s_index = -1;
		while (TRUE) {
			gint _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
			GeeList* _tmp17_;
			gint _tmp18_;
			gpointer _tmp19_ = NULL;
			gchar* s;
			GeeArrayList* _tmp20_;
			const gchar* _tmp21_;
			_tmp14_ = _s_index;
			_s_index = _tmp14_ + 1;
			_tmp15_ = _s_index;
			_tmp16_ = _s_size;
			if (!(_tmp15_ < _tmp16_)) {
				break;
			}
			_tmp17_ = _s_list;
			_tmp18_ = _s_index;
			_tmp19_ = gee_list_get (_tmp17_, _tmp18_);
			s = (gchar*) _tmp19_;
			_tmp20_ = self->priv->_macs;
			_tmp21_ = s;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp20_, _tmp21_);
			_g_free0 (s);
		}
		_g_object_unref0 (_s_list);
	}
	_tmp22_ = netsukuku_dead_rem_new ();
	_tmp23_ = _tmp22_;
	netsukuku_neighbour_set_rem (self, (NetsukukuREM*) _tmp23_);
	_g_object_unref0 (_tmp23_);
	return self;
}


NetsukukuNeighbour* netsukuku_neighbour_new_with_deadrem (gint levels, gint gsize, NetsukukuNIP* nip, gint nodeid, NetsukukuNetworkID* netid, gboolean is_primary, gboolean is_auxiliary, const gchar* dev, GeeList* macs) {
	return netsukuku_neighbour_construct_with_deadrem (NETSUKUKU_TYPE_NEIGHBOUR, levels, gsize, nip, nodeid, netid, is_primary, is_auxiliary, dev, macs);
}


gboolean netsukuku_neighbour_is_local (NetsukukuNeighbour* self) {
	gboolean result = FALSE;
	zcdRPCDispatcher* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_rpcdispatcher;
	result = _tmp0_ != NULL;
	return result;
}


gboolean netsukuku_neighbour_equal_func (NetsukukuNeighbour* a, NetsukukuNeighbour* b) {
	gboolean result = FALSE;
	NetsukukuNeighbour* _tmp0_;
	NetsukukuNeighbour* _tmp1_;
	gboolean _tmp2_ = FALSE;
	NetsukukuNeighbour* _tmp3_;
	gboolean _tmp5_;
	NetsukukuNeighbour* _tmp6_;
	gint _tmp7_;
	NetsukukuNeighbour* _tmp8_;
	gint _tmp9_;
	NetsukukuNeighbour* _tmp10_;
	NetsukukuNIP* _tmp11_;
	NetsukukuNeighbour* _tmp12_;
	NetsukukuNIP* _tmp13_;
	gboolean _tmp14_ = FALSE;
	_tmp0_ = a;
	_tmp1_ = b;
	if (_tmp0_ == _tmp1_) {
		result = TRUE;
		return result;
	}
	_tmp3_ = a;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		NetsukukuNeighbour* _tmp4_;
		_tmp4_ = b;
		_tmp2_ = _tmp4_ == NULL;
	}
	_tmp5_ = _tmp2_;
	if (_tmp5_) {
		result = FALSE;
		return result;
	}
	_tmp6_ = a;
	_tmp7_ = _tmp6_->priv->_nodeid;
	_tmp8_ = b;
	_tmp9_ = _tmp8_->priv->_nodeid;
	if (_tmp7_ != _tmp9_) {
		result = FALSE;
		return result;
	}
	_tmp10_ = a;
	_tmp11_ = _tmp10_->priv->_nip;
	_tmp12_ = b;
	_tmp13_ = _tmp12_->priv->_nip;
	_tmp14_ = netsukuku_partial_nip_equal_func ((NetsukukuPartialNIP*) _tmp11_, (NetsukukuPartialNIP*) _tmp13_);
	if (!_tmp14_) {
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


gchar* netsukuku_neighbour_to_string (NetsukukuNeighbour* self) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	NetsukukuNIP* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* ipstr;
	const gchar* _tmp4_;
	const gchar* _tmp5_ = NULL;
	gint _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	NetsukukuNetworkID* _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_;
	gchar* ret;
	gboolean _tmp14_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_levels;
	_tmp1_ = self->priv->_gsize;
	_tmp2_ = self->priv->_nip;
	_tmp3_ = netsukuku_nip_to_str (_tmp0_, _tmp1_, _tmp2_);
	ipstr = _tmp3_;
	_tmp4_ = ipstr;
	_tmp5_ = string_to_string (_tmp4_);
	_tmp6_ = self->priv->_nodeid;
	_tmp7_ = g_strdup_printf ("%i", _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = self->priv->_netid;
	_tmp10_ = netsukuku_network_id_to_string (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strconcat ("<Neighbour(", _tmp5_, ", id ", _tmp8_, " in ", _tmp11_, "): ", NULL);
	_tmp13_ = _tmp12_;
	_g_free0 (_tmp11_);
	_g_free0 (_tmp8_);
	ret = _tmp13_;
	_tmp14_ = netsukuku_neighbour_is_local (self);
	if (_tmp14_) {
		const gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp15_ = ret;
		_tmp16_ = g_strconcat (_tmp15_, "local>", NULL);
		_g_free0 (ret);
		ret = _tmp16_;
	} else {
		const gchar* _tmp17_;
		NetsukukuREM* _tmp18_;
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_;
		const gchar* _tmp21_;
		const gchar* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_;
		gchar* _tmp25_;
		_tmp17_ = ret;
		_tmp18_ = self->priv->_rem;
		_tmp19_ = netsukuku_rem_to_string (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = self->priv->_dev;
		_tmp22_ = string_to_string (_tmp21_);
		_tmp23_ = g_strconcat (_tmp20_, " through ", _tmp22_, ">", NULL);
		_tmp24_ = _tmp23_;
		_tmp25_ = g_strconcat (_tmp17_, _tmp24_, NULL);
		_g_free0 (ret);
		ret = _tmp25_;
		_g_free0 (_tmp24_);
		_g_free0 (_tmp20_);
	}
	result = ret;
	_g_free0 (ipstr);
	return result;
}


NetsukukuNeighbour* netsukuku_neighbour_construct (GType object_type) {
	NetsukukuNeighbour * self = NULL;
	self = (NetsukukuNeighbour*) g_object_new (object_type, NULL);
	return self;
}


NetsukukuNeighbour* netsukuku_neighbour_new (void) {
	return netsukuku_neighbour_construct (NETSUKUKU_TYPE_NEIGHBOUR);
}


NetsukukuNIP* netsukuku_neighbour_get_nip (NetsukukuNeighbour* self) {
	NetsukukuNIP* result;
	NetsukukuNIP* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_nip;
	result = _tmp0_;
	return result;
}


static void netsukuku_neighbour_set_nip (NetsukukuNeighbour* self, NetsukukuNIP* value) {
	NetsukukuNIP* _tmp0_;
	NetsukukuNIP* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_nip);
	self->priv->_nip = _tmp1_;
	g_object_notify ((GObject *) self, "nip");
}


gint netsukuku_neighbour_get_nodeid (NetsukukuNeighbour* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_nodeid;
	result = _tmp0_;
	return result;
}


static void netsukuku_neighbour_set_nodeid (NetsukukuNeighbour* self, gint value) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_nodeid = _tmp0_;
	g_object_notify ((GObject *) self, "nodeid");
}


gint netsukuku_neighbour_get_levels (NetsukukuNeighbour* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_levels;
	result = _tmp0_;
	return result;
}


static void netsukuku_neighbour_set_levels (NetsukukuNeighbour* self, gint value) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_levels = _tmp0_;
	g_object_notify ((GObject *) self, "levels");
}


gint netsukuku_neighbour_get_gsize (NetsukukuNeighbour* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_gsize;
	result = _tmp0_;
	return result;
}


static void netsukuku_neighbour_set_gsize (NetsukukuNeighbour* self, gint value) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_gsize = _tmp0_;
	g_object_notify ((GObject *) self, "gsize");
}


NetsukukuNetworkID* netsukuku_neighbour_get_netid (NetsukukuNeighbour* self) {
	NetsukukuNetworkID* result;
	NetsukukuNetworkID* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_netid;
	result = _tmp0_;
	return result;
}


void netsukuku_neighbour_set_netid (NetsukukuNeighbour* self, NetsukukuNetworkID* value) {
	NetsukukuNetworkID* _tmp0_;
	NetsukukuNetworkID* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_netid);
	self->priv->_netid = _tmp1_;
	g_object_notify ((GObject *) self, "netid");
}


gboolean netsukuku_neighbour_get_is_primary (NetsukukuNeighbour* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_primary;
	result = _tmp0_;
	return result;
}


void netsukuku_neighbour_set_is_primary (NetsukukuNeighbour* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_is_primary = _tmp0_;
	g_object_notify ((GObject *) self, "is-primary");
}


gboolean netsukuku_neighbour_get_is_auxiliary (NetsukukuNeighbour* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_auxiliary;
	result = _tmp0_;
	return result;
}


static void netsukuku_neighbour_set_is_auxiliary (NetsukukuNeighbour* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_is_auxiliary = _tmp0_;
	g_object_notify ((GObject *) self, "is-auxiliary");
}


const gchar* netsukuku_neighbour_get_dev (NetsukukuNeighbour* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_dev;
	result = _tmp0_;
	return result;
}


void netsukuku_neighbour_set_dev (NetsukukuNeighbour* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_dev);
	self->priv->_dev = _tmp1_;
	g_object_notify ((GObject *) self, "dev");
}


NetsukukuREM* netsukuku_neighbour_get_rem (NetsukukuNeighbour* self) {
	NetsukukuREM* result;
	NetsukukuREM* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_rem;
	result = _tmp0_;
	return result;
}


void netsukuku_neighbour_set_rem (NetsukukuNeighbour* self, NetsukukuREM* value) {
	NetsukukuREM* _tmp0_;
	NetsukukuREM* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_rem);
	self->priv->_rem = _tmp1_;
	g_object_notify ((GObject *) self, "rem");
}


zcdRPCDispatcher* netsukuku_neighbour_get_rpcdispatcher (NetsukukuNeighbour* self) {
	zcdRPCDispatcher* result;
	zcdRPCDispatcher* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_rpcdispatcher;
	result = _tmp0_;
	return result;
}


static void netsukuku_neighbour_set_rpcdispatcher (NetsukukuNeighbour* self, zcdRPCDispatcher* value) {
	zcdRPCDispatcher* _tmp0_;
	zcdRPCDispatcher* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_rpcdispatcher);
	self->priv->_rpcdispatcher = _tmp1_;
	g_object_notify ((GObject *) self, "rpcdispatcher");
}


static void netsukuku_neighbour_class_init (NetsukukuNeighbourClass * klass) {
	netsukuku_neighbour_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (NetsukukuNeighbourPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_netsukuku_neighbour_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_netsukuku_neighbour_set_property;
	G_OBJECT_CLASS (klass)->finalize = netsukuku_neighbour_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETSUKUKU_NEIGHBOUR_NIP, g_param_spec_object ("nip", "nip", "nip", NETSUKUKU_TYPE_NIP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETSUKUKU_NEIGHBOUR_NODEID, g_param_spec_int ("nodeid", "nodeid", "nodeid", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETSUKUKU_NEIGHBOUR_LEVELS, g_param_spec_int ("levels", "levels", "levels", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETSUKUKU_NEIGHBOUR_GSIZE, g_param_spec_int ("gsize", "gsize", "gsize", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETSUKUKU_NEIGHBOUR_NETID, g_param_spec_object ("netid", "netid", "netid", NETSUKUKU_TYPE_NETWORK_ID, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETSUKUKU_NEIGHBOUR_IS_PRIMARY, g_param_spec_boolean ("is-primary", "is-primary", "is-primary", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETSUKUKU_NEIGHBOUR_IS_AUXILIARY, g_param_spec_boolean ("is-auxiliary", "is-auxiliary", "is-auxiliary", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETSUKUKU_NEIGHBOUR_DEV, g_param_spec_string ("dev", "dev", "dev", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETSUKUKU_NEIGHBOUR_REM, g_param_spec_object ("rem", "rem", "rem", NETSUKUKU_TYPE_REM, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETSUKUKU_NEIGHBOUR_RPCDISPATCHER, g_param_spec_object ("rpcdispatcher", "rpcdispatcher", "rpcdispatcher", ZCD_TYPE_RPC_DISPATCHER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void netsukuku_neighbour_instance_init (NetsukukuNeighbour * self) {
	self->priv = NETSUKUKU_NEIGHBOUR_GET_PRIVATE (self);
	self->priv->_rpcdispatcher = NULL;
}


static void netsukuku_neighbour_finalize (GObject* obj) {
	NetsukukuNeighbour * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_NEIGHBOUR, NetsukukuNeighbour);
	_g_object_unref0 (self->priv->_nip);
	_g_object_unref0 (self->priv->_netid);
	_g_free0 (self->priv->_dev);
	_g_object_unref0 (self->priv->_macs);
	_g_object_unref0 (self->priv->_rem);
	_g_object_unref0 (self->priv->_rpcdispatcher);
	G_OBJECT_CLASS (netsukuku_neighbour_parent_class)->finalize (obj);
}


/** Each instance of this class represents a neighbour as seen by a particular nic of this node.
      */
GType netsukuku_neighbour_get_type (void) {
	static volatile gsize netsukuku_neighbour_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_neighbour_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuNeighbourClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_neighbour_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuNeighbour), 0, (GInstanceInitFunc) netsukuku_neighbour_instance_init, NULL };
		GType netsukuku_neighbour_type_id;
		netsukuku_neighbour_type_id = g_type_register_static (G_TYPE_OBJECT, "NetsukukuNeighbour", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_neighbour_type_id__volatile, netsukuku_neighbour_type_id);
	}
	return netsukuku_neighbour_type_id__volatile;
}


static void _vala_netsukuku_neighbour_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	NetsukukuNeighbour * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETSUKUKU_TYPE_NEIGHBOUR, NetsukukuNeighbour);
	switch (property_id) {
		case NETSUKUKU_NEIGHBOUR_NIP:
		g_value_set_object (value, netsukuku_neighbour_get_nip (self));
		break;
		case NETSUKUKU_NEIGHBOUR_NODEID:
		g_value_set_int (value, netsukuku_neighbour_get_nodeid (self));
		break;
		case NETSUKUKU_NEIGHBOUR_LEVELS:
		g_value_set_int (value, netsukuku_neighbour_get_levels (self));
		break;
		case NETSUKUKU_NEIGHBOUR_GSIZE:
		g_value_set_int (value, netsukuku_neighbour_get_gsize (self));
		break;
		case NETSUKUKU_NEIGHBOUR_NETID:
		g_value_set_object (value, netsukuku_neighbour_get_netid (self));
		break;
		case NETSUKUKU_NEIGHBOUR_IS_PRIMARY:
		g_value_set_boolean (value, netsukuku_neighbour_get_is_primary (self));
		break;
		case NETSUKUKU_NEIGHBOUR_IS_AUXILIARY:
		g_value_set_boolean (value, netsukuku_neighbour_get_is_auxiliary (self));
		break;
		case NETSUKUKU_NEIGHBOUR_DEV:
		g_value_set_string (value, netsukuku_neighbour_get_dev (self));
		break;
		case NETSUKUKU_NEIGHBOUR_REM:
		g_value_set_object (value, netsukuku_neighbour_get_rem (self));
		break;
		case NETSUKUKU_NEIGHBOUR_RPCDISPATCHER:
		g_value_set_object (value, netsukuku_neighbour_get_rpcdispatcher (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_netsukuku_neighbour_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	NetsukukuNeighbour * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETSUKUKU_TYPE_NEIGHBOUR, NetsukukuNeighbour);
	switch (property_id) {
		case NETSUKUKU_NEIGHBOUR_NIP:
		netsukuku_neighbour_set_nip (self, g_value_get_object (value));
		break;
		case NETSUKUKU_NEIGHBOUR_NODEID:
		netsukuku_neighbour_set_nodeid (self, g_value_get_int (value));
		break;
		case NETSUKUKU_NEIGHBOUR_LEVELS:
		netsukuku_neighbour_set_levels (self, g_value_get_int (value));
		break;
		case NETSUKUKU_NEIGHBOUR_GSIZE:
		netsukuku_neighbour_set_gsize (self, g_value_get_int (value));
		break;
		case NETSUKUKU_NEIGHBOUR_NETID:
		netsukuku_neighbour_set_netid (self, g_value_get_object (value));
		break;
		case NETSUKUKU_NEIGHBOUR_IS_PRIMARY:
		netsukuku_neighbour_set_is_primary (self, g_value_get_boolean (value));
		break;
		case NETSUKUKU_NEIGHBOUR_IS_AUXILIARY:
		netsukuku_neighbour_set_is_auxiliary (self, g_value_get_boolean (value));
		break;
		case NETSUKUKU_NEIGHBOUR_DEV:
		netsukuku_neighbour_set_dev (self, g_value_get_string (value));
		break;
		case NETSUKUKU_NEIGHBOUR_REM:
		netsukuku_neighbour_set_rem (self, g_value_get_object (value));
		break;
		case NETSUKUKU_NEIGHBOUR_RPCDISPATCHER:
		netsukuku_neighbour_set_rpcdispatcher (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


void netsukuku_struct_helper_neighbourmanager_serialized_store_xxx_neighbour_copy (const Netsukukustruct_helper_NeighbourManager_serialized_store_XXX_neighbour* self, Netsukukustruct_helper_NeighbourManager_serialized_store_XXX_neighbour* dest) {
	NetsukukuNeighbourManager* _tmp0_;
	NetsukukuNeighbourManager* _tmp1_;
	gint _tmp2_;
	NetsukukuNeighbour* _tmp3_;
	NetsukukuNeighbour* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	_tmp0_ = (*self).self;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 ((*dest).self);
	(*dest).self = _tmp1_;
	_tmp2_ = (*self).function_code;
	(*dest).function_code = _tmp2_;
	_tmp3_ = (*self).val;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 ((*dest).val);
	(*dest).val = _tmp4_;
	_tmp5_ = (*self).key;
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 ((*dest).key);
	(*dest).key = _tmp6_;
}


void netsukuku_struct_helper_neighbourmanager_serialized_store_xxx_neighbour_destroy (Netsukukustruct_helper_NeighbourManager_serialized_store_XXX_neighbour* self) {
	_g_object_unref0 ((*self).self);
	_g_object_unref0 ((*self).val);
	_g_free0 ((*self).key);
}


Netsukukustruct_helper_NeighbourManager_serialized_store_XXX_neighbour* netsukuku_struct_helper_neighbourmanager_serialized_store_xxx_neighbour_dup (const Netsukukustruct_helper_NeighbourManager_serialized_store_XXX_neighbour* self) {
	Netsukukustruct_helper_NeighbourManager_serialized_store_XXX_neighbour* dup;
	dup = g_new0 (Netsukukustruct_helper_NeighbourManager_serialized_store_XXX_neighbour, 1);
	netsukuku_struct_helper_neighbourmanager_serialized_store_xxx_neighbour_copy (self, dup);
	return dup;
}


void netsukuku_struct_helper_neighbourmanager_serialized_store_xxx_neighbour_free (Netsukukustruct_helper_NeighbourManager_serialized_store_XXX_neighbour* self) {
	netsukuku_struct_helper_neighbourmanager_serialized_store_xxx_neighbour_destroy (self);
	g_free (self);
}


GType netsukuku_struct_helper_neighbourmanager_serialized_store_xxx_neighbour_get_type (void) {
	static volatile gsize netsukuku_struct_helper_neighbourmanager_serialized_store_xxx_neighbour_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_struct_helper_neighbourmanager_serialized_store_xxx_neighbour_type_id__volatile)) {
		GType netsukuku_struct_helper_neighbourmanager_serialized_store_xxx_neighbour_type_id;
		netsukuku_struct_helper_neighbourmanager_serialized_store_xxx_neighbour_type_id = g_boxed_type_register_static ("Netsukukustruct_helper_NeighbourManager_serialized_store_XXX_neighbour", (GBoxedCopyFunc) netsukuku_struct_helper_neighbourmanager_serialized_store_xxx_neighbour_dup, (GBoxedFreeFunc) netsukuku_struct_helper_neighbourmanager_serialized_store_xxx_neighbour_free);
		g_once_init_leave (&netsukuku_struct_helper_neighbourmanager_serialized_store_xxx_neighbour_type_id__volatile, netsukuku_struct_helper_neighbourmanager_serialized_store_xxx_neighbour_type_id);
	}
	return netsukuku_struct_helper_neighbourmanager_serialized_store_xxx_neighbour_type_id__volatile;
}


void netsukuku_struct_helper_neighbourmanager_store_copy (const Netsukukustruct_helper_NeighbourManager_store* self, Netsukukustruct_helper_NeighbourManager_store* dest) {
	NetsukukuNeighbourManager* _tmp0_;
	NetsukukuNeighbourManager* _tmp1_;
	gint _tmp2_;
	GeeHashMap* _tmp3_;
	GeeHashMap* _tmp4_;
	_tmp0_ = (*self).self;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 ((*dest).self);
	(*dest).self = _tmp1_;
	_tmp2_ = (*self).bouquet_numb;
	(*dest).bouquet_numb = _tmp2_;
	_tmp3_ = (*self).detected_neighbours;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 ((*dest).detected_neighbours);
	(*dest).detected_neighbours = _tmp4_;
}


void netsukuku_struct_helper_neighbourmanager_store_destroy (Netsukukustruct_helper_NeighbourManager_store* self) {
	_g_object_unref0 ((*self).self);
	_g_object_unref0 ((*self).detected_neighbours);
}


Netsukukustruct_helper_NeighbourManager_store* netsukuku_struct_helper_neighbourmanager_store_dup (const Netsukukustruct_helper_NeighbourManager_store* self) {
	Netsukukustruct_helper_NeighbourManager_store* dup;
	dup = g_new0 (Netsukukustruct_helper_NeighbourManager_store, 1);
	netsukuku_struct_helper_neighbourmanager_store_copy (self, dup);
	return dup;
}


void netsukuku_struct_helper_neighbourmanager_store_free (Netsukukustruct_helper_NeighbourManager_store* self) {
	netsukuku_struct_helper_neighbourmanager_store_destroy (self);
	g_free (self);
}


GType netsukuku_struct_helper_neighbourmanager_store_get_type (void) {
	static volatile gsize netsukuku_struct_helper_neighbourmanager_store_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_struct_helper_neighbourmanager_store_type_id__volatile)) {
		GType netsukuku_struct_helper_neighbourmanager_store_type_id;
		netsukuku_struct_helper_neighbourmanager_store_type_id = g_boxed_type_register_static ("Netsukukustruct_helper_NeighbourManager_store", (GBoxedCopyFunc) netsukuku_struct_helper_neighbourmanager_store_dup, (GBoxedFreeFunc) netsukuku_struct_helper_neighbourmanager_store_free);
		g_once_init_leave (&netsukuku_struct_helper_neighbourmanager_store_type_id__volatile, netsukuku_struct_helper_neighbourmanager_store_type_id);
	}
	return netsukuku_struct_helper_neighbourmanager_store_type_id__volatile;
}


NetsukukuNeighbourManager* netsukuku_neighbour_manager_construct_fake (GType object_type) {
	NetsukukuNeighbourManager * self = NULL;
	self = (NetsukukuNeighbourManager*) g_object_new (object_type, NULL);
	return self;
}


NetsukukuNeighbourManager* netsukuku_neighbour_manager_new_fake (void) {
	return netsukuku_neighbour_manager_construct_fake (NETSUKUKU_TYPE_NEIGHBOUR_MANAGER);
}


static void _netsukuku_neighbour_manager_store_netsukuku_radar_scan_done (NetsukukuRadar* _sender, gint bouquet_numb, GeeHashMap* detected_neighbours, gpointer self) {
	netsukuku_neighbour_manager_store (self, bouquet_numb, detected_neighbours);
}


static void _netsukuku_neighbour_manager_empty_netsukuku_radar_radar_stop (NetsukukuRadar* _sender, gpointer self) {
	netsukuku_neighbour_manager_empty (self);
}


NetsukukuNeighbourManager* netsukuku_neighbour_manager_construct (GType object_type, NetsukukuRadar* radar, gint max_neighbours) {
	NetsukukuNeighbourManager * self = NULL;
	gint _tmp0_;
	gint _tmp3_;
	GeeHashMap* _tmp4_;
	GeeHashMap* _tmp5_;
	NetsukukuRadar* _tmp6_;
	NetsukukuRadar* _tmp7_;
	NetsukukuRadar* _tmp8_;
	GeeArrayList* _tmp9_;
	g_return_val_if_fail (radar != NULL, NULL);
	self = (NetsukukuNeighbourManager*) g_object_new (object_type, NULL);
	_tmp0_ = max_neighbours;
	if (_tmp0_ == (-1)) {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = netsukuku_settings_get_MAX_NEIGHBOURS ();
		_tmp2_ = _tmp1_;
		max_neighbours = _tmp2_;
	}
	_tmp3_ = max_neighbours;
	self->priv->max_neighbours = _tmp3_;
	self->priv->rtt_variation_threshold = 0.9;
	_tmp4_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NETSUKUKU_TYPE_NEIGHBOUR, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->tnip_nodeid_table);
	self->priv->tnip_nodeid_table = _tmp4_;
	self->priv->number_of_scan_before_deleting = 2;
	_tmp5_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_INT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->missing_neighbour_keys);
	self->priv->missing_neighbour_keys = _tmp5_;
	_tmp6_ = radar;
	netsukuku_neighbour_manager_set_radar (self, _tmp6_);
	_tmp7_ = self->priv->_radar;
	g_signal_connect_object (_tmp7_, "scan-done", (GCallback) _netsukuku_neighbour_manager_store_netsukuku_radar_scan_done, self, 0);
	_tmp8_ = self->priv->_radar;
	g_signal_connect_object (_tmp8_, "radar-stop", (GCallback) _netsukuku_neighbour_manager_empty_netsukuku_radar_radar_stop, self, 0);
	_tmp9_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->declared_dead);
	self->priv->declared_dead = _tmp9_;
	return self;
}


NetsukukuNeighbourManager* netsukuku_neighbour_manager_new (NetsukukuRadar* radar, gint max_neighbours) {
	return netsukuku_neighbour_manager_construct (NETSUKUKU_TYPE_NEIGHBOUR_MANAGER, radar, max_neighbours);
}


static gchar* netsukuku_neighbour_manager_tnip_nodeid_key (NetsukukuNeighbourManager* self, NetsukukuNIP* key_nip, gint key_nodeid) {
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* ret;
	NetsukukuNIP* _tmp1_;
	gint _tmp2_ = 0;
	gint* _tmp3_ = NULL;
	gint* nip;
	gint nip_length1;
	gint _nip_size_;
	gint* _tmp4_;
	gint _tmp4__length1;
	const gchar* _tmp10_;
	gint _tmp11_;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_;
	gchar* _tmp14_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (key_nip != NULL, NULL);
	_tmp0_ = g_strdup ("");
	ret = _tmp0_;
	_tmp1_ = key_nip;
	_tmp3_ = netsukuku_partial_nip_get_positions ((NetsukukuPartialNIP*) _tmp1_, &_tmp2_);
	nip = _tmp3_;
	nip_length1 = _tmp2_;
	_nip_size_ = nip_length1;
	_tmp4_ = nip;
	_tmp4__length1 = nip_length1;
	{
		gint* i_collection = NULL;
		gint i_collection_length1 = 0;
		gint _i_collection_size_ = 0;
		gint i_it = 0;
		i_collection = _tmp4_;
		i_collection_length1 = _tmp4__length1;
		for (i_it = 0; i_it < _tmp4__length1; i_it = i_it + 1) {
			gint i = 0;
			i = i_collection[i_it];
			{
				const gchar* _tmp5_;
				gint _tmp6_;
				gchar* _tmp7_ = NULL;
				gchar* _tmp8_;
				gchar* _tmp9_;
				_tmp5_ = ret;
				_tmp6_ = i;
				_tmp7_ = g_strdup_printf ("%d_", _tmp6_);
				_tmp8_ = _tmp7_;
				_tmp9_ = g_strconcat (_tmp5_, _tmp8_, NULL);
				_g_free0 (ret);
				ret = _tmp9_;
				_g_free0 (_tmp8_);
			}
		}
	}
	_tmp10_ = ret;
	_tmp11_ = key_nodeid;
	_tmp12_ = g_strdup_printf ("%d", _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strconcat (_tmp10_, _tmp13_, NULL);
	_g_free0 (ret);
	ret = _tmp14_;
	_g_free0 (_tmp13_);
	result = ret;
	nip = (g_free (nip), NULL);
	return result;
}


static void netsukuku_neighbour_manager_key_tnip_nodeid (NetsukukuNeighbourManager* self, const gchar* key, NetsukukuNIP** key_nip, gint* key_nodeid) {
	NetsukukuNIP* _vala_key_nip = NULL;
	gint _vala_key_nodeid = 0;
	const gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_ = NULL;
	gchar** nums;
	gint nums_length1;
	gint _nums_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gint* _tmp4_ = NULL;
	gint* pos;
	gint pos_length1;
	gint _pos_size_;
	gchar** _tmp17_;
	gint _tmp17__length1;
	gchar** _tmp18_;
	gint _tmp18__length1;
	const gchar* _tmp19_;
	gint _tmp20_ = 0;
	gint* _tmp21_;
	gint _tmp21__length1;
	NetsukukuNIP* _tmp22_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = key;
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, "_", 0);
	nums = _tmp2_;
	nums_length1 = _vala_array_length (_tmp1_);
	_nums_size_ = nums_length1;
	_tmp3_ = nums;
	_tmp3__length1 = nums_length1;
	_tmp4_ = g_new0 (gint, _tmp3__length1 - 1);
	pos = _tmp4_;
	pos_length1 = _tmp3__length1 - 1;
	_pos_size_ = pos_length1;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp5_;
			_tmp5_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_;
				gint _tmp8_;
				gint* _tmp9_;
				gint _tmp9__length1;
				gint* _tmp10_;
				gint _tmp10__length1;
				gint _tmp11_;
				gchar** _tmp12_;
				gint _tmp12__length1;
				gint _tmp13_;
				const gchar* _tmp14_;
				gint _tmp15_ = 0;
				gint _tmp16_;
				_tmp6_ = _tmp5_;
				if (!_tmp6_) {
					gint _tmp7_;
					_tmp7_ = i;
					i = _tmp7_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp8_ = i;
				_tmp9_ = pos;
				_tmp9__length1 = pos_length1;
				if (!(_tmp8_ < _tmp9__length1)) {
					break;
				}
				_tmp10_ = pos;
				_tmp10__length1 = pos_length1;
				_tmp11_ = i;
				_tmp12_ = nums;
				_tmp12__length1 = nums_length1;
				_tmp13_ = i;
				_tmp14_ = _tmp12_[_tmp13_];
				_tmp15_ = atoi (_tmp14_);
				_tmp10_[_tmp11_] = _tmp15_;
				_tmp16_ = _tmp10_[_tmp11_];
			}
		}
	}
	_tmp17_ = nums;
	_tmp17__length1 = nums_length1;
	_tmp18_ = nums;
	_tmp18__length1 = nums_length1;
	_tmp19_ = _tmp17_[_tmp18__length1 - 1];
	_tmp20_ = atoi (_tmp19_);
	_vala_key_nodeid = _tmp20_;
	_tmp21_ = pos;
	_tmp21__length1 = pos_length1;
	_tmp22_ = netsukuku_nip_new (_tmp21_, _tmp21__length1);
	_g_object_unref0 (_vala_key_nip);
	_vala_key_nip = _tmp22_;
	pos = (g_free (pos), NULL);
	nums = (_vala_array_free (nums, nums_length1, (GDestroyNotify) g_free), NULL);
	if (key_nip) {
		*key_nip = _vala_key_nip;
	} else {
		_g_object_unref0 (_vala_key_nip);
	}
	if (key_nodeid) {
		*key_nodeid = _vala_key_nodeid;
	}
}


/** Returns the list of neighbours.
          */
static gboolean _netsukuku_neighbour_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gboolean result;
	result = netsukuku_neighbour_equal_func (a, b);
	return result;
}


static GeeList* netsukuku_neighbour_manager_real_neighbour_list (NetsukukuNeighbourManager* self) {
	GeeList* result = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* nlist;
	_tmp0_ = gee_array_list_new (NETSUKUKU_TYPE_NEIGHBOUR, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_neighbour_equal_func_gee_equal_data_func, NULL, NULL);
	nlist = _tmp0_;
	{
		GeeHashMap* _tmp1_;
		GeeSet* _tmp2_;
		GeeSet* _tmp3_;
		GeeSet* _tmp4_;
		GeeIterator* _tmp5_ = NULL;
		GeeIterator* _tmp6_;
		GeeIterator* _skey_it;
		_tmp1_ = self->priv->tnip_nodeid_table;
		_tmp2_ = gee_abstract_map_get_keys ((GeeMap*) _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_;
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
		_skey_it = _tmp6_;
		while (TRUE) {
			GeeIterator* _tmp7_;
			gboolean _tmp8_ = FALSE;
			GeeIterator* _tmp9_;
			gpointer _tmp10_ = NULL;
			gchar* skey;
			NetsukukuNIP* key_nip = NULL;
			gint key_nodeid = 0;
			const gchar* _tmp11_;
			NetsukukuNIP* _tmp12_ = NULL;
			gint _tmp13_ = 0;
			GeeArrayList* _tmp14_;
			GeeHashMap* _tmp15_;
			const gchar* _tmp16_;
			gpointer _tmp17_ = NULL;
			NetsukukuNeighbour* _tmp18_;
			_tmp7_ = _skey_it;
			_tmp8_ = gee_iterator_next (_tmp7_);
			if (!_tmp8_) {
				break;
			}
			_tmp9_ = _skey_it;
			_tmp10_ = gee_iterator_get (_tmp9_);
			skey = (gchar*) _tmp10_;
			_tmp11_ = skey;
			netsukuku_neighbour_manager_key_tnip_nodeid (self, _tmp11_, &_tmp12_, &_tmp13_);
			_g_object_unref0 (key_nip);
			key_nip = _tmp12_;
			key_nodeid = _tmp13_;
			_tmp14_ = nlist;
			_tmp15_ = self->priv->tnip_nodeid_table;
			_tmp16_ = skey;
			_tmp17_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp15_, _tmp16_);
			_tmp18_ = (NetsukukuNeighbour*) _tmp17_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp14_, _tmp18_);
			_g_object_unref0 (_tmp18_);
			_g_object_unref0 (key_nip);
			_g_free0 (skey);
		}
		_g_object_unref0 (_skey_it);
	}
	result = (GeeList*) nlist;
	return result;
}


GeeList* netsukuku_neighbour_manager_neighbour_list (NetsukukuNeighbourManager* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return NETSUKUKU_NEIGHBOUR_MANAGER_GET_CLASS (self)->neighbour_list (self);
}


/** Inserts this neighbour in our data structures.
          */
static void netsukuku_neighbour_manager_memorize (NetsukukuNeighbourManager* self, NetsukukuNeighbour* val, GError** error) {
	NetsukukuNeighbour* _tmp0_;
	NetsukukuNIP* _tmp1_;
	NetsukukuNIP* _tmp2_;
	NetsukukuNeighbour* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* skey;
	GeeHashMap* _tmp7_;
	const gchar* _tmp8_;
	gboolean _tmp9_ = FALSE;
	GeeHashMap* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	GeeHashMap* _tmp16_;
	const gchar* _tmp17_;
	NetsukukuNeighbour* _tmp18_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (val != NULL);
	_tmp0_ = val;
	_tmp1_ = netsukuku_neighbour_get_nip (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = val;
	_tmp4_ = netsukuku_neighbour_get_nodeid (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = netsukuku_neighbour_manager_tnip_nodeid_key (self, _tmp2_, _tmp5_);
	skey = _tmp6_;
	_tmp7_ = self->priv->tnip_nodeid_table;
	_tmp8_ = skey;
	_tmp9_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp7_, _tmp8_);
	if (_tmp9_) {
		GError* _tmp10_;
		_tmp10_ = g_error_new_literal (NETSUKUKU_NEIGHBOUR_ERROR, NETSUKUKU_NEIGHBOUR_ERROR_DUPLICATE_INSERT, "Key was already present");
		_inner_error_ = _tmp10_;
		if (_inner_error_->domain == NETSUKUKU_NEIGHBOUR_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (skey);
			return;
		} else {
			_g_free0 (skey);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp11_ = self->priv->tnip_nodeid_table;
	_tmp12_ = gee_abstract_map_get_size ((GeeMap*) _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = self->priv->max_neighbours;
	if (_tmp13_ > _tmp14_) {
		GError* _tmp15_;
		_tmp15_ = g_error_new_literal (NETSUKUKU_NEIGHBOUR_ERROR, NETSUKUKU_NEIGHBOUR_ERROR_MAX_EXCEED, "Max Neighbours Exceeded");
		_inner_error_ = _tmp15_;
		if (_inner_error_->domain == NETSUKUKU_NEIGHBOUR_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (skey);
			return;
		} else {
			_g_free0 (skey);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp16_ = self->priv->tnip_nodeid_table;
	_tmp17_ = skey;
	_tmp18_ = val;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp16_, _tmp17_, _tmp18_);
	_g_free0 (skey);
}


/** Removes this neighbour in our data structures.
          */
static void netsukuku_neighbour_manager_unmemorize (NetsukukuNeighbourManager* self, const gchar* skey, GError** error) {
	GeeHashMap* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GeeHashMap* _tmp4_;
	const gchar* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (skey != NULL);
	_tmp0_ = self->priv->tnip_nodeid_table;
	_tmp1_ = skey;
	_tmp2_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, _tmp1_);
	if (!_tmp2_) {
		GError* _tmp3_;
		_tmp3_ = g_error_new_literal (NETSUKUKU_NEIGHBOUR_ERROR, NETSUKUKU_NEIGHBOUR_ERROR_MISSING_REMOVE, "Key was not present");
		_inner_error_ = _tmp3_;
		if (_inner_error_->domain == NETSUKUKU_NEIGHBOUR_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp4_ = self->priv->tnip_nodeid_table;
	_tmp5_ = skey;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp4_, _tmp5_, NULL);
}


/** return a Neighbour object from its nip and nodeid
          */
NetsukukuNeighbour* netsukuku_neighbour_manager_key_to_neighbour (NetsukukuNeighbourManager* self, NetsukukuNIP* nip, gint nodeid) {
	NetsukukuNeighbour* result = NULL;
	NetsukukuNIP* _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* skey;
	GeeHashMap* _tmp3_;
	const gchar* _tmp4_;
	gboolean _tmp5_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (nip != NULL, NULL);
	_tmp0_ = nip;
	_tmp1_ = nodeid;
	_tmp2_ = netsukuku_neighbour_manager_tnip_nodeid_key (self, _tmp0_, _tmp1_);
	skey = _tmp2_;
	_tmp3_ = self->priv->tnip_nodeid_table;
	_tmp4_ = skey;
	_tmp5_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp3_, _tmp4_);
	if (!_tmp5_) {
		result = NULL;
		_g_free0 (skey);
		return result;
	} else {
		GeeHashMap* _tmp6_;
		const gchar* _tmp7_;
		gpointer _tmp8_ = NULL;
		_tmp6_ = self->priv->tnip_nodeid_table;
		_tmp7_ = skey;
		_tmp8_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp6_, _tmp7_);
		result = (NetsukukuNeighbour*) _tmp8_;
		_g_free0 (skey);
		return result;
	}
	_g_free0 (skey);
}


static gint netsukuku_neighbour_manager_table_compare_func (GeeMapEntry* a, GeeMapEntry* b) {
	gint result = 0;
	GeeMapEntry* _tmp0_;
	gconstpointer _tmp1_;
	NetsukukuNeighbour* _tmp2_;
	NetsukukuREM* _tmp3_;
	NetsukukuREM* _tmp4_;
	GeeMapEntry* _tmp5_;
	gconstpointer _tmp6_;
	NetsukukuNeighbour* _tmp7_;
	NetsukukuREM* _tmp8_;
	NetsukukuREM* _tmp9_;
	gint _tmp10_ = 0;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = b;
	_tmp1_ = gee_map_entry_get_value (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = netsukuku_neighbour_get_rem ((NetsukukuNeighbour*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = a;
	_tmp6_ = gee_map_entry_get_value (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = netsukuku_neighbour_get_rem ((NetsukukuNeighbour*) _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = netsukuku_rem_compare_to (_tmp4_, _tmp9_);
	result = _tmp10_;
	return result;
}


static gboolean netsukuku_neighbour_manager_not_impl_equal_func (GObject* a, GObject* b) {
	gboolean result = FALSE;
	g_error ("neighbour.vala:304: NeighbourManager._truncate: equal_func not impleme" \
"nted");
	return result;
}


static gboolean _netsukuku_neighbour_manager_not_impl_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gboolean result;
	result = netsukuku_neighbour_manager_not_impl_equal_func (a, b);
	return result;
}


static gint _netsukuku_neighbour_manager_table_compare_func_gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gint result;
	result = netsukuku_neighbour_manager_table_compare_func (a, b);
	return result;
}


GeeHashMap* _netsukuku_neighbour_manager_truncate (NetsukukuNeighbourManager* self, GeeHashMap* old_tnip_nodeid_table) {
	GeeHashMap* result = NULL;
	GeeHashMap* _tmp0_;
	GeeHashMap* tnip_nodeid_table_trunc;
	gint counter;
	GeeArrayList* _tmp1_;
	GeeArrayList* elements;
	GeeArrayList* _tmp14_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old_tnip_nodeid_table != NULL, NULL);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NETSUKUKU_TYPE_NEIGHBOUR, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	tnip_nodeid_table_trunc = _tmp0_;
	counter = 0;
	_tmp1_ = gee_array_list_new (GEE_MAP_TYPE_ENTRY, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_neighbour_manager_not_impl_equal_func_gee_equal_data_func, NULL, NULL);
	elements = _tmp1_;
	{
		GeeHashMap* _tmp2_;
		GeeSet* _tmp3_;
		GeeSet* _tmp4_;
		GeeSet* _tmp5_;
		GeeIterator* _tmp6_ = NULL;
		GeeIterator* _tmp7_;
		GeeIterator* _el_it;
		_tmp2_ = old_tnip_nodeid_table;
		_tmp3_ = gee_abstract_map_get_entries ((GeeMap*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = _tmp4_;
		_tmp6_ = gee_iterable_iterator ((GeeIterable*) _tmp5_);
		_tmp7_ = _tmp6_;
		_g_object_unref0 (_tmp5_);
		_el_it = _tmp7_;
		while (TRUE) {
			GeeIterator* _tmp8_;
			gboolean _tmp9_ = FALSE;
			GeeIterator* _tmp10_;
			gpointer _tmp11_ = NULL;
			GeeMapEntry* el;
			GeeArrayList* _tmp12_;
			GeeMapEntry* _tmp13_;
			_tmp8_ = _el_it;
			_tmp9_ = gee_iterator_next (_tmp8_);
			if (!_tmp9_) {
				break;
			}
			_tmp10_ = _el_it;
			_tmp11_ = gee_iterator_get (_tmp10_);
			el = (GeeMapEntry*) _tmp11_;
			_tmp12_ = elements;
			_tmp13_ = el;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp12_, _tmp13_);
			_g_object_unref0 (el);
		}
		_g_object_unref0 (_el_it);
	}
	_tmp14_ = elements;
	gee_list_sort ((GeeList*) _tmp14_, _netsukuku_neighbour_manager_table_compare_func_gcompare_data_func, NULL, NULL);
	{
		GeeArrayList* _tmp15_;
		GeeArrayList* _tmp16_;
		GeeArrayList* _el_list;
		GeeArrayList* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		gint _el_size;
		gint _el_index;
		_tmp15_ = elements;
		_tmp16_ = _g_object_ref0 (_tmp15_);
		_el_list = _tmp16_;
		_tmp17_ = _el_list;
		_tmp18_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp17_);
		_tmp19_ = _tmp18_;
		_el_size = _tmp19_;
		_el_index = -1;
		while (TRUE) {
			gint _tmp20_;
			gint _tmp21_;
			gint _tmp22_;
			GeeArrayList* _tmp23_;
			gint _tmp24_;
			gpointer _tmp25_ = NULL;
			GeeMapEntry* el;
			gint _tmp26_;
			gint _tmp27_;
			_tmp20_ = _el_index;
			_el_index = _tmp20_ + 1;
			_tmp21_ = _el_index;
			_tmp22_ = _el_size;
			if (!(_tmp21_ < _tmp22_)) {
				break;
			}
			_tmp23_ = _el_list;
			_tmp24_ = _el_index;
			_tmp25_ = gee_abstract_list_get ((GeeAbstractList*) _tmp23_, _tmp24_);
			el = (GeeMapEntry*) _tmp25_;
			_tmp26_ = counter;
			_tmp27_ = self->priv->max_neighbours;
			if (_tmp26_ < _tmp27_) {
				GeeHashMap* _tmp28_;
				GeeMapEntry* _tmp29_;
				gconstpointer _tmp30_;
				const gchar* _tmp31_;
				GeeMapEntry* _tmp32_;
				gconstpointer _tmp33_;
				NetsukukuNeighbour* _tmp34_;
				gint _tmp35_;
				_tmp28_ = tnip_nodeid_table_trunc;
				_tmp29_ = el;
				_tmp30_ = gee_map_entry_get_key (_tmp29_);
				_tmp31_ = _tmp30_;
				_tmp32_ = el;
				_tmp33_ = gee_map_entry_get_value (_tmp32_);
				_tmp34_ = _tmp33_;
				gee_abstract_map_set ((GeeAbstractMap*) _tmp28_, (const gchar*) _tmp31_, (NetsukukuNeighbour*) _tmp34_);
				_tmp35_ = counter;
				counter = _tmp35_ + 1;
			} else {
				_g_object_unref0 (el);
				break;
			}
			_g_object_unref0 (el);
		}
		_g_object_unref0 (_el_list);
	}
	result = tnip_nodeid_table_trunc;
	_g_object_unref0 (elements);
	return result;
}


static void netsukuku_neighbour_manager_serialized_store_add_neighbour (NetsukukuNeighbourManager* self, const gchar* key, NetsukukuNeighbour* val, GError** error) {
	GeeHashMap* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	NetsukukuNeighbour* _tmp3_;
	NetsukukuNeighbour* _tmp4_;
	const gchar* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (val != NULL);
	_tmp0_ = self->priv->tnip_nodeid_table;
	_tmp1_ = key;
	_tmp2_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, _tmp1_);
	if (_tmp2_) {
		return;
	}
	_tmp3_ = val;
	netsukuku_neighbour_manager_going_add (self, _tmp3_);
	_tmp4_ = val;
	netsukuku_neighbour_manager_memorize (self, _tmp4_, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp5_ = key;
	netsukuku_neighbour_manager_add_neighbour (self, _tmp5_);
}


static void netsukuku_neighbour_manager_serialized_store_delete_neighbour (NetsukukuNeighbourManager* self, const gchar* key, GError** error) {
	GeeHashMap* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GeeHashMap* _tmp3_;
	const gchar* _tmp4_;
	gpointer _tmp5_ = NULL;
	NetsukukuNeighbour* old_val;
	NetsukukuNeighbour* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	NetsukukuNeighbour* _tmp9_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = self->priv->tnip_nodeid_table;
	_tmp1_ = key;
	_tmp2_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, _tmp1_);
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = self->priv->tnip_nodeid_table;
	_tmp4_ = key;
	_tmp5_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp3_, _tmp4_);
	old_val = (NetsukukuNeighbour*) _tmp5_;
	_tmp6_ = old_val;
	netsukuku_neighbour_manager_going_delete (self, _tmp6_);
	_tmp7_ = key;
	netsukuku_neighbour_manager_unmemorize (self, _tmp7_, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (old_val);
		return;
	}
	_tmp8_ = key;
	_tmp9_ = old_val;
	netsukuku_neighbour_manager_delete_neighbour (self, _tmp8_, _tmp9_);
	_g_object_unref0 (old_val);
}


static void netsukuku_neighbour_manager_serialized_store_changed_rem_neighbour (NetsukukuNeighbourManager* self, const gchar* key, NetsukukuNeighbour* val, GError** error) {
	GeeHashMap* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GeeHashMap* _tmp3_;
	const gchar* _tmp4_;
	gpointer _tmp5_ = NULL;
	NetsukukuNeighbour* old_val;
	NetsukukuNeighbour* _tmp6_;
	NetsukukuNeighbour* _tmp7_;
	NetsukukuREM* _tmp8_;
	NetsukukuREM* _tmp9_;
	NetsukukuREM* _tmp10_;
	NetsukukuREM* old_rem;
	NetsukukuNeighbour* _tmp11_;
	NetsukukuNeighbour* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	NetsukukuNeighbour* _tmp15_;
	NetsukukuNeighbour* _tmp16_;
	NetsukukuREM* _tmp17_;
	NetsukukuREM* _tmp18_;
	const gchar* _tmp19_;
	NetsukukuREM* _tmp20_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (val != NULL);
	_tmp0_ = self->priv->tnip_nodeid_table;
	_tmp1_ = key;
	_tmp2_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, _tmp1_);
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = self->priv->tnip_nodeid_table;
	_tmp4_ = key;
	_tmp5_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp3_, _tmp4_);
	old_val = (NetsukukuNeighbour*) _tmp5_;
	_tmp6_ = old_val;
	netsukuku_neighbour_manager_going_rem_change (self, _tmp6_);
	_tmp7_ = old_val;
	_tmp8_ = netsukuku_neighbour_get_rem (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = _g_object_ref0 (_tmp9_);
	old_rem = _tmp10_;
	_tmp11_ = old_val;
	_tmp12_ = val;
	_tmp13_ = netsukuku_neighbour_get_dev (_tmp12_);
	_tmp14_ = _tmp13_;
	netsukuku_neighbour_set_dev (_tmp11_, _tmp14_);
	_tmp15_ = old_val;
	_tmp16_ = val;
	_tmp17_ = netsukuku_neighbour_get_rem (_tmp16_);
	_tmp18_ = _tmp17_;
	netsukuku_neighbour_set_rem (_tmp15_, _tmp18_);
	_tmp19_ = key;
	_tmp20_ = old_rem;
	netsukuku_neighbour_manager_rem_change_neighbour (self, _tmp19_, _tmp20_);
	_g_object_unref0 (old_rem);
	_g_object_unref0 (old_val);
}


static void netsukuku_neighbour_manager_serialized_store_changed_attrib_neighbour (NetsukukuNeighbourManager* self, const gchar* key, NetsukukuNeighbour* val, GError** error) {
	GeeHashMap* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GeeHashMap* _tmp3_;
	const gchar* _tmp4_;
	gpointer _tmp5_ = NULL;
	NetsukukuNeighbour* old_val;
	NetsukukuNeighbour* _tmp6_;
	NetsukukuNeighbour* _tmp7_;
	NetsukukuREM* _tmp8_;
	NetsukukuREM* _tmp9_;
	NetsukukuREM* _tmp10_;
	NetsukukuREM* old_rem;
	NetsukukuNeighbour* _tmp11_;
	NetsukukuNeighbour* _tmp12_;
	NetsukukuNetworkID* _tmp13_;
	NetsukukuNetworkID* _tmp14_;
	NetsukukuNeighbour* _tmp15_;
	NetsukukuNeighbour* _tmp16_;
	gboolean _tmp17_;
	gboolean _tmp18_;
	const gchar* _tmp19_;
	NetsukukuREM* _tmp20_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (val != NULL);
	_tmp0_ = self->priv->tnip_nodeid_table;
	_tmp1_ = key;
	_tmp2_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, _tmp1_);
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = self->priv->tnip_nodeid_table;
	_tmp4_ = key;
	_tmp5_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp3_, _tmp4_);
	old_val = (NetsukukuNeighbour*) _tmp5_;
	_tmp6_ = old_val;
	netsukuku_neighbour_manager_going_rem_change (self, _tmp6_);
	_tmp7_ = old_val;
	_tmp8_ = netsukuku_neighbour_get_rem (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = _g_object_ref0 (_tmp9_);
	old_rem = _tmp10_;
	_tmp11_ = old_val;
	_tmp12_ = val;
	_tmp13_ = netsukuku_neighbour_get_netid (_tmp12_);
	_tmp14_ = _tmp13_;
	netsukuku_neighbour_set_netid (_tmp11_, _tmp14_);
	_tmp15_ = old_val;
	_tmp16_ = val;
	_tmp17_ = netsukuku_neighbour_get_is_primary (_tmp16_);
	_tmp18_ = _tmp17_;
	netsukuku_neighbour_set_is_primary (_tmp15_, _tmp18_);
	_tmp19_ = key;
	_tmp20_ = old_rem;
	netsukuku_neighbour_manager_rem_change_neighbour (self, _tmp19_, _tmp20_);
	_g_object_unref0 (old_rem);
	_g_object_unref0 (old_val);
}


static void* netsukuku_neighbour_manager_helper_serialized_store_XXX_neighbour (void* v, GError** error) {
	void* result = NULL;
	void* _tmp0_;
	Taskletsstruct_channel* ch_cont_p;
	Taskletsstruct_channel* _tmp1_;
	TaskletsChannel* _tmp2_;
	TaskletsChannel* _tmp3_;
	TaskletsChannel* ch;
	GError * _inner_error_ = NULL;
	tasklets_tasklet_declare_self ("NeighbourManager.serialized_store dispatcher");
	_tmp0_ = v;
	ch_cont_p = (Taskletsstruct_channel*) _tmp0_;
	_tmp1_ = ch_cont_p;
	_tmp2_ = (*_tmp1_).self;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	ch = _tmp3_;
	tasklets_tasklet_schedule_back ();
	while (TRUE) {
		gchar* doing;
		Netsukukustruct_helper_NeighbourManager_serialized_store_XXX_neighbour tuple_p = {0};
		const gchar* _tmp78_;
		doing = NULL;
		{
			Netsukukustruct_helper_NeighbourManager_serialized_store_XXX_neighbour _tmp8_;
			gint _tmp9_;
			Netsukukustruct_helper_NeighbourManager_serialized_store_XXX_neighbour _tmp21_;
			gint _tmp22_;
			Netsukukustruct_helper_NeighbourManager_serialized_store_XXX_neighbour _tmp32_;
			gint _tmp33_;
			Netsukukustruct_helper_NeighbourManager_serialized_store_XXX_neighbour _tmp45_;
			gint _tmp46_;
			{
				TaskletsChannel* _tmp4_;
				GValue _tmp5_ = {0};
				GValue vv;
				void* _tmp6_ = NULL;
				Netsukukustruct_helper_NeighbourManager_serialized_store_XXX_neighbour _tmp7_ = {0};
				_tmp4_ = ch;
				tasklets_channel_recv (_tmp4_, &_tmp5_);
				vv = _tmp5_;
				_tmp6_ = g_value_get_boxed (&vv);
				netsukuku_struct_helper_neighbourmanager_serialized_store_xxx_neighbour_copy ((Netsukukustruct_helper_NeighbourManager_serialized_store_XXX_neighbour*) _tmp6_, &_tmp7_);
				netsukuku_struct_helper_neighbourmanager_serialized_store_xxx_neighbour_destroy (&tuple_p);
				tuple_p = _tmp7_;
				G_IS_VALUE (&vv) ? (g_value_unset (&vv), NULL) : NULL;
			}
			_tmp8_ = tuple_p;
			_tmp9_ = _tmp8_.function_code;
			if (_tmp9_ == 1) {
				Netsukukustruct_helper_NeighbourManager_serialized_store_XXX_neighbour _tmp10_;
				const gchar* _tmp11_;
				const gchar* _tmp12_ = NULL;
				gchar* _tmp13_ = NULL;
				const gchar* _tmp14_;
				Netsukukustruct_helper_NeighbourManager_serialized_store_XXX_neighbour _tmp15_;
				NetsukukuNeighbourManager* _tmp16_;
				Netsukukustruct_helper_NeighbourManager_serialized_store_XXX_neighbour _tmp17_;
				const gchar* _tmp18_;
				Netsukukustruct_helper_NeighbourManager_serialized_store_XXX_neighbour _tmp19_;
				NetsukukuNeighbour* _tmp20_;
				_tmp10_ = tuple_p;
				_tmp11_ = _tmp10_.key;
				_tmp12_ = string_to_string (_tmp11_);
				_tmp13_ = g_strconcat ("add_neighbour(", _tmp12_, ")", NULL);
				_g_free0 (doing);
				doing = _tmp13_;
				_tmp14_ = doing;
				tasklets_tasklet_declare_self (_tmp14_);
				_tmp15_ = tuple_p;
				_tmp16_ = _tmp15_.self;
				_tmp17_ = tuple_p;
				_tmp18_ = _tmp17_.key;
				_tmp19_ = tuple_p;
				_tmp20_ = _tmp19_.val;
				netsukuku_neighbour_manager_serialized_store_add_neighbour (_tmp16_, _tmp18_, _tmp20_, &_inner_error_);
				if (_inner_error_ != NULL) {
					goto __catch60_g_error;
				}
			}
			_tmp21_ = tuple_p;
			_tmp22_ = _tmp21_.function_code;
			if (_tmp22_ == 2) {
				Netsukukustruct_helper_NeighbourManager_serialized_store_XXX_neighbour _tmp23_;
				const gchar* _tmp24_;
				const gchar* _tmp25_ = NULL;
				gchar* _tmp26_ = NULL;
				const gchar* _tmp27_;
				Netsukukustruct_helper_NeighbourManager_serialized_store_XXX_neighbour _tmp28_;
				NetsukukuNeighbourManager* _tmp29_;
				Netsukukustruct_helper_NeighbourManager_serialized_store_XXX_neighbour _tmp30_;
				const gchar* _tmp31_;
				_tmp23_ = tuple_p;
				_tmp24_ = _tmp23_.key;
				_tmp25_ = string_to_string (_tmp24_);
				_tmp26_ = g_strconcat ("delete_neighbour(", _tmp25_, ")", NULL);
				_g_free0 (doing);
				doing = _tmp26_;
				_tmp27_ = doing;
				tasklets_tasklet_declare_self (_tmp27_);
				_tmp28_ = tuple_p;
				_tmp29_ = _tmp28_.self;
				_tmp30_ = tuple_p;
				_tmp31_ = _tmp30_.key;
				netsukuku_neighbour_manager_serialized_store_delete_neighbour (_tmp29_, _tmp31_, &_inner_error_);
				if (_inner_error_ != NULL) {
					goto __catch60_g_error;
				}
			}
			_tmp32_ = tuple_p;
			_tmp33_ = _tmp32_.function_code;
			if (_tmp33_ == 3) {
				Netsukukustruct_helper_NeighbourManager_serialized_store_XXX_neighbour _tmp34_;
				const gchar* _tmp35_;
				const gchar* _tmp36_ = NULL;
				gchar* _tmp37_ = NULL;
				const gchar* _tmp38_;
				Netsukukustruct_helper_NeighbourManager_serialized_store_XXX_neighbour _tmp39_;
				NetsukukuNeighbourManager* _tmp40_;
				Netsukukustruct_helper_NeighbourManager_serialized_store_XXX_neighbour _tmp41_;
				const gchar* _tmp42_;
				Netsukukustruct_helper_NeighbourManager_serialized_store_XXX_neighbour _tmp43_;
				NetsukukuNeighbour* _tmp44_;
				_tmp34_ = tuple_p;
				_tmp35_ = _tmp34_.key;
				_tmp36_ = string_to_string (_tmp35_);
				_tmp37_ = g_strconcat ("changed_rem_neighbour(", _tmp36_, ")", NULL);
				_g_free0 (doing);
				doing = _tmp37_;
				_tmp38_ = doing;
				tasklets_tasklet_declare_self (_tmp38_);
				_tmp39_ = tuple_p;
				_tmp40_ = _tmp39_.self;
				_tmp41_ = tuple_p;
				_tmp42_ = _tmp41_.key;
				_tmp43_ = tuple_p;
				_tmp44_ = _tmp43_.val;
				netsukuku_neighbour_manager_serialized_store_changed_rem_neighbour (_tmp40_, _tmp42_, _tmp44_, &_inner_error_);
				if (_inner_error_ != NULL) {
					goto __catch60_g_error;
				}
			}
			_tmp45_ = tuple_p;
			_tmp46_ = _tmp45_.function_code;
			if (_tmp46_ == 4) {
				Netsukukustruct_helper_NeighbourManager_serialized_store_XXX_neighbour _tmp47_;
				const gchar* _tmp48_;
				const gchar* _tmp49_ = NULL;
				gchar* _tmp50_ = NULL;
				const gchar* _tmp51_;
				Netsukukustruct_helper_NeighbourManager_serialized_store_XXX_neighbour _tmp52_;
				NetsukukuNeighbourManager* _tmp53_;
				Netsukukustruct_helper_NeighbourManager_serialized_store_XXX_neighbour _tmp54_;
				const gchar* _tmp55_;
				Netsukukustruct_helper_NeighbourManager_serialized_store_XXX_neighbour _tmp56_;
				NetsukukuNeighbour* _tmp57_;
				_tmp47_ = tuple_p;
				_tmp48_ = _tmp47_.key;
				_tmp49_ = string_to_string (_tmp48_);
				_tmp50_ = g_strconcat ("changed_attrib_neighbour(", _tmp49_, ")", NULL);
				_g_free0 (doing);
				doing = _tmp50_;
				_tmp51_ = doing;
				tasklets_tasklet_declare_self (_tmp51_);
				_tmp52_ = tuple_p;
				_tmp53_ = _tmp52_.self;
				_tmp54_ = tuple_p;
				_tmp55_ = _tmp54_.key;
				_tmp56_ = tuple_p;
				_tmp57_ = _tmp56_.val;
				netsukuku_neighbour_manager_serialized_store_changed_attrib_neighbour (_tmp53_, _tmp55_, _tmp57_, &_inner_error_);
				if (_inner_error_ != NULL) {
					goto __catch60_g_error;
				}
			}
		}
		goto __finally60;
		__catch60_g_error:
		{
			GError* e = NULL;
			gchar* _tmp58_;
			gchar* part1;
			Netsukukustruct_helper_NeighbourManager_serialized_store_XXX_neighbour _tmp59_;
			gint _tmp60_;
			Netsukukustruct_helper_NeighbourManager_serialized_store_XXX_neighbour _tmp62_;
			gint _tmp63_;
			Netsukukustruct_helper_NeighbourManager_serialized_store_XXX_neighbour _tmp65_;
			gint _tmp66_;
			Netsukukustruct_helper_NeighbourManager_serialized_store_XXX_neighbour _tmp68_;
			gint _tmp69_;
			const gchar* _tmp71_;
			const gchar* _tmp72_ = NULL;
			GError* _tmp73_;
			const gchar* _tmp74_;
			const gchar* _tmp75_ = NULL;
			gchar* _tmp76_ = NULL;
			gchar* _tmp77_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp58_ = g_strdup ("serialized_store_XXX_neighbour");
			part1 = _tmp58_;
			_tmp59_ = tuple_p;
			_tmp60_ = _tmp59_.function_code;
			if (_tmp60_ == 1) {
				gchar* _tmp61_;
				_tmp61_ = g_strdup ("serialized_store_add_neighbour");
				_g_free0 (part1);
				part1 = _tmp61_;
			}
			_tmp62_ = tuple_p;
			_tmp63_ = _tmp62_.function_code;
			if (_tmp63_ == 2) {
				gchar* _tmp64_;
				_tmp64_ = g_strdup ("serialized_store_delete_neighbour");
				_g_free0 (part1);
				part1 = _tmp64_;
			}
			_tmp65_ = tuple_p;
			_tmp66_ = _tmp65_.function_code;
			if (_tmp66_ == 3) {
				gchar* _tmp67_;
				_tmp67_ = g_strdup ("serialized_store_changed_rem_neighbour");
				_g_free0 (part1);
				part1 = _tmp67_;
			}
			_tmp68_ = tuple_p;
			_tmp69_ = _tmp68_.function_code;
			if (_tmp69_ == 4) {
				gchar* _tmp70_;
				_tmp70_ = g_strdup ("serialized_store_changed_attrib_neighbour");
				_g_free0 (part1);
				part1 = _tmp70_;
			}
			_tmp71_ = part1;
			_tmp72_ = string_to_string (_tmp71_);
			_tmp73_ = e;
			_tmp74_ = _tmp73_->message;
			_tmp75_ = string_to_string (_tmp74_);
			_tmp76_ = g_strconcat ("NeighbourManager: ", _tmp72_, " reported an error: ", _tmp75_, NULL);
			_tmp77_ = _tmp76_;
			netsukuku_log_warn (_tmp77_);
			_g_free0 (_tmp77_);
			_g_free0 (part1);
			_g_error_free0 (e);
		}
		__finally60:
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			netsukuku_struct_helper_neighbourmanager_serialized_store_xxx_neighbour_destroy (&tuple_p);
			_g_free0 (doing);
			_g_object_unref0 (ch);
			return NULL;
		}
		_tmp78_ = doing;
		if (_tmp78_ != NULL) {
			const gchar* _tmp79_;
			_tmp79_ = doing;
			tasklets_tasklet_declare_finished (_tmp79_);
		}
		netsukuku_struct_helper_neighbourmanager_serialized_store_xxx_neighbour_destroy (&tuple_p);
		_g_free0 (doing);
	}
	_g_object_unref0 (ch);
	return result;
}


static void netsukuku_neighbour_manager_store_add_neighbour (NetsukukuNeighbourManager* self, const gchar* key, NetsukukuNeighbour* val) {
	TaskletsChannel* _tmp0_ = NULL;
	TaskletsChannel* ch;
	Netsukukustruct_helper_NeighbourManager_serialized_store_XXX_neighbour arg = {0};
	NetsukukuNeighbourManager* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	NetsukukuNeighbour* _tmp4_;
	NetsukukuNeighbour* _tmp5_;
	Netsukukustruct_helper_NeighbourManager_serialized_store_XXX_neighbour _tmp6_;
	GValue _tmp7_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (val != NULL);
	_tmp0_ = tasklets_tasklet_dispatcher_get_channel_for_helper ((TaskletsSpawnable) netsukuku_neighbour_manager_helper_serialized_store_XXX_neighbour, -1);
	ch = _tmp0_;
	memset (&arg, 0, sizeof (Netsukukustruct_helper_NeighbourManager_serialized_store_XXX_neighbour));
	_tmp1_ = _g_object_ref0 (self);
	_g_object_unref0 (arg.self);
	arg.self = _tmp1_;
	arg.function_code = 1;
	_tmp2_ = key;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (arg.key);
	arg.key = _tmp3_;
	_tmp4_ = val;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (arg.val);
	arg.val = _tmp5_;
	_tmp6_ = arg;
	g_value_init (&_tmp7_, NETSUKUKU_TYPE_STRUCT_HELPER_NEIGHBOURMANAGER_SERIALIZED_STORE_XXX_NEIGHBOUR);
	g_value_set_boxed (&_tmp7_, &_tmp6_);
	tasklets_channel_send_async (ch, &_tmp7_);
	G_IS_VALUE (&_tmp7_) ? (g_value_unset (&_tmp7_), NULL) : NULL;
	netsukuku_struct_helper_neighbourmanager_serialized_store_xxx_neighbour_destroy (&arg);
	_g_object_unref0 (ch);
}


static void netsukuku_neighbour_manager_store_delete_neighbour (NetsukukuNeighbourManager* self, const gchar* key) {
	TaskletsChannel* _tmp0_ = NULL;
	TaskletsChannel* ch;
	Netsukukustruct_helper_NeighbourManager_serialized_store_XXX_neighbour arg = {0};
	NetsukukuNeighbourManager* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	Netsukukustruct_helper_NeighbourManager_serialized_store_XXX_neighbour _tmp4_;
	GValue _tmp5_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = tasklets_tasklet_dispatcher_get_channel_for_helper ((TaskletsSpawnable) netsukuku_neighbour_manager_helper_serialized_store_XXX_neighbour, -1);
	ch = _tmp0_;
	memset (&arg, 0, sizeof (Netsukukustruct_helper_NeighbourManager_serialized_store_XXX_neighbour));
	_tmp1_ = _g_object_ref0 (self);
	_g_object_unref0 (arg.self);
	arg.self = _tmp1_;
	arg.function_code = 2;
	_tmp2_ = key;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (arg.key);
	arg.key = _tmp3_;
	_tmp4_ = arg;
	g_value_init (&_tmp5_, NETSUKUKU_TYPE_STRUCT_HELPER_NEIGHBOURMANAGER_SERIALIZED_STORE_XXX_NEIGHBOUR);
	g_value_set_boxed (&_tmp5_, &_tmp4_);
	tasklets_channel_send_async (ch, &_tmp5_);
	G_IS_VALUE (&_tmp5_) ? (g_value_unset (&_tmp5_), NULL) : NULL;
	netsukuku_struct_helper_neighbourmanager_serialized_store_xxx_neighbour_destroy (&arg);
	_g_object_unref0 (ch);
}


static void netsukuku_neighbour_manager_store_changed_rem_neighbour (NetsukukuNeighbourManager* self, const gchar* key, NetsukukuNeighbour* val) {
	TaskletsChannel* _tmp0_ = NULL;
	TaskletsChannel* ch;
	Netsukukustruct_helper_NeighbourManager_serialized_store_XXX_neighbour arg = {0};
	NetsukukuNeighbourManager* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	NetsukukuNeighbour* _tmp4_;
	NetsukukuNeighbour* _tmp5_;
	Netsukukustruct_helper_NeighbourManager_serialized_store_XXX_neighbour _tmp6_;
	GValue _tmp7_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (val != NULL);
	_tmp0_ = tasklets_tasklet_dispatcher_get_channel_for_helper ((TaskletsSpawnable) netsukuku_neighbour_manager_helper_serialized_store_XXX_neighbour, -1);
	ch = _tmp0_;
	memset (&arg, 0, sizeof (Netsukukustruct_helper_NeighbourManager_serialized_store_XXX_neighbour));
	_tmp1_ = _g_object_ref0 (self);
	_g_object_unref0 (arg.self);
	arg.self = _tmp1_;
	arg.function_code = 3;
	_tmp2_ = key;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (arg.key);
	arg.key = _tmp3_;
	_tmp4_ = val;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (arg.val);
	arg.val = _tmp5_;
	_tmp6_ = arg;
	g_value_init (&_tmp7_, NETSUKUKU_TYPE_STRUCT_HELPER_NEIGHBOURMANAGER_SERIALIZED_STORE_XXX_NEIGHBOUR);
	g_value_set_boxed (&_tmp7_, &_tmp6_);
	tasklets_channel_send_async (ch, &_tmp7_);
	G_IS_VALUE (&_tmp7_) ? (g_value_unset (&_tmp7_), NULL) : NULL;
	netsukuku_struct_helper_neighbourmanager_serialized_store_xxx_neighbour_destroy (&arg);
	_g_object_unref0 (ch);
}


static void netsukuku_neighbour_manager_store_changed_attrib_neighbour (NetsukukuNeighbourManager* self, const gchar* key, NetsukukuNeighbour* val) {
	TaskletsChannel* _tmp0_ = NULL;
	TaskletsChannel* ch;
	Netsukukustruct_helper_NeighbourManager_serialized_store_XXX_neighbour arg = {0};
	NetsukukuNeighbourManager* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	NetsukukuNeighbour* _tmp4_;
	NetsukukuNeighbour* _tmp5_;
	Netsukukustruct_helper_NeighbourManager_serialized_store_XXX_neighbour _tmp6_;
	GValue _tmp7_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (val != NULL);
	_tmp0_ = tasklets_tasklet_dispatcher_get_channel_for_helper ((TaskletsSpawnable) netsukuku_neighbour_manager_helper_serialized_store_XXX_neighbour, -1);
	ch = _tmp0_;
	memset (&arg, 0, sizeof (Netsukukustruct_helper_NeighbourManager_serialized_store_XXX_neighbour));
	_tmp1_ = _g_object_ref0 (self);
	_g_object_unref0 (arg.self);
	arg.self = _tmp1_;
	arg.function_code = 4;
	_tmp2_ = key;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (arg.key);
	arg.key = _tmp3_;
	_tmp4_ = val;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (arg.val);
	arg.val = _tmp5_;
	_tmp6_ = arg;
	g_value_init (&_tmp7_, NETSUKUKU_TYPE_STRUCT_HELPER_NEIGHBOURMANAGER_SERIALIZED_STORE_XXX_NEIGHBOUR);
	g_value_set_boxed (&_tmp7_, &_tmp6_);
	tasklets_channel_send_async (ch, &_tmp7_);
	G_IS_VALUE (&_tmp7_) ? (g_value_unset (&_tmp7_), NULL) : NULL;
	netsukuku_struct_helper_neighbourmanager_serialized_store_xxx_neighbour_destroy (&arg);
	_g_object_unref0 (ch);
}


static void netsukuku_neighbour_manager_real_declare_dead (NetsukukuNeighbourManager* self, NetsukukuNIP* nip, gint nodeid) {
	NetsukukuNIP* _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* key;
	GeeArrayList* _tmp3_;
	g_return_if_fail (nip != NULL);
	_tmp0_ = nip;
	_tmp1_ = nodeid;
	_tmp2_ = netsukuku_neighbour_manager_tnip_nodeid_key (self, _tmp0_, _tmp1_);
	key = _tmp2_;
	_tmp3_ = self->priv->declared_dead;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp3_, key);
	_g_free0 (key);
}


void netsukuku_neighbour_manager_declare_dead (NetsukukuNeighbourManager* self, NetsukukuNIP* nip, gint nodeid) {
	g_return_if_fail (self != NULL);
	NETSUKUKU_NEIGHBOUR_MANAGER_GET_CLASS (self)->declare_dead (self, nip, nodeid);
}


/** Detects changes in our neighbourhood. Updates internal data structures
          * and notify about the changes.
          */
static void netsukuku_neighbour_manager_impl_store (NetsukukuNeighbourManager* self, gint bouquet_numb, GeeHashMap* detected_neighbours, GError** error) {
	GeeArrayList* _declared_dead = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeHashMap* _tmp3_;
	GeeHashMap* _tmp4_;
	GeeHashMap* new_tnip_nodeid_table;
	GeeArrayList* _tmp5_;
	GeeArrayList* new_tnip_nodeid_table_keys;
	GeeArrayList* _tmp6_;
	GeeHashMap* _tmp7_;
	GeeSet* _tmp8_;
	GeeSet* _tmp9_;
	GeeSet* _tmp10_;
	GeeHashMap* _tmp27_;
	GeeHashMap* _tmp28_ = NULL;
	GeeArrayList* _tmp29_;
	GeeArrayList* to_be_deleted;
	GeeArrayList* _tmp30_;
	GeeArrayList* to_be_almost_deleted;
	GeeArrayList* _tmp31_;
	GeeArrayList* to_be_added_key;
	GeeArrayList* _tmp32_;
	GeeArrayList* to_be_added_value;
	GeeArrayList* _tmp33_;
	GeeArrayList* to_be_rem_changed_key;
	GeeArrayList* _tmp34_;
	GeeArrayList* to_be_rem_changed_value;
	GeeArrayList* _tmp35_;
	GeeArrayList* to_be_attrib_changed_key;
	GeeArrayList* _tmp36_;
	GeeArrayList* to_be_attrib_changed_value;
	GeeListIterator* keys = NULL;
	gboolean hascur = FALSE;
	GeeListIterator* values = NULL;
	GeeArrayList* _tmp247_;
	GeeListIterator* _tmp248_ = NULL;
	GeeListIterator* _tmp249_;
	gboolean _tmp250_ = FALSE;
	GeeArrayList* _tmp251_;
	GeeListIterator* _tmp252_ = NULL;
	GeeListIterator* _tmp253_;
	GeeArrayList* _tmp264_;
	GeeListIterator* _tmp265_ = NULL;
	GeeListIterator* _tmp266_;
	gboolean _tmp267_ = FALSE;
	GeeArrayList* _tmp268_;
	GeeListIterator* _tmp269_ = NULL;
	GeeListIterator* _tmp270_;
	GeeArrayList* _tmp281_;
	GeeListIterator* _tmp282_ = NULL;
	GeeListIterator* _tmp283_;
	gboolean _tmp284_ = FALSE;
	GeeArrayList* _tmp285_;
	GeeListIterator* _tmp286_ = NULL;
	GeeListIterator* _tmp287_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (detected_neighbours != NULL);
	tasklets_tasklet_declare_self ("NeighbourManager.store");
	_tmp0_ = self->priv->declared_dead;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_declared_dead);
	_declared_dead = _tmp1_;
	_tmp2_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->declared_dead);
	self->priv->declared_dead = _tmp2_;
	_tmp3_ = detected_neighbours;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	new_tnip_nodeid_table = _tmp4_;
	_tmp5_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	new_tnip_nodeid_table_keys = _tmp5_;
	_tmp6_ = new_tnip_nodeid_table_keys;
	_tmp7_ = new_tnip_nodeid_table;
	_tmp8_ = gee_abstract_map_get_keys ((GeeMap*) _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = _tmp9_;
	gee_array_list_add_all (_tmp6_, (GeeCollection*) _tmp10_);
	_g_object_unref0 (_tmp10_);
	{
		GeeArrayList* _tmp11_;
		GeeArrayList* _tmp12_;
		GeeArrayList* _k_list;
		GeeArrayList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _k_size;
		gint _k_index;
		_tmp11_ = new_tnip_nodeid_table_keys;
		_tmp12_ = _g_object_ref0 (_tmp11_);
		_k_list = _tmp12_;
		_tmp13_ = _k_list;
		_tmp14_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp13_);
		_tmp15_ = _tmp14_;
		_k_size = _tmp15_;
		_k_index = -1;
		while (TRUE) {
			gint _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			GeeArrayList* _tmp19_;
			gint _tmp20_;
			gpointer _tmp21_ = NULL;
			gchar* k;
			GeeArrayList* _tmp22_;
			const gchar* _tmp23_;
			gboolean _tmp24_ = FALSE;
			_tmp16_ = _k_index;
			_k_index = _tmp16_ + 1;
			_tmp17_ = _k_index;
			_tmp18_ = _k_size;
			if (!(_tmp17_ < _tmp18_)) {
				break;
			}
			_tmp19_ = _k_list;
			_tmp20_ = _k_index;
			_tmp21_ = gee_abstract_list_get ((GeeAbstractList*) _tmp19_, _tmp20_);
			k = (gchar*) _tmp21_;
			_tmp22_ = _declared_dead;
			_tmp23_ = k;
			_tmp24_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp22_, _tmp23_);
			if (_tmp24_) {
				GeeHashMap* _tmp25_;
				const gchar* _tmp26_;
				_tmp25_ = new_tnip_nodeid_table;
				_tmp26_ = k;
				gee_abstract_map_unset ((GeeAbstractMap*) _tmp25_, _tmp26_, NULL);
			}
			_g_free0 (k);
		}
		_g_object_unref0 (_k_list);
	}
	_tmp27_ = new_tnip_nodeid_table;
	_tmp28_ = _netsukuku_neighbour_manager_truncate (self, _tmp27_);
	_g_object_unref0 (new_tnip_nodeid_table);
	new_tnip_nodeid_table = _tmp28_;
	_tmp29_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	to_be_deleted = _tmp29_;
	_tmp30_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	to_be_almost_deleted = _tmp30_;
	_tmp31_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	to_be_added_key = _tmp31_;
	_tmp32_ = gee_array_list_new (NETSUKUKU_TYPE_NEIGHBOUR, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_neighbour_equal_func_gee_equal_data_func, NULL, NULL);
	to_be_added_value = _tmp32_;
	_tmp33_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	to_be_rem_changed_key = _tmp33_;
	_tmp34_ = gee_array_list_new (NETSUKUKU_TYPE_NEIGHBOUR, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_neighbour_equal_func_gee_equal_data_func, NULL, NULL);
	to_be_rem_changed_value = _tmp34_;
	_tmp35_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	to_be_attrib_changed_key = _tmp35_;
	_tmp36_ = gee_array_list_new (NETSUKUKU_TYPE_NEIGHBOUR, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_neighbour_equal_func_gee_equal_data_func, NULL, NULL);
	to_be_attrib_changed_value = _tmp36_;
	{
		GeeHashMap* _tmp37_;
		GeeSet* _tmp38_;
		GeeSet* _tmp39_;
		GeeSet* _tmp40_;
		GeeIterator* _tmp41_ = NULL;
		GeeIterator* _tmp42_;
		GeeIterator* _key_it;
		_tmp37_ = new_tnip_nodeid_table;
		_tmp38_ = gee_abstract_map_get_keys ((GeeMap*) _tmp37_);
		_tmp39_ = _tmp38_;
		_tmp40_ = _tmp39_;
		_tmp41_ = gee_iterable_iterator ((GeeIterable*) _tmp40_);
		_tmp42_ = _tmp41_;
		_g_object_unref0 (_tmp40_);
		_key_it = _tmp42_;
		while (TRUE) {
			GeeIterator* _tmp43_;
			gboolean _tmp44_ = FALSE;
			GeeIterator* _tmp45_;
			gpointer _tmp46_ = NULL;
			gchar* key;
			GeeHashMap* _tmp47_;
			const gchar* _tmp48_;
			gboolean _tmp49_ = FALSE;
			_tmp43_ = _key_it;
			_tmp44_ = gee_iterator_next (_tmp43_);
			if (!_tmp44_) {
				break;
			}
			_tmp45_ = _key_it;
			_tmp46_ = gee_iterator_get (_tmp45_);
			key = (gchar*) _tmp46_;
			_tmp47_ = self->priv->missing_neighbour_keys;
			_tmp48_ = key;
			_tmp49_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp47_, _tmp48_);
			if (_tmp49_) {
				GeeHashMap* _tmp50_;
				const gchar* _tmp51_;
				GeeArrayList* _tmp52_;
				const gchar* _tmp53_;
				GeeArrayList* _tmp54_;
				GeeHashMap* _tmp55_;
				const gchar* _tmp56_;
				gpointer _tmp57_ = NULL;
				NetsukukuNeighbour* _tmp58_;
				_tmp50_ = self->priv->missing_neighbour_keys;
				_tmp51_ = key;
				gee_abstract_map_unset ((GeeAbstractMap*) _tmp50_, _tmp51_, NULL);
				_tmp52_ = to_be_rem_changed_key;
				_tmp53_ = key;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp52_, _tmp53_);
				_tmp54_ = to_be_rem_changed_value;
				_tmp55_ = new_tnip_nodeid_table;
				_tmp56_ = key;
				_tmp57_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp55_, _tmp56_);
				_tmp58_ = (NetsukukuNeighbour*) _tmp57_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp54_, _tmp58_);
				_g_object_unref0 (_tmp58_);
			}
			_g_free0 (key);
		}
		_g_object_unref0 (_key_it);
	}
	{
		GeeArrayList* _tmp59_;
		GeeArrayList* _tmp60_;
		GeeArrayList* _key_list;
		GeeArrayList* _tmp61_;
		gint _tmp62_;
		gint _tmp63_;
		gint _key_size;
		gint _key_index;
		_tmp59_ = _declared_dead;
		_tmp60_ = _g_object_ref0 (_tmp59_);
		_key_list = _tmp60_;
		_tmp61_ = _key_list;
		_tmp62_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp61_);
		_tmp63_ = _tmp62_;
		_key_size = _tmp63_;
		_key_index = -1;
		while (TRUE) {
			gint _tmp64_;
			gint _tmp65_;
			gint _tmp66_;
			GeeArrayList* _tmp67_;
			gint _tmp68_;
			gpointer _tmp69_ = NULL;
			gchar* key;
			GeeHashMap* _tmp70_;
			const gchar* _tmp71_;
			gboolean _tmp72_ = FALSE;
			_tmp64_ = _key_index;
			_key_index = _tmp64_ + 1;
			_tmp65_ = _key_index;
			_tmp66_ = _key_size;
			if (!(_tmp65_ < _tmp66_)) {
				break;
			}
			_tmp67_ = _key_list;
			_tmp68_ = _key_index;
			_tmp69_ = gee_abstract_list_get ((GeeAbstractList*) _tmp67_, _tmp68_);
			key = (gchar*) _tmp69_;
			_tmp70_ = self->priv->missing_neighbour_keys;
			_tmp71_ = key;
			_tmp72_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp70_, _tmp71_);
			if (_tmp72_) {
				GeeHashMap* _tmp73_;
				const gchar* _tmp74_;
				_tmp73_ = self->priv->missing_neighbour_keys;
				_tmp74_ = key;
				gee_abstract_map_unset ((GeeAbstractMap*) _tmp73_, _tmp74_, NULL);
			}
			_g_free0 (key);
		}
		_g_object_unref0 (_key_list);
	}
	{
		GeeHashMap* _tmp75_;
		GeeSet* _tmp76_;
		GeeSet* _tmp77_;
		GeeSet* _tmp78_;
		GeeIterator* _tmp79_ = NULL;
		GeeIterator* _tmp80_;
		GeeIterator* _key_it;
		_tmp75_ = self->priv->tnip_nodeid_table;
		_tmp76_ = gee_abstract_map_get_keys ((GeeMap*) _tmp75_);
		_tmp77_ = _tmp76_;
		_tmp78_ = _tmp77_;
		_tmp79_ = gee_iterable_iterator ((GeeIterable*) _tmp78_);
		_tmp80_ = _tmp79_;
		_g_object_unref0 (_tmp78_);
		_key_it = _tmp80_;
		while (TRUE) {
			GeeIterator* _tmp81_;
			gboolean _tmp82_ = FALSE;
			GeeIterator* _tmp83_;
			gpointer _tmp84_ = NULL;
			gchar* key;
			gboolean _tmp85_ = FALSE;
			GeeHashMap* _tmp86_;
			const gchar* _tmp87_;
			gboolean _tmp88_ = FALSE;
			gboolean _tmp92_;
			_tmp81_ = _key_it;
			_tmp82_ = gee_iterator_next (_tmp81_);
			if (!_tmp82_) {
				break;
			}
			_tmp83_ = _key_it;
			_tmp84_ = gee_iterator_get (_tmp83_);
			key = (gchar*) _tmp84_;
			_tmp86_ = new_tnip_nodeid_table;
			_tmp87_ = key;
			_tmp88_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp86_, _tmp87_);
			if (!_tmp88_) {
				GeeArrayList* _tmp89_;
				const gchar* _tmp90_;
				gboolean _tmp91_ = FALSE;
				_tmp89_ = _declared_dead;
				_tmp90_ = key;
				_tmp91_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp89_, _tmp90_);
				_tmp85_ = !_tmp91_;
			} else {
				_tmp85_ = FALSE;
			}
			_tmp92_ = _tmp85_;
			if (_tmp92_) {
				gint times = 0;
				GeeHashMap* _tmp93_;
				const gchar* _tmp94_;
				gboolean _tmp95_ = FALSE;
				GeeHashMap* _tmp101_;
				const gchar* _tmp102_;
				gint _tmp103_;
				gboolean _tmp104_ = FALSE;
				gint _tmp105_;
				GeeHashMap* _tmp106_;
				gint _tmp107_;
				gint _tmp108_;
				gboolean _tmp111_;
				_tmp93_ = self->priv->missing_neighbour_keys;
				_tmp94_ = key;
				_tmp95_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp93_, _tmp94_);
				if (_tmp95_) {
					GeeHashMap* _tmp96_;
					const gchar* _tmp97_;
					gpointer _tmp98_ = NULL;
					_tmp96_ = self->priv->missing_neighbour_keys;
					_tmp97_ = key;
					_tmp98_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp96_, _tmp97_);
					times = ((gint) ((gintptr) _tmp98_)) + 1;
				} else {
					GeeArrayList* _tmp99_;
					const gchar* _tmp100_;
					times = 1;
					_tmp99_ = to_be_almost_deleted;
					_tmp100_ = key;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp99_, _tmp100_);
				}
				_tmp101_ = self->priv->missing_neighbour_keys;
				_tmp102_ = key;
				_tmp103_ = times;
				gee_abstract_map_set ((GeeAbstractMap*) _tmp101_, _tmp102_, (gpointer) ((gintptr) _tmp103_));
				_tmp105_ = self->priv->max_neighbours;
				_tmp106_ = new_tnip_nodeid_table;
				_tmp107_ = gee_abstract_map_get_size ((GeeMap*) _tmp106_);
				_tmp108_ = _tmp107_;
				if (_tmp105_ <= _tmp108_) {
					_tmp104_ = TRUE;
				} else {
					gint _tmp109_;
					gint _tmp110_;
					_tmp109_ = times;
					_tmp110_ = self->priv->number_of_scan_before_deleting;
					_tmp104_ = _tmp109_ > _tmp110_;
				}
				_tmp111_ = _tmp104_;
				if (_tmp111_) {
					GeeHashMap* _tmp112_;
					const gchar* _tmp113_;
					GeeArrayList* _tmp114_;
					const gchar* _tmp115_;
					_tmp112_ = self->priv->missing_neighbour_keys;
					_tmp113_ = key;
					gee_abstract_map_unset ((GeeAbstractMap*) _tmp112_, _tmp113_, NULL);
					_tmp114_ = to_be_deleted;
					_tmp115_ = key;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp114_, _tmp115_);
				}
			}
			_g_free0 (key);
		}
		_g_object_unref0 (_key_it);
	}
	{
		GeeHashMap* _tmp116_;
		GeeSet* _tmp117_;
		GeeSet* _tmp118_;
		GeeSet* _tmp119_;
		GeeIterator* _tmp120_ = NULL;
		GeeIterator* _tmp121_;
		GeeIterator* _key_it;
		_tmp116_ = new_tnip_nodeid_table;
		_tmp117_ = gee_abstract_map_get_keys ((GeeMap*) _tmp116_);
		_tmp118_ = _tmp117_;
		_tmp119_ = _tmp118_;
		_tmp120_ = gee_iterable_iterator ((GeeIterable*) _tmp119_);
		_tmp121_ = _tmp120_;
		_g_object_unref0 (_tmp119_);
		_key_it = _tmp121_;
		while (TRUE) {
			GeeIterator* _tmp122_;
			gboolean _tmp123_ = FALSE;
			GeeIterator* _tmp124_;
			gpointer _tmp125_ = NULL;
			gchar* key;
			GeeHashMap* _tmp126_;
			const gchar* _tmp127_;
			gpointer _tmp128_ = NULL;
			NetsukukuNeighbour* val;
			gboolean _tmp129_ = FALSE;
			GeeHashMap* _tmp130_;
			const gchar* _tmp131_;
			gboolean _tmp132_ = FALSE;
			gboolean _tmp136_;
			_tmp122_ = _key_it;
			_tmp123_ = gee_iterator_next (_tmp122_);
			if (!_tmp123_) {
				break;
			}
			_tmp124_ = _key_it;
			_tmp125_ = gee_iterator_get (_tmp124_);
			key = (gchar*) _tmp125_;
			_tmp126_ = new_tnip_nodeid_table;
			_tmp127_ = key;
			_tmp128_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp126_, _tmp127_);
			val = (NetsukukuNeighbour*) _tmp128_;
			_tmp130_ = self->priv->tnip_nodeid_table;
			_tmp131_ = key;
			_tmp132_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp130_, _tmp131_);
			if (!_tmp132_) {
				GeeArrayList* _tmp133_;
				const gchar* _tmp134_;
				gboolean _tmp135_ = FALSE;
				_tmp133_ = _declared_dead;
				_tmp134_ = key;
				_tmp135_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp133_, _tmp134_);
				_tmp129_ = !_tmp135_;
			} else {
				_tmp129_ = FALSE;
			}
			_tmp136_ = _tmp129_;
			if (_tmp136_) {
				GeeArrayList* _tmp137_;
				const gchar* _tmp138_;
				GeeArrayList* _tmp139_;
				NetsukukuNeighbour* _tmp140_;
				_tmp137_ = to_be_added_key;
				_tmp138_ = key;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp137_, _tmp138_);
				_tmp139_ = to_be_added_value;
				_tmp140_ = val;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp139_, _tmp140_);
			}
			_g_object_unref0 (val);
			_g_free0 (key);
		}
		_g_object_unref0 (_key_it);
	}
	{
		GeeHashMap* _tmp141_;
		GeeSet* _tmp142_;
		GeeSet* _tmp143_;
		GeeSet* _tmp144_;
		GeeIterator* _tmp145_ = NULL;
		GeeIterator* _tmp146_;
		GeeIterator* _key_it;
		_tmp141_ = new_tnip_nodeid_table;
		_tmp142_ = gee_abstract_map_get_keys ((GeeMap*) _tmp141_);
		_tmp143_ = _tmp142_;
		_tmp144_ = _tmp143_;
		_tmp145_ = gee_iterable_iterator ((GeeIterable*) _tmp144_);
		_tmp146_ = _tmp145_;
		_g_object_unref0 (_tmp144_);
		_key_it = _tmp146_;
		while (TRUE) {
			GeeIterator* _tmp147_;
			gboolean _tmp148_ = FALSE;
			GeeIterator* _tmp149_;
			gpointer _tmp150_ = NULL;
			gchar* key;
			GeeHashMap* _tmp151_;
			const gchar* _tmp152_;
			gpointer _tmp153_ = NULL;
			NetsukukuNeighbour* val_new;
			gboolean _tmp154_ = FALSE;
			GeeHashMap* _tmp155_;
			const gchar* _tmp156_;
			gboolean _tmp157_ = FALSE;
			gboolean _tmp161_;
			_tmp147_ = _key_it;
			_tmp148_ = gee_iterator_next (_tmp147_);
			if (!_tmp148_) {
				break;
			}
			_tmp149_ = _key_it;
			_tmp150_ = gee_iterator_get (_tmp149_);
			key = (gchar*) _tmp150_;
			_tmp151_ = new_tnip_nodeid_table;
			_tmp152_ = key;
			_tmp153_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp151_, _tmp152_);
			val_new = (NetsukukuNeighbour*) _tmp153_;
			_tmp155_ = self->priv->tnip_nodeid_table;
			_tmp156_ = key;
			_tmp157_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp155_, _tmp156_);
			if (_tmp157_) {
				GeeArrayList* _tmp158_;
				const gchar* _tmp159_;
				gboolean _tmp160_ = FALSE;
				_tmp158_ = _declared_dead;
				_tmp159_ = key;
				_tmp160_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp158_, _tmp159_);
				_tmp154_ = !_tmp160_;
			} else {
				_tmp154_ = FALSE;
			}
			_tmp161_ = _tmp154_;
			if (_tmp161_) {
				GeeArrayList* _tmp162_;
				const gchar* _tmp163_;
				gboolean _tmp164_ = FALSE;
				_tmp162_ = to_be_rem_changed_key;
				_tmp163_ = key;
				_tmp164_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp162_, _tmp163_);
				if (!_tmp164_) {
					GeeHashMap* _tmp165_;
					const gchar* _tmp166_;
					gpointer _tmp167_ = NULL;
					NetsukukuNeighbour* val;
					NetsukukuNeighbour* _tmp168_;
					NetsukukuNetworkID* _tmp169_;
					NetsukukuNetworkID* _tmp170_;
					NetsukukuNeighbour* _tmp171_;
					NetsukukuNetworkID* _tmp172_;
					NetsukukuNetworkID* _tmp173_;
					gboolean _tmp174_ = FALSE;
					_tmp165_ = self->priv->tnip_nodeid_table;
					_tmp166_ = key;
					_tmp167_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp165_, _tmp166_);
					val = (NetsukukuNeighbour*) _tmp167_;
					_tmp168_ = val;
					_tmp169_ = netsukuku_neighbour_get_netid (_tmp168_);
					_tmp170_ = _tmp169_;
					_tmp171_ = val_new;
					_tmp172_ = netsukuku_neighbour_get_netid (_tmp171_);
					_tmp173_ = _tmp172_;
					_tmp174_ = netsukuku_network_id_is_strictly_equal (_tmp170_, _tmp173_);
					if (!_tmp174_) {
						GeeArrayList* _tmp175_;
						const gchar* _tmp176_;
						GeeArrayList* _tmp177_;
						NetsukukuNeighbour* _tmp178_;
						_tmp175_ = to_be_attrib_changed_key;
						_tmp176_ = key;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp175_, _tmp176_);
						_tmp177_ = to_be_attrib_changed_value;
						_tmp178_ = val_new;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp177_, _tmp178_);
					} else {
						NetsukukuNeighbour* _tmp179_;
						gboolean _tmp180_;
						gboolean _tmp181_;
						NetsukukuNeighbour* _tmp182_;
						gboolean _tmp183_;
						gboolean _tmp184_;
						_tmp179_ = val;
						_tmp180_ = netsukuku_neighbour_get_is_primary (_tmp179_);
						_tmp181_ = _tmp180_;
						_tmp182_ = val_new;
						_tmp183_ = netsukuku_neighbour_get_is_primary (_tmp182_);
						_tmp184_ = _tmp183_;
						if (_tmp181_ != _tmp184_) {
							GeeArrayList* _tmp185_;
							const gchar* _tmp186_;
							GeeArrayList* _tmp187_;
							NetsukukuNeighbour* _tmp188_;
							_tmp185_ = to_be_attrib_changed_key;
							_tmp186_ = key;
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp185_, _tmp186_);
							_tmp187_ = to_be_attrib_changed_value;
							_tmp188_ = val_new;
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp187_, _tmp188_);
						} else {
							gboolean _tmp189_ = FALSE;
							NetsukukuNeighbour* _tmp190_;
							NetsukukuREM* _tmp191_;
							NetsukukuREM* _tmp192_;
							GType _tmp193_ = 0UL;
							gboolean _tmp198_;
							_tmp190_ = val_new;
							_tmp191_ = netsukuku_neighbour_get_rem (_tmp190_);
							_tmp192_ = _tmp191_;
							_tmp193_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp192_);
							if (_tmp193_ == NETSUKUKU_TYPE_RTT) {
								NetsukukuNeighbour* _tmp194_;
								NetsukukuREM* _tmp195_;
								NetsukukuREM* _tmp196_;
								GType _tmp197_ = 0UL;
								_tmp194_ = val;
								_tmp195_ = netsukuku_neighbour_get_rem (_tmp194_);
								_tmp196_ = _tmp195_;
								_tmp197_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp196_);
								_tmp189_ = _tmp197_ == NETSUKUKU_TYPE_RTT;
							} else {
								_tmp189_ = FALSE;
							}
							_tmp198_ = _tmp189_;
							if (_tmp198_) {
								NetsukukuNeighbour* _tmp199_;
								NetsukukuREM* _tmp200_;
								NetsukukuREM* _tmp201_;
								gint _tmp202_;
								gint _tmp203_;
								gint new_rtt;
								NetsukukuNeighbour* _tmp204_;
								NetsukukuREM* _tmp205_;
								NetsukukuREM* _tmp206_;
								gint _tmp207_;
								gint _tmp208_;
								gint old_rtt;
								gdouble rtt_variation;
								gint _tmp209_;
								gint _tmp210_;
								gdouble _tmp217_;
								gdouble _tmp218_;
								_tmp199_ = val_new;
								_tmp200_ = netsukuku_neighbour_get_rem (_tmp199_);
								_tmp201_ = _tmp200_;
								_tmp202_ = netsukuku_rtt_get_delay (G_TYPE_CHECK_INSTANCE_CAST (_tmp201_, NETSUKUKU_TYPE_RTT, NetsukukuRTT));
								_tmp203_ = _tmp202_;
								new_rtt = _tmp203_;
								_tmp204_ = val;
								_tmp205_ = netsukuku_neighbour_get_rem (_tmp204_);
								_tmp206_ = _tmp205_;
								_tmp207_ = netsukuku_rtt_get_delay (G_TYPE_CHECK_INSTANCE_CAST (_tmp206_, NETSUKUKU_TYPE_RTT, NetsukukuRTT));
								_tmp208_ = _tmp207_;
								old_rtt = _tmp208_;
								rtt_variation = (gdouble) 0;
								_tmp209_ = new_rtt;
								_tmp210_ = old_rtt;
								if (_tmp209_ > _tmp210_) {
									gint _tmp211_;
									gint _tmp212_;
									gint _tmp213_;
									_tmp211_ = new_rtt;
									_tmp212_ = old_rtt;
									_tmp213_ = new_rtt;
									rtt_variation = (_tmp211_ - _tmp212_) / ((gdouble) _tmp213_);
								} else {
									gint _tmp214_;
									gint _tmp215_;
									gint _tmp216_;
									_tmp214_ = old_rtt;
									_tmp215_ = new_rtt;
									_tmp216_ = old_rtt;
									rtt_variation = (_tmp214_ - _tmp215_) / ((gdouble) _tmp216_);
								}
								_tmp217_ = rtt_variation;
								_tmp218_ = self->priv->rtt_variation_threshold;
								if (_tmp217_ > _tmp218_) {
									GeeArrayList* _tmp219_;
									const gchar* _tmp220_;
									GeeArrayList* _tmp221_;
									NetsukukuNeighbour* _tmp222_;
									_tmp219_ = to_be_rem_changed_key;
									_tmp220_ = key;
									gee_abstract_collection_add ((GeeAbstractCollection*) _tmp219_, _tmp220_);
									_tmp221_ = to_be_rem_changed_value;
									_tmp222_ = val_new;
									gee_abstract_collection_add ((GeeAbstractCollection*) _tmp221_, _tmp222_);
								}
							}
						}
					}
					_g_object_unref0 (val);
				}
			}
			_g_object_unref0 (val_new);
			_g_free0 (key);
		}
		_g_object_unref0 (_key_it);
	}
	{
		GeeArrayList* _tmp223_;
		GeeArrayList* _tmp224_;
		GeeArrayList* _key_list;
		GeeArrayList* _tmp225_;
		gint _tmp226_;
		gint _tmp227_;
		gint _key_size;
		gint _key_index;
		_tmp223_ = _declared_dead;
		_tmp224_ = _g_object_ref0 (_tmp223_);
		_key_list = _tmp224_;
		_tmp225_ = _key_list;
		_tmp226_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp225_);
		_tmp227_ = _tmp226_;
		_key_size = _tmp227_;
		_key_index = -1;
		while (TRUE) {
			gint _tmp228_;
			gint _tmp229_;
			gint _tmp230_;
			GeeArrayList* _tmp231_;
			gint _tmp232_;
			gpointer _tmp233_ = NULL;
			gchar* key;
			const gchar* _tmp234_;
			_tmp228_ = _key_index;
			_key_index = _tmp228_ + 1;
			_tmp229_ = _key_index;
			_tmp230_ = _key_size;
			if (!(_tmp229_ < _tmp230_)) {
				break;
			}
			_tmp231_ = _key_list;
			_tmp232_ = _key_index;
			_tmp233_ = gee_abstract_list_get ((GeeAbstractList*) _tmp231_, _tmp232_);
			key = (gchar*) _tmp233_;
			_tmp234_ = key;
			netsukuku_neighbour_manager_store_delete_neighbour (self, _tmp234_);
			_g_free0 (key);
		}
		_g_object_unref0 (_key_list);
	}
	{
		GeeArrayList* _tmp235_;
		GeeArrayList* _tmp236_;
		GeeArrayList* _key_list;
		GeeArrayList* _tmp237_;
		gint _tmp238_;
		gint _tmp239_;
		gint _key_size;
		gint _key_index;
		_tmp235_ = to_be_deleted;
		_tmp236_ = _g_object_ref0 (_tmp235_);
		_key_list = _tmp236_;
		_tmp237_ = _key_list;
		_tmp238_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp237_);
		_tmp239_ = _tmp238_;
		_key_size = _tmp239_;
		_key_index = -1;
		while (TRUE) {
			gint _tmp240_;
			gint _tmp241_;
			gint _tmp242_;
			GeeArrayList* _tmp243_;
			gint _tmp244_;
			gpointer _tmp245_ = NULL;
			gchar* key;
			const gchar* _tmp246_;
			_tmp240_ = _key_index;
			_key_index = _tmp240_ + 1;
			_tmp241_ = _key_index;
			_tmp242_ = _key_size;
			if (!(_tmp241_ < _tmp242_)) {
				break;
			}
			_tmp243_ = _key_list;
			_tmp244_ = _key_index;
			_tmp245_ = gee_abstract_list_get ((GeeAbstractList*) _tmp243_, _tmp244_);
			key = (gchar*) _tmp245_;
			_tmp246_ = key;
			netsukuku_neighbour_manager_store_delete_neighbour (self, _tmp246_);
			_g_free0 (key);
		}
		_g_object_unref0 (_key_list);
	}
	_tmp247_ = to_be_added_key;
	_tmp248_ = gee_abstract_list_list_iterator ((GeeAbstractList*) _tmp247_);
	_g_object_unref0 (keys);
	keys = _tmp248_;
	_tmp249_ = keys;
	_tmp250_ = gee_iterator_next ((GeeIterator*) _tmp249_);
	hascur = _tmp250_;
	_tmp251_ = to_be_added_value;
	_tmp252_ = gee_abstract_list_list_iterator ((GeeAbstractList*) _tmp251_);
	_g_object_unref0 (values);
	values = _tmp252_;
	_tmp253_ = values;
	gee_iterator_next ((GeeIterator*) _tmp253_);
	while (TRUE) {
		gboolean _tmp254_;
		GeeListIterator* _tmp255_;
		gpointer _tmp256_ = NULL;
		gchar* key;
		GeeListIterator* _tmp257_;
		gpointer _tmp258_ = NULL;
		NetsukukuNeighbour* val;
		const gchar* _tmp259_;
		NetsukukuNeighbour* _tmp260_;
		GeeListIterator* _tmp261_;
		gboolean _tmp262_ = FALSE;
		GeeListIterator* _tmp263_;
		_tmp254_ = hascur;
		if (!_tmp254_) {
			break;
		}
		_tmp255_ = keys;
		_tmp256_ = gee_iterator_get ((GeeIterator*) _tmp255_);
		key = (gchar*) _tmp256_;
		_tmp257_ = values;
		_tmp258_ = gee_iterator_get ((GeeIterator*) _tmp257_);
		val = (NetsukukuNeighbour*) _tmp258_;
		_tmp259_ = key;
		_tmp260_ = val;
		netsukuku_neighbour_manager_store_add_neighbour (self, _tmp259_, _tmp260_);
		_tmp261_ = keys;
		_tmp262_ = gee_iterator_next ((GeeIterator*) _tmp261_);
		hascur = _tmp262_;
		_tmp263_ = values;
		gee_iterator_next ((GeeIterator*) _tmp263_);
		_g_object_unref0 (val);
		_g_free0 (key);
	}
	_tmp264_ = to_be_rem_changed_key;
	_tmp265_ = gee_abstract_list_list_iterator ((GeeAbstractList*) _tmp264_);
	_g_object_unref0 (keys);
	keys = _tmp265_;
	_tmp266_ = keys;
	_tmp267_ = gee_iterator_next ((GeeIterator*) _tmp266_);
	hascur = _tmp267_;
	_tmp268_ = to_be_rem_changed_value;
	_tmp269_ = gee_abstract_list_list_iterator ((GeeAbstractList*) _tmp268_);
	_g_object_unref0 (values);
	values = _tmp269_;
	_tmp270_ = values;
	gee_iterator_next ((GeeIterator*) _tmp270_);
	while (TRUE) {
		gboolean _tmp271_;
		GeeListIterator* _tmp272_;
		gpointer _tmp273_ = NULL;
		gchar* key;
		GeeListIterator* _tmp274_;
		gpointer _tmp275_ = NULL;
		NetsukukuNeighbour* val;
		const gchar* _tmp276_;
		NetsukukuNeighbour* _tmp277_;
		GeeListIterator* _tmp278_;
		gboolean _tmp279_ = FALSE;
		GeeListIterator* _tmp280_;
		_tmp271_ = hascur;
		if (!_tmp271_) {
			break;
		}
		_tmp272_ = keys;
		_tmp273_ = gee_iterator_get ((GeeIterator*) _tmp272_);
		key = (gchar*) _tmp273_;
		_tmp274_ = values;
		_tmp275_ = gee_iterator_get ((GeeIterator*) _tmp274_);
		val = (NetsukukuNeighbour*) _tmp275_;
		_tmp276_ = key;
		_tmp277_ = val;
		netsukuku_neighbour_manager_store_changed_rem_neighbour (self, _tmp276_, _tmp277_);
		_tmp278_ = keys;
		_tmp279_ = gee_iterator_next ((GeeIterator*) _tmp278_);
		hascur = _tmp279_;
		_tmp280_ = values;
		gee_iterator_next ((GeeIterator*) _tmp280_);
		_g_object_unref0 (val);
		_g_free0 (key);
	}
	_tmp281_ = to_be_attrib_changed_key;
	_tmp282_ = gee_abstract_list_list_iterator ((GeeAbstractList*) _tmp281_);
	_g_object_unref0 (keys);
	keys = _tmp282_;
	_tmp283_ = keys;
	_tmp284_ = gee_iterator_next ((GeeIterator*) _tmp283_);
	hascur = _tmp284_;
	_tmp285_ = to_be_attrib_changed_value;
	_tmp286_ = gee_abstract_list_list_iterator ((GeeAbstractList*) _tmp285_);
	_g_object_unref0 (values);
	values = _tmp286_;
	_tmp287_ = values;
	gee_iterator_next ((GeeIterator*) _tmp287_);
	while (TRUE) {
		gboolean _tmp288_;
		GeeListIterator* _tmp289_;
		gpointer _tmp290_ = NULL;
		gchar* key;
		GeeListIterator* _tmp291_;
		gpointer _tmp292_ = NULL;
		NetsukukuNeighbour* val;
		const gchar* _tmp293_;
		NetsukukuNeighbour* _tmp294_;
		GeeListIterator* _tmp295_;
		gboolean _tmp296_ = FALSE;
		GeeListIterator* _tmp297_;
		_tmp288_ = hascur;
		if (!_tmp288_) {
			break;
		}
		_tmp289_ = keys;
		_tmp290_ = gee_iterator_get ((GeeIterator*) _tmp289_);
		key = (gchar*) _tmp290_;
		_tmp291_ = values;
		_tmp292_ = gee_iterator_get ((GeeIterator*) _tmp291_);
		val = (NetsukukuNeighbour*) _tmp292_;
		_tmp293_ = key;
		_tmp294_ = val;
		netsukuku_neighbour_manager_store_changed_attrib_neighbour (self, _tmp293_, _tmp294_);
		_tmp295_ = keys;
		_tmp296_ = gee_iterator_next ((GeeIterator*) _tmp295_);
		hascur = _tmp296_;
		_tmp297_ = values;
		gee_iterator_next ((GeeIterator*) _tmp297_);
		_g_object_unref0 (val);
		_g_free0 (key);
	}
	{
		GeeArrayList* _tmp298_;
		GeeArrayList* _tmp299_;
		GeeArrayList* _key_list;
		GeeArrayList* _tmp300_;
		gint _tmp301_;
		gint _tmp302_;
		gint _key_size;
		gint _key_index;
		_tmp298_ = to_be_almost_deleted;
		_tmp299_ = _g_object_ref0 (_tmp298_);
		_key_list = _tmp299_;
		_tmp300_ = _key_list;
		_tmp301_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp300_);
		_tmp302_ = _tmp301_;
		_key_size = _tmp302_;
		_key_index = -1;
		while (TRUE) {
			gint _tmp303_;
			gint _tmp304_;
			gint _tmp305_;
			GeeArrayList* _tmp306_;
			gint _tmp307_;
			gpointer _tmp308_ = NULL;
			gchar* key;
			GeeHashMap* _tmp309_;
			const gchar* _tmp310_;
			gpointer _tmp311_ = NULL;
			NetsukukuNeighbour* old_val;
			NetsukukuNeighbour* _tmp312_;
			gint _tmp313_;
			gint _tmp314_;
			NetsukukuNeighbour* _tmp315_;
			gint _tmp316_;
			gint _tmp317_;
			NetsukukuNeighbour* _tmp318_;
			NetsukukuNIP* _tmp319_;
			NetsukukuNIP* _tmp320_;
			NetsukukuNeighbour* _tmp321_;
			gint _tmp322_;
			gint _tmp323_;
			NetsukukuNeighbour* _tmp324_;
			NetsukukuNetworkID* _tmp325_;
			NetsukukuNetworkID* _tmp326_;
			NetsukukuNeighbour* _tmp327_;
			gboolean _tmp328_;
			gboolean _tmp329_;
			NetsukukuNeighbour* _tmp330_;
			gboolean _tmp331_;
			gboolean _tmp332_;
			NetsukukuNeighbour* _tmp333_;
			const gchar* _tmp334_;
			const gchar* _tmp335_;
			NetsukukuNeighbour* _tmp336_;
			GeeList* _tmp337_ = NULL;
			GeeList* _tmp338_;
			NetsukukuAlmostDeadREM* _tmp339_;
			NetsukukuAlmostDeadREM* _tmp340_;
			NetsukukuNeighbour* _tmp341_;
			NetsukukuNeighbour* _tmp342_;
			NetsukukuNeighbour* val;
			const gchar* _tmp343_;
			NetsukukuNeighbour* _tmp344_;
			_tmp303_ = _key_index;
			_key_index = _tmp303_ + 1;
			_tmp304_ = _key_index;
			_tmp305_ = _key_size;
			if (!(_tmp304_ < _tmp305_)) {
				break;
			}
			_tmp306_ = _key_list;
			_tmp307_ = _key_index;
			_tmp308_ = gee_abstract_list_get ((GeeAbstractList*) _tmp306_, _tmp307_);
			key = (gchar*) _tmp308_;
			_tmp309_ = self->priv->tnip_nodeid_table;
			_tmp310_ = key;
			_tmp311_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp309_, _tmp310_);
			old_val = (NetsukukuNeighbour*) _tmp311_;
			_tmp312_ = old_val;
			_tmp313_ = netsukuku_neighbour_get_levels (_tmp312_);
			_tmp314_ = _tmp313_;
			_tmp315_ = old_val;
			_tmp316_ = netsukuku_neighbour_get_gsize (_tmp315_);
			_tmp317_ = _tmp316_;
			_tmp318_ = old_val;
			_tmp319_ = netsukuku_neighbour_get_nip (_tmp318_);
			_tmp320_ = _tmp319_;
			_tmp321_ = old_val;
			_tmp322_ = netsukuku_neighbour_get_nodeid (_tmp321_);
			_tmp323_ = _tmp322_;
			_tmp324_ = old_val;
			_tmp325_ = netsukuku_neighbour_get_netid (_tmp324_);
			_tmp326_ = _tmp325_;
			_tmp327_ = old_val;
			_tmp328_ = netsukuku_neighbour_get_is_primary (_tmp327_);
			_tmp329_ = _tmp328_;
			_tmp330_ = old_val;
			_tmp331_ = netsukuku_neighbour_get_is_auxiliary (_tmp330_);
			_tmp332_ = _tmp331_;
			_tmp333_ = old_val;
			_tmp334_ = netsukuku_neighbour_get_dev (_tmp333_);
			_tmp335_ = _tmp334_;
			_tmp336_ = old_val;
			_tmp337_ = netsukuku_neighbour_get_macs (_tmp336_);
			_tmp338_ = _tmp337_;
			_tmp339_ = netsukuku_almost_dead_rem_new ();
			_tmp340_ = _tmp339_;
			_tmp341_ = netsukuku_neighbour_new_with_rem (_tmp314_, _tmp317_, _tmp320_, _tmp323_, _tmp326_, _tmp329_, _tmp332_, _tmp335_, _tmp338_, (NetsukukuREM*) _tmp340_);
			_tmp342_ = _tmp341_;
			_g_object_unref0 (_tmp340_);
			_g_object_unref0 (_tmp338_);
			val = _tmp342_;
			_tmp343_ = key;
			_tmp344_ = val;
			netsukuku_neighbour_manager_store_changed_rem_neighbour (self, _tmp343_, _tmp344_);
			_g_object_unref0 (val);
			_g_object_unref0 (old_val);
			_g_free0 (key);
		}
		_g_object_unref0 (_key_list);
	}
	_g_object_unref0 (values);
	_g_object_unref0 (keys);
	_g_object_unref0 (to_be_attrib_changed_value);
	_g_object_unref0 (to_be_attrib_changed_key);
	_g_object_unref0 (to_be_rem_changed_value);
	_g_object_unref0 (to_be_rem_changed_key);
	_g_object_unref0 (to_be_added_value);
	_g_object_unref0 (to_be_added_key);
	_g_object_unref0 (to_be_almost_deleted);
	_g_object_unref0 (to_be_deleted);
	_g_object_unref0 (new_tnip_nodeid_table_keys);
	_g_object_unref0 (new_tnip_nodeid_table);
	_g_object_unref0 (_declared_dead);
}


static void* netsukuku_neighbour_manager_helper_store (void* v, GError** error) {
	void* result = NULL;
	void* _tmp0_;
	Netsukukustruct_helper_NeighbourManager_store* tuple_p;
	NetsukukuNeighbourManager* _tmp1_;
	NetsukukuNeighbourManager* _tmp2_;
	NetsukukuNeighbourManager* self_save;
	GeeHashMap* _tmp3_;
	GeeHashMap* _tmp4_;
	GeeHashMap* detected_neighbours_save;
	gint _tmp5_;
	gint bouquet_numb_save;
	GError * _inner_error_ = NULL;
	_tmp0_ = v;
	tuple_p = (Netsukukustruct_helper_NeighbourManager_store*) _tmp0_;
	_tmp1_ = (*tuple_p).self;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	self_save = _tmp2_;
	_tmp3_ = (*tuple_p).detected_neighbours;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	detected_neighbours_save = _tmp4_;
	_tmp5_ = (*tuple_p).bouquet_numb;
	bouquet_numb_save = _tmp5_;
	tasklets_tasklet_schedule_back ();
	netsukuku_neighbour_manager_impl_store (self_save, bouquet_numb_save, detected_neighbours_save, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (detected_neighbours_save);
		_g_object_unref0 (self_save);
		return NULL;
	}
	result = NULL;
	_g_object_unref0 (detected_neighbours_save);
	_g_object_unref0 (self_save);
	return result;
}


void netsukuku_neighbour_manager_store (NetsukukuNeighbourManager* self, gint bouquet_numb, GeeHashMap* detected_neighbours) {
	Netsukukustruct_helper_NeighbourManager_store arg = {0};
	NetsukukuNeighbourManager* _tmp0_;
	gint _tmp1_;
	GeeHashMap* _tmp2_;
	GeeHashMap* _tmp3_;
	TaskletsTasklet* _tmp4_ = NULL;
	TaskletsTasklet* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (detected_neighbours != NULL);
	memset (&arg, 0, sizeof (Netsukukustruct_helper_NeighbourManager_store));
	_tmp0_ = _g_object_ref0 (self);
	_g_object_unref0 (arg.self);
	arg.self = _tmp0_;
	_tmp1_ = bouquet_numb;
	arg.bouquet_numb = _tmp1_;
	_tmp2_ = detected_neighbours;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (arg.detected_neighbours);
	arg.detected_neighbours = _tmp3_;
	_tmp4_ = tasklets_tasklet_spawn ((TaskletsSpawnable) netsukuku_neighbour_manager_helper_store, &arg, FALSE, -1);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp5_);
	netsukuku_struct_helper_neighbourmanager_store_destroy (&arg);
}


/** No more radar. Deletes all neighbours. Updates internal data structures
          * and notify about the changes.
          */
void netsukuku_neighbour_manager_empty (NetsukukuNeighbourManager* self) {
	GeeArrayList* _tmp0_;
	GeeArrayList* keys;
	GeeArrayList* _tmp1_;
	GeeHashMap* _tmp2_;
	GeeSet* _tmp3_;
	GeeSet* _tmp4_;
	GeeSet* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	keys = _tmp0_;
	_tmp1_ = keys;
	_tmp2_ = self->priv->tnip_nodeid_table;
	_tmp3_ = gee_abstract_map_get_keys ((GeeMap*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	gee_array_list_add_all (_tmp1_, (GeeCollection*) _tmp5_);
	_g_object_unref0 (_tmp5_);
	{
		GeeArrayList* _tmp6_;
		GeeArrayList* _tmp7_;
		GeeArrayList* _key_list;
		GeeArrayList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _key_size;
		gint _key_index;
		_tmp6_ = keys;
		_tmp7_ = _g_object_ref0 (_tmp6_);
		_key_list = _tmp7_;
		_tmp8_ = _key_list;
		_tmp9_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp8_);
		_tmp10_ = _tmp9_;
		_key_size = _tmp10_;
		_key_index = -1;
		while (TRUE) {
			gint _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			GeeArrayList* _tmp14_;
			gint _tmp15_;
			gpointer _tmp16_ = NULL;
			gchar* key;
			const gchar* _tmp17_;
			_tmp11_ = _key_index;
			_key_index = _tmp11_ + 1;
			_tmp12_ = _key_index;
			_tmp13_ = _key_size;
			if (!(_tmp12_ < _tmp13_)) {
				break;
			}
			_tmp14_ = _key_list;
			_tmp15_ = _key_index;
			_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) _tmp14_, _tmp15_);
			key = (gchar*) _tmp16_;
			_tmp17_ = key;
			netsukuku_neighbour_manager_store_delete_neighbour (self, _tmp17_);
			_g_free0 (key);
		}
		_g_object_unref0 (_key_list);
	}
	_g_object_unref0 (keys);
}


/** Emits signal BEFORE a new neighbour.
          */
void netsukuku_neighbour_manager_going_add (NetsukukuNeighbourManager* self, NetsukukuNeighbour* neighbour) {
	NetsukukuNeighbour* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	NetsukukuNeighbour* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	NetsukukuNeighbour* _tmp6_;
	NetsukukuNIP* _tmp7_;
	NetsukukuNIP* _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* ipstr;
	NetsukukuNeighbour* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (neighbour != NULL);
	_tmp0_ = neighbour;
	_tmp1_ = netsukuku_neighbour_get_levels (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = neighbour;
	_tmp4_ = netsukuku_neighbour_get_gsize (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = neighbour;
	_tmp7_ = netsukuku_neighbour_get_nip (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = netsukuku_nip_to_str (_tmp2_, _tmp5_, _tmp8_);
	ipstr = _tmp9_;
	_tmp10_ = neighbour;
	g_signal_emit_by_name (self, "neighbour-going-new", _tmp10_);
	_g_free0 (ipstr);
}


/** Emits signal BEFORE a dead neighbour.
          */
void netsukuku_neighbour_manager_going_delete (NetsukukuNeighbourManager* self, NetsukukuNeighbour* neighbour) {
	NetsukukuNeighbour* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	NetsukukuNeighbour* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	NetsukukuNeighbour* _tmp6_;
	NetsukukuNIP* _tmp7_;
	NetsukukuNIP* _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* ipstr;
	NetsukukuNeighbour* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (neighbour != NULL);
	_tmp0_ = neighbour;
	_tmp1_ = netsukuku_neighbour_get_levels (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = neighbour;
	_tmp4_ = netsukuku_neighbour_get_gsize (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = neighbour;
	_tmp7_ = netsukuku_neighbour_get_nip (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = netsukuku_nip_to_str (_tmp2_, _tmp5_, _tmp8_);
	ipstr = _tmp9_;
	_tmp10_ = neighbour;
	g_signal_emit_by_name (self, "neighbour-going-deleted", _tmp10_);
	_g_free0 (ipstr);
}


/** Emits signal BEFORE a changed rem neighbour.
          */
void netsukuku_neighbour_manager_going_rem_change (NetsukukuNeighbourManager* self, NetsukukuNeighbour* neighbour) {
	NetsukukuNeighbour* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	NetsukukuNeighbour* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	NetsukukuNeighbour* _tmp6_;
	NetsukukuNIP* _tmp7_;
	NetsukukuNIP* _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* ipstr;
	NetsukukuNeighbour* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (neighbour != NULL);
	_tmp0_ = neighbour;
	_tmp1_ = netsukuku_neighbour_get_levels (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = neighbour;
	_tmp4_ = netsukuku_neighbour_get_gsize (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = neighbour;
	_tmp7_ = netsukuku_neighbour_get_nip (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = netsukuku_nip_to_str (_tmp2_, _tmp5_, _tmp8_);
	ipstr = _tmp9_;
	_tmp10_ = neighbour;
	g_signal_emit_by_name (self, "neighbour-going-rem-chged", _tmp10_);
	_g_free0 (ipstr);
}


/** Emits signal for a new neighbour.
          */
void netsukuku_neighbour_manager_add_neighbour (NetsukukuNeighbourManager* self, const gchar* key) {
	GeeHashMap* _tmp0_;
	const gchar* _tmp1_;
	gpointer _tmp2_ = NULL;
	NetsukukuNeighbour* neighbour;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	NetsukukuNIP* _tmp7_;
	NetsukukuNIP* _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* ipstr;
	const gchar* _tmp10_ = NULL;
	NetsukukuNetworkID* _tmp11_;
	NetsukukuNetworkID* _tmp12_;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_;
	const gchar* _tmp20_ = NULL;
	NetsukukuNetworkID* _tmp21_;
	NetsukukuNetworkID* _tmp22_;
	gchar* _tmp23_ = NULL;
	gchar* _tmp24_;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_ = NULL;
	gchar* _tmp28_ = NULL;
	gchar* _tmp29_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = self->priv->tnip_nodeid_table;
	_tmp1_ = key;
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, _tmp1_);
	neighbour = (NetsukukuNeighbour*) _tmp2_;
	_tmp3_ = netsukuku_neighbour_get_levels (neighbour);
	_tmp4_ = _tmp3_;
	_tmp5_ = netsukuku_neighbour_get_gsize (neighbour);
	_tmp6_ = _tmp5_;
	_tmp7_ = netsukuku_neighbour_get_nip (neighbour);
	_tmp8_ = _tmp7_;
	_tmp9_ = netsukuku_nip_to_str (_tmp4_, _tmp6_, _tmp8_);
	ipstr = _tmp9_;
	_tmp10_ = string_to_string (ipstr);
	_tmp11_ = netsukuku_neighbour_get_netid (neighbour);
	_tmp12_ = _tmp11_;
	_tmp13_ = netsukuku_network_id_to_string (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = netsukuku_neighbour_get_dev (neighbour);
	_tmp16_ = _tmp15_;
	_tmp17_ = string_to_string (_tmp16_);
	_tmp18_ = g_strconcat ("NeighbourManager: emit NEIGHBOUR_NEW for ip ", _tmp10_, ", netid ", _tmp14_, " dev ", _tmp17_, NULL);
	_tmp19_ = _tmp18_;
	netsukuku_log_debug (_tmp19_);
	_g_free0 (_tmp19_);
	_g_free0 (_tmp14_);
	_tmp20_ = string_to_string (ipstr);
	_tmp21_ = netsukuku_neighbour_get_netid (neighbour);
	_tmp22_ = _tmp21_;
	_tmp23_ = netsukuku_network_id_to_string (_tmp22_);
	_tmp24_ = _tmp23_;
	_tmp25_ = netsukuku_neighbour_get_dev (neighbour);
	_tmp26_ = _tmp25_;
	_tmp27_ = string_to_string (_tmp26_);
	_tmp28_ = g_strconcat ("NeighbourManager: emit NEIGHBOUR_NEW for ip ", _tmp20_, ", netid ", _tmp24_, " dev ", _tmp27_, NULL);
	_tmp29_ = _tmp28_;
	netsukuku_log_verbose (_tmp29_);
	_g_free0 (_tmp29_);
	_g_free0 (_tmp24_);
	g_signal_emit_by_name (self, "neighbour-new", neighbour);
	_g_free0 (ipstr);
	_g_object_unref0 (neighbour);
}


/** Emits signal for a dead neighbour.
          */
void netsukuku_neighbour_manager_delete_neighbour (NetsukukuNeighbourManager* self, const gchar* key, NetsukukuNeighbour* old_val) {
	NetsukukuNeighbour* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	NetsukukuNeighbour* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	NetsukukuNeighbour* _tmp6_;
	NetsukukuNIP* _tmp7_;
	NetsukukuNIP* _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* ipstr;
	const gchar* _tmp10_ = NULL;
	NetsukukuNeighbour* _tmp11_;
	NetsukukuNetworkID* _tmp12_;
	NetsukukuNetworkID* _tmp13_;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_;
	NetsukukuNeighbour* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_;
	const gchar* _tmp22_ = NULL;
	NetsukukuNeighbour* _tmp23_;
	NetsukukuNetworkID* _tmp24_;
	NetsukukuNetworkID* _tmp25_;
	gchar* _tmp26_ = NULL;
	gchar* _tmp27_;
	NetsukukuNeighbour* _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	const gchar* _tmp31_ = NULL;
	gchar* _tmp32_ = NULL;
	gchar* _tmp33_;
	NetsukukuNeighbour* _tmp34_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (old_val != NULL);
	_tmp0_ = old_val;
	_tmp1_ = netsukuku_neighbour_get_levels (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = old_val;
	_tmp4_ = netsukuku_neighbour_get_gsize (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = old_val;
	_tmp7_ = netsukuku_neighbour_get_nip (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = netsukuku_nip_to_str (_tmp2_, _tmp5_, _tmp8_);
	ipstr = _tmp9_;
	_tmp10_ = string_to_string (ipstr);
	_tmp11_ = old_val;
	_tmp12_ = netsukuku_neighbour_get_netid (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = netsukuku_network_id_to_string (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = old_val;
	_tmp17_ = netsukuku_neighbour_get_dev (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = string_to_string (_tmp18_);
	_tmp20_ = g_strconcat ("NeighbourManager: emit NEIGHBOUR_DELETED for ip ", _tmp10_, ", netid ", _tmp15_, " dev ", _tmp19_, NULL);
	_tmp21_ = _tmp20_;
	netsukuku_log_debug (_tmp21_);
	_g_free0 (_tmp21_);
	_g_free0 (_tmp15_);
	_tmp22_ = string_to_string (ipstr);
	_tmp23_ = old_val;
	_tmp24_ = netsukuku_neighbour_get_netid (_tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = netsukuku_network_id_to_string (_tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = old_val;
	_tmp29_ = netsukuku_neighbour_get_dev (_tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = string_to_string (_tmp30_);
	_tmp32_ = g_strconcat ("NeighbourManager: emit NEIGHBOUR_DELETED for ip ", _tmp22_, ", netid ", _tmp27_, " dev ", _tmp31_, NULL);
	_tmp33_ = _tmp32_;
	netsukuku_log_verbose (_tmp33_);
	_g_free0 (_tmp33_);
	_g_free0 (_tmp27_);
	_tmp34_ = old_val;
	g_signal_emit_by_name (self, "neighbour-deleted", _tmp34_);
	_g_free0 (ipstr);
}


/** Emits signal for a changed rem neighbour.
          */
void netsukuku_neighbour_manager_rem_change_neighbour (NetsukukuNeighbourManager* self, const gchar* key, NetsukukuREM* old_rem) {
	GeeHashMap* _tmp0_;
	const gchar* _tmp1_;
	gpointer _tmp2_ = NULL;
	NetsukukuNeighbour* neighbour;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	NetsukukuNIP* _tmp7_;
	NetsukukuNIP* _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* ipstr;
	NetsukukuREM* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (old_rem != NULL);
	_tmp0_ = self->priv->tnip_nodeid_table;
	_tmp1_ = key;
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, _tmp1_);
	neighbour = (NetsukukuNeighbour*) _tmp2_;
	_tmp3_ = netsukuku_neighbour_get_levels (neighbour);
	_tmp4_ = _tmp3_;
	_tmp5_ = netsukuku_neighbour_get_gsize (neighbour);
	_tmp6_ = _tmp5_;
	_tmp7_ = netsukuku_neighbour_get_nip (neighbour);
	_tmp8_ = _tmp7_;
	_tmp9_ = netsukuku_nip_to_str (_tmp4_, _tmp6_, _tmp8_);
	ipstr = _tmp9_;
	_tmp10_ = old_rem;
	g_signal_emit_by_name (self, "neighbour-rem-chged", neighbour, _tmp10_);
	_g_free0 (ipstr);
	_g_object_unref0 (neighbour);
}


NetsukukuRadar* netsukuku_neighbour_manager_get_radar (NetsukukuNeighbourManager* self) {
	NetsukukuRadar* result;
	NetsukukuRadar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_radar;
	result = _tmp0_;
	return result;
}


void netsukuku_neighbour_manager_set_radar (NetsukukuNeighbourManager* self, NetsukukuRadar* value) {
	NetsukukuRadar* _tmp0_;
	NetsukukuRadar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_radar);
	self->priv->_radar = _tmp1_;
	g_object_notify ((GObject *) self, "radar");
}


static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), data2);
}


static void netsukuku_neighbour_manager_class_init (NetsukukuNeighbourManagerClass * klass) {
	netsukuku_neighbour_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (NetsukukuNeighbourManagerPrivate));
	NETSUKUKU_NEIGHBOUR_MANAGER_CLASS (klass)->neighbour_list = netsukuku_neighbour_manager_real_neighbour_list;
	NETSUKUKU_NEIGHBOUR_MANAGER_CLASS (klass)->declare_dead = netsukuku_neighbour_manager_real_declare_dead;
	G_OBJECT_CLASS (klass)->get_property = _vala_netsukuku_neighbour_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_netsukuku_neighbour_manager_set_property;
	G_OBJECT_CLASS (klass)->finalize = netsukuku_neighbour_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETSUKUKU_NEIGHBOUR_MANAGER_RADAR, g_param_spec_object ("radar", "radar", "radar", NETSUKUKU_TYPE_RADAR, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("neighbour_new", NETSUKUKU_TYPE_NEIGHBOUR_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, NETSUKUKU_TYPE_NEIGHBOUR);
	g_signal_new ("neighbour_deleted", NETSUKUKU_TYPE_NEIGHBOUR_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, NETSUKUKU_TYPE_NEIGHBOUR);
	g_signal_new ("neighbour_rem_chged", NETSUKUKU_TYPE_NEIGHBOUR_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, NETSUKUKU_TYPE_NEIGHBOUR, NETSUKUKU_TYPE_REM);
	g_signal_new ("neighbour_going_new", NETSUKUKU_TYPE_NEIGHBOUR_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, NETSUKUKU_TYPE_NEIGHBOUR);
	g_signal_new ("neighbour_going_deleted", NETSUKUKU_TYPE_NEIGHBOUR_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, NETSUKUKU_TYPE_NEIGHBOUR);
	g_signal_new ("neighbour_going_rem_chged", NETSUKUKU_TYPE_NEIGHBOUR_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, NETSUKUKU_TYPE_NEIGHBOUR);
}


static void netsukuku_neighbour_manager_instance_init (NetsukukuNeighbourManager * self) {
	self->priv = NETSUKUKU_NEIGHBOUR_MANAGER_GET_PRIVATE (self);
}


static void netsukuku_neighbour_manager_finalize (GObject* obj) {
	NetsukukuNeighbourManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_NEIGHBOUR_MANAGER, NetsukukuNeighbourManager);
	_g_object_unref0 (self->priv->_radar);
	_g_object_unref0 (self->priv->tnip_nodeid_table);
	_g_object_unref0 (self->priv->missing_neighbour_keys);
	_g_object_unref0 (self->priv->declared_dead);
	G_OBJECT_CLASS (netsukuku_neighbour_manager_parent_class)->finalize (obj);
}


/** By watching the previous statistics, it can deduces if a change occurred or
        not. If it is, one of the following events is fired:
               'NEIGHBOUR_NEW', 'NEIGHBOUR_DELETED', 'NEIGHBOUR_REM_CHGED'
        In this way, the other modules of ntk will be noticed.

        TODO: the current statistic is based on the RTT (Round Trip Time)
        of the packets. However, more refined way can be used and shall be
        implemented: first of all consider the number of bouquet packets lost, then
        see NTK_RFC 0002  http://lab.dyne.org/Ntk_bandwidth_measurement
      */
GType netsukuku_neighbour_manager_get_type (void) {
	static volatile gsize netsukuku_neighbour_manager_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_neighbour_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuNeighbourManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_neighbour_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuNeighbourManager), 0, (GInstanceInitFunc) netsukuku_neighbour_manager_instance_init, NULL };
		GType netsukuku_neighbour_manager_type_id;
		netsukuku_neighbour_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "NetsukukuNeighbourManager", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_neighbour_manager_type_id__volatile, netsukuku_neighbour_manager_type_id);
	}
	return netsukuku_neighbour_manager_type_id__volatile;
}


static void _vala_netsukuku_neighbour_manager_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	NetsukukuNeighbourManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETSUKUKU_TYPE_NEIGHBOUR_MANAGER, NetsukukuNeighbourManager);
	switch (property_id) {
		case NETSUKUKU_NEIGHBOUR_MANAGER_RADAR:
		g_value_set_object (value, netsukuku_neighbour_manager_get_radar (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_netsukuku_neighbour_manager_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	NetsukukuNeighbourManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETSUKUKU_TYPE_NEIGHBOUR_MANAGER, NetsukukuNeighbourManager);
	switch (property_id) {
		case NETSUKUKU_NEIGHBOUR_MANAGER_RADAR:
		netsukuku_neighbour_manager_set_radar (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



