/* counter.c generated by valac 0.20.1, the Vala compiler
 * generated from counter.vala, do not modify */

/*
 *  This file is part of Netsukuku.
 *  (c) Copyright 2011-2014 Luca Dionisi aka lukisi <luca.dionisi@gmail.com>
 *
 *  Netsukuku is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Netsukuku is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Netsukuku.  If not, see <http://www.gnu.org/licenses/>.
 */
/*   peerbuilder.in
errors:
 HookingError
  INEXISTENT_GNODE
  GENERIC
 QspnError
  NOT_YOUR_GATEWAY
  ALREADY_UP_TO_DATE
  GENERIC
 PeerRefuseServiceError
  GENERIC
 TunnelError
  GENERIC
 BorderNodesError
  WRONG_GNODE
  NOT_BORDER_NODE
  WILL_NOT_TUNNEL
  TIMEOUT
  GENERIC
 AndnaError
  GENERIC
serializables:
 TimeCapsule
 ParticipantNode
 PackedParticipantNodes
 OptionalServiceParticipants
 SetOptionalServiceParticipants
 PeerToPeerTracerPacketList
 PairNipDistance
 HookReservation
 BookingRecord
 Bookings
 BnodeRecord
 BnodeList
 CoordinatorKnowledge
 CoordinatorKnowledgeSet
 PairLvlNumberOfFreeNodes
 HCoord
 PartialNIP
 NIP
 REM
 NullREM
 DeadREM
 AlmostDeadREM
 RTT
 TracerPacketList
 RouteInSet
 PositionInRoutesSetPerLevel
 RoutesSetPerLevel
 RoutesSet
 ExtendedTracerPacket
 GNodeID
 NetworkID
 InfoNeighbour
 InfoRoute
 InfoNode
 QspnStats
 InfoBorderNode
 InfoCoord
 DHTKey
 DHTRecord
 PublicKey
 AndnaServiceKey
 AndnaServerRecord
 AndnaDomainRecord
 AndnaServer
 AndnaServers
 RegisterHostnameArguments
 CounterNipRecord
 CounterSetDataResponse
 CounterCheckHostnameResponse
 CounterGetCacheRecordsResponse
 AndnaConfirmPubkResponse
 AndnaRegisterMainResponse
 AndnaRegisterSpreadResponse
 AndnaGetServersResponse
 AndnaGetRegistrarResponse
 AndnaGetCacheRecordsResponse
 BroadcastID
 UnicastID
peers:
 Counter
  methods:
   CounterSetDataResponse set_data_for_pubk
    arguments:
     NIP nip
     Gee.List<string> hashed_domains
     PublicKey pubkey
     SerializableBuffer signature
     bool replicate
    throws:
     PeerRefuseServiceError
   CounterCheckHostnameResponse check_hostname
    arguments:
     NIP nip
     string hashed_domain
     PublicKey pubkey
    throws:
     PeerRefuseServiceError
   CounterNipRecord? get_hostnames
    arguments:
     NIP nip
    throws:
     PeerRefuseServiceError
   CounterGetCacheRecordsResponse get_cache_records
    arguments:
    throws:
     PeerRefuseServiceError
*/

#include <glib.h>
#include <glib-object.h>
#include <netsukuku-rpc.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <zcd.h>
#include <tasklet.h>
#include <unistd.h>


#define NETSUKUKU_TYPE_ICOUNTER_AS_PEER (netsukuku_icounter_as_peer_get_type ())
#define NETSUKUKU_ICOUNTER_AS_PEER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_ICOUNTER_AS_PEER, NetsukukuICounterAsPeer))
#define NETSUKUKU_IS_ICOUNTER_AS_PEER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_ICOUNTER_AS_PEER))
#define NETSUKUKU_ICOUNTER_AS_PEER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), NETSUKUKU_TYPE_ICOUNTER_AS_PEER, NetsukukuICounterAsPeerIface))

typedef struct _NetsukukuICounterAsPeer NetsukukuICounterAsPeer;
typedef struct _NetsukukuICounterAsPeerIface NetsukukuICounterAsPeerIface;

#define NETSUKUKU_TYPE_RMT_PEER (netsukuku_rmt_peer_get_type ())
#define NETSUKUKU_RMT_PEER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_RMT_PEER, NetsukukuRmtPeer))
#define NETSUKUKU_RMT_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_RMT_PEER, NetsukukuRmtPeerClass))
#define NETSUKUKU_IS_RMT_PEER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_RMT_PEER))
#define NETSUKUKU_IS_RMT_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_RMT_PEER))
#define NETSUKUKU_RMT_PEER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_RMT_PEER, NetsukukuRmtPeerClass))

typedef struct _NetsukukuRmtPeer NetsukukuRmtPeer;
typedef struct _NetsukukuRmtPeerClass NetsukukuRmtPeerClass;
typedef struct _NetsukukuRmtPeerPrivate NetsukukuRmtPeerPrivate;

#define NETSUKUKU_TYPE_RMT_COUNTER_PEER (netsukuku_rmt_counter_peer_get_type ())
#define NETSUKUKU_RMT_COUNTER_PEER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_RMT_COUNTER_PEER, NetsukukuRmtCounterPeer))
#define NETSUKUKU_RMT_COUNTER_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_RMT_COUNTER_PEER, NetsukukuRmtCounterPeerClass))
#define NETSUKUKU_IS_RMT_COUNTER_PEER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_RMT_COUNTER_PEER))
#define NETSUKUKU_IS_RMT_COUNTER_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_RMT_COUNTER_PEER))
#define NETSUKUKU_RMT_COUNTER_PEER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_RMT_COUNTER_PEER, NetsukukuRmtCounterPeerClass))

typedef struct _NetsukukuRmtCounterPeer NetsukukuRmtCounterPeer;
typedef struct _NetsukukuRmtCounterPeerClass NetsukukuRmtCounterPeerClass;
typedef struct _NetsukukuRmtCounterPeerPrivate NetsukukuRmtCounterPeerPrivate;

#define NETSUKUKU_TYPE_PEER_TO_PEER (netsukuku_peer_to_peer_get_type ())
#define NETSUKUKU_PEER_TO_PEER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_PEER_TO_PEER, NetsukukuPeerToPeer))
#define NETSUKUKU_PEER_TO_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_PEER_TO_PEER, NetsukukuPeerToPeerClass))
#define NETSUKUKU_IS_PEER_TO_PEER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_PEER_TO_PEER))
#define NETSUKUKU_IS_PEER_TO_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_PEER_TO_PEER))
#define NETSUKUKU_PEER_TO_PEER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_PEER_TO_PEER, NetsukukuPeerToPeerClass))

typedef struct _NetsukukuPeerToPeer NetsukukuPeerToPeer;
typedef struct _NetsukukuPeerToPeerClass NetsukukuPeerToPeerClass;

#define NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR (netsukuku_aggregated_neighbour_get_type ())
#define NETSUKUKU_AGGREGATED_NEIGHBOUR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR, NetsukukuAggregatedNeighbour))
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR, NetsukukuAggregatedNeighbourClass))
#define NETSUKUKU_IS_AGGREGATED_NEIGHBOUR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR))
#define NETSUKUKU_IS_AGGREGATED_NEIGHBOUR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR))
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR, NetsukukuAggregatedNeighbourClass))

typedef struct _NetsukukuAggregatedNeighbour NetsukukuAggregatedNeighbour;
typedef struct _NetsukukuAggregatedNeighbourClass NetsukukuAggregatedNeighbourClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define NETSUKUKU_TYPE_ARGUMENTS_FOR_DUPLICATION_SET_DATA (netsukuku_arguments_for_duplication_set_data_get_type ())
#define NETSUKUKU_ARGUMENTS_FOR_DUPLICATION_SET_DATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_ARGUMENTS_FOR_DUPLICATION_SET_DATA, NetsukukuArgumentsForDuplicationSetData))
#define NETSUKUKU_ARGUMENTS_FOR_DUPLICATION_SET_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_ARGUMENTS_FOR_DUPLICATION_SET_DATA, NetsukukuArgumentsForDuplicationSetDataClass))
#define NETSUKUKU_IS_ARGUMENTS_FOR_DUPLICATION_SET_DATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_ARGUMENTS_FOR_DUPLICATION_SET_DATA))
#define NETSUKUKU_IS_ARGUMENTS_FOR_DUPLICATION_SET_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_ARGUMENTS_FOR_DUPLICATION_SET_DATA))
#define NETSUKUKU_ARGUMENTS_FOR_DUPLICATION_SET_DATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_ARGUMENTS_FOR_DUPLICATION_SET_DATA, NetsukukuArgumentsForDuplicationSetDataClass))

typedef struct _NetsukukuArgumentsForDuplicationSetData NetsukukuArgumentsForDuplicationSetData;
typedef struct _NetsukukuArgumentsForDuplicationSetDataClass NetsukukuArgumentsForDuplicationSetDataClass;
typedef struct _NetsukukuArgumentsForDuplicationSetDataPrivate NetsukukuArgumentsForDuplicationSetDataPrivate;

#define NETSUKUKU_TYPE_STRUCT_HELPER_COUNTER_HOOK_TO_SERVICE (netsukuku_struct_helper_counter_hook_to_service_get_type ())

#define NETSUKUKU_TYPE_OPTIONAL_PEER_TO_PEER (netsukuku_optional_peer_to_peer_get_type ())
#define NETSUKUKU_OPTIONAL_PEER_TO_PEER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_OPTIONAL_PEER_TO_PEER, NetsukukuOptionalPeerToPeer))
#define NETSUKUKU_OPTIONAL_PEER_TO_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_OPTIONAL_PEER_TO_PEER, NetsukukuOptionalPeerToPeerClass))
#define NETSUKUKU_IS_OPTIONAL_PEER_TO_PEER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_OPTIONAL_PEER_TO_PEER))
#define NETSUKUKU_IS_OPTIONAL_PEER_TO_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_OPTIONAL_PEER_TO_PEER))
#define NETSUKUKU_OPTIONAL_PEER_TO_PEER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_OPTIONAL_PEER_TO_PEER, NetsukukuOptionalPeerToPeerClass))

typedef struct _NetsukukuOptionalPeerToPeer NetsukukuOptionalPeerToPeer;
typedef struct _NetsukukuOptionalPeerToPeerClass NetsukukuOptionalPeerToPeerClass;

#define NETSUKUKU_TYPE_COUNTER (netsukuku_counter_get_type ())
#define NETSUKUKU_COUNTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_COUNTER, NetsukukuCounter))
#define NETSUKUKU_COUNTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_COUNTER, NetsukukuCounterClass))
#define NETSUKUKU_IS_COUNTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_COUNTER))
#define NETSUKUKU_IS_COUNTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_COUNTER))
#define NETSUKUKU_COUNTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_COUNTER, NetsukukuCounterClass))

typedef struct _NetsukukuCounter NetsukukuCounter;
typedef struct _NetsukukuCounterClass NetsukukuCounterClass;
typedef struct _Netsukukustruct_helper_Counter_hook_to_service Netsukukustruct_helper_Counter_hook_to_service;

#define NETSUKUKU_TYPE_STRUCT_HELPER_COUNTER_RESET_MY_COUNTER_NODE (netsukuku_struct_helper_counter_reset_my_counter_node_get_type ())
typedef struct _Netsukukustruct_helper_Counter_reset_my_counter_node Netsukukustruct_helper_Counter_reset_my_counter_node;
typedef struct _NetsukukuPeerToPeerPrivate NetsukukuPeerToPeerPrivate;

#define NETSUKUKU_TYPE_MAP (netsukuku_map_get_type ())
#define NETSUKUKU_MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_MAP, NetsukukuMap))
#define NETSUKUKU_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_MAP, NetsukukuMapClass))
#define NETSUKUKU_IS_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_MAP))
#define NETSUKUKU_IS_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_MAP))
#define NETSUKUKU_MAP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_MAP, NetsukukuMapClass))

typedef struct _NetsukukuMap NetsukukuMap;
typedef struct _NetsukukuMapClass NetsukukuMapClass;

#define NETSUKUKU_TYPE_MAP_ROUTE (netsukuku_map_route_get_type ())
#define NETSUKUKU_MAP_ROUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_MAP_ROUTE, NetsukukuMapRoute))
#define NETSUKUKU_MAP_ROUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_MAP_ROUTE, NetsukukuMapRouteClass))
#define NETSUKUKU_IS_MAP_ROUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_MAP_ROUTE))
#define NETSUKUKU_IS_MAP_ROUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_MAP_ROUTE))
#define NETSUKUKU_MAP_ROUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_MAP_ROUTE, NetsukukuMapRouteClass))

typedef struct _NetsukukuMapRoute NetsukukuMapRoute;
typedef struct _NetsukukuMapRouteClass NetsukukuMapRouteClass;

#define NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER (netsukuku_aggregated_neighbour_manager_get_type ())
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, NetsukukuAggregatedNeighbourManager))
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, NetsukukuAggregatedNeighbourManagerClass))
#define NETSUKUKU_IS_AGGREGATED_NEIGHBOUR_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER))
#define NETSUKUKU_IS_AGGREGATED_NEIGHBOUR_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER))
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, NetsukukuAggregatedNeighbourManagerClass))

typedef struct _NetsukukuAggregatedNeighbourManager NetsukukuAggregatedNeighbourManager;
typedef struct _NetsukukuAggregatedNeighbourManagerClass NetsukukuAggregatedNeighbourManagerClass;
typedef struct _NetsukukuOptionalPeerToPeerPrivate NetsukukuOptionalPeerToPeerPrivate;

#define NETSUKUKU_TYPE_MAP_PEER_TO_PEER (netsukuku_map_peer_to_peer_get_type ())
#define NETSUKUKU_MAP_PEER_TO_PEER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_MAP_PEER_TO_PEER, NetsukukuMapPeerToPeer))
#define NETSUKUKU_MAP_PEER_TO_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_MAP_PEER_TO_PEER, NetsukukuMapPeerToPeerClass))
#define NETSUKUKU_IS_MAP_PEER_TO_PEER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_MAP_PEER_TO_PEER))
#define NETSUKUKU_IS_MAP_PEER_TO_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_MAP_PEER_TO_PEER))
#define NETSUKUKU_MAP_PEER_TO_PEER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_MAP_PEER_TO_PEER, NetsukukuMapPeerToPeerClass))

typedef struct _NetsukukuMapPeerToPeer NetsukukuMapPeerToPeer;
typedef struct _NetsukukuMapPeerToPeerClass NetsukukuMapPeerToPeerClass;
typedef struct _NetsukukuCounterPrivate NetsukukuCounterPrivate;

#define NETSUKUKU_TYPE_PEER_TO_PEER_ALL (netsukuku_peer_to_peer_all_get_type ())
#define NETSUKUKU_PEER_TO_PEER_ALL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_PEER_TO_PEER_ALL, NetsukukuPeerToPeerAll))
#define NETSUKUKU_PEER_TO_PEER_ALL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_PEER_TO_PEER_ALL, NetsukukuPeerToPeerAllClass))
#define NETSUKUKU_IS_PEER_TO_PEER_ALL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_PEER_TO_PEER_ALL))
#define NETSUKUKU_IS_PEER_TO_PEER_ALL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_PEER_TO_PEER_ALL))
#define NETSUKUKU_PEER_TO_PEER_ALL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_PEER_TO_PEER_ALL, NetsukukuPeerToPeerAllClass))

typedef struct _NetsukukuPeerToPeerAll NetsukukuPeerToPeerAll;
typedef struct _NetsukukuPeerToPeerAllClass NetsukukuPeerToPeerAllClass;

#define NETSUKUKU_TYPE_ANDNA (netsukuku_andna_get_type ())
#define NETSUKUKU_ANDNA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_ANDNA, NetsukukuAndna))
#define NETSUKUKU_ANDNA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_ANDNA, NetsukukuAndnaClass))
#define NETSUKUKU_IS_ANDNA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_ANDNA))
#define NETSUKUKU_IS_ANDNA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_ANDNA))
#define NETSUKUKU_ANDNA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_ANDNA, NetsukukuAndnaClass))

typedef struct _NetsukukuAndna NetsukukuAndna;
typedef struct _NetsukukuAndnaClass NetsukukuAndnaClass;

#define NETSUKUKU_TYPE_KEY_PAIR (netsukuku_key_pair_get_type ())
#define NETSUKUKU_KEY_PAIR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_KEY_PAIR, NetsukukuKeyPair))
#define NETSUKUKU_KEY_PAIR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_KEY_PAIR, NetsukukuKeyPairClass))
#define NETSUKUKU_IS_KEY_PAIR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_KEY_PAIR))
#define NETSUKUKU_IS_KEY_PAIR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_KEY_PAIR))
#define NETSUKUKU_KEY_PAIR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_KEY_PAIR, NetsukukuKeyPairClass))

typedef struct _NetsukukuKeyPair NetsukukuKeyPair;
typedef struct _NetsukukuKeyPairClass NetsukukuKeyPairClass;

#define NETSUKUKU_TYPE_PUBLIC_KEY_WRAPPER (netsukuku_public_key_wrapper_get_type ())
#define NETSUKUKU_PUBLIC_KEY_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_PUBLIC_KEY_WRAPPER, NetsukukuPublicKeyWrapper))
#define NETSUKUKU_PUBLIC_KEY_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_PUBLIC_KEY_WRAPPER, NetsukukuPublicKeyWrapperClass))
#define NETSUKUKU_IS_PUBLIC_KEY_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_PUBLIC_KEY_WRAPPER))
#define NETSUKUKU_IS_PUBLIC_KEY_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_PUBLIC_KEY_WRAPPER))
#define NETSUKUKU_PUBLIC_KEY_WRAPPER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_PUBLIC_KEY_WRAPPER, NetsukukuPublicKeyWrapperClass))

typedef struct _NetsukukuPublicKeyWrapper NetsukukuPublicKeyWrapper;
typedef struct _NetsukukuPublicKeyWrapperClass NetsukukuPublicKeyWrapperClass;
typedef struct _Block5Data Block5Data;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _NetsukukuICounterAsPeerIface {
	GTypeInterface parent_iface;
	NetsukukuCounterSetDataResponse* (*set_data_for_pubk) (NetsukukuICounterAsPeer* self, NetsukukuNIP* nip, GeeList* hashed_domains, NetsukukuPublicKey* pubkey, zcdSerializableBuffer* signature, gboolean replicate, GError** error);
	NetsukukuCounterCheckHostnameResponse* (*check_hostname) (NetsukukuICounterAsPeer* self, NetsukukuNIP* nip, const gchar* hashed_domain, NetsukukuPublicKey* pubkey, GError** error);
	NetsukukuCounterNipRecord* (*get_hostnames) (NetsukukuICounterAsPeer* self, NetsukukuNIP* nip, GError** error);
	NetsukukuCounterGetCacheRecordsResponse* (*get_cache_records) (NetsukukuICounterAsPeer* self, GError** error);
};

struct _NetsukukuRmtPeer {
	GObject parent_instance;
	NetsukukuRmtPeerPrivate * priv;
};

struct _NetsukukuRmtPeerClass {
	GObjectClass parent_class;
	zcdISerializable* (*rmt) (NetsukukuRmtPeer* self, zcdRemoteCall* data, GError** error);
};

struct _NetsukukuRmtCounterPeer {
	NetsukukuRmtPeer parent_instance;
	NetsukukuRmtCounterPeerPrivate * priv;
};

struct _NetsukukuRmtCounterPeerClass {
	NetsukukuRmtPeerClass parent_class;
};

struct _NetsukukuArgumentsForDuplicationSetData {
	GObject parent_instance;
	NetsukukuArgumentsForDuplicationSetDataPrivate * priv;
	NetsukukuNIP* nip;
	GeeList* hashed_domains;
	NetsukukuPublicKey* pubkey;
	zcdSerializableBuffer* signature;
	NetsukukuNIP* hashnode;
};

struct _NetsukukuArgumentsForDuplicationSetDataClass {
	GObjectClass parent_class;
};

struct _Netsukukustruct_helper_Counter_hook_to_service {
	NetsukukuCounter* self;
};

struct _Netsukukustruct_helper_Counter_reset_my_counter_node {
	NetsukukuCounter* self;
};

struct _NetsukukuPeerToPeer {
	zcdRPCDispatcher parent_instance;
	NetsukukuPeerToPeerPrivate * priv;
	NetsukukuMapRoute* maproute;
	NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager;
	gint pid;
	gboolean has_valid_map;
};

struct _NetsukukuPeerToPeerClass {
	zcdRPCDispatcherClass parent_class;
	void (*start_operations) (NetsukukuPeerToPeer* self);
	void (*stop_operations) (NetsukukuPeerToPeer* self);
	gboolean (*is_participant) (NetsukukuPeerToPeer* self, gint lvl, gint pos);
	NetsukukuNIP* (*h) (NetsukukuPeerToPeer* self, GObject* key);
};

struct _NetsukukuOptionalPeerToPeer {
	NetsukukuPeerToPeer parent_instance;
	NetsukukuOptionalPeerToPeerPrivate * priv;
	NetsukukuMapPeerToPeer* map_peer_to_peer;
	gboolean will_participate;
};

struct _NetsukukuOptionalPeerToPeerClass {
	NetsukukuPeerToPeerClass parent_class;
};

struct _NetsukukuCounter {
	NetsukukuOptionalPeerToPeer parent_instance;
	NetsukukuCounterPrivate * priv;
};

struct _NetsukukuCounterClass {
	NetsukukuOptionalPeerToPeerClass parent_class;
	NetsukukuIAddressManagerRootDispatcher* (*contact_registrar) (NetsukukuCounter* self, const gchar* registrar_address);
};

struct _NetsukukuCounterPrivate {
	GeeArrayList* _hashednames;
	NetsukukuPeerToPeerAll* peer_to_peer_all;
	gboolean hooked_to_service;
	TaskletsTasklet* reset_my_counter_node_tasklet;
	NetsukukuAndna* _andna;
	NetsukukuKeyPair* my_keys;
	NetsukukuPublicKey* pubk;
	GeeHashMap* cache;
};

typedef enum  {
	NETSUKUKU_PEER_TO_PEER_ERROR_REGISTER,
	NETSUKUKU_PEER_TO_PEER_ERROR_GENERIC
} NetsukukuPeerToPeerError;
#define NETSUKUKU_PEER_TO_PEER_ERROR netsukuku_peer_to_peer_error_quark ()
typedef enum  {
	NETSUKUKU_CRYPTO_GCRYPT_ERROR_FAILED
} NetsukukuCryptoGCryptError;
#define NETSUKUKU_CRYPTO_GCRYPT_ERROR netsukuku_crypto_gcrypt_error_quark ()
struct _Block5Data {
	int _ref_count_;
	NetsukukuCounter * self;
	gchar* response_msg;
	NetsukukuTimeCapsule* response_ttl;
	NetsukukuNIP* nip;
	GeeList* hashed_domains;
	NetsukukuPublicKey* pubkey;
	zcdSerializableBuffer* signature;
};

typedef gboolean (*NetsukukuAcceptRecordCallback) (void* user_data, GError** error);
typedef void (*NetsukukuForwardRecordCallback) (GObject* obj1, GeeList* replica_nodes, void* user_data, GError** error);
typedef void (*NetsukukuRefuseRecordCallback) (void* user_data, GError** error);

static gpointer netsukuku_rmt_counter_peer_parent_class = NULL;
static NetsukukuICounterAsPeerIface* netsukuku_rmt_counter_peer_netsukuku_icounter_as_peer_parent_iface = NULL;
static gpointer netsukuku_arguments_for_duplication_set_data_parent_class = NULL;
static gpointer netsukuku_counter_parent_class = NULL;
static NetsukukuICounterAsPeerIface* netsukuku_counter_netsukuku_icounter_as_peer_parent_iface = NULL;

GType netsukuku_icounter_as_peer_get_type (void) G_GNUC_CONST;
NetsukukuCounterSetDataResponse* netsukuku_icounter_as_peer_set_data_for_pubk (NetsukukuICounterAsPeer* self, NetsukukuNIP* nip, GeeList* hashed_domains, NetsukukuPublicKey* pubkey, zcdSerializableBuffer* signature, gboolean replicate, GError** error);
NetsukukuCounterCheckHostnameResponse* netsukuku_icounter_as_peer_check_hostname (NetsukukuICounterAsPeer* self, NetsukukuNIP* nip, const gchar* hashed_domain, NetsukukuPublicKey* pubkey, GError** error);
NetsukukuCounterNipRecord* netsukuku_icounter_as_peer_get_hostnames (NetsukukuICounterAsPeer* self, NetsukukuNIP* nip, GError** error);
NetsukukuCounterGetCacheRecordsResponse* netsukuku_icounter_as_peer_get_cache_records (NetsukukuICounterAsPeer* self, GError** error);
GType netsukuku_rmt_peer_get_type (void) G_GNUC_CONST;
GType netsukuku_rmt_counter_peer_get_type (void) G_GNUC_CONST;
enum  {
	NETSUKUKU_RMT_COUNTER_PEER_DUMMY_PROPERTY
};
GType netsukuku_peer_to_peer_get_type (void) G_GNUC_CONST;
GType netsukuku_aggregated_neighbour_get_type (void) G_GNUC_CONST;
NetsukukuRmtCounterPeer* netsukuku_rmt_counter_peer_new (NetsukukuPeerToPeer* peer_to_peer_service, GObject* key, NetsukukuNIP* hIP, NetsukukuAggregatedNeighbour* aggregated_neighbour);
NetsukukuRmtCounterPeer* netsukuku_rmt_counter_peer_construct (GType object_type, NetsukukuPeerToPeer* peer_to_peer_service, GObject* key, NetsukukuNIP* hIP, NetsukukuAggregatedNeighbour* aggregated_neighbour);
NetsukukuRmtPeer* netsukuku_rmt_peer_construct (GType object_type, NetsukukuPeerToPeer* peer_to_peer_service, GObject* key, NetsukukuNIP* hIP, NetsukukuAggregatedNeighbour* aggregated_neighbour);
static NetsukukuCounterSetDataResponse* netsukuku_rmt_counter_peer_real_set_data_for_pubk (NetsukukuICounterAsPeer* base, NetsukukuNIP* nip, GeeList* hashed_domains, NetsukukuPublicKey* pubkey, zcdSerializableBuffer* signature, gboolean replicate, GError** error);
zcdISerializable* netsukuku_rmt_peer_rmt (NetsukukuRmtPeer* self, zcdRemoteCall* data, GError** error);
static NetsukukuCounterCheckHostnameResponse* netsukuku_rmt_counter_peer_real_check_hostname (NetsukukuICounterAsPeer* base, NetsukukuNIP* nip, const gchar* hashed_domain, NetsukukuPublicKey* pubkey, GError** error);
static NetsukukuCounterNipRecord* netsukuku_rmt_counter_peer_real_get_hostnames (NetsukukuICounterAsPeer* base, NetsukukuNIP* nip, GError** error);
static NetsukukuCounterGetCacheRecordsResponse* netsukuku_rmt_counter_peer_real_get_cache_records (NetsukukuICounterAsPeer* base, GError** error);
GType netsukuku_arguments_for_duplication_set_data_get_type (void) G_GNUC_CONST;
enum  {
	NETSUKUKU_ARGUMENTS_FOR_DUPLICATION_SET_DATA_DUMMY_PROPERTY
};
NetsukukuArgumentsForDuplicationSetData* netsukuku_arguments_for_duplication_set_data_new (void);
NetsukukuArgumentsForDuplicationSetData* netsukuku_arguments_for_duplication_set_data_construct (GType object_type);
static void netsukuku_arguments_for_duplication_set_data_finalize (GObject* obj);
GType netsukuku_struct_helper_counter_hook_to_service_get_type (void) G_GNUC_CONST;
GType netsukuku_optional_peer_to_peer_get_type (void) G_GNUC_CONST;
GType netsukuku_counter_get_type (void) G_GNUC_CONST;
Netsukukustruct_helper_Counter_hook_to_service* netsukuku_struct_helper_counter_hook_to_service_dup (const Netsukukustruct_helper_Counter_hook_to_service* self);
void netsukuku_struct_helper_counter_hook_to_service_free (Netsukukustruct_helper_Counter_hook_to_service* self);
void netsukuku_struct_helper_counter_hook_to_service_copy (const Netsukukustruct_helper_Counter_hook_to_service* self, Netsukukustruct_helper_Counter_hook_to_service* dest);
void netsukuku_struct_helper_counter_hook_to_service_destroy (Netsukukustruct_helper_Counter_hook_to_service* self);
GType netsukuku_struct_helper_counter_reset_my_counter_node_get_type (void) G_GNUC_CONST;
Netsukukustruct_helper_Counter_reset_my_counter_node* netsukuku_struct_helper_counter_reset_my_counter_node_dup (const Netsukukustruct_helper_Counter_reset_my_counter_node* self);
void netsukuku_struct_helper_counter_reset_my_counter_node_free (Netsukukustruct_helper_Counter_reset_my_counter_node* self);
void netsukuku_struct_helper_counter_reset_my_counter_node_copy (const Netsukukustruct_helper_Counter_reset_my_counter_node* self, Netsukukustruct_helper_Counter_reset_my_counter_node* dest);
void netsukuku_struct_helper_counter_reset_my_counter_node_destroy (Netsukukustruct_helper_Counter_reset_my_counter_node* self);
GType netsukuku_map_get_type (void) G_GNUC_CONST;
GType netsukuku_map_route_get_type (void) G_GNUC_CONST;
GType netsukuku_aggregated_neighbour_manager_get_type (void) G_GNUC_CONST;
GType netsukuku_map_peer_to_peer_get_type (void) G_GNUC_CONST;
GType netsukuku_peer_to_peer_all_get_type (void) G_GNUC_CONST;
GType netsukuku_andna_get_type (void) G_GNUC_CONST;
GType netsukuku_key_pair_get_type (void) G_GNUC_CONST;
#define NETSUKUKU_COUNTER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), NETSUKUKU_TYPE_COUNTER, NetsukukuCounterPrivate))
enum  {
	NETSUKUKU_COUNTER_DUMMY_PROPERTY,
	NETSUKUKU_COUNTER_ANDNA
};
#define NETSUKUKU_COUNTER_mypid 2
NetsukukuCounter* netsukuku_counter_new (NetsukukuKeyPair* keypair, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, NetsukukuPeerToPeerAll* peer_to_peer_all);
NetsukukuCounter* netsukuku_counter_construct (GType object_type, NetsukukuKeyPair* keypair, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, NetsukukuPeerToPeerAll* peer_to_peer_all);
NetsukukuOptionalPeerToPeer* netsukuku_optional_peer_to_peer_new (NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, gint pid);
NetsukukuOptionalPeerToPeer* netsukuku_optional_peer_to_peer_construct (GType object_type, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, gint pid);
GType netsukuku_public_key_wrapper_get_type (void) G_GNUC_CONST;
NetsukukuPublicKeyWrapper* netsukuku_key_pair_get_pub_key (NetsukukuKeyPair* self);
NetsukukuPublicKey* netsukuku_public_key_wrapper_to_pubkey (NetsukukuPublicKeyWrapper* self);
GQuark netsukuku_peer_to_peer_error_quark (void);
void netsukuku_peer_to_peer_all_peer_to_peer_register (NetsukukuPeerToPeerAll* self, NetsukukuPeerToPeer* peer_to_peer, GError** error);
void netsukuku_counter_hook_to_service (NetsukukuCounter* self);
static void _netsukuku_counter_hook_to_service_netsukuku_peer_to_peer_map_peer_to_peer_validated (NetsukukuPeerToPeer* _sender, gpointer self);
static guint _netsukuku_pair_public_key_nip_hash_func_gee_hash_data_func (gconstpointer v, gpointer self);
static gboolean _netsukuku_pair_public_key_nip_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self);
NetsukukuRmtCounterPeer* netsukuku_counter_peer (NetsukukuCounter* self, NetsukukuNIP* hIP, GObject* key, NetsukukuAggregatedNeighbour* aggregated_neighbour);
static zcdISerializable* netsukuku_counter_real__dispatch (zcdRPCDispatcher* base, GObject* caller, zcdRemoteCall* data, GError** error);
static NetsukukuNIP* netsukuku_counter_nip_for_lvl_pos (NetsukukuCounter* self, gint lvl, gint pos);
NetsukukuNIP* netsukuku_map_get_me (NetsukukuMap* self);
static void netsukuku_counter_impl_hook_to_service (NetsukukuCounter* self, GError** error);
gint netsukuku_map_get_levels (NetsukukuMap* self);
void netsukuku_peer_to_peer_find_hook_peers (NetsukukuPeerToPeer* self, gint** ret_first_forward, gint** ret_first_back, gint** ret_last_back, gint lvl, gint num_dupl, gint timeout);
#define NETSUKUKU_COUNTER_DUPLICATION 10
static gboolean _int_equal (const gint* s1, const gint* s2);
NetsukukuNIP* netsukuku_peer_to_peer_h (NetsukukuPeerToPeer* self, GObject* key);
GeeList* netsukuku_peer_to_peer_list_ids (NetsukukuPeerToPeer* self, gint center, gint sign);
void netsukuku_optional_peer_to_peer_participate (NetsukukuOptionalPeerToPeer* self);
void netsukuku_log_info (const gchar* msg);
static void* netsukuku_counter_helper_hook_to_service (void* v, GError** error);
static NetsukukuNIP* netsukuku_counter_real_h (NetsukukuPeerToPeer* base, GObject* key);
GQuark netsukuku_crypto_gcrypt_error_quark (void);
guint8* netsukuku_crypto_md5 (guint8* buffer, int buffer_length1, int* result_length1, GError** error);
gint netsukuku_map_get_gsize (NetsukukuMap* self);
static void netsukuku_counter_impl_reset_my_counter_node (NetsukukuCounter* self, GError** error);
static NetsukukuCounterSetDataResponse* netsukuku_counter_ask_set_data_for_pubk (NetsukukuCounter* self);
#define NETSUKUKU_MAX_WAIT_REFRESH_COUNTER ((((gint64) 1000) * ((gint64) 60)) * ((gint64) 60))
static void* netsukuku_counter_helper_reset_my_counter_node (void* v, GError** error);
void netsukuku_counter_reset_my_counter_node (NetsukukuCounter* self);
void netsukuku_counter_stop_reset_my_counter_node (NetsukukuCounter* self);
gboolean netsukuku_counter_reset_my_counter_node_ongoing (NetsukukuCounter* self);
static zcdSerializableBuffer* _netsukuku_counter_sign (NetsukukuCounter* self, GeeList* hashed_domains);
static GeeArrayList* netsukuku_counter_get_hashednames (NetsukukuCounter* self);
guchar* netsukuku_key_pair_sign (NetsukukuKeyPair* self, guchar* msg, int msg_length1, int* result_length1, GError** error);
guchar* netsukuku_counter_utilities_prepare_msg (NetsukukuNIP* nip, GeeList* hashed_domains, int* result_length1);
static gboolean _netsukuku_counter_verify (NetsukukuCounter* self, NetsukukuNIP* nip, GeeList* hashed_domains, NetsukukuPublicKey* pubk, zcdSerializableBuffer* signature);
NetsukukuPublicKeyWrapper* netsukuku_public_key_wrapper_new_from_pubk (NetsukukuPublicKey* from_pubk, GError** error);
NetsukukuPublicKeyWrapper* netsukuku_public_key_wrapper_construct_from_pubk (GType object_type, NetsukukuPublicKey* from_pubk, GError** error);
gboolean netsukuku_public_key_wrapper_verify (NetsukukuPublicKeyWrapper* self, guchar* msg, int msg_length1, guchar* signature, int signature_length1, GError** error);
NetsukukuCounterCheckHostnameResponse* netsukuku_counter_ask_check_hostname (NetsukukuCounter* self, NetsukukuNIP* nip, const gchar* hashed_domain, NetsukukuPublicKey* pubkey, GError** error);
NetsukukuCounterNipRecord* netsukuku_counter_ask_get_hostnames (NetsukukuCounter* self, NetsukukuNIP* nip);
void netsukuku_counter_check_expirations_cache (NetsukukuCounter* self);
NetsukukuIAddressManagerRootDispatcher* netsukuku_counter_contact_registrar (NetsukukuCounter* self, const gchar* registrar_address);
static NetsukukuIAddressManagerRootDispatcher* netsukuku_counter_real_contact_registrar (NetsukukuCounter* self, const gchar* registrar_address);
static NetsukukuCounterSetDataResponse* netsukuku_counter_real_set_data_for_pubk (NetsukukuICounterAsPeer* base, NetsukukuNIP* nip, GeeList* hashed_domains, NetsukukuPublicKey* pubkey, zcdSerializableBuffer* signature, gboolean replicate, GError** error);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
void netsukuku_check_hash_and_start_replica (NetsukukuPeerToPeer* service, NetsukukuNIP* hash_nip, gboolean replicate, GObject* obj1, gint replica_nodes_max, NetsukukuAcceptRecordCallback accept_callback, void* accept_callback_target, NetsukukuForwardRecordCallback forward_callback, void* forward_callback_target, NetsukukuRefuseRecordCallback refuse_callback, void* refuse_callback_target, GError** error);
static gboolean __lambda14_ (Block5Data* _data5_, GError** error);
#define NETSUKUKU_MAX_HOSTNAMES 256
gchar* netsukuku_nip_to_str (gint levels, gint gsize, NetsukukuNIP* nip);
#define NETSUKUKU_MAX_TTL_COUNTER ((((((gint64) 1000) * ((gint64) 60)) * ((gint64) 60)) * ((gint64) 24)) * ((gint64) 30))
static gboolean ___lambda14__netsukuku_accept_record_callback (gpointer self, GError** error);
static void __lambda15_ (NetsukukuCounter* self, GObject* tasklet_obj1, GeeList* tasklet_replica_nodes, GError** error);
GeeList* netsukuku_peer_to_peer_find_nearest_to_register (NetsukukuPeerToPeer* self, NetsukukuNIP* hash_nip, gint num_dupl, gint* inside_gnode_level, GError** error);
static void _____lambda16_ (NetsukukuCounter* self, GObject* tpar1, GObject* tpar2, GError** error);
void netsukuku_log_warn (const gchar* msg);
static void ______lambda16__tasklets_tasklet_callback (GObject* obj1, GObject* obj2, GObject* obj3, GObject* obj4, gpointer self, GError** error);
static void ___lambda15__netsukuku_forward_record_callback (GObject* obj1, GeeList* replica_nodes, gpointer self, GError** error);
static NetsukukuCounterCheckHostnameResponse* netsukuku_counter_real_check_hostname (NetsukukuICounterAsPeer* base, NetsukukuNIP* nip, const gchar* hashed_domain, NetsukukuPublicKey* pubkey, GError** error);
NetsukukuHCoord* netsukuku_peer_to_peer_search_participant (NetsukukuPeerToPeer* self, NetsukukuNIP* hIP, gint path_sign, GError** error);
static NetsukukuCounterNipRecord* netsukuku_counter_real_get_hostnames (NetsukukuICounterAsPeer* base, NetsukukuNIP* nip, GError** error);
static NetsukukuCounterGetCacheRecordsResponse* netsukuku_counter_real_get_cache_records (NetsukukuICounterAsPeer* base, GError** error);
gchar* netsukuku_andna_crypto_hash (const gchar* hostname);
static NetsukukuAndna* netsukuku_counter_get_andna (NetsukukuCounter* self);
void netsukuku_counter_set_andna (NetsukukuCounter* self, NetsukukuAndna* value);
static void netsukuku_counter_finalize (GObject* obj);
static void _vala_netsukuku_counter_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_netsukuku_counter_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


NetsukukuCounterSetDataResponse* netsukuku_icounter_as_peer_set_data_for_pubk (NetsukukuICounterAsPeer* self, NetsukukuNIP* nip, GeeList* hashed_domains, NetsukukuPublicKey* pubkey, zcdSerializableBuffer* signature, gboolean replicate, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return NETSUKUKU_ICOUNTER_AS_PEER_GET_INTERFACE (self)->set_data_for_pubk (self, nip, hashed_domains, pubkey, signature, replicate, error);
}


NetsukukuCounterCheckHostnameResponse* netsukuku_icounter_as_peer_check_hostname (NetsukukuICounterAsPeer* self, NetsukukuNIP* nip, const gchar* hashed_domain, NetsukukuPublicKey* pubkey, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return NETSUKUKU_ICOUNTER_AS_PEER_GET_INTERFACE (self)->check_hostname (self, nip, hashed_domain, pubkey, error);
}


NetsukukuCounterNipRecord* netsukuku_icounter_as_peer_get_hostnames (NetsukukuICounterAsPeer* self, NetsukukuNIP* nip, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return NETSUKUKU_ICOUNTER_AS_PEER_GET_INTERFACE (self)->get_hostnames (self, nip, error);
}


NetsukukuCounterGetCacheRecordsResponse* netsukuku_icounter_as_peer_get_cache_records (NetsukukuICounterAsPeer* self, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return NETSUKUKU_ICOUNTER_AS_PEER_GET_INTERFACE (self)->get_cache_records (self, error);
}


static void netsukuku_icounter_as_peer_base_init (NetsukukuICounterAsPeerIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


GType netsukuku_icounter_as_peer_get_type (void) {
	static volatile gsize netsukuku_icounter_as_peer_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_icounter_as_peer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuICounterAsPeerIface), (GBaseInitFunc) netsukuku_icounter_as_peer_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType netsukuku_icounter_as_peer_type_id;
		netsukuku_icounter_as_peer_type_id = g_type_register_static (G_TYPE_INTERFACE, "NetsukukuICounterAsPeer", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (netsukuku_icounter_as_peer_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&netsukuku_icounter_as_peer_type_id__volatile, netsukuku_icounter_as_peer_type_id);
	}
	return netsukuku_icounter_as_peer_type_id__volatile;
}


NetsukukuRmtCounterPeer* netsukuku_rmt_counter_peer_construct (GType object_type, NetsukukuPeerToPeer* peer_to_peer_service, GObject* key, NetsukukuNIP* hIP, NetsukukuAggregatedNeighbour* aggregated_neighbour) {
	NetsukukuRmtCounterPeer * self = NULL;
	NetsukukuPeerToPeer* _tmp0_;
	GObject* _tmp1_;
	NetsukukuNIP* _tmp2_;
	NetsukukuAggregatedNeighbour* _tmp3_;
	g_return_val_if_fail (peer_to_peer_service != NULL, NULL);
	_tmp0_ = peer_to_peer_service;
	_tmp1_ = key;
	_tmp2_ = hIP;
	_tmp3_ = aggregated_neighbour;
	self = (NetsukukuRmtCounterPeer*) netsukuku_rmt_peer_construct (object_type, _tmp0_, _tmp1_, _tmp2_, _tmp3_);
	return self;
}


NetsukukuRmtCounterPeer* netsukuku_rmt_counter_peer_new (NetsukukuPeerToPeer* peer_to_peer_service, GObject* key, NetsukukuNIP* hIP, NetsukukuAggregatedNeighbour* aggregated_neighbour) {
	return netsukuku_rmt_counter_peer_construct (NETSUKUKU_TYPE_RMT_COUNTER_PEER, peer_to_peer_service, key, hIP, aggregated_neighbour);
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static NetsukukuCounterSetDataResponse* netsukuku_rmt_counter_peer_real_set_data_for_pubk (NetsukukuICounterAsPeer* base, NetsukukuNIP* nip, GeeList* hashed_domains, NetsukukuPublicKey* pubkey, zcdSerializableBuffer* signature, gboolean replicate, GError** error) {
	NetsukukuRmtCounterPeer * self;
	NetsukukuCounterSetDataResponse* result = NULL;
	zcdRemoteCall* _tmp0_;
	zcdRemoteCall* rc;
	zcdRemoteCall* _tmp1_;
	gchar* _tmp2_;
	zcdRemoteCall* _tmp3_;
	NetsukukuNIP* _tmp4_;
	GeeList* _tmp5_;
	zcdListString* _tmp6_;
	zcdListString* _hashed_domains;
	zcdRemoteCall* _tmp7_;
	zcdListString* _tmp8_;
	zcdRemoteCall* _tmp9_;
	NetsukukuPublicKey* _tmp10_;
	zcdRemoteCall* _tmp11_;
	zcdSerializableBuffer* _tmp12_;
	zcdRemoteCall* _tmp13_;
	gboolean _tmp14_;
	zcdSerializableBool* _tmp15_;
	zcdSerializableBool* _tmp16_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuRmtCounterPeer*) base;
	g_return_val_if_fail (nip != NULL, NULL);
	g_return_val_if_fail (hashed_domains != NULL, NULL);
	g_return_val_if_fail (pubkey != NULL, NULL);
	g_return_val_if_fail (signature != NULL, NULL);
	_tmp0_ = zcd_remote_call_new ();
	rc = _tmp0_;
	_tmp1_ = rc;
	_tmp2_ = g_strdup ("set_data_for_pubk");
	_g_free0 (_tmp1_->method_name);
	_tmp1_->method_name = _tmp2_;
	_tmp3_ = rc;
	_tmp4_ = nip;
	zcd_remote_call_add_parameter (_tmp3_, (zcdISerializable*) _tmp4_);
	_tmp5_ = hashed_domains;
	_tmp6_ = zcd_list_string_new_with_backer (_tmp5_);
	_hashed_domains = _tmp6_;
	_tmp7_ = rc;
	_tmp8_ = _hashed_domains;
	zcd_remote_call_add_parameter (_tmp7_, (zcdISerializable*) _tmp8_);
	_tmp9_ = rc;
	_tmp10_ = pubkey;
	zcd_remote_call_add_parameter (_tmp9_, (zcdISerializable*) _tmp10_);
	_tmp11_ = rc;
	_tmp12_ = signature;
	zcd_remote_call_add_parameter (_tmp11_, (zcdISerializable*) _tmp12_);
	_tmp13_ = rc;
	_tmp14_ = replicate;
	_tmp15_ = zcd_serializable_bool_new (_tmp14_);
	_tmp16_ = _tmp15_;
	zcd_remote_call_add_parameter (_tmp13_, (zcdISerializable*) _tmp16_);
	_g_object_unref0 (_tmp16_);
	{
		zcdRemoteCall* _tmp17_;
		zcdISerializable* _tmp18_ = NULL;
		zcdISerializable* _tmp19_;
		zcdISerializable* _tmp20_;
		zcdISerializable* _tmp21_ = NULL;
		zcdISerializable* _tmp22_;
		zcdISerializable* _tmp23_;
		zcdISerializable* _tmp24_;
		zcdISerializable* _tmp25_ = NULL;
		zcdISerializable* _tmp26_;
		zcdISerializable* _tmp27_;
		_tmp17_ = rc;
		_tmp18_ = netsukuku_rmt_peer_rmt ((NetsukukuRmtPeer*) self, _tmp17_, &_inner_error_);
		_tmp19_ = _tmp18_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch38_zcd_rpc_error;
			}
			goto __catch38_g_error;
		}
		_tmp20_ = _tmp19_;
		_tmp21_ = netsukuku_filter_exception_PeerRefuseServiceError (_tmp20_, &_inner_error_);
		_tmp22_ = _tmp21_;
		_g_object_unref0 (_tmp20_);
		_tmp23_ = _tmp22_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch38_zcd_rpc_error;
			}
			goto __catch38_g_error;
		}
		_tmp24_ = _tmp23_;
		_tmp25_ = zcd_filter_exception (_tmp24_, &_inner_error_);
		_tmp26_ = _tmp25_;
		_g_object_unref0 (_tmp24_);
		_tmp27_ = _tmp26_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch38_zcd_rpc_error;
			}
			goto __catch38_g_error;
		}
		result = G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, NETSUKUKU_TYPE_COUNTER_SET_DATA_RESPONSE, NetsukukuCounterSetDataResponse);
		_g_object_unref0 (_hashed_domains);
		_g_object_unref0 (rc);
		return result;
	}
	goto __finally38;
	__catch38_zcd_rpc_error:
	{
		GError* e = NULL;
		GError* _tmp28_;
		GError* _tmp29_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp28_ = e;
		_tmp29_ = _g_error_copy0 (_tmp28_);
		_inner_error_ = _tmp29_;
		_g_error_free0 (e);
		goto __finally38;
	}
	goto __finally38;
	__catch38_g_error:
	{
		GError* e = NULL;
		GError* _tmp30_;
		GQuark _tmp31_;
		const gchar* _tmp32_ = NULL;
		GError* _tmp33_;
		gint _tmp34_;
		gchar* _tmp35_ = NULL;
		gchar* _tmp36_;
		GError* _tmp37_;
		const gchar* _tmp38_;
		const gchar* _tmp39_ = NULL;
		gchar* _tmp40_ = NULL;
		gchar* _tmp41_;
		GError* _tmp42_;
		GError* _tmp43_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp30_ = e;
		_tmp31_ = _tmp30_->domain;
		_tmp32_ = g_quark_to_string (_tmp31_);
		_tmp33_ = e;
		_tmp34_ = _tmp33_->code;
		_tmp35_ = g_strdup_printf ("%i", _tmp34_);
		_tmp36_ = _tmp35_;
		_tmp37_ = e;
		_tmp38_ = _tmp37_->message;
		_tmp39_ = string_to_string (_tmp38_);
		_tmp40_ = g_strconcat ("Unexpected error ", _tmp32_, ".", _tmp36_, " '", _tmp39_, "'", NULL);
		_tmp41_ = _tmp40_;
		_tmp42_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_GENERIC, _tmp41_);
		_tmp43_ = _tmp42_;
		_g_free0 (_tmp41_);
		_g_free0 (_tmp36_);
		_inner_error_ = _tmp43_;
		_g_error_free0 (e);
		goto __finally38;
	}
	__finally38:
	if ((_inner_error_->domain == ZCD_RPC_ERROR) || (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (_hashed_domains);
		_g_object_unref0 (rc);
		return NULL;
	} else {
		_g_object_unref0 (_hashed_domains);
		_g_object_unref0 (rc);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_object_unref0 (_hashed_domains);
	_g_object_unref0 (rc);
}


static NetsukukuCounterCheckHostnameResponse* netsukuku_rmt_counter_peer_real_check_hostname (NetsukukuICounterAsPeer* base, NetsukukuNIP* nip, const gchar* hashed_domain, NetsukukuPublicKey* pubkey, GError** error) {
	NetsukukuRmtCounterPeer * self;
	NetsukukuCounterCheckHostnameResponse* result = NULL;
	zcdRemoteCall* _tmp0_;
	zcdRemoteCall* rc;
	zcdRemoteCall* _tmp1_;
	gchar* _tmp2_;
	zcdRemoteCall* _tmp3_;
	NetsukukuNIP* _tmp4_;
	zcdRemoteCall* _tmp5_;
	const gchar* _tmp6_;
	zcdSerializableString* _tmp7_;
	zcdSerializableString* _tmp8_;
	zcdRemoteCall* _tmp9_;
	NetsukukuPublicKey* _tmp10_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuRmtCounterPeer*) base;
	g_return_val_if_fail (nip != NULL, NULL);
	g_return_val_if_fail (hashed_domain != NULL, NULL);
	g_return_val_if_fail (pubkey != NULL, NULL);
	_tmp0_ = zcd_remote_call_new ();
	rc = _tmp0_;
	_tmp1_ = rc;
	_tmp2_ = g_strdup ("check_hostname");
	_g_free0 (_tmp1_->method_name);
	_tmp1_->method_name = _tmp2_;
	_tmp3_ = rc;
	_tmp4_ = nip;
	zcd_remote_call_add_parameter (_tmp3_, (zcdISerializable*) _tmp4_);
	_tmp5_ = rc;
	_tmp6_ = hashed_domain;
	_tmp7_ = zcd_serializable_string_new (_tmp6_);
	_tmp8_ = _tmp7_;
	zcd_remote_call_add_parameter (_tmp5_, (zcdISerializable*) _tmp8_);
	_g_object_unref0 (_tmp8_);
	_tmp9_ = rc;
	_tmp10_ = pubkey;
	zcd_remote_call_add_parameter (_tmp9_, (zcdISerializable*) _tmp10_);
	{
		zcdRemoteCall* _tmp11_;
		zcdISerializable* _tmp12_ = NULL;
		zcdISerializable* _tmp13_;
		zcdISerializable* _tmp14_;
		zcdISerializable* _tmp15_ = NULL;
		zcdISerializable* _tmp16_;
		zcdISerializable* _tmp17_;
		zcdISerializable* _tmp18_;
		zcdISerializable* _tmp19_ = NULL;
		zcdISerializable* _tmp20_;
		zcdISerializable* _tmp21_;
		_tmp11_ = rc;
		_tmp12_ = netsukuku_rmt_peer_rmt ((NetsukukuRmtPeer*) self, _tmp11_, &_inner_error_);
		_tmp13_ = _tmp12_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch39_zcd_rpc_error;
			}
			goto __catch39_g_error;
		}
		_tmp14_ = _tmp13_;
		_tmp15_ = netsukuku_filter_exception_PeerRefuseServiceError (_tmp14_, &_inner_error_);
		_tmp16_ = _tmp15_;
		_g_object_unref0 (_tmp14_);
		_tmp17_ = _tmp16_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch39_zcd_rpc_error;
			}
			goto __catch39_g_error;
		}
		_tmp18_ = _tmp17_;
		_tmp19_ = zcd_filter_exception (_tmp18_, &_inner_error_);
		_tmp20_ = _tmp19_;
		_g_object_unref0 (_tmp18_);
		_tmp21_ = _tmp20_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch39_zcd_rpc_error;
			}
			goto __catch39_g_error;
		}
		result = G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, NETSUKUKU_TYPE_COUNTER_CHECK_HOSTNAME_RESPONSE, NetsukukuCounterCheckHostnameResponse);
		_g_object_unref0 (rc);
		return result;
	}
	goto __finally39;
	__catch39_zcd_rpc_error:
	{
		GError* e = NULL;
		GError* _tmp22_;
		GError* _tmp23_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp22_ = e;
		_tmp23_ = _g_error_copy0 (_tmp22_);
		_inner_error_ = _tmp23_;
		_g_error_free0 (e);
		goto __finally39;
	}
	goto __finally39;
	__catch39_g_error:
	{
		GError* e = NULL;
		GError* _tmp24_;
		GQuark _tmp25_;
		const gchar* _tmp26_ = NULL;
		GError* _tmp27_;
		gint _tmp28_;
		gchar* _tmp29_ = NULL;
		gchar* _tmp30_;
		GError* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_ = NULL;
		gchar* _tmp34_ = NULL;
		gchar* _tmp35_;
		GError* _tmp36_;
		GError* _tmp37_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp24_ = e;
		_tmp25_ = _tmp24_->domain;
		_tmp26_ = g_quark_to_string (_tmp25_);
		_tmp27_ = e;
		_tmp28_ = _tmp27_->code;
		_tmp29_ = g_strdup_printf ("%i", _tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = e;
		_tmp32_ = _tmp31_->message;
		_tmp33_ = string_to_string (_tmp32_);
		_tmp34_ = g_strconcat ("Unexpected error ", _tmp26_, ".", _tmp30_, " '", _tmp33_, "'", NULL);
		_tmp35_ = _tmp34_;
		_tmp36_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_GENERIC, _tmp35_);
		_tmp37_ = _tmp36_;
		_g_free0 (_tmp35_);
		_g_free0 (_tmp30_);
		_inner_error_ = _tmp37_;
		_g_error_free0 (e);
		goto __finally39;
	}
	__finally39:
	if ((_inner_error_->domain == ZCD_RPC_ERROR) || (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (rc);
		return NULL;
	} else {
		_g_object_unref0 (rc);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_object_unref0 (rc);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static NetsukukuCounterNipRecord* netsukuku_rmt_counter_peer_real_get_hostnames (NetsukukuICounterAsPeer* base, NetsukukuNIP* nip, GError** error) {
	NetsukukuRmtCounterPeer * self;
	NetsukukuCounterNipRecord* result = NULL;
	zcdRemoteCall* _tmp0_;
	zcdRemoteCall* rc;
	zcdRemoteCall* _tmp1_;
	gchar* _tmp2_;
	zcdRemoteCall* _tmp3_;
	NetsukukuNIP* _tmp4_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuRmtCounterPeer*) base;
	g_return_val_if_fail (nip != NULL, NULL);
	_tmp0_ = zcd_remote_call_new ();
	rc = _tmp0_;
	_tmp1_ = rc;
	_tmp2_ = g_strdup ("get_hostnames");
	_g_free0 (_tmp1_->method_name);
	_tmp1_->method_name = _tmp2_;
	_tmp3_ = rc;
	_tmp4_ = nip;
	zcd_remote_call_add_parameter (_tmp3_, (zcdISerializable*) _tmp4_);
	{
		zcdRemoteCall* _tmp5_;
		zcdISerializable* _tmp6_ = NULL;
		zcdISerializable* _tmp7_;
		zcdISerializable* _tmp8_;
		zcdISerializable* _tmp9_ = NULL;
		zcdISerializable* _tmp10_;
		zcdISerializable* _tmp11_;
		zcdISerializable* _tmp12_;
		zcdISerializable* _tmp13_ = NULL;
		zcdISerializable* _tmp14_;
		zcdISerializable* ret;
		zcdISerializable* _tmp15_;
		GType _tmp16_ = 0UL;
		gboolean _tmp17_ = FALSE;
		_tmp5_ = rc;
		_tmp6_ = netsukuku_rmt_peer_rmt ((NetsukukuRmtPeer*) self, _tmp5_, &_inner_error_);
		_tmp7_ = _tmp6_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch40_zcd_rpc_error;
			}
			goto __catch40_g_error;
		}
		_tmp8_ = _tmp7_;
		_tmp9_ = netsukuku_filter_exception_PeerRefuseServiceError (_tmp8_, &_inner_error_);
		_tmp10_ = _tmp9_;
		_g_object_unref0 (_tmp8_);
		_tmp11_ = _tmp10_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch40_zcd_rpc_error;
			}
			goto __catch40_g_error;
		}
		_tmp12_ = _tmp11_;
		_tmp13_ = zcd_filter_exception (_tmp12_, &_inner_error_);
		_tmp14_ = _tmp13_;
		_g_object_unref0 (_tmp12_);
		ret = _tmp14_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch40_zcd_rpc_error;
			}
			goto __catch40_g_error;
		}
		_tmp15_ = ret;
		_tmp16_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp15_);
		_tmp17_ = g_type_is_a (_tmp16_, ZCD_TYPE_SERIALIZABLE_NONE);
		if (_tmp17_) {
			result = NULL;
			_g_object_unref0 (ret);
			_g_object_unref0 (rc);
			return result;
		} else {
			zcdISerializable* _tmp18_;
			NetsukukuCounterNipRecord* _tmp19_;
			_tmp18_ = ret;
			_tmp19_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, NETSUKUKU_TYPE_COUNTER_NIP_RECORD, NetsukukuCounterNipRecord));
			result = _tmp19_;
			_g_object_unref0 (ret);
			_g_object_unref0 (rc);
			return result;
		}
		_g_object_unref0 (ret);
	}
	goto __finally40;
	__catch40_zcd_rpc_error:
	{
		GError* e = NULL;
		GError* _tmp20_;
		GError* _tmp21_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp20_ = e;
		_tmp21_ = _g_error_copy0 (_tmp20_);
		_inner_error_ = _tmp21_;
		_g_error_free0 (e);
		goto __finally40;
	}
	goto __finally40;
	__catch40_g_error:
	{
		GError* e = NULL;
		GError* _tmp22_;
		GQuark _tmp23_;
		const gchar* _tmp24_ = NULL;
		GError* _tmp25_;
		gint _tmp26_;
		gchar* _tmp27_ = NULL;
		gchar* _tmp28_;
		GError* _tmp29_;
		const gchar* _tmp30_;
		const gchar* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
		gchar* _tmp33_;
		GError* _tmp34_;
		GError* _tmp35_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp22_ = e;
		_tmp23_ = _tmp22_->domain;
		_tmp24_ = g_quark_to_string (_tmp23_);
		_tmp25_ = e;
		_tmp26_ = _tmp25_->code;
		_tmp27_ = g_strdup_printf ("%i", _tmp26_);
		_tmp28_ = _tmp27_;
		_tmp29_ = e;
		_tmp30_ = _tmp29_->message;
		_tmp31_ = string_to_string (_tmp30_);
		_tmp32_ = g_strconcat ("Unexpected error ", _tmp24_, ".", _tmp28_, " '", _tmp31_, "'", NULL);
		_tmp33_ = _tmp32_;
		_tmp34_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_GENERIC, _tmp33_);
		_tmp35_ = _tmp34_;
		_g_free0 (_tmp33_);
		_g_free0 (_tmp28_);
		_inner_error_ = _tmp35_;
		_g_error_free0 (e);
		goto __finally40;
	}
	__finally40:
	if ((_inner_error_->domain == ZCD_RPC_ERROR) || (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (rc);
		return NULL;
	} else {
		_g_object_unref0 (rc);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_object_unref0 (rc);
}


static NetsukukuCounterGetCacheRecordsResponse* netsukuku_rmt_counter_peer_real_get_cache_records (NetsukukuICounterAsPeer* base, GError** error) {
	NetsukukuRmtCounterPeer * self;
	NetsukukuCounterGetCacheRecordsResponse* result = NULL;
	zcdRemoteCall* _tmp0_;
	zcdRemoteCall* rc;
	zcdRemoteCall* _tmp1_;
	gchar* _tmp2_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuRmtCounterPeer*) base;
	_tmp0_ = zcd_remote_call_new ();
	rc = _tmp0_;
	_tmp1_ = rc;
	_tmp2_ = g_strdup ("get_cache_records");
	_g_free0 (_tmp1_->method_name);
	_tmp1_->method_name = _tmp2_;
	{
		zcdRemoteCall* _tmp3_;
		zcdISerializable* _tmp4_ = NULL;
		zcdISerializable* _tmp5_;
		zcdISerializable* _tmp6_;
		zcdISerializable* _tmp7_ = NULL;
		zcdISerializable* _tmp8_;
		zcdISerializable* _tmp9_;
		zcdISerializable* _tmp10_;
		zcdISerializable* _tmp11_ = NULL;
		zcdISerializable* _tmp12_;
		zcdISerializable* _tmp13_;
		_tmp3_ = rc;
		_tmp4_ = netsukuku_rmt_peer_rmt ((NetsukukuRmtPeer*) self, _tmp3_, &_inner_error_);
		_tmp5_ = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch41_zcd_rpc_error;
			}
			goto __catch41_g_error;
		}
		_tmp6_ = _tmp5_;
		_tmp7_ = netsukuku_filter_exception_PeerRefuseServiceError (_tmp6_, &_inner_error_);
		_tmp8_ = _tmp7_;
		_g_object_unref0 (_tmp6_);
		_tmp9_ = _tmp8_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch41_zcd_rpc_error;
			}
			goto __catch41_g_error;
		}
		_tmp10_ = _tmp9_;
		_tmp11_ = zcd_filter_exception (_tmp10_, &_inner_error_);
		_tmp12_ = _tmp11_;
		_g_object_unref0 (_tmp10_);
		_tmp13_ = _tmp12_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch41_zcd_rpc_error;
			}
			goto __catch41_g_error;
		}
		result = G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, NETSUKUKU_TYPE_COUNTER_GET_CACHE_RECORDS_RESPONSE, NetsukukuCounterGetCacheRecordsResponse);
		_g_object_unref0 (rc);
		return result;
	}
	goto __finally41;
	__catch41_zcd_rpc_error:
	{
		GError* e = NULL;
		GError* _tmp14_;
		GError* _tmp15_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp14_ = e;
		_tmp15_ = _g_error_copy0 (_tmp14_);
		_inner_error_ = _tmp15_;
		_g_error_free0 (e);
		goto __finally41;
	}
	goto __finally41;
	__catch41_g_error:
	{
		GError* e = NULL;
		GError* _tmp16_;
		GQuark _tmp17_;
		const gchar* _tmp18_ = NULL;
		GError* _tmp19_;
		gint _tmp20_;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_;
		GError* _tmp23_;
		const gchar* _tmp24_;
		const gchar* _tmp25_ = NULL;
		gchar* _tmp26_ = NULL;
		gchar* _tmp27_;
		GError* _tmp28_;
		GError* _tmp29_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp16_ = e;
		_tmp17_ = _tmp16_->domain;
		_tmp18_ = g_quark_to_string (_tmp17_);
		_tmp19_ = e;
		_tmp20_ = _tmp19_->code;
		_tmp21_ = g_strdup_printf ("%i", _tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = e;
		_tmp24_ = _tmp23_->message;
		_tmp25_ = string_to_string (_tmp24_);
		_tmp26_ = g_strconcat ("Unexpected error ", _tmp18_, ".", _tmp22_, " '", _tmp25_, "'", NULL);
		_tmp27_ = _tmp26_;
		_tmp28_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_GENERIC, _tmp27_);
		_tmp29_ = _tmp28_;
		_g_free0 (_tmp27_);
		_g_free0 (_tmp22_);
		_inner_error_ = _tmp29_;
		_g_error_free0 (e);
		goto __finally41;
	}
	__finally41:
	if ((_inner_error_->domain == ZCD_RPC_ERROR) || (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (rc);
		return NULL;
	} else {
		_g_object_unref0 (rc);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_object_unref0 (rc);
}


static void netsukuku_rmt_counter_peer_class_init (NetsukukuRmtCounterPeerClass * klass) {
	netsukuku_rmt_counter_peer_parent_class = g_type_class_peek_parent (klass);
}


static void netsukuku_rmt_counter_peer_netsukuku_icounter_as_peer_interface_init (NetsukukuICounterAsPeerIface * iface) {
	netsukuku_rmt_counter_peer_netsukuku_icounter_as_peer_parent_iface = g_type_interface_peek_parent (iface);
	iface->set_data_for_pubk = (NetsukukuCounterSetDataResponse* (*)(NetsukukuICounterAsPeer*, NetsukukuNIP*, GeeList*, NetsukukuPublicKey*, zcdSerializableBuffer*, gboolean, GError**)) netsukuku_rmt_counter_peer_real_set_data_for_pubk;
	iface->check_hostname = (NetsukukuCounterCheckHostnameResponse* (*)(NetsukukuICounterAsPeer*, NetsukukuNIP*, const gchar*, NetsukukuPublicKey*, GError**)) netsukuku_rmt_counter_peer_real_check_hostname;
	iface->get_hostnames = (NetsukukuCounterNipRecord* (*)(NetsukukuICounterAsPeer*, NetsukukuNIP*, GError**)) netsukuku_rmt_counter_peer_real_get_hostnames;
	iface->get_cache_records = (NetsukukuCounterGetCacheRecordsResponse* (*)(NetsukukuICounterAsPeer*, GError**)) netsukuku_rmt_counter_peer_real_get_cache_records;
}


static void netsukuku_rmt_counter_peer_instance_init (NetsukukuRmtCounterPeer * self) {
}


GType netsukuku_rmt_counter_peer_get_type (void) {
	static volatile gsize netsukuku_rmt_counter_peer_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_rmt_counter_peer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuRmtCounterPeerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_rmt_counter_peer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuRmtCounterPeer), 0, (GInstanceInitFunc) netsukuku_rmt_counter_peer_instance_init, NULL };
		static const GInterfaceInfo netsukuku_icounter_as_peer_info = { (GInterfaceInitFunc) netsukuku_rmt_counter_peer_netsukuku_icounter_as_peer_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType netsukuku_rmt_counter_peer_type_id;
		netsukuku_rmt_counter_peer_type_id = g_type_register_static (NETSUKUKU_TYPE_RMT_PEER, "NetsukukuRmtCounterPeer", &g_define_type_info, 0);
		g_type_add_interface_static (netsukuku_rmt_counter_peer_type_id, NETSUKUKU_TYPE_ICOUNTER_AS_PEER, &netsukuku_icounter_as_peer_info);
		g_once_init_leave (&netsukuku_rmt_counter_peer_type_id__volatile, netsukuku_rmt_counter_peer_type_id);
	}
	return netsukuku_rmt_counter_peer_type_id__volatile;
}


NetsukukuArgumentsForDuplicationSetData* netsukuku_arguments_for_duplication_set_data_construct (GType object_type) {
	NetsukukuArgumentsForDuplicationSetData * self = NULL;
	self = (NetsukukuArgumentsForDuplicationSetData*) g_object_new (object_type, NULL);
	return self;
}


NetsukukuArgumentsForDuplicationSetData* netsukuku_arguments_for_duplication_set_data_new (void) {
	return netsukuku_arguments_for_duplication_set_data_construct (NETSUKUKU_TYPE_ARGUMENTS_FOR_DUPLICATION_SET_DATA);
}


static void netsukuku_arguments_for_duplication_set_data_class_init (NetsukukuArgumentsForDuplicationSetDataClass * klass) {
	netsukuku_arguments_for_duplication_set_data_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = netsukuku_arguments_for_duplication_set_data_finalize;
}


static void netsukuku_arguments_for_duplication_set_data_instance_init (NetsukukuArgumentsForDuplicationSetData * self) {
}


static void netsukuku_arguments_for_duplication_set_data_finalize (GObject* obj) {
	NetsukukuArgumentsForDuplicationSetData * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_ARGUMENTS_FOR_DUPLICATION_SET_DATA, NetsukukuArgumentsForDuplicationSetData);
	_g_object_unref0 (self->nip);
	_g_object_unref0 (self->hashed_domains);
	_g_object_unref0 (self->pubkey);
	_g_object_unref0 (self->signature);
	_g_object_unref0 (self->hashnode);
	G_OBJECT_CLASS (netsukuku_arguments_for_duplication_set_data_parent_class)->finalize (obj);
}


GType netsukuku_arguments_for_duplication_set_data_get_type (void) {
	static volatile gsize netsukuku_arguments_for_duplication_set_data_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_arguments_for_duplication_set_data_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuArgumentsForDuplicationSetDataClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_arguments_for_duplication_set_data_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuArgumentsForDuplicationSetData), 0, (GInstanceInitFunc) netsukuku_arguments_for_duplication_set_data_instance_init, NULL };
		GType netsukuku_arguments_for_duplication_set_data_type_id;
		netsukuku_arguments_for_duplication_set_data_type_id = g_type_register_static (G_TYPE_OBJECT, "NetsukukuArgumentsForDuplicationSetData", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_arguments_for_duplication_set_data_type_id__volatile, netsukuku_arguments_for_duplication_set_data_type_id);
	}
	return netsukuku_arguments_for_duplication_set_data_type_id__volatile;
}


void netsukuku_struct_helper_counter_hook_to_service_copy (const Netsukukustruct_helper_Counter_hook_to_service* self, Netsukukustruct_helper_Counter_hook_to_service* dest) {
	NetsukukuCounter* _tmp0_;
	NetsukukuCounter* _tmp1_;
	_tmp0_ = (*self).self;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 ((*dest).self);
	(*dest).self = _tmp1_;
}


void netsukuku_struct_helper_counter_hook_to_service_destroy (Netsukukustruct_helper_Counter_hook_to_service* self) {
	_g_object_unref0 ((*self).self);
}


Netsukukustruct_helper_Counter_hook_to_service* netsukuku_struct_helper_counter_hook_to_service_dup (const Netsukukustruct_helper_Counter_hook_to_service* self) {
	Netsukukustruct_helper_Counter_hook_to_service* dup;
	dup = g_new0 (Netsukukustruct_helper_Counter_hook_to_service, 1);
	netsukuku_struct_helper_counter_hook_to_service_copy (self, dup);
	return dup;
}


void netsukuku_struct_helper_counter_hook_to_service_free (Netsukukustruct_helper_Counter_hook_to_service* self) {
	netsukuku_struct_helper_counter_hook_to_service_destroy (self);
	g_free (self);
}


GType netsukuku_struct_helper_counter_hook_to_service_get_type (void) {
	static volatile gsize netsukuku_struct_helper_counter_hook_to_service_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_struct_helper_counter_hook_to_service_type_id__volatile)) {
		GType netsukuku_struct_helper_counter_hook_to_service_type_id;
		netsukuku_struct_helper_counter_hook_to_service_type_id = g_boxed_type_register_static ("Netsukukustruct_helper_Counter_hook_to_service", (GBoxedCopyFunc) netsukuku_struct_helper_counter_hook_to_service_dup, (GBoxedFreeFunc) netsukuku_struct_helper_counter_hook_to_service_free);
		g_once_init_leave (&netsukuku_struct_helper_counter_hook_to_service_type_id__volatile, netsukuku_struct_helper_counter_hook_to_service_type_id);
	}
	return netsukuku_struct_helper_counter_hook_to_service_type_id__volatile;
}


void netsukuku_struct_helper_counter_reset_my_counter_node_copy (const Netsukukustruct_helper_Counter_reset_my_counter_node* self, Netsukukustruct_helper_Counter_reset_my_counter_node* dest) {
	NetsukukuCounter* _tmp0_;
	NetsukukuCounter* _tmp1_;
	_tmp0_ = (*self).self;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 ((*dest).self);
	(*dest).self = _tmp1_;
}


void netsukuku_struct_helper_counter_reset_my_counter_node_destroy (Netsukukustruct_helper_Counter_reset_my_counter_node* self) {
	_g_object_unref0 ((*self).self);
}


Netsukukustruct_helper_Counter_reset_my_counter_node* netsukuku_struct_helper_counter_reset_my_counter_node_dup (const Netsukukustruct_helper_Counter_reset_my_counter_node* self) {
	Netsukukustruct_helper_Counter_reset_my_counter_node* dup;
	dup = g_new0 (Netsukukustruct_helper_Counter_reset_my_counter_node, 1);
	netsukuku_struct_helper_counter_reset_my_counter_node_copy (self, dup);
	return dup;
}


void netsukuku_struct_helper_counter_reset_my_counter_node_free (Netsukukustruct_helper_Counter_reset_my_counter_node* self) {
	netsukuku_struct_helper_counter_reset_my_counter_node_destroy (self);
	g_free (self);
}


GType netsukuku_struct_helper_counter_reset_my_counter_node_get_type (void) {
	static volatile gsize netsukuku_struct_helper_counter_reset_my_counter_node_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_struct_helper_counter_reset_my_counter_node_type_id__volatile)) {
		GType netsukuku_struct_helper_counter_reset_my_counter_node_type_id;
		netsukuku_struct_helper_counter_reset_my_counter_node_type_id = g_boxed_type_register_static ("Netsukukustruct_helper_Counter_reset_my_counter_node", (GBoxedCopyFunc) netsukuku_struct_helper_counter_reset_my_counter_node_dup, (GBoxedFreeFunc) netsukuku_struct_helper_counter_reset_my_counter_node_free);
		g_once_init_leave (&netsukuku_struct_helper_counter_reset_my_counter_node_type_id__volatile, netsukuku_struct_helper_counter_reset_my_counter_node_type_id);
	}
	return netsukuku_struct_helper_counter_reset_my_counter_node_type_id__volatile;
}


static void _netsukuku_counter_hook_to_service_netsukuku_peer_to_peer_map_peer_to_peer_validated (NetsukukuPeerToPeer* _sender, gpointer self) {
	netsukuku_counter_hook_to_service (self);
}


static guint _netsukuku_pair_public_key_nip_hash_func_gee_hash_data_func (gconstpointer v, gpointer self) {
	guint result;
	result = netsukuku_pair_public_key_nip_hash_func (v);
	return result;
}


static gboolean _netsukuku_pair_public_key_nip_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gboolean result;
	result = netsukuku_pair_public_key_nip_equal_func (a, b);
	return result;
}


NetsukukuCounter* netsukuku_counter_construct (GType object_type, NetsukukuKeyPair* keypair, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, NetsukukuPeerToPeerAll* peer_to_peer_all) {
	NetsukukuCounter * self = NULL;
	NetsukukuAggregatedNeighbourManager* _tmp0_;
	NetsukukuMapRoute* _tmp1_;
	NetsukukuPeerToPeerAll* _tmp2_;
	NetsukukuPeerToPeerAll* _tmp3_;
	NetsukukuKeyPair* _tmp4_;
	NetsukukuKeyPair* _tmp5_;
	NetsukukuKeyPair* _tmp6_;
	NetsukukuPublicKeyWrapper* _tmp7_;
	NetsukukuPublicKeyWrapper* _tmp8_;
	NetsukukuPublicKey* _tmp9_ = NULL;
	NetsukukuPeerToPeerAll* _tmp10_;
	GeeHashMap* _tmp11_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (keypair != NULL, NULL);
	g_return_val_if_fail (aggregated_neighbour_manager != NULL, NULL);
	g_return_val_if_fail (maproute != NULL, NULL);
	g_return_val_if_fail (peer_to_peer_all != NULL, NULL);
	_tmp0_ = aggregated_neighbour_manager;
	_tmp1_ = maproute;
	self = (NetsukukuCounter*) netsukuku_optional_peer_to_peer_construct (object_type, _tmp0_, _tmp1_, NETSUKUKU_COUNTER_mypid);
	_tmp2_ = peer_to_peer_all;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->peer_to_peer_all);
	self->priv->peer_to_peer_all = _tmp3_;
	_tmp4_ = keypair;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (self->priv->my_keys);
	self->priv->my_keys = _tmp5_;
	_tmp6_ = self->priv->my_keys;
	_tmp7_ = netsukuku_key_pair_get_pub_key (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = netsukuku_public_key_wrapper_to_pubkey (_tmp8_);
	_g_object_unref0 (self->priv->pubk);
	self->priv->pubk = _tmp9_;
	_g_object_unref0 (self->priv->reset_my_counter_node_tasklet);
	self->priv->reset_my_counter_node_tasklet = NULL;
	((NetsukukuOptionalPeerToPeer*) self)->will_participate = TRUE;
	_tmp10_ = self->priv->peer_to_peer_all;
	netsukuku_peer_to_peer_all_peer_to_peer_register (_tmp10_, (NetsukukuPeerToPeer*) self, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	self->priv->hooked_to_service = FALSE;
	g_signal_connect_object ((NetsukukuPeerToPeer*) self, "map-peer-to-peer-validated", (GCallback) _netsukuku_counter_hook_to_service_netsukuku_peer_to_peer_map_peer_to_peer_validated, self, 0);
	_tmp11_ = gee_hash_map_new (NETSUKUKU_TYPE_PAIR_PUBLIC_KEY_NIP, (GBoxedCopyFunc) g_object_ref, g_object_unref, NETSUKUKU_TYPE_COUNTER_NIP_RECORD, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_pair_public_key_nip_hash_func_gee_hash_data_func, NULL, NULL, _netsukuku_pair_public_key_nip_equal_func_gee_equal_data_func, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->cache);
	self->priv->cache = _tmp11_;
	return self;
}


NetsukukuCounter* netsukuku_counter_new (NetsukukuKeyPair* keypair, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, NetsukukuPeerToPeerAll* peer_to_peer_all) {
	return netsukuku_counter_construct (NETSUKUKU_TYPE_COUNTER, keypair, aggregated_neighbour_manager, maproute, peer_to_peer_all);
}


NetsukukuRmtCounterPeer* netsukuku_counter_peer (NetsukukuCounter* self, NetsukukuNIP* hIP, GObject* key, NetsukukuAggregatedNeighbour* aggregated_neighbour) {
	NetsukukuRmtCounterPeer* result = NULL;
	gboolean _tmp0_ = FALSE;
	NetsukukuNIP* _tmp1_;
	gboolean _tmp3_;
	GObject* _tmp4_;
	NetsukukuNIP* _tmp5_;
	NetsukukuAggregatedNeighbour* _tmp6_;
	NetsukukuRmtCounterPeer* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = hIP;
	if (_tmp1_ != NULL) {
		_tmp0_ = TRUE;
	} else {
		GObject* _tmp2_;
		_tmp2_ = key;
		_tmp0_ = _tmp2_ != NULL;
	}
	_tmp3_ = _tmp0_;
	_vala_assert (_tmp3_, "hIP != null || key != null");
	_tmp4_ = key;
	_tmp5_ = hIP;
	_tmp6_ = aggregated_neighbour;
	_tmp7_ = netsukuku_rmt_counter_peer_new ((NetsukukuPeerToPeer*) self, _tmp4_, _tmp5_, _tmp6_);
	result = _tmp7_;
	return result;
}


/** This method could be called *directly* for a dispatcher that does not need to transform
          * an exception into a remotable.
          */
static zcdISerializable* netsukuku_counter_real__dispatch (zcdRPCDispatcher* base, GObject* caller, zcdRemoteCall* data, GError** error) {
	NetsukukuCounter * self;
	zcdISerializable* result = NULL;
	zcdRemoteCall* _tmp0_;
	const gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_ = NULL;
	gchar** pieces;
	gint pieces_length1;
	gint _pieces_size_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	const gchar* _tmp5_;
	gchar** _tmp75_;
	gint _tmp75__length1;
	const gchar* _tmp76_;
	gchar** _tmp122_;
	gint _tmp122__length1;
	const gchar* _tmp123_;
	gchar** _tmp146_;
	gint _tmp146__length1;
	const gchar* _tmp147_;
	GObject* _tmp158_;
	zcdRemoteCall* _tmp159_;
	zcdISerializable* _tmp160_ = NULL;
	zcdISerializable* _tmp161_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuCounter*) base;
	g_return_val_if_fail (data != NULL, NULL);
	_tmp0_ = data;
	_tmp1_ = _tmp0_->method_name;
	_tmp3_ = _tmp2_ = g_strsplit (_tmp1_, ".", 0);
	pieces = _tmp3_;
	pieces_length1 = _vala_array_length (_tmp2_);
	_pieces_size_ = pieces_length1;
	_tmp4_ = pieces;
	_tmp4__length1 = pieces_length1;
	_tmp5_ = _tmp4_[0];
	if (g_strcmp0 (_tmp5_, "set_data_for_pubk") == 0) {
		gchar** _tmp6_;
		gint _tmp6__length1;
		zcdRemoteCall* _tmp8_;
		GeeList* _tmp9_;
		GeeList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		zcdRemoteCall* _tmp14_;
		GeeList* _tmp15_;
		GeeList* _tmp16_;
		gpointer _tmp17_ = NULL;
		zcdISerializable* iser0;
		zcdISerializable* _tmp18_;
		GType _tmp19_ = 0UL;
		gboolean _tmp20_ = FALSE;
		zcdISerializable* _tmp22_;
		NetsukukuNIP* _tmp23_;
		NetsukukuNIP* nip;
		zcdRemoteCall* _tmp24_;
		GeeList* _tmp25_;
		GeeList* _tmp26_;
		gpointer _tmp27_ = NULL;
		zcdISerializable* iser1;
		zcdISerializable* _tmp28_;
		GType _tmp29_ = 0UL;
		gboolean _tmp30_ = FALSE;
		zcdISerializable* _tmp32_;
		zcdListString* _tmp33_;
		zcdListString* _hashed_domains;
		zcdListString* _tmp34_;
		GeeList* _tmp35_;
		GeeList* _tmp36_;
		GeeList* hashed_domains;
		zcdRemoteCall* _tmp37_;
		GeeList* _tmp38_;
		GeeList* _tmp39_;
		gpointer _tmp40_ = NULL;
		zcdISerializable* iser2;
		zcdISerializable* _tmp41_;
		GType _tmp42_ = 0UL;
		gboolean _tmp43_ = FALSE;
		zcdISerializable* _tmp45_;
		NetsukukuPublicKey* _tmp46_;
		NetsukukuPublicKey* pubkey;
		zcdRemoteCall* _tmp47_;
		GeeList* _tmp48_;
		GeeList* _tmp49_;
		gpointer _tmp50_ = NULL;
		zcdISerializable* iser3;
		zcdISerializable* _tmp51_;
		GType _tmp52_ = 0UL;
		gboolean _tmp53_ = FALSE;
		zcdISerializable* _tmp55_;
		zcdSerializableBuffer* _tmp56_;
		zcdSerializableBuffer* signature;
		zcdRemoteCall* _tmp57_;
		GeeList* _tmp58_;
		GeeList* _tmp59_;
		gpointer _tmp60_ = NULL;
		zcdISerializable* iser4;
		zcdISerializable* _tmp61_;
		GType _tmp62_ = 0UL;
		gboolean _tmp63_ = FALSE;
		zcdISerializable* _tmp65_;
		gboolean _tmp66_;
		gboolean _tmp67_;
		gboolean replicate;
		NetsukukuNIP* _tmp68_;
		GeeList* _tmp69_;
		NetsukukuPublicKey* _tmp70_;
		zcdSerializableBuffer* _tmp71_;
		gboolean _tmp72_;
		NetsukukuCounterSetDataResponse* _tmp73_ = NULL;
		NetsukukuCounterSetDataResponse* _tmp74_;
		_tmp6_ = pieces;
		_tmp6__length1 = pieces_length1;
		if (_tmp6__length1 != 1) {
			GError* _tmp7_;
			_tmp7_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "set_data_for_pubk is a function.");
			_inner_error_ = _tmp7_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp8_ = data;
		_tmp9_ = zcd_remote_call_get_parameters (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = gee_collection_get_size ((GeeCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		if (_tmp12_ != 5) {
			GError* _tmp13_;
			_tmp13_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "set_data_for_pubk wants 5 parameters.");
			_inner_error_ = _tmp13_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp14_ = data;
		_tmp15_ = zcd_remote_call_get_parameters (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = gee_list_get (_tmp16_, 0);
		iser0 = (zcdISerializable*) _tmp17_;
		_tmp18_ = iser0;
		_tmp19_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp18_);
		_tmp20_ = g_type_is_a (_tmp19_, NETSUKUKU_TYPE_NIP);
		if (!_tmp20_) {
			GError* _tmp21_;
			_tmp21_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "set_data_for_pubk parameter 1 is not a NIP.");
			_inner_error_ = _tmp21_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp22_ = iser0;
		_tmp23_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, NETSUKUKU_TYPE_NIP, NetsukukuNIP));
		nip = _tmp23_;
		_tmp24_ = data;
		_tmp25_ = zcd_remote_call_get_parameters (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = gee_list_get (_tmp26_, 1);
		iser1 = (zcdISerializable*) _tmp27_;
		_tmp28_ = iser1;
		_tmp29_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp28_);
		_tmp30_ = g_type_is_a (_tmp29_, ZCD_TYPE_LIST_STRING);
		if (!_tmp30_) {
			GError* _tmp31_;
			_tmp31_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "set_data_for_pubk parameter 2 is not a List<string>.");
			_inner_error_ = _tmp31_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser1);
			_g_object_unref0 (nip);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp32_ = iser1;
		_tmp33_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, ZCD_TYPE_LIST_STRING, zcdListString));
		_hashed_domains = _tmp33_;
		_tmp34_ = _hashed_domains;
		_tmp35_ = _tmp34_->backed;
		_tmp36_ = _g_object_ref0 (_tmp35_);
		hashed_domains = _tmp36_;
		_tmp37_ = data;
		_tmp38_ = zcd_remote_call_get_parameters (_tmp37_);
		_tmp39_ = _tmp38_;
		_tmp40_ = gee_list_get (_tmp39_, 2);
		iser2 = (zcdISerializable*) _tmp40_;
		_tmp41_ = iser2;
		_tmp42_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp41_);
		_tmp43_ = g_type_is_a (_tmp42_, NETSUKUKU_TYPE_PUBLIC_KEY);
		if (!_tmp43_) {
			GError* _tmp44_;
			_tmp44_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "set_data_for_pubk parameter 3 is not a PublicKey.");
			_inner_error_ = _tmp44_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser2);
			_g_object_unref0 (hashed_domains);
			_g_object_unref0 (_hashed_domains);
			_g_object_unref0 (iser1);
			_g_object_unref0 (nip);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp45_ = iser2;
		_tmp46_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, NETSUKUKU_TYPE_PUBLIC_KEY, NetsukukuPublicKey));
		pubkey = _tmp46_;
		_tmp47_ = data;
		_tmp48_ = zcd_remote_call_get_parameters (_tmp47_);
		_tmp49_ = _tmp48_;
		_tmp50_ = gee_list_get (_tmp49_, 3);
		iser3 = (zcdISerializable*) _tmp50_;
		_tmp51_ = iser3;
		_tmp52_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp51_);
		_tmp53_ = g_type_is_a (_tmp52_, ZCD_TYPE_SERIALIZABLE_BUFFER);
		if (!_tmp53_) {
			GError* _tmp54_;
			_tmp54_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "set_data_for_pubk parameter 4 is not a SerializableBuffer.");
			_inner_error_ = _tmp54_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser3);
			_g_object_unref0 (pubkey);
			_g_object_unref0 (iser2);
			_g_object_unref0 (hashed_domains);
			_g_object_unref0 (_hashed_domains);
			_g_object_unref0 (iser1);
			_g_object_unref0 (nip);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp55_ = iser3;
		_tmp56_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp55_, ZCD_TYPE_SERIALIZABLE_BUFFER, zcdSerializableBuffer));
		signature = _tmp56_;
		_tmp57_ = data;
		_tmp58_ = zcd_remote_call_get_parameters (_tmp57_);
		_tmp59_ = _tmp58_;
		_tmp60_ = gee_list_get (_tmp59_, 4);
		iser4 = (zcdISerializable*) _tmp60_;
		_tmp61_ = iser4;
		_tmp62_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp61_);
		_tmp63_ = g_type_is_a (_tmp62_, ZCD_TYPE_SERIALIZABLE_BOOL);
		if (!_tmp63_) {
			GError* _tmp64_;
			_tmp64_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "set_data_for_pubk parameter 5 is not a bool.");
			_inner_error_ = _tmp64_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser4);
			_g_object_unref0 (signature);
			_g_object_unref0 (iser3);
			_g_object_unref0 (pubkey);
			_g_object_unref0 (iser2);
			_g_object_unref0 (hashed_domains);
			_g_object_unref0 (_hashed_domains);
			_g_object_unref0 (iser1);
			_g_object_unref0 (nip);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp65_ = iser4;
		_tmp66_ = zcd_serializable_bool_get_b (G_TYPE_CHECK_INSTANCE_CAST (_tmp65_, ZCD_TYPE_SERIALIZABLE_BOOL, zcdSerializableBool));
		_tmp67_ = _tmp66_;
		replicate = _tmp67_;
		_tmp68_ = nip;
		_tmp69_ = hashed_domains;
		_tmp70_ = pubkey;
		_tmp71_ = signature;
		_tmp72_ = replicate;
		_tmp73_ = netsukuku_icounter_as_peer_set_data_for_pubk ((NetsukukuICounterAsPeer*) self, _tmp68_, _tmp69_, _tmp70_, _tmp71_, _tmp72_, &_inner_error_);
		_tmp74_ = _tmp73_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser4);
			_g_object_unref0 (signature);
			_g_object_unref0 (iser3);
			_g_object_unref0 (pubkey);
			_g_object_unref0 (iser2);
			_g_object_unref0 (hashed_domains);
			_g_object_unref0 (_hashed_domains);
			_g_object_unref0 (iser1);
			_g_object_unref0 (nip);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		result = (zcdISerializable*) _tmp74_;
		_g_object_unref0 (iser4);
		_g_object_unref0 (signature);
		_g_object_unref0 (iser3);
		_g_object_unref0 (pubkey);
		_g_object_unref0 (iser2);
		_g_object_unref0 (hashed_domains);
		_g_object_unref0 (_hashed_domains);
		_g_object_unref0 (iser1);
		_g_object_unref0 (nip);
		_g_object_unref0 (iser0);
		pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp75_ = pieces;
	_tmp75__length1 = pieces_length1;
	_tmp76_ = _tmp75_[0];
	if (g_strcmp0 (_tmp76_, "check_hostname") == 0) {
		gchar** _tmp77_;
		gint _tmp77__length1;
		zcdRemoteCall* _tmp79_;
		GeeList* _tmp80_;
		GeeList* _tmp81_;
		gint _tmp82_;
		gint _tmp83_;
		zcdRemoteCall* _tmp85_;
		GeeList* _tmp86_;
		GeeList* _tmp87_;
		gpointer _tmp88_ = NULL;
		zcdISerializable* iser0;
		zcdISerializable* _tmp89_;
		GType _tmp90_ = 0UL;
		gboolean _tmp91_ = FALSE;
		zcdISerializable* _tmp93_;
		NetsukukuNIP* _tmp94_;
		NetsukukuNIP* nip;
		zcdRemoteCall* _tmp95_;
		GeeList* _tmp96_;
		GeeList* _tmp97_;
		gpointer _tmp98_ = NULL;
		zcdISerializable* iser1;
		zcdISerializable* _tmp99_;
		GType _tmp100_ = 0UL;
		gboolean _tmp101_ = FALSE;
		zcdISerializable* _tmp103_;
		const gchar* _tmp104_;
		const gchar* _tmp105_;
		gchar* _tmp106_;
		gchar* hashed_domain;
		zcdRemoteCall* _tmp107_;
		GeeList* _tmp108_;
		GeeList* _tmp109_;
		gpointer _tmp110_ = NULL;
		zcdISerializable* iser2;
		zcdISerializable* _tmp111_;
		GType _tmp112_ = 0UL;
		gboolean _tmp113_ = FALSE;
		zcdISerializable* _tmp115_;
		NetsukukuPublicKey* _tmp116_;
		NetsukukuPublicKey* pubkey;
		NetsukukuNIP* _tmp117_;
		const gchar* _tmp118_;
		NetsukukuPublicKey* _tmp119_;
		NetsukukuCounterCheckHostnameResponse* _tmp120_ = NULL;
		NetsukukuCounterCheckHostnameResponse* _tmp121_;
		_tmp77_ = pieces;
		_tmp77__length1 = pieces_length1;
		if (_tmp77__length1 != 1) {
			GError* _tmp78_;
			_tmp78_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "check_hostname is a function.");
			_inner_error_ = _tmp78_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp79_ = data;
		_tmp80_ = zcd_remote_call_get_parameters (_tmp79_);
		_tmp81_ = _tmp80_;
		_tmp82_ = gee_collection_get_size ((GeeCollection*) _tmp81_);
		_tmp83_ = _tmp82_;
		if (_tmp83_ != 3) {
			GError* _tmp84_;
			_tmp84_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "check_hostname wants 3 parameters.");
			_inner_error_ = _tmp84_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp85_ = data;
		_tmp86_ = zcd_remote_call_get_parameters (_tmp85_);
		_tmp87_ = _tmp86_;
		_tmp88_ = gee_list_get (_tmp87_, 0);
		iser0 = (zcdISerializable*) _tmp88_;
		_tmp89_ = iser0;
		_tmp90_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp89_);
		_tmp91_ = g_type_is_a (_tmp90_, NETSUKUKU_TYPE_NIP);
		if (!_tmp91_) {
			GError* _tmp92_;
			_tmp92_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "check_hostname parameter 1 is not a NIP.");
			_inner_error_ = _tmp92_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp93_ = iser0;
		_tmp94_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp93_, NETSUKUKU_TYPE_NIP, NetsukukuNIP));
		nip = _tmp94_;
		_tmp95_ = data;
		_tmp96_ = zcd_remote_call_get_parameters (_tmp95_);
		_tmp97_ = _tmp96_;
		_tmp98_ = gee_list_get (_tmp97_, 1);
		iser1 = (zcdISerializable*) _tmp98_;
		_tmp99_ = iser1;
		_tmp100_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp99_);
		_tmp101_ = g_type_is_a (_tmp100_, ZCD_TYPE_SERIALIZABLE_STRING);
		if (!_tmp101_) {
			GError* _tmp102_;
			_tmp102_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "check_hostname parameter 2 is not a string.");
			_inner_error_ = _tmp102_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser1);
			_g_object_unref0 (nip);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp103_ = iser1;
		_tmp104_ = zcd_serializable_string_get_s (G_TYPE_CHECK_INSTANCE_CAST (_tmp103_, ZCD_TYPE_SERIALIZABLE_STRING, zcdSerializableString));
		_tmp105_ = _tmp104_;
		_tmp106_ = g_strdup (_tmp105_);
		hashed_domain = _tmp106_;
		_tmp107_ = data;
		_tmp108_ = zcd_remote_call_get_parameters (_tmp107_);
		_tmp109_ = _tmp108_;
		_tmp110_ = gee_list_get (_tmp109_, 2);
		iser2 = (zcdISerializable*) _tmp110_;
		_tmp111_ = iser2;
		_tmp112_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp111_);
		_tmp113_ = g_type_is_a (_tmp112_, NETSUKUKU_TYPE_PUBLIC_KEY);
		if (!_tmp113_) {
			GError* _tmp114_;
			_tmp114_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "check_hostname parameter 3 is not a PublicKey.");
			_inner_error_ = _tmp114_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser2);
			_g_free0 (hashed_domain);
			_g_object_unref0 (iser1);
			_g_object_unref0 (nip);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp115_ = iser2;
		_tmp116_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp115_, NETSUKUKU_TYPE_PUBLIC_KEY, NetsukukuPublicKey));
		pubkey = _tmp116_;
		_tmp117_ = nip;
		_tmp118_ = hashed_domain;
		_tmp119_ = pubkey;
		_tmp120_ = netsukuku_icounter_as_peer_check_hostname ((NetsukukuICounterAsPeer*) self, _tmp117_, _tmp118_, _tmp119_, &_inner_error_);
		_tmp121_ = _tmp120_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (pubkey);
			_g_object_unref0 (iser2);
			_g_free0 (hashed_domain);
			_g_object_unref0 (iser1);
			_g_object_unref0 (nip);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		result = (zcdISerializable*) _tmp121_;
		_g_object_unref0 (pubkey);
		_g_object_unref0 (iser2);
		_g_free0 (hashed_domain);
		_g_object_unref0 (iser1);
		_g_object_unref0 (nip);
		_g_object_unref0 (iser0);
		pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp122_ = pieces;
	_tmp122__length1 = pieces_length1;
	_tmp123_ = _tmp122_[0];
	if (g_strcmp0 (_tmp123_, "get_hostnames") == 0) {
		gchar** _tmp124_;
		gint _tmp124__length1;
		zcdRemoteCall* _tmp126_;
		GeeList* _tmp127_;
		GeeList* _tmp128_;
		gint _tmp129_;
		gint _tmp130_;
		zcdRemoteCall* _tmp132_;
		GeeList* _tmp133_;
		GeeList* _tmp134_;
		gpointer _tmp135_ = NULL;
		zcdISerializable* iser0;
		zcdISerializable* _tmp136_;
		GType _tmp137_ = 0UL;
		gboolean _tmp138_ = FALSE;
		zcdISerializable* _tmp140_;
		NetsukukuNIP* _tmp141_;
		NetsukukuNIP* nip;
		NetsukukuNIP* _tmp142_;
		NetsukukuCounterNipRecord* _tmp143_ = NULL;
		NetsukukuCounterNipRecord* ret;
		NetsukukuCounterNipRecord* _tmp144_;
		_tmp124_ = pieces;
		_tmp124__length1 = pieces_length1;
		if (_tmp124__length1 != 1) {
			GError* _tmp125_;
			_tmp125_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "get_hostnames is a function.");
			_inner_error_ = _tmp125_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp126_ = data;
		_tmp127_ = zcd_remote_call_get_parameters (_tmp126_);
		_tmp128_ = _tmp127_;
		_tmp129_ = gee_collection_get_size ((GeeCollection*) _tmp128_);
		_tmp130_ = _tmp129_;
		if (_tmp130_ != 1) {
			GError* _tmp131_;
			_tmp131_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "get_hostnames wants 1 parameter.");
			_inner_error_ = _tmp131_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp132_ = data;
		_tmp133_ = zcd_remote_call_get_parameters (_tmp132_);
		_tmp134_ = _tmp133_;
		_tmp135_ = gee_list_get (_tmp134_, 0);
		iser0 = (zcdISerializable*) _tmp135_;
		_tmp136_ = iser0;
		_tmp137_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp136_);
		_tmp138_ = g_type_is_a (_tmp137_, NETSUKUKU_TYPE_NIP);
		if (!_tmp138_) {
			GError* _tmp139_;
			_tmp139_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "get_hostnames parameter 1 is not a NIP.");
			_inner_error_ = _tmp139_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp140_ = iser0;
		_tmp141_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp140_, NETSUKUKU_TYPE_NIP, NetsukukuNIP));
		nip = _tmp141_;
		_tmp142_ = nip;
		_tmp143_ = netsukuku_icounter_as_peer_get_hostnames ((NetsukukuICounterAsPeer*) self, _tmp142_, &_inner_error_);
		ret = _tmp143_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (nip);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp144_ = ret;
		if (_tmp144_ == NULL) {
			zcdSerializableNone* _tmp145_;
			_tmp145_ = zcd_serializable_none_new ();
			result = (zcdISerializable*) _tmp145_;
			_g_object_unref0 (ret);
			_g_object_unref0 (nip);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return result;
		}
		result = (zcdISerializable*) ret;
		_g_object_unref0 (nip);
		_g_object_unref0 (iser0);
		pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp146_ = pieces;
	_tmp146__length1 = pieces_length1;
	_tmp147_ = _tmp146_[0];
	if (g_strcmp0 (_tmp147_, "get_cache_records") == 0) {
		gchar** _tmp148_;
		gint _tmp148__length1;
		zcdRemoteCall* _tmp150_;
		GeeList* _tmp151_;
		GeeList* _tmp152_;
		gint _tmp153_;
		gint _tmp154_;
		NetsukukuCounterGetCacheRecordsResponse* _tmp156_ = NULL;
		NetsukukuCounterGetCacheRecordsResponse* _tmp157_;
		_tmp148_ = pieces;
		_tmp148__length1 = pieces_length1;
		if (_tmp148__length1 != 1) {
			GError* _tmp149_;
			_tmp149_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "get_cache_records is a function.");
			_inner_error_ = _tmp149_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp150_ = data;
		_tmp151_ = zcd_remote_call_get_parameters (_tmp150_);
		_tmp152_ = _tmp151_;
		_tmp153_ = gee_collection_get_size ((GeeCollection*) _tmp152_);
		_tmp154_ = _tmp153_;
		if (_tmp154_ != 0) {
			GError* _tmp155_;
			_tmp155_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "get_cache_records wants no parameters.");
			_inner_error_ = _tmp155_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp156_ = netsukuku_icounter_as_peer_get_cache_records ((NetsukukuICounterAsPeer*) self, &_inner_error_);
		_tmp157_ = _tmp156_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		result = (zcdISerializable*) _tmp157_;
		pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp158_ = caller;
	_tmp159_ = data;
	_tmp160_ = ZCD_RPC_DISPATCHER_CLASS (netsukuku_counter_parent_class)->_dispatch ((zcdRPCDispatcher*) G_TYPE_CHECK_INSTANCE_CAST (self, NETSUKUKU_TYPE_OPTIONAL_PEER_TO_PEER, NetsukukuOptionalPeerToPeer), _tmp158_, _tmp159_, &_inner_error_);
	_tmp161_ = _tmp160_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
		return NULL;
	}
	result = _tmp161_;
	pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static NetsukukuNIP* netsukuku_counter_nip_for_lvl_pos (NetsukukuCounter* self, gint lvl, gint pos) {
	NetsukukuNIP* result = NULL;
	NetsukukuMapRoute* _tmp0_;
	NetsukukuNIP* _tmp1_;
	NetsukukuNIP* _tmp2_;
	gint _tmp3_ = 0;
	gint* _tmp4_ = NULL;
	gint* ret;
	gint ret_length1;
	gint _ret_size_;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	NetsukukuNIP* _tmp8_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = ((NetsukukuPeerToPeer*) self)->maproute;
	_tmp1_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp4_ = netsukuku_partial_nip_get_positions ((NetsukukuPartialNIP*) _tmp2_, &_tmp3_);
	ret = _tmp4_;
	ret_length1 = _tmp3_;
	_ret_size_ = ret_length1;
	_tmp5_ = lvl;
	_tmp6_ = pos;
	ret[_tmp5_] = _tmp6_;
	_tmp7_ = ret[_tmp5_];
	_tmp8_ = netsukuku_nip_new (ret, ret_length1);
	result = _tmp8_;
	ret = (g_free (ret), NULL);
	return result;
}


static gboolean _int_equal (const gint* s1, const gint* s2) {
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	return (*s1) == (*s2);
}


static void netsukuku_counter_impl_hook_to_service (NetsukukuCounter* self, GError** error) {
	gboolean _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	tasklets_tasklet_declare_self ("Counter.hook_to_service");
	_tmp0_ = ((NetsukukuOptionalPeerToPeer*) self)->will_participate;
	if (_tmp0_) {
		GeeHashMap* _tmp1_;
		_tmp1_ = self->priv->cache;
		gee_abstract_map_clear ((GeeAbstractMap*) _tmp1_);
		{
			gint lvl;
			lvl = 0;
			{
				gboolean _tmp2_;
				_tmp2_ = TRUE;
				while (TRUE) {
					gboolean _tmp3_;
					gint _tmp5_;
					NetsukukuMapRoute* _tmp6_;
					gint _tmp7_;
					gint _tmp8_;
					gint* first_forward = NULL;
					gint* first_back = NULL;
					gint* last_back = NULL;
					gint _tmp9_;
					gint* _tmp10_ = NULL;
					gint* _tmp11_ = NULL;
					gint* _tmp12_ = NULL;
					gint* _tmp13_;
					_tmp3_ = _tmp2_;
					if (!_tmp3_) {
						gint _tmp4_;
						_tmp4_ = lvl;
						lvl = _tmp4_ + 1;
					}
					_tmp2_ = FALSE;
					_tmp5_ = lvl;
					_tmp6_ = ((NetsukukuPeerToPeer*) self)->maproute;
					_tmp7_ = netsukuku_map_get_levels ((NetsukukuMap*) _tmp6_);
					_tmp8_ = _tmp7_;
					if (!(_tmp5_ < _tmp8_)) {
						break;
					}
					_tmp9_ = lvl;
					netsukuku_peer_to_peer_find_hook_peers ((NetsukukuPeerToPeer*) self, &_tmp10_, &_tmp11_, &_tmp12_, _tmp9_, NETSUKUKU_COUNTER_DUPLICATION, 120000);
					_g_free0 (first_forward);
					first_forward = _tmp10_;
					_g_free0 (first_back);
					first_back = _tmp11_;
					_g_free0 (last_back);
					last_back = _tmp12_;
					_tmp13_ = first_forward;
					if (_tmp13_ == NULL) {
					} else {
						gint* _tmp14_;
						_tmp14_ = first_back;
						if (_tmp14_ == NULL) {
							gint _tmp15_;
							gint* _tmp16_;
							NetsukukuNIP* _tmp17_ = NULL;
							NetsukukuNIP* nip_first_forward;
							NetsukukuNIP* _tmp18_;
							NetsukukuRmtCounterPeer* _tmp19_ = NULL;
							NetsukukuRmtCounterPeer* peer_first_forward;
							NetsukukuRmtCounterPeer* _tmp20_;
							NetsukukuCounterGetCacheRecordsResponse* _tmp21_ = NULL;
							NetsukukuCounterGetCacheRecordsResponse* cache_first_forward;
							_tmp15_ = lvl;
							_tmp16_ = first_forward;
							_tmp17_ = netsukuku_counter_nip_for_lvl_pos (self, _tmp15_, *_tmp16_);
							nip_first_forward = _tmp17_;
							_tmp18_ = nip_first_forward;
							_tmp19_ = netsukuku_counter_peer (self, _tmp18_, NULL, NULL);
							peer_first_forward = _tmp19_;
							_tmp20_ = peer_first_forward;
							_tmp21_ = netsukuku_icounter_as_peer_get_cache_records ((NetsukukuICounterAsPeer*) _tmp20_, &_inner_error_);
							cache_first_forward = _tmp21_;
							if (_inner_error_ != NULL) {
								g_propagate_error (error, _inner_error_);
								_g_object_unref0 (peer_first_forward);
								_g_object_unref0 (nip_first_forward);
								_g_free0 (last_back);
								_g_free0 (first_back);
								_g_free0 (first_forward);
								return;
							}
							{
								NetsukukuCounterGetCacheRecordsResponse* _tmp22_;
								GeeHashMap* _tmp23_;
								GeeHashMap* _tmp24_;
								GeeSet* _tmp25_;
								GeeSet* _tmp26_;
								GeeSet* _tmp27_;
								GeeIterator* _tmp28_ = NULL;
								GeeIterator* _tmp29_;
								GeeIterator* _pk_nip_it;
								_tmp22_ = cache_first_forward;
								_tmp23_ = netsukuku_counter_get_cache_records_response_get_cache (_tmp22_);
								_tmp24_ = _tmp23_;
								_tmp25_ = gee_abstract_map_get_keys ((GeeMap*) _tmp24_);
								_tmp26_ = _tmp25_;
								_tmp27_ = _tmp26_;
								_tmp28_ = gee_iterable_iterator ((GeeIterable*) _tmp27_);
								_tmp29_ = _tmp28_;
								_g_object_unref0 (_tmp27_);
								_pk_nip_it = _tmp29_;
								while (TRUE) {
									GeeIterator* _tmp30_;
									gboolean _tmp31_ = FALSE;
									GeeIterator* _tmp32_;
									gpointer _tmp33_ = NULL;
									NetsukukuPairPublicKeyNIP* pk_nip;
									GeeHashMap* _tmp34_;
									NetsukukuPairPublicKeyNIP* _tmp35_;
									gboolean _tmp36_ = FALSE;
									_tmp30_ = _pk_nip_it;
									_tmp31_ = gee_iterator_next (_tmp30_);
									if (!_tmp31_) {
										break;
									}
									_tmp32_ = _pk_nip_it;
									_tmp33_ = gee_iterator_get (_tmp32_);
									pk_nip = (NetsukukuPairPublicKeyNIP*) _tmp33_;
									_tmp34_ = self->priv->cache;
									_tmp35_ = pk_nip;
									_tmp36_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp34_, _tmp35_);
									if (!_tmp36_) {
										GeeHashMap* _tmp37_;
										NetsukukuPairPublicKeyNIP* _tmp38_;
										NetsukukuCounterGetCacheRecordsResponse* _tmp39_;
										GeeHashMap* _tmp40_;
										GeeHashMap* _tmp41_;
										NetsukukuPairPublicKeyNIP* _tmp42_;
										gpointer _tmp43_ = NULL;
										NetsukukuCounterNipRecord* _tmp44_;
										_tmp37_ = self->priv->cache;
										_tmp38_ = pk_nip;
										_tmp39_ = cache_first_forward;
										_tmp40_ = netsukuku_counter_get_cache_records_response_get_cache (_tmp39_);
										_tmp41_ = _tmp40_;
										_tmp42_ = pk_nip;
										_tmp43_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp41_, _tmp42_);
										_tmp44_ = (NetsukukuCounterNipRecord*) _tmp43_;
										gee_abstract_map_set ((GeeAbstractMap*) _tmp37_, _tmp38_, _tmp44_);
										_g_object_unref0 (_tmp44_);
									}
									_g_object_unref0 (pk_nip);
								}
								_g_object_unref0 (_pk_nip_it);
							}
							_g_object_unref0 (cache_first_forward);
							_g_object_unref0 (peer_first_forward);
							_g_object_unref0 (nip_first_forward);
							_g_free0 (last_back);
							_g_free0 (first_back);
							_g_free0 (first_forward);
							break;
						} else {
							gint* _tmp45_;
							gint* _tmp46_;
							gint _tmp100_;
							gint* _tmp101_;
							NetsukukuNIP* _tmp102_ = NULL;
							NetsukukuNIP* nip_first_forward;
							NetsukukuNIP* _tmp103_;
							NetsukukuRmtCounterPeer* _tmp104_ = NULL;
							NetsukukuRmtCounterPeer* peer_first_forward;
							NetsukukuRmtCounterPeer* _tmp105_;
							NetsukukuCounterGetCacheRecordsResponse* _tmp106_ = NULL;
							NetsukukuCounterGetCacheRecordsResponse* cache_first_forward;
							_tmp45_ = first_back;
							_tmp46_ = last_back;
							if (_int_equal (_tmp45_, _tmp46_) != TRUE) {
								gint _tmp47_;
								gint* _tmp48_;
								NetsukukuNIP* _tmp49_ = NULL;
								NetsukukuNIP* nip_first_back;
								NetsukukuNIP* _tmp50_;
								NetsukukuRmtCounterPeer* _tmp51_ = NULL;
								NetsukukuRmtCounterPeer* peer_first_back;
								gint _tmp52_;
								gint* _tmp53_;
								NetsukukuNIP* _tmp54_ = NULL;
								NetsukukuNIP* nip_last_back;
								NetsukukuNIP* _tmp55_;
								NetsukukuRmtCounterPeer* _tmp56_ = NULL;
								NetsukukuRmtCounterPeer* peer_last_back;
								NetsukukuRmtCounterPeer* _tmp57_;
								NetsukukuCounterGetCacheRecordsResponse* _tmp58_ = NULL;
								NetsukukuCounterGetCacheRecordsResponse* recs_first;
								NetsukukuRmtCounterPeer* _tmp59_;
								NetsukukuCounterGetCacheRecordsResponse* _tmp60_ = NULL;
								NetsukukuCounterGetCacheRecordsResponse* recs_last;
								_tmp47_ = lvl;
								_tmp48_ = first_back;
								_tmp49_ = netsukuku_counter_nip_for_lvl_pos (self, _tmp47_, *_tmp48_);
								nip_first_back = _tmp49_;
								_tmp50_ = nip_first_back;
								_tmp51_ = netsukuku_counter_peer (self, _tmp50_, NULL, NULL);
								peer_first_back = _tmp51_;
								_tmp52_ = lvl;
								_tmp53_ = last_back;
								_tmp54_ = netsukuku_counter_nip_for_lvl_pos (self, _tmp52_, *_tmp53_);
								nip_last_back = _tmp54_;
								_tmp55_ = nip_last_back;
								_tmp56_ = netsukuku_counter_peer (self, _tmp55_, NULL, NULL);
								peer_last_back = _tmp56_;
								_tmp57_ = peer_first_back;
								_tmp58_ = netsukuku_icounter_as_peer_get_cache_records ((NetsukukuICounterAsPeer*) _tmp57_, &_inner_error_);
								recs_first = _tmp58_;
								if (_inner_error_ != NULL) {
									g_propagate_error (error, _inner_error_);
									_g_object_unref0 (peer_last_back);
									_g_object_unref0 (nip_last_back);
									_g_object_unref0 (peer_first_back);
									_g_object_unref0 (nip_first_back);
									_g_free0 (last_back);
									_g_free0 (first_back);
									_g_free0 (first_forward);
									return;
								}
								_tmp59_ = peer_last_back;
								_tmp60_ = netsukuku_icounter_as_peer_get_cache_records ((NetsukukuICounterAsPeer*) _tmp59_, &_inner_error_);
								recs_last = _tmp60_;
								if (_inner_error_ != NULL) {
									g_propagate_error (error, _inner_error_);
									_g_object_unref0 (recs_first);
									_g_object_unref0 (peer_last_back);
									_g_object_unref0 (nip_last_back);
									_g_object_unref0 (peer_first_back);
									_g_object_unref0 (nip_first_back);
									_g_free0 (last_back);
									_g_free0 (first_back);
									_g_free0 (first_forward);
									return;
								}
								{
									NetsukukuCounterGetCacheRecordsResponse* _tmp61_;
									GeeHashMap* _tmp62_;
									GeeHashMap* _tmp63_;
									GeeSet* _tmp64_;
									GeeSet* _tmp65_;
									GeeSet* _tmp66_;
									GeeIterator* _tmp67_ = NULL;
									GeeIterator* _tmp68_;
									GeeIterator* _pk_nip_it;
									_tmp61_ = recs_first;
									_tmp62_ = netsukuku_counter_get_cache_records_response_get_cache (_tmp61_);
									_tmp63_ = _tmp62_;
									_tmp64_ = gee_abstract_map_get_keys ((GeeMap*) _tmp63_);
									_tmp65_ = _tmp64_;
									_tmp66_ = _tmp65_;
									_tmp67_ = gee_iterable_iterator ((GeeIterable*) _tmp66_);
									_tmp68_ = _tmp67_;
									_g_object_unref0 (_tmp66_);
									_pk_nip_it = _tmp68_;
									while (TRUE) {
										GeeIterator* _tmp69_;
										gboolean _tmp70_ = FALSE;
										GeeIterator* _tmp71_;
										gpointer _tmp72_ = NULL;
										NetsukukuPairPublicKeyNIP* pk_nip;
										GeeHashMap* _tmp73_;
										NetsukukuPairPublicKeyNIP* _tmp74_;
										gboolean _tmp75_ = FALSE;
										_tmp69_ = _pk_nip_it;
										_tmp70_ = gee_iterator_next (_tmp69_);
										if (!_tmp70_) {
											break;
										}
										_tmp71_ = _pk_nip_it;
										_tmp72_ = gee_iterator_get (_tmp71_);
										pk_nip = (NetsukukuPairPublicKeyNIP*) _tmp72_;
										_tmp73_ = self->priv->cache;
										_tmp74_ = pk_nip;
										_tmp75_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp73_, _tmp74_);
										if (!_tmp75_) {
											gboolean found;
											gboolean _tmp91_;
											found = FALSE;
											{
												NetsukukuCounterGetCacheRecordsResponse* _tmp76_;
												GeeHashMap* _tmp77_;
												GeeHashMap* _tmp78_;
												GeeSet* _tmp79_;
												GeeSet* _tmp80_;
												GeeSet* _tmp81_;
												GeeIterator* _tmp82_ = NULL;
												GeeIterator* _tmp83_;
												GeeIterator* _pk_nip2_it;
												_tmp76_ = recs_last;
												_tmp77_ = netsukuku_counter_get_cache_records_response_get_cache (_tmp76_);
												_tmp78_ = _tmp77_;
												_tmp79_ = gee_abstract_map_get_keys ((GeeMap*) _tmp78_);
												_tmp80_ = _tmp79_;
												_tmp81_ = _tmp80_;
												_tmp82_ = gee_iterable_iterator ((GeeIterable*) _tmp81_);
												_tmp83_ = _tmp82_;
												_g_object_unref0 (_tmp81_);
												_pk_nip2_it = _tmp83_;
												while (TRUE) {
													GeeIterator* _tmp84_;
													gboolean _tmp85_ = FALSE;
													GeeIterator* _tmp86_;
													gpointer _tmp87_ = NULL;
													NetsukukuPairPublicKeyNIP* pk_nip2;
													NetsukukuPairPublicKeyNIP* _tmp88_;
													NetsukukuPairPublicKeyNIP* _tmp89_;
													gboolean _tmp90_ = FALSE;
													_tmp84_ = _pk_nip2_it;
													_tmp85_ = gee_iterator_next (_tmp84_);
													if (!_tmp85_) {
														break;
													}
													_tmp86_ = _pk_nip2_it;
													_tmp87_ = gee_iterator_get (_tmp86_);
													pk_nip2 = (NetsukukuPairPublicKeyNIP*) _tmp87_;
													_tmp88_ = pk_nip2;
													_tmp89_ = pk_nip;
													_tmp90_ = netsukuku_pair_public_key_nip_equal_func (_tmp88_, _tmp89_);
													if (_tmp90_) {
														found = TRUE;
														_g_object_unref0 (pk_nip2);
														break;
													}
													_g_object_unref0 (pk_nip2);
												}
												_g_object_unref0 (_pk_nip2_it);
											}
											_tmp91_ = found;
											if (!_tmp91_) {
												GeeHashMap* _tmp92_;
												NetsukukuPairPublicKeyNIP* _tmp93_;
												NetsukukuCounterGetCacheRecordsResponse* _tmp94_;
												GeeHashMap* _tmp95_;
												GeeHashMap* _tmp96_;
												NetsukukuPairPublicKeyNIP* _tmp97_;
												gpointer _tmp98_ = NULL;
												NetsukukuCounterNipRecord* _tmp99_;
												_tmp92_ = self->priv->cache;
												_tmp93_ = pk_nip;
												_tmp94_ = recs_first;
												_tmp95_ = netsukuku_counter_get_cache_records_response_get_cache (_tmp94_);
												_tmp96_ = _tmp95_;
												_tmp97_ = pk_nip;
												_tmp98_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp96_, _tmp97_);
												_tmp99_ = (NetsukukuCounterNipRecord*) _tmp98_;
												gee_abstract_map_set ((GeeAbstractMap*) _tmp92_, _tmp93_, _tmp99_);
												_g_object_unref0 (_tmp99_);
											}
										}
										_g_object_unref0 (pk_nip);
									}
									_g_object_unref0 (_pk_nip_it);
								}
								_g_object_unref0 (recs_last);
								_g_object_unref0 (recs_first);
								_g_object_unref0 (peer_last_back);
								_g_object_unref0 (nip_last_back);
								_g_object_unref0 (peer_first_back);
								_g_object_unref0 (nip_first_back);
							}
							_tmp100_ = lvl;
							_tmp101_ = first_forward;
							_tmp102_ = netsukuku_counter_nip_for_lvl_pos (self, _tmp100_, *_tmp101_);
							nip_first_forward = _tmp102_;
							_tmp103_ = nip_first_forward;
							_tmp104_ = netsukuku_counter_peer (self, _tmp103_, NULL, NULL);
							peer_first_forward = _tmp104_;
							_tmp105_ = peer_first_forward;
							_tmp106_ = netsukuku_icounter_as_peer_get_cache_records ((NetsukukuICounterAsPeer*) _tmp105_, &_inner_error_);
							cache_first_forward = _tmp106_;
							if (_inner_error_ != NULL) {
								g_propagate_error (error, _inner_error_);
								_g_object_unref0 (peer_first_forward);
								_g_object_unref0 (nip_first_forward);
								_g_free0 (last_back);
								_g_free0 (first_back);
								_g_free0 (first_forward);
								return;
							}
							{
								NetsukukuCounterGetCacheRecordsResponse* _tmp107_;
								GeeHashMap* _tmp108_;
								GeeHashMap* _tmp109_;
								GeeSet* _tmp110_;
								GeeSet* _tmp111_;
								GeeSet* _tmp112_;
								GeeIterator* _tmp113_ = NULL;
								GeeIterator* _tmp114_;
								GeeIterator* _pk_nip_it;
								_tmp107_ = cache_first_forward;
								_tmp108_ = netsukuku_counter_get_cache_records_response_get_cache (_tmp107_);
								_tmp109_ = _tmp108_;
								_tmp110_ = gee_abstract_map_get_keys ((GeeMap*) _tmp109_);
								_tmp111_ = _tmp110_;
								_tmp112_ = _tmp111_;
								_tmp113_ = gee_iterable_iterator ((GeeIterable*) _tmp112_);
								_tmp114_ = _tmp113_;
								_g_object_unref0 (_tmp112_);
								_pk_nip_it = _tmp114_;
								while (TRUE) {
									GeeIterator* _tmp115_;
									gboolean _tmp116_ = FALSE;
									GeeIterator* _tmp117_;
									gpointer _tmp118_ = NULL;
									NetsukukuPairPublicKeyNIP* pk_nip;
									GeeHashMap* _tmp119_;
									NetsukukuPairPublicKeyNIP* _tmp120_;
									gboolean _tmp121_ = FALSE;
									_tmp115_ = _pk_nip_it;
									_tmp116_ = gee_iterator_next (_tmp115_);
									if (!_tmp116_) {
										break;
									}
									_tmp117_ = _pk_nip_it;
									_tmp118_ = gee_iterator_get (_tmp117_);
									pk_nip = (NetsukukuPairPublicKeyNIP*) _tmp118_;
									_tmp119_ = self->priv->cache;
									_tmp120_ = pk_nip;
									_tmp121_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp119_, _tmp120_);
									if (!_tmp121_) {
										gboolean check;
										NetsukukuPairPublicKeyNIP* _tmp122_;
										NetsukukuNIP* _tmp123_;
										NetsukukuNIP* _tmp124_;
										NetsukukuNIP* _tmp125_ = NULL;
										NetsukukuNIP* _tmp126_;
										gint _tmp127_;
										gint _tmp128_ = 0;
										gint _tmp129_;
										gint hk;
										gint _tmp130_;
										GeeList* _tmp131_ = NULL;
										GeeList* ids;
										GeeList* _tmp132_;
										gint* _tmp133_;
										gint _tmp134_ = 0;
										GeeList* _tmp135_;
										NetsukukuMapRoute* _tmp136_;
										NetsukukuNIP* _tmp137_;
										NetsukukuNIP* _tmp138_;
										gint _tmp139_;
										gint _tmp140_ = 0;
										gint _tmp141_ = 0;
										gboolean _tmp142_;
										check = FALSE;
										_tmp122_ = pk_nip;
										_tmp123_ = netsukuku_pair_public_key_nip_get_nip (_tmp122_);
										_tmp124_ = _tmp123_;
										_tmp125_ = netsukuku_peer_to_peer_h ((NetsukukuPeerToPeer*) self, (GObject*) _tmp124_);
										_tmp126_ = _tmp125_;
										_tmp127_ = lvl;
										_tmp128_ = netsukuku_partial_nip_position_at ((NetsukukuPartialNIP*) _tmp126_, _tmp127_);
										_tmp129_ = _tmp128_;
										_g_object_unref0 (_tmp126_);
										hk = _tmp129_;
										_tmp130_ = hk;
										_tmp131_ = netsukuku_peer_to_peer_list_ids ((NetsukukuPeerToPeer*) self, _tmp130_, 1);
										ids = _tmp131_;
										_tmp132_ = ids;
										_tmp133_ = first_forward;
										_tmp134_ = gee_list_index_of (_tmp132_, (gpointer) ((gintptr) (*_tmp133_)));
										_tmp135_ = ids;
										_tmp136_ = ((NetsukukuPeerToPeer*) self)->maproute;
										_tmp137_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp136_);
										_tmp138_ = _tmp137_;
										_tmp139_ = lvl;
										_tmp140_ = netsukuku_partial_nip_position_at ((NetsukukuPartialNIP*) _tmp138_, _tmp139_);
										_tmp141_ = gee_list_index_of (_tmp135_, (gpointer) ((gintptr) _tmp140_));
										if (_tmp134_ > _tmp141_) {
											check = TRUE;
										}
										_tmp142_ = check;
										if (_tmp142_) {
											GeeHashMap* _tmp143_;
											NetsukukuPairPublicKeyNIP* _tmp144_;
											NetsukukuCounterGetCacheRecordsResponse* _tmp145_;
											GeeHashMap* _tmp146_;
											GeeHashMap* _tmp147_;
											NetsukukuPairPublicKeyNIP* _tmp148_;
											gpointer _tmp149_ = NULL;
											NetsukukuCounterNipRecord* _tmp150_;
											_tmp143_ = self->priv->cache;
											_tmp144_ = pk_nip;
											_tmp145_ = cache_first_forward;
											_tmp146_ = netsukuku_counter_get_cache_records_response_get_cache (_tmp145_);
											_tmp147_ = _tmp146_;
											_tmp148_ = pk_nip;
											_tmp149_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp147_, _tmp148_);
											_tmp150_ = (NetsukukuCounterNipRecord*) _tmp149_;
											gee_abstract_map_set ((GeeAbstractMap*) _tmp143_, _tmp144_, _tmp150_);
											_g_object_unref0 (_tmp150_);
										}
										_g_object_unref0 (ids);
									}
									_g_object_unref0 (pk_nip);
								}
								_g_object_unref0 (_pk_nip_it);
							}
							_g_object_unref0 (cache_first_forward);
							_g_object_unref0 (peer_first_forward);
							_g_object_unref0 (nip_first_forward);
							_g_free0 (last_back);
							_g_free0 (first_back);
							_g_free0 (first_forward);
							break;
						}
					}
					_g_free0 (last_back);
					_g_free0 (first_back);
					_g_free0 (first_forward);
				}
			}
		}
		g_signal_emit_by_name (self, "counter-hooked");
		self->priv->hooked_to_service = TRUE;
		netsukuku_optional_peer_to_peer_participate ((NetsukukuOptionalPeerToPeer*) self);
		netsukuku_log_info ("Counter service: participating.");
	}
}


static void* netsukuku_counter_helper_hook_to_service (void* v, GError** error) {
	void* result = NULL;
	void* _tmp0_;
	Netsukukustruct_helper_Counter_hook_to_service* tuple_p;
	NetsukukuCounter* _tmp1_;
	NetsukukuCounter* _tmp2_;
	NetsukukuCounter* self_save;
	GError * _inner_error_ = NULL;
	_tmp0_ = v;
	tuple_p = (Netsukukustruct_helper_Counter_hook_to_service*) _tmp0_;
	_tmp1_ = (*tuple_p).self;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	self_save = _tmp2_;
	tasklets_tasklet_schedule_back ();
	netsukuku_counter_impl_hook_to_service (self_save, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self_save);
		return NULL;
	}
	result = NULL;
	_g_object_unref0 (self_save);
	return result;
}


void netsukuku_counter_hook_to_service (NetsukukuCounter* self) {
	Netsukukustruct_helper_Counter_hook_to_service arg = {0};
	NetsukukuCounter* _tmp0_;
	TaskletsTasklet* _tmp1_ = NULL;
	TaskletsTasklet* _tmp2_;
	g_return_if_fail (self != NULL);
	memset (&arg, 0, sizeof (Netsukukustruct_helper_Counter_hook_to_service));
	_tmp0_ = _g_object_ref0 (self);
	_g_object_unref0 (arg.self);
	arg.self = _tmp0_;
	_tmp1_ = tasklets_tasklet_spawn ((TaskletsSpawnable) netsukuku_counter_helper_hook_to_service, &arg, FALSE, -1);
	_tmp2_ = _tmp1_;
	_g_object_unref0 (_tmp2_);
	netsukuku_struct_helper_counter_hook_to_service_destroy (&arg);
}


/** This is the function h:KEY-->hIP.
          */
static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res_length1;
	_tmp3_ = res;
	_tmp3__length1 = res_length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


static NetsukukuNIP* netsukuku_counter_real_h (NetsukukuPeerToPeer* base, GObject* key) {
	NetsukukuCounter * self;
	NetsukukuNIP* result = NULL;
	GObject* _tmp0_;
	NetsukukuNIP* _tmp1_;
	NetsukukuNIP* _key;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	guint8* _tmp4_;
	gint _tmp4__length1;
	guint8* _tmp5_;
	gint _tmp5__length1;
	gint _tmp6_ = 0;
	guint8* _tmp7_ = NULL;
	guint8* _tmp8_;
	gint _tmp8__length1;
	guint8* hash;
	gint hash_length1;
	gint _hash_size_;
	guint8 _tmp9_;
	guint8 _tmp10_;
	guint8 _tmp11_;
	guint8 _tmp12_;
	guint32 basic_hash;
	NetsukukuMapRoute* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	gint* _tmp16_ = NULL;
	gint* positions;
	gint positions_length1;
	gint _positions_size_;
	gint* _tmp36_;
	gint _tmp36__length1;
	NetsukukuNIP* _tmp37_;
	NetsukukuNIP* ret;
	GError * _inner_error_ = NULL;
	self = (NetsukukuCounter*) base;
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = key;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, NETSUKUKU_TYPE_NIP, NetsukukuNIP));
	_key = _tmp1_;
	_tmp2_ = netsukuku_partial_nip_to_string ((NetsukukuPartialNIP*) _key);
	_tmp3_ = _tmp2_;
	_tmp4_ = string_get_data (_tmp3_, &_tmp4__length1);
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _tmp4__length1;
	_tmp7_ = netsukuku_crypto_md5 (_tmp5_, _tmp5__length1, &_tmp6_, &_inner_error_);
	_tmp8_ = _tmp7_;
	_tmp8__length1 = _tmp6_;
	_g_free0 (_tmp3_);
	hash = _tmp8_;
	hash_length1 = _tmp8__length1;
	_hash_size_ = hash_length1;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (_key);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp9_ = hash[15];
	_tmp10_ = hash[14];
	_tmp11_ = hash[13];
	_tmp12_ = hash[12];
	basic_hash = ((((guint32) _tmp9_) + (((guint32) _tmp10_) * ((guint32) 256))) + ((((guint32) _tmp11_) * ((guint32) 256)) * ((guint32) 256))) + (((((guint32) _tmp12_) * ((guint32) 256)) * ((guint32) 256)) * ((guint32) 256));
	_tmp13_ = ((NetsukukuPeerToPeer*) self)->maproute;
	_tmp14_ = netsukuku_map_get_levels ((NetsukukuMap*) _tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = g_new0 (gint, _tmp15_);
	positions = _tmp16_;
	positions_length1 = _tmp15_;
	_positions_size_ = positions_length1;
	{
		gint lvl;
		lvl = 0;
		{
			gboolean _tmp17_;
			_tmp17_ = TRUE;
			while (TRUE) {
				gboolean _tmp18_;
				gint _tmp20_;
				NetsukukuMapRoute* _tmp21_;
				gint _tmp22_;
				gint _tmp23_;
				guint32 _tmp24_;
				NetsukukuMapRoute* _tmp25_;
				gint _tmp26_;
				gint _tmp27_;
				guint pos;
				gint* _tmp28_;
				gint _tmp28__length1;
				gint _tmp29_;
				guint _tmp30_;
				gint _tmp31_;
				guint32 _tmp32_;
				NetsukukuMapRoute* _tmp33_;
				gint _tmp34_;
				gint _tmp35_;
				_tmp18_ = _tmp17_;
				if (!_tmp18_) {
					gint _tmp19_;
					_tmp19_ = lvl;
					lvl = _tmp19_ + 1;
				}
				_tmp17_ = FALSE;
				_tmp20_ = lvl;
				_tmp21_ = ((NetsukukuPeerToPeer*) self)->maproute;
				_tmp22_ = netsukuku_map_get_levels ((NetsukukuMap*) _tmp21_);
				_tmp23_ = _tmp22_;
				if (!(_tmp20_ < _tmp23_)) {
					break;
				}
				_tmp24_ = basic_hash;
				_tmp25_ = ((NetsukukuPeerToPeer*) self)->maproute;
				_tmp26_ = netsukuku_map_get_gsize ((NetsukukuMap*) _tmp25_);
				_tmp27_ = _tmp26_;
				pos = (guint) (_tmp24_ % _tmp27_);
				_tmp28_ = positions;
				_tmp28__length1 = positions_length1;
				_tmp29_ = lvl;
				_tmp30_ = pos;
				_tmp28_[_tmp29_] = (gint) _tmp30_;
				_tmp31_ = _tmp28_[_tmp29_];
				_tmp32_ = basic_hash;
				_tmp33_ = ((NetsukukuPeerToPeer*) self)->maproute;
				_tmp34_ = netsukuku_map_get_gsize ((NetsukukuMap*) _tmp33_);
				_tmp35_ = _tmp34_;
				basic_hash = _tmp32_ / _tmp35_;
			}
		}
	}
	_tmp36_ = positions;
	_tmp36__length1 = positions_length1;
	_tmp37_ = netsukuku_nip_new (_tmp36_, _tmp36__length1);
	ret = _tmp37_;
	result = ret;
	positions = (g_free (positions), NULL);
	hash = (g_free (hash), NULL);
	_g_object_unref0 (_key);
	return result;
}


static void netsukuku_counter_impl_reset_my_counter_node (NetsukukuCounter* self, GError** error) {
	TaskletsTasklet* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	tasklets_tasklet_declare_self ("Counter.reset_my_counter_node");
	_tmp0_ = tasklets_tasklet_self ();
	_g_object_unref0 (self->priv->reset_my_counter_node_tasklet);
	self->priv->reset_my_counter_node_tasklet = _tmp0_;
	while (TRUE) {
		NetsukukuTimeCapsule* ttl = NULL;
		{
			NetsukukuCounterSetDataResponse* _tmp1_ = NULL;
			NetsukukuCounterSetDataResponse* resp;
			NetsukukuCounterSetDataResponse* _tmp2_;
			const gchar* _tmp3_;
			const gchar* _tmp4_;
			_tmp1_ = netsukuku_counter_ask_set_data_for_pubk (self);
			resp = _tmp1_;
			_tmp2_ = resp;
			_tmp3_ = netsukuku_counter_set_data_response_get_response (_tmp2_);
			_tmp4_ = _tmp3_;
			if (g_strcmp0 (_tmp4_, "OK") == 0) {
				NetsukukuCounterSetDataResponse* _tmp5_;
				NetsukukuTimeCapsule* _tmp6_;
				NetsukukuTimeCapsule* _tmp7_;
				NetsukukuTimeCapsule* _tmp8_;
				NetsukukuTimeCapsule* _tmp9_;
				gint64 _tmp10_ = 0LL;
				NetsukukuTimeCapsule* _tmp11_;
				NetsukukuTimeCapsule* _tmp12_;
				NetsukukuTimeCapsule* maxttl;
				NetsukukuTimeCapsule* _tmp13_;
				NetsukukuTimeCapsule* _tmp14_;
				gboolean _tmp15_ = FALSE;
				g_signal_emit_by_name (self, "counter-registered");
				_tmp5_ = resp;
				_tmp6_ = netsukuku_counter_set_data_response_get_expires (_tmp5_);
				_tmp7_ = _tmp6_;
				_tmp8_ = _g_object_ref0 (_tmp7_);
				_g_object_unref0 (ttl);
				ttl = _tmp8_;
				_tmp9_ = ttl;
				_tmp10_ = tasklets_timer_get_msec_ttl ((TaskletsTimer*) _tmp9_);
				_tmp11_ = netsukuku_time_capsule_new (_tmp10_ - ((((gint64) 1000) * ((gint64) 60)) * ((gint64) 10)));
				_g_object_unref0 (ttl);
				ttl = _tmp11_;
				_tmp12_ = netsukuku_time_capsule_new (NETSUKUKU_MAX_WAIT_REFRESH_COUNTER);
				maxttl = _tmp12_;
				_tmp13_ = ttl;
				_tmp14_ = maxttl;
				_tmp15_ = tasklets_timer_is_younger ((TaskletsTimer*) _tmp13_, (TaskletsTimer*) _tmp14_);
				if (_tmp15_) {
					NetsukukuTimeCapsule* _tmp16_;
					NetsukukuTimeCapsule* _tmp17_;
					_tmp16_ = maxttl;
					_tmp17_ = _g_object_ref0 (_tmp16_);
					_g_object_unref0 (ttl);
					ttl = _tmp17_;
				}
				_g_object_unref0 (maxttl);
			} else {
				NetsukukuTimeCapsule* _tmp18_;
				_tmp18_ = netsukuku_time_capsule_new ((((gint64) 1000) * ((gint64) 60)) * ((gint64) 2));
				_g_object_unref0 (ttl);
				ttl = _tmp18_;
			}
			_g_object_unref0 (resp);
		}
		goto __finally42;
		__catch42_g_error:
		{
			GError* e = NULL;
			NetsukukuTimeCapsule* _tmp19_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp19_ = netsukuku_time_capsule_new ((((gint64) 1000) * ((gint64) 60)) * ((gint64) 2));
			_g_object_unref0 (ttl);
			ttl = _tmp19_;
			_g_error_free0 (e);
		}
		__finally42:
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (ttl);
			return;
		}
		while (TRUE) {
			NetsukukuTimeCapsule* _tmp20_;
			gboolean _tmp21_ = FALSE;
			_tmp20_ = ttl;
			_tmp21_ = tasklets_timer_is_expired ((TaskletsTimer*) _tmp20_);
			if (!(!_tmp21_)) {
				break;
			}
			tasklets_tasklet_nap ((glong) 0, (glong) 100000);
		}
		_g_object_unref0 (ttl);
	}
}


static void* netsukuku_counter_helper_reset_my_counter_node (void* v, GError** error) {
	void* result = NULL;
	void* _tmp0_;
	Netsukukustruct_helper_Counter_reset_my_counter_node* tuple_p;
	NetsukukuCounter* _tmp1_;
	NetsukukuCounter* _tmp2_;
	NetsukukuCounter* self_save;
	GError * _inner_error_ = NULL;
	_tmp0_ = v;
	tuple_p = (Netsukukustruct_helper_Counter_reset_my_counter_node*) _tmp0_;
	_tmp1_ = (*tuple_p).self;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	self_save = _tmp2_;
	tasklets_tasklet_schedule_back ();
	netsukuku_counter_impl_reset_my_counter_node (self_save, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self_save);
		return NULL;
	}
	result = NULL;
	_g_object_unref0 (self_save);
	return result;
}


void netsukuku_counter_reset_my_counter_node (NetsukukuCounter* self) {
	Netsukukustruct_helper_Counter_reset_my_counter_node arg = {0};
	NetsukukuCounter* _tmp0_;
	TaskletsTasklet* _tmp1_ = NULL;
	TaskletsTasklet* _tmp2_;
	g_return_if_fail (self != NULL);
	memset (&arg, 0, sizeof (Netsukukustruct_helper_Counter_reset_my_counter_node));
	_tmp0_ = _g_object_ref0 (self);
	_g_object_unref0 (arg.self);
	arg.self = _tmp0_;
	_tmp1_ = tasklets_tasklet_spawn ((TaskletsSpawnable) netsukuku_counter_helper_reset_my_counter_node, &arg, FALSE, -1);
	_tmp2_ = _tmp1_;
	_g_object_unref0 (_tmp2_);
	netsukuku_struct_helper_counter_reset_my_counter_node_destroy (&arg);
}


void netsukuku_counter_stop_reset_my_counter_node (NetsukukuCounter* self) {
	TaskletsTasklet* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->reset_my_counter_node_tasklet;
	if (_tmp0_ != NULL) {
		TaskletsTasklet* _tmp1_;
		_tmp1_ = self->priv->reset_my_counter_node_tasklet;
		tasklets_tasklet_abort (_tmp1_);
	}
	_g_object_unref0 (self->priv->reset_my_counter_node_tasklet);
	self->priv->reset_my_counter_node_tasklet = NULL;
}


gboolean netsukuku_counter_reset_my_counter_node_ongoing (NetsukukuCounter* self) {
	gboolean result = FALSE;
	TaskletsTasklet* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->reset_my_counter_node_tasklet;
	result = _tmp0_ != NULL;
	return result;
}


static NetsukukuCounterSetDataResponse* netsukuku_counter_ask_set_data_for_pubk (NetsukukuCounter* self) {
	NetsukukuCounterSetDataResponse* result = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	zcdSerializableBuffer* _tmp2_ = NULL;
	zcdSerializableBuffer* signature;
	NetsukukuMapRoute* _tmp3_;
	NetsukukuNIP* _tmp4_;
	NetsukukuNIP* _tmp5_;
	NetsukukuRmtCounterPeer* _tmp6_ = NULL;
	NetsukukuRmtCounterPeer* _tmp7_;
	NetsukukuMapRoute* _tmp8_;
	NetsukukuNIP* _tmp9_;
	NetsukukuNIP* _tmp10_;
	GeeArrayList* _tmp11_;
	GeeArrayList* _tmp12_;
	NetsukukuPublicKey* _tmp13_;
	NetsukukuCounterSetDataResponse* _tmp14_ = NULL;
	NetsukukuCounterSetDataResponse* _tmp15_;
	NetsukukuCounterSetDataResponse* _tmp16_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = netsukuku_counter_get_hashednames (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _netsukuku_counter_sign (self, (GeeList*) _tmp1_);
	signature = _tmp2_;
	_tmp3_ = ((NetsukukuPeerToPeer*) self)->maproute;
	_tmp4_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = netsukuku_counter_peer (self, NULL, (GObject*) _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = ((NetsukukuPeerToPeer*) self)->maproute;
	_tmp9_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = netsukuku_counter_get_hashednames (self);
	_tmp12_ = _tmp11_;
	_tmp13_ = self->priv->pubk;
	_tmp14_ = netsukuku_icounter_as_peer_set_data_for_pubk ((NetsukukuICounterAsPeer*) _tmp7_, _tmp10_, (GeeList*) _tmp12_, _tmp13_, signature, TRUE, &_inner_error_);
	_tmp15_ = _tmp14_;
	_g_object_unref0 (_tmp7_);
	_tmp16_ = _tmp15_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (signature);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = _tmp16_;
	_g_object_unref0 (signature);
	return result;
}


static zcdSerializableBuffer* _netsukuku_counter_sign (NetsukukuCounter* self, GeeList* hashed_domains) {
	zcdSerializableBuffer* result = NULL;
	NetsukukuKeyPair* _tmp0_;
	NetsukukuMapRoute* _tmp1_;
	NetsukukuNIP* _tmp2_;
	NetsukukuNIP* _tmp3_;
	GeeList* _tmp4_;
	gint _tmp5_ = 0;
	guchar* _tmp6_ = NULL;
	guchar* _tmp7_;
	gint _tmp7__length1;
	gint _tmp8_ = 0;
	guchar* _tmp9_ = NULL;
	guchar* _tmp10_;
	gint _tmp10__length1;
	guchar* _signed_;
	gint _signed__length1;
	gint __signed__size_;
	zcdSerializableBuffer* _tmp11_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (hashed_domains != NULL, NULL);
	_tmp0_ = self->priv->my_keys;
	_tmp1_ = ((NetsukukuPeerToPeer*) self)->maproute;
	_tmp2_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = hashed_domains;
	_tmp6_ = netsukuku_counter_utilities_prepare_msg (_tmp3_, _tmp4_, &_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _tmp5_;
	_tmp9_ = netsukuku_key_pair_sign (_tmp0_, _tmp7_, _tmp5_, &_tmp8_, &_inner_error_);
	_tmp10_ = _tmp9_;
	_tmp10__length1 = _tmp8_;
	_tmp7_ = (g_free (_tmp7_), NULL);
	_signed_ = _tmp10_;
	_signed__length1 = _tmp10__length1;
	__signed__size_ = _signed__length1;
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp11_ = zcd_serializable_buffer_new ((guint8*) _signed_, (_signed__length1 * sizeof (guchar)) / sizeof (guint8));
	result = _tmp11_;
	_signed_ = (g_free (_signed_), NULL);
	return result;
}


static gboolean _netsukuku_counter_verify (NetsukukuCounter* self, NetsukukuNIP* nip, GeeList* hashed_domains, NetsukukuPublicKey* pubk, zcdSerializableBuffer* signature) {
	gboolean result = FALSE;
	NetsukukuPublicKey* _tmp0_;
	NetsukukuPublicKeyWrapper* _tmp1_;
	NetsukukuPublicKeyWrapper* pkw;
	NetsukukuPublicKeyWrapper* _tmp2_;
	NetsukukuNIP* _tmp3_;
	GeeList* _tmp4_;
	gint _tmp5_ = 0;
	guchar* _tmp6_ = NULL;
	guchar* _tmp7_;
	gint _tmp7__length1;
	zcdSerializableBuffer* _tmp8_;
	guint8* _tmp9_;
	gint _tmp9__length1;
	guint8* _tmp10_;
	gint _tmp10__length1;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_;
	gboolean _tmp13_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (nip != NULL, FALSE);
	g_return_val_if_fail (hashed_domains != NULL, FALSE);
	g_return_val_if_fail (pubk != NULL, FALSE);
	g_return_val_if_fail (signature != NULL, FALSE);
	_tmp0_ = pubk;
	_tmp1_ = netsukuku_public_key_wrapper_new_from_pubk (_tmp0_, &_inner_error_);
	pkw = _tmp1_;
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp2_ = pkw;
	_tmp3_ = nip;
	_tmp4_ = hashed_domains;
	_tmp6_ = netsukuku_counter_utilities_prepare_msg (_tmp3_, _tmp4_, &_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _tmp5_;
	_tmp8_ = signature;
	_tmp9_ = zcd_serializable_buffer_get_buffer (_tmp8_, &_tmp9__length1);
	_tmp10_ = _tmp9_;
	_tmp10__length1 = _tmp9__length1;
	_tmp11_ = netsukuku_public_key_wrapper_verify (_tmp2_, _tmp7_, _tmp5_, (guchar*) _tmp10_, (_tmp10__length1 * sizeof (guint8)) / sizeof (guchar), &_inner_error_);
	_tmp12_ = _tmp11_;
	_tmp7_ = (g_free (_tmp7_), NULL);
	_tmp13_ = _tmp12_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (pkw);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = _tmp13_;
	_g_object_unref0 (pkw);
	return result;
}


NetsukukuCounterCheckHostnameResponse* netsukuku_counter_ask_check_hostname (NetsukukuCounter* self, NetsukukuNIP* nip, const gchar* hashed_domain, NetsukukuPublicKey* pubkey, GError** error) {
	NetsukukuCounterCheckHostnameResponse* result = NULL;
	NetsukukuNIP* _tmp0_;
	NetsukukuRmtCounterPeer* _tmp1_ = NULL;
	NetsukukuRmtCounterPeer* _tmp2_;
	NetsukukuNIP* _tmp3_;
	const gchar* _tmp4_;
	NetsukukuPublicKey* _tmp5_;
	NetsukukuCounterCheckHostnameResponse* _tmp6_ = NULL;
	NetsukukuCounterCheckHostnameResponse* _tmp7_;
	NetsukukuCounterCheckHostnameResponse* _tmp8_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (nip != NULL, NULL);
	g_return_val_if_fail (hashed_domain != NULL, NULL);
	g_return_val_if_fail (pubkey != NULL, NULL);
	_tmp0_ = nip;
	_tmp1_ = netsukuku_counter_peer (self, NULL, (GObject*) _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = nip;
	_tmp4_ = hashed_domain;
	_tmp5_ = pubkey;
	_tmp6_ = netsukuku_icounter_as_peer_check_hostname ((NetsukukuICounterAsPeer*) _tmp2_, _tmp3_, _tmp4_, _tmp5_, &_inner_error_);
	_tmp7_ = _tmp6_;
	_g_object_unref0 (_tmp2_);
	_tmp8_ = _tmp7_;
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == ZCD_RPC_ERROR) || (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _tmp8_;
	return result;
}


NetsukukuCounterNipRecord* netsukuku_counter_ask_get_hostnames (NetsukukuCounter* self, NetsukukuNIP* nip) {
	NetsukukuCounterNipRecord* result = NULL;
	NetsukukuNIP* _tmp0_;
	NetsukukuRmtCounterPeer* _tmp1_ = NULL;
	NetsukukuRmtCounterPeer* node;
	NetsukukuNIP* _tmp2_;
	NetsukukuCounterNipRecord* _tmp3_ = NULL;
	NetsukukuCounterNipRecord* ret;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (nip != NULL, NULL);
	_tmp0_ = nip;
	_tmp1_ = netsukuku_counter_peer (self, NULL, (GObject*) _tmp0_, NULL);
	node = _tmp1_;
	_tmp2_ = nip;
	_tmp3_ = netsukuku_icounter_as_peer_get_hostnames ((NetsukukuICounterAsPeer*) node, _tmp2_, &_inner_error_);
	ret = _tmp3_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (node);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = ret;
	_g_object_unref0 (node);
	return result;
}


/** Helper methods used as a server
          */
void netsukuku_counter_check_expirations_cache (NetsukukuCounter* self) {
	GeeArrayList* _tmp0_;
	GeeArrayList* todel;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_array_list_new (NETSUKUKU_TYPE_PAIR_PUBLIC_KEY_NIP, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_pair_public_key_nip_equal_func_gee_equal_data_func, NULL, NULL);
	todel = _tmp0_;
	{
		GeeHashMap* _tmp1_;
		GeeSet* _tmp2_;
		GeeSet* _tmp3_;
		GeeSet* _tmp4_;
		GeeIterator* _tmp5_ = NULL;
		GeeIterator* _tmp6_;
		GeeIterator* _k_it;
		_tmp1_ = self->priv->cache;
		_tmp2_ = gee_abstract_map_get_keys ((GeeMap*) _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_;
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
		_k_it = _tmp6_;
		while (TRUE) {
			GeeIterator* _tmp7_;
			gboolean _tmp8_ = FALSE;
			GeeIterator* _tmp9_;
			gpointer _tmp10_ = NULL;
			NetsukukuPairPublicKeyNIP* k;
			GeeHashMap* _tmp11_;
			NetsukukuPairPublicKeyNIP* _tmp12_;
			gpointer _tmp13_ = NULL;
			NetsukukuCounterNipRecord* record;
			NetsukukuCounterNipRecord* _tmp14_;
			NetsukukuTimeCapsule* _tmp15_;
			NetsukukuTimeCapsule* _tmp16_;
			gboolean _tmp17_ = FALSE;
			_tmp7_ = _k_it;
			_tmp8_ = gee_iterator_next (_tmp7_);
			if (!_tmp8_) {
				break;
			}
			_tmp9_ = _k_it;
			_tmp10_ = gee_iterator_get (_tmp9_);
			k = (NetsukukuPairPublicKeyNIP*) _tmp10_;
			_tmp11_ = self->priv->cache;
			_tmp12_ = k;
			_tmp13_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp11_, _tmp12_);
			record = (NetsukukuCounterNipRecord*) _tmp13_;
			_tmp14_ = record;
			_tmp15_ = netsukuku_counter_nip_record_get_expires (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = tasklets_timer_is_expired ((TaskletsTimer*) _tmp16_);
			if (_tmp17_) {
				GeeArrayList* _tmp18_;
				NetsukukuPairPublicKeyNIP* _tmp19_;
				_tmp18_ = todel;
				_tmp19_ = k;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp18_, _tmp19_);
			}
			_g_object_unref0 (record);
			_g_object_unref0 (k);
		}
		_g_object_unref0 (_k_it);
	}
	{
		GeeArrayList* _tmp20_;
		GeeArrayList* _tmp21_;
		GeeArrayList* _k_list;
		GeeArrayList* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		gint _k_size;
		gint _k_index;
		_tmp20_ = todel;
		_tmp21_ = _g_object_ref0 (_tmp20_);
		_k_list = _tmp21_;
		_tmp22_ = _k_list;
		_tmp23_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp22_);
		_tmp24_ = _tmp23_;
		_k_size = _tmp24_;
		_k_index = -1;
		while (TRUE) {
			gint _tmp25_;
			gint _tmp26_;
			gint _tmp27_;
			GeeArrayList* _tmp28_;
			gint _tmp29_;
			gpointer _tmp30_ = NULL;
			NetsukukuPairPublicKeyNIP* k;
			GeeHashMap* _tmp31_;
			NetsukukuPairPublicKeyNIP* _tmp32_;
			_tmp25_ = _k_index;
			_k_index = _tmp25_ + 1;
			_tmp26_ = _k_index;
			_tmp27_ = _k_size;
			if (!(_tmp26_ < _tmp27_)) {
				break;
			}
			_tmp28_ = _k_list;
			_tmp29_ = _k_index;
			_tmp30_ = gee_abstract_list_get ((GeeAbstractList*) _tmp28_, _tmp29_);
			k = (NetsukukuPairPublicKeyNIP*) _tmp30_;
			_tmp31_ = self->priv->cache;
			_tmp32_ = k;
			gee_abstract_map_unset ((GeeAbstractMap*) _tmp31_, _tmp32_, NULL);
			_g_object_unref0 (k);
		}
		_g_object_unref0 (_k_list);
	}
	_g_object_unref0 (todel);
}


static NetsukukuIAddressManagerRootDispatcher* netsukuku_counter_real_contact_registrar (NetsukukuCounter* self, const gchar* registrar_address) {
	NetsukukuIAddressManagerRootDispatcher* result = NULL;
	const gchar* _tmp0_;
	NetsukukuAddressManagerTCPClient* _tmp1_;
	g_return_val_if_fail (registrar_address != NULL, NULL);
	_tmp0_ = registrar_address;
	_tmp1_ = netsukuku_address_manager_tcp_client_new (_tmp0_, NULL, NULL, TRUE);
	result = (NetsukukuIAddressManagerRootDispatcher*) _tmp1_;
	return result;
}


NetsukukuIAddressManagerRootDispatcher* netsukuku_counter_contact_registrar (NetsukukuCounter* self, const gchar* registrar_address) {
	g_return_val_if_fail (self != NULL, NULL);
	return NETSUKUKU_COUNTER_GET_CLASS (self)->contact_registrar (self, registrar_address);
}


/** Remotable methods as peer()
          */
static Block5Data* block5_data_ref (Block5Data* _data5_) {
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}


static void block5_data_unref (void * _userdata_) {
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		NetsukukuCounter * self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->response_ttl);
		_g_free0 (_data5_->response_msg);
		_g_object_unref0 (_data5_->nip);
		_g_object_unref0 (_data5_->hashed_domains);
		_g_object_unref0 (_data5_->pubkey);
		_g_object_unref0 (_data5_->signature);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}


static gboolean __lambda14_ (Block5Data* _data5_, GError** error) {
	NetsukukuCounter * self;
	gboolean result = FALSE;
	NetsukukuNIP* _tmp0_;
	GeeList* _tmp1_;
	NetsukukuPublicKey* _tmp2_;
	zcdSerializableBuffer* _tmp3_;
	gboolean _tmp4_ = FALSE;
	GeeList* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	NetsukukuMapRoute* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	NetsukukuMapRoute* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	NetsukukuNIP* _tmp16_;
	gchar* _tmp17_ = NULL;
	gchar* dest_addr;
	const gchar* _tmp18_;
	NetsukukuIAddressManagerRootDispatcher* _tmp19_ = NULL;
	NetsukukuIAddressManagerRootDispatcher* client;
	gint32 _tmp20_ = 0;
	gint to_be_signed;
	NetsukukuIAddressManagerRootDispatcher* _tmp21_;
	NetsukukuIAndna* _tmp22_;
	NetsukukuIAndna* _tmp23_;
	NetsukukuNIP* _tmp24_;
	NetsukukuPublicKey* _tmp25_;
	gint _tmp26_;
	NetsukukuAndnaConfirmPubkResponse* _tmp27_ = NULL;
	NetsukukuAndnaConfirmPubkResponse* resp;
	NetsukukuAndnaConfirmPubkResponse* _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	NetsukukuPairPublicKeyNIP* to_del;
	NetsukukuPairPublicKeyNIP* _tmp62_;
	NetsukukuTimeCapsule* _tmp65_;
	NetsukukuTimeCapsule* ttl;
	GeeHashMap* _tmp66_;
	NetsukukuPublicKey* _tmp67_;
	NetsukukuNIP* _tmp68_;
	NetsukukuPairPublicKeyNIP* _tmp69_;
	NetsukukuPairPublicKeyNIP* _tmp70_;
	NetsukukuPublicKey* _tmp71_;
	NetsukukuNIP* _tmp72_;
	GeeList* _tmp73_;
	zcdListString* _tmp74_;
	zcdListString* _tmp75_;
	NetsukukuTimeCapsule* _tmp76_;
	NetsukukuCounterNipRecord* _tmp77_;
	NetsukukuCounterNipRecord* _tmp78_;
	gchar* _tmp79_;
	NetsukukuTimeCapsule* _tmp80_;
	NetsukukuTimeCapsule* _tmp81_;
	GError * _inner_error_ = NULL;
	self = _data5_->self;
	_tmp0_ = _data5_->nip;
	_tmp1_ = _data5_->hashed_domains;
	_tmp2_ = _data5_->pubkey;
	_tmp3_ = _data5_->signature;
	_tmp4_ = _netsukuku_counter_verify (self, _tmp0_, _tmp1_, _tmp2_, _tmp3_);
	if (!_tmp4_) {
		GError* _tmp5_;
		_tmp5_ = g_error_new_literal (NETSUKUKU_PEER_REFUSE_SERVICE_ERROR, NETSUKUKU_PEER_REFUSE_SERVICE_ERROR_GENERIC, "Not your signature.");
		_inner_error_ = _tmp5_;
		if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	_tmp6_ = _data5_->hashed_domains;
	_tmp7_ = gee_collection_get_size ((GeeCollection*) _tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_ > NETSUKUKU_MAX_HOSTNAMES) {
		GError* _tmp9_;
		_tmp9_ = g_error_new_literal (NETSUKUKU_PEER_REFUSE_SERVICE_ERROR, NETSUKUKU_PEER_REFUSE_SERVICE_ERROR_GENERIC, "Too many names.");
		_inner_error_ = _tmp9_;
		if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	_tmp10_ = ((NetsukukuPeerToPeer*) self)->maproute;
	_tmp11_ = netsukuku_map_get_levels ((NetsukukuMap*) _tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = ((NetsukukuPeerToPeer*) self)->maproute;
	_tmp14_ = netsukuku_map_get_gsize ((NetsukukuMap*) _tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = _data5_->nip;
	_tmp17_ = netsukuku_nip_to_str (_tmp12_, _tmp15_, _tmp16_);
	dest_addr = _tmp17_;
	_tmp18_ = dest_addr;
	_tmp19_ = netsukuku_counter_contact_registrar (self, _tmp18_);
	client = _tmp19_;
	_tmp20_ = g_random_int_range ((gint32) 0, (gint32) 64000);
	to_be_signed = (gint) _tmp20_;
	_tmp21_ = client;
	_tmp22_ = netsukuku_iaddress_manager_root_dispatcher_get_andna (_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = _data5_->nip;
	_tmp25_ = _data5_->pubkey;
	_tmp26_ = to_be_signed;
	_tmp27_ = netsukuku_iandna_confirm_pubk (_tmp23_, _tmp24_, _tmp25_, _tmp26_, &_inner_error_);
	resp = _tmp27_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (client);
			_g_free0 (dest_addr);
			return FALSE;
		} else {
			_g_object_unref0 (client);
			_g_free0 (dest_addr);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	_tmp28_ = resp;
	_tmp29_ = netsukuku_andna_confirm_pubk_response_get_response (_tmp28_);
	_tmp30_ = _tmp29_;
	if (g_strcmp0 (_tmp30_, "OK") == 0) {
		NetsukukuPublicKey* _tmp31_;
		NetsukukuPublicKeyWrapper* _tmp32_;
		NetsukukuPublicKeyWrapper* pk;
		NetsukukuPublicKeyWrapper* _tmp33_;
		gint _tmp34_;
		gchar* _tmp35_ = NULL;
		gchar* _tmp36_;
		guint8* _tmp37_;
		gint _tmp37__length1;
		guint8* _tmp38_;
		gint _tmp38__length1;
		NetsukukuAndnaConfirmPubkResponse* _tmp39_;
		zcdSerializableBuffer* _tmp40_;
		zcdSerializableBuffer* _tmp41_;
		guint8* _tmp42_;
		gint _tmp42__length1;
		guint8* _tmp43_;
		gint _tmp43__length1;
		_tmp31_ = _data5_->pubkey;
		_tmp32_ = netsukuku_public_key_wrapper_new_from_pubk (_tmp31_, &_inner_error_);
		pk = _tmp32_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (resp);
				_g_object_unref0 (client);
				_g_free0 (dest_addr);
				return FALSE;
			} else {
				_g_object_unref0 (resp);
				_g_object_unref0 (client);
				_g_free0 (dest_addr);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		_tmp33_ = pk;
		_tmp34_ = to_be_signed;
		_tmp35_ = g_strdup_printf ("%i", _tmp34_);
		_tmp36_ = _tmp35_;
		_tmp37_ = string_get_data (_tmp36_, &_tmp37__length1);
		_tmp38_ = _tmp37_;
		_tmp38__length1 = _tmp37__length1;
		_tmp39_ = resp;
		_tmp40_ = netsukuku_andna_confirm_pubk_response_get_signature (_tmp39_);
		_tmp41_ = _tmp40_;
		_tmp42_ = zcd_serializable_buffer_get_buffer (_tmp41_, &_tmp42__length1);
		_tmp43_ = _tmp42_;
		_tmp43__length1 = _tmp42__length1;
		netsukuku_public_key_wrapper_verify (_tmp33_, (guchar*) _tmp38_, (_tmp38__length1 * sizeof (guint8)) / sizeof (guchar), (guchar*) _tmp43_, (_tmp43__length1 * sizeof (guint8)) / sizeof (guchar), &_inner_error_);
		_g_free0 (_tmp36_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (pk);
				_g_object_unref0 (resp);
				_g_object_unref0 (client);
				_g_free0 (dest_addr);
				return FALSE;
			} else {
				_g_object_unref0 (pk);
				_g_object_unref0 (resp);
				_g_object_unref0 (client);
				_g_free0 (dest_addr);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		_g_object_unref0 (pk);
	} else {
		GError* _tmp44_;
		_tmp44_ = g_error_new_literal (NETSUKUKU_PEER_REFUSE_SERVICE_ERROR, NETSUKUKU_PEER_REFUSE_SERVICE_ERROR_GENERIC, "Not your NIP.");
		_inner_error_ = _tmp44_;
		if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (resp);
			_g_object_unref0 (client);
			_g_free0 (dest_addr);
			return FALSE;
		} else {
			_g_object_unref0 (resp);
			_g_object_unref0 (client);
			_g_free0 (dest_addr);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	to_del = NULL;
	{
		GeeHashMap* _tmp45_;
		GeeSet* _tmp46_;
		GeeSet* _tmp47_;
		GeeSet* _tmp48_;
		GeeIterator* _tmp49_ = NULL;
		GeeIterator* _tmp50_;
		GeeIterator* _pk_nip_it;
		_tmp45_ = self->priv->cache;
		_tmp46_ = gee_abstract_map_get_keys ((GeeMap*) _tmp45_);
		_tmp47_ = _tmp46_;
		_tmp48_ = _tmp47_;
		_tmp49_ = gee_iterable_iterator ((GeeIterable*) _tmp48_);
		_tmp50_ = _tmp49_;
		_g_object_unref0 (_tmp48_);
		_pk_nip_it = _tmp50_;
		while (TRUE) {
			GeeIterator* _tmp51_;
			gboolean _tmp52_ = FALSE;
			GeeIterator* _tmp53_;
			gpointer _tmp54_ = NULL;
			NetsukukuPairPublicKeyNIP* pk_nip;
			NetsukukuPairPublicKeyNIP* _tmp55_;
			NetsukukuPublicKey* _tmp56_;
			NetsukukuPublicKey* _tmp57_;
			NetsukukuPublicKey* _tmp58_;
			gboolean _tmp59_ = FALSE;
			_tmp51_ = _pk_nip_it;
			_tmp52_ = gee_iterator_next (_tmp51_);
			if (!_tmp52_) {
				break;
			}
			_tmp53_ = _pk_nip_it;
			_tmp54_ = gee_iterator_get (_tmp53_);
			pk_nip = (NetsukukuPairPublicKeyNIP*) _tmp54_;
			_tmp55_ = pk_nip;
			_tmp56_ = netsukuku_pair_public_key_nip_get_pk (_tmp55_);
			_tmp57_ = _tmp56_;
			_tmp58_ = _data5_->pubkey;
			_tmp59_ = netsukuku_public_key_equal_func (_tmp57_, _tmp58_);
			if (_tmp59_) {
				NetsukukuPairPublicKeyNIP* _tmp60_;
				NetsukukuPairPublicKeyNIP* _tmp61_;
				_tmp60_ = pk_nip;
				_tmp61_ = _g_object_ref0 (_tmp60_);
				_g_object_unref0 (to_del);
				to_del = _tmp61_;
				_g_object_unref0 (pk_nip);
				break;
			}
			_g_object_unref0 (pk_nip);
		}
		_g_object_unref0 (_pk_nip_it);
	}
	_tmp62_ = to_del;
	if (_tmp62_ != NULL) {
		GeeHashMap* _tmp63_;
		NetsukukuPairPublicKeyNIP* _tmp64_;
		_tmp63_ = self->priv->cache;
		_tmp64_ = to_del;
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp63_, _tmp64_, NULL);
	}
	_tmp65_ = netsukuku_time_capsule_new (NETSUKUKU_MAX_TTL_COUNTER);
	ttl = _tmp65_;
	_tmp66_ = self->priv->cache;
	_tmp67_ = _data5_->pubkey;
	_tmp68_ = _data5_->nip;
	_tmp69_ = netsukuku_pair_public_key_nip_new (_tmp67_, _tmp68_);
	_tmp70_ = _tmp69_;
	_tmp71_ = _data5_->pubkey;
	_tmp72_ = _data5_->nip;
	_tmp73_ = _data5_->hashed_domains;
	_tmp74_ = zcd_list_string_new_with_backer (_tmp73_);
	_tmp75_ = _tmp74_;
	_tmp76_ = ttl;
	_tmp77_ = netsukuku_counter_nip_record_new (_tmp71_, _tmp72_, _tmp75_, _tmp76_);
	_tmp78_ = _tmp77_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp66_, _tmp70_, _tmp78_);
	_g_object_unref0 (_tmp78_);
	_g_object_unref0 (_tmp75_);
	_g_object_unref0 (_tmp70_);
	_tmp79_ = g_strdup ("OK");
	_g_free0 (_data5_->response_msg);
	_data5_->response_msg = _tmp79_;
	_tmp80_ = ttl;
	_tmp81_ = _g_object_ref0 (_tmp80_);
	_g_object_unref0 (_data5_->response_ttl);
	_data5_->response_ttl = _tmp81_;
	result = TRUE;
	_g_object_unref0 (ttl);
	_g_object_unref0 (to_del);
	_g_object_unref0 (resp);
	_g_object_unref0 (client);
	_g_free0 (dest_addr);
	return result;
}


static gboolean ___lambda14__netsukuku_accept_record_callback (gpointer self, GError** error) {
	gboolean result;
	result = __lambda14_ (self, error);
	return result;
}


static void _____lambda16_ (NetsukukuCounter* self, GObject* tpar1, GObject* tpar2, GError** error) {
	GObject* _tmp0_;
	NetsukukuNIP* _tmp1_;
	NetsukukuNIP* tonip;
	GObject* _tmp2_;
	NetsukukuArgumentsForDuplicationSetData* _tmp3_;
	NetsukukuArgumentsForDuplicationSetData* arec;
	GError * _inner_error_ = NULL;
	_tmp0_ = tpar1;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, NETSUKUKU_TYPE_NIP, NetsukukuNIP));
	tonip = _tmp1_;
	_tmp2_ = tpar2;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, NETSUKUKU_TYPE_ARGUMENTS_FOR_DUPLICATION_SET_DATA, NetsukukuArgumentsForDuplicationSetData));
	arec = _tmp3_;
	tasklets_tasklet_declare_self ("Counter.forward_record");
	{
		NetsukukuRmtCounterPeer* _tmp4_ = NULL;
		NetsukukuRmtCounterPeer* _tmp5_;
		NetsukukuNIP* _tmp6_;
		GeeList* _tmp7_;
		NetsukukuPublicKey* _tmp8_;
		zcdSerializableBuffer* _tmp9_;
		NetsukukuCounterSetDataResponse* _tmp10_ = NULL;
		NetsukukuCounterSetDataResponse* _tmp11_;
		_tmp4_ = netsukuku_counter_peer (self, tonip, NULL, NULL);
		_tmp5_ = _tmp4_;
		_tmp6_ = arec->nip;
		_tmp7_ = arec->hashed_domains;
		_tmp8_ = arec->pubkey;
		_tmp9_ = arec->signature;
		_tmp10_ = netsukuku_icounter_as_peer_set_data_for_pubk ((NetsukukuICounterAsPeer*) _tmp5_, _tmp6_, _tmp7_, _tmp8_, _tmp9_, FALSE, &_inner_error_);
		_tmp11_ = _tmp10_;
		_g_object_unref0 (_tmp11_);
		_g_object_unref0 (_tmp5_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch43_zcd_rpc_error;
			}
			goto __finally43;
		}
	}
	goto __finally43;
	__catch43_zcd_rpc_error:
	{
		GError* e = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_;
		GError* _tmp16_;
		GQuark _tmp17_;
		const gchar* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		GError* _tmp20_;
		gint _tmp21_;
		gchar* _tmp22_ = NULL;
		gchar* _tmp23_;
		GError* _tmp24_;
		const gchar* _tmp25_;
		const gchar* _tmp26_ = NULL;
		gchar* _tmp27_ = NULL;
		gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp12_ = netsukuku_partial_nip_to_string ((NetsukukuPartialNIP*) tonip);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_strconcat ("Counter.forward_record: forwarding to ", _tmp13_, ":", NULL);
		_tmp15_ = _tmp14_;
		_tmp16_ = e;
		_tmp17_ = _tmp16_->domain;
		_tmp18_ = g_quark_to_string (_tmp17_);
		_tmp19_ = string_to_string (_tmp18_);
		_tmp20_ = e;
		_tmp21_ = _tmp20_->code;
		_tmp22_ = g_strdup_printf ("%i", _tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = e;
		_tmp25_ = _tmp24_->message;
		_tmp26_ = string_to_string (_tmp25_);
		_tmp27_ = g_strconcat (" got ", _tmp19_, " ", _tmp23_, " ", _tmp26_, NULL);
		_tmp28_ = _tmp27_;
		_tmp29_ = g_strconcat (_tmp15_, _tmp28_, NULL);
		_tmp30_ = _tmp29_;
		netsukuku_log_warn (_tmp30_);
		_g_free0 (_tmp30_);
		_g_free0 (_tmp28_);
		_g_free0 (_tmp23_);
		_g_free0 (_tmp15_);
		_g_free0 (_tmp13_);
		_g_error_free0 (e);
	}
	__finally43:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (arec);
		_g_object_unref0 (tonip);
		return;
	}
	_g_object_unref0 (arec);
	_g_object_unref0 (tonip);
}


static void ______lambda16__tasklets_tasklet_callback (GObject* obj1, GObject* obj2, GObject* obj3, GObject* obj4, gpointer self, GError** error) {
	_____lambda16_ (self, obj1, obj2, error);
}


static void __lambda15_ (NetsukukuCounter* self, GObject* tasklet_obj1, GeeList* tasklet_replica_nodes, GError** error) {
	GObject* _tmp0_;
	NetsukukuArgumentsForDuplicationSetData* _tmp1_;
	NetsukukuArgumentsForDuplicationSetData* tasklet_rec;
	GeeList* _tmp2_;
	GError * _inner_error_ = NULL;
	_tmp0_ = tasklet_obj1;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, NETSUKUKU_TYPE_ARGUMENTS_FOR_DUPLICATION_SET_DATA, NetsukukuArgumentsForDuplicationSetData));
	tasklet_rec = _tmp1_;
	_tmp2_ = tasklet_replica_nodes;
	if (_tmp2_ == NULL) {
		NetsukukuArgumentsForDuplicationSetData* _tmp3_;
		NetsukukuNIP* _tmp4_;
		GeeList* _tmp5_ = NULL;
		GeeList* _tmp6_;
		_tmp3_ = tasklet_rec;
		_tmp4_ = _tmp3_->hashnode;
		_tmp5_ = netsukuku_peer_to_peer_find_nearest_to_register ((NetsukukuPeerToPeer*) self, _tmp4_, NETSUKUKU_COUNTER_DUPLICATION, NULL, &_inner_error_);
		_tmp6_ = _tmp5_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (tasklet_rec);
				_g_object_unref0 (tasklet_replica_nodes);
				return;
			} else {
				_g_object_unref0 (tasklet_rec);
				_g_object_unref0 (tasklet_replica_nodes);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_g_object_unref0 (tasklet_replica_nodes);
		tasklet_replica_nodes = _tmp6_;
	}
	{
		GeeList* _tmp7_;
		GeeList* _tmp8_;
		GeeList* _replica_node_list;
		GeeList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _replica_node_size;
		gint _replica_node_index;
		_tmp7_ = tasklet_replica_nodes;
		_tmp8_ = _g_object_ref0 (_tmp7_);
		_replica_node_list = _tmp8_;
		_tmp9_ = _replica_node_list;
		_tmp10_ = gee_collection_get_size ((GeeCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		_replica_node_size = _tmp11_;
		_replica_node_index = -1;
		while (TRUE) {
			gint _tmp12_;
			gint _tmp13_;
			gint _tmp14_;
			GeeList* _tmp15_;
			gint _tmp16_;
			gpointer _tmp17_ = NULL;
			NetsukukuNIP* replica_node;
			NetsukukuNIP* _tmp18_;
			NetsukukuMapRoute* _tmp19_;
			NetsukukuNIP* _tmp20_;
			NetsukukuNIP* _tmp21_;
			gboolean _tmp22_ = FALSE;
			_tmp12_ = _replica_node_index;
			_replica_node_index = _tmp12_ + 1;
			_tmp13_ = _replica_node_index;
			_tmp14_ = _replica_node_size;
			if (!(_tmp13_ < _tmp14_)) {
				break;
			}
			_tmp15_ = _replica_node_list;
			_tmp16_ = _replica_node_index;
			_tmp17_ = gee_list_get (_tmp15_, _tmp16_);
			replica_node = (NetsukukuNIP*) _tmp17_;
			_tmp18_ = replica_node;
			_tmp19_ = ((NetsukukuPeerToPeer*) self)->maproute;
			_tmp20_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = netsukuku_partial_nip_is_equal ((NetsukukuPartialNIP*) _tmp18_, (NetsukukuPartialNIP*) _tmp21_);
			if (!_tmp22_) {
				NetsukukuNIP* _tmp23_;
				NetsukukuArgumentsForDuplicationSetData* _tmp24_;
				TaskletsTasklet* _tmp25_ = NULL;
				TaskletsTasklet* _tmp26_;
				_tmp23_ = replica_node;
				_tmp24_ = tasklet_rec;
				_tmp25_ = tasklets_tasklet_tasklet_callback (______lambda16__tasklets_tasklet_callback, self, (GObject*) _tmp23_, (GObject*) _tmp24_, NULL, NULL);
				_tmp26_ = _tmp25_;
				_g_object_unref0 (_tmp26_);
			}
			_g_object_unref0 (replica_node);
		}
		_g_object_unref0 (_replica_node_list);
	}
	_g_object_unref0 (tasklet_rec);
	_g_object_unref0 (tasklet_replica_nodes);
}


static void ___lambda15__netsukuku_forward_record_callback (GObject* obj1, GeeList* replica_nodes, gpointer self, GError** error) {
	__lambda15_ (self, obj1, replica_nodes, error);
}


static NetsukukuCounterSetDataResponse* netsukuku_counter_real_set_data_for_pubk (NetsukukuICounterAsPeer* base, NetsukukuNIP* nip, GeeList* hashed_domains, NetsukukuPublicKey* pubkey, zcdSerializableBuffer* signature, gboolean replicate, GError** error) {
	NetsukukuCounter * self;
	NetsukukuCounterSetDataResponse* result = NULL;
	Block5Data* _data5_;
	NetsukukuNIP* _tmp0_;
	NetsukukuNIP* _tmp1_;
	GeeList* _tmp2_;
	GeeList* _tmp3_;
	NetsukukuPublicKey* _tmp4_;
	NetsukukuPublicKey* _tmp5_;
	zcdSerializableBuffer* _tmp6_;
	zcdSerializableBuffer* _tmp7_;
	gboolean _tmp8_;
	gchar* _tmp16_;
	NetsukukuTimeCapsule* _tmp17_;
	NetsukukuNIP* _tmp18_;
	NetsukukuNIP* _tmp19_ = NULL;
	NetsukukuNIP* hashnode;
	NetsukukuArgumentsForDuplicationSetData* _tmp20_;
	NetsukukuArgumentsForDuplicationSetData* rec;
	NetsukukuArgumentsForDuplicationSetData* _tmp21_;
	NetsukukuNIP* _tmp22_;
	NetsukukuNIP* _tmp23_;
	NetsukukuArgumentsForDuplicationSetData* _tmp24_;
	GeeList* _tmp25_;
	GeeList* _tmp26_;
	NetsukukuArgumentsForDuplicationSetData* _tmp27_;
	NetsukukuPublicKey* _tmp28_;
	NetsukukuPublicKey* _tmp29_;
	NetsukukuArgumentsForDuplicationSetData* _tmp30_;
	zcdSerializableBuffer* _tmp31_;
	zcdSerializableBuffer* _tmp32_;
	NetsukukuArgumentsForDuplicationSetData* _tmp33_;
	NetsukukuNIP* _tmp34_;
	NetsukukuNIP* _tmp35_;
	NetsukukuNIP* _tmp36_;
	gboolean _tmp37_;
	NetsukukuArgumentsForDuplicationSetData* _tmp38_;
	const gchar* _tmp39_;
	NetsukukuTimeCapsule* _tmp40_;
	NetsukukuCounterSetDataResponse* _tmp41_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuCounter*) base;
	g_return_val_if_fail (nip != NULL, NULL);
	g_return_val_if_fail (hashed_domains != NULL, NULL);
	g_return_val_if_fail (pubkey != NULL, NULL);
	g_return_val_if_fail (signature != NULL, NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_tmp0_ = nip;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data5_->nip);
	_data5_->nip = _tmp1_;
	_tmp2_ = hashed_domains;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (_data5_->hashed_domains);
	_data5_->hashed_domains = _tmp3_;
	_tmp4_ = pubkey;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (_data5_->pubkey);
	_data5_->pubkey = _tmp5_;
	_tmp6_ = signature;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	_g_object_unref0 (_data5_->signature);
	_data5_->signature = _tmp7_;
	_tmp8_ = self->priv->hooked_to_service;
	if (!_tmp8_) {
		gboolean _tmp9_;
		_tmp9_ = replicate;
		if (_tmp9_) {
			TaskletsTimer* _tmp10_;
			TaskletsTimer* w;
			_tmp10_ = tasklets_timer_new ((gint64) 10000);
			w = _tmp10_;
			while (TRUE) {
				gboolean _tmp11_;
				TaskletsTimer* _tmp12_;
				gboolean _tmp13_ = FALSE;
				_tmp11_ = self->priv->hooked_to_service;
				if (!(!_tmp11_)) {
					break;
				}
				_tmp12_ = w;
				_tmp13_ = tasklets_timer_is_expired (_tmp12_);
				if (_tmp13_) {
					GError* _tmp14_;
					_tmp14_ = g_error_new_literal (NETSUKUKU_PEER_REFUSE_SERVICE_ERROR, NETSUKUKU_PEER_REFUSE_SERVICE_ERROR_GENERIC, "Not hooked yet");
					_inner_error_ = _tmp14_;
					if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_object_unref0 (w);
						block5_data_unref (_data5_);
						_data5_ = NULL;
						return NULL;
					} else {
						_g_object_unref0 (w);
						block5_data_unref (_data5_);
						_data5_ = NULL;
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				tasklets_tasklet_nap ((glong) 0, (glong) 1000);
			}
			_g_object_unref0 (w);
		} else {
			while (TRUE) {
				gboolean _tmp15_;
				_tmp15_ = self->priv->hooked_to_service;
				if (!(!_tmp15_)) {
					break;
				}
				tasklets_tasklet_nap ((glong) 0, (glong) 1000);
			}
		}
	}
	_tmp16_ = g_strdup ("Noooo");
	_data5_->response_msg = _tmp16_;
	_tmp17_ = netsukuku_time_capsule_new ((gint64) 0);
	_data5_->response_ttl = _tmp17_;
	netsukuku_counter_check_expirations_cache (self);
	_tmp18_ = _data5_->nip;
	_tmp19_ = netsukuku_peer_to_peer_h ((NetsukukuPeerToPeer*) self, (GObject*) _tmp18_);
	hashnode = _tmp19_;
	_tmp20_ = netsukuku_arguments_for_duplication_set_data_new ();
	rec = _tmp20_;
	_tmp21_ = rec;
	_tmp22_ = _data5_->nip;
	_tmp23_ = _g_object_ref0 (_tmp22_);
	_g_object_unref0 (_tmp21_->nip);
	_tmp21_->nip = _tmp23_;
	_tmp24_ = rec;
	_tmp25_ = _data5_->hashed_domains;
	_tmp26_ = _g_object_ref0 (_tmp25_);
	_g_object_unref0 (_tmp24_->hashed_domains);
	_tmp24_->hashed_domains = _tmp26_;
	_tmp27_ = rec;
	_tmp28_ = _data5_->pubkey;
	_tmp29_ = _g_object_ref0 (_tmp28_);
	_g_object_unref0 (_tmp27_->pubkey);
	_tmp27_->pubkey = _tmp29_;
	_tmp30_ = rec;
	_tmp31_ = _data5_->signature;
	_tmp32_ = _g_object_ref0 (_tmp31_);
	_g_object_unref0 (_tmp30_->signature);
	_tmp30_->signature = _tmp32_;
	_tmp33_ = rec;
	_tmp34_ = hashnode;
	_tmp35_ = _g_object_ref0 (_tmp34_);
	_g_object_unref0 (_tmp33_->hashnode);
	_tmp33_->hashnode = _tmp35_;
	_tmp36_ = hashnode;
	_tmp37_ = replicate;
	_tmp38_ = rec;
	netsukuku_check_hash_and_start_replica ((NetsukukuPeerToPeer*) self, _tmp36_, _tmp37_, (GObject*) _tmp38_, NETSUKUKU_COUNTER_DUPLICATION, ___lambda14__netsukuku_accept_record_callback, _data5_, ___lambda15__netsukuku_forward_record_callback, self, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (rec);
			_g_object_unref0 (hashnode);
			block5_data_unref (_data5_);
			_data5_ = NULL;
			return NULL;
		} else {
			_g_object_unref0 (rec);
			_g_object_unref0 (hashnode);
			block5_data_unref (_data5_);
			_data5_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp39_ = _data5_->response_msg;
	_tmp40_ = _data5_->response_ttl;
	_tmp41_ = netsukuku_counter_set_data_response_new (_tmp39_, _tmp40_);
	result = _tmp41_;
	_g_object_unref0 (rec);
	_g_object_unref0 (hashnode);
	block5_data_unref (_data5_);
	_data5_ = NULL;
	return result;
}


static NetsukukuCounterCheckHostnameResponse* netsukuku_counter_real_check_hostname (NetsukukuICounterAsPeer* base, NetsukukuNIP* nip, const gchar* hashed_domain, NetsukukuPublicKey* pubkey, GError** error) {
	NetsukukuCounter * self;
	NetsukukuCounterCheckHostnameResponse* result = NULL;
	gboolean _tmp0_;
	NetsukukuNIP* _tmp6_;
	NetsukukuNIP* _tmp7_ = NULL;
	NetsukukuNIP* hashnode;
	NetsukukuNIP* _tmp8_;
	NetsukukuHCoord* _tmp9_ = NULL;
	NetsukukuHCoord* _tmp10_;
	NetsukukuHCoord* _tmp11_;
	gboolean _tmp12_;
	gboolean response;
	NetsukukuTimeCapsule* _tmp14_;
	NetsukukuTimeCapsule* ttl;
	NetsukukuPairPublicKeyNIP* found;
	NetsukukuPairPublicKeyNIP* _tmp32_;
	gboolean _tmp40_;
	NetsukukuTimeCapsule* _tmp41_;
	NetsukukuCounterCheckHostnameResponse* _tmp42_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuCounter*) base;
	g_return_val_if_fail (nip != NULL, NULL);
	g_return_val_if_fail (hashed_domain != NULL, NULL);
	g_return_val_if_fail (pubkey != NULL, NULL);
	_tmp0_ = self->priv->hooked_to_service;
	if (!_tmp0_) {
		TaskletsTimer* _tmp1_;
		TaskletsTimer* w;
		_tmp1_ = tasklets_timer_new ((gint64) 10000);
		w = _tmp1_;
		while (TRUE) {
			gboolean _tmp2_;
			TaskletsTimer* _tmp3_;
			gboolean _tmp4_ = FALSE;
			_tmp2_ = self->priv->hooked_to_service;
			if (!(!_tmp2_)) {
				break;
			}
			_tmp3_ = w;
			_tmp4_ = tasklets_timer_is_expired (_tmp3_);
			if (_tmp4_) {
				GError* _tmp5_;
				_tmp5_ = g_error_new_literal (NETSUKUKU_PEER_REFUSE_SERVICE_ERROR, NETSUKUKU_PEER_REFUSE_SERVICE_ERROR_GENERIC, "Not hooked yet");
				_inner_error_ = _tmp5_;
				if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (w);
					return NULL;
				} else {
					_g_object_unref0 (w);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			tasklets_tasklet_nap ((glong) 0, (glong) 1000);
		}
		_g_object_unref0 (w);
	}
	netsukuku_counter_check_expirations_cache (self);
	_tmp6_ = nip;
	_tmp7_ = netsukuku_peer_to_peer_h ((NetsukukuPeerToPeer*) self, (GObject*) _tmp6_);
	hashnode = _tmp7_;
	_tmp8_ = hashnode;
	_tmp9_ = netsukuku_peer_to_peer_search_participant ((NetsukukuPeerToPeer*) self, _tmp8_, 1, &_inner_error_);
	_tmp10_ = _tmp9_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (hashnode);
			return NULL;
		} else {
			_g_object_unref0 (hashnode);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp11_ = _tmp10_;
	_tmp12_ = _tmp11_ != NULL;
	_g_object_unref0 (_tmp11_);
	if (_tmp12_) {
		GError* _tmp13_;
		_tmp13_ = g_error_new_literal (NETSUKUKU_PEER_REFUSE_SERVICE_ERROR, NETSUKUKU_PEER_REFUSE_SERVICE_ERROR_GENERIC, "Not the correct hashnode");
		_inner_error_ = _tmp13_;
		if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (hashnode);
			return NULL;
		} else {
			_g_object_unref0 (hashnode);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	response = FALSE;
	_tmp14_ = netsukuku_time_capsule_new ((gint64) 0);
	ttl = _tmp14_;
	found = NULL;
	{
		GeeHashMap* _tmp15_;
		GeeSet* _tmp16_;
		GeeSet* _tmp17_;
		GeeSet* _tmp18_;
		GeeIterator* _tmp19_ = NULL;
		GeeIterator* _tmp20_;
		GeeIterator* _pk_nip_it;
		_tmp15_ = self->priv->cache;
		_tmp16_ = gee_abstract_map_get_keys ((GeeMap*) _tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = _tmp17_;
		_tmp19_ = gee_iterable_iterator ((GeeIterable*) _tmp18_);
		_tmp20_ = _tmp19_;
		_g_object_unref0 (_tmp18_);
		_pk_nip_it = _tmp20_;
		while (TRUE) {
			GeeIterator* _tmp21_;
			gboolean _tmp22_ = FALSE;
			GeeIterator* _tmp23_;
			gpointer _tmp24_ = NULL;
			NetsukukuPairPublicKeyNIP* pk_nip;
			NetsukukuPairPublicKeyNIP* _tmp25_;
			NetsukukuNIP* _tmp26_;
			NetsukukuNIP* _tmp27_;
			NetsukukuNIP* _tmp28_;
			gboolean _tmp29_ = FALSE;
			_tmp21_ = _pk_nip_it;
			_tmp22_ = gee_iterator_next (_tmp21_);
			if (!_tmp22_) {
				break;
			}
			_tmp23_ = _pk_nip_it;
			_tmp24_ = gee_iterator_get (_tmp23_);
			pk_nip = (NetsukukuPairPublicKeyNIP*) _tmp24_;
			_tmp25_ = pk_nip;
			_tmp26_ = netsukuku_pair_public_key_nip_get_nip (_tmp25_);
			_tmp27_ = _tmp26_;
			_tmp28_ = nip;
			_tmp29_ = netsukuku_partial_nip_equal_func ((NetsukukuPartialNIP*) _tmp27_, (NetsukukuPartialNIP*) _tmp28_);
			if (_tmp29_) {
				NetsukukuPairPublicKeyNIP* _tmp30_;
				NetsukukuPairPublicKeyNIP* _tmp31_;
				_tmp30_ = pk_nip;
				_tmp31_ = _g_object_ref0 (_tmp30_);
				_g_object_unref0 (found);
				found = _tmp31_;
				_g_object_unref0 (pk_nip);
				break;
			}
			_g_object_unref0 (pk_nip);
		}
		_g_object_unref0 (_pk_nip_it);
	}
	_tmp32_ = found;
	if (_tmp32_ != NULL) {
		GeeHashMap* _tmp33_;
		NetsukukuPairPublicKeyNIP* _tmp34_;
		gpointer _tmp35_ = NULL;
		NetsukukuCounterNipRecord* _tmp36_;
		NetsukukuTimeCapsule* _tmp37_;
		NetsukukuTimeCapsule* _tmp38_;
		NetsukukuTimeCapsule* _tmp39_;
		response = TRUE;
		_tmp33_ = self->priv->cache;
		_tmp34_ = found;
		_tmp35_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp33_, _tmp34_);
		_tmp36_ = (NetsukukuCounterNipRecord*) _tmp35_;
		_tmp37_ = netsukuku_counter_nip_record_get_expires (_tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = _g_object_ref0 (_tmp38_);
		_g_object_unref0 (ttl);
		ttl = _tmp39_;
		_g_object_unref0 (_tmp36_);
	}
	_tmp40_ = response;
	_tmp41_ = ttl;
	_tmp42_ = netsukuku_counter_check_hostname_response_new (_tmp40_, _tmp41_);
	result = _tmp42_;
	_g_object_unref0 (found);
	_g_object_unref0 (ttl);
	_g_object_unref0 (hashnode);
	return result;
}


static NetsukukuCounterNipRecord* netsukuku_counter_real_get_hostnames (NetsukukuICounterAsPeer* base, NetsukukuNIP* nip, GError** error) {
	NetsukukuCounter * self;
	NetsukukuCounterNipRecord* result = NULL;
	gboolean _tmp0_;
	NetsukukuNIP* _tmp6_;
	NetsukukuNIP* _tmp7_ = NULL;
	NetsukukuNIP* hashnode;
	NetsukukuNIP* _tmp8_;
	NetsukukuHCoord* _tmp9_ = NULL;
	NetsukukuHCoord* _tmp10_;
	NetsukukuHCoord* _tmp11_;
	gboolean _tmp12_;
	NetsukukuPairPublicKeyNIP* found;
	NetsukukuPairPublicKeyNIP* _tmp31_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuCounter*) base;
	g_return_val_if_fail (nip != NULL, NULL);
	_tmp0_ = self->priv->hooked_to_service;
	if (!_tmp0_) {
		TaskletsTimer* _tmp1_;
		TaskletsTimer* w;
		_tmp1_ = tasklets_timer_new ((gint64) 10000);
		w = _tmp1_;
		while (TRUE) {
			gboolean _tmp2_;
			TaskletsTimer* _tmp3_;
			gboolean _tmp4_ = FALSE;
			_tmp2_ = self->priv->hooked_to_service;
			if (!(!_tmp2_)) {
				break;
			}
			_tmp3_ = w;
			_tmp4_ = tasklets_timer_is_expired (_tmp3_);
			if (_tmp4_) {
				GError* _tmp5_;
				_tmp5_ = g_error_new_literal (NETSUKUKU_PEER_REFUSE_SERVICE_ERROR, NETSUKUKU_PEER_REFUSE_SERVICE_ERROR_GENERIC, "Not hooked yet");
				_inner_error_ = _tmp5_;
				if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (w);
					return NULL;
				} else {
					_g_object_unref0 (w);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			tasklets_tasklet_nap ((glong) 0, (glong) 1000);
		}
		_g_object_unref0 (w);
	}
	netsukuku_counter_check_expirations_cache (self);
	_tmp6_ = nip;
	_tmp7_ = netsukuku_peer_to_peer_h ((NetsukukuPeerToPeer*) self, (GObject*) _tmp6_);
	hashnode = _tmp7_;
	_tmp8_ = hashnode;
	_tmp9_ = netsukuku_peer_to_peer_search_participant ((NetsukukuPeerToPeer*) self, _tmp8_, 1, &_inner_error_);
	_tmp10_ = _tmp9_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (hashnode);
			return NULL;
		} else {
			_g_object_unref0 (hashnode);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp11_ = _tmp10_;
	_tmp12_ = _tmp11_ != NULL;
	_g_object_unref0 (_tmp11_);
	if (_tmp12_) {
		GError* _tmp13_;
		_tmp13_ = g_error_new_literal (NETSUKUKU_PEER_REFUSE_SERVICE_ERROR, NETSUKUKU_PEER_REFUSE_SERVICE_ERROR_GENERIC, "Not the correct hashnode");
		_inner_error_ = _tmp13_;
		if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (hashnode);
			return NULL;
		} else {
			_g_object_unref0 (hashnode);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	found = NULL;
	{
		GeeHashMap* _tmp14_;
		GeeSet* _tmp15_;
		GeeSet* _tmp16_;
		GeeSet* _tmp17_;
		GeeIterator* _tmp18_ = NULL;
		GeeIterator* _tmp19_;
		GeeIterator* _pk_nip_it;
		_tmp14_ = self->priv->cache;
		_tmp15_ = gee_abstract_map_get_keys ((GeeMap*) _tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = _tmp16_;
		_tmp18_ = gee_iterable_iterator ((GeeIterable*) _tmp17_);
		_tmp19_ = _tmp18_;
		_g_object_unref0 (_tmp17_);
		_pk_nip_it = _tmp19_;
		while (TRUE) {
			GeeIterator* _tmp20_;
			gboolean _tmp21_ = FALSE;
			GeeIterator* _tmp22_;
			gpointer _tmp23_ = NULL;
			NetsukukuPairPublicKeyNIP* pk_nip;
			NetsukukuPairPublicKeyNIP* _tmp24_;
			NetsukukuNIP* _tmp25_;
			NetsukukuNIP* _tmp26_;
			NetsukukuNIP* _tmp27_;
			gboolean _tmp28_ = FALSE;
			_tmp20_ = _pk_nip_it;
			_tmp21_ = gee_iterator_next (_tmp20_);
			if (!_tmp21_) {
				break;
			}
			_tmp22_ = _pk_nip_it;
			_tmp23_ = gee_iterator_get (_tmp22_);
			pk_nip = (NetsukukuPairPublicKeyNIP*) _tmp23_;
			_tmp24_ = pk_nip;
			_tmp25_ = netsukuku_pair_public_key_nip_get_nip (_tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = nip;
			_tmp28_ = netsukuku_partial_nip_equal_func ((NetsukukuPartialNIP*) _tmp26_, (NetsukukuPartialNIP*) _tmp27_);
			if (_tmp28_) {
				NetsukukuPairPublicKeyNIP* _tmp29_;
				NetsukukuPairPublicKeyNIP* _tmp30_;
				_tmp29_ = pk_nip;
				_tmp30_ = _g_object_ref0 (_tmp29_);
				_g_object_unref0 (found);
				found = _tmp30_;
				_g_object_unref0 (pk_nip);
				break;
			}
			_g_object_unref0 (pk_nip);
		}
		_g_object_unref0 (_pk_nip_it);
	}
	_tmp31_ = found;
	if (_tmp31_ != NULL) {
		GeeHashMap* _tmp32_;
		NetsukukuPairPublicKeyNIP* _tmp33_;
		gpointer _tmp34_ = NULL;
		_tmp32_ = self->priv->cache;
		_tmp33_ = found;
		_tmp34_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp32_, _tmp33_);
		result = (NetsukukuCounterNipRecord*) _tmp34_;
		_g_object_unref0 (found);
		_g_object_unref0 (hashnode);
		return result;
	}
	result = NULL;
	_g_object_unref0 (found);
	_g_object_unref0 (hashnode);
	return result;
}


static NetsukukuCounterGetCacheRecordsResponse* netsukuku_counter_real_get_cache_records (NetsukukuICounterAsPeer* base, GError** error) {
	NetsukukuCounter * self;
	NetsukukuCounterGetCacheRecordsResponse* result = NULL;
	TaskletsTimer* _tmp0_;
	TaskletsTimer* w;
	GeeHashMap* _tmp5_;
	NetsukukuCounterGetCacheRecordsResponse* _tmp6_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuCounter*) base;
	_tmp0_ = tasklets_timer_new ((gint64) 10000);
	w = _tmp0_;
	while (TRUE) {
		gboolean _tmp1_;
		TaskletsTimer* _tmp2_;
		gboolean _tmp3_ = FALSE;
		_tmp1_ = self->priv->hooked_to_service;
		if (!(!_tmp1_)) {
			break;
		}
		_tmp2_ = w;
		_tmp3_ = tasklets_timer_is_expired (_tmp2_);
		if (_tmp3_) {
			GError* _tmp4_;
			_tmp4_ = g_error_new_literal (NETSUKUKU_PEER_REFUSE_SERVICE_ERROR, NETSUKUKU_PEER_REFUSE_SERVICE_ERROR_GENERIC, "Not hooked yet");
			_inner_error_ = _tmp4_;
			if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (w);
				return NULL;
			} else {
				_g_object_unref0 (w);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		tasklets_tasklet_nap ((glong) 0, (glong) 1000);
	}
	_tmp5_ = self->priv->cache;
	_tmp6_ = netsukuku_counter_get_cache_records_response_new (_tmp5_);
	result = _tmp6_;
	_g_object_unref0 (w);
	return result;
}


static GeeArrayList* netsukuku_counter_get_hashednames (NetsukukuCounter* self) {
	GeeArrayList* result;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp18_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_hashednames;
	if (_tmp0_ == NULL) {
		GeeArrayList* _tmp1_;
		gchar buffer[256] = {0};
		gchar* myhostname;
		gint _tmp2_ = 0;
		const gchar* _tmp13_;
		_tmp1_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
		_g_object_unref0 (self->priv->_hashednames);
		self->priv->_hashednames = _tmp1_;
		myhostname = NULL;
		_tmp2_ = gethostname (buffer, 256);
		if (_tmp2_ == 0) {
			GString* _tmp3_;
			GString* sb;
			gint pos;
			GString* _tmp9_;
			GString* _tmp10_;
			const gchar* _tmp11_;
			gchar* _tmp12_;
			_tmp3_ = g_string_new ("");
			sb = _tmp3_;
			pos = 0;
			while (TRUE) {
				gint _tmp4_;
				gchar _tmp5_;
				GString* _tmp6_;
				gint _tmp7_;
				gchar _tmp8_;
				_tmp4_ = pos;
				_tmp5_ = buffer[_tmp4_];
				if (!(_tmp5_ != '\0')) {
					break;
				}
				_tmp6_ = sb;
				_tmp7_ = pos;
				pos = _tmp7_ + 1;
				_tmp8_ = buffer[_tmp7_];
				g_string_append_c (_tmp6_, _tmp8_);
			}
			_tmp9_ = sb;
			g_string_append_c (_tmp9_, '\0');
			_tmp10_ = sb;
			_tmp11_ = _tmp10_->str;
			_tmp12_ = g_strdup (_tmp11_);
			_g_free0 (myhostname);
			myhostname = _tmp12_;
			_g_string_free0 (sb);
		}
		_tmp13_ = myhostname;
		if (_tmp13_ != NULL) {
			GeeArrayList* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_ = NULL;
			gchar* _tmp17_;
			_tmp14_ = self->priv->_hashednames;
			_tmp15_ = myhostname;
			_tmp16_ = netsukuku_andna_crypto_hash (_tmp15_);
			_tmp17_ = _tmp16_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp14_, _tmp17_);
			_g_free0 (_tmp17_);
		}
		_g_free0 (myhostname);
	}
	_tmp18_ = self->priv->_hashednames;
	result = _tmp18_;
	return result;
}


static NetsukukuAndna* netsukuku_counter_get_andna (NetsukukuCounter* self) {
	NetsukukuAndna* result;
	NetsukukuAndna* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_andna;
	result = _tmp0_;
	return result;
}


void netsukuku_counter_set_andna (NetsukukuCounter* self, NetsukukuAndna* value) {
	NetsukukuAndna* _tmp0_;
	NetsukukuAndna* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_andna);
	self->priv->_andna = _tmp1_;
	g_object_notify ((GObject *) self, "andna");
}


static void netsukuku_counter_class_init (NetsukukuCounterClass * klass) {
	netsukuku_counter_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (NetsukukuCounterPrivate));
	ZCD_RPC_DISPATCHER_CLASS (klass)->_dispatch = netsukuku_counter_real__dispatch;
	NETSUKUKU_PEER_TO_PEER_CLASS (klass)->h = netsukuku_counter_real_h;
	NETSUKUKU_COUNTER_CLASS (klass)->contact_registrar = netsukuku_counter_real_contact_registrar;
	G_OBJECT_CLASS (klass)->get_property = _vala_netsukuku_counter_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_netsukuku_counter_set_property;
	G_OBJECT_CLASS (klass)->finalize = netsukuku_counter_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETSUKUKU_COUNTER_ANDNA, g_param_spec_object ("andna", "andna", "andna", NETSUKUKU_TYPE_ANDNA, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
	g_signal_new ("counter_hooked", NETSUKUKU_TYPE_COUNTER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("counter_registered", NETSUKUKU_TYPE_COUNTER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void netsukuku_counter_netsukuku_icounter_as_peer_interface_init (NetsukukuICounterAsPeerIface * iface) {
	netsukuku_counter_netsukuku_icounter_as_peer_parent_iface = g_type_interface_peek_parent (iface);
	iface->set_data_for_pubk = (NetsukukuCounterSetDataResponse* (*)(NetsukukuICounterAsPeer*, NetsukukuNIP*, GeeList*, NetsukukuPublicKey*, zcdSerializableBuffer*, gboolean, GError**)) netsukuku_counter_real_set_data_for_pubk;
	iface->check_hostname = (NetsukukuCounterCheckHostnameResponse* (*)(NetsukukuICounterAsPeer*, NetsukukuNIP*, const gchar*, NetsukukuPublicKey*, GError**)) netsukuku_counter_real_check_hostname;
	iface->get_hostnames = (NetsukukuCounterNipRecord* (*)(NetsukukuICounterAsPeer*, NetsukukuNIP*, GError**)) netsukuku_counter_real_get_hostnames;
	iface->get_cache_records = (NetsukukuCounterGetCacheRecordsResponse* (*)(NetsukukuICounterAsPeer*, GError**)) netsukuku_counter_real_get_cache_records;
}


static void netsukuku_counter_instance_init (NetsukukuCounter * self) {
	self->priv = NETSUKUKU_COUNTER_GET_PRIVATE (self);
}


static void netsukuku_counter_finalize (GObject* obj) {
	NetsukukuCounter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_COUNTER, NetsukukuCounter);
	_g_object_unref0 (self->priv->_hashednames);
	_g_object_unref0 (self->priv->peer_to_peer_all);
	_g_object_unref0 (self->priv->reset_my_counter_node_tasklet);
	_g_object_unref0 (self->priv->_andna);
	_g_object_unref0 (self->priv->my_keys);
	_g_object_unref0 (self->priv->pubk);
	_g_object_unref0 (self->priv->cache);
	G_OBJECT_CLASS (netsukuku_counter_parent_class)->finalize (obj);
}


GType netsukuku_counter_get_type (void) {
	static volatile gsize netsukuku_counter_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_counter_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuCounterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_counter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuCounter), 0, (GInstanceInitFunc) netsukuku_counter_instance_init, NULL };
		static const GInterfaceInfo netsukuku_icounter_as_peer_info = { (GInterfaceInitFunc) netsukuku_counter_netsukuku_icounter_as_peer_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType netsukuku_counter_type_id;
		netsukuku_counter_type_id = g_type_register_static (NETSUKUKU_TYPE_OPTIONAL_PEER_TO_PEER, "NetsukukuCounter", &g_define_type_info, 0);
		g_type_add_interface_static (netsukuku_counter_type_id, NETSUKUKU_TYPE_ICOUNTER_AS_PEER, &netsukuku_icounter_as_peer_info);
		g_once_init_leave (&netsukuku_counter_type_id__volatile, netsukuku_counter_type_id);
	}
	return netsukuku_counter_type_id__volatile;
}


static void _vala_netsukuku_counter_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	NetsukukuCounter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETSUKUKU_TYPE_COUNTER, NetsukukuCounter);
	switch (property_id) {
		case NETSUKUKU_COUNTER_ANDNA:
		g_value_set_object (value, netsukuku_counter_get_andna (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_netsukuku_counter_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	NetsukukuCounter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETSUKUKU_TYPE_COUNTER, NetsukukuCounter);
	switch (property_id) {
		case NETSUKUKU_COUNTER_ANDNA:
		netsukuku_counter_set_andna (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



