/* coord.c generated by valac 0.20.1, the Vala compiler
 * generated from coord.vala, do not modify */

/*
 *  This file is part of Netsukuku.
 *  (c) Copyright 2011 Luca Dionisi aka lukisi <luca.dionisi@gmail.com>
 *
 *  Netsukuku is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Netsukuku is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Netsukuku.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * Coordinator Node
 *
 * TODO: a fixed timeout isn't a
 *       good thing, you have to consider the rtt from the requester node to
 *       the coordinator node. Any better idea?
 */
/** Handling events **/

#include <glib.h>
#include <glib-object.h>
#include <zcd.h>
#include <netsukuku-rpc.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <tasklet.h>


#define NETSUKUKU_TYPE_RMT_PEER (netsukuku_rmt_peer_get_type ())
#define NETSUKUKU_RMT_PEER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_RMT_PEER, NetsukukuRmtPeer))
#define NETSUKUKU_RMT_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_RMT_PEER, NetsukukuRmtPeerClass))
#define NETSUKUKU_IS_RMT_PEER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_RMT_PEER))
#define NETSUKUKU_IS_RMT_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_RMT_PEER))
#define NETSUKUKU_RMT_PEER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_RMT_PEER, NetsukukuRmtPeerClass))

typedef struct _NetsukukuRmtPeer NetsukukuRmtPeer;
typedef struct _NetsukukuRmtPeerClass NetsukukuRmtPeerClass;
typedef struct _NetsukukuRmtPeerPrivate NetsukukuRmtPeerPrivate;

#define NETSUKUKU_TYPE_RMT_COORD_PEER (netsukuku_rmt_coord_peer_get_type ())
#define NETSUKUKU_RMT_COORD_PEER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_RMT_COORD_PEER, NetsukukuRmtCoordPeer))
#define NETSUKUKU_RMT_COORD_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_RMT_COORD_PEER, NetsukukuRmtCoordPeerClass))
#define NETSUKUKU_IS_RMT_COORD_PEER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_RMT_COORD_PEER))
#define NETSUKUKU_IS_RMT_COORD_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_RMT_COORD_PEER))
#define NETSUKUKU_RMT_COORD_PEER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_RMT_COORD_PEER, NetsukukuRmtCoordPeerClass))

typedef struct _NetsukukuRmtCoordPeer NetsukukuRmtCoordPeer;
typedef struct _NetsukukuRmtCoordPeerClass NetsukukuRmtCoordPeerClass;
typedef struct _NetsukukuRmtCoordPeerPrivate NetsukukuRmtCoordPeerPrivate;

#define NETSUKUKU_TYPE_PEER_TO_PEER (netsukuku_peer_to_peer_get_type ())
#define NETSUKUKU_PEER_TO_PEER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_PEER_TO_PEER, NetsukukuPeerToPeer))
#define NETSUKUKU_PEER_TO_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_PEER_TO_PEER, NetsukukuPeerToPeerClass))
#define NETSUKUKU_IS_PEER_TO_PEER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_PEER_TO_PEER))
#define NETSUKUKU_IS_PEER_TO_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_PEER_TO_PEER))
#define NETSUKUKU_PEER_TO_PEER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_PEER_TO_PEER, NetsukukuPeerToPeerClass))

typedef struct _NetsukukuPeerToPeer NetsukukuPeerToPeer;
typedef struct _NetsukukuPeerToPeerClass NetsukukuPeerToPeerClass;

#define NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR (netsukuku_aggregated_neighbour_get_type ())
#define NETSUKUKU_AGGREGATED_NEIGHBOUR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR, NetsukukuAggregatedNeighbour))
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR, NetsukukuAggregatedNeighbourClass))
#define NETSUKUKU_IS_AGGREGATED_NEIGHBOUR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR))
#define NETSUKUKU_IS_AGGREGATED_NEIGHBOUR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR))
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR, NetsukukuAggregatedNeighbourClass))

typedef struct _NetsukukuAggregatedNeighbour NetsukukuAggregatedNeighbour;
typedef struct _NetsukukuAggregatedNeighbourClass NetsukukuAggregatedNeighbourClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define NETSUKUKU_TYPE_COORD_HKEY (netsukuku_coord_hkey_get_type ())
#define NETSUKUKU_COORD_HKEY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_COORD_HKEY, NetsukukuCoord_hkey))
#define NETSUKUKU_COORD_HKEY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_COORD_HKEY, NetsukukuCoord_hkeyClass))
#define NETSUKUKU_IS_COORD_HKEY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_COORD_HKEY))
#define NETSUKUKU_IS_COORD_HKEY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_COORD_HKEY))
#define NETSUKUKU_COORD_HKEY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_COORD_HKEY, NetsukukuCoord_hkeyClass))

typedef struct _NetsukukuCoord_hkey NetsukukuCoord_hkey;
typedef struct _NetsukukuCoord_hkeyClass NetsukukuCoord_hkeyClass;
typedef struct _NetsukukuCoord_hkeyPrivate NetsukukuCoord_hkeyPrivate;

#define NETSUKUKU_TYPE_STRUCT_HELPER_COORD_COMMUNICATE_TO_NEW_COORDINATOR (netsukuku_struct_helper_coord_communicate_to_new_coordinator_get_type ())

#define NETSUKUKU_TYPE_COORD (netsukuku_coord_get_type ())
#define NETSUKUKU_COORD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_COORD, NetsukukuCoord))
#define NETSUKUKU_COORD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_COORD, NetsukukuCoordClass))
#define NETSUKUKU_IS_COORD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_COORD))
#define NETSUKUKU_IS_COORD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_COORD))
#define NETSUKUKU_COORD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_COORD, NetsukukuCoordClass))

typedef struct _NetsukukuCoord NetsukukuCoord;
typedef struct _NetsukukuCoordClass NetsukukuCoordClass;
typedef struct _Netsukukustruct_helper_Coord_communicate_to_new_coordinator Netsukukustruct_helper_Coord_communicate_to_new_coordinator;
typedef struct _NetsukukuPeerToPeerPrivate NetsukukuPeerToPeerPrivate;

#define NETSUKUKU_TYPE_MAP (netsukuku_map_get_type ())
#define NETSUKUKU_MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_MAP, NetsukukuMap))
#define NETSUKUKU_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_MAP, NetsukukuMapClass))
#define NETSUKUKU_IS_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_MAP))
#define NETSUKUKU_IS_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_MAP))
#define NETSUKUKU_MAP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_MAP, NetsukukuMapClass))

typedef struct _NetsukukuMap NetsukukuMap;
typedef struct _NetsukukuMapClass NetsukukuMapClass;

#define NETSUKUKU_TYPE_MAP_ROUTE (netsukuku_map_route_get_type ())
#define NETSUKUKU_MAP_ROUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_MAP_ROUTE, NetsukukuMapRoute))
#define NETSUKUKU_MAP_ROUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_MAP_ROUTE, NetsukukuMapRouteClass))
#define NETSUKUKU_IS_MAP_ROUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_MAP_ROUTE))
#define NETSUKUKU_IS_MAP_ROUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_MAP_ROUTE))
#define NETSUKUKU_MAP_ROUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_MAP_ROUTE, NetsukukuMapRouteClass))

typedef struct _NetsukukuMapRoute NetsukukuMapRoute;
typedef struct _NetsukukuMapRouteClass NetsukukuMapRouteClass;

#define NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER (netsukuku_aggregated_neighbour_manager_get_type ())
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, NetsukukuAggregatedNeighbourManager))
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, NetsukukuAggregatedNeighbourManagerClass))
#define NETSUKUKU_IS_AGGREGATED_NEIGHBOUR_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER))
#define NETSUKUKU_IS_AGGREGATED_NEIGHBOUR_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER))
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, NetsukukuAggregatedNeighbourManagerClass))

typedef struct _NetsukukuAggregatedNeighbourManager NetsukukuAggregatedNeighbourManager;
typedef struct _NetsukukuAggregatedNeighbourManagerClass NetsukukuAggregatedNeighbourManagerClass;
typedef struct _NetsukukuCoordPrivate NetsukukuCoordPrivate;

#define NETSUKUKU_TYPE_COORDINATOR (netsukuku_coordinator_get_type ())
#define NETSUKUKU_COORDINATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_COORDINATOR, NetsukukuCoordinator))
#define NETSUKUKU_COORDINATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_COORDINATOR, NetsukukuCoordinatorClass))
#define NETSUKUKU_IS_COORDINATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_COORDINATOR))
#define NETSUKUKU_IS_COORDINATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_COORDINATOR))
#define NETSUKUKU_COORDINATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_COORDINATOR, NetsukukuCoordinatorClass))

typedef struct _NetsukukuCoordinator NetsukukuCoordinator;
typedef struct _NetsukukuCoordinatorClass NetsukukuCoordinatorClass;

#define NETSUKUKU_TYPE_PEER_TO_PEER_ALL (netsukuku_peer_to_peer_all_get_type ())
#define NETSUKUKU_PEER_TO_PEER_ALL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_PEER_TO_PEER_ALL, NetsukukuPeerToPeerAll))
#define NETSUKUKU_PEER_TO_PEER_ALL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_PEER_TO_PEER_ALL, NetsukukuPeerToPeerAllClass))
#define NETSUKUKU_IS_PEER_TO_PEER_ALL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_PEER_TO_PEER_ALL))
#define NETSUKUKU_IS_PEER_TO_PEER_ALL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_PEER_TO_PEER_ALL))
#define NETSUKUKU_PEER_TO_PEER_ALL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_PEER_TO_PEER_ALL, NetsukukuPeerToPeerAllClass))

typedef struct _NetsukukuPeerToPeerAll NetsukukuPeerToPeerAll;
typedef struct _NetsukukuPeerToPeerAllClass NetsukukuPeerToPeerAllClass;
typedef struct _NetsukukuCoordinatorPrivate NetsukukuCoordinatorPrivate;

#define NETSUKUKU_TYPE_ROUTE_NODE (netsukuku_route_node_get_type ())
#define NETSUKUKU_ROUTE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_ROUTE_NODE, NetsukukuRouteNode))
#define NETSUKUKU_ROUTE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_ROUTE_NODE, NetsukukuRouteNodeClass))
#define NETSUKUKU_IS_ROUTE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_ROUTE_NODE))
#define NETSUKUKU_IS_ROUTE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_ROUTE_NODE))
#define NETSUKUKU_ROUTE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_ROUTE_NODE, NetsukukuRouteNodeClass))

typedef struct _NetsukukuRouteNode NetsukukuRouteNode;
typedef struct _NetsukukuRouteNodeClass NetsukukuRouteNodeClass;

#define NETSUKUKU_TYPE_STRUCT_HELPER_COORDINATOR_MANAGE_BNODE_TUNNELS (netsukuku_struct_helper_coordinator_manage_bnode_tunnels_get_type ())
typedef struct _Netsukukustruct_helper_Coordinator_manage_bnode_tunnels Netsukukustruct_helper_Coordinator_manage_bnode_tunnels;

#define NETSUKUKU_TYPE_STRUCT_HELPER_COORDINATOR_FORWARD_KNOWLEDGE (netsukuku_struct_helper_coordinator_forward_knowledge_get_type ())
typedef struct _Netsukukustruct_helper_Coordinator_forward_knowledge Netsukukustruct_helper_Coordinator_forward_knowledge;

#define NETSUKUKU_TYPE_STRUCT_HELPER_COORDINATOR_FORWARD_KNOWLEDGE_TO_NIP (netsukuku_struct_helper_coordinator_forward_knowledge_to_nip_get_type ())
typedef struct _Netsukukustruct_helper_Coordinator_forward_knowledge_to_nip Netsukukustruct_helper_Coordinator_forward_knowledge_to_nip;

#define NETSUKUKU_TYPE_STRUCT_HELPER_COORDINATOR_FORWARD_FREE (netsukuku_struct_helper_coordinator_forward_free_get_type ())
typedef struct _Netsukukustruct_helper_Coordinator_forward_free Netsukukustruct_helper_Coordinator_forward_free;

#define NETSUKUKU_TYPE_STRUCT_HELPER_COORDINATOR_FORWARD_FREE_TO_NIP (netsukuku_struct_helper_coordinator_forward_free_to_nip_get_type ())
typedef struct _Netsukukustruct_helper_Coordinator_forward_free_to_nip Netsukukustruct_helper_Coordinator_forward_free_to_nip;

#define NETSUKUKU_COORDINATOR_TYPE_PAIR (netsukuku_coordinator_pair_get_type ())
#define NETSUKUKU_COORDINATOR_PAIR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_COORDINATOR_TYPE_PAIR, NetsukukuCoordinatorPair))
#define NETSUKUKU_COORDINATOR_PAIR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_COORDINATOR_TYPE_PAIR, NetsukukuCoordinatorPairClass))
#define NETSUKUKU_COORDINATOR_IS_PAIR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_COORDINATOR_TYPE_PAIR))
#define NETSUKUKU_COORDINATOR_IS_PAIR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_COORDINATOR_TYPE_PAIR))
#define NETSUKUKU_COORDINATOR_PAIR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_COORDINATOR_TYPE_PAIR, NetsukukuCoordinatorPairClass))

typedef struct _NetsukukuCoordinatorPair NetsukukuCoordinatorPair;
typedef struct _NetsukukuCoordinatorPairClass NetsukukuCoordinatorPairClass;
typedef struct _NetsukukuCoordinatorPairPrivate NetsukukuCoordinatorPairPrivate;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _NetsukukuRmtPeer {
	GObject parent_instance;
	NetsukukuRmtPeerPrivate * priv;
};

struct _NetsukukuRmtPeerClass {
	GObjectClass parent_class;
	zcdISerializable* (*rmt) (NetsukukuRmtPeer* self, zcdRemoteCall* data, GError** error);
};

struct _NetsukukuRmtCoordPeer {
	NetsukukuRmtPeer parent_instance;
	NetsukukuRmtCoordPeerPrivate * priv;
};

struct _NetsukukuRmtCoordPeerClass {
	NetsukukuRmtPeerClass parent_class;
};

struct _NetsukukuCoord_hkey {
	GObject parent_instance;
	NetsukukuCoord_hkeyPrivate * priv;
	gint level_of_gnode;
	NetsukukuNIP* nip;
};

struct _NetsukukuCoord_hkeyClass {
	GObjectClass parent_class;
};

struct _Netsukukustruct_helper_Coord_communicate_to_new_coordinator {
	NetsukukuCoord* self;
	gint level_of_gnode;
};

struct _NetsukukuPeerToPeer {
	zcdRPCDispatcher parent_instance;
	NetsukukuPeerToPeerPrivate * priv;
	NetsukukuMapRoute* maproute;
	NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager;
	gint pid;
	gboolean has_valid_map;
};

struct _NetsukukuPeerToPeerClass {
	zcdRPCDispatcherClass parent_class;
	void (*start_operations) (NetsukukuPeerToPeer* self);
	void (*stop_operations) (NetsukukuPeerToPeer* self);
	gboolean (*is_participant) (NetsukukuPeerToPeer* self, gint lvl, gint pos);
	NetsukukuNIP* (*h) (NetsukukuPeerToPeer* self, GObject* key);
};

struct _NetsukukuCoord {
	NetsukukuPeerToPeer parent_instance;
	NetsukukuCoordPrivate * priv;
};

struct _NetsukukuCoordClass {
	NetsukukuPeerToPeerClass parent_class;
};

struct _NetsukukuCoordPrivate {
	GeeArrayList* _coordinators;
};

typedef enum  {
	NETSUKUKU_PEER_TO_PEER_ERROR_REGISTER,
	NETSUKUKU_PEER_TO_PEER_ERROR_GENERIC
} NetsukukuPeerToPeerError;
#define NETSUKUKU_PEER_TO_PEER_ERROR netsukuku_peer_to_peer_error_quark ()
struct _NetsukukuCoordinator {
	GObject parent_instance;
	NetsukukuCoordinatorPrivate * priv;
	gint last_assigned_elderliness;
};

struct _NetsukukuCoordinatorClass {
	GObjectClass parent_class;
};

struct _Netsukukustruct_helper_Coordinator_manage_bnode_tunnels {
	NetsukukuCoordinator* self;
};

struct _Netsukukustruct_helper_Coordinator_forward_knowledge {
	NetsukukuCoordinator* self;
};

struct _Netsukukustruct_helper_Coordinator_forward_knowledge_to_nip {
	NetsukukuCoordinator* self;
	NetsukukuNIP* nip;
};

struct _Netsukukustruct_helper_Coordinator_forward_free {
	NetsukukuCoordinator* self;
	gint pos;
};

struct _Netsukukustruct_helper_Coordinator_forward_free_to_nip {
	NetsukukuCoordinator* self;
	NetsukukuNIP* to_nip;
	gint pos;
};

struct _NetsukukuCoordinatorPrivate {
	NetsukukuBookings* bookings;
	NetsukukuBnodeList* bnode_list;
	NetsukukuPartialNIP* _gnode;
	NetsukukuCoord* parent;
	NetsukukuMapRoute* maproute;
	gint level_of_gnode;
	gint level_of_nodes;
	gboolean _is_main_previous_state;
	gboolean _is_main_latest_evaluation;
	TaskletsTasklet* manage_bnode_tunnels_handle;
};

struct _NetsukukuCoordinatorPair {
	GObject parent_instance;
	NetsukukuCoordinatorPairPrivate * priv;
};

struct _NetsukukuCoordinatorPairClass {
	GObjectClass parent_class;
};

struct _NetsukukuCoordinatorPairPrivate {
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	GType b_type;
	GBoxedCopyFunc b_dup_func;
	GDestroyNotify b_destroy_func;
	gpointer _a;
	gpointer _b;
};


static gpointer netsukuku_rmt_coord_peer_parent_class = NULL;
static NetsukukuICoordIface* netsukuku_rmt_coord_peer_netsukuku_icoord_parent_iface = NULL;
static gpointer netsukuku_coord_hkey_parent_class = NULL;
static gpointer netsukuku_coord_parent_class = NULL;
static NetsukukuICoordIface* netsukuku_coord_netsukuku_icoord_parent_iface = NULL;
static gpointer netsukuku_coordinator_parent_class = NULL;
static gpointer netsukuku_coordinator_pair_parent_class = NULL;

#define NETSUKUKU_COORD_DUPLICATION 10
GType netsukuku_rmt_peer_get_type (void) G_GNUC_CONST;
GType netsukuku_rmt_coord_peer_get_type (void) G_GNUC_CONST;
enum  {
	NETSUKUKU_RMT_COORD_PEER_DUMMY_PROPERTY
};
GType netsukuku_peer_to_peer_get_type (void) G_GNUC_CONST;
GType netsukuku_aggregated_neighbour_get_type (void) G_GNUC_CONST;
NetsukukuRmtCoordPeer* netsukuku_rmt_coord_peer_new (NetsukukuPeerToPeer* peer_to_peer_service, GObject* key, NetsukukuNIP* hIP, NetsukukuAggregatedNeighbour* aggregated_neighbour);
NetsukukuRmtCoordPeer* netsukuku_rmt_coord_peer_construct (GType object_type, NetsukukuPeerToPeer* peer_to_peer_service, GObject* key, NetsukukuNIP* hIP, NetsukukuAggregatedNeighbour* aggregated_neighbour);
NetsukukuRmtPeer* netsukuku_rmt_peer_construct (GType object_type, NetsukukuPeerToPeer* peer_to_peer_service, GObject* key, NetsukukuNIP* hIP, NetsukukuAggregatedNeighbour* aggregated_neighbour);
static void netsukuku_rmt_coord_peer_real_duplicate_all_knowledge (NetsukukuICoord* base, NetsukukuPartialNIP* gnode, NetsukukuCoordinatorKnowledge* coordinator_knowledge, GError** error);
zcdISerializable* netsukuku_rmt_peer_rmt (NetsukukuRmtPeer* self, zcdRemoteCall* data, GError** error);
static NetsukukuHookReservation* netsukuku_rmt_coord_peer_real_reserve (NetsukukuICoord* base, NetsukukuPartialNIP* gnode, GError** error);
static void netsukuku_rmt_coord_peer_real_free (NetsukukuICoord* base, NetsukukuPartialNIP* gnode, gint pos, GError** error);
static void netsukuku_rmt_coord_peer_real_duplicate_free (NetsukukuICoord* base, NetsukukuPartialNIP* gnode, gint pos, GError** error);
static gboolean netsukuku_rmt_coord_peer_real_register_bnode (NetsukukuICoord* base, NetsukukuPartialNIP* gnode, NetsukukuNIP* nip, gboolean is_border, gboolean has_tunnel, gboolean is_willing, GError** error);
static GeeList* netsukuku_rmt_coord_peer_real_report_status (NetsukukuICoord* base, GError** error);
GType netsukuku_coord_hkey_get_type (void) G_GNUC_CONST;
enum  {
	NETSUKUKU_COORD_HKEY_DUMMY_PROPERTY
};
NetsukukuCoord_hkey* netsukuku_coord_hkey_new (void);
NetsukukuCoord_hkey* netsukuku_coord_hkey_construct (GType object_type);
static void netsukuku_coord_hkey_finalize (GObject* obj);
GType netsukuku_struct_helper_coord_communicate_to_new_coordinator_get_type (void) G_GNUC_CONST;
GType netsukuku_coord_get_type (void) G_GNUC_CONST;
Netsukukustruct_helper_Coord_communicate_to_new_coordinator* netsukuku_struct_helper_coord_communicate_to_new_coordinator_dup (const Netsukukustruct_helper_Coord_communicate_to_new_coordinator* self);
void netsukuku_struct_helper_coord_communicate_to_new_coordinator_free (Netsukukustruct_helper_Coord_communicate_to_new_coordinator* self);
void netsukuku_struct_helper_coord_communicate_to_new_coordinator_copy (const Netsukukustruct_helper_Coord_communicate_to_new_coordinator* self, Netsukukustruct_helper_Coord_communicate_to_new_coordinator* dest);
void netsukuku_struct_helper_coord_communicate_to_new_coordinator_destroy (Netsukukustruct_helper_Coord_communicate_to_new_coordinator* self);
GType netsukuku_map_get_type (void) G_GNUC_CONST;
GType netsukuku_map_route_get_type (void) G_GNUC_CONST;
GType netsukuku_aggregated_neighbour_manager_get_type (void) G_GNUC_CONST;
GType netsukuku_coordinator_get_type (void) G_GNUC_CONST;
#define NETSUKUKU_COORD_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), NETSUKUKU_TYPE_COORD, NetsukukuCoordPrivate))
enum  {
	NETSUKUKU_COORD_DUMMY_PROPERTY
};
#define NETSUKUKU_COORD_mypid 1
GType netsukuku_peer_to_peer_all_get_type (void) G_GNUC_CONST;
NetsukukuCoord* netsukuku_coord_new (NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, NetsukukuPeerToPeerAll* peer_to_peer_all, NetsukukuCoordinatorKnowledgeSet* coordinator_knowledge_set);
NetsukukuCoord* netsukuku_coord_construct (GType object_type, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, NetsukukuPeerToPeerAll* peer_to_peer_all, NetsukukuCoordinatorKnowledgeSet* coordinator_knowledge_set);
NetsukukuPeerToPeer* netsukuku_peer_to_peer_new (NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, gint pid);
NetsukukuPeerToPeer* netsukuku_peer_to_peer_construct (GType object_type, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, gint pid);
GQuark netsukuku_peer_to_peer_error_quark (void);
void netsukuku_peer_to_peer_all_peer_to_peer_register (NetsukukuPeerToPeerAll* self, NetsukukuPeerToPeer* peer_to_peer, GError** error);
void netsukuku_coord_initialize_coordinators (NetsukukuCoord* self);
gint netsukuku_map_get_levels (NetsukukuMap* self);
NetsukukuCoordinator* netsukuku_coord_get_coordinator_for_gnode_at_level (NetsukukuCoord* self, gint l);
NetsukukuPartialNIP* netsukuku_coordinator_get_gnode (NetsukukuCoordinator* self);
void netsukuku_coordinator_add_bookings (NetsukukuCoordinator* self, NetsukukuBookings* bookings);
void netsukuku_coordinator_add_bnode_list (NetsukukuCoordinator* self, NetsukukuBnodeList* bnode_list);
GType netsukuku_route_node_get_type (void) G_GNUC_CONST;
void netsukuku_coord_node_joins_maproute (NetsukukuCoord* self, gint level_of_nodes, gint pos);
static void _netsukuku_coord_node_joins_maproute_netsukuku_map_node_new (NetsukukuMap* _sender, gint lvl, gint pos, gpointer self);
void netsukuku_coord_node_exits_maproute (NetsukukuCoord* self, gint level_of_nodes, gint pos);
static void _netsukuku_coord_node_exits_maproute_netsukuku_map_node_deleted (NetsukukuMap* _sender, gint lvl, gint pos, gpointer self);
void netsukuku_coord_coord_has_valid_map (NetsukukuCoord* self);
static void _netsukuku_coord_coord_has_valid_map_netsukuku_peer_to_peer_map_peer_to_peer_validated (NetsukukuPeerToPeer* _sender, gpointer self);
NetsukukuRmtCoordPeer* netsukuku_coord_peer (NetsukukuCoord* self, NetsukukuNIP* hIP, GObject* key, NetsukukuAggregatedNeighbour* aggregated_neighbour);
static zcdISerializable* netsukuku_coord_real__dispatch (zcdRPCDispatcher* base, GObject* caller, zcdRemoteCall* data, GError** error);
static GeeList* netsukuku_coord_real_report_status (NetsukukuICoord* base, GError** error);
NetsukukuNIP* netsukuku_map_get_me (NetsukukuMap* self);
NetsukukuPartialNIP* netsukuku_peer_to_peer_search_participant_as_nip (NetsukukuPeerToPeer* self, NetsukukuNIP* hIP, gint path_sign, GError** error);
NetsukukuNIP* netsukuku_peer_to_peer_h (NetsukukuPeerToPeer* self, GObject* key);
void netsukuku_log_error (const gchar* msg);
NetsukukuCoordinatorKnowledge* netsukuku_coordinator_report_status (NetsukukuCoordinator* self);
gboolean netsukuku_coordinator_get_is_main (NetsukukuCoordinator* self);
static NetsukukuNIP* netsukuku_coord_real_h (NetsukukuPeerToPeer* base, GObject* k);
static void netsukuku_coord_set_coordinator_for_gnode_at_level (NetsukukuCoord* self, gint l);
NetsukukuCoordinator* netsukuku_coordinator_new (NetsukukuPartialNIP* gnode, NetsukukuCoord* parent);
NetsukukuCoordinator* netsukuku_coordinator_construct (GType object_type, NetsukukuPartialNIP* gnode, NetsukukuCoord* parent);
static void netsukuku_coord_real_stop_operations (NetsukukuPeerToPeer* base);
void netsukuku_peer_to_peer_stop_operations (NetsukukuPeerToPeer* self);
void netsukuku_coordinator_stop_operations (NetsukukuCoordinator* self);
NetsukukuPartialNIP* netsukuku_coord_get_my_gnode_at_level (NetsukukuCoord* self, gint l);
gint netsukuku_coord_get_level_of_gnode (NetsukukuCoord* self, NetsukukuPartialNIP* gnode);
NetsukukuCoordinator* netsukuku_coord_get_coordinator_for_gnode (NetsukukuCoord* self, NetsukukuPartialNIP* gnode, GError** error);
NetsukukuHookReservation* netsukuku_coord_enter_into (NetsukukuCoord* self, gint level_of_gnode, NetsukukuNIP* nip, NetsukukuAggregatedNeighbour* neighbour_to_contact);
void netsukuku_log_info (const gchar* msg);
NetsukukuBookings* netsukuku_coord_get_bookings (NetsukukuCoord* self, gint level_of_gnode);
NetsukukuBookings* netsukuku_coordinator_get_bookings (NetsukukuCoordinator* self);
gint netsukuku_coord_get_last_assigned_elderliness (NetsukukuCoord* self, gint level_of_gnode);
NetsukukuBnodeList* netsukuku_coord_get_bnode_list (NetsukukuCoord* self, gint level_of_gnode);
NetsukukuBnodeList* netsukuku_coordinator_get_bnode_list (NetsukukuCoordinator* self);
static NetsukukuHookReservation* netsukuku_coord_real_reserve (NetsukukuICoord* base, NetsukukuPartialNIP* gnode, GError** error);
NetsukukuHookReservation* netsukuku_coordinator_reserve (NetsukukuCoordinator* self);
static void netsukuku_coord_real_free (NetsukukuICoord* base, NetsukukuPartialNIP* gnode, gint pos, GError** error);
void netsukuku_coordinator_free (NetsukukuCoordinator* self, gint pos);
static void netsukuku_coord_real_duplicate_all_knowledge (NetsukukuICoord* base, NetsukukuPartialNIP* gnode, NetsukukuCoordinatorKnowledge* coordinator_knowledge, GError** error);
static void netsukuku_coord_real_duplicate_free (NetsukukuICoord* base, NetsukukuPartialNIP* gnode, gint pos, GError** error);
void netsukuku_coordinator_force_remove (NetsukukuCoordinator* self, gint pos);
static gboolean netsukuku_coord_real_register_bnode (NetsukukuICoord* base, NetsukukuPartialNIP* gnode, NetsukukuNIP* nip, gboolean is_border, gboolean has_tunnel, gboolean is_willing, GError** error);
gboolean netsukuku_coordinator_register_bnode (NetsukukuCoordinator* self, NetsukukuNIP* nip, gboolean is_border, gboolean has_tunnel, gboolean is_willing);
void netsukuku_coordinator_map_has_changed (NetsukukuCoordinator* self);
gboolean netsukuku_coordinator_get_was_main (NetsukukuCoordinator* self);
void netsukuku_coord_communicate_to_new_coordinator (NetsukukuCoord* self, gint level_of_gnode);
static void netsukuku_coord_impl_communicate_to_new_coordinator (NetsukukuCoord* self, gint level_of_gnode, GError** error);
static void* netsukuku_coord_helper_communicate_to_new_coordinator (void* v, GError** error);
static void netsukuku_coord_finalize (GObject* obj);
GType netsukuku_struct_helper_coordinator_manage_bnode_tunnels_get_type (void) G_GNUC_CONST;
Netsukukustruct_helper_Coordinator_manage_bnode_tunnels* netsukuku_struct_helper_coordinator_manage_bnode_tunnels_dup (const Netsukukustruct_helper_Coordinator_manage_bnode_tunnels* self);
void netsukuku_struct_helper_coordinator_manage_bnode_tunnels_free (Netsukukustruct_helper_Coordinator_manage_bnode_tunnels* self);
void netsukuku_struct_helper_coordinator_manage_bnode_tunnels_copy (const Netsukukustruct_helper_Coordinator_manage_bnode_tunnels* self, Netsukukustruct_helper_Coordinator_manage_bnode_tunnels* dest);
void netsukuku_struct_helper_coordinator_manage_bnode_tunnels_destroy (Netsukukustruct_helper_Coordinator_manage_bnode_tunnels* self);
GType netsukuku_struct_helper_coordinator_forward_knowledge_get_type (void) G_GNUC_CONST;
Netsukukustruct_helper_Coordinator_forward_knowledge* netsukuku_struct_helper_coordinator_forward_knowledge_dup (const Netsukukustruct_helper_Coordinator_forward_knowledge* self);
void netsukuku_struct_helper_coordinator_forward_knowledge_free (Netsukukustruct_helper_Coordinator_forward_knowledge* self);
void netsukuku_struct_helper_coordinator_forward_knowledge_copy (const Netsukukustruct_helper_Coordinator_forward_knowledge* self, Netsukukustruct_helper_Coordinator_forward_knowledge* dest);
void netsukuku_struct_helper_coordinator_forward_knowledge_destroy (Netsukukustruct_helper_Coordinator_forward_knowledge* self);
GType netsukuku_struct_helper_coordinator_forward_knowledge_to_nip_get_type (void) G_GNUC_CONST;
Netsukukustruct_helper_Coordinator_forward_knowledge_to_nip* netsukuku_struct_helper_coordinator_forward_knowledge_to_nip_dup (const Netsukukustruct_helper_Coordinator_forward_knowledge_to_nip* self);
void netsukuku_struct_helper_coordinator_forward_knowledge_to_nip_free (Netsukukustruct_helper_Coordinator_forward_knowledge_to_nip* self);
void netsukuku_struct_helper_coordinator_forward_knowledge_to_nip_copy (const Netsukukustruct_helper_Coordinator_forward_knowledge_to_nip* self, Netsukukustruct_helper_Coordinator_forward_knowledge_to_nip* dest);
void netsukuku_struct_helper_coordinator_forward_knowledge_to_nip_destroy (Netsukukustruct_helper_Coordinator_forward_knowledge_to_nip* self);
GType netsukuku_struct_helper_coordinator_forward_free_get_type (void) G_GNUC_CONST;
Netsukukustruct_helper_Coordinator_forward_free* netsukuku_struct_helper_coordinator_forward_free_dup (const Netsukukustruct_helper_Coordinator_forward_free* self);
void netsukuku_struct_helper_coordinator_forward_free_free (Netsukukustruct_helper_Coordinator_forward_free* self);
void netsukuku_struct_helper_coordinator_forward_free_copy (const Netsukukustruct_helper_Coordinator_forward_free* self, Netsukukustruct_helper_Coordinator_forward_free* dest);
void netsukuku_struct_helper_coordinator_forward_free_destroy (Netsukukustruct_helper_Coordinator_forward_free* self);
GType netsukuku_struct_helper_coordinator_forward_free_to_nip_get_type (void) G_GNUC_CONST;
Netsukukustruct_helper_Coordinator_forward_free_to_nip* netsukuku_struct_helper_coordinator_forward_free_to_nip_dup (const Netsukukustruct_helper_Coordinator_forward_free_to_nip* self);
void netsukuku_struct_helper_coordinator_forward_free_to_nip_free (Netsukukustruct_helper_Coordinator_forward_free_to_nip* self);
void netsukuku_struct_helper_coordinator_forward_free_to_nip_copy (const Netsukukustruct_helper_Coordinator_forward_free_to_nip* self, Netsukukustruct_helper_Coordinator_forward_free_to_nip* dest);
void netsukuku_struct_helper_coordinator_forward_free_to_nip_destroy (Netsukukustruct_helper_Coordinator_forward_free_to_nip* self);
#define NETSUKUKU_COORDINATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), NETSUKUKU_TYPE_COORDINATOR, NetsukukuCoordinatorPrivate))
enum  {
	NETSUKUKU_COORDINATOR_DUMMY_PROPERTY,
	NETSUKUKU_COORDINATOR_GNODE,
	NETSUKUKU_COORDINATOR_IS_MAIN,
	NETSUKUKU_COORDINATOR_WAS_MAIN
};
static void netsukuku_coordinator_set_gnode (NetsukukuCoordinator* self, NetsukukuPartialNIP* value);
void netsukuku_coordinator_manage_bnode_tunnels (NetsukukuCoordinator* self);
NetsukukuHCoord* netsukuku_peer_to_peer_search_participant (NetsukukuPeerToPeer* self, NetsukukuNIP* hIP, gint path_sign, GError** error);
gint* netsukuku_map_free_nodes_list (NetsukukuMap* self, gint lvl, int* result_length1);
gint netsukuku_map_get_gsize (NetsukukuMap* self);
gpointer netsukuku_map_node_get (NetsukukuMap* self, gint lvl, gint pos);
gboolean netsukuku_route_node_is_empty (NetsukukuRouteNode* self);
NetsukukuGNodeID* netsukuku_route_node_get_eldest_gid (NetsukukuRouteNode* self);
NetsukukuGNodeID** netsukuku_map_route_get_gid_list (NetsukukuMapRoute* self, int* result_length1);
static gint* _int_dup (gint* self);
NetsukukuGNodeID** netsukuku_map_route_get_gid_uppermost_list (NetsukukuMapRoute* self, gint level_of_gnode, int* result_length1);
void netsukuku_coordinator_forward_knowledge (NetsukukuCoordinator* self);
static NetsukukuGNodeID** _vala_array_dup2 (NetsukukuGNodeID** self, int length);
void netsukuku_coordinator_forward_free (NetsukukuCoordinator* self, gint pos);
static void netsukuku_coordinator_impl_forward_free (NetsukukuCoordinator* self, gint pos, GError** error);
GeeList* netsukuku_peer_to_peer_find_nearest_to_register (NetsukukuPeerToPeer* self, NetsukukuNIP* hash_nip, gint num_dupl, gint* inside_gnode_level, GError** error);
static void _vala_array_add3 (NetsukukuNIP*** array, int* length, int* size, NetsukukuNIP* value);
void netsukuku_coordinator_forward_free_to_nip (NetsukukuCoordinator* self, NetsukukuNIP* to_nip, gint pos);
static void* netsukuku_coordinator_helper_forward_free (void* v, GError** error);
static void netsukuku_coordinator_impl_forward_free_to_nip (NetsukukuCoordinator* self, NetsukukuNIP* to_nip, gint pos, GError** error);
gchar* netsukuku_nip_to_str (gint levels, gint gsize, NetsukukuNIP* nip);
void netsukuku_log_warn (const gchar* msg);
static void* netsukuku_coordinator_helper_forward_free_to_nip (void* v, GError** error);
void netsukuku_coordinator_add_record (NetsukukuCoordinator* self, NetsukukuBookingRecord* booking_record);
static void netsukuku_coordinator_impl_manage_bnode_tunnels (NetsukukuCoordinator* self, GError** error);
static gboolean _netsukuku_bnode_record_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self);
void netsukuku_coordinator_arrange_tunnel (NetsukukuCoordinator* self, GeeArrayList* candidates);
static void* netsukuku_coordinator_helper_manage_bnode_tunnels (void* v, GError** error);
static GType netsukuku_coordinator_pair_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static gboolean _netsukuku_partial_nip_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self);
static NetsukukuCoordinatorPair* netsukuku_coordinator_pair_new (GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GType b_type, GBoxedCopyFunc b_dup_func, GDestroyNotify b_destroy_func, gconstpointer a, gconstpointer b);
static NetsukukuCoordinatorPair* netsukuku_coordinator_pair_construct (GType object_type, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GType b_type, GBoxedCopyFunc b_dup_func, GDestroyNotify b_destroy_func, gconstpointer a, gconstpointer b);
static gint __lambda2_ (NetsukukuCoordinator* self, NetsukukuCoordinatorPair* a, NetsukukuCoordinatorPair* b);
static gconstpointer netsukuku_coordinator_pair_get_b (NetsukukuCoordinatorPair* self);
static gint ___lambda2__gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self);
static gconstpointer netsukuku_coordinator_pair_get_a (NetsukukuCoordinatorPair* self);
static void netsukuku_coordinator_impl_forward_knowledge (NetsukukuCoordinator* self, GError** error);
static void _vala_array_add4 (NetsukukuNIP*** array, int* length, int* size, NetsukukuNIP* value);
void netsukuku_coordinator_forward_knowledge_to_nip (NetsukukuCoordinator* self, NetsukukuNIP* nip);
static void* netsukuku_coordinator_helper_forward_knowledge (void* v, GError** error);
static void netsukuku_coordinator_impl_forward_knowledge_to_nip (NetsukukuCoordinator* self, NetsukukuNIP* to_nip, GError** error);
static void* netsukuku_coordinator_helper_forward_knowledge_to_nip (void* v, GError** error);
#define NETSUKUKU_COORDINATOR_PAIR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), NETSUKUKU_COORDINATOR_TYPE_PAIR, NetsukukuCoordinatorPairPrivate))
enum  {
	NETSUKUKU_COORDINATOR_PAIR_DUMMY_PROPERTY,
	NETSUKUKU_COORDINATOR_PAIR_A_TYPE,
	NETSUKUKU_COORDINATOR_PAIR_A_DUP_FUNC,
	NETSUKUKU_COORDINATOR_PAIR_A_DESTROY_FUNC,
	NETSUKUKU_COORDINATOR_PAIR_B_TYPE,
	NETSUKUKU_COORDINATOR_PAIR_B_DUP_FUNC,
	NETSUKUKU_COORDINATOR_PAIR_B_DESTROY_FUNC,
	NETSUKUKU_COORDINATOR_PAIR_A,
	NETSUKUKU_COORDINATOR_PAIR_B
};
static void netsukuku_coordinator_pair_set_a (NetsukukuCoordinatorPair* self, gconstpointer value);
static void netsukuku_coordinator_pair_set_b (NetsukukuCoordinatorPair* self, gconstpointer value);
static void netsukuku_coordinator_pair_finalize (GObject* obj);
static void _vala_netsukuku_coordinator_pair_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_netsukuku_coordinator_pair_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void netsukuku_coordinator_finalize (GObject* obj);
static void _vala_netsukuku_coordinator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_netsukuku_coordinator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


NetsukukuRmtCoordPeer* netsukuku_rmt_coord_peer_construct (GType object_type, NetsukukuPeerToPeer* peer_to_peer_service, GObject* key, NetsukukuNIP* hIP, NetsukukuAggregatedNeighbour* aggregated_neighbour) {
	NetsukukuRmtCoordPeer * self = NULL;
	NetsukukuPeerToPeer* _tmp0_;
	GObject* _tmp1_;
	NetsukukuNIP* _tmp2_;
	NetsukukuAggregatedNeighbour* _tmp3_;
	g_return_val_if_fail (peer_to_peer_service != NULL, NULL);
	_tmp0_ = peer_to_peer_service;
	_tmp1_ = key;
	_tmp2_ = hIP;
	_tmp3_ = aggregated_neighbour;
	self = (NetsukukuRmtCoordPeer*) netsukuku_rmt_peer_construct (object_type, _tmp0_, _tmp1_, _tmp2_, _tmp3_);
	return self;
}


NetsukukuRmtCoordPeer* netsukuku_rmt_coord_peer_new (NetsukukuPeerToPeer* peer_to_peer_service, GObject* key, NetsukukuNIP* hIP, NetsukukuAggregatedNeighbour* aggregated_neighbour) {
	return netsukuku_rmt_coord_peer_construct (NETSUKUKU_TYPE_RMT_COORD_PEER, peer_to_peer_service, key, hIP, aggregated_neighbour);
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static void netsukuku_rmt_coord_peer_real_duplicate_all_knowledge (NetsukukuICoord* base, NetsukukuPartialNIP* gnode, NetsukukuCoordinatorKnowledge* coordinator_knowledge, GError** error) {
	NetsukukuRmtCoordPeer * self;
	zcdRemoteCall* _tmp0_;
	zcdRemoteCall* rc;
	gchar* _tmp1_;
	NetsukukuPartialNIP* _tmp2_;
	NetsukukuCoordinatorKnowledge* _tmp3_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuRmtCoordPeer*) base;
	g_return_if_fail (gnode != NULL);
	g_return_if_fail (coordinator_knowledge != NULL);
	_tmp0_ = zcd_remote_call_new ();
	rc = _tmp0_;
	_tmp1_ = g_strdup ("duplicate_all_knowledge");
	_g_free0 (rc->method_name);
	rc->method_name = _tmp1_;
	_tmp2_ = gnode;
	zcd_remote_call_add_parameter (rc, (zcdISerializable*) _tmp2_);
	_tmp3_ = coordinator_knowledge;
	zcd_remote_call_add_parameter (rc, (zcdISerializable*) _tmp3_);
	{
		zcdISerializable* _tmp4_ = NULL;
		zcdISerializable* _tmp5_;
		_tmp4_ = netsukuku_rmt_peer_rmt ((NetsukukuRmtPeer*) self, rc, &_inner_error_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp5_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch25_zcd_rpc_error;
			}
			if (_inner_error_->domain == NETSUKUKU_HOOKING_ERROR) {
				goto __catch25_netsukuku_hooking_error;
			}
			goto __catch25_g_error;
		}
	}
	goto __finally25;
	__catch25_zcd_rpc_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		GError* _tmp7_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _g_error_copy0 (_tmp6_);
		_inner_error_ = _tmp7_;
		_g_error_free0 (e);
		goto __finally25;
	}
	goto __finally25;
	__catch25_netsukuku_hooking_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		GError* _tmp9_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _g_error_copy0 (_tmp8_);
		_inner_error_ = _tmp9_;
		_g_error_free0 (e);
		goto __finally25;
	}
	goto __finally25;
	__catch25_g_error:
	{
		GError* e = NULL;
		GError* _tmp10_;
		GQuark _tmp11_;
		const gchar* _tmp12_ = NULL;
		GError* _tmp13_;
		gint _tmp14_;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_;
		GError* _tmp17_;
		const gchar* _tmp18_;
		const gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_;
		GError* _tmp22_;
		GError* _tmp23_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp10_ = e;
		_tmp11_ = _tmp10_->domain;
		_tmp12_ = g_quark_to_string (_tmp11_);
		_tmp13_ = e;
		_tmp14_ = _tmp13_->code;
		_tmp15_ = g_strdup_printf ("%i", _tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = e;
		_tmp18_ = _tmp17_->message;
		_tmp19_ = string_to_string (_tmp18_);
		_tmp20_ = g_strconcat ("Unexpected error ", _tmp12_, ".", _tmp16_, " '", _tmp19_, "'", NULL);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_GENERIC, _tmp21_);
		_tmp23_ = _tmp22_;
		_g_free0 (_tmp21_);
		_g_free0 (_tmp16_);
		_inner_error_ = _tmp23_;
		_g_error_free0 (e);
		goto __finally25;
	}
	__finally25:
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == NETSUKUKU_HOOKING_ERROR) || (_inner_error_->domain == ZCD_RPC_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (rc);
			return;
		} else {
			_g_object_unref0 (rc);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_object_unref0 (rc);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static NetsukukuHookReservation* netsukuku_rmt_coord_peer_real_reserve (NetsukukuICoord* base, NetsukukuPartialNIP* gnode, GError** error) {
	NetsukukuRmtCoordPeer * self;
	NetsukukuHookReservation* result = NULL;
	zcdRemoteCall* _tmp0_;
	zcdRemoteCall* rc;
	zcdRemoteCall* _tmp1_;
	gchar* _tmp2_;
	zcdRemoteCall* _tmp3_;
	NetsukukuPartialNIP* _tmp4_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuRmtCoordPeer*) base;
	g_return_val_if_fail (gnode != NULL, NULL);
	_tmp0_ = zcd_remote_call_new ();
	rc = _tmp0_;
	_tmp1_ = rc;
	_tmp2_ = g_strdup ("reserve");
	_g_free0 (_tmp1_->method_name);
	_tmp1_->method_name = _tmp2_;
	_tmp3_ = rc;
	_tmp4_ = gnode;
	zcd_remote_call_add_parameter (_tmp3_, (zcdISerializable*) _tmp4_);
	{
		zcdRemoteCall* _tmp5_;
		zcdISerializable* _tmp6_ = NULL;
		zcdISerializable* ret;
		zcdISerializable* _tmp7_;
		GType _tmp8_ = 0UL;
		gboolean _tmp9_ = FALSE;
		_tmp5_ = rc;
		_tmp6_ = netsukuku_rmt_peer_rmt ((NetsukukuRmtPeer*) self, _tmp5_, &_inner_error_);
		ret = _tmp6_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch26_zcd_rpc_error;
			}
			if (_inner_error_->domain == NETSUKUKU_HOOKING_ERROR) {
				goto __catch26_netsukuku_hooking_error;
			}
			goto __catch26_g_error;
		}
		_tmp7_ = ret;
		_tmp8_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp7_);
		_tmp9_ = g_type_is_a (_tmp8_, ZCD_TYPE_SERIALIZABLE_NONE);
		if (_tmp9_) {
			result = NULL;
			_g_object_unref0 (ret);
			_g_object_unref0 (rc);
			return result;
		} else {
			zcdISerializable* _tmp10_;
			NetsukukuHookReservation* _tmp11_;
			_tmp10_ = ret;
			_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, NETSUKUKU_TYPE_HOOK_RESERVATION, NetsukukuHookReservation));
			result = _tmp11_;
			_g_object_unref0 (ret);
			_g_object_unref0 (rc);
			return result;
		}
		_g_object_unref0 (ret);
	}
	goto __finally26;
	__catch26_zcd_rpc_error:
	{
		GError* e = NULL;
		GError* _tmp12_;
		GError* _tmp13_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp12_ = e;
		_tmp13_ = _g_error_copy0 (_tmp12_);
		_inner_error_ = _tmp13_;
		_g_error_free0 (e);
		goto __finally26;
	}
	goto __finally26;
	__catch26_netsukuku_hooking_error:
	{
		GError* e = NULL;
		GError* _tmp14_;
		GError* _tmp15_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp14_ = e;
		_tmp15_ = _g_error_copy0 (_tmp14_);
		_inner_error_ = _tmp15_;
		_g_error_free0 (e);
		goto __finally26;
	}
	goto __finally26;
	__catch26_g_error:
	{
		GError* e = NULL;
		GError* _tmp16_;
		GQuark _tmp17_;
		const gchar* _tmp18_ = NULL;
		GError* _tmp19_;
		gint _tmp20_;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_;
		GError* _tmp23_;
		const gchar* _tmp24_;
		const gchar* _tmp25_ = NULL;
		gchar* _tmp26_ = NULL;
		gchar* _tmp27_;
		GError* _tmp28_;
		GError* _tmp29_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp16_ = e;
		_tmp17_ = _tmp16_->domain;
		_tmp18_ = g_quark_to_string (_tmp17_);
		_tmp19_ = e;
		_tmp20_ = _tmp19_->code;
		_tmp21_ = g_strdup_printf ("%i", _tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = e;
		_tmp24_ = _tmp23_->message;
		_tmp25_ = string_to_string (_tmp24_);
		_tmp26_ = g_strconcat ("Unexpected error ", _tmp18_, ".", _tmp22_, " '", _tmp25_, "'", NULL);
		_tmp27_ = _tmp26_;
		_tmp28_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_GENERIC, _tmp27_);
		_tmp29_ = _tmp28_;
		_g_free0 (_tmp27_);
		_g_free0 (_tmp22_);
		_inner_error_ = _tmp29_;
		_g_error_free0 (e);
		goto __finally26;
	}
	__finally26:
	if ((_inner_error_->domain == NETSUKUKU_HOOKING_ERROR) || (_inner_error_->domain == ZCD_RPC_ERROR)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (rc);
		return NULL;
	} else {
		_g_object_unref0 (rc);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_object_unref0 (rc);
}


static void netsukuku_rmt_coord_peer_real_free (NetsukukuICoord* base, NetsukukuPartialNIP* gnode, gint pos, GError** error) {
	NetsukukuRmtCoordPeer * self;
	zcdRemoteCall* _tmp0_;
	zcdRemoteCall* rc;
	gchar* _tmp1_;
	NetsukukuPartialNIP* _tmp2_;
	gint _tmp3_;
	zcdSerializableInt* _tmp4_;
	zcdSerializableInt* _tmp5_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuRmtCoordPeer*) base;
	g_return_if_fail (gnode != NULL);
	_tmp0_ = zcd_remote_call_new ();
	rc = _tmp0_;
	_tmp1_ = g_strdup ("free");
	_g_free0 (rc->method_name);
	rc->method_name = _tmp1_;
	_tmp2_ = gnode;
	zcd_remote_call_add_parameter (rc, (zcdISerializable*) _tmp2_);
	_tmp3_ = pos;
	_tmp4_ = zcd_serializable_int_new (_tmp3_);
	_tmp5_ = _tmp4_;
	zcd_remote_call_add_parameter (rc, (zcdISerializable*) _tmp5_);
	_g_object_unref0 (_tmp5_);
	{
		zcdISerializable* _tmp6_ = NULL;
		zcdISerializable* _tmp7_;
		_tmp6_ = netsukuku_rmt_peer_rmt ((NetsukukuRmtPeer*) self, rc, &_inner_error_);
		_tmp7_ = _tmp6_;
		_g_object_unref0 (_tmp7_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch27_zcd_rpc_error;
			}
			if (_inner_error_->domain == NETSUKUKU_HOOKING_ERROR) {
				goto __catch27_netsukuku_hooking_error;
			}
			goto __catch27_g_error;
		}
	}
	goto __finally27;
	__catch27_zcd_rpc_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		GError* _tmp9_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _g_error_copy0 (_tmp8_);
		_inner_error_ = _tmp9_;
		_g_error_free0 (e);
		goto __finally27;
	}
	goto __finally27;
	__catch27_netsukuku_hooking_error:
	{
		GError* e = NULL;
		GError* _tmp10_;
		GError* _tmp11_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp10_ = e;
		_tmp11_ = _g_error_copy0 (_tmp10_);
		_inner_error_ = _tmp11_;
		_g_error_free0 (e);
		goto __finally27;
	}
	goto __finally27;
	__catch27_g_error:
	{
		GError* e = NULL;
		GError* _tmp12_;
		GQuark _tmp13_;
		const gchar* _tmp14_ = NULL;
		GError* _tmp15_;
		gint _tmp16_;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_;
		GError* _tmp19_;
		const gchar* _tmp20_;
		const gchar* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		gchar* _tmp23_;
		GError* _tmp24_;
		GError* _tmp25_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp12_ = e;
		_tmp13_ = _tmp12_->domain;
		_tmp14_ = g_quark_to_string (_tmp13_);
		_tmp15_ = e;
		_tmp16_ = _tmp15_->code;
		_tmp17_ = g_strdup_printf ("%i", _tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = e;
		_tmp20_ = _tmp19_->message;
		_tmp21_ = string_to_string (_tmp20_);
		_tmp22_ = g_strconcat ("Unexpected error ", _tmp14_, ".", _tmp18_, " '", _tmp21_, "'", NULL);
		_tmp23_ = _tmp22_;
		_tmp24_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_GENERIC, _tmp23_);
		_tmp25_ = _tmp24_;
		_g_free0 (_tmp23_);
		_g_free0 (_tmp18_);
		_inner_error_ = _tmp25_;
		_g_error_free0 (e);
		goto __finally27;
	}
	__finally27:
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == NETSUKUKU_HOOKING_ERROR) || (_inner_error_->domain == ZCD_RPC_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (rc);
			return;
		} else {
			_g_object_unref0 (rc);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_object_unref0 (rc);
}


static void netsukuku_rmt_coord_peer_real_duplicate_free (NetsukukuICoord* base, NetsukukuPartialNIP* gnode, gint pos, GError** error) {
	NetsukukuRmtCoordPeer * self;
	zcdRemoteCall* _tmp0_;
	zcdRemoteCall* rc;
	gchar* _tmp1_;
	NetsukukuPartialNIP* _tmp2_;
	gint _tmp3_;
	zcdSerializableInt* _tmp4_;
	zcdSerializableInt* _tmp5_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuRmtCoordPeer*) base;
	g_return_if_fail (gnode != NULL);
	_tmp0_ = zcd_remote_call_new ();
	rc = _tmp0_;
	_tmp1_ = g_strdup ("duplicate_free");
	_g_free0 (rc->method_name);
	rc->method_name = _tmp1_;
	_tmp2_ = gnode;
	zcd_remote_call_add_parameter (rc, (zcdISerializable*) _tmp2_);
	_tmp3_ = pos;
	_tmp4_ = zcd_serializable_int_new (_tmp3_);
	_tmp5_ = _tmp4_;
	zcd_remote_call_add_parameter (rc, (zcdISerializable*) _tmp5_);
	_g_object_unref0 (_tmp5_);
	{
		zcdISerializable* _tmp6_ = NULL;
		zcdISerializable* _tmp7_;
		_tmp6_ = netsukuku_rmt_peer_rmt ((NetsukukuRmtPeer*) self, rc, &_inner_error_);
		_tmp7_ = _tmp6_;
		_g_object_unref0 (_tmp7_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch28_zcd_rpc_error;
			}
			if (_inner_error_->domain == NETSUKUKU_HOOKING_ERROR) {
				goto __catch28_netsukuku_hooking_error;
			}
			goto __catch28_g_error;
		}
	}
	goto __finally28;
	__catch28_zcd_rpc_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		GError* _tmp9_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _g_error_copy0 (_tmp8_);
		_inner_error_ = _tmp9_;
		_g_error_free0 (e);
		goto __finally28;
	}
	goto __finally28;
	__catch28_netsukuku_hooking_error:
	{
		GError* e = NULL;
		GError* _tmp10_;
		GError* _tmp11_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp10_ = e;
		_tmp11_ = _g_error_copy0 (_tmp10_);
		_inner_error_ = _tmp11_;
		_g_error_free0 (e);
		goto __finally28;
	}
	goto __finally28;
	__catch28_g_error:
	{
		GError* e = NULL;
		GError* _tmp12_;
		GQuark _tmp13_;
		const gchar* _tmp14_ = NULL;
		GError* _tmp15_;
		gint _tmp16_;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_;
		GError* _tmp19_;
		const gchar* _tmp20_;
		const gchar* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		gchar* _tmp23_;
		GError* _tmp24_;
		GError* _tmp25_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp12_ = e;
		_tmp13_ = _tmp12_->domain;
		_tmp14_ = g_quark_to_string (_tmp13_);
		_tmp15_ = e;
		_tmp16_ = _tmp15_->code;
		_tmp17_ = g_strdup_printf ("%i", _tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = e;
		_tmp20_ = _tmp19_->message;
		_tmp21_ = string_to_string (_tmp20_);
		_tmp22_ = g_strconcat ("Unexpected error ", _tmp14_, ".", _tmp18_, " '", _tmp21_, "'", NULL);
		_tmp23_ = _tmp22_;
		_tmp24_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_GENERIC, _tmp23_);
		_tmp25_ = _tmp24_;
		_g_free0 (_tmp23_);
		_g_free0 (_tmp18_);
		_inner_error_ = _tmp25_;
		_g_error_free0 (e);
		goto __finally28;
	}
	__finally28:
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == NETSUKUKU_HOOKING_ERROR) || (_inner_error_->domain == ZCD_RPC_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (rc);
			return;
		} else {
			_g_object_unref0 (rc);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_object_unref0 (rc);
}


static gboolean netsukuku_rmt_coord_peer_real_register_bnode (NetsukukuICoord* base, NetsukukuPartialNIP* gnode, NetsukukuNIP* nip, gboolean is_border, gboolean has_tunnel, gboolean is_willing, GError** error) {
	NetsukukuRmtCoordPeer * self;
	gboolean result = FALSE;
	zcdRemoteCall* _tmp0_;
	zcdRemoteCall* rc;
	zcdRemoteCall* _tmp1_;
	gchar* _tmp2_;
	zcdRemoteCall* _tmp3_;
	NetsukukuPartialNIP* _tmp4_;
	zcdRemoteCall* _tmp5_;
	NetsukukuNIP* _tmp6_;
	zcdRemoteCall* _tmp7_;
	gboolean _tmp8_;
	zcdSerializableBool* _tmp9_;
	zcdSerializableBool* _tmp10_;
	zcdRemoteCall* _tmp11_;
	gboolean _tmp12_;
	zcdSerializableBool* _tmp13_;
	zcdSerializableBool* _tmp14_;
	zcdRemoteCall* _tmp15_;
	gboolean _tmp16_;
	zcdSerializableBool* _tmp17_;
	zcdSerializableBool* _tmp18_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuRmtCoordPeer*) base;
	g_return_val_if_fail (gnode != NULL, FALSE);
	g_return_val_if_fail (nip != NULL, FALSE);
	_tmp0_ = zcd_remote_call_new ();
	rc = _tmp0_;
	_tmp1_ = rc;
	_tmp2_ = g_strdup ("register_bnode");
	_g_free0 (_tmp1_->method_name);
	_tmp1_->method_name = _tmp2_;
	_tmp3_ = rc;
	_tmp4_ = gnode;
	zcd_remote_call_add_parameter (_tmp3_, (zcdISerializable*) _tmp4_);
	_tmp5_ = rc;
	_tmp6_ = nip;
	zcd_remote_call_add_parameter (_tmp5_, (zcdISerializable*) _tmp6_);
	_tmp7_ = rc;
	_tmp8_ = is_border;
	_tmp9_ = zcd_serializable_bool_new (_tmp8_);
	_tmp10_ = _tmp9_;
	zcd_remote_call_add_parameter (_tmp7_, (zcdISerializable*) _tmp10_);
	_g_object_unref0 (_tmp10_);
	_tmp11_ = rc;
	_tmp12_ = has_tunnel;
	_tmp13_ = zcd_serializable_bool_new (_tmp12_);
	_tmp14_ = _tmp13_;
	zcd_remote_call_add_parameter (_tmp11_, (zcdISerializable*) _tmp14_);
	_g_object_unref0 (_tmp14_);
	_tmp15_ = rc;
	_tmp16_ = is_willing;
	_tmp17_ = zcd_serializable_bool_new (_tmp16_);
	_tmp18_ = _tmp17_;
	zcd_remote_call_add_parameter (_tmp15_, (zcdISerializable*) _tmp18_);
	_g_object_unref0 (_tmp18_);
	{
		zcdRemoteCall* _tmp19_;
		zcdISerializable* _tmp20_ = NULL;
		zcdISerializable* _tmp21_;
		zcdSerializableBool* ret;
		zcdSerializableBool* _tmp22_;
		gboolean _tmp23_;
		gboolean _tmp24_;
		_tmp19_ = rc;
		_tmp20_ = netsukuku_rmt_peer_rmt ((NetsukukuRmtPeer*) self, _tmp19_, &_inner_error_);
		_tmp21_ = _tmp20_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch29_zcd_rpc_error;
			}
			if (_inner_error_->domain == NETSUKUKU_HOOKING_ERROR) {
				goto __catch29_netsukuku_hooking_error;
			}
			goto __catch29_g_error;
		}
		ret = G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, ZCD_TYPE_SERIALIZABLE_BOOL, zcdSerializableBool);
		_tmp22_ = ret;
		_tmp23_ = zcd_serializable_bool_get_b (_tmp22_);
		_tmp24_ = _tmp23_;
		result = _tmp24_;
		_g_object_unref0 (ret);
		_g_object_unref0 (rc);
		return result;
	}
	goto __finally29;
	__catch29_zcd_rpc_error:
	{
		GError* e = NULL;
		GError* _tmp25_;
		GError* _tmp26_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp25_ = e;
		_tmp26_ = _g_error_copy0 (_tmp25_);
		_inner_error_ = _tmp26_;
		_g_error_free0 (e);
		goto __finally29;
	}
	goto __finally29;
	__catch29_netsukuku_hooking_error:
	{
		GError* e = NULL;
		GError* _tmp27_;
		GError* _tmp28_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp27_ = e;
		_tmp28_ = _g_error_copy0 (_tmp27_);
		_inner_error_ = _tmp28_;
		_g_error_free0 (e);
		goto __finally29;
	}
	goto __finally29;
	__catch29_g_error:
	{
		GError* e = NULL;
		GError* _tmp29_;
		GQuark _tmp30_;
		const gchar* _tmp31_ = NULL;
		GError* _tmp32_;
		gint _tmp33_;
		gchar* _tmp34_ = NULL;
		gchar* _tmp35_;
		GError* _tmp36_;
		const gchar* _tmp37_;
		const gchar* _tmp38_ = NULL;
		gchar* _tmp39_ = NULL;
		gchar* _tmp40_;
		GError* _tmp41_;
		GError* _tmp42_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp29_ = e;
		_tmp30_ = _tmp29_->domain;
		_tmp31_ = g_quark_to_string (_tmp30_);
		_tmp32_ = e;
		_tmp33_ = _tmp32_->code;
		_tmp34_ = g_strdup_printf ("%i", _tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = e;
		_tmp37_ = _tmp36_->message;
		_tmp38_ = string_to_string (_tmp37_);
		_tmp39_ = g_strconcat ("Unexpected error ", _tmp31_, ".", _tmp35_, " '", _tmp38_, "'", NULL);
		_tmp40_ = _tmp39_;
		_tmp41_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_GENERIC, _tmp40_);
		_tmp42_ = _tmp41_;
		_g_free0 (_tmp40_);
		_g_free0 (_tmp35_);
		_inner_error_ = _tmp42_;
		_g_error_free0 (e);
		goto __finally29;
	}
	__finally29:
	if ((_inner_error_->domain == NETSUKUKU_HOOKING_ERROR) || (_inner_error_->domain == ZCD_RPC_ERROR)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (rc);
		return FALSE;
	} else {
		_g_object_unref0 (rc);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_g_object_unref0 (rc);
}


static GeeList* netsukuku_rmt_coord_peer_real_report_status (NetsukukuICoord* base, GError** error) {
	NetsukukuRmtCoordPeer * self;
	GeeList* result = NULL;
	zcdRemoteCall* _tmp0_;
	zcdRemoteCall* rc;
	gchar* _tmp1_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuRmtCoordPeer*) base;
	_tmp0_ = zcd_remote_call_new ();
	rc = _tmp0_;
	_tmp1_ = g_strdup ("report_status");
	_g_free0 (rc->method_name);
	rc->method_name = _tmp1_;
	{
		zcdISerializable* _tmp2_ = NULL;
		zcdISerializable* _tmp3_;
		zcdListISerializable* ret;
		zcdListISerializable* _tmp4_;
		GeeList* _tmp5_;
		GeeList* _tmp6_;
		_tmp2_ = netsukuku_rmt_peer_rmt ((NetsukukuRmtPeer*) self, rc, &_inner_error_);
		_tmp3_ = _tmp2_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch30_zcd_rpc_error;
			}
			goto __catch30_g_error;
		}
		ret = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, ZCD_TYPE_LIST_ISERIALIZABLE, zcdListISerializable);
		_tmp4_ = ret;
		_tmp5_ = _tmp4_->backed;
		_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_LIST, GeeList));
		result = _tmp6_;
		_g_object_unref0 (ret);
		_g_object_unref0 (rc);
		return result;
	}
	goto __finally30;
	__catch30_zcd_rpc_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		GError* _tmp8_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _g_error_copy0 (_tmp7_);
		_inner_error_ = _tmp8_;
		_g_error_free0 (e);
		goto __finally30;
	}
	goto __finally30;
	__catch30_g_error:
	{
		GError* e = NULL;
		GError* _tmp9_;
		GQuark _tmp10_;
		const gchar* _tmp11_ = NULL;
		GError* _tmp12_;
		gint _tmp13_;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_;
		GError* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_;
		GError* _tmp21_;
		GError* _tmp22_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->domain;
		_tmp11_ = g_quark_to_string (_tmp10_);
		_tmp12_ = e;
		_tmp13_ = _tmp12_->code;
		_tmp14_ = g_strdup_printf ("%i", _tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = e;
		_tmp17_ = _tmp16_->message;
		_tmp18_ = string_to_string (_tmp17_);
		_tmp19_ = g_strconcat ("Unexpected error ", _tmp11_, ".", _tmp15_, " '", _tmp18_, "'", NULL);
		_tmp20_ = _tmp19_;
		_tmp21_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_GENERIC, _tmp20_);
		_tmp22_ = _tmp21_;
		_g_free0 (_tmp20_);
		_g_free0 (_tmp15_);
		_inner_error_ = _tmp22_;
		_g_error_free0 (e);
		goto __finally30;
	}
	__finally30:
	if (_inner_error_->domain == ZCD_RPC_ERROR) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (rc);
		return NULL;
	} else {
		_g_object_unref0 (rc);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_object_unref0 (rc);
}


static void netsukuku_rmt_coord_peer_class_init (NetsukukuRmtCoordPeerClass * klass) {
	netsukuku_rmt_coord_peer_parent_class = g_type_class_peek_parent (klass);
}


static void netsukuku_rmt_coord_peer_netsukuku_icoord_interface_init (NetsukukuICoordIface * iface) {
	netsukuku_rmt_coord_peer_netsukuku_icoord_parent_iface = g_type_interface_peek_parent (iface);
	iface->duplicate_all_knowledge = (void (*)(NetsukukuICoord*, NetsukukuPartialNIP*, NetsukukuCoordinatorKnowledge*, GError**)) netsukuku_rmt_coord_peer_real_duplicate_all_knowledge;
	iface->reserve = (NetsukukuHookReservation* (*)(NetsukukuICoord*, NetsukukuPartialNIP*, GError**)) netsukuku_rmt_coord_peer_real_reserve;
	iface->free = (void (*)(NetsukukuICoord*, NetsukukuPartialNIP*, gint, GError**)) netsukuku_rmt_coord_peer_real_free;
	iface->duplicate_free = (void (*)(NetsukukuICoord*, NetsukukuPartialNIP*, gint, GError**)) netsukuku_rmt_coord_peer_real_duplicate_free;
	iface->register_bnode = (gboolean (*)(NetsukukuICoord*, NetsukukuPartialNIP*, NetsukukuNIP*, gboolean, gboolean, gboolean, GError**)) netsukuku_rmt_coord_peer_real_register_bnode;
	iface->report_status = (GeeList* (*)(NetsukukuICoord*, GError**)) netsukuku_rmt_coord_peer_real_report_status;
}


static void netsukuku_rmt_coord_peer_instance_init (NetsukukuRmtCoordPeer * self) {
}


GType netsukuku_rmt_coord_peer_get_type (void) {
	static volatile gsize netsukuku_rmt_coord_peer_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_rmt_coord_peer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuRmtCoordPeerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_rmt_coord_peer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuRmtCoordPeer), 0, (GInstanceInitFunc) netsukuku_rmt_coord_peer_instance_init, NULL };
		static const GInterfaceInfo netsukuku_icoord_info = { (GInterfaceInitFunc) netsukuku_rmt_coord_peer_netsukuku_icoord_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType netsukuku_rmt_coord_peer_type_id;
		netsukuku_rmt_coord_peer_type_id = g_type_register_static (NETSUKUKU_TYPE_RMT_PEER, "NetsukukuRmtCoordPeer", &g_define_type_info, 0);
		g_type_add_interface_static (netsukuku_rmt_coord_peer_type_id, NETSUKUKU_TYPE_ICOORD, &netsukuku_icoord_info);
		g_once_init_leave (&netsukuku_rmt_coord_peer_type_id__volatile, netsukuku_rmt_coord_peer_type_id);
	}
	return netsukuku_rmt_coord_peer_type_id__volatile;
}


NetsukukuCoord_hkey* netsukuku_coord_hkey_construct (GType object_type) {
	NetsukukuCoord_hkey * self = NULL;
	self = (NetsukukuCoord_hkey*) g_object_new (object_type, NULL);
	return self;
}


NetsukukuCoord_hkey* netsukuku_coord_hkey_new (void) {
	return netsukuku_coord_hkey_construct (NETSUKUKU_TYPE_COORD_HKEY);
}


static void netsukuku_coord_hkey_class_init (NetsukukuCoord_hkeyClass * klass) {
	netsukuku_coord_hkey_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = netsukuku_coord_hkey_finalize;
}


static void netsukuku_coord_hkey_instance_init (NetsukukuCoord_hkey * self) {
}


static void netsukuku_coord_hkey_finalize (GObject* obj) {
	NetsukukuCoord_hkey * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_COORD_HKEY, NetsukukuCoord_hkey);
	_g_object_unref0 (self->nip);
	G_OBJECT_CLASS (netsukuku_coord_hkey_parent_class)->finalize (obj);
}


GType netsukuku_coord_hkey_get_type (void) {
	static volatile gsize netsukuku_coord_hkey_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_coord_hkey_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuCoord_hkeyClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_coord_hkey_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuCoord_hkey), 0, (GInstanceInitFunc) netsukuku_coord_hkey_instance_init, NULL };
		GType netsukuku_coord_hkey_type_id;
		netsukuku_coord_hkey_type_id = g_type_register_static (G_TYPE_OBJECT, "NetsukukuCoord_hkey", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_coord_hkey_type_id__volatile, netsukuku_coord_hkey_type_id);
	}
	return netsukuku_coord_hkey_type_id__volatile;
}


void netsukuku_struct_helper_coord_communicate_to_new_coordinator_copy (const Netsukukustruct_helper_Coord_communicate_to_new_coordinator* self, Netsukukustruct_helper_Coord_communicate_to_new_coordinator* dest) {
	NetsukukuCoord* _tmp0_;
	NetsukukuCoord* _tmp1_;
	gint _tmp2_;
	_tmp0_ = (*self).self;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 ((*dest).self);
	(*dest).self = _tmp1_;
	_tmp2_ = (*self).level_of_gnode;
	(*dest).level_of_gnode = _tmp2_;
}


void netsukuku_struct_helper_coord_communicate_to_new_coordinator_destroy (Netsukukustruct_helper_Coord_communicate_to_new_coordinator* self) {
	_g_object_unref0 ((*self).self);
}


Netsukukustruct_helper_Coord_communicate_to_new_coordinator* netsukuku_struct_helper_coord_communicate_to_new_coordinator_dup (const Netsukukustruct_helper_Coord_communicate_to_new_coordinator* self) {
	Netsukukustruct_helper_Coord_communicate_to_new_coordinator* dup;
	dup = g_new0 (Netsukukustruct_helper_Coord_communicate_to_new_coordinator, 1);
	netsukuku_struct_helper_coord_communicate_to_new_coordinator_copy (self, dup);
	return dup;
}


void netsukuku_struct_helper_coord_communicate_to_new_coordinator_free (Netsukukustruct_helper_Coord_communicate_to_new_coordinator* self) {
	netsukuku_struct_helper_coord_communicate_to_new_coordinator_destroy (self);
	g_free (self);
}


GType netsukuku_struct_helper_coord_communicate_to_new_coordinator_get_type (void) {
	static volatile gsize netsukuku_struct_helper_coord_communicate_to_new_coordinator_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_struct_helper_coord_communicate_to_new_coordinator_type_id__volatile)) {
		GType netsukuku_struct_helper_coord_communicate_to_new_coordinator_type_id;
		netsukuku_struct_helper_coord_communicate_to_new_coordinator_type_id = g_boxed_type_register_static ("Netsukukustruct_helper_Coord_communicate_to_new_coordinator", (GBoxedCopyFunc) netsukuku_struct_helper_coord_communicate_to_new_coordinator_dup, (GBoxedFreeFunc) netsukuku_struct_helper_coord_communicate_to_new_coordinator_free);
		g_once_init_leave (&netsukuku_struct_helper_coord_communicate_to_new_coordinator_type_id__volatile, netsukuku_struct_helper_coord_communicate_to_new_coordinator_type_id);
	}
	return netsukuku_struct_helper_coord_communicate_to_new_coordinator_type_id__volatile;
}


static void _netsukuku_coord_node_joins_maproute_netsukuku_map_node_new (NetsukukuMap* _sender, gint lvl, gint pos, gpointer self) {
	netsukuku_coord_node_joins_maproute (self, lvl, pos);
}


static void _netsukuku_coord_node_exits_maproute_netsukuku_map_node_deleted (NetsukukuMap* _sender, gint lvl, gint pos, gpointer self) {
	netsukuku_coord_node_exits_maproute (self, lvl, pos);
}


static void _netsukuku_coord_coord_has_valid_map_netsukuku_peer_to_peer_map_peer_to_peer_validated (NetsukukuPeerToPeer* _sender, gpointer self) {
	netsukuku_coord_coord_has_valid_map (self);
}


NetsukukuCoord* netsukuku_coord_construct (GType object_type, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, NetsukukuPeerToPeerAll* peer_to_peer_all, NetsukukuCoordinatorKnowledgeSet* coordinator_knowledge_set) {
	NetsukukuCoord * self = NULL;
	NetsukukuAggregatedNeighbourManager* _tmp0_;
	NetsukukuMapRoute* _tmp1_;
	NetsukukuMapRoute* _tmp40_;
	NetsukukuMapRoute* _tmp41_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (aggregated_neighbour_manager != NULL, NULL);
	g_return_val_if_fail (maproute != NULL, NULL);
	g_return_val_if_fail (peer_to_peer_all != NULL, NULL);
	g_return_val_if_fail (coordinator_knowledge_set != NULL, NULL);
	_tmp0_ = aggregated_neighbour_manager;
	_tmp1_ = maproute;
	self = (NetsukukuCoord*) netsukuku_peer_to_peer_construct (object_type, _tmp0_, _tmp1_, NETSUKUKU_COORD_mypid);
	{
		NetsukukuPeerToPeerAll* _tmp2_;
		_tmp2_ = peer_to_peer_all;
		netsukuku_peer_to_peer_all_peer_to_peer_register (_tmp2_, (NetsukukuPeerToPeer*) self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == NETSUKUKU_PEER_TO_PEER_ERROR) {
				goto __catch31_netsukuku_peer_to_peer_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	goto __finally31;
	__catch31_netsukuku_peer_to_peer_error:
	{
		GError* e = NULL;
		const gchar* _tmp3_;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e->message;
		_tmp4_ = string_to_string (_tmp3_);
		_tmp5_ = g_strconcat ("Coord service: registering failed: ", _tmp4_, NULL);
		_tmp6_ = _tmp5_;
		g_error ("coord.vala:167: %s", _tmp6_);
		_g_free0 (_tmp6_);
		_g_error_free0 (e);
	}
	__finally31:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	netsukuku_coord_initialize_coordinators (self);
	{
		gint level_of_gnode;
		level_of_gnode = 1;
		{
			gboolean _tmp7_;
			_tmp7_ = TRUE;
			while (TRUE) {
				gboolean _tmp8_;
				gint _tmp10_;
				NetsukukuMapRoute* _tmp11_;
				gint _tmp12_;
				gint _tmp13_;
				gint _tmp14_;
				NetsukukuCoordinator* _tmp15_ = NULL;
				NetsukukuCoordinator* coordinator;
				NetsukukuCoordinatorKnowledgeSet* _tmp16_;
				GeeHashMap* _tmp17_;
				NetsukukuCoordinator* _tmp18_;
				NetsukukuPartialNIP* _tmp19_;
				NetsukukuPartialNIP* _tmp20_;
				gboolean _tmp21_ = FALSE;
				_tmp8_ = _tmp7_;
				if (!_tmp8_) {
					gint _tmp9_;
					_tmp9_ = level_of_gnode;
					level_of_gnode = _tmp9_ + 1;
				}
				_tmp7_ = FALSE;
				_tmp10_ = level_of_gnode;
				_tmp11_ = maproute;
				_tmp12_ = netsukuku_map_get_levels ((NetsukukuMap*) _tmp11_);
				_tmp13_ = _tmp12_;
				if (!(_tmp10_ < (_tmp13_ + 1))) {
					break;
				}
				_tmp14_ = level_of_gnode;
				_tmp15_ = netsukuku_coord_get_coordinator_for_gnode_at_level (self, _tmp14_);
				coordinator = _tmp15_;
				_tmp16_ = coordinator_knowledge_set;
				_tmp17_ = _tmp16_->dict;
				_tmp18_ = coordinator;
				_tmp19_ = netsukuku_coordinator_get_gnode (_tmp18_);
				_tmp20_ = _tmp19_;
				_tmp21_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp17_, _tmp20_);
				if (_tmp21_) {
					NetsukukuCoordinatorKnowledgeSet* _tmp22_;
					GeeHashMap* _tmp23_;
					NetsukukuCoordinator* _tmp24_;
					NetsukukuPartialNIP* _tmp25_;
					NetsukukuPartialNIP* _tmp26_;
					gpointer _tmp27_ = NULL;
					NetsukukuCoordinatorKnowledge* coordinator_knowledge;
					NetsukukuCoordinator* _tmp28_;
					NetsukukuCoordinatorKnowledge* _tmp29_;
					NetsukukuBookings* _tmp30_;
					NetsukukuBookings* _tmp31_;
					NetsukukuCoordinator* _tmp32_;
					NetsukukuCoordinatorKnowledge* _tmp33_;
					gint _tmp34_;
					gint _tmp35_;
					NetsukukuCoordinator* _tmp36_;
					NetsukukuCoordinatorKnowledge* _tmp37_;
					NetsukukuBnodeList* _tmp38_;
					NetsukukuBnodeList* _tmp39_;
					_tmp22_ = coordinator_knowledge_set;
					_tmp23_ = _tmp22_->dict;
					_tmp24_ = coordinator;
					_tmp25_ = netsukuku_coordinator_get_gnode (_tmp24_);
					_tmp26_ = _tmp25_;
					_tmp27_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp23_, _tmp26_);
					coordinator_knowledge = (NetsukukuCoordinatorKnowledge*) _tmp27_;
					_tmp28_ = coordinator;
					_tmp29_ = coordinator_knowledge;
					_tmp30_ = netsukuku_coordinator_knowledge_get_bookings (_tmp29_);
					_tmp31_ = _tmp30_;
					netsukuku_coordinator_add_bookings (_tmp28_, _tmp31_);
					_tmp32_ = coordinator;
					_tmp33_ = coordinator_knowledge;
					_tmp34_ = netsukuku_coordinator_knowledge_get_last_assigned_elderliness (_tmp33_);
					_tmp35_ = _tmp34_;
					_tmp32_->last_assigned_elderliness = _tmp35_;
					_tmp36_ = coordinator;
					_tmp37_ = coordinator_knowledge;
					_tmp38_ = netsukuku_coordinator_knowledge_get_bnode_list (_tmp37_);
					_tmp39_ = _tmp38_;
					netsukuku_coordinator_add_bnode_list (_tmp36_, _tmp39_);
					_g_object_unref0 (coordinator_knowledge);
				}
				_g_object_unref0 (coordinator);
			}
		}
	}
	_tmp40_ = maproute;
	g_signal_connect_object ((NetsukukuMap*) _tmp40_, "node-new", (GCallback) _netsukuku_coord_node_joins_maproute_netsukuku_map_node_new, self, 0);
	_tmp41_ = maproute;
	g_signal_connect_object ((NetsukukuMap*) _tmp41_, "node-deleted", (GCallback) _netsukuku_coord_node_exits_maproute_netsukuku_map_node_deleted, self, 0);
	g_signal_connect_object ((NetsukukuPeerToPeer*) self, "map-peer-to-peer-validated", (GCallback) _netsukuku_coord_coord_has_valid_map_netsukuku_peer_to_peer_map_peer_to_peer_validated, self, 0);
	return self;
}


NetsukukuCoord* netsukuku_coord_new (NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, NetsukukuPeerToPeerAll* peer_to_peer_all, NetsukukuCoordinatorKnowledgeSet* coordinator_knowledge_set) {
	return netsukuku_coord_construct (NETSUKUKU_TYPE_COORD, aggregated_neighbour_manager, maproute, peer_to_peer_all, coordinator_knowledge_set);
}


NetsukukuRmtCoordPeer* netsukuku_coord_peer (NetsukukuCoord* self, NetsukukuNIP* hIP, GObject* key, NetsukukuAggregatedNeighbour* aggregated_neighbour) {
	NetsukukuRmtCoordPeer* result = NULL;
	gboolean _tmp0_ = FALSE;
	NetsukukuNIP* _tmp1_;
	gboolean _tmp3_;
	GObject* _tmp4_;
	NetsukukuNIP* _tmp5_;
	NetsukukuAggregatedNeighbour* _tmp6_;
	NetsukukuRmtCoordPeer* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = hIP;
	if (_tmp1_ != NULL) {
		_tmp0_ = TRUE;
	} else {
		GObject* _tmp2_;
		_tmp2_ = key;
		_tmp0_ = _tmp2_ != NULL;
	}
	_tmp3_ = _tmp0_;
	_vala_assert (_tmp3_, "hIP != null || key != null");
	_tmp4_ = key;
	_tmp5_ = hIP;
	_tmp6_ = aggregated_neighbour;
	_tmp7_ = netsukuku_rmt_coord_peer_new ((NetsukukuPeerToPeer*) self, _tmp4_, _tmp5_, _tmp6_);
	result = _tmp7_;
	return result;
}


/** This method could be called *directly* for a dispatcher that does not need to transform
          * an exception into a remotable.
          */
static zcdISerializable* netsukuku_coord_real__dispatch (zcdRPCDispatcher* base, GObject* caller, zcdRemoteCall* data, GError** error) {
	NetsukukuCoord * self;
	zcdISerializable* result = NULL;
	zcdRemoteCall* _tmp0_;
	const gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_ = NULL;
	gchar** pieces;
	gint pieces_length1;
	gint _pieces_size_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	const gchar* _tmp5_;
	gchar** _tmp37_;
	gint _tmp37__length1;
	const gchar* _tmp38_;
	gchar** _tmp63_;
	gint _tmp63__length1;
	const gchar* _tmp64_;
	gchar** _tmp98_;
	gint _tmp98__length1;
	const gchar* _tmp99_;
	gchar** _tmp133_;
	gint _tmp133__length1;
	const gchar* _tmp134_;
	gchar** _tmp207_;
	gint _tmp207__length1;
	const gchar* _tmp208_;
	GObject* _tmp222_;
	zcdRemoteCall* _tmp223_;
	zcdISerializable* _tmp224_ = NULL;
	zcdISerializable* _tmp225_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuCoord*) base;
	g_return_val_if_fail (data != NULL, NULL);
	_tmp0_ = data;
	_tmp1_ = _tmp0_->method_name;
	_tmp3_ = _tmp2_ = g_strsplit (_tmp1_, ".", 0);
	pieces = _tmp3_;
	pieces_length1 = _vala_array_length (_tmp2_);
	_pieces_size_ = pieces_length1;
	_tmp4_ = pieces;
	_tmp4__length1 = pieces_length1;
	_tmp5_ = _tmp4_[0];
	if (g_strcmp0 (_tmp5_, "duplicate_all_knowledge") == 0) {
		gchar** _tmp6_;
		gint _tmp6__length1;
		zcdRemoteCall* _tmp8_;
		GeeList* _tmp9_;
		GeeList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		zcdRemoteCall* _tmp14_;
		GeeList* _tmp15_;
		GeeList* _tmp16_;
		gpointer _tmp17_ = NULL;
		zcdISerializable* iser0;
		zcdRemoteCall* _tmp18_;
		GeeList* _tmp19_;
		GeeList* _tmp20_;
		gpointer _tmp21_ = NULL;
		zcdISerializable* iser1;
		zcdISerializable* _tmp22_;
		GType _tmp23_ = 0UL;
		gboolean _tmp24_ = FALSE;
		zcdISerializable* _tmp26_;
		GType _tmp27_ = 0UL;
		gboolean _tmp28_ = FALSE;
		zcdISerializable* _tmp30_;
		NetsukukuPartialNIP* _tmp31_;
		NetsukukuPartialNIP* gnode;
		zcdISerializable* _tmp32_;
		NetsukukuCoordinatorKnowledge* _tmp33_;
		NetsukukuCoordinatorKnowledge* coordinator_knowledge;
		NetsukukuPartialNIP* _tmp34_;
		NetsukukuCoordinatorKnowledge* _tmp35_;
		zcdSerializableNone* _tmp36_;
		_tmp6_ = pieces;
		_tmp6__length1 = pieces_length1;
		if (_tmp6__length1 != 1) {
			GError* _tmp7_;
			_tmp7_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "duplicate_all_knowledge is a function.");
			_inner_error_ = _tmp7_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp8_ = data;
		_tmp9_ = zcd_remote_call_get_parameters (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = gee_collection_get_size ((GeeCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		if (_tmp12_ != 2) {
			GError* _tmp13_;
			_tmp13_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "duplicate_all_knowledge wants 2 parameters.");
			_inner_error_ = _tmp13_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp14_ = data;
		_tmp15_ = zcd_remote_call_get_parameters (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = gee_list_get (_tmp16_, 0);
		iser0 = (zcdISerializable*) _tmp17_;
		_tmp18_ = data;
		_tmp19_ = zcd_remote_call_get_parameters (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = gee_list_get (_tmp20_, 1);
		iser1 = (zcdISerializable*) _tmp21_;
		_tmp22_ = iser0;
		_tmp23_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp22_);
		_tmp24_ = g_type_is_a (_tmp23_, NETSUKUKU_TYPE_PARTIAL_NIP);
		if (!_tmp24_) {
			GError* _tmp25_;
			_tmp25_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "duplicate_all_knowledge parameter 1 is not a PartialNIP.");
			_inner_error_ = _tmp25_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser1);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp26_ = iser1;
		_tmp27_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp26_);
		_tmp28_ = g_type_is_a (_tmp27_, NETSUKUKU_TYPE_COORDINATOR_KNOWLEDGE);
		if (!_tmp28_) {
			GError* _tmp29_;
			_tmp29_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "duplicate_all_knowledge parameter 2 is not a CoordinatorKnowledge.");
			_inner_error_ = _tmp29_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser1);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp30_ = iser0;
		_tmp31_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, NETSUKUKU_TYPE_PARTIAL_NIP, NetsukukuPartialNIP));
		gnode = _tmp31_;
		_tmp32_ = iser1;
		_tmp33_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, NETSUKUKU_TYPE_COORDINATOR_KNOWLEDGE, NetsukukuCoordinatorKnowledge));
		coordinator_knowledge = _tmp33_;
		_tmp34_ = gnode;
		_tmp35_ = coordinator_knowledge;
		netsukuku_icoord_duplicate_all_knowledge ((NetsukukuICoord*) self, _tmp34_, _tmp35_, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (coordinator_knowledge);
			_g_object_unref0 (gnode);
			_g_object_unref0 (iser1);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp36_ = zcd_serializable_none_new ();
		result = (zcdISerializable*) _tmp36_;
		_g_object_unref0 (coordinator_knowledge);
		_g_object_unref0 (gnode);
		_g_object_unref0 (iser1);
		_g_object_unref0 (iser0);
		pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp37_ = pieces;
	_tmp37__length1 = pieces_length1;
	_tmp38_ = _tmp37_[0];
	if (g_strcmp0 (_tmp38_, "reserve") == 0) {
		gchar** _tmp39_;
		gint _tmp39__length1;
		zcdRemoteCall* _tmp41_;
		GeeList* _tmp42_;
		GeeList* _tmp43_;
		gint _tmp44_;
		gint _tmp45_;
		zcdRemoteCall* _tmp47_;
		GeeList* _tmp48_;
		GeeList* _tmp49_;
		gpointer _tmp50_ = NULL;
		zcdISerializable* iser0;
		zcdISerializable* _tmp51_;
		GType _tmp52_ = 0UL;
		gboolean _tmp53_ = FALSE;
		zcdISerializable* _tmp55_;
		NetsukukuPartialNIP* _tmp56_;
		NetsukukuPartialNIP* gnode;
		NetsukukuPartialNIP* _tmp57_;
		NetsukukuHookReservation* _tmp58_ = NULL;
		NetsukukuHookReservation* ret;
		NetsukukuHookReservation* _tmp59_;
		_tmp39_ = pieces;
		_tmp39__length1 = pieces_length1;
		if (_tmp39__length1 != 1) {
			GError* _tmp40_;
			_tmp40_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "reserve is a function.");
			_inner_error_ = _tmp40_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp41_ = data;
		_tmp42_ = zcd_remote_call_get_parameters (_tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = gee_collection_get_size ((GeeCollection*) _tmp43_);
		_tmp45_ = _tmp44_;
		if (_tmp45_ != 1) {
			GError* _tmp46_;
			_tmp46_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "reserve wants 1 parameters.");
			_inner_error_ = _tmp46_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp47_ = data;
		_tmp48_ = zcd_remote_call_get_parameters (_tmp47_);
		_tmp49_ = _tmp48_;
		_tmp50_ = gee_list_get (_tmp49_, 0);
		iser0 = (zcdISerializable*) _tmp50_;
		_tmp51_ = iser0;
		_tmp52_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp51_);
		_tmp53_ = g_type_is_a (_tmp52_, NETSUKUKU_TYPE_PARTIAL_NIP);
		if (!_tmp53_) {
			GError* _tmp54_;
			_tmp54_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "reserve parameter 1 is not a PartialNIP.");
			_inner_error_ = _tmp54_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp55_ = iser0;
		_tmp56_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp55_, NETSUKUKU_TYPE_PARTIAL_NIP, NetsukukuPartialNIP));
		gnode = _tmp56_;
		_tmp57_ = gnode;
		_tmp58_ = netsukuku_icoord_reserve ((NetsukukuICoord*) self, _tmp57_, &_inner_error_);
		ret = _tmp58_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (gnode);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp59_ = ret;
		if (_tmp59_ == NULL) {
			zcdSerializableNone* _tmp60_;
			_tmp60_ = zcd_serializable_none_new ();
			result = (zcdISerializable*) _tmp60_;
			_g_object_unref0 (ret);
			_g_object_unref0 (gnode);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return result;
		} else {
			NetsukukuHookReservation* _tmp61_;
			zcdISerializable* _tmp62_;
			_tmp61_ = ret;
			_tmp62_ = _g_object_ref0 ((zcdISerializable*) G_TYPE_CHECK_INSTANCE_CAST (_tmp61_, NETSUKUKU_TYPE_HOOK_RESERVATION, NetsukukuHookReservation));
			result = _tmp62_;
			_g_object_unref0 (ret);
			_g_object_unref0 (gnode);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return result;
		}
		_g_object_unref0 (ret);
		_g_object_unref0 (gnode);
		_g_object_unref0 (iser0);
	}
	_tmp63_ = pieces;
	_tmp63__length1 = pieces_length1;
	_tmp64_ = _tmp63_[0];
	if (g_strcmp0 (_tmp64_, "free") == 0) {
		gchar** _tmp65_;
		gint _tmp65__length1;
		zcdRemoteCall* _tmp67_;
		GeeList* _tmp68_;
		GeeList* _tmp69_;
		gint _tmp70_;
		gint _tmp71_;
		zcdRemoteCall* _tmp73_;
		GeeList* _tmp74_;
		GeeList* _tmp75_;
		gpointer _tmp76_ = NULL;
		zcdISerializable* iser0;
		zcdRemoteCall* _tmp77_;
		GeeList* _tmp78_;
		GeeList* _tmp79_;
		gpointer _tmp80_ = NULL;
		zcdISerializable* iser1;
		zcdISerializable* _tmp81_;
		GType _tmp82_ = 0UL;
		gboolean _tmp83_ = FALSE;
		zcdISerializable* _tmp85_;
		GType _tmp86_ = 0UL;
		gboolean _tmp87_ = FALSE;
		zcdISerializable* _tmp89_;
		NetsukukuPartialNIP* _tmp90_;
		NetsukukuPartialNIP* gnode;
		zcdISerializable* _tmp91_;
		zcdSerializableInt* _tmp92_;
		zcdSerializableInt* pos;
		NetsukukuPartialNIP* _tmp93_;
		zcdSerializableInt* _tmp94_;
		gint _tmp95_;
		gint _tmp96_;
		zcdSerializableNone* _tmp97_;
		_tmp65_ = pieces;
		_tmp65__length1 = pieces_length1;
		if (_tmp65__length1 != 1) {
			GError* _tmp66_;
			_tmp66_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "free is a function.");
			_inner_error_ = _tmp66_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp67_ = data;
		_tmp68_ = zcd_remote_call_get_parameters (_tmp67_);
		_tmp69_ = _tmp68_;
		_tmp70_ = gee_collection_get_size ((GeeCollection*) _tmp69_);
		_tmp71_ = _tmp70_;
		if (_tmp71_ != 2) {
			GError* _tmp72_;
			_tmp72_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "free wants 2 parameters.");
			_inner_error_ = _tmp72_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp73_ = data;
		_tmp74_ = zcd_remote_call_get_parameters (_tmp73_);
		_tmp75_ = _tmp74_;
		_tmp76_ = gee_list_get (_tmp75_, 0);
		iser0 = (zcdISerializable*) _tmp76_;
		_tmp77_ = data;
		_tmp78_ = zcd_remote_call_get_parameters (_tmp77_);
		_tmp79_ = _tmp78_;
		_tmp80_ = gee_list_get (_tmp79_, 1);
		iser1 = (zcdISerializable*) _tmp80_;
		_tmp81_ = iser0;
		_tmp82_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp81_);
		_tmp83_ = g_type_is_a (_tmp82_, NETSUKUKU_TYPE_PARTIAL_NIP);
		if (!_tmp83_) {
			GError* _tmp84_;
			_tmp84_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "free parameter 1 is not a PartialNIP.");
			_inner_error_ = _tmp84_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser1);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp85_ = iser1;
		_tmp86_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp85_);
		_tmp87_ = g_type_is_a (_tmp86_, ZCD_TYPE_SERIALIZABLE_INT);
		if (!_tmp87_) {
			GError* _tmp88_;
			_tmp88_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "free parameter 2 is not a int.");
			_inner_error_ = _tmp88_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser1);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp89_ = iser0;
		_tmp90_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp89_, NETSUKUKU_TYPE_PARTIAL_NIP, NetsukukuPartialNIP));
		gnode = _tmp90_;
		_tmp91_ = iser1;
		_tmp92_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp91_, ZCD_TYPE_SERIALIZABLE_INT, zcdSerializableInt));
		pos = _tmp92_;
		_tmp93_ = gnode;
		_tmp94_ = pos;
		_tmp95_ = zcd_serializable_int_get_i (_tmp94_);
		_tmp96_ = _tmp95_;
		netsukuku_icoord_free ((NetsukukuICoord*) self, _tmp93_, _tmp96_, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (pos);
			_g_object_unref0 (gnode);
			_g_object_unref0 (iser1);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp97_ = zcd_serializable_none_new ();
		result = (zcdISerializable*) _tmp97_;
		_g_object_unref0 (pos);
		_g_object_unref0 (gnode);
		_g_object_unref0 (iser1);
		_g_object_unref0 (iser0);
		pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp98_ = pieces;
	_tmp98__length1 = pieces_length1;
	_tmp99_ = _tmp98_[0];
	if (g_strcmp0 (_tmp99_, "duplicate_free") == 0) {
		gchar** _tmp100_;
		gint _tmp100__length1;
		zcdRemoteCall* _tmp102_;
		GeeList* _tmp103_;
		GeeList* _tmp104_;
		gint _tmp105_;
		gint _tmp106_;
		zcdRemoteCall* _tmp108_;
		GeeList* _tmp109_;
		GeeList* _tmp110_;
		gpointer _tmp111_ = NULL;
		zcdISerializable* iser0;
		zcdRemoteCall* _tmp112_;
		GeeList* _tmp113_;
		GeeList* _tmp114_;
		gpointer _tmp115_ = NULL;
		zcdISerializable* iser1;
		zcdISerializable* _tmp116_;
		GType _tmp117_ = 0UL;
		gboolean _tmp118_ = FALSE;
		zcdISerializable* _tmp120_;
		GType _tmp121_ = 0UL;
		gboolean _tmp122_ = FALSE;
		zcdISerializable* _tmp124_;
		NetsukukuPartialNIP* _tmp125_;
		NetsukukuPartialNIP* gnode;
		zcdISerializable* _tmp126_;
		zcdSerializableInt* _tmp127_;
		zcdSerializableInt* pos;
		NetsukukuPartialNIP* _tmp128_;
		zcdSerializableInt* _tmp129_;
		gint _tmp130_;
		gint _tmp131_;
		zcdSerializableNone* _tmp132_;
		_tmp100_ = pieces;
		_tmp100__length1 = pieces_length1;
		if (_tmp100__length1 != 1) {
			GError* _tmp101_;
			_tmp101_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "duplicate_free is a function.");
			_inner_error_ = _tmp101_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp102_ = data;
		_tmp103_ = zcd_remote_call_get_parameters (_tmp102_);
		_tmp104_ = _tmp103_;
		_tmp105_ = gee_collection_get_size ((GeeCollection*) _tmp104_);
		_tmp106_ = _tmp105_;
		if (_tmp106_ != 2) {
			GError* _tmp107_;
			_tmp107_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "duplicate_free wants 2 parameters.");
			_inner_error_ = _tmp107_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp108_ = data;
		_tmp109_ = zcd_remote_call_get_parameters (_tmp108_);
		_tmp110_ = _tmp109_;
		_tmp111_ = gee_list_get (_tmp110_, 0);
		iser0 = (zcdISerializable*) _tmp111_;
		_tmp112_ = data;
		_tmp113_ = zcd_remote_call_get_parameters (_tmp112_);
		_tmp114_ = _tmp113_;
		_tmp115_ = gee_list_get (_tmp114_, 1);
		iser1 = (zcdISerializable*) _tmp115_;
		_tmp116_ = iser0;
		_tmp117_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp116_);
		_tmp118_ = g_type_is_a (_tmp117_, NETSUKUKU_TYPE_PARTIAL_NIP);
		if (!_tmp118_) {
			GError* _tmp119_;
			_tmp119_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "duplicate_free parameter 1 is not a PartialNIP.");
			_inner_error_ = _tmp119_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser1);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp120_ = iser1;
		_tmp121_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp120_);
		_tmp122_ = g_type_is_a (_tmp121_, ZCD_TYPE_SERIALIZABLE_INT);
		if (!_tmp122_) {
			GError* _tmp123_;
			_tmp123_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "duplicate_free parameter 2 is not a int.");
			_inner_error_ = _tmp123_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser1);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp124_ = iser0;
		_tmp125_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp124_, NETSUKUKU_TYPE_PARTIAL_NIP, NetsukukuPartialNIP));
		gnode = _tmp125_;
		_tmp126_ = iser1;
		_tmp127_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp126_, ZCD_TYPE_SERIALIZABLE_INT, zcdSerializableInt));
		pos = _tmp127_;
		_tmp128_ = gnode;
		_tmp129_ = pos;
		_tmp130_ = zcd_serializable_int_get_i (_tmp129_);
		_tmp131_ = _tmp130_;
		netsukuku_icoord_duplicate_free ((NetsukukuICoord*) self, _tmp128_, _tmp131_, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (pos);
			_g_object_unref0 (gnode);
			_g_object_unref0 (iser1);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp132_ = zcd_serializable_none_new ();
		result = (zcdISerializable*) _tmp132_;
		_g_object_unref0 (pos);
		_g_object_unref0 (gnode);
		_g_object_unref0 (iser1);
		_g_object_unref0 (iser0);
		pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp133_ = pieces;
	_tmp133__length1 = pieces_length1;
	_tmp134_ = _tmp133_[0];
	if (g_strcmp0 (_tmp134_, "register_bnode") == 0) {
		gchar** _tmp135_;
		gint _tmp135__length1;
		zcdRemoteCall* _tmp137_;
		GeeList* _tmp138_;
		GeeList* _tmp139_;
		gint _tmp140_;
		gint _tmp141_;
		zcdRemoteCall* _tmp143_;
		GeeList* _tmp144_;
		GeeList* _tmp145_;
		gpointer _tmp146_ = NULL;
		zcdISerializable* iser0;
		zcdRemoteCall* _tmp147_;
		GeeList* _tmp148_;
		GeeList* _tmp149_;
		gpointer _tmp150_ = NULL;
		zcdISerializable* iser1;
		zcdRemoteCall* _tmp151_;
		GeeList* _tmp152_;
		GeeList* _tmp153_;
		gpointer _tmp154_ = NULL;
		zcdISerializable* iser2;
		zcdRemoteCall* _tmp155_;
		GeeList* _tmp156_;
		GeeList* _tmp157_;
		gpointer _tmp158_ = NULL;
		zcdISerializable* iser3;
		zcdRemoteCall* _tmp159_;
		GeeList* _tmp160_;
		GeeList* _tmp161_;
		gpointer _tmp162_ = NULL;
		zcdISerializable* iser4;
		zcdISerializable* _tmp163_;
		GType _tmp164_ = 0UL;
		gboolean _tmp165_ = FALSE;
		zcdISerializable* _tmp167_;
		GType _tmp168_ = 0UL;
		gboolean _tmp169_ = FALSE;
		zcdISerializable* _tmp171_;
		GType _tmp172_ = 0UL;
		gboolean _tmp173_ = FALSE;
		zcdISerializable* _tmp175_;
		GType _tmp176_ = 0UL;
		gboolean _tmp177_ = FALSE;
		zcdISerializable* _tmp179_;
		GType _tmp180_ = 0UL;
		gboolean _tmp181_ = FALSE;
		zcdISerializable* _tmp183_;
		NetsukukuPartialNIP* _tmp184_;
		NetsukukuPartialNIP* gnode;
		zcdISerializable* _tmp185_;
		NetsukukuNIP* _tmp186_;
		NetsukukuNIP* nip;
		zcdISerializable* _tmp187_;
		zcdSerializableBool* _tmp188_;
		zcdSerializableBool* is_border;
		zcdISerializable* _tmp189_;
		zcdSerializableBool* _tmp190_;
		zcdSerializableBool* has_tunnel;
		zcdISerializable* _tmp191_;
		zcdSerializableBool* _tmp192_;
		zcdSerializableBool* is_willing;
		NetsukukuPartialNIP* _tmp193_;
		NetsukukuNIP* _tmp194_;
		zcdSerializableBool* _tmp195_;
		gboolean _tmp196_;
		gboolean _tmp197_;
		zcdSerializableBool* _tmp198_;
		gboolean _tmp199_;
		gboolean _tmp200_;
		zcdSerializableBool* _tmp201_;
		gboolean _tmp202_;
		gboolean _tmp203_;
		gboolean _tmp204_ = FALSE;
		gboolean ret;
		gboolean _tmp205_;
		zcdSerializableBool* _tmp206_;
		_tmp135_ = pieces;
		_tmp135__length1 = pieces_length1;
		if (_tmp135__length1 != 1) {
			GError* _tmp136_;
			_tmp136_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "register_bnode is a function.");
			_inner_error_ = _tmp136_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp137_ = data;
		_tmp138_ = zcd_remote_call_get_parameters (_tmp137_);
		_tmp139_ = _tmp138_;
		_tmp140_ = gee_collection_get_size ((GeeCollection*) _tmp139_);
		_tmp141_ = _tmp140_;
		if (_tmp141_ != 5) {
			GError* _tmp142_;
			_tmp142_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "register_bnode wants 5 parameters.");
			_inner_error_ = _tmp142_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp143_ = data;
		_tmp144_ = zcd_remote_call_get_parameters (_tmp143_);
		_tmp145_ = _tmp144_;
		_tmp146_ = gee_list_get (_tmp145_, 0);
		iser0 = (zcdISerializable*) _tmp146_;
		_tmp147_ = data;
		_tmp148_ = zcd_remote_call_get_parameters (_tmp147_);
		_tmp149_ = _tmp148_;
		_tmp150_ = gee_list_get (_tmp149_, 1);
		iser1 = (zcdISerializable*) _tmp150_;
		_tmp151_ = data;
		_tmp152_ = zcd_remote_call_get_parameters (_tmp151_);
		_tmp153_ = _tmp152_;
		_tmp154_ = gee_list_get (_tmp153_, 2);
		iser2 = (zcdISerializable*) _tmp154_;
		_tmp155_ = data;
		_tmp156_ = zcd_remote_call_get_parameters (_tmp155_);
		_tmp157_ = _tmp156_;
		_tmp158_ = gee_list_get (_tmp157_, 3);
		iser3 = (zcdISerializable*) _tmp158_;
		_tmp159_ = data;
		_tmp160_ = zcd_remote_call_get_parameters (_tmp159_);
		_tmp161_ = _tmp160_;
		_tmp162_ = gee_list_get (_tmp161_, 4);
		iser4 = (zcdISerializable*) _tmp162_;
		_tmp163_ = iser0;
		_tmp164_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp163_);
		_tmp165_ = g_type_is_a (_tmp164_, NETSUKUKU_TYPE_PARTIAL_NIP);
		if (!_tmp165_) {
			GError* _tmp166_;
			_tmp166_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "register_bnode parameter 1 is not a PartialNIP.");
			_inner_error_ = _tmp166_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser4);
			_g_object_unref0 (iser3);
			_g_object_unref0 (iser2);
			_g_object_unref0 (iser1);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp167_ = iser1;
		_tmp168_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp167_);
		_tmp169_ = g_type_is_a (_tmp168_, NETSUKUKU_TYPE_NIP);
		if (!_tmp169_) {
			GError* _tmp170_;
			_tmp170_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "register_bnode parameter 2 is not a NIP.");
			_inner_error_ = _tmp170_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser4);
			_g_object_unref0 (iser3);
			_g_object_unref0 (iser2);
			_g_object_unref0 (iser1);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp171_ = iser2;
		_tmp172_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp171_);
		_tmp173_ = g_type_is_a (_tmp172_, ZCD_TYPE_SERIALIZABLE_BOOL);
		if (!_tmp173_) {
			GError* _tmp174_;
			_tmp174_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "register_bnode parameter 3 is not a SerializableBool.");
			_inner_error_ = _tmp174_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser4);
			_g_object_unref0 (iser3);
			_g_object_unref0 (iser2);
			_g_object_unref0 (iser1);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp175_ = iser3;
		_tmp176_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp175_);
		_tmp177_ = g_type_is_a (_tmp176_, ZCD_TYPE_SERIALIZABLE_BOOL);
		if (!_tmp177_) {
			GError* _tmp178_;
			_tmp178_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "register_bnode parameter 4 is not a SerializableBool.");
			_inner_error_ = _tmp178_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser4);
			_g_object_unref0 (iser3);
			_g_object_unref0 (iser2);
			_g_object_unref0 (iser1);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp179_ = iser4;
		_tmp180_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp179_);
		_tmp181_ = g_type_is_a (_tmp180_, ZCD_TYPE_SERIALIZABLE_BOOL);
		if (!_tmp181_) {
			GError* _tmp182_;
			_tmp182_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "register_bnode parameter 5 is not a SerializableBool.");
			_inner_error_ = _tmp182_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser4);
			_g_object_unref0 (iser3);
			_g_object_unref0 (iser2);
			_g_object_unref0 (iser1);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp183_ = iser0;
		_tmp184_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp183_, NETSUKUKU_TYPE_PARTIAL_NIP, NetsukukuPartialNIP));
		gnode = _tmp184_;
		_tmp185_ = iser1;
		_tmp186_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp185_, NETSUKUKU_TYPE_NIP, NetsukukuNIP));
		nip = _tmp186_;
		_tmp187_ = iser2;
		_tmp188_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp187_, ZCD_TYPE_SERIALIZABLE_BOOL, zcdSerializableBool));
		is_border = _tmp188_;
		_tmp189_ = iser3;
		_tmp190_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp189_, ZCD_TYPE_SERIALIZABLE_BOOL, zcdSerializableBool));
		has_tunnel = _tmp190_;
		_tmp191_ = iser4;
		_tmp192_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp191_, ZCD_TYPE_SERIALIZABLE_BOOL, zcdSerializableBool));
		is_willing = _tmp192_;
		_tmp193_ = gnode;
		_tmp194_ = nip;
		_tmp195_ = is_border;
		_tmp196_ = zcd_serializable_bool_get_b (_tmp195_);
		_tmp197_ = _tmp196_;
		_tmp198_ = has_tunnel;
		_tmp199_ = zcd_serializable_bool_get_b (_tmp198_);
		_tmp200_ = _tmp199_;
		_tmp201_ = is_willing;
		_tmp202_ = zcd_serializable_bool_get_b (_tmp201_);
		_tmp203_ = _tmp202_;
		_tmp204_ = netsukuku_icoord_register_bnode ((NetsukukuICoord*) self, _tmp193_, _tmp194_, _tmp197_, _tmp200_, _tmp203_, &_inner_error_);
		ret = _tmp204_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (is_willing);
			_g_object_unref0 (has_tunnel);
			_g_object_unref0 (is_border);
			_g_object_unref0 (nip);
			_g_object_unref0 (gnode);
			_g_object_unref0 (iser4);
			_g_object_unref0 (iser3);
			_g_object_unref0 (iser2);
			_g_object_unref0 (iser1);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp205_ = ret;
		_tmp206_ = zcd_serializable_bool_new (_tmp205_);
		result = (zcdISerializable*) _tmp206_;
		_g_object_unref0 (is_willing);
		_g_object_unref0 (has_tunnel);
		_g_object_unref0 (is_border);
		_g_object_unref0 (nip);
		_g_object_unref0 (gnode);
		_g_object_unref0 (iser4);
		_g_object_unref0 (iser3);
		_g_object_unref0 (iser2);
		_g_object_unref0 (iser1);
		_g_object_unref0 (iser0);
		pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp207_ = pieces;
	_tmp207__length1 = pieces_length1;
	_tmp208_ = _tmp207_[0];
	if (g_strcmp0 (_tmp208_, "report_status") == 0) {
		gchar** _tmp209_;
		gint _tmp209__length1;
		zcdRemoteCall* _tmp211_;
		GeeList* _tmp212_;
		GeeList* _tmp213_;
		gint _tmp214_;
		gint _tmp215_;
		GeeList* _tmp217_ = NULL;
		GeeList* _tmp218_;
		GeeList* _tmp219_;
		zcdListISerializable* _tmp220_;
		zcdISerializable* _tmp221_;
		_tmp209_ = pieces;
		_tmp209__length1 = pieces_length1;
		if (_tmp209__length1 != 1) {
			GError* _tmp210_;
			_tmp210_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "report_status is a function.");
			_inner_error_ = _tmp210_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp211_ = data;
		_tmp212_ = zcd_remote_call_get_parameters (_tmp211_);
		_tmp213_ = _tmp212_;
		_tmp214_ = gee_collection_get_size ((GeeCollection*) _tmp213_);
		_tmp215_ = _tmp214_;
		if (_tmp215_ != 0) {
			GError* _tmp216_;
			_tmp216_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "report_status wants no parameters.");
			_inner_error_ = _tmp216_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp217_ = netsukuku_icoord_report_status ((NetsukukuICoord*) self, &_inner_error_);
		_tmp218_ = _tmp217_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp219_ = _tmp218_;
		_tmp220_ = zcd_list_iserializable_new_with_backer (_tmp219_);
		_tmp221_ = (zcdISerializable*) _tmp220_;
		_g_object_unref0 (_tmp219_);
		result = _tmp221_;
		pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp222_ = caller;
	_tmp223_ = data;
	_tmp224_ = ZCD_RPC_DISPATCHER_CLASS (netsukuku_coord_parent_class)->_dispatch ((zcdRPCDispatcher*) G_TYPE_CHECK_INSTANCE_CAST (self, NETSUKUKU_TYPE_PEER_TO_PEER, NetsukukuPeerToPeer), _tmp222_, _tmp223_, &_inner_error_);
	_tmp225_ = _tmp224_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
		return NULL;
	}
	result = _tmp225_;
	pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static GeeList* netsukuku_coord_real_report_status (NetsukukuICoord* base, GError** error) {
	NetsukukuCoord * self;
	GeeList* result = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* ret;
	GError * _inner_error_ = NULL;
	self = (NetsukukuCoord*) base;
	_tmp0_ = gee_array_list_new (NETSUKUKU_TYPE_INFO_COORD, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	ret = _tmp0_;
	{
		NetsukukuMapRoute* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _level_of_nodes;
		_tmp1_ = ((NetsukukuPeerToPeer*) self)->maproute;
		_tmp2_ = netsukuku_map_get_levels ((NetsukukuMap*) _tmp1_);
		_tmp3_ = _tmp2_;
		_level_of_nodes = _tmp3_ - 1;
		{
			gboolean _tmp4_;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp5_;
				gint _tmp7_;
				gint _tmp8_;
				gint _level_of_gnode;
				gint* _tmp9_ = NULL;
				gint* _tmp10_;
				gint _tmp10__length1;
				NetsukukuPartialNIP* _tmp11_;
				NetsukukuPartialNIP* _tmp12_;
				NetsukukuPartialNIP* actual_coord;
				gint _tmp27_;
				NetsukukuCoordinator* _tmp28_ = NULL;
				NetsukukuCoordinator* coordinator;
				NetsukukuCoordinator* _tmp29_;
				NetsukukuCoordinatorKnowledge* _tmp30_ = NULL;
				NetsukukuCoordinatorKnowledge* knowledge;
				NetsukukuInfoCoord* _tmp31_;
				NetsukukuInfoCoord* info_coord;
				NetsukukuInfoCoord* _tmp32_;
				gint _tmp33_;
				NetsukukuInfoCoord* _tmp34_;
				NetsukukuCoordinatorKnowledge* _tmp35_;
				NetsukukuCoordinatorKnowledge* _tmp36_;
				NetsukukuInfoCoord* _tmp37_;
				NetsukukuCoordinator* _tmp38_;
				gboolean _tmp39_;
				gboolean _tmp40_;
				NetsukukuInfoCoord* _tmp41_;
				NetsukukuPartialNIP* _tmp42_;
				NetsukukuPartialNIP* _tmp43_;
				GeeArrayList* _tmp44_;
				NetsukukuInfoCoord* _tmp45_;
				_tmp5_ = _tmp4_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = _level_of_nodes;
					_level_of_nodes = _tmp6_ - 1;
				}
				_tmp4_ = FALSE;
				_tmp7_ = _level_of_nodes;
				if (!(_tmp7_ >= 0)) {
					break;
				}
				_tmp8_ = _level_of_nodes;
				_level_of_gnode = _tmp8_ + 1;
				_tmp9_ = g_new0 (gint, 0);
				_tmp10_ = _tmp9_;
				_tmp10__length1 = 0;
				_tmp11_ = netsukuku_partial_nip_new (_tmp10_, 0);
				_tmp12_ = _tmp11_;
				_tmp10_ = (g_free (_tmp10_), NULL);
				actual_coord = _tmp12_;
				{
					NetsukukuCoord_hkey* _tmp13_;
					NetsukukuCoord_hkey* key;
					NetsukukuCoord_hkey* _tmp14_;
					gint _tmp15_;
					NetsukukuCoord_hkey* _tmp16_;
					NetsukukuMapRoute* _tmp17_;
					NetsukukuNIP* _tmp18_;
					NetsukukuNIP* _tmp19_;
					NetsukukuNIP* _tmp20_;
					NetsukukuCoord_hkey* _tmp21_;
					NetsukukuNIP* _tmp22_ = NULL;
					NetsukukuNIP* _tmp23_;
					NetsukukuPartialNIP* _tmp24_ = NULL;
					NetsukukuPartialNIP* _tmp25_;
					NetsukukuPartialNIP* _tmp26_;
					_tmp13_ = netsukuku_coord_hkey_new ();
					key = _tmp13_;
					_tmp14_ = key;
					_tmp15_ = _level_of_gnode;
					_tmp14_->level_of_gnode = _tmp15_;
					_tmp16_ = key;
					_tmp17_ = ((NetsukukuPeerToPeer*) self)->maproute;
					_tmp18_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp17_);
					_tmp19_ = _tmp18_;
					_tmp20_ = _g_object_ref0 (_tmp19_);
					_g_object_unref0 (_tmp16_->nip);
					_tmp16_->nip = _tmp20_;
					_tmp21_ = key;
					_tmp22_ = netsukuku_peer_to_peer_h ((NetsukukuPeerToPeer*) self, (GObject*) _tmp21_);
					_tmp23_ = _tmp22_;
					_tmp24_ = netsukuku_peer_to_peer_search_participant_as_nip ((NetsukukuPeerToPeer*) self, _tmp23_, 1, &_inner_error_);
					_tmp25_ = _tmp24_;
					_g_object_unref0 (_tmp23_);
					_tmp26_ = _tmp25_;
					if (_inner_error_ != NULL) {
						_g_object_unref0 (key);
						if (_inner_error_->domain == NETSUKUKU_PEER_TO_PEER_ERROR) {
							goto __catch32_netsukuku_peer_to_peer_error;
						}
						_g_object_unref0 (key);
						_g_object_unref0 (actual_coord);
						_g_object_unref0 (ret);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
					_g_object_unref0 (actual_coord);
					actual_coord = _tmp26_;
					_g_object_unref0 (key);
				}
				goto __finally32;
				__catch32_netsukuku_peer_to_peer_error:
				{
					GError* e = NULL;
					e = _inner_error_;
					_inner_error_ = NULL;
					netsukuku_log_error ("Coord.report_status: no participants in Coord service.");
					_g_error_free0 (e);
				}
				__finally32:
				if (_inner_error_ != NULL) {
					_g_object_unref0 (actual_coord);
					_g_object_unref0 (ret);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				_tmp27_ = _level_of_gnode;
				_tmp28_ = netsukuku_coord_get_coordinator_for_gnode_at_level (self, _tmp27_);
				coordinator = _tmp28_;
				_tmp29_ = coordinator;
				_tmp30_ = netsukuku_coordinator_report_status (_tmp29_);
				knowledge = _tmp30_;
				_tmp31_ = netsukuku_info_coord_new ();
				info_coord = _tmp31_;
				_tmp32_ = info_coord;
				_tmp33_ = _level_of_gnode;
				_tmp32_->level = _tmp33_;
				_tmp34_ = info_coord;
				_tmp35_ = knowledge;
				_tmp36_ = _g_object_ref0 (_tmp35_);
				_g_object_unref0 (_tmp34_->knowledge);
				_tmp34_->knowledge = _tmp36_;
				_tmp37_ = info_coord;
				_tmp38_ = coordinator;
				_tmp39_ = netsukuku_coordinator_get_is_main (_tmp38_);
				_tmp40_ = _tmp39_;
				_tmp37_->is_main = _tmp40_;
				_tmp41_ = info_coord;
				_tmp42_ = actual_coord;
				_tmp43_ = _g_object_ref0 (_tmp42_);
				_g_object_unref0 (_tmp41_->actual_coord);
				_tmp41_->actual_coord = _tmp43_;
				_tmp44_ = ret;
				_tmp45_ = info_coord;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp44_, _tmp45_);
				_g_object_unref0 (info_coord);
				_g_object_unref0 (knowledge);
				_g_object_unref0 (coordinator);
				_g_object_unref0 (actual_coord);
			}
		}
	}
	result = (GeeList*) ret;
	return result;
}


static NetsukukuNIP* netsukuku_coord_real_h (NetsukukuPeerToPeer* base, GObject* k) {
	NetsukukuCoord * self;
	NetsukukuNIP* result = NULL;
	GObject* _tmp0_;
	NetsukukuCoord_hkey* _tmp1_;
	NetsukukuCoord_hkey* key;
	NetsukukuCoord_hkey* _tmp2_;
	NetsukukuNIP* _tmp3_;
	gint _tmp4_ = 0;
	gint* _tmp5_ = NULL;
	gint* positions;
	gint positions_length1;
	gint _positions_size_;
	gint* _tmp15_;
	gint _tmp15__length1;
	NetsukukuNIP* _tmp16_;
	self = (NetsukukuCoord*) base;
	g_return_val_if_fail (k != NULL, NULL);
	_tmp0_ = k;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, NETSUKUKU_TYPE_COORD_HKEY, NetsukukuCoord_hkey));
	key = _tmp1_;
	_tmp2_ = key;
	_tmp3_ = _tmp2_->nip;
	_tmp5_ = netsukuku_partial_nip_get_positions ((NetsukukuPartialNIP*) _tmp3_, &_tmp4_);
	positions = _tmp5_;
	positions_length1 = _tmp4_;
	_positions_size_ = positions_length1;
	{
		gint l;
		l = 0;
		{
			gboolean _tmp6_;
			_tmp6_ = TRUE;
			while (TRUE) {
				gboolean _tmp7_;
				gint _tmp9_;
				NetsukukuCoord_hkey* _tmp10_;
				gint _tmp11_;
				gint* _tmp12_;
				gint _tmp12__length1;
				gint _tmp13_;
				gint _tmp14_;
				_tmp7_ = _tmp6_;
				if (!_tmp7_) {
					gint _tmp8_;
					_tmp8_ = l;
					l = _tmp8_ + 1;
				}
				_tmp6_ = FALSE;
				_tmp9_ = l;
				_tmp10_ = key;
				_tmp11_ = _tmp10_->level_of_gnode;
				if (!(_tmp9_ < _tmp11_)) {
					break;
				}
				_tmp12_ = positions;
				_tmp12__length1 = positions_length1;
				_tmp13_ = l;
				_tmp12_[_tmp13_] = 0;
				_tmp14_ = _tmp12_[_tmp13_];
			}
		}
	}
	_tmp15_ = positions;
	_tmp15__length1 = positions_length1;
	_tmp16_ = netsukuku_nip_new (_tmp15_, _tmp15__length1);
	result = _tmp16_;
	positions = (g_free (positions), NULL);
	_g_object_unref0 (key);
	return result;
}


NetsukukuCoordinator* netsukuku_coord_get_coordinator_for_gnode_at_level (NetsukukuCoord* self, gint l) {
	NetsukukuCoordinator* result = NULL;
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gpointer _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_coordinators;
	_tmp1_ = l;
	_tmp2_ = gee_abstract_list_get ((GeeAbstractList*) _tmp0_, _tmp1_ - 1);
	result = (NetsukukuCoordinator*) _tmp2_;
	return result;
}


static void netsukuku_coord_set_coordinator_for_gnode_at_level (NetsukukuCoord* self, gint l) {
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GeeArrayList* _tmp4_;
	NetsukukuMapRoute* _tmp5_;
	NetsukukuNIP* _tmp6_;
	NetsukukuNIP* _tmp7_;
	gint _tmp8_;
	NetsukukuPartialNIP* _tmp9_ = NULL;
	NetsukukuPartialNIP* _tmp10_;
	NetsukukuCoordinator* _tmp11_;
	NetsukukuCoordinator* _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_coordinators;
	_tmp1_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = l;
	_vala_assert (_tmp2_ == (_tmp3_ - 1), "_coordinators.size == l-1");
	_tmp4_ = self->priv->_coordinators;
	_tmp5_ = ((NetsukukuPeerToPeer*) self)->maproute;
	_tmp6_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = l;
	_tmp9_ = netsukuku_partial_nip_get_gnode_at_level ((NetsukukuPartialNIP*) _tmp7_, _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = netsukuku_coordinator_new (_tmp10_, self);
	_tmp12_ = _tmp11_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp4_, _tmp12_);
	_g_object_unref0 (_tmp12_);
	_g_object_unref0 (_tmp10_);
}


void netsukuku_coord_initialize_coordinators (NetsukukuCoord* self) {
	GeeArrayList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_array_list_new (NETSUKUKU_TYPE_COORDINATOR, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_coordinators);
	self->priv->_coordinators = _tmp0_;
	{
		gint l;
		l = 1;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				gboolean _tmp2_;
				gint _tmp4_;
				NetsukukuMapRoute* _tmp5_;
				gint _tmp6_;
				gint _tmp7_;
				gint _tmp8_;
				_tmp2_ = _tmp1_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = l;
					l = _tmp3_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp4_ = l;
				_tmp5_ = ((NetsukukuPeerToPeer*) self)->maproute;
				_tmp6_ = netsukuku_map_get_levels ((NetsukukuMap*) _tmp5_);
				_tmp7_ = _tmp6_;
				if (!(_tmp4_ <= _tmp7_)) {
					break;
				}
				_tmp8_ = l;
				netsukuku_coord_set_coordinator_for_gnode_at_level (self, _tmp8_);
			}
		}
	}
}


static void netsukuku_coord_real_stop_operations (NetsukukuPeerToPeer* base) {
	NetsukukuCoord * self;
	self = (NetsukukuCoord*) base;
	NETSUKUKU_PEER_TO_PEER_CLASS (netsukuku_coord_parent_class)->stop_operations (G_TYPE_CHECK_INSTANCE_CAST (self, NETSUKUKU_TYPE_PEER_TO_PEER, NetsukukuPeerToPeer));
	{
		gint l;
		l = 1;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_;
				gint _tmp3_;
				NetsukukuMapRoute* _tmp4_;
				gint _tmp5_;
				gint _tmp6_;
				gint _tmp7_;
				NetsukukuCoordinator* _tmp8_ = NULL;
				NetsukukuCoordinator* coordinator;
				NetsukukuCoordinator* _tmp9_;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = l;
					l = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = l;
				_tmp4_ = ((NetsukukuPeerToPeer*) self)->maproute;
				_tmp5_ = netsukuku_map_get_levels ((NetsukukuMap*) _tmp4_);
				_tmp6_ = _tmp5_;
				if (!(_tmp3_ < (_tmp6_ + 1))) {
					break;
				}
				_tmp7_ = l;
				_tmp8_ = netsukuku_coord_get_coordinator_for_gnode_at_level (self, _tmp7_);
				coordinator = _tmp8_;
				_tmp9_ = coordinator;
				netsukuku_coordinator_stop_operations (_tmp9_);
				_g_object_unref0 (coordinator);
			}
		}
	}
}


NetsukukuPartialNIP* netsukuku_coord_get_my_gnode_at_level (NetsukukuCoord* self, gint l) {
	NetsukukuPartialNIP* result = NULL;
	NetsukukuMapRoute* _tmp0_;
	NetsukukuNIP* _tmp1_;
	NetsukukuNIP* _tmp2_;
	gint _tmp3_;
	NetsukukuPartialNIP* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = ((NetsukukuPeerToPeer*) self)->maproute;
	_tmp1_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = l;
	_tmp4_ = netsukuku_partial_nip_get_gnode_at_level ((NetsukukuPartialNIP*) _tmp2_, _tmp3_);
	result = _tmp4_;
	return result;
}


gint netsukuku_coord_get_level_of_gnode (NetsukukuCoord* self, NetsukukuPartialNIP* gnode) {
	gint result = 0;
	NetsukukuPartialNIP* _tmp0_;
	gint _tmp1_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (gnode != NULL, 0);
	_tmp0_ = gnode;
	_tmp1_ = netsukuku_partial_nip_level_of_gnode (_tmp0_);
	result = _tmp1_;
	return result;
}


NetsukukuCoordinator* netsukuku_coord_get_coordinator_for_gnode (NetsukukuCoord* self, NetsukukuPartialNIP* gnode, GError** error) {
	NetsukukuCoordinator* result = NULL;
	NetsukukuPartialNIP* _tmp0_;
	gint _tmp1_ = 0;
	gint level_of_gnode;
	gint _tmp2_;
	NetsukukuPartialNIP* _tmp3_ = NULL;
	NetsukukuPartialNIP* _tmp4_;
	NetsukukuPartialNIP* _tmp5_;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_;
	gint _tmp13_;
	NetsukukuCoordinator* _tmp14_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (gnode != NULL, NULL);
	_tmp0_ = gnode;
	_tmp1_ = netsukuku_coord_get_level_of_gnode (self, _tmp0_);
	level_of_gnode = _tmp1_;
	_tmp2_ = level_of_gnode;
	_tmp3_ = netsukuku_coord_get_my_gnode_at_level (self, _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = gnode;
	_tmp6_ = netsukuku_partial_nip_is_equal (_tmp4_, _tmp5_);
	_tmp7_ = !_tmp6_;
	_g_object_unref0 (_tmp4_);
	if (_tmp7_) {
		NetsukukuPartialNIP* _tmp8_;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_;
		GError* _tmp11_;
		GError* _tmp12_;
		_tmp8_ = gnode;
		_tmp9_ = netsukuku_partial_nip_to_string (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_error_new_literal (NETSUKUKU_HOOKING_ERROR, NETSUKUKU_HOOKING_ERROR_INEXISTENT_GNODE, _tmp10_);
		_tmp12_ = _tmp11_;
		_g_free0 (_tmp10_);
		_inner_error_ = _tmp12_;
		if (_inner_error_->domain == NETSUKUKU_HOOKING_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp13_ = level_of_gnode;
	_tmp14_ = netsukuku_coord_get_coordinator_for_gnode_at_level (self, _tmp13_);
	result = _tmp14_;
	return result;
}


/** Client-side helpers **/
NetsukukuHookReservation* netsukuku_coord_enter_into (NetsukukuCoord* self, gint level_of_gnode, NetsukukuNIP* nip, NetsukukuAggregatedNeighbour* neighbour_to_contact) {
	NetsukukuHookReservation* result = NULL;
	NetsukukuCoord_hkey* _tmp0_;
	NetsukukuCoord_hkey* key;
	NetsukukuCoord_hkey* _tmp1_;
	gint _tmp2_;
	NetsukukuCoord_hkey* _tmp3_;
	NetsukukuNIP* _tmp4_;
	NetsukukuNIP* _tmp5_;
	NetsukukuCoord_hkey* _tmp6_;
	NetsukukuAggregatedNeighbour* _tmp7_;
	NetsukukuRmtCoordPeer* _tmp8_ = NULL;
	NetsukukuRmtCoordPeer* _peer;
	NetsukukuHookReservation* ret;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (nip != NULL, NULL);
	_tmp0_ = netsukuku_coord_hkey_new ();
	key = _tmp0_;
	_tmp1_ = key;
	_tmp2_ = level_of_gnode;
	_tmp1_->level_of_gnode = _tmp2_;
	_tmp3_ = key;
	_tmp4_ = nip;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (_tmp3_->nip);
	_tmp3_->nip = _tmp5_;
	_tmp6_ = key;
	_tmp7_ = neighbour_to_contact;
	_tmp8_ = netsukuku_coord_peer (self, NULL, (GObject*) _tmp6_, _tmp7_);
	_peer = _tmp8_;
	ret = NULL;
	{
		NetsukukuRmtCoordPeer* _tmp9_;
		NetsukukuNIP* _tmp10_;
		gint _tmp11_;
		NetsukukuPartialNIP* _tmp12_ = NULL;
		NetsukukuPartialNIP* _tmp13_;
		NetsukukuHookReservation* _tmp14_ = NULL;
		NetsukukuHookReservation* _tmp15_;
		NetsukukuHookReservation* _tmp16_;
		_tmp9_ = _peer;
		_tmp10_ = nip;
		_tmp11_ = level_of_gnode;
		_tmp12_ = netsukuku_partial_nip_get_gnode_at_level ((NetsukukuPartialNIP*) _tmp10_, _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = netsukuku_icoord_reserve ((NetsukukuICoord*) _tmp9_, _tmp13_, &_inner_error_);
		_tmp15_ = _tmp14_;
		_g_object_unref0 (_tmp13_);
		_tmp16_ = _tmp15_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch33_zcd_rpc_error;
			}
			if (_inner_error_->domain == NETSUKUKU_HOOKING_ERROR) {
				goto __catch33_netsukuku_hooking_error;
			}
			_g_object_unref0 (ret);
			_g_object_unref0 (_peer);
			_g_object_unref0 (key);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_object_unref0 (ret);
		ret = _tmp16_;
	}
	goto __finally33;
	__catch33_zcd_rpc_error:
	{
		GError* e = NULL;
		GError* _tmp17_;
		gint _tmp18_;
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_;
		GError* _tmp21_;
		const gchar* _tmp22_;
		const gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
		gchar* _tmp25_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp17_ = e;
		_tmp18_ = _tmp17_->code;
		_tmp19_ = g_strdup_printf ("%i", _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = e;
		_tmp22_ = _tmp21_->message;
		_tmp23_ = string_to_string (_tmp22_);
		_tmp24_ = g_strconcat ("Coord: got RPCError code ", _tmp20_, ": ", _tmp23_, NULL);
		_tmp25_ = _tmp24_;
		netsukuku_log_info (_tmp25_);
		_g_free0 (_tmp25_);
		_g_free0 (_tmp20_);
		_g_error_free0 (e);
	}
	goto __finally33;
	__catch33_netsukuku_hooking_error:
	{
		GError* e = NULL;
		GError* _tmp26_;
		gint _tmp27_;
		gchar* _tmp28_ = NULL;
		gchar* _tmp29_;
		GError* _tmp30_;
		const gchar* _tmp31_;
		const gchar* _tmp32_ = NULL;
		gchar* _tmp33_ = NULL;
		gchar* _tmp34_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp26_ = e;
		_tmp27_ = _tmp26_->code;
		_tmp28_ = g_strdup_printf ("%i", _tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = e;
		_tmp31_ = _tmp30_->message;
		_tmp32_ = string_to_string (_tmp31_);
		_tmp33_ = g_strconcat ("Coord: got HookingError code ", _tmp29_, ": ", _tmp32_, NULL);
		_tmp34_ = _tmp33_;
		netsukuku_log_info (_tmp34_);
		_g_free0 (_tmp34_);
		_g_free0 (_tmp29_);
		_g_error_free0 (e);
	}
	__finally33:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (ret);
		_g_object_unref0 (_peer);
		_g_object_unref0 (key);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = ret;
	_g_object_unref0 (_peer);
	_g_object_unref0 (key);
	return result;
}


NetsukukuBookings* netsukuku_coord_get_bookings (NetsukukuCoord* self, gint level_of_gnode) {
	NetsukukuBookings* result = NULL;
	gint _tmp0_;
	NetsukukuCoordinator* _tmp1_ = NULL;
	NetsukukuCoordinator* coordinator;
	NetsukukuBookings* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = level_of_gnode;
	_tmp1_ = netsukuku_coord_get_coordinator_for_gnode_at_level (self, _tmp0_);
	coordinator = _tmp1_;
	_tmp2_ = netsukuku_coordinator_get_bookings (coordinator);
	result = _tmp2_;
	_g_object_unref0 (coordinator);
	return result;
}


gint netsukuku_coord_get_last_assigned_elderliness (NetsukukuCoord* self, gint level_of_gnode) {
	gint result = 0;
	gint _tmp0_;
	NetsukukuCoordinator* _tmp1_ = NULL;
	NetsukukuCoordinator* coordinator;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = level_of_gnode;
	_tmp1_ = netsukuku_coord_get_coordinator_for_gnode_at_level (self, _tmp0_);
	coordinator = _tmp1_;
	_tmp2_ = coordinator->last_assigned_elderliness;
	result = _tmp2_;
	_g_object_unref0 (coordinator);
	return result;
}


NetsukukuBnodeList* netsukuku_coord_get_bnode_list (NetsukukuCoord* self, gint level_of_gnode) {
	NetsukukuBnodeList* result = NULL;
	gint _tmp0_;
	NetsukukuCoordinator* _tmp1_ = NULL;
	NetsukukuCoordinator* coordinator;
	NetsukukuBnodeList* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = level_of_gnode;
	_tmp1_ = netsukuku_coord_get_coordinator_for_gnode_at_level (self, _tmp0_);
	coordinator = _tmp1_;
	_tmp2_ = netsukuku_coordinator_get_bnode_list (coordinator);
	result = _tmp2_;
	_g_object_unref0 (coordinator);
	return result;
}


/** Remotables **/
static NetsukukuHookReservation* netsukuku_coord_real_reserve (NetsukukuICoord* base, NetsukukuPartialNIP* gnode, GError** error) {
	NetsukukuCoord * self;
	NetsukukuHookReservation* result = NULL;
	NetsukukuPartialNIP* _tmp0_;
	NetsukukuCoordinator* _tmp1_ = NULL;
	NetsukukuCoordinator* coordinator;
	NetsukukuHookReservation* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
	self = (NetsukukuCoord*) base;
	g_return_val_if_fail (gnode != NULL, NULL);
	_tmp0_ = gnode;
	_tmp1_ = netsukuku_coord_get_coordinator_for_gnode (self, _tmp0_, &_inner_error_);
	coordinator = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == NETSUKUKU_HOOKING_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp2_ = netsukuku_coordinator_reserve (coordinator);
	result = _tmp2_;
	_g_object_unref0 (coordinator);
	return result;
}


static void netsukuku_coord_real_free (NetsukukuICoord* base, NetsukukuPartialNIP* gnode, gint pos, GError** error) {
	NetsukukuCoord * self;
	NetsukukuPartialNIP* _tmp0_;
	NetsukukuCoordinator* _tmp1_ = NULL;
	NetsukukuCoordinator* coordinator;
	gint _tmp2_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuCoord*) base;
	g_return_if_fail (gnode != NULL);
	_tmp0_ = gnode;
	_tmp1_ = netsukuku_coord_get_coordinator_for_gnode (self, _tmp0_, &_inner_error_);
	coordinator = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == NETSUKUKU_HOOKING_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp2_ = pos;
	netsukuku_coordinator_free (coordinator, _tmp2_);
	_g_object_unref0 (coordinator);
}


static void netsukuku_coord_real_duplicate_all_knowledge (NetsukukuICoord* base, NetsukukuPartialNIP* gnode, NetsukukuCoordinatorKnowledge* coordinator_knowledge, GError** error) {
	NetsukukuCoord * self;
	NetsukukuPartialNIP* _tmp0_;
	NetsukukuCoordinator* _tmp1_ = NULL;
	NetsukukuCoordinator* coordinator;
	NetsukukuCoordinatorKnowledge* _tmp2_;
	NetsukukuBookings* _tmp3_;
	NetsukukuBookings* _tmp4_;
	gint _tmp5_;
	NetsukukuCoordinatorKnowledge* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	NetsukukuCoordinatorKnowledge* _tmp12_;
	NetsukukuBnodeList* _tmp13_;
	NetsukukuBnodeList* _tmp14_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuCoord*) base;
	g_return_if_fail (gnode != NULL);
	g_return_if_fail (coordinator_knowledge != NULL);
	_tmp0_ = gnode;
	_tmp1_ = netsukuku_coord_get_coordinator_for_gnode (self, _tmp0_, &_inner_error_);
	coordinator = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == NETSUKUKU_HOOKING_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp2_ = coordinator_knowledge;
	_tmp3_ = netsukuku_coordinator_knowledge_get_bookings (_tmp2_);
	_tmp4_ = _tmp3_;
	netsukuku_coordinator_add_bookings (coordinator, _tmp4_);
	_tmp5_ = coordinator->last_assigned_elderliness;
	_tmp6_ = coordinator_knowledge;
	_tmp7_ = netsukuku_coordinator_knowledge_get_last_assigned_elderliness (_tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp5_ < _tmp8_) {
		NetsukukuCoordinatorKnowledge* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		_tmp9_ = coordinator_knowledge;
		_tmp10_ = netsukuku_coordinator_knowledge_get_last_assigned_elderliness (_tmp9_);
		_tmp11_ = _tmp10_;
		coordinator->last_assigned_elderliness = _tmp11_;
	}
	_tmp12_ = coordinator_knowledge;
	_tmp13_ = netsukuku_coordinator_knowledge_get_bnode_list (_tmp12_);
	_tmp14_ = _tmp13_;
	netsukuku_coordinator_add_bnode_list (coordinator, _tmp14_);
	_g_object_unref0 (coordinator);
}


static void netsukuku_coord_real_duplicate_free (NetsukukuICoord* base, NetsukukuPartialNIP* gnode, gint pos, GError** error) {
	NetsukukuCoord * self;
	NetsukukuPartialNIP* _tmp0_;
	NetsukukuCoordinator* _tmp1_ = NULL;
	NetsukukuCoordinator* coordinator;
	gint _tmp2_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuCoord*) base;
	g_return_if_fail (gnode != NULL);
	_tmp0_ = gnode;
	_tmp1_ = netsukuku_coord_get_coordinator_for_gnode (self, _tmp0_, &_inner_error_);
	coordinator = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == NETSUKUKU_HOOKING_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp2_ = pos;
	netsukuku_coordinator_force_remove (coordinator, _tmp2_);
	_g_object_unref0 (coordinator);
}


static gboolean netsukuku_coord_real_register_bnode (NetsukukuICoord* base, NetsukukuPartialNIP* gnode, NetsukukuNIP* nip, gboolean is_border, gboolean has_tunnel, gboolean is_willing, GError** error) {
	NetsukukuCoord * self;
	gboolean result = FALSE;
	NetsukukuPartialNIP* _tmp0_;
	NetsukukuCoordinator* _tmp1_ = NULL;
	NetsukukuCoordinator* coordinator;
	NetsukukuNIP* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_ = FALSE;
	GError * _inner_error_ = NULL;
	self = (NetsukukuCoord*) base;
	g_return_val_if_fail (gnode != NULL, FALSE);
	g_return_val_if_fail (nip != NULL, FALSE);
	_tmp0_ = gnode;
	_tmp1_ = netsukuku_coord_get_coordinator_for_gnode (self, _tmp0_, &_inner_error_);
	coordinator = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == NETSUKUKU_HOOKING_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	_tmp2_ = nip;
	_tmp3_ = is_border;
	_tmp4_ = has_tunnel;
	_tmp5_ = is_willing;
	_tmp6_ = netsukuku_coordinator_register_bnode (coordinator, _tmp2_, _tmp3_, _tmp4_, _tmp5_);
	result = _tmp6_;
	_g_object_unref0 (coordinator);
	return result;
}


/** A new node in the service
          */
void netsukuku_coord_node_joins_maproute (NetsukukuCoord* self, gint level_of_nodes, gint pos) {
	gint _tmp0_;
	gint level_of_gnode;
	gint _tmp1_;
	NetsukukuCoordinator* _tmp2_ = NULL;
	NetsukukuCoordinator* coordinator;
	NetsukukuCoordinator* _tmp3_;
	NetsukukuCoordinator* _tmp4_;
	gint _tmp5_;
	gboolean _tmp6_ = FALSE;
	NetsukukuCoordinator* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp0_ = level_of_nodes;
	level_of_gnode = _tmp0_ + 1;
	_tmp1_ = level_of_gnode;
	_tmp2_ = netsukuku_coord_get_coordinator_for_gnode_at_level (self, _tmp1_);
	coordinator = _tmp2_;
	_tmp3_ = coordinator;
	netsukuku_coordinator_map_has_changed (_tmp3_);
	_tmp4_ = coordinator;
	_tmp5_ = pos;
	netsukuku_coordinator_force_remove (_tmp4_, _tmp5_);
	_tmp7_ = coordinator;
	_tmp8_ = netsukuku_coordinator_get_was_main (_tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp9_) {
		NetsukukuCoordinator* _tmp10_;
		gboolean _tmp11_;
		gboolean _tmp12_;
		_tmp10_ = coordinator;
		_tmp11_ = netsukuku_coordinator_get_is_main (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp6_ = !_tmp12_;
	} else {
		_tmp6_ = FALSE;
	}
	_tmp13_ = _tmp6_;
	if (_tmp13_) {
		gint _tmp14_;
		_tmp14_ = level_of_gnode;
		netsukuku_coord_communicate_to_new_coordinator (self, _tmp14_);
	}
	_g_object_unref0 (coordinator);
}


static void netsukuku_coord_impl_communicate_to_new_coordinator (NetsukukuCoord* self, gint level_of_gnode, GError** error) {
	NetsukukuCoord_hkey* _tmp0_;
	NetsukukuCoord_hkey* key;
	gint _tmp1_;
	NetsukukuMapRoute* _tmp2_;
	NetsukukuNIP* _tmp3_;
	NetsukukuNIP* _tmp4_;
	NetsukukuNIP* _tmp5_;
	NetsukukuRmtCoordPeer* _tmp6_ = NULL;
	NetsukukuRmtCoordPeer* _peer;
	gint _tmp7_;
	NetsukukuPartialNIP* _tmp8_ = NULL;
	NetsukukuPartialNIP* _tmp9_;
	gint _tmp10_;
	NetsukukuBookings* _tmp11_ = NULL;
	NetsukukuBookings* _tmp12_;
	gint _tmp13_;
	gint _tmp14_ = 0;
	gint _tmp15_;
	NetsukukuBnodeList* _tmp16_ = NULL;
	NetsukukuBnodeList* _tmp17_;
	NetsukukuCoordinatorKnowledge* _tmp18_;
	NetsukukuCoordinatorKnowledge* _tmp19_;
	NetsukukuCoordinatorKnowledge* coordinator_knowledge;
	gint _tmp20_;
	NetsukukuPartialNIP* _tmp21_ = NULL;
	NetsukukuPartialNIP* _tmp22_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	tasklets_tasklet_declare_self ("Coord.communicate_to_new_coordinator");
	_tmp0_ = netsukuku_coord_hkey_new ();
	key = _tmp0_;
	_tmp1_ = level_of_gnode;
	key->level_of_gnode = _tmp1_;
	_tmp2_ = ((NetsukukuPeerToPeer*) self)->maproute;
	_tmp3_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (key->nip);
	key->nip = _tmp5_;
	_tmp6_ = netsukuku_coord_peer (self, NULL, (GObject*) key, NULL);
	_peer = _tmp6_;
	_tmp7_ = level_of_gnode;
	_tmp8_ = netsukuku_coord_get_my_gnode_at_level (self, _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = level_of_gnode;
	_tmp11_ = netsukuku_coord_get_bookings (self, _tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = level_of_gnode;
	_tmp14_ = netsukuku_coord_get_last_assigned_elderliness (self, _tmp13_);
	_tmp15_ = level_of_gnode;
	_tmp16_ = netsukuku_coord_get_bnode_list (self, _tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = netsukuku_coordinator_knowledge_new (_tmp9_, _tmp12_, _tmp14_, _tmp17_);
	_tmp19_ = _tmp18_;
	_g_object_unref0 (_tmp17_);
	_g_object_unref0 (_tmp12_);
	_g_object_unref0 (_tmp9_);
	coordinator_knowledge = _tmp19_;
	_tmp20_ = level_of_gnode;
	_tmp21_ = netsukuku_coord_get_my_gnode_at_level (self, _tmp20_);
	_tmp22_ = _tmp21_;
	netsukuku_icoord_duplicate_all_knowledge ((NetsukukuICoord*) _peer, _tmp22_, coordinator_knowledge, &_inner_error_);
	_g_object_unref0 (_tmp22_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (coordinator_knowledge);
		_g_object_unref0 (_peer);
		_g_object_unref0 (key);
		return;
	}
	_g_object_unref0 (coordinator_knowledge);
	_g_object_unref0 (_peer);
	_g_object_unref0 (key);
}


static void* netsukuku_coord_helper_communicate_to_new_coordinator (void* v, GError** error) {
	void* result = NULL;
	void* _tmp0_;
	Netsukukustruct_helper_Coord_communicate_to_new_coordinator* tuple_p;
	NetsukukuCoord* _tmp1_;
	NetsukukuCoord* _tmp2_;
	NetsukukuCoord* self_save;
	gint _tmp3_;
	gint level_of_gnode_save;
	GError * _inner_error_ = NULL;
	_tmp0_ = v;
	tuple_p = (Netsukukustruct_helper_Coord_communicate_to_new_coordinator*) _tmp0_;
	_tmp1_ = (*tuple_p).self;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	self_save = _tmp2_;
	_tmp3_ = (*tuple_p).level_of_gnode;
	level_of_gnode_save = _tmp3_;
	tasklets_tasklet_schedule_back ();
	netsukuku_coord_impl_communicate_to_new_coordinator (self_save, level_of_gnode_save, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self_save);
		return NULL;
	}
	result = NULL;
	_g_object_unref0 (self_save);
	return result;
}


void netsukuku_coord_communicate_to_new_coordinator (NetsukukuCoord* self, gint level_of_gnode) {
	Netsukukustruct_helper_Coord_communicate_to_new_coordinator arg = {0};
	NetsukukuCoord* _tmp0_;
	gint _tmp1_;
	TaskletsTasklet* _tmp2_ = NULL;
	TaskletsTasklet* _tmp3_;
	g_return_if_fail (self != NULL);
	memset (&arg, 0, sizeof (Netsukukustruct_helper_Coord_communicate_to_new_coordinator));
	_tmp0_ = _g_object_ref0 (self);
	_g_object_unref0 (arg.self);
	arg.self = _tmp0_;
	_tmp1_ = level_of_gnode;
	arg.level_of_gnode = _tmp1_;
	_tmp2_ = tasklets_tasklet_spawn ((TaskletsSpawnable) netsukuku_coord_helper_communicate_to_new_coordinator, &arg, FALSE, -1);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp3_);
	netsukuku_struct_helper_coord_communicate_to_new_coordinator_destroy (&arg);
}


/** A deleted node in the service
          */
void netsukuku_coord_node_exits_maproute (NetsukukuCoord* self, gint level_of_nodes, gint pos) {
	gint _tmp0_;
	gint level_of_gnode;
	NetsukukuCoordinator* _tmp1_ = NULL;
	NetsukukuCoordinator* coordinator;
	g_return_if_fail (self != NULL);
	_tmp0_ = level_of_nodes;
	level_of_gnode = _tmp0_ + 1;
	_tmp1_ = netsukuku_coord_get_coordinator_for_gnode_at_level (self, level_of_gnode);
	coordinator = _tmp1_;
	netsukuku_coordinator_map_has_changed (coordinator);
	_g_object_unref0 (coordinator);
}


/** We now have a valid map, I could have become a coordinator
          */
void netsukuku_coord_coord_has_valid_map (NetsukukuCoord* self) {
	g_return_if_fail (self != NULL);
	{
		gint level_of_gnode;
		level_of_gnode = 1;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_;
				gint _tmp3_;
				NetsukukuMapRoute* _tmp4_;
				gint _tmp5_;
				gint _tmp6_;
				gint _tmp7_;
				NetsukukuCoordinator* _tmp8_ = NULL;
				NetsukukuCoordinator* coordinator;
				NetsukukuCoordinator* _tmp9_;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = level_of_gnode;
					level_of_gnode = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = level_of_gnode;
				_tmp4_ = ((NetsukukuPeerToPeer*) self)->maproute;
				_tmp5_ = netsukuku_map_get_levels ((NetsukukuMap*) _tmp4_);
				_tmp6_ = _tmp5_;
				if (!(_tmp3_ < (_tmp6_ + 1))) {
					break;
				}
				_tmp7_ = level_of_gnode;
				_tmp8_ = netsukuku_coord_get_coordinator_for_gnode_at_level (self, _tmp7_);
				coordinator = _tmp8_;
				_tmp9_ = coordinator;
				netsukuku_coordinator_map_has_changed (_tmp9_);
				_g_object_unref0 (coordinator);
			}
		}
	}
}


static void netsukuku_coord_class_init (NetsukukuCoordClass * klass) {
	netsukuku_coord_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (NetsukukuCoordPrivate));
	ZCD_RPC_DISPATCHER_CLASS (klass)->_dispatch = netsukuku_coord_real__dispatch;
	NETSUKUKU_PEER_TO_PEER_CLASS (klass)->h = netsukuku_coord_real_h;
	NETSUKUKU_PEER_TO_PEER_CLASS (klass)->stop_operations = netsukuku_coord_real_stop_operations;
	G_OBJECT_CLASS (klass)->finalize = netsukuku_coord_finalize;
}


static void netsukuku_coord_netsukuku_icoord_interface_init (NetsukukuICoordIface * iface) {
	netsukuku_coord_netsukuku_icoord_parent_iface = g_type_interface_peek_parent (iface);
	iface->report_status = (GeeList* (*)(NetsukukuICoord*, GError**)) netsukuku_coord_real_report_status;
	iface->reserve = (NetsukukuHookReservation* (*)(NetsukukuICoord*, NetsukukuPartialNIP*, GError**)) netsukuku_coord_real_reserve;
	iface->free = (void (*)(NetsukukuICoord*, NetsukukuPartialNIP*, gint, GError**)) netsukuku_coord_real_free;
	iface->duplicate_all_knowledge = (void (*)(NetsukukuICoord*, NetsukukuPartialNIP*, NetsukukuCoordinatorKnowledge*, GError**)) netsukuku_coord_real_duplicate_all_knowledge;
	iface->duplicate_free = (void (*)(NetsukukuICoord*, NetsukukuPartialNIP*, gint, GError**)) netsukuku_coord_real_duplicate_free;
	iface->register_bnode = (gboolean (*)(NetsukukuICoord*, NetsukukuPartialNIP*, NetsukukuNIP*, gboolean, gboolean, gboolean, GError**)) netsukuku_coord_real_register_bnode;
}


static void netsukuku_coord_instance_init (NetsukukuCoord * self) {
	self->priv = NETSUKUKU_COORD_GET_PRIVATE (self);
}


static void netsukuku_coord_finalize (GObject* obj) {
	NetsukukuCoord * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_COORD, NetsukukuCoord);
	_g_object_unref0 (self->priv->_coordinators);
	G_OBJECT_CLASS (netsukuku_coord_parent_class)->finalize (obj);
}


GType netsukuku_coord_get_type (void) {
	static volatile gsize netsukuku_coord_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_coord_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuCoordClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_coord_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuCoord), 0, (GInstanceInitFunc) netsukuku_coord_instance_init, NULL };
		static const GInterfaceInfo netsukuku_icoord_info = { (GInterfaceInitFunc) netsukuku_coord_netsukuku_icoord_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType netsukuku_coord_type_id;
		netsukuku_coord_type_id = g_type_register_static (NETSUKUKU_TYPE_PEER_TO_PEER, "NetsukukuCoord", &g_define_type_info, 0);
		g_type_add_interface_static (netsukuku_coord_type_id, NETSUKUKU_TYPE_ICOORD, &netsukuku_icoord_info);
		g_once_init_leave (&netsukuku_coord_type_id__volatile, netsukuku_coord_type_id);
	}
	return netsukuku_coord_type_id__volatile;
}


void netsukuku_struct_helper_coordinator_manage_bnode_tunnels_copy (const Netsukukustruct_helper_Coordinator_manage_bnode_tunnels* self, Netsukukustruct_helper_Coordinator_manage_bnode_tunnels* dest) {
	NetsukukuCoordinator* _tmp0_;
	NetsukukuCoordinator* _tmp1_;
	_tmp0_ = (*self).self;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 ((*dest).self);
	(*dest).self = _tmp1_;
}


void netsukuku_struct_helper_coordinator_manage_bnode_tunnels_destroy (Netsukukustruct_helper_Coordinator_manage_bnode_tunnels* self) {
	_g_object_unref0 ((*self).self);
}


Netsukukustruct_helper_Coordinator_manage_bnode_tunnels* netsukuku_struct_helper_coordinator_manage_bnode_tunnels_dup (const Netsukukustruct_helper_Coordinator_manage_bnode_tunnels* self) {
	Netsukukustruct_helper_Coordinator_manage_bnode_tunnels* dup;
	dup = g_new0 (Netsukukustruct_helper_Coordinator_manage_bnode_tunnels, 1);
	netsukuku_struct_helper_coordinator_manage_bnode_tunnels_copy (self, dup);
	return dup;
}


void netsukuku_struct_helper_coordinator_manage_bnode_tunnels_free (Netsukukustruct_helper_Coordinator_manage_bnode_tunnels* self) {
	netsukuku_struct_helper_coordinator_manage_bnode_tunnels_destroy (self);
	g_free (self);
}


GType netsukuku_struct_helper_coordinator_manage_bnode_tunnels_get_type (void) {
	static volatile gsize netsukuku_struct_helper_coordinator_manage_bnode_tunnels_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_struct_helper_coordinator_manage_bnode_tunnels_type_id__volatile)) {
		GType netsukuku_struct_helper_coordinator_manage_bnode_tunnels_type_id;
		netsukuku_struct_helper_coordinator_manage_bnode_tunnels_type_id = g_boxed_type_register_static ("Netsukukustruct_helper_Coordinator_manage_bnode_tunnels", (GBoxedCopyFunc) netsukuku_struct_helper_coordinator_manage_bnode_tunnels_dup, (GBoxedFreeFunc) netsukuku_struct_helper_coordinator_manage_bnode_tunnels_free);
		g_once_init_leave (&netsukuku_struct_helper_coordinator_manage_bnode_tunnels_type_id__volatile, netsukuku_struct_helper_coordinator_manage_bnode_tunnels_type_id);
	}
	return netsukuku_struct_helper_coordinator_manage_bnode_tunnels_type_id__volatile;
}


void netsukuku_struct_helper_coordinator_forward_knowledge_copy (const Netsukukustruct_helper_Coordinator_forward_knowledge* self, Netsukukustruct_helper_Coordinator_forward_knowledge* dest) {
	NetsukukuCoordinator* _tmp0_;
	NetsukukuCoordinator* _tmp1_;
	_tmp0_ = (*self).self;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 ((*dest).self);
	(*dest).self = _tmp1_;
}


void netsukuku_struct_helper_coordinator_forward_knowledge_destroy (Netsukukustruct_helper_Coordinator_forward_knowledge* self) {
	_g_object_unref0 ((*self).self);
}


Netsukukustruct_helper_Coordinator_forward_knowledge* netsukuku_struct_helper_coordinator_forward_knowledge_dup (const Netsukukustruct_helper_Coordinator_forward_knowledge* self) {
	Netsukukustruct_helper_Coordinator_forward_knowledge* dup;
	dup = g_new0 (Netsukukustruct_helper_Coordinator_forward_knowledge, 1);
	netsukuku_struct_helper_coordinator_forward_knowledge_copy (self, dup);
	return dup;
}


void netsukuku_struct_helper_coordinator_forward_knowledge_free (Netsukukustruct_helper_Coordinator_forward_knowledge* self) {
	netsukuku_struct_helper_coordinator_forward_knowledge_destroy (self);
	g_free (self);
}


GType netsukuku_struct_helper_coordinator_forward_knowledge_get_type (void) {
	static volatile gsize netsukuku_struct_helper_coordinator_forward_knowledge_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_struct_helper_coordinator_forward_knowledge_type_id__volatile)) {
		GType netsukuku_struct_helper_coordinator_forward_knowledge_type_id;
		netsukuku_struct_helper_coordinator_forward_knowledge_type_id = g_boxed_type_register_static ("Netsukukustruct_helper_Coordinator_forward_knowledge", (GBoxedCopyFunc) netsukuku_struct_helper_coordinator_forward_knowledge_dup, (GBoxedFreeFunc) netsukuku_struct_helper_coordinator_forward_knowledge_free);
		g_once_init_leave (&netsukuku_struct_helper_coordinator_forward_knowledge_type_id__volatile, netsukuku_struct_helper_coordinator_forward_knowledge_type_id);
	}
	return netsukuku_struct_helper_coordinator_forward_knowledge_type_id__volatile;
}


void netsukuku_struct_helper_coordinator_forward_knowledge_to_nip_copy (const Netsukukustruct_helper_Coordinator_forward_knowledge_to_nip* self, Netsukukustruct_helper_Coordinator_forward_knowledge_to_nip* dest) {
	NetsukukuCoordinator* _tmp0_;
	NetsukukuCoordinator* _tmp1_;
	NetsukukuNIP* _tmp2_;
	NetsukukuNIP* _tmp3_;
	_tmp0_ = (*self).self;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 ((*dest).self);
	(*dest).self = _tmp1_;
	_tmp2_ = (*self).nip;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 ((*dest).nip);
	(*dest).nip = _tmp3_;
}


void netsukuku_struct_helper_coordinator_forward_knowledge_to_nip_destroy (Netsukukustruct_helper_Coordinator_forward_knowledge_to_nip* self) {
	_g_object_unref0 ((*self).self);
	_g_object_unref0 ((*self).nip);
}


Netsukukustruct_helper_Coordinator_forward_knowledge_to_nip* netsukuku_struct_helper_coordinator_forward_knowledge_to_nip_dup (const Netsukukustruct_helper_Coordinator_forward_knowledge_to_nip* self) {
	Netsukukustruct_helper_Coordinator_forward_knowledge_to_nip* dup;
	dup = g_new0 (Netsukukustruct_helper_Coordinator_forward_knowledge_to_nip, 1);
	netsukuku_struct_helper_coordinator_forward_knowledge_to_nip_copy (self, dup);
	return dup;
}


void netsukuku_struct_helper_coordinator_forward_knowledge_to_nip_free (Netsukukustruct_helper_Coordinator_forward_knowledge_to_nip* self) {
	netsukuku_struct_helper_coordinator_forward_knowledge_to_nip_destroy (self);
	g_free (self);
}


GType netsukuku_struct_helper_coordinator_forward_knowledge_to_nip_get_type (void) {
	static volatile gsize netsukuku_struct_helper_coordinator_forward_knowledge_to_nip_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_struct_helper_coordinator_forward_knowledge_to_nip_type_id__volatile)) {
		GType netsukuku_struct_helper_coordinator_forward_knowledge_to_nip_type_id;
		netsukuku_struct_helper_coordinator_forward_knowledge_to_nip_type_id = g_boxed_type_register_static ("Netsukukustruct_helper_Coordinator_forward_knowledge_to_nip", (GBoxedCopyFunc) netsukuku_struct_helper_coordinator_forward_knowledge_to_nip_dup, (GBoxedFreeFunc) netsukuku_struct_helper_coordinator_forward_knowledge_to_nip_free);
		g_once_init_leave (&netsukuku_struct_helper_coordinator_forward_knowledge_to_nip_type_id__volatile, netsukuku_struct_helper_coordinator_forward_knowledge_to_nip_type_id);
	}
	return netsukuku_struct_helper_coordinator_forward_knowledge_to_nip_type_id__volatile;
}


void netsukuku_struct_helper_coordinator_forward_free_copy (const Netsukukustruct_helper_Coordinator_forward_free* self, Netsukukustruct_helper_Coordinator_forward_free* dest) {
	NetsukukuCoordinator* _tmp0_;
	NetsukukuCoordinator* _tmp1_;
	gint _tmp2_;
	_tmp0_ = (*self).self;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 ((*dest).self);
	(*dest).self = _tmp1_;
	_tmp2_ = (*self).pos;
	(*dest).pos = _tmp2_;
}


void netsukuku_struct_helper_coordinator_forward_free_destroy (Netsukukustruct_helper_Coordinator_forward_free* self) {
	_g_object_unref0 ((*self).self);
}


Netsukukustruct_helper_Coordinator_forward_free* netsukuku_struct_helper_coordinator_forward_free_dup (const Netsukukustruct_helper_Coordinator_forward_free* self) {
	Netsukukustruct_helper_Coordinator_forward_free* dup;
	dup = g_new0 (Netsukukustruct_helper_Coordinator_forward_free, 1);
	netsukuku_struct_helper_coordinator_forward_free_copy (self, dup);
	return dup;
}


void netsukuku_struct_helper_coordinator_forward_free_free (Netsukukustruct_helper_Coordinator_forward_free* self) {
	netsukuku_struct_helper_coordinator_forward_free_destroy (self);
	g_free (self);
}


GType netsukuku_struct_helper_coordinator_forward_free_get_type (void) {
	static volatile gsize netsukuku_struct_helper_coordinator_forward_free_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_struct_helper_coordinator_forward_free_type_id__volatile)) {
		GType netsukuku_struct_helper_coordinator_forward_free_type_id;
		netsukuku_struct_helper_coordinator_forward_free_type_id = g_boxed_type_register_static ("Netsukukustruct_helper_Coordinator_forward_free", (GBoxedCopyFunc) netsukuku_struct_helper_coordinator_forward_free_dup, (GBoxedFreeFunc) netsukuku_struct_helper_coordinator_forward_free_free);
		g_once_init_leave (&netsukuku_struct_helper_coordinator_forward_free_type_id__volatile, netsukuku_struct_helper_coordinator_forward_free_type_id);
	}
	return netsukuku_struct_helper_coordinator_forward_free_type_id__volatile;
}


void netsukuku_struct_helper_coordinator_forward_free_to_nip_copy (const Netsukukustruct_helper_Coordinator_forward_free_to_nip* self, Netsukukustruct_helper_Coordinator_forward_free_to_nip* dest) {
	NetsukukuCoordinator* _tmp0_;
	NetsukukuCoordinator* _tmp1_;
	NetsukukuNIP* _tmp2_;
	NetsukukuNIP* _tmp3_;
	gint _tmp4_;
	_tmp0_ = (*self).self;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 ((*dest).self);
	(*dest).self = _tmp1_;
	_tmp2_ = (*self).to_nip;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 ((*dest).to_nip);
	(*dest).to_nip = _tmp3_;
	_tmp4_ = (*self).pos;
	(*dest).pos = _tmp4_;
}


void netsukuku_struct_helper_coordinator_forward_free_to_nip_destroy (Netsukukustruct_helper_Coordinator_forward_free_to_nip* self) {
	_g_object_unref0 ((*self).self);
	_g_object_unref0 ((*self).to_nip);
}


Netsukukustruct_helper_Coordinator_forward_free_to_nip* netsukuku_struct_helper_coordinator_forward_free_to_nip_dup (const Netsukukustruct_helper_Coordinator_forward_free_to_nip* self) {
	Netsukukustruct_helper_Coordinator_forward_free_to_nip* dup;
	dup = g_new0 (Netsukukustruct_helper_Coordinator_forward_free_to_nip, 1);
	netsukuku_struct_helper_coordinator_forward_free_to_nip_copy (self, dup);
	return dup;
}


void netsukuku_struct_helper_coordinator_forward_free_to_nip_free (Netsukukustruct_helper_Coordinator_forward_free_to_nip* self) {
	netsukuku_struct_helper_coordinator_forward_free_to_nip_destroy (self);
	g_free (self);
}


GType netsukuku_struct_helper_coordinator_forward_free_to_nip_get_type (void) {
	static volatile gsize netsukuku_struct_helper_coordinator_forward_free_to_nip_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_struct_helper_coordinator_forward_free_to_nip_type_id__volatile)) {
		GType netsukuku_struct_helper_coordinator_forward_free_to_nip_type_id;
		netsukuku_struct_helper_coordinator_forward_free_to_nip_type_id = g_boxed_type_register_static ("Netsukukustruct_helper_Coordinator_forward_free_to_nip", (GBoxedCopyFunc) netsukuku_struct_helper_coordinator_forward_free_to_nip_dup, (GBoxedFreeFunc) netsukuku_struct_helper_coordinator_forward_free_to_nip_free);
		g_once_init_leave (&netsukuku_struct_helper_coordinator_forward_free_to_nip_type_id__volatile, netsukuku_struct_helper_coordinator_forward_free_to_nip_type_id);
	}
	return netsukuku_struct_helper_coordinator_forward_free_to_nip_type_id__volatile;
}


NetsukukuCoordinator* netsukuku_coordinator_construct (GType object_type, NetsukukuPartialNIP* gnode, NetsukukuCoord* parent) {
	NetsukukuCoordinator * self = NULL;
	NetsukukuPartialNIP* _tmp0_;
	NetsukukuCoord* _tmp1_;
	NetsukukuCoord* _tmp2_;
	NetsukukuMapRoute* _tmp3_;
	NetsukukuPartialNIP* _tmp4_;
	gint _tmp5_ = 0;
	gint _tmp6_;
	NetsukukuPartialNIP* _tmp7_;
	NetsukukuBookings* _tmp8_;
	NetsukukuPartialNIP* _tmp9_;
	NetsukukuBnodeList* _tmp10_;
	gint _tmp11_;
	NetsukukuMapRoute* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	g_return_val_if_fail (gnode != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	self = (NetsukukuCoordinator*) g_object_new (object_type, NULL);
	_tmp0_ = gnode;
	netsukuku_coordinator_set_gnode (self, _tmp0_);
	_tmp1_ = parent;
	self->priv->parent = _tmp1_;
	_tmp2_ = parent;
	_tmp3_ = ((NetsukukuPeerToPeer*) _tmp2_)->maproute;
	self->priv->maproute = _tmp3_;
	_tmp4_ = gnode;
	_tmp5_ = netsukuku_partial_nip_level_of_gnode (_tmp4_);
	self->priv->level_of_gnode = _tmp5_;
	_tmp6_ = self->priv->level_of_gnode;
	self->priv->level_of_nodes = _tmp6_ - 1;
	_tmp7_ = gnode;
	_tmp8_ = netsukuku_bookings_new (_tmp7_);
	_g_object_unref0 (self->priv->bookings);
	self->priv->bookings = _tmp8_;
	_tmp9_ = gnode;
	_tmp10_ = netsukuku_bnode_list_new (_tmp9_);
	_g_object_unref0 (self->priv->bnode_list);
	self->priv->bnode_list = _tmp10_;
	self->last_assigned_elderliness = 0;
	self->priv->_is_main_previous_state = FALSE;
	self->priv->_is_main_latest_evaluation = FALSE;
	_g_object_unref0 (self->priv->manage_bnode_tunnels_handle);
	self->priv->manage_bnode_tunnels_handle = NULL;
	_tmp11_ = self->priv->level_of_gnode;
	_tmp12_ = self->priv->maproute;
	_tmp13_ = netsukuku_map_get_levels ((NetsukukuMap*) _tmp12_);
	_tmp14_ = _tmp13_;
	if (_tmp11_ != _tmp14_) {
		netsukuku_coordinator_manage_bnode_tunnels (self);
	}
	return self;
}


NetsukukuCoordinator* netsukuku_coordinator_new (NetsukukuPartialNIP* gnode, NetsukukuCoord* parent) {
	return netsukuku_coordinator_construct (NETSUKUKU_TYPE_COORDINATOR, gnode, parent);
}


void netsukuku_coordinator_stop_operations (NetsukukuCoordinator* self) {
	TaskletsTasklet* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->manage_bnode_tunnels_handle;
	if (_tmp0_ != NULL) {
		TaskletsTasklet* _tmp1_;
		_tmp1_ = self->priv->manage_bnode_tunnels_handle;
		tasklets_tasklet_abort (_tmp1_);
		_g_object_unref0 (self->priv->manage_bnode_tunnels_handle);
		self->priv->manage_bnode_tunnels_handle = NULL;
	}
}


NetsukukuCoordinatorKnowledge* netsukuku_coordinator_report_status (NetsukukuCoordinator* self) {
	NetsukukuCoordinatorKnowledge* result = NULL;
	NetsukukuPartialNIP* _tmp0_;
	NetsukukuBookings* _tmp1_;
	gint _tmp2_;
	NetsukukuBnodeList* _tmp3_;
	NetsukukuCoordinatorKnowledge* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_gnode;
	_tmp1_ = self->priv->bookings;
	_tmp2_ = self->last_assigned_elderliness;
	_tmp3_ = self->priv->bnode_list;
	_tmp4_ = netsukuku_coordinator_knowledge_new (_tmp0_, _tmp1_, _tmp2_, _tmp3_);
	result = _tmp4_;
	return result;
}


void netsukuku_coordinator_map_has_changed (NetsukukuCoordinator* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		gboolean _tmp0_;
		NetsukukuCoord_hkey* _tmp1_;
		NetsukukuCoord_hkey* key;
		gint _tmp2_;
		NetsukukuMapRoute* _tmp3_;
		NetsukukuNIP* _tmp4_;
		NetsukukuNIP* _tmp5_;
		NetsukukuNIP* _tmp6_;
		gboolean _tmp7_ = FALSE;
		NetsukukuCoord* _tmp8_;
		NetsukukuCoord* _tmp9_;
		NetsukukuNIP* _tmp10_ = NULL;
		NetsukukuNIP* _tmp11_;
		NetsukukuHCoord* _tmp12_ = NULL;
		NetsukukuHCoord* _tmp13_;
		NetsukukuHCoord* _tmp14_;
		NetsukukuHCoord* _tmp15_;
		gboolean _tmp16_;
		gboolean _tmp19_;
		_tmp0_ = self->priv->_is_main_latest_evaluation;
		self->priv->_is_main_previous_state = _tmp0_;
		_tmp1_ = netsukuku_coord_hkey_new ();
		key = _tmp1_;
		_tmp2_ = self->priv->level_of_gnode;
		key->level_of_gnode = _tmp2_;
		_tmp3_ = self->priv->maproute;
		_tmp4_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = _g_object_ref0 (_tmp5_);
		_g_object_unref0 (key->nip);
		key->nip = _tmp6_;
		_tmp8_ = self->priv->parent;
		_tmp9_ = self->priv->parent;
		_tmp10_ = netsukuku_peer_to_peer_h ((NetsukukuPeerToPeer*) _tmp9_, (GObject*) key);
		_tmp11_ = _tmp10_;
		_tmp12_ = netsukuku_peer_to_peer_search_participant ((NetsukukuPeerToPeer*) _tmp8_, _tmp11_, 1, &_inner_error_);
		_tmp13_ = _tmp12_;
		_g_object_unref0 (_tmp11_);
		_tmp14_ = _tmp13_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (key);
			if (_inner_error_->domain == NETSUKUKU_PEER_TO_PEER_ERROR) {
				goto __catch34_netsukuku_peer_to_peer_error;
			}
			_g_object_unref0 (key);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp15_ = _tmp14_;
		_tmp16_ = _tmp15_ == NULL;
		_g_object_unref0 (_tmp15_);
		if (_tmp16_) {
			NetsukukuCoord* _tmp17_;
			gboolean _tmp18_;
			_tmp17_ = self->priv->parent;
			_tmp18_ = ((NetsukukuPeerToPeer*) _tmp17_)->has_valid_map;
			_tmp7_ = _tmp18_;
		} else {
			_tmp7_ = FALSE;
		}
		_tmp19_ = _tmp7_;
		self->priv->_is_main_latest_evaluation = _tmp19_;
		_g_object_unref0 (key);
	}
	goto __finally34;
	__catch34_netsukuku_peer_to_peer_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		netsukuku_log_error ("Coordinator.map_has_changed: no participants in Coord service.");
		_g_error_free0 (e);
	}
	__finally34:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


/** A node wants to become a member of our gnode.
          * If possible, we add the reservation and return the HookReservation,
          * else, we return None.
          */
static gint* _int_dup (gint* self) {
	gint* dup;
	dup = g_new0 (gint, 1);
	memcpy (dup, self, sizeof (gint));
	return dup;
}


static gpointer __int_dup0 (gpointer self) {
	return self ? _int_dup (self) : NULL;
}


static NetsukukuGNodeID** _vala_array_dup2 (NetsukukuGNodeID** self, int length) {
	NetsukukuGNodeID** result;
	int i;
	result = g_new0 (NetsukukuGNodeID*, length + 1);
	for (i = 0; i < length; i++) {
		NetsukukuGNodeID* _tmp0_;
		_tmp0_ = _g_object_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


NetsukukuHookReservation* netsukuku_coordinator_reserve (NetsukukuCoordinator* self) {
	NetsukukuHookReservation* result = NULL;
	NetsukukuMapRoute* _tmp0_;
	gint _tmp1_;
	gint _tmp2_ = 0;
	gint* _tmp3_ = NULL;
	gint* _fnl;
	gint _fnl_length1;
	gint __fnl_size_;
	GeeArrayList* _tmp4_;
	GeeArrayList* fnl;
	gint* _tmp5_;
	gint _tmp5__length1;
	GeeArrayList* _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	GeeArrayList* _tmp14_;
	GeeArrayList* _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	gint32 _tmp18_ = 0;
	gpointer _tmp19_ = NULL;
	gint pos;
	NetsukukuBookings* _tmp20_;
	gint _tmp21_;
	GeeArrayList* _tmp22_;
	GeeArrayList* pool;
	GeeArrayList* _tmp42_;
	NetsukukuMapRoute* _tmp43_;
	gint _tmp44_ = 0;
	NetsukukuGNodeID** _tmp45_ = NULL;
	NetsukukuGNodeID** _tmp46_;
	gint _tmp46__length1;
	gint _tmp47_;
	NetsukukuGNodeID* _tmp48_;
	gint _tmp49_;
	gint _tmp50_;
	GeeArrayList* _tmp51_;
	gint _tmp52_;
	gint* max_pool;
	gint* _tmp71_;
	gint new_elderliness;
	gint _tmp72_;
	NetsukukuMapRoute* _tmp73_;
	gint _tmp74_;
	gint _tmp75_ = 0;
	NetsukukuGNodeID** _tmp76_ = NULL;
	NetsukukuGNodeID** gids;
	gint gids_length1;
	gint _gids_size_;
	NetsukukuCoordinatorKnowledgeSet* _tmp77_;
	NetsukukuCoordinatorKnowledgeSet* coordinator_knowledge_set;
	NetsukukuHookReservation* _tmp137_;
	NetsukukuHookReservation* ret;
	NetsukukuHookReservation* _tmp138_;
	NetsukukuPartialNIP* _tmp139_;
	NetsukukuPartialNIP* _tmp140_;
	NetsukukuHookReservation* _tmp141_;
	gint _tmp142_;
	NetsukukuHookReservation* _tmp143_;
	gint _tmp144_;
	NetsukukuHookReservation* _tmp145_;
	NetsukukuGNodeID** _tmp146_;
	gint _tmp146__length1;
	NetsukukuGNodeID** _tmp147_;
	gint _tmp147__length1;
	NetsukukuHookReservation* _tmp148_;
	NetsukukuCoordinatorKnowledgeSet* _tmp149_;
	NetsukukuCoordinatorKnowledgeSet* _tmp150_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->maproute;
	_tmp1_ = self->priv->level_of_nodes;
	_tmp3_ = netsukuku_map_free_nodes_list ((NetsukukuMap*) _tmp0_, _tmp1_, &_tmp2_);
	_fnl = _tmp3_;
	_fnl_length1 = _tmp2_;
	__fnl_size_ = _fnl_length1;
	_tmp4_ = gee_array_list_new (G_TYPE_INT, NULL, NULL, NULL, NULL, NULL);
	fnl = _tmp4_;
	_tmp5_ = _fnl;
	_tmp5__length1 = _fnl_length1;
	{
		gint* i_collection = NULL;
		gint i_collection_length1 = 0;
		gint _i_collection_size_ = 0;
		gint i_it = 0;
		i_collection = _tmp5_;
		i_collection_length1 = _tmp5__length1;
		for (i_it = 0; i_it < _tmp5__length1; i_it = i_it + 1) {
			gint i = 0;
			i = i_collection[i_it];
			{
				NetsukukuBookings* _tmp6_;
				gint _tmp7_;
				gboolean _tmp8_ = FALSE;
				_tmp6_ = self->priv->bookings;
				_tmp7_ = i;
				_tmp8_ = netsukuku_bookings_is_booked (_tmp6_, _tmp7_);
				if (!_tmp8_) {
					GeeArrayList* _tmp9_;
					gint _tmp10_;
					_tmp9_ = fnl;
					_tmp10_ = i;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp9_, (gpointer) ((gintptr) _tmp10_));
				}
			}
		}
	}
	_tmp11_ = fnl;
	_tmp12_ = gee_collection_get_is_empty ((GeeCollection*) _tmp11_);
	_tmp13_ = _tmp12_;
	if (_tmp13_) {
		result = NULL;
		_g_object_unref0 (fnl);
		_fnl = (g_free (_fnl), NULL);
		return result;
	}
	_tmp14_ = fnl;
	_tmp15_ = fnl;
	_tmp16_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = g_random_int_range ((gint32) 0, (gint32) _tmp17_);
	_tmp19_ = gee_abstract_list_get ((GeeAbstractList*) _tmp14_, (gint) _tmp18_);
	pos = (gint) ((gintptr) _tmp19_);
	_tmp20_ = self->priv->bookings;
	_tmp21_ = pos;
	netsukuku_bookings_new_book (_tmp20_, _tmp21_);
	_tmp22_ = gee_array_list_new (G_TYPE_INT, NULL, NULL, NULL, NULL, NULL);
	pool = _tmp22_;
	{
		gint pos2;
		pos2 = 0;
		{
			gboolean _tmp23_;
			_tmp23_ = TRUE;
			while (TRUE) {
				gboolean _tmp24_;
				gint _tmp26_;
				NetsukukuMapRoute* _tmp27_;
				gint _tmp28_;
				gint _tmp29_;
				NetsukukuMapRoute* _tmp30_;
				gint _tmp31_;
				gint _tmp32_;
				gpointer _tmp33_ = NULL;
				NetsukukuRouteNode* node;
				NetsukukuRouteNode* _tmp34_;
				gboolean _tmp35_ = FALSE;
				_tmp24_ = _tmp23_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = pos2;
					pos2 = _tmp25_ + 1;
				}
				_tmp23_ = FALSE;
				_tmp26_ = pos2;
				_tmp27_ = self->priv->maproute;
				_tmp28_ = netsukuku_map_get_gsize ((NetsukukuMap*) _tmp27_);
				_tmp29_ = _tmp28_;
				if (!(_tmp26_ < _tmp29_)) {
					break;
				}
				_tmp30_ = self->priv->maproute;
				_tmp31_ = self->priv->level_of_nodes;
				_tmp32_ = pos2;
				_tmp33_ = netsukuku_map_node_get ((NetsukukuMap*) _tmp30_, _tmp31_, _tmp32_);
				node = (NetsukukuRouteNode*) _tmp33_;
				_tmp34_ = node;
				_tmp35_ = netsukuku_route_node_is_empty (_tmp34_);
				if (!_tmp35_) {
					GeeArrayList* _tmp36_;
					NetsukukuRouteNode* _tmp37_;
					NetsukukuGNodeID* _tmp38_ = NULL;
					NetsukukuGNodeID* _tmp39_;
					gint _tmp40_;
					gint _tmp41_;
					_tmp36_ = pool;
					_tmp37_ = node;
					_tmp38_ = netsukuku_route_node_get_eldest_gid (_tmp37_);
					_tmp39_ = _tmp38_;
					_tmp40_ = netsukuku_gnode_id_get_elderliness (_tmp39_);
					_tmp41_ = _tmp40_;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp36_, (gpointer) ((gintptr) _tmp41_));
					_g_object_unref0 (_tmp39_);
				}
				_g_object_unref0 (node);
			}
		}
	}
	_tmp42_ = pool;
	_tmp43_ = self->priv->maproute;
	_tmp45_ = netsukuku_map_route_get_gid_list (_tmp43_, &_tmp44_);
	_tmp46_ = _tmp45_;
	_tmp46__length1 = _tmp44_;
	_tmp47_ = self->priv->level_of_nodes;
	_tmp48_ = _tmp46_[_tmp47_];
	_tmp49_ = netsukuku_gnode_id_get_elderliness (_tmp48_);
	_tmp50_ = _tmp49_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp42_, (gpointer) ((gintptr) _tmp50_));
	_tmp46_ = (_vala_array_free (_tmp46_, _tmp46__length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp51_ = pool;
	_tmp52_ = self->last_assigned_elderliness;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp51_, (gpointer) ((gintptr) _tmp52_));
	max_pool = NULL;
	{
		GeeArrayList* _tmp53_;
		GeeArrayList* _tmp54_;
		GeeArrayList* _maybe_max_list;
		GeeArrayList* _tmp55_;
		gint _tmp56_;
		gint _tmp57_;
		gint _maybe_max_size;
		gint _maybe_max_index;
		_tmp53_ = pool;
		_tmp54_ = _g_object_ref0 (_tmp53_);
		_maybe_max_list = _tmp54_;
		_tmp55_ = _maybe_max_list;
		_tmp56_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp55_);
		_tmp57_ = _tmp56_;
		_maybe_max_size = _tmp57_;
		_maybe_max_index = -1;
		while (TRUE) {
			gint _tmp58_;
			gint _tmp59_;
			gint _tmp60_;
			GeeArrayList* _tmp61_;
			gint _tmp62_;
			gpointer _tmp63_ = NULL;
			gint maybe_max;
			gint* _tmp64_;
			_tmp58_ = _maybe_max_index;
			_maybe_max_index = _tmp58_ + 1;
			_tmp59_ = _maybe_max_index;
			_tmp60_ = _maybe_max_size;
			if (!(_tmp59_ < _tmp60_)) {
				break;
			}
			_tmp61_ = _maybe_max_list;
			_tmp62_ = _maybe_max_index;
			_tmp63_ = gee_abstract_list_get ((GeeAbstractList*) _tmp61_, _tmp62_);
			maybe_max = (gint) ((gintptr) _tmp63_);
			_tmp64_ = max_pool;
			if (_tmp64_ == NULL) {
				gint _tmp65_;
				gint* _tmp66_;
				_tmp65_ = maybe_max;
				_tmp66_ = __int_dup0 (&_tmp65_);
				_g_free0 (max_pool);
				max_pool = _tmp66_;
			} else {
				gint* _tmp67_;
				gint _tmp68_;
				_tmp67_ = max_pool;
				_tmp68_ = maybe_max;
				if ((*_tmp67_) < _tmp68_) {
					gint _tmp69_;
					gint* _tmp70_;
					_tmp69_ = maybe_max;
					_tmp70_ = __int_dup0 (&_tmp69_);
					_g_free0 (max_pool);
					max_pool = _tmp70_;
				}
			}
		}
		_g_object_unref0 (_maybe_max_list);
	}
	_tmp71_ = max_pool;
	new_elderliness = (*_tmp71_) + 1;
	_tmp72_ = new_elderliness;
	self->last_assigned_elderliness = _tmp72_;
	_tmp73_ = self->priv->maproute;
	_tmp74_ = self->priv->level_of_gnode;
	_tmp76_ = netsukuku_map_route_get_gid_uppermost_list (_tmp73_, _tmp74_, &_tmp75_);
	gids = _tmp76_;
	gids_length1 = _tmp75_;
	_gids_size_ = gids_length1;
	netsukuku_coordinator_forward_knowledge (self);
	_tmp77_ = netsukuku_coordinator_knowledge_set_new ();
	coordinator_knowledge_set = _tmp77_;
	{
		gint _tmp78_;
		gint _level_of_nodes;
		_tmp78_ = self->priv->level_of_nodes;
		_level_of_nodes = _tmp78_;
		{
			gboolean _tmp79_;
			_tmp79_ = TRUE;
			while (TRUE) {
				gboolean _tmp80_;
				gint _tmp82_;
				NetsukukuMapRoute* _tmp83_;
				gint _tmp84_;
				gint _tmp85_;
				gint _tmp86_;
				gint _level_of_gnode;
				NetsukukuCoord* _tmp87_;
				gint _tmp88_;
				NetsukukuPartialNIP* _tmp89_ = NULL;
				NetsukukuPartialNIP* _gnode;
				NetsukukuPartialNIP* _tmp90_;
				NetsukukuBookings* _tmp91_;
				NetsukukuBookings* _bookings;
				NetsukukuCoord* _tmp117_;
				gint _tmp118_;
				NetsukukuCoordinator* _tmp119_ = NULL;
				NetsukukuCoordinator* _tmp120_;
				gint _tmp121_;
				gint _tmp122_;
				gint _last_assigned_elderliness;
				NetsukukuCoord* _tmp123_;
				gint _tmp124_;
				NetsukukuCoordinator* _tmp125_ = NULL;
				NetsukukuCoordinator* _tmp126_;
				NetsukukuBnodeList* _tmp127_ = NULL;
				NetsukukuBnodeList* _tmp128_;
				NetsukukuBnodeList* _bnode_list;
				NetsukukuCoordinatorKnowledgeSet* _tmp129_;
				NetsukukuPartialNIP* _tmp130_;
				NetsukukuPartialNIP* _tmp131_;
				NetsukukuBookings* _tmp132_;
				gint _tmp133_;
				NetsukukuBnodeList* _tmp134_;
				NetsukukuCoordinatorKnowledge* _tmp135_;
				NetsukukuCoordinatorKnowledge* _tmp136_;
				_tmp80_ = _tmp79_;
				if (!_tmp80_) {
					gint _tmp81_;
					_tmp81_ = _level_of_nodes;
					_level_of_nodes = _tmp81_ + 1;
				}
				_tmp79_ = FALSE;
				_tmp82_ = _level_of_nodes;
				_tmp83_ = self->priv->maproute;
				_tmp84_ = netsukuku_map_get_levels ((NetsukukuMap*) _tmp83_);
				_tmp85_ = _tmp84_;
				if (!(_tmp82_ < _tmp85_)) {
					break;
				}
				_tmp86_ = _level_of_nodes;
				_level_of_gnode = _tmp86_ + 1;
				_tmp87_ = self->priv->parent;
				_tmp88_ = _level_of_gnode;
				_tmp89_ = netsukuku_coord_get_my_gnode_at_level (_tmp87_, _tmp88_);
				_gnode = _tmp89_;
				_tmp90_ = _gnode;
				_tmp91_ = netsukuku_bookings_new (_tmp90_);
				_bookings = _tmp91_;
				{
					gint pos2;
					pos2 = 0;
					{
						gboolean _tmp92_;
						_tmp92_ = TRUE;
						while (TRUE) {
							gboolean _tmp93_;
							gint _tmp95_;
							NetsukukuMapRoute* _tmp96_;
							gint _tmp97_;
							gint _tmp98_;
							gboolean _tmp99_ = FALSE;
							NetsukukuMapRoute* _tmp100_;
							gint _tmp101_;
							gint _tmp102_;
							gpointer _tmp103_ = NULL;
							NetsukukuRouteNode* _tmp104_;
							gboolean _tmp105_ = FALSE;
							gboolean _tmp106_;
							gboolean _tmp114_;
							_tmp93_ = _tmp92_;
							if (!_tmp93_) {
								gint _tmp94_;
								_tmp94_ = pos2;
								pos2 = _tmp94_ + 1;
							}
							_tmp92_ = FALSE;
							_tmp95_ = pos2;
							_tmp96_ = self->priv->maproute;
							_tmp97_ = netsukuku_map_get_gsize ((NetsukukuMap*) _tmp96_);
							_tmp98_ = _tmp97_;
							if (!(_tmp95_ < _tmp98_)) {
								break;
							}
							_tmp100_ = self->priv->maproute;
							_tmp101_ = _level_of_nodes;
							_tmp102_ = pos2;
							_tmp103_ = netsukuku_map_node_get ((NetsukukuMap*) _tmp100_, _tmp101_, _tmp102_);
							_tmp104_ = (NetsukukuRouteNode*) _tmp103_;
							_tmp105_ = netsukuku_dataclass_is_free ((NetsukukuDataClass*) _tmp104_);
							_tmp106_ = !_tmp105_;
							_g_object_unref0 (_tmp104_);
							if (_tmp106_) {
								_tmp99_ = TRUE;
							} else {
								NetsukukuCoord* _tmp107_;
								gint _tmp108_;
								NetsukukuCoordinator* _tmp109_ = NULL;
								NetsukukuCoordinator* _tmp110_;
								NetsukukuBookings* _tmp111_;
								gint _tmp112_;
								gboolean _tmp113_ = FALSE;
								_tmp107_ = self->priv->parent;
								_tmp108_ = _level_of_gnode;
								_tmp109_ = netsukuku_coord_get_coordinator_for_gnode_at_level (_tmp107_, _tmp108_);
								_tmp110_ = _tmp109_;
								_tmp111_ = _tmp110_->priv->bookings;
								_tmp112_ = pos2;
								_tmp113_ = netsukuku_bookings_is_booked (_tmp111_, _tmp112_);
								_tmp99_ = _tmp113_;
								_g_object_unref0 (_tmp110_);
							}
							_tmp114_ = _tmp99_;
							if (_tmp114_) {
								NetsukukuBookings* _tmp115_;
								gint _tmp116_;
								_tmp115_ = _bookings;
								_tmp116_ = pos2;
								netsukuku_bookings_new_book (_tmp115_, _tmp116_);
							}
						}
					}
				}
				_tmp117_ = self->priv->parent;
				_tmp118_ = _level_of_gnode;
				_tmp119_ = netsukuku_coord_get_coordinator_for_gnode_at_level (_tmp117_, _tmp118_);
				_tmp120_ = _tmp119_;
				_tmp121_ = _tmp120_->last_assigned_elderliness;
				_tmp122_ = _tmp121_;
				_g_object_unref0 (_tmp120_);
				_last_assigned_elderliness = _tmp122_;
				_tmp123_ = self->priv->parent;
				_tmp124_ = _level_of_gnode;
				_tmp125_ = netsukuku_coord_get_coordinator_for_gnode_at_level (_tmp123_, _tmp124_);
				_tmp126_ = _tmp125_;
				_tmp127_ = netsukuku_coordinator_get_bnode_list (_tmp126_);
				_tmp128_ = _tmp127_;
				_g_object_unref0 (_tmp126_);
				_bnode_list = _tmp128_;
				_tmp129_ = coordinator_knowledge_set;
				_tmp130_ = _gnode;
				_tmp131_ = _gnode;
				_tmp132_ = _bookings;
				_tmp133_ = _last_assigned_elderliness;
				_tmp134_ = _bnode_list;
				_tmp135_ = netsukuku_coordinator_knowledge_new (_tmp131_, _tmp132_, _tmp133_, _tmp134_);
				_tmp136_ = _tmp135_;
				netsukuku_coordinator_knowledge_set_dict_set (_tmp129_, _tmp130_, _tmp136_);
				_g_object_unref0 (_tmp136_);
				_g_object_unref0 (_bnode_list);
				_g_object_unref0 (_bookings);
				_g_object_unref0 (_gnode);
			}
		}
	}
	_tmp137_ = netsukuku_hook_reservation_new ();
	ret = _tmp137_;
	_tmp138_ = ret;
	_tmp139_ = self->priv->_gnode;
	_tmp140_ = _g_object_ref0 (_tmp139_);
	_g_object_unref0 (_tmp138_->gnode);
	_tmp138_->gnode = _tmp140_;
	_tmp141_ = ret;
	_tmp142_ = pos;
	_tmp141_->pos = _tmp142_;
	_tmp143_ = ret;
	_tmp144_ = new_elderliness;
	_tmp143_->elderliness = _tmp144_;
	_tmp145_ = ret;
	_tmp146_ = gids;
	_tmp146__length1 = gids_length1;
	_tmp147_ = (_tmp146_ != NULL) ? _vala_array_dup2 (_tmp146_, _tmp146__length1) : ((gpointer) _tmp146_);
	_tmp147__length1 = _tmp146__length1;
	_tmp145_->gids = (_vala_array_free (_tmp145_->gids, _tmp145_->gids_length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp145_->gids = _tmp147_;
	_tmp145_->gids_length1 = _tmp147__length1;
	_tmp148_ = ret;
	_tmp149_ = coordinator_knowledge_set;
	_tmp150_ = _g_object_ref0 (_tmp149_);
	_g_object_unref0 (_tmp148_->coordinator_knowledge_set);
	_tmp148_->coordinator_knowledge_set = _tmp150_;
	result = ret;
	_g_object_unref0 (coordinator_knowledge_set);
	gids = (_vala_array_free (gids, gids_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_free0 (max_pool);
	_g_object_unref0 (pool);
	_g_object_unref0 (fnl);
	_fnl = (g_free (_fnl), NULL);
	return result;
}


void netsukuku_coordinator_free (NetsukukuCoordinator* self, gint pos) {
	gint _tmp0_;
	gint _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = pos;
	netsukuku_coordinator_force_remove (self, _tmp0_);
	_tmp1_ = pos;
	netsukuku_coordinator_forward_free (self, _tmp1_);
}


static void _vala_array_add3 (NetsukukuNIP*** array, int* length, int* size, NetsukukuNIP* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (NetsukukuNIP*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void netsukuku_coordinator_impl_forward_free (NetsukukuCoordinator* self, gint pos, GError** error) {
	NetsukukuCoord_hkey* _tmp0_;
	NetsukukuCoord_hkey* key;
	gint _tmp1_;
	NetsukukuMapRoute* _tmp2_;
	NetsukukuNIP* _tmp3_;
	NetsukukuNIP* _tmp4_;
	NetsukukuNIP* _tmp5_;
	NetsukukuCoord* _tmp6_;
	NetsukukuNIP* _tmp7_ = NULL;
	NetsukukuNIP* hash_nip;
	NetsukukuCoord* _tmp8_;
	gint _tmp9_;
	GeeList* _tmp10_ = NULL;
	GeeList* bunch;
	NetsukukuNIP** _tmp11_ = NULL;
	NetsukukuNIP** bunch_not_me;
	gint bunch_not_me_length1;
	gint _bunch_not_me_size_;
	NetsukukuNIP** _tmp30_;
	gint _tmp30__length1;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	tasklets_tasklet_declare_self ("Coordinator.forward_free");
	_tmp0_ = netsukuku_coord_hkey_new ();
	key = _tmp0_;
	_tmp1_ = self->priv->level_of_gnode;
	key->level_of_gnode = _tmp1_;
	_tmp2_ = self->priv->maproute;
	_tmp3_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (key->nip);
	key->nip = _tmp5_;
	_tmp6_ = self->priv->parent;
	_tmp7_ = netsukuku_peer_to_peer_h ((NetsukukuPeerToPeer*) _tmp6_, (GObject*) key);
	hash_nip = _tmp7_;
	_tmp8_ = self->priv->parent;
	_tmp9_ = self->priv->level_of_gnode;
	_tmp10_ = netsukuku_peer_to_peer_find_nearest_to_register ((NetsukukuPeerToPeer*) _tmp8_, hash_nip, NETSUKUKU_COORD_DUPLICATION, &_tmp9_, &_inner_error_);
	bunch = _tmp10_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (hash_nip);
		_g_object_unref0 (key);
		return;
	}
	_tmp11_ = g_new0 (NetsukukuNIP*, 0 + 1);
	bunch_not_me = _tmp11_;
	bunch_not_me_length1 = 0;
	_bunch_not_me_size_ = bunch_not_me_length1;
	{
		GeeList* _tmp12_;
		GeeList* _n_list;
		GeeList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _n_size;
		gint _n_index;
		_tmp12_ = _g_object_ref0 (bunch);
		_n_list = _tmp12_;
		_tmp13_ = _n_list;
		_tmp14_ = gee_collection_get_size ((GeeCollection*) _tmp13_);
		_tmp15_ = _tmp14_;
		_n_size = _tmp15_;
		_n_index = -1;
		while (TRUE) {
			gint _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			GeeList* _tmp19_;
			gint _tmp20_;
			gpointer _tmp21_ = NULL;
			NetsukukuNIP* n;
			NetsukukuNIP* _tmp22_;
			NetsukukuMapRoute* _tmp23_;
			NetsukukuNIP* _tmp24_;
			NetsukukuNIP* _tmp25_;
			gboolean _tmp26_ = FALSE;
			_tmp16_ = _n_index;
			_n_index = _tmp16_ + 1;
			_tmp17_ = _n_index;
			_tmp18_ = _n_size;
			if (!(_tmp17_ < _tmp18_)) {
				break;
			}
			_tmp19_ = _n_list;
			_tmp20_ = _n_index;
			_tmp21_ = gee_list_get (_tmp19_, _tmp20_);
			n = (NetsukukuNIP*) _tmp21_;
			_tmp22_ = n;
			_tmp23_ = self->priv->maproute;
			_tmp24_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = netsukuku_partial_nip_is_equal ((NetsukukuPartialNIP*) _tmp22_, (NetsukukuPartialNIP*) _tmp25_);
			if (!_tmp26_) {
				NetsukukuNIP** _tmp27_;
				gint _tmp27__length1;
				NetsukukuNIP* _tmp28_;
				NetsukukuNIP* _tmp29_;
				_tmp27_ = bunch_not_me;
				_tmp27__length1 = bunch_not_me_length1;
				_tmp28_ = n;
				_tmp29_ = _g_object_ref0 (_tmp28_);
				_vala_array_add3 (&bunch_not_me, &bunch_not_me_length1, &_bunch_not_me_size_, _tmp29_);
			}
			_g_object_unref0 (n);
		}
		_g_object_unref0 (_n_list);
	}
	_tmp30_ = bunch_not_me;
	_tmp30__length1 = bunch_not_me_length1;
	{
		NetsukukuNIP** to_nip_collection = NULL;
		gint to_nip_collection_length1 = 0;
		gint _to_nip_collection_size_ = 0;
		gint to_nip_it = 0;
		to_nip_collection = _tmp30_;
		to_nip_collection_length1 = _tmp30__length1;
		for (to_nip_it = 0; to_nip_it < _tmp30__length1; to_nip_it = to_nip_it + 1) {
			NetsukukuNIP* _tmp31_;
			NetsukukuNIP* to_nip = NULL;
			_tmp31_ = _g_object_ref0 (to_nip_collection[to_nip_it]);
			to_nip = _tmp31_;
			{
				NetsukukuNIP* _tmp32_;
				gint _tmp33_;
				_tmp32_ = to_nip;
				_tmp33_ = pos;
				netsukuku_coordinator_forward_free_to_nip (self, _tmp32_, _tmp33_);
				_g_object_unref0 (to_nip);
			}
		}
	}
	bunch_not_me = (_vala_array_free (bunch_not_me, bunch_not_me_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (bunch);
	_g_object_unref0 (hash_nip);
	_g_object_unref0 (key);
}


static void* netsukuku_coordinator_helper_forward_free (void* v, GError** error) {
	void* result = NULL;
	void* _tmp0_;
	Netsukukustruct_helper_Coordinator_forward_free* tuple_p;
	NetsukukuCoordinator* _tmp1_;
	NetsukukuCoordinator* _tmp2_;
	NetsukukuCoordinator* self_save;
	gint _tmp3_;
	gint pos_save;
	GError * _inner_error_ = NULL;
	_tmp0_ = v;
	tuple_p = (Netsukukustruct_helper_Coordinator_forward_free*) _tmp0_;
	_tmp1_ = (*tuple_p).self;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	self_save = _tmp2_;
	_tmp3_ = (*tuple_p).pos;
	pos_save = _tmp3_;
	tasklets_tasklet_schedule_back ();
	netsukuku_coordinator_impl_forward_free (self_save, pos_save, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self_save);
		return NULL;
	}
	result = NULL;
	_g_object_unref0 (self_save);
	return result;
}


/** Communicate to secondary coordinators to free this 'pos'.
          */
void netsukuku_coordinator_forward_free (NetsukukuCoordinator* self, gint pos) {
	Netsukukustruct_helper_Coordinator_forward_free arg = {0};
	NetsukukuCoordinator* _tmp0_;
	gint _tmp1_;
	TaskletsTasklet* _tmp2_ = NULL;
	TaskletsTasklet* _tmp3_;
	g_return_if_fail (self != NULL);
	memset (&arg, 0, sizeof (Netsukukustruct_helper_Coordinator_forward_free));
	_tmp0_ = _g_object_ref0 (self);
	_g_object_unref0 (arg.self);
	arg.self = _tmp0_;
	_tmp1_ = pos;
	arg.pos = _tmp1_;
	_tmp2_ = tasklets_tasklet_spawn ((TaskletsSpawnable) netsukuku_coordinator_helper_forward_free, &arg, FALSE, -1);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp3_);
	netsukuku_struct_helper_coordinator_forward_free_destroy (&arg);
}


static void netsukuku_coordinator_impl_forward_free_to_nip (NetsukukuCoordinator* self, NetsukukuNIP* to_nip, gint pos, GError** error) {
	NetsukukuMapRoute* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	NetsukukuMapRoute* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	NetsukukuNIP* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* dest_addr;
	NetsukukuMapRoute* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	NetsukukuMapRoute* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	NetsukukuMapRoute* _tmp14_;
	NetsukukuNIP* _tmp15_;
	NetsukukuNIP* _tmp16_;
	gchar* _tmp17_ = NULL;
	gchar* my_addr;
	NetsukukuAddressManagerTCPClient* _tmp18_;
	NetsukukuAddressManagerTCPClient* remote;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (to_nip != NULL);
	tasklets_tasklet_declare_self ("Coordinator.forward_free_to_nip");
	_tmp0_ = self->priv->maproute;
	_tmp1_ = netsukuku_map_get_levels ((NetsukukuMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->maproute;
	_tmp4_ = netsukuku_map_get_gsize ((NetsukukuMap*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = to_nip;
	_tmp7_ = netsukuku_nip_to_str (_tmp2_, _tmp5_, _tmp6_);
	dest_addr = _tmp7_;
	_tmp8_ = self->priv->maproute;
	_tmp9_ = netsukuku_map_get_levels ((NetsukukuMap*) _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = self->priv->maproute;
	_tmp12_ = netsukuku_map_get_gsize ((NetsukukuMap*) _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = self->priv->maproute;
	_tmp15_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = netsukuku_nip_to_str (_tmp10_, _tmp13_, _tmp16_);
	my_addr = _tmp17_;
	_tmp18_ = netsukuku_address_manager_tcp_client_new (dest_addr, NULL, my_addr, FALSE);
	remote = _tmp18_;
	{
		NetsukukuICoord* _tmp19_;
		NetsukukuICoord* _tmp20_;
		NetsukukuPartialNIP* _tmp21_;
		gint _tmp22_;
		_tmp19_ = netsukuku_iaddress_manager_root_dispatcher_get_coordnode ((NetsukukuIAddressManagerRootDispatcher*) remote);
		_tmp20_ = _tmp19_;
		_tmp21_ = self->priv->_gnode;
		_tmp22_ = pos;
		netsukuku_icoord_duplicate_free (_tmp20_, _tmp21_, _tmp22_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch35_g_error;
		}
	}
	goto __finally35;
	__catch35_g_error:
	{
		GError* e = NULL;
		gint _tmp23_;
		gchar* _tmp24_ = NULL;
		gchar* _tmp25_;
		const gchar* _tmp26_ = NULL;
		GError* _tmp27_;
		const gchar* _tmp28_;
		const gchar* _tmp29_ = NULL;
		gchar* _tmp30_ = NULL;
		gchar* _tmp31_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp23_ = pos;
		_tmp24_ = g_strdup_printf ("%i", _tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = string_to_string (dest_addr);
		_tmp27_ = e;
		_tmp28_ = _tmp27_->message;
		_tmp29_ = string_to_string (_tmp28_);
		_tmp30_ = g_strconcat ("'Coord: forwarded free ", _tmp25_, " to ", _tmp26_, " got exception ", _tmp29_, NULL);
		_tmp31_ = _tmp30_;
		netsukuku_log_warn (_tmp31_);
		_g_free0 (_tmp31_);
		_g_free0 (_tmp25_);
		_g_error_free0 (e);
	}
	__finally35:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (remote);
		_g_free0 (my_addr);
		_g_free0 (dest_addr);
		return;
	}
	_g_object_unref0 (remote);
	_g_free0 (my_addr);
	_g_free0 (dest_addr);
}


static void* netsukuku_coordinator_helper_forward_free_to_nip (void* v, GError** error) {
	void* result = NULL;
	void* _tmp0_;
	Netsukukustruct_helper_Coordinator_forward_free_to_nip* tuple_p;
	NetsukukuCoordinator* _tmp1_;
	NetsukukuCoordinator* _tmp2_;
	NetsukukuCoordinator* self_save;
	NetsukukuNIP* _tmp3_;
	NetsukukuNIP* _tmp4_;
	NetsukukuNIP* to_nip_save;
	gint _tmp5_;
	gint pos_save;
	GError * _inner_error_ = NULL;
	_tmp0_ = v;
	tuple_p = (Netsukukustruct_helper_Coordinator_forward_free_to_nip*) _tmp0_;
	_tmp1_ = (*tuple_p).self;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	self_save = _tmp2_;
	_tmp3_ = (*tuple_p).to_nip;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	to_nip_save = _tmp4_;
	_tmp5_ = (*tuple_p).pos;
	pos_save = _tmp5_;
	tasklets_tasklet_schedule_back ();
	netsukuku_coordinator_impl_forward_free_to_nip (self_save, to_nip_save, pos_save, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (to_nip_save);
		_g_object_unref0 (self_save);
		return NULL;
	}
	result = NULL;
	_g_object_unref0 (to_nip_save);
	_g_object_unref0 (self_save);
	return result;
}


/** Forwards a freed position to another hash node in the bunch.
          */
void netsukuku_coordinator_forward_free_to_nip (NetsukukuCoordinator* self, NetsukukuNIP* to_nip, gint pos) {
	Netsukukustruct_helper_Coordinator_forward_free_to_nip arg = {0};
	NetsukukuCoordinator* _tmp0_;
	gint _tmp1_;
	NetsukukuNIP* _tmp2_;
	NetsukukuNIP* _tmp3_;
	TaskletsTasklet* _tmp4_ = NULL;
	TaskletsTasklet* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (to_nip != NULL);
	memset (&arg, 0, sizeof (Netsukukustruct_helper_Coordinator_forward_free_to_nip));
	_tmp0_ = _g_object_ref0 (self);
	_g_object_unref0 (arg.self);
	arg.self = _tmp0_;
	_tmp1_ = pos;
	arg.pos = _tmp1_;
	_tmp2_ = to_nip;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (arg.to_nip);
	arg.to_nip = _tmp3_;
	_tmp4_ = tasklets_tasklet_spawn ((TaskletsSpawnable) netsukuku_coordinator_helper_forward_free_to_nip, &arg, FALSE, -1);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp5_);
	netsukuku_struct_helper_coordinator_forward_free_to_nip_destroy (&arg);
}


NetsukukuBookings* netsukuku_coordinator_get_bookings (NetsukukuCoordinator* self) {
	NetsukukuBookings* result = NULL;
	NetsukukuBookings* _tmp0_;
	NetsukukuBookings* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->bookings;
	_tmp1_ = netsukuku_bookings_clone (_tmp0_);
	result = _tmp1_;
	return result;
}


void netsukuku_coordinator_add_bookings (NetsukukuCoordinator* self, NetsukukuBookings* bookings) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (bookings != NULL);
	{
		NetsukukuBookings* _tmp0_;
		GeeIterator* _tmp1_ = NULL;
		GeeIterator* _booking_record_it;
		_tmp0_ = bookings;
		_tmp1_ = netsukuku_bookings_iterator (_tmp0_);
		_booking_record_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			gboolean _tmp3_ = FALSE;
			GeeIterator* _tmp4_;
			gpointer _tmp5_ = NULL;
			NetsukukuBookingRecord* booking_record;
			NetsukukuBookingRecord* _tmp6_;
			_tmp2_ = _booking_record_it;
			_tmp3_ = gee_iterator_next (_tmp2_);
			if (!_tmp3_) {
				break;
			}
			_tmp4_ = _booking_record_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			booking_record = (NetsukukuBookingRecord*) _tmp5_;
			_tmp6_ = booking_record;
			netsukuku_coordinator_add_record (self, _tmp6_);
			_g_object_unref0 (booking_record);
		}
		_g_object_unref0 (_booking_record_it);
	}
}


/** Add a record to my bookings, do not forward.
          */
void netsukuku_coordinator_add_record (NetsukukuCoordinator* self, NetsukukuBookingRecord* booking_record) {
	NetsukukuMapRoute* _tmp0_;
	gint _tmp1_;
	NetsukukuBookingRecord* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gpointer _tmp5_ = NULL;
	NetsukukuRouteNode* node;
	NetsukukuRouteNode* _tmp6_;
	gboolean _tmp7_ = FALSE;
	NetsukukuBookings* _tmp8_;
	NetsukukuBookingRecord* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (booking_record != NULL);
	_tmp0_ = self->priv->maproute;
	_tmp1_ = self->priv->level_of_nodes;
	_tmp2_ = booking_record;
	_tmp3_ = netsukuku_booking_record_get_pos (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = netsukuku_map_node_get ((NetsukukuMap*) _tmp0_, _tmp1_, _tmp4_);
	node = (NetsukukuRouteNode*) _tmp5_;
	_tmp6_ = node;
	_tmp7_ = netsukuku_dataclass_is_free ((NetsukukuDataClass*) _tmp6_);
	if (!_tmp7_) {
		_g_object_unref0 (node);
		return;
	}
	_tmp8_ = self->priv->bookings;
	_tmp9_ = booking_record;
	netsukuku_bookings_force_add (_tmp8_, _tmp9_);
	_g_object_unref0 (node);
}


/** Remove a record from my bookings, do not forward.
          */
void netsukuku_coordinator_force_remove (NetsukukuCoordinator* self, gint pos) {
	NetsukukuBookings* _tmp0_;
	gint _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->bookings;
	_tmp1_ = pos;
	netsukuku_bookings_force_remove (_tmp0_, _tmp1_);
}


NetsukukuBnodeList* netsukuku_coordinator_get_bnode_list (NetsukukuCoordinator* self) {
	NetsukukuBnodeList* result = NULL;
	NetsukukuBnodeList* _tmp0_;
	NetsukukuBnodeList* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->bnode_list;
	_tmp1_ = netsukuku_bnode_list_clone (_tmp0_);
	result = _tmp1_;
	return result;
}


gboolean netsukuku_coordinator_register_bnode (NetsukukuCoordinator* self, NetsukukuNIP* nip, gboolean is_border, gboolean has_tunnel, gboolean is_willing) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (nip != NULL, FALSE);
	_tmp0_ = is_border;
	if (_tmp0_) {
		NetsukukuBnodeList* _tmp1_;
		NetsukukuNIP* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_ = FALSE;
		gboolean ret;
		_tmp1_ = self->priv->bnode_list;
		_tmp2_ = nip;
		_tmp3_ = has_tunnel;
		_tmp4_ = is_willing;
		_tmp5_ = netsukuku_bnode_list_update_bnode (_tmp1_, _tmp2_, _tmp3_, _tmp4_);
		ret = _tmp5_;
		netsukuku_coordinator_forward_knowledge (self);
		result = ret;
		return result;
	} else {
		NetsukukuBnodeList* _tmp6_;
		NetsukukuNIP* _tmp7_;
		_tmp6_ = self->priv->bnode_list;
		_tmp7_ = nip;
		netsukuku_bnode_list_delete_bnode (_tmp6_, _tmp7_);
		netsukuku_coordinator_forward_knowledge (self);
		result = TRUE;
		return result;
	}
}


void netsukuku_coordinator_add_bnode_list (NetsukukuCoordinator* self, NetsukukuBnodeList* bnode_list) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (bnode_list != NULL);
	{
		NetsukukuBnodeList* _tmp0_;
		GeeIterator* _tmp1_ = NULL;
		GeeIterator* _bnode_record_it;
		_tmp0_ = bnode_list;
		_tmp1_ = netsukuku_bnode_list_iterator (_tmp0_);
		_bnode_record_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			gboolean _tmp3_ = FALSE;
			GeeIterator* _tmp4_;
			gpointer _tmp5_ = NULL;
			NetsukukuBnodeRecord* bnode_record;
			NetsukukuBnodeList* _tmp6_;
			NetsukukuBnodeRecord* _tmp7_;
			_tmp2_ = _bnode_record_it;
			_tmp3_ = gee_iterator_next (_tmp2_);
			if (!_tmp3_) {
				break;
			}
			_tmp4_ = _bnode_record_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			bnode_record = (NetsukukuBnodeRecord*) _tmp5_;
			_tmp6_ = bnode_list;
			_tmp7_ = bnode_record;
			netsukuku_bnode_list_copy_bnode (_tmp6_, _tmp7_);
			_g_object_unref0 (bnode_record);
		}
		_g_object_unref0 (_bnode_record_it);
	}
}


static gboolean _netsukuku_bnode_record_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gboolean result;
	result = netsukuku_bnode_record_equal_func (a, b);
	return result;
}


static void netsukuku_coordinator_impl_manage_bnode_tunnels (NetsukukuCoordinator* self, GError** error) {
	TaskletsTasklet* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	tasklets_tasklet_declare_self ("Coordinator.manage_bnode_tunnels");
	_tmp0_ = tasklets_tasklet_self ();
	_g_object_unref0 (self->priv->manage_bnode_tunnels_handle);
	self->priv->manage_bnode_tunnels_handle = _tmp0_;
	while (TRUE) {
		{
			gboolean _tmp1_;
			gboolean _tmp2_;
			tasklets_ms_wait ((gint64) 10000);
			_tmp1_ = netsukuku_coordinator_get_is_main (self);
			_tmp2_ = _tmp1_;
			if (_tmp2_) {
				gint number_of_nodes;
				gint number_of_tunnels;
				GeeArrayList* _tmp12_;
				GeeArrayList* candidates;
				gchar* _tmp23_;
				gchar* str_candidates;
				const gchar* _tmp42_;
				gchar* _tmp43_;
				GeeArrayList* _tmp44_;
				gint _tmp45_;
				gint _tmp46_;
				number_of_nodes = 50;
				number_of_tunnels = 0;
				{
					NetsukukuBnodeList* _tmp3_;
					GeeIterator* _tmp4_ = NULL;
					GeeIterator* _bn_it;
					_tmp3_ = self->priv->bnode_list;
					_tmp4_ = netsukuku_bnode_list_iterator (_tmp3_);
					_bn_it = _tmp4_;
					while (TRUE) {
						GeeIterator* _tmp5_;
						gboolean _tmp6_ = FALSE;
						GeeIterator* _tmp7_;
						gpointer _tmp8_ = NULL;
						NetsukukuBnodeRecord* bn;
						NetsukukuBnodeRecord* _tmp9_;
						gboolean _tmp10_;
						_tmp5_ = _bn_it;
						_tmp6_ = gee_iterator_next (_tmp5_);
						if (!_tmp6_) {
							break;
						}
						_tmp7_ = _bn_it;
						_tmp8_ = gee_iterator_get (_tmp7_);
						bn = (NetsukukuBnodeRecord*) _tmp8_;
						_tmp9_ = bn;
						_tmp10_ = _tmp9_->has_tunnel;
						if (_tmp10_) {
							gint _tmp11_;
							_tmp11_ = number_of_tunnels;
							number_of_tunnels = _tmp11_ + 1;
						}
						_g_object_unref0 (bn);
					}
					_g_object_unref0 (_bn_it);
				}
				_tmp12_ = gee_array_list_new (NETSUKUKU_TYPE_BNODE_RECORD, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_bnode_record_equal_func_gee_equal_data_func, NULL, NULL);
				candidates = _tmp12_;
				{
					NetsukukuBnodeList* _tmp13_;
					GeeIterator* _tmp14_ = NULL;
					GeeIterator* _bn_it;
					_tmp13_ = self->priv->bnode_list;
					_tmp14_ = netsukuku_bnode_list_iterator (_tmp13_);
					_bn_it = _tmp14_;
					while (TRUE) {
						GeeIterator* _tmp15_;
						gboolean _tmp16_ = FALSE;
						GeeIterator* _tmp17_;
						gpointer _tmp18_ = NULL;
						NetsukukuBnodeRecord* bn;
						NetsukukuBnodeRecord* _tmp19_;
						gboolean _tmp20_;
						_tmp15_ = _bn_it;
						_tmp16_ = gee_iterator_next (_tmp15_);
						if (!_tmp16_) {
							break;
						}
						_tmp17_ = _bn_it;
						_tmp18_ = gee_iterator_get (_tmp17_);
						bn = (NetsukukuBnodeRecord*) _tmp18_;
						_tmp19_ = bn;
						_tmp20_ = _tmp19_->is_willing;
						if (_tmp20_) {
							GeeArrayList* _tmp21_;
							NetsukukuBnodeRecord* _tmp22_;
							_tmp21_ = candidates;
							_tmp22_ = bn;
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp21_, _tmp22_);
						}
						_g_object_unref0 (bn);
					}
					_g_object_unref0 (_bn_it);
				}
				_tmp23_ = g_strdup ("[");
				str_candidates = _tmp23_;
				{
					GeeArrayList* _tmp24_;
					GeeArrayList* _tmp25_;
					GeeArrayList* _record_list;
					GeeArrayList* _tmp26_;
					gint _tmp27_;
					gint _tmp28_;
					gint _record_size;
					gint _record_index;
					_tmp24_ = candidates;
					_tmp25_ = _g_object_ref0 (_tmp24_);
					_record_list = _tmp25_;
					_tmp26_ = _record_list;
					_tmp27_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp26_);
					_tmp28_ = _tmp27_;
					_record_size = _tmp28_;
					_record_index = -1;
					while (TRUE) {
						gint _tmp29_;
						gint _tmp30_;
						gint _tmp31_;
						GeeArrayList* _tmp32_;
						gint _tmp33_;
						gpointer _tmp34_ = NULL;
						NetsukukuBnodeRecord* record;
						const gchar* _tmp35_;
						NetsukukuBnodeRecord* _tmp36_;
						gchar* _tmp37_ = NULL;
						gchar* _tmp38_;
						gchar* _tmp39_ = NULL;
						gchar* _tmp40_;
						gchar* _tmp41_;
						_tmp29_ = _record_index;
						_record_index = _tmp29_ + 1;
						_tmp30_ = _record_index;
						_tmp31_ = _record_size;
						if (!(_tmp30_ < _tmp31_)) {
							break;
						}
						_tmp32_ = _record_list;
						_tmp33_ = _record_index;
						_tmp34_ = gee_abstract_list_get ((GeeAbstractList*) _tmp32_, _tmp33_);
						record = (NetsukukuBnodeRecord*) _tmp34_;
						_tmp35_ = str_candidates;
						_tmp36_ = record;
						_tmp37_ = netsukuku_bnode_record_to_string (_tmp36_);
						_tmp38_ = _tmp37_;
						_tmp39_ = g_strconcat (_tmp38_, ",", NULL);
						_tmp40_ = _tmp39_;
						_tmp41_ = g_strconcat (_tmp35_, _tmp40_, NULL);
						_g_free0 (str_candidates);
						str_candidates = _tmp41_;
						_g_free0 (_tmp40_);
						_g_free0 (_tmp38_);
						_g_object_unref0 (record);
					}
					_g_object_unref0 (_record_list);
				}
				_tmp42_ = str_candidates;
				_tmp43_ = g_strconcat (_tmp42_, "]", NULL);
				_g_free0 (str_candidates);
				str_candidates = _tmp43_;
				_tmp44_ = candidates;
				_tmp45_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp44_);
				_tmp46_ = _tmp45_;
				if (_tmp46_ >= 2) {
					gboolean _tmp47_ = FALSE;
					gint _tmp48_;
					gboolean _tmp51_;
					_tmp48_ = number_of_tunnels;
					if (_tmp48_ == 0) {
						_tmp47_ = TRUE;
					} else {
						gint _tmp49_;
						gint _tmp50_;
						_tmp49_ = number_of_nodes;
						_tmp50_ = number_of_tunnels;
						_tmp47_ = (_tmp49_ / _tmp50_) > 10;
					}
					_tmp51_ = _tmp47_;
					if (_tmp51_) {
						GeeArrayList* _tmp52_;
						_tmp52_ = candidates;
						netsukuku_coordinator_arrange_tunnel (self, _tmp52_);
					}
				}
				_g_free0 (str_candidates);
				_g_object_unref0 (candidates);
			}
		}
		goto __finally36;
		__catch36_g_error:
		{
			GError* e = NULL;
			GError* _tmp53_;
			const gchar* _tmp54_;
			const gchar* _tmp55_ = NULL;
			NetsukukuPartialNIP* _tmp56_;
			gchar* _tmp57_ = NULL;
			gchar* _tmp58_;
			gchar* _tmp59_ = NULL;
			gchar* _tmp60_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp53_ = e;
			_tmp54_ = _tmp53_->message;
			_tmp55_ = string_to_string (_tmp54_);
			_tmp56_ = self->priv->_gnode;
			_tmp57_ = netsukuku_partial_nip_to_string (_tmp56_);
			_tmp58_ = _tmp57_;
			_tmp59_ = g_strconcat ("Uncaught exception ", _tmp55_, " while manage_bnode_tunnels of ", _tmp58_, NULL);
			_tmp60_ = _tmp59_;
			netsukuku_log_error (_tmp60_);
			_g_free0 (_tmp60_);
			_g_free0 (_tmp58_);
			_g_error_free0 (e);
		}
		__finally36:
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return;
		}
	}
}


static void* netsukuku_coordinator_helper_manage_bnode_tunnels (void* v, GError** error) {
	void* result = NULL;
	void* _tmp0_;
	Netsukukustruct_helper_Coordinator_manage_bnode_tunnels* tuple_p;
	NetsukukuCoordinator* _tmp1_;
	NetsukukuCoordinator* _tmp2_;
	NetsukukuCoordinator* self_save;
	GError * _inner_error_ = NULL;
	_tmp0_ = v;
	tuple_p = (Netsukukustruct_helper_Coordinator_manage_bnode_tunnels*) _tmp0_;
	_tmp1_ = (*tuple_p).self;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	self_save = _tmp2_;
	tasklets_tasklet_schedule_back ();
	netsukuku_coordinator_impl_manage_bnode_tunnels (self_save, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self_save);
		return NULL;
	}
	result = NULL;
	_g_object_unref0 (self_save);
	return result;
}


void netsukuku_coordinator_manage_bnode_tunnels (NetsukukuCoordinator* self) {
	Netsukukustruct_helper_Coordinator_manage_bnode_tunnels arg = {0};
	NetsukukuCoordinator* _tmp0_;
	TaskletsTasklet* _tmp1_ = NULL;
	TaskletsTasklet* _tmp2_;
	g_return_if_fail (self != NULL);
	memset (&arg, 0, sizeof (Netsukukustruct_helper_Coordinator_manage_bnode_tunnels));
	_tmp0_ = _g_object_ref0 (self);
	_g_object_unref0 (arg.self);
	arg.self = _tmp0_;
	_tmp1_ = tasklets_tasklet_spawn ((TaskletsSpawnable) netsukuku_coordinator_helper_manage_bnode_tunnels, &arg, FALSE, -1);
	_tmp2_ = _tmp1_;
	_g_object_unref0 (_tmp2_);
	netsukuku_struct_helper_coordinator_manage_bnode_tunnels_destroy (&arg);
}


static gboolean _netsukuku_partial_nip_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gboolean result;
	result = netsukuku_partial_nip_equal_func (a, b);
	return result;
}


static gint __lambda2_ (NetsukukuCoordinator* self, NetsukukuCoordinatorPair* a, NetsukukuCoordinatorPair* b) {
	gint result = 0;
	NetsukukuCoordinatorPair* _tmp0_;
	gconstpointer _tmp1_;
	NetsukukuPairNipDistance* _tmp2_;
	gint _tmp3_;
	NetsukukuCoordinatorPair* _tmp4_;
	gconstpointer _tmp5_;
	NetsukukuPairNipDistance* _tmp6_;
	gint _tmp7_;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = a;
	_tmp1_ = netsukuku_coordinator_pair_get_b (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = ((NetsukukuPairNipDistance*) _tmp2_)->distance;
	_tmp4_ = b;
	_tmp5_ = netsukuku_coordinator_pair_get_b (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = ((NetsukukuPairNipDistance*) _tmp6_)->distance;
	result = _tmp3_ - _tmp7_;
	return result;
}


static gint ___lambda2__gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gint result;
	result = __lambda2_ (self, a, b);
	return result;
}


void netsukuku_coordinator_arrange_tunnel (NetsukukuCoordinator* self, GeeArrayList* candidates) {
	NetsukukuMapRoute* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	NetsukukuMapRoute* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	NetsukukuMapRoute* _tmp6_;
	NetsukukuNIP* _tmp7_;
	NetsukukuNIP* _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* my_addr;
	NetsukukuAddressManagerTCPClient* remote_x = NULL;
	NetsukukuAddressManagerTCPClient* remote_y = NULL;
	GeeArrayList* _tmp10_;
	GeeArrayList* pool;
	GeeArrayList* _tmp77_;
	gboolean _tmp78_;
	gboolean _tmp79_;
	GCompareDataFunc cmp;
	void* cmp_target;
	GDestroyNotify cmp_target_destroy_notify;
	GeeArrayList* _tmp80_;
	GCompareDataFunc _tmp81_;
	void* _tmp81__target;
	GeeArrayList* _tmp82_;
	gpointer _tmp83_ = NULL;
	NetsukukuCoordinatorPair* _tmp84_;
	gconstpointer _tmp85_;
	NetsukukuNIP* _tmp86_;
	NetsukukuNIP* _tmp87_;
	NetsukukuNIP* _tmp88_;
	NetsukukuNIP* nip_x;
	GeeArrayList* _tmp89_;
	gpointer _tmp90_ = NULL;
	NetsukukuCoordinatorPair* _tmp91_;
	gconstpointer _tmp92_;
	NetsukukuPairNipDistance* _tmp93_;
	NetsukukuNIP* _tmp94_;
	NetsukukuNIP* _tmp95_;
	NetsukukuNIP* _tmp96_;
	NetsukukuNIP* nip_y;
	NetsukukuMapRoute* _tmp97_;
	gint _tmp98_;
	gint _tmp99_;
	NetsukukuMapRoute* _tmp100_;
	gint _tmp101_;
	gint _tmp102_;
	NetsukukuNIP* _tmp103_;
	gchar* _tmp104_ = NULL;
	gchar* _tmp105_;
	const gchar* _tmp106_;
	NetsukukuAddressManagerTCPClient* _tmp107_;
	NetsukukuAddressManagerTCPClient* _tmp108_;
	NetsukukuIBorderNodesManager* _tmp109_;
	NetsukukuIBorderNodesManager* _tmp110_;
	NetsukukuPartialNIP* _tmp111_;
	NetsukukuNIP* _tmp112_ = NULL;
	NetsukukuNIP* nip_x_secondary;
	NetsukukuMapRoute* _tmp113_;
	gint _tmp114_;
	gint _tmp115_;
	NetsukukuMapRoute* _tmp116_;
	gint _tmp117_;
	gint _tmp118_;
	NetsukukuNIP* _tmp119_;
	gchar* _tmp120_ = NULL;
	gchar* _tmp121_;
	const gchar* _tmp122_;
	NetsukukuAddressManagerTCPClient* _tmp123_;
	NetsukukuAddressManagerTCPClient* _tmp124_;
	NetsukukuIBorderNodesManager* _tmp125_;
	NetsukukuIBorderNodesManager* _tmp126_;
	NetsukukuPartialNIP* _tmp127_;
	NetsukukuNIP* _tmp128_;
	NetsukukuNIP* _tmp129_ = NULL;
	NetsukukuNIP* nip_y_secondary;
	NetsukukuAddressManagerTCPClient* _tmp130_;
	NetsukukuIBorderNodesManager* _tmp131_;
	NetsukukuIBorderNodesManager* _tmp132_;
	NetsukukuNIP* _tmp133_;
	NetsukukuNIP* _tmp134_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (candidates != NULL);
	_tmp0_ = self->priv->maproute;
	_tmp1_ = netsukuku_map_get_levels ((NetsukukuMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->maproute;
	_tmp4_ = netsukuku_map_get_gsize ((NetsukukuMap*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->maproute;
	_tmp7_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = netsukuku_nip_to_str (_tmp2_, _tmp5_, _tmp8_);
	my_addr = _tmp9_;
	_tmp10_ = gee_array_list_new (NETSUKUKU_COORDINATOR_TYPE_PAIR, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	pool = _tmp10_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp11_;
			_tmp11_ = TRUE;
			while (TRUE) {
				gboolean _tmp12_;
				gint _tmp14_;
				GeeArrayList* _tmp15_;
				gint _tmp16_;
				gint _tmp17_;
				GeeArrayList* _tmp18_;
				gint _tmp19_;
				gpointer _tmp20_ = NULL;
				NetsukukuBnodeRecord* _tmp21_;
				NetsukukuNIP* _tmp22_;
				NetsukukuNIP* _tmp23_;
				NetsukukuNIP* _tmp24_;
				NetsukukuNIP* _tmp25_;
				NetsukukuNIP* x;
				GeeArrayList* _tmp26_;
				GeeArrayList* list_of_y;
				NetsukukuMapRoute* _tmp42_;
				gint _tmp43_;
				gint _tmp44_;
				NetsukukuMapRoute* _tmp45_;
				gint _tmp46_;
				gint _tmp47_;
				NetsukukuNIP* _tmp48_;
				gchar* _tmp49_ = NULL;
				gchar* _tmp50_;
				const gchar* _tmp51_;
				NetsukukuAddressManagerTCPClient* _tmp52_;
				NetsukukuAddressManagerTCPClient* _tmp53_;
				NetsukukuIBorderNodesManager* _tmp54_;
				NetsukukuIBorderNodesManager* _tmp55_;
				NetsukukuPartialNIP* _tmp56_;
				GeeArrayList* _tmp57_;
				GeeList* _tmp58_ = NULL;
				GeeList* dists;
				_tmp12_ = _tmp11_;
				if (!_tmp12_) {
					gint _tmp13_;
					_tmp13_ = i;
					i = _tmp13_ + 1;
				}
				_tmp11_ = FALSE;
				_tmp14_ = i;
				_tmp15_ = candidates;
				_tmp16_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp15_);
				_tmp17_ = _tmp16_;
				if (!(_tmp14_ < _tmp17_)) {
					break;
				}
				_tmp18_ = candidates;
				_tmp19_ = i;
				_tmp20_ = gee_abstract_list_get ((GeeAbstractList*) _tmp18_, _tmp19_);
				_tmp21_ = (NetsukukuBnodeRecord*) _tmp20_;
				_tmp22_ = netsukuku_bnode_record_get_nip (_tmp21_);
				_tmp23_ = _tmp22_;
				_tmp24_ = _g_object_ref0 (_tmp23_);
				_tmp25_ = _tmp24_;
				_g_object_unref0 (_tmp21_);
				x = _tmp25_;
				_tmp26_ = gee_array_list_new (NETSUKUKU_TYPE_NIP, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_partial_nip_equal_func_gee_equal_data_func, NULL, NULL);
				list_of_y = _tmp26_;
				{
					gint _tmp27_;
					gint j;
					_tmp27_ = i;
					j = _tmp27_ + 1;
					{
						gboolean _tmp28_;
						_tmp28_ = TRUE;
						while (TRUE) {
							gboolean _tmp29_;
							gint _tmp31_;
							GeeArrayList* _tmp32_;
							gint _tmp33_;
							gint _tmp34_;
							GeeArrayList* _tmp35_;
							GeeArrayList* _tmp36_;
							gint _tmp37_;
							gpointer _tmp38_ = NULL;
							NetsukukuBnodeRecord* _tmp39_;
							NetsukukuNIP* _tmp40_;
							NetsukukuNIP* _tmp41_;
							_tmp29_ = _tmp28_;
							if (!_tmp29_) {
								gint _tmp30_;
								_tmp30_ = j;
								j = _tmp30_ + 1;
							}
							_tmp28_ = FALSE;
							_tmp31_ = j;
							_tmp32_ = candidates;
							_tmp33_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp32_);
							_tmp34_ = _tmp33_;
							if (!(_tmp31_ < _tmp34_)) {
								break;
							}
							_tmp35_ = list_of_y;
							_tmp36_ = candidates;
							_tmp37_ = j;
							_tmp38_ = gee_abstract_list_get ((GeeAbstractList*) _tmp36_, _tmp37_);
							_tmp39_ = (NetsukukuBnodeRecord*) _tmp38_;
							_tmp40_ = netsukuku_bnode_record_get_nip (_tmp39_);
							_tmp41_ = _tmp40_;
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp35_, _tmp41_);
							_g_object_unref0 (_tmp39_);
						}
					}
				}
				_tmp42_ = self->priv->maproute;
				_tmp43_ = netsukuku_map_get_levels ((NetsukukuMap*) _tmp42_);
				_tmp44_ = _tmp43_;
				_tmp45_ = self->priv->maproute;
				_tmp46_ = netsukuku_map_get_gsize ((NetsukukuMap*) _tmp45_);
				_tmp47_ = _tmp46_;
				_tmp48_ = x;
				_tmp49_ = netsukuku_nip_to_str (_tmp44_, _tmp47_, _tmp48_);
				_tmp50_ = _tmp49_;
				_tmp51_ = my_addr;
				_tmp52_ = netsukuku_address_manager_tcp_client_new (_tmp50_, NULL, _tmp51_, TRUE);
				_g_object_unref0 (remote_x);
				remote_x = _tmp52_;
				_g_free0 (_tmp50_);
				_tmp53_ = remote_x;
				_tmp54_ = netsukuku_iaddress_manager_root_dispatcher_get_border_nodes_manager ((NetsukukuIAddressManagerRootDispatcher*) _tmp53_);
				_tmp55_ = _tmp54_;
				_tmp56_ = self->priv->_gnode;
				_tmp57_ = list_of_y;
				_tmp58_ = netsukuku_iborder_nodes_manager_get_distances (_tmp55_, _tmp56_, (GeeList*) _tmp57_, NULL, &_inner_error_);
				dists = _tmp58_;
				if (_inner_error_ != NULL) {
					_g_object_unref0 (list_of_y);
					_g_object_unref0 (x);
					_g_object_unref0 (pool);
					_g_object_unref0 (remote_y);
					_g_object_unref0 (remote_x);
					_g_free0 (my_addr);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				{
					GeeList* _tmp59_;
					GeeList* _tmp60_;
					GeeList* _y_dist_list;
					GeeList* _tmp61_;
					gint _tmp62_;
					gint _tmp63_;
					gint _y_dist_size;
					gint _y_dist_index;
					_tmp59_ = dists;
					_tmp60_ = _g_object_ref0 (_tmp59_);
					_y_dist_list = _tmp60_;
					_tmp61_ = _y_dist_list;
					_tmp62_ = gee_collection_get_size ((GeeCollection*) _tmp61_);
					_tmp63_ = _tmp62_;
					_y_dist_size = _tmp63_;
					_y_dist_index = -1;
					while (TRUE) {
						gint _tmp64_;
						gint _tmp65_;
						gint _tmp66_;
						GeeList* _tmp67_;
						gint _tmp68_;
						gpointer _tmp69_ = NULL;
						NetsukukuPairNipDistance* y_dist;
						NetsukukuPairNipDistance* _tmp70_;
						gint _tmp71_;
						_tmp64_ = _y_dist_index;
						_y_dist_index = _tmp64_ + 1;
						_tmp65_ = _y_dist_index;
						_tmp66_ = _y_dist_size;
						if (!(_tmp65_ < _tmp66_)) {
							break;
						}
						_tmp67_ = _y_dist_list;
						_tmp68_ = _y_dist_index;
						_tmp69_ = gee_list_get (_tmp67_, _tmp68_);
						y_dist = (NetsukukuPairNipDistance*) _tmp69_;
						_tmp70_ = y_dist;
						_tmp71_ = _tmp70_->distance;
						if (_tmp71_ > 1) {
							GeeArrayList* _tmp72_;
							NetsukukuNIP* _tmp73_;
							NetsukukuPairNipDistance* _tmp74_;
							NetsukukuCoordinatorPair* _tmp75_;
							NetsukukuCoordinatorPair* _tmp76_;
							_tmp72_ = pool;
							_tmp73_ = x;
							_tmp74_ = y_dist;
							_tmp75_ = netsukuku_coordinator_pair_new (NETSUKUKU_TYPE_NIP, (GBoxedCopyFunc) g_object_ref, g_object_unref, NETSUKUKU_TYPE_PAIR_NIP_DISTANCE, (GBoxedCopyFunc) g_object_ref, g_object_unref, _tmp73_, _tmp74_);
							_tmp76_ = _tmp75_;
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp72_, _tmp76_);
							_g_object_unref0 (_tmp76_);
						}
						_g_object_unref0 (y_dist);
					}
					_g_object_unref0 (_y_dist_list);
				}
				_g_object_unref0 (dists);
				_g_object_unref0 (list_of_y);
				_g_object_unref0 (x);
			}
		}
	}
	_tmp77_ = pool;
	_tmp78_ = gee_collection_get_is_empty ((GeeCollection*) _tmp77_);
	_tmp79_ = _tmp78_;
	if (_tmp79_) {
		_g_object_unref0 (pool);
		_g_object_unref0 (remote_y);
		_g_object_unref0 (remote_x);
		_g_free0 (my_addr);
		return;
	}
	cmp = ___lambda2__gcompare_data_func;
	cmp_target = g_object_ref (self);
	cmp_target_destroy_notify = g_object_unref;
	_tmp80_ = pool;
	_tmp81_ = cmp;
	_tmp81__target = cmp_target;
	gee_list_sort ((GeeList*) _tmp80_, _tmp81_, _tmp81__target, NULL);
	_tmp82_ = pool;
	_tmp83_ = gee_abstract_list_get ((GeeAbstractList*) _tmp82_, 0);
	_tmp84_ = (NetsukukuCoordinatorPair*) _tmp83_;
	_tmp85_ = netsukuku_coordinator_pair_get_a (_tmp84_);
	_tmp86_ = _tmp85_;
	_tmp87_ = _g_object_ref0 ((NetsukukuNIP*) _tmp86_);
	_tmp88_ = _tmp87_;
	_g_object_unref0 (_tmp84_);
	nip_x = _tmp88_;
	_tmp89_ = pool;
	_tmp90_ = gee_abstract_list_get ((GeeAbstractList*) _tmp89_, 0);
	_tmp91_ = (NetsukukuCoordinatorPair*) _tmp90_;
	_tmp92_ = netsukuku_coordinator_pair_get_b (_tmp91_);
	_tmp93_ = _tmp92_;
	_tmp94_ = ((NetsukukuPairNipDistance*) _tmp93_)->nip;
	_tmp95_ = _g_object_ref0 (_tmp94_);
	_tmp96_ = _tmp95_;
	_g_object_unref0 (_tmp91_);
	nip_y = _tmp96_;
	_tmp97_ = self->priv->maproute;
	_tmp98_ = netsukuku_map_get_levels ((NetsukukuMap*) _tmp97_);
	_tmp99_ = _tmp98_;
	_tmp100_ = self->priv->maproute;
	_tmp101_ = netsukuku_map_get_gsize ((NetsukukuMap*) _tmp100_);
	_tmp102_ = _tmp101_;
	_tmp103_ = nip_x;
	_tmp104_ = netsukuku_nip_to_str (_tmp99_, _tmp102_, _tmp103_);
	_tmp105_ = _tmp104_;
	_tmp106_ = my_addr;
	_tmp107_ = netsukuku_address_manager_tcp_client_new (_tmp105_, NULL, _tmp106_, TRUE);
	_g_object_unref0 (remote_x);
	remote_x = _tmp107_;
	_g_free0 (_tmp105_);
	_tmp108_ = remote_x;
	_tmp109_ = netsukuku_iaddress_manager_root_dispatcher_get_border_nodes_manager ((NetsukukuIAddressManagerRootDispatcher*) _tmp108_);
	_tmp110_ = _tmp109_;
	_tmp111_ = self->priv->_gnode;
	_tmp112_ = netsukuku_iborder_nodes_manager_get_new_address (_tmp110_, _tmp111_, NULL, NULL, &_inner_error_);
	nip_x_secondary = _tmp112_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (nip_y);
		_g_object_unref0 (nip_x);
		(cmp_target_destroy_notify == NULL) ? NULL : (cmp_target_destroy_notify (cmp_target), NULL);
		cmp = NULL;
		cmp_target = NULL;
		cmp_target_destroy_notify = NULL;
		_g_object_unref0 (pool);
		_g_object_unref0 (remote_y);
		_g_object_unref0 (remote_x);
		_g_free0 (my_addr);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp113_ = self->priv->maproute;
	_tmp114_ = netsukuku_map_get_levels ((NetsukukuMap*) _tmp113_);
	_tmp115_ = _tmp114_;
	_tmp116_ = self->priv->maproute;
	_tmp117_ = netsukuku_map_get_gsize ((NetsukukuMap*) _tmp116_);
	_tmp118_ = _tmp117_;
	_tmp119_ = nip_y;
	_tmp120_ = netsukuku_nip_to_str (_tmp115_, _tmp118_, _tmp119_);
	_tmp121_ = _tmp120_;
	_tmp122_ = my_addr;
	_tmp123_ = netsukuku_address_manager_tcp_client_new (_tmp121_, NULL, _tmp122_, TRUE);
	_g_object_unref0 (remote_y);
	remote_y = _tmp123_;
	_g_free0 (_tmp121_);
	_tmp124_ = remote_y;
	_tmp125_ = netsukuku_iaddress_manager_root_dispatcher_get_border_nodes_manager ((NetsukukuIAddressManagerRootDispatcher*) _tmp124_);
	_tmp126_ = _tmp125_;
	_tmp127_ = self->priv->_gnode;
	_tmp128_ = nip_x_secondary;
	_tmp129_ = netsukuku_iborder_nodes_manager_get_new_address (_tmp126_, _tmp127_, _tmp128_, NULL, &_inner_error_);
	nip_y_secondary = _tmp129_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (nip_x_secondary);
		_g_object_unref0 (nip_y);
		_g_object_unref0 (nip_x);
		(cmp_target_destroy_notify == NULL) ? NULL : (cmp_target_destroy_notify (cmp_target), NULL);
		cmp = NULL;
		cmp_target = NULL;
		cmp_target_destroy_notify = NULL;
		_g_object_unref0 (pool);
		_g_object_unref0 (remote_y);
		_g_object_unref0 (remote_x);
		_g_free0 (my_addr);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp130_ = remote_x;
	_tmp131_ = netsukuku_iaddress_manager_root_dispatcher_get_border_nodes_manager ((NetsukukuIAddressManagerRootDispatcher*) _tmp130_);
	_tmp132_ = _tmp131_;
	_tmp133_ = nip_x_secondary;
	_tmp134_ = nip_y_secondary;
	netsukuku_iborder_nodes_manager_assign_peer_nip (_tmp132_, _tmp133_, _tmp134_, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (nip_y_secondary);
		_g_object_unref0 (nip_x_secondary);
		_g_object_unref0 (nip_y);
		_g_object_unref0 (nip_x);
		(cmp_target_destroy_notify == NULL) ? NULL : (cmp_target_destroy_notify (cmp_target), NULL);
		cmp = NULL;
		cmp_target = NULL;
		cmp_target_destroy_notify = NULL;
		_g_object_unref0 (pool);
		_g_object_unref0 (remote_y);
		_g_object_unref0 (remote_x);
		_g_free0 (my_addr);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (nip_y_secondary);
	_g_object_unref0 (nip_x_secondary);
	_g_object_unref0 (nip_y);
	_g_object_unref0 (nip_x);
	(cmp_target_destroy_notify == NULL) ? NULL : (cmp_target_destroy_notify (cmp_target), NULL);
	cmp = NULL;
	cmp_target = NULL;
	cmp_target_destroy_notify = NULL;
	_g_object_unref0 (pool);
	_g_object_unref0 (remote_y);
	_g_object_unref0 (remote_x);
	_g_free0 (my_addr);
}


static void _vala_array_add4 (NetsukukuNIP*** array, int* length, int* size, NetsukukuNIP* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (NetsukukuNIP*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void netsukuku_coordinator_impl_forward_knowledge (NetsukukuCoordinator* self, GError** error) {
	NetsukukuCoord_hkey* _tmp0_;
	NetsukukuCoord_hkey* key;
	gint _tmp1_;
	NetsukukuMapRoute* _tmp2_;
	NetsukukuNIP* _tmp3_;
	NetsukukuNIP* _tmp4_;
	NetsukukuNIP* _tmp5_;
	NetsukukuCoord* _tmp6_;
	NetsukukuNIP* _tmp7_ = NULL;
	NetsukukuNIP* hash_nip;
	NetsukukuCoord* _tmp8_;
	gint _tmp9_;
	GeeList* _tmp10_ = NULL;
	GeeList* bunch;
	NetsukukuNIP** _tmp11_ = NULL;
	NetsukukuNIP** bunch_not_me;
	gint bunch_not_me_length1;
	gint _bunch_not_me_size_;
	NetsukukuNIP** _tmp30_;
	gint _tmp30__length1;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	tasklets_tasklet_declare_self ("Coordinator.forward_knowledge");
	_tmp0_ = netsukuku_coord_hkey_new ();
	key = _tmp0_;
	_tmp1_ = self->priv->level_of_gnode;
	key->level_of_gnode = _tmp1_;
	_tmp2_ = self->priv->maproute;
	_tmp3_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (key->nip);
	key->nip = _tmp5_;
	_tmp6_ = self->priv->parent;
	_tmp7_ = netsukuku_peer_to_peer_h ((NetsukukuPeerToPeer*) _tmp6_, (GObject*) key);
	hash_nip = _tmp7_;
	_tmp8_ = self->priv->parent;
	_tmp9_ = self->priv->level_of_gnode;
	_tmp10_ = netsukuku_peer_to_peer_find_nearest_to_register ((NetsukukuPeerToPeer*) _tmp8_, hash_nip, NETSUKUKU_COORD_DUPLICATION, &_tmp9_, &_inner_error_);
	bunch = _tmp10_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (hash_nip);
		_g_object_unref0 (key);
		return;
	}
	_tmp11_ = g_new0 (NetsukukuNIP*, 0 + 1);
	bunch_not_me = _tmp11_;
	bunch_not_me_length1 = 0;
	_bunch_not_me_size_ = bunch_not_me_length1;
	{
		GeeList* _tmp12_;
		GeeList* _n_list;
		GeeList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _n_size;
		gint _n_index;
		_tmp12_ = _g_object_ref0 (bunch);
		_n_list = _tmp12_;
		_tmp13_ = _n_list;
		_tmp14_ = gee_collection_get_size ((GeeCollection*) _tmp13_);
		_tmp15_ = _tmp14_;
		_n_size = _tmp15_;
		_n_index = -1;
		while (TRUE) {
			gint _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			GeeList* _tmp19_;
			gint _tmp20_;
			gpointer _tmp21_ = NULL;
			NetsukukuNIP* n;
			NetsukukuNIP* _tmp22_;
			NetsukukuMapRoute* _tmp23_;
			NetsukukuNIP* _tmp24_;
			NetsukukuNIP* _tmp25_;
			gboolean _tmp26_ = FALSE;
			_tmp16_ = _n_index;
			_n_index = _tmp16_ + 1;
			_tmp17_ = _n_index;
			_tmp18_ = _n_size;
			if (!(_tmp17_ < _tmp18_)) {
				break;
			}
			_tmp19_ = _n_list;
			_tmp20_ = _n_index;
			_tmp21_ = gee_list_get (_tmp19_, _tmp20_);
			n = (NetsukukuNIP*) _tmp21_;
			_tmp22_ = n;
			_tmp23_ = self->priv->maproute;
			_tmp24_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = netsukuku_partial_nip_is_equal ((NetsukukuPartialNIP*) _tmp22_, (NetsukukuPartialNIP*) _tmp25_);
			if (!_tmp26_) {
				NetsukukuNIP** _tmp27_;
				gint _tmp27__length1;
				NetsukukuNIP* _tmp28_;
				NetsukukuNIP* _tmp29_;
				_tmp27_ = bunch_not_me;
				_tmp27__length1 = bunch_not_me_length1;
				_tmp28_ = n;
				_tmp29_ = _g_object_ref0 (_tmp28_);
				_vala_array_add4 (&bunch_not_me, &bunch_not_me_length1, &_bunch_not_me_size_, _tmp29_);
			}
			_g_object_unref0 (n);
		}
		_g_object_unref0 (_n_list);
	}
	_tmp30_ = bunch_not_me;
	_tmp30__length1 = bunch_not_me_length1;
	{
		NetsukukuNIP** to_nip_collection = NULL;
		gint to_nip_collection_length1 = 0;
		gint _to_nip_collection_size_ = 0;
		gint to_nip_it = 0;
		to_nip_collection = _tmp30_;
		to_nip_collection_length1 = _tmp30__length1;
		for (to_nip_it = 0; to_nip_it < _tmp30__length1; to_nip_it = to_nip_it + 1) {
			NetsukukuNIP* _tmp31_;
			NetsukukuNIP* to_nip = NULL;
			_tmp31_ = _g_object_ref0 (to_nip_collection[to_nip_it]);
			to_nip = _tmp31_;
			{
				NetsukukuNIP* _tmp32_;
				_tmp32_ = to_nip;
				netsukuku_coordinator_forward_knowledge_to_nip (self, _tmp32_);
				_g_object_unref0 (to_nip);
			}
		}
	}
	bunch_not_me = (_vala_array_free (bunch_not_me, bunch_not_me_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (bunch);
	_g_object_unref0 (hash_nip);
	_g_object_unref0 (key);
}


static void* netsukuku_coordinator_helper_forward_knowledge (void* v, GError** error) {
	void* result = NULL;
	void* _tmp0_;
	Netsukukustruct_helper_Coordinator_forward_knowledge* tuple_p;
	NetsukukuCoordinator* _tmp1_;
	NetsukukuCoordinator* _tmp2_;
	NetsukukuCoordinator* self_save;
	GError * _inner_error_ = NULL;
	_tmp0_ = v;
	tuple_p = (Netsukukustruct_helper_Coordinator_forward_knowledge*) _tmp0_;
	_tmp1_ = (*tuple_p).self;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	self_save = _tmp2_;
	tasklets_tasklet_schedule_back ();
	netsukuku_coordinator_impl_forward_knowledge (self_save, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self_save);
		return NULL;
	}
	result = NULL;
	_g_object_unref0 (self_save);
	return result;
}


/** Communicate to secondary coordinators all our current knowledge.
          */
void netsukuku_coordinator_forward_knowledge (NetsukukuCoordinator* self) {
	Netsukukustruct_helper_Coordinator_forward_knowledge arg = {0};
	NetsukukuCoordinator* _tmp0_;
	TaskletsTasklet* _tmp1_ = NULL;
	TaskletsTasklet* _tmp2_;
	g_return_if_fail (self != NULL);
	memset (&arg, 0, sizeof (Netsukukustruct_helper_Coordinator_forward_knowledge));
	_tmp0_ = _g_object_ref0 (self);
	_g_object_unref0 (arg.self);
	arg.self = _tmp0_;
	_tmp1_ = tasklets_tasklet_spawn ((TaskletsSpawnable) netsukuku_coordinator_helper_forward_knowledge, &arg, FALSE, -1);
	_tmp2_ = _tmp1_;
	_g_object_unref0 (_tmp2_);
	netsukuku_struct_helper_coordinator_forward_knowledge_destroy (&arg);
}


static void netsukuku_coordinator_impl_forward_knowledge_to_nip (NetsukukuCoordinator* self, NetsukukuNIP* to_nip, GError** error) {
	NetsukukuMapRoute* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	NetsukukuMapRoute* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	NetsukukuNIP* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* dest_addr;
	NetsukukuMapRoute* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	NetsukukuMapRoute* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	NetsukukuMapRoute* _tmp14_;
	NetsukukuNIP* _tmp15_;
	NetsukukuNIP* _tmp16_;
	gchar* _tmp17_ = NULL;
	gchar* my_addr;
	NetsukukuAddressManagerTCPClient* _tmp18_;
	NetsukukuAddressManagerTCPClient* remote;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (to_nip != NULL);
	tasklets_tasklet_declare_self ("Coordinator.forward_knowledge_to_nip");
	_tmp0_ = self->priv->maproute;
	_tmp1_ = netsukuku_map_get_levels ((NetsukukuMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->maproute;
	_tmp4_ = netsukuku_map_get_gsize ((NetsukukuMap*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = to_nip;
	_tmp7_ = netsukuku_nip_to_str (_tmp2_, _tmp5_, _tmp6_);
	dest_addr = _tmp7_;
	_tmp8_ = self->priv->maproute;
	_tmp9_ = netsukuku_map_get_levels ((NetsukukuMap*) _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = self->priv->maproute;
	_tmp12_ = netsukuku_map_get_gsize ((NetsukukuMap*) _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = self->priv->maproute;
	_tmp15_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = netsukuku_nip_to_str (_tmp10_, _tmp13_, _tmp16_);
	my_addr = _tmp17_;
	_tmp18_ = netsukuku_address_manager_tcp_client_new (dest_addr, NULL, my_addr, FALSE);
	remote = _tmp18_;
	{
		NetsukukuICoord* _tmp19_;
		NetsukukuICoord* _tmp20_;
		NetsukukuPartialNIP* _tmp21_;
		NetsukukuPartialNIP* _tmp22_;
		NetsukukuBookings* _tmp23_ = NULL;
		NetsukukuBookings* _tmp24_;
		gint _tmp25_;
		NetsukukuBnodeList* _tmp26_ = NULL;
		NetsukukuBnodeList* _tmp27_;
		NetsukukuCoordinatorKnowledge* _tmp28_;
		NetsukukuCoordinatorKnowledge* _tmp29_;
		_tmp19_ = netsukuku_iaddress_manager_root_dispatcher_get_coordnode ((NetsukukuIAddressManagerRootDispatcher*) remote);
		_tmp20_ = _tmp19_;
		_tmp21_ = self->priv->_gnode;
		_tmp22_ = self->priv->_gnode;
		_tmp23_ = netsukuku_coordinator_get_bookings (self);
		_tmp24_ = _tmp23_;
		_tmp25_ = self->last_assigned_elderliness;
		_tmp26_ = netsukuku_coordinator_get_bnode_list (self);
		_tmp27_ = _tmp26_;
		_tmp28_ = netsukuku_coordinator_knowledge_new (_tmp22_, _tmp24_, _tmp25_, _tmp27_);
		_tmp29_ = _tmp28_;
		netsukuku_icoord_duplicate_all_knowledge (_tmp20_, _tmp21_, _tmp29_, &_inner_error_);
		_g_object_unref0 (_tmp29_);
		_g_object_unref0 (_tmp27_);
		_g_object_unref0 (_tmp24_);
		if (_inner_error_ != NULL) {
			goto __catch37_g_error;
		}
	}
	goto __finally37;
	__catch37_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp30_ = NULL;
		GError* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_ = NULL;
		gchar* _tmp34_ = NULL;
		gchar* _tmp35_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp30_ = string_to_string (dest_addr);
		_tmp31_ = e;
		_tmp32_ = _tmp31_->message;
		_tmp33_ = string_to_string (_tmp32_);
		_tmp34_ = g_strconcat ("'Coord: forwarded knowledge to ", _tmp30_, " got exception ", _tmp33_, NULL);
		_tmp35_ = _tmp34_;
		netsukuku_log_warn (_tmp35_);
		_g_free0 (_tmp35_);
		_g_error_free0 (e);
	}
	__finally37:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (remote);
		_g_free0 (my_addr);
		_g_free0 (dest_addr);
		return;
	}
	_g_object_unref0 (remote);
	_g_free0 (my_addr);
	_g_free0 (dest_addr);
}


static void* netsukuku_coordinator_helper_forward_knowledge_to_nip (void* v, GError** error) {
	void* result = NULL;
	void* _tmp0_;
	Netsukukustruct_helper_Coordinator_forward_knowledge_to_nip* tuple_p;
	NetsukukuCoordinator* _tmp1_;
	NetsukukuCoordinator* _tmp2_;
	NetsukukuCoordinator* self_save;
	NetsukukuNIP* _tmp3_;
	NetsukukuNIP* _tmp4_;
	NetsukukuNIP* nip_save;
	GError * _inner_error_ = NULL;
	_tmp0_ = v;
	tuple_p = (Netsukukustruct_helper_Coordinator_forward_knowledge_to_nip*) _tmp0_;
	_tmp1_ = (*tuple_p).self;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	self_save = _tmp2_;
	_tmp3_ = (*tuple_p).nip;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	nip_save = _tmp4_;
	tasklets_tasklet_schedule_back ();
	netsukuku_coordinator_impl_forward_knowledge_to_nip (self_save, nip_save, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (nip_save);
		_g_object_unref0 (self_save);
		return NULL;
	}
	result = NULL;
	_g_object_unref0 (nip_save);
	_g_object_unref0 (self_save);
	return result;
}


/** Forwards all current knowledge to a secondary coordinator.
          */
void netsukuku_coordinator_forward_knowledge_to_nip (NetsukukuCoordinator* self, NetsukukuNIP* nip) {
	Netsukukustruct_helper_Coordinator_forward_knowledge_to_nip arg = {0};
	NetsukukuCoordinator* _tmp0_;
	NetsukukuNIP* _tmp1_;
	NetsukukuNIP* _tmp2_;
	TaskletsTasklet* _tmp3_ = NULL;
	TaskletsTasklet* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (nip != NULL);
	memset (&arg, 0, sizeof (Netsukukustruct_helper_Coordinator_forward_knowledge_to_nip));
	_tmp0_ = _g_object_ref0 (self);
	_g_object_unref0 (arg.self);
	arg.self = _tmp0_;
	_tmp1_ = nip;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (arg.nip);
	arg.nip = _tmp2_;
	_tmp3_ = tasklets_tasklet_spawn ((TaskletsSpawnable) netsukuku_coordinator_helper_forward_knowledge_to_nip, &arg, FALSE, -1);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp4_);
	netsukuku_struct_helper_coordinator_forward_knowledge_to_nip_destroy (&arg);
}


NetsukukuPartialNIP* netsukuku_coordinator_get_gnode (NetsukukuCoordinator* self) {
	NetsukukuPartialNIP* result;
	NetsukukuPartialNIP* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_gnode;
	result = _tmp0_;
	return result;
}


static void netsukuku_coordinator_set_gnode (NetsukukuCoordinator* self, NetsukukuPartialNIP* value) {
	NetsukukuPartialNIP* _tmp0_;
	NetsukukuPartialNIP* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_gnode);
	self->priv->_gnode = _tmp1_;
	g_object_notify ((GObject *) self, "gnode");
}


gboolean netsukuku_coordinator_get_is_main (NetsukukuCoordinator* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_main_latest_evaluation;
	result = _tmp0_;
	return result;
}


gboolean netsukuku_coordinator_get_was_main (NetsukukuCoordinator* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_main_previous_state;
	result = _tmp0_;
	return result;
}


static NetsukukuCoordinatorPair* netsukuku_coordinator_pair_construct (GType object_type, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GType b_type, GBoxedCopyFunc b_dup_func, GDestroyNotify b_destroy_func, gconstpointer a, gconstpointer b) {
	NetsukukuCoordinatorPair * self = NULL;
	gconstpointer _tmp0_;
	gconstpointer _tmp1_;
	self = (NetsukukuCoordinatorPair*) g_object_new (object_type, NULL);
	self->priv->a_type = a_type;
	self->priv->a_dup_func = a_dup_func;
	self->priv->a_destroy_func = a_destroy_func;
	self->priv->b_type = b_type;
	self->priv->b_dup_func = b_dup_func;
	self->priv->b_destroy_func = b_destroy_func;
	_tmp0_ = a;
	netsukuku_coordinator_pair_set_a (self, _tmp0_);
	_tmp1_ = b;
	netsukuku_coordinator_pair_set_b (self, _tmp1_);
	return self;
}


static NetsukukuCoordinatorPair* netsukuku_coordinator_pair_new (GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GType b_type, GBoxedCopyFunc b_dup_func, GDestroyNotify b_destroy_func, gconstpointer a, gconstpointer b) {
	return netsukuku_coordinator_pair_construct (NETSUKUKU_COORDINATOR_TYPE_PAIR, a_type, a_dup_func, a_destroy_func, b_type, b_dup_func, b_destroy_func, a, b);
}


static gconstpointer netsukuku_coordinator_pair_get_a (NetsukukuCoordinatorPair* self) {
	gconstpointer result;
	gconstpointer _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_a;
	result = _tmp0_;
	return result;
}


static void netsukuku_coordinator_pair_set_a (NetsukukuCoordinatorPair* self, gconstpointer value) {
	gconstpointer _tmp0_;
	gpointer _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = ((_tmp0_ != NULL) && (self->priv->a_dup_func != NULL)) ? self->priv->a_dup_func ((gpointer) _tmp0_) : ((gpointer) _tmp0_);
	((self->priv->_a == NULL) || (self->priv->a_destroy_func == NULL)) ? NULL : (self->priv->_a = (self->priv->a_destroy_func (self->priv->_a), NULL));
	self->priv->_a = _tmp1_;
	g_object_notify ((GObject *) self, "a");
}


static gconstpointer netsukuku_coordinator_pair_get_b (NetsukukuCoordinatorPair* self) {
	gconstpointer result;
	gconstpointer _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_b;
	result = _tmp0_;
	return result;
}


static void netsukuku_coordinator_pair_set_b (NetsukukuCoordinatorPair* self, gconstpointer value) {
	gconstpointer _tmp0_;
	gpointer _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = ((_tmp0_ != NULL) && (self->priv->b_dup_func != NULL)) ? self->priv->b_dup_func ((gpointer) _tmp0_) : ((gpointer) _tmp0_);
	((self->priv->_b == NULL) || (self->priv->b_destroy_func == NULL)) ? NULL : (self->priv->_b = (self->priv->b_destroy_func (self->priv->_b), NULL));
	self->priv->_b = _tmp1_;
	g_object_notify ((GObject *) self, "b");
}


static void netsukuku_coordinator_pair_class_init (NetsukukuCoordinatorPairClass * klass) {
	netsukuku_coordinator_pair_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (NetsukukuCoordinatorPairPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_netsukuku_coordinator_pair_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_netsukuku_coordinator_pair_set_property;
	G_OBJECT_CLASS (klass)->finalize = netsukuku_coordinator_pair_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETSUKUKU_COORDINATOR_PAIR_A_TYPE, g_param_spec_gtype ("a-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETSUKUKU_COORDINATOR_PAIR_A_DUP_FUNC, g_param_spec_pointer ("a-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETSUKUKU_COORDINATOR_PAIR_A_DESTROY_FUNC, g_param_spec_pointer ("a-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETSUKUKU_COORDINATOR_PAIR_B_TYPE, g_param_spec_gtype ("b-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETSUKUKU_COORDINATOR_PAIR_B_DUP_FUNC, g_param_spec_pointer ("b-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETSUKUKU_COORDINATOR_PAIR_B_DESTROY_FUNC, g_param_spec_pointer ("b-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETSUKUKU_COORDINATOR_PAIR_A, g_param_spec_pointer ("a", "a", "a", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETSUKUKU_COORDINATOR_PAIR_B, g_param_spec_pointer ("b", "b", "b", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void netsukuku_coordinator_pair_instance_init (NetsukukuCoordinatorPair * self) {
	self->priv = NETSUKUKU_COORDINATOR_PAIR_GET_PRIVATE (self);
}


static void netsukuku_coordinator_pair_finalize (GObject* obj) {
	NetsukukuCoordinatorPair * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_COORDINATOR_TYPE_PAIR, NetsukukuCoordinatorPair);
	((self->priv->_a == NULL) || (self->priv->a_destroy_func == NULL)) ? NULL : (self->priv->_a = (self->priv->a_destroy_func (self->priv->_a), NULL));
	((self->priv->_b == NULL) || (self->priv->b_destroy_func == NULL)) ? NULL : (self->priv->_b = (self->priv->b_destroy_func (self->priv->_b), NULL));
	G_OBJECT_CLASS (netsukuku_coordinator_pair_parent_class)->finalize (obj);
}


static GType netsukuku_coordinator_pair_get_type (void) {
	static volatile gsize netsukuku_coordinator_pair_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_coordinator_pair_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuCoordinatorPairClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_coordinator_pair_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuCoordinatorPair), 0, (GInstanceInitFunc) netsukuku_coordinator_pair_instance_init, NULL };
		GType netsukuku_coordinator_pair_type_id;
		netsukuku_coordinator_pair_type_id = g_type_register_static (G_TYPE_OBJECT, "NetsukukuCoordinatorPair", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_coordinator_pair_type_id__volatile, netsukuku_coordinator_pair_type_id);
	}
	return netsukuku_coordinator_pair_type_id__volatile;
}


static void _vala_netsukuku_coordinator_pair_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	NetsukukuCoordinatorPair * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETSUKUKU_COORDINATOR_TYPE_PAIR, NetsukukuCoordinatorPair);
	switch (property_id) {
		case NETSUKUKU_COORDINATOR_PAIR_A:
		g_value_set_pointer (value, netsukuku_coordinator_pair_get_a (self));
		break;
		case NETSUKUKU_COORDINATOR_PAIR_B:
		g_value_set_pointer (value, netsukuku_coordinator_pair_get_b (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_netsukuku_coordinator_pair_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	NetsukukuCoordinatorPair * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETSUKUKU_COORDINATOR_TYPE_PAIR, NetsukukuCoordinatorPair);
	switch (property_id) {
		case NETSUKUKU_COORDINATOR_PAIR_A:
		netsukuku_coordinator_pair_set_a (self, g_value_get_pointer (value));
		break;
		case NETSUKUKU_COORDINATOR_PAIR_B:
		netsukuku_coordinator_pair_set_b (self, g_value_get_pointer (value));
		break;
		case NETSUKUKU_COORDINATOR_PAIR_A_TYPE:
		self->priv->a_type = g_value_get_gtype (value);
		break;
		case NETSUKUKU_COORDINATOR_PAIR_A_DUP_FUNC:
		self->priv->a_dup_func = g_value_get_pointer (value);
		break;
		case NETSUKUKU_COORDINATOR_PAIR_A_DESTROY_FUNC:
		self->priv->a_destroy_func = g_value_get_pointer (value);
		break;
		case NETSUKUKU_COORDINATOR_PAIR_B_TYPE:
		self->priv->b_type = g_value_get_gtype (value);
		break;
		case NETSUKUKU_COORDINATOR_PAIR_B_DUP_FUNC:
		self->priv->b_dup_func = g_value_get_pointer (value);
		break;
		case NETSUKUKU_COORDINATOR_PAIR_B_DESTROY_FUNC:
		self->priv->b_destroy_func = g_value_get_pointer (value);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void netsukuku_coordinator_class_init (NetsukukuCoordinatorClass * klass) {
	netsukuku_coordinator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (NetsukukuCoordinatorPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_netsukuku_coordinator_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_netsukuku_coordinator_set_property;
	G_OBJECT_CLASS (klass)->finalize = netsukuku_coordinator_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETSUKUKU_COORDINATOR_GNODE, g_param_spec_object ("gnode", "gnode", "gnode", NETSUKUKU_TYPE_PARTIAL_NIP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETSUKUKU_COORDINATOR_IS_MAIN, g_param_spec_boolean ("is-main", "is-main", "is-main", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETSUKUKU_COORDINATOR_WAS_MAIN, g_param_spec_boolean ("was-main", "was-main", "was-main", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void netsukuku_coordinator_instance_init (NetsukukuCoordinator * self) {
	self->priv = NETSUKUKU_COORDINATOR_GET_PRIVATE (self);
}


static void netsukuku_coordinator_finalize (GObject* obj) {
	NetsukukuCoordinator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_COORDINATOR, NetsukukuCoordinator);
	_g_object_unref0 (self->priv->bookings);
	_g_object_unref0 (self->priv->bnode_list);
	_g_object_unref0 (self->priv->_gnode);
	_g_object_unref0 (self->priv->manage_bnode_tunnels_handle);
	G_OBJECT_CLASS (netsukuku_coordinator_parent_class)->finalize (obj);
}


GType netsukuku_coordinator_get_type (void) {
	static volatile gsize netsukuku_coordinator_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_coordinator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuCoordinatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_coordinator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuCoordinator), 0, (GInstanceInitFunc) netsukuku_coordinator_instance_init, NULL };
		GType netsukuku_coordinator_type_id;
		netsukuku_coordinator_type_id = g_type_register_static (G_TYPE_OBJECT, "NetsukukuCoordinator", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_coordinator_type_id__volatile, netsukuku_coordinator_type_id);
	}
	return netsukuku_coordinator_type_id__volatile;
}


static void _vala_netsukuku_coordinator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	NetsukukuCoordinator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETSUKUKU_TYPE_COORDINATOR, NetsukukuCoordinator);
	switch (property_id) {
		case NETSUKUKU_COORDINATOR_GNODE:
		g_value_set_object (value, netsukuku_coordinator_get_gnode (self));
		break;
		case NETSUKUKU_COORDINATOR_IS_MAIN:
		g_value_set_boolean (value, netsukuku_coordinator_get_is_main (self));
		break;
		case NETSUKUKU_COORDINATOR_WAS_MAIN:
		g_value_set_boolean (value, netsukuku_coordinator_get_was_main (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_netsukuku_coordinator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	NetsukukuCoordinator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETSUKUKU_TYPE_COORDINATOR, NetsukukuCoordinator);
	switch (property_id) {
		case NETSUKUKU_COORDINATOR_GNODE:
		netsukuku_coordinator_set_gnode (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



