/* andna_tester_2.c generated by valac 0.20.1, the Vala compiler
 * generated from andna_tester_2.vala, do not modify */

/*
 *  This file is part of Netsukuku.
 *  (c) Copyright 2011-2014 Luca Dionisi aka lukisi <luca.dionisi@gmail.com>
 *
 *  Netsukuku is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Netsukuku is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Netsukuku.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <tasklet.h>
#include <zcd.h>
#include <netsukuku-rpc.h>
#include <gee.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define NETSUKUKU_TYPE_RMT_PEER (netsukuku_rmt_peer_get_type ())
#define NETSUKUKU_RMT_PEER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_RMT_PEER, NetsukukuRmtPeer))
#define NETSUKUKU_RMT_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_RMT_PEER, NetsukukuRmtPeerClass))
#define NETSUKUKU_IS_RMT_PEER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_RMT_PEER))
#define NETSUKUKU_IS_RMT_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_RMT_PEER))
#define NETSUKUKU_RMT_PEER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_RMT_PEER, NetsukukuRmtPeerClass))

typedef struct _NetsukukuRmtPeer NetsukukuRmtPeer;
typedef struct _NetsukukuRmtPeerClass NetsukukuRmtPeerClass;
typedef struct _NetsukukuRmtPeerPrivate NetsukukuRmtPeerPrivate;

#define NETSUKUKU_TYPE_PEER_TO_PEER (netsukuku_peer_to_peer_get_type ())
#define NETSUKUKU_PEER_TO_PEER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_PEER_TO_PEER, NetsukukuPeerToPeer))
#define NETSUKUKU_PEER_TO_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_PEER_TO_PEER, NetsukukuPeerToPeerClass))
#define NETSUKUKU_IS_PEER_TO_PEER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_PEER_TO_PEER))
#define NETSUKUKU_IS_PEER_TO_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_PEER_TO_PEER))
#define NETSUKUKU_PEER_TO_PEER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_PEER_TO_PEER, NetsukukuPeerToPeerClass))

typedef struct _NetsukukuPeerToPeer NetsukukuPeerToPeer;
typedef struct _NetsukukuPeerToPeerClass NetsukukuPeerToPeerClass;

#define NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR (netsukuku_aggregated_neighbour_get_type ())
#define NETSUKUKU_AGGREGATED_NEIGHBOUR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR, NetsukukuAggregatedNeighbour))
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR, NetsukukuAggregatedNeighbourClass))
#define NETSUKUKU_IS_AGGREGATED_NEIGHBOUR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR))
#define NETSUKUKU_IS_AGGREGATED_NEIGHBOUR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR))
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR, NetsukukuAggregatedNeighbourClass))

typedef struct _NetsukukuAggregatedNeighbour NetsukukuAggregatedNeighbour;
typedef struct _NetsukukuAggregatedNeighbourClass NetsukukuAggregatedNeighbourClass;

#define NETSUKUKU_TYPE_PEER_TO_PEER_ALL (netsukuku_peer_to_peer_all_get_type ())
#define NETSUKUKU_PEER_TO_PEER_ALL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_PEER_TO_PEER_ALL, NetsukukuPeerToPeerAll))
#define NETSUKUKU_PEER_TO_PEER_ALL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_PEER_TO_PEER_ALL, NetsukukuPeerToPeerAllClass))
#define NETSUKUKU_IS_PEER_TO_PEER_ALL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_PEER_TO_PEER_ALL))
#define NETSUKUKU_IS_PEER_TO_PEER_ALL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_PEER_TO_PEER_ALL))
#define NETSUKUKU_PEER_TO_PEER_ALL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_PEER_TO_PEER_ALL, NetsukukuPeerToPeerAllClass))

typedef struct _NetsukukuPeerToPeerAll NetsukukuPeerToPeerAll;
typedef struct _NetsukukuPeerToPeerAllClass NetsukukuPeerToPeerAllClass;
typedef struct _NetsukukuPeerToPeerAllPrivate NetsukukuPeerToPeerAllPrivate;
typedef struct _NetsukukuPeerToPeerPrivate NetsukukuPeerToPeerPrivate;

#define NETSUKUKU_TYPE_MAP_ROUTE (netsukuku_map_route_get_type ())
#define NETSUKUKU_MAP_ROUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_MAP_ROUTE, NetsukukuMapRoute))
#define NETSUKUKU_MAP_ROUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_MAP_ROUTE, NetsukukuMapRouteClass))
#define NETSUKUKU_IS_MAP_ROUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_MAP_ROUTE))
#define NETSUKUKU_IS_MAP_ROUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_MAP_ROUTE))
#define NETSUKUKU_MAP_ROUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_MAP_ROUTE, NetsukukuMapRouteClass))

typedef struct _NetsukukuMapRoute NetsukukuMapRoute;
typedef struct _NetsukukuMapRouteClass NetsukukuMapRouteClass;

#define NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER (netsukuku_aggregated_neighbour_manager_get_type ())
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, NetsukukuAggregatedNeighbourManager))
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, NetsukukuAggregatedNeighbourManagerClass))
#define NETSUKUKU_IS_AGGREGATED_NEIGHBOUR_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER))
#define NETSUKUKU_IS_AGGREGATED_NEIGHBOUR_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER))
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, NetsukukuAggregatedNeighbourManagerClass))

typedef struct _NetsukukuAggregatedNeighbourManager NetsukukuAggregatedNeighbourManager;
typedef struct _NetsukukuAggregatedNeighbourManagerClass NetsukukuAggregatedNeighbourManagerClass;

#define NETSUKUKU_TYPE_OPTIONAL_PEER_TO_PEER (netsukuku_optional_peer_to_peer_get_type ())
#define NETSUKUKU_OPTIONAL_PEER_TO_PEER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_OPTIONAL_PEER_TO_PEER, NetsukukuOptionalPeerToPeer))
#define NETSUKUKU_OPTIONAL_PEER_TO_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_OPTIONAL_PEER_TO_PEER, NetsukukuOptionalPeerToPeerClass))
#define NETSUKUKU_IS_OPTIONAL_PEER_TO_PEER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_OPTIONAL_PEER_TO_PEER))
#define NETSUKUKU_IS_OPTIONAL_PEER_TO_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_OPTIONAL_PEER_TO_PEER))
#define NETSUKUKU_OPTIONAL_PEER_TO_PEER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_OPTIONAL_PEER_TO_PEER, NetsukukuOptionalPeerToPeerClass))

typedef struct _NetsukukuOptionalPeerToPeer NetsukukuOptionalPeerToPeer;
typedef struct _NetsukukuOptionalPeerToPeerClass NetsukukuOptionalPeerToPeerClass;
typedef struct _NetsukukuOptionalPeerToPeerPrivate NetsukukuOptionalPeerToPeerPrivate;
typedef struct _NetsukukuAggregatedNeighbourManagerPrivate NetsukukuAggregatedNeighbourManagerPrivate;
typedef struct _NetsukukuAggregatedNeighbourPrivate NetsukukuAggregatedNeighbourPrivate;

#define NETSUKUKU_TYPE_COUNTER (netsukuku_counter_get_type ())
#define NETSUKUKU_COUNTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_COUNTER, NetsukukuCounter))
#define NETSUKUKU_COUNTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_COUNTER, NetsukukuCounterClass))
#define NETSUKUKU_IS_COUNTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_COUNTER))
#define NETSUKUKU_IS_COUNTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_COUNTER))
#define NETSUKUKU_COUNTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_COUNTER, NetsukukuCounterClass))

typedef struct _NetsukukuCounter NetsukukuCounter;
typedef struct _NetsukukuCounterClass NetsukukuCounterClass;
typedef struct _NetsukukuCounterPrivate NetsukukuCounterPrivate;
typedef struct _NetsukukuMapRoutePrivate NetsukukuMapRoutePrivate;

#define NTK_TEST_TYPE_ANDNA_TESTER (ntk_test_andna_tester_get_type ())
#define NTK_TEST_ANDNA_TESTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NTK_TEST_TYPE_ANDNA_TESTER, NtkTestAndnaTester))
#define NTK_TEST_ANDNA_TESTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NTK_TEST_TYPE_ANDNA_TESTER, NtkTestAndnaTesterClass))
#define NTK_TEST_IS_ANDNA_TESTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NTK_TEST_TYPE_ANDNA_TESTER))
#define NTK_TEST_IS_ANDNA_TESTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NTK_TEST_TYPE_ANDNA_TESTER))
#define NTK_TEST_ANDNA_TESTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NTK_TEST_TYPE_ANDNA_TESTER, NtkTestAndnaTesterClass))

typedef struct _NtkTestAndnaTester NtkTestAndnaTester;
typedef struct _NtkTestAndnaTesterClass NtkTestAndnaTesterClass;
typedef struct _NtkTestAndnaTesterPrivate NtkTestAndnaTesterPrivate;

#define NETSUKUKU_TYPE_KEY_PAIR (netsukuku_key_pair_get_type ())
#define NETSUKUKU_KEY_PAIR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_KEY_PAIR, NetsukukuKeyPair))
#define NETSUKUKU_KEY_PAIR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_KEY_PAIR, NetsukukuKeyPairClass))
#define NETSUKUKU_IS_KEY_PAIR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_KEY_PAIR))
#define NETSUKUKU_IS_KEY_PAIR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_KEY_PAIR))
#define NETSUKUKU_KEY_PAIR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_KEY_PAIR, NetsukukuKeyPairClass))

typedef struct _NetsukukuKeyPair NetsukukuKeyPair;
typedef struct _NetsukukuKeyPairClass NetsukukuKeyPairClass;

#define NETSUKUKU_TYPE_PUBLIC_KEY_WRAPPER (netsukuku_public_key_wrapper_get_type ())
#define NETSUKUKU_PUBLIC_KEY_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_PUBLIC_KEY_WRAPPER, NetsukukuPublicKeyWrapper))
#define NETSUKUKU_PUBLIC_KEY_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_PUBLIC_KEY_WRAPPER, NetsukukuPublicKeyWrapperClass))
#define NETSUKUKU_IS_PUBLIC_KEY_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_PUBLIC_KEY_WRAPPER))
#define NETSUKUKU_IS_PUBLIC_KEY_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_PUBLIC_KEY_WRAPPER))
#define NETSUKUKU_PUBLIC_KEY_WRAPPER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_PUBLIC_KEY_WRAPPER, NetsukukuPublicKeyWrapperClass))

typedef struct _NetsukukuPublicKeyWrapper NetsukukuPublicKeyWrapper;
typedef struct _NetsukukuPublicKeyWrapperClass NetsukukuPublicKeyWrapperClass;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	NETSUKUKU_PEER_TO_PEER_ERROR_REGISTER,
	NETSUKUKU_PEER_TO_PEER_ERROR_GENERIC
} NetsukukuPeerToPeerError;
#define NETSUKUKU_PEER_TO_PEER_ERROR netsukuku_peer_to_peer_error_quark ()
struct _NetsukukuRmtPeer {
	GObject parent_instance;
	NetsukukuRmtPeerPrivate * priv;
};

struct _NetsukukuRmtPeerClass {
	GObjectClass parent_class;
	zcdISerializable* (*rmt) (NetsukukuRmtPeer* self, zcdRemoteCall* data, GError** error);
};

struct _NetsukukuPeerToPeerAll {
	GObject parent_instance;
	NetsukukuPeerToPeerAllPrivate * priv;
};

struct _NetsukukuPeerToPeerAllClass {
	GObjectClass parent_class;
	void (*peer_to_peer_register) (NetsukukuPeerToPeerAll* self, NetsukukuPeerToPeer* peer_to_peer, GError** error);
};

struct _NetsukukuPeerToPeer {
	GObject parent_instance;
	NetsukukuPeerToPeerPrivate * priv;
	NetsukukuMapRoute* maproute;
};

struct _NetsukukuPeerToPeerClass {
	GObjectClass parent_class;
	zcdISerializable* (*_dispatch) (NetsukukuPeerToPeer* self, GObject* caller, zcdRemoteCall* data, GError** error);
	NetsukukuNIP* (*h) (NetsukukuPeerToPeer* self, GObject* key);
};

struct _NetsukukuOptionalPeerToPeer {
	NetsukukuPeerToPeer parent_instance;
	NetsukukuOptionalPeerToPeerPrivate * priv;
	gboolean will_participate;
	gboolean hooked;
	gboolean participant;
};

struct _NetsukukuOptionalPeerToPeerClass {
	NetsukukuPeerToPeerClass parent_class;
};

typedef gboolean (*NetsukukuAcceptRecordCallback) (void* user_data);
typedef void (*NetsukukuRefuseRecordCallback) (void* user_data);
typedef void (*NetsukukuForwardRecordCallback) (GObject* obj1, GeeList* replica_nodes, void* user_data);
struct _NetsukukuAggregatedNeighbourManager {
	GObject parent_instance;
	NetsukukuAggregatedNeighbourManagerPrivate * priv;
};

struct _NetsukukuAggregatedNeighbourManagerClass {
	GObjectClass parent_class;
};

struct _NetsukukuAggregatedNeighbour {
	GObject parent_instance;
	NetsukukuAggregatedNeighbourPrivate * priv;
};

struct _NetsukukuAggregatedNeighbourClass {
	GObjectClass parent_class;
};

struct _NetsukukuCounter {
	GObject parent_instance;
	NetsukukuCounterPrivate * priv;
};

struct _NetsukukuCounterClass {
	GObjectClass parent_class;
};

struct _NetsukukuMapRoute {
	GObject parent_instance;
	NetsukukuMapRoutePrivate * priv;
	gint levels;
	gint gsize;
	NetsukukuNIP* me;
};

struct _NetsukukuMapRouteClass {
	GObjectClass parent_class;
};

struct _NtkTestAndnaTester {
	GObject parent_instance;
	NtkTestAndnaTesterPrivate * priv;
};

struct _NtkTestAndnaTesterClass {
	GObjectClass parent_class;
};

typedef enum  {
	NETSUKUKU_CRYPTO_GCRYPT_ERROR_FAILED
} NetsukukuCryptoGCryptError;
#define NETSUKUKU_CRYPTO_GCRYPT_ERROR netsukuku_crypto_gcrypt_error_quark ()

extern gint64 netsukuku_andna_const_MAX_TTL_ANDNA;
gint64 netsukuku_andna_const_MAX_TTL_ANDNA = (((((gint64) 1000) * ((gint64) 60)) * ((gint64) 60)) * ((gint64) 24)) * ((gint64) 30);
static gpointer netsukuku_rmt_peer_parent_class = NULL;
static gpointer netsukuku_peer_to_peer_all_parent_class = NULL;
static gpointer netsukuku_peer_to_peer_parent_class = NULL;
static gpointer netsukuku_optional_peer_to_peer_parent_class = NULL;
static gpointer netsukuku_aggregated_neighbour_manager_parent_class = NULL;
static gpointer netsukuku_aggregated_neighbour_parent_class = NULL;
static gpointer netsukuku_counter_parent_class = NULL;
static gpointer netsukuku_map_route_parent_class = NULL;
extern gboolean netsukuku_settings_TESTING;
gboolean netsukuku_settings_TESTING = FALSE;
extern gchar* ntk_test_logger;
gchar* ntk_test_logger = NULL;
static gpointer ntk_test_andna_tester_parent_class = NULL;

gchar* netsukuku_tasklet_id (void);
void netsukuku_log_debug (const gchar* msg);
void ntk_test_print_out (const gchar* s);
void netsukuku_log_info (const gchar* msg);
void netsukuku_log_notice (const gchar* msg);
void netsukuku_log_warn (const gchar* msg);
void netsukuku_log_error (const gchar* msg);
void netsukuku_log_critical (const gchar* msg);
GQuark netsukuku_peer_to_peer_error_quark (void);
GType netsukuku_rmt_peer_get_type (void) G_GNUC_CONST;
enum  {
	NETSUKUKU_RMT_PEER_DUMMY_PROPERTY
};
GType netsukuku_peer_to_peer_get_type (void) G_GNUC_CONST;
GType netsukuku_aggregated_neighbour_get_type (void) G_GNUC_CONST;
NetsukukuRmtPeer* netsukuku_rmt_peer_new (NetsukukuPeerToPeer* peer_to_peer_service, GObject* key, NetsukukuNIP* hIP, NetsukukuAggregatedNeighbour* aggregated_neighbour);
NetsukukuRmtPeer* netsukuku_rmt_peer_construct (GType object_type, NetsukukuPeerToPeer* peer_to_peer_service, GObject* key, NetsukukuNIP* hIP, NetsukukuAggregatedNeighbour* aggregated_neighbour);
zcdISerializable* netsukuku_rmt_peer_rmt (NetsukukuRmtPeer* self, zcdRemoteCall* data, GError** error);
static zcdISerializable* netsukuku_rmt_peer_real_rmt (NetsukukuRmtPeer* self, zcdRemoteCall* data, GError** error);
GType netsukuku_peer_to_peer_all_get_type (void) G_GNUC_CONST;
enum  {
	NETSUKUKU_PEER_TO_PEER_ALL_DUMMY_PROPERTY
};
void netsukuku_peer_to_peer_all_peer_to_peer_register (NetsukukuPeerToPeerAll* self, NetsukukuPeerToPeer* peer_to_peer, GError** error);
static void netsukuku_peer_to_peer_all_real_peer_to_peer_register (NetsukukuPeerToPeerAll* self, NetsukukuPeerToPeer* peer_to_peer, GError** error);
NetsukukuPeerToPeerAll* netsukuku_peer_to_peer_all_new (void);
NetsukukuPeerToPeerAll* netsukuku_peer_to_peer_all_construct (GType object_type);
GType netsukuku_map_route_get_type (void) G_GNUC_CONST;
enum  {
	NETSUKUKU_PEER_TO_PEER_DUMMY_PROPERTY
};
GType netsukuku_aggregated_neighbour_manager_get_type (void) G_GNUC_CONST;
NetsukukuPeerToPeer* netsukuku_peer_to_peer_new (NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, gint pid);
NetsukukuPeerToPeer* netsukuku_peer_to_peer_construct (GType object_type, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, gint pid);
zcdISerializable* _netsukuku_peer_to_peer_dispatch (NetsukukuPeerToPeer* self, GObject* caller, zcdRemoteCall* data, GError** error);
static zcdISerializable* netsukuku_peer_to_peer_real__dispatch (NetsukukuPeerToPeer* self, GObject* caller, zcdRemoteCall* data, GError** error);
NetsukukuNIP* netsukuku_peer_to_peer_h (NetsukukuPeerToPeer* self, GObject* key);
static NetsukukuNIP* netsukuku_peer_to_peer_real_h (NetsukukuPeerToPeer* self, GObject* key);
GeeList* netsukuku_peer_to_peer_list_ids (NetsukukuPeerToPeer* self, gint center, gint sign);
void netsukuku_peer_to_peer_find_hook_peers (NetsukukuPeerToPeer* self, gint** ret_first_forward, gint** ret_first_back, gint** ret_last_back, gint lvl, gint num_dupl, gint timeout);
gint netsukuku_peer_to_peer_get_number_of_participants (NetsukukuPeerToPeer* self, gint lvl, gint pos, gint timeout);
GeeList* netsukuku_peer_to_peer_find_nearest_to_register (NetsukukuPeerToPeer* self, NetsukukuNIP* hash_nip, gint num_dupl);
static gboolean _netsukuku_partial_nip_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self);
NetsukukuHCoord* netsukuku_peer_to_peer_search_participant (NetsukukuPeerToPeer* self, NetsukukuNIP* hIP, gint path_sign, GError** error);
NetsukukuPartialNIP* netsukuku_peer_to_peer_search_participant_as_nip (NetsukukuPeerToPeer* self, NetsukukuNIP* hIP, gint path_sign, GError** error);
static void netsukuku_peer_to_peer_finalize (GObject* obj);
GType netsukuku_optional_peer_to_peer_get_type (void) G_GNUC_CONST;
enum  {
	NETSUKUKU_OPTIONAL_PEER_TO_PEER_DUMMY_PROPERTY
};
NetsukukuOptionalPeerToPeer* netsukuku_optional_peer_to_peer_new (NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, gint pid);
NetsukukuOptionalPeerToPeer* netsukuku_optional_peer_to_peer_construct (GType object_type, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, gint pid);
void netsukuku_optional_peer_to_peer_participate (NetsukukuOptionalPeerToPeer* self);
static void netsukuku_optional_peer_to_peer_finalize (GObject* obj);
void netsukuku_check_hash_and_start_replica (NetsukukuPeerToPeer* service, NetsukukuNIP* hash_nip, gboolean replicate, GObject* obj1, gint replica_nodes_max, NetsukukuAcceptRecordCallback accept_callback, void* accept_callback_target, NetsukukuForwardRecordCallback forward_callback, void* forward_callback_target, NetsukukuRefuseRecordCallback refuse_callback, void* refuse_callback_target, GError** error);
enum  {
	NETSUKUKU_AGGREGATED_NEIGHBOUR_MANAGER_DUMMY_PROPERTY
};
NetsukukuAggregatedNeighbourManager* netsukuku_aggregated_neighbour_manager_new (void);
NetsukukuAggregatedNeighbourManager* netsukuku_aggregated_neighbour_manager_construct (GType object_type);
enum  {
	NETSUKUKU_AGGREGATED_NEIGHBOUR_DUMMY_PROPERTY
};
NetsukukuAggregatedNeighbour* netsukuku_aggregated_neighbour_new (void);
NetsukukuAggregatedNeighbour* netsukuku_aggregated_neighbour_construct (GType object_type);
GType netsukuku_counter_get_type (void) G_GNUC_CONST;
enum  {
	NETSUKUKU_COUNTER_DUMMY_PROPERTY
};
NetsukukuCounterCheckHostnameResponse* netsukuku_counter_ask_check_hostname (NetsukukuCounter* self, NetsukukuNIP* nip, const gchar* hashed_hostname, NetsukukuPublicKey* pubkey, GError** error);
NetsukukuCounter* netsukuku_counter_new (void);
NetsukukuCounter* netsukuku_counter_construct (GType object_type);
enum  {
	NETSUKUKU_MAP_ROUTE_DUMMY_PROPERTY
};
NetsukukuMapRoute* netsukuku_map_route_new (gint l, gint s, NetsukukuNIP* n);
NetsukukuMapRoute* netsukuku_map_route_construct (GType object_type, gint l, gint s, NetsukukuNIP* n);
NetsukukuPartialNIP* netsukuku_map_route_choose_fast (NetsukukuMapRoute* self, GeeList* choose_from);
static void netsukuku_map_route_finalize (GObject* obj);
#define NETSUKUKU_COUNTER_DUPLICATION 10
#define NETSUKUKU_ANDNA_DUPLICATION 10
#define NETSUKUKU_MAX_HOSTNAMES 256
#define NETSUKUKU_MAX_TTL_ANDNA ((((((gint64) 1000) * ((gint64) 60)) * ((gint64) 60)) * ((gint64) 24)) * ((gint64) 30))
#define NETSUKUKU_MAX_TTL_OF_NEGATIVE (((gint64) 1000) * ((gint64) 30))
#define NETSUKUKU_MAX_TTL_COUNTER ((((((gint64) 1000) * ((gint64) 60)) * ((gint64) 60)) * ((gint64) 24)) * ((gint64) 30))
#define NETSUKUKU_MAX_WAIT_REFRESH_ANDNA ((((gint64) 1000) * ((gint64) 60)) * ((gint64) 60))
#define NETSUKUKU_MAX_WAIT_REFRESH_COUNTER ((((gint64) 1000) * ((gint64) 60)) * ((gint64) 60))
#define NETSUKUKU_MAX_QUEUE_ANDNA 5
#define NETSUKUKU_SPREAD_ANDNA 9
#define NTK_TEST_output FALSE
GType ntk_test_andna_tester_get_type (void) G_GNUC_CONST;
enum  {
	NTK_TEST_ANDNA_TESTER_DUMMY_PROPERTY
};
void ntk_test_andna_tester_set_up (NtkTestAndnaTester* self);
void ntk_test_andna_tester_tear_down (NtkTestAndnaTester* self);
void ntk_test_andna_tester_test_crypto_hash (NtkTestAndnaTester* self);
gchar* netsukuku_andna_crypto_hash (const gchar* hostname);
void ntk_test_andna_tester_test_signatures (NtkTestAndnaTester* self);
GQuark netsukuku_crypto_gcrypt_error_quark (void);
NetsukukuKeyPair* netsukuku_key_pair_new (const gchar* from_file, GError** error);
NetsukukuKeyPair* netsukuku_key_pair_construct (GType object_type, const gchar* from_file, GError** error);
GType netsukuku_key_pair_get_type (void) G_GNUC_CONST;
GType netsukuku_public_key_wrapper_get_type (void) G_GNUC_CONST;
NetsukukuPublicKeyWrapper* netsukuku_key_pair_get_pub_key (NetsukukuKeyPair* self);
NetsukukuPublicKey* netsukuku_public_key_wrapper_to_pubkey (NetsukukuPublicKeyWrapper* self);
static guchar* _vala_array_dup1 (guchar* self, int length);
guchar* netsukuku_key_pair_sign (NetsukukuKeyPair* self, guchar* msg, int msg_length1, int* result_length1, GError** error);
static guchar* _vala_array_dup2 (guchar* self, int length);
NetsukukuPublicKeyWrapper* netsukuku_public_key_wrapper_new_from_pubk (NetsukukuPublicKey* from_pubk, GError** error);
NetsukukuPublicKeyWrapper* netsukuku_public_key_wrapper_construct_from_pubk (GType object_type, NetsukukuPublicKey* from_pubk, GError** error);
gboolean netsukuku_public_key_wrapper_verify (NetsukukuPublicKeyWrapper* self, guchar* msg, int msg_length1, guchar* signature, int signature_length1, GError** error);
gint ntk_test_andna_tester_main (gchar** args, int args_length1);
static void __lambda11_ (void);
NtkTestAndnaTester* ntk_test_andna_tester_new (void);
NtkTestAndnaTester* ntk_test_andna_tester_construct (GType object_type);
static void ___lambda11__gcallback (void);
static void __lambda12_ (void);
static void ___lambda12__gcallback (void);


gchar* netsukuku_tasklet_id (void) {
	gchar* result = NULL;
	TaskletsTasklet* _tmp0_ = NULL;
	TaskletsTasklet* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	_tmp0_ = tasklets_tasklet_self ();
	_tmp1_ = _tmp0_;
	_tmp2_ = tasklets_tasklet_get_id (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("%i", _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat ("[", _tmp5_, "] ", NULL);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	_g_object_unref0 (_tmp1_);
	result = _tmp7_;
	return result;
}


void netsukuku_log_debug (const gchar* msg) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = netsukuku_tasklet_id ();
	_tmp1_ = _tmp0_;
	_tmp2_ = msg;
	_tmp3_ = g_strconcat (_tmp1_, _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp4_, "\n", NULL);
	_tmp6_ = _tmp5_;
	ntk_test_print_out (_tmp6_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp1_);
}


void netsukuku_log_info (const gchar* msg) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = netsukuku_tasklet_id ();
	_tmp1_ = _tmp0_;
	_tmp2_ = msg;
	_tmp3_ = g_strconcat (_tmp1_, _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp4_, "\n", NULL);
	_tmp6_ = _tmp5_;
	ntk_test_print_out (_tmp6_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp1_);
}


void netsukuku_log_notice (const gchar* msg) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = netsukuku_tasklet_id ();
	_tmp1_ = _tmp0_;
	_tmp2_ = msg;
	_tmp3_ = g_strconcat (_tmp1_, _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp4_, "\n", NULL);
	_tmp6_ = _tmp5_;
	ntk_test_print_out (_tmp6_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp1_);
}


void netsukuku_log_warn (const gchar* msg) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = netsukuku_tasklet_id ();
	_tmp1_ = _tmp0_;
	_tmp2_ = msg;
	_tmp3_ = g_strconcat (_tmp1_, _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp4_, "\n", NULL);
	_tmp6_ = _tmp5_;
	ntk_test_print_out (_tmp6_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp1_);
}


void netsukuku_log_error (const gchar* msg) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = netsukuku_tasklet_id ();
	_tmp1_ = _tmp0_;
	_tmp2_ = msg;
	_tmp3_ = g_strconcat (_tmp1_, _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp4_, "\n", NULL);
	_tmp6_ = _tmp5_;
	ntk_test_print_out (_tmp6_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp1_);
}


void netsukuku_log_critical (const gchar* msg) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = netsukuku_tasklet_id ();
	_tmp1_ = _tmp0_;
	_tmp2_ = msg;
	_tmp3_ = g_strconcat (_tmp1_, _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp4_, "\n", NULL);
	_tmp6_ = _tmp5_;
	ntk_test_print_out (_tmp6_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp1_);
}


GQuark netsukuku_peer_to_peer_error_quark (void) {
	return g_quark_from_static_string ("netsukuku_peer_to_peer_error-quark");
}


NetsukukuRmtPeer* netsukuku_rmt_peer_construct (GType object_type, NetsukukuPeerToPeer* peer_to_peer_service, GObject* key, NetsukukuNIP* hIP, NetsukukuAggregatedNeighbour* aggregated_neighbour) {
	NetsukukuRmtPeer * self = NULL;
	g_return_val_if_fail (peer_to_peer_service != NULL, NULL);
	self = (NetsukukuRmtPeer*) g_object_new (object_type, NULL);
	return self;
}


NetsukukuRmtPeer* netsukuku_rmt_peer_new (NetsukukuPeerToPeer* peer_to_peer_service, GObject* key, NetsukukuNIP* hIP, NetsukukuAggregatedNeighbour* aggregated_neighbour) {
	return netsukuku_rmt_peer_construct (NETSUKUKU_TYPE_RMT_PEER, peer_to_peer_service, key, hIP, aggregated_neighbour);
}


static zcdISerializable* netsukuku_rmt_peer_real_rmt (NetsukukuRmtPeer* self, zcdRemoteCall* data, GError** error) {
	zcdISerializable* result = NULL;
	zcdSerializableNone* _tmp0_;
	g_return_val_if_fail (data != NULL, NULL);
	_tmp0_ = zcd_serializable_none_new ();
	result = (zcdISerializable*) _tmp0_;
	return result;
}


zcdISerializable* netsukuku_rmt_peer_rmt (NetsukukuRmtPeer* self, zcdRemoteCall* data, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return NETSUKUKU_RMT_PEER_GET_CLASS (self)->rmt (self, data, error);
}


static void netsukuku_rmt_peer_class_init (NetsukukuRmtPeerClass * klass) {
	netsukuku_rmt_peer_parent_class = g_type_class_peek_parent (klass);
	NETSUKUKU_RMT_PEER_CLASS (klass)->rmt = netsukuku_rmt_peer_real_rmt;
}


static void netsukuku_rmt_peer_instance_init (NetsukukuRmtPeer * self) {
}


GType netsukuku_rmt_peer_get_type (void) {
	static volatile gsize netsukuku_rmt_peer_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_rmt_peer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuRmtPeerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_rmt_peer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuRmtPeer), 0, (GInstanceInitFunc) netsukuku_rmt_peer_instance_init, NULL };
		GType netsukuku_rmt_peer_type_id;
		netsukuku_rmt_peer_type_id = g_type_register_static (G_TYPE_OBJECT, "NetsukukuRmtPeer", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_rmt_peer_type_id__volatile, netsukuku_rmt_peer_type_id);
	}
	return netsukuku_rmt_peer_type_id__volatile;
}


static void netsukuku_peer_to_peer_all_real_peer_to_peer_register (NetsukukuPeerToPeerAll* self, NetsukukuPeerToPeer* peer_to_peer, GError** error) {
	g_return_if_fail (peer_to_peer != NULL);
}


void netsukuku_peer_to_peer_all_peer_to_peer_register (NetsukukuPeerToPeerAll* self, NetsukukuPeerToPeer* peer_to_peer, GError** error) {
	g_return_if_fail (self != NULL);
	NETSUKUKU_PEER_TO_PEER_ALL_GET_CLASS (self)->peer_to_peer_register (self, peer_to_peer, error);
}


NetsukukuPeerToPeerAll* netsukuku_peer_to_peer_all_construct (GType object_type) {
	NetsukukuPeerToPeerAll * self = NULL;
	self = (NetsukukuPeerToPeerAll*) g_object_new (object_type, NULL);
	return self;
}


NetsukukuPeerToPeerAll* netsukuku_peer_to_peer_all_new (void) {
	return netsukuku_peer_to_peer_all_construct (NETSUKUKU_TYPE_PEER_TO_PEER_ALL);
}


static void netsukuku_peer_to_peer_all_class_init (NetsukukuPeerToPeerAllClass * klass) {
	netsukuku_peer_to_peer_all_parent_class = g_type_class_peek_parent (klass);
	NETSUKUKU_PEER_TO_PEER_ALL_CLASS (klass)->peer_to_peer_register = netsukuku_peer_to_peer_all_real_peer_to_peer_register;
}


static void netsukuku_peer_to_peer_all_instance_init (NetsukukuPeerToPeerAll * self) {
}


GType netsukuku_peer_to_peer_all_get_type (void) {
	static volatile gsize netsukuku_peer_to_peer_all_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_peer_to_peer_all_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuPeerToPeerAllClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_peer_to_peer_all_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuPeerToPeerAll), 0, (GInstanceInitFunc) netsukuku_peer_to_peer_all_instance_init, NULL };
		GType netsukuku_peer_to_peer_all_type_id;
		netsukuku_peer_to_peer_all_type_id = g_type_register_static (G_TYPE_OBJECT, "NetsukukuPeerToPeerAll", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_peer_to_peer_all_type_id__volatile, netsukuku_peer_to_peer_all_type_id);
	}
	return netsukuku_peer_to_peer_all_type_id__volatile;
}


NetsukukuPeerToPeer* netsukuku_peer_to_peer_construct (GType object_type, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, gint pid) {
	NetsukukuPeerToPeer * self = NULL;
	NetsukukuMapRoute* _tmp0_;
	g_return_val_if_fail (aggregated_neighbour_manager != NULL, NULL);
	g_return_val_if_fail (maproute != NULL, NULL);
	self = (NetsukukuPeerToPeer*) g_object_new (object_type, NULL);
	_tmp0_ = maproute;
	self->maproute = _tmp0_;
	return self;
}


NetsukukuPeerToPeer* netsukuku_peer_to_peer_new (NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, gint pid) {
	return netsukuku_peer_to_peer_construct (NETSUKUKU_TYPE_PEER_TO_PEER, aggregated_neighbour_manager, maproute, pid);
}


static zcdISerializable* netsukuku_peer_to_peer_real__dispatch (NetsukukuPeerToPeer* self, GObject* caller, zcdRemoteCall* data, GError** error) {
	zcdISerializable* result = NULL;
	g_return_val_if_fail (data != NULL, NULL);
	result = NULL;
	return result;
}


zcdISerializable* _netsukuku_peer_to_peer_dispatch (NetsukukuPeerToPeer* self, GObject* caller, zcdRemoteCall* data, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return NETSUKUKU_PEER_TO_PEER_GET_CLASS (self)->_dispatch (self, caller, data, error);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static NetsukukuNIP* netsukuku_peer_to_peer_real_h (NetsukukuPeerToPeer* self, GObject* key) {
	NetsukukuNIP* result = NULL;
	GObject* _tmp0_;
	NetsukukuNIP* _tmp1_;
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = key;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, NETSUKUKU_TYPE_NIP, NetsukukuNIP));
	result = _tmp1_;
	return result;
}


NetsukukuNIP* netsukuku_peer_to_peer_h (NetsukukuPeerToPeer* self, GObject* key) {
	g_return_val_if_fail (self != NULL, NULL);
	return NETSUKUKU_PEER_TO_PEER_GET_CLASS (self)->h (self, key);
}


GeeList* netsukuku_peer_to_peer_list_ids (NetsukukuPeerToPeer* self, gint center, gint sign) {
	GeeList* result = NULL;
	GeeArrayList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_INT, NULL, NULL, NULL, NULL, NULL);
	result = (GeeList*) _tmp0_;
	return result;
}


void netsukuku_peer_to_peer_find_hook_peers (NetsukukuPeerToPeer* self, gint** ret_first_forward, gint** ret_first_back, gint** ret_last_back, gint lvl, gint num_dupl, gint timeout) {
	gint* _vala_ret_first_forward = NULL;
	gint* _vala_ret_first_back = NULL;
	gint* _vala_ret_last_back = NULL;
	g_return_if_fail (self != NULL);
	if (ret_first_forward) {
		*ret_first_forward = _vala_ret_first_forward;
	} else {
		_g_free0 (_vala_ret_first_forward);
	}
	if (ret_first_back) {
		*ret_first_back = _vala_ret_first_back;
	} else {
		_g_free0 (_vala_ret_first_back);
	}
	if (ret_last_back) {
		*ret_last_back = _vala_ret_last_back;
	} else {
		_g_free0 (_vala_ret_last_back);
	}
}


gint netsukuku_peer_to_peer_get_number_of_participants (NetsukukuPeerToPeer* self, gint lvl, gint pos, gint timeout) {
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	result = 0;
	return result;
}


static gboolean _netsukuku_partial_nip_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gboolean result;
	result = netsukuku_partial_nip_equal_func (a, b);
	return result;
}


GeeList* netsukuku_peer_to_peer_find_nearest_to_register (NetsukukuPeerToPeer* self, NetsukukuNIP* hash_nip, gint num_dupl) {
	GeeList* result = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* ret;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (hash_nip != NULL, NULL);
	_tmp0_ = gee_array_list_new (NETSUKUKU_TYPE_NIP, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_partial_nip_equal_func_gee_equal_data_func, NULL, NULL);
	ret = _tmp0_;
	result = (GeeList*) ret;
	return result;
}


NetsukukuHCoord* netsukuku_peer_to_peer_search_participant (NetsukukuPeerToPeer* self, NetsukukuNIP* hIP, gint path_sign, GError** error) {
	NetsukukuHCoord* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (hIP != NULL, NULL);
	result = NULL;
	return result;
}


NetsukukuPartialNIP* netsukuku_peer_to_peer_search_participant_as_nip (NetsukukuPeerToPeer* self, NetsukukuNIP* hIP, gint path_sign, GError** error) {
	NetsukukuPartialNIP* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (hIP != NULL, NULL);
	result = NULL;
	return result;
}


static void netsukuku_peer_to_peer_class_init (NetsukukuPeerToPeerClass * klass) {
	netsukuku_peer_to_peer_parent_class = g_type_class_peek_parent (klass);
	NETSUKUKU_PEER_TO_PEER_CLASS (klass)->_dispatch = netsukuku_peer_to_peer_real__dispatch;
	NETSUKUKU_PEER_TO_PEER_CLASS (klass)->h = netsukuku_peer_to_peer_real_h;
	G_OBJECT_CLASS (klass)->finalize = netsukuku_peer_to_peer_finalize;
	g_signal_new ("map_peer_to_peer_validated", NETSUKUKU_TYPE_PEER_TO_PEER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void netsukuku_peer_to_peer_instance_init (NetsukukuPeerToPeer * self) {
}


static void netsukuku_peer_to_peer_finalize (GObject* obj) {
	NetsukukuPeerToPeer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_PEER_TO_PEER, NetsukukuPeerToPeer);
	G_OBJECT_CLASS (netsukuku_peer_to_peer_parent_class)->finalize (obj);
}


GType netsukuku_peer_to_peer_get_type (void) {
	static volatile gsize netsukuku_peer_to_peer_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_peer_to_peer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuPeerToPeerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_peer_to_peer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuPeerToPeer), 0, (GInstanceInitFunc) netsukuku_peer_to_peer_instance_init, NULL };
		GType netsukuku_peer_to_peer_type_id;
		netsukuku_peer_to_peer_type_id = g_type_register_static (G_TYPE_OBJECT, "NetsukukuPeerToPeer", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_peer_to_peer_type_id__volatile, netsukuku_peer_to_peer_type_id);
	}
	return netsukuku_peer_to_peer_type_id__volatile;
}


NetsukukuOptionalPeerToPeer* netsukuku_optional_peer_to_peer_construct (GType object_type, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, gint pid) {
	NetsukukuOptionalPeerToPeer * self = NULL;
	NetsukukuAggregatedNeighbourManager* _tmp0_;
	NetsukukuMapRoute* _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (aggregated_neighbour_manager != NULL, NULL);
	g_return_val_if_fail (maproute != NULL, NULL);
	_tmp0_ = aggregated_neighbour_manager;
	_tmp1_ = maproute;
	_tmp2_ = pid;
	self = (NetsukukuOptionalPeerToPeer*) netsukuku_peer_to_peer_construct (object_type, _tmp0_, _tmp1_, _tmp2_);
	return self;
}


NetsukukuOptionalPeerToPeer* netsukuku_optional_peer_to_peer_new (NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, gint pid) {
	return netsukuku_optional_peer_to_peer_construct (NETSUKUKU_TYPE_OPTIONAL_PEER_TO_PEER, aggregated_neighbour_manager, maproute, pid);
}


void netsukuku_optional_peer_to_peer_participate (NetsukukuOptionalPeerToPeer* self) {
	g_return_if_fail (self != NULL);
	self->hooked = TRUE;
}


static void netsukuku_optional_peer_to_peer_class_init (NetsukukuOptionalPeerToPeerClass * klass) {
	netsukuku_optional_peer_to_peer_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = netsukuku_optional_peer_to_peer_finalize;
}


static void netsukuku_optional_peer_to_peer_instance_init (NetsukukuOptionalPeerToPeer * self) {
	self->hooked = FALSE;
}


static void netsukuku_optional_peer_to_peer_finalize (GObject* obj) {
	NetsukukuOptionalPeerToPeer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_OPTIONAL_PEER_TO_PEER, NetsukukuOptionalPeerToPeer);
	G_OBJECT_CLASS (netsukuku_optional_peer_to_peer_parent_class)->finalize (obj);
}


GType netsukuku_optional_peer_to_peer_get_type (void) {
	static volatile gsize netsukuku_optional_peer_to_peer_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_optional_peer_to_peer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuOptionalPeerToPeerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_optional_peer_to_peer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuOptionalPeerToPeer), 0, (GInstanceInitFunc) netsukuku_optional_peer_to_peer_instance_init, NULL };
		GType netsukuku_optional_peer_to_peer_type_id;
		netsukuku_optional_peer_to_peer_type_id = g_type_register_static (NETSUKUKU_TYPE_PEER_TO_PEER, "NetsukukuOptionalPeerToPeer", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_optional_peer_to_peer_type_id__volatile, netsukuku_optional_peer_to_peer_type_id);
	}
	return netsukuku_optional_peer_to_peer_type_id__volatile;
}


void netsukuku_check_hash_and_start_replica (NetsukukuPeerToPeer* service, NetsukukuNIP* hash_nip, gboolean replicate, GObject* obj1, gint replica_nodes_max, NetsukukuAcceptRecordCallback accept_callback, void* accept_callback_target, NetsukukuForwardRecordCallback forward_callback, void* forward_callback_target, NetsukukuRefuseRecordCallback refuse_callback, void* refuse_callback_target, GError** error) {
	g_return_if_fail (service != NULL);
	g_return_if_fail (hash_nip != NULL);
}


NetsukukuAggregatedNeighbourManager* netsukuku_aggregated_neighbour_manager_construct (GType object_type) {
	NetsukukuAggregatedNeighbourManager * self = NULL;
	self = (NetsukukuAggregatedNeighbourManager*) g_object_new (object_type, NULL);
	return self;
}


NetsukukuAggregatedNeighbourManager* netsukuku_aggregated_neighbour_manager_new (void) {
	return netsukuku_aggregated_neighbour_manager_construct (NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER);
}


static void netsukuku_aggregated_neighbour_manager_class_init (NetsukukuAggregatedNeighbourManagerClass * klass) {
	netsukuku_aggregated_neighbour_manager_parent_class = g_type_class_peek_parent (klass);
}


static void netsukuku_aggregated_neighbour_manager_instance_init (NetsukukuAggregatedNeighbourManager * self) {
}


GType netsukuku_aggregated_neighbour_manager_get_type (void) {
	static volatile gsize netsukuku_aggregated_neighbour_manager_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_aggregated_neighbour_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuAggregatedNeighbourManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_aggregated_neighbour_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuAggregatedNeighbourManager), 0, (GInstanceInitFunc) netsukuku_aggregated_neighbour_manager_instance_init, NULL };
		GType netsukuku_aggregated_neighbour_manager_type_id;
		netsukuku_aggregated_neighbour_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "NetsukukuAggregatedNeighbourManager", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_aggregated_neighbour_manager_type_id__volatile, netsukuku_aggregated_neighbour_manager_type_id);
	}
	return netsukuku_aggregated_neighbour_manager_type_id__volatile;
}


NetsukukuAggregatedNeighbour* netsukuku_aggregated_neighbour_construct (GType object_type) {
	NetsukukuAggregatedNeighbour * self = NULL;
	self = (NetsukukuAggregatedNeighbour*) g_object_new (object_type, NULL);
	return self;
}


NetsukukuAggregatedNeighbour* netsukuku_aggregated_neighbour_new (void) {
	return netsukuku_aggregated_neighbour_construct (NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR);
}


static void netsukuku_aggregated_neighbour_class_init (NetsukukuAggregatedNeighbourClass * klass) {
	netsukuku_aggregated_neighbour_parent_class = g_type_class_peek_parent (klass);
}


static void netsukuku_aggregated_neighbour_instance_init (NetsukukuAggregatedNeighbour * self) {
}


GType netsukuku_aggregated_neighbour_get_type (void) {
	static volatile gsize netsukuku_aggregated_neighbour_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_aggregated_neighbour_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuAggregatedNeighbourClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_aggregated_neighbour_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuAggregatedNeighbour), 0, (GInstanceInitFunc) netsukuku_aggregated_neighbour_instance_init, NULL };
		GType netsukuku_aggregated_neighbour_type_id;
		netsukuku_aggregated_neighbour_type_id = g_type_register_static (G_TYPE_OBJECT, "NetsukukuAggregatedNeighbour", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_aggregated_neighbour_type_id__volatile, netsukuku_aggregated_neighbour_type_id);
	}
	return netsukuku_aggregated_neighbour_type_id__volatile;
}


NetsukukuCounterCheckHostnameResponse* netsukuku_counter_ask_check_hostname (NetsukukuCounter* self, NetsukukuNIP* nip, const gchar* hashed_hostname, NetsukukuPublicKey* pubkey, GError** error) {
	NetsukukuCounterCheckHostnameResponse* result = NULL;
	GError* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (nip != NULL, NULL);
	g_return_val_if_fail (hashed_hostname != NULL, NULL);
	g_return_val_if_fail (pubkey != NULL, NULL);
	_tmp0_ = g_error_new_literal (NETSUKUKU_PEER_REFUSE_SERVICE_ERROR, NETSUKUKU_PEER_REFUSE_SERVICE_ERROR_GENERIC, "not impl");
	_inner_error_ = _tmp0_;
	if ((_inner_error_->domain == ZCD_RPC_ERROR) || (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR)) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return result;
}


NetsukukuCounter* netsukuku_counter_construct (GType object_type) {
	NetsukukuCounter * self = NULL;
	self = (NetsukukuCounter*) g_object_new (object_type, NULL);
	return self;
}


NetsukukuCounter* netsukuku_counter_new (void) {
	return netsukuku_counter_construct (NETSUKUKU_TYPE_COUNTER);
}


static void netsukuku_counter_class_init (NetsukukuCounterClass * klass) {
	netsukuku_counter_parent_class = g_type_class_peek_parent (klass);
}


static void netsukuku_counter_instance_init (NetsukukuCounter * self) {
}


GType netsukuku_counter_get_type (void) {
	static volatile gsize netsukuku_counter_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_counter_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuCounterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_counter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuCounter), 0, (GInstanceInitFunc) netsukuku_counter_instance_init, NULL };
		GType netsukuku_counter_type_id;
		netsukuku_counter_type_id = g_type_register_static (G_TYPE_OBJECT, "NetsukukuCounter", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_counter_type_id__volatile, netsukuku_counter_type_id);
	}
	return netsukuku_counter_type_id__volatile;
}


NetsukukuMapRoute* netsukuku_map_route_construct (GType object_type, gint l, gint s, NetsukukuNIP* n) {
	NetsukukuMapRoute * self = NULL;
	gint _tmp0_;
	gint _tmp1_;
	NetsukukuNIP* _tmp2_;
	NetsukukuNIP* _tmp3_;
	g_return_val_if_fail (n != NULL, NULL);
	self = (NetsukukuMapRoute*) g_object_new (object_type, NULL);
	_tmp0_ = l;
	self->levels = _tmp0_;
	_tmp1_ = s;
	self->gsize = _tmp1_;
	_tmp2_ = n;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->me);
	self->me = _tmp3_;
	return self;
}


NetsukukuMapRoute* netsukuku_map_route_new (gint l, gint s, NetsukukuNIP* n) {
	return netsukuku_map_route_construct (NETSUKUKU_TYPE_MAP_ROUTE, l, s, n);
}


NetsukukuPartialNIP* netsukuku_map_route_choose_fast (NetsukukuMapRoute* self, GeeList* choose_from) {
	NetsukukuPartialNIP* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (choose_from != NULL, NULL);
	result = NULL;
	return result;
}


static void netsukuku_map_route_class_init (NetsukukuMapRouteClass * klass) {
	netsukuku_map_route_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = netsukuku_map_route_finalize;
}


static void netsukuku_map_route_instance_init (NetsukukuMapRoute * self) {
}


static void netsukuku_map_route_finalize (GObject* obj) {
	NetsukukuMapRoute * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_MAP_ROUTE, NetsukukuMapRoute);
	_g_object_unref0 (self->me);
	G_OBJECT_CLASS (netsukuku_map_route_parent_class)->finalize (obj);
}


GType netsukuku_map_route_get_type (void) {
	static volatile gsize netsukuku_map_route_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_map_route_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuMapRouteClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_map_route_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuMapRoute), 0, (GInstanceInitFunc) netsukuku_map_route_instance_init, NULL };
		GType netsukuku_map_route_type_id;
		netsukuku_map_route_type_id = g_type_register_static (G_TYPE_OBJECT, "NetsukukuMapRoute", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_map_route_type_id__volatile, netsukuku_map_route_type_id);
	}
	return netsukuku_map_route_type_id__volatile;
}


void ntk_test_print_out (const gchar* s) {
	g_return_if_fail (s != NULL);
	if (NTK_TEST_output) {
		const gchar* _tmp0_;
		_tmp0_ = s;
		g_print ("%s", _tmp0_);
	}
}


void ntk_test_andna_tester_set_up (NtkTestAndnaTester* self) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("");
	_g_free0 (ntk_test_logger);
	ntk_test_logger = _tmp0_;
}


void ntk_test_andna_tester_tear_down (NtkTestAndnaTester* self) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("");
	_g_free0 (ntk_test_logger);
	ntk_test_logger = _tmp0_;
}


void ntk_test_andna_tester_test_crypto_hash (NtkTestAndnaTester* self) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp0_ = netsukuku_andna_crypto_hash ("pippo");
	_tmp1_ = _tmp0_;
	netsukuku_log_debug (_tmp1_);
	_g_free0 (_tmp1_);
	_tmp2_ = netsukuku_andna_crypto_hash ("plippo");
	_tmp3_ = _tmp2_;
	netsukuku_log_debug (_tmp3_);
	_g_free0 (_tmp3_);
	_tmp4_ = netsukuku_andna_crypto_hash ("PiPPo");
	_tmp5_ = _tmp4_;
	netsukuku_log_debug (_tmp5_);
	_g_free0 (_tmp5_);
	_tmp6_ = netsukuku_andna_crypto_hash ("pippo");
	_tmp7_ = _tmp6_;
	_vala_assert (g_strcmp0 (_tmp7_, "cXJewoJPKqAvN1dcxJyZKA") == 0, "Andna.crypto_hash(\"pippo\") == \"cXJewoJPKqAvN1dcxJyZKA\"");
	_g_free0 (_tmp7_);
	_tmp8_ = netsukuku_andna_crypto_hash ("PiPPo");
	_tmp9_ = _tmp8_;
	_vala_assert (g_strcmp0 (_tmp9_, "cXJewoJPKqAvN1dcxJyZKA") == 0, "Andna.crypto_hash(\"PiPPo\") == \"cXJewoJPKqAvN1dcxJyZKA\"");
	_g_free0 (_tmp9_);
	_tmp10_ = netsukuku_andna_crypto_hash ("pippo");
	_tmp11_ = _tmp10_;
	_tmp12_ = netsukuku_andna_crypto_hash ("plippo");
	_tmp13_ = _tmp12_;
	_vala_assert (g_strcmp0 (_tmp11_, _tmp13_) != 0, "Andna.crypto_hash(\"pippo\") != Andna.crypto_hash(\"plippo\")");
	_g_free0 (_tmp13_);
	_g_free0 (_tmp11_);
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static guchar* _vala_array_dup1 (guchar* self, int length) {
	return g_memdup (self, length * sizeof (guchar));
}


static guchar* _vala_array_dup2 (guchar* self, int length) {
	return g_memdup (self, length * sizeof (guchar));
}


void ntk_test_andna_tester_test_signatures (NtkTestAndnaTester* self) {
	NetsukukuKeyPair* _tmp0_;
	NetsukukuKeyPair* keypair;
	NetsukukuKeyPair* _tmp1_;
	NetsukukuPublicKeyWrapper* _tmp2_;
	NetsukukuPublicKeyWrapper* _tmp3_;
	NetsukukuPublicKey* _tmp4_ = NULL;
	NetsukukuPublicKey* pubkey;
	gint* _tmp5_ = NULL;
	gint* _tmp6_;
	gint _tmp6__length1;
	NetsukukuNIP* _tmp7_;
	NetsukukuNIP* _tmp8_;
	NetsukukuNIP* maproute_me;
	GeeArrayList* _tmp9_;
	GeeArrayList* hashednames;
	GeeArrayList* _tmp10_;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
	guchar* message_prepared_in_client = NULL;
	gint message_prepared_in_client_length1 = 0;
	gint _message_prepared_in_client_size_ = 0;
	guchar* _tmp69_;
	gint _tmp69__length1;
	gchar* _tmp70_ = NULL;
	gchar* _tmp71_;
	const gchar* _tmp72_ = NULL;
	gchar* _tmp73_ = NULL;
	gchar* _tmp74_;
	NetsukukuKeyPair* _tmp75_;
	guchar* _tmp76_;
	gint _tmp76__length1;
	gint _tmp77_ = 0;
	guchar* _tmp78_ = NULL;
	guchar* _signed_;
	gint _signed__length1;
	gint __signed__size_;
	guchar* _tmp79_;
	gint _tmp79__length1;
	zcdSerializableBuffer* _tmp80_;
	zcdSerializableBuffer* signature;
	zcdRemoteCall* _tmp81_;
	zcdRemoteCall* rc;
	zcdRemoteCall* _tmp82_;
	gchar* _tmp83_;
	zcdRemoteCall* _tmp84_;
	NetsukukuNIP* _tmp85_;
	zcdRemoteCall* _tmp86_;
	GeeArrayList* _tmp87_;
	zcdListString* _tmp88_;
	zcdListString* _tmp89_;
	zcdRemoteCall* _tmp90_;
	NetsukukuPublicKey* _tmp91_;
	zcdRemoteCall* _tmp92_;
	zcdSerializableBuffer* _tmp93_;
	zcdRemoteCall* _tmp94_;
	gint _tmp95_ = 0;
	guchar* _tmp96_ = NULL;
	guchar* _tmp97_;
	gint _tmp97__length1;
	zcdISerializable* _tmp98_ = NULL;
	zcdISerializable* _tmp99_;
	zcdISerializable* _tmp100_;
	zcdRemoteCall* data;
	zcdRemoteCall* _tmp101_;
	GeeList* _tmp102_;
	GeeList* _tmp103_;
	gpointer _tmp104_ = NULL;
	zcdISerializable* iser0;
	zcdISerializable* _tmp105_;
	GType _tmp106_ = 0UL;
	gboolean _tmp107_ = FALSE;
	zcdISerializable* _tmp109_;
	NetsukukuNIP* _tmp110_;
	NetsukukuNIP* ported_nip;
	zcdRemoteCall* _tmp111_;
	GeeList* _tmp112_;
	GeeList* _tmp113_;
	gpointer _tmp114_ = NULL;
	zcdISerializable* iser1;
	zcdISerializable* _tmp115_;
	GType _tmp116_ = 0UL;
	gboolean _tmp117_ = FALSE;
	zcdISerializable* _tmp119_;
	zcdListString* _tmp120_;
	zcdListString* _hashed_hostnames;
	zcdListString* _tmp121_;
	GeeList* _tmp122_;
	GeeList* _tmp123_;
	GeeList* ported_hashed_hostnames;
	zcdRemoteCall* _tmp124_;
	GeeList* _tmp125_;
	GeeList* _tmp126_;
	gpointer _tmp127_ = NULL;
	zcdISerializable* iser2;
	zcdISerializable* _tmp128_;
	GType _tmp129_ = 0UL;
	gboolean _tmp130_ = FALSE;
	zcdISerializable* _tmp132_;
	NetsukukuPublicKey* _tmp133_;
	NetsukukuPublicKey* ported_pubkey;
	zcdRemoteCall* _tmp134_;
	GeeList* _tmp135_;
	GeeList* _tmp136_;
	gpointer _tmp137_ = NULL;
	zcdISerializable* iser3;
	zcdISerializable* _tmp138_;
	GType _tmp139_ = 0UL;
	gboolean _tmp140_ = FALSE;
	zcdISerializable* _tmp142_;
	zcdSerializableBuffer* _tmp143_;
	zcdSerializableBuffer* ported_signature;
	guchar* message_prepared_in_server = NULL;
	gint message_prepared_in_server_length1 = 0;
	gint _message_prepared_in_server_size_ = 0;
	guchar* _tmp200_;
	gint _tmp200__length1;
	gchar* _tmp201_ = NULL;
	gchar* _tmp202_;
	const gchar* _tmp203_ = NULL;
	gchar* _tmp204_ = NULL;
	gchar* _tmp205_;
	NetsukukuPublicKey* _tmp206_;
	NetsukukuPublicKeyWrapper* _tmp207_;
	NetsukukuPublicKeyWrapper* pkw;
	NetsukukuPublicKeyWrapper* _tmp208_;
	guchar* _tmp209_;
	gint _tmp209__length1;
	zcdSerializableBuffer* _tmp210_;
	guint8* _tmp211_;
	gint _tmp211__length1;
	guint8* _tmp212_;
	gint _tmp212__length1;
	gboolean _tmp213_ = FALSE;
	gboolean ret;
	gboolean _tmp214_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = netsukuku_key_pair_new (NULL, &_inner_error_);
	keypair = _tmp0_;
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp1_ = keypair;
	_tmp2_ = netsukuku_key_pair_get_pub_key (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = netsukuku_public_key_wrapper_to_pubkey (_tmp3_);
	pubkey = _tmp4_;
	_tmp5_ = g_new0 (gint, 4);
	_tmp5_[0] = 1;
	_tmp5_[1] = 2;
	_tmp5_[2] = 3;
	_tmp5_[3] = 4;
	_tmp6_ = _tmp5_;
	_tmp6__length1 = 4;
	_tmp7_ = netsukuku_nip_new (_tmp6_, 4);
	_tmp8_ = _tmp7_;
	_tmp6_ = (g_free (_tmp6_), NULL);
	maproute_me = _tmp8_;
	_tmp9_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	hashednames = _tmp9_;
	_tmp10_ = hashednames;
	_tmp11_ = netsukuku_andna_crypto_hash ("pegasus.lukisinet");
	_tmp12_ = _tmp11_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp10_, _tmp12_);
	_g_free0 (_tmp12_);
	{
		NetsukukuNIP* _tmp13_;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_;
		NetsukukuNIP* _tmp18_;
		gint _tmp19_ = 0;
		guchar* _tmp20_ = NULL;
		guchar* message1;
		gint message1_length1;
		gint _message1_size_;
		GeeArrayList* _tmp36_;
		zcdListString* _tmp37_;
		zcdListString* _tmp38_;
		gint _tmp39_ = 0;
		guchar* _tmp40_ = NULL;
		guchar* _tmp41_;
		gint _tmp41__length1;
		guchar* message2;
		gint message2_length1;
		gint _message2_size_;
		guchar* _tmp42_;
		gint _tmp42__length1;
		guchar* _tmp43_;
		gint _tmp43__length1;
		guchar* _tmp44_ = NULL;
		guchar* message;
		gint message_length1;
		gint _message_size_;
		gint im;
		guchar* _tmp67_;
		gint _tmp67__length1;
		guchar* _tmp68_;
		gint _tmp68__length1;
		_tmp13_ = maproute_me;
		_tmp14_ = netsukuku_partial_nip_to_string ((NetsukukuPartialNIP*) _tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = g_strconcat ("nip ", _tmp15_, NULL);
		_tmp17_ = _tmp16_;
		netsukuku_log_debug (_tmp17_);
		_g_free0 (_tmp17_);
		_g_free0 (_tmp15_);
		_tmp18_ = maproute_me;
		_tmp20_ = netsukuku_partial_nip_hash_for_signature ((NetsukukuPartialNIP*) _tmp18_, &_tmp19_);
		message1 = _tmp20_;
		message1_length1 = _tmp19_;
		_message1_size_ = message1_length1;
		{
			GeeArrayList* _tmp21_;
			GeeArrayList* _tmp22_;
			GeeArrayList* _s_list;
			GeeArrayList* _tmp23_;
			gint _tmp24_;
			gint _tmp25_;
			gint _s_size;
			gint _s_index;
			_tmp21_ = hashednames;
			_tmp22_ = _g_object_ref0 (_tmp21_);
			_s_list = _tmp22_;
			_tmp23_ = _s_list;
			_tmp24_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp23_);
			_tmp25_ = _tmp24_;
			_s_size = _tmp25_;
			_s_index = -1;
			while (TRUE) {
				gint _tmp26_;
				gint _tmp27_;
				gint _tmp28_;
				GeeArrayList* _tmp29_;
				gint _tmp30_;
				gpointer _tmp31_ = NULL;
				gchar* s;
				const gchar* _tmp32_;
				const gchar* _tmp33_ = NULL;
				gchar* _tmp34_ = NULL;
				gchar* _tmp35_;
				_tmp26_ = _s_index;
				_s_index = _tmp26_ + 1;
				_tmp27_ = _s_index;
				_tmp28_ = _s_size;
				if (!(_tmp27_ < _tmp28_)) {
					break;
				}
				_tmp29_ = _s_list;
				_tmp30_ = _s_index;
				_tmp31_ = gee_abstract_list_get ((GeeAbstractList*) _tmp29_, _tmp30_);
				s = (gchar*) _tmp31_;
				_tmp32_ = s;
				_tmp33_ = string_to_string (_tmp32_);
				_tmp34_ = g_strconcat ("hashedname ", _tmp33_, NULL);
				_tmp35_ = _tmp34_;
				netsukuku_log_debug (_tmp35_);
				_g_free0 (_tmp35_);
				_g_free0 (s);
			}
			_g_object_unref0 (_s_list);
		}
		_tmp36_ = hashednames;
		_tmp37_ = zcd_list_string_new_with_backer ((GeeList*) _tmp36_);
		_tmp38_ = _tmp37_;
		_tmp40_ = zcd_list_string_hash_for_signature (_tmp38_, &_tmp39_);
		_tmp41_ = _tmp40_;
		_tmp41__length1 = _tmp39_;
		_g_object_unref0 (_tmp38_);
		message2 = _tmp41_;
		message2_length1 = _tmp41__length1;
		_message2_size_ = message2_length1;
		_tmp42_ = message1;
		_tmp42__length1 = message1_length1;
		_tmp43_ = message2;
		_tmp43__length1 = message2_length1;
		_tmp44_ = g_new0 (guchar, _tmp42__length1 + _tmp43__length1);
		message = _tmp44_;
		message_length1 = _tmp42__length1 + _tmp43__length1;
		_message_size_ = message_length1;
		im = 0;
		{
			gint i;
			i = 0;
			{
				gboolean _tmp45_;
				_tmp45_ = TRUE;
				while (TRUE) {
					gboolean _tmp46_;
					gint _tmp48_;
					guchar* _tmp49_;
					gint _tmp49__length1;
					guchar* _tmp50_;
					gint _tmp50__length1;
					gint _tmp51_;
					guchar* _tmp52_;
					gint _tmp52__length1;
					gint _tmp53_;
					guchar _tmp54_;
					guchar _tmp55_;
					_tmp46_ = _tmp45_;
					if (!_tmp46_) {
						gint _tmp47_;
						_tmp47_ = i;
						i = _tmp47_ + 1;
					}
					_tmp45_ = FALSE;
					_tmp48_ = i;
					_tmp49_ = message1;
					_tmp49__length1 = message1_length1;
					if (!(_tmp48_ < _tmp49__length1)) {
						break;
					}
					_tmp50_ = message;
					_tmp50__length1 = message_length1;
					_tmp51_ = im;
					im = _tmp51_ + 1;
					_tmp52_ = message1;
					_tmp52__length1 = message1_length1;
					_tmp53_ = i;
					_tmp54_ = _tmp52_[_tmp53_];
					_tmp50_[_tmp51_] = _tmp54_;
					_tmp55_ = _tmp50_[_tmp51_];
				}
			}
		}
		{
			gint i;
			i = 0;
			{
				gboolean _tmp56_;
				_tmp56_ = TRUE;
				while (TRUE) {
					gboolean _tmp57_;
					gint _tmp59_;
					guchar* _tmp60_;
					gint _tmp60__length1;
					guchar* _tmp61_;
					gint _tmp61__length1;
					gint _tmp62_;
					guchar* _tmp63_;
					gint _tmp63__length1;
					gint _tmp64_;
					guchar _tmp65_;
					guchar _tmp66_;
					_tmp57_ = _tmp56_;
					if (!_tmp57_) {
						gint _tmp58_;
						_tmp58_ = i;
						i = _tmp58_ + 1;
					}
					_tmp56_ = FALSE;
					_tmp59_ = i;
					_tmp60_ = message2;
					_tmp60__length1 = message2_length1;
					if (!(_tmp59_ < _tmp60__length1)) {
						break;
					}
					_tmp61_ = message;
					_tmp61__length1 = message_length1;
					_tmp62_ = im;
					im = _tmp62_ + 1;
					_tmp63_ = message2;
					_tmp63__length1 = message2_length1;
					_tmp64_ = i;
					_tmp65_ = _tmp63_[_tmp64_];
					_tmp61_[_tmp62_] = _tmp65_;
					_tmp66_ = _tmp61_[_tmp62_];
				}
			}
		}
		_tmp67_ = message;
		_tmp67__length1 = message_length1;
		_tmp68_ = (_tmp67_ != NULL) ? _vala_array_dup1 (_tmp67_, _tmp67__length1) : ((gpointer) _tmp67_);
		_tmp68__length1 = _tmp67__length1;
		message_prepared_in_client = (g_free (message_prepared_in_client), NULL);
		message_prepared_in_client = _tmp68_;
		message_prepared_in_client_length1 = _tmp68__length1;
		_message_prepared_in_client_size_ = message_prepared_in_client_length1;
		message = (g_free (message), NULL);
		message2 = (g_free (message2), NULL);
		message1 = (g_free (message1), NULL);
	}
	_tmp69_ = message_prepared_in_client;
	_tmp69__length1 = message_prepared_in_client_length1;
	_tmp70_ = g_base64_encode (_tmp69_, _tmp69__length1);
	_tmp71_ = _tmp70_;
	_tmp72_ = string_to_string (_tmp71_);
	_tmp73_ = g_strconcat ("message_prepared_in_client ", _tmp72_, NULL);
	_tmp74_ = _tmp73_;
	netsukuku_log_debug (_tmp74_);
	_g_free0 (_tmp74_);
	_g_free0 (_tmp71_);
	_tmp75_ = keypair;
	_tmp76_ = message_prepared_in_client;
	_tmp76__length1 = message_prepared_in_client_length1;
	_tmp78_ = netsukuku_key_pair_sign (_tmp75_, _tmp76_, _tmp76__length1, &_tmp77_, &_inner_error_);
	_signed_ = _tmp78_;
	_signed__length1 = _tmp77_;
	__signed__size_ = _signed__length1;
	if (_inner_error_ != NULL) {
		message_prepared_in_client = (g_free (message_prepared_in_client), NULL);
		_g_object_unref0 (hashednames);
		_g_object_unref0 (maproute_me);
		_g_object_unref0 (pubkey);
		_g_object_unref0 (keypair);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp79_ = _signed_;
	_tmp79__length1 = _signed__length1;
	_tmp80_ = zcd_serializable_buffer_new ((guint8*) _tmp79_, (_tmp79__length1 * sizeof (guchar)) / sizeof (guint8));
	signature = _tmp80_;
	_tmp81_ = zcd_remote_call_new ();
	rc = _tmp81_;
	_tmp82_ = rc;
	_tmp83_ = g_strdup ("set_data_for_pubk");
	_g_free0 (_tmp82_->method_name);
	_tmp82_->method_name = _tmp83_;
	_tmp84_ = rc;
	_tmp85_ = maproute_me;
	zcd_remote_call_add_parameter (_tmp84_, (zcdISerializable*) _tmp85_);
	_tmp86_ = rc;
	_tmp87_ = hashednames;
	_tmp88_ = zcd_list_string_new_with_backer ((GeeList*) _tmp87_);
	_tmp89_ = _tmp88_;
	zcd_remote_call_add_parameter (_tmp86_, (zcdISerializable*) _tmp89_);
	_g_object_unref0 (_tmp89_);
	_tmp90_ = rc;
	_tmp91_ = pubkey;
	zcd_remote_call_add_parameter (_tmp90_, (zcdISerializable*) _tmp91_);
	_tmp92_ = rc;
	_tmp93_ = signature;
	zcd_remote_call_add_parameter (_tmp92_, (zcdISerializable*) _tmp93_);
	_tmp94_ = rc;
	_tmp96_ = zcd_iserializable_serialize ((zcdISerializable*) _tmp94_, &_tmp95_);
	_tmp97_ = _tmp96_;
	_tmp97__length1 = _tmp95_;
	_tmp98_ = zcd_iserializable_deserialize (_tmp97_, _tmp95_, &_inner_error_);
	_tmp99_ = _tmp98_;
	_tmp97_ = (g_free (_tmp97_), NULL);
	_tmp100_ = _tmp99_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (rc);
		_g_object_unref0 (signature);
		_signed_ = (g_free (_signed_), NULL);
		message_prepared_in_client = (g_free (message_prepared_in_client), NULL);
		_g_object_unref0 (hashednames);
		_g_object_unref0 (maproute_me);
		_g_object_unref0 (pubkey);
		_g_object_unref0 (keypair);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	data = G_TYPE_CHECK_INSTANCE_CAST (_tmp100_, ZCD_TYPE_REMOTE_CALL, zcdRemoteCall);
	_tmp101_ = data;
	_tmp102_ = zcd_remote_call_get_parameters (_tmp101_);
	_tmp103_ = _tmp102_;
	_tmp104_ = gee_list_get (_tmp103_, 0);
	iser0 = (zcdISerializable*) _tmp104_;
	_tmp105_ = iser0;
	_tmp106_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp105_);
	_tmp107_ = g_type_is_a (_tmp106_, NETSUKUKU_TYPE_NIP);
	if (!_tmp107_) {
		GError* _tmp108_;
		_tmp108_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "set_data_for_pubk parameter 1 is not a NIP.");
		_inner_error_ = _tmp108_;
		_g_object_unref0 (iser0);
		_g_object_unref0 (data);
		_g_object_unref0 (rc);
		_g_object_unref0 (signature);
		_signed_ = (g_free (_signed_), NULL);
		message_prepared_in_client = (g_free (message_prepared_in_client), NULL);
		_g_object_unref0 (hashednames);
		_g_object_unref0 (maproute_me);
		_g_object_unref0 (pubkey);
		_g_object_unref0 (keypair);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp109_ = iser0;
	_tmp110_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp109_, NETSUKUKU_TYPE_NIP, NetsukukuNIP));
	ported_nip = _tmp110_;
	_tmp111_ = data;
	_tmp112_ = zcd_remote_call_get_parameters (_tmp111_);
	_tmp113_ = _tmp112_;
	_tmp114_ = gee_list_get (_tmp113_, 1);
	iser1 = (zcdISerializable*) _tmp114_;
	_tmp115_ = iser1;
	_tmp116_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp115_);
	_tmp117_ = g_type_is_a (_tmp116_, ZCD_TYPE_LIST_STRING);
	if (!_tmp117_) {
		GError* _tmp118_;
		_tmp118_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "set_data_for_pubk parameter 2 is not a List<string>.");
		_inner_error_ = _tmp118_;
		_g_object_unref0 (iser1);
		_g_object_unref0 (ported_nip);
		_g_object_unref0 (iser0);
		_g_object_unref0 (data);
		_g_object_unref0 (rc);
		_g_object_unref0 (signature);
		_signed_ = (g_free (_signed_), NULL);
		message_prepared_in_client = (g_free (message_prepared_in_client), NULL);
		_g_object_unref0 (hashednames);
		_g_object_unref0 (maproute_me);
		_g_object_unref0 (pubkey);
		_g_object_unref0 (keypair);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp119_ = iser1;
	_tmp120_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp119_, ZCD_TYPE_LIST_STRING, zcdListString));
	_hashed_hostnames = _tmp120_;
	_tmp121_ = _hashed_hostnames;
	_tmp122_ = _tmp121_->backed;
	_tmp123_ = _g_object_ref0 (_tmp122_);
	ported_hashed_hostnames = _tmp123_;
	_tmp124_ = data;
	_tmp125_ = zcd_remote_call_get_parameters (_tmp124_);
	_tmp126_ = _tmp125_;
	_tmp127_ = gee_list_get (_tmp126_, 2);
	iser2 = (zcdISerializable*) _tmp127_;
	_tmp128_ = iser2;
	_tmp129_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp128_);
	_tmp130_ = g_type_is_a (_tmp129_, NETSUKUKU_TYPE_PUBLIC_KEY);
	if (!_tmp130_) {
		GError* _tmp131_;
		_tmp131_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "set_data_for_pubk parameter 3 is not a PublicKey.");
		_inner_error_ = _tmp131_;
		_g_object_unref0 (iser2);
		_g_object_unref0 (ported_hashed_hostnames);
		_g_object_unref0 (_hashed_hostnames);
		_g_object_unref0 (iser1);
		_g_object_unref0 (ported_nip);
		_g_object_unref0 (iser0);
		_g_object_unref0 (data);
		_g_object_unref0 (rc);
		_g_object_unref0 (signature);
		_signed_ = (g_free (_signed_), NULL);
		message_prepared_in_client = (g_free (message_prepared_in_client), NULL);
		_g_object_unref0 (hashednames);
		_g_object_unref0 (maproute_me);
		_g_object_unref0 (pubkey);
		_g_object_unref0 (keypair);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp132_ = iser2;
	_tmp133_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp132_, NETSUKUKU_TYPE_PUBLIC_KEY, NetsukukuPublicKey));
	ported_pubkey = _tmp133_;
	_tmp134_ = data;
	_tmp135_ = zcd_remote_call_get_parameters (_tmp134_);
	_tmp136_ = _tmp135_;
	_tmp137_ = gee_list_get (_tmp136_, 3);
	iser3 = (zcdISerializable*) _tmp137_;
	_tmp138_ = iser3;
	_tmp139_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp138_);
	_tmp140_ = g_type_is_a (_tmp139_, ZCD_TYPE_SERIALIZABLE_BUFFER);
	if (!_tmp140_) {
		GError* _tmp141_;
		_tmp141_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "set_data_for_pubk parameter 4 is not a SerializableBuffer.");
		_inner_error_ = _tmp141_;
		_g_object_unref0 (iser3);
		_g_object_unref0 (ported_pubkey);
		_g_object_unref0 (iser2);
		_g_object_unref0 (ported_hashed_hostnames);
		_g_object_unref0 (_hashed_hostnames);
		_g_object_unref0 (iser1);
		_g_object_unref0 (ported_nip);
		_g_object_unref0 (iser0);
		_g_object_unref0 (data);
		_g_object_unref0 (rc);
		_g_object_unref0 (signature);
		_signed_ = (g_free (_signed_), NULL);
		message_prepared_in_client = (g_free (message_prepared_in_client), NULL);
		_g_object_unref0 (hashednames);
		_g_object_unref0 (maproute_me);
		_g_object_unref0 (pubkey);
		_g_object_unref0 (keypair);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp142_ = iser3;
	_tmp143_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp142_, ZCD_TYPE_SERIALIZABLE_BUFFER, zcdSerializableBuffer));
	ported_signature = _tmp143_;
	{
		NetsukukuNIP* _tmp144_;
		gchar* _tmp145_ = NULL;
		gchar* _tmp146_;
		gchar* _tmp147_ = NULL;
		gchar* _tmp148_;
		NetsukukuNIP* _tmp149_;
		gint _tmp150_ = 0;
		guchar* _tmp151_ = NULL;
		guchar* message1;
		gint message1_length1;
		gint _message1_size_;
		GeeList* _tmp167_;
		zcdListString* _tmp168_;
		zcdListString* _tmp169_;
		gint _tmp170_ = 0;
		guchar* _tmp171_ = NULL;
		guchar* _tmp172_;
		gint _tmp172__length1;
		guchar* message2;
		gint message2_length1;
		gint _message2_size_;
		guchar* _tmp173_;
		gint _tmp173__length1;
		guchar* _tmp174_;
		gint _tmp174__length1;
		guchar* _tmp175_ = NULL;
		guchar* message;
		gint message_length1;
		gint _message_size_;
		gint im;
		guchar* _tmp198_;
		gint _tmp198__length1;
		guchar* _tmp199_;
		gint _tmp199__length1;
		_tmp144_ = ported_nip;
		_tmp145_ = netsukuku_partial_nip_to_string ((NetsukukuPartialNIP*) _tmp144_);
		_tmp146_ = _tmp145_;
		_tmp147_ = g_strconcat ("nip ", _tmp146_, NULL);
		_tmp148_ = _tmp147_;
		netsukuku_log_debug (_tmp148_);
		_g_free0 (_tmp148_);
		_g_free0 (_tmp146_);
		_tmp149_ = ported_nip;
		_tmp151_ = netsukuku_partial_nip_hash_for_signature ((NetsukukuPartialNIP*) _tmp149_, &_tmp150_);
		message1 = _tmp151_;
		message1_length1 = _tmp150_;
		_message1_size_ = message1_length1;
		{
			GeeList* _tmp152_;
			GeeList* _tmp153_;
			GeeList* _s_list;
			GeeList* _tmp154_;
			gint _tmp155_;
			gint _tmp156_;
			gint _s_size;
			gint _s_index;
			_tmp152_ = ported_hashed_hostnames;
			_tmp153_ = _g_object_ref0 (_tmp152_);
			_s_list = _tmp153_;
			_tmp154_ = _s_list;
			_tmp155_ = gee_collection_get_size ((GeeCollection*) _tmp154_);
			_tmp156_ = _tmp155_;
			_s_size = _tmp156_;
			_s_index = -1;
			while (TRUE) {
				gint _tmp157_;
				gint _tmp158_;
				gint _tmp159_;
				GeeList* _tmp160_;
				gint _tmp161_;
				gpointer _tmp162_ = NULL;
				gchar* s;
				const gchar* _tmp163_;
				const gchar* _tmp164_ = NULL;
				gchar* _tmp165_ = NULL;
				gchar* _tmp166_;
				_tmp157_ = _s_index;
				_s_index = _tmp157_ + 1;
				_tmp158_ = _s_index;
				_tmp159_ = _s_size;
				if (!(_tmp158_ < _tmp159_)) {
					break;
				}
				_tmp160_ = _s_list;
				_tmp161_ = _s_index;
				_tmp162_ = gee_list_get (_tmp160_, _tmp161_);
				s = (gchar*) _tmp162_;
				_tmp163_ = s;
				_tmp164_ = string_to_string (_tmp163_);
				_tmp165_ = g_strconcat ("hashedname ", _tmp164_, NULL);
				_tmp166_ = _tmp165_;
				netsukuku_log_debug (_tmp166_);
				_g_free0 (_tmp166_);
				_g_free0 (s);
			}
			_g_object_unref0 (_s_list);
		}
		_tmp167_ = ported_hashed_hostnames;
		_tmp168_ = zcd_list_string_new_with_backer (_tmp167_);
		_tmp169_ = _tmp168_;
		_tmp171_ = zcd_list_string_hash_for_signature (_tmp169_, &_tmp170_);
		_tmp172_ = _tmp171_;
		_tmp172__length1 = _tmp170_;
		_g_object_unref0 (_tmp169_);
		message2 = _tmp172_;
		message2_length1 = _tmp172__length1;
		_message2_size_ = message2_length1;
		_tmp173_ = message1;
		_tmp173__length1 = message1_length1;
		_tmp174_ = message2;
		_tmp174__length1 = message2_length1;
		_tmp175_ = g_new0 (guchar, _tmp173__length1 + _tmp174__length1);
		message = _tmp175_;
		message_length1 = _tmp173__length1 + _tmp174__length1;
		_message_size_ = message_length1;
		im = 0;
		{
			gint i;
			i = 0;
			{
				gboolean _tmp176_;
				_tmp176_ = TRUE;
				while (TRUE) {
					gboolean _tmp177_;
					gint _tmp179_;
					guchar* _tmp180_;
					gint _tmp180__length1;
					guchar* _tmp181_;
					gint _tmp181__length1;
					gint _tmp182_;
					guchar* _tmp183_;
					gint _tmp183__length1;
					gint _tmp184_;
					guchar _tmp185_;
					guchar _tmp186_;
					_tmp177_ = _tmp176_;
					if (!_tmp177_) {
						gint _tmp178_;
						_tmp178_ = i;
						i = _tmp178_ + 1;
					}
					_tmp176_ = FALSE;
					_tmp179_ = i;
					_tmp180_ = message1;
					_tmp180__length1 = message1_length1;
					if (!(_tmp179_ < _tmp180__length1)) {
						break;
					}
					_tmp181_ = message;
					_tmp181__length1 = message_length1;
					_tmp182_ = im;
					im = _tmp182_ + 1;
					_tmp183_ = message1;
					_tmp183__length1 = message1_length1;
					_tmp184_ = i;
					_tmp185_ = _tmp183_[_tmp184_];
					_tmp181_[_tmp182_] = _tmp185_;
					_tmp186_ = _tmp181_[_tmp182_];
				}
			}
		}
		{
			gint i;
			i = 0;
			{
				gboolean _tmp187_;
				_tmp187_ = TRUE;
				while (TRUE) {
					gboolean _tmp188_;
					gint _tmp190_;
					guchar* _tmp191_;
					gint _tmp191__length1;
					guchar* _tmp192_;
					gint _tmp192__length1;
					gint _tmp193_;
					guchar* _tmp194_;
					gint _tmp194__length1;
					gint _tmp195_;
					guchar _tmp196_;
					guchar _tmp197_;
					_tmp188_ = _tmp187_;
					if (!_tmp188_) {
						gint _tmp189_;
						_tmp189_ = i;
						i = _tmp189_ + 1;
					}
					_tmp187_ = FALSE;
					_tmp190_ = i;
					_tmp191_ = message2;
					_tmp191__length1 = message2_length1;
					if (!(_tmp190_ < _tmp191__length1)) {
						break;
					}
					_tmp192_ = message;
					_tmp192__length1 = message_length1;
					_tmp193_ = im;
					im = _tmp193_ + 1;
					_tmp194_ = message2;
					_tmp194__length1 = message2_length1;
					_tmp195_ = i;
					_tmp196_ = _tmp194_[_tmp195_];
					_tmp192_[_tmp193_] = _tmp196_;
					_tmp197_ = _tmp192_[_tmp193_];
				}
			}
		}
		_tmp198_ = message;
		_tmp198__length1 = message_length1;
		_tmp199_ = (_tmp198_ != NULL) ? _vala_array_dup2 (_tmp198_, _tmp198__length1) : ((gpointer) _tmp198_);
		_tmp199__length1 = _tmp198__length1;
		message_prepared_in_server = (g_free (message_prepared_in_server), NULL);
		message_prepared_in_server = _tmp199_;
		message_prepared_in_server_length1 = _tmp199__length1;
		_message_prepared_in_server_size_ = message_prepared_in_server_length1;
		message = (g_free (message), NULL);
		message2 = (g_free (message2), NULL);
		message1 = (g_free (message1), NULL);
	}
	_tmp200_ = message_prepared_in_server;
	_tmp200__length1 = message_prepared_in_server_length1;
	_tmp201_ = g_base64_encode (_tmp200_, _tmp200__length1);
	_tmp202_ = _tmp201_;
	_tmp203_ = string_to_string (_tmp202_);
	_tmp204_ = g_strconcat ("message_prepared_in_server ", _tmp203_, NULL);
	_tmp205_ = _tmp204_;
	netsukuku_log_debug (_tmp205_);
	_g_free0 (_tmp205_);
	_g_free0 (_tmp202_);
	_tmp206_ = ported_pubkey;
	_tmp207_ = netsukuku_public_key_wrapper_new_from_pubk (_tmp206_, &_inner_error_);
	pkw = _tmp207_;
	if (_inner_error_ != NULL) {
		message_prepared_in_server = (g_free (message_prepared_in_server), NULL);
		_g_object_unref0 (ported_signature);
		_g_object_unref0 (iser3);
		_g_object_unref0 (ported_pubkey);
		_g_object_unref0 (iser2);
		_g_object_unref0 (ported_hashed_hostnames);
		_g_object_unref0 (_hashed_hostnames);
		_g_object_unref0 (iser1);
		_g_object_unref0 (ported_nip);
		_g_object_unref0 (iser0);
		_g_object_unref0 (data);
		_g_object_unref0 (rc);
		_g_object_unref0 (signature);
		_signed_ = (g_free (_signed_), NULL);
		message_prepared_in_client = (g_free (message_prepared_in_client), NULL);
		_g_object_unref0 (hashednames);
		_g_object_unref0 (maproute_me);
		_g_object_unref0 (pubkey);
		_g_object_unref0 (keypair);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp208_ = pkw;
	_tmp209_ = message_prepared_in_server;
	_tmp209__length1 = message_prepared_in_server_length1;
	_tmp210_ = ported_signature;
	_tmp211_ = zcd_serializable_buffer_get_buffer (_tmp210_, &_tmp211__length1);
	_tmp212_ = _tmp211_;
	_tmp212__length1 = _tmp211__length1;
	_tmp213_ = netsukuku_public_key_wrapper_verify (_tmp208_, _tmp209_, _tmp209__length1, (guchar*) _tmp212_, (_tmp212__length1 * sizeof (guint8)) / sizeof (guchar), &_inner_error_);
	ret = _tmp213_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (pkw);
		message_prepared_in_server = (g_free (message_prepared_in_server), NULL);
		_g_object_unref0 (ported_signature);
		_g_object_unref0 (iser3);
		_g_object_unref0 (ported_pubkey);
		_g_object_unref0 (iser2);
		_g_object_unref0 (ported_hashed_hostnames);
		_g_object_unref0 (_hashed_hostnames);
		_g_object_unref0 (iser1);
		_g_object_unref0 (ported_nip);
		_g_object_unref0 (iser0);
		_g_object_unref0 (data);
		_g_object_unref0 (rc);
		_g_object_unref0 (signature);
		_signed_ = (g_free (_signed_), NULL);
		message_prepared_in_client = (g_free (message_prepared_in_client), NULL);
		_g_object_unref0 (hashednames);
		_g_object_unref0 (maproute_me);
		_g_object_unref0 (pubkey);
		_g_object_unref0 (keypair);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp214_ = ret;
	_vala_assert (_tmp214_, "ret");
	_g_object_unref0 (pkw);
	message_prepared_in_server = (g_free (message_prepared_in_server), NULL);
	_g_object_unref0 (ported_signature);
	_g_object_unref0 (iser3);
	_g_object_unref0 (ported_pubkey);
	_g_object_unref0 (iser2);
	_g_object_unref0 (ported_hashed_hostnames);
	_g_object_unref0 (_hashed_hostnames);
	_g_object_unref0 (iser1);
	_g_object_unref0 (ported_nip);
	_g_object_unref0 (iser0);
	_g_object_unref0 (data);
	_g_object_unref0 (rc);
	_g_object_unref0 (signature);
	_signed_ = (g_free (_signed_), NULL);
	message_prepared_in_client = (g_free (message_prepared_in_client), NULL);
	_g_object_unref0 (hashednames);
	_g_object_unref0 (maproute_me);
	_g_object_unref0 (pubkey);
	_g_object_unref0 (keypair);
}


static void __lambda11_ (void) {
	NtkTestAndnaTester* _tmp0_;
	NtkTestAndnaTester* x;
	_tmp0_ = ntk_test_andna_tester_new ();
	x = _tmp0_;
	ntk_test_andna_tester_set_up (x);
	ntk_test_andna_tester_test_crypto_hash (x);
	ntk_test_andna_tester_tear_down (x);
	_g_object_unref0 (x);
}


static void ___lambda11__gcallback (void) {
	__lambda11_ ();
}


static void __lambda12_ (void) {
	NtkTestAndnaTester* _tmp0_;
	NtkTestAndnaTester* x;
	_tmp0_ = ntk_test_andna_tester_new ();
	x = _tmp0_;
	ntk_test_andna_tester_set_up (x);
	ntk_test_andna_tester_test_signatures (x);
	ntk_test_andna_tester_tear_down (x);
	_g_object_unref0 (x);
}


static void ___lambda12__gcallback (void) {
	__lambda12_ ();
}


gint ntk_test_andna_tester_main (gchar** args, int args_length1) {
	gint result = 0;
	g_test_init (&args_length1, &args, NULL);
	tasklets_tasklet_init (64);
	g_test_add_func ("/Andna/CryptoHash", ___lambda11__gcallback);
	g_test_add_func ("/Andna/Signatures", ___lambda12__gcallback);
	g_test_run ();
	tasklets_tasklet_kill ();
	result = 0;
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return ntk_test_andna_tester_main (argv, argc);
}


NtkTestAndnaTester* ntk_test_andna_tester_construct (GType object_type) {
	NtkTestAndnaTester * self = NULL;
	self = (NtkTestAndnaTester*) g_object_new (object_type, NULL);
	return self;
}


NtkTestAndnaTester* ntk_test_andna_tester_new (void) {
	return ntk_test_andna_tester_construct (NTK_TEST_TYPE_ANDNA_TESTER);
}


static void ntk_test_andna_tester_class_init (NtkTestAndnaTesterClass * klass) {
	ntk_test_andna_tester_parent_class = g_type_class_peek_parent (klass);
}


static void ntk_test_andna_tester_instance_init (NtkTestAndnaTester * self) {
}


GType ntk_test_andna_tester_get_type (void) {
	static volatile gsize ntk_test_andna_tester_type_id__volatile = 0;
	if (g_once_init_enter (&ntk_test_andna_tester_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NtkTestAndnaTesterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ntk_test_andna_tester_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NtkTestAndnaTester), 0, (GInstanceInitFunc) ntk_test_andna_tester_instance_init, NULL };
		GType ntk_test_andna_tester_type_id;
		ntk_test_andna_tester_type_id = g_type_register_static (G_TYPE_OBJECT, "NtkTestAndnaTester", &g_define_type_info, 0);
		g_once_init_leave (&ntk_test_andna_tester_type_id__volatile, ntk_test_andna_tester_type_id);
	}
	return ntk_test_andna_tester_type_id__volatile;
}



