/* counter.c generated by valac 0.20.1, the Vala compiler
 * generated from counter.vala, do not modify */

/*
 *  This file is part of Netsukuku.
 *  (c) Copyright 2011-2014 Luca Dionisi aka lukisi <luca.dionisi@gmail.com>
 *
 *  Netsukuku is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Netsukuku is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Netsukuku.  If not, see <http://www.gnu.org/licenses/>.
 */
/*   peerbuilder.in
errors:
 HookingError
  INEXISTENT_GNODE
  GENERIC
 QspnError
  NOT_YOUR_GATEWAY
  ALREADY_UP_TO_DATE
  GENERIC
 PeerRefuseServiceError
  GENERIC
 TunnelError
  GENERIC
 BorderNodesError
  WRONG_GNODE
  NOT_BORDER_NODE
  WILL_NOT_TUNNEL
  TIMEOUT
  GENERIC
 AndnaError
  GENERIC
serializables:
 TimeCapsule
 ParticipantNode
 PackedParticipantNodes
 OptionalServiceParticipants
 SetOptionalServiceParticipants
 PeerToPeerTracerPacketList
 PairNipDistance
 BnodeRecord
 BnodeList
 PairLvlNumberOfFreeNodes
 HCoord
 PartialNIP
 NIP
 REM
 NullREM
 DeadREM
 AlmostDeadREM
 RTT
 TracerPacketList
 RouteInSet
 PositionInRoutesSetPerLevel
 RoutesSetPerLevel
 RoutesSet
 ExtendedTracerPacket
 GNodeID
 NetworkID
 InfoNeighbour
 InfoRoute
 InfoNode
 QspnStats
 InfoBorderNode
 DHTKey
 DHTRecord
 PublicKey
 AndnaServiceKey
 AndnaServerRecord
 AndnaDomainRecord
 AndnaServer
 AndnaServers
 RegisterHostnameArguments
 CounterNipRecord
 CounterSetDataResponse
 CounterCheckHostnameResponse
 CounterGetCacheRecordsResponse
 AndnaConfirmPubkResponse
 AndnaRegisterMainResponse
 AndnaRegisterSpreadResponse
 AndnaGetServersResponse
 AndnaGetRegistrarResponse
 AndnaGetCacheRecordsResponse
 BroadcastID
 UnicastID
peers:
 Counter
  methods:
   CounterSetDataResponse set_data_for_pubk
    arguments:
     NIP nip
     Gee.List<string> hashed_domains
     PublicKey pubkey
     SerializableBuffer signature
     bool replicate
    throws:
     PeerRefuseServiceError
   CounterCheckHostnameResponse check_hostname
    arguments:
     NIP nip
     string hashed_domain
     PublicKey pubkey
    throws:
     PeerRefuseServiceError
   CounterNipRecord? get_hostnames
    arguments:
     NIP nip
    throws:
     PeerRefuseServiceError
   CounterGetCacheRecordsResponse get_cache_records
    arguments:
    throws:
     PeerRefuseServiceError
*/

#include <glib.h>
#include <glib-object.h>
#include <netsukuku-rpc.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <zcd.h>
#include <tasklet.h>
#include <unistd.h>


#define NETSUKUKU_TYPE_ICOUNTER_AS_PEER (netsukuku_icounter_as_peer_get_type ())
#define NETSUKUKU_ICOUNTER_AS_PEER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_ICOUNTER_AS_PEER, NetsukukuICounterAsPeer))
#define NETSUKUKU_IS_ICOUNTER_AS_PEER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_ICOUNTER_AS_PEER))
#define NETSUKUKU_ICOUNTER_AS_PEER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), NETSUKUKU_TYPE_ICOUNTER_AS_PEER, NetsukukuICounterAsPeerIface))

typedef struct _NetsukukuICounterAsPeer NetsukukuICounterAsPeer;
typedef struct _NetsukukuICounterAsPeerIface NetsukukuICounterAsPeerIface;

#define NETSUKUKU_TYPE_RMT_PEER (netsukuku_rmt_peer_get_type ())
#define NETSUKUKU_RMT_PEER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_RMT_PEER, NetsukukuRmtPeer))
#define NETSUKUKU_RMT_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_RMT_PEER, NetsukukuRmtPeerClass))
#define NETSUKUKU_IS_RMT_PEER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_RMT_PEER))
#define NETSUKUKU_IS_RMT_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_RMT_PEER))
#define NETSUKUKU_RMT_PEER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_RMT_PEER, NetsukukuRmtPeerClass))

typedef struct _NetsukukuRmtPeer NetsukukuRmtPeer;
typedef struct _NetsukukuRmtPeerClass NetsukukuRmtPeerClass;
typedef struct _NetsukukuRmtPeerPrivate NetsukukuRmtPeerPrivate;

#define NETSUKUKU_TYPE_RMT_COUNTER_PEER (netsukuku_rmt_counter_peer_get_type ())
#define NETSUKUKU_RMT_COUNTER_PEER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_RMT_COUNTER_PEER, NetsukukuRmtCounterPeer))
#define NETSUKUKU_RMT_COUNTER_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_RMT_COUNTER_PEER, NetsukukuRmtCounterPeerClass))
#define NETSUKUKU_IS_RMT_COUNTER_PEER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_RMT_COUNTER_PEER))
#define NETSUKUKU_IS_RMT_COUNTER_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_RMT_COUNTER_PEER))
#define NETSUKUKU_RMT_COUNTER_PEER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_RMT_COUNTER_PEER, NetsukukuRmtCounterPeerClass))

typedef struct _NetsukukuRmtCounterPeer NetsukukuRmtCounterPeer;
typedef struct _NetsukukuRmtCounterPeerClass NetsukukuRmtCounterPeerClass;
typedef struct _NetsukukuRmtCounterPeerPrivate NetsukukuRmtCounterPeerPrivate;

#define NETSUKUKU_TYPE_PEER_TO_PEER (netsukuku_peer_to_peer_get_type ())
#define NETSUKUKU_PEER_TO_PEER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_PEER_TO_PEER, NetsukukuPeerToPeer))
#define NETSUKUKU_PEER_TO_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_PEER_TO_PEER, NetsukukuPeerToPeerClass))
#define NETSUKUKU_IS_PEER_TO_PEER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_PEER_TO_PEER))
#define NETSUKUKU_IS_PEER_TO_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_PEER_TO_PEER))
#define NETSUKUKU_PEER_TO_PEER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_PEER_TO_PEER, NetsukukuPeerToPeerClass))

typedef struct _NetsukukuPeerToPeer NetsukukuPeerToPeer;
typedef struct _NetsukukuPeerToPeerClass NetsukukuPeerToPeerClass;

#define NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR (netsukuku_aggregated_neighbour_get_type ())
#define NETSUKUKU_AGGREGATED_NEIGHBOUR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR, NetsukukuAggregatedNeighbour))
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR, NetsukukuAggregatedNeighbourClass))
#define NETSUKUKU_IS_AGGREGATED_NEIGHBOUR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR))
#define NETSUKUKU_IS_AGGREGATED_NEIGHBOUR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR))
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR, NetsukukuAggregatedNeighbourClass))

typedef struct _NetsukukuAggregatedNeighbour NetsukukuAggregatedNeighbour;
typedef struct _NetsukukuAggregatedNeighbourClass NetsukukuAggregatedNeighbourClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define NETSUKUKU_TYPE_ARGUMENTS_FOR_DUPLICATION_SET_DATA (netsukuku_arguments_for_duplication_set_data_get_type ())
#define NETSUKUKU_ARGUMENTS_FOR_DUPLICATION_SET_DATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_ARGUMENTS_FOR_DUPLICATION_SET_DATA, NetsukukuArgumentsForDuplicationSetData))
#define NETSUKUKU_ARGUMENTS_FOR_DUPLICATION_SET_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_ARGUMENTS_FOR_DUPLICATION_SET_DATA, NetsukukuArgumentsForDuplicationSetDataClass))
#define NETSUKUKU_IS_ARGUMENTS_FOR_DUPLICATION_SET_DATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_ARGUMENTS_FOR_DUPLICATION_SET_DATA))
#define NETSUKUKU_IS_ARGUMENTS_FOR_DUPLICATION_SET_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_ARGUMENTS_FOR_DUPLICATION_SET_DATA))
#define NETSUKUKU_ARGUMENTS_FOR_DUPLICATION_SET_DATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_ARGUMENTS_FOR_DUPLICATION_SET_DATA, NetsukukuArgumentsForDuplicationSetDataClass))

typedef struct _NetsukukuArgumentsForDuplicationSetData NetsukukuArgumentsForDuplicationSetData;
typedef struct _NetsukukuArgumentsForDuplicationSetDataClass NetsukukuArgumentsForDuplicationSetDataClass;
typedef struct _NetsukukuArgumentsForDuplicationSetDataPrivate NetsukukuArgumentsForDuplicationSetDataPrivate;

#define NETSUKUKU_TYPE_STRUCT_HELPER_COUNTER_RESET_MY_COUNTER_NODE (netsukuku_struct_helper_counter_reset_my_counter_node_get_type ())

#define NETSUKUKU_TYPE_COUNTER (netsukuku_counter_get_type ())
#define NETSUKUKU_COUNTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_COUNTER, NetsukukuCounter))
#define NETSUKUKU_COUNTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_COUNTER, NetsukukuCounterClass))
#define NETSUKUKU_IS_COUNTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_COUNTER))
#define NETSUKUKU_IS_COUNTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_COUNTER))
#define NETSUKUKU_COUNTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_COUNTER, NetsukukuCounterClass))

typedef struct _NetsukukuCounter NetsukukuCounter;
typedef struct _NetsukukuCounterClass NetsukukuCounterClass;
typedef struct _Netsukukustruct_helper_Counter_reset_my_counter_node Netsukukustruct_helper_Counter_reset_my_counter_node;
typedef struct _NetsukukuPeerToPeerPrivate NetsukukuPeerToPeerPrivate;

#define NETSUKUKU_TYPE_MAP_ROUTE (netsukuku_map_route_get_type ())
#define NETSUKUKU_MAP_ROUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_MAP_ROUTE, NetsukukuMapRoute))
#define NETSUKUKU_MAP_ROUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_MAP_ROUTE, NetsukukuMapRouteClass))
#define NETSUKUKU_IS_MAP_ROUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_MAP_ROUTE))
#define NETSUKUKU_IS_MAP_ROUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_MAP_ROUTE))
#define NETSUKUKU_MAP_ROUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_MAP_ROUTE, NetsukukuMapRouteClass))

typedef struct _NetsukukuMapRoute NetsukukuMapRoute;
typedef struct _NetsukukuMapRouteClass NetsukukuMapRouteClass;
typedef struct _NetsukukuCounterPrivate NetsukukuCounterPrivate;

#define NETSUKUKU_TYPE_PEER_TO_PEER_ALL (netsukuku_peer_to_peer_all_get_type ())
#define NETSUKUKU_PEER_TO_PEER_ALL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_PEER_TO_PEER_ALL, NetsukukuPeerToPeerAll))
#define NETSUKUKU_PEER_TO_PEER_ALL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_PEER_TO_PEER_ALL, NetsukukuPeerToPeerAllClass))
#define NETSUKUKU_IS_PEER_TO_PEER_ALL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_PEER_TO_PEER_ALL))
#define NETSUKUKU_IS_PEER_TO_PEER_ALL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_PEER_TO_PEER_ALL))
#define NETSUKUKU_PEER_TO_PEER_ALL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_PEER_TO_PEER_ALL, NetsukukuPeerToPeerAllClass))

typedef struct _NetsukukuPeerToPeerAll NetsukukuPeerToPeerAll;
typedef struct _NetsukukuPeerToPeerAllClass NetsukukuPeerToPeerAllClass;

#define NETSUKUKU_TYPE_ANDNA (netsukuku_andna_get_type ())
#define NETSUKUKU_ANDNA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_ANDNA, NetsukukuAndna))
#define NETSUKUKU_ANDNA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_ANDNA, NetsukukuAndnaClass))
#define NETSUKUKU_IS_ANDNA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_ANDNA))
#define NETSUKUKU_IS_ANDNA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_ANDNA))
#define NETSUKUKU_ANDNA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_ANDNA, NetsukukuAndnaClass))

typedef struct _NetsukukuAndna NetsukukuAndna;
typedef struct _NetsukukuAndnaClass NetsukukuAndnaClass;

#define NETSUKUKU_TYPE_KEY_PAIR (netsukuku_key_pair_get_type ())
#define NETSUKUKU_KEY_PAIR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_KEY_PAIR, NetsukukuKeyPair))
#define NETSUKUKU_KEY_PAIR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_KEY_PAIR, NetsukukuKeyPairClass))
#define NETSUKUKU_IS_KEY_PAIR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_KEY_PAIR))
#define NETSUKUKU_IS_KEY_PAIR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_KEY_PAIR))
#define NETSUKUKU_KEY_PAIR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_KEY_PAIR, NetsukukuKeyPairClass))

typedef struct _NetsukukuKeyPair NetsukukuKeyPair;
typedef struct _NetsukukuKeyPairClass NetsukukuKeyPairClass;

#define NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER (netsukuku_aggregated_neighbour_manager_get_type ())
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, NetsukukuAggregatedNeighbourManager))
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, NetsukukuAggregatedNeighbourManagerClass))
#define NETSUKUKU_IS_AGGREGATED_NEIGHBOUR_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER))
#define NETSUKUKU_IS_AGGREGATED_NEIGHBOUR_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER))
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, NetsukukuAggregatedNeighbourManagerClass))

typedef struct _NetsukukuAggregatedNeighbourManager NetsukukuAggregatedNeighbourManager;
typedef struct _NetsukukuAggregatedNeighbourManagerClass NetsukukuAggregatedNeighbourManagerClass;

#define NETSUKUKU_TYPE_PUBLIC_KEY_WRAPPER (netsukuku_public_key_wrapper_get_type ())
#define NETSUKUKU_PUBLIC_KEY_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_PUBLIC_KEY_WRAPPER, NetsukukuPublicKeyWrapper))
#define NETSUKUKU_PUBLIC_KEY_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_PUBLIC_KEY_WRAPPER, NetsukukuPublicKeyWrapperClass))
#define NETSUKUKU_IS_PUBLIC_KEY_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_PUBLIC_KEY_WRAPPER))
#define NETSUKUKU_IS_PUBLIC_KEY_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_PUBLIC_KEY_WRAPPER))
#define NETSUKUKU_PUBLIC_KEY_WRAPPER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_PUBLIC_KEY_WRAPPER, NetsukukuPublicKeyWrapperClass))

typedef struct _NetsukukuPublicKeyWrapper NetsukukuPublicKeyWrapper;
typedef struct _NetsukukuPublicKeyWrapperClass NetsukukuPublicKeyWrapperClass;
typedef struct _NetsukukuMapRoutePrivate NetsukukuMapRoutePrivate;
typedef struct _Block3Data Block3Data;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _NetsukukuICounterAsPeerIface {
	GTypeInterface parent_iface;
	NetsukukuCounterSetDataResponse* (*set_data_for_pubk) (NetsukukuICounterAsPeer* self, NetsukukuNIP* nip, GeeList* hashed_domains, NetsukukuPublicKey* pubkey, zcdSerializableBuffer* signature, gboolean replicate, GError** error);
	NetsukukuCounterCheckHostnameResponse* (*check_hostname) (NetsukukuICounterAsPeer* self, NetsukukuNIP* nip, const gchar* hashed_domain, NetsukukuPublicKey* pubkey, GError** error);
	NetsukukuCounterNipRecord* (*get_hostnames) (NetsukukuICounterAsPeer* self, NetsukukuNIP* nip, GError** error);
	NetsukukuCounterGetCacheRecordsResponse* (*get_cache_records) (NetsukukuICounterAsPeer* self, GError** error);
};

struct _NetsukukuRmtPeer {
	GObject parent_instance;
	NetsukukuRmtPeerPrivate * priv;
};

struct _NetsukukuRmtPeerClass {
	GObjectClass parent_class;
	zcdISerializable* (*rmt) (NetsukukuRmtPeer* self, zcdRemoteCall* data, GError** error);
};

struct _NetsukukuRmtCounterPeer {
	NetsukukuRmtPeer parent_instance;
	NetsukukuRmtCounterPeerPrivate * priv;
};

struct _NetsukukuRmtCounterPeerClass {
	NetsukukuRmtPeerClass parent_class;
};

struct _NetsukukuArgumentsForDuplicationSetData {
	GObject parent_instance;
	NetsukukuArgumentsForDuplicationSetDataPrivate * priv;
	NetsukukuNIP* nip;
	GeeList* hashed_domains;
	NetsukukuPublicKey* pubkey;
	zcdSerializableBuffer* signature;
	NetsukukuNIP* hashnode;
};

struct _NetsukukuArgumentsForDuplicationSetDataClass {
	GObjectClass parent_class;
};

struct _Netsukukustruct_helper_Counter_reset_my_counter_node {
	NetsukukuCounter* self;
};

struct _NetsukukuPeerToPeer {
	GObject parent_instance;
	NetsukukuPeerToPeerPrivate * priv;
	NetsukukuMapRoute* maproute;
};

struct _NetsukukuPeerToPeerClass {
	GObjectClass parent_class;
	zcdISerializable* (*_dispatch) (NetsukukuPeerToPeer* self, GObject* caller, zcdRemoteCall* data, GError** error);
	NetsukukuNIP* (*h) (NetsukukuPeerToPeer* self, GObject* key);
};

struct _NetsukukuCounter {
	NetsukukuPeerToPeer parent_instance;
	NetsukukuCounterPrivate * priv;
	gboolean memory_initialized;
};

struct _NetsukukuCounterClass {
	NetsukukuPeerToPeerClass parent_class;
	NetsukukuIAddressManagerRootDispatcher* (*contact_registrar) (NetsukukuCounter* self, const gchar* registrar_address);
};

struct _NetsukukuCounterPrivate {
	GeeArrayList* _hashednames;
	NetsukukuPeerToPeerAll* peer_to_peer_all;
	TaskletsTasklet* reset_my_counter_node_tasklet;
	NetsukukuAndna* _andna;
	NetsukukuKeyPair* my_keys;
	NetsukukuPublicKey* pubk;
	GeeHashMap* cache;
};

typedef enum  {
	NETSUKUKU_PEER_TO_PEER_ERROR_REGISTER,
	NETSUKUKU_PEER_TO_PEER_ERROR_GENERIC
} NetsukukuPeerToPeerError;
#define NETSUKUKU_PEER_TO_PEER_ERROR netsukuku_peer_to_peer_error_quark ()
struct _NetsukukuMapRoute {
	GObject parent_instance;
	NetsukukuMapRoutePrivate * priv;
	gint levels;
	gint gsize;
	NetsukukuNIP* me;
};

struct _NetsukukuMapRouteClass {
	GObjectClass parent_class;
};

typedef enum  {
	NETSUKUKU_CRYPTO_GCRYPT_ERROR_FAILED
} NetsukukuCryptoGCryptError;
#define NETSUKUKU_CRYPTO_GCRYPT_ERROR netsukuku_crypto_gcrypt_error_quark ()
struct _Block3Data {
	int _ref_count_;
	NetsukukuCounter * self;
	gchar* response_msg;
	NetsukukuTimeCapsule* response_ttl;
	NetsukukuNIP* nip;
	GeeList* hashed_domains;
	NetsukukuPublicKey* pubkey;
	zcdSerializableBuffer* signature;
};

typedef gboolean (*NetsukukuAcceptRecordCallback) (void* user_data, GError** error);
typedef void (*NetsukukuForwardRecordCallback) (GObject* obj1, GeeList* replica_nodes, void* user_data, GError** error);
typedef void (*NetsukukuRefuseRecordCallback) (void* user_data, GError** error);

static gpointer netsukuku_rmt_counter_peer_parent_class = NULL;
static NetsukukuICounterAsPeerIface* netsukuku_rmt_counter_peer_netsukuku_icounter_as_peer_parent_iface = NULL;
static gpointer netsukuku_arguments_for_duplication_set_data_parent_class = NULL;
static gpointer netsukuku_counter_parent_class = NULL;
static NetsukukuICounterAsPeerIface* netsukuku_counter_netsukuku_icounter_as_peer_parent_iface = NULL;

GType netsukuku_icounter_as_peer_get_type (void) G_GNUC_CONST;
NetsukukuCounterSetDataResponse* netsukuku_icounter_as_peer_set_data_for_pubk (NetsukukuICounterAsPeer* self, NetsukukuNIP* nip, GeeList* hashed_domains, NetsukukuPublicKey* pubkey, zcdSerializableBuffer* signature, gboolean replicate, GError** error);
NetsukukuCounterCheckHostnameResponse* netsukuku_icounter_as_peer_check_hostname (NetsukukuICounterAsPeer* self, NetsukukuNIP* nip, const gchar* hashed_domain, NetsukukuPublicKey* pubkey, GError** error);
NetsukukuCounterNipRecord* netsukuku_icounter_as_peer_get_hostnames (NetsukukuICounterAsPeer* self, NetsukukuNIP* nip, GError** error);
NetsukukuCounterGetCacheRecordsResponse* netsukuku_icounter_as_peer_get_cache_records (NetsukukuICounterAsPeer* self, GError** error);
GType netsukuku_rmt_peer_get_type (void) G_GNUC_CONST;
GType netsukuku_rmt_counter_peer_get_type (void) G_GNUC_CONST;
enum  {
	NETSUKUKU_RMT_COUNTER_PEER_DUMMY_PROPERTY
};
GType netsukuku_peer_to_peer_get_type (void) G_GNUC_CONST;
GType netsukuku_aggregated_neighbour_get_type (void) G_GNUC_CONST;
NetsukukuRmtCounterPeer* netsukuku_rmt_counter_peer_new (NetsukukuPeerToPeer* peer_to_peer_service, GObject* key, NetsukukuNIP* hIP, NetsukukuAggregatedNeighbour* aggregated_neighbour);
NetsukukuRmtCounterPeer* netsukuku_rmt_counter_peer_construct (GType object_type, NetsukukuPeerToPeer* peer_to_peer_service, GObject* key, NetsukukuNIP* hIP, NetsukukuAggregatedNeighbour* aggregated_neighbour);
NetsukukuRmtPeer* netsukuku_rmt_peer_new (NetsukukuPeerToPeer* peer_to_peer_service, GObject* key, NetsukukuNIP* hIP, NetsukukuAggregatedNeighbour* aggregated_neighbour);
NetsukukuRmtPeer* netsukuku_rmt_peer_construct (GType object_type, NetsukukuPeerToPeer* peer_to_peer_service, GObject* key, NetsukukuNIP* hIP, NetsukukuAggregatedNeighbour* aggregated_neighbour);
static NetsukukuCounterSetDataResponse* netsukuku_rmt_counter_peer_real_set_data_for_pubk (NetsukukuICounterAsPeer* base, NetsukukuNIP* nip, GeeList* hashed_domains, NetsukukuPublicKey* pubkey, zcdSerializableBuffer* signature, gboolean replicate, GError** error);
zcdISerializable* netsukuku_rmt_peer_rmt (NetsukukuRmtPeer* self, zcdRemoteCall* data, GError** error);
static NetsukukuCounterCheckHostnameResponse* netsukuku_rmt_counter_peer_real_check_hostname (NetsukukuICounterAsPeer* base, NetsukukuNIP* nip, const gchar* hashed_domain, NetsukukuPublicKey* pubkey, GError** error);
static NetsukukuCounterNipRecord* netsukuku_rmt_counter_peer_real_get_hostnames (NetsukukuICounterAsPeer* base, NetsukukuNIP* nip, GError** error);
static NetsukukuCounterGetCacheRecordsResponse* netsukuku_rmt_counter_peer_real_get_cache_records (NetsukukuICounterAsPeer* base, GError** error);
GType netsukuku_arguments_for_duplication_set_data_get_type (void) G_GNUC_CONST;
enum  {
	NETSUKUKU_ARGUMENTS_FOR_DUPLICATION_SET_DATA_DUMMY_PROPERTY
};
NetsukukuArgumentsForDuplicationSetData* netsukuku_arguments_for_duplication_set_data_new (void);
NetsukukuArgumentsForDuplicationSetData* netsukuku_arguments_for_duplication_set_data_construct (GType object_type);
static void netsukuku_arguments_for_duplication_set_data_finalize (GObject* obj);
GType netsukuku_struct_helper_counter_reset_my_counter_node_get_type (void) G_GNUC_CONST;
GType netsukuku_counter_get_type (void) G_GNUC_CONST;
Netsukukustruct_helper_Counter_reset_my_counter_node* netsukuku_struct_helper_counter_reset_my_counter_node_dup (const Netsukukustruct_helper_Counter_reset_my_counter_node* self);
void netsukuku_struct_helper_counter_reset_my_counter_node_free (Netsukukustruct_helper_Counter_reset_my_counter_node* self);
void netsukuku_struct_helper_counter_reset_my_counter_node_copy (const Netsukukustruct_helper_Counter_reset_my_counter_node* self, Netsukukustruct_helper_Counter_reset_my_counter_node* dest);
void netsukuku_struct_helper_counter_reset_my_counter_node_destroy (Netsukukustruct_helper_Counter_reset_my_counter_node* self);
GType netsukuku_map_route_get_type (void) G_GNUC_CONST;
GType netsukuku_peer_to_peer_all_get_type (void) G_GNUC_CONST;
GType netsukuku_andna_get_type (void) G_GNUC_CONST;
GType netsukuku_key_pair_get_type (void) G_GNUC_CONST;
#define NETSUKUKU_COUNTER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), NETSUKUKU_TYPE_COUNTER, NetsukukuCounterPrivate))
enum  {
	NETSUKUKU_COUNTER_DUMMY_PROPERTY,
	NETSUKUKU_COUNTER_ANDNA
};
#define NETSUKUKU_COUNTER_mypid 2
GType netsukuku_aggregated_neighbour_manager_get_type (void) G_GNUC_CONST;
NetsukukuCounter* netsukuku_counter_new (NetsukukuKeyPair* keypair, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, NetsukukuPeerToPeerAll* peer_to_peer_all);
NetsukukuCounter* netsukuku_counter_construct (GType object_type, NetsukukuKeyPair* keypair, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, NetsukukuPeerToPeerAll* peer_to_peer_all);
NetsukukuPeerToPeer* netsukuku_peer_to_peer_new (NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, gint pid);
NetsukukuPeerToPeer* netsukuku_peer_to_peer_construct (GType object_type, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, gint pid);
GType netsukuku_public_key_wrapper_get_type (void) G_GNUC_CONST;
NetsukukuPublicKeyWrapper* netsukuku_key_pair_get_pub_key (NetsukukuKeyPair* self);
NetsukukuPublicKey* netsukuku_public_key_wrapper_to_pubkey (NetsukukuPublicKeyWrapper* self);
GQuark netsukuku_peer_to_peer_error_quark (void);
void netsukuku_peer_to_peer_all_peer_to_peer_register (NetsukukuPeerToPeerAll* self, NetsukukuPeerToPeer* peer_to_peer, GError** error);
void netsukuku_counter_init_memory (NetsukukuCounter* self);
static void _netsukuku_counter_init_memory_netsukuku_peer_to_peer_map_peer_to_peer_validated (NetsukukuPeerToPeer* _sender, gpointer self);
static guint _netsukuku_pair_public_key_nip_hash_func_gee_hash_data_func (gconstpointer v, gpointer self);
static gboolean _netsukuku_pair_public_key_nip_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self);
NetsukukuRmtCounterPeer* netsukuku_counter_peer (NetsukukuCounter* self, NetsukukuNIP* hIP, GObject* key, NetsukukuAggregatedNeighbour* aggregated_neighbour);
static zcdISerializable* netsukuku_counter_real__dispatch (NetsukukuPeerToPeer* base, GObject* caller, zcdRemoteCall* data, GError** error);
zcdISerializable* _netsukuku_peer_to_peer_dispatch (NetsukukuPeerToPeer* self, GObject* caller, zcdRemoteCall* data, GError** error);
static NetsukukuNIP* netsukuku_counter_nip_for_lvl_pos (NetsukukuCounter* self, gint lvl, gint pos);
static void netsukuku_counter_impl_init_memory (NetsukukuCounter* self, GError** error);
void netsukuku_peer_to_peer_find_hook_peers (NetsukukuPeerToPeer* self, gint** ret_first_forward, gint** ret_first_back, gint** ret_last_back, gint lvl, gint num_dupl, gint timeout);
#define NETSUKUKU_COUNTER_DUPLICATION 3
static gboolean _int_equal (const gint* s1, const gint* s2);
NetsukukuNIP* netsukuku_peer_to_peer_h (NetsukukuPeerToPeer* self, GObject* key);
GeeList* netsukuku_peer_to_peer_list_ids (NetsukukuPeerToPeer* self, gint center, gint sign);
void netsukuku_log_info (const gchar* msg);
static void __lambda2_ (NetsukukuCounter* self, GError** error);
void netsukuku_log_warn (const gchar* msg);
static void ___lambda2__tasklets_tasklet_callback (GObject* obj1, GObject* obj2, GObject* obj3, GObject* obj4, gpointer self, GError** error);
static NetsukukuNIP* netsukuku_counter_real_h (NetsukukuPeerToPeer* base, GObject* key);
GQuark netsukuku_crypto_gcrypt_error_quark (void);
guint8* netsukuku_crypto_md5 (guint8* buffer, int buffer_length1, int* result_length1, GError** error);
static void netsukuku_counter_impl_reset_my_counter_node (NetsukukuCounter* self, GError** error);
static NetsukukuCounterSetDataResponse* netsukuku_counter_ask_set_data_for_pubk (NetsukukuCounter* self, GError** error);
#define NETSUKUKU_MAX_WAIT_REFRESH_COUNTER ((((gint64) 1000) * ((gint64) 60)) * ((gint64) 60))
static void* netsukuku_counter_helper_reset_my_counter_node (void* v, GError** error);
void netsukuku_counter_reset_my_counter_node (NetsukukuCounter* self);
void netsukuku_counter_stop_reset_my_counter_node (NetsukukuCounter* self);
gboolean netsukuku_counter_reset_my_counter_node_ongoing (NetsukukuCounter* self);
static zcdSerializableBuffer* _netsukuku_counter_sign (NetsukukuCounter* self, GeeList* hashed_domains);
static GeeArrayList* netsukuku_counter_get_hashednames (NetsukukuCounter* self);
void netsukuku_log_debug (const gchar* msg);
guchar* netsukuku_key_pair_sign (NetsukukuKeyPair* self, guchar* msg, int msg_length1, int* result_length1, GError** error);
guchar* netsukuku_counter_utilities_prepare_msg (NetsukukuNIP* nip, GeeList* hashed_domains, int* result_length1);
static gboolean _netsukuku_counter_verify (NetsukukuCounter* self, NetsukukuNIP* nip, GeeList* hashed_domains, NetsukukuPublicKey* pubk, zcdSerializableBuffer* signature);
NetsukukuPublicKeyWrapper* netsukuku_public_key_wrapper_new_from_pubk (NetsukukuPublicKey* from_pubk, GError** error);
NetsukukuPublicKeyWrapper* netsukuku_public_key_wrapper_construct_from_pubk (GType object_type, NetsukukuPublicKey* from_pubk, GError** error);
gboolean netsukuku_public_key_wrapper_verify (NetsukukuPublicKeyWrapper* self, guchar* msg, int msg_length1, guchar* signature, int signature_length1, GError** error);
NetsukukuCounterCheckHostnameResponse* netsukuku_counter_ask_check_hostname (NetsukukuCounter* self, NetsukukuNIP* nip, const gchar* hashed_domain, NetsukukuPublicKey* pubkey, GError** error);
NetsukukuCounterNipRecord* netsukuku_counter_ask_get_hostnames (NetsukukuCounter* self, NetsukukuNIP* nip);
void netsukuku_counter_check_expirations_cache (NetsukukuCounter* self);
NetsukukuIAddressManagerRootDispatcher* netsukuku_counter_contact_registrar (NetsukukuCounter* self, const gchar* registrar_address);
static NetsukukuIAddressManagerRootDispatcher* netsukuku_counter_real_contact_registrar (NetsukukuCounter* self, const gchar* registrar_address);
static NetsukukuCounterSetDataResponse* netsukuku_counter_real_set_data_for_pubk (NetsukukuICounterAsPeer* base, NetsukukuNIP* nip, GeeList* hashed_domains, NetsukukuPublicKey* pubkey, zcdSerializableBuffer* signature, gboolean replicate, GError** error);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
void netsukuku_check_hash_and_start_replica (NetsukukuPeerToPeer* service, NetsukukuNIP* hash_nip, gboolean replicate, GObject* obj1, gint replica_nodes_max, NetsukukuAcceptRecordCallback accept_callback, void* accept_callback_target, NetsukukuForwardRecordCallback forward_callback, void* forward_callback_target, NetsukukuRefuseRecordCallback refuse_callback, void* refuse_callback_target, GError** error);
static gboolean __lambda5_ (Block3Data* _data3_, GError** error);
#define NETSUKUKU_MAX_HOSTNAMES 256
gchar* netsukuku_nip_to_str (gint levels, gint gsize, NetsukukuNIP* nip);
#define NETSUKUKU_MAX_TTL_COUNTER ((((((gint64) 1000) * ((gint64) 60)) * ((gint64) 60)) * ((gint64) 24)) * ((gint64) 30))
static gboolean ___lambda5__netsukuku_accept_record_callback (gpointer self, GError** error);
static void __lambda6_ (NetsukukuCounter* self, GObject* tasklet_obj1, GeeList* tasklet_replica_nodes, GError** error);
GeeList* netsukuku_peer_to_peer_find_nearest_to_register (NetsukukuPeerToPeer* self, NetsukukuNIP* hash_nip, gint num_dupl);
static void _____lambda7_ (NetsukukuCounter* self, GObject* tpar1, GObject* tpar2, GError** error);
static void ______lambda7__tasklets_tasklet_callback (GObject* obj1, GObject* obj2, GObject* obj3, GObject* obj4, gpointer self, GError** error);
static void ___lambda6__netsukuku_forward_record_callback (GObject* obj1, GeeList* replica_nodes, gpointer self, GError** error);
static NetsukukuCounterCheckHostnameResponse* netsukuku_counter_real_check_hostname (NetsukukuICounterAsPeer* base, NetsukukuNIP* nip, const gchar* hashed_domain, NetsukukuPublicKey* pubkey, GError** error);
NetsukukuHCoord* netsukuku_peer_to_peer_search_participant (NetsukukuPeerToPeer* self, NetsukukuNIP* hIP, gint path_sign, GError** error);
static NetsukukuCounterNipRecord* netsukuku_counter_real_get_hostnames (NetsukukuICounterAsPeer* base, NetsukukuNIP* nip, GError** error);
static NetsukukuCounterGetCacheRecordsResponse* netsukuku_counter_real_get_cache_records (NetsukukuICounterAsPeer* base, GError** error);
gchar* netsukuku_andna_crypto_hash (const gchar* hostname);
static NetsukukuAndna* netsukuku_counter_get_andna (NetsukukuCounter* self);
void netsukuku_counter_set_andna (NetsukukuCounter* self, NetsukukuAndna* value);
static void netsukuku_counter_finalize (GObject* obj);
static void _vala_netsukuku_counter_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_netsukuku_counter_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


NetsukukuCounterSetDataResponse* netsukuku_icounter_as_peer_set_data_for_pubk (NetsukukuICounterAsPeer* self, NetsukukuNIP* nip, GeeList* hashed_domains, NetsukukuPublicKey* pubkey, zcdSerializableBuffer* signature, gboolean replicate, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return NETSUKUKU_ICOUNTER_AS_PEER_GET_INTERFACE (self)->set_data_for_pubk (self, nip, hashed_domains, pubkey, signature, replicate, error);
}


NetsukukuCounterCheckHostnameResponse* netsukuku_icounter_as_peer_check_hostname (NetsukukuICounterAsPeer* self, NetsukukuNIP* nip, const gchar* hashed_domain, NetsukukuPublicKey* pubkey, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return NETSUKUKU_ICOUNTER_AS_PEER_GET_INTERFACE (self)->check_hostname (self, nip, hashed_domain, pubkey, error);
}


NetsukukuCounterNipRecord* netsukuku_icounter_as_peer_get_hostnames (NetsukukuICounterAsPeer* self, NetsukukuNIP* nip, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return NETSUKUKU_ICOUNTER_AS_PEER_GET_INTERFACE (self)->get_hostnames (self, nip, error);
}


NetsukukuCounterGetCacheRecordsResponse* netsukuku_icounter_as_peer_get_cache_records (NetsukukuICounterAsPeer* self, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return NETSUKUKU_ICOUNTER_AS_PEER_GET_INTERFACE (self)->get_cache_records (self, error);
}


static void netsukuku_icounter_as_peer_base_init (NetsukukuICounterAsPeerIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


GType netsukuku_icounter_as_peer_get_type (void) {
	static volatile gsize netsukuku_icounter_as_peer_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_icounter_as_peer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuICounterAsPeerIface), (GBaseInitFunc) netsukuku_icounter_as_peer_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType netsukuku_icounter_as_peer_type_id;
		netsukuku_icounter_as_peer_type_id = g_type_register_static (G_TYPE_INTERFACE, "NetsukukuICounterAsPeer", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (netsukuku_icounter_as_peer_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&netsukuku_icounter_as_peer_type_id__volatile, netsukuku_icounter_as_peer_type_id);
	}
	return netsukuku_icounter_as_peer_type_id__volatile;
}


NetsukukuRmtCounterPeer* netsukuku_rmt_counter_peer_construct (GType object_type, NetsukukuPeerToPeer* peer_to_peer_service, GObject* key, NetsukukuNIP* hIP, NetsukukuAggregatedNeighbour* aggregated_neighbour) {
	NetsukukuRmtCounterPeer * self = NULL;
	NetsukukuPeerToPeer* _tmp0_;
	GObject* _tmp1_;
	NetsukukuNIP* _tmp2_;
	NetsukukuAggregatedNeighbour* _tmp3_;
	g_return_val_if_fail (peer_to_peer_service != NULL, NULL);
	_tmp0_ = peer_to_peer_service;
	_tmp1_ = key;
	_tmp2_ = hIP;
	_tmp3_ = aggregated_neighbour;
	self = (NetsukukuRmtCounterPeer*) netsukuku_rmt_peer_construct (object_type, _tmp0_, _tmp1_, _tmp2_, _tmp3_);
	return self;
}


NetsukukuRmtCounterPeer* netsukuku_rmt_counter_peer_new (NetsukukuPeerToPeer* peer_to_peer_service, GObject* key, NetsukukuNIP* hIP, NetsukukuAggregatedNeighbour* aggregated_neighbour) {
	return netsukuku_rmt_counter_peer_construct (NETSUKUKU_TYPE_RMT_COUNTER_PEER, peer_to_peer_service, key, hIP, aggregated_neighbour);
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static NetsukukuCounterSetDataResponse* netsukuku_rmt_counter_peer_real_set_data_for_pubk (NetsukukuICounterAsPeer* base, NetsukukuNIP* nip, GeeList* hashed_domains, NetsukukuPublicKey* pubkey, zcdSerializableBuffer* signature, gboolean replicate, GError** error) {
	NetsukukuRmtCounterPeer * self;
	NetsukukuCounterSetDataResponse* result = NULL;
	zcdRemoteCall* _tmp0_;
	zcdRemoteCall* rc;
	zcdRemoteCall* _tmp1_;
	gchar* _tmp2_;
	zcdRemoteCall* _tmp3_;
	NetsukukuNIP* _tmp4_;
	GeeList* _tmp5_;
	zcdListString* _tmp6_;
	zcdListString* _hashed_domains;
	zcdRemoteCall* _tmp7_;
	zcdListString* _tmp8_;
	zcdRemoteCall* _tmp9_;
	NetsukukuPublicKey* _tmp10_;
	zcdRemoteCall* _tmp11_;
	zcdSerializableBuffer* _tmp12_;
	zcdRemoteCall* _tmp13_;
	gboolean _tmp14_;
	zcdSerializableBool* _tmp15_;
	zcdSerializableBool* _tmp16_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuRmtCounterPeer*) base;
	g_return_val_if_fail (nip != NULL, NULL);
	g_return_val_if_fail (hashed_domains != NULL, NULL);
	g_return_val_if_fail (pubkey != NULL, NULL);
	g_return_val_if_fail (signature != NULL, NULL);
	_tmp0_ = zcd_remote_call_new ();
	rc = _tmp0_;
	_tmp1_ = rc;
	_tmp2_ = g_strdup ("set_data_for_pubk");
	_g_free0 (_tmp1_->method_name);
	_tmp1_->method_name = _tmp2_;
	_tmp3_ = rc;
	_tmp4_ = nip;
	zcd_remote_call_add_parameter (_tmp3_, (zcdISerializable*) _tmp4_);
	_tmp5_ = hashed_domains;
	_tmp6_ = zcd_list_string_new_with_backer (_tmp5_);
	_hashed_domains = _tmp6_;
	_tmp7_ = rc;
	_tmp8_ = _hashed_domains;
	zcd_remote_call_add_parameter (_tmp7_, (zcdISerializable*) _tmp8_);
	_tmp9_ = rc;
	_tmp10_ = pubkey;
	zcd_remote_call_add_parameter (_tmp9_, (zcdISerializable*) _tmp10_);
	_tmp11_ = rc;
	_tmp12_ = signature;
	zcd_remote_call_add_parameter (_tmp11_, (zcdISerializable*) _tmp12_);
	_tmp13_ = rc;
	_tmp14_ = replicate;
	_tmp15_ = zcd_serializable_bool_new (_tmp14_);
	_tmp16_ = _tmp15_;
	zcd_remote_call_add_parameter (_tmp13_, (zcdISerializable*) _tmp16_);
	_g_object_unref0 (_tmp16_);
	{
		zcdRemoteCall* _tmp17_;
		zcdISerializable* _tmp18_ = NULL;
		zcdISerializable* _tmp19_;
		zcdISerializable* _tmp20_;
		zcdISerializable* _tmp21_ = NULL;
		zcdISerializable* _tmp22_;
		zcdISerializable* _tmp23_;
		zcdISerializable* _tmp24_;
		zcdISerializable* _tmp25_ = NULL;
		zcdISerializable* _tmp26_;
		zcdISerializable* _tmp27_;
		_tmp17_ = rc;
		_tmp18_ = netsukuku_rmt_peer_rmt ((NetsukukuRmtPeer*) self, _tmp17_, &_inner_error_);
		_tmp19_ = _tmp18_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch13_zcd_rpc_error;
			}
			goto __catch13_g_error;
		}
		_tmp20_ = _tmp19_;
		_tmp21_ = netsukuku_filter_exception_PeerRefuseServiceError (_tmp20_, &_inner_error_);
		_tmp22_ = _tmp21_;
		_g_object_unref0 (_tmp20_);
		_tmp23_ = _tmp22_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch13_zcd_rpc_error;
			}
			goto __catch13_g_error;
		}
		_tmp24_ = _tmp23_;
		_tmp25_ = zcd_filter_exception (_tmp24_, &_inner_error_);
		_tmp26_ = _tmp25_;
		_g_object_unref0 (_tmp24_);
		_tmp27_ = _tmp26_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch13_zcd_rpc_error;
			}
			goto __catch13_g_error;
		}
		result = G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, NETSUKUKU_TYPE_COUNTER_SET_DATA_RESPONSE, NetsukukuCounterSetDataResponse);
		_g_object_unref0 (_hashed_domains);
		_g_object_unref0 (rc);
		return result;
	}
	goto __finally13;
	__catch13_zcd_rpc_error:
	{
		GError* e = NULL;
		GError* _tmp28_;
		GError* _tmp29_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp28_ = e;
		_tmp29_ = _g_error_copy0 (_tmp28_);
		_inner_error_ = _tmp29_;
		_g_error_free0 (e);
		goto __finally13;
	}
	goto __finally13;
	__catch13_g_error:
	{
		GError* e = NULL;
		GError* _tmp30_;
		GQuark _tmp31_;
		const gchar* _tmp32_ = NULL;
		GError* _tmp33_;
		gint _tmp34_;
		gchar* _tmp35_ = NULL;
		gchar* _tmp36_;
		GError* _tmp37_;
		const gchar* _tmp38_;
		const gchar* _tmp39_ = NULL;
		gchar* _tmp40_ = NULL;
		gchar* _tmp41_;
		GError* _tmp42_;
		GError* _tmp43_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp30_ = e;
		_tmp31_ = _tmp30_->domain;
		_tmp32_ = g_quark_to_string (_tmp31_);
		_tmp33_ = e;
		_tmp34_ = _tmp33_->code;
		_tmp35_ = g_strdup_printf ("%i", _tmp34_);
		_tmp36_ = _tmp35_;
		_tmp37_ = e;
		_tmp38_ = _tmp37_->message;
		_tmp39_ = string_to_string (_tmp38_);
		_tmp40_ = g_strconcat ("Unexpected error ", _tmp32_, ".", _tmp36_, " '", _tmp39_, "'", NULL);
		_tmp41_ = _tmp40_;
		_tmp42_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_GENERIC, _tmp41_);
		_tmp43_ = _tmp42_;
		_g_free0 (_tmp41_);
		_g_free0 (_tmp36_);
		_inner_error_ = _tmp43_;
		_g_error_free0 (e);
		goto __finally13;
	}
	__finally13:
	if ((_inner_error_->domain == ZCD_RPC_ERROR) || (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (_hashed_domains);
		_g_object_unref0 (rc);
		return NULL;
	} else {
		_g_object_unref0 (_hashed_domains);
		_g_object_unref0 (rc);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_object_unref0 (_hashed_domains);
	_g_object_unref0 (rc);
}


static NetsukukuCounterCheckHostnameResponse* netsukuku_rmt_counter_peer_real_check_hostname (NetsukukuICounterAsPeer* base, NetsukukuNIP* nip, const gchar* hashed_domain, NetsukukuPublicKey* pubkey, GError** error) {
	NetsukukuRmtCounterPeer * self;
	NetsukukuCounterCheckHostnameResponse* result = NULL;
	zcdRemoteCall* _tmp0_;
	zcdRemoteCall* rc;
	zcdRemoteCall* _tmp1_;
	gchar* _tmp2_;
	zcdRemoteCall* _tmp3_;
	NetsukukuNIP* _tmp4_;
	zcdRemoteCall* _tmp5_;
	const gchar* _tmp6_;
	zcdSerializableString* _tmp7_;
	zcdSerializableString* _tmp8_;
	zcdRemoteCall* _tmp9_;
	NetsukukuPublicKey* _tmp10_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuRmtCounterPeer*) base;
	g_return_val_if_fail (nip != NULL, NULL);
	g_return_val_if_fail (hashed_domain != NULL, NULL);
	g_return_val_if_fail (pubkey != NULL, NULL);
	_tmp0_ = zcd_remote_call_new ();
	rc = _tmp0_;
	_tmp1_ = rc;
	_tmp2_ = g_strdup ("check_hostname");
	_g_free0 (_tmp1_->method_name);
	_tmp1_->method_name = _tmp2_;
	_tmp3_ = rc;
	_tmp4_ = nip;
	zcd_remote_call_add_parameter (_tmp3_, (zcdISerializable*) _tmp4_);
	_tmp5_ = rc;
	_tmp6_ = hashed_domain;
	_tmp7_ = zcd_serializable_string_new (_tmp6_);
	_tmp8_ = _tmp7_;
	zcd_remote_call_add_parameter (_tmp5_, (zcdISerializable*) _tmp8_);
	_g_object_unref0 (_tmp8_);
	_tmp9_ = rc;
	_tmp10_ = pubkey;
	zcd_remote_call_add_parameter (_tmp9_, (zcdISerializable*) _tmp10_);
	{
		zcdRemoteCall* _tmp11_;
		zcdISerializable* _tmp12_ = NULL;
		zcdISerializable* _tmp13_;
		zcdISerializable* _tmp14_;
		zcdISerializable* _tmp15_ = NULL;
		zcdISerializable* _tmp16_;
		zcdISerializable* _tmp17_;
		zcdISerializable* _tmp18_;
		zcdISerializable* _tmp19_ = NULL;
		zcdISerializable* _tmp20_;
		zcdISerializable* _tmp21_;
		_tmp11_ = rc;
		_tmp12_ = netsukuku_rmt_peer_rmt ((NetsukukuRmtPeer*) self, _tmp11_, &_inner_error_);
		_tmp13_ = _tmp12_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch14_zcd_rpc_error;
			}
			goto __catch14_g_error;
		}
		_tmp14_ = _tmp13_;
		_tmp15_ = netsukuku_filter_exception_PeerRefuseServiceError (_tmp14_, &_inner_error_);
		_tmp16_ = _tmp15_;
		_g_object_unref0 (_tmp14_);
		_tmp17_ = _tmp16_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch14_zcd_rpc_error;
			}
			goto __catch14_g_error;
		}
		_tmp18_ = _tmp17_;
		_tmp19_ = zcd_filter_exception (_tmp18_, &_inner_error_);
		_tmp20_ = _tmp19_;
		_g_object_unref0 (_tmp18_);
		_tmp21_ = _tmp20_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch14_zcd_rpc_error;
			}
			goto __catch14_g_error;
		}
		result = G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, NETSUKUKU_TYPE_COUNTER_CHECK_HOSTNAME_RESPONSE, NetsukukuCounterCheckHostnameResponse);
		_g_object_unref0 (rc);
		return result;
	}
	goto __finally14;
	__catch14_zcd_rpc_error:
	{
		GError* e = NULL;
		GError* _tmp22_;
		GError* _tmp23_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp22_ = e;
		_tmp23_ = _g_error_copy0 (_tmp22_);
		_inner_error_ = _tmp23_;
		_g_error_free0 (e);
		goto __finally14;
	}
	goto __finally14;
	__catch14_g_error:
	{
		GError* e = NULL;
		GError* _tmp24_;
		GQuark _tmp25_;
		const gchar* _tmp26_ = NULL;
		GError* _tmp27_;
		gint _tmp28_;
		gchar* _tmp29_ = NULL;
		gchar* _tmp30_;
		GError* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_ = NULL;
		gchar* _tmp34_ = NULL;
		gchar* _tmp35_;
		GError* _tmp36_;
		GError* _tmp37_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp24_ = e;
		_tmp25_ = _tmp24_->domain;
		_tmp26_ = g_quark_to_string (_tmp25_);
		_tmp27_ = e;
		_tmp28_ = _tmp27_->code;
		_tmp29_ = g_strdup_printf ("%i", _tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = e;
		_tmp32_ = _tmp31_->message;
		_tmp33_ = string_to_string (_tmp32_);
		_tmp34_ = g_strconcat ("Unexpected error ", _tmp26_, ".", _tmp30_, " '", _tmp33_, "'", NULL);
		_tmp35_ = _tmp34_;
		_tmp36_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_GENERIC, _tmp35_);
		_tmp37_ = _tmp36_;
		_g_free0 (_tmp35_);
		_g_free0 (_tmp30_);
		_inner_error_ = _tmp37_;
		_g_error_free0 (e);
		goto __finally14;
	}
	__finally14:
	if ((_inner_error_->domain == ZCD_RPC_ERROR) || (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (rc);
		return NULL;
	} else {
		_g_object_unref0 (rc);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_object_unref0 (rc);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static NetsukukuCounterNipRecord* netsukuku_rmt_counter_peer_real_get_hostnames (NetsukukuICounterAsPeer* base, NetsukukuNIP* nip, GError** error) {
	NetsukukuRmtCounterPeer * self;
	NetsukukuCounterNipRecord* result = NULL;
	zcdRemoteCall* _tmp0_;
	zcdRemoteCall* rc;
	zcdRemoteCall* _tmp1_;
	gchar* _tmp2_;
	zcdRemoteCall* _tmp3_;
	NetsukukuNIP* _tmp4_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuRmtCounterPeer*) base;
	g_return_val_if_fail (nip != NULL, NULL);
	_tmp0_ = zcd_remote_call_new ();
	rc = _tmp0_;
	_tmp1_ = rc;
	_tmp2_ = g_strdup ("get_hostnames");
	_g_free0 (_tmp1_->method_name);
	_tmp1_->method_name = _tmp2_;
	_tmp3_ = rc;
	_tmp4_ = nip;
	zcd_remote_call_add_parameter (_tmp3_, (zcdISerializable*) _tmp4_);
	{
		zcdRemoteCall* _tmp5_;
		zcdISerializable* _tmp6_ = NULL;
		zcdISerializable* _tmp7_;
		zcdISerializable* _tmp8_;
		zcdISerializable* _tmp9_ = NULL;
		zcdISerializable* _tmp10_;
		zcdISerializable* _tmp11_;
		zcdISerializable* _tmp12_;
		zcdISerializable* _tmp13_ = NULL;
		zcdISerializable* _tmp14_;
		zcdISerializable* ret;
		zcdISerializable* _tmp15_;
		GType _tmp16_ = 0UL;
		gboolean _tmp17_ = FALSE;
		_tmp5_ = rc;
		_tmp6_ = netsukuku_rmt_peer_rmt ((NetsukukuRmtPeer*) self, _tmp5_, &_inner_error_);
		_tmp7_ = _tmp6_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch15_zcd_rpc_error;
			}
			goto __catch15_g_error;
		}
		_tmp8_ = _tmp7_;
		_tmp9_ = netsukuku_filter_exception_PeerRefuseServiceError (_tmp8_, &_inner_error_);
		_tmp10_ = _tmp9_;
		_g_object_unref0 (_tmp8_);
		_tmp11_ = _tmp10_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch15_zcd_rpc_error;
			}
			goto __catch15_g_error;
		}
		_tmp12_ = _tmp11_;
		_tmp13_ = zcd_filter_exception (_tmp12_, &_inner_error_);
		_tmp14_ = _tmp13_;
		_g_object_unref0 (_tmp12_);
		ret = _tmp14_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch15_zcd_rpc_error;
			}
			goto __catch15_g_error;
		}
		_tmp15_ = ret;
		_tmp16_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp15_);
		_tmp17_ = g_type_is_a (_tmp16_, ZCD_TYPE_SERIALIZABLE_NONE);
		if (_tmp17_) {
			result = NULL;
			_g_object_unref0 (ret);
			_g_object_unref0 (rc);
			return result;
		} else {
			zcdISerializable* _tmp18_;
			NetsukukuCounterNipRecord* _tmp19_;
			_tmp18_ = ret;
			_tmp19_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, NETSUKUKU_TYPE_COUNTER_NIP_RECORD, NetsukukuCounterNipRecord));
			result = _tmp19_;
			_g_object_unref0 (ret);
			_g_object_unref0 (rc);
			return result;
		}
		_g_object_unref0 (ret);
	}
	goto __finally15;
	__catch15_zcd_rpc_error:
	{
		GError* e = NULL;
		GError* _tmp20_;
		GError* _tmp21_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp20_ = e;
		_tmp21_ = _g_error_copy0 (_tmp20_);
		_inner_error_ = _tmp21_;
		_g_error_free0 (e);
		goto __finally15;
	}
	goto __finally15;
	__catch15_g_error:
	{
		GError* e = NULL;
		GError* _tmp22_;
		GQuark _tmp23_;
		const gchar* _tmp24_ = NULL;
		GError* _tmp25_;
		gint _tmp26_;
		gchar* _tmp27_ = NULL;
		gchar* _tmp28_;
		GError* _tmp29_;
		const gchar* _tmp30_;
		const gchar* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
		gchar* _tmp33_;
		GError* _tmp34_;
		GError* _tmp35_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp22_ = e;
		_tmp23_ = _tmp22_->domain;
		_tmp24_ = g_quark_to_string (_tmp23_);
		_tmp25_ = e;
		_tmp26_ = _tmp25_->code;
		_tmp27_ = g_strdup_printf ("%i", _tmp26_);
		_tmp28_ = _tmp27_;
		_tmp29_ = e;
		_tmp30_ = _tmp29_->message;
		_tmp31_ = string_to_string (_tmp30_);
		_tmp32_ = g_strconcat ("Unexpected error ", _tmp24_, ".", _tmp28_, " '", _tmp31_, "'", NULL);
		_tmp33_ = _tmp32_;
		_tmp34_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_GENERIC, _tmp33_);
		_tmp35_ = _tmp34_;
		_g_free0 (_tmp33_);
		_g_free0 (_tmp28_);
		_inner_error_ = _tmp35_;
		_g_error_free0 (e);
		goto __finally15;
	}
	__finally15:
	if ((_inner_error_->domain == ZCD_RPC_ERROR) || (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (rc);
		return NULL;
	} else {
		_g_object_unref0 (rc);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_object_unref0 (rc);
}


static NetsukukuCounterGetCacheRecordsResponse* netsukuku_rmt_counter_peer_real_get_cache_records (NetsukukuICounterAsPeer* base, GError** error) {
	NetsukukuRmtCounterPeer * self;
	NetsukukuCounterGetCacheRecordsResponse* result = NULL;
	zcdRemoteCall* _tmp0_;
	zcdRemoteCall* rc;
	zcdRemoteCall* _tmp1_;
	gchar* _tmp2_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuRmtCounterPeer*) base;
	_tmp0_ = zcd_remote_call_new ();
	rc = _tmp0_;
	_tmp1_ = rc;
	_tmp2_ = g_strdup ("get_cache_records");
	_g_free0 (_tmp1_->method_name);
	_tmp1_->method_name = _tmp2_;
	{
		zcdRemoteCall* _tmp3_;
		zcdISerializable* _tmp4_ = NULL;
		zcdISerializable* _tmp5_;
		zcdISerializable* _tmp6_;
		zcdISerializable* _tmp7_ = NULL;
		zcdISerializable* _tmp8_;
		zcdISerializable* _tmp9_;
		zcdISerializable* _tmp10_;
		zcdISerializable* _tmp11_ = NULL;
		zcdISerializable* _tmp12_;
		zcdISerializable* _tmp13_;
		_tmp3_ = rc;
		_tmp4_ = netsukuku_rmt_peer_rmt ((NetsukukuRmtPeer*) self, _tmp3_, &_inner_error_);
		_tmp5_ = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch16_zcd_rpc_error;
			}
			goto __catch16_g_error;
		}
		_tmp6_ = _tmp5_;
		_tmp7_ = netsukuku_filter_exception_PeerRefuseServiceError (_tmp6_, &_inner_error_);
		_tmp8_ = _tmp7_;
		_g_object_unref0 (_tmp6_);
		_tmp9_ = _tmp8_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch16_zcd_rpc_error;
			}
			goto __catch16_g_error;
		}
		_tmp10_ = _tmp9_;
		_tmp11_ = zcd_filter_exception (_tmp10_, &_inner_error_);
		_tmp12_ = _tmp11_;
		_g_object_unref0 (_tmp10_);
		_tmp13_ = _tmp12_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch16_zcd_rpc_error;
			}
			goto __catch16_g_error;
		}
		result = G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, NETSUKUKU_TYPE_COUNTER_GET_CACHE_RECORDS_RESPONSE, NetsukukuCounterGetCacheRecordsResponse);
		_g_object_unref0 (rc);
		return result;
	}
	goto __finally16;
	__catch16_zcd_rpc_error:
	{
		GError* e = NULL;
		GError* _tmp14_;
		GError* _tmp15_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp14_ = e;
		_tmp15_ = _g_error_copy0 (_tmp14_);
		_inner_error_ = _tmp15_;
		_g_error_free0 (e);
		goto __finally16;
	}
	goto __finally16;
	__catch16_g_error:
	{
		GError* e = NULL;
		GError* _tmp16_;
		GQuark _tmp17_;
		const gchar* _tmp18_ = NULL;
		GError* _tmp19_;
		gint _tmp20_;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_;
		GError* _tmp23_;
		const gchar* _tmp24_;
		const gchar* _tmp25_ = NULL;
		gchar* _tmp26_ = NULL;
		gchar* _tmp27_;
		GError* _tmp28_;
		GError* _tmp29_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp16_ = e;
		_tmp17_ = _tmp16_->domain;
		_tmp18_ = g_quark_to_string (_tmp17_);
		_tmp19_ = e;
		_tmp20_ = _tmp19_->code;
		_tmp21_ = g_strdup_printf ("%i", _tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = e;
		_tmp24_ = _tmp23_->message;
		_tmp25_ = string_to_string (_tmp24_);
		_tmp26_ = g_strconcat ("Unexpected error ", _tmp18_, ".", _tmp22_, " '", _tmp25_, "'", NULL);
		_tmp27_ = _tmp26_;
		_tmp28_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_GENERIC, _tmp27_);
		_tmp29_ = _tmp28_;
		_g_free0 (_tmp27_);
		_g_free0 (_tmp22_);
		_inner_error_ = _tmp29_;
		_g_error_free0 (e);
		goto __finally16;
	}
	__finally16:
	if ((_inner_error_->domain == ZCD_RPC_ERROR) || (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (rc);
		return NULL;
	} else {
		_g_object_unref0 (rc);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_object_unref0 (rc);
}


static void netsukuku_rmt_counter_peer_class_init (NetsukukuRmtCounterPeerClass * klass) {
	netsukuku_rmt_counter_peer_parent_class = g_type_class_peek_parent (klass);
}


static void netsukuku_rmt_counter_peer_netsukuku_icounter_as_peer_interface_init (NetsukukuICounterAsPeerIface * iface) {
	netsukuku_rmt_counter_peer_netsukuku_icounter_as_peer_parent_iface = g_type_interface_peek_parent (iface);
	iface->set_data_for_pubk = (NetsukukuCounterSetDataResponse* (*)(NetsukukuICounterAsPeer*, NetsukukuNIP*, GeeList*, NetsukukuPublicKey*, zcdSerializableBuffer*, gboolean, GError**)) netsukuku_rmt_counter_peer_real_set_data_for_pubk;
	iface->check_hostname = (NetsukukuCounterCheckHostnameResponse* (*)(NetsukukuICounterAsPeer*, NetsukukuNIP*, const gchar*, NetsukukuPublicKey*, GError**)) netsukuku_rmt_counter_peer_real_check_hostname;
	iface->get_hostnames = (NetsukukuCounterNipRecord* (*)(NetsukukuICounterAsPeer*, NetsukukuNIP*, GError**)) netsukuku_rmt_counter_peer_real_get_hostnames;
	iface->get_cache_records = (NetsukukuCounterGetCacheRecordsResponse* (*)(NetsukukuICounterAsPeer*, GError**)) netsukuku_rmt_counter_peer_real_get_cache_records;
}


static void netsukuku_rmt_counter_peer_instance_init (NetsukukuRmtCounterPeer * self) {
}


GType netsukuku_rmt_counter_peer_get_type (void) {
	static volatile gsize netsukuku_rmt_counter_peer_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_rmt_counter_peer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuRmtCounterPeerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_rmt_counter_peer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuRmtCounterPeer), 0, (GInstanceInitFunc) netsukuku_rmt_counter_peer_instance_init, NULL };
		static const GInterfaceInfo netsukuku_icounter_as_peer_info = { (GInterfaceInitFunc) netsukuku_rmt_counter_peer_netsukuku_icounter_as_peer_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType netsukuku_rmt_counter_peer_type_id;
		netsukuku_rmt_counter_peer_type_id = g_type_register_static (NETSUKUKU_TYPE_RMT_PEER, "NetsukukuRmtCounterPeer", &g_define_type_info, 0);
		g_type_add_interface_static (netsukuku_rmt_counter_peer_type_id, NETSUKUKU_TYPE_ICOUNTER_AS_PEER, &netsukuku_icounter_as_peer_info);
		g_once_init_leave (&netsukuku_rmt_counter_peer_type_id__volatile, netsukuku_rmt_counter_peer_type_id);
	}
	return netsukuku_rmt_counter_peer_type_id__volatile;
}


NetsukukuArgumentsForDuplicationSetData* netsukuku_arguments_for_duplication_set_data_construct (GType object_type) {
	NetsukukuArgumentsForDuplicationSetData * self = NULL;
	self = (NetsukukuArgumentsForDuplicationSetData*) g_object_new (object_type, NULL);
	return self;
}


NetsukukuArgumentsForDuplicationSetData* netsukuku_arguments_for_duplication_set_data_new (void) {
	return netsukuku_arguments_for_duplication_set_data_construct (NETSUKUKU_TYPE_ARGUMENTS_FOR_DUPLICATION_SET_DATA);
}


static void netsukuku_arguments_for_duplication_set_data_class_init (NetsukukuArgumentsForDuplicationSetDataClass * klass) {
	netsukuku_arguments_for_duplication_set_data_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = netsukuku_arguments_for_duplication_set_data_finalize;
}


static void netsukuku_arguments_for_duplication_set_data_instance_init (NetsukukuArgumentsForDuplicationSetData * self) {
}


static void netsukuku_arguments_for_duplication_set_data_finalize (GObject* obj) {
	NetsukukuArgumentsForDuplicationSetData * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_ARGUMENTS_FOR_DUPLICATION_SET_DATA, NetsukukuArgumentsForDuplicationSetData);
	_g_object_unref0 (self->nip);
	_g_object_unref0 (self->hashed_domains);
	_g_object_unref0 (self->pubkey);
	_g_object_unref0 (self->signature);
	_g_object_unref0 (self->hashnode);
	G_OBJECT_CLASS (netsukuku_arguments_for_duplication_set_data_parent_class)->finalize (obj);
}


GType netsukuku_arguments_for_duplication_set_data_get_type (void) {
	static volatile gsize netsukuku_arguments_for_duplication_set_data_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_arguments_for_duplication_set_data_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuArgumentsForDuplicationSetDataClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_arguments_for_duplication_set_data_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuArgumentsForDuplicationSetData), 0, (GInstanceInitFunc) netsukuku_arguments_for_duplication_set_data_instance_init, NULL };
		GType netsukuku_arguments_for_duplication_set_data_type_id;
		netsukuku_arguments_for_duplication_set_data_type_id = g_type_register_static (G_TYPE_OBJECT, "NetsukukuArgumentsForDuplicationSetData", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_arguments_for_duplication_set_data_type_id__volatile, netsukuku_arguments_for_duplication_set_data_type_id);
	}
	return netsukuku_arguments_for_duplication_set_data_type_id__volatile;
}


void netsukuku_struct_helper_counter_reset_my_counter_node_copy (const Netsukukustruct_helper_Counter_reset_my_counter_node* self, Netsukukustruct_helper_Counter_reset_my_counter_node* dest) {
	NetsukukuCounter* _tmp0_;
	NetsukukuCounter* _tmp1_;
	_tmp0_ = (*self).self;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 ((*dest).self);
	(*dest).self = _tmp1_;
}


void netsukuku_struct_helper_counter_reset_my_counter_node_destroy (Netsukukustruct_helper_Counter_reset_my_counter_node* self) {
	_g_object_unref0 ((*self).self);
}


Netsukukustruct_helper_Counter_reset_my_counter_node* netsukuku_struct_helper_counter_reset_my_counter_node_dup (const Netsukukustruct_helper_Counter_reset_my_counter_node* self) {
	Netsukukustruct_helper_Counter_reset_my_counter_node* dup;
	dup = g_new0 (Netsukukustruct_helper_Counter_reset_my_counter_node, 1);
	netsukuku_struct_helper_counter_reset_my_counter_node_copy (self, dup);
	return dup;
}


void netsukuku_struct_helper_counter_reset_my_counter_node_free (Netsukukustruct_helper_Counter_reset_my_counter_node* self) {
	netsukuku_struct_helper_counter_reset_my_counter_node_destroy (self);
	g_free (self);
}


GType netsukuku_struct_helper_counter_reset_my_counter_node_get_type (void) {
	static volatile gsize netsukuku_struct_helper_counter_reset_my_counter_node_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_struct_helper_counter_reset_my_counter_node_type_id__volatile)) {
		GType netsukuku_struct_helper_counter_reset_my_counter_node_type_id;
		netsukuku_struct_helper_counter_reset_my_counter_node_type_id = g_boxed_type_register_static ("Netsukukustruct_helper_Counter_reset_my_counter_node", (GBoxedCopyFunc) netsukuku_struct_helper_counter_reset_my_counter_node_dup, (GBoxedFreeFunc) netsukuku_struct_helper_counter_reset_my_counter_node_free);
		g_once_init_leave (&netsukuku_struct_helper_counter_reset_my_counter_node_type_id__volatile, netsukuku_struct_helper_counter_reset_my_counter_node_type_id);
	}
	return netsukuku_struct_helper_counter_reset_my_counter_node_type_id__volatile;
}


static void _netsukuku_counter_init_memory_netsukuku_peer_to_peer_map_peer_to_peer_validated (NetsukukuPeerToPeer* _sender, gpointer self) {
	netsukuku_counter_init_memory (self);
}


static guint _netsukuku_pair_public_key_nip_hash_func_gee_hash_data_func (gconstpointer v, gpointer self) {
	guint result;
	result = netsukuku_pair_public_key_nip_hash_func (v);
	return result;
}


static gboolean _netsukuku_pair_public_key_nip_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gboolean result;
	result = netsukuku_pair_public_key_nip_equal_func (a, b);
	return result;
}


NetsukukuCounter* netsukuku_counter_construct (GType object_type, NetsukukuKeyPair* keypair, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, NetsukukuPeerToPeerAll* peer_to_peer_all) {
	NetsukukuCounter * self = NULL;
	NetsukukuAggregatedNeighbourManager* _tmp0_;
	NetsukukuMapRoute* _tmp1_;
	NetsukukuPeerToPeerAll* _tmp2_;
	NetsukukuPeerToPeerAll* _tmp3_;
	NetsukukuKeyPair* _tmp4_;
	NetsukukuKeyPair* _tmp5_;
	NetsukukuKeyPair* _tmp6_;
	NetsukukuPublicKeyWrapper* _tmp7_;
	NetsukukuPublicKeyWrapper* _tmp8_;
	NetsukukuPublicKey* _tmp9_ = NULL;
	GeeHashMap* _tmp15_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (keypair != NULL, NULL);
	g_return_val_if_fail (aggregated_neighbour_manager != NULL, NULL);
	g_return_val_if_fail (maproute != NULL, NULL);
	g_return_val_if_fail (peer_to_peer_all != NULL, NULL);
	_tmp0_ = aggregated_neighbour_manager;
	_tmp1_ = maproute;
	self = (NetsukukuCounter*) netsukuku_peer_to_peer_construct (object_type, _tmp0_, _tmp1_, NETSUKUKU_COUNTER_mypid);
	_tmp2_ = peer_to_peer_all;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->peer_to_peer_all);
	self->priv->peer_to_peer_all = _tmp3_;
	_tmp4_ = keypair;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (self->priv->my_keys);
	self->priv->my_keys = _tmp5_;
	_tmp6_ = self->priv->my_keys;
	_tmp7_ = netsukuku_key_pair_get_pub_key (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = netsukuku_public_key_wrapper_to_pubkey (_tmp8_);
	_g_object_unref0 (self->priv->pubk);
	self->priv->pubk = _tmp9_;
	_g_object_unref0 (self->priv->reset_my_counter_node_tasklet);
	self->priv->reset_my_counter_node_tasklet = NULL;
	{
		NetsukukuPeerToPeerAll* _tmp10_;
		_tmp10_ = peer_to_peer_all;
		netsukuku_peer_to_peer_all_peer_to_peer_register (_tmp10_, (NetsukukuPeerToPeer*) self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == NETSUKUKU_PEER_TO_PEER_ERROR) {
				goto __catch17_netsukuku_peer_to_peer_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	goto __finally17;
	__catch17_netsukuku_peer_to_peer_error:
	{
		GError* e = NULL;
		const gchar* _tmp11_;
		const gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp11_ = e->message;
		_tmp12_ = string_to_string (_tmp11_);
		_tmp13_ = g_strconcat ("Counter: registering failed: ", _tmp12_, NULL);
		_tmp14_ = _tmp13_;
		g_error ("counter.vala:341: %s", _tmp14_);
		_g_free0 (_tmp14_);
		_g_error_free0 (e);
	}
	__finally17:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	self->memory_initialized = FALSE;
	g_signal_connect_object ((NetsukukuPeerToPeer*) self, "map-peer-to-peer-validated", (GCallback) _netsukuku_counter_init_memory_netsukuku_peer_to_peer_map_peer_to_peer_validated, self, 0);
	_tmp15_ = gee_hash_map_new (NETSUKUKU_TYPE_PAIR_PUBLIC_KEY_NIP, (GBoxedCopyFunc) g_object_ref, g_object_unref, NETSUKUKU_TYPE_COUNTER_NIP_RECORD, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_pair_public_key_nip_hash_func_gee_hash_data_func, NULL, NULL, _netsukuku_pair_public_key_nip_equal_func_gee_equal_data_func, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->cache);
	self->priv->cache = _tmp15_;
	return self;
}


NetsukukuCounter* netsukuku_counter_new (NetsukukuKeyPair* keypair, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, NetsukukuPeerToPeerAll* peer_to_peer_all) {
	return netsukuku_counter_construct (NETSUKUKU_TYPE_COUNTER, keypair, aggregated_neighbour_manager, maproute, peer_to_peer_all);
}


NetsukukuRmtCounterPeer* netsukuku_counter_peer (NetsukukuCounter* self, NetsukukuNIP* hIP, GObject* key, NetsukukuAggregatedNeighbour* aggregated_neighbour) {
	NetsukukuRmtCounterPeer* result = NULL;
	gboolean _tmp0_ = FALSE;
	NetsukukuNIP* _tmp1_;
	gboolean _tmp3_;
	GObject* _tmp4_;
	NetsukukuNIP* _tmp5_;
	NetsukukuAggregatedNeighbour* _tmp6_;
	NetsukukuRmtCounterPeer* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = hIP;
	if (_tmp1_ != NULL) {
		_tmp0_ = TRUE;
	} else {
		GObject* _tmp2_;
		_tmp2_ = key;
		_tmp0_ = _tmp2_ != NULL;
	}
	_tmp3_ = _tmp0_;
	_vala_assert (_tmp3_, "hIP != null || key != null");
	_tmp4_ = key;
	_tmp5_ = hIP;
	_tmp6_ = aggregated_neighbour;
	_tmp7_ = netsukuku_rmt_counter_peer_new ((NetsukukuPeerToPeer*) self, _tmp4_, _tmp5_, _tmp6_);
	result = _tmp7_;
	return result;
}


/** This method could be called *directly* for a dispatcher that does not need to transform
          * an exception into a remotable.
          */
static zcdISerializable* netsukuku_counter_real__dispatch (NetsukukuPeerToPeer* base, GObject* caller, zcdRemoteCall* data, GError** error) {
	NetsukukuCounter * self;
	zcdISerializable* result = NULL;
	zcdRemoteCall* _tmp0_;
	const gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_ = NULL;
	gchar** pieces;
	gint pieces_length1;
	gint _pieces_size_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	const gchar* _tmp5_;
	gchar** _tmp75_;
	gint _tmp75__length1;
	const gchar* _tmp76_;
	gchar** _tmp122_;
	gint _tmp122__length1;
	const gchar* _tmp123_;
	gchar** _tmp146_;
	gint _tmp146__length1;
	const gchar* _tmp147_;
	GObject* _tmp158_;
	zcdRemoteCall* _tmp159_;
	zcdISerializable* _tmp160_ = NULL;
	zcdISerializable* _tmp161_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuCounter*) base;
	g_return_val_if_fail (data != NULL, NULL);
	_tmp0_ = data;
	_tmp1_ = _tmp0_->method_name;
	_tmp3_ = _tmp2_ = g_strsplit (_tmp1_, ".", 0);
	pieces = _tmp3_;
	pieces_length1 = _vala_array_length (_tmp2_);
	_pieces_size_ = pieces_length1;
	_tmp4_ = pieces;
	_tmp4__length1 = pieces_length1;
	_tmp5_ = _tmp4_[0];
	if (g_strcmp0 (_tmp5_, "set_data_for_pubk") == 0) {
		gchar** _tmp6_;
		gint _tmp6__length1;
		zcdRemoteCall* _tmp8_;
		GeeList* _tmp9_;
		GeeList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		zcdRemoteCall* _tmp14_;
		GeeList* _tmp15_;
		GeeList* _tmp16_;
		gpointer _tmp17_ = NULL;
		zcdISerializable* iser0;
		zcdISerializable* _tmp18_;
		GType _tmp19_ = 0UL;
		gboolean _tmp20_ = FALSE;
		zcdISerializable* _tmp22_;
		NetsukukuNIP* _tmp23_;
		NetsukukuNIP* nip;
		zcdRemoteCall* _tmp24_;
		GeeList* _tmp25_;
		GeeList* _tmp26_;
		gpointer _tmp27_ = NULL;
		zcdISerializable* iser1;
		zcdISerializable* _tmp28_;
		GType _tmp29_ = 0UL;
		gboolean _tmp30_ = FALSE;
		zcdISerializable* _tmp32_;
		zcdListString* _tmp33_;
		zcdListString* _hashed_domains;
		zcdListString* _tmp34_;
		GeeList* _tmp35_;
		GeeList* _tmp36_;
		GeeList* hashed_domains;
		zcdRemoteCall* _tmp37_;
		GeeList* _tmp38_;
		GeeList* _tmp39_;
		gpointer _tmp40_ = NULL;
		zcdISerializable* iser2;
		zcdISerializable* _tmp41_;
		GType _tmp42_ = 0UL;
		gboolean _tmp43_ = FALSE;
		zcdISerializable* _tmp45_;
		NetsukukuPublicKey* _tmp46_;
		NetsukukuPublicKey* pubkey;
		zcdRemoteCall* _tmp47_;
		GeeList* _tmp48_;
		GeeList* _tmp49_;
		gpointer _tmp50_ = NULL;
		zcdISerializable* iser3;
		zcdISerializable* _tmp51_;
		GType _tmp52_ = 0UL;
		gboolean _tmp53_ = FALSE;
		zcdISerializable* _tmp55_;
		zcdSerializableBuffer* _tmp56_;
		zcdSerializableBuffer* signature;
		zcdRemoteCall* _tmp57_;
		GeeList* _tmp58_;
		GeeList* _tmp59_;
		gpointer _tmp60_ = NULL;
		zcdISerializable* iser4;
		zcdISerializable* _tmp61_;
		GType _tmp62_ = 0UL;
		gboolean _tmp63_ = FALSE;
		zcdISerializable* _tmp65_;
		gboolean _tmp66_;
		gboolean _tmp67_;
		gboolean replicate;
		NetsukukuNIP* _tmp68_;
		GeeList* _tmp69_;
		NetsukukuPublicKey* _tmp70_;
		zcdSerializableBuffer* _tmp71_;
		gboolean _tmp72_;
		NetsukukuCounterSetDataResponse* _tmp73_ = NULL;
		NetsukukuCounterSetDataResponse* _tmp74_;
		_tmp6_ = pieces;
		_tmp6__length1 = pieces_length1;
		if (_tmp6__length1 != 1) {
			GError* _tmp7_;
			_tmp7_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "set_data_for_pubk is a function.");
			_inner_error_ = _tmp7_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp8_ = data;
		_tmp9_ = zcd_remote_call_get_parameters (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = gee_collection_get_size ((GeeCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		if (_tmp12_ != 5) {
			GError* _tmp13_;
			_tmp13_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "set_data_for_pubk wants 5 parameters.");
			_inner_error_ = _tmp13_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp14_ = data;
		_tmp15_ = zcd_remote_call_get_parameters (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = gee_list_get (_tmp16_, 0);
		iser0 = (zcdISerializable*) _tmp17_;
		_tmp18_ = iser0;
		_tmp19_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp18_);
		_tmp20_ = g_type_is_a (_tmp19_, NETSUKUKU_TYPE_NIP);
		if (!_tmp20_) {
			GError* _tmp21_;
			_tmp21_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "set_data_for_pubk parameter 1 is not a NIP.");
			_inner_error_ = _tmp21_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp22_ = iser0;
		_tmp23_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, NETSUKUKU_TYPE_NIP, NetsukukuNIP));
		nip = _tmp23_;
		_tmp24_ = data;
		_tmp25_ = zcd_remote_call_get_parameters (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = gee_list_get (_tmp26_, 1);
		iser1 = (zcdISerializable*) _tmp27_;
		_tmp28_ = iser1;
		_tmp29_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp28_);
		_tmp30_ = g_type_is_a (_tmp29_, ZCD_TYPE_LIST_STRING);
		if (!_tmp30_) {
			GError* _tmp31_;
			_tmp31_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "set_data_for_pubk parameter 2 is not a List<string>.");
			_inner_error_ = _tmp31_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser1);
			_g_object_unref0 (nip);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp32_ = iser1;
		_tmp33_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, ZCD_TYPE_LIST_STRING, zcdListString));
		_hashed_domains = _tmp33_;
		_tmp34_ = _hashed_domains;
		_tmp35_ = _tmp34_->backed;
		_tmp36_ = _g_object_ref0 (_tmp35_);
		hashed_domains = _tmp36_;
		_tmp37_ = data;
		_tmp38_ = zcd_remote_call_get_parameters (_tmp37_);
		_tmp39_ = _tmp38_;
		_tmp40_ = gee_list_get (_tmp39_, 2);
		iser2 = (zcdISerializable*) _tmp40_;
		_tmp41_ = iser2;
		_tmp42_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp41_);
		_tmp43_ = g_type_is_a (_tmp42_, NETSUKUKU_TYPE_PUBLIC_KEY);
		if (!_tmp43_) {
			GError* _tmp44_;
			_tmp44_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "set_data_for_pubk parameter 3 is not a PublicKey.");
			_inner_error_ = _tmp44_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser2);
			_g_object_unref0 (hashed_domains);
			_g_object_unref0 (_hashed_domains);
			_g_object_unref0 (iser1);
			_g_object_unref0 (nip);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp45_ = iser2;
		_tmp46_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, NETSUKUKU_TYPE_PUBLIC_KEY, NetsukukuPublicKey));
		pubkey = _tmp46_;
		_tmp47_ = data;
		_tmp48_ = zcd_remote_call_get_parameters (_tmp47_);
		_tmp49_ = _tmp48_;
		_tmp50_ = gee_list_get (_tmp49_, 3);
		iser3 = (zcdISerializable*) _tmp50_;
		_tmp51_ = iser3;
		_tmp52_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp51_);
		_tmp53_ = g_type_is_a (_tmp52_, ZCD_TYPE_SERIALIZABLE_BUFFER);
		if (!_tmp53_) {
			GError* _tmp54_;
			_tmp54_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "set_data_for_pubk parameter 4 is not a SerializableBuffer.");
			_inner_error_ = _tmp54_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser3);
			_g_object_unref0 (pubkey);
			_g_object_unref0 (iser2);
			_g_object_unref0 (hashed_domains);
			_g_object_unref0 (_hashed_domains);
			_g_object_unref0 (iser1);
			_g_object_unref0 (nip);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp55_ = iser3;
		_tmp56_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp55_, ZCD_TYPE_SERIALIZABLE_BUFFER, zcdSerializableBuffer));
		signature = _tmp56_;
		_tmp57_ = data;
		_tmp58_ = zcd_remote_call_get_parameters (_tmp57_);
		_tmp59_ = _tmp58_;
		_tmp60_ = gee_list_get (_tmp59_, 4);
		iser4 = (zcdISerializable*) _tmp60_;
		_tmp61_ = iser4;
		_tmp62_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp61_);
		_tmp63_ = g_type_is_a (_tmp62_, ZCD_TYPE_SERIALIZABLE_BOOL);
		if (!_tmp63_) {
			GError* _tmp64_;
			_tmp64_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "set_data_for_pubk parameter 5 is not a bool.");
			_inner_error_ = _tmp64_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser4);
			_g_object_unref0 (signature);
			_g_object_unref0 (iser3);
			_g_object_unref0 (pubkey);
			_g_object_unref0 (iser2);
			_g_object_unref0 (hashed_domains);
			_g_object_unref0 (_hashed_domains);
			_g_object_unref0 (iser1);
			_g_object_unref0 (nip);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp65_ = iser4;
		_tmp66_ = zcd_serializable_bool_get_b (G_TYPE_CHECK_INSTANCE_CAST (_tmp65_, ZCD_TYPE_SERIALIZABLE_BOOL, zcdSerializableBool));
		_tmp67_ = _tmp66_;
		replicate = _tmp67_;
		_tmp68_ = nip;
		_tmp69_ = hashed_domains;
		_tmp70_ = pubkey;
		_tmp71_ = signature;
		_tmp72_ = replicate;
		_tmp73_ = netsukuku_icounter_as_peer_set_data_for_pubk ((NetsukukuICounterAsPeer*) self, _tmp68_, _tmp69_, _tmp70_, _tmp71_, _tmp72_, &_inner_error_);
		_tmp74_ = _tmp73_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser4);
			_g_object_unref0 (signature);
			_g_object_unref0 (iser3);
			_g_object_unref0 (pubkey);
			_g_object_unref0 (iser2);
			_g_object_unref0 (hashed_domains);
			_g_object_unref0 (_hashed_domains);
			_g_object_unref0 (iser1);
			_g_object_unref0 (nip);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		result = (zcdISerializable*) _tmp74_;
		_g_object_unref0 (iser4);
		_g_object_unref0 (signature);
		_g_object_unref0 (iser3);
		_g_object_unref0 (pubkey);
		_g_object_unref0 (iser2);
		_g_object_unref0 (hashed_domains);
		_g_object_unref0 (_hashed_domains);
		_g_object_unref0 (iser1);
		_g_object_unref0 (nip);
		_g_object_unref0 (iser0);
		pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp75_ = pieces;
	_tmp75__length1 = pieces_length1;
	_tmp76_ = _tmp75_[0];
	if (g_strcmp0 (_tmp76_, "check_hostname") == 0) {
		gchar** _tmp77_;
		gint _tmp77__length1;
		zcdRemoteCall* _tmp79_;
		GeeList* _tmp80_;
		GeeList* _tmp81_;
		gint _tmp82_;
		gint _tmp83_;
		zcdRemoteCall* _tmp85_;
		GeeList* _tmp86_;
		GeeList* _tmp87_;
		gpointer _tmp88_ = NULL;
		zcdISerializable* iser0;
		zcdISerializable* _tmp89_;
		GType _tmp90_ = 0UL;
		gboolean _tmp91_ = FALSE;
		zcdISerializable* _tmp93_;
		NetsukukuNIP* _tmp94_;
		NetsukukuNIP* nip;
		zcdRemoteCall* _tmp95_;
		GeeList* _tmp96_;
		GeeList* _tmp97_;
		gpointer _tmp98_ = NULL;
		zcdISerializable* iser1;
		zcdISerializable* _tmp99_;
		GType _tmp100_ = 0UL;
		gboolean _tmp101_ = FALSE;
		zcdISerializable* _tmp103_;
		const gchar* _tmp104_;
		const gchar* _tmp105_;
		gchar* _tmp106_;
		gchar* hashed_domain;
		zcdRemoteCall* _tmp107_;
		GeeList* _tmp108_;
		GeeList* _tmp109_;
		gpointer _tmp110_ = NULL;
		zcdISerializable* iser2;
		zcdISerializable* _tmp111_;
		GType _tmp112_ = 0UL;
		gboolean _tmp113_ = FALSE;
		zcdISerializable* _tmp115_;
		NetsukukuPublicKey* _tmp116_;
		NetsukukuPublicKey* pubkey;
		NetsukukuNIP* _tmp117_;
		const gchar* _tmp118_;
		NetsukukuPublicKey* _tmp119_;
		NetsukukuCounterCheckHostnameResponse* _tmp120_ = NULL;
		NetsukukuCounterCheckHostnameResponse* _tmp121_;
		_tmp77_ = pieces;
		_tmp77__length1 = pieces_length1;
		if (_tmp77__length1 != 1) {
			GError* _tmp78_;
			_tmp78_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "check_hostname is a function.");
			_inner_error_ = _tmp78_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp79_ = data;
		_tmp80_ = zcd_remote_call_get_parameters (_tmp79_);
		_tmp81_ = _tmp80_;
		_tmp82_ = gee_collection_get_size ((GeeCollection*) _tmp81_);
		_tmp83_ = _tmp82_;
		if (_tmp83_ != 3) {
			GError* _tmp84_;
			_tmp84_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "check_hostname wants 3 parameters.");
			_inner_error_ = _tmp84_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp85_ = data;
		_tmp86_ = zcd_remote_call_get_parameters (_tmp85_);
		_tmp87_ = _tmp86_;
		_tmp88_ = gee_list_get (_tmp87_, 0);
		iser0 = (zcdISerializable*) _tmp88_;
		_tmp89_ = iser0;
		_tmp90_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp89_);
		_tmp91_ = g_type_is_a (_tmp90_, NETSUKUKU_TYPE_NIP);
		if (!_tmp91_) {
			GError* _tmp92_;
			_tmp92_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "check_hostname parameter 1 is not a NIP.");
			_inner_error_ = _tmp92_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp93_ = iser0;
		_tmp94_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp93_, NETSUKUKU_TYPE_NIP, NetsukukuNIP));
		nip = _tmp94_;
		_tmp95_ = data;
		_tmp96_ = zcd_remote_call_get_parameters (_tmp95_);
		_tmp97_ = _tmp96_;
		_tmp98_ = gee_list_get (_tmp97_, 1);
		iser1 = (zcdISerializable*) _tmp98_;
		_tmp99_ = iser1;
		_tmp100_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp99_);
		_tmp101_ = g_type_is_a (_tmp100_, ZCD_TYPE_SERIALIZABLE_STRING);
		if (!_tmp101_) {
			GError* _tmp102_;
			_tmp102_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "check_hostname parameter 2 is not a string.");
			_inner_error_ = _tmp102_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser1);
			_g_object_unref0 (nip);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp103_ = iser1;
		_tmp104_ = zcd_serializable_string_get_s (G_TYPE_CHECK_INSTANCE_CAST (_tmp103_, ZCD_TYPE_SERIALIZABLE_STRING, zcdSerializableString));
		_tmp105_ = _tmp104_;
		_tmp106_ = g_strdup (_tmp105_);
		hashed_domain = _tmp106_;
		_tmp107_ = data;
		_tmp108_ = zcd_remote_call_get_parameters (_tmp107_);
		_tmp109_ = _tmp108_;
		_tmp110_ = gee_list_get (_tmp109_, 2);
		iser2 = (zcdISerializable*) _tmp110_;
		_tmp111_ = iser2;
		_tmp112_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp111_);
		_tmp113_ = g_type_is_a (_tmp112_, NETSUKUKU_TYPE_PUBLIC_KEY);
		if (!_tmp113_) {
			GError* _tmp114_;
			_tmp114_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "check_hostname parameter 3 is not a PublicKey.");
			_inner_error_ = _tmp114_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser2);
			_g_free0 (hashed_domain);
			_g_object_unref0 (iser1);
			_g_object_unref0 (nip);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp115_ = iser2;
		_tmp116_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp115_, NETSUKUKU_TYPE_PUBLIC_KEY, NetsukukuPublicKey));
		pubkey = _tmp116_;
		_tmp117_ = nip;
		_tmp118_ = hashed_domain;
		_tmp119_ = pubkey;
		_tmp120_ = netsukuku_icounter_as_peer_check_hostname ((NetsukukuICounterAsPeer*) self, _tmp117_, _tmp118_, _tmp119_, &_inner_error_);
		_tmp121_ = _tmp120_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (pubkey);
			_g_object_unref0 (iser2);
			_g_free0 (hashed_domain);
			_g_object_unref0 (iser1);
			_g_object_unref0 (nip);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		result = (zcdISerializable*) _tmp121_;
		_g_object_unref0 (pubkey);
		_g_object_unref0 (iser2);
		_g_free0 (hashed_domain);
		_g_object_unref0 (iser1);
		_g_object_unref0 (nip);
		_g_object_unref0 (iser0);
		pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp122_ = pieces;
	_tmp122__length1 = pieces_length1;
	_tmp123_ = _tmp122_[0];
	if (g_strcmp0 (_tmp123_, "get_hostnames") == 0) {
		gchar** _tmp124_;
		gint _tmp124__length1;
		zcdRemoteCall* _tmp126_;
		GeeList* _tmp127_;
		GeeList* _tmp128_;
		gint _tmp129_;
		gint _tmp130_;
		zcdRemoteCall* _tmp132_;
		GeeList* _tmp133_;
		GeeList* _tmp134_;
		gpointer _tmp135_ = NULL;
		zcdISerializable* iser0;
		zcdISerializable* _tmp136_;
		GType _tmp137_ = 0UL;
		gboolean _tmp138_ = FALSE;
		zcdISerializable* _tmp140_;
		NetsukukuNIP* _tmp141_;
		NetsukukuNIP* nip;
		NetsukukuNIP* _tmp142_;
		NetsukukuCounterNipRecord* _tmp143_ = NULL;
		NetsukukuCounterNipRecord* ret;
		NetsukukuCounterNipRecord* _tmp144_;
		_tmp124_ = pieces;
		_tmp124__length1 = pieces_length1;
		if (_tmp124__length1 != 1) {
			GError* _tmp125_;
			_tmp125_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "get_hostnames is a function.");
			_inner_error_ = _tmp125_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp126_ = data;
		_tmp127_ = zcd_remote_call_get_parameters (_tmp126_);
		_tmp128_ = _tmp127_;
		_tmp129_ = gee_collection_get_size ((GeeCollection*) _tmp128_);
		_tmp130_ = _tmp129_;
		if (_tmp130_ != 1) {
			GError* _tmp131_;
			_tmp131_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "get_hostnames wants 1 parameter.");
			_inner_error_ = _tmp131_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp132_ = data;
		_tmp133_ = zcd_remote_call_get_parameters (_tmp132_);
		_tmp134_ = _tmp133_;
		_tmp135_ = gee_list_get (_tmp134_, 0);
		iser0 = (zcdISerializable*) _tmp135_;
		_tmp136_ = iser0;
		_tmp137_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp136_);
		_tmp138_ = g_type_is_a (_tmp137_, NETSUKUKU_TYPE_NIP);
		if (!_tmp138_) {
			GError* _tmp139_;
			_tmp139_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "get_hostnames parameter 1 is not a NIP.");
			_inner_error_ = _tmp139_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp140_ = iser0;
		_tmp141_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp140_, NETSUKUKU_TYPE_NIP, NetsukukuNIP));
		nip = _tmp141_;
		_tmp142_ = nip;
		_tmp143_ = netsukuku_icounter_as_peer_get_hostnames ((NetsukukuICounterAsPeer*) self, _tmp142_, &_inner_error_);
		ret = _tmp143_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (nip);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp144_ = ret;
		if (_tmp144_ == NULL) {
			zcdSerializableNone* _tmp145_;
			_tmp145_ = zcd_serializable_none_new ();
			result = (zcdISerializable*) _tmp145_;
			_g_object_unref0 (ret);
			_g_object_unref0 (nip);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return result;
		}
		result = (zcdISerializable*) ret;
		_g_object_unref0 (nip);
		_g_object_unref0 (iser0);
		pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp146_ = pieces;
	_tmp146__length1 = pieces_length1;
	_tmp147_ = _tmp146_[0];
	if (g_strcmp0 (_tmp147_, "get_cache_records") == 0) {
		gchar** _tmp148_;
		gint _tmp148__length1;
		zcdRemoteCall* _tmp150_;
		GeeList* _tmp151_;
		GeeList* _tmp152_;
		gint _tmp153_;
		gint _tmp154_;
		NetsukukuCounterGetCacheRecordsResponse* _tmp156_ = NULL;
		NetsukukuCounterGetCacheRecordsResponse* _tmp157_;
		_tmp148_ = pieces;
		_tmp148__length1 = pieces_length1;
		if (_tmp148__length1 != 1) {
			GError* _tmp149_;
			_tmp149_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "get_cache_records is a function.");
			_inner_error_ = _tmp149_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp150_ = data;
		_tmp151_ = zcd_remote_call_get_parameters (_tmp150_);
		_tmp152_ = _tmp151_;
		_tmp153_ = gee_collection_get_size ((GeeCollection*) _tmp152_);
		_tmp154_ = _tmp153_;
		if (_tmp154_ != 0) {
			GError* _tmp155_;
			_tmp155_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "get_cache_records wants no parameters.");
			_inner_error_ = _tmp155_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp156_ = netsukuku_icounter_as_peer_get_cache_records ((NetsukukuICounterAsPeer*) self, &_inner_error_);
		_tmp157_ = _tmp156_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		result = (zcdISerializable*) _tmp157_;
		pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp158_ = caller;
	_tmp159_ = data;
	_tmp160_ = NETSUKUKU_PEER_TO_PEER_CLASS (netsukuku_counter_parent_class)->_dispatch (G_TYPE_CHECK_INSTANCE_CAST (self, NETSUKUKU_TYPE_PEER_TO_PEER, NetsukukuPeerToPeer), _tmp158_, _tmp159_, &_inner_error_);
	_tmp161_ = _tmp160_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
		return NULL;
	}
	result = _tmp161_;
	pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static NetsukukuNIP* netsukuku_counter_nip_for_lvl_pos (NetsukukuCounter* self, gint lvl, gint pos) {
	NetsukukuNIP* result = NULL;
	NetsukukuMapRoute* _tmp0_;
	NetsukukuNIP* _tmp1_;
	gint _tmp2_ = 0;
	gint* _tmp3_ = NULL;
	gint* ret;
	gint ret_length1;
	gint _ret_size_;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	NetsukukuNIP* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = ((NetsukukuPeerToPeer*) self)->maproute;
	_tmp1_ = _tmp0_->me;
	_tmp3_ = netsukuku_partial_nip_get_positions ((NetsukukuPartialNIP*) _tmp1_, &_tmp2_);
	ret = _tmp3_;
	ret_length1 = _tmp2_;
	_ret_size_ = ret_length1;
	_tmp4_ = lvl;
	_tmp5_ = pos;
	ret[_tmp4_] = _tmp5_;
	_tmp6_ = ret[_tmp4_];
	_tmp7_ = netsukuku_nip_new (ret, ret_length1);
	result = _tmp7_;
	ret = (g_free (ret), NULL);
	return result;
}


static gboolean _int_equal (const gint* s1, const gint* s2) {
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	return (*s1) == (*s2);
}


static void netsukuku_counter_impl_init_memory (NetsukukuCounter* self, GError** error) {
	GeeHashMap* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	tasklets_tasklet_declare_self ("Counter.init_memory");
	_tmp0_ = self->priv->cache;
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp0_);
	{
		gint lvl;
		lvl = 0;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				gboolean _tmp2_;
				gint _tmp4_;
				NetsukukuMapRoute* _tmp5_;
				gint _tmp6_;
				gint* first_forward = NULL;
				gint* first_back = NULL;
				gint* last_back = NULL;
				gint _tmp7_;
				gint* _tmp8_ = NULL;
				gint* _tmp9_ = NULL;
				gint* _tmp10_ = NULL;
				gint* _tmp11_;
				_tmp2_ = _tmp1_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = lvl;
					lvl = _tmp3_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp4_ = lvl;
				_tmp5_ = ((NetsukukuPeerToPeer*) self)->maproute;
				_tmp6_ = _tmp5_->levels;
				if (!(_tmp4_ < _tmp6_)) {
					break;
				}
				_tmp7_ = lvl;
				netsukuku_peer_to_peer_find_hook_peers ((NetsukukuPeerToPeer*) self, &_tmp8_, &_tmp9_, &_tmp10_, _tmp7_, NETSUKUKU_COUNTER_DUPLICATION, 120000);
				_g_free0 (first_forward);
				first_forward = _tmp8_;
				_g_free0 (first_back);
				first_back = _tmp9_;
				_g_free0 (last_back);
				last_back = _tmp10_;
				_tmp11_ = first_forward;
				if (_tmp11_ == NULL) {
				} else {
					gint* _tmp12_;
					_tmp12_ = first_back;
					if (_tmp12_ == NULL) {
						gint _tmp13_;
						gint* _tmp14_;
						NetsukukuNIP* _tmp15_ = NULL;
						NetsukukuNIP* nip_first_forward;
						NetsukukuNIP* _tmp16_;
						NetsukukuRmtCounterPeer* _tmp17_ = NULL;
						NetsukukuRmtCounterPeer* peer_first_forward;
						NetsukukuRmtCounterPeer* _tmp18_;
						NetsukukuCounterGetCacheRecordsResponse* _tmp19_ = NULL;
						NetsukukuCounterGetCacheRecordsResponse* cache_first_forward;
						_tmp13_ = lvl;
						_tmp14_ = first_forward;
						_tmp15_ = netsukuku_counter_nip_for_lvl_pos (self, _tmp13_, *_tmp14_);
						nip_first_forward = _tmp15_;
						_tmp16_ = nip_first_forward;
						_tmp17_ = netsukuku_counter_peer (self, _tmp16_, NULL, NULL);
						peer_first_forward = _tmp17_;
						_tmp18_ = peer_first_forward;
						_tmp19_ = netsukuku_icounter_as_peer_get_cache_records ((NetsukukuICounterAsPeer*) _tmp18_, &_inner_error_);
						cache_first_forward = _tmp19_;
						if (_inner_error_ != NULL) {
							g_propagate_error (error, _inner_error_);
							_g_object_unref0 (peer_first_forward);
							_g_object_unref0 (nip_first_forward);
							_g_free0 (last_back);
							_g_free0 (first_back);
							_g_free0 (first_forward);
							return;
						}
						{
							NetsukukuCounterGetCacheRecordsResponse* _tmp20_;
							GeeHashMap* _tmp21_;
							GeeHashMap* _tmp22_;
							GeeSet* _tmp23_;
							GeeSet* _tmp24_;
							GeeSet* _tmp25_;
							GeeIterator* _tmp26_ = NULL;
							GeeIterator* _tmp27_;
							GeeIterator* _pk_nip_it;
							_tmp20_ = cache_first_forward;
							_tmp21_ = netsukuku_counter_get_cache_records_response_get_cache (_tmp20_);
							_tmp22_ = _tmp21_;
							_tmp23_ = gee_abstract_map_get_keys ((GeeMap*) _tmp22_);
							_tmp24_ = _tmp23_;
							_tmp25_ = _tmp24_;
							_tmp26_ = gee_iterable_iterator ((GeeIterable*) _tmp25_);
							_tmp27_ = _tmp26_;
							_g_object_unref0 (_tmp25_);
							_pk_nip_it = _tmp27_;
							while (TRUE) {
								GeeIterator* _tmp28_;
								gboolean _tmp29_ = FALSE;
								GeeIterator* _tmp30_;
								gpointer _tmp31_ = NULL;
								NetsukukuPairPublicKeyNIP* pk_nip;
								GeeHashMap* _tmp32_;
								NetsukukuPairPublicKeyNIP* _tmp33_;
								gboolean _tmp34_ = FALSE;
								_tmp28_ = _pk_nip_it;
								_tmp29_ = gee_iterator_next (_tmp28_);
								if (!_tmp29_) {
									break;
								}
								_tmp30_ = _pk_nip_it;
								_tmp31_ = gee_iterator_get (_tmp30_);
								pk_nip = (NetsukukuPairPublicKeyNIP*) _tmp31_;
								_tmp32_ = self->priv->cache;
								_tmp33_ = pk_nip;
								_tmp34_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp32_, _tmp33_);
								if (!_tmp34_) {
									GeeHashMap* _tmp35_;
									NetsukukuPairPublicKeyNIP* _tmp36_;
									NetsukukuCounterGetCacheRecordsResponse* _tmp37_;
									GeeHashMap* _tmp38_;
									GeeHashMap* _tmp39_;
									NetsukukuPairPublicKeyNIP* _tmp40_;
									gpointer _tmp41_ = NULL;
									NetsukukuCounterNipRecord* _tmp42_;
									_tmp35_ = self->priv->cache;
									_tmp36_ = pk_nip;
									_tmp37_ = cache_first_forward;
									_tmp38_ = netsukuku_counter_get_cache_records_response_get_cache (_tmp37_);
									_tmp39_ = _tmp38_;
									_tmp40_ = pk_nip;
									_tmp41_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp39_, _tmp40_);
									_tmp42_ = (NetsukukuCounterNipRecord*) _tmp41_;
									gee_abstract_map_set ((GeeAbstractMap*) _tmp35_, _tmp36_, _tmp42_);
									_g_object_unref0 (_tmp42_);
								}
								_g_object_unref0 (pk_nip);
							}
							_g_object_unref0 (_pk_nip_it);
						}
						_g_object_unref0 (cache_first_forward);
						_g_object_unref0 (peer_first_forward);
						_g_object_unref0 (nip_first_forward);
						_g_free0 (last_back);
						_g_free0 (first_back);
						_g_free0 (first_forward);
						break;
					} else {
						gint* _tmp43_;
						gint* _tmp44_;
						gint _tmp98_;
						gint* _tmp99_;
						NetsukukuNIP* _tmp100_ = NULL;
						NetsukukuNIP* nip_first_forward;
						NetsukukuNIP* _tmp101_;
						NetsukukuRmtCounterPeer* _tmp102_ = NULL;
						NetsukukuRmtCounterPeer* peer_first_forward;
						NetsukukuRmtCounterPeer* _tmp103_;
						NetsukukuCounterGetCacheRecordsResponse* _tmp104_ = NULL;
						NetsukukuCounterGetCacheRecordsResponse* cache_first_forward;
						_tmp43_ = first_back;
						_tmp44_ = last_back;
						if (_int_equal (_tmp43_, _tmp44_) != TRUE) {
							gint _tmp45_;
							gint* _tmp46_;
							NetsukukuNIP* _tmp47_ = NULL;
							NetsukukuNIP* nip_first_back;
							NetsukukuNIP* _tmp48_;
							NetsukukuRmtCounterPeer* _tmp49_ = NULL;
							NetsukukuRmtCounterPeer* peer_first_back;
							gint _tmp50_;
							gint* _tmp51_;
							NetsukukuNIP* _tmp52_ = NULL;
							NetsukukuNIP* nip_last_back;
							NetsukukuNIP* _tmp53_;
							NetsukukuRmtCounterPeer* _tmp54_ = NULL;
							NetsukukuRmtCounterPeer* peer_last_back;
							NetsukukuRmtCounterPeer* _tmp55_;
							NetsukukuCounterGetCacheRecordsResponse* _tmp56_ = NULL;
							NetsukukuCounterGetCacheRecordsResponse* recs_first;
							NetsukukuRmtCounterPeer* _tmp57_;
							NetsukukuCounterGetCacheRecordsResponse* _tmp58_ = NULL;
							NetsukukuCounterGetCacheRecordsResponse* recs_last;
							_tmp45_ = lvl;
							_tmp46_ = first_back;
							_tmp47_ = netsukuku_counter_nip_for_lvl_pos (self, _tmp45_, *_tmp46_);
							nip_first_back = _tmp47_;
							_tmp48_ = nip_first_back;
							_tmp49_ = netsukuku_counter_peer (self, _tmp48_, NULL, NULL);
							peer_first_back = _tmp49_;
							_tmp50_ = lvl;
							_tmp51_ = last_back;
							_tmp52_ = netsukuku_counter_nip_for_lvl_pos (self, _tmp50_, *_tmp51_);
							nip_last_back = _tmp52_;
							_tmp53_ = nip_last_back;
							_tmp54_ = netsukuku_counter_peer (self, _tmp53_, NULL, NULL);
							peer_last_back = _tmp54_;
							_tmp55_ = peer_first_back;
							_tmp56_ = netsukuku_icounter_as_peer_get_cache_records ((NetsukukuICounterAsPeer*) _tmp55_, &_inner_error_);
							recs_first = _tmp56_;
							if (_inner_error_ != NULL) {
								g_propagate_error (error, _inner_error_);
								_g_object_unref0 (peer_last_back);
								_g_object_unref0 (nip_last_back);
								_g_object_unref0 (peer_first_back);
								_g_object_unref0 (nip_first_back);
								_g_free0 (last_back);
								_g_free0 (first_back);
								_g_free0 (first_forward);
								return;
							}
							_tmp57_ = peer_last_back;
							_tmp58_ = netsukuku_icounter_as_peer_get_cache_records ((NetsukukuICounterAsPeer*) _tmp57_, &_inner_error_);
							recs_last = _tmp58_;
							if (_inner_error_ != NULL) {
								g_propagate_error (error, _inner_error_);
								_g_object_unref0 (recs_first);
								_g_object_unref0 (peer_last_back);
								_g_object_unref0 (nip_last_back);
								_g_object_unref0 (peer_first_back);
								_g_object_unref0 (nip_first_back);
								_g_free0 (last_back);
								_g_free0 (first_back);
								_g_free0 (first_forward);
								return;
							}
							{
								NetsukukuCounterGetCacheRecordsResponse* _tmp59_;
								GeeHashMap* _tmp60_;
								GeeHashMap* _tmp61_;
								GeeSet* _tmp62_;
								GeeSet* _tmp63_;
								GeeSet* _tmp64_;
								GeeIterator* _tmp65_ = NULL;
								GeeIterator* _tmp66_;
								GeeIterator* _pk_nip_it;
								_tmp59_ = recs_first;
								_tmp60_ = netsukuku_counter_get_cache_records_response_get_cache (_tmp59_);
								_tmp61_ = _tmp60_;
								_tmp62_ = gee_abstract_map_get_keys ((GeeMap*) _tmp61_);
								_tmp63_ = _tmp62_;
								_tmp64_ = _tmp63_;
								_tmp65_ = gee_iterable_iterator ((GeeIterable*) _tmp64_);
								_tmp66_ = _tmp65_;
								_g_object_unref0 (_tmp64_);
								_pk_nip_it = _tmp66_;
								while (TRUE) {
									GeeIterator* _tmp67_;
									gboolean _tmp68_ = FALSE;
									GeeIterator* _tmp69_;
									gpointer _tmp70_ = NULL;
									NetsukukuPairPublicKeyNIP* pk_nip;
									GeeHashMap* _tmp71_;
									NetsukukuPairPublicKeyNIP* _tmp72_;
									gboolean _tmp73_ = FALSE;
									_tmp67_ = _pk_nip_it;
									_tmp68_ = gee_iterator_next (_tmp67_);
									if (!_tmp68_) {
										break;
									}
									_tmp69_ = _pk_nip_it;
									_tmp70_ = gee_iterator_get (_tmp69_);
									pk_nip = (NetsukukuPairPublicKeyNIP*) _tmp70_;
									_tmp71_ = self->priv->cache;
									_tmp72_ = pk_nip;
									_tmp73_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp71_, _tmp72_);
									if (!_tmp73_) {
										gboolean found;
										gboolean _tmp89_;
										found = FALSE;
										{
											NetsukukuCounterGetCacheRecordsResponse* _tmp74_;
											GeeHashMap* _tmp75_;
											GeeHashMap* _tmp76_;
											GeeSet* _tmp77_;
											GeeSet* _tmp78_;
											GeeSet* _tmp79_;
											GeeIterator* _tmp80_ = NULL;
											GeeIterator* _tmp81_;
											GeeIterator* _pk_nip2_it;
											_tmp74_ = recs_last;
											_tmp75_ = netsukuku_counter_get_cache_records_response_get_cache (_tmp74_);
											_tmp76_ = _tmp75_;
											_tmp77_ = gee_abstract_map_get_keys ((GeeMap*) _tmp76_);
											_tmp78_ = _tmp77_;
											_tmp79_ = _tmp78_;
											_tmp80_ = gee_iterable_iterator ((GeeIterable*) _tmp79_);
											_tmp81_ = _tmp80_;
											_g_object_unref0 (_tmp79_);
											_pk_nip2_it = _tmp81_;
											while (TRUE) {
												GeeIterator* _tmp82_;
												gboolean _tmp83_ = FALSE;
												GeeIterator* _tmp84_;
												gpointer _tmp85_ = NULL;
												NetsukukuPairPublicKeyNIP* pk_nip2;
												NetsukukuPairPublicKeyNIP* _tmp86_;
												NetsukukuPairPublicKeyNIP* _tmp87_;
												gboolean _tmp88_ = FALSE;
												_tmp82_ = _pk_nip2_it;
												_tmp83_ = gee_iterator_next (_tmp82_);
												if (!_tmp83_) {
													break;
												}
												_tmp84_ = _pk_nip2_it;
												_tmp85_ = gee_iterator_get (_tmp84_);
												pk_nip2 = (NetsukukuPairPublicKeyNIP*) _tmp85_;
												_tmp86_ = pk_nip2;
												_tmp87_ = pk_nip;
												_tmp88_ = netsukuku_pair_public_key_nip_equal_func (_tmp86_, _tmp87_);
												if (_tmp88_) {
													found = TRUE;
													_g_object_unref0 (pk_nip2);
													break;
												}
												_g_object_unref0 (pk_nip2);
											}
											_g_object_unref0 (_pk_nip2_it);
										}
										_tmp89_ = found;
										if (!_tmp89_) {
											GeeHashMap* _tmp90_;
											NetsukukuPairPublicKeyNIP* _tmp91_;
											NetsukukuCounterGetCacheRecordsResponse* _tmp92_;
											GeeHashMap* _tmp93_;
											GeeHashMap* _tmp94_;
											NetsukukuPairPublicKeyNIP* _tmp95_;
											gpointer _tmp96_ = NULL;
											NetsukukuCounterNipRecord* _tmp97_;
											_tmp90_ = self->priv->cache;
											_tmp91_ = pk_nip;
											_tmp92_ = recs_first;
											_tmp93_ = netsukuku_counter_get_cache_records_response_get_cache (_tmp92_);
											_tmp94_ = _tmp93_;
											_tmp95_ = pk_nip;
											_tmp96_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp94_, _tmp95_);
											_tmp97_ = (NetsukukuCounterNipRecord*) _tmp96_;
											gee_abstract_map_set ((GeeAbstractMap*) _tmp90_, _tmp91_, _tmp97_);
											_g_object_unref0 (_tmp97_);
										}
									}
									_g_object_unref0 (pk_nip);
								}
								_g_object_unref0 (_pk_nip_it);
							}
							_g_object_unref0 (recs_last);
							_g_object_unref0 (recs_first);
							_g_object_unref0 (peer_last_back);
							_g_object_unref0 (nip_last_back);
							_g_object_unref0 (peer_first_back);
							_g_object_unref0 (nip_first_back);
						}
						_tmp98_ = lvl;
						_tmp99_ = first_forward;
						_tmp100_ = netsukuku_counter_nip_for_lvl_pos (self, _tmp98_, *_tmp99_);
						nip_first_forward = _tmp100_;
						_tmp101_ = nip_first_forward;
						_tmp102_ = netsukuku_counter_peer (self, _tmp101_, NULL, NULL);
						peer_first_forward = _tmp102_;
						_tmp103_ = peer_first_forward;
						_tmp104_ = netsukuku_icounter_as_peer_get_cache_records ((NetsukukuICounterAsPeer*) _tmp103_, &_inner_error_);
						cache_first_forward = _tmp104_;
						if (_inner_error_ != NULL) {
							g_propagate_error (error, _inner_error_);
							_g_object_unref0 (peer_first_forward);
							_g_object_unref0 (nip_first_forward);
							_g_free0 (last_back);
							_g_free0 (first_back);
							_g_free0 (first_forward);
							return;
						}
						{
							NetsukukuCounterGetCacheRecordsResponse* _tmp105_;
							GeeHashMap* _tmp106_;
							GeeHashMap* _tmp107_;
							GeeSet* _tmp108_;
							GeeSet* _tmp109_;
							GeeSet* _tmp110_;
							GeeIterator* _tmp111_ = NULL;
							GeeIterator* _tmp112_;
							GeeIterator* _pk_nip_it;
							_tmp105_ = cache_first_forward;
							_tmp106_ = netsukuku_counter_get_cache_records_response_get_cache (_tmp105_);
							_tmp107_ = _tmp106_;
							_tmp108_ = gee_abstract_map_get_keys ((GeeMap*) _tmp107_);
							_tmp109_ = _tmp108_;
							_tmp110_ = _tmp109_;
							_tmp111_ = gee_iterable_iterator ((GeeIterable*) _tmp110_);
							_tmp112_ = _tmp111_;
							_g_object_unref0 (_tmp110_);
							_pk_nip_it = _tmp112_;
							while (TRUE) {
								GeeIterator* _tmp113_;
								gboolean _tmp114_ = FALSE;
								GeeIterator* _tmp115_;
								gpointer _tmp116_ = NULL;
								NetsukukuPairPublicKeyNIP* pk_nip;
								GeeHashMap* _tmp117_;
								NetsukukuPairPublicKeyNIP* _tmp118_;
								gboolean _tmp119_ = FALSE;
								_tmp113_ = _pk_nip_it;
								_tmp114_ = gee_iterator_next (_tmp113_);
								if (!_tmp114_) {
									break;
								}
								_tmp115_ = _pk_nip_it;
								_tmp116_ = gee_iterator_get (_tmp115_);
								pk_nip = (NetsukukuPairPublicKeyNIP*) _tmp116_;
								_tmp117_ = self->priv->cache;
								_tmp118_ = pk_nip;
								_tmp119_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp117_, _tmp118_);
								if (!_tmp119_) {
									gboolean check;
									NetsukukuPairPublicKeyNIP* _tmp120_;
									NetsukukuNIP* _tmp121_;
									NetsukukuNIP* _tmp122_;
									NetsukukuNIP* _tmp123_ = NULL;
									NetsukukuNIP* _tmp124_;
									gint _tmp125_;
									gint _tmp126_ = 0;
									gint _tmp127_;
									gint hk;
									gint _tmp128_;
									GeeList* _tmp129_ = NULL;
									GeeList* ids;
									GeeList* _tmp130_;
									gint* _tmp131_;
									gint _tmp132_ = 0;
									GeeList* _tmp133_;
									NetsukukuMapRoute* _tmp134_;
									NetsukukuNIP* _tmp135_;
									gint _tmp136_;
									gint _tmp137_ = 0;
									gint _tmp138_ = 0;
									gboolean _tmp139_;
									check = FALSE;
									_tmp120_ = pk_nip;
									_tmp121_ = netsukuku_pair_public_key_nip_get_nip (_tmp120_);
									_tmp122_ = _tmp121_;
									_tmp123_ = netsukuku_peer_to_peer_h ((NetsukukuPeerToPeer*) self, (GObject*) _tmp122_);
									_tmp124_ = _tmp123_;
									_tmp125_ = lvl;
									_tmp126_ = netsukuku_partial_nip_position_at ((NetsukukuPartialNIP*) _tmp124_, _tmp125_);
									_tmp127_ = _tmp126_;
									_g_object_unref0 (_tmp124_);
									hk = _tmp127_;
									_tmp128_ = hk;
									_tmp129_ = netsukuku_peer_to_peer_list_ids ((NetsukukuPeerToPeer*) self, _tmp128_, 1);
									ids = _tmp129_;
									_tmp130_ = ids;
									_tmp131_ = first_forward;
									_tmp132_ = gee_list_index_of (_tmp130_, (gpointer) ((gintptr) (*_tmp131_)));
									_tmp133_ = ids;
									_tmp134_ = ((NetsukukuPeerToPeer*) self)->maproute;
									_tmp135_ = _tmp134_->me;
									_tmp136_ = lvl;
									_tmp137_ = netsukuku_partial_nip_position_at ((NetsukukuPartialNIP*) _tmp135_, _tmp136_);
									_tmp138_ = gee_list_index_of (_tmp133_, (gpointer) ((gintptr) _tmp137_));
									if (_tmp132_ > _tmp138_) {
										check = TRUE;
									}
									_tmp139_ = check;
									if (_tmp139_) {
										GeeHashMap* _tmp140_;
										NetsukukuPairPublicKeyNIP* _tmp141_;
										NetsukukuCounterGetCacheRecordsResponse* _tmp142_;
										GeeHashMap* _tmp143_;
										GeeHashMap* _tmp144_;
										NetsukukuPairPublicKeyNIP* _tmp145_;
										gpointer _tmp146_ = NULL;
										NetsukukuCounterNipRecord* _tmp147_;
										_tmp140_ = self->priv->cache;
										_tmp141_ = pk_nip;
										_tmp142_ = cache_first_forward;
										_tmp143_ = netsukuku_counter_get_cache_records_response_get_cache (_tmp142_);
										_tmp144_ = _tmp143_;
										_tmp145_ = pk_nip;
										_tmp146_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp144_, _tmp145_);
										_tmp147_ = (NetsukukuCounterNipRecord*) _tmp146_;
										gee_abstract_map_set ((GeeAbstractMap*) _tmp140_, _tmp141_, _tmp147_);
										_g_object_unref0 (_tmp147_);
									}
									_g_object_unref0 (ids);
								}
								_g_object_unref0 (pk_nip);
							}
							_g_object_unref0 (_pk_nip_it);
						}
						_g_object_unref0 (cache_first_forward);
						_g_object_unref0 (peer_first_forward);
						_g_object_unref0 (nip_first_forward);
						_g_free0 (last_back);
						_g_free0 (first_back);
						_g_free0 (first_forward);
						break;
					}
				}
				_g_free0 (last_back);
				_g_free0 (first_back);
				_g_free0 (first_forward);
			}
		}
	}
	self->memory_initialized = TRUE;
	netsukuku_log_info ("Counter service: memory ready.");
	g_signal_emit_by_name (self, "counter-ready");
}


static void __lambda2_ (NetsukukuCounter* self, GError** error) {
	GError * _inner_error_ = NULL;
	while (TRUE) {
		{
			netsukuku_counter_impl_init_memory (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch18_g_error;
			}
			break;
		}
		goto __finally18;
		__catch18_g_error:
		{
			GError* e = NULL;
			GError* _tmp0_;
			GQuark _tmp1_;
			const gchar* _tmp2_ = NULL;
			const gchar* _tmp3_ = NULL;
			GError* _tmp4_;
			gint _tmp5_;
			gchar* _tmp6_ = NULL;
			gchar* _tmp7_;
			GError* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_ = NULL;
			gchar* _tmp11_ = NULL;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp0_ = e;
			_tmp1_ = _tmp0_->domain;
			_tmp2_ = g_quark_to_string (_tmp1_);
			_tmp3_ = string_to_string (_tmp2_);
			_tmp4_ = e;
			_tmp5_ = _tmp4_->code;
			_tmp6_ = g_strdup_printf ("%i", _tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = e;
			_tmp9_ = _tmp8_->message;
			_tmp10_ = string_to_string (_tmp9_);
			_tmp11_ = g_strconcat ("got ", _tmp3_, " ", _tmp7_, " ", _tmp10_, ". ", NULL);
			_tmp12_ = _tmp11_;
			_tmp13_ = g_strconcat ("Counter.init_memory: ", _tmp12_, NULL);
			_tmp14_ = _tmp13_;
			_tmp15_ = g_strconcat (_tmp14_, "Trying again.\n", NULL);
			_tmp16_ = _tmp15_;
			netsukuku_log_warn (_tmp16_);
			_g_free0 (_tmp16_);
			_g_free0 (_tmp14_);
			_g_free0 (_tmp12_);
			_g_free0 (_tmp7_);
			tasklets_ms_wait ((gint64) 100);
			_g_error_free0 (e);
		}
		__finally18:
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return;
		}
	}
}


static void ___lambda2__tasklets_tasklet_callback (GObject* obj1, GObject* obj2, GObject* obj3, GObject* obj4, gpointer self, GError** error) {
	__lambda2_ (self, error);
}


void netsukuku_counter_init_memory (NetsukukuCounter* self) {
	TaskletsTasklet* _tmp0_ = NULL;
	TaskletsTasklet* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = tasklets_tasklet_tasklet_callback (___lambda2__tasklets_tasklet_callback, self, NULL, NULL, NULL, NULL);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (_tmp1_);
}


/** This is the function h:KEY-->hIP.
          */
static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res_length1;
	_tmp3_ = res;
	_tmp3__length1 = res_length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


static NetsukukuNIP* netsukuku_counter_real_h (NetsukukuPeerToPeer* base, GObject* key) {
	NetsukukuCounter * self;
	NetsukukuNIP* result = NULL;
	GObject* _tmp0_;
	NetsukukuNIP* _tmp1_;
	NetsukukuNIP* _key;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	guint8* _tmp4_;
	gint _tmp4__length1;
	guint8* _tmp5_;
	gint _tmp5__length1;
	gint _tmp6_ = 0;
	guint8* _tmp7_ = NULL;
	guint8* _tmp8_;
	gint _tmp8__length1;
	guint8* hash;
	gint hash_length1;
	gint _hash_size_;
	guint8 _tmp9_;
	guint8 _tmp10_;
	guint8 _tmp11_;
	guint8 _tmp12_;
	guint32 basic_hash;
	NetsukukuMapRoute* _tmp13_;
	gint _tmp14_;
	gint* _tmp15_ = NULL;
	gint* positions;
	gint positions_length1;
	gint _positions_size_;
	gint* _tmp32_;
	gint _tmp32__length1;
	NetsukukuNIP* _tmp33_;
	NetsukukuNIP* ret;
	GError * _inner_error_ = NULL;
	self = (NetsukukuCounter*) base;
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = key;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, NETSUKUKU_TYPE_NIP, NetsukukuNIP));
	_key = _tmp1_;
	_tmp2_ = netsukuku_partial_nip_to_string ((NetsukukuPartialNIP*) _key);
	_tmp3_ = _tmp2_;
	_tmp4_ = string_get_data (_tmp3_, &_tmp4__length1);
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _tmp4__length1;
	_tmp7_ = netsukuku_crypto_md5 (_tmp5_, _tmp5__length1, &_tmp6_, &_inner_error_);
	_tmp8_ = _tmp7_;
	_tmp8__length1 = _tmp6_;
	_g_free0 (_tmp3_);
	hash = _tmp8_;
	hash_length1 = _tmp8__length1;
	_hash_size_ = hash_length1;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (_key);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp9_ = hash[15];
	_tmp10_ = hash[14];
	_tmp11_ = hash[13];
	_tmp12_ = hash[12];
	basic_hash = ((((guint32) _tmp9_) + (((guint32) _tmp10_) * ((guint32) 256))) + ((((guint32) _tmp11_) * ((guint32) 256)) * ((guint32) 256))) + (((((guint32) _tmp12_) * ((guint32) 256)) * ((guint32) 256)) * ((guint32) 256));
	_tmp13_ = ((NetsukukuPeerToPeer*) self)->maproute;
	_tmp14_ = _tmp13_->levels;
	_tmp15_ = g_new0 (gint, _tmp14_);
	positions = _tmp15_;
	positions_length1 = _tmp14_;
	_positions_size_ = positions_length1;
	{
		gint lvl;
		lvl = 0;
		{
			gboolean _tmp16_;
			_tmp16_ = TRUE;
			while (TRUE) {
				gboolean _tmp17_;
				gint _tmp19_;
				NetsukukuMapRoute* _tmp20_;
				gint _tmp21_;
				guint32 _tmp22_;
				NetsukukuMapRoute* _tmp23_;
				gint _tmp24_;
				guint pos;
				gint* _tmp25_;
				gint _tmp25__length1;
				gint _tmp26_;
				guint _tmp27_;
				gint _tmp28_;
				guint32 _tmp29_;
				NetsukukuMapRoute* _tmp30_;
				gint _tmp31_;
				_tmp17_ = _tmp16_;
				if (!_tmp17_) {
					gint _tmp18_;
					_tmp18_ = lvl;
					lvl = _tmp18_ + 1;
				}
				_tmp16_ = FALSE;
				_tmp19_ = lvl;
				_tmp20_ = ((NetsukukuPeerToPeer*) self)->maproute;
				_tmp21_ = _tmp20_->levels;
				if (!(_tmp19_ < _tmp21_)) {
					break;
				}
				_tmp22_ = basic_hash;
				_tmp23_ = ((NetsukukuPeerToPeer*) self)->maproute;
				_tmp24_ = _tmp23_->gsize;
				pos = (guint) (_tmp22_ % _tmp24_);
				_tmp25_ = positions;
				_tmp25__length1 = positions_length1;
				_tmp26_ = lvl;
				_tmp27_ = pos;
				_tmp25_[_tmp26_] = (gint) _tmp27_;
				_tmp28_ = _tmp25_[_tmp26_];
				_tmp29_ = basic_hash;
				_tmp30_ = ((NetsukukuPeerToPeer*) self)->maproute;
				_tmp31_ = _tmp30_->gsize;
				basic_hash = _tmp29_ / _tmp31_;
			}
		}
	}
	_tmp32_ = positions;
	_tmp32__length1 = positions_length1;
	_tmp33_ = netsukuku_nip_new (_tmp32_, _tmp32__length1);
	ret = _tmp33_;
	result = ret;
	positions = (g_free (positions), NULL);
	hash = (g_free (hash), NULL);
	_g_object_unref0 (_key);
	return result;
}


static void netsukuku_counter_impl_reset_my_counter_node (NetsukukuCounter* self, GError** error) {
	TaskletsTasklet* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	tasklets_tasklet_declare_self ("Counter.reset_my_counter_node");
	_tmp0_ = tasklets_tasklet_self ();
	_g_object_unref0 (self->priv->reset_my_counter_node_tasklet);
	self->priv->reset_my_counter_node_tasklet = _tmp0_;
	while (TRUE) {
		NetsukukuTimeCapsule* ttl = NULL;
		{
			NetsukukuCounterSetDataResponse* _tmp1_ = NULL;
			NetsukukuCounterSetDataResponse* resp;
			NetsukukuCounterSetDataResponse* _tmp2_;
			const gchar* _tmp3_;
			const gchar* _tmp4_;
			_tmp1_ = netsukuku_counter_ask_set_data_for_pubk (self, &_inner_error_);
			resp = _tmp1_;
			if (_inner_error_ != NULL) {
				goto __catch19_g_error;
			}
			_tmp2_ = resp;
			_tmp3_ = netsukuku_counter_set_data_response_get_response (_tmp2_);
			_tmp4_ = _tmp3_;
			if (g_strcmp0 (_tmp4_, "OK") == 0) {
				NetsukukuCounterSetDataResponse* _tmp5_;
				NetsukukuTimeCapsule* _tmp6_;
				NetsukukuTimeCapsule* _tmp7_;
				NetsukukuTimeCapsule* _tmp8_;
				NetsukukuTimeCapsule* _tmp9_;
				gint64 _tmp10_ = 0LL;
				NetsukukuTimeCapsule* _tmp11_;
				NetsukukuTimeCapsule* _tmp12_;
				NetsukukuTimeCapsule* maxttl;
				NetsukukuTimeCapsule* _tmp13_;
				NetsukukuTimeCapsule* _tmp14_;
				gboolean _tmp15_ = FALSE;
				g_signal_emit_by_name (self, "counter-registered");
				_tmp5_ = resp;
				_tmp6_ = netsukuku_counter_set_data_response_get_expires (_tmp5_);
				_tmp7_ = _tmp6_;
				_tmp8_ = _g_object_ref0 (_tmp7_);
				_g_object_unref0 (ttl);
				ttl = _tmp8_;
				_tmp9_ = ttl;
				_tmp10_ = tasklets_timer_get_msec_ttl ((TaskletsTimer*) _tmp9_);
				_tmp11_ = netsukuku_time_capsule_new (_tmp10_ - ((((gint64) 1000) * ((gint64) 60)) * ((gint64) 10)));
				_g_object_unref0 (ttl);
				ttl = _tmp11_;
				_tmp12_ = netsukuku_time_capsule_new (NETSUKUKU_MAX_WAIT_REFRESH_COUNTER);
				maxttl = _tmp12_;
				_tmp13_ = ttl;
				_tmp14_ = maxttl;
				_tmp15_ = tasklets_timer_is_younger ((TaskletsTimer*) _tmp13_, (TaskletsTimer*) _tmp14_);
				if (_tmp15_) {
					NetsukukuTimeCapsule* _tmp16_;
					NetsukukuTimeCapsule* _tmp17_;
					_tmp16_ = maxttl;
					_tmp17_ = _g_object_ref0 (_tmp16_);
					_g_object_unref0 (ttl);
					ttl = _tmp17_;
				}
				_g_object_unref0 (maxttl);
			} else {
				NetsukukuTimeCapsule* _tmp18_;
				_tmp18_ = netsukuku_time_capsule_new ((((gint64) 1000) * ((gint64) 60)) * ((gint64) 2));
				_g_object_unref0 (ttl);
				ttl = _tmp18_;
			}
			_g_object_unref0 (resp);
		}
		goto __finally19;
		__catch19_g_error:
		{
			GError* e = NULL;
			NetsukukuTimeCapsule* _tmp19_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp19_ = netsukuku_time_capsule_new ((((gint64) 1000) * ((gint64) 60)) * ((gint64) 2));
			_g_object_unref0 (ttl);
			ttl = _tmp19_;
			_g_error_free0 (e);
		}
		__finally19:
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (ttl);
			return;
		}
		while (TRUE) {
			NetsukukuTimeCapsule* _tmp20_;
			gboolean _tmp21_ = FALSE;
			_tmp20_ = ttl;
			_tmp21_ = tasklets_timer_is_expired ((TaskletsTimer*) _tmp20_);
			if (!(!_tmp21_)) {
				break;
			}
			tasklets_tasklet_nap ((glong) 0, (glong) 100000);
		}
		_g_object_unref0 (ttl);
	}
}


static void* netsukuku_counter_helper_reset_my_counter_node (void* v, GError** error) {
	void* result = NULL;
	void* _tmp0_;
	Netsukukustruct_helper_Counter_reset_my_counter_node* tuple_p;
	NetsukukuCounter* _tmp1_;
	NetsukukuCounter* _tmp2_;
	NetsukukuCounter* self_save;
	GError * _inner_error_ = NULL;
	_tmp0_ = v;
	tuple_p = (Netsukukustruct_helper_Counter_reset_my_counter_node*) _tmp0_;
	_tmp1_ = (*tuple_p).self;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	self_save = _tmp2_;
	tasklets_tasklet_schedule_back ();
	netsukuku_counter_impl_reset_my_counter_node (self_save, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self_save);
		return NULL;
	}
	result = NULL;
	_g_object_unref0 (self_save);
	return result;
}


void netsukuku_counter_reset_my_counter_node (NetsukukuCounter* self) {
	Netsukukustruct_helper_Counter_reset_my_counter_node arg = {0};
	NetsukukuCounter* _tmp0_;
	TaskletsTasklet* _tmp1_ = NULL;
	TaskletsTasklet* _tmp2_;
	g_return_if_fail (self != NULL);
	memset (&arg, 0, sizeof (Netsukukustruct_helper_Counter_reset_my_counter_node));
	_tmp0_ = _g_object_ref0 (self);
	_g_object_unref0 (arg.self);
	arg.self = _tmp0_;
	_tmp1_ = tasklets_tasklet_spawn ((TaskletsSpawnable) netsukuku_counter_helper_reset_my_counter_node, &arg, FALSE, -1);
	_tmp2_ = _tmp1_;
	_g_object_unref0 (_tmp2_);
	netsukuku_struct_helper_counter_reset_my_counter_node_destroy (&arg);
}


void netsukuku_counter_stop_reset_my_counter_node (NetsukukuCounter* self) {
	TaskletsTasklet* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->reset_my_counter_node_tasklet;
	if (_tmp0_ != NULL) {
		TaskletsTasklet* _tmp1_;
		_tmp1_ = self->priv->reset_my_counter_node_tasklet;
		tasklets_tasklet_abort (_tmp1_);
	}
	_g_object_unref0 (self->priv->reset_my_counter_node_tasklet);
	self->priv->reset_my_counter_node_tasklet = NULL;
}


gboolean netsukuku_counter_reset_my_counter_node_ongoing (NetsukukuCounter* self) {
	gboolean result = FALSE;
	TaskletsTasklet* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->reset_my_counter_node_tasklet;
	result = _tmp0_ != NULL;
	return result;
}


static NetsukukuCounterSetDataResponse* netsukuku_counter_ask_set_data_for_pubk (NetsukukuCounter* self, GError** error) {
	NetsukukuCounterSetDataResponse* result = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	zcdSerializableBuffer* _tmp2_ = NULL;
	zcdSerializableBuffer* signature;
	NetsukukuMapRoute* _tmp3_;
	NetsukukuNIP* _tmp4_;
	NetsukukuRmtCounterPeer* _tmp5_ = NULL;
	NetsukukuRmtCounterPeer* _tmp6_;
	NetsukukuMapRoute* _tmp7_;
	NetsukukuNIP* _tmp8_;
	GeeArrayList* _tmp9_;
	GeeArrayList* _tmp10_;
	NetsukukuPublicKey* _tmp11_;
	NetsukukuCounterSetDataResponse* _tmp12_ = NULL;
	NetsukukuCounterSetDataResponse* _tmp13_;
	NetsukukuCounterSetDataResponse* ret;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = netsukuku_counter_get_hashednames (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _netsukuku_counter_sign (self, (GeeList*) _tmp1_);
	signature = _tmp2_;
	netsukuku_log_debug ("possible uncaught error: Counter client: calling set_data_for_pubk: in" \
" progress...");
	_tmp3_ = ((NetsukukuPeerToPeer*) self)->maproute;
	_tmp4_ = _tmp3_->me;
	_tmp5_ = netsukuku_counter_peer (self, NULL, (GObject*) _tmp4_, NULL);
	_tmp6_ = _tmp5_;
	_tmp7_ = ((NetsukukuPeerToPeer*) self)->maproute;
	_tmp8_ = _tmp7_->me;
	_tmp9_ = netsukuku_counter_get_hashednames (self);
	_tmp10_ = _tmp9_;
	_tmp11_ = self->priv->pubk;
	_tmp12_ = netsukuku_icounter_as_peer_set_data_for_pubk ((NetsukukuICounterAsPeer*) _tmp6_, _tmp8_, (GeeList*) _tmp10_, _tmp11_, signature, TRUE, &_inner_error_);
	_tmp13_ = _tmp12_;
	_g_object_unref0 (_tmp6_);
	ret = _tmp13_;
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == ZCD_RPC_ERROR) || (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (signature);
			return NULL;
		} else {
			_g_object_unref0 (signature);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	netsukuku_log_debug ("done.");
	result = ret;
	_g_object_unref0 (signature);
	return result;
}


static zcdSerializableBuffer* _netsukuku_counter_sign (NetsukukuCounter* self, GeeList* hashed_domains) {
	zcdSerializableBuffer* result = NULL;
	NetsukukuKeyPair* _tmp0_;
	NetsukukuMapRoute* _tmp1_;
	NetsukukuNIP* _tmp2_;
	GeeList* _tmp3_;
	gint _tmp4_ = 0;
	guchar* _tmp5_ = NULL;
	guchar* _tmp6_;
	gint _tmp6__length1;
	gint _tmp7_ = 0;
	guchar* _tmp8_ = NULL;
	guchar* _tmp9_;
	gint _tmp9__length1;
	guchar* _signed_;
	gint _signed__length1;
	gint __signed__size_;
	zcdSerializableBuffer* _tmp10_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (hashed_domains != NULL, NULL);
	_tmp0_ = self->priv->my_keys;
	_tmp1_ = ((NetsukukuPeerToPeer*) self)->maproute;
	_tmp2_ = _tmp1_->me;
	_tmp3_ = hashed_domains;
	_tmp5_ = netsukuku_counter_utilities_prepare_msg (_tmp2_, _tmp3_, &_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp6__length1 = _tmp4_;
	_tmp8_ = netsukuku_key_pair_sign (_tmp0_, _tmp6_, _tmp4_, &_tmp7_, &_inner_error_);
	_tmp9_ = _tmp8_;
	_tmp9__length1 = _tmp7_;
	_tmp6_ = (g_free (_tmp6_), NULL);
	_signed_ = _tmp9_;
	_signed__length1 = _tmp9__length1;
	__signed__size_ = _signed__length1;
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp10_ = zcd_serializable_buffer_new ((guint8*) _signed_, (_signed__length1 * sizeof (guchar)) / sizeof (guint8));
	result = _tmp10_;
	_signed_ = (g_free (_signed_), NULL);
	return result;
}


static gboolean _netsukuku_counter_verify (NetsukukuCounter* self, NetsukukuNIP* nip, GeeList* hashed_domains, NetsukukuPublicKey* pubk, zcdSerializableBuffer* signature) {
	gboolean result = FALSE;
	NetsukukuPublicKey* _tmp0_;
	NetsukukuPublicKeyWrapper* _tmp1_;
	NetsukukuPublicKeyWrapper* pkw;
	NetsukukuPublicKeyWrapper* _tmp2_;
	NetsukukuNIP* _tmp3_;
	GeeList* _tmp4_;
	gint _tmp5_ = 0;
	guchar* _tmp6_ = NULL;
	guchar* _tmp7_;
	gint _tmp7__length1;
	zcdSerializableBuffer* _tmp8_;
	guint8* _tmp9_;
	gint _tmp9__length1;
	guint8* _tmp10_;
	gint _tmp10__length1;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_;
	gboolean _tmp13_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (nip != NULL, FALSE);
	g_return_val_if_fail (hashed_domains != NULL, FALSE);
	g_return_val_if_fail (pubk != NULL, FALSE);
	g_return_val_if_fail (signature != NULL, FALSE);
	_tmp0_ = pubk;
	_tmp1_ = netsukuku_public_key_wrapper_new_from_pubk (_tmp0_, &_inner_error_);
	pkw = _tmp1_;
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp2_ = pkw;
	_tmp3_ = nip;
	_tmp4_ = hashed_domains;
	_tmp6_ = netsukuku_counter_utilities_prepare_msg (_tmp3_, _tmp4_, &_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _tmp5_;
	_tmp8_ = signature;
	_tmp9_ = zcd_serializable_buffer_get_buffer (_tmp8_, &_tmp9__length1);
	_tmp10_ = _tmp9_;
	_tmp10__length1 = _tmp9__length1;
	_tmp11_ = netsukuku_public_key_wrapper_verify (_tmp2_, _tmp7_, _tmp5_, (guchar*) _tmp10_, (_tmp10__length1 * sizeof (guint8)) / sizeof (guchar), &_inner_error_);
	_tmp12_ = _tmp11_;
	_tmp7_ = (g_free (_tmp7_), NULL);
	_tmp13_ = _tmp12_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (pkw);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = _tmp13_;
	_g_object_unref0 (pkw);
	return result;
}


NetsukukuCounterCheckHostnameResponse* netsukuku_counter_ask_check_hostname (NetsukukuCounter* self, NetsukukuNIP* nip, const gchar* hashed_domain, NetsukukuPublicKey* pubkey, GError** error) {
	NetsukukuCounterCheckHostnameResponse* result = NULL;
	NetsukukuNIP* _tmp0_;
	NetsukukuRmtCounterPeer* _tmp1_ = NULL;
	NetsukukuRmtCounterPeer* _tmp2_;
	NetsukukuNIP* _tmp3_;
	const gchar* _tmp4_;
	NetsukukuPublicKey* _tmp5_;
	NetsukukuCounterCheckHostnameResponse* _tmp6_ = NULL;
	NetsukukuCounterCheckHostnameResponse* _tmp7_;
	NetsukukuCounterCheckHostnameResponse* _tmp8_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (nip != NULL, NULL);
	g_return_val_if_fail (hashed_domain != NULL, NULL);
	g_return_val_if_fail (pubkey != NULL, NULL);
	_tmp0_ = nip;
	_tmp1_ = netsukuku_counter_peer (self, NULL, (GObject*) _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = nip;
	_tmp4_ = hashed_domain;
	_tmp5_ = pubkey;
	_tmp6_ = netsukuku_icounter_as_peer_check_hostname ((NetsukukuICounterAsPeer*) _tmp2_, _tmp3_, _tmp4_, _tmp5_, &_inner_error_);
	_tmp7_ = _tmp6_;
	_g_object_unref0 (_tmp2_);
	_tmp8_ = _tmp7_;
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == ZCD_RPC_ERROR) || (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _tmp8_;
	return result;
}


NetsukukuCounterNipRecord* netsukuku_counter_ask_get_hostnames (NetsukukuCounter* self, NetsukukuNIP* nip) {
	NetsukukuCounterNipRecord* result = NULL;
	NetsukukuNIP* _tmp0_;
	NetsukukuRmtCounterPeer* _tmp1_ = NULL;
	NetsukukuRmtCounterPeer* node;
	NetsukukuNIP* _tmp2_;
	NetsukukuCounterNipRecord* _tmp3_ = NULL;
	NetsukukuCounterNipRecord* ret;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (nip != NULL, NULL);
	_tmp0_ = nip;
	_tmp1_ = netsukuku_counter_peer (self, NULL, (GObject*) _tmp0_, NULL);
	node = _tmp1_;
	netsukuku_log_debug ("possible uncaught error: Counter client: calling get_hostnames: in pro" \
"gress...");
	_tmp2_ = nip;
	_tmp3_ = netsukuku_icounter_as_peer_get_hostnames ((NetsukukuICounterAsPeer*) node, _tmp2_, &_inner_error_);
	ret = _tmp3_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (node);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	netsukuku_log_debug ("done.");
	result = ret;
	_g_object_unref0 (node);
	return result;
}


/** Helper methods used as a server
          */
void netsukuku_counter_check_expirations_cache (NetsukukuCounter* self) {
	GeeArrayList* _tmp0_;
	GeeArrayList* todel;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_array_list_new (NETSUKUKU_TYPE_PAIR_PUBLIC_KEY_NIP, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_pair_public_key_nip_equal_func_gee_equal_data_func, NULL, NULL);
	todel = _tmp0_;
	{
		GeeHashMap* _tmp1_;
		GeeSet* _tmp2_;
		GeeSet* _tmp3_;
		GeeSet* _tmp4_;
		GeeIterator* _tmp5_ = NULL;
		GeeIterator* _tmp6_;
		GeeIterator* _k_it;
		_tmp1_ = self->priv->cache;
		_tmp2_ = gee_abstract_map_get_keys ((GeeMap*) _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_;
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
		_k_it = _tmp6_;
		while (TRUE) {
			GeeIterator* _tmp7_;
			gboolean _tmp8_ = FALSE;
			GeeIterator* _tmp9_;
			gpointer _tmp10_ = NULL;
			NetsukukuPairPublicKeyNIP* k;
			GeeHashMap* _tmp11_;
			NetsukukuPairPublicKeyNIP* _tmp12_;
			gpointer _tmp13_ = NULL;
			NetsukukuCounterNipRecord* record;
			NetsukukuCounterNipRecord* _tmp14_;
			NetsukukuTimeCapsule* _tmp15_;
			NetsukukuTimeCapsule* _tmp16_;
			gboolean _tmp17_ = FALSE;
			_tmp7_ = _k_it;
			_tmp8_ = gee_iterator_next (_tmp7_);
			if (!_tmp8_) {
				break;
			}
			_tmp9_ = _k_it;
			_tmp10_ = gee_iterator_get (_tmp9_);
			k = (NetsukukuPairPublicKeyNIP*) _tmp10_;
			_tmp11_ = self->priv->cache;
			_tmp12_ = k;
			_tmp13_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp11_, _tmp12_);
			record = (NetsukukuCounterNipRecord*) _tmp13_;
			_tmp14_ = record;
			_tmp15_ = netsukuku_counter_nip_record_get_expires (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = tasklets_timer_is_expired ((TaskletsTimer*) _tmp16_);
			if (_tmp17_) {
				GeeArrayList* _tmp18_;
				NetsukukuPairPublicKeyNIP* _tmp19_;
				_tmp18_ = todel;
				_tmp19_ = k;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp18_, _tmp19_);
			}
			_g_object_unref0 (record);
			_g_object_unref0 (k);
		}
		_g_object_unref0 (_k_it);
	}
	{
		GeeArrayList* _tmp20_;
		GeeArrayList* _tmp21_;
		GeeArrayList* _k_list;
		GeeArrayList* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		gint _k_size;
		gint _k_index;
		_tmp20_ = todel;
		_tmp21_ = _g_object_ref0 (_tmp20_);
		_k_list = _tmp21_;
		_tmp22_ = _k_list;
		_tmp23_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp22_);
		_tmp24_ = _tmp23_;
		_k_size = _tmp24_;
		_k_index = -1;
		while (TRUE) {
			gint _tmp25_;
			gint _tmp26_;
			gint _tmp27_;
			GeeArrayList* _tmp28_;
			gint _tmp29_;
			gpointer _tmp30_ = NULL;
			NetsukukuPairPublicKeyNIP* k;
			GeeHashMap* _tmp31_;
			NetsukukuPairPublicKeyNIP* _tmp32_;
			_tmp25_ = _k_index;
			_k_index = _tmp25_ + 1;
			_tmp26_ = _k_index;
			_tmp27_ = _k_size;
			if (!(_tmp26_ < _tmp27_)) {
				break;
			}
			_tmp28_ = _k_list;
			_tmp29_ = _k_index;
			_tmp30_ = gee_abstract_list_get ((GeeAbstractList*) _tmp28_, _tmp29_);
			k = (NetsukukuPairPublicKeyNIP*) _tmp30_;
			_tmp31_ = self->priv->cache;
			_tmp32_ = k;
			gee_abstract_map_unset ((GeeAbstractMap*) _tmp31_, _tmp32_, NULL);
			_g_object_unref0 (k);
		}
		_g_object_unref0 (_k_list);
	}
	_g_object_unref0 (todel);
}


static NetsukukuIAddressManagerRootDispatcher* netsukuku_counter_real_contact_registrar (NetsukukuCounter* self, const gchar* registrar_address) {
	NetsukukuIAddressManagerRootDispatcher* result = NULL;
	const gchar* _tmp0_;
	NetsukukuAddressManagerTCPClient* _tmp1_;
	g_return_val_if_fail (registrar_address != NULL, NULL);
	_tmp0_ = registrar_address;
	_tmp1_ = netsukuku_address_manager_tcp_client_new (_tmp0_, NULL, NULL, TRUE);
	result = (NetsukukuIAddressManagerRootDispatcher*) _tmp1_;
	return result;
}


NetsukukuIAddressManagerRootDispatcher* netsukuku_counter_contact_registrar (NetsukukuCounter* self, const gchar* registrar_address) {
	g_return_val_if_fail (self != NULL, NULL);
	return NETSUKUKU_COUNTER_GET_CLASS (self)->contact_registrar (self, registrar_address);
}


/** Remotable methods as peer()
          */
static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		NetsukukuCounter * self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->response_ttl);
		_g_free0 (_data3_->response_msg);
		_g_object_unref0 (_data3_->nip);
		_g_object_unref0 (_data3_->hashed_domains);
		_g_object_unref0 (_data3_->pubkey);
		_g_object_unref0 (_data3_->signature);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}


static gboolean __lambda5_ (Block3Data* _data3_, GError** error) {
	NetsukukuCounter * self;
	gboolean result = FALSE;
	NetsukukuNIP* _tmp0_;
	GeeList* _tmp1_;
	NetsukukuPublicKey* _tmp2_;
	zcdSerializableBuffer* _tmp3_;
	gboolean _tmp4_ = FALSE;
	GeeList* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	NetsukukuMapRoute* _tmp10_;
	gint _tmp11_;
	NetsukukuMapRoute* _tmp12_;
	gint _tmp13_;
	NetsukukuNIP* _tmp14_;
	gchar* _tmp15_ = NULL;
	gchar* dest_addr;
	const gchar* _tmp16_;
	NetsukukuIAddressManagerRootDispatcher* _tmp17_ = NULL;
	NetsukukuIAddressManagerRootDispatcher* client;
	gint32 _tmp18_ = 0;
	gint to_be_signed;
	NetsukukuIAddressManagerRootDispatcher* _tmp19_;
	NetsukukuIAndna* _tmp20_;
	NetsukukuIAndna* _tmp21_;
	NetsukukuNIP* _tmp22_;
	NetsukukuPublicKey* _tmp23_;
	gint _tmp24_;
	NetsukukuAndnaConfirmPubkResponse* _tmp25_ = NULL;
	NetsukukuAndnaConfirmPubkResponse* resp;
	NetsukukuAndnaConfirmPubkResponse* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	NetsukukuPairPublicKeyNIP* to_del;
	NetsukukuPairPublicKeyNIP* _tmp60_;
	NetsukukuTimeCapsule* _tmp63_;
	NetsukukuTimeCapsule* ttl;
	GeeHashMap* _tmp64_;
	NetsukukuPublicKey* _tmp65_;
	NetsukukuNIP* _tmp66_;
	NetsukukuPairPublicKeyNIP* _tmp67_;
	NetsukukuPairPublicKeyNIP* _tmp68_;
	NetsukukuPublicKey* _tmp69_;
	NetsukukuNIP* _tmp70_;
	GeeList* _tmp71_;
	zcdListString* _tmp72_;
	zcdListString* _tmp73_;
	NetsukukuTimeCapsule* _tmp74_;
	NetsukukuCounterNipRecord* _tmp75_;
	NetsukukuCounterNipRecord* _tmp76_;
	gchar* _tmp77_;
	NetsukukuTimeCapsule* _tmp78_;
	NetsukukuTimeCapsule* _tmp79_;
	GError * _inner_error_ = NULL;
	self = _data3_->self;
	_tmp0_ = _data3_->nip;
	_tmp1_ = _data3_->hashed_domains;
	_tmp2_ = _data3_->pubkey;
	_tmp3_ = _data3_->signature;
	_tmp4_ = _netsukuku_counter_verify (self, _tmp0_, _tmp1_, _tmp2_, _tmp3_);
	if (!_tmp4_) {
		GError* _tmp5_;
		_tmp5_ = g_error_new_literal (NETSUKUKU_PEER_REFUSE_SERVICE_ERROR, NETSUKUKU_PEER_REFUSE_SERVICE_ERROR_GENERIC, "Not your signature.");
		_inner_error_ = _tmp5_;
		if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	_tmp6_ = _data3_->hashed_domains;
	_tmp7_ = gee_collection_get_size ((GeeCollection*) _tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_ > NETSUKUKU_MAX_HOSTNAMES) {
		GError* _tmp9_;
		_tmp9_ = g_error_new_literal (NETSUKUKU_PEER_REFUSE_SERVICE_ERROR, NETSUKUKU_PEER_REFUSE_SERVICE_ERROR_GENERIC, "Too many names.");
		_inner_error_ = _tmp9_;
		if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	_tmp10_ = ((NetsukukuPeerToPeer*) self)->maproute;
	_tmp11_ = _tmp10_->levels;
	_tmp12_ = ((NetsukukuPeerToPeer*) self)->maproute;
	_tmp13_ = _tmp12_->gsize;
	_tmp14_ = _data3_->nip;
	_tmp15_ = netsukuku_nip_to_str (_tmp11_, _tmp13_, _tmp14_);
	dest_addr = _tmp15_;
	_tmp16_ = dest_addr;
	_tmp17_ = netsukuku_counter_contact_registrar (self, _tmp16_);
	client = _tmp17_;
	_tmp18_ = g_random_int_range ((gint32) 0, (gint32) 64000);
	to_be_signed = (gint) _tmp18_;
	netsukuku_log_debug ("possible uncaught error: Counter: contacting the registrar: in progres" \
"s...");
	_tmp19_ = client;
	_tmp20_ = netsukuku_iaddress_manager_root_dispatcher_get_andna (_tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = _data3_->nip;
	_tmp23_ = _data3_->pubkey;
	_tmp24_ = to_be_signed;
	_tmp25_ = netsukuku_iandna_confirm_pubk (_tmp21_, _tmp22_, _tmp23_, _tmp24_, &_inner_error_);
	resp = _tmp25_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (client);
			_g_free0 (dest_addr);
			return FALSE;
		} else {
			_g_object_unref0 (client);
			_g_free0 (dest_addr);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	netsukuku_log_debug ("done.");
	_tmp26_ = resp;
	_tmp27_ = netsukuku_andna_confirm_pubk_response_get_response (_tmp26_);
	_tmp28_ = _tmp27_;
	if (g_strcmp0 (_tmp28_, "OK") == 0) {
		NetsukukuPublicKey* _tmp29_;
		NetsukukuPublicKeyWrapper* _tmp30_;
		NetsukukuPublicKeyWrapper* pk;
		NetsukukuPublicKeyWrapper* _tmp31_;
		gint _tmp32_;
		gchar* _tmp33_ = NULL;
		gchar* _tmp34_;
		guint8* _tmp35_;
		gint _tmp35__length1;
		guint8* _tmp36_;
		gint _tmp36__length1;
		NetsukukuAndnaConfirmPubkResponse* _tmp37_;
		zcdSerializableBuffer* _tmp38_;
		zcdSerializableBuffer* _tmp39_;
		guint8* _tmp40_;
		gint _tmp40__length1;
		guint8* _tmp41_;
		gint _tmp41__length1;
		_tmp29_ = _data3_->pubkey;
		_tmp30_ = netsukuku_public_key_wrapper_new_from_pubk (_tmp29_, &_inner_error_);
		pk = _tmp30_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (resp);
				_g_object_unref0 (client);
				_g_free0 (dest_addr);
				return FALSE;
			} else {
				_g_object_unref0 (resp);
				_g_object_unref0 (client);
				_g_free0 (dest_addr);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		_tmp31_ = pk;
		_tmp32_ = to_be_signed;
		_tmp33_ = g_strdup_printf ("%i", _tmp32_);
		_tmp34_ = _tmp33_;
		_tmp35_ = string_get_data (_tmp34_, &_tmp35__length1);
		_tmp36_ = _tmp35_;
		_tmp36__length1 = _tmp35__length1;
		_tmp37_ = resp;
		_tmp38_ = netsukuku_andna_confirm_pubk_response_get_signature (_tmp37_);
		_tmp39_ = _tmp38_;
		_tmp40_ = zcd_serializable_buffer_get_buffer (_tmp39_, &_tmp40__length1);
		_tmp41_ = _tmp40_;
		_tmp41__length1 = _tmp40__length1;
		netsukuku_public_key_wrapper_verify (_tmp31_, (guchar*) _tmp36_, (_tmp36__length1 * sizeof (guint8)) / sizeof (guchar), (guchar*) _tmp41_, (_tmp41__length1 * sizeof (guint8)) / sizeof (guchar), &_inner_error_);
		_g_free0 (_tmp34_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (pk);
				_g_object_unref0 (resp);
				_g_object_unref0 (client);
				_g_free0 (dest_addr);
				return FALSE;
			} else {
				_g_object_unref0 (pk);
				_g_object_unref0 (resp);
				_g_object_unref0 (client);
				_g_free0 (dest_addr);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		_g_object_unref0 (pk);
	} else {
		GError* _tmp42_;
		_tmp42_ = g_error_new_literal (NETSUKUKU_PEER_REFUSE_SERVICE_ERROR, NETSUKUKU_PEER_REFUSE_SERVICE_ERROR_GENERIC, "Not your NIP.");
		_inner_error_ = _tmp42_;
		if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (resp);
			_g_object_unref0 (client);
			_g_free0 (dest_addr);
			return FALSE;
		} else {
			_g_object_unref0 (resp);
			_g_object_unref0 (client);
			_g_free0 (dest_addr);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	to_del = NULL;
	{
		GeeHashMap* _tmp43_;
		GeeSet* _tmp44_;
		GeeSet* _tmp45_;
		GeeSet* _tmp46_;
		GeeIterator* _tmp47_ = NULL;
		GeeIterator* _tmp48_;
		GeeIterator* _pk_nip_it;
		_tmp43_ = self->priv->cache;
		_tmp44_ = gee_abstract_map_get_keys ((GeeMap*) _tmp43_);
		_tmp45_ = _tmp44_;
		_tmp46_ = _tmp45_;
		_tmp47_ = gee_iterable_iterator ((GeeIterable*) _tmp46_);
		_tmp48_ = _tmp47_;
		_g_object_unref0 (_tmp46_);
		_pk_nip_it = _tmp48_;
		while (TRUE) {
			GeeIterator* _tmp49_;
			gboolean _tmp50_ = FALSE;
			GeeIterator* _tmp51_;
			gpointer _tmp52_ = NULL;
			NetsukukuPairPublicKeyNIP* pk_nip;
			NetsukukuPairPublicKeyNIP* _tmp53_;
			NetsukukuPublicKey* _tmp54_;
			NetsukukuPublicKey* _tmp55_;
			NetsukukuPublicKey* _tmp56_;
			gboolean _tmp57_ = FALSE;
			_tmp49_ = _pk_nip_it;
			_tmp50_ = gee_iterator_next (_tmp49_);
			if (!_tmp50_) {
				break;
			}
			_tmp51_ = _pk_nip_it;
			_tmp52_ = gee_iterator_get (_tmp51_);
			pk_nip = (NetsukukuPairPublicKeyNIP*) _tmp52_;
			_tmp53_ = pk_nip;
			_tmp54_ = netsukuku_pair_public_key_nip_get_pk (_tmp53_);
			_tmp55_ = _tmp54_;
			_tmp56_ = _data3_->pubkey;
			_tmp57_ = netsukuku_public_key_equal_func (_tmp55_, _tmp56_);
			if (_tmp57_) {
				NetsukukuPairPublicKeyNIP* _tmp58_;
				NetsukukuPairPublicKeyNIP* _tmp59_;
				_tmp58_ = pk_nip;
				_tmp59_ = _g_object_ref0 (_tmp58_);
				_g_object_unref0 (to_del);
				to_del = _tmp59_;
				_g_object_unref0 (pk_nip);
				break;
			}
			_g_object_unref0 (pk_nip);
		}
		_g_object_unref0 (_pk_nip_it);
	}
	_tmp60_ = to_del;
	if (_tmp60_ != NULL) {
		GeeHashMap* _tmp61_;
		NetsukukuPairPublicKeyNIP* _tmp62_;
		_tmp61_ = self->priv->cache;
		_tmp62_ = to_del;
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp61_, _tmp62_, NULL);
	}
	_tmp63_ = netsukuku_time_capsule_new (NETSUKUKU_MAX_TTL_COUNTER);
	ttl = _tmp63_;
	_tmp64_ = self->priv->cache;
	_tmp65_ = _data3_->pubkey;
	_tmp66_ = _data3_->nip;
	_tmp67_ = netsukuku_pair_public_key_nip_new (_tmp65_, _tmp66_);
	_tmp68_ = _tmp67_;
	_tmp69_ = _data3_->pubkey;
	_tmp70_ = _data3_->nip;
	_tmp71_ = _data3_->hashed_domains;
	_tmp72_ = zcd_list_string_new_with_backer (_tmp71_);
	_tmp73_ = _tmp72_;
	_tmp74_ = ttl;
	_tmp75_ = netsukuku_counter_nip_record_new (_tmp69_, _tmp70_, _tmp73_, _tmp74_);
	_tmp76_ = _tmp75_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp64_, _tmp68_, _tmp76_);
	_g_object_unref0 (_tmp76_);
	_g_object_unref0 (_tmp73_);
	_g_object_unref0 (_tmp68_);
	_tmp77_ = g_strdup ("OK");
	_g_free0 (_data3_->response_msg);
	_data3_->response_msg = _tmp77_;
	_tmp78_ = ttl;
	_tmp79_ = _g_object_ref0 (_tmp78_);
	_g_object_unref0 (_data3_->response_ttl);
	_data3_->response_ttl = _tmp79_;
	result = TRUE;
	_g_object_unref0 (ttl);
	_g_object_unref0 (to_del);
	_g_object_unref0 (resp);
	_g_object_unref0 (client);
	_g_free0 (dest_addr);
	return result;
}


static gboolean ___lambda5__netsukuku_accept_record_callback (gpointer self, GError** error) {
	gboolean result;
	result = __lambda5_ (self, error);
	return result;
}


static void _____lambda7_ (NetsukukuCounter* self, GObject* tpar1, GObject* tpar2, GError** error) {
	GObject* _tmp0_;
	NetsukukuNIP* _tmp1_;
	NetsukukuNIP* tonip;
	GObject* _tmp2_;
	NetsukukuArgumentsForDuplicationSetData* _tmp3_;
	NetsukukuArgumentsForDuplicationSetData* arec;
	GError * _inner_error_ = NULL;
	_tmp0_ = tpar1;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, NETSUKUKU_TYPE_NIP, NetsukukuNIP));
	tonip = _tmp1_;
	_tmp2_ = tpar2;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, NETSUKUKU_TYPE_ARGUMENTS_FOR_DUPLICATION_SET_DATA, NetsukukuArgumentsForDuplicationSetData));
	arec = _tmp3_;
	tasklets_tasklet_declare_self ("Counter.forward_record");
	{
		NetsukukuRmtCounterPeer* _tmp4_ = NULL;
		NetsukukuRmtCounterPeer* _tmp5_;
		NetsukukuNIP* _tmp6_;
		GeeList* _tmp7_;
		NetsukukuPublicKey* _tmp8_;
		zcdSerializableBuffer* _tmp9_;
		NetsukukuCounterSetDataResponse* _tmp10_ = NULL;
		NetsukukuCounterSetDataResponse* _tmp11_;
		_tmp4_ = netsukuku_counter_peer (self, tonip, NULL, NULL);
		_tmp5_ = _tmp4_;
		_tmp6_ = arec->nip;
		_tmp7_ = arec->hashed_domains;
		_tmp8_ = arec->pubkey;
		_tmp9_ = arec->signature;
		_tmp10_ = netsukuku_icounter_as_peer_set_data_for_pubk ((NetsukukuICounterAsPeer*) _tmp5_, _tmp6_, _tmp7_, _tmp8_, _tmp9_, FALSE, &_inner_error_);
		_tmp11_ = _tmp10_;
		_g_object_unref0 (_tmp11_);
		_g_object_unref0 (_tmp5_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch20_zcd_rpc_error;
			}
			goto __finally20;
		}
	}
	goto __finally20;
	__catch20_zcd_rpc_error:
	{
		GError* e = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_;
		GError* _tmp16_;
		GQuark _tmp17_;
		const gchar* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		GError* _tmp20_;
		gint _tmp21_;
		gchar* _tmp22_ = NULL;
		gchar* _tmp23_;
		GError* _tmp24_;
		const gchar* _tmp25_;
		const gchar* _tmp26_ = NULL;
		gchar* _tmp27_ = NULL;
		gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp12_ = netsukuku_partial_nip_to_string ((NetsukukuPartialNIP*) tonip);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_strconcat ("Counter.forward_record: forwarding to ", _tmp13_, ":", NULL);
		_tmp15_ = _tmp14_;
		_tmp16_ = e;
		_tmp17_ = _tmp16_->domain;
		_tmp18_ = g_quark_to_string (_tmp17_);
		_tmp19_ = string_to_string (_tmp18_);
		_tmp20_ = e;
		_tmp21_ = _tmp20_->code;
		_tmp22_ = g_strdup_printf ("%i", _tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = e;
		_tmp25_ = _tmp24_->message;
		_tmp26_ = string_to_string (_tmp25_);
		_tmp27_ = g_strconcat (" got ", _tmp19_, " ", _tmp23_, " ", _tmp26_, NULL);
		_tmp28_ = _tmp27_;
		_tmp29_ = g_strconcat (_tmp15_, _tmp28_, NULL);
		_tmp30_ = _tmp29_;
		netsukuku_log_warn (_tmp30_);
		_g_free0 (_tmp30_);
		_g_free0 (_tmp28_);
		_g_free0 (_tmp23_);
		_g_free0 (_tmp15_);
		_g_free0 (_tmp13_);
		_g_error_free0 (e);
	}
	__finally20:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (arec);
		_g_object_unref0 (tonip);
		return;
	}
	_g_object_unref0 (arec);
	_g_object_unref0 (tonip);
}


static void ______lambda7__tasklets_tasklet_callback (GObject* obj1, GObject* obj2, GObject* obj3, GObject* obj4, gpointer self, GError** error) {
	_____lambda7_ (self, obj1, obj2, error);
}


static void __lambda6_ (NetsukukuCounter* self, GObject* tasklet_obj1, GeeList* tasklet_replica_nodes, GError** error) {
	GObject* _tmp0_;
	NetsukukuArgumentsForDuplicationSetData* _tmp1_;
	NetsukukuArgumentsForDuplicationSetData* tasklet_rec;
	GeeList* _tmp2_;
	_tmp0_ = tasklet_obj1;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, NETSUKUKU_TYPE_ARGUMENTS_FOR_DUPLICATION_SET_DATA, NetsukukuArgumentsForDuplicationSetData));
	tasklet_rec = _tmp1_;
	_tmp2_ = tasklet_replica_nodes;
	if (_tmp2_ == NULL) {
		NetsukukuArgumentsForDuplicationSetData* _tmp3_;
		NetsukukuNIP* _tmp4_;
		GeeList* _tmp5_ = NULL;
		netsukuku_log_debug ("possible uncaught error: Counter: finding replicas for set_data_for_pu" \
"bk: in progress...");
		_tmp3_ = tasklet_rec;
		_tmp4_ = _tmp3_->hashnode;
		_tmp5_ = netsukuku_peer_to_peer_find_nearest_to_register ((NetsukukuPeerToPeer*) self, _tmp4_, NETSUKUKU_COUNTER_DUPLICATION);
		_g_object_unref0 (tasklet_replica_nodes);
		tasklet_replica_nodes = _tmp5_;
		netsukuku_log_debug ("done.");
	}
	{
		GeeList* _tmp6_;
		GeeList* _tmp7_;
		GeeList* _replica_node_list;
		GeeList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _replica_node_size;
		gint _replica_node_index;
		_tmp6_ = tasklet_replica_nodes;
		_tmp7_ = _g_object_ref0 (_tmp6_);
		_replica_node_list = _tmp7_;
		_tmp8_ = _replica_node_list;
		_tmp9_ = gee_collection_get_size ((GeeCollection*) _tmp8_);
		_tmp10_ = _tmp9_;
		_replica_node_size = _tmp10_;
		_replica_node_index = -1;
		while (TRUE) {
			gint _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			GeeList* _tmp14_;
			gint _tmp15_;
			gpointer _tmp16_ = NULL;
			NetsukukuNIP* replica_node;
			NetsukukuNIP* _tmp17_;
			NetsukukuMapRoute* _tmp18_;
			NetsukukuNIP* _tmp19_;
			gboolean _tmp20_ = FALSE;
			_tmp11_ = _replica_node_index;
			_replica_node_index = _tmp11_ + 1;
			_tmp12_ = _replica_node_index;
			_tmp13_ = _replica_node_size;
			if (!(_tmp12_ < _tmp13_)) {
				break;
			}
			_tmp14_ = _replica_node_list;
			_tmp15_ = _replica_node_index;
			_tmp16_ = gee_list_get (_tmp14_, _tmp15_);
			replica_node = (NetsukukuNIP*) _tmp16_;
			_tmp17_ = replica_node;
			_tmp18_ = ((NetsukukuPeerToPeer*) self)->maproute;
			_tmp19_ = _tmp18_->me;
			_tmp20_ = netsukuku_partial_nip_is_equal ((NetsukukuPartialNIP*) _tmp17_, (NetsukukuPartialNIP*) _tmp19_);
			if (!_tmp20_) {
				NetsukukuNIP* _tmp21_;
				NetsukukuArgumentsForDuplicationSetData* _tmp22_;
				TaskletsTasklet* _tmp23_ = NULL;
				TaskletsTasklet* _tmp24_;
				_tmp21_ = replica_node;
				_tmp22_ = tasklet_rec;
				_tmp23_ = tasklets_tasklet_tasklet_callback (______lambda7__tasklets_tasklet_callback, self, (GObject*) _tmp21_, (GObject*) _tmp22_, NULL, NULL);
				_tmp24_ = _tmp23_;
				_g_object_unref0 (_tmp24_);
			}
			_g_object_unref0 (replica_node);
		}
		_g_object_unref0 (_replica_node_list);
	}
	_g_object_unref0 (tasklet_rec);
	_g_object_unref0 (tasklet_replica_nodes);
}


static void ___lambda6__netsukuku_forward_record_callback (GObject* obj1, GeeList* replica_nodes, gpointer self, GError** error) {
	__lambda6_ (self, obj1, replica_nodes, error);
}


static NetsukukuCounterSetDataResponse* netsukuku_counter_real_set_data_for_pubk (NetsukukuICounterAsPeer* base, NetsukukuNIP* nip, GeeList* hashed_domains, NetsukukuPublicKey* pubkey, zcdSerializableBuffer* signature, gboolean replicate, GError** error) {
	NetsukukuCounter * self;
	NetsukukuCounterSetDataResponse* result = NULL;
	Block3Data* _data3_;
	NetsukukuNIP* _tmp0_;
	NetsukukuNIP* _tmp1_;
	GeeList* _tmp2_;
	GeeList* _tmp3_;
	NetsukukuPublicKey* _tmp4_;
	NetsukukuPublicKey* _tmp5_;
	zcdSerializableBuffer* _tmp6_;
	zcdSerializableBuffer* _tmp7_;
	gboolean _tmp8_;
	gchar* _tmp16_;
	NetsukukuTimeCapsule* _tmp17_;
	NetsukukuNIP* _tmp18_;
	NetsukukuNIP* _tmp19_ = NULL;
	NetsukukuNIP* hashnode;
	NetsukukuArgumentsForDuplicationSetData* _tmp20_;
	NetsukukuArgumentsForDuplicationSetData* rec;
	NetsukukuArgumentsForDuplicationSetData* _tmp21_;
	NetsukukuNIP* _tmp22_;
	NetsukukuNIP* _tmp23_;
	NetsukukuArgumentsForDuplicationSetData* _tmp24_;
	GeeList* _tmp25_;
	GeeList* _tmp26_;
	NetsukukuArgumentsForDuplicationSetData* _tmp27_;
	NetsukukuPublicKey* _tmp28_;
	NetsukukuPublicKey* _tmp29_;
	NetsukukuArgumentsForDuplicationSetData* _tmp30_;
	zcdSerializableBuffer* _tmp31_;
	zcdSerializableBuffer* _tmp32_;
	NetsukukuArgumentsForDuplicationSetData* _tmp33_;
	NetsukukuNIP* _tmp34_;
	NetsukukuNIP* _tmp35_;
	NetsukukuNIP* _tmp36_;
	gboolean _tmp37_;
	NetsukukuArgumentsForDuplicationSetData* _tmp38_;
	const gchar* _tmp39_;
	NetsukukuTimeCapsule* _tmp40_;
	NetsukukuCounterSetDataResponse* _tmp41_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuCounter*) base;
	g_return_val_if_fail (nip != NULL, NULL);
	g_return_val_if_fail (hashed_domains != NULL, NULL);
	g_return_val_if_fail (pubkey != NULL, NULL);
	g_return_val_if_fail (signature != NULL, NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = nip;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data3_->nip);
	_data3_->nip = _tmp1_;
	_tmp2_ = hashed_domains;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (_data3_->hashed_domains);
	_data3_->hashed_domains = _tmp3_;
	_tmp4_ = pubkey;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (_data3_->pubkey);
	_data3_->pubkey = _tmp5_;
	_tmp6_ = signature;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	_g_object_unref0 (_data3_->signature);
	_data3_->signature = _tmp7_;
	_tmp8_ = self->memory_initialized;
	if (!_tmp8_) {
		gboolean _tmp9_;
		_tmp9_ = replicate;
		if (_tmp9_) {
			TaskletsTimer* _tmp10_;
			TaskletsTimer* w;
			_tmp10_ = tasklets_timer_new ((gint64) 10000);
			w = _tmp10_;
			while (TRUE) {
				gboolean _tmp11_;
				TaskletsTimer* _tmp12_;
				gboolean _tmp13_ = FALSE;
				_tmp11_ = self->memory_initialized;
				if (!(!_tmp11_)) {
					break;
				}
				_tmp12_ = w;
				_tmp13_ = tasklets_timer_is_expired (_tmp12_);
				if (_tmp13_) {
					GError* _tmp14_;
					_tmp14_ = g_error_new_literal (NETSUKUKU_PEER_REFUSE_SERVICE_ERROR, NETSUKUKU_PEER_REFUSE_SERVICE_ERROR_GENERIC, "Memory not ready yet");
					_inner_error_ = _tmp14_;
					if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_object_unref0 (w);
						block3_data_unref (_data3_);
						_data3_ = NULL;
						return NULL;
					} else {
						_g_object_unref0 (w);
						block3_data_unref (_data3_);
						_data3_ = NULL;
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				tasklets_tasklet_nap ((glong) 0, (glong) 1000);
			}
			_g_object_unref0 (w);
		} else {
			while (TRUE) {
				gboolean _tmp15_;
				_tmp15_ = self->memory_initialized;
				if (!(!_tmp15_)) {
					break;
				}
				tasklets_tasklet_nap ((glong) 0, (glong) 1000);
			}
		}
	}
	_tmp16_ = g_strdup ("Noooo");
	_data3_->response_msg = _tmp16_;
	_tmp17_ = netsukuku_time_capsule_new ((gint64) 0);
	_data3_->response_ttl = _tmp17_;
	netsukuku_counter_check_expirations_cache (self);
	_tmp18_ = _data3_->nip;
	_tmp19_ = netsukuku_peer_to_peer_h ((NetsukukuPeerToPeer*) self, (GObject*) _tmp18_);
	hashnode = _tmp19_;
	_tmp20_ = netsukuku_arguments_for_duplication_set_data_new ();
	rec = _tmp20_;
	_tmp21_ = rec;
	_tmp22_ = _data3_->nip;
	_tmp23_ = _g_object_ref0 (_tmp22_);
	_g_object_unref0 (_tmp21_->nip);
	_tmp21_->nip = _tmp23_;
	_tmp24_ = rec;
	_tmp25_ = _data3_->hashed_domains;
	_tmp26_ = _g_object_ref0 (_tmp25_);
	_g_object_unref0 (_tmp24_->hashed_domains);
	_tmp24_->hashed_domains = _tmp26_;
	_tmp27_ = rec;
	_tmp28_ = _data3_->pubkey;
	_tmp29_ = _g_object_ref0 (_tmp28_);
	_g_object_unref0 (_tmp27_->pubkey);
	_tmp27_->pubkey = _tmp29_;
	_tmp30_ = rec;
	_tmp31_ = _data3_->signature;
	_tmp32_ = _g_object_ref0 (_tmp31_);
	_g_object_unref0 (_tmp30_->signature);
	_tmp30_->signature = _tmp32_;
	_tmp33_ = rec;
	_tmp34_ = hashnode;
	_tmp35_ = _g_object_ref0 (_tmp34_);
	_g_object_unref0 (_tmp33_->hashnode);
	_tmp33_->hashnode = _tmp35_;
	_tmp36_ = hashnode;
	_tmp37_ = replicate;
	_tmp38_ = rec;
	netsukuku_check_hash_and_start_replica ((NetsukukuPeerToPeer*) self, _tmp36_, _tmp37_, (GObject*) _tmp38_, NETSUKUKU_COUNTER_DUPLICATION, ___lambda5__netsukuku_accept_record_callback, _data3_, ___lambda6__netsukuku_forward_record_callback, self, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (rec);
			_g_object_unref0 (hashnode);
			block3_data_unref (_data3_);
			_data3_ = NULL;
			return NULL;
		} else {
			_g_object_unref0 (rec);
			_g_object_unref0 (hashnode);
			block3_data_unref (_data3_);
			_data3_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp39_ = _data3_->response_msg;
	_tmp40_ = _data3_->response_ttl;
	_tmp41_ = netsukuku_counter_set_data_response_new (_tmp39_, _tmp40_);
	result = _tmp41_;
	_g_object_unref0 (rec);
	_g_object_unref0 (hashnode);
	block3_data_unref (_data3_);
	_data3_ = NULL;
	return result;
}


static NetsukukuCounterCheckHostnameResponse* netsukuku_counter_real_check_hostname (NetsukukuICounterAsPeer* base, NetsukukuNIP* nip, const gchar* hashed_domain, NetsukukuPublicKey* pubkey, GError** error) {
	NetsukukuCounter * self;
	NetsukukuCounterCheckHostnameResponse* result = NULL;
	gboolean _tmp0_;
	NetsukukuNIP* _tmp6_;
	NetsukukuNIP* _tmp7_ = NULL;
	NetsukukuNIP* hashnode;
	NetsukukuNIP* _tmp8_;
	NetsukukuHCoord* _tmp9_ = NULL;
	NetsukukuHCoord* _tmp10_;
	NetsukukuHCoord* _tmp11_;
	gboolean _tmp12_;
	gboolean response;
	NetsukukuTimeCapsule* _tmp14_;
	NetsukukuTimeCapsule* ttl;
	NetsukukuPairPublicKeyNIP* found;
	NetsukukuPairPublicKeyNIP* _tmp32_;
	gboolean _tmp40_;
	NetsukukuTimeCapsule* _tmp41_;
	NetsukukuCounterCheckHostnameResponse* _tmp42_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuCounter*) base;
	g_return_val_if_fail (nip != NULL, NULL);
	g_return_val_if_fail (hashed_domain != NULL, NULL);
	g_return_val_if_fail (pubkey != NULL, NULL);
	_tmp0_ = self->memory_initialized;
	if (!_tmp0_) {
		TaskletsTimer* _tmp1_;
		TaskletsTimer* w;
		_tmp1_ = tasklets_timer_new ((gint64) 10000);
		w = _tmp1_;
		while (TRUE) {
			gboolean _tmp2_;
			TaskletsTimer* _tmp3_;
			gboolean _tmp4_ = FALSE;
			_tmp2_ = self->memory_initialized;
			if (!(!_tmp2_)) {
				break;
			}
			_tmp3_ = w;
			_tmp4_ = tasklets_timer_is_expired (_tmp3_);
			if (_tmp4_) {
				GError* _tmp5_;
				_tmp5_ = g_error_new_literal (NETSUKUKU_PEER_REFUSE_SERVICE_ERROR, NETSUKUKU_PEER_REFUSE_SERVICE_ERROR_GENERIC, "Memory not ready yet");
				_inner_error_ = _tmp5_;
				if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (w);
					return NULL;
				} else {
					_g_object_unref0 (w);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			tasklets_tasklet_nap ((glong) 0, (glong) 1000);
		}
		_g_object_unref0 (w);
	}
	netsukuku_counter_check_expirations_cache (self);
	_tmp6_ = nip;
	_tmp7_ = netsukuku_peer_to_peer_h ((NetsukukuPeerToPeer*) self, (GObject*) _tmp6_);
	hashnode = _tmp7_;
	_tmp8_ = hashnode;
	_tmp9_ = netsukuku_peer_to_peer_search_participant ((NetsukukuPeerToPeer*) self, _tmp8_, 1, &_inner_error_);
	_tmp10_ = _tmp9_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (hashnode);
			return NULL;
		} else {
			_g_object_unref0 (hashnode);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp11_ = _tmp10_;
	_tmp12_ = _tmp11_ != NULL;
	_g_object_unref0 (_tmp11_);
	if (_tmp12_) {
		GError* _tmp13_;
		_tmp13_ = g_error_new_literal (NETSUKUKU_PEER_REFUSE_SERVICE_ERROR, NETSUKUKU_PEER_REFUSE_SERVICE_ERROR_GENERIC, "Not the correct hashnode");
		_inner_error_ = _tmp13_;
		if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (hashnode);
			return NULL;
		} else {
			_g_object_unref0 (hashnode);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	response = FALSE;
	_tmp14_ = netsukuku_time_capsule_new ((gint64) 0);
	ttl = _tmp14_;
	found = NULL;
	{
		GeeHashMap* _tmp15_;
		GeeSet* _tmp16_;
		GeeSet* _tmp17_;
		GeeSet* _tmp18_;
		GeeIterator* _tmp19_ = NULL;
		GeeIterator* _tmp20_;
		GeeIterator* _pk_nip_it;
		_tmp15_ = self->priv->cache;
		_tmp16_ = gee_abstract_map_get_keys ((GeeMap*) _tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = _tmp17_;
		_tmp19_ = gee_iterable_iterator ((GeeIterable*) _tmp18_);
		_tmp20_ = _tmp19_;
		_g_object_unref0 (_tmp18_);
		_pk_nip_it = _tmp20_;
		while (TRUE) {
			GeeIterator* _tmp21_;
			gboolean _tmp22_ = FALSE;
			GeeIterator* _tmp23_;
			gpointer _tmp24_ = NULL;
			NetsukukuPairPublicKeyNIP* pk_nip;
			NetsukukuPairPublicKeyNIP* _tmp25_;
			NetsukukuNIP* _tmp26_;
			NetsukukuNIP* _tmp27_;
			NetsukukuNIP* _tmp28_;
			gboolean _tmp29_ = FALSE;
			_tmp21_ = _pk_nip_it;
			_tmp22_ = gee_iterator_next (_tmp21_);
			if (!_tmp22_) {
				break;
			}
			_tmp23_ = _pk_nip_it;
			_tmp24_ = gee_iterator_get (_tmp23_);
			pk_nip = (NetsukukuPairPublicKeyNIP*) _tmp24_;
			_tmp25_ = pk_nip;
			_tmp26_ = netsukuku_pair_public_key_nip_get_nip (_tmp25_);
			_tmp27_ = _tmp26_;
			_tmp28_ = nip;
			_tmp29_ = netsukuku_partial_nip_equal_func ((NetsukukuPartialNIP*) _tmp27_, (NetsukukuPartialNIP*) _tmp28_);
			if (_tmp29_) {
				NetsukukuPairPublicKeyNIP* _tmp30_;
				NetsukukuPairPublicKeyNIP* _tmp31_;
				_tmp30_ = pk_nip;
				_tmp31_ = _g_object_ref0 (_tmp30_);
				_g_object_unref0 (found);
				found = _tmp31_;
				_g_object_unref0 (pk_nip);
				break;
			}
			_g_object_unref0 (pk_nip);
		}
		_g_object_unref0 (_pk_nip_it);
	}
	_tmp32_ = found;
	if (_tmp32_ != NULL) {
		GeeHashMap* _tmp33_;
		NetsukukuPairPublicKeyNIP* _tmp34_;
		gpointer _tmp35_ = NULL;
		NetsukukuCounterNipRecord* _tmp36_;
		NetsukukuTimeCapsule* _tmp37_;
		NetsukukuTimeCapsule* _tmp38_;
		NetsukukuTimeCapsule* _tmp39_;
		response = TRUE;
		_tmp33_ = self->priv->cache;
		_tmp34_ = found;
		_tmp35_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp33_, _tmp34_);
		_tmp36_ = (NetsukukuCounterNipRecord*) _tmp35_;
		_tmp37_ = netsukuku_counter_nip_record_get_expires (_tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = _g_object_ref0 (_tmp38_);
		_g_object_unref0 (ttl);
		ttl = _tmp39_;
		_g_object_unref0 (_tmp36_);
	}
	_tmp40_ = response;
	_tmp41_ = ttl;
	_tmp42_ = netsukuku_counter_check_hostname_response_new (_tmp40_, _tmp41_);
	result = _tmp42_;
	_g_object_unref0 (found);
	_g_object_unref0 (ttl);
	_g_object_unref0 (hashnode);
	return result;
}


static NetsukukuCounterNipRecord* netsukuku_counter_real_get_hostnames (NetsukukuICounterAsPeer* base, NetsukukuNIP* nip, GError** error) {
	NetsukukuCounter * self;
	NetsukukuCounterNipRecord* result = NULL;
	gboolean _tmp0_;
	NetsukukuNIP* _tmp6_;
	NetsukukuNIP* _tmp7_ = NULL;
	NetsukukuNIP* hashnode;
	NetsukukuNIP* _tmp8_;
	NetsukukuHCoord* _tmp9_ = NULL;
	NetsukukuHCoord* _tmp10_;
	NetsukukuHCoord* _tmp11_;
	gboolean _tmp12_;
	NetsukukuPairPublicKeyNIP* found;
	NetsukukuPairPublicKeyNIP* _tmp31_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuCounter*) base;
	g_return_val_if_fail (nip != NULL, NULL);
	_tmp0_ = self->memory_initialized;
	if (!_tmp0_) {
		TaskletsTimer* _tmp1_;
		TaskletsTimer* w;
		_tmp1_ = tasklets_timer_new ((gint64) 10000);
		w = _tmp1_;
		while (TRUE) {
			gboolean _tmp2_;
			TaskletsTimer* _tmp3_;
			gboolean _tmp4_ = FALSE;
			_tmp2_ = self->memory_initialized;
			if (!(!_tmp2_)) {
				break;
			}
			_tmp3_ = w;
			_tmp4_ = tasklets_timer_is_expired (_tmp3_);
			if (_tmp4_) {
				GError* _tmp5_;
				_tmp5_ = g_error_new_literal (NETSUKUKU_PEER_REFUSE_SERVICE_ERROR, NETSUKUKU_PEER_REFUSE_SERVICE_ERROR_GENERIC, "Memory not ready yet");
				_inner_error_ = _tmp5_;
				if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (w);
					return NULL;
				} else {
					_g_object_unref0 (w);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			tasklets_tasklet_nap ((glong) 0, (glong) 1000);
		}
		_g_object_unref0 (w);
	}
	netsukuku_counter_check_expirations_cache (self);
	_tmp6_ = nip;
	_tmp7_ = netsukuku_peer_to_peer_h ((NetsukukuPeerToPeer*) self, (GObject*) _tmp6_);
	hashnode = _tmp7_;
	_tmp8_ = hashnode;
	_tmp9_ = netsukuku_peer_to_peer_search_participant ((NetsukukuPeerToPeer*) self, _tmp8_, 1, &_inner_error_);
	_tmp10_ = _tmp9_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (hashnode);
			return NULL;
		} else {
			_g_object_unref0 (hashnode);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp11_ = _tmp10_;
	_tmp12_ = _tmp11_ != NULL;
	_g_object_unref0 (_tmp11_);
	if (_tmp12_) {
		GError* _tmp13_;
		_tmp13_ = g_error_new_literal (NETSUKUKU_PEER_REFUSE_SERVICE_ERROR, NETSUKUKU_PEER_REFUSE_SERVICE_ERROR_GENERIC, "Not the correct hashnode");
		_inner_error_ = _tmp13_;
		if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (hashnode);
			return NULL;
		} else {
			_g_object_unref0 (hashnode);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	found = NULL;
	{
		GeeHashMap* _tmp14_;
		GeeSet* _tmp15_;
		GeeSet* _tmp16_;
		GeeSet* _tmp17_;
		GeeIterator* _tmp18_ = NULL;
		GeeIterator* _tmp19_;
		GeeIterator* _pk_nip_it;
		_tmp14_ = self->priv->cache;
		_tmp15_ = gee_abstract_map_get_keys ((GeeMap*) _tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = _tmp16_;
		_tmp18_ = gee_iterable_iterator ((GeeIterable*) _tmp17_);
		_tmp19_ = _tmp18_;
		_g_object_unref0 (_tmp17_);
		_pk_nip_it = _tmp19_;
		while (TRUE) {
			GeeIterator* _tmp20_;
			gboolean _tmp21_ = FALSE;
			GeeIterator* _tmp22_;
			gpointer _tmp23_ = NULL;
			NetsukukuPairPublicKeyNIP* pk_nip;
			NetsukukuPairPublicKeyNIP* _tmp24_;
			NetsukukuNIP* _tmp25_;
			NetsukukuNIP* _tmp26_;
			NetsukukuNIP* _tmp27_;
			gboolean _tmp28_ = FALSE;
			_tmp20_ = _pk_nip_it;
			_tmp21_ = gee_iterator_next (_tmp20_);
			if (!_tmp21_) {
				break;
			}
			_tmp22_ = _pk_nip_it;
			_tmp23_ = gee_iterator_get (_tmp22_);
			pk_nip = (NetsukukuPairPublicKeyNIP*) _tmp23_;
			_tmp24_ = pk_nip;
			_tmp25_ = netsukuku_pair_public_key_nip_get_nip (_tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = nip;
			_tmp28_ = netsukuku_partial_nip_equal_func ((NetsukukuPartialNIP*) _tmp26_, (NetsukukuPartialNIP*) _tmp27_);
			if (_tmp28_) {
				NetsukukuPairPublicKeyNIP* _tmp29_;
				NetsukukuPairPublicKeyNIP* _tmp30_;
				_tmp29_ = pk_nip;
				_tmp30_ = _g_object_ref0 (_tmp29_);
				_g_object_unref0 (found);
				found = _tmp30_;
				_g_object_unref0 (pk_nip);
				break;
			}
			_g_object_unref0 (pk_nip);
		}
		_g_object_unref0 (_pk_nip_it);
	}
	_tmp31_ = found;
	if (_tmp31_ != NULL) {
		GeeHashMap* _tmp32_;
		NetsukukuPairPublicKeyNIP* _tmp33_;
		gpointer _tmp34_ = NULL;
		_tmp32_ = self->priv->cache;
		_tmp33_ = found;
		_tmp34_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp32_, _tmp33_);
		result = (NetsukukuCounterNipRecord*) _tmp34_;
		_g_object_unref0 (found);
		_g_object_unref0 (hashnode);
		return result;
	}
	result = NULL;
	_g_object_unref0 (found);
	_g_object_unref0 (hashnode);
	return result;
}


static NetsukukuCounterGetCacheRecordsResponse* netsukuku_counter_real_get_cache_records (NetsukukuICounterAsPeer* base, GError** error) {
	NetsukukuCounter * self;
	NetsukukuCounterGetCacheRecordsResponse* result = NULL;
	gboolean _tmp0_;
	GeeHashMap* _tmp6_;
	NetsukukuCounterGetCacheRecordsResponse* _tmp7_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuCounter*) base;
	_tmp0_ = self->memory_initialized;
	if (!_tmp0_) {
		TaskletsTimer* _tmp1_;
		TaskletsTimer* w;
		_tmp1_ = tasklets_timer_new ((gint64) 10000);
		w = _tmp1_;
		while (TRUE) {
			gboolean _tmp2_;
			TaskletsTimer* _tmp3_;
			gboolean _tmp4_ = FALSE;
			_tmp2_ = self->memory_initialized;
			if (!(!_tmp2_)) {
				break;
			}
			_tmp3_ = w;
			_tmp4_ = tasklets_timer_is_expired (_tmp3_);
			if (_tmp4_) {
				GError* _tmp5_;
				_tmp5_ = g_error_new_literal (NETSUKUKU_PEER_REFUSE_SERVICE_ERROR, NETSUKUKU_PEER_REFUSE_SERVICE_ERROR_GENERIC, "Memory not ready yet");
				_inner_error_ = _tmp5_;
				if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (w);
					return NULL;
				} else {
					_g_object_unref0 (w);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			tasklets_tasklet_nap ((glong) 0, (glong) 1000);
		}
		_g_object_unref0 (w);
	}
	_tmp6_ = self->priv->cache;
	_tmp7_ = netsukuku_counter_get_cache_records_response_new (_tmp6_);
	result = _tmp7_;
	return result;
}


static GeeArrayList* netsukuku_counter_get_hashednames (NetsukukuCounter* self) {
	GeeArrayList* result;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp18_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_hashednames;
	if (_tmp0_ == NULL) {
		GeeArrayList* _tmp1_;
		gchar buffer[256] = {0};
		gchar* myhostname;
		gint _tmp2_ = 0;
		const gchar* _tmp13_;
		_tmp1_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
		_g_object_unref0 (self->priv->_hashednames);
		self->priv->_hashednames = _tmp1_;
		myhostname = NULL;
		_tmp2_ = gethostname (buffer, 256);
		if (_tmp2_ == 0) {
			GString* _tmp3_;
			GString* sb;
			gint pos;
			GString* _tmp9_;
			GString* _tmp10_;
			const gchar* _tmp11_;
			gchar* _tmp12_;
			_tmp3_ = g_string_new ("");
			sb = _tmp3_;
			pos = 0;
			while (TRUE) {
				gint _tmp4_;
				gchar _tmp5_;
				GString* _tmp6_;
				gint _tmp7_;
				gchar _tmp8_;
				_tmp4_ = pos;
				_tmp5_ = buffer[_tmp4_];
				if (!(_tmp5_ != '\0')) {
					break;
				}
				_tmp6_ = sb;
				_tmp7_ = pos;
				pos = _tmp7_ + 1;
				_tmp8_ = buffer[_tmp7_];
				g_string_append_c (_tmp6_, _tmp8_);
			}
			_tmp9_ = sb;
			g_string_append_c (_tmp9_, '\0');
			_tmp10_ = sb;
			_tmp11_ = _tmp10_->str;
			_tmp12_ = g_strdup (_tmp11_);
			_g_free0 (myhostname);
			myhostname = _tmp12_;
			_g_string_free0 (sb);
		}
		_tmp13_ = myhostname;
		if (_tmp13_ != NULL) {
			GeeArrayList* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_ = NULL;
			gchar* _tmp17_;
			_tmp14_ = self->priv->_hashednames;
			_tmp15_ = myhostname;
			_tmp16_ = netsukuku_andna_crypto_hash (_tmp15_);
			_tmp17_ = _tmp16_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp14_, _tmp17_);
			_g_free0 (_tmp17_);
		}
		_g_free0 (myhostname);
	}
	_tmp18_ = self->priv->_hashednames;
	result = _tmp18_;
	return result;
}


static NetsukukuAndna* netsukuku_counter_get_andna (NetsukukuCounter* self) {
	NetsukukuAndna* result;
	NetsukukuAndna* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_andna;
	result = _tmp0_;
	return result;
}


void netsukuku_counter_set_andna (NetsukukuCounter* self, NetsukukuAndna* value) {
	NetsukukuAndna* _tmp0_;
	NetsukukuAndna* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_andna);
	self->priv->_andna = _tmp1_;
	g_object_notify ((GObject *) self, "andna");
}


static void netsukuku_counter_class_init (NetsukukuCounterClass * klass) {
	netsukuku_counter_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (NetsukukuCounterPrivate));
	NETSUKUKU_PEER_TO_PEER_CLASS (klass)->_dispatch = netsukuku_counter_real__dispatch;
	NETSUKUKU_PEER_TO_PEER_CLASS (klass)->h = netsukuku_counter_real_h;
	NETSUKUKU_COUNTER_CLASS (klass)->contact_registrar = netsukuku_counter_real_contact_registrar;
	G_OBJECT_CLASS (klass)->get_property = _vala_netsukuku_counter_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_netsukuku_counter_set_property;
	G_OBJECT_CLASS (klass)->finalize = netsukuku_counter_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETSUKUKU_COUNTER_ANDNA, g_param_spec_object ("andna", "andna", "andna", NETSUKUKU_TYPE_ANDNA, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
	g_signal_new ("counter_ready", NETSUKUKU_TYPE_COUNTER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("counter_registered", NETSUKUKU_TYPE_COUNTER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void netsukuku_counter_netsukuku_icounter_as_peer_interface_init (NetsukukuICounterAsPeerIface * iface) {
	netsukuku_counter_netsukuku_icounter_as_peer_parent_iface = g_type_interface_peek_parent (iface);
	iface->set_data_for_pubk = (NetsukukuCounterSetDataResponse* (*)(NetsukukuICounterAsPeer*, NetsukukuNIP*, GeeList*, NetsukukuPublicKey*, zcdSerializableBuffer*, gboolean, GError**)) netsukuku_counter_real_set_data_for_pubk;
	iface->check_hostname = (NetsukukuCounterCheckHostnameResponse* (*)(NetsukukuICounterAsPeer*, NetsukukuNIP*, const gchar*, NetsukukuPublicKey*, GError**)) netsukuku_counter_real_check_hostname;
	iface->get_hostnames = (NetsukukuCounterNipRecord* (*)(NetsukukuICounterAsPeer*, NetsukukuNIP*, GError**)) netsukuku_counter_real_get_hostnames;
	iface->get_cache_records = (NetsukukuCounterGetCacheRecordsResponse* (*)(NetsukukuICounterAsPeer*, GError**)) netsukuku_counter_real_get_cache_records;
}


static void netsukuku_counter_instance_init (NetsukukuCounter * self) {
	self->priv = NETSUKUKU_COUNTER_GET_PRIVATE (self);
}


static void netsukuku_counter_finalize (GObject* obj) {
	NetsukukuCounter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_COUNTER, NetsukukuCounter);
	_g_object_unref0 (self->priv->_hashednames);
	_g_object_unref0 (self->priv->peer_to_peer_all);
	_g_object_unref0 (self->priv->reset_my_counter_node_tasklet);
	_g_object_unref0 (self->priv->_andna);
	_g_object_unref0 (self->priv->my_keys);
	_g_object_unref0 (self->priv->pubk);
	_g_object_unref0 (self->priv->cache);
	G_OBJECT_CLASS (netsukuku_counter_parent_class)->finalize (obj);
}


GType netsukuku_counter_get_type (void) {
	static volatile gsize netsukuku_counter_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_counter_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuCounterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_counter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuCounter), 0, (GInstanceInitFunc) netsukuku_counter_instance_init, NULL };
		static const GInterfaceInfo netsukuku_icounter_as_peer_info = { (GInterfaceInitFunc) netsukuku_counter_netsukuku_icounter_as_peer_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType netsukuku_counter_type_id;
		netsukuku_counter_type_id = g_type_register_static (NETSUKUKU_TYPE_PEER_TO_PEER, "NetsukukuCounter", &g_define_type_info, 0);
		g_type_add_interface_static (netsukuku_counter_type_id, NETSUKUKU_TYPE_ICOUNTER_AS_PEER, &netsukuku_icounter_as_peer_info);
		g_once_init_leave (&netsukuku_counter_type_id__volatile, netsukuku_counter_type_id);
	}
	return netsukuku_counter_type_id__volatile;
}


static void _vala_netsukuku_counter_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	NetsukukuCounter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETSUKUKU_TYPE_COUNTER, NetsukukuCounter);
	switch (property_id) {
		case NETSUKUKU_COUNTER_ANDNA:
		g_value_set_object (value, netsukuku_counter_get_andna (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_netsukuku_counter_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	NetsukukuCounter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETSUKUKU_TYPE_COUNTER, NetsukukuCounter);
	switch (property_id) {
		case NETSUKUKU_COUNTER_ANDNA:
		netsukuku_counter_set_andna (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



