/* andna_counter_tester.c generated by valac 0.20.1, the Vala compiler
 * generated from andna_counter_tester.vala, do not modify */

/*
 *  This file is part of Netsukuku.
 *  (c) Copyright 2011-2014 Luca Dionisi aka lukisi <luca.dionisi@gmail.com>
 *
 *  Netsukuku is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Netsukuku is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Netsukuku.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <tasklet.h>
#include <zcd.h>
#include <netsukuku-rpc.h>
#include <gee.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define NETSUKUKU_TYPE_RMT_PEER (netsukuku_rmt_peer_get_type ())
#define NETSUKUKU_RMT_PEER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_RMT_PEER, NetsukukuRmtPeer))
#define NETSUKUKU_RMT_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_RMT_PEER, NetsukukuRmtPeerClass))
#define NETSUKUKU_IS_RMT_PEER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_RMT_PEER))
#define NETSUKUKU_IS_RMT_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_RMT_PEER))
#define NETSUKUKU_RMT_PEER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_RMT_PEER, NetsukukuRmtPeerClass))

typedef struct _NetsukukuRmtPeer NetsukukuRmtPeer;
typedef struct _NetsukukuRmtPeerClass NetsukukuRmtPeerClass;
typedef struct _NetsukukuRmtPeerPrivate NetsukukuRmtPeerPrivate;

#define NETSUKUKU_TYPE_PEER_TO_PEER (netsukuku_peer_to_peer_get_type ())
#define NETSUKUKU_PEER_TO_PEER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_PEER_TO_PEER, NetsukukuPeerToPeer))
#define NETSUKUKU_PEER_TO_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_PEER_TO_PEER, NetsukukuPeerToPeerClass))
#define NETSUKUKU_IS_PEER_TO_PEER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_PEER_TO_PEER))
#define NETSUKUKU_IS_PEER_TO_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_PEER_TO_PEER))
#define NETSUKUKU_PEER_TO_PEER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_PEER_TO_PEER, NetsukukuPeerToPeerClass))

typedef struct _NetsukukuPeerToPeer NetsukukuPeerToPeer;
typedef struct _NetsukukuPeerToPeerClass NetsukukuPeerToPeerClass;

#define NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR (netsukuku_aggregated_neighbour_get_type ())
#define NETSUKUKU_AGGREGATED_NEIGHBOUR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR, NetsukukuAggregatedNeighbour))
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR, NetsukukuAggregatedNeighbourClass))
#define NETSUKUKU_IS_AGGREGATED_NEIGHBOUR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR))
#define NETSUKUKU_IS_AGGREGATED_NEIGHBOUR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR))
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR, NetsukukuAggregatedNeighbourClass))

typedef struct _NetsukukuAggregatedNeighbour NetsukukuAggregatedNeighbour;
typedef struct _NetsukukuAggregatedNeighbourClass NetsukukuAggregatedNeighbourClass;
typedef struct _NetsukukuPeerToPeerPrivate NetsukukuPeerToPeerPrivate;

#define NETSUKUKU_TYPE_MAP_ROUTE (netsukuku_map_route_get_type ())
#define NETSUKUKU_MAP_ROUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_MAP_ROUTE, NetsukukuMapRoute))
#define NETSUKUKU_MAP_ROUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_MAP_ROUTE, NetsukukuMapRouteClass))
#define NETSUKUKU_IS_MAP_ROUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_MAP_ROUTE))
#define NETSUKUKU_IS_MAP_ROUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_MAP_ROUTE))
#define NETSUKUKU_MAP_ROUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_MAP_ROUTE, NetsukukuMapRouteClass))

typedef struct _NetsukukuMapRoute NetsukukuMapRoute;
typedef struct _NetsukukuMapRouteClass NetsukukuMapRouteClass;

#define NTK_TEST_TYPE_ANDNA_COUNTER (ntk_test_andna_counter_get_type ())
#define NTK_TEST_ANDNA_COUNTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NTK_TEST_TYPE_ANDNA_COUNTER, NtkTestAndnaCounter))
#define NTK_TEST_ANDNA_COUNTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NTK_TEST_TYPE_ANDNA_COUNTER, NtkTestAndnaCounterClass))
#define NTK_TEST_IS_ANDNA_COUNTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NTK_TEST_TYPE_ANDNA_COUNTER))
#define NTK_TEST_IS_ANDNA_COUNTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NTK_TEST_TYPE_ANDNA_COUNTER))
#define NTK_TEST_ANDNA_COUNTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NTK_TEST_TYPE_ANDNA_COUNTER, NtkTestAndnaCounterClass))

typedef struct _NtkTestAndnaCounter NtkTestAndnaCounter;
typedef struct _NtkTestAndnaCounterClass NtkTestAndnaCounterClass;
typedef struct _NetsukukuMapRoutePrivate NetsukukuMapRoutePrivate;

#define NETSUKUKU_TYPE_ANDNA (netsukuku_andna_get_type ())
#define NETSUKUKU_ANDNA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_ANDNA, NetsukukuAndna))
#define NETSUKUKU_ANDNA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_ANDNA, NetsukukuAndnaClass))
#define NETSUKUKU_IS_ANDNA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_ANDNA))
#define NETSUKUKU_IS_ANDNA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_ANDNA))
#define NETSUKUKU_ANDNA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_ANDNA, NetsukukuAndnaClass))

typedef struct _NetsukukuAndna NetsukukuAndna;
typedef struct _NetsukukuAndnaClass NetsukukuAndnaClass;
typedef struct _NtkTestAndnaCounterPrivate NtkTestAndnaCounterPrivate;

#define NETSUKUKU_TYPE_COUNTER (netsukuku_counter_get_type ())
#define NETSUKUKU_COUNTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_COUNTER, NetsukukuCounter))
#define NETSUKUKU_COUNTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_COUNTER, NetsukukuCounterClass))
#define NETSUKUKU_IS_COUNTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_COUNTER))
#define NETSUKUKU_IS_COUNTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_COUNTER))
#define NETSUKUKU_COUNTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_COUNTER, NetsukukuCounterClass))

typedef struct _NetsukukuCounter NetsukukuCounter;
typedef struct _NetsukukuCounterClass NetsukukuCounterClass;

#define NETSUKUKU_TYPE_PEER_TO_PEER_ALL (netsukuku_peer_to_peer_all_get_type ())
#define NETSUKUKU_PEER_TO_PEER_ALL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_PEER_TO_PEER_ALL, NetsukukuPeerToPeerAll))
#define NETSUKUKU_PEER_TO_PEER_ALL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_PEER_TO_PEER_ALL, NetsukukuPeerToPeerAllClass))
#define NETSUKUKU_IS_PEER_TO_PEER_ALL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_PEER_TO_PEER_ALL))
#define NETSUKUKU_IS_PEER_TO_PEER_ALL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_PEER_TO_PEER_ALL))
#define NETSUKUKU_PEER_TO_PEER_ALL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_PEER_TO_PEER_ALL, NetsukukuPeerToPeerAllClass))

typedef struct _NetsukukuPeerToPeerAll NetsukukuPeerToPeerAll;
typedef struct _NetsukukuPeerToPeerAllClass NetsukukuPeerToPeerAllClass;
typedef struct _NetsukukuPeerToPeerAllPrivate NetsukukuPeerToPeerAllPrivate;

#define NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER (netsukuku_aggregated_neighbour_manager_get_type ())
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, NetsukukuAggregatedNeighbourManager))
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, NetsukukuAggregatedNeighbourManagerClass))
#define NETSUKUKU_IS_AGGREGATED_NEIGHBOUR_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER))
#define NETSUKUKU_IS_AGGREGATED_NEIGHBOUR_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER))
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, NetsukukuAggregatedNeighbourManagerClass))

typedef struct _NetsukukuAggregatedNeighbourManager NetsukukuAggregatedNeighbourManager;
typedef struct _NetsukukuAggregatedNeighbourManagerClass NetsukukuAggregatedNeighbourManagerClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define NETSUKUKU_TYPE_OPTIONAL_PEER_TO_PEER (netsukuku_optional_peer_to_peer_get_type ())
#define NETSUKUKU_OPTIONAL_PEER_TO_PEER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_OPTIONAL_PEER_TO_PEER, NetsukukuOptionalPeerToPeer))
#define NETSUKUKU_OPTIONAL_PEER_TO_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_OPTIONAL_PEER_TO_PEER, NetsukukuOptionalPeerToPeerClass))
#define NETSUKUKU_IS_OPTIONAL_PEER_TO_PEER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_OPTIONAL_PEER_TO_PEER))
#define NETSUKUKU_IS_OPTIONAL_PEER_TO_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_OPTIONAL_PEER_TO_PEER))
#define NETSUKUKU_OPTIONAL_PEER_TO_PEER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_OPTIONAL_PEER_TO_PEER, NetsukukuOptionalPeerToPeerClass))

typedef struct _NetsukukuOptionalPeerToPeer NetsukukuOptionalPeerToPeer;
typedef struct _NetsukukuOptionalPeerToPeerClass NetsukukuOptionalPeerToPeerClass;
typedef struct _NetsukukuOptionalPeerToPeerPrivate NetsukukuOptionalPeerToPeerPrivate;
typedef struct _NetsukukuAggregatedNeighbourManagerPrivate NetsukukuAggregatedNeighbourManagerPrivate;
typedef struct _NetsukukuAggregatedNeighbourPrivate NetsukukuAggregatedNeighbourPrivate;

#define NETSUKUKU_TYPE_ICOUNTER_AS_PEER (netsukuku_icounter_as_peer_get_type ())
#define NETSUKUKU_ICOUNTER_AS_PEER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_ICOUNTER_AS_PEER, NetsukukuICounterAsPeer))
#define NETSUKUKU_IS_ICOUNTER_AS_PEER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_ICOUNTER_AS_PEER))
#define NETSUKUKU_ICOUNTER_AS_PEER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), NETSUKUKU_TYPE_ICOUNTER_AS_PEER, NetsukukuICounterAsPeerIface))

typedef struct _NetsukukuICounterAsPeer NetsukukuICounterAsPeer;
typedef struct _NetsukukuICounterAsPeerIface NetsukukuICounterAsPeerIface;
typedef struct _NetsukukuCounterPrivate NetsukukuCounterPrivate;

#define NTK_TEST_TYPE_COUNTER_DEBUG (ntk_test_counter_debug_get_type ())
#define NTK_TEST_COUNTER_DEBUG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NTK_TEST_TYPE_COUNTER_DEBUG, NtkTestCounterDebug))
#define NTK_TEST_COUNTER_DEBUG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NTK_TEST_TYPE_COUNTER_DEBUG, NtkTestCounterDebugClass))
#define NTK_TEST_IS_COUNTER_DEBUG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NTK_TEST_TYPE_COUNTER_DEBUG))
#define NTK_TEST_IS_COUNTER_DEBUG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NTK_TEST_TYPE_COUNTER_DEBUG))
#define NTK_TEST_COUNTER_DEBUG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NTK_TEST_TYPE_COUNTER_DEBUG, NtkTestCounterDebugClass))

typedef struct _NtkTestCounterDebug NtkTestCounterDebug;
typedef struct _NtkTestCounterDebugClass NtkTestCounterDebugClass;
typedef struct _NtkTestCounterDebugPrivate NtkTestCounterDebugPrivate;

#define NETSUKUKU_TYPE_KEY_PAIR (netsukuku_key_pair_get_type ())
#define NETSUKUKU_KEY_PAIR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_KEY_PAIR, NetsukukuKeyPair))
#define NETSUKUKU_KEY_PAIR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_KEY_PAIR, NetsukukuKeyPairClass))
#define NETSUKUKU_IS_KEY_PAIR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_KEY_PAIR))
#define NETSUKUKU_IS_KEY_PAIR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_KEY_PAIR))
#define NETSUKUKU_KEY_PAIR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_KEY_PAIR, NetsukukuKeyPairClass))

typedef struct _NetsukukuKeyPair NetsukukuKeyPair;
typedef struct _NetsukukuKeyPairClass NetsukukuKeyPairClass;

#define NTK_TEST_TYPE_FAKE_CLIENT (ntk_test_fake_client_get_type ())
#define NTK_TEST_FAKE_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NTK_TEST_TYPE_FAKE_CLIENT, NtkTestFakeClient))
#define NTK_TEST_FAKE_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NTK_TEST_TYPE_FAKE_CLIENT, NtkTestFakeClientClass))
#define NTK_TEST_IS_FAKE_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NTK_TEST_TYPE_FAKE_CLIENT))
#define NTK_TEST_IS_FAKE_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NTK_TEST_TYPE_FAKE_CLIENT))
#define NTK_TEST_FAKE_CLIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NTK_TEST_TYPE_FAKE_CLIENT, NtkTestFakeClientClass))

typedef struct _NtkTestFakeClient NtkTestFakeClient;
typedef struct _NtkTestFakeClientClass NtkTestFakeClientClass;
typedef struct _NtkTestFakeClientPrivate NtkTestFakeClientPrivate;

#define NTK_TEST_TYPE_ANDNA_COUNTER_TESTER (ntk_test_andna_counter_tester_get_type ())
#define NTK_TEST_ANDNA_COUNTER_TESTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NTK_TEST_TYPE_ANDNA_COUNTER_TESTER, NtkTestAndnaCounterTester))
#define NTK_TEST_ANDNA_COUNTER_TESTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NTK_TEST_TYPE_ANDNA_COUNTER_TESTER, NtkTestAndnaCounterTesterClass))
#define NTK_TEST_IS_ANDNA_COUNTER_TESTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NTK_TEST_TYPE_ANDNA_COUNTER_TESTER))
#define NTK_TEST_IS_ANDNA_COUNTER_TESTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NTK_TEST_TYPE_ANDNA_COUNTER_TESTER))
#define NTK_TEST_ANDNA_COUNTER_TESTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NTK_TEST_TYPE_ANDNA_COUNTER_TESTER, NtkTestAndnaCounterTesterClass))

typedef struct _NtkTestAndnaCounterTester NtkTestAndnaCounterTester;
typedef struct _NtkTestAndnaCounterTesterClass NtkTestAndnaCounterTesterClass;
typedef struct _NtkTestAndnaCounterTesterPrivate NtkTestAndnaCounterTesterPrivate;

#define NETSUKUKU_TYPE_IANDNA_AS_PEER (netsukuku_iandna_as_peer_get_type ())
#define NETSUKUKU_IANDNA_AS_PEER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_IANDNA_AS_PEER, NetsukukuIAndnaAsPeer))
#define NETSUKUKU_IS_IANDNA_AS_PEER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_IANDNA_AS_PEER))
#define NETSUKUKU_IANDNA_AS_PEER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), NETSUKUKU_TYPE_IANDNA_AS_PEER, NetsukukuIAndnaAsPeerIface))

typedef struct _NetsukukuIAndnaAsPeer NetsukukuIAndnaAsPeer;
typedef struct _NetsukukuIAndnaAsPeerIface NetsukukuIAndnaAsPeerIface;
typedef struct _NetsukukuAndnaPrivate NetsukukuAndnaPrivate;

#define NETSUKUKU_TYPE_RMT_COUNTER_PEER (netsukuku_rmt_counter_peer_get_type ())
#define NETSUKUKU_RMT_COUNTER_PEER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_RMT_COUNTER_PEER, NetsukukuRmtCounterPeer))
#define NETSUKUKU_RMT_COUNTER_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_RMT_COUNTER_PEER, NetsukukuRmtCounterPeerClass))
#define NETSUKUKU_IS_RMT_COUNTER_PEER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_RMT_COUNTER_PEER))
#define NETSUKUKU_IS_RMT_COUNTER_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_RMT_COUNTER_PEER))
#define NETSUKUKU_RMT_COUNTER_PEER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_RMT_COUNTER_PEER, NetsukukuRmtCounterPeerClass))

typedef struct _NetsukukuRmtCounterPeer NetsukukuRmtCounterPeer;
typedef struct _NetsukukuRmtCounterPeerClass NetsukukuRmtCounterPeerClass;

#define NETSUKUKU_TYPE_PUBLIC_KEY_WRAPPER (netsukuku_public_key_wrapper_get_type ())
#define NETSUKUKU_PUBLIC_KEY_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_PUBLIC_KEY_WRAPPER, NetsukukuPublicKeyWrapper))
#define NETSUKUKU_PUBLIC_KEY_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_PUBLIC_KEY_WRAPPER, NetsukukuPublicKeyWrapperClass))
#define NETSUKUKU_IS_PUBLIC_KEY_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_PUBLIC_KEY_WRAPPER))
#define NETSUKUKU_IS_PUBLIC_KEY_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_PUBLIC_KEY_WRAPPER))
#define NETSUKUKU_PUBLIC_KEY_WRAPPER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_PUBLIC_KEY_WRAPPER, NetsukukuPublicKeyWrapperClass))

typedef struct _NetsukukuPublicKeyWrapper NetsukukuPublicKeyWrapper;
typedef struct _NetsukukuPublicKeyWrapperClass NetsukukuPublicKeyWrapperClass;

#define NETSUKUKU_TYPE_RMT_ANDNA_PEER (netsukuku_rmt_andna_peer_get_type ())
#define NETSUKUKU_RMT_ANDNA_PEER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_RMT_ANDNA_PEER, NetsukukuRmtAndnaPeer))
#define NETSUKUKU_RMT_ANDNA_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_RMT_ANDNA_PEER, NetsukukuRmtAndnaPeerClass))
#define NETSUKUKU_IS_RMT_ANDNA_PEER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_RMT_ANDNA_PEER))
#define NETSUKUKU_IS_RMT_ANDNA_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_RMT_ANDNA_PEER))
#define NETSUKUKU_RMT_ANDNA_PEER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_RMT_ANDNA_PEER, NetsukukuRmtAndnaPeerClass))

typedef struct _NetsukukuRmtAndnaPeer NetsukukuRmtAndnaPeer;
typedef struct _NetsukukuRmtAndnaPeerClass NetsukukuRmtAndnaPeerClass;

#define NETSUKUKU_TYPE_ANDNA_SERVICE_HASHNODE_KEY (netsukuku_andna_service_hashnode_key_get_type ())
#define NETSUKUKU_ANDNA_SERVICE_HASHNODE_KEY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_ANDNA_SERVICE_HASHNODE_KEY, NetsukukuAndnaServiceHashnodeKey))
#define NETSUKUKU_ANDNA_SERVICE_HASHNODE_KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_ANDNA_SERVICE_HASHNODE_KEY, NetsukukuAndnaServiceHashnodeKeyClass))
#define NETSUKUKU_IS_ANDNA_SERVICE_HASHNODE_KEY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_ANDNA_SERVICE_HASHNODE_KEY))
#define NETSUKUKU_IS_ANDNA_SERVICE_HASHNODE_KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_ANDNA_SERVICE_HASHNODE_KEY))
#define NETSUKUKU_ANDNA_SERVICE_HASHNODE_KEY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_ANDNA_SERVICE_HASHNODE_KEY, NetsukukuAndnaServiceHashnodeKeyClass))

typedef struct _NetsukukuAndnaServiceHashnodeKey NetsukukuAndnaServiceHashnodeKey;
typedef struct _NetsukukuAndnaServiceHashnodeKeyClass NetsukukuAndnaServiceHashnodeKeyClass;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	NETSUKUKU_PEER_TO_PEER_ERROR_REGISTER,
	NETSUKUKU_PEER_TO_PEER_ERROR_GENERIC
} NetsukukuPeerToPeerError;
#define NETSUKUKU_PEER_TO_PEER_ERROR netsukuku_peer_to_peer_error_quark ()
struct _NetsukukuRmtPeer {
	GObject parent_instance;
	NetsukukuRmtPeerPrivate * priv;
};

struct _NetsukukuRmtPeerClass {
	GObjectClass parent_class;
	zcdISerializable* (*rmt) (NetsukukuRmtPeer* self, zcdRemoteCall* data, GError** error);
};

struct _NetsukukuRmtPeerPrivate {
	NetsukukuPeerToPeer* realdest;
};

struct _NetsukukuPeerToPeer {
	GObject parent_instance;
	NetsukukuPeerToPeerPrivate * priv;
	NetsukukuMapRoute* maproute;
};

struct _NetsukukuPeerToPeerClass {
	GObjectClass parent_class;
	zcdISerializable* (*_dispatch) (NetsukukuPeerToPeer* self, GObject* caller, zcdRemoteCall* data, GError** error);
	NetsukukuNIP* (*h) (NetsukukuPeerToPeer* self, GObject* key);
};

struct _NetsukukuMapRoute {
	GObject parent_instance;
	NetsukukuMapRoutePrivate * priv;
	gint levels;
	gint gsize;
	NetsukukuNIP* me;
};

struct _NetsukukuMapRouteClass {
	GObjectClass parent_class;
};

struct _NtkTestAndnaCounter {
	GObject parent_instance;
	NtkTestAndnaCounterPrivate * priv;
	NetsukukuAndna* andna;
	NetsukukuCounter* counter;
};

struct _NtkTestAndnaCounterClass {
	GObjectClass parent_class;
};

struct _NetsukukuPeerToPeerAll {
	GObject parent_instance;
	NetsukukuPeerToPeerAllPrivate * priv;
};

struct _NetsukukuPeerToPeerAllClass {
	GObjectClass parent_class;
	void (*peer_to_peer_register) (NetsukukuPeerToPeerAll* self, NetsukukuPeerToPeer* peer_to_peer, GError** error);
};

struct _NetsukukuOptionalPeerToPeer {
	NetsukukuPeerToPeer parent_instance;
	NetsukukuOptionalPeerToPeerPrivate * priv;
	gboolean will_participate;
	gboolean hooked;
};

struct _NetsukukuOptionalPeerToPeerClass {
	NetsukukuPeerToPeerClass parent_class;
};

struct _NetsukukuAggregatedNeighbourManager {
	GObject parent_instance;
	NetsukukuAggregatedNeighbourManagerPrivate * priv;
};

struct _NetsukukuAggregatedNeighbourManagerClass {
	GObjectClass parent_class;
};

struct _NetsukukuAggregatedNeighbour {
	GObject parent_instance;
	NetsukukuAggregatedNeighbourPrivate * priv;
};

struct _NetsukukuAggregatedNeighbourClass {
	GObjectClass parent_class;
};

struct _NetsukukuICounterAsPeerIface {
	GTypeInterface parent_iface;
	NetsukukuCounterSetDataResponse* (*set_data_for_pubk) (NetsukukuICounterAsPeer* self, NetsukukuNIP* nip, GeeList* hashed_domains, NetsukukuPublicKey* pubkey, zcdSerializableBuffer* signature, gboolean replicate, GError** error);
	NetsukukuCounterCheckHostnameResponse* (*check_hostname) (NetsukukuICounterAsPeer* self, NetsukukuNIP* nip, const gchar* hashed_domain, NetsukukuPublicKey* pubkey, GError** error);
	NetsukukuCounterNipRecord* (*get_hostnames) (NetsukukuICounterAsPeer* self, NetsukukuNIP* nip, GError** error);
	NetsukukuCounterGetCacheRecordsResponse* (*get_cache_records) (NetsukukuICounterAsPeer* self, GError** error);
};

struct _NetsukukuCounter {
	NetsukukuPeerToPeer parent_instance;
	NetsukukuCounterPrivate * priv;
	gboolean memory_initialized;
};

struct _NetsukukuCounterClass {
	NetsukukuPeerToPeerClass parent_class;
	NetsukukuIAddressManagerRootDispatcher* (*contact_registrar) (NetsukukuCounter* self, const gchar* registrar_address);
};

struct _NtkTestCounterDebug {
	NetsukukuCounter parent_instance;
	NtkTestCounterDebugPrivate * priv;
};

struct _NtkTestCounterDebugClass {
	NetsukukuCounterClass parent_class;
};

struct _NtkTestFakeClient {
	GObject parent_instance;
	NtkTestFakeClientPrivate * priv;
	NetsukukuAndna* actual_andna;
};

struct _NtkTestFakeClientClass {
	GObjectClass parent_class;
};

struct _NtkTestAndnaCounterTester {
	GObject parent_instance;
	NtkTestAndnaCounterTesterPrivate * priv;
};

struct _NtkTestAndnaCounterTesterClass {
	GObjectClass parent_class;
};

typedef enum  {
	NETSUKUKU_CRYPTO_GCRYPT_ERROR_FAILED
} NetsukukuCryptoGCryptError;
#define NETSUKUKU_CRYPTO_GCRYPT_ERROR netsukuku_crypto_gcrypt_error_quark ()
struct _NetsukukuIAndnaAsPeerIface {
	GTypeInterface parent_iface;
	NetsukukuAndnaRegisterMainResponse* (*register_main_for_pubk) (NetsukukuIAndnaAsPeer* self, NetsukukuAndnaDomainRequest* request, zcdSerializableBuffer* signature, gboolean replicate, GError** error);
	NetsukukuAndnaGetRegistrarResponse* (*get_registrar) (NetsukukuIAndnaAsPeer* self, const gchar* hashed_domain, GError** error);
	NetsukukuAndnaDomainRecord* (*get_domain_record) (NetsukukuIAndnaAsPeer* self, const gchar* hashed_domain, GError** error);
	NetsukukuAndnaRegisterSpreadResponse* (*register_spread_record) (NetsukukuIAndnaAsPeer* self, const gchar* hashed_domain, gint spread_number, gboolean replicate, GError** error);
	NetsukukuAndnaGetServersResponse* (*get_servers) (NetsukukuIAndnaAsPeer* self, const gchar* hashed_domain, NetsukukuAndnaServiceKey* srv_key, gint spread_number, gboolean chain, GError** error);
	NetsukukuAndnaGetCacheRecordsResponse* (*get_cache_records) (NetsukukuIAndnaAsPeer* self, GError** error);
};

struct _NetsukukuAndna {
	NetsukukuPeerToPeer parent_instance;
	NetsukukuAndnaPrivate * priv;
	gboolean memory_initialized;
};

struct _NetsukukuAndnaClass {
	NetsukukuPeerToPeerClass parent_class;
};


static gpointer netsukuku_rmt_peer_parent_class = NULL;
static gpointer netsukuku_peer_to_peer_all_parent_class = NULL;
static gpointer netsukuku_peer_to_peer_parent_class = NULL;
extern GeeHashMap* ntk_test_nodes;
static gpointer netsukuku_optional_peer_to_peer_parent_class = NULL;
static gpointer netsukuku_aggregated_neighbour_manager_parent_class = NULL;
static gpointer netsukuku_aggregated_neighbour_parent_class = NULL;
static gpointer netsukuku_map_route_parent_class = NULL;
extern gboolean netsukuku_settings_TESTING;
gboolean netsukuku_settings_TESTING = FALSE;
extern gchar* ntk_test_logger;
gchar* ntk_test_logger = NULL;
GeeHashMap* ntk_test_nodes = NULL;
extern GeeHashMap* ntk_test_nodes_by_niptostr;
GeeHashMap* ntk_test_nodes_by_niptostr = NULL;
static gpointer ntk_test_counter_debug_parent_class = NULL;
static gpointer ntk_test_fake_client_parent_class = NULL;
static NetsukukuIAddressManagerRootDispatcherIface* ntk_test_fake_client_netsukuku_iaddress_manager_root_dispatcher_parent_iface = NULL;
static gpointer ntk_test_andna_counter_parent_class = NULL;
static gpointer ntk_test_andna_counter_tester_parent_class = NULL;

gchar* netsukuku_tasklet_id (void);
void netsukuku_log_debug (const gchar* msg);
void ntk_test_print_out (const gchar* s);
void netsukuku_log_info (const gchar* msg);
void netsukuku_log_notice (const gchar* msg);
void netsukuku_log_warn (const gchar* msg);
void netsukuku_log_error (const gchar* msg);
void netsukuku_log_critical (const gchar* msg);
GQuark netsukuku_peer_to_peer_error_quark (void);
GType netsukuku_rmt_peer_get_type (void) G_GNUC_CONST;
GType netsukuku_peer_to_peer_get_type (void) G_GNUC_CONST;
#define NETSUKUKU_RMT_PEER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), NETSUKUKU_TYPE_RMT_PEER, NetsukukuRmtPeerPrivate))
enum  {
	NETSUKUKU_RMT_PEER_DUMMY_PROPERTY
};
GType netsukuku_aggregated_neighbour_get_type (void) G_GNUC_CONST;
NetsukukuRmtPeer* netsukuku_rmt_peer_new (NetsukukuPeerToPeer* peer_to_peer_service, GObject* key, NetsukukuNIP* hIP, NetsukukuAggregatedNeighbour* aggregated_neighbour);
NetsukukuRmtPeer* netsukuku_rmt_peer_construct (GType object_type, NetsukukuPeerToPeer* peer_to_peer_service, GObject* key, NetsukukuNIP* hIP, NetsukukuAggregatedNeighbour* aggregated_neighbour);
GType netsukuku_map_route_get_type (void) G_GNUC_CONST;
NetsukukuNIP* netsukuku_peer_to_peer_h (NetsukukuPeerToPeer* self, GObject* key);
GType ntk_test_andna_counter_get_type (void) G_GNUC_CONST;
NtkTestAndnaCounter* ntk_test_best_approximation (gint levels, gint gsize, NetsukukuNIP* hIP, gint sign);
GType netsukuku_andna_get_type (void) G_GNUC_CONST;
GType netsukuku_counter_get_type (void) G_GNUC_CONST;
zcdISerializable* netsukuku_rmt_peer_rmt (NetsukukuRmtPeer* self, zcdRemoteCall* data, GError** error);
static zcdISerializable* netsukuku_rmt_peer_real_rmt (NetsukukuRmtPeer* self, zcdRemoteCall* data, GError** error);
zcdISerializable* _netsukuku_peer_to_peer_dispatch (NetsukukuPeerToPeer* self, GObject* caller, zcdRemoteCall* data, GError** error);
static void netsukuku_rmt_peer_finalize (GObject* obj);
GType netsukuku_peer_to_peer_all_get_type (void) G_GNUC_CONST;
enum  {
	NETSUKUKU_PEER_TO_PEER_ALL_DUMMY_PROPERTY
};
void netsukuku_peer_to_peer_all_peer_to_peer_register (NetsukukuPeerToPeerAll* self, NetsukukuPeerToPeer* peer_to_peer, GError** error);
static void netsukuku_peer_to_peer_all_real_peer_to_peer_register (NetsukukuPeerToPeerAll* self, NetsukukuPeerToPeer* peer_to_peer, GError** error);
NetsukukuPeerToPeerAll* netsukuku_peer_to_peer_all_new (void);
NetsukukuPeerToPeerAll* netsukuku_peer_to_peer_all_construct (GType object_type);
enum  {
	NETSUKUKU_PEER_TO_PEER_DUMMY_PROPERTY,
	NETSUKUKU_PEER_TO_PEER_PARTICIPANT
};
GType netsukuku_aggregated_neighbour_manager_get_type (void) G_GNUC_CONST;
NetsukukuPeerToPeer* netsukuku_peer_to_peer_new (NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, gint pid);
NetsukukuPeerToPeer* netsukuku_peer_to_peer_construct (GType object_type, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, gint pid);
static zcdISerializable* netsukuku_peer_to_peer_real__dispatch (NetsukukuPeerToPeer* self, GObject* caller, zcdRemoteCall* data, GError** error);
static NetsukukuNIP* netsukuku_peer_to_peer_real_h (NetsukukuPeerToPeer* self, GObject* key);
GeeList* netsukuku_peer_to_peer_list_ids (NetsukukuPeerToPeer* self, gint center, gint sign);
GeeArrayList* ntk_test_list_positions (gint startpos, gint sign, gint gsize);
void netsukuku_peer_to_peer_find_hook_peers (NetsukukuPeerToPeer* self, gint** ret_first_forward, gint** ret_first_back, gint** ret_last_back, gint lvl, gint num_dupl, gint timeout);
gint netsukuku_peer_to_peer_get_number_of_participants (NetsukukuPeerToPeer* self, gint lvl, gint pos, gint timeout);
static gint* _int_dup (gint* self);
GeeList* netsukuku_peer_to_peer_find_nearest_to_register (NetsukukuPeerToPeer* self, NetsukukuNIP* hash_nip, gint num_dupl);
static gboolean _netsukuku_partial_nip_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self);
GeeArrayList* ntk_test_ordered_lookup (gint levels, gint gsize, NetsukukuNIP* hIP, gint sign);
NetsukukuHCoord* netsukuku_peer_to_peer_search_participant (NetsukukuPeerToPeer* self, NetsukukuNIP* hIP, gint path_sign, GError** error);
NetsukukuNIP* ntk_test_best_approximation_nip (gint levels, gint gsize, NetsukukuNIP* hIP, gint sign);
NetsukukuPartialNIP* netsukuku_peer_to_peer_search_participant_as_nip (NetsukukuPeerToPeer* self, NetsukukuNIP* hIP, gint path_sign, GError** error);
gboolean netsukuku_peer_to_peer_get_participant (NetsukukuPeerToPeer* self);
static void netsukuku_peer_to_peer_finalize (GObject* obj);
static void _vala_netsukuku_peer_to_peer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
GType netsukuku_optional_peer_to_peer_get_type (void) G_GNUC_CONST;
enum  {
	NETSUKUKU_OPTIONAL_PEER_TO_PEER_DUMMY_PROPERTY
};
NetsukukuOptionalPeerToPeer* netsukuku_optional_peer_to_peer_new (NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, gint pid);
NetsukukuOptionalPeerToPeer* netsukuku_optional_peer_to_peer_construct (GType object_type, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, gint pid);
void netsukuku_optional_peer_to_peer_participate (NetsukukuOptionalPeerToPeer* self);
static void netsukuku_optional_peer_to_peer_finalize (GObject* obj);
enum  {
	NETSUKUKU_AGGREGATED_NEIGHBOUR_MANAGER_DUMMY_PROPERTY
};
NetsukukuAggregatedNeighbourManager* netsukuku_aggregated_neighbour_manager_new (void);
NetsukukuAggregatedNeighbourManager* netsukuku_aggregated_neighbour_manager_construct (GType object_type);
enum  {
	NETSUKUKU_AGGREGATED_NEIGHBOUR_DUMMY_PROPERTY
};
NetsukukuAggregatedNeighbour* netsukuku_aggregated_neighbour_new (void);
NetsukukuAggregatedNeighbour* netsukuku_aggregated_neighbour_construct (GType object_type);
enum  {
	NETSUKUKU_MAP_ROUTE_DUMMY_PROPERTY
};
NetsukukuMapRoute* netsukuku_map_route_new (gint l, gint s, NetsukukuNIP* n);
NetsukukuMapRoute* netsukuku_map_route_construct (GType object_type, gint l, gint s, NetsukukuNIP* n);
NetsukukuPartialNIP* netsukuku_map_route_choose_fast (NetsukukuMapRoute* self, GeeList* choose_from);
static void netsukuku_map_route_finalize (GObject* obj);
GeeArrayList* netsukuku_valid_ids (gint levels, gint gsize, gint lvl, NetsukukuPartialNIP* partial_nip);
gchar* netsukuku_nip_to_str (gint levels, gint gsize, NetsukukuNIP* nip);
#define NETSUKUKU_COUNTER_DUPLICATION 3
#define NETSUKUKU_ANDNA_DUPLICATION 3
#define NETSUKUKU_MAX_HOSTNAMES 256
#define NETSUKUKU_MAX_TTL_ANDNA ((((((gint64) 1000) * ((gint64) 60)) * ((gint64) 60)) * ((gint64) 24)) * ((gint64) 30))
#define NETSUKUKU_MAX_TTL_OF_NEGATIVE (((gint64) 1000) * ((gint64) 30))
#define NETSUKUKU_MAX_TTL_COUNTER ((((((gint64) 1000) * ((gint64) 60)) * ((gint64) 60)) * ((gint64) 24)) * ((gint64) 30))
#define NETSUKUKU_MAX_WAIT_REFRESH_ANDNA ((((gint64) 1000) * ((gint64) 60)) * ((gint64) 60))
#define NETSUKUKU_MAX_WAIT_REFRESH_COUNTER ((((gint64) 1000) * ((gint64) 60)) * ((gint64) 60))
#define NETSUKUKU_MAX_QUEUE_ANDNA 5
#define NETSUKUKU_SPREAD_ANDNA 3
#define NTK_TEST_output FALSE
GType netsukuku_icounter_as_peer_get_type (void) G_GNUC_CONST;
GType ntk_test_counter_debug_get_type (void) G_GNUC_CONST;
enum  {
	NTK_TEST_COUNTER_DEBUG_DUMMY_PROPERTY
};
GType netsukuku_key_pair_get_type (void) G_GNUC_CONST;
NtkTestCounterDebug* ntk_test_counter_debug_new (NetsukukuKeyPair* keypair, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, NetsukukuPeerToPeerAll* peer_to_peer_all);
NtkTestCounterDebug* ntk_test_counter_debug_construct (GType object_type, NetsukukuKeyPair* keypair, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, NetsukukuPeerToPeerAll* peer_to_peer_all);
NetsukukuCounter* netsukuku_counter_new (NetsukukuKeyPair* keypair, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, NetsukukuPeerToPeerAll* peer_to_peer_all);
NetsukukuCounter* netsukuku_counter_construct (GType object_type, NetsukukuKeyPair* keypair, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, NetsukukuPeerToPeerAll* peer_to_peer_all);
static NetsukukuIAddressManagerRootDispatcher* ntk_test_counter_debug_real_contact_registrar (NetsukukuCounter* base, const gchar* registrar_address);
NtkTestFakeClient* ntk_test_fake_client_new (void);
NtkTestFakeClient* ntk_test_fake_client_construct (GType object_type);
GType ntk_test_fake_client_get_type (void) G_GNUC_CONST;
enum  {
	NTK_TEST_FAKE_CLIENT_DUMMY_PROPERTY
};
static NetsukukuIAggregatedNeighbourManager* ntk_test_fake_client_real__aggregated_neighbour_manager_getter (NetsukukuIAddressManagerRootDispatcher* base);
static NetsukukuIAndna* ntk_test_fake_client_real__andna_getter (NetsukukuIAddressManagerRootDispatcher* base);
static NetsukukuIBorderNodesManager* ntk_test_fake_client_real__border_nodes_manager_getter (NetsukukuIAddressManagerRootDispatcher* base);
static NetsukukuICoordinator* ntk_test_fake_client_real__coordinator_getter (NetsukukuIAddressManagerRootDispatcher* base);
static NetsukukuIEtp* ntk_test_fake_client_real__etp_getter (NetsukukuIAddressManagerRootDispatcher* base);
static NetsukukuIHook* ntk_test_fake_client_real__hook_getter (NetsukukuIAddressManagerRootDispatcher* base);
static NetsukukuIMapRoute* ntk_test_fake_client_real__maproute_getter (NetsukukuIAddressManagerRootDispatcher* base);
static NetsukukuIPeerToPeerAll* ntk_test_fake_client_real__peer_to_peer_all_getter (NetsukukuIAddressManagerRootDispatcher* base);
static NetsukukuITunnelManager* ntk_test_fake_client_real__tunnel_manager_getter (NetsukukuIAddressManagerRootDispatcher* base);
static NetsukukuIOptionalPeerToPeer* ntk_test_fake_client_real_get_optional_peer_to_peer_service (NetsukukuIAddressManagerRootDispatcher* base, gint pid);
static NetsukukuIPeerToPeer* ntk_test_fake_client_real_get_peer_to_peer_service (NetsukukuIAddressManagerRootDispatcher* base, gint pid);
static GeeList* ntk_test_fake_client_real_report_tasklets_stats (NetsukukuIAddressManagerRootDispatcher* base, gint minutes, GError** error);
static GeeList* ntk_test_fake_client_real_report_tasklet_logs (NetsukukuIAddressManagerRootDispatcher* base, gint minutes, GError** error);
static GeeList* ntk_test_fake_client_real_report_running_tasklets (NetsukukuIAddressManagerRootDispatcher* base, GError** error);
static void ntk_test_fake_client_finalize (GObject* obj);
enum  {
	NTK_TEST_ANDNA_COUNTER_DUMMY_PROPERTY
};
NtkTestAndnaCounter* ntk_test_andna_counter_new (void);
NtkTestAndnaCounter* ntk_test_andna_counter_construct (GType object_type);
static void ntk_test_andna_counter_finalize (GObject* obj);
GType ntk_test_andna_counter_tester_get_type (void) G_GNUC_CONST;
enum  {
	NTK_TEST_ANDNA_COUNTER_TESTER_DUMMY_PROPERTY
};
void ntk_test_andna_counter_tester_set_up (NtkTestAndnaCounterTester* self);
void ntk_test_andna_counter_tester_tear_down (NtkTestAndnaCounterTester* self);
void ntk_test_andna_counter_tester_test_hook_and_replica (NtkTestAndnaCounterTester* self);
static guint _netsukuku_partial_nip_hash_func_gee_hash_data_func (gconstpointer v, gpointer self);
static void _vala_array_add1 (NetsukukuNIP*** array, int* length, int* size, NetsukukuNIP* value);
GQuark netsukuku_crypto_gcrypt_error_quark (void);
NetsukukuKeyPair* netsukuku_key_pair_new (const gchar* from_file, GError** error);
NetsukukuKeyPair* netsukuku_key_pair_construct (GType object_type, const gchar* from_file, GError** error);
static void _vala_array_add2 (NetsukukuKeyPair*** array, int* length, int* size, NetsukukuKeyPair* value);
static void _vala_array_add3 (NetsukukuMapRoute*** array, int* length, int* size, NetsukukuMapRoute* value);
NetsukukuAndna* netsukuku_andna_new (NetsukukuKeyPair* keypair, NetsukukuCounter* counter, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, NetsukukuPeerToPeerAll* peer_to_peer_all);
NetsukukuAndna* netsukuku_andna_construct (GType object_type, NetsukukuKeyPair* keypair, NetsukukuCounter* counter, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, NetsukukuPeerToPeerAll* peer_to_peer_all);
void netsukuku_counter_set_andna (NetsukukuCounter* self, NetsukukuAndna* value);
GType netsukuku_iandna_as_peer_get_type (void) G_GNUC_CONST;
GeeArrayList* netsukuku_counter_utilities_hash_names (GeeArrayList* myhostnames);
guchar* netsukuku_counter_utilities_prepare_msg (NetsukukuNIP* nip, GeeList* hashed_domains, int* result_length1);
guchar* netsukuku_key_pair_sign (NetsukukuKeyPair* self, guchar* msg, int msg_length1, int* result_length1, GError** error);
GType netsukuku_rmt_counter_peer_get_type (void) G_GNUC_CONST;
NetsukukuRmtCounterPeer* netsukuku_counter_peer (NetsukukuCounter* self, NetsukukuNIP* hIP, GObject* key, NetsukukuAggregatedNeighbour* aggregated_neighbour);
NetsukukuCounterSetDataResponse* netsukuku_icounter_as_peer_set_data_for_pubk (NetsukukuICounterAsPeer* self, NetsukukuNIP* nip, GeeList* hashed_domains, NetsukukuPublicKey* pubkey, zcdSerializableBuffer* signature, gboolean replicate, GError** error);
GType netsukuku_public_key_wrapper_get_type (void) G_GNUC_CONST;
NetsukukuPublicKeyWrapper* netsukuku_key_pair_get_pub_key (NetsukukuKeyPair* self);
NetsukukuPublicKey* netsukuku_public_key_wrapper_to_pubkey (NetsukukuPublicKeyWrapper* self);
NetsukukuAndnaDomainRequest* netsukuku_andna_make_domain_request (NetsukukuAndna* self, NetsukukuAndnaPrivateConfiguration* cfg);
GType netsukuku_rmt_andna_peer_get_type (void) G_GNUC_CONST;
NetsukukuRmtAndnaPeer* netsukuku_andna_peer (NetsukukuAndna* self, NetsukukuNIP* hIP, GObject* key, NetsukukuAggregatedNeighbour* aggregated_neighbour);
NetsukukuAndnaServiceHashnodeKey* netsukuku_andna_service_hashnode_key_new (const gchar* hashed_domain, gint spread_num);
NetsukukuAndnaServiceHashnodeKey* netsukuku_andna_service_hashnode_key_construct (GType object_type, const gchar* hashed_domain, gint spread_num);
GType netsukuku_andna_service_hashnode_key_get_type (void) G_GNUC_CONST;
NetsukukuAndnaRegisterMainResponse* netsukuku_iandna_as_peer_register_main_for_pubk (NetsukukuIAndnaAsPeer* self, NetsukukuAndnaDomainRequest* request, zcdSerializableBuffer* signature, gboolean replicate, GError** error);
NetsukukuAndnaGetServersResponse* netsukuku_andna_ask_get_servers (NetsukukuAndna* self, const gchar* hashed_domain, NetsukukuAndnaServiceKey* srv_key, gboolean chain);
gchar* netsukuku_andna_crypto_hash (const gchar* hostname);
gint ntk_test_andna_counter_tester_main (gchar** args, int args_length1);
static void __lambda17_ (void);
NtkTestAndnaCounterTester* ntk_test_andna_counter_tester_new (void);
NtkTestAndnaCounterTester* ntk_test_andna_counter_tester_construct (GType object_type);
static void ___lambda17__gcallback (void);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


gchar* netsukuku_tasklet_id (void) {
	gchar* result = NULL;
	TaskletsTasklet* _tmp0_ = NULL;
	TaskletsTasklet* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	_tmp0_ = tasklets_tasklet_self ();
	_tmp1_ = _tmp0_;
	_tmp2_ = tasklets_tasklet_get_id (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("%i", _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat ("[", _tmp5_, "] ", NULL);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	_g_object_unref0 (_tmp1_);
	result = _tmp7_;
	return result;
}


void netsukuku_log_debug (const gchar* msg) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = netsukuku_tasklet_id ();
	_tmp1_ = _tmp0_;
	_tmp2_ = msg;
	_tmp3_ = g_strconcat (_tmp1_, _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp4_, "\n", NULL);
	_tmp6_ = _tmp5_;
	ntk_test_print_out (_tmp6_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp1_);
}


void netsukuku_log_info (const gchar* msg) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = netsukuku_tasklet_id ();
	_tmp1_ = _tmp0_;
	_tmp2_ = msg;
	_tmp3_ = g_strconcat (_tmp1_, _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp4_, "\n", NULL);
	_tmp6_ = _tmp5_;
	ntk_test_print_out (_tmp6_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp1_);
}


void netsukuku_log_notice (const gchar* msg) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = netsukuku_tasklet_id ();
	_tmp1_ = _tmp0_;
	_tmp2_ = msg;
	_tmp3_ = g_strconcat (_tmp1_, _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp4_, "\n", NULL);
	_tmp6_ = _tmp5_;
	ntk_test_print_out (_tmp6_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp1_);
}


void netsukuku_log_warn (const gchar* msg) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = netsukuku_tasklet_id ();
	_tmp1_ = _tmp0_;
	_tmp2_ = msg;
	_tmp3_ = g_strconcat (_tmp1_, _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp4_, "\n", NULL);
	_tmp6_ = _tmp5_;
	ntk_test_print_out (_tmp6_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp1_);
}


void netsukuku_log_error (const gchar* msg) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = netsukuku_tasklet_id ();
	_tmp1_ = _tmp0_;
	_tmp2_ = msg;
	_tmp3_ = g_strconcat (_tmp1_, _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp4_, "\n", NULL);
	_tmp6_ = _tmp5_;
	ntk_test_print_out (_tmp6_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp1_);
}


void netsukuku_log_critical (const gchar* msg) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = netsukuku_tasklet_id ();
	_tmp1_ = _tmp0_;
	_tmp2_ = msg;
	_tmp3_ = g_strconcat (_tmp1_, _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp4_, "\n", NULL);
	_tmp6_ = _tmp5_;
	ntk_test_print_out (_tmp6_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp1_);
}


GQuark netsukuku_peer_to_peer_error_quark (void) {
	return g_quark_from_static_string ("netsukuku_peer_to_peer_error-quark");
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


NetsukukuRmtPeer* netsukuku_rmt_peer_construct (GType object_type, NetsukukuPeerToPeer* peer_to_peer_service, GObject* key, NetsukukuNIP* hIP, NetsukukuAggregatedNeighbour* aggregated_neighbour) {
	NetsukukuRmtPeer * self = NULL;
	NetsukukuPeerToPeer* _tmp0_;
	NetsukukuMapRoute* _tmp1_;
	NetsukukuMapRoute* _tmp2_;
	NetsukukuMapRoute* mr;
	NetsukukuNIP* dest = NULL;
	NetsukukuNIP* _tmp3_;
	NetsukukuMapRoute* _tmp9_;
	gint _tmp10_;
	NetsukukuMapRoute* _tmp11_;
	gint _tmp12_;
	NetsukukuNIP* _tmp13_;
	NtkTestAndnaCounter* _tmp14_ = NULL;
	NtkTestAndnaCounter* d;
	NetsukukuPeerToPeer* _tmp15_;
	GType _tmp16_ = 0UL;
	gboolean _tmp17_ = FALSE;
	NetsukukuPeerToPeer* _tmp21_;
	GType _tmp22_ = 0UL;
	gboolean _tmp23_ = FALSE;
	g_return_val_if_fail (peer_to_peer_service != NULL, NULL);
	self = (NetsukukuRmtPeer*) g_object_new (object_type, NULL);
	_tmp0_ = peer_to_peer_service;
	_tmp1_ = _tmp0_->maproute;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	mr = _tmp2_;
	_tmp3_ = hIP;
	if (_tmp3_ == NULL) {
		NetsukukuPeerToPeer* _tmp4_;
		GObject* _tmp5_;
		NetsukukuNIP* _tmp6_ = NULL;
		_tmp4_ = peer_to_peer_service;
		_tmp5_ = key;
		_tmp6_ = netsukuku_peer_to_peer_h (_tmp4_, _tmp5_);
		_g_object_unref0 (dest);
		dest = _tmp6_;
	} else {
		NetsukukuNIP* _tmp7_;
		NetsukukuNIP* _tmp8_;
		_tmp7_ = hIP;
		_tmp8_ = _g_object_ref0 (_tmp7_);
		_g_object_unref0 (dest);
		dest = _tmp8_;
	}
	_tmp9_ = mr;
	_tmp10_ = _tmp9_->levels;
	_tmp11_ = mr;
	_tmp12_ = _tmp11_->gsize;
	_tmp13_ = dest;
	_tmp14_ = ntk_test_best_approximation (_tmp10_, _tmp12_, _tmp13_, 1);
	d = _tmp14_;
	_tmp15_ = peer_to_peer_service;
	_tmp16_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp15_);
	_tmp17_ = g_type_is_a (_tmp16_, NETSUKUKU_TYPE_ANDNA);
	if (_tmp17_) {
		NtkTestAndnaCounter* _tmp18_;
		NetsukukuAndna* _tmp19_;
		NetsukukuPeerToPeer* _tmp20_;
		_tmp18_ = d;
		_tmp19_ = _tmp18_->andna;
		_tmp20_ = _g_object_ref0 ((NetsukukuPeerToPeer*) _tmp19_);
		_g_object_unref0 (self->priv->realdest);
		self->priv->realdest = _tmp20_;
	}
	_tmp21_ = peer_to_peer_service;
	_tmp22_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp21_);
	_tmp23_ = g_type_is_a (_tmp22_, NETSUKUKU_TYPE_COUNTER);
	if (_tmp23_) {
		NtkTestAndnaCounter* _tmp24_;
		NetsukukuCounter* _tmp25_;
		NetsukukuPeerToPeer* _tmp26_;
		_tmp24_ = d;
		_tmp25_ = _tmp24_->counter;
		_tmp26_ = _g_object_ref0 ((NetsukukuPeerToPeer*) _tmp25_);
		_g_object_unref0 (self->priv->realdest);
		self->priv->realdest = _tmp26_;
	}
	_g_object_unref0 (d);
	_g_object_unref0 (dest);
	_g_object_unref0 (mr);
	return self;
}


NetsukukuRmtPeer* netsukuku_rmt_peer_new (NetsukukuPeerToPeer* peer_to_peer_service, GObject* key, NetsukukuNIP* hIP, NetsukukuAggregatedNeighbour* aggregated_neighbour) {
	return netsukuku_rmt_peer_construct (NETSUKUKU_TYPE_RMT_PEER, peer_to_peer_service, key, hIP, aggregated_neighbour);
}


static zcdISerializable* netsukuku_rmt_peer_real_rmt (NetsukukuRmtPeer* self, zcdRemoteCall* data, GError** error) {
	zcdISerializable* result = NULL;
	zcdRemoteCall* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	NetsukukuPeerToPeer* _tmp5_;
	NetsukukuMapRoute* _tmp6_;
	NetsukukuNIP* _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	NetsukukuPeerToPeer* _tmp12_;
	zcdRemoteCall* _tmp13_;
	zcdISerializable* _tmp14_ = NULL;
	zcdISerializable* _tmp15_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (data != NULL, NULL);
	_tmp0_ = data;
	_tmp1_ = zcd_remote_call_to_string (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat ("RmtPeer.rmt(data ", _tmp2_, ")\n", NULL);
	_tmp4_ = _tmp3_;
	ntk_test_print_out (_tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	_tmp5_ = self->priv->realdest;
	_tmp6_ = _tmp5_->maproute;
	_tmp7_ = _tmp6_->me;
	_tmp8_ = netsukuku_partial_nip_to_string ((NetsukukuPartialNIP*) _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat ("sent to ", _tmp9_, "\n", NULL);
	_tmp11_ = _tmp10_;
	ntk_test_print_out (_tmp11_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	_tmp12_ = self->priv->realdest;
	_tmp13_ = data;
	_tmp14_ = _netsukuku_peer_to_peer_dispatch (_tmp12_, NULL, _tmp13_, &_inner_error_);
	_tmp15_ = _tmp14_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	result = _tmp15_;
	return result;
}


zcdISerializable* netsukuku_rmt_peer_rmt (NetsukukuRmtPeer* self, zcdRemoteCall* data, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return NETSUKUKU_RMT_PEER_GET_CLASS (self)->rmt (self, data, error);
}


static void netsukuku_rmt_peer_class_init (NetsukukuRmtPeerClass * klass) {
	netsukuku_rmt_peer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (NetsukukuRmtPeerPrivate));
	NETSUKUKU_RMT_PEER_CLASS (klass)->rmt = netsukuku_rmt_peer_real_rmt;
	G_OBJECT_CLASS (klass)->finalize = netsukuku_rmt_peer_finalize;
}


static void netsukuku_rmt_peer_instance_init (NetsukukuRmtPeer * self) {
	self->priv = NETSUKUKU_RMT_PEER_GET_PRIVATE (self);
}


static void netsukuku_rmt_peer_finalize (GObject* obj) {
	NetsukukuRmtPeer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_RMT_PEER, NetsukukuRmtPeer);
	_g_object_unref0 (self->priv->realdest);
	G_OBJECT_CLASS (netsukuku_rmt_peer_parent_class)->finalize (obj);
}


GType netsukuku_rmt_peer_get_type (void) {
	static volatile gsize netsukuku_rmt_peer_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_rmt_peer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuRmtPeerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_rmt_peer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuRmtPeer), 0, (GInstanceInitFunc) netsukuku_rmt_peer_instance_init, NULL };
		GType netsukuku_rmt_peer_type_id;
		netsukuku_rmt_peer_type_id = g_type_register_static (G_TYPE_OBJECT, "NetsukukuRmtPeer", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_rmt_peer_type_id__volatile, netsukuku_rmt_peer_type_id);
	}
	return netsukuku_rmt_peer_type_id__volatile;
}


static void netsukuku_peer_to_peer_all_real_peer_to_peer_register (NetsukukuPeerToPeerAll* self, NetsukukuPeerToPeer* peer_to_peer, GError** error) {
	g_return_if_fail (peer_to_peer != NULL);
}


void netsukuku_peer_to_peer_all_peer_to_peer_register (NetsukukuPeerToPeerAll* self, NetsukukuPeerToPeer* peer_to_peer, GError** error) {
	g_return_if_fail (self != NULL);
	NETSUKUKU_PEER_TO_PEER_ALL_GET_CLASS (self)->peer_to_peer_register (self, peer_to_peer, error);
}


NetsukukuPeerToPeerAll* netsukuku_peer_to_peer_all_construct (GType object_type) {
	NetsukukuPeerToPeerAll * self = NULL;
	self = (NetsukukuPeerToPeerAll*) g_object_new (object_type, NULL);
	return self;
}


NetsukukuPeerToPeerAll* netsukuku_peer_to_peer_all_new (void) {
	return netsukuku_peer_to_peer_all_construct (NETSUKUKU_TYPE_PEER_TO_PEER_ALL);
}


static void netsukuku_peer_to_peer_all_class_init (NetsukukuPeerToPeerAllClass * klass) {
	netsukuku_peer_to_peer_all_parent_class = g_type_class_peek_parent (klass);
	NETSUKUKU_PEER_TO_PEER_ALL_CLASS (klass)->peer_to_peer_register = netsukuku_peer_to_peer_all_real_peer_to_peer_register;
}


static void netsukuku_peer_to_peer_all_instance_init (NetsukukuPeerToPeerAll * self) {
}


GType netsukuku_peer_to_peer_all_get_type (void) {
	static volatile gsize netsukuku_peer_to_peer_all_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_peer_to_peer_all_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuPeerToPeerAllClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_peer_to_peer_all_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuPeerToPeerAll), 0, (GInstanceInitFunc) netsukuku_peer_to_peer_all_instance_init, NULL };
		GType netsukuku_peer_to_peer_all_type_id;
		netsukuku_peer_to_peer_all_type_id = g_type_register_static (G_TYPE_OBJECT, "NetsukukuPeerToPeerAll", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_peer_to_peer_all_type_id__volatile, netsukuku_peer_to_peer_all_type_id);
	}
	return netsukuku_peer_to_peer_all_type_id__volatile;
}


NetsukukuPeerToPeer* netsukuku_peer_to_peer_construct (GType object_type, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, gint pid) {
	NetsukukuPeerToPeer * self = NULL;
	NetsukukuMapRoute* _tmp0_;
	NetsukukuMapRoute* _tmp1_;
	g_return_val_if_fail (aggregated_neighbour_manager != NULL, NULL);
	g_return_val_if_fail (maproute != NULL, NULL);
	self = (NetsukukuPeerToPeer*) g_object_new (object_type, NULL);
	_tmp0_ = maproute;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->maproute);
	self->maproute = _tmp1_;
	return self;
}


NetsukukuPeerToPeer* netsukuku_peer_to_peer_new (NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, gint pid) {
	return netsukuku_peer_to_peer_construct (NETSUKUKU_TYPE_PEER_TO_PEER, aggregated_neighbour_manager, maproute, pid);
}


static zcdISerializable* netsukuku_peer_to_peer_real__dispatch (NetsukukuPeerToPeer* self, GObject* caller, zcdRemoteCall* data, GError** error) {
	zcdISerializable* result = NULL;
	g_return_val_if_fail (data != NULL, NULL);
	result = NULL;
	return result;
}


zcdISerializable* _netsukuku_peer_to_peer_dispatch (NetsukukuPeerToPeer* self, GObject* caller, zcdRemoteCall* data, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return NETSUKUKU_PEER_TO_PEER_GET_CLASS (self)->_dispatch (self, caller, data, error);
}


static NetsukukuNIP* netsukuku_peer_to_peer_real_h (NetsukukuPeerToPeer* self, GObject* key) {
	NetsukukuNIP* result = NULL;
	GObject* _tmp0_;
	NetsukukuNIP* _tmp1_;
	g_return_val_if_fail (key != NULL, NULL);
	_vala_assert (FALSE, "false");
	_tmp0_ = key;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, NETSUKUKU_TYPE_NIP, NetsukukuNIP));
	result = _tmp1_;
	return result;
}


NetsukukuNIP* netsukuku_peer_to_peer_h (NetsukukuPeerToPeer* self, GObject* key) {
	g_return_val_if_fail (self != NULL, NULL);
	return NETSUKUKU_PEER_TO_PEER_GET_CLASS (self)->h (self, key);
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


GeeList* netsukuku_peer_to_peer_list_ids (NetsukukuPeerToPeer* self, gint center, gint sign) {
	GeeList* result = NULL;
	NetsukukuMapRoute* _tmp0_;
	NetsukukuNIP* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gint _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	gint _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	NetsukukuMapRoute* _tmp14_;
	gint _tmp15_;
	GeeArrayList* _tmp16_ = NULL;
	GeeArrayList* ret;
	gchar* _tmp17_;
	gchar* strret;
	NetsukukuMapRoute* _tmp36_;
	NetsukukuNIP* _tmp37_;
	gchar* _tmp38_ = NULL;
	gchar* _tmp39_;
	const gchar* _tmp40_;
	const gchar* _tmp41_ = NULL;
	gchar* _tmp42_ = NULL;
	gchar* _tmp43_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->maproute;
	_tmp1_ = _tmp0_->me;
	_tmp2_ = netsukuku_partial_nip_to_string ((NetsukukuPartialNIP*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = center;
	_tmp5_ = g_strdup_printf ("%i", _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = sign;
	_tmp8_ = g_strdup_printf ("%i", _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat ("[", _tmp3_, "]: list_ids(center ", _tmp6_, ", sign ", _tmp9_, ")\n", NULL);
	_tmp11_ = _tmp10_;
	ntk_test_print_out (_tmp11_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp3_);
	_tmp12_ = center;
	_tmp13_ = sign;
	_tmp14_ = self->maproute;
	_tmp15_ = _tmp14_->gsize;
	_tmp16_ = ntk_test_list_positions (_tmp12_, _tmp13_, _tmp15_);
	ret = _tmp16_;
	_tmp17_ = g_strdup ("");
	strret = _tmp17_;
	{
		GeeArrayList* _tmp18_;
		GeeArrayList* _tmp19_;
		GeeArrayList* _r_list;
		GeeArrayList* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		gint _r_size;
		gint _r_index;
		_tmp18_ = ret;
		_tmp19_ = _g_object_ref0 (_tmp18_);
		_r_list = _tmp19_;
		_tmp20_ = _r_list;
		_tmp21_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp20_);
		_tmp22_ = _tmp21_;
		_r_size = _tmp22_;
		_r_index = -1;
		while (TRUE) {
			gint _tmp23_;
			gint _tmp24_;
			gint _tmp25_;
			GeeArrayList* _tmp26_;
			gint _tmp27_;
			gpointer _tmp28_ = NULL;
			gint r;
			const gchar* _tmp29_;
			gint _tmp30_;
			gchar* _tmp31_ = NULL;
			gchar* _tmp32_;
			gchar* _tmp33_ = NULL;
			gchar* _tmp34_;
			gchar* _tmp35_;
			_tmp23_ = _r_index;
			_r_index = _tmp23_ + 1;
			_tmp24_ = _r_index;
			_tmp25_ = _r_size;
			if (!(_tmp24_ < _tmp25_)) {
				break;
			}
			_tmp26_ = _r_list;
			_tmp27_ = _r_index;
			_tmp28_ = gee_abstract_list_get ((GeeAbstractList*) _tmp26_, _tmp27_);
			r = (gint) ((gintptr) _tmp28_);
			_tmp29_ = strret;
			_tmp30_ = r;
			_tmp31_ = g_strdup_printf ("%i", _tmp30_);
			_tmp32_ = _tmp31_;
			_tmp33_ = g_strconcat (" ", _tmp32_, " ", NULL);
			_tmp34_ = _tmp33_;
			_tmp35_ = g_strconcat (_tmp29_, _tmp34_, NULL);
			_g_free0 (strret);
			strret = _tmp35_;
			_g_free0 (_tmp34_);
			_g_free0 (_tmp32_);
		}
		_g_object_unref0 (_r_list);
	}
	_tmp36_ = self->maproute;
	_tmp37_ = _tmp36_->me;
	_tmp38_ = netsukuku_partial_nip_to_string ((NetsukukuPartialNIP*) _tmp37_);
	_tmp39_ = _tmp38_;
	_tmp40_ = strret;
	_tmp41_ = string_to_string (_tmp40_);
	_tmp42_ = g_strconcat ("[", _tmp39_, "]: list_ids = ", _tmp41_, "\n", NULL);
	_tmp43_ = _tmp42_;
	ntk_test_print_out (_tmp43_);
	_g_free0 (_tmp43_);
	_g_free0 (_tmp39_);
	result = (GeeList*) ret;
	_g_free0 (strret);
	return result;
}


static gint* _int_dup (gint* self) {
	gint* dup;
	dup = g_new0 (gint, 1);
	memcpy (dup, self, sizeof (gint));
	return dup;
}


static gpointer __int_dup0 (gpointer self) {
	return self ? _int_dup (self) : NULL;
}


void netsukuku_peer_to_peer_find_hook_peers (NetsukukuPeerToPeer* self, gint** ret_first_forward, gint** ret_first_back, gint** ret_last_back, gint lvl, gint num_dupl, gint timeout) {
	gint* _vala_ret_first_forward = NULL;
	gint* _vala_ret_first_back = NULL;
	gint* _vala_ret_last_back = NULL;
	NetsukukuMapRoute* _tmp0_;
	NetsukukuNIP* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gint _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	gint _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	NetsukukuMapRoute* _tmp12_;
	NetsukukuNIP* _tmp13_;
	gint _tmp14_;
	gint _tmp15_ = 0;
	GeeList* _tmp16_ = NULL;
	GeeList* ids_me_forward;
	GeeList* _tmp17_;
	gint* _tmp36_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->maproute;
	_tmp1_ = _tmp0_->me;
	_tmp2_ = netsukuku_partial_nip_to_string ((NetsukukuPartialNIP*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = lvl;
	_tmp5_ = g_strdup_printf ("%i", _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = num_dupl;
	_tmp8_ = g_strdup_printf ("%i", _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat ("[", _tmp3_, "]: find_hook_peers(lvl ", _tmp6_, ", num_dupl ", _tmp9_, ")\n", NULL);
	_tmp11_ = _tmp10_;
	ntk_test_print_out (_tmp11_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp3_);
	_g_free0 (_vala_ret_first_forward);
	_vala_ret_first_forward = NULL;
	_g_free0 (_vala_ret_first_back);
	_vala_ret_first_back = NULL;
	_g_free0 (_vala_ret_last_back);
	_vala_ret_last_back = NULL;
	_tmp12_ = self->maproute;
	_tmp13_ = _tmp12_->me;
	_tmp14_ = lvl;
	_tmp15_ = netsukuku_partial_nip_position_at ((NetsukukuPartialNIP*) _tmp13_, _tmp14_);
	_tmp16_ = netsukuku_peer_to_peer_list_ids (self, _tmp15_, 1);
	ids_me_forward = _tmp16_;
	_tmp17_ = ids_me_forward;
	gee_list_remove_at (_tmp17_, 0);
	{
		GeeList* _tmp18_;
		GeeList* _tmp19_;
		GeeList* __id_list;
		GeeList* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		gint __id_size;
		gint __id_index;
		_tmp18_ = ids_me_forward;
		_tmp19_ = _g_object_ref0 (_tmp18_);
		__id_list = _tmp19_;
		_tmp20_ = __id_list;
		_tmp21_ = gee_collection_get_size ((GeeCollection*) _tmp20_);
		_tmp22_ = _tmp21_;
		__id_size = _tmp22_;
		__id_index = -1;
		while (TRUE) {
			gint _tmp23_;
			gint _tmp24_;
			gint _tmp25_;
			GeeList* _tmp26_;
			gint _tmp27_;
			gpointer _tmp28_ = NULL;
			gint _id;
			gint num;
			gint _tmp33_;
			_tmp23_ = __id_index;
			__id_index = _tmp23_ + 1;
			_tmp24_ = __id_index;
			_tmp25_ = __id_size;
			if (!(_tmp24_ < _tmp25_)) {
				break;
			}
			_tmp26_ = __id_list;
			_tmp27_ = __id_index;
			_tmp28_ = gee_list_get (_tmp26_, _tmp27_);
			_id = (gint) ((gintptr) _tmp28_);
			num = 0;
			{
				gint _tmp29_;
				gint _tmp30_;
				gint _tmp31_;
				gint _tmp32_ = 0;
				_tmp29_ = lvl;
				_tmp30_ = _id;
				_tmp31_ = timeout;
				_tmp32_ = netsukuku_peer_to_peer_get_number_of_participants (self, _tmp29_, _tmp30_, _tmp31_);
				num = _tmp32_;
			}
			goto __finally0;
			__catch0_zcd_rpc_error:
			{
				GError* e = NULL;
				e = _inner_error_;
				_inner_error_ = NULL;
				_g_error_free0 (e);
			}
			__finally0:
			if (_inner_error_ != NULL) {
				_g_object_unref0 (__id_list);
				_g_object_unref0 (ids_me_forward);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_tmp33_ = num;
			if (_tmp33_ > 0) {
				gint _tmp34_;
				gint* _tmp35_;
				_tmp34_ = _id;
				_tmp35_ = __int_dup0 (&_tmp34_);
				_g_free0 (_vala_ret_first_forward);
				_vala_ret_first_forward = _tmp35_;
				break;
			}
		}
		_g_object_unref0 (__id_list);
	}
	_tmp36_ = _vala_ret_first_forward;
	if (_tmp36_ != NULL) {
		NetsukukuMapRoute* _tmp37_;
		NetsukukuNIP* _tmp38_;
		gint _tmp39_;
		gint _tmp40_ = 0;
		GeeList* _tmp41_ = NULL;
		GeeList* ids_me_back;
		GeeList* _tmp42_;
		gint _tmp43_;
		gint remaining;
		gint _tmp70_;
		_tmp37_ = self->maproute;
		_tmp38_ = _tmp37_->me;
		_tmp39_ = lvl;
		_tmp40_ = netsukuku_partial_nip_position_at ((NetsukukuPartialNIP*) _tmp38_, _tmp39_);
		_tmp41_ = netsukuku_peer_to_peer_list_ids (self, _tmp40_, -1);
		ids_me_back = _tmp41_;
		_tmp42_ = ids_me_back;
		gee_list_remove_at (_tmp42_, 0);
		_tmp43_ = num_dupl;
		remaining = _tmp43_;
		{
			GeeList* _tmp44_;
			GeeList* _tmp45_;
			GeeList* __id_list;
			GeeList* _tmp46_;
			gint _tmp47_;
			gint _tmp48_;
			gint __id_size;
			gint __id_index;
			_tmp44_ = ids_me_back;
			_tmp45_ = _g_object_ref0 (_tmp44_);
			__id_list = _tmp45_;
			_tmp46_ = __id_list;
			_tmp47_ = gee_collection_get_size ((GeeCollection*) _tmp46_);
			_tmp48_ = _tmp47_;
			__id_size = _tmp48_;
			__id_index = -1;
			while (TRUE) {
				gint _tmp49_;
				gint _tmp50_;
				gint _tmp51_;
				GeeList* _tmp52_;
				gint _tmp53_;
				gpointer _tmp54_ = NULL;
				gint _id;
				gint num;
				gboolean _tmp59_ = FALSE;
				gint _tmp60_;
				gboolean _tmp62_;
				gint _tmp65_;
				gint _tmp66_;
				gint _tmp67_;
				_tmp49_ = __id_index;
				__id_index = _tmp49_ + 1;
				_tmp50_ = __id_index;
				_tmp51_ = __id_size;
				if (!(_tmp50_ < _tmp51_)) {
					break;
				}
				_tmp52_ = __id_list;
				_tmp53_ = __id_index;
				_tmp54_ = gee_list_get (_tmp52_, _tmp53_);
				_id = (gint) ((gintptr) _tmp54_);
				num = 0;
				{
					gint _tmp55_;
					gint _tmp56_;
					gint _tmp57_;
					gint _tmp58_ = 0;
					_tmp55_ = lvl;
					_tmp56_ = _id;
					_tmp57_ = timeout;
					_tmp58_ = netsukuku_peer_to_peer_get_number_of_participants (self, _tmp55_, _tmp56_, _tmp57_);
					num = _tmp58_;
				}
				goto __finally1;
				__catch1_zcd_rpc_error:
				{
					GError* e = NULL;
					e = _inner_error_;
					_inner_error_ = NULL;
					_g_error_free0 (e);
				}
				__finally1:
				if (_inner_error_ != NULL) {
					_g_object_unref0 (__id_list);
					_g_object_unref0 (ids_me_back);
					_g_object_unref0 (ids_me_forward);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_tmp60_ = num;
				if (_tmp60_ > 0) {
					gint* _tmp61_;
					_tmp61_ = _vala_ret_first_back;
					_tmp59_ = _tmp61_ == NULL;
				} else {
					_tmp59_ = FALSE;
				}
				_tmp62_ = _tmp59_;
				if (_tmp62_) {
					gint _tmp63_;
					gint* _tmp64_;
					_tmp63_ = _id;
					_tmp64_ = __int_dup0 (&_tmp63_);
					_g_free0 (_vala_ret_first_back);
					_vala_ret_first_back = _tmp64_;
				}
				_tmp65_ = remaining;
				_tmp66_ = num;
				remaining = _tmp65_ - _tmp66_;
				_tmp67_ = remaining;
				if (_tmp67_ <= 0) {
					gint _tmp68_;
					gint* _tmp69_;
					_tmp68_ = _id;
					_tmp69_ = __int_dup0 (&_tmp68_);
					_g_free0 (_vala_ret_last_back);
					_vala_ret_last_back = _tmp69_;
					break;
				}
			}
			_g_object_unref0 (__id_list);
		}
		_tmp70_ = remaining;
		if (_tmp70_ > 0) {
			_g_free0 (_vala_ret_first_back);
			_vala_ret_first_back = NULL;
		}
		_g_object_unref0 (ids_me_back);
	}
	_g_object_unref0 (ids_me_forward);
	if (ret_first_forward) {
		*ret_first_forward = _vala_ret_first_forward;
	} else {
		_g_free0 (_vala_ret_first_forward);
	}
	if (ret_first_back) {
		*ret_first_back = _vala_ret_first_back;
	} else {
		_g_free0 (_vala_ret_first_back);
	}
	if (ret_last_back) {
		*ret_last_back = _vala_ret_last_back;
	} else {
		_g_free0 (_vala_ret_last_back);
	}
}


gint netsukuku_peer_to_peer_get_number_of_participants (NetsukukuPeerToPeer* self, gint lvl, gint pos, gint timeout) {
	gint result = 0;
	NetsukukuMapRoute* _tmp0_;
	NetsukukuNIP* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gint _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	gint _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	gint ret;
	NetsukukuMapRoute* _tmp37_;
	NetsukukuNIP* _tmp38_;
	gchar* _tmp39_ = NULL;
	gchar* _tmp40_;
	gint _tmp41_;
	gchar* _tmp42_ = NULL;
	gchar* _tmp43_;
	gchar* _tmp44_ = NULL;
	gchar* _tmp45_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->maproute;
	_tmp1_ = _tmp0_->me;
	_tmp2_ = netsukuku_partial_nip_to_string ((NetsukukuPartialNIP*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = lvl;
	_tmp5_ = g_strdup_printf ("%i", _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = pos;
	_tmp8_ = g_strdup_printf ("%i", _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat ("[", _tmp3_, "]: get_number_of_participants(lvl ", _tmp6_, ", pos ", _tmp9_, ")\n", NULL);
	_tmp11_ = _tmp10_;
	ntk_test_print_out (_tmp11_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp3_);
	ret = 0;
	{
		GeeHashMap* _tmp12_;
		GeeSet* _tmp13_;
		GeeSet* _tmp14_;
		GeeSet* _tmp15_;
		GeeIterator* _tmp16_ = NULL;
		GeeIterator* _tmp17_;
		GeeIterator* _n_it;
		_tmp12_ = ntk_test_nodes;
		_tmp13_ = gee_abstract_map_get_keys ((GeeMap*) _tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = _tmp14_;
		_tmp16_ = gee_iterable_iterator ((GeeIterable*) _tmp15_);
		_tmp17_ = _tmp16_;
		_g_object_unref0 (_tmp15_);
		_n_it = _tmp17_;
		while (TRUE) {
			GeeIterator* _tmp18_;
			gboolean _tmp19_ = FALSE;
			GeeIterator* _tmp20_;
			gpointer _tmp21_ = NULL;
			NetsukukuNIP* n;
			NetsukukuNIP* _tmp22_;
			NetsukukuMapRoute* _tmp23_;
			NetsukukuNIP* _tmp24_;
			NetsukukuHCoord* _tmp25_ = NULL;
			NetsukukuHCoord* hcn;
			gboolean _tmp26_ = FALSE;
			NetsukukuHCoord* _tmp27_;
			gint _tmp28_;
			gint _tmp29_;
			gint _tmp30_;
			gboolean _tmp35_;
			_tmp18_ = _n_it;
			_tmp19_ = gee_iterator_next (_tmp18_);
			if (!_tmp19_) {
				break;
			}
			_tmp20_ = _n_it;
			_tmp21_ = gee_iterator_get (_tmp20_);
			n = (NetsukukuNIP*) _tmp21_;
			_tmp22_ = n;
			_tmp23_ = self->maproute;
			_tmp24_ = _tmp23_->me;
			_tmp25_ = netsukuku_partial_nip_get_hcoord_relative_to ((NetsukukuPartialNIP*) _tmp22_, _tmp24_);
			hcn = _tmp25_;
			_tmp27_ = hcn;
			_tmp28_ = netsukuku_hcoord_get_lvl (_tmp27_);
			_tmp29_ = _tmp28_;
			_tmp30_ = lvl;
			if (_tmp29_ == _tmp30_) {
				NetsukukuHCoord* _tmp31_;
				gint _tmp32_;
				gint _tmp33_;
				gint _tmp34_;
				_tmp31_ = hcn;
				_tmp32_ = netsukuku_hcoord_get_pos (_tmp31_);
				_tmp33_ = _tmp32_;
				_tmp34_ = pos;
				_tmp26_ = _tmp33_ == _tmp34_;
			} else {
				_tmp26_ = FALSE;
			}
			_tmp35_ = _tmp26_;
			if (_tmp35_) {
				gint _tmp36_;
				_tmp36_ = ret;
				ret = _tmp36_ + 1;
			}
			_g_object_unref0 (hcn);
			_g_object_unref0 (n);
		}
		_g_object_unref0 (_n_it);
	}
	_tmp37_ = self->maproute;
	_tmp38_ = _tmp37_->me;
	_tmp39_ = netsukuku_partial_nip_to_string ((NetsukukuPartialNIP*) _tmp38_);
	_tmp40_ = _tmp39_;
	_tmp41_ = ret;
	_tmp42_ = g_strdup_printf ("%i", _tmp41_);
	_tmp43_ = _tmp42_;
	_tmp44_ = g_strconcat ("[", _tmp40_, "]:   ", _tmp43_, "\n", NULL);
	_tmp45_ = _tmp44_;
	ntk_test_print_out (_tmp45_);
	_g_free0 (_tmp45_);
	_g_free0 (_tmp43_);
	_g_free0 (_tmp40_);
	result = ret;
	return result;
}


static gboolean _netsukuku_partial_nip_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gboolean result;
	result = netsukuku_partial_nip_equal_func (a, b);
	return result;
}


GeeList* netsukuku_peer_to_peer_find_nearest_to_register (NetsukukuPeerToPeer* self, NetsukukuNIP* hash_nip, gint num_dupl) {
	GeeList* result = NULL;
	NetsukukuMapRoute* _tmp0_;
	NetsukukuNIP* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	NetsukukuNIP* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	gint _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	GeeArrayList* _tmp12_;
	GeeArrayList* ret;
	NetsukukuMapRoute* _tmp13_;
	gint _tmp14_;
	NetsukukuMapRoute* _tmp15_;
	gint _tmp16_;
	NetsukukuNIP* _tmp17_;
	GeeArrayList* _tmp18_ = NULL;
	GeeArrayList* lst;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (hash_nip != NULL, NULL);
	_tmp0_ = self->maproute;
	_tmp1_ = _tmp0_->me;
	_tmp2_ = netsukuku_partial_nip_to_string ((NetsukukuPartialNIP*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = hash_nip;
	_tmp5_ = netsukuku_partial_nip_to_string ((NetsukukuPartialNIP*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = num_dupl;
	_tmp8_ = g_strdup_printf ("%i", _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat ("[", _tmp3_, "]: find_nearest_to_register(hash_nip ", _tmp6_, ", num_dupl ", _tmp9_, ")\n", NULL);
	_tmp11_ = _tmp10_;
	ntk_test_print_out (_tmp11_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp3_);
	_tmp12_ = gee_array_list_new (NETSUKUKU_TYPE_NIP, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_partial_nip_equal_func_gee_equal_data_func, NULL, NULL);
	ret = _tmp12_;
	_tmp13_ = self->maproute;
	_tmp14_ = _tmp13_->levels;
	_tmp15_ = self->maproute;
	_tmp16_ = _tmp15_->gsize;
	_tmp17_ = hash_nip;
	_tmp18_ = ntk_test_ordered_lookup (_tmp14_, _tmp16_, _tmp17_, 1);
	lst = _tmp18_;
	{
		GeeArrayList* _tmp19_;
		GeeArrayList* _tmp20_;
		GeeArrayList* _s_list;
		GeeArrayList* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gint _s_size;
		gint _s_index;
		_tmp19_ = lst;
		_tmp20_ = _g_object_ref0 (_tmp19_);
		_s_list = _tmp20_;
		_tmp21_ = _s_list;
		_tmp22_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp21_);
		_tmp23_ = _tmp22_;
		_s_size = _tmp23_;
		_s_index = -1;
		while (TRUE) {
			gint _tmp24_;
			gint _tmp25_;
			gint _tmp26_;
			GeeArrayList* _tmp27_;
			gint _tmp28_;
			gpointer _tmp29_ = NULL;
			NetsukukuNIP* s;
			GeeHashMap* _tmp30_;
			NetsukukuNIP* _tmp31_;
			gboolean _tmp32_ = FALSE;
			GeeArrayList* _tmp35_;
			gint _tmp36_;
			gint _tmp37_;
			gint _tmp38_;
			_tmp24_ = _s_index;
			_s_index = _tmp24_ + 1;
			_tmp25_ = _s_index;
			_tmp26_ = _s_size;
			if (!(_tmp25_ < _tmp26_)) {
				break;
			}
			_tmp27_ = _s_list;
			_tmp28_ = _s_index;
			_tmp29_ = gee_abstract_list_get ((GeeAbstractList*) _tmp27_, _tmp28_);
			s = (NetsukukuNIP*) _tmp29_;
			_tmp30_ = ntk_test_nodes;
			_tmp31_ = s;
			_tmp32_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp30_, _tmp31_);
			if (_tmp32_) {
				GeeArrayList* _tmp33_;
				NetsukukuNIP* _tmp34_;
				_tmp33_ = ret;
				_tmp34_ = s;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp33_, _tmp34_);
			}
			_tmp35_ = ret;
			_tmp36_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp35_);
			_tmp37_ = _tmp36_;
			_tmp38_ = num_dupl;
			if (_tmp37_ >= _tmp38_) {
				_g_object_unref0 (s);
				break;
			}
			_g_object_unref0 (s);
		}
		_g_object_unref0 (_s_list);
	}
	{
		GeeArrayList* _tmp39_;
		GeeArrayList* _tmp40_;
		GeeArrayList* _s_list;
		GeeArrayList* _tmp41_;
		gint _tmp42_;
		gint _tmp43_;
		gint _s_size;
		gint _s_index;
		_tmp39_ = ret;
		_tmp40_ = _g_object_ref0 (_tmp39_);
		_s_list = _tmp40_;
		_tmp41_ = _s_list;
		_tmp42_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp41_);
		_tmp43_ = _tmp42_;
		_s_size = _tmp43_;
		_s_index = -1;
		while (TRUE) {
			gint _tmp44_;
			gint _tmp45_;
			gint _tmp46_;
			GeeArrayList* _tmp47_;
			gint _tmp48_;
			gpointer _tmp49_ = NULL;
			NetsukukuNIP* s;
			NetsukukuMapRoute* _tmp50_;
			NetsukukuNIP* _tmp51_;
			gchar* _tmp52_ = NULL;
			gchar* _tmp53_;
			NetsukukuNIP* _tmp54_;
			gchar* _tmp55_ = NULL;
			gchar* _tmp56_;
			gchar* _tmp57_ = NULL;
			gchar* _tmp58_;
			_tmp44_ = _s_index;
			_s_index = _tmp44_ + 1;
			_tmp45_ = _s_index;
			_tmp46_ = _s_size;
			if (!(_tmp45_ < _tmp46_)) {
				break;
			}
			_tmp47_ = _s_list;
			_tmp48_ = _s_index;
			_tmp49_ = gee_abstract_list_get ((GeeAbstractList*) _tmp47_, _tmp48_);
			s = (NetsukukuNIP*) _tmp49_;
			_tmp50_ = self->maproute;
			_tmp51_ = _tmp50_->me;
			_tmp52_ = netsukuku_partial_nip_to_string ((NetsukukuPartialNIP*) _tmp51_);
			_tmp53_ = _tmp52_;
			_tmp54_ = s;
			_tmp55_ = netsukuku_partial_nip_to_string ((NetsukukuPartialNIP*) _tmp54_);
			_tmp56_ = _tmp55_;
			_tmp57_ = g_strconcat ("[", _tmp53_, "]:   ", _tmp56_, "\n", NULL);
			_tmp58_ = _tmp57_;
			ntk_test_print_out (_tmp58_);
			_g_free0 (_tmp58_);
			_g_free0 (_tmp56_);
			_g_free0 (_tmp53_);
			_g_object_unref0 (s);
		}
		_g_object_unref0 (_s_list);
	}
	result = (GeeList*) ret;
	_g_object_unref0 (lst);
	return result;
}


NetsukukuHCoord* netsukuku_peer_to_peer_search_participant (NetsukukuPeerToPeer* self, NetsukukuNIP* hIP, gint path_sign, GError** error) {
	NetsukukuHCoord* result = NULL;
	NetsukukuMapRoute* _tmp0_;
	NetsukukuNIP* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	NetsukukuNIP* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	gint _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	NetsukukuMapRoute* _tmp12_;
	gint _tmp13_;
	NetsukukuMapRoute* _tmp14_;
	gint _tmp15_;
	NetsukukuNIP* _tmp16_;
	gint _tmp17_;
	NetsukukuNIP* _tmp18_ = NULL;
	NetsukukuNIP* first;
	NetsukukuNIP* _tmp19_;
	NetsukukuNIP* _tmp35_;
	NetsukukuNIP* _tmp37_;
	NetsukukuMapRoute* _tmp38_;
	NetsukukuNIP* _tmp39_;
	gboolean _tmp40_ = FALSE;
	NetsukukuNIP* _tmp41_;
	NetsukukuMapRoute* _tmp42_;
	NetsukukuNIP* _tmp43_;
	NetsukukuHCoord* _tmp44_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (hIP != NULL, NULL);
	_tmp0_ = self->maproute;
	_tmp1_ = _tmp0_->me;
	_tmp2_ = netsukuku_partial_nip_to_string ((NetsukukuPartialNIP*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = hIP;
	_tmp5_ = netsukuku_partial_nip_to_string ((NetsukukuPartialNIP*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = path_sign;
	_tmp8_ = g_strdup_printf ("%i", _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat ("[", _tmp3_, "]: search_participant(hIP ", _tmp6_, ", path_sign ", _tmp9_, ")\n", NULL);
	_tmp11_ = _tmp10_;
	ntk_test_print_out (_tmp11_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp3_);
	_tmp12_ = self->maproute;
	_tmp13_ = _tmp12_->levels;
	_tmp14_ = self->maproute;
	_tmp15_ = _tmp14_->gsize;
	_tmp16_ = hIP;
	_tmp17_ = path_sign;
	_tmp18_ = ntk_test_best_approximation_nip (_tmp13_, _tmp15_, _tmp16_, _tmp17_);
	first = _tmp18_;
	_tmp19_ = first;
	if (_tmp19_ == NULL) {
		NetsukukuMapRoute* _tmp20_;
		NetsukukuNIP* _tmp21_;
		gchar* _tmp22_ = NULL;
		gchar* _tmp23_;
		gchar* _tmp24_ = NULL;
		gchar* _tmp25_;
		_tmp20_ = self->maproute;
		_tmp21_ = _tmp20_->me;
		_tmp22_ = netsukuku_partial_nip_to_string ((NetsukukuPartialNIP*) _tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = g_strconcat ("[", _tmp23_, "]: search_participant: first null\n", NULL);
		_tmp25_ = _tmp24_;
		ntk_test_print_out (_tmp25_);
		_g_free0 (_tmp25_);
		_g_free0 (_tmp23_);
	} else {
		NetsukukuMapRoute* _tmp26_;
		NetsukukuNIP* _tmp27_;
		gchar* _tmp28_ = NULL;
		gchar* _tmp29_;
		NetsukukuNIP* _tmp30_;
		gchar* _tmp31_ = NULL;
		gchar* _tmp32_;
		gchar* _tmp33_ = NULL;
		gchar* _tmp34_;
		_tmp26_ = self->maproute;
		_tmp27_ = _tmp26_->me;
		_tmp28_ = netsukuku_partial_nip_to_string ((NetsukukuPartialNIP*) _tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = first;
		_tmp31_ = netsukuku_partial_nip_to_string ((NetsukukuPartialNIP*) _tmp30_);
		_tmp32_ = _tmp31_;
		_tmp33_ = g_strconcat ("[", _tmp29_, "]: search_participant: first ", _tmp32_, "\n", NULL);
		_tmp34_ = _tmp33_;
		ntk_test_print_out (_tmp34_);
		_g_free0 (_tmp34_);
		_g_free0 (_tmp32_);
		_g_free0 (_tmp29_);
	}
	_tmp35_ = first;
	if (_tmp35_ == NULL) {
		GError* _tmp36_;
		_tmp36_ = g_error_new_literal (NETSUKUKU_PEER_TO_PEER_ERROR, NETSUKUKU_PEER_TO_PEER_ERROR_GENERIC, "No participants.");
		_inner_error_ = _tmp36_;
		if (_inner_error_->domain == NETSUKUKU_PEER_TO_PEER_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (first);
			return NULL;
		} else {
			_g_object_unref0 (first);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp37_ = first;
	_tmp38_ = self->maproute;
	_tmp39_ = _tmp38_->me;
	_tmp40_ = netsukuku_partial_nip_is_equal ((NetsukukuPartialNIP*) _tmp37_, (NetsukukuPartialNIP*) _tmp39_);
	if (_tmp40_) {
		result = NULL;
		_g_object_unref0 (first);
		return result;
	}
	_tmp41_ = first;
	_tmp42_ = self->maproute;
	_tmp43_ = _tmp42_->me;
	_tmp44_ = netsukuku_partial_nip_get_hcoord_relative_to ((NetsukukuPartialNIP*) _tmp41_, _tmp43_);
	result = _tmp44_;
	_g_object_unref0 (first);
	return result;
}


NetsukukuPartialNIP* netsukuku_peer_to_peer_search_participant_as_nip (NetsukukuPeerToPeer* self, NetsukukuNIP* hIP, gint path_sign, GError** error) {
	NetsukukuPartialNIP* result = NULL;
	NetsukukuMapRoute* _tmp0_;
	NetsukukuNIP* _tmp1_;
	gint _tmp2_ = 0;
	gint* _tmp3_ = NULL;
	gint* positions;
	gint positions_length1;
	gint _positions_size_;
	NetsukukuNIP* _tmp4_;
	gint _tmp5_;
	NetsukukuHCoord* _tmp6_ = NULL;
	NetsukukuHCoord* lvlpos;
	NetsukukuPartialNIP* _tmp21_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (hIP != NULL, NULL);
	_tmp0_ = self->maproute;
	_tmp1_ = _tmp0_->me;
	_tmp3_ = netsukuku_partial_nip_get_positions ((NetsukukuPartialNIP*) _tmp1_, &_tmp2_);
	positions = _tmp3_;
	positions_length1 = _tmp2_;
	_positions_size_ = positions_length1;
	_tmp4_ = hIP;
	_tmp5_ = path_sign;
	_tmp6_ = netsukuku_peer_to_peer_search_participant (self, _tmp4_, _tmp5_, &_inner_error_);
	lvlpos = _tmp6_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == NETSUKUKU_PEER_TO_PEER_ERROR) {
			g_propagate_error (error, _inner_error_);
			positions = (g_free (positions), NULL);
			return NULL;
		} else {
			positions = (g_free (positions), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	if (lvlpos != NULL) {
		gint _tmp7_;
		gint _tmp8_;
		gint lvl;
		gint _tmp9_;
		gint _tmp10_;
		gint pos;
		gint _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		_tmp7_ = netsukuku_hcoord_get_lvl (lvlpos);
		_tmp8_ = _tmp7_;
		lvl = _tmp8_;
		_tmp9_ = netsukuku_hcoord_get_pos (lvlpos);
		_tmp10_ = _tmp9_;
		pos = _tmp10_;
		_tmp11_ = lvl;
		_tmp12_ = pos;
		positions[_tmp11_] = _tmp12_;
		_tmp13_ = positions[_tmp11_];
		{
			gint _tmp14_;
			gint i;
			_tmp14_ = lvl;
			i = _tmp14_ - 1;
			{
				gboolean _tmp15_;
				_tmp15_ = TRUE;
				while (TRUE) {
					gboolean _tmp16_;
					gint _tmp18_;
					gint _tmp19_;
					gint _tmp20_;
					_tmp16_ = _tmp15_;
					if (!_tmp16_) {
						gint _tmp17_;
						_tmp17_ = i;
						i = _tmp17_ - 1;
					}
					_tmp15_ = FALSE;
					_tmp18_ = i;
					if (!(_tmp18_ >= 0)) {
						break;
					}
					_tmp19_ = i;
					positions[_tmp19_] = -1;
					_tmp20_ = positions[_tmp19_];
				}
			}
		}
	}
	_tmp21_ = netsukuku_partial_nip_new (positions, positions_length1);
	result = _tmp21_;
	_g_object_unref0 (lvlpos);
	positions = (g_free (positions), NULL);
	return result;
}


gboolean netsukuku_peer_to_peer_get_participant (NetsukukuPeerToPeer* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = TRUE;
	return result;
}


static void netsukuku_peer_to_peer_class_init (NetsukukuPeerToPeerClass * klass) {
	netsukuku_peer_to_peer_parent_class = g_type_class_peek_parent (klass);
	NETSUKUKU_PEER_TO_PEER_CLASS (klass)->_dispatch = netsukuku_peer_to_peer_real__dispatch;
	NETSUKUKU_PEER_TO_PEER_CLASS (klass)->h = netsukuku_peer_to_peer_real_h;
	G_OBJECT_CLASS (klass)->get_property = _vala_netsukuku_peer_to_peer_get_property;
	G_OBJECT_CLASS (klass)->finalize = netsukuku_peer_to_peer_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETSUKUKU_PEER_TO_PEER_PARTICIPANT, g_param_spec_boolean ("participant", "participant", "participant", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("map_peer_to_peer_validated", NETSUKUKU_TYPE_PEER_TO_PEER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void netsukuku_peer_to_peer_instance_init (NetsukukuPeerToPeer * self) {
}


static void netsukuku_peer_to_peer_finalize (GObject* obj) {
	NetsukukuPeerToPeer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_PEER_TO_PEER, NetsukukuPeerToPeer);
	_g_object_unref0 (self->maproute);
	G_OBJECT_CLASS (netsukuku_peer_to_peer_parent_class)->finalize (obj);
}


GType netsukuku_peer_to_peer_get_type (void) {
	static volatile gsize netsukuku_peer_to_peer_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_peer_to_peer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuPeerToPeerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_peer_to_peer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuPeerToPeer), 0, (GInstanceInitFunc) netsukuku_peer_to_peer_instance_init, NULL };
		GType netsukuku_peer_to_peer_type_id;
		netsukuku_peer_to_peer_type_id = g_type_register_static (G_TYPE_OBJECT, "NetsukukuPeerToPeer", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_peer_to_peer_type_id__volatile, netsukuku_peer_to_peer_type_id);
	}
	return netsukuku_peer_to_peer_type_id__volatile;
}


static void _vala_netsukuku_peer_to_peer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	NetsukukuPeerToPeer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETSUKUKU_TYPE_PEER_TO_PEER, NetsukukuPeerToPeer);
	switch (property_id) {
		case NETSUKUKU_PEER_TO_PEER_PARTICIPANT:
		g_value_set_boolean (value, netsukuku_peer_to_peer_get_participant (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


NetsukukuOptionalPeerToPeer* netsukuku_optional_peer_to_peer_construct (GType object_type, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, gint pid) {
	NetsukukuOptionalPeerToPeer * self = NULL;
	NetsukukuAggregatedNeighbourManager* _tmp0_;
	NetsukukuMapRoute* _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (aggregated_neighbour_manager != NULL, NULL);
	g_return_val_if_fail (maproute != NULL, NULL);
	_tmp0_ = aggregated_neighbour_manager;
	_tmp1_ = maproute;
	_tmp2_ = pid;
	self = (NetsukukuOptionalPeerToPeer*) netsukuku_peer_to_peer_construct (object_type, _tmp0_, _tmp1_, _tmp2_);
	return self;
}


NetsukukuOptionalPeerToPeer* netsukuku_optional_peer_to_peer_new (NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, gint pid) {
	return netsukuku_optional_peer_to_peer_construct (NETSUKUKU_TYPE_OPTIONAL_PEER_TO_PEER, aggregated_neighbour_manager, maproute, pid);
}


void netsukuku_optional_peer_to_peer_participate (NetsukukuOptionalPeerToPeer* self) {
	g_return_if_fail (self != NULL);
	self->hooked = TRUE;
}


static void netsukuku_optional_peer_to_peer_class_init (NetsukukuOptionalPeerToPeerClass * klass) {
	netsukuku_optional_peer_to_peer_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = netsukuku_optional_peer_to_peer_finalize;
}


static void netsukuku_optional_peer_to_peer_instance_init (NetsukukuOptionalPeerToPeer * self) {
	self->hooked = FALSE;
}


static void netsukuku_optional_peer_to_peer_finalize (GObject* obj) {
	NetsukukuOptionalPeerToPeer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_OPTIONAL_PEER_TO_PEER, NetsukukuOptionalPeerToPeer);
	G_OBJECT_CLASS (netsukuku_optional_peer_to_peer_parent_class)->finalize (obj);
}


GType netsukuku_optional_peer_to_peer_get_type (void) {
	static volatile gsize netsukuku_optional_peer_to_peer_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_optional_peer_to_peer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuOptionalPeerToPeerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_optional_peer_to_peer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuOptionalPeerToPeer), 0, (GInstanceInitFunc) netsukuku_optional_peer_to_peer_instance_init, NULL };
		GType netsukuku_optional_peer_to_peer_type_id;
		netsukuku_optional_peer_to_peer_type_id = g_type_register_static (NETSUKUKU_TYPE_PEER_TO_PEER, "NetsukukuOptionalPeerToPeer", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_optional_peer_to_peer_type_id__volatile, netsukuku_optional_peer_to_peer_type_id);
	}
	return netsukuku_optional_peer_to_peer_type_id__volatile;
}


NetsukukuAggregatedNeighbourManager* netsukuku_aggregated_neighbour_manager_construct (GType object_type) {
	NetsukukuAggregatedNeighbourManager * self = NULL;
	self = (NetsukukuAggregatedNeighbourManager*) g_object_new (object_type, NULL);
	return self;
}


NetsukukuAggregatedNeighbourManager* netsukuku_aggregated_neighbour_manager_new (void) {
	return netsukuku_aggregated_neighbour_manager_construct (NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER);
}


static void netsukuku_aggregated_neighbour_manager_class_init (NetsukukuAggregatedNeighbourManagerClass * klass) {
	netsukuku_aggregated_neighbour_manager_parent_class = g_type_class_peek_parent (klass);
}


static void netsukuku_aggregated_neighbour_manager_instance_init (NetsukukuAggregatedNeighbourManager * self) {
}


GType netsukuku_aggregated_neighbour_manager_get_type (void) {
	static volatile gsize netsukuku_aggregated_neighbour_manager_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_aggregated_neighbour_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuAggregatedNeighbourManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_aggregated_neighbour_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuAggregatedNeighbourManager), 0, (GInstanceInitFunc) netsukuku_aggregated_neighbour_manager_instance_init, NULL };
		GType netsukuku_aggregated_neighbour_manager_type_id;
		netsukuku_aggregated_neighbour_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "NetsukukuAggregatedNeighbourManager", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_aggregated_neighbour_manager_type_id__volatile, netsukuku_aggregated_neighbour_manager_type_id);
	}
	return netsukuku_aggregated_neighbour_manager_type_id__volatile;
}


NetsukukuAggregatedNeighbour* netsukuku_aggregated_neighbour_construct (GType object_type) {
	NetsukukuAggregatedNeighbour * self = NULL;
	self = (NetsukukuAggregatedNeighbour*) g_object_new (object_type, NULL);
	return self;
}


NetsukukuAggregatedNeighbour* netsukuku_aggregated_neighbour_new (void) {
	return netsukuku_aggregated_neighbour_construct (NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR);
}


static void netsukuku_aggregated_neighbour_class_init (NetsukukuAggregatedNeighbourClass * klass) {
	netsukuku_aggregated_neighbour_parent_class = g_type_class_peek_parent (klass);
}


static void netsukuku_aggregated_neighbour_instance_init (NetsukukuAggregatedNeighbour * self) {
}


GType netsukuku_aggregated_neighbour_get_type (void) {
	static volatile gsize netsukuku_aggregated_neighbour_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_aggregated_neighbour_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuAggregatedNeighbourClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_aggregated_neighbour_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuAggregatedNeighbour), 0, (GInstanceInitFunc) netsukuku_aggregated_neighbour_instance_init, NULL };
		GType netsukuku_aggregated_neighbour_type_id;
		netsukuku_aggregated_neighbour_type_id = g_type_register_static (G_TYPE_OBJECT, "NetsukukuAggregatedNeighbour", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_aggregated_neighbour_type_id__volatile, netsukuku_aggregated_neighbour_type_id);
	}
	return netsukuku_aggregated_neighbour_type_id__volatile;
}


NetsukukuMapRoute* netsukuku_map_route_construct (GType object_type, gint l, gint s, NetsukukuNIP* n) {
	NetsukukuMapRoute * self = NULL;
	gint _tmp0_;
	gint _tmp1_;
	NetsukukuNIP* _tmp2_;
	NetsukukuNIP* _tmp3_;
	g_return_val_if_fail (n != NULL, NULL);
	self = (NetsukukuMapRoute*) g_object_new (object_type, NULL);
	_tmp0_ = l;
	self->levels = _tmp0_;
	_tmp1_ = s;
	self->gsize = _tmp1_;
	_tmp2_ = n;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->me);
	self->me = _tmp3_;
	return self;
}


NetsukukuMapRoute* netsukuku_map_route_new (gint l, gint s, NetsukukuNIP* n) {
	return netsukuku_map_route_construct (NETSUKUKU_TYPE_MAP_ROUTE, l, s, n);
}


NetsukukuPartialNIP* netsukuku_map_route_choose_fast (NetsukukuMapRoute* self, GeeList* choose_from) {
	NetsukukuPartialNIP* result = NULL;
	GeeList* _tmp0_;
	gpointer _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (choose_from != NULL, NULL);
	_tmp0_ = choose_from;
	_tmp1_ = gee_list_get (_tmp0_, 0);
	result = (NetsukukuPartialNIP*) _tmp1_;
	return result;
}


static void netsukuku_map_route_class_init (NetsukukuMapRouteClass * klass) {
	netsukuku_map_route_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = netsukuku_map_route_finalize;
}


static void netsukuku_map_route_instance_init (NetsukukuMapRoute * self) {
}


static void netsukuku_map_route_finalize (GObject* obj) {
	NetsukukuMapRoute * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_MAP_ROUTE, NetsukukuMapRoute);
	_g_object_unref0 (self->me);
	G_OBJECT_CLASS (netsukuku_map_route_parent_class)->finalize (obj);
}


GType netsukuku_map_route_get_type (void) {
	static volatile gsize netsukuku_map_route_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_map_route_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuMapRouteClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_map_route_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuMapRoute), 0, (GInstanceInitFunc) netsukuku_map_route_instance_init, NULL };
		GType netsukuku_map_route_type_id;
		netsukuku_map_route_type_id = g_type_register_static (G_TYPE_OBJECT, "NetsukukuMapRoute", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_map_route_type_id__volatile, netsukuku_map_route_type_id);
	}
	return netsukuku_map_route_type_id__volatile;
}


GeeArrayList* netsukuku_valid_ids (gint levels, gint gsize, gint lvl, NetsukukuPartialNIP* partial_nip) {
	GeeArrayList* result = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* ret;
	g_return_val_if_fail (partial_nip != NULL, NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_INT, NULL, NULL, NULL, NULL, NULL);
	ret = _tmp0_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				gboolean _tmp2_;
				gint _tmp4_;
				gint _tmp5_;
				GeeArrayList* _tmp6_;
				gint _tmp7_;
				_tmp2_ = _tmp1_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp4_ = i;
				_tmp5_ = gsize;
				if (!(_tmp4_ < _tmp5_)) {
					break;
				}
				_tmp6_ = ret;
				_tmp7_ = i;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp6_, (gpointer) ((gintptr) _tmp7_));
			}
		}
	}
	result = ret;
	return result;
}


gchar* netsukuku_nip_to_str (gint levels, gint gsize, NetsukukuNIP* nip) {
	gchar* result = NULL;
	gint _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gint _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	NetsukukuNIP* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	g_return_val_if_fail (nip != NULL, NULL);
	_tmp0_ = levels;
	_tmp1_ = g_strdup_printf ("%i", _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = gsize;
	_tmp4_ = g_strdup_printf ("%i", _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = nip;
	_tmp7_ = netsukuku_partial_nip_to_string ((NetsukukuPartialNIP*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strconcat (_tmp2_, "_", _tmp5_, "_", _tmp8_, NULL);
	_tmp10_ = _tmp9_;
	_g_free0 (_tmp8_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp2_);
	result = _tmp10_;
	return result;
}


void ntk_test_print_out (const gchar* s) {
	g_return_if_fail (s != NULL);
	if (NTK_TEST_output) {
		const gchar* _tmp0_;
		_tmp0_ = s;
		g_print ("%s", _tmp0_);
	}
}


NetsukukuNIP* ntk_test_best_approximation_nip (gint levels, gint gsize, NetsukukuNIP* hIP, gint sign) {
	NetsukukuNIP* result = NULL;
	NetsukukuNIP* ret;
	gint _tmp0_;
	gint _tmp1_;
	NetsukukuNIP* _tmp2_;
	gint _tmp3_;
	GeeArrayList* _tmp4_ = NULL;
	GeeArrayList* lst;
	g_return_val_if_fail (hIP != NULL, NULL);
	ret = NULL;
	_tmp0_ = levels;
	_tmp1_ = gsize;
	_tmp2_ = hIP;
	_tmp3_ = sign;
	_tmp4_ = ntk_test_ordered_lookup (_tmp0_, _tmp1_, _tmp2_, _tmp3_);
	lst = _tmp4_;
	{
		GeeArrayList* _tmp5_;
		GeeArrayList* _tmp6_;
		GeeArrayList* _s_list;
		GeeArrayList* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _s_size;
		gint _s_index;
		_tmp5_ = lst;
		_tmp6_ = _g_object_ref0 (_tmp5_);
		_s_list = _tmp6_;
		_tmp7_ = _s_list;
		_tmp8_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp7_);
		_tmp9_ = _tmp8_;
		_s_size = _tmp9_;
		_s_index = -1;
		while (TRUE) {
			gint _tmp10_;
			gint _tmp11_;
			gint _tmp12_;
			GeeArrayList* _tmp13_;
			gint _tmp14_;
			gpointer _tmp15_ = NULL;
			NetsukukuNIP* s;
			GeeHashMap* _tmp16_;
			NetsukukuNIP* _tmp17_;
			gboolean _tmp18_ = FALSE;
			_tmp10_ = _s_index;
			_s_index = _tmp10_ + 1;
			_tmp11_ = _s_index;
			_tmp12_ = _s_size;
			if (!(_tmp11_ < _tmp12_)) {
				break;
			}
			_tmp13_ = _s_list;
			_tmp14_ = _s_index;
			_tmp15_ = gee_abstract_list_get ((GeeAbstractList*) _tmp13_, _tmp14_);
			s = (NetsukukuNIP*) _tmp15_;
			_tmp16_ = ntk_test_nodes;
			_tmp17_ = s;
			_tmp18_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp16_, _tmp17_);
			if (_tmp18_) {
				NetsukukuNIP* _tmp19_;
				NetsukukuNIP* _tmp20_;
				_tmp19_ = s;
				_tmp20_ = _g_object_ref0 (_tmp19_);
				_g_object_unref0 (ret);
				ret = _tmp20_;
				_g_object_unref0 (s);
				break;
			}
			_g_object_unref0 (s);
		}
		_g_object_unref0 (_s_list);
	}
	result = ret;
	_g_object_unref0 (lst);
	return result;
}


NtkTestAndnaCounter* ntk_test_best_approximation (gint levels, gint gsize, NetsukukuNIP* hIP, gint sign) {
	NtkTestAndnaCounter* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	NetsukukuNIP* _tmp2_;
	gint _tmp3_;
	NetsukukuNIP* _tmp4_ = NULL;
	NetsukukuNIP* nip;
	GeeHashMap* _tmp5_;
	gboolean _tmp6_ = FALSE;
	GeeHashMap* _tmp7_;
	gpointer _tmp8_ = NULL;
	g_return_val_if_fail (hIP != NULL, NULL);
	_tmp0_ = levels;
	_tmp1_ = gsize;
	_tmp2_ = hIP;
	_tmp3_ = sign;
	_tmp4_ = ntk_test_best_approximation_nip (_tmp0_, _tmp1_, _tmp2_, _tmp3_);
	nip = _tmp4_;
	_vala_assert (nip != NULL, "nip != null");
	_tmp5_ = ntk_test_nodes;
	_tmp6_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp5_, nip);
	_vala_assert (_tmp6_, "Ntk.Test.nodes.has_key(nip)");
	_tmp7_ = ntk_test_nodes;
	_tmp8_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp7_, nip);
	result = (NtkTestAndnaCounter*) _tmp8_;
	_g_object_unref0 (nip);
	return result;
}


GeeArrayList* ntk_test_list_positions (gint startpos, gint sign, gint gsize) {
	GeeArrayList* result = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* ret;
	_tmp0_ = gee_array_list_new (G_TYPE_INT, NULL, NULL, NULL, NULL, NULL);
	ret = _tmp0_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				gboolean _tmp2_;
				gint _tmp4_;
				gint _tmp5_;
				GeeArrayList* _tmp6_;
				gint _tmp7_;
				gint _tmp8_;
				gint _tmp9_;
				gint _tmp10_;
				gint _tmp11_;
				_tmp2_ = _tmp1_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp4_ = i;
				_tmp5_ = gsize;
				if (!(_tmp4_ < _tmp5_)) {
					break;
				}
				_tmp6_ = ret;
				_tmp7_ = startpos;
				_tmp8_ = gsize;
				_tmp9_ = i;
				_tmp10_ = sign;
				_tmp11_ = gsize;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp6_, (gpointer) ((gintptr) (((_tmp7_ + _tmp8_) + (_tmp9_ * _tmp10_)) % _tmp11_)));
			}
		}
	}
	result = ret;
	return result;
}


GeeArrayList* ntk_test_ordered_lookup (gint levels, gint gsize, NetsukukuNIP* hIP, gint sign) {
	GeeArrayList* result = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* tot;
	g_return_val_if_fail (hIP != NULL, NULL);
	_tmp0_ = gee_array_list_new (NETSUKUKU_TYPE_NIP, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	tot = _tmp0_;
	{
		gint lvl;
		lvl = 0;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				gboolean _tmp2_;
				gint _tmp4_;
				gint _tmp5_;
				GeeArrayList* _tmp6_;
				GeeArrayList* tmp;
				GeeArrayList* _tmp66_;
				GeeArrayList* _tmp67_;
				_tmp2_ = _tmp1_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = lvl;
					lvl = _tmp3_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp4_ = lvl;
				_tmp5_ = levels;
				if (!(_tmp4_ < _tmp5_)) {
					break;
				}
				_tmp6_ = gee_array_list_new (NETSUKUKU_TYPE_NIP, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
				tmp = _tmp6_;
				{
					NetsukukuNIP* _tmp7_;
					gint _tmp8_;
					gint _tmp9_ = 0;
					gint _tmp10_;
					gint _tmp11_;
					GeeArrayList* _tmp12_ = NULL;
					GeeArrayList* _n_list;
					GeeArrayList* _tmp13_;
					gint _tmp14_;
					gint _tmp15_;
					gint _n_size;
					gint _n_index;
					_tmp7_ = hIP;
					_tmp8_ = lvl;
					_tmp9_ = netsukuku_partial_nip_position_at ((NetsukukuPartialNIP*) _tmp7_, _tmp8_);
					_tmp10_ = sign;
					_tmp11_ = gsize;
					_tmp12_ = ntk_test_list_positions (_tmp9_, _tmp10_, _tmp11_);
					_n_list = _tmp12_;
					_tmp13_ = _n_list;
					_tmp14_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp13_);
					_tmp15_ = _tmp14_;
					_n_size = _tmp15_;
					_n_index = -1;
					while (TRUE) {
						gint _tmp16_;
						gint _tmp17_;
						gint _tmp18_;
						GeeArrayList* _tmp19_;
						gint _tmp20_;
						gpointer _tmp21_ = NULL;
						gint n;
						GeeArrayList* _tmp22_;
						gboolean _tmp23_;
						gboolean _tmp24_;
						_tmp16_ = _n_index;
						_n_index = _tmp16_ + 1;
						_tmp17_ = _n_index;
						_tmp18_ = _n_size;
						if (!(_tmp17_ < _tmp18_)) {
							break;
						}
						_tmp19_ = _n_list;
						_tmp20_ = _n_index;
						_tmp21_ = gee_abstract_list_get ((GeeAbstractList*) _tmp19_, _tmp20_);
						n = (gint) ((gintptr) _tmp21_);
						_tmp22_ = tot;
						_tmp23_ = gee_collection_get_is_empty ((GeeCollection*) _tmp22_);
						_tmp24_ = _tmp23_;
						if (_tmp24_) {
							GeeArrayList* _tmp25_;
							gint _tmp26_;
							gint* _tmp27_ = NULL;
							gint* _tmp28_;
							gint _tmp28__length1;
							NetsukukuNIP* _tmp29_;
							NetsukukuNIP* _tmp30_;
							_tmp25_ = tmp;
							_tmp26_ = n;
							_tmp27_ = g_new0 (gint, 1);
							_tmp27_[0] = _tmp26_;
							_tmp28_ = _tmp27_;
							_tmp28__length1 = 1;
							_tmp29_ = netsukuku_nip_new (_tmp28_, 1);
							_tmp30_ = _tmp29_;
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp25_, _tmp30_);
							_g_object_unref0 (_tmp30_);
							_tmp28_ = (g_free (_tmp28_), NULL);
						} else {
							{
								GeeArrayList* _tmp31_;
								GeeArrayList* _tmp32_;
								GeeArrayList* _s_list;
								GeeArrayList* _tmp33_;
								gint _tmp34_;
								gint _tmp35_;
								gint _s_size;
								gint _s_index;
								_tmp31_ = tot;
								_tmp32_ = _g_object_ref0 (_tmp31_);
								_s_list = _tmp32_;
								_tmp33_ = _s_list;
								_tmp34_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp33_);
								_tmp35_ = _tmp34_;
								_s_size = _tmp35_;
								_s_index = -1;
								while (TRUE) {
									gint _tmp36_;
									gint _tmp37_;
									gint _tmp38_;
									GeeArrayList* _tmp39_;
									gint _tmp40_;
									gpointer _tmp41_ = NULL;
									NetsukukuNIP* s;
									gint _tmp42_;
									gint* _tmp43_ = NULL;
									gint* n_s_pos;
									gint n_s_pos_length1;
									gint _n_s_pos_size_;
									NetsukukuNIP* _tmp44_;
									gint _tmp45_ = 0;
									gint* _tmp46_ = NULL;
									gint* s_pos;
									gint s_pos_length1;
									gint _s_pos_size_;
									gint* _tmp58_;
									gint _tmp58__length1;
									gint _tmp59_;
									gint _tmp60_;
									gint _tmp61_;
									GeeArrayList* _tmp62_;
									gint* _tmp63_;
									gint _tmp63__length1;
									NetsukukuNIP* _tmp64_;
									NetsukukuNIP* _tmp65_;
									_tmp36_ = _s_index;
									_s_index = _tmp36_ + 1;
									_tmp37_ = _s_index;
									_tmp38_ = _s_size;
									if (!(_tmp37_ < _tmp38_)) {
										break;
									}
									_tmp39_ = _s_list;
									_tmp40_ = _s_index;
									_tmp41_ = gee_abstract_list_get ((GeeAbstractList*) _tmp39_, _tmp40_);
									s = (NetsukukuNIP*) _tmp41_;
									_tmp42_ = lvl;
									_tmp43_ = g_new0 (gint, _tmp42_ + 1);
									n_s_pos = _tmp43_;
									n_s_pos_length1 = _tmp42_ + 1;
									_n_s_pos_size_ = n_s_pos_length1;
									_tmp44_ = s;
									_tmp46_ = netsukuku_partial_nip_get_positions ((NetsukukuPartialNIP*) _tmp44_, &_tmp45_);
									s_pos = _tmp46_;
									s_pos_length1 = _tmp45_;
									_s_pos_size_ = s_pos_length1;
									{
										gint l;
										l = 0;
										{
											gboolean _tmp47_;
											_tmp47_ = TRUE;
											while (TRUE) {
												gboolean _tmp48_;
												gint _tmp50_;
												gint _tmp51_;
												gint* _tmp52_;
												gint _tmp52__length1;
												gint _tmp53_;
												gint* _tmp54_;
												gint _tmp54__length1;
												gint _tmp55_;
												gint _tmp56_;
												gint _tmp57_;
												_tmp48_ = _tmp47_;
												if (!_tmp48_) {
													gint _tmp49_;
													_tmp49_ = l;
													l = _tmp49_ + 1;
												}
												_tmp47_ = FALSE;
												_tmp50_ = l;
												_tmp51_ = lvl;
												if (!(_tmp50_ < _tmp51_)) {
													break;
												}
												_tmp52_ = n_s_pos;
												_tmp52__length1 = n_s_pos_length1;
												_tmp53_ = l;
												_tmp54_ = s_pos;
												_tmp54__length1 = s_pos_length1;
												_tmp55_ = l;
												_tmp56_ = _tmp54_[_tmp55_];
												_tmp52_[_tmp53_] = _tmp56_;
												_tmp57_ = _tmp52_[_tmp53_];
											}
										}
									}
									_tmp58_ = n_s_pos;
									_tmp58__length1 = n_s_pos_length1;
									_tmp59_ = lvl;
									_tmp60_ = n;
									_tmp58_[_tmp59_] = _tmp60_;
									_tmp61_ = _tmp58_[_tmp59_];
									_tmp62_ = tmp;
									_tmp63_ = n_s_pos;
									_tmp63__length1 = n_s_pos_length1;
									_tmp64_ = netsukuku_nip_new (_tmp63_, _tmp63__length1);
									_tmp65_ = _tmp64_;
									gee_abstract_collection_add ((GeeAbstractCollection*) _tmp62_, _tmp65_);
									_g_object_unref0 (_tmp65_);
									s_pos = (g_free (s_pos), NULL);
									n_s_pos = (g_free (n_s_pos), NULL);
									_g_object_unref0 (s);
								}
								_g_object_unref0 (_s_list);
							}
						}
					}
					_g_object_unref0 (_n_list);
				}
				_tmp66_ = tmp;
				_tmp67_ = _g_object_ref0 (_tmp66_);
				_g_object_unref0 (tot);
				tot = _tmp67_;
				_g_object_unref0 (tmp);
			}
		}
	}
	result = tot;
	return result;
}


NtkTestCounterDebug* ntk_test_counter_debug_construct (GType object_type, NetsukukuKeyPair* keypair, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, NetsukukuPeerToPeerAll* peer_to_peer_all) {
	NtkTestCounterDebug * self = NULL;
	NetsukukuKeyPair* _tmp0_;
	NetsukukuAggregatedNeighbourManager* _tmp1_;
	NetsukukuMapRoute* _tmp2_;
	NetsukukuPeerToPeerAll* _tmp3_;
	g_return_val_if_fail (keypair != NULL, NULL);
	g_return_val_if_fail (aggregated_neighbour_manager != NULL, NULL);
	g_return_val_if_fail (maproute != NULL, NULL);
	g_return_val_if_fail (peer_to_peer_all != NULL, NULL);
	_tmp0_ = keypair;
	_tmp1_ = aggregated_neighbour_manager;
	_tmp2_ = maproute;
	_tmp3_ = peer_to_peer_all;
	self = (NtkTestCounterDebug*) netsukuku_counter_construct (object_type, _tmp0_, _tmp1_, _tmp2_, _tmp3_);
	return self;
}


NtkTestCounterDebug* ntk_test_counter_debug_new (NetsukukuKeyPair* keypair, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, NetsukukuPeerToPeerAll* peer_to_peer_all) {
	return ntk_test_counter_debug_construct (NTK_TEST_TYPE_COUNTER_DEBUG, keypair, aggregated_neighbour_manager, maproute, peer_to_peer_all);
}


static NetsukukuIAddressManagerRootDispatcher* ntk_test_counter_debug_real_contact_registrar (NetsukukuCounter* base, const gchar* registrar_address) {
	NtkTestCounterDebug * self;
	NetsukukuIAddressManagerRootDispatcher* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	NtkTestFakeClient* _tmp4_;
	NtkTestFakeClient* ret;
	GeeHashMap* _tmp5_;
	const gchar* _tmp6_;
	gpointer _tmp7_ = NULL;
	NtkTestAndnaCounter* _tmp8_;
	NetsukukuAndna* _tmp9_;
	NetsukukuAndna* _tmp10_;
	self = (NtkTestCounterDebug*) base;
	g_return_val_if_fail (registrar_address != NULL, NULL);
	_tmp0_ = registrar_address;
	_tmp1_ = string_to_string (_tmp0_);
	_tmp2_ = g_strconcat ("registrar_address = ", _tmp1_, "\n", NULL);
	_tmp3_ = _tmp2_;
	ntk_test_print_out (_tmp3_);
	_g_free0 (_tmp3_);
	_tmp4_ = ntk_test_fake_client_new ();
	ret = _tmp4_;
	_tmp5_ = ntk_test_nodes_by_niptostr;
	_tmp6_ = registrar_address;
	_tmp7_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp5_, _tmp6_);
	_tmp8_ = (NtkTestAndnaCounter*) _tmp7_;
	_tmp9_ = _tmp8_->andna;
	_tmp10_ = _g_object_ref0 (_tmp9_);
	_g_object_unref0 (ret->actual_andna);
	ret->actual_andna = _tmp10_;
	_g_object_unref0 (_tmp8_);
	result = (NetsukukuIAddressManagerRootDispatcher*) ret;
	return result;
}


static void ntk_test_counter_debug_class_init (NtkTestCounterDebugClass * klass) {
	ntk_test_counter_debug_parent_class = g_type_class_peek_parent (klass);
	NETSUKUKU_COUNTER_CLASS (klass)->contact_registrar = ntk_test_counter_debug_real_contact_registrar;
}


static void ntk_test_counter_debug_instance_init (NtkTestCounterDebug * self) {
}


GType ntk_test_counter_debug_get_type (void) {
	static volatile gsize ntk_test_counter_debug_type_id__volatile = 0;
	if (g_once_init_enter (&ntk_test_counter_debug_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NtkTestCounterDebugClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ntk_test_counter_debug_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NtkTestCounterDebug), 0, (GInstanceInitFunc) ntk_test_counter_debug_instance_init, NULL };
		GType ntk_test_counter_debug_type_id;
		ntk_test_counter_debug_type_id = g_type_register_static (NETSUKUKU_TYPE_COUNTER, "NtkTestCounterDebug", &g_define_type_info, 0);
		g_once_init_leave (&ntk_test_counter_debug_type_id__volatile, ntk_test_counter_debug_type_id);
	}
	return ntk_test_counter_debug_type_id__volatile;
}


static NetsukukuIAggregatedNeighbourManager* ntk_test_fake_client_real__aggregated_neighbour_manager_getter (NetsukukuIAddressManagerRootDispatcher* base) {
	NtkTestFakeClient * self;
	NetsukukuIAggregatedNeighbourManager* result = NULL;
	self = (NtkTestFakeClient*) base;
	result = NULL;
	return result;
}


static NetsukukuIAndna* ntk_test_fake_client_real__andna_getter (NetsukukuIAddressManagerRootDispatcher* base) {
	NtkTestFakeClient * self;
	NetsukukuIAndna* result = NULL;
	NetsukukuAndna* _tmp0_;
	self = (NtkTestFakeClient*) base;
	_tmp0_ = self->actual_andna;
	result = (NetsukukuIAndna*) _tmp0_;
	return result;
}


static NetsukukuIBorderNodesManager* ntk_test_fake_client_real__border_nodes_manager_getter (NetsukukuIAddressManagerRootDispatcher* base) {
	NtkTestFakeClient * self;
	NetsukukuIBorderNodesManager* result = NULL;
	self = (NtkTestFakeClient*) base;
	result = NULL;
	return result;
}


static NetsukukuICoordinator* ntk_test_fake_client_real__coordinator_getter (NetsukukuIAddressManagerRootDispatcher* base) {
	NtkTestFakeClient * self;
	NetsukukuICoordinator* result = NULL;
	self = (NtkTestFakeClient*) base;
	result = NULL;
	return result;
}


static NetsukukuIEtp* ntk_test_fake_client_real__etp_getter (NetsukukuIAddressManagerRootDispatcher* base) {
	NtkTestFakeClient * self;
	NetsukukuIEtp* result = NULL;
	self = (NtkTestFakeClient*) base;
	result = NULL;
	return result;
}


static NetsukukuIHook* ntk_test_fake_client_real__hook_getter (NetsukukuIAddressManagerRootDispatcher* base) {
	NtkTestFakeClient * self;
	NetsukukuIHook* result = NULL;
	self = (NtkTestFakeClient*) base;
	result = NULL;
	return result;
}


static NetsukukuIMapRoute* ntk_test_fake_client_real__maproute_getter (NetsukukuIAddressManagerRootDispatcher* base) {
	NtkTestFakeClient * self;
	NetsukukuIMapRoute* result = NULL;
	self = (NtkTestFakeClient*) base;
	result = NULL;
	return result;
}


static NetsukukuIPeerToPeerAll* ntk_test_fake_client_real__peer_to_peer_all_getter (NetsukukuIAddressManagerRootDispatcher* base) {
	NtkTestFakeClient * self;
	NetsukukuIPeerToPeerAll* result = NULL;
	self = (NtkTestFakeClient*) base;
	result = NULL;
	return result;
}


static NetsukukuITunnelManager* ntk_test_fake_client_real__tunnel_manager_getter (NetsukukuIAddressManagerRootDispatcher* base) {
	NtkTestFakeClient * self;
	NetsukukuITunnelManager* result = NULL;
	self = (NtkTestFakeClient*) base;
	result = NULL;
	return result;
}


static NetsukukuIOptionalPeerToPeer* ntk_test_fake_client_real_get_optional_peer_to_peer_service (NetsukukuIAddressManagerRootDispatcher* base, gint pid) {
	NtkTestFakeClient * self;
	NetsukukuIOptionalPeerToPeer* result = NULL;
	self = (NtkTestFakeClient*) base;
	result = NULL;
	return result;
}


static NetsukukuIPeerToPeer* ntk_test_fake_client_real_get_peer_to_peer_service (NetsukukuIAddressManagerRootDispatcher* base, gint pid) {
	NtkTestFakeClient * self;
	NetsukukuIPeerToPeer* result = NULL;
	self = (NtkTestFakeClient*) base;
	result = NULL;
	return result;
}


static GeeList* ntk_test_fake_client_real_report_tasklets_stats (NetsukukuIAddressManagerRootDispatcher* base, gint minutes, GError** error) {
	NtkTestFakeClient * self;
	GeeList* result = NULL;
	self = (NtkTestFakeClient*) base;
	result = NULL;
	return result;
}


static GeeList* ntk_test_fake_client_real_report_tasklet_logs (NetsukukuIAddressManagerRootDispatcher* base, gint minutes, GError** error) {
	NtkTestFakeClient * self;
	GeeList* result = NULL;
	self = (NtkTestFakeClient*) base;
	result = NULL;
	return result;
}


static GeeList* ntk_test_fake_client_real_report_running_tasklets (NetsukukuIAddressManagerRootDispatcher* base, GError** error) {
	NtkTestFakeClient * self;
	GeeList* result = NULL;
	self = (NtkTestFakeClient*) base;
	result = NULL;
	return result;
}


NtkTestFakeClient* ntk_test_fake_client_construct (GType object_type) {
	NtkTestFakeClient * self = NULL;
	self = (NtkTestFakeClient*) g_object_new (object_type, NULL);
	return self;
}


NtkTestFakeClient* ntk_test_fake_client_new (void) {
	return ntk_test_fake_client_construct (NTK_TEST_TYPE_FAKE_CLIENT);
}


static void ntk_test_fake_client_class_init (NtkTestFakeClientClass * klass) {
	ntk_test_fake_client_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = ntk_test_fake_client_finalize;
}


static void ntk_test_fake_client_netsukuku_iaddress_manager_root_dispatcher_interface_init (NetsukukuIAddressManagerRootDispatcherIface * iface) {
	ntk_test_fake_client_netsukuku_iaddress_manager_root_dispatcher_parent_iface = g_type_interface_peek_parent (iface);
	iface->_aggregated_neighbour_manager_getter = (NetsukukuIAggregatedNeighbourManager* (*)(NetsukukuIAddressManagerRootDispatcher*)) ntk_test_fake_client_real__aggregated_neighbour_manager_getter;
	iface->_andna_getter = (NetsukukuIAndna* (*)(NetsukukuIAddressManagerRootDispatcher*)) ntk_test_fake_client_real__andna_getter;
	iface->_border_nodes_manager_getter = (NetsukukuIBorderNodesManager* (*)(NetsukukuIAddressManagerRootDispatcher*)) ntk_test_fake_client_real__border_nodes_manager_getter;
	iface->_coordinator_getter = (NetsukukuICoordinator* (*)(NetsukukuIAddressManagerRootDispatcher*)) ntk_test_fake_client_real__coordinator_getter;
	iface->_etp_getter = (NetsukukuIEtp* (*)(NetsukukuIAddressManagerRootDispatcher*)) ntk_test_fake_client_real__etp_getter;
	iface->_hook_getter = (NetsukukuIHook* (*)(NetsukukuIAddressManagerRootDispatcher*)) ntk_test_fake_client_real__hook_getter;
	iface->_maproute_getter = (NetsukukuIMapRoute* (*)(NetsukukuIAddressManagerRootDispatcher*)) ntk_test_fake_client_real__maproute_getter;
	iface->_peer_to_peer_all_getter = (NetsukukuIPeerToPeerAll* (*)(NetsukukuIAddressManagerRootDispatcher*)) ntk_test_fake_client_real__peer_to_peer_all_getter;
	iface->_tunnel_manager_getter = (NetsukukuITunnelManager* (*)(NetsukukuIAddressManagerRootDispatcher*)) ntk_test_fake_client_real__tunnel_manager_getter;
	iface->get_optional_peer_to_peer_service = (NetsukukuIOptionalPeerToPeer* (*)(NetsukukuIAddressManagerRootDispatcher*, gint)) ntk_test_fake_client_real_get_optional_peer_to_peer_service;
	iface->get_peer_to_peer_service = (NetsukukuIPeerToPeer* (*)(NetsukukuIAddressManagerRootDispatcher*, gint)) ntk_test_fake_client_real_get_peer_to_peer_service;
	iface->report_tasklets_stats = (GeeList* (*)(NetsukukuIAddressManagerRootDispatcher*, gint, GError**)) ntk_test_fake_client_real_report_tasklets_stats;
	iface->report_tasklet_logs = (GeeList* (*)(NetsukukuIAddressManagerRootDispatcher*, gint, GError**)) ntk_test_fake_client_real_report_tasklet_logs;
	iface->report_running_tasklets = (GeeList* (*)(NetsukukuIAddressManagerRootDispatcher*, GError**)) ntk_test_fake_client_real_report_running_tasklets;
}


static void ntk_test_fake_client_instance_init (NtkTestFakeClient * self) {
}


static void ntk_test_fake_client_finalize (GObject* obj) {
	NtkTestFakeClient * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NTK_TEST_TYPE_FAKE_CLIENT, NtkTestFakeClient);
	_g_object_unref0 (self->actual_andna);
	G_OBJECT_CLASS (ntk_test_fake_client_parent_class)->finalize (obj);
}


GType ntk_test_fake_client_get_type (void) {
	static volatile gsize ntk_test_fake_client_type_id__volatile = 0;
	if (g_once_init_enter (&ntk_test_fake_client_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NtkTestFakeClientClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ntk_test_fake_client_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NtkTestFakeClient), 0, (GInstanceInitFunc) ntk_test_fake_client_instance_init, NULL };
		static const GInterfaceInfo netsukuku_iaddress_manager_root_dispatcher_info = { (GInterfaceInitFunc) ntk_test_fake_client_netsukuku_iaddress_manager_root_dispatcher_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType ntk_test_fake_client_type_id;
		ntk_test_fake_client_type_id = g_type_register_static (G_TYPE_OBJECT, "NtkTestFakeClient", &g_define_type_info, 0);
		g_type_add_interface_static (ntk_test_fake_client_type_id, NETSUKUKU_TYPE_IADDRESS_MANAGER_ROOT_DISPATCHER, &netsukuku_iaddress_manager_root_dispatcher_info);
		g_once_init_leave (&ntk_test_fake_client_type_id__volatile, ntk_test_fake_client_type_id);
	}
	return ntk_test_fake_client_type_id__volatile;
}


NtkTestAndnaCounter* ntk_test_andna_counter_construct (GType object_type) {
	NtkTestAndnaCounter * self = NULL;
	self = (NtkTestAndnaCounter*) g_object_new (object_type, NULL);
	return self;
}


NtkTestAndnaCounter* ntk_test_andna_counter_new (void) {
	return ntk_test_andna_counter_construct (NTK_TEST_TYPE_ANDNA_COUNTER);
}


static void ntk_test_andna_counter_class_init (NtkTestAndnaCounterClass * klass) {
	ntk_test_andna_counter_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = ntk_test_andna_counter_finalize;
}


static void ntk_test_andna_counter_instance_init (NtkTestAndnaCounter * self) {
}


static void ntk_test_andna_counter_finalize (GObject* obj) {
	NtkTestAndnaCounter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NTK_TEST_TYPE_ANDNA_COUNTER, NtkTestAndnaCounter);
	_g_object_unref0 (self->andna);
	_g_object_unref0 (self->counter);
	G_OBJECT_CLASS (ntk_test_andna_counter_parent_class)->finalize (obj);
}


GType ntk_test_andna_counter_get_type (void) {
	static volatile gsize ntk_test_andna_counter_type_id__volatile = 0;
	if (g_once_init_enter (&ntk_test_andna_counter_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NtkTestAndnaCounterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ntk_test_andna_counter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NtkTestAndnaCounter), 0, (GInstanceInitFunc) ntk_test_andna_counter_instance_init, NULL };
		GType ntk_test_andna_counter_type_id;
		ntk_test_andna_counter_type_id = g_type_register_static (G_TYPE_OBJECT, "NtkTestAndnaCounter", &g_define_type_info, 0);
		g_once_init_leave (&ntk_test_andna_counter_type_id__volatile, ntk_test_andna_counter_type_id);
	}
	return ntk_test_andna_counter_type_id__volatile;
}


void ntk_test_andna_counter_tester_set_up (NtkTestAndnaCounterTester* self) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("");
	_g_free0 (ntk_test_logger);
	ntk_test_logger = _tmp0_;
}


void ntk_test_andna_counter_tester_tear_down (NtkTestAndnaCounterTester* self) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("");
	_g_free0 (ntk_test_logger);
	ntk_test_logger = _tmp0_;
}


static guint _netsukuku_partial_nip_hash_func_gee_hash_data_func (gconstpointer v, gpointer self) {
	guint result;
	result = netsukuku_partial_nip_hash_func (v);
	return result;
}


static void _vala_array_add1 (NetsukukuNIP*** array, int* length, int* size, NetsukukuNIP* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (NetsukukuNIP*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add2 (NetsukukuKeyPair*** array, int* length, int* size, NetsukukuKeyPair* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (NetsukukuKeyPair*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add3 (NetsukukuMapRoute*** array, int* length, int* size, NetsukukuMapRoute* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (NetsukukuMapRoute*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


void ntk_test_andna_counter_tester_test_hook_and_replica (NtkTestAndnaCounterTester* self) {
	gint int_set_1_counter;
	gint* _tmp0_ = NULL;
	gint* int_set_1;
	gint int_set_1_length1;
	gint _int_set_1_size_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar** _tmp11_ = NULL;
	gchar** hostnames;
	gint hostnames_length1;
	gint _hostnames_size_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar** _tmp18_ = NULL;
	gchar** snsd_records;
	gint snsd_records_length1;
	gint _snsd_records_size_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar** _tmp25_ = NULL;
	gchar** snsdserver_alias;
	gint snsdserver_alias_length1;
	gint _snsdserver_alias_size_;
	gint* _tmp26_ = NULL;
	gint* snsdserver_values;
	gint snsdserver_values_length1;
	gint _snsdserver_values_size_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	gchar** _tmp39_ = NULL;
	gchar** searchkeys;
	gint searchkeys_length1;
	gint _searchkeys_size_;
	GeeHashMap* _tmp40_;
	GeeHashMap* _tmp41_;
	NetsukukuNIP** _tmp42_ = NULL;
	NetsukukuNIP** nips;
	gint nips_length1;
	gint _nips_size_;
	NetsukukuKeyPair** _tmp43_ = NULL;
	NetsukukuKeyPair** keypairs;
	gint keypairs_length1;
	gint _keypairs_size_;
	gint* _tmp44_;
	gint _tmp44__length1;
	gint _tmp45_;
	gint _tmp46_;
	gint levels;
	gint* _tmp47_;
	gint _tmp47__length1;
	gint _tmp48_;
	gint _tmp49_;
	gint gsize;
	NetsukukuKeyPair** _tmp75_;
	gint _tmp75__length1;
	gchar* _tmp76_ = NULL;
	gchar* _tmp77_;
	gchar* _tmp78_ = NULL;
	gchar* _tmp79_;
	NetsukukuMapRoute** _tmp80_ = NULL;
	NetsukukuMapRoute** mrs;
	gint mrs_length1;
	gint _mrs_size_;
	gint keypairs_counter;
	gint hostname_counter;
	gint snsd_record_counter;
	gint snsdserver_alias_counter;
	gint snsdserver_values_counter;
	gint searchkeys_counter;
	NetsukukuNIP** _tmp81_;
	gint _tmp81__length1;
	GeeHashMap* _tmp366_;
	NetsukukuNIP** _tmp367_;
	gint _tmp367__length1;
	NetsukukuNIP* _tmp368_;
	gpointer _tmp369_ = NULL;
	NtkTestAndnaCounter* _tmp370_;
	NetsukukuAndna* _tmp371_;
	NetsukukuAndna* _tmp372_;
	NetsukukuAndna* _tmp373_;
	NetsukukuAndna* test;
	NetsukukuAndnaGetServersResponse* look_resp = NULL;
	NetsukukuAndna* _tmp374_;
	gchar* _tmp375_ = NULL;
	gchar* _tmp376_;
	NetsukukuAndnaServiceKey* _tmp377_;
	NetsukukuAndnaServiceKey* _tmp378_;
	NetsukukuAndnaGetServersResponse* _tmp379_ = NULL;
	NetsukukuAndnaGetServersResponse* _tmp380_;
	NetsukukuTimeCapsule* _tmp381_;
	NetsukukuTimeCapsule* _tmp382_;
	gchar* _tmp383_ = NULL;
	gchar* _tmp384_;
	const gchar* _tmp385_ = NULL;
	gchar* _tmp386_ = NULL;
	gchar* _tmp387_;
	NetsukukuAndnaGetServersResponse* _tmp388_;
	NetsukukuAndnaServers* _tmp389_;
	NetsukukuAndnaServers* _tmp390_;
	gboolean _tmp391_;
	gboolean _tmp392_;
	NetsukukuAndnaGetServersResponse* _tmp393_;
	NetsukukuAndnaServers* _tmp394_;
	NetsukukuAndnaServers* _tmp395_;
	GeeList* _tmp396_;
	GeeList* _tmp397_;
	gint _tmp398_;
	gint _tmp399_;
	NetsukukuAndna* _tmp420_;
	gchar* _tmp421_ = NULL;
	gchar* _tmp422_;
	NetsukukuAndnaServiceKey* _tmp423_;
	NetsukukuAndnaServiceKey* _tmp424_;
	NetsukukuAndnaGetServersResponse* _tmp425_ = NULL;
	NetsukukuAndnaGetServersResponse* _tmp426_;
	NetsukukuTimeCapsule* _tmp427_;
	NetsukukuTimeCapsule* _tmp428_;
	gchar* _tmp429_ = NULL;
	gchar* _tmp430_;
	const gchar* _tmp431_ = NULL;
	gchar* _tmp432_ = NULL;
	gchar* _tmp433_;
	NetsukukuAndnaGetServersResponse* _tmp434_;
	NetsukukuAndnaServers* _tmp435_;
	NetsukukuAndnaServers* _tmp436_;
	gboolean _tmp437_;
	gboolean _tmp438_;
	NetsukukuAndnaGetServersResponse* _tmp439_;
	NetsukukuAndnaServers* _tmp440_;
	NetsukukuAndnaServers* _tmp441_;
	GeeList* _tmp442_;
	GeeList* _tmp443_;
	gint _tmp444_;
	gint _tmp445_;
	NetsukukuNIP* found;
	NetsukukuNIP* _tmp508_;
	NetsukukuAndna* _tmp509_;
	gchar* _tmp510_ = NULL;
	gchar* _tmp511_;
	NetsukukuAndnaServiceKey* _tmp512_;
	NetsukukuAndnaServiceKey* _tmp513_;
	NetsukukuAndnaGetServersResponse* _tmp514_ = NULL;
	NetsukukuAndnaGetServersResponse* _tmp515_;
	NetsukukuAndnaServers* _tmp516_;
	NetsukukuAndnaServers* _tmp517_;
	GeeList* _tmp518_;
	GeeList* _tmp519_;
	gint _tmp520_;
	gint _tmp521_;
	gchar* _tmp522_ = NULL;
	gchar* _tmp523_;
	gchar* _tmp524_ = NULL;
	gchar* _tmp525_;
	NetsukukuAndnaGetServersResponse* _tmp526_;
	NetsukukuTimeCapsule* _tmp527_;
	NetsukukuTimeCapsule* _tmp528_;
	gchar* _tmp529_ = NULL;
	gchar* _tmp530_;
	const gchar* _tmp531_ = NULL;
	gchar* _tmp532_ = NULL;
	gchar* _tmp533_;
	NetsukukuAndnaGetServersResponse* _tmp534_;
	NetsukukuAndnaServers* _tmp535_;
	NetsukukuAndnaServers* _tmp536_;
	gboolean _tmp537_;
	gboolean _tmp538_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	ntk_test_print_out ("test_hook_and_replica started\n");
	int_set_1_counter = 0;
	_tmp0_ = g_new0 (gint, 82);
	_tmp0_[0] = 3;
	_tmp0_[1] = 4;
	_tmp0_[2] = 3;
	_tmp0_[3] = 0;
	_tmp0_[4] = 2;
	_tmp0_[5] = 0;
	_tmp0_[6] = 2;
	_tmp0_[7] = 0;
	_tmp0_[8] = 1;
	_tmp0_[9] = 1;
	_tmp0_[10] = 1;
	_tmp0_[11] = 1;
	_tmp0_[12] = 3;
	_tmp0_[13] = 1;
	_tmp0_[14] = 0;
	_tmp0_[15] = 3;
	_tmp0_[16] = 2;
	_tmp0_[17] = 1;
	_tmp0_[18] = 0;
	_tmp0_[19] = 2;
	_tmp0_[20] = 2;
	_tmp0_[21] = 1;
	_tmp0_[22] = 3;
	_tmp0_[23] = 1;
	_tmp0_[24] = 3;
	_tmp0_[25] = 1;
	_tmp0_[26] = 2;
	_tmp0_[27] = 1;
	_tmp0_[28] = 1;
	_tmp0_[29] = 0;
	_tmp0_[30] = 3;
	_tmp0_[31] = 0;
	_tmp0_[32] = 3;
	_tmp0_[33] = 0;
	_tmp0_[34] = 2;
	_tmp0_[35] = 0;
	_tmp0_[36] = 2;
	_tmp0_[37] = 0;
	_tmp0_[38] = 3;
	_tmp0_[39] = 1;
	_tmp0_[40] = 1;
	_tmp0_[41] = 0;
	_tmp0_[42] = 2;
	_tmp0_[43] = 2;
	_tmp0_[44] = 2;
	_tmp0_[45] = 0;
	_tmp0_[46] = 0;
	_tmp0_[47] = 2;
	_tmp0_[48] = 3;
	_tmp0_[49] = 0;
	_tmp0_[50] = 1;
	_tmp0_[51] = 1;
	_tmp0_[52] = 1;
	_tmp0_[53] = 0;
	_tmp0_[54] = 2;
	_tmp0_[55] = 2;
	_tmp0_[56] = 1;
	_tmp0_[57] = 0;
	_tmp0_[58] = 0;
	_tmp0_[59] = 0;
	_tmp0_[60] = 2;
	_tmp0_[61] = 0;
	_tmp0_[62] = 2;
	_tmp0_[63] = 3;
	_tmp0_[64] = 0;
	_tmp0_[65] = 0;
	_tmp0_[66] = 3;
	_tmp0_[67] = 3;
	_tmp0_[68] = 1;
	_tmp0_[69] = 0;
	_tmp0_[70] = 3;
	_tmp0_[71] = 2;
	_tmp0_[72] = 2;
	_tmp0_[73] = 0;
	_tmp0_[74] = 0;
	_tmp0_[75] = 2;
	_tmp0_[76] = 0;
	_tmp0_[77] = 0;
	_tmp0_[78] = 3;
	_tmp0_[79] = 3;
	_tmp0_[80] = 2;
	_tmp0_[81] = 0;
	int_set_1 = _tmp0_;
	int_set_1_length1 = 82;
	_int_set_1_size_ = int_set_1_length1;
	_tmp1_ = g_strdup ("luca.dionisi.perugia.it");
	_tmp2_ = g_strdup ("");
	_tmp3_ = g_strdup ("netsukuku.org");
	_tmp4_ = g_strdup ("2");
	_tmp5_ = g_strdup ("pegasus");
	_tmp6_ = g_strdup ("");
	_tmp7_ = g_strdup ("zeus");
	_tmp8_ = g_strdup ("");
	_tmp9_ = g_strdup ("andromeda");
	_tmp10_ = g_strdup ("");
	_tmp11_ = g_new0 (gchar*, 10 + 1);
	_tmp11_[0] = _tmp1_;
	_tmp11_[1] = _tmp2_;
	_tmp11_[2] = _tmp3_;
	_tmp11_[3] = _tmp4_;
	_tmp11_[4] = _tmp5_;
	_tmp11_[5] = _tmp6_;
	_tmp11_[6] = _tmp7_;
	_tmp11_[7] = _tmp8_;
	_tmp11_[8] = _tmp9_;
	_tmp11_[9] = _tmp10_;
	hostnames = _tmp11_;
	hostnames_length1 = 10;
	_hostnames_size_ = hostnames_length1;
	_tmp12_ = g_strdup ("");
	_tmp13_ = g_strdup ("");
	_tmp14_ = g_strdup ("1");
	_tmp15_ = g_strdup ("_www");
	_tmp16_ = g_strdup ("_tcp");
	_tmp17_ = g_strdup ("2");
	_tmp18_ = g_new0 (gchar*, 6 + 1);
	_tmp18_[0] = _tmp12_;
	_tmp18_[1] = _tmp13_;
	_tmp18_[2] = _tmp14_;
	_tmp18_[3] = _tmp15_;
	_tmp18_[4] = _tmp16_;
	_tmp18_[5] = _tmp17_;
	snsd_records = _tmp18_;
	snsd_records_length1 = 6;
	_snsd_records_size_ = snsd_records_length1;
	_tmp19_ = g_strdup ("");
	_tmp20_ = g_strdup ("");
	_tmp21_ = g_strdup ("luca.dionisi.perugia.it");
	_tmp22_ = g_strdup ("1");
	_tmp23_ = g_strdup ("");
	_tmp24_ = g_strdup ("");
	_tmp25_ = g_new0 (gchar*, 6 + 1);
	_tmp25_[0] = _tmp19_;
	_tmp25_[1] = _tmp20_;
	_tmp25_[2] = _tmp21_;
	_tmp25_[3] = _tmp22_;
	_tmp25_[4] = _tmp23_;
	_tmp25_[5] = _tmp24_;
	snsdserver_alias = _tmp25_;
	snsdserver_alias_length1 = 6;
	_snsdserver_alias_size_ = snsdserver_alias_length1;
	_tmp26_ = g_new0 (gint, 9);
	_tmp26_[0] = 1;
	_tmp26_[1] = 1;
	_tmp26_[2] = 1;
	_tmp26_[3] = 1;
	_tmp26_[4] = 50;
	_tmp26_[5] = 80;
	_tmp26_[6] = 1;
	_tmp26_[7] = 50;
	_tmp26_[8] = 80;
	snsdserver_values = _tmp26_;
	snsdserver_values_length1 = 9;
	_snsdserver_values_size_ = snsdserver_values_length1;
	_tmp27_ = g_strdup ("k1");
	_tmp28_ = g_strdup ("1");
	_tmp29_ = g_strdup ("kn");
	_tmp30_ = g_strdup ("1");
	_tmp31_ = g_strdup ("pippo");
	_tmp32_ = g_strdup ("");
	_tmp33_ = g_strdup ("athena");
	_tmp34_ = g_strdup ("1");
	_tmp35_ = g_strdup ("zeus");
	_tmp36_ = g_strdup ("1");
	_tmp37_ = g_strdup ("dedalo");
	_tmp38_ = g_strdup ("1");
	_tmp39_ = g_new0 (gchar*, 12 + 1);
	_tmp39_[0] = _tmp27_;
	_tmp39_[1] = _tmp28_;
	_tmp39_[2] = _tmp29_;
	_tmp39_[3] = _tmp30_;
	_tmp39_[4] = _tmp31_;
	_tmp39_[5] = _tmp32_;
	_tmp39_[6] = _tmp33_;
	_tmp39_[7] = _tmp34_;
	_tmp39_[8] = _tmp35_;
	_tmp39_[9] = _tmp36_;
	_tmp39_[10] = _tmp37_;
	_tmp39_[11] = _tmp38_;
	searchkeys = _tmp39_;
	searchkeys_length1 = 12;
	_searchkeys_size_ = searchkeys_length1;
	_tmp40_ = gee_hash_map_new (NETSUKUKU_TYPE_NIP, (GBoxedCopyFunc) g_object_ref, g_object_unref, NTK_TEST_TYPE_ANDNA_COUNTER, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_partial_nip_hash_func_gee_hash_data_func, NULL, NULL, _netsukuku_partial_nip_equal_func_gee_equal_data_func, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (ntk_test_nodes);
	ntk_test_nodes = _tmp40_;
	_tmp41_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NTK_TEST_TYPE_ANDNA_COUNTER, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (ntk_test_nodes_by_niptostr);
	ntk_test_nodes_by_niptostr = _tmp41_;
	_tmp42_ = g_new0 (NetsukukuNIP*, 0 + 1);
	nips = _tmp42_;
	nips_length1 = 0;
	_nips_size_ = nips_length1;
	_tmp43_ = g_new0 (NetsukukuKeyPair*, 0 + 1);
	keypairs = _tmp43_;
	keypairs_length1 = 0;
	_keypairs_size_ = keypairs_length1;
	_tmp44_ = int_set_1;
	_tmp44__length1 = int_set_1_length1;
	_tmp45_ = int_set_1_counter;
	int_set_1_counter = _tmp45_ + 1;
	_tmp46_ = _tmp44_[_tmp45_];
	levels = _tmp46_;
	_tmp47_ = int_set_1;
	_tmp47__length1 = int_set_1_length1;
	_tmp48_ = int_set_1_counter;
	int_set_1_counter = _tmp48_ + 1;
	_tmp49_ = _tmp47_[_tmp48_];
	gsize = _tmp49_;
	ntk_test_print_out ("generating keys...\n");
	while (TRUE) {
		gint _tmp50_;
		gint* _tmp51_ = NULL;
		gint* positions;
		gint positions_length1;
		gint _positions_size_;
		gint* _tmp63_;
		gint _tmp63__length1;
		NetsukukuNIP* _tmp64_;
		NetsukukuNIP* nip;
		NetsukukuNIP** _tmp65_;
		gint _tmp65__length1;
		NetsukukuNIP* _tmp66_;
		NetsukukuNIP* _tmp67_;
		NetsukukuKeyPair* _tmp68_;
		NetsukukuKeyPair* keypair;
		NetsukukuKeyPair** _tmp69_;
		gint _tmp69__length1;
		NetsukukuKeyPair* _tmp70_;
		NetsukukuKeyPair* _tmp71_;
		gint _tmp72_;
		gint _tmp73_;
		gint* _tmp74_;
		gint _tmp74__length1;
		_tmp50_ = levels;
		_tmp51_ = g_new0 (gint, _tmp50_);
		positions = _tmp51_;
		positions_length1 = _tmp50_;
		_positions_size_ = positions_length1;
		{
			gint _tmp52_;
			gint i;
			_tmp52_ = levels;
			i = _tmp52_ - 1;
			{
				gboolean _tmp53_;
				_tmp53_ = TRUE;
				while (TRUE) {
					gboolean _tmp54_;
					gint _tmp56_;
					gint* _tmp57_;
					gint _tmp57__length1;
					gint _tmp58_;
					gint* _tmp59_;
					gint _tmp59__length1;
					gint _tmp60_;
					gint _tmp61_;
					gint _tmp62_;
					_tmp54_ = _tmp53_;
					if (!_tmp54_) {
						gint _tmp55_;
						_tmp55_ = i;
						i = _tmp55_ - 1;
					}
					_tmp53_ = FALSE;
					_tmp56_ = i;
					if (!(_tmp56_ >= 0)) {
						break;
					}
					_tmp57_ = positions;
					_tmp57__length1 = positions_length1;
					_tmp58_ = i;
					_tmp59_ = int_set_1;
					_tmp59__length1 = int_set_1_length1;
					_tmp60_ = int_set_1_counter;
					int_set_1_counter = _tmp60_ + 1;
					_tmp61_ = _tmp59_[_tmp60_];
					_tmp57_[_tmp58_] = _tmp61_;
					_tmp62_ = _tmp57_[_tmp58_];
				}
			}
		}
		_tmp63_ = positions;
		_tmp63__length1 = positions_length1;
		_tmp64_ = netsukuku_nip_new (_tmp63_, _tmp63__length1);
		nip = _tmp64_;
		_tmp65_ = nips;
		_tmp65__length1 = nips_length1;
		_tmp66_ = nip;
		_tmp67_ = _g_object_ref0 (_tmp66_);
		_vala_array_add1 (&nips, &nips_length1, &_nips_size_, _tmp67_);
		_tmp68_ = netsukuku_key_pair_new (NULL, &_inner_error_);
		keypair = _tmp68_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (nip);
			positions = (g_free (positions), NULL);
			keypairs = (_vala_array_free (keypairs, keypairs_length1, (GDestroyNotify) g_object_unref), NULL);
			nips = (_vala_array_free (nips, nips_length1, (GDestroyNotify) g_object_unref), NULL);
			searchkeys = (_vala_array_free (searchkeys, searchkeys_length1, (GDestroyNotify) g_free), NULL);
			snsdserver_values = (g_free (snsdserver_values), NULL);
			snsdserver_alias = (_vala_array_free (snsdserver_alias, snsdserver_alias_length1, (GDestroyNotify) g_free), NULL);
			snsd_records = (_vala_array_free (snsd_records, snsd_records_length1, (GDestroyNotify) g_free), NULL);
			hostnames = (_vala_array_free (hostnames, hostnames_length1, (GDestroyNotify) g_free), NULL);
			int_set_1 = (g_free (int_set_1), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp69_ = keypairs;
		_tmp69__length1 = keypairs_length1;
		_tmp70_ = keypair;
		_tmp71_ = _g_object_ref0 (_tmp70_);
		_vala_array_add2 (&keypairs, &keypairs_length1, &_keypairs_size_, _tmp71_);
		_tmp72_ = int_set_1_counter;
		int_set_1_counter = _tmp72_ + 1;
		_tmp73_ = int_set_1_counter;
		_tmp74_ = int_set_1;
		_tmp74__length1 = int_set_1_length1;
		if (_tmp73_ >= _tmp74__length1) {
			_g_object_unref0 (keypair);
			_g_object_unref0 (nip);
			positions = (g_free (positions), NULL);
			break;
		}
		_g_object_unref0 (keypair);
		_g_object_unref0 (nip);
		positions = (g_free (positions), NULL);
	}
	_tmp75_ = keypairs;
	_tmp75__length1 = keypairs_length1;
	_tmp76_ = g_strdup_printf ("%i", _tmp75__length1);
	_tmp77_ = _tmp76_;
	_tmp78_ = g_strconcat (_tmp77_, " keypairs done.\n", NULL);
	_tmp79_ = _tmp78_;
	ntk_test_print_out (_tmp79_);
	_g_free0 (_tmp79_);
	_g_free0 (_tmp77_);
	_tmp80_ = g_new0 (NetsukukuMapRoute*, 0 + 1);
	mrs = _tmp80_;
	mrs_length1 = 0;
	_mrs_size_ = mrs_length1;
	int_set_1_counter = 2;
	keypairs_counter = 0;
	hostname_counter = 0;
	snsd_record_counter = 0;
	snsdserver_alias_counter = 0;
	snsdserver_values_counter = 0;
	searchkeys_counter = 0;
	_tmp81_ = nips;
	_tmp81__length1 = nips_length1;
	{
		NetsukukuNIP** nip_collection = NULL;
		gint nip_collection_length1 = 0;
		gint _nip_collection_size_ = 0;
		gint nip_it = 0;
		nip_collection = _tmp81_;
		nip_collection_length1 = _tmp81__length1;
		for (nip_it = 0; nip_it < _tmp81__length1; nip_it = nip_it + 1) {
			NetsukukuNIP* _tmp82_;
			NetsukukuNIP* nip = NULL;
			_tmp82_ = _g_object_ref0 (nip_collection[nip_it]);
			nip = _tmp82_;
			{
				NetsukukuAggregatedNeighbourManager* _tmp83_;
				NetsukukuAggregatedNeighbourManager* anm;
				gint _tmp84_;
				gint _tmp85_;
				NetsukukuNIP* _tmp86_;
				NetsukukuMapRoute* _tmp87_;
				NetsukukuMapRoute* mr;
				NetsukukuMapRoute** _tmp88_;
				gint _tmp88__length1;
				NetsukukuMapRoute* _tmp89_;
				NetsukukuMapRoute* _tmp90_;
				NetsukukuPeerToPeerAll* _tmp91_;
				NetsukukuPeerToPeerAll* ptpall;
				NetsukukuKeyPair** _tmp92_;
				gint _tmp92__length1;
				gint _tmp93_;
				NetsukukuKeyPair* _tmp94_;
				NetsukukuKeyPair* _tmp95_;
				NetsukukuKeyPair* keypair;
				NetsukukuKeyPair* _tmp96_;
				NetsukukuAggregatedNeighbourManager* _tmp97_;
				NetsukukuMapRoute* _tmp98_;
				NetsukukuPeerToPeerAll* _tmp99_;
				NtkTestCounterDebug* _tmp100_;
				NetsukukuCounter* counter;
				NetsukukuKeyPair* _tmp101_;
				NetsukukuCounter* _tmp102_;
				NetsukukuAggregatedNeighbourManager* _tmp103_;
				NetsukukuMapRoute* _tmp104_;
				NetsukukuPeerToPeerAll* _tmp105_;
				NetsukukuAndna* _tmp106_;
				NetsukukuAndna* andna;
				NetsukukuCounter* _tmp107_;
				NetsukukuAndna* _tmp108_;
				NtkTestAndnaCounter* _tmp109_;
				NtkTestAndnaCounter* andnacounter;
				NtkTestAndnaCounter* _tmp110_;
				NetsukukuAndna* _tmp111_;
				NetsukukuAndna* _tmp112_;
				NtkTestAndnaCounter* _tmp113_;
				NetsukukuCounter* _tmp114_;
				NetsukukuCounter* _tmp115_;
				NetsukukuCounter* _tmp116_;
				NetsukukuAndna* _tmp117_;
				GeeHashMap* _tmp122_;
				NetsukukuMapRoute* _tmp123_;
				NetsukukuNIP* _tmp124_;
				NtkTestAndnaCounter* _tmp125_;
				GeeHashMap* _tmp126_;
				gint _tmp127_;
				gint _tmp128_;
				NetsukukuMapRoute* _tmp129_;
				NetsukukuNIP* _tmp130_;
				gchar* _tmp131_ = NULL;
				gchar* _tmp132_;
				NtkTestAndnaCounter* _tmp133_;
				gint _tmp134_;
				gint _tmp135_;
				gint* _tmp136_;
				gint _tmp136__length1;
				gint _tmp137_;
				gint _tmp138_;
				gint store;
				GeeArrayList* _tmp139_;
				GeeArrayList* myhostnames;
				GeeArrayList* _tmp165_;
				GeeArrayList* _tmp166_ = NULL;
				GeeList* hashed_hostnames;
				NetsukukuMapRoute* _tmp182_;
				NetsukukuNIP* _tmp183_;
				GeeList* _tmp184_;
				gint _tmp185_ = 0;
				guchar* _tmp186_ = NULL;
				guchar* msg_counter;
				gint msg_counter_length1;
				gint _msg_counter_size_;
				NetsukukuKeyPair* _tmp187_;
				guchar* _tmp188_;
				gint _tmp188__length1;
				gint _tmp189_ = 0;
				guchar* _tmp190_ = NULL;
				guchar* signed_counter;
				gint signed_counter_length1;
				gint _signed_counter_size_;
				guchar* _tmp191_;
				gint _tmp191__length1;
				zcdSerializableBuffer* _tmp192_;
				zcdSerializableBuffer* signature_counter;
				NetsukukuCounter* _tmp193_;
				NetsukukuMapRoute* _tmp194_;
				NetsukukuNIP* _tmp195_;
				NetsukukuRmtCounterPeer* _tmp196_ = NULL;
				NetsukukuRmtCounterPeer* _tmp197_;
				NetsukukuMapRoute* _tmp198_;
				NetsukukuNIP* _tmp199_;
				GeeList* _tmp200_;
				NetsukukuKeyPair* _tmp201_;
				NetsukukuPublicKeyWrapper* _tmp202_;
				NetsukukuPublicKeyWrapper* _tmp203_;
				NetsukukuPublicKey* _tmp204_ = NULL;
				NetsukukuPublicKey* _tmp205_;
				zcdSerializableBuffer* _tmp206_;
				NetsukukuCounterSetDataResponse* _tmp207_ = NULL;
				NetsukukuCounterSetDataResponse* _tmp208_;
				NetsukukuCounterSetDataResponse* resp_counter;
				NetsukukuCounterSetDataResponse* _tmp209_;
				const gchar* _tmp210_;
				const gchar* _tmp211_;
				const gchar* _tmp212_ = NULL;
				gchar* _tmp213_ = NULL;
				gchar* _tmp214_;
				NetsukukuCounterSetDataResponse* _tmp215_;
				const gchar* _tmp216_;
				const gchar* _tmp217_;
				gint _tmp364_;
				gint _tmp365_;
				_tmp83_ = netsukuku_aggregated_neighbour_manager_new ();
				anm = _tmp83_;
				_tmp84_ = levels;
				_tmp85_ = gsize;
				_tmp86_ = nip;
				_tmp87_ = netsukuku_map_route_new (_tmp84_, _tmp85_, _tmp86_);
				mr = _tmp87_;
				_tmp88_ = mrs;
				_tmp88__length1 = mrs_length1;
				_tmp89_ = mr;
				_tmp90_ = _g_object_ref0 (_tmp89_);
				_vala_array_add3 (&mrs, &mrs_length1, &_mrs_size_, _tmp90_);
				_tmp91_ = netsukuku_peer_to_peer_all_new ();
				ptpall = _tmp91_;
				_tmp92_ = keypairs;
				_tmp92__length1 = keypairs_length1;
				_tmp93_ = keypairs_counter;
				keypairs_counter = _tmp93_ + 1;
				_tmp94_ = _tmp92_[_tmp93_];
				_tmp95_ = _g_object_ref0 (_tmp94_);
				keypair = _tmp95_;
				_tmp96_ = keypair;
				_tmp97_ = anm;
				_tmp98_ = mr;
				_tmp99_ = ptpall;
				_tmp100_ = ntk_test_counter_debug_new (_tmp96_, _tmp97_, _tmp98_, _tmp99_);
				counter = (NetsukukuCounter*) _tmp100_;
				_tmp101_ = keypair;
				_tmp102_ = counter;
				_tmp103_ = anm;
				_tmp104_ = mr;
				_tmp105_ = ptpall;
				_tmp106_ = netsukuku_andna_new (_tmp101_, _tmp102_, _tmp103_, _tmp104_, _tmp105_);
				andna = _tmp106_;
				_tmp107_ = counter;
				_tmp108_ = andna;
				netsukuku_counter_set_andna (_tmp107_, _tmp108_);
				_tmp109_ = ntk_test_andna_counter_new ();
				andnacounter = _tmp109_;
				_tmp110_ = andnacounter;
				_tmp111_ = andna;
				_tmp112_ = _g_object_ref0 (_tmp111_);
				_g_object_unref0 (_tmp110_->andna);
				_tmp110_->andna = _tmp112_;
				_tmp113_ = andnacounter;
				_tmp114_ = counter;
				_tmp115_ = _g_object_ref0 (_tmp114_);
				_g_object_unref0 (_tmp113_->counter);
				_tmp113_->counter = _tmp115_;
				_tmp116_ = counter;
				g_signal_emit_by_name ((NetsukukuPeerToPeer*) _tmp116_, "map-peer-to-peer-validated");
				_tmp117_ = andna;
				g_signal_emit_by_name ((NetsukukuPeerToPeer*) _tmp117_, "map-peer-to-peer-validated");
				while (TRUE) {
					NetsukukuCounter* _tmp118_;
					gboolean _tmp119_;
					_tmp118_ = counter;
					_tmp119_ = _tmp118_->memory_initialized;
					if (!(!_tmp119_)) {
						break;
					}
					tasklets_tasklet_nap ((glong) 0, (glong) 10000);
				}
				while (TRUE) {
					NetsukukuAndna* _tmp120_;
					gboolean _tmp121_;
					_tmp120_ = andna;
					_tmp121_ = _tmp120_->memory_initialized;
					if (!(!_tmp121_)) {
						break;
					}
					tasklets_tasklet_nap ((glong) 0, (glong) 10000);
				}
				_tmp122_ = ntk_test_nodes;
				_tmp123_ = mr;
				_tmp124_ = _tmp123_->me;
				_tmp125_ = andnacounter;
				gee_abstract_map_set ((GeeAbstractMap*) _tmp122_, _tmp124_, _tmp125_);
				_tmp126_ = ntk_test_nodes_by_niptostr;
				_tmp127_ = levels;
				_tmp128_ = gsize;
				_tmp129_ = mr;
				_tmp130_ = _tmp129_->me;
				_tmp131_ = netsukuku_nip_to_str (_tmp127_, _tmp128_, _tmp130_);
				_tmp132_ = _tmp131_;
				_tmp133_ = andnacounter;
				gee_abstract_map_set ((GeeAbstractMap*) _tmp126_, _tmp132_, _tmp133_);
				_g_free0 (_tmp132_);
				_tmp134_ = int_set_1_counter;
				_tmp135_ = levels;
				int_set_1_counter = _tmp134_ + _tmp135_;
				_tmp136_ = int_set_1;
				_tmp136__length1 = int_set_1_length1;
				_tmp137_ = int_set_1_counter;
				int_set_1_counter = _tmp137_ + 1;
				_tmp138_ = _tmp136_[_tmp137_];
				store = _tmp138_;
				_tmp139_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
				myhostnames = _tmp139_;
				{
					gint i_name;
					i_name = 0;
					{
						gboolean _tmp140_;
						_tmp140_ = TRUE;
						while (TRUE) {
							gboolean _tmp141_;
							gint _tmp143_;
							gint _tmp144_;
							GeeArrayList* _tmp145_;
							gchar** _tmp146_;
							gint _tmp146__length1;
							gint _tmp147_;
							gint _tmp148_;
							const gchar* _tmp149_;
							_tmp141_ = _tmp140_;
							if (!_tmp141_) {
								gint _tmp142_;
								_tmp142_ = i_name;
								i_name = _tmp142_ + 1;
							}
							_tmp140_ = FALSE;
							_tmp143_ = i_name;
							_tmp144_ = store;
							if (!(_tmp143_ < _tmp144_)) {
								break;
							}
							_tmp145_ = myhostnames;
							_tmp146_ = hostnames;
							_tmp146__length1 = hostnames_length1;
							_tmp147_ = hostname_counter;
							_tmp148_ = i_name;
							_tmp149_ = _tmp146_[_tmp147_ + (_tmp148_ * 2)];
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp145_, _tmp149_);
						}
					}
				}
				{
					GeeArrayList* _tmp150_;
					GeeArrayList* _tmp151_;
					GeeArrayList* _hn_list;
					GeeArrayList* _tmp152_;
					gint _tmp153_;
					gint _tmp154_;
					gint _hn_size;
					gint _hn_index;
					_tmp150_ = myhostnames;
					_tmp151_ = _g_object_ref0 (_tmp150_);
					_hn_list = _tmp151_;
					_tmp152_ = _hn_list;
					_tmp153_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp152_);
					_tmp154_ = _tmp153_;
					_hn_size = _tmp154_;
					_hn_index = -1;
					while (TRUE) {
						gint _tmp155_;
						gint _tmp156_;
						gint _tmp157_;
						GeeArrayList* _tmp158_;
						gint _tmp159_;
						gpointer _tmp160_ = NULL;
						gchar* hn;
						const gchar* _tmp161_;
						const gchar* _tmp162_ = NULL;
						gchar* _tmp163_ = NULL;
						gchar* _tmp164_;
						_tmp155_ = _hn_index;
						_hn_index = _tmp155_ + 1;
						_tmp156_ = _hn_index;
						_tmp157_ = _hn_size;
						if (!(_tmp156_ < _tmp157_)) {
							break;
						}
						_tmp158_ = _hn_list;
						_tmp159_ = _hn_index;
						_tmp160_ = gee_abstract_list_get ((GeeAbstractList*) _tmp158_, _tmp159_);
						hn = (gchar*) _tmp160_;
						_tmp161_ = hn;
						_tmp162_ = string_to_string (_tmp161_);
						_tmp163_ = g_strconcat ("On Counter I will register hash for ", _tmp162_, ".\n", NULL);
						_tmp164_ = _tmp163_;
						ntk_test_print_out (_tmp164_);
						_g_free0 (_tmp164_);
						_g_free0 (hn);
					}
					_g_object_unref0 (_hn_list);
				}
				_tmp165_ = myhostnames;
				_tmp166_ = netsukuku_counter_utilities_hash_names (_tmp165_);
				hashed_hostnames = (GeeList*) _tmp166_;
				{
					GeeList* _tmp167_;
					GeeList* _tmp168_;
					GeeList* _hhn_list;
					GeeList* _tmp169_;
					gint _tmp170_;
					gint _tmp171_;
					gint _hhn_size;
					gint _hhn_index;
					_tmp167_ = hashed_hostnames;
					_tmp168_ = _g_object_ref0 (_tmp167_);
					_hhn_list = _tmp168_;
					_tmp169_ = _hhn_list;
					_tmp170_ = gee_collection_get_size ((GeeCollection*) _tmp169_);
					_tmp171_ = _tmp170_;
					_hhn_size = _tmp171_;
					_hhn_index = -1;
					while (TRUE) {
						gint _tmp172_;
						gint _tmp173_;
						gint _tmp174_;
						GeeList* _tmp175_;
						gint _tmp176_;
						gpointer _tmp177_ = NULL;
						gchar* hhn;
						const gchar* _tmp178_;
						const gchar* _tmp179_ = NULL;
						gchar* _tmp180_ = NULL;
						gchar* _tmp181_;
						_tmp172_ = _hhn_index;
						_hhn_index = _tmp172_ + 1;
						_tmp173_ = _hhn_index;
						_tmp174_ = _hhn_size;
						if (!(_tmp173_ < _tmp174_)) {
							break;
						}
						_tmp175_ = _hhn_list;
						_tmp176_ = _hhn_index;
						_tmp177_ = gee_list_get (_tmp175_, _tmp176_);
						hhn = (gchar*) _tmp177_;
						_tmp178_ = hhn;
						_tmp179_ = string_to_string (_tmp178_);
						_tmp180_ = g_strconcat ("On Counter I will register ", _tmp179_, ".\n", NULL);
						_tmp181_ = _tmp180_;
						ntk_test_print_out (_tmp181_);
						_g_free0 (_tmp181_);
						_g_free0 (hhn);
					}
					_g_object_unref0 (_hhn_list);
				}
				_tmp182_ = mr;
				_tmp183_ = _tmp182_->me;
				_tmp184_ = hashed_hostnames;
				_tmp186_ = netsukuku_counter_utilities_prepare_msg (_tmp183_, _tmp184_, &_tmp185_);
				msg_counter = _tmp186_;
				msg_counter_length1 = _tmp185_;
				_msg_counter_size_ = msg_counter_length1;
				_tmp187_ = keypair;
				_tmp188_ = msg_counter;
				_tmp188__length1 = msg_counter_length1;
				_tmp190_ = netsukuku_key_pair_sign (_tmp187_, _tmp188_, _tmp188__length1, &_tmp189_, &_inner_error_);
				signed_counter = _tmp190_;
				signed_counter_length1 = _tmp189_;
				_signed_counter_size_ = signed_counter_length1;
				if (_inner_error_ != NULL) {
					msg_counter = (g_free (msg_counter), NULL);
					_g_object_unref0 (hashed_hostnames);
					_g_object_unref0 (myhostnames);
					_g_object_unref0 (andnacounter);
					_g_object_unref0 (andna);
					_g_object_unref0 (counter);
					_g_object_unref0 (keypair);
					_g_object_unref0 (ptpall);
					_g_object_unref0 (mr);
					_g_object_unref0 (anm);
					_g_object_unref0 (nip);
					mrs = (_vala_array_free (mrs, mrs_length1, (GDestroyNotify) g_object_unref), NULL);
					keypairs = (_vala_array_free (keypairs, keypairs_length1, (GDestroyNotify) g_object_unref), NULL);
					nips = (_vala_array_free (nips, nips_length1, (GDestroyNotify) g_object_unref), NULL);
					searchkeys = (_vala_array_free (searchkeys, searchkeys_length1, (GDestroyNotify) g_free), NULL);
					snsdserver_values = (g_free (snsdserver_values), NULL);
					snsdserver_alias = (_vala_array_free (snsdserver_alias, snsdserver_alias_length1, (GDestroyNotify) g_free), NULL);
					snsd_records = (_vala_array_free (snsd_records, snsd_records_length1, (GDestroyNotify) g_free), NULL);
					hostnames = (_vala_array_free (hostnames, hostnames_length1, (GDestroyNotify) g_free), NULL);
					int_set_1 = (g_free (int_set_1), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_tmp191_ = signed_counter;
				_tmp191__length1 = signed_counter_length1;
				_tmp192_ = zcd_serializable_buffer_new ((guint8*) _tmp191_, (_tmp191__length1 * sizeof (guchar)) / sizeof (guint8));
				signature_counter = _tmp192_;
				_tmp193_ = counter;
				_tmp194_ = mr;
				_tmp195_ = _tmp194_->me;
				_tmp196_ = netsukuku_counter_peer (_tmp193_, NULL, (GObject*) _tmp195_, NULL);
				_tmp197_ = _tmp196_;
				_tmp198_ = mr;
				_tmp199_ = _tmp198_->me;
				_tmp200_ = hashed_hostnames;
				_tmp201_ = keypair;
				_tmp202_ = netsukuku_key_pair_get_pub_key (_tmp201_);
				_tmp203_ = _tmp202_;
				_tmp204_ = netsukuku_public_key_wrapper_to_pubkey (_tmp203_);
				_tmp205_ = _tmp204_;
				_tmp206_ = signature_counter;
				_tmp207_ = netsukuku_icounter_as_peer_set_data_for_pubk ((NetsukukuICounterAsPeer*) _tmp197_, _tmp199_, _tmp200_, _tmp205_, _tmp206_, TRUE, &_inner_error_);
				_tmp208_ = _tmp207_;
				_g_object_unref0 (_tmp205_);
				_g_object_unref0 (_tmp197_);
				resp_counter = _tmp208_;
				if (_inner_error_ != NULL) {
					_g_object_unref0 (signature_counter);
					signed_counter = (g_free (signed_counter), NULL);
					msg_counter = (g_free (msg_counter), NULL);
					_g_object_unref0 (hashed_hostnames);
					_g_object_unref0 (myhostnames);
					_g_object_unref0 (andnacounter);
					_g_object_unref0 (andna);
					_g_object_unref0 (counter);
					_g_object_unref0 (keypair);
					_g_object_unref0 (ptpall);
					_g_object_unref0 (mr);
					_g_object_unref0 (anm);
					_g_object_unref0 (nip);
					mrs = (_vala_array_free (mrs, mrs_length1, (GDestroyNotify) g_object_unref), NULL);
					keypairs = (_vala_array_free (keypairs, keypairs_length1, (GDestroyNotify) g_object_unref), NULL);
					nips = (_vala_array_free (nips, nips_length1, (GDestroyNotify) g_object_unref), NULL);
					searchkeys = (_vala_array_free (searchkeys, searchkeys_length1, (GDestroyNotify) g_free), NULL);
					snsdserver_values = (g_free (snsdserver_values), NULL);
					snsdserver_alias = (_vala_array_free (snsdserver_alias, snsdserver_alias_length1, (GDestroyNotify) g_free), NULL);
					snsd_records = (_vala_array_free (snsd_records, snsd_records_length1, (GDestroyNotify) g_free), NULL);
					hostnames = (_vala_array_free (hostnames, hostnames_length1, (GDestroyNotify) g_free), NULL);
					int_set_1 = (g_free (int_set_1), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_tmp209_ = resp_counter;
				_tmp210_ = netsukuku_counter_set_data_response_get_response (_tmp209_);
				_tmp211_ = _tmp210_;
				_tmp212_ = string_to_string (_tmp211_);
				_tmp213_ = g_strconcat ("CounterSetDataResponse ", _tmp212_, "\n", NULL);
				_tmp214_ = _tmp213_;
				ntk_test_print_out (_tmp214_);
				_g_free0 (_tmp214_);
				_tmp215_ = resp_counter;
				_tmp216_ = netsukuku_counter_set_data_response_get_response (_tmp215_);
				_tmp217_ = _tmp216_;
				_vala_assert (g_strcmp0 (_tmp217_, "OK") == 0, "resp_counter.response == \"OK\"");
				tasklets_tasklet_nap ((glong) 0, (glong) 10000);
				{
					gint i_name;
					i_name = 0;
					{
						gboolean _tmp218_;
						_tmp218_ = TRUE;
						while (TRUE) {
							gboolean _tmp219_;
							gint _tmp221_;
							gint _tmp222_;
							gchar** _tmp223_;
							gint _tmp223__length1;
							gint _tmp224_;
							gint _tmp225_;
							const gchar* _tmp226_;
							gchar* _tmp227_;
							gchar* hostname;
							const gchar* _tmp228_;
							const gchar* _tmp229_ = NULL;
							gchar* _tmp230_ = NULL;
							gchar* _tmp231_;
							gchar** _tmp232_;
							gint _tmp232__length1;
							gint _tmp233_;
							gint _tmp234_;
							const gchar* _tmp235_;
							gchar* _tmp236_;
							gchar* num_snsd_str;
							GeeHashMap* services;
							const gchar* _tmp237_;
							const gchar* _tmp328_;
							GeeHashMap* _tmp329_;
							NetsukukuAndnaPrivateConfiguration* _tmp330_;
							NetsukukuAndnaPrivateConfiguration* cfg;
							NetsukukuAndna* _tmp331_;
							NetsukukuAndnaPrivateConfiguration* _tmp332_;
							NetsukukuAndnaDomainRequest* _tmp333_ = NULL;
							NetsukukuAndnaDomainRequest* andna_req;
							NetsukukuAndnaDomainRequest* _tmp334_;
							gint _tmp335_ = 0;
							guchar* _tmp336_ = NULL;
							guchar* message_andna;
							gint message_andna_length1;
							gint _message_andna_size_;
							NetsukukuKeyPair* _tmp337_;
							guchar* _tmp338_;
							gint _tmp338__length1;
							gint _tmp339_ = 0;
							guchar* _tmp340_ = NULL;
							guchar* signed_andna;
							gint signed_andna_length1;
							gint _signed_andna_size_;
							guchar* _tmp341_;
							gint _tmp341__length1;
							zcdSerializableBuffer* _tmp342_;
							zcdSerializableBuffer* signature_andna;
							NetsukukuAndna* _tmp343_;
							NetsukukuAndnaDomainRequest* _tmp344_;
							const gchar* _tmp345_;
							const gchar* _tmp346_;
							NetsukukuAndnaServiceHashnodeKey* _tmp347_;
							NetsukukuAndnaServiceHashnodeKey* _tmp348_;
							NetsukukuRmtAndnaPeer* _tmp349_ = NULL;
							NetsukukuRmtAndnaPeer* _tmp350_;
							NetsukukuAndnaDomainRequest* _tmp351_;
							zcdSerializableBuffer* _tmp352_;
							NetsukukuAndnaRegisterMainResponse* _tmp353_ = NULL;
							NetsukukuAndnaRegisterMainResponse* _tmp354_;
							NetsukukuAndnaRegisterMainResponse* resp_andna;
							NetsukukuAndnaRegisterMainResponse* _tmp355_;
							const gchar* _tmp356_;
							const gchar* _tmp357_;
							const gchar* _tmp358_ = NULL;
							gchar* _tmp359_ = NULL;
							gchar* _tmp360_;
							NetsukukuAndnaRegisterMainResponse* _tmp361_;
							const gchar* _tmp362_;
							const gchar* _tmp363_;
							_tmp219_ = _tmp218_;
							if (!_tmp219_) {
								gint _tmp220_;
								_tmp220_ = i_name;
								i_name = _tmp220_ + 1;
							}
							_tmp218_ = FALSE;
							_tmp221_ = i_name;
							_tmp222_ = store;
							if (!(_tmp221_ < _tmp222_)) {
								break;
							}
							_tmp223_ = hostnames;
							_tmp223__length1 = hostnames_length1;
							_tmp224_ = hostname_counter;
							_tmp225_ = i_name;
							_tmp226_ = _tmp223_[_tmp224_ + (_tmp225_ * 2)];
							_tmp227_ = g_strdup (_tmp226_);
							hostname = _tmp227_;
							_tmp228_ = hostname;
							_tmp229_ = string_to_string (_tmp228_);
							_tmp230_ = g_strconcat ("On Andna I will register ", _tmp229_, "\n", NULL);
							_tmp231_ = _tmp230_;
							ntk_test_print_out (_tmp231_);
							_g_free0 (_tmp231_);
							_tmp232_ = hostnames;
							_tmp232__length1 = hostnames_length1;
							_tmp233_ = hostname_counter;
							_tmp234_ = i_name;
							_tmp235_ = _tmp232_[(_tmp233_ + (_tmp234_ * 2)) + 1];
							_tmp236_ = g_strdup (_tmp235_);
							num_snsd_str = _tmp236_;
							services = NULL;
							_tmp237_ = num_snsd_str;
							if (g_strcmp0 (_tmp237_, "") != 0) {
								const gchar* _tmp238_;
								gint _tmp239_ = 0;
								gint num_snsd;
								gint _tmp240_;
								gchar* _tmp241_ = NULL;
								gchar* _tmp242_;
								gchar* _tmp243_ = NULL;
								gchar* _tmp244_;
								GeeHashMap* _tmp245_ = NULL;
								_tmp238_ = num_snsd_str;
								_tmp239_ = atoi (_tmp238_);
								num_snsd = _tmp239_;
								_tmp240_ = num_snsd;
								_tmp241_ = g_strdup_printf ("%i", _tmp240_);
								_tmp242_ = _tmp241_;
								_tmp243_ = g_strconcat ("this includes ", _tmp242_, " scattered services\n", NULL);
								_tmp244_ = _tmp243_;
								ntk_test_print_out (_tmp244_);
								_g_free0 (_tmp244_);
								_g_free0 (_tmp242_);
								_tmp245_ = netsukuku_andna_private_configuration_make_empty_services ();
								_g_object_unref0 (services);
								services = _tmp245_;
								{
									gint i_key;
									i_key = 0;
									{
										gboolean _tmp246_;
										_tmp246_ = TRUE;
										while (TRUE) {
											gboolean _tmp247_;
											gint _tmp249_;
											gint _tmp250_;
											gchar** _tmp251_;
											gint _tmp251__length1;
											gint _tmp252_;
											const gchar* _tmp253_;
											gchar* _tmp254_;
											gchar* key_name;
											gchar** _tmp255_;
											gint _tmp255__length1;
											gint _tmp256_;
											const gchar* _tmp257_;
											gchar* _tmp258_;
											gchar* key_prot;
											gchar** _tmp259_;
											gint _tmp259__length1;
											gint _tmp260_;
											const gchar* _tmp261_;
											gint _tmp262_ = 0;
											gint num_servers;
											NetsukukuAndnaServiceKey* _tmp263_;
											NetsukukuAndnaServiceKey* _tmp264_;
											NetsukukuAndnaServiceKey* _tmp265_;
											NetsukukuAndnaServiceKey* srvkey;
											const gchar* _tmp266_;
											NetsukukuAndnaServiceKey* _tmp270_;
											gchar* _tmp271_ = NULL;
											gchar* _tmp272_;
											gint _tmp273_;
											gchar* _tmp274_ = NULL;
											gchar* _tmp275_;
											gchar* _tmp276_ = NULL;
											gchar* _tmp277_;
											GeeHashMap* _tmp278_;
											NetsukukuAndnaServiceKey* _tmp279_;
											GeeArrayList* _tmp280_ = NULL;
											GeeArrayList* _tmp281_;
											_tmp247_ = _tmp246_;
											if (!_tmp247_) {
												gint _tmp248_;
												_tmp248_ = i_key;
												i_key = _tmp248_ + 1;
											}
											_tmp246_ = FALSE;
											_tmp249_ = i_key;
											_tmp250_ = num_snsd;
											if (!(_tmp249_ < _tmp250_)) {
												break;
											}
											_tmp251_ = snsd_records;
											_tmp251__length1 = snsd_records_length1;
											_tmp252_ = snsd_record_counter;
											snsd_record_counter = _tmp252_ + 1;
											_tmp253_ = _tmp251_[_tmp252_];
											_tmp254_ = g_strdup (_tmp253_);
											key_name = _tmp254_;
											_tmp255_ = snsd_records;
											_tmp255__length1 = snsd_records_length1;
											_tmp256_ = snsd_record_counter;
											snsd_record_counter = _tmp256_ + 1;
											_tmp257_ = _tmp255_[_tmp256_];
											_tmp258_ = g_strdup (_tmp257_);
											key_prot = _tmp258_;
											_tmp259_ = snsd_records;
											_tmp259__length1 = snsd_records_length1;
											_tmp260_ = snsd_record_counter;
											snsd_record_counter = _tmp260_ + 1;
											_tmp261_ = _tmp259_[_tmp260_];
											_tmp262_ = atoi (_tmp261_);
											num_servers = _tmp262_;
											_tmp263_ = netsukuku_andna_service_key_get_NULL_SERV_KEY ();
											_tmp264_ = _tmp263_;
											_tmp265_ = _g_object_ref0 (_tmp264_);
											srvkey = _tmp265_;
											_tmp266_ = key_name;
											if (g_strcmp0 (_tmp266_, "") != 0) {
												const gchar* _tmp267_;
												const gchar* _tmp268_;
												NetsukukuAndnaServiceKey* _tmp269_;
												_tmp267_ = key_name;
												_tmp268_ = key_prot;
												_tmp269_ = netsukuku_andna_service_key_new (_tmp267_, _tmp268_);
												_g_object_unref0 (srvkey);
												srvkey = _tmp269_;
											}
											_tmp270_ = srvkey;
											_tmp271_ = netsukuku_andna_service_key_to_string (_tmp270_);
											_tmp272_ = _tmp271_;
											_tmp273_ = num_servers;
											_tmp274_ = g_strdup_printf ("%i", _tmp273_);
											_tmp275_ = _tmp274_;
											_tmp276_ = g_strconcat ("service ", _tmp272_, " has ", _tmp275_, " servers\n", NULL);
											_tmp277_ = _tmp276_;
											ntk_test_print_out (_tmp277_);
											_g_free0 (_tmp277_);
											_g_free0 (_tmp275_);
											_g_free0 (_tmp272_);
											_tmp278_ = services;
											_tmp279_ = srvkey;
											_tmp280_ = netsukuku_andna_private_configuration_server_make_empty_list ();
											_tmp281_ = _tmp280_;
											gee_abstract_map_set ((GeeAbstractMap*) _tmp278_, _tmp279_, _tmp281_);
											_g_object_unref0 (_tmp281_);
											{
												gint i_server;
												i_server = 0;
												{
													gboolean _tmp282_;
													_tmp282_ = TRUE;
													while (TRUE) {
														gboolean _tmp283_;
														gint _tmp285_;
														gint _tmp286_;
														NetsukukuPublicKey* server_pubk;
														gchar** _tmp287_;
														gint _tmp287__length1;
														gint _tmp288_;
														const gchar* _tmp289_;
														gchar* _tmp290_;
														gchar* server_alias;
														const gchar* _tmp291_;
														gint* _tmp303_;
														gint _tmp303__length1;
														gint _tmp304_;
														gint _tmp305_;
														gint server_priority;
														gint* _tmp306_;
														gint _tmp306__length1;
														gint _tmp307_;
														gint _tmp308_;
														gint server_weight;
														gint* _tmp309_;
														gint _tmp309__length1;
														gint _tmp310_;
														gint _tmp311_;
														gint server_port_number;
														const gchar* _tmp312_;
														NetsukukuPublicKey* _tmp313_;
														gint _tmp314_;
														gint _tmp315_;
														gint _tmp316_;
														NetsukukuAndnaPrivateConfigurationServer* _tmp317_;
														NetsukukuAndnaPrivateConfigurationServer* srv;
														GeeHashMap* _tmp318_;
														NetsukukuAndnaServiceKey* _tmp319_;
														gpointer _tmp320_ = NULL;
														GeeArrayList* _tmp321_;
														NetsukukuAndnaPrivateConfigurationServer* _tmp322_;
														NetsukukuAndnaPrivateConfigurationServer* _tmp323_;
														gchar* _tmp324_ = NULL;
														gchar* _tmp325_;
														gchar* _tmp326_ = NULL;
														gchar* _tmp327_;
														_tmp283_ = _tmp282_;
														if (!_tmp283_) {
															gint _tmp284_;
															_tmp284_ = i_server;
															i_server = _tmp284_ + 1;
														}
														_tmp282_ = FALSE;
														_tmp285_ = i_server;
														_tmp286_ = num_servers;
														if (!(_tmp285_ < _tmp286_)) {
															break;
														}
														server_pubk = NULL;
														_tmp287_ = snsdserver_alias;
														_tmp287__length1 = snsdserver_alias_length1;
														_tmp288_ = snsdserver_alias_counter;
														snsdserver_alias_counter = _tmp288_ + 1;
														_tmp289_ = _tmp287_[_tmp288_];
														_tmp290_ = g_strdup (_tmp289_);
														server_alias = _tmp290_;
														_tmp291_ = server_alias;
														if (g_strcmp0 (_tmp291_, "") == 0) {
															gint _tmp292_;
															_g_free0 (server_alias);
															server_alias = NULL;
															_tmp292_ = snsdserver_alias_counter;
															snsdserver_alias_counter = _tmp292_ + 1;
														} else {
															gchar** _tmp293_;
															gint _tmp293__length1;
															gint _tmp294_;
															const gchar* _tmp295_;
															gint _tmp296_ = 0;
															gint server_pubk_index;
															NetsukukuKeyPair** _tmp297_;
															gint _tmp297__length1;
															gint _tmp298_;
															NetsukukuKeyPair* _tmp299_;
															NetsukukuPublicKeyWrapper* _tmp300_;
															NetsukukuPublicKeyWrapper* _tmp301_;
															NetsukukuPublicKey* _tmp302_ = NULL;
															_tmp293_ = snsdserver_alias;
															_tmp293__length1 = snsdserver_alias_length1;
															_tmp294_ = snsdserver_alias_counter;
															snsdserver_alias_counter = _tmp294_ + 1;
															_tmp295_ = _tmp293_[_tmp294_];
															_tmp296_ = atoi (_tmp295_);
															server_pubk_index = _tmp296_;
															_tmp297_ = keypairs;
															_tmp297__length1 = keypairs_length1;
															_tmp298_ = server_pubk_index;
															_tmp299_ = _tmp297_[_tmp298_];
															_tmp300_ = netsukuku_key_pair_get_pub_key (_tmp299_);
															_tmp301_ = _tmp300_;
															_tmp302_ = netsukuku_public_key_wrapper_to_pubkey (_tmp301_);
															_g_object_unref0 (server_pubk);
															server_pubk = _tmp302_;
														}
														_tmp303_ = snsdserver_values;
														_tmp303__length1 = snsdserver_values_length1;
														_tmp304_ = snsdserver_values_counter;
														snsdserver_values_counter = _tmp304_ + 1;
														_tmp305_ = _tmp303_[_tmp304_];
														server_priority = _tmp305_;
														_tmp306_ = snsdserver_values;
														_tmp306__length1 = snsdserver_values_length1;
														_tmp307_ = snsdserver_values_counter;
														snsdserver_values_counter = _tmp307_ + 1;
														_tmp308_ = _tmp306_[_tmp307_];
														server_weight = _tmp308_;
														_tmp309_ = snsdserver_values;
														_tmp309__length1 = snsdserver_values_length1;
														_tmp310_ = snsdserver_values_counter;
														snsdserver_values_counter = _tmp310_ + 1;
														_tmp311_ = _tmp309_[_tmp310_];
														server_port_number = _tmp311_;
														_tmp312_ = server_alias;
														_tmp313_ = server_pubk;
														_tmp314_ = server_port_number;
														_tmp315_ = server_priority;
														_tmp316_ = server_weight;
														_tmp317_ = netsukuku_andna_private_configuration_server_new (_tmp312_, _tmp313_, _tmp314_, _tmp315_, _tmp316_);
														srv = _tmp317_;
														_tmp318_ = services;
														_tmp319_ = srvkey;
														_tmp320_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp318_, _tmp319_);
														_tmp321_ = (GeeArrayList*) _tmp320_;
														_tmp322_ = srv;
														gee_abstract_collection_add ((GeeAbstractCollection*) _tmp321_, _tmp322_);
														_g_object_unref0 (_tmp321_);
														_tmp323_ = srv;
														_tmp324_ = netsukuku_andna_private_configuration_server_to_string (_tmp323_);
														_tmp325_ = _tmp324_;
														_tmp326_ = g_strconcat ("  * ", _tmp325_, "\n", NULL);
														_tmp327_ = _tmp326_;
														ntk_test_print_out (_tmp327_);
														_g_free0 (_tmp327_);
														_g_free0 (_tmp325_);
														_g_object_unref0 (srv);
														_g_free0 (server_alias);
														_g_object_unref0 (server_pubk);
													}
												}
											}
											_g_object_unref0 (srvkey);
											_g_free0 (key_prot);
											_g_free0 (key_name);
										}
									}
								}
							}
							ntk_test_print_out ("Now registering...\n");
							_tmp328_ = hostname;
							_tmp329_ = services;
							_tmp330_ = netsukuku_andna_private_configuration_new (_tmp328_, _tmp329_);
							cfg = _tmp330_;
							_tmp331_ = andna;
							_tmp332_ = cfg;
							_tmp333_ = netsukuku_andna_make_domain_request (_tmp331_, _tmp332_);
							andna_req = _tmp333_;
							_tmp334_ = andna_req;
							_tmp336_ = netsukuku_andna_domain_request_hash_for_signature (_tmp334_, &_tmp335_);
							message_andna = _tmp336_;
							message_andna_length1 = _tmp335_;
							_message_andna_size_ = message_andna_length1;
							_tmp337_ = keypair;
							_tmp338_ = message_andna;
							_tmp338__length1 = message_andna_length1;
							_tmp340_ = netsukuku_key_pair_sign (_tmp337_, _tmp338_, _tmp338__length1, &_tmp339_, &_inner_error_);
							signed_andna = _tmp340_;
							signed_andna_length1 = _tmp339_;
							_signed_andna_size_ = signed_andna_length1;
							if (_inner_error_ != NULL) {
								message_andna = (g_free (message_andna), NULL);
								_g_object_unref0 (andna_req);
								_g_object_unref0 (cfg);
								_g_object_unref0 (services);
								_g_free0 (num_snsd_str);
								_g_free0 (hostname);
								_g_object_unref0 (resp_counter);
								_g_object_unref0 (signature_counter);
								signed_counter = (g_free (signed_counter), NULL);
								msg_counter = (g_free (msg_counter), NULL);
								_g_object_unref0 (hashed_hostnames);
								_g_object_unref0 (myhostnames);
								_g_object_unref0 (andnacounter);
								_g_object_unref0 (andna);
								_g_object_unref0 (counter);
								_g_object_unref0 (keypair);
								_g_object_unref0 (ptpall);
								_g_object_unref0 (mr);
								_g_object_unref0 (anm);
								_g_object_unref0 (nip);
								mrs = (_vala_array_free (mrs, mrs_length1, (GDestroyNotify) g_object_unref), NULL);
								keypairs = (_vala_array_free (keypairs, keypairs_length1, (GDestroyNotify) g_object_unref), NULL);
								nips = (_vala_array_free (nips, nips_length1, (GDestroyNotify) g_object_unref), NULL);
								searchkeys = (_vala_array_free (searchkeys, searchkeys_length1, (GDestroyNotify) g_free), NULL);
								snsdserver_values = (g_free (snsdserver_values), NULL);
								snsdserver_alias = (_vala_array_free (snsdserver_alias, snsdserver_alias_length1, (GDestroyNotify) g_free), NULL);
								snsd_records = (_vala_array_free (snsd_records, snsd_records_length1, (GDestroyNotify) g_free), NULL);
								hostnames = (_vala_array_free (hostnames, hostnames_length1, (GDestroyNotify) g_free), NULL);
								int_set_1 = (g_free (int_set_1), NULL);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
							_tmp341_ = signed_andna;
							_tmp341__length1 = signed_andna_length1;
							_tmp342_ = zcd_serializable_buffer_new ((guint8*) _tmp341_, (_tmp341__length1 * sizeof (guchar)) / sizeof (guint8));
							signature_andna = _tmp342_;
							_tmp343_ = andna;
							_tmp344_ = andna_req;
							_tmp345_ = netsukuku_andna_domain_request_get_hashed_domain (_tmp344_);
							_tmp346_ = _tmp345_;
							_tmp347_ = netsukuku_andna_service_hashnode_key_new (_tmp346_, 0);
							_tmp348_ = _tmp347_;
							_tmp349_ = netsukuku_andna_peer (_tmp343_, NULL, (GObject*) _tmp348_, NULL);
							_tmp350_ = _tmp349_;
							_tmp351_ = andna_req;
							_tmp352_ = signature_andna;
							_tmp353_ = netsukuku_iandna_as_peer_register_main_for_pubk ((NetsukukuIAndnaAsPeer*) _tmp350_, _tmp351_, _tmp352_, TRUE, &_inner_error_);
							_tmp354_ = _tmp353_;
							_g_object_unref0 (_tmp350_);
							_g_object_unref0 (_tmp348_);
							resp_andna = _tmp354_;
							if (_inner_error_ != NULL) {
								_g_object_unref0 (signature_andna);
								signed_andna = (g_free (signed_andna), NULL);
								message_andna = (g_free (message_andna), NULL);
								_g_object_unref0 (andna_req);
								_g_object_unref0 (cfg);
								_g_object_unref0 (services);
								_g_free0 (num_snsd_str);
								_g_free0 (hostname);
								_g_object_unref0 (resp_counter);
								_g_object_unref0 (signature_counter);
								signed_counter = (g_free (signed_counter), NULL);
								msg_counter = (g_free (msg_counter), NULL);
								_g_object_unref0 (hashed_hostnames);
								_g_object_unref0 (myhostnames);
								_g_object_unref0 (andnacounter);
								_g_object_unref0 (andna);
								_g_object_unref0 (counter);
								_g_object_unref0 (keypair);
								_g_object_unref0 (ptpall);
								_g_object_unref0 (mr);
								_g_object_unref0 (anm);
								_g_object_unref0 (nip);
								mrs = (_vala_array_free (mrs, mrs_length1, (GDestroyNotify) g_object_unref), NULL);
								keypairs = (_vala_array_free (keypairs, keypairs_length1, (GDestroyNotify) g_object_unref), NULL);
								nips = (_vala_array_free (nips, nips_length1, (GDestroyNotify) g_object_unref), NULL);
								searchkeys = (_vala_array_free (searchkeys, searchkeys_length1, (GDestroyNotify) g_free), NULL);
								snsdserver_values = (g_free (snsdserver_values), NULL);
								snsdserver_alias = (_vala_array_free (snsdserver_alias, snsdserver_alias_length1, (GDestroyNotify) g_free), NULL);
								snsd_records = (_vala_array_free (snsd_records, snsd_records_length1, (GDestroyNotify) g_free), NULL);
								hostnames = (_vala_array_free (hostnames, hostnames_length1, (GDestroyNotify) g_free), NULL);
								int_set_1 = (g_free (int_set_1), NULL);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
							_tmp355_ = resp_andna;
							_tmp356_ = netsukuku_andna_register_main_response_get_response (_tmp355_);
							_tmp357_ = _tmp356_;
							_tmp358_ = string_to_string (_tmp357_);
							_tmp359_ = g_strconcat ("AndnaRegisterMainResponse ", _tmp358_, "\n", NULL);
							_tmp360_ = _tmp359_;
							ntk_test_print_out (_tmp360_);
							_g_free0 (_tmp360_);
							_tmp361_ = resp_andna;
							_tmp362_ = netsukuku_andna_register_main_response_get_response (_tmp361_);
							_tmp363_ = _tmp362_;
							_vala_assert (g_strcmp0 (_tmp363_, "REGISTERED") == 0, "resp_andna.response == \"REGISTERED\"");
							tasklets_tasklet_nap ((glong) 0, (glong) 10000);
							_g_object_unref0 (resp_andna);
							_g_object_unref0 (signature_andna);
							signed_andna = (g_free (signed_andna), NULL);
							message_andna = (g_free (message_andna), NULL);
							_g_object_unref0 (andna_req);
							_g_object_unref0 (cfg);
							_g_object_unref0 (services);
							_g_free0 (num_snsd_str);
							_g_free0 (hostname);
						}
					}
				}
				_tmp364_ = hostname_counter;
				_tmp365_ = store;
				hostname_counter = _tmp364_ + (_tmp365_ * 2);
				_g_object_unref0 (resp_counter);
				_g_object_unref0 (signature_counter);
				signed_counter = (g_free (signed_counter), NULL);
				msg_counter = (g_free (msg_counter), NULL);
				_g_object_unref0 (hashed_hostnames);
				_g_object_unref0 (myhostnames);
				_g_object_unref0 (andnacounter);
				_g_object_unref0 (andna);
				_g_object_unref0 (counter);
				_g_object_unref0 (keypair);
				_g_object_unref0 (ptpall);
				_g_object_unref0 (mr);
				_g_object_unref0 (anm);
				_g_object_unref0 (nip);
			}
		}
	}
	_tmp366_ = ntk_test_nodes;
	_tmp367_ = nips;
	_tmp367__length1 = nips_length1;
	_tmp368_ = _tmp367_[0];
	_tmp369_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp366_, _tmp368_);
	_tmp370_ = (NtkTestAndnaCounter*) _tmp369_;
	_tmp371_ = _tmp370_->andna;
	_tmp372_ = _g_object_ref0 (_tmp371_);
	_tmp373_ = _tmp372_;
	_g_object_unref0 (_tmp370_);
	test = _tmp373_;
	ntk_test_print_out ("Looking for zeus\n");
	_tmp374_ = test;
	_tmp375_ = netsukuku_andna_crypto_hash ("zeus");
	_tmp376_ = _tmp375_;
	_tmp377_ = netsukuku_andna_service_key_get_NULL_SERV_KEY ();
	_tmp378_ = _tmp377_;
	_tmp379_ = netsukuku_andna_ask_get_servers (_tmp374_, _tmp376_, _tmp378_, TRUE);
	_g_object_unref0 (look_resp);
	look_resp = _tmp379_;
	_g_free0 (_tmp376_);
	ntk_test_print_out ("got response\n");
	_tmp380_ = look_resp;
	_tmp381_ = netsukuku_andna_get_servers_response_get_expires (_tmp380_);
	_tmp382_ = _tmp381_;
	_tmp383_ = tasklets_timer_get_string_msec_ttl ((TaskletsTimer*) _tmp382_);
	_tmp384_ = _tmp383_;
	_tmp385_ = string_to_string (_tmp384_);
	_tmp386_ = g_strconcat (" expires in ", _tmp385_, "\n", NULL);
	_tmp387_ = _tmp386_;
	ntk_test_print_out (_tmp387_);
	_g_free0 (_tmp387_);
	_g_free0 (_tmp384_);
	_tmp388_ = look_resp;
	_tmp389_ = netsukuku_andna_get_servers_response_get_response (_tmp388_);
	_tmp390_ = _tmp389_;
	_tmp391_ = netsukuku_andna_servers_get_is_not_found (_tmp390_);
	_tmp392_ = _tmp391_;
	_vala_assert (!_tmp392_, "!look_resp.response.is_not_found");
	_tmp393_ = look_resp;
	_tmp394_ = netsukuku_andna_get_servers_response_get_response (_tmp393_);
	_tmp395_ = _tmp394_;
	_tmp396_ = netsukuku_andna_servers_get_servers (_tmp395_);
	_tmp397_ = _tmp396_;
	_tmp398_ = gee_collection_get_size ((GeeCollection*) _tmp397_);
	_tmp399_ = _tmp398_;
	_vala_assert (_tmp399_ == 1, "look_resp.response.servers.size == 1");
	{
		NetsukukuAndnaGetServersResponse* _tmp400_;
		NetsukukuAndnaServers* _tmp401_;
		NetsukukuAndnaServers* _tmp402_;
		GeeList* _tmp403_;
		GeeList* _tmp404_;
		GeeList* _tmp405_;
		GeeList* _s_list;
		GeeList* _tmp406_;
		gint _tmp407_;
		gint _tmp408_;
		gint _s_size;
		gint _s_index;
		_tmp400_ = look_resp;
		_tmp401_ = netsukuku_andna_get_servers_response_get_response (_tmp400_);
		_tmp402_ = _tmp401_;
		_tmp403_ = netsukuku_andna_servers_get_servers (_tmp402_);
		_tmp404_ = _tmp403_;
		_tmp405_ = _g_object_ref0 (_tmp404_);
		_s_list = _tmp405_;
		_tmp406_ = _s_list;
		_tmp407_ = gee_collection_get_size ((GeeCollection*) _tmp406_);
		_tmp408_ = _tmp407_;
		_s_size = _tmp408_;
		_s_index = -1;
		while (TRUE) {
			gint _tmp409_;
			gint _tmp410_;
			gint _tmp411_;
			GeeList* _tmp412_;
			gint _tmp413_;
			gpointer _tmp414_ = NULL;
			NetsukukuAndnaServer* s;
			NetsukukuAndnaServer* _tmp415_;
			gchar* _tmp416_ = NULL;
			gchar* _tmp417_;
			gchar* _tmp418_ = NULL;
			gchar* _tmp419_;
			_tmp409_ = _s_index;
			_s_index = _tmp409_ + 1;
			_tmp410_ = _s_index;
			_tmp411_ = _s_size;
			if (!(_tmp410_ < _tmp411_)) {
				break;
			}
			_tmp412_ = _s_list;
			_tmp413_ = _s_index;
			_tmp414_ = gee_list_get (_tmp412_, _tmp413_);
			s = (NetsukukuAndnaServer*) _tmp414_;
			_tmp415_ = s;
			_tmp416_ = netsukuku_andna_server_to_string (_tmp415_);
			_tmp417_ = _tmp416_;
			_tmp418_ = g_strconcat (" . ", _tmp417_, "\n", NULL);
			_tmp419_ = _tmp418_;
			ntk_test_print_out (_tmp419_);
			_g_free0 (_tmp419_);
			_g_free0 (_tmp417_);
			_g_object_unref0 (s);
		}
		_g_object_unref0 (_s_list);
	}
	ntk_test_print_out ("Looking for http:netsukuku.org\n");
	_tmp420_ = test;
	_tmp421_ = netsukuku_andna_crypto_hash ("netsukuku.org");
	_tmp422_ = _tmp421_;
	_tmp423_ = netsukuku_andna_service_key_new ("_www", "_tcp");
	_tmp424_ = _tmp423_;
	_tmp425_ = netsukuku_andna_ask_get_servers (_tmp420_, _tmp422_, _tmp424_, TRUE);
	_g_object_unref0 (look_resp);
	look_resp = _tmp425_;
	_g_object_unref0 (_tmp424_);
	_g_free0 (_tmp422_);
	ntk_test_print_out ("got response\n");
	_tmp426_ = look_resp;
	_tmp427_ = netsukuku_andna_get_servers_response_get_expires (_tmp426_);
	_tmp428_ = _tmp427_;
	_tmp429_ = tasklets_timer_get_string_msec_ttl ((TaskletsTimer*) _tmp428_);
	_tmp430_ = _tmp429_;
	_tmp431_ = string_to_string (_tmp430_);
	_tmp432_ = g_strconcat (" expires in ", _tmp431_, "\n", NULL);
	_tmp433_ = _tmp432_;
	ntk_test_print_out (_tmp433_);
	_g_free0 (_tmp433_);
	_g_free0 (_tmp430_);
	_tmp434_ = look_resp;
	_tmp435_ = netsukuku_andna_get_servers_response_get_response (_tmp434_);
	_tmp436_ = _tmp435_;
	_tmp437_ = netsukuku_andna_servers_get_is_not_found (_tmp436_);
	_tmp438_ = _tmp437_;
	_vala_assert (!_tmp438_, "!look_resp.response.is_not_found");
	_tmp439_ = look_resp;
	_tmp440_ = netsukuku_andna_get_servers_response_get_response (_tmp439_);
	_tmp441_ = _tmp440_;
	_tmp442_ = netsukuku_andna_servers_get_servers (_tmp441_);
	_tmp443_ = _tmp442_;
	_tmp444_ = gee_collection_get_size ((GeeCollection*) _tmp443_);
	_tmp445_ = _tmp444_;
	_vala_assert (_tmp445_ == 2, "look_resp.response.servers.size == 2");
	found = NULL;
	{
		NetsukukuAndnaGetServersResponse* _tmp446_;
		NetsukukuAndnaServers* _tmp447_;
		NetsukukuAndnaServers* _tmp448_;
		GeeList* _tmp449_;
		GeeList* _tmp450_;
		GeeList* _tmp451_;
		GeeList* _s_list;
		GeeList* _tmp452_;
		gint _tmp453_;
		gint _tmp454_;
		gint _s_size;
		gint _s_index;
		_tmp446_ = look_resp;
		_tmp447_ = netsukuku_andna_get_servers_response_get_response (_tmp446_);
		_tmp448_ = _tmp447_;
		_tmp449_ = netsukuku_andna_servers_get_servers (_tmp448_);
		_tmp450_ = _tmp449_;
		_tmp451_ = _g_object_ref0 (_tmp450_);
		_s_list = _tmp451_;
		_tmp452_ = _s_list;
		_tmp453_ = gee_collection_get_size ((GeeCollection*) _tmp452_);
		_tmp454_ = _tmp453_;
		_s_size = _tmp454_;
		_s_index = -1;
		while (TRUE) {
			gint _tmp455_;
			gint _tmp456_;
			gint _tmp457_;
			GeeList* _tmp458_;
			gint _tmp459_;
			gpointer _tmp460_ = NULL;
			NetsukukuAndnaServer* s;
			NetsukukuAndnaServer* _tmp461_;
			gchar* _tmp462_ = NULL;
			gchar* _tmp463_;
			gchar* _tmp464_ = NULL;
			gchar* _tmp465_;
			NetsukukuAndnaServer* _tmp466_;
			const gchar* _tmp467_;
			const gchar* _tmp468_;
			_tmp455_ = _s_index;
			_s_index = _tmp455_ + 1;
			_tmp456_ = _s_index;
			_tmp457_ = _s_size;
			if (!(_tmp456_ < _tmp457_)) {
				break;
			}
			_tmp458_ = _s_list;
			_tmp459_ = _s_index;
			_tmp460_ = gee_list_get (_tmp458_, _tmp459_);
			s = (NetsukukuAndnaServer*) _tmp460_;
			_tmp461_ = s;
			_tmp462_ = netsukuku_andna_server_to_string (_tmp461_);
			_tmp463_ = _tmp462_;
			_tmp464_ = g_strconcat (" . ", _tmp463_, "\n", NULL);
			_tmp465_ = _tmp464_;
			ntk_test_print_out (_tmp465_);
			_g_free0 (_tmp465_);
			_g_free0 (_tmp463_);
			_tmp466_ = s;
			_tmp467_ = netsukuku_andna_server_get_alias_name (_tmp466_);
			_tmp468_ = _tmp467_;
			if (_tmp468_ != NULL) {
				NetsukukuAndna* _tmp469_;
				NetsukukuAndnaServer* _tmp470_;
				const gchar* _tmp471_;
				const gchar* _tmp472_;
				NetsukukuAndnaServiceKey* _tmp473_;
				NetsukukuAndnaServiceKey* _tmp474_;
				NetsukukuAndnaGetServersResponse* _tmp475_ = NULL;
				NetsukukuAndnaGetServersResponse* resolvealias_resp;
				NetsukukuAndnaGetServersResponse* _tmp476_;
				NetsukukuAndnaServers* _tmp477_;
				NetsukukuAndnaServers* _tmp478_;
				gboolean _tmp479_;
				gboolean _tmp480_;
				NetsukukuNIP* _tmp503_;
				gchar* _tmp504_ = NULL;
				gchar* _tmp505_;
				gchar* _tmp506_ = NULL;
				gchar* _tmp507_;
				_tmp469_ = test;
				_tmp470_ = s;
				_tmp471_ = netsukuku_andna_server_get_alias_name (_tmp470_);
				_tmp472_ = _tmp471_;
				_tmp473_ = netsukuku_andna_service_key_get_NULL_SERV_KEY ();
				_tmp474_ = _tmp473_;
				_tmp475_ = netsukuku_andna_ask_get_servers (_tmp469_, _tmp472_, _tmp474_, FALSE);
				resolvealias_resp = _tmp475_;
				_tmp476_ = resolvealias_resp;
				_tmp477_ = netsukuku_andna_get_servers_response_get_response (_tmp476_);
				_tmp478_ = _tmp477_;
				_tmp479_ = netsukuku_andna_servers_get_is_not_found (_tmp478_);
				_tmp480_ = _tmp479_;
				_vala_assert (!_tmp480_, "!resolvealias_resp.response.is_not_found");
				{
					NetsukukuAndnaGetServersResponse* _tmp481_;
					NetsukukuAndnaServers* _tmp482_;
					NetsukukuAndnaServers* _tmp483_;
					GeeList* _tmp484_;
					GeeList* _tmp485_;
					GeeList* _tmp486_;
					GeeList* _s2_list;
					GeeList* _tmp487_;
					gint _tmp488_;
					gint _tmp489_;
					gint _s2_size;
					gint _s2_index;
					_tmp481_ = resolvealias_resp;
					_tmp482_ = netsukuku_andna_get_servers_response_get_response (_tmp481_);
					_tmp483_ = _tmp482_;
					_tmp484_ = netsukuku_andna_servers_get_servers (_tmp483_);
					_tmp485_ = _tmp484_;
					_tmp486_ = _g_object_ref0 (_tmp485_);
					_s2_list = _tmp486_;
					_tmp487_ = _s2_list;
					_tmp488_ = gee_collection_get_size ((GeeCollection*) _tmp487_);
					_tmp489_ = _tmp488_;
					_s2_size = _tmp489_;
					_s2_index = -1;
					while (TRUE) {
						gint _tmp490_;
						gint _tmp491_;
						gint _tmp492_;
						GeeList* _tmp493_;
						gint _tmp494_;
						gpointer _tmp495_ = NULL;
						NetsukukuAndnaServer* s2;
						NetsukukuAndnaServer* _tmp496_;
						const gchar* _tmp497_;
						const gchar* _tmp498_;
						_tmp490_ = _s2_index;
						_s2_index = _tmp490_ + 1;
						_tmp491_ = _s2_index;
						_tmp492_ = _s2_size;
						if (!(_tmp491_ < _tmp492_)) {
							break;
						}
						_tmp493_ = _s2_list;
						_tmp494_ = _s2_index;
						_tmp495_ = gee_list_get (_tmp493_, _tmp494_);
						s2 = (NetsukukuAndnaServer*) _tmp495_;
						_tmp496_ = s2;
						_tmp497_ = netsukuku_andna_server_get_alias_name (_tmp496_);
						_tmp498_ = _tmp497_;
						if (_tmp498_ == NULL) {
							NetsukukuAndnaServer* _tmp499_;
							NetsukukuNIP* _tmp500_;
							NetsukukuNIP* _tmp501_;
							NetsukukuNIP* _tmp502_;
							_tmp499_ = s2;
							_tmp500_ = netsukuku_andna_server_get_registrar_nip (_tmp499_);
							_tmp501_ = _tmp500_;
							_tmp502_ = _g_object_ref0 (_tmp501_);
							_g_object_unref0 (found);
							found = _tmp502_;
							_g_object_unref0 (s2);
							break;
						}
						_g_object_unref0 (s2);
					}
					_g_object_unref0 (_s2_list);
				}
				_tmp503_ = found;
				_tmp504_ = netsukuku_partial_nip_to_string ((NetsukukuPartialNIP*) _tmp503_);
				_tmp505_ = _tmp504_;
				_tmp506_ = g_strconcat ("   ", _tmp505_, "\n", NULL);
				_tmp507_ = _tmp506_;
				ntk_test_print_out (_tmp507_);
				_g_free0 (_tmp507_);
				_g_free0 (_tmp505_);
				_g_object_unref0 (resolvealias_resp);
			}
			_g_object_unref0 (s);
		}
		_g_object_unref0 (_s_list);
	}
	_tmp508_ = found;
	_vala_assert (_tmp508_ != NULL, "found != null");
	ntk_test_print_out ("Looking for poseidon\n");
	_tmp509_ = test;
	_tmp510_ = netsukuku_andna_crypto_hash ("poseidon");
	_tmp511_ = _tmp510_;
	_tmp512_ = netsukuku_andna_service_key_get_NULL_SERV_KEY ();
	_tmp513_ = _tmp512_;
	_tmp514_ = netsukuku_andna_ask_get_servers (_tmp509_, _tmp511_, _tmp513_, TRUE);
	_g_object_unref0 (look_resp);
	look_resp = _tmp514_;
	_g_free0 (_tmp511_);
	_tmp515_ = look_resp;
	_tmp516_ = netsukuku_andna_get_servers_response_get_response (_tmp515_);
	_tmp517_ = _tmp516_;
	_tmp518_ = netsukuku_andna_servers_get_servers (_tmp517_);
	_tmp519_ = _tmp518_;
	_tmp520_ = gee_collection_get_size ((GeeCollection*) _tmp519_);
	_tmp521_ = _tmp520_;
	_tmp522_ = g_strdup_printf ("%i", _tmp521_);
	_tmp523_ = _tmp522_;
	_tmp524_ = g_strconcat ("got response with ", _tmp523_, " records\n", NULL);
	_tmp525_ = _tmp524_;
	ntk_test_print_out (_tmp525_);
	_g_free0 (_tmp525_);
	_g_free0 (_tmp523_);
	_tmp526_ = look_resp;
	_tmp527_ = netsukuku_andna_get_servers_response_get_expires (_tmp526_);
	_tmp528_ = _tmp527_;
	_tmp529_ = tasklets_timer_get_string_msec_ttl ((TaskletsTimer*) _tmp528_);
	_tmp530_ = _tmp529_;
	_tmp531_ = string_to_string (_tmp530_);
	_tmp532_ = g_strconcat (" expires in ", _tmp531_, "\n", NULL);
	_tmp533_ = _tmp532_;
	ntk_test_print_out (_tmp533_);
	_g_free0 (_tmp533_);
	_g_free0 (_tmp530_);
	_tmp534_ = look_resp;
	_tmp535_ = netsukuku_andna_get_servers_response_get_response (_tmp534_);
	_tmp536_ = _tmp535_;
	_tmp537_ = netsukuku_andna_servers_get_is_not_found (_tmp536_);
	_tmp538_ = _tmp537_;
	_vala_assert (_tmp538_, "look_resp.response.is_not_found");
	_g_object_unref0 (found);
	_g_object_unref0 (look_resp);
	_g_object_unref0 (test);
	mrs = (_vala_array_free (mrs, mrs_length1, (GDestroyNotify) g_object_unref), NULL);
	keypairs = (_vala_array_free (keypairs, keypairs_length1, (GDestroyNotify) g_object_unref), NULL);
	nips = (_vala_array_free (nips, nips_length1, (GDestroyNotify) g_object_unref), NULL);
	searchkeys = (_vala_array_free (searchkeys, searchkeys_length1, (GDestroyNotify) g_free), NULL);
	snsdserver_values = (g_free (snsdserver_values), NULL);
	snsdserver_alias = (_vala_array_free (snsdserver_alias, snsdserver_alias_length1, (GDestroyNotify) g_free), NULL);
	snsd_records = (_vala_array_free (snsd_records, snsd_records_length1, (GDestroyNotify) g_free), NULL);
	hostnames = (_vala_array_free (hostnames, hostnames_length1, (GDestroyNotify) g_free), NULL);
	int_set_1 = (g_free (int_set_1), NULL);
}


static void __lambda17_ (void) {
	NtkTestAndnaCounterTester* _tmp0_;
	NtkTestAndnaCounterTester* x;
	_tmp0_ = ntk_test_andna_counter_tester_new ();
	x = _tmp0_;
	ntk_test_andna_counter_tester_set_up (x);
	ntk_test_andna_counter_tester_test_hook_and_replica (x);
	ntk_test_andna_counter_tester_tear_down (x);
	_g_object_unref0 (x);
}


static void ___lambda17__gcallback (void) {
	__lambda17_ ();
}


gint ntk_test_andna_counter_tester_main (gchar** args, int args_length1) {
	gint result = 0;
	g_test_init (&args_length1, &args, NULL);
	tasklets_tasklet_init (64);
	g_test_add_func ("/AndnaCounter/HookingAndReplica", ___lambda17__gcallback);
	g_test_run ();
	tasklets_tasklet_kill ();
	result = 0;
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return ntk_test_andna_counter_tester_main (argv, argc);
}


NtkTestAndnaCounterTester* ntk_test_andna_counter_tester_construct (GType object_type) {
	NtkTestAndnaCounterTester * self = NULL;
	self = (NtkTestAndnaCounterTester*) g_object_new (object_type, NULL);
	return self;
}


NtkTestAndnaCounterTester* ntk_test_andna_counter_tester_new (void) {
	return ntk_test_andna_counter_tester_construct (NTK_TEST_TYPE_ANDNA_COUNTER_TESTER);
}


static void ntk_test_andna_counter_tester_class_init (NtkTestAndnaCounterTesterClass * klass) {
	ntk_test_andna_counter_tester_parent_class = g_type_class_peek_parent (klass);
}


static void ntk_test_andna_counter_tester_instance_init (NtkTestAndnaCounterTester * self) {
}


GType ntk_test_andna_counter_tester_get_type (void) {
	static volatile gsize ntk_test_andna_counter_tester_type_id__volatile = 0;
	if (g_once_init_enter (&ntk_test_andna_counter_tester_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NtkTestAndnaCounterTesterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ntk_test_andna_counter_tester_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NtkTestAndnaCounterTester), 0, (GInstanceInitFunc) ntk_test_andna_counter_tester_instance_init, NULL };
		GType ntk_test_andna_counter_tester_type_id;
		ntk_test_andna_counter_tester_type_id = g_type_register_static (G_TYPE_OBJECT, "NtkTestAndnaCounterTester", &g_define_type_info, 0);
		g_once_init_leave (&ntk_test_andna_counter_tester_type_id__volatile, ntk_test_andna_counter_tester_type_id);
	}
	return ntk_test_andna_counter_tester_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



