/* radar.c generated by valac 0.20.1, the Vala compiler
 * generated from radar.vala, do not modify */

/*
 *  This file is part of Netsukuku.
 *  (c) Copyright 2011 Luca Dionisi aka lukisi <luca.dionisi@gmail.com>
 *
 *  Netsukuku is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Netsukuku is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Netsukuku.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <netsukuku-rpc.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <tasklet.h>
#include <zcd.h>
#include <float.h>
#include <math.h>


#define NETSUKUKU_TYPE_STRUCT_HELPER_RADAR_RUN (netsukuku_struct_helper_radar_run_get_type ())

#define NETSUKUKU_TYPE_RADAR (netsukuku_radar_get_type ())
#define NETSUKUKU_RADAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_RADAR, NetsukukuRadar))
#define NETSUKUKU_RADAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_RADAR, NetsukukuRadarClass))
#define NETSUKUKU_IS_RADAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_RADAR))
#define NETSUKUKU_IS_RADAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_RADAR))
#define NETSUKUKU_RADAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_RADAR, NetsukukuRadarClass))

typedef struct _NetsukukuRadar NetsukukuRadar;
typedef struct _NetsukukuRadarClass NetsukukuRadarClass;
typedef struct _Netsukukustruct_helper_Radar_run Netsukukustruct_helper_Radar_run;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _NetsukukuRadarPrivate NetsukukuRadarPrivate;

#define NETSUKUKU_TYPE_NEIGHBOUR (netsukuku_neighbour_get_type ())
#define NETSUKUKU_NEIGHBOUR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_NEIGHBOUR, NetsukukuNeighbour))
#define NETSUKUKU_NEIGHBOUR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_NEIGHBOUR, NetsukukuNeighbourClass))
#define NETSUKUKU_IS_NEIGHBOUR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_NEIGHBOUR))
#define NETSUKUKU_IS_NEIGHBOUR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_NEIGHBOUR))
#define NETSUKUKU_NEIGHBOUR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_NEIGHBOUR, NetsukukuNeighbourClass))

typedef struct _NetsukukuNeighbour NetsukukuNeighbour;
typedef struct _NetsukukuNeighbourClass NetsukukuNeighbourClass;

#define NETSUKUKU_TYPE_ADDRESS_MANAGER (netsukuku_address_manager_get_type ())
#define NETSUKUKU_ADDRESS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_ADDRESS_MANAGER, NetsukukuAddressManager))
#define NETSUKUKU_ADDRESS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_ADDRESS_MANAGER, NetsukukuAddressManagerClass))
#define NETSUKUKU_IS_ADDRESS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_ADDRESS_MANAGER))
#define NETSUKUKU_IS_ADDRESS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_ADDRESS_MANAGER))
#define NETSUKUKU_ADDRESS_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_ADDRESS_MANAGER, NetsukukuAddressManagerClass))

typedef struct _NetsukukuAddressManager NetsukukuAddressManager;
typedef struct _NetsukukuAddressManagerClass NetsukukuAddressManagerClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _NetsukukuAddressManagerPrivate NetsukukuAddressManagerPrivate;

#define NETSUKUKU_TYPE_HOOK_INFORMATION (netsukuku_hook_information_get_type ())
#define NETSUKUKU_HOOK_INFORMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_HOOK_INFORMATION, NetsukukuHookInformation))
#define NETSUKUKU_HOOK_INFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_HOOK_INFORMATION, NetsukukuHookInformationClass))
#define NETSUKUKU_IS_HOOK_INFORMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_HOOK_INFORMATION))
#define NETSUKUKU_IS_HOOK_INFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_HOOK_INFORMATION))
#define NETSUKUKU_HOOK_INFORMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_HOOK_INFORMATION, NetsukukuHookInformationClass))

typedef struct _NetsukukuHookInformation NetsukukuHookInformation;
typedef struct _NetsukukuHookInformationClass NetsukukuHookInformationClass;

#define NETSUKUKU_TYPE_INCOMING_NODES (netsukuku_incoming_nodes_get_type ())
#define NETSUKUKU_INCOMING_NODES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_INCOMING_NODES, NetsukukuIncomingNodes))
#define NETSUKUKU_INCOMING_NODES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_INCOMING_NODES, NetsukukuIncomingNodesClass))
#define NETSUKUKU_IS_INCOMING_NODES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_INCOMING_NODES))
#define NETSUKUKU_IS_INCOMING_NODES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_INCOMING_NODES))
#define NETSUKUKU_INCOMING_NODES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_INCOMING_NODES, NetsukukuIncomingNodesClass))

typedef struct _NetsukukuIncomingNodes NetsukukuIncomingNodes;
typedef struct _NetsukukuIncomingNodesClass NetsukukuIncomingNodesClass;

#define NETSUKUKU_TYPE_MAP (netsukuku_map_get_type ())
#define NETSUKUKU_MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_MAP, NetsukukuMap))
#define NETSUKUKU_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_MAP, NetsukukuMapClass))
#define NETSUKUKU_IS_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_MAP))
#define NETSUKUKU_IS_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_MAP))
#define NETSUKUKU_MAP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_MAP, NetsukukuMapClass))

typedef struct _NetsukukuMap NetsukukuMap;
typedef struct _NetsukukuMapClass NetsukukuMapClass;

#define NETSUKUKU_TYPE_MAP_ROUTE (netsukuku_map_route_get_type ())
#define NETSUKUKU_MAP_ROUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_MAP_ROUTE, NetsukukuMapRoute))
#define NETSUKUKU_MAP_ROUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_MAP_ROUTE, NetsukukuMapRouteClass))
#define NETSUKUKU_IS_MAP_ROUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_MAP_ROUTE))
#define NETSUKUKU_IS_MAP_ROUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_MAP_ROUTE))
#define NETSUKUKU_MAP_ROUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_MAP_ROUTE, NetsukukuMapRouteClass))

typedef struct _NetsukukuMapRoute NetsukukuMapRoute;
typedef struct _NetsukukuMapRouteClass NetsukukuMapRouteClass;

#define NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER (netsukuku_aggregated_neighbour_manager_get_type ())
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, NetsukukuAggregatedNeighbourManager))
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, NetsukukuAggregatedNeighbourManagerClass))
#define NETSUKUKU_IS_AGGREGATED_NEIGHBOUR_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER))
#define NETSUKUKU_IS_AGGREGATED_NEIGHBOUR_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER))
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, NetsukukuAggregatedNeighbourManagerClass))

typedef struct _NetsukukuAggregatedNeighbourManager NetsukukuAggregatedNeighbourManager;
typedef struct _NetsukukuAggregatedNeighbourManagerClass NetsukukuAggregatedNeighbourManagerClass;

#define NETSUKUKU_TYPE_ETP (netsukuku_etp_get_type ())
#define NETSUKUKU_ETP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_ETP, NetsukukuEtp))
#define NETSUKUKU_ETP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_ETP, NetsukukuEtpClass))
#define NETSUKUKU_IS_ETP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_ETP))
#define NETSUKUKU_IS_ETP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_ETP))
#define NETSUKUKU_ETP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_ETP, NetsukukuEtpClass))

typedef struct _NetsukukuEtp NetsukukuEtp;
typedef struct _NetsukukuEtpClass NetsukukuEtpClass;

#define NETSUKUKU_TYPE_PEER_TO_PEER_ALL (netsukuku_peer_to_peer_all_get_type ())
#define NETSUKUKU_PEER_TO_PEER_ALL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_PEER_TO_PEER_ALL, NetsukukuPeerToPeerAll))
#define NETSUKUKU_PEER_TO_PEER_ALL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_PEER_TO_PEER_ALL, NetsukukuPeerToPeerAllClass))
#define NETSUKUKU_IS_PEER_TO_PEER_ALL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_PEER_TO_PEER_ALL))
#define NETSUKUKU_IS_PEER_TO_PEER_ALL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_PEER_TO_PEER_ALL))
#define NETSUKUKU_PEER_TO_PEER_ALL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_PEER_TO_PEER_ALL, NetsukukuPeerToPeerAllClass))

typedef struct _NetsukukuPeerToPeerAll NetsukukuPeerToPeerAll;
typedef struct _NetsukukuPeerToPeerAllClass NetsukukuPeerToPeerAllClass;

#define NETSUKUKU_TYPE_PEER_TO_PEER (netsukuku_peer_to_peer_get_type ())
#define NETSUKUKU_PEER_TO_PEER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_PEER_TO_PEER, NetsukukuPeerToPeer))
#define NETSUKUKU_PEER_TO_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_PEER_TO_PEER, NetsukukuPeerToPeerClass))
#define NETSUKUKU_IS_PEER_TO_PEER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_PEER_TO_PEER))
#define NETSUKUKU_IS_PEER_TO_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_PEER_TO_PEER))
#define NETSUKUKU_PEER_TO_PEER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_PEER_TO_PEER, NetsukukuPeerToPeerClass))

typedef struct _NetsukukuPeerToPeer NetsukukuPeerToPeer;
typedef struct _NetsukukuPeerToPeerClass NetsukukuPeerToPeerClass;

#define NETSUKUKU_TYPE_COORDINATOR (netsukuku_coordinator_get_type ())
#define NETSUKUKU_COORDINATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_COORDINATOR, NetsukukuCoordinator))
#define NETSUKUKU_COORDINATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_COORDINATOR, NetsukukuCoordinatorClass))
#define NETSUKUKU_IS_COORDINATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_COORDINATOR))
#define NETSUKUKU_IS_COORDINATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_COORDINATOR))
#define NETSUKUKU_COORDINATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_COORDINATOR, NetsukukuCoordinatorClass))

typedef struct _NetsukukuCoordinator NetsukukuCoordinator;
typedef struct _NetsukukuCoordinatorClass NetsukukuCoordinatorClass;

#define NETSUKUKU_TYPE_KEY_PAIR (netsukuku_key_pair_get_type ())
#define NETSUKUKU_KEY_PAIR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_KEY_PAIR, NetsukukuKeyPair))
#define NETSUKUKU_KEY_PAIR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_KEY_PAIR, NetsukukuKeyPairClass))
#define NETSUKUKU_IS_KEY_PAIR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_KEY_PAIR))
#define NETSUKUKU_IS_KEY_PAIR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_KEY_PAIR))
#define NETSUKUKU_KEY_PAIR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_KEY_PAIR, NetsukukuKeyPairClass))

typedef struct _NetsukukuKeyPair NetsukukuKeyPair;
typedef struct _NetsukukuKeyPairClass NetsukukuKeyPairClass;

#define NETSUKUKU_TYPE_COUNTER (netsukuku_counter_get_type ())
#define NETSUKUKU_COUNTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_COUNTER, NetsukukuCounter))
#define NETSUKUKU_COUNTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_COUNTER, NetsukukuCounterClass))
#define NETSUKUKU_IS_COUNTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_COUNTER))
#define NETSUKUKU_IS_COUNTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_COUNTER))
#define NETSUKUKU_COUNTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_COUNTER, NetsukukuCounterClass))

typedef struct _NetsukukuCounter NetsukukuCounter;
typedef struct _NetsukukuCounterClass NetsukukuCounterClass;

#define NETSUKUKU_TYPE_ANDNA (netsukuku_andna_get_type ())
#define NETSUKUKU_ANDNA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_ANDNA, NetsukukuAndna))
#define NETSUKUKU_ANDNA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_ANDNA, NetsukukuAndnaClass))
#define NETSUKUKU_IS_ANDNA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_ANDNA))
#define NETSUKUKU_IS_ANDNA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_ANDNA))
#define NETSUKUKU_ANDNA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_ANDNA, NetsukukuAndnaClass))

typedef struct _NetsukukuAndna NetsukukuAndna;
typedef struct _NetsukukuAndnaClass NetsukukuAndnaClass;

#define NETSUKUKU_TYPE_TUNNEL_MANAGER (netsukuku_tunnel_manager_get_type ())
#define NETSUKUKU_TUNNEL_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_TUNNEL_MANAGER, NetsukukuTunnelManager))
#define NETSUKUKU_TUNNEL_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_TUNNEL_MANAGER, NetsukukuTunnelManagerClass))
#define NETSUKUKU_IS_TUNNEL_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_TUNNEL_MANAGER))
#define NETSUKUKU_IS_TUNNEL_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_TUNNEL_MANAGER))
#define NETSUKUKU_TUNNEL_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_TUNNEL_MANAGER, NetsukukuTunnelManagerClass))

typedef struct _NetsukukuTunnelManager NetsukukuTunnelManager;
typedef struct _NetsukukuTunnelManagerClass NetsukukuTunnelManagerClass;

#define NETSUKUKU_TYPE_HOOK (netsukuku_hook_get_type ())
#define NETSUKUKU_HOOK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_HOOK, NetsukukuHook))
#define NETSUKUKU_HOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_HOOK, NetsukukuHookClass))
#define NETSUKUKU_IS_HOOK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_HOOK))
#define NETSUKUKU_IS_HOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_HOOK))
#define NETSUKUKU_HOOK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_HOOK, NetsukukuHookClass))

typedef struct _NetsukukuHook NetsukukuHook;
typedef struct _NetsukukuHookClass NetsukukuHookClass;

#define NETSUKUKU_TYPE_BORDER_NODES_MANAGER (netsukuku_border_nodes_manager_get_type ())
#define NETSUKUKU_BORDER_NODES_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_BORDER_NODES_MANAGER, NetsukukuBorderNodesManager))
#define NETSUKUKU_BORDER_NODES_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_BORDER_NODES_MANAGER, NetsukukuBorderNodesManagerClass))
#define NETSUKUKU_IS_BORDER_NODES_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_BORDER_NODES_MANAGER))
#define NETSUKUKU_IS_BORDER_NODES_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_BORDER_NODES_MANAGER))
#define NETSUKUKU_BORDER_NODES_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_BORDER_NODES_MANAGER, NetsukukuBorderNodesManagerClass))

typedef struct _NetsukukuBorderNodesManager NetsukukuBorderNodesManager;
typedef struct _NetsukukuBorderNodesManagerClass NetsukukuBorderNodesManagerClass;

#define NETSUKUKU_TYPE_MIGRATION_MANAGER (netsukuku_migration_manager_get_type ())
#define NETSUKUKU_MIGRATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_MIGRATION_MANAGER, NetsukukuMigrationManager))
#define NETSUKUKU_MIGRATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_MIGRATION_MANAGER, NetsukukuMigrationManagerClass))
#define NETSUKUKU_IS_MIGRATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_MIGRATION_MANAGER))
#define NETSUKUKU_IS_MIGRATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_MIGRATION_MANAGER))
#define NETSUKUKU_MIGRATION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_MIGRATION_MANAGER, NetsukukuMigrationManagerClass))

typedef struct _NetsukukuMigrationManager NetsukukuMigrationManager;
typedef struct _NetsukukuMigrationManagerClass NetsukukuMigrationManagerClass;

#define NETSUKUKU_TYPE_NIC (netsukuku_nic_get_type ())
#define NETSUKUKU_NIC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_NIC, NetsukukuNIC))
#define NETSUKUKU_NIC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_NIC, NetsukukuNICClass))
#define NETSUKUKU_IS_NIC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_NIC))
#define NETSUKUKU_IS_NIC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_NIC))
#define NETSUKUKU_NIC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_NIC, NetsukukuNICClass))

typedef struct _NetsukukuNIC NetsukukuNIC;
typedef struct _NetsukukuNICClass NetsukukuNICClass;

#define NETSUKUKU_TYPE_IGS_MANAGER_DISPATCHER (netsukuku_igs_manager_dispatcher_get_type ())
#define NETSUKUKU_IGS_MANAGER_DISPATCHER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_IGS_MANAGER_DISPATCHER, NetsukukuIGSManagerDispatcher))
#define NETSUKUKU_IGS_MANAGER_DISPATCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_IGS_MANAGER_DISPATCHER, NetsukukuIGSManagerDispatcherClass))
#define NETSUKUKU_IS_IGS_MANAGER_DISPATCHER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_IGS_MANAGER_DISPATCHER))
#define NETSUKUKU_IS_IGS_MANAGER_DISPATCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_IGS_MANAGER_DISPATCHER))
#define NETSUKUKU_IGS_MANAGER_DISPATCHER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_IGS_MANAGER_DISPATCHER, NetsukukuIGSManagerDispatcherClass))

typedef struct _NetsukukuIGSManagerDispatcher NetsukukuIGSManagerDispatcher;
typedef struct _NetsukukuIGSManagerDispatcherClass NetsukukuIGSManagerDispatcherClass;

#define NETSUKUKU_TYPE_NETWORK_INTERFACE_MANAGER (netsukuku_network_interface_manager_get_type ())
#define NETSUKUKU_NETWORK_INTERFACE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_NETWORK_INTERFACE_MANAGER, NetsukukuNetworkInterfaceManager))
#define NETSUKUKU_NETWORK_INTERFACE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_NETWORK_INTERFACE_MANAGER, NetsukukuNetworkInterfaceManagerClass))
#define NETSUKUKU_IS_NETWORK_INTERFACE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_NETWORK_INTERFACE_MANAGER))
#define NETSUKUKU_IS_NETWORK_INTERFACE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_NETWORK_INTERFACE_MANAGER))
#define NETSUKUKU_NETWORK_INTERFACE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_NETWORK_INTERFACE_MANAGER, NetsukukuNetworkInterfaceManagerClass))

typedef struct _NetsukukuNetworkInterfaceManager NetsukukuNetworkInterfaceManager;
typedef struct _NetsukukuNetworkInterfaceManagerClass NetsukukuNetworkInterfaceManagerClass;

#define NETSUKUKU_TYPE_NEIGHBOUR_MANAGER (netsukuku_neighbour_manager_get_type ())
#define NETSUKUKU_NEIGHBOUR_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_NEIGHBOUR_MANAGER, NetsukukuNeighbourManager))
#define NETSUKUKU_NEIGHBOUR_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_NEIGHBOUR_MANAGER, NetsukukuNeighbourManagerClass))
#define NETSUKUKU_IS_NEIGHBOUR_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_NEIGHBOUR_MANAGER))
#define NETSUKUKU_IS_NEIGHBOUR_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_NEIGHBOUR_MANAGER))
#define NETSUKUKU_NEIGHBOUR_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_NEIGHBOUR_MANAGER, NetsukukuNeighbourManagerClass))

typedef struct _NetsukukuNeighbourManager NetsukukuNeighbourManager;
typedef struct _NetsukukuNeighbourManagerClass NetsukukuNeighbourManagerClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

typedef enum  {
	NETSUKUKU_RADAR_ERROR_DUPL
} NetsukukuRadarError;
#define NETSUKUKU_RADAR_ERROR netsukuku_radar_error_quark ()
struct _Netsukukustruct_helper_Radar_run {
	NetsukukuRadar* self;
};

struct _NetsukukuRadar {
	GObject parent_instance;
	NetsukukuRadarPrivate * priv;
	gchar* dev_name;
	NetsukukuAddressManager* address_manager;
	gint bouquet_numb;
	gint max_bouquet;
	gint wait_time;
	NetsukukuAddressManagerBroadcastClient* bcastclient;
	GeeArrayList* radar_ids;
};

struct _NetsukukuRadarClass {
	GObjectClass parent_class;
	void (*radar) (NetsukukuRadar* self);
	void (*time_register) (NetsukukuRadar* self, gint radar_id, gint levels, gint gsize, NetsukukuNIP* nip, gint nodeid, NetsukukuNetworkID* netid, const gchar* mac, gboolean is_primary, gboolean is_auxiliary);
	GeeHashMap* (*get_all_avg_rtt) (NetsukukuRadar* self);
};

struct _NetsukukuRadarPrivate {
	GeeHashMap* gather_rtts;
	GeeHashMap* gather_macs;
	GeeHashMap* gather_levels;
	GeeHashMap* gather_gsize;
	GeeHashMap* gather_netid;
	GeeHashMap* gather_is_primary;
	GeeHashMap* gather_is_auxiliary;
	gint max_neighbours;
	TaskletsTasklet* tasklet;
	GeeHashMap* bcast_send_time;
};

typedef NetsukukuNIC* (*NetsukukuCreateNicDelegate) (const gchar* nic_name, void* user_data);
struct _NetsukukuAddressManager {
	GObject parent_instance;
	NetsukukuAddressManagerPrivate * priv;
	GeeArrayList* auxiliary_addresses;
	gint levels;
	gint gsize;
	NetsukukuKeyPair* keypair;
	NetsukukuCreateNicDelegate create_new_nic;
	gpointer create_new_nic_target;
	GDestroyNotify create_new_nic_target_destroy_notify;
	gboolean operative;
	gboolean is_mature;
	NetsukukuIncomingNodes* incoming_nodes;
	NetsukukuMapRoute* maproute;
	NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager;
	NetsukukuEtp* etp;
	NetsukukuPeerToPeerAll* peer_to_peer_all;
	NetsukukuCoordinator* coordinator;
	NetsukukuCounter* counter;
	NetsukukuAndna* andna;
	NetsukukuTunnelManager* tunnel_manager;
	NetsukukuHook* hook;
	NetsukukuBorderNodesManager* border_nodes_manager;
	NetsukukuMigrationManager* migration_manager;
	NetsukukuIGSManagerDispatcher* igs_manager;
	GeeArrayList* nics;
	GeeHashMap* neighbour_managers;
};

struct _NetsukukuAddressManagerClass {
	GObjectClass parent_class;
	void (*_get_data_from_hook_information) (NetsukukuAddressManager* self, gint levels, gint gsize, NetsukukuHookInformation* hook_information, NetsukukuNIP** nip, NetsukukuGNodeID*** id_myself, int* id_myself_length1);
	NetsukukuIncomingNodes* (*create_IncomingNodes) (NetsukukuAddressManager* self);
	NetsukukuMapRoute* (*create_MapRoute) (NetsukukuAddressManager* self, gint levels, gint gsize, NetsukukuNIP* nip, NetsukukuGNodeID** id_myself, int id_myself_length1);
	NetsukukuAggregatedNeighbourManager* (*create_AggregatedNeighbourManager) (NetsukukuAddressManager* self);
	NetsukukuEtp* (*create_Etp) (NetsukukuAddressManager* self, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute);
	NetsukukuPeerToPeerAll* (*create_PeerToPeerAll) (NetsukukuAddressManager* self, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute);
	NetsukukuCoordinator* (*create_Coordinator) (NetsukukuAddressManager* self, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, NetsukukuPeerToPeerAll* peer_to_peer_all);
	NetsukukuCounter* (*create_Counter) (NetsukukuAddressManager* self, NetsukukuKeyPair* keypair, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, NetsukukuPeerToPeerAll* peer_to_peer_all);
	NetsukukuAndna* (*create_Andna) (NetsukukuAddressManager* self, NetsukukuKeyPair* keypair, NetsukukuCounter* counter, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, NetsukukuPeerToPeerAll* peer_to_peer_all);
	NetsukukuTunnelManager* (*create_TunnelManager) (NetsukukuAddressManager* self, const gchar* ipstr);
	NetsukukuHook* (*create_Hook) (NetsukukuAddressManager* self, NetsukukuMapRoute* maproute);
	NetsukukuBorderNodesManager* (*create_BorderNodesManager) (NetsukukuAddressManager* self, NetsukukuMapRoute* maproute, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager);
	NetsukukuMigrationManager* (*create_MigrationManager) (NetsukukuAddressManager* self, NetsukukuMapRoute* maproute, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager);
	gboolean (*do_i_act_as_gateway_for) (NetsukukuAddressManager* self, NetsukukuNIP* nip, gint nodeid, NetsukukuNetworkID* netid);
	gboolean (*do_i_act_as_gateway_for_local) (NetsukukuAddressManager* self);
	gboolean (*do_i_participate_in_routing_tables) (NetsukukuAddressManager* self);
	gboolean (*get_is_auxiliary) (NetsukukuAddressManager* self);
	gboolean (*get_is_autonomous) (NetsukukuAddressManager* self);
};


static gpointer netsukuku_radar_parent_class = NULL;

GQuark netsukuku_radar_error_quark (void);
GType netsukuku_struct_helper_radar_run_get_type (void) G_GNUC_CONST;
GType netsukuku_radar_get_type (void) G_GNUC_CONST;
Netsukukustruct_helper_Radar_run* netsukuku_struct_helper_radar_run_dup (const Netsukukustruct_helper_Radar_run* self);
void netsukuku_struct_helper_radar_run_free (Netsukukustruct_helper_Radar_run* self);
void netsukuku_struct_helper_radar_run_copy (const Netsukukustruct_helper_Radar_run* self, Netsukukustruct_helper_Radar_run* dest);
void netsukuku_struct_helper_radar_run_destroy (Netsukukustruct_helper_Radar_run* self);
GType netsukuku_neighbour_get_type (void) G_GNUC_CONST;
GType netsukuku_address_manager_get_type (void) G_GNUC_CONST;
#define NETSUKUKU_RADAR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), NETSUKUKU_TYPE_RADAR, NetsukukuRadarPrivate))
enum  {
	NETSUKUKU_RADAR_DUMMY_PROPERTY
};
NetsukukuRadar* netsukuku_radar_new_fake (void);
NetsukukuRadar* netsukuku_radar_construct_fake (GType object_type);
NetsukukuRadar* netsukuku_radar_new (const gchar* dev_name, NetsukukuAddressManager* address_manager);
NetsukukuRadar* netsukuku_radar_construct (GType object_type, const gchar* dev_name, NetsukukuAddressManager* address_manager);
gint netsukuku_settings_get_MAX_BOUQUET (void);
gint netsukuku_settings_get_RADAR_WAIT_TIME (void);
gint netsukuku_settings_get_MAX_NEIGHBOURS (void);
static void netsukuku_radar_impl_run (NetsukukuRadar* self, GError** error);
void netsukuku_radar_radar (NetsukukuRadar* self);
static void* netsukuku_radar_helper_run (void* v, GError** error);
void netsukuku_radar_run (NetsukukuRadar* self);
void netsukuku_radar_stop (NetsukukuRadar* self);
static void netsukuku_radar_real_radar (NetsukukuRadar* self);
static gint64* _int64_dup (gint64* self);
GType netsukuku_hook_information_get_type (void) G_GNUC_CONST;
GType netsukuku_incoming_nodes_get_type (void) G_GNUC_CONST;
GType netsukuku_map_get_type (void) G_GNUC_CONST;
GType netsukuku_map_route_get_type (void) G_GNUC_CONST;
GType netsukuku_aggregated_neighbour_manager_get_type (void) G_GNUC_CONST;
GType netsukuku_etp_get_type (void) G_GNUC_CONST;
GType netsukuku_peer_to_peer_all_get_type (void) G_GNUC_CONST;
GType netsukuku_peer_to_peer_get_type (void) G_GNUC_CONST;
GType netsukuku_coordinator_get_type (void) G_GNUC_CONST;
GType netsukuku_key_pair_get_type (void) G_GNUC_CONST;
GType netsukuku_counter_get_type (void) G_GNUC_CONST;
GType netsukuku_andna_get_type (void) G_GNUC_CONST;
GType netsukuku_tunnel_manager_get_type (void) G_GNUC_CONST;
GType netsukuku_hook_get_type (void) G_GNUC_CONST;
GType netsukuku_border_nodes_manager_get_type (void) G_GNUC_CONST;
GType netsukuku_migration_manager_get_type (void) G_GNUC_CONST;
GType netsukuku_nic_get_type (void) G_GNUC_CONST;
GType netsukuku_igs_manager_dispatcher_get_type (void) G_GNUC_CONST;
GType netsukuku_network_interface_manager_get_type (void) G_GNUC_CONST;
GType netsukuku_neighbour_manager_get_type (void) G_GNUC_CONST;
NetsukukuNIP* netsukuku_map_get_me (NetsukukuMap* self);
NetsukukuNetworkID* netsukuku_address_manager_get_main_netid (NetsukukuAddressManager* self);
gint netsukuku_address_manager_get_my_id (NetsukukuAddressManager* self);
GeeHashMap* netsukuku_radar_get_all_avg_rtt (NetsukukuRadar* self);
void netsukuku_log_warn (const gchar* msg);
void netsukuku_radar_radar_reset (NetsukukuRadar* self);
void netsukuku_radar_time_register (NetsukukuRadar* self, gint radar_id, gint levels, gint gsize, NetsukukuNIP* nip, gint nodeid, NetsukukuNetworkID* netid, const gchar* mac, gboolean is_primary, gboolean is_auxiliary);
static void netsukuku_radar_real_time_register (NetsukukuRadar* self, gint radar_id, gint levels, gint gsize, NetsukukuNIP* nip, gint nodeid, NetsukukuNetworkID* netid, const gchar* mac, gboolean is_primary, gboolean is_auxiliary);
gchar* netsukuku_radar_tnip_nodeid_key (NetsukukuRadar* self, NetsukukuNIP* key_nip, gint key_nodeid);
static gint* _int_dup (gint* self);
gint netsukuku_radar_get_avg_rtt (NetsukukuRadar* self, const gchar* key);
void netsukuku_radar_key_tnip_nodeid (NetsukukuRadar* self, const gchar* key, NetsukukuNIP** key_nip, gint* key_nodeid);
static GeeHashMap* netsukuku_radar_real_get_all_avg_rtt (NetsukukuRadar* self);
NetsukukuNeighbour* netsukuku_neighbour_new_with_rtt (gint levels, gint gsize, NetsukukuNIP* nip, gint nodeid, NetsukukuNetworkID* netid, gboolean is_primary, gboolean is_auxiliary, const gchar* dev, GeeList* macs, gint avg_rtt);
NetsukukuNeighbour* netsukuku_neighbour_construct_with_rtt (GType object_type, gint levels, gint gsize, NetsukukuNIP* nip, gint nodeid, NetsukukuNetworkID* netid, gboolean is_primary, gboolean is_auxiliary, const gchar* dev, GeeList* macs, gint avg_rtt);
gchar* netsukuku_radar_to_string (NetsukukuRadar* self);
static void g_cclosure_user_marshal_VOID__INT_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void netsukuku_radar_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GQuark netsukuku_radar_error_quark (void) {
	return g_quark_from_static_string ("netsukuku_radar_error-quark");
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void netsukuku_struct_helper_radar_run_copy (const Netsukukustruct_helper_Radar_run* self, Netsukukustruct_helper_Radar_run* dest) {
	NetsukukuRadar* _tmp0_;
	NetsukukuRadar* _tmp1_;
	_tmp0_ = (*self).self;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 ((*dest).self);
	(*dest).self = _tmp1_;
}


void netsukuku_struct_helper_radar_run_destroy (Netsukukustruct_helper_Radar_run* self) {
	_g_object_unref0 ((*self).self);
}


Netsukukustruct_helper_Radar_run* netsukuku_struct_helper_radar_run_dup (const Netsukukustruct_helper_Radar_run* self) {
	Netsukukustruct_helper_Radar_run* dup;
	dup = g_new0 (Netsukukustruct_helper_Radar_run, 1);
	netsukuku_struct_helper_radar_run_copy (self, dup);
	return dup;
}


void netsukuku_struct_helper_radar_run_free (Netsukukustruct_helper_Radar_run* self) {
	netsukuku_struct_helper_radar_run_destroy (self);
	g_free (self);
}


GType netsukuku_struct_helper_radar_run_get_type (void) {
	static volatile gsize netsukuku_struct_helper_radar_run_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_struct_helper_radar_run_type_id__volatile)) {
		GType netsukuku_struct_helper_radar_run_type_id;
		netsukuku_struct_helper_radar_run_type_id = g_boxed_type_register_static ("Netsukukustruct_helper_Radar_run", (GBoxedCopyFunc) netsukuku_struct_helper_radar_run_dup, (GBoxedFreeFunc) netsukuku_struct_helper_radar_run_free);
		g_once_init_leave (&netsukuku_struct_helper_radar_run_type_id__volatile, netsukuku_struct_helper_radar_run_type_id);
	}
	return netsukuku_struct_helper_radar_run_type_id__volatile;
}


NetsukukuRadar* netsukuku_radar_construct_fake (GType object_type) {
	NetsukukuRadar * self = NULL;
	self = (NetsukukuRadar*) g_object_new (object_type, NULL);
	return self;
}


NetsukukuRadar* netsukuku_radar_new_fake (void) {
	return netsukuku_radar_construct_fake (NETSUKUKU_TYPE_RADAR);
}


NetsukukuRadar* netsukuku_radar_construct (GType object_type, const gchar* dev_name, NetsukukuAddressManager* address_manager) {
	NetsukukuRadar * self = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	NetsukukuAddressManager* _tmp2_;
	NetsukukuAddressManager* _tmp3_;
	GeeHashMap* _tmp4_;
	GeeHashMap* _tmp5_;
	GeeHashMap* _tmp6_;
	GeeHashMap* _tmp7_;
	GeeHashMap* _tmp8_;
	GeeHashMap* _tmp9_;
	GeeHashMap* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	NetsukukuBroadcastID* _tmp17_;
	NetsukukuBroadcastID* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	gchar** _tmp21_ = NULL;
	gchar** _tmp22_;
	gint _tmp22__length1;
	NetsukukuAddressManagerBroadcastClient* _tmp23_;
	g_return_val_if_fail (dev_name != NULL, NULL);
	g_return_val_if_fail (address_manager != NULL, NULL);
	self = (NetsukukuRadar*) g_object_new (object_type, NULL);
	_tmp0_ = dev_name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->dev_name);
	self->dev_name = _tmp1_;
	_tmp2_ = address_manager;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->address_manager);
	self->address_manager = _tmp3_;
	self->bouquet_numb = 0;
	_tmp4_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, GEE_TYPE_ARRAY_LIST, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->gather_rtts);
	self->priv->gather_rtts = _tmp4_;
	_tmp5_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, GEE_TYPE_ARRAY_LIST, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->gather_macs);
	self->priv->gather_macs = _tmp5_;
	_tmp6_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_INT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->gather_levels);
	self->priv->gather_levels = _tmp6_;
	_tmp7_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_INT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->gather_gsize);
	self->priv->gather_gsize = _tmp7_;
	_tmp8_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NETSUKUKU_TYPE_NETWORK_ID, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->gather_netid);
	self->priv->gather_netid = _tmp8_;
	_tmp9_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_BOOLEAN, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->gather_is_primary);
	self->priv->gather_is_primary = _tmp9_;
	_tmp10_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_BOOLEAN, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->gather_is_auxiliary);
	self->priv->gather_is_auxiliary = _tmp10_;
	_tmp11_ = netsukuku_settings_get_MAX_BOUQUET ();
	_tmp12_ = _tmp11_;
	self->max_bouquet = _tmp12_;
	_tmp13_ = netsukuku_settings_get_RADAR_WAIT_TIME ();
	_tmp14_ = _tmp13_;
	self->wait_time = _tmp14_;
	_tmp15_ = netsukuku_settings_get_MAX_NEIGHBOURS ();
	_tmp16_ = _tmp15_;
	self->priv->max_neighbours = _tmp16_;
	_tmp17_ = netsukuku_broadcast_id_new ();
	_tmp18_ = _tmp17_;
	_tmp19_ = self->dev_name;
	_tmp20_ = g_strdup (_tmp19_);
	_tmp21_ = g_new0 (gchar*, 1 + 1);
	_tmp21_[0] = _tmp20_;
	_tmp22_ = _tmp21_;
	_tmp22__length1 = 1;
	_tmp23_ = netsukuku_address_manager_broadcast_client_new ((zcdISerializable*) _tmp18_, _tmp22_, 1, NULL, NULL, (guint16) 269);
	_g_object_unref0 (self->bcastclient);
	self->bcastclient = _tmp23_;
	_tmp22_ = (_vala_array_free (_tmp22_, _tmp22__length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (_tmp18_);
	_g_object_unref0 (self->priv->tasklet);
	self->priv->tasklet = NULL;
	return self;
}


NetsukukuRadar* netsukuku_radar_new (const gchar* dev_name, NetsukukuAddressManager* address_manager) {
	return netsukuku_radar_construct (NETSUKUKU_TYPE_RADAR, dev_name, address_manager);
}


static void netsukuku_radar_impl_run (NetsukukuRadar* self, GError** error) {
	TaskletsTasklet* _tmp0_;
	TaskletsTasklet* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	tasklets_tasklet_declare_self ("Radar.run");
	_tmp0_ = self->priv->tasklet;
	if (_tmp0_ != NULL) {
		GError* _tmp1_;
		_tmp1_ = g_error_new_literal (NETSUKUKU_RADAR_ERROR, NETSUKUKU_RADAR_ERROR_DUPL, "An instance of Radar is already running");
		_inner_error_ = _tmp1_;
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp2_ = tasklets_tasklet_self ();
	_g_object_unref0 (self->priv->tasklet);
	self->priv->tasklet = _tmp2_;
	while (TRUE) {
		netsukuku_radar_radar (self);
	}
}


static void* netsukuku_radar_helper_run (void* v, GError** error) {
	void* result = NULL;
	void* _tmp0_;
	Netsukukustruct_helper_Radar_run* tuple_p;
	NetsukukuRadar* _tmp1_;
	NetsukukuRadar* _tmp2_;
	NetsukukuRadar* self_save;
	GError * _inner_error_ = NULL;
	_tmp0_ = v;
	tuple_p = (Netsukukustruct_helper_Radar_run*) _tmp0_;
	_tmp1_ = (*tuple_p).self;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	self_save = _tmp2_;
	tasklets_tasklet_schedule_back ();
	netsukuku_radar_impl_run (self_save, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self_save);
		return NULL;
	}
	result = NULL;
	_g_object_unref0 (self_save);
	return result;
}


void netsukuku_radar_run (NetsukukuRadar* self) {
	Netsukukustruct_helper_Radar_run arg = {0};
	NetsukukuRadar* _tmp0_;
	TaskletsTasklet* _tmp1_ = NULL;
	TaskletsTasklet* _tmp2_;
	g_return_if_fail (self != NULL);
	memset (&arg, 0, sizeof (Netsukukustruct_helper_Radar_run));
	_tmp0_ = _g_object_ref0 (self);
	_g_object_unref0 (arg.self);
	arg.self = _tmp0_;
	_tmp1_ = tasklets_tasklet_spawn ((TaskletsSpawnable) netsukuku_radar_helper_run, &arg, FALSE, -1);
	_tmp2_ = _tmp1_;
	_g_object_unref0 (_tmp2_);
	netsukuku_struct_helper_radar_run_destroy (&arg);
}


/** Stop the radar scanner
          */
void netsukuku_radar_stop (NetsukukuRadar* self) {
	TaskletsTasklet* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->tasklet;
	if (_tmp0_ != NULL) {
		TaskletsTasklet* _tmp1_;
		_tmp1_ = self->priv->tasklet;
		tasklets_tasklet_abort (_tmp1_);
		_g_object_unref0 (self->priv->tasklet);
		self->priv->tasklet = NULL;
		g_signal_emit_by_name (self, "radar-stop");
	}
}


static gint64* _int64_dup (gint64* self) {
	gint64* dup;
	dup = g_new0 (gint64, 1);
	memcpy (dup, self, sizeof (gint64));
	return dup;
}


static void netsukuku_radar_real_radar (NetsukukuRadar* self) {
	GError * _inner_error_ = NULL;
	{
		GeeArrayList* _tmp0_;
		GeeHashMap* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gdouble interval;
		gint _tmp37_;
		gint _tmp38_;
		GeeHashMap* _tmp39_ = NULL;
		GeeHashMap* detected_neighbours;
		gint _tmp40_;
		GeeHashMap* _tmp41_;
		_tmp0_ = gee_array_list_new (G_TYPE_INT, NULL, NULL, NULL, NULL, NULL);
		_g_object_unref0 (self->radar_ids);
		self->radar_ids = _tmp0_;
		_tmp1_ = gee_hash_map_new (G_TYPE_INT, NULL, NULL, G_TYPE_INT64, (GBoxedCopyFunc) _int64_dup, g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
		_g_object_unref0 (self->priv->bcast_send_time);
		self->priv->bcast_send_time = _tmp1_;
		_tmp2_ = self->wait_time;
		_tmp3_ = self->max_bouquet;
		interval = ((gdouble) _tmp2_) / ((gdouble) (_tmp3_ * 2));
		{
			gint i;
			i = 0;
			{
				gboolean _tmp4_;
				_tmp4_ = TRUE;
				while (TRUE) {
					gboolean _tmp5_;
					gint _tmp7_;
					gint _tmp8_;
					gdouble _tmp9_ = 0.0;
					gint32 _tmp10_ = 0;
					gint radar_id;
					GTimeVal time_now = {0};
					GTimeVal _tmp11_;
					glong _tmp12_;
					GTimeVal _tmp13_;
					glong _tmp14_;
					gint64 msec_now;
					GeeArrayList* _tmp15_;
					gint _tmp16_;
					GeeHashMap* _tmp17_;
					gint _tmp18_;
					gint64 _tmp19_;
					NetsukukuAddressManager* _tmp20_;
					NetsukukuMapRoute* _tmp21_;
					NetsukukuNIP* _tmp22_;
					NetsukukuNIP* _tmp23_;
					NetsukukuNIP* _tmp24_;
					NetsukukuNIP* nip;
					NetsukukuAddressManager* _tmp25_;
					NetsukukuNetworkID* _tmp26_ = NULL;
					NetsukukuNetworkID* netid;
					NetsukukuAddressManager* _tmp27_;
					gint _tmp28_ = 0;
					gint nodeid;
					NetsukukuAddressManagerBroadcastClient* _tmp29_;
					NetsukukuIAggregatedNeighbourManager* _tmp30_;
					NetsukukuIAggregatedNeighbourManager* _tmp31_;
					gint _tmp32_;
					NetsukukuNIP* _tmp33_;
					gint _tmp34_;
					NetsukukuNetworkID* _tmp35_;
					gdouble _tmp36_;
					_tmp5_ = _tmp4_;
					if (!_tmp5_) {
						gint _tmp6_;
						_tmp6_ = i;
						i = _tmp6_ + 1;
					}
					_tmp4_ = FALSE;
					_tmp7_ = i;
					_tmp8_ = self->max_bouquet;
					if (!(_tmp7_ < _tmp8_)) {
						break;
					}
					_tmp9_ = pow ((gdouble) 2, (gdouble) 32);
					_tmp10_ = g_random_int_range ((gint32) 0, (gint32) (((gint) _tmp9_) - 1));
					radar_id = (gint) _tmp10_;
					g_get_current_time (&time_now);
					g_get_current_time (&time_now);
					_tmp11_ = time_now;
					_tmp12_ = _tmp11_.tv_sec;
					_tmp13_ = time_now;
					_tmp14_ = _tmp13_.tv_usec;
					msec_now = (((gint64) _tmp12_) * ((gint64) 1000)) + (((gint64) _tmp14_) / ((gint64) 1000));
					_tmp15_ = self->radar_ids;
					_tmp16_ = radar_id;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp15_, (gpointer) ((gintptr) _tmp16_));
					_tmp17_ = self->priv->bcast_send_time;
					_tmp18_ = radar_id;
					_tmp19_ = msec_now;
					gee_abstract_map_set ((GeeAbstractMap*) _tmp17_, (gpointer) ((gintptr) _tmp18_), &_tmp19_);
					_tmp20_ = self->address_manager;
					_tmp21_ = _tmp20_->maproute;
					_tmp22_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp21_);
					_tmp23_ = _tmp22_;
					_tmp24_ = _g_object_ref0 (_tmp23_);
					nip = _tmp24_;
					_tmp25_ = self->address_manager;
					_tmp26_ = netsukuku_address_manager_get_main_netid (_tmp25_);
					netid = _tmp26_;
					_tmp27_ = self->address_manager;
					_tmp28_ = netsukuku_address_manager_get_my_id (_tmp27_);
					nodeid = _tmp28_;
					_tmp29_ = self->bcastclient;
					_tmp30_ = netsukuku_iaddress_manager_root_dispatcher_get_aggregated_neighbour_manager ((NetsukukuIAddressManagerRootDispatcher*) _tmp29_);
					_tmp31_ = _tmp30_;
					_tmp32_ = radar_id;
					_tmp33_ = nip;
					_tmp34_ = nodeid;
					_tmp35_ = netid;
					netsukuku_iaggregated_neighbour_manager_reply (_tmp31_, _tmp32_, _tmp33_, _tmp34_, _tmp35_, NULL, &_inner_error_);
					if (_inner_error_ != NULL) {
						_g_object_unref0 (netid);
						_g_object_unref0 (nip);
						goto __catch109_g_error;
					}
					_tmp36_ = interval;
					tasklets_ms_wait ((gint64) ((glong) (_tmp36_ * 1000)));
					_g_object_unref0 (netid);
					_g_object_unref0 (nip);
				}
			}
		}
		_tmp37_ = self->wait_time;
		tasklets_ms_wait ((gint64) (_tmp37_ * 500));
		_tmp38_ = self->bouquet_numb;
		self->bouquet_numb = _tmp38_ + 1;
		_tmp39_ = netsukuku_radar_get_all_avg_rtt (self);
		detected_neighbours = _tmp39_;
		_tmp40_ = self->bouquet_numb;
		_tmp41_ = detected_neighbours;
		g_signal_emit_by_name (self, "scan-done", _tmp40_, _tmp41_);
		_g_object_unref0 (detected_neighbours);
	}
	goto __finally109;
	__catch109_g_error:
	{
		GError* e = NULL;
		GError* _tmp42_;
		GQuark _tmp43_;
		const gchar* _tmp44_ = NULL;
		GError* _tmp45_;
		gint _tmp46_;
		GError* _tmp47_;
		const gchar* _tmp48_;
		gchar* _tmp49_ = NULL;
		gchar* _tmp50_;
		gchar* _tmp51_ = NULL;
		gchar* _tmp52_;
		NetsukukuBroadcastID* _tmp53_;
		NetsukukuBroadcastID* _tmp54_;
		const gchar* _tmp55_;
		gchar* _tmp56_;
		gchar** _tmp57_ = NULL;
		gchar** _tmp58_;
		gint _tmp58__length1;
		NetsukukuAddressManagerBroadcastClient* _tmp59_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp42_ = e;
		_tmp43_ = _tmp42_->domain;
		_tmp44_ = g_quark_to_string (_tmp43_);
		_tmp45_ = e;
		_tmp46_ = _tmp45_->code;
		_tmp47_ = e;
		_tmp48_ = _tmp47_->message;
		_tmp49_ = g_strdup_printf ("%s: %d: %s", _tmp44_, _tmp46_, _tmp48_);
		_tmp50_ = _tmp49_;
		_tmp51_ = g_strdup_printf ("Exception %s while doing a radar scan. We ignore it. Soon another scan" \
".", _tmp50_);
		_tmp52_ = _tmp51_;
		netsukuku_log_warn (_tmp52_);
		_g_free0 (_tmp52_);
		_g_free0 (_tmp50_);
		_tmp53_ = netsukuku_broadcast_id_new ();
		_tmp54_ = _tmp53_;
		_tmp55_ = self->dev_name;
		_tmp56_ = g_strdup (_tmp55_);
		_tmp57_ = g_new0 (gchar*, 1 + 1);
		_tmp57_[0] = _tmp56_;
		_tmp58_ = _tmp57_;
		_tmp58__length1 = 1;
		_tmp59_ = netsukuku_address_manager_broadcast_client_new ((zcdISerializable*) _tmp54_, _tmp58_, 1, NULL, NULL, (guint16) 269);
		_g_object_unref0 (self->bcastclient);
		self->bcastclient = _tmp59_;
		_tmp58_ = (_vala_array_free (_tmp58_, _tmp58__length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (_tmp54_);
		tasklets_ms_wait ((gint64) 500);
		_g_error_free0 (e);
	}
	__finally109:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	netsukuku_radar_radar_reset (self);
}


void netsukuku_radar_radar (NetsukukuRadar* self) {
	g_return_if_fail (self != NULL);
	NETSUKUKU_RADAR_GET_CLASS (self)->radar (self);
}


/** Clean the objects needed by radar()
          */
void netsukuku_radar_radar_reset (NetsukukuRadar* self) {
	GeeHashMap* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, GEE_TYPE_ARRAY_LIST, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->gather_rtts);
	self->priv->gather_rtts = _tmp0_;
}


/** save each node's rtt
          */
static gint* _int_dup (gint* self) {
	gint* dup;
	dup = g_new0 (gint, 1);
	memcpy (dup, self, sizeof (gint));
	return dup;
}


static void netsukuku_radar_real_time_register (NetsukukuRadar* self, gint radar_id, gint levels, gint gsize, NetsukukuNIP* nip, gint nodeid, NetsukukuNetworkID* netid, const gchar* mac, gboolean is_primary, gboolean is_auxiliary) {
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	GeeHashMap* _tmp3_;
	gint _tmp4_;
	gpointer _tmp5_ = NULL;
	gint64* _tmp6_;
	gint64 _tmp7_;
	gint64 msec_send_time;
	NetsukukuNIP* _tmp8_;
	gint _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* key;
	GTimeVal time_now = {0};
	GTimeVal _tmp11_;
	glong _tmp12_;
	GTimeVal _tmp13_;
	glong _tmp14_;
	gint64 msec_now;
	gint64 _tmp15_;
	gint64 _tmp16_;
	gint time_elapsed;
	GeeHashMap* _tmp17_;
	const gchar* _tmp18_;
	gboolean _tmp19_ = FALSE;
	g_return_if_fail (nip != NULL);
	g_return_if_fail (netid != NULL);
	g_return_if_fail (mac != NULL);
	_tmp0_ = self->radar_ids;
	_tmp1_ = radar_id;
	_tmp2_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp0_, (gpointer) ((gintptr) _tmp1_));
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = self->priv->bcast_send_time;
	_tmp4_ = radar_id;
	_tmp5_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp3_, (gpointer) ((gintptr) _tmp4_));
	_tmp6_ = (gint64*) _tmp5_;
	_tmp7_ = *_tmp6_;
	_g_free0 (_tmp6_);
	msec_send_time = _tmp7_;
	_tmp8_ = nip;
	_tmp9_ = nodeid;
	_tmp10_ = netsukuku_radar_tnip_nodeid_key (self, _tmp8_, _tmp9_);
	key = _tmp10_;
	g_get_current_time (&time_now);
	g_get_current_time (&time_now);
	_tmp11_ = time_now;
	_tmp12_ = _tmp11_.tv_sec;
	_tmp13_ = time_now;
	_tmp14_ = _tmp13_.tv_usec;
	msec_now = (((gint64) _tmp12_) * ((gint64) 1000)) + (((gint64) _tmp14_) / ((gint64) 1000));
	_tmp15_ = msec_now;
	_tmp16_ = msec_send_time;
	time_elapsed = (gint) (_tmp15_ - _tmp16_);
	_tmp17_ = self->priv->gather_rtts;
	_tmp18_ = key;
	_tmp19_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp17_, _tmp18_);
	if (_tmp19_) {
		GeeHashMap* _tmp20_;
		const gchar* _tmp21_;
		gpointer _tmp22_ = NULL;
		GeeArrayList* _tmp23_;
		gint _tmp24_;
		GeeHashMap* _tmp25_;
		const gchar* _tmp26_;
		gpointer _tmp27_ = NULL;
		GeeArrayList* _tmp28_;
		const gchar* _tmp29_;
		gboolean _tmp30_ = FALSE;
		gboolean _tmp31_;
		_tmp20_ = self->priv->gather_rtts;
		_tmp21_ = key;
		_tmp22_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp20_, _tmp21_);
		_tmp23_ = (GeeArrayList*) _tmp22_;
		_tmp24_ = time_elapsed;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp23_, &_tmp24_);
		_g_object_unref0 (_tmp23_);
		_tmp25_ = self->priv->gather_macs;
		_tmp26_ = key;
		_tmp27_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp25_, _tmp26_);
		_tmp28_ = (GeeArrayList*) _tmp27_;
		_tmp29_ = mac;
		_tmp30_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp28_, _tmp29_);
		_tmp31_ = !_tmp30_;
		_g_object_unref0 (_tmp28_);
		if (_tmp31_) {
			GeeHashMap* _tmp32_;
			const gchar* _tmp33_;
			gpointer _tmp34_ = NULL;
			GeeArrayList* _tmp35_;
			const gchar* _tmp36_;
			_tmp32_ = self->priv->gather_macs;
			_tmp33_ = key;
			_tmp34_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp32_, _tmp33_);
			_tmp35_ = (GeeArrayList*) _tmp34_;
			_tmp36_ = mac;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp35_, _tmp36_);
			_g_object_unref0 (_tmp35_);
		}
	} else {
		GeeHashMap* _tmp37_;
		const gchar* _tmp38_;
		GeeArrayList* _tmp39_;
		GeeArrayList* _tmp40_;
		GeeHashMap* _tmp41_;
		const gchar* _tmp42_;
		gpointer _tmp43_ = NULL;
		GeeArrayList* _tmp44_;
		gint _tmp45_;
		GeeHashMap* _tmp46_;
		const gchar* _tmp47_;
		GeeArrayList* _tmp48_;
		GeeArrayList* _tmp49_;
		GeeHashMap* _tmp50_;
		const gchar* _tmp51_;
		gpointer _tmp52_ = NULL;
		GeeArrayList* _tmp53_;
		const gchar* _tmp54_;
		GeeHashMap* _tmp55_;
		const gchar* _tmp56_;
		gint _tmp57_;
		GeeHashMap* _tmp58_;
		const gchar* _tmp59_;
		gint _tmp60_;
		GeeHashMap* _tmp61_;
		const gchar* _tmp62_;
		NetsukukuNetworkID* _tmp63_;
		GeeHashMap* _tmp64_;
		const gchar* _tmp65_;
		gboolean _tmp66_;
		GeeHashMap* _tmp67_;
		const gchar* _tmp68_;
		gboolean _tmp69_;
		_tmp37_ = self->priv->gather_rtts;
		_tmp38_ = key;
		_tmp39_ = gee_array_list_new (G_TYPE_INT, (GBoxedCopyFunc) _int_dup, g_free, NULL, NULL, NULL);
		_tmp40_ = _tmp39_;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp37_, _tmp38_, _tmp40_);
		_g_object_unref0 (_tmp40_);
		_tmp41_ = self->priv->gather_rtts;
		_tmp42_ = key;
		_tmp43_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp41_, _tmp42_);
		_tmp44_ = (GeeArrayList*) _tmp43_;
		_tmp45_ = time_elapsed;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp44_, &_tmp45_);
		_g_object_unref0 (_tmp44_);
		_tmp46_ = self->priv->gather_macs;
		_tmp47_ = key;
		_tmp48_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
		_tmp49_ = _tmp48_;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp46_, _tmp47_, _tmp49_);
		_g_object_unref0 (_tmp49_);
		_tmp50_ = self->priv->gather_macs;
		_tmp51_ = key;
		_tmp52_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp50_, _tmp51_);
		_tmp53_ = (GeeArrayList*) _tmp52_;
		_tmp54_ = mac;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp53_, _tmp54_);
		_g_object_unref0 (_tmp53_);
		_tmp55_ = self->priv->gather_levels;
		_tmp56_ = key;
		_tmp57_ = levels;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp55_, _tmp56_, (gpointer) ((gintptr) _tmp57_));
		_tmp58_ = self->priv->gather_gsize;
		_tmp59_ = key;
		_tmp60_ = gsize;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp58_, _tmp59_, (gpointer) ((gintptr) _tmp60_));
		_tmp61_ = self->priv->gather_netid;
		_tmp62_ = key;
		_tmp63_ = netid;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp61_, _tmp62_, _tmp63_);
		_tmp64_ = self->priv->gather_is_primary;
		_tmp65_ = key;
		_tmp66_ = is_primary;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp64_, _tmp65_, (gpointer) ((gintptr) _tmp66_));
		_tmp67_ = self->priv->gather_is_auxiliary;
		_tmp68_ = key;
		_tmp69_ = is_auxiliary;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp67_, _tmp68_, (gpointer) ((gintptr) _tmp69_));
	}
	_g_free0 (key);
}


void netsukuku_radar_time_register (NetsukukuRadar* self, gint radar_id, gint levels, gint gsize, NetsukukuNIP* nip, gint nodeid, NetsukukuNetworkID* netid, const gchar* mac, gboolean is_primary, gboolean is_auxiliary) {
	g_return_if_fail (self != NULL);
	NETSUKUKU_RADAR_GET_CLASS (self)->time_register (self, radar_id, levels, gsize, nip, nodeid, netid, mac, is_primary, is_auxiliary);
}


/** Calculates the average RTT of the neighbour for the device associated to this radar.
          */
gint netsukuku_radar_get_avg_rtt (NetsukukuRadar* self, const gchar* key) {
	gint result = 0;
	GeeHashMap* _tmp0_;
	const gchar* _tmp1_;
	gpointer _tmp2_ = NULL;
	GeeArrayList* rtts;
	gint sum;
	gint _tmp18_;
	GeeArrayList* _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (key != NULL, 0);
	_tmp0_ = self->priv->gather_rtts;
	_tmp1_ = key;
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, _tmp1_);
	rtts = (GeeArrayList*) _tmp2_;
	sum = 0;
	{
		GeeArrayList* _tmp3_;
		GeeArrayList* _tmp4_;
		GeeArrayList* _rtt_list;
		GeeArrayList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _rtt_size;
		gint _rtt_index;
		_tmp3_ = rtts;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		_rtt_list = _tmp4_;
		_tmp5_ = _rtt_list;
		_tmp6_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_rtt_size = _tmp7_;
		_rtt_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			GeeArrayList* _tmp11_;
			gint _tmp12_;
			gpointer _tmp13_ = NULL;
			gint* _tmp14_;
			gint _tmp15_;
			gint rtt;
			gint _tmp16_;
			gint _tmp17_;
			_tmp8_ = _rtt_index;
			_rtt_index = _tmp8_ + 1;
			_tmp9_ = _rtt_index;
			_tmp10_ = _rtt_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _rtt_list;
			_tmp12_ = _rtt_index;
			_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) _tmp11_, _tmp12_);
			_tmp14_ = (gint*) _tmp13_;
			_tmp15_ = *_tmp14_;
			_g_free0 (_tmp14_);
			rtt = _tmp15_;
			_tmp16_ = sum;
			_tmp17_ = rtt;
			sum = _tmp16_ + _tmp17_;
		}
		_g_object_unref0 (_rtt_list);
	}
	_tmp18_ = sum;
	_tmp19_ = rtts;
	_tmp20_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp19_);
	_tmp21_ = _tmp20_;
	result = _tmp18_ / _tmp21_;
	_g_object_unref0 (rtts);
	return result;
}


gchar* netsukuku_radar_tnip_nodeid_key (NetsukukuRadar* self, NetsukukuNIP* key_nip, gint key_nodeid) {
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* ret;
	NetsukukuNIP* _tmp1_;
	gint _tmp2_ = 0;
	gint* _tmp3_ = NULL;
	gint* nip;
	gint nip_length1;
	gint _nip_size_;
	gint* _tmp4_;
	gint _tmp4__length1;
	const gchar* _tmp10_;
	gint _tmp11_;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_;
	gchar* _tmp14_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (key_nip != NULL, NULL);
	_tmp0_ = g_strdup ("");
	ret = _tmp0_;
	_tmp1_ = key_nip;
	_tmp3_ = netsukuku_partial_nip_get_positions ((NetsukukuPartialNIP*) _tmp1_, &_tmp2_);
	nip = _tmp3_;
	nip_length1 = _tmp2_;
	_nip_size_ = nip_length1;
	_tmp4_ = nip;
	_tmp4__length1 = nip_length1;
	{
		gint* i_collection = NULL;
		gint i_collection_length1 = 0;
		gint _i_collection_size_ = 0;
		gint i_it = 0;
		i_collection = _tmp4_;
		i_collection_length1 = _tmp4__length1;
		for (i_it = 0; i_it < _tmp4__length1; i_it = i_it + 1) {
			gint i = 0;
			i = i_collection[i_it];
			{
				const gchar* _tmp5_;
				gint _tmp6_;
				gchar* _tmp7_ = NULL;
				gchar* _tmp8_;
				gchar* _tmp9_;
				_tmp5_ = ret;
				_tmp6_ = i;
				_tmp7_ = g_strdup_printf ("%d_", _tmp6_);
				_tmp8_ = _tmp7_;
				_tmp9_ = g_strconcat (_tmp5_, _tmp8_, NULL);
				_g_free0 (ret);
				ret = _tmp9_;
				_g_free0 (_tmp8_);
			}
		}
	}
	_tmp10_ = ret;
	_tmp11_ = key_nodeid;
	_tmp12_ = g_strdup_printf ("%d", _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strconcat (_tmp10_, _tmp13_, NULL);
	_g_free0 (ret);
	ret = _tmp14_;
	_g_free0 (_tmp13_);
	result = ret;
	nip = (g_free (nip), NULL);
	return result;
}


void netsukuku_radar_key_tnip_nodeid (NetsukukuRadar* self, const gchar* key, NetsukukuNIP** key_nip, gint* key_nodeid) {
	NetsukukuNIP* _vala_key_nip = NULL;
	gint _vala_key_nodeid = 0;
	const gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_ = NULL;
	gchar** nums;
	gint nums_length1;
	gint _nums_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gint* _tmp4_ = NULL;
	gint* pos;
	gint pos_length1;
	gint _pos_size_;
	gchar** _tmp17_;
	gint _tmp17__length1;
	gchar** _tmp18_;
	gint _tmp18__length1;
	const gchar* _tmp19_;
	gint _tmp20_ = 0;
	gint* _tmp21_;
	gint _tmp21__length1;
	NetsukukuNIP* _tmp22_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = key;
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, "_", 0);
	nums = _tmp2_;
	nums_length1 = _vala_array_length (_tmp1_);
	_nums_size_ = nums_length1;
	_tmp3_ = nums;
	_tmp3__length1 = nums_length1;
	_tmp4_ = g_new0 (gint, _tmp3__length1 - 1);
	pos = _tmp4_;
	pos_length1 = _tmp3__length1 - 1;
	_pos_size_ = pos_length1;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp5_;
			_tmp5_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_;
				gint _tmp8_;
				gint* _tmp9_;
				gint _tmp9__length1;
				gint* _tmp10_;
				gint _tmp10__length1;
				gint _tmp11_;
				gchar** _tmp12_;
				gint _tmp12__length1;
				gint _tmp13_;
				const gchar* _tmp14_;
				gint _tmp15_ = 0;
				gint _tmp16_;
				_tmp6_ = _tmp5_;
				if (!_tmp6_) {
					gint _tmp7_;
					_tmp7_ = i;
					i = _tmp7_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp8_ = i;
				_tmp9_ = pos;
				_tmp9__length1 = pos_length1;
				if (!(_tmp8_ < _tmp9__length1)) {
					break;
				}
				_tmp10_ = pos;
				_tmp10__length1 = pos_length1;
				_tmp11_ = i;
				_tmp12_ = nums;
				_tmp12__length1 = nums_length1;
				_tmp13_ = i;
				_tmp14_ = _tmp12_[_tmp13_];
				_tmp15_ = atoi (_tmp14_);
				_tmp10_[_tmp11_] = _tmp15_;
				_tmp16_ = _tmp10_[_tmp11_];
			}
		}
	}
	_tmp17_ = nums;
	_tmp17__length1 = nums_length1;
	_tmp18_ = nums;
	_tmp18__length1 = nums_length1;
	_tmp19_ = _tmp17_[_tmp18__length1 - 1];
	_tmp20_ = atoi (_tmp19_);
	_vala_key_nodeid = _tmp20_;
	_tmp21_ = pos;
	_tmp21__length1 = pos_length1;
	_tmp22_ = netsukuku_nip_new (_tmp21_, _tmp21__length1);
	_g_object_unref0 (_vala_key_nip);
	_vala_key_nip = _tmp22_;
	pos = (g_free (pos), NULL);
	nums = (_vala_array_free (nums, nums_length1, (GDestroyNotify) g_free), NULL);
	if (key_nip) {
		*key_nip = _vala_key_nip;
	} else {
		_g_object_unref0 (_vala_key_nip);
	}
	if (key_nodeid) {
		*key_nodeid = _vala_key_nodeid;
	}
}


/** Calculate the average rtt of all the neighbours
          */
static GeeHashMap* netsukuku_radar_real_get_all_avg_rtt (NetsukukuRadar* self) {
	GeeHashMap* result = NULL;
	GeeHashMap* _tmp0_;
	GeeHashMap* all_avg;
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NETSUKUKU_TYPE_NEIGHBOUR, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	all_avg = _tmp0_;
	{
		GeeHashMap* _tmp1_;
		GeeSet* _tmp2_;
		GeeSet* _tmp3_;
		GeeSet* _tmp4_;
		GeeIterator* _tmp5_ = NULL;
		GeeIterator* _tmp6_;
		GeeIterator* _key_it;
		_tmp1_ = self->priv->gather_rtts;
		_tmp2_ = gee_abstract_map_get_keys ((GeeMap*) _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_;
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
		_key_it = _tmp6_;
		while (TRUE) {
			GeeIterator* _tmp7_;
			gboolean _tmp8_ = FALSE;
			GeeIterator* _tmp9_;
			gpointer _tmp10_ = NULL;
			gchar* key;
			NetsukukuNIP* nip = NULL;
			gint nodeid = 0;
			const gchar* _tmp11_;
			NetsukukuNIP* _tmp12_ = NULL;
			gint _tmp13_ = 0;
			const gchar* _tmp14_;
			gint _tmp15_ = 0;
			gint avg;
			GeeHashMap* _tmp16_;
			const gchar* _tmp17_;
			GeeHashMap* _tmp18_;
			const gchar* _tmp19_;
			gpointer _tmp20_ = NULL;
			GeeHashMap* _tmp21_;
			const gchar* _tmp22_;
			gpointer _tmp23_ = NULL;
			NetsukukuNIP* _tmp24_;
			gint _tmp25_;
			GeeHashMap* _tmp26_;
			const gchar* _tmp27_;
			gpointer _tmp28_ = NULL;
			NetsukukuNetworkID* _tmp29_;
			GeeHashMap* _tmp30_;
			const gchar* _tmp31_;
			gpointer _tmp32_ = NULL;
			GeeHashMap* _tmp33_;
			const gchar* _tmp34_;
			gpointer _tmp35_ = NULL;
			const gchar* _tmp36_;
			GeeHashMap* _tmp37_;
			const gchar* _tmp38_;
			gpointer _tmp39_ = NULL;
			GeeArrayList* _tmp40_;
			gint _tmp41_;
			NetsukukuNeighbour* _tmp42_;
			NetsukukuNeighbour* _tmp43_;
			_tmp7_ = _key_it;
			_tmp8_ = gee_iterator_next (_tmp7_);
			if (!_tmp8_) {
				break;
			}
			_tmp9_ = _key_it;
			_tmp10_ = gee_iterator_get (_tmp9_);
			key = (gchar*) _tmp10_;
			_tmp11_ = key;
			netsukuku_radar_key_tnip_nodeid (self, _tmp11_, &_tmp12_, &_tmp13_);
			_g_object_unref0 (nip);
			nip = _tmp12_;
			nodeid = _tmp13_;
			_tmp14_ = key;
			_tmp15_ = netsukuku_radar_get_avg_rtt (self, _tmp14_);
			avg = _tmp15_;
			_tmp16_ = all_avg;
			_tmp17_ = key;
			_tmp18_ = self->priv->gather_levels;
			_tmp19_ = key;
			_tmp20_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp18_, _tmp19_);
			_tmp21_ = self->priv->gather_gsize;
			_tmp22_ = key;
			_tmp23_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp21_, _tmp22_);
			_tmp24_ = nip;
			_tmp25_ = nodeid;
			_tmp26_ = self->priv->gather_netid;
			_tmp27_ = key;
			_tmp28_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp26_, _tmp27_);
			_tmp29_ = (NetsukukuNetworkID*) _tmp28_;
			_tmp30_ = self->priv->gather_is_primary;
			_tmp31_ = key;
			_tmp32_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp30_, _tmp31_);
			_tmp33_ = self->priv->gather_is_auxiliary;
			_tmp34_ = key;
			_tmp35_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp33_, _tmp34_);
			_tmp36_ = self->dev_name;
			_tmp37_ = self->priv->gather_macs;
			_tmp38_ = key;
			_tmp39_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp37_, _tmp38_);
			_tmp40_ = (GeeArrayList*) _tmp39_;
			_tmp41_ = avg;
			_tmp42_ = netsukuku_neighbour_new_with_rtt ((gint) ((gintptr) _tmp20_), (gint) ((gintptr) _tmp23_), _tmp24_, _tmp25_, _tmp29_, (gboolean) ((gintptr) _tmp32_), (gboolean) ((gintptr) _tmp35_), _tmp36_, (GeeList*) _tmp40_, _tmp41_);
			_tmp43_ = _tmp42_;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp16_, _tmp17_, _tmp43_);
			_g_object_unref0 (_tmp43_);
			_g_object_unref0 (_tmp40_);
			_g_object_unref0 (_tmp29_);
			_g_object_unref0 (nip);
			_g_free0 (key);
		}
		_g_object_unref0 (_key_it);
	}
	result = all_avg;
	return result;
}


GeeHashMap* netsukuku_radar_get_all_avg_rtt (NetsukukuRadar* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return NETSUKUKU_RADAR_GET_CLASS (self)->get_all_avg_rtt (self);
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


gchar* netsukuku_radar_to_string (NetsukukuRadar* self) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->dev_name;
	_tmp1_ = string_to_string (_tmp0_);
	_tmp2_ = g_strconcat ("<Radar for device ", _tmp1_, ">", NULL);
	result = _tmp2_;
	return result;
}


static void g_cclosure_user_marshal_VOID__INT_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__INT_OBJECT) (gpointer data1, gint arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__INT_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__INT_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_int (param_values + 1), g_value_get_object (param_values + 2), data2);
}


static void netsukuku_radar_class_init (NetsukukuRadarClass * klass) {
	netsukuku_radar_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (NetsukukuRadarPrivate));
	NETSUKUKU_RADAR_CLASS (klass)->radar = netsukuku_radar_real_radar;
	NETSUKUKU_RADAR_CLASS (klass)->time_register = netsukuku_radar_real_time_register;
	NETSUKUKU_RADAR_CLASS (klass)->get_all_avg_rtt = netsukuku_radar_real_get_all_avg_rtt;
	G_OBJECT_CLASS (klass)->finalize = netsukuku_radar_finalize;
	g_signal_new ("scan_done", NETSUKUKU_TYPE_RADAR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_OBJECT, G_TYPE_NONE, 2, G_TYPE_INT, GEE_TYPE_HASH_MAP);
	g_signal_new ("radar_stop", NETSUKUKU_TYPE_RADAR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void netsukuku_radar_instance_init (NetsukukuRadar * self) {
	self->priv = NETSUKUKU_RADAR_GET_PRIVATE (self);
	self->priv->tasklet = NULL;
}


static void netsukuku_radar_finalize (GObject* obj) {
	NetsukukuRadar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_RADAR, NetsukukuRadar);
	_g_free0 (self->dev_name);
	_g_object_unref0 (self->address_manager);
	_g_object_unref0 (self->priv->gather_rtts);
	_g_object_unref0 (self->priv->gather_macs);
	_g_object_unref0 (self->priv->gather_levels);
	_g_object_unref0 (self->priv->gather_gsize);
	_g_object_unref0 (self->priv->gather_netid);
	_g_object_unref0 (self->priv->gather_is_primary);
	_g_object_unref0 (self->priv->gather_is_auxiliary);
	_g_object_unref0 (self->bcastclient);
	_g_object_unref0 (self->priv->tasklet);
	_g_object_unref0 (self->radar_ids);
	_g_object_unref0 (self->priv->bcast_send_time);
	G_OBJECT_CLASS (netsukuku_radar_parent_class)->finalize (obj);
}


/** An instance of Radar uses a certain network interface on behalf of a certain AddressManager.
      * The radar sends in broadcast a bouquet of MAX_BOUQUET packets and waits
      * for the reply of the alive nodes. It then recollects the replies and builds
      * a small statistic.
      * Then it reports the detected neighbours to the NeighbourManager(s) interested
      * in that network interface.
      *
      * A radar is fired periodically by Radar.run(), which is started as a
      * microfunc.
      */
GType netsukuku_radar_get_type (void) {
	static volatile gsize netsukuku_radar_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_radar_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuRadarClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_radar_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuRadar), 0, (GInstanceInitFunc) netsukuku_radar_instance_init, NULL };
		GType netsukuku_radar_type_id;
		netsukuku_radar_type_id = g_type_register_static (G_TYPE_OBJECT, "NetsukukuRadar", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_radar_type_id__volatile, netsukuku_radar_type_id);
	}
	return netsukuku_radar_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



