/* map.c generated by valac 0.20.1, the Vala compiler
 * generated from map.vala, do not modify */

/*
 *  This file is part of Netsukuku.
 *  (c) Copyright 2011 Luca Dionisi aka lukisi <luca.dionisi@gmail.com>
 *
 *  Netsukuku is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Netsukuku is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Netsukuku.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <netsukuku-rpc.h>
#include <tasklet.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define NETSUKUKU_TYPE_STRUCT_HELPER_MAP_PERIODICALLY_CHECK_ALL_NODES (netsukuku_struct_helper_map_periodically_check_all_nodes_get_type ())

#define NETSUKUKU_TYPE_MAP (netsukuku_map_get_type ())
#define NETSUKUKU_MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_MAP, NetsukukuMap))
#define NETSUKUKU_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_MAP, NetsukukuMapClass))
#define NETSUKUKU_IS_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_MAP))
#define NETSUKUKU_IS_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_MAP))
#define NETSUKUKU_MAP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_MAP, NetsukukuMapClass))

typedef struct _NetsukukuMap NetsukukuMap;
typedef struct _NetsukukuMapClass NetsukukuMapClass;
typedef struct _Netsukukustruct_helper_Map_periodically_check_all_nodes Netsukukustruct_helper_Map_periodically_check_all_nodes;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define NETSUKUKU_TYPE_STRUCT_HELPER_MAP_CHECK_NODE (netsukuku_struct_helper_map_check_node_get_type ())
typedef struct _Netsukukustruct_helper_Map_check_node Netsukukustruct_helper_Map_check_node;
typedef struct _NetsukukuMapPrivate NetsukukuMapPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Netsukukustruct_helper_Map_periodically_check_all_nodes {
	NetsukukuMap* self;
};

struct _Netsukukustruct_helper_Map_check_node {
	NetsukukuMap* self;
	gint lvl;
	gint pos;
};

struct _NetsukukuMap {
	GObject parent_instance;
	NetsukukuMapPrivate * priv;
	NetsukukuDataClass** node;
	gint node_length1;
	gint node_length2;
};

struct _NetsukukuMapClass {
	GObjectClass parent_class;
	void (*stop_operations) (NetsukukuMap* self);
	gpointer (*node_get) (NetsukukuMap* self, gint lvl, gint pos);
};

struct _NetsukukuMapPrivate {
	GType t_type;
	GBoxedCopyFunc t_dup_func;
	GDestroyNotify t_destroy_func;
	gint _levels;
	gint _gsize;
	NetsukukuNIP* _me;
	gboolean* node_prev_free;
	gint node_prev_free_length1;
	gint node_prev_free_length2;
	TaskletsTasklet* check_all_nodes_handle;
	gboolean stopped_operations;
};


static gpointer netsukuku_map_parent_class = NULL;

GType netsukuku_struct_helper_map_periodically_check_all_nodes_get_type (void) G_GNUC_CONST;
GType netsukuku_map_get_type (void) G_GNUC_CONST;
Netsukukustruct_helper_Map_periodically_check_all_nodes* netsukuku_struct_helper_map_periodically_check_all_nodes_dup (const Netsukukustruct_helper_Map_periodically_check_all_nodes* self);
void netsukuku_struct_helper_map_periodically_check_all_nodes_free (Netsukukustruct_helper_Map_periodically_check_all_nodes* self);
void netsukuku_struct_helper_map_periodically_check_all_nodes_copy (const Netsukukustruct_helper_Map_periodically_check_all_nodes* self, Netsukukustruct_helper_Map_periodically_check_all_nodes* dest);
void netsukuku_struct_helper_map_periodically_check_all_nodes_destroy (Netsukukustruct_helper_Map_periodically_check_all_nodes* self);
GType netsukuku_struct_helper_map_check_node_get_type (void) G_GNUC_CONST;
Netsukukustruct_helper_Map_check_node* netsukuku_struct_helper_map_check_node_dup (const Netsukukustruct_helper_Map_check_node* self);
void netsukuku_struct_helper_map_check_node_free (Netsukukustruct_helper_Map_check_node* self);
void netsukuku_struct_helper_map_check_node_copy (const Netsukukustruct_helper_Map_check_node* self, Netsukukustruct_helper_Map_check_node* dest);
void netsukuku_struct_helper_map_check_node_destroy (Netsukukustruct_helper_Map_check_node* self);
#define NETSUKUKU_MAP_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), NETSUKUKU_TYPE_MAP, NetsukukuMapPrivate))
enum  {
	NETSUKUKU_MAP_DUMMY_PROPERTY,
	NETSUKUKU_MAP_T_TYPE,
	NETSUKUKU_MAP_T_DUP_FUNC,
	NETSUKUKU_MAP_T_DESTROY_FUNC,
	NETSUKUKU_MAP_LEVELS,
	NETSUKUKU_MAP_GSIZE,
	NETSUKUKU_MAP_ME
};
NetsukukuMap* netsukuku_map_new (GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, gint levels, gint gsize, NetsukukuNIP* me);
NetsukukuMap* netsukuku_map_construct (GType object_type, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, gint levels, gint gsize, NetsukukuNIP* me);
void netsukuku_map_periodically_check_all_nodes (NetsukukuMap* self);
static void netsukuku_map_impl_periodically_check_all_nodes (NetsukukuMap* self, GError** error);
void netsukuku_map_check_node (NetsukukuMap* self, gint lvl, gint pos);
void netsukuku_log_error (const gchar* msg);
static void* netsukuku_map_helper_periodically_check_all_nodes (void* v, GError** error);
void netsukuku_map_stop_operations (NetsukukuMap* self);
static void netsukuku_map_real_stop_operations (NetsukukuMap* self);
static void netsukuku_map_impl_check_node (NetsukukuMap* self, gint lvl, gint pos, GError** error);
gpointer netsukuku_map_node_get (NetsukukuMap* self, gint lvl, gint pos);
void netsukuku_map_node_add (NetsukukuMap* self, gint lvl, gint pos);
void netsukuku_map_node_del (NetsukukuMap* self, gint lvl, gint pos);
static void* netsukuku_map_helper_check_node (void* v, GError** error);
void netsukuku_log_warn (const gchar* msg);
static gpointer netsukuku_map_real_node_get (NetsukukuMap* self, gint lvl, gint pos);
gpointer netsukuku_map_node_get_hcoord (NetsukukuMap* self, NetsukukuHCoord* hc);
void netsukuku_map_node_remove (NetsukukuMap* self, gint lvl, gint pos);
gint netsukuku_map_free_nodes_nb (NetsukukuMap* self, gint lvl);
gint* netsukuku_map_free_nodes_list (NetsukukuMap* self, gint lvl, int* result_length1);
GeeArrayList* netsukuku_valid_ids (gint levels, gint gsize, gint lvl, NetsukukuPartialNIP* partial_nip);
gint netsukuku_map_busy_nodes_nb (NetsukukuMap* self, gint lvl);
gint* netsukuku_map_busy_nodes_list (NetsukukuMap* self, gint lvl, int* result_length1);
gint* netsukuku_map_get_all_busy_nodes_nb (NetsukukuMap* self, int* result_length1);
gint netsukuku_map_nip_cmp (NetsukukuMap* self, gint* nipA, int nipA_length1);
NetsukukuPartialNIP* netsukuku_map_lvlid_to_nip (NetsukukuMap* self, NetsukukuHCoord* lvlid);
NetsukukuHCoord* netsukuku_map_nip_to_lvlid (NetsukukuMap* self, NetsukukuPartialNIP* nip);
GeeList* netsukuku_map_list_lvl_id_from_nip (NetsukukuMap* self, GeeList* lvl_ids, NetsukukuNIP* sender_nip);
static gboolean _netsukuku_hcoord_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self);
GeeList* netsukuku_map_list_lvl_id_to_nip (NetsukukuMap* self, GeeList* lvl_ids, NetsukukuNIP* to_nip);
gint netsukuku_map_get_levels (NetsukukuMap* self);
gint netsukuku_map_get_gsize (NetsukukuMap* self);
NetsukukuNIP* netsukuku_map_get_me (NetsukukuMap* self);
static void g_cclosure_user_marshal_VOID__INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void netsukuku_map_finalize (GObject* obj);
static void _vala_netsukuku_map_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_netsukuku_map_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void netsukuku_struct_helper_map_periodically_check_all_nodes_copy (const Netsukukustruct_helper_Map_periodically_check_all_nodes* self, Netsukukustruct_helper_Map_periodically_check_all_nodes* dest) {
	NetsukukuMap* _tmp0_;
	NetsukukuMap* _tmp1_;
	_tmp0_ = (*self).self;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 ((*dest).self);
	(*dest).self = _tmp1_;
}


void netsukuku_struct_helper_map_periodically_check_all_nodes_destroy (Netsukukustruct_helper_Map_periodically_check_all_nodes* self) {
	_g_object_unref0 ((*self).self);
}


Netsukukustruct_helper_Map_periodically_check_all_nodes* netsukuku_struct_helper_map_periodically_check_all_nodes_dup (const Netsukukustruct_helper_Map_periodically_check_all_nodes* self) {
	Netsukukustruct_helper_Map_periodically_check_all_nodes* dup;
	dup = g_new0 (Netsukukustruct_helper_Map_periodically_check_all_nodes, 1);
	netsukuku_struct_helper_map_periodically_check_all_nodes_copy (self, dup);
	return dup;
}


void netsukuku_struct_helper_map_periodically_check_all_nodes_free (Netsukukustruct_helper_Map_periodically_check_all_nodes* self) {
	netsukuku_struct_helper_map_periodically_check_all_nodes_destroy (self);
	g_free (self);
}


GType netsukuku_struct_helper_map_periodically_check_all_nodes_get_type (void) {
	static volatile gsize netsukuku_struct_helper_map_periodically_check_all_nodes_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_struct_helper_map_periodically_check_all_nodes_type_id__volatile)) {
		GType netsukuku_struct_helper_map_periodically_check_all_nodes_type_id;
		netsukuku_struct_helper_map_periodically_check_all_nodes_type_id = g_boxed_type_register_static ("Netsukukustruct_helper_Map_periodically_check_all_nodes", (GBoxedCopyFunc) netsukuku_struct_helper_map_periodically_check_all_nodes_dup, (GBoxedFreeFunc) netsukuku_struct_helper_map_periodically_check_all_nodes_free);
		g_once_init_leave (&netsukuku_struct_helper_map_periodically_check_all_nodes_type_id__volatile, netsukuku_struct_helper_map_periodically_check_all_nodes_type_id);
	}
	return netsukuku_struct_helper_map_periodically_check_all_nodes_type_id__volatile;
}


void netsukuku_struct_helper_map_check_node_copy (const Netsukukustruct_helper_Map_check_node* self, Netsukukustruct_helper_Map_check_node* dest) {
	NetsukukuMap* _tmp0_;
	NetsukukuMap* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	_tmp0_ = (*self).self;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 ((*dest).self);
	(*dest).self = _tmp1_;
	_tmp2_ = (*self).lvl;
	(*dest).lvl = _tmp2_;
	_tmp3_ = (*self).pos;
	(*dest).pos = _tmp3_;
}


void netsukuku_struct_helper_map_check_node_destroy (Netsukukustruct_helper_Map_check_node* self) {
	_g_object_unref0 ((*self).self);
}


Netsukukustruct_helper_Map_check_node* netsukuku_struct_helper_map_check_node_dup (const Netsukukustruct_helper_Map_check_node* self) {
	Netsukukustruct_helper_Map_check_node* dup;
	dup = g_new0 (Netsukukustruct_helper_Map_check_node, 1);
	netsukuku_struct_helper_map_check_node_copy (self, dup);
	return dup;
}


void netsukuku_struct_helper_map_check_node_free (Netsukukustruct_helper_Map_check_node* self) {
	netsukuku_struct_helper_map_check_node_destroy (self);
	g_free (self);
}


GType netsukuku_struct_helper_map_check_node_get_type (void) {
	static volatile gsize netsukuku_struct_helper_map_check_node_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_struct_helper_map_check_node_type_id__volatile)) {
		GType netsukuku_struct_helper_map_check_node_type_id;
		netsukuku_struct_helper_map_check_node_type_id = g_boxed_type_register_static ("Netsukukustruct_helper_Map_check_node", (GBoxedCopyFunc) netsukuku_struct_helper_map_check_node_dup, (GBoxedFreeFunc) netsukuku_struct_helper_map_check_node_free);
		g_once_init_leave (&netsukuku_struct_helper_map_check_node_type_id__volatile, netsukuku_struct_helper_map_check_node_type_id);
	}
	return netsukuku_struct_helper_map_check_node_type_id__volatile;
}


NetsukukuMap* netsukuku_map_construct (GType object_type, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, gint levels, gint gsize, NetsukukuNIP* me) {
	NetsukukuMap * self = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	NetsukukuNIP* _tmp8_;
	NetsukukuNIP* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	NetsukukuDataClass** _tmp12_ = NULL;
	gint _tmp13_;
	gint _tmp14_;
	gboolean* _tmp15_ = NULL;
	g_return_val_if_fail (me != NULL, NULL);
	self = (NetsukukuMap*) g_object_new (object_type, NULL);
	self->priv->t_type = t_type;
	self->priv->t_dup_func = t_dup_func;
	self->priv->t_destroy_func = t_destroy_func;
	_tmp0_ = levels;
	self->priv->_levels = _tmp0_;
	_tmp1_ = gsize;
	self->priv->_gsize = _tmp1_;
	_tmp2_ = g_type_is_a (t_type, NETSUKUKU_TYPE_DATACLASS);
	_vala_assert (_tmp2_, "typeof(T).is_a(typeof(DataClass))");
	{
		NetsukukuNIP* _tmp3_;
		gint _tmp4_ = 0;
		gint* _tmp5_ = NULL;
		gint* y;
		gint y_length1;
		gint _y_size_;
		gint* _tmp6_;
		gint _tmp6__length1;
		gint _tmp7_;
		_tmp3_ = me;
		_tmp5_ = netsukuku_partial_nip_get_positions ((NetsukukuPartialNIP*) _tmp3_, &_tmp4_);
		y = _tmp5_;
		y_length1 = _tmp4_;
		_y_size_ = y_length1;
		_tmp6_ = y;
		_tmp6__length1 = y_length1;
		_tmp7_ = levels;
		_vala_assert (_tmp6__length1 == _tmp7_, "y.length == levels");
		y = (g_free (y), NULL);
	}
	_tmp8_ = me;
	_tmp9_ = _g_object_ref0 (_tmp8_);
	_g_object_unref0 (self->priv->_me);
	self->priv->_me = _tmp9_;
	_tmp10_ = self->priv->_levels;
	_tmp11_ = self->priv->_gsize;
	_tmp12_ = g_new0 (NetsukukuDataClass*, (_tmp10_ * _tmp11_) + 1);
	self->node = (_vala_array_free (self->node, self->node_length1 * self->node_length2, (GDestroyNotify) g_object_unref), NULL);
	self->node = _tmp12_;
	self->node_length1 = _tmp10_;
	self->node_length2 = _tmp11_;
	_tmp13_ = self->priv->_levels;
	_tmp14_ = self->priv->_gsize;
	_tmp15_ = g_new0 (gboolean, _tmp13_ * _tmp14_);
	self->priv->node_prev_free = (g_free (self->priv->node_prev_free), NULL);
	self->priv->node_prev_free = _tmp15_;
	self->priv->node_prev_free_length1 = _tmp13_;
	self->priv->node_prev_free_length2 = _tmp14_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp16_;
			_tmp16_ = TRUE;
			while (TRUE) {
				gboolean _tmp17_;
				gint _tmp19_;
				gint _tmp20_;
				_tmp17_ = _tmp16_;
				if (!_tmp17_) {
					gint _tmp18_;
					_tmp18_ = i;
					i = _tmp18_ + 1;
				}
				_tmp16_ = FALSE;
				_tmp19_ = i;
				_tmp20_ = self->priv->_levels;
				if (!(_tmp19_ < _tmp20_)) {
					break;
				}
				{
					gint j;
					j = 0;
					{
						gboolean _tmp21_;
						_tmp21_ = TRUE;
						while (TRUE) {
							gboolean _tmp22_;
							gint _tmp24_;
							gint _tmp25_;
							NetsukukuDataClass** _tmp26_;
							gint _tmp26__length1;
							gint _tmp26__length2;
							gint _tmp27_;
							gint _tmp28_;
							NetsukukuDataClass* _tmp29_;
							gboolean* _tmp30_;
							gint _tmp30__length1;
							gint _tmp30__length2;
							gint _tmp31_;
							gint _tmp32_;
							gboolean _tmp33_;
							_tmp22_ = _tmp21_;
							if (!_tmp22_) {
								gint _tmp23_;
								_tmp23_ = j;
								j = _tmp23_ + 1;
							}
							_tmp21_ = FALSE;
							_tmp24_ = j;
							_tmp25_ = self->priv->_gsize;
							if (!(_tmp24_ < _tmp25_)) {
								break;
							}
							_tmp26_ = self->node;
							_tmp26__length1 = self->node_length1;
							_tmp26__length2 = self->node_length2;
							_tmp27_ = i;
							_tmp28_ = j;
							_g_object_unref0 (_tmp26_[(_tmp27_ * _tmp26__length2) + _tmp28_]);
							_tmp26_[(_tmp27_ * _tmp26__length2) + _tmp28_] = NULL;
							_tmp29_ = _tmp26_[(_tmp27_ * _tmp26__length2) + _tmp28_];
							_tmp30_ = self->priv->node_prev_free;
							_tmp30__length1 = self->priv->node_prev_free_length1;
							_tmp30__length2 = self->priv->node_prev_free_length2;
							_tmp31_ = i;
							_tmp32_ = j;
							_tmp30_[(_tmp31_ * _tmp30__length2) + _tmp32_] = TRUE;
							_tmp33_ = _tmp30_[(_tmp31_ * _tmp30__length2) + _tmp32_];
						}
					}
				}
			}
		}
	}
	_g_object_unref0 (self->priv->check_all_nodes_handle);
	self->priv->check_all_nodes_handle = NULL;
	netsukuku_map_periodically_check_all_nodes (self);
	return self;
}


NetsukukuMap* netsukuku_map_new (GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, gint levels, gint gsize, NetsukukuNIP* me) {
	return netsukuku_map_construct (NETSUKUKU_TYPE_MAP, t_type, t_dup_func, t_destroy_func, levels, gsize, me);
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static void netsukuku_map_impl_periodically_check_all_nodes (NetsukukuMap* self, GError** error) {
	gboolean _tmp0_;
	TaskletsTasklet* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	tasklets_tasklet_declare_self ("Map.periodically_check_all_nodes");
	_tmp0_ = self->priv->stopped_operations;
	if (_tmp0_) {
		return;
	}
	_tmp1_ = tasklets_tasklet_self ();
	_g_object_unref0 (self->priv->check_all_nodes_handle);
	self->priv->check_all_nodes_handle = _tmp1_;
	while (TRUE) {
		{
			tasklets_tasklet_nap ((glong) 5, (glong) 0);
			{
				gint lvl;
				lvl = 0;
				{
					gboolean _tmp2_;
					_tmp2_ = TRUE;
					while (TRUE) {
						gboolean _tmp3_;
						gint _tmp5_;
						gint _tmp6_;
						_tmp3_ = _tmp2_;
						if (!_tmp3_) {
							gint _tmp4_;
							_tmp4_ = lvl;
							lvl = _tmp4_ + 1;
						}
						_tmp2_ = FALSE;
						_tmp5_ = lvl;
						_tmp6_ = self->priv->_levels;
						if (!(_tmp5_ < _tmp6_)) {
							break;
						}
						{
							gint pos;
							pos = 0;
							{
								gboolean _tmp7_;
								_tmp7_ = TRUE;
								while (TRUE) {
									gboolean _tmp8_;
									gint _tmp10_;
									gint _tmp11_;
									gint _tmp12_;
									gint _tmp13_;
									_tmp8_ = _tmp7_;
									if (!_tmp8_) {
										gint _tmp9_;
										_tmp9_ = pos;
										pos = _tmp9_ + 1;
									}
									_tmp7_ = FALSE;
									_tmp10_ = pos;
									_tmp11_ = self->priv->_gsize;
									if (!(_tmp10_ < _tmp11_)) {
										break;
									}
									_tmp12_ = lvl;
									_tmp13_ = pos;
									netsukuku_map_check_node (self, _tmp12_, _tmp13_);
								}
							}
						}
					}
				}
			}
		}
		goto __finally53;
		__catch53_g_error:
		{
			GType _tmp14_ = 0UL;
			const gchar* _tmp15_ = NULL;
			const gchar* _tmp16_ = NULL;
			gchar* _tmp17_ = NULL;
			gchar* _tmp18_;
			g_clear_error (&_inner_error_);
			_inner_error_ = NULL;
			_tmp14_ = G_TYPE_FROM_INSTANCE ((GObject*) self);
			_tmp15_ = g_type_name (_tmp14_);
			_tmp16_ = string_to_string (_tmp15_);
			_tmp17_ = g_strconcat ("Map(", _tmp16_, "): Uncaught exception while periodically_check_all_nodes", NULL);
			_tmp18_ = _tmp17_;
			netsukuku_log_error (_tmp18_);
			_g_free0 (_tmp18_);
		}
		__finally53:
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return;
		}
	}
}


static void* netsukuku_map_helper_periodically_check_all_nodes (void* v, GError** error) {
	void* result = NULL;
	void* _tmp0_;
	Netsukukustruct_helper_Map_periodically_check_all_nodes* tuple_p;
	NetsukukuMap* _tmp1_;
	NetsukukuMap* _tmp2_;
	NetsukukuMap* self_save;
	GError * _inner_error_ = NULL;
	_tmp0_ = v;
	tuple_p = (Netsukukustruct_helper_Map_periodically_check_all_nodes*) _tmp0_;
	_tmp1_ = (*tuple_p).self;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	self_save = _tmp2_;
	tasklets_tasklet_schedule_back ();
	netsukuku_map_impl_periodically_check_all_nodes (self_save, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self_save);
		return NULL;
	}
	result = NULL;
	_g_object_unref0 (self_save);
	return result;
}


void netsukuku_map_periodically_check_all_nodes (NetsukukuMap* self) {
	Netsukukustruct_helper_Map_periodically_check_all_nodes arg = {0};
	NetsukukuMap* _tmp0_;
	TaskletsTasklet* _tmp1_ = NULL;
	TaskletsTasklet* _tmp2_;
	g_return_if_fail (self != NULL);
	memset (&arg, 0, sizeof (Netsukukustruct_helper_Map_periodically_check_all_nodes));
	_tmp0_ = _g_object_ref0 (self);
	_g_object_unref0 (arg.self);
	arg.self = _tmp0_;
	_tmp1_ = tasklets_tasklet_spawn ((TaskletsSpawnable) netsukuku_map_helper_periodically_check_all_nodes, &arg, FALSE, -1);
	_tmp2_ = _tmp1_;
	_g_object_unref0 (_tmp2_);
	netsukuku_struct_helper_map_periodically_check_all_nodes_destroy (&arg);
}


static void netsukuku_map_real_stop_operations (NetsukukuMap* self) {
	TaskletsTasklet* _tmp0_;
	_tmp0_ = self->priv->check_all_nodes_handle;
	if (_tmp0_ != NULL) {
		TaskletsTasklet* _tmp1_;
		_tmp1_ = self->priv->check_all_nodes_handle;
		tasklets_tasklet_abort (_tmp1_);
		_g_object_unref0 (self->priv->check_all_nodes_handle);
		self->priv->check_all_nodes_handle = NULL;
	}
	self->priv->stopped_operations = TRUE;
}


void netsukuku_map_stop_operations (NetsukukuMap* self) {
	g_return_if_fail (self != NULL);
	NETSUKUKU_MAP_GET_CLASS (self)->stop_operations (self);
}


static void netsukuku_map_impl_check_node (NetsukukuMap* self, gint lvl, gint pos, GError** error) {
	gboolean _tmp0_;
	gboolean* _tmp1_;
	gint _tmp1__length1;
	gint _tmp1__length2;
	gint _tmp2_;
	gint _tmp3_;
	gboolean _tmp4_;
	gboolean prev;
	gint _tmp5_;
	gint _tmp6_;
	gpointer _tmp7_ = NULL;
	NetsukukuDataClass* _tmp8_;
	NetsukukuDataClass* _tmp9_;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_;
	gboolean curr;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_;
	gboolean _tmp15_;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_;
	gboolean _tmp21_;
	gboolean* _tmp24_;
	gint _tmp24__length1;
	gint _tmp24__length2;
	gint _tmp25_;
	gint _tmp26_;
	gboolean _tmp27_;
	gboolean _tmp28_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->stopped_operations;
	if (_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->node_prev_free;
	_tmp1__length1 = self->priv->node_prev_free_length1;
	_tmp1__length2 = self->priv->node_prev_free_length2;
	_tmp2_ = lvl;
	_tmp3_ = pos;
	_tmp4_ = _tmp1_[(_tmp2_ * _tmp1__length2) + _tmp3_];
	prev = _tmp4_;
	_tmp5_ = lvl;
	_tmp6_ = pos;
	_tmp7_ = netsukuku_map_node_get (self, _tmp5_, _tmp6_);
	_tmp8_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, NETSUKUKU_TYPE_DATACLASS) ? ((NetsukukuDataClass*) _tmp7_) : NULL;
	if (_tmp8_ == NULL) {
		((_tmp7_ == NULL) || (self->priv->t_destroy_func == NULL)) ? NULL : (_tmp7_ = (self->priv->t_destroy_func (_tmp7_), NULL));
	}
	_tmp9_ = _tmp8_;
	_tmp10_ = netsukuku_dataclass_is_free (_tmp9_);
	_tmp11_ = _tmp10_;
	_g_object_unref0 (_tmp9_);
	curr = _tmp11_;
	_tmp13_ = prev;
	if (_tmp13_) {
		gboolean _tmp14_;
		_tmp14_ = curr;
		_tmp12_ = !_tmp14_;
	} else {
		_tmp12_ = FALSE;
	}
	_tmp15_ = _tmp12_;
	if (_tmp15_) {
		gint _tmp16_;
		gint _tmp17_;
		_tmp16_ = lvl;
		_tmp17_ = pos;
		netsukuku_map_node_add (self, _tmp16_, _tmp17_);
	}
	_tmp19_ = curr;
	if (_tmp19_) {
		gboolean _tmp20_;
		_tmp20_ = prev;
		_tmp18_ = !_tmp20_;
	} else {
		_tmp18_ = FALSE;
	}
	_tmp21_ = _tmp18_;
	if (_tmp21_) {
		gint _tmp22_;
		gint _tmp23_;
		_tmp22_ = lvl;
		_tmp23_ = pos;
		netsukuku_map_node_del (self, _tmp22_, _tmp23_);
	}
	_tmp24_ = self->priv->node_prev_free;
	_tmp24__length1 = self->priv->node_prev_free_length1;
	_tmp24__length2 = self->priv->node_prev_free_length2;
	_tmp25_ = lvl;
	_tmp26_ = pos;
	_tmp27_ = curr;
	_tmp24_[(_tmp25_ * _tmp24__length2) + _tmp26_] = _tmp27_;
	_tmp28_ = _tmp24_[(_tmp25_ * _tmp24__length2) + _tmp26_];
}


static void* netsukuku_map_helper_check_node (void* v, GError** error) {
	void* result = NULL;
	void* _tmp0_;
	Taskletsstruct_channel* ch_cont_p;
	Taskletsstruct_channel* _tmp1_;
	TaskletsChannel* _tmp2_;
	TaskletsChannel* _tmp3_;
	TaskletsChannel* ch;
	GError * _inner_error_ = NULL;
	tasklets_tasklet_declare_self ("Map.check_node dispatcher");
	_tmp0_ = v;
	ch_cont_p = (Taskletsstruct_channel*) _tmp0_;
	_tmp1_ = ch_cont_p;
	_tmp2_ = (*_tmp1_).self;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	ch = _tmp3_;
	tasklets_tasklet_schedule_back ();
	while (TRUE) {
		gchar* doing;
		const gchar* _tmp29_;
		doing = NULL;
		{
			Netsukukustruct_helper_Map_check_node tuple_p = {0};
			Netsukukustruct_helper_Map_check_node _tmp8_;
			gint _tmp9_;
			gchar* _tmp10_ = NULL;
			gchar* _tmp11_;
			Netsukukustruct_helper_Map_check_node _tmp12_;
			gint _tmp13_;
			gchar* _tmp14_ = NULL;
			gchar* _tmp15_;
			gchar* _tmp16_ = NULL;
			const gchar* _tmp17_;
			Netsukukustruct_helper_Map_check_node _tmp18_;
			NetsukukuMap* _tmp19_;
			Netsukukustruct_helper_Map_check_node _tmp20_;
			gint _tmp21_;
			Netsukukustruct_helper_Map_check_node _tmp22_;
			gint _tmp23_;
			{
				TaskletsChannel* _tmp4_;
				GValue _tmp5_ = {0};
				GValue vv;
				void* _tmp6_ = NULL;
				Netsukukustruct_helper_Map_check_node _tmp7_ = {0};
				_tmp4_ = ch;
				tasklets_channel_recv (_tmp4_, &_tmp5_);
				vv = _tmp5_;
				_tmp6_ = g_value_get_boxed (&vv);
				netsukuku_struct_helper_map_check_node_copy ((Netsukukustruct_helper_Map_check_node*) _tmp6_, &_tmp7_);
				netsukuku_struct_helper_map_check_node_destroy (&tuple_p);
				tuple_p = _tmp7_;
				G_IS_VALUE (&vv) ? (g_value_unset (&vv), NULL) : NULL;
			}
			_tmp8_ = tuple_p;
			_tmp9_ = _tmp8_.lvl;
			_tmp10_ = g_strdup_printf ("%i", _tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = tuple_p;
			_tmp13_ = _tmp12_.pos;
			_tmp14_ = g_strdup_printf ("%i", _tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = g_strconcat ("check_node(", _tmp11_, ", ", _tmp15_, ")", NULL);
			_g_free0 (doing);
			doing = _tmp16_;
			_g_free0 (_tmp15_);
			_g_free0 (_tmp11_);
			_tmp17_ = doing;
			tasklets_tasklet_declare_self (_tmp17_);
			_tmp18_ = tuple_p;
			_tmp19_ = _tmp18_.self;
			_tmp20_ = tuple_p;
			_tmp21_ = _tmp20_.lvl;
			_tmp22_ = tuple_p;
			_tmp23_ = _tmp22_.pos;
			netsukuku_map_impl_check_node (_tmp19_, _tmp21_, _tmp23_, &_inner_error_);
			if (_inner_error_ != NULL) {
				netsukuku_struct_helper_map_check_node_destroy (&tuple_p);
				goto __catch54_g_error;
			}
			netsukuku_struct_helper_map_check_node_destroy (&tuple_p);
		}
		goto __finally54;
		__catch54_g_error:
		{
			GError* e = NULL;
			GError* _tmp24_;
			const gchar* _tmp25_;
			const gchar* _tmp26_ = NULL;
			gchar* _tmp27_ = NULL;
			gchar* _tmp28_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp24_ = e;
			_tmp25_ = _tmp24_->message;
			_tmp26_ = string_to_string (_tmp25_);
			_tmp27_ = g_strconcat ("Map: check_node reported an error: ", _tmp26_, NULL);
			_tmp28_ = _tmp27_;
			netsukuku_log_warn (_tmp28_);
			_g_free0 (_tmp28_);
			_g_error_free0 (e);
		}
		__finally54:
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (doing);
			_g_object_unref0 (ch);
			return NULL;
		}
		_tmp29_ = doing;
		if (_tmp29_ != NULL) {
			const gchar* _tmp30_;
			_tmp30_ = doing;
			tasklets_tasklet_declare_finished (_tmp30_);
		}
		_g_free0 (doing);
	}
	_g_object_unref0 (ch);
	return result;
}


void netsukuku_map_check_node (NetsukukuMap* self, gint lvl, gint pos) {
	TaskletsChannel* _tmp0_ = NULL;
	TaskletsChannel* ch;
	Netsukukustruct_helper_Map_check_node arg = {0};
	NetsukukuMap* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	Netsukukustruct_helper_Map_check_node _tmp4_;
	GValue _tmp5_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = tasklets_tasklet_dispatcher_get_channel_for_helper ((TaskletsSpawnable) netsukuku_map_helper_check_node, -1);
	ch = _tmp0_;
	memset (&arg, 0, sizeof (Netsukukustruct_helper_Map_check_node));
	_tmp1_ = _g_object_ref0 (self);
	_g_object_unref0 (arg.self);
	arg.self = _tmp1_;
	_tmp2_ = lvl;
	arg.lvl = _tmp2_;
	_tmp3_ = pos;
	arg.pos = _tmp3_;
	_tmp4_ = arg;
	g_value_init (&_tmp5_, NETSUKUKU_TYPE_STRUCT_HELPER_MAP_CHECK_NODE);
	g_value_set_boxed (&_tmp5_, &_tmp4_);
	tasklets_channel_send_async (ch, &_tmp5_);
	G_IS_VALUE (&_tmp5_) ? (g_value_unset (&_tmp5_), NULL) : NULL;
	netsukuku_struct_helper_map_check_node_destroy (&arg);
	_g_object_unref0 (ch);
}


/** Returns from the map a node of level `lvl' and id `pos'.
          *
          * An instance of type T will always be returned: if
          * it doesn't exist, it is created.
          */
static gpointer netsukuku_map_real_node_get (NetsukukuMap* self, gint lvl, gint pos) {
	gpointer result = NULL;
	NetsukukuDataClass** _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	gint _tmp1_;
	gint _tmp2_;
	NetsukukuDataClass* _tmp3_;
	NetsukukuDataClass** _tmp32_;
	gint _tmp32__length1;
	gint _tmp32__length2;
	gint _tmp33_;
	gint _tmp34_;
	NetsukukuDataClass* _tmp35_;
	gpointer _tmp36_;
	_tmp0_ = self->node;
	_tmp0__length1 = self->node_length1;
	_tmp0__length2 = self->node_length2;
	_tmp1_ = lvl;
	_tmp2_ = pos;
	_tmp3_ = _tmp0_[(_tmp1_ * _tmp0__length2) + _tmp2_];
	if (_tmp3_ == NULL) {
		NetsukukuNIP* _tmp4_;
		gint _tmp5_;
		gint _tmp6_ = 0;
		gint _tmp7_;
		_tmp4_ = self->priv->_me;
		_tmp5_ = lvl;
		_tmp6_ = netsukuku_partial_nip_position_at ((NetsukukuPartialNIP*) _tmp4_, _tmp5_);
		_tmp7_ = pos;
		if (_tmp6_ == _tmp7_) {
			GObject* _tmp8_ = NULL;
			GObject* _tmp9_;
			NetsukukuDataClass* _tmp10_;
			NetsukukuDataClass* ret;
			NetsukukuDataClass* _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			NetsukukuDataClass** _tmp14_;
			gint _tmp14__length1;
			gint _tmp14__length2;
			gint _tmp15_;
			gint _tmp16_;
			NetsukukuDataClass* _tmp17_;
			NetsukukuDataClass* _tmp18_;
			NetsukukuDataClass* _tmp19_;
			_tmp8_ = g_object_new (self->priv->t_type, NULL);
			_tmp9_ = G_IS_INITIALLY_UNOWNED (_tmp8_) ? g_object_ref_sink (_tmp8_) : _tmp8_;
			_tmp10_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, NETSUKUKU_TYPE_DATACLASS) ? ((NetsukukuDataClass*) _tmp9_) : NULL;
			if (_tmp10_ == NULL) {
				_g_object_unref0 (_tmp9_);
			}
			ret = _tmp10_;
			_tmp11_ = ret;
			_tmp12_ = lvl;
			_tmp13_ = pos;
			netsukuku_dataclass_initialize (_tmp11_, (GObject*) self, _tmp12_, _tmp13_, TRUE);
			_tmp14_ = self->node;
			_tmp14__length1 = self->node_length1;
			_tmp14__length2 = self->node_length2;
			_tmp15_ = lvl;
			_tmp16_ = pos;
			_tmp17_ = ret;
			_tmp18_ = _g_object_ref0 (_tmp17_);
			_g_object_unref0 (_tmp14_[(_tmp15_ * _tmp14__length2) + _tmp16_]);
			_tmp14_[(_tmp15_ * _tmp14__length2) + _tmp16_] = _tmp18_;
			_tmp19_ = _tmp14_[(_tmp15_ * _tmp14__length2) + _tmp16_];
			_g_object_unref0 (ret);
		} else {
			GObject* _tmp20_ = NULL;
			GObject* _tmp21_;
			NetsukukuDataClass* _tmp22_;
			NetsukukuDataClass* ret;
			NetsukukuDataClass* _tmp23_;
			gint _tmp24_;
			gint _tmp25_;
			NetsukukuDataClass** _tmp26_;
			gint _tmp26__length1;
			gint _tmp26__length2;
			gint _tmp27_;
			gint _tmp28_;
			NetsukukuDataClass* _tmp29_;
			NetsukukuDataClass* _tmp30_;
			NetsukukuDataClass* _tmp31_;
			_tmp20_ = g_object_new (self->priv->t_type, NULL);
			_tmp21_ = G_IS_INITIALLY_UNOWNED (_tmp20_) ? g_object_ref_sink (_tmp20_) : _tmp20_;
			_tmp22_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp21_, NETSUKUKU_TYPE_DATACLASS) ? ((NetsukukuDataClass*) _tmp21_) : NULL;
			if (_tmp22_ == NULL) {
				_g_object_unref0 (_tmp21_);
			}
			ret = _tmp22_;
			_tmp23_ = ret;
			_tmp24_ = lvl;
			_tmp25_ = pos;
			netsukuku_dataclass_initialize (_tmp23_, (GObject*) self, _tmp24_, _tmp25_, FALSE);
			_tmp26_ = self->node;
			_tmp26__length1 = self->node_length1;
			_tmp26__length2 = self->node_length2;
			_tmp27_ = lvl;
			_tmp28_ = pos;
			_tmp29_ = ret;
			_tmp30_ = _g_object_ref0 (_tmp29_);
			_g_object_unref0 (_tmp26_[(_tmp27_ * _tmp26__length2) + _tmp28_]);
			_tmp26_[(_tmp27_ * _tmp26__length2) + _tmp28_] = _tmp30_;
			_tmp31_ = _tmp26_[(_tmp27_ * _tmp26__length2) + _tmp28_];
			_g_object_unref0 (ret);
		}
	}
	_tmp32_ = self->node;
	_tmp32__length1 = self->node_length1;
	_tmp32__length2 = self->node_length2;
	_tmp33_ = lvl;
	_tmp34_ = pos;
	_tmp35_ = _tmp32_[(_tmp33_ * _tmp32__length2) + _tmp34_];
	_tmp36_ = ((((gconstpointer) _tmp35_) != NULL) && (self->priv->t_dup_func != NULL)) ? self->priv->t_dup_func ((gpointer) ((gconstpointer) _tmp35_)) : ((gpointer) ((gconstpointer) _tmp35_));
	result = _tmp36_;
	return result;
}


gpointer netsukuku_map_node_get (NetsukukuMap* self, gint lvl, gint pos) {
	g_return_val_if_fail (self != NULL, NULL);
	return NETSUKUKU_MAP_GET_CLASS (self)->node_get (self, lvl, pos);
}


gpointer netsukuku_map_node_get_hcoord (NetsukukuMap* self, NetsukukuHCoord* hc) {
	gpointer result = NULL;
	NetsukukuHCoord* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	NetsukukuHCoord* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gpointer _tmp6_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (hc != NULL, NULL);
	_tmp0_ = hc;
	_tmp1_ = netsukuku_hcoord_get_lvl (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = hc;
	_tmp4_ = netsukuku_hcoord_get_pos (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = netsukuku_map_node_get (self, _tmp2_, _tmp5_);
	result = _tmp6_;
	return result;
}


/** Removes from the map a node of level `lvl' and id `pos'.
          */
void netsukuku_map_node_remove (NetsukukuMap* self, gint lvl, gint pos) {
	NetsukukuDataClass** _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	gint _tmp1_;
	gint _tmp2_;
	NetsukukuDataClass* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->node;
	_tmp0__length1 = self->node_length1;
	_tmp0__length2 = self->node_length2;
	_tmp1_ = lvl;
	_tmp2_ = pos;
	_g_object_unref0 (_tmp0_[(_tmp1_ * _tmp0__length2) + _tmp2_]);
	_tmp0_[(_tmp1_ * _tmp0__length2) + _tmp2_] = NULL;
	_tmp3_ = _tmp0_[(_tmp1_ * _tmp0__length2) + _tmp2_];
}


/** A node was previously free, and now it is busy. Emit a signal.
          */
void netsukuku_map_node_add (NetsukukuMap* self, gint lvl, gint pos) {
	gint _tmp0_;
	gint _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = lvl;
	_tmp1_ = pos;
	g_signal_emit_by_name (self, "node-new", _tmp0_, _tmp1_);
}


/** A node was previously busy, and now it is free. Emit a signal.
          */
void netsukuku_map_node_del (NetsukukuMap* self, gint lvl, gint pos) {
	gint _tmp0_;
	gint _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = lvl;
	_tmp1_ = pos;
	g_signal_emit_by_name (self, "node-deleted", _tmp0_, _tmp1_);
}


/** Returns the number of free nodes of level `lvl'
          */
gint netsukuku_map_free_nodes_nb (NetsukukuMap* self, gint lvl) {
	gint result = 0;
	gint _tmp0_;
	gint _tmp1_ = 0;
	gint* _tmp2_ = NULL;
	gint* x;
	gint x_length1;
	gint _x_size_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = lvl;
	_tmp2_ = netsukuku_map_free_nodes_list (self, _tmp0_, &_tmp1_);
	x = _tmp2_;
	x_length1 = _tmp1_;
	_x_size_ = x_length1;
	result = x_length1;
	x = (g_free (x), NULL);
	return result;
}


/** Returns the list of free nodes of level `lvl'
          */
gint* netsukuku_map_free_nodes_list (NetsukukuMap* self, gint lvl, int* result_length1) {
	gint* result = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* ret;
	GeeArrayList* _tmp24_;
	gint _tmp25_ = 0;
	gpointer* _tmp26_ = NULL;
	gint* _tmp27_;
	gint _tmp27__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_INT, NULL, NULL, NULL, NULL, NULL);
	ret = _tmp0_;
	{
		gint _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		NetsukukuNIP* _tmp4_;
		GeeArrayList* _tmp5_ = NULL;
		GeeArrayList* _pos_list;
		GeeArrayList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _pos_size;
		gint _pos_index;
		_tmp1_ = self->priv->_levels;
		_tmp2_ = self->priv->_gsize;
		_tmp3_ = lvl;
		_tmp4_ = self->priv->_me;
		_tmp5_ = netsukuku_valid_ids (_tmp1_, _tmp2_, _tmp3_, (NetsukukuPartialNIP*) _tmp4_);
		_pos_list = _tmp5_;
		_tmp6_ = _pos_list;
		_tmp7_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_pos_size = _tmp8_;
		_pos_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			GeeArrayList* _tmp12_;
			gint _tmp13_;
			gpointer _tmp14_ = NULL;
			gint pos;
			gint _tmp15_;
			gint _tmp16_;
			gpointer _tmp17_ = NULL;
			NetsukukuDataClass* _tmp18_;
			NetsukukuDataClass* _tmp19_;
			gboolean _tmp20_ = FALSE;
			gboolean _tmp21_;
			_tmp9_ = _pos_index;
			_pos_index = _tmp9_ + 1;
			_tmp10_ = _pos_index;
			_tmp11_ = _pos_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _pos_list;
			_tmp13_ = _pos_index;
			_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, _tmp13_);
			pos = (gint) ((gintptr) _tmp14_);
			_tmp15_ = lvl;
			_tmp16_ = pos;
			_tmp17_ = netsukuku_map_node_get (self, _tmp15_, _tmp16_);
			_tmp18_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp17_, NETSUKUKU_TYPE_DATACLASS) ? ((NetsukukuDataClass*) _tmp17_) : NULL;
			if (_tmp18_ == NULL) {
				((_tmp17_ == NULL) || (self->priv->t_destroy_func == NULL)) ? NULL : (_tmp17_ = (self->priv->t_destroy_func (_tmp17_), NULL));
			}
			_tmp19_ = _tmp18_;
			_tmp20_ = netsukuku_dataclass_is_free (_tmp19_);
			_tmp21_ = _tmp20_;
			_g_object_unref0 (_tmp19_);
			if (_tmp21_) {
				GeeArrayList* _tmp22_;
				gint _tmp23_;
				_tmp22_ = ret;
				_tmp23_ = pos;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp22_, (gpointer) ((gintptr) _tmp23_));
			}
		}
		_g_object_unref0 (_pos_list);
	}
	_tmp24_ = ret;
	_tmp26_ = gee_collection_to_array ((GeeCollection*) _tmp24_, &_tmp25_);
	_tmp27_ = (gint*) _tmp26_;
	_tmp27__length1 = (_tmp25_ * sizeof (gint)) / sizeof (gint);
	if (result_length1) {
		*result_length1 = _tmp27__length1;
	}
	result = _tmp27_;
	_g_object_unref0 (ret);
	return result;
}


/** Returns the number of busy nodes of level `lvl'
          */
gint netsukuku_map_busy_nodes_nb (NetsukukuMap* self, gint lvl) {
	gint result = 0;
	gint _tmp0_;
	gint _tmp1_ = 0;
	gint* _tmp2_ = NULL;
	gint* x;
	gint x_length1;
	gint _x_size_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = lvl;
	_tmp2_ = netsukuku_map_busy_nodes_list (self, _tmp0_, &_tmp1_);
	x = _tmp2_;
	x_length1 = _tmp1_;
	_x_size_ = x_length1;
	result = x_length1;
	x = (g_free (x), NULL);
	return result;
}


/** Returns the list of busy nodes of level `lvl'
          */
gint* netsukuku_map_busy_nodes_list (NetsukukuMap* self, gint lvl, int* result_length1) {
	gint* result = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* ret;
	GeeArrayList* _tmp24_;
	gint _tmp25_;
	gint _tmp26_;
	gint* _tmp27_ = NULL;
	gint* retval;
	gint retval_length1;
	gint _retval_size_;
	gint* _tmp41_;
	gint _tmp41__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_INT, NULL, NULL, NULL, NULL, NULL);
	ret = _tmp0_;
	{
		gint _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		NetsukukuNIP* _tmp4_;
		GeeArrayList* _tmp5_ = NULL;
		GeeArrayList* _pos_list;
		GeeArrayList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _pos_size;
		gint _pos_index;
		_tmp1_ = self->priv->_levels;
		_tmp2_ = self->priv->_gsize;
		_tmp3_ = lvl;
		_tmp4_ = self->priv->_me;
		_tmp5_ = netsukuku_valid_ids (_tmp1_, _tmp2_, _tmp3_, (NetsukukuPartialNIP*) _tmp4_);
		_pos_list = _tmp5_;
		_tmp6_ = _pos_list;
		_tmp7_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_pos_size = _tmp8_;
		_pos_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			GeeArrayList* _tmp12_;
			gint _tmp13_;
			gpointer _tmp14_ = NULL;
			gint pos;
			gint _tmp15_;
			gint _tmp16_;
			gpointer _tmp17_ = NULL;
			NetsukukuDataClass* _tmp18_;
			NetsukukuDataClass* _tmp19_;
			gboolean _tmp20_ = FALSE;
			gboolean _tmp21_;
			_tmp9_ = _pos_index;
			_pos_index = _tmp9_ + 1;
			_tmp10_ = _pos_index;
			_tmp11_ = _pos_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _pos_list;
			_tmp13_ = _pos_index;
			_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, _tmp13_);
			pos = (gint) ((gintptr) _tmp14_);
			_tmp15_ = lvl;
			_tmp16_ = pos;
			_tmp17_ = netsukuku_map_node_get (self, _tmp15_, _tmp16_);
			_tmp18_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp17_, NETSUKUKU_TYPE_DATACLASS) ? ((NetsukukuDataClass*) _tmp17_) : NULL;
			if (_tmp18_ == NULL) {
				((_tmp17_ == NULL) || (self->priv->t_destroy_func == NULL)) ? NULL : (_tmp17_ = (self->priv->t_destroy_func (_tmp17_), NULL));
			}
			_tmp19_ = _tmp18_;
			_tmp20_ = netsukuku_dataclass_is_free (_tmp19_);
			_tmp21_ = !_tmp20_;
			_g_object_unref0 (_tmp19_);
			if (_tmp21_) {
				GeeArrayList* _tmp22_;
				gint _tmp23_;
				_tmp22_ = ret;
				_tmp23_ = pos;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp22_, (gpointer) ((gintptr) _tmp23_));
			}
		}
		_g_object_unref0 (_pos_list);
	}
	_tmp24_ = ret;
	_tmp25_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = g_new0 (gint, _tmp26_);
	retval = _tmp27_;
	retval_length1 = _tmp26_;
	_retval_size_ = retval_length1;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp28_;
			_tmp28_ = TRUE;
			while (TRUE) {
				gboolean _tmp29_;
				gint _tmp31_;
				GeeArrayList* _tmp32_;
				gint _tmp33_;
				gint _tmp34_;
				gint* _tmp35_;
				gint _tmp35__length1;
				gint _tmp36_;
				GeeArrayList* _tmp37_;
				gint _tmp38_;
				gpointer _tmp39_ = NULL;
				gint _tmp40_;
				_tmp29_ = _tmp28_;
				if (!_tmp29_) {
					gint _tmp30_;
					_tmp30_ = i;
					i = _tmp30_ + 1;
				}
				_tmp28_ = FALSE;
				_tmp31_ = i;
				_tmp32_ = ret;
				_tmp33_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp32_);
				_tmp34_ = _tmp33_;
				if (!(_tmp31_ < _tmp34_)) {
					break;
				}
				_tmp35_ = retval;
				_tmp35__length1 = retval_length1;
				_tmp36_ = i;
				_tmp37_ = ret;
				_tmp38_ = i;
				_tmp39_ = gee_abstract_list_get ((GeeAbstractList*) _tmp37_, _tmp38_);
				_tmp35_[_tmp36_] = (gint) ((gintptr) _tmp39_);
				_tmp40_ = _tmp35_[_tmp36_];
			}
		}
	}
	_tmp41_ = retval;
	_tmp41__length1 = retval_length1;
	if (result_length1) {
		*result_length1 = _tmp41__length1;
	}
	result = _tmp41_;
	_g_object_unref0 (ret);
	return result;
}


/** Returns a list of the number of busy nodes at every level
          */
gint* netsukuku_map_get_all_busy_nodes_nb (NetsukukuMap* self, int* result_length1) {
	gint* result = NULL;
	gint _tmp0_;
	gint* _tmp1_ = NULL;
	gint* retval;
	gint retval_length1;
	gint _retval_size_;
	gint* _tmp12_;
	gint _tmp12__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_levels;
	_tmp1_ = g_new0 (gint, _tmp0_);
	retval = _tmp1_;
	retval_length1 = _tmp0_;
	_retval_size_ = retval_length1;
	{
		gint lvl;
		lvl = 0;
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp3_;
				gint _tmp5_;
				gint _tmp6_;
				gint* _tmp7_;
				gint _tmp7__length1;
				gint _tmp8_;
				gint _tmp9_;
				gint _tmp10_ = 0;
				gint _tmp11_;
				_tmp3_ = _tmp2_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = lvl;
					lvl = _tmp4_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp5_ = lvl;
				_tmp6_ = self->priv->_levels;
				if (!(_tmp5_ < _tmp6_)) {
					break;
				}
				_tmp7_ = retval;
				_tmp7__length1 = retval_length1;
				_tmp8_ = lvl;
				_tmp9_ = lvl;
				_tmp10_ = netsukuku_map_busy_nodes_nb (self, _tmp9_);
				_tmp7_[_tmp8_] = _tmp10_;
				_tmp11_ = _tmp7_[_tmp8_];
			}
		}
	}
	_tmp12_ = retval;
	_tmp12__length1 = retval_length1;
	if (result_length1) {
		*result_length1 = _tmp12__length1;
	}
	result = _tmp12_;
	return result;
}


gint netsukuku_map_nip_cmp (NetsukukuMap* self, gint* nipA, int nipA_length1) {
	gint result = 0;
	gint* _tmp0_;
	gint _tmp0__length1;
	NetsukukuNIP* _tmp1_;
	gint _tmp2_ = 0;
	gint* _tmp3_ = NULL;
	gint* _tmp4_;
	gint _tmp4__length1;
	gint _tmp5_ = 0;
	gint _tmp6_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = nipA;
	_tmp0__length1 = nipA_length1;
	_tmp1_ = self->priv->_me;
	_tmp3_ = netsukuku_partial_nip_get_positions ((NetsukukuPartialNIP*) _tmp1_, &_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp2_;
	_tmp5_ = netsukuku_nip_nip_cmp (_tmp0_, _tmp0__length1, _tmp4_, _tmp2_);
	_tmp6_ = _tmp5_;
	_tmp4_ = (g_free (_tmp4_), NULL);
	result = _tmp6_;
	return result;
}


/** Converts a (lvl, pos) pair, referring to this map, to
          * its equivalent nip
          */
NetsukukuPartialNIP* netsukuku_map_lvlid_to_nip (NetsukukuMap* self, NetsukukuHCoord* lvlid) {
	NetsukukuPartialNIP* result = NULL;
	NetsukukuHCoord* _tmp0_;
	NetsukukuNIP* _tmp1_;
	NetsukukuPartialNIP* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (lvlid != NULL, NULL);
	_tmp0_ = lvlid;
	_tmp1_ = self->priv->_me;
	_tmp2_ = netsukuku_hcoord_get_partialnip_relative_to (_tmp0_, _tmp1_);
	result = _tmp2_;
	return result;
}


/** Finds a (lvl, pos) pair, referring to this map, from
          * its equivalent nip
          */
NetsukukuHCoord* netsukuku_map_nip_to_lvlid (NetsukukuMap* self, NetsukukuPartialNIP* nip) {
	NetsukukuHCoord* result = NULL;
	NetsukukuPartialNIP* _tmp0_;
	NetsukukuNIP* _tmp1_;
	NetsukukuHCoord* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (nip != NULL, NULL);
	_tmp0_ = nip;
	_tmp1_ = self->priv->_me;
	_tmp2_ = netsukuku_partial_nip_get_hcoord_relative_to (_tmp0_, _tmp1_);
	result = _tmp2_;
	return result;
}


/** Given a list of pairs (lvl, id) received by a neighbour with a
          * given nip, returns the list of pairs (lvl, id) representing the same
          * list of nodes, as seen from the point of view of this node.
          */
static gboolean _netsukuku_hcoord_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gboolean result;
	result = netsukuku_hcoord_equal_func (a, b);
	return result;
}


GeeList* netsukuku_map_list_lvl_id_from_nip (NetsukukuMap* self, GeeList* lvl_ids, NetsukukuNIP* sender_nip) {
	GeeList* result = NULL;
	NetsukukuNIP* _tmp0_;
	NetsukukuHCoord* _tmp1_ = NULL;
	NetsukukuHCoord* sender_lvlid;
	GeeArrayList* _tmp2_;
	GeeArrayList* ret;
	GeeArrayList* _tmp24_;
	GeeArrayList* ret_nodups;
	NetsukukuHCoord* prec;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (lvl_ids != NULL, NULL);
	g_return_val_if_fail (sender_nip != NULL, NULL);
	_tmp0_ = sender_nip;
	_tmp1_ = netsukuku_map_nip_to_lvlid (self, (NetsukukuPartialNIP*) _tmp0_);
	sender_lvlid = _tmp1_;
	_tmp2_ = gee_array_list_new (NETSUKUKU_TYPE_HCOORD, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_hcoord_equal_func_gee_equal_data_func, NULL, NULL);
	ret = _tmp2_;
	{
		GeeList* _tmp3_;
		GeeList* _tmp4_;
		GeeList* _lvl_id_list;
		GeeList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _lvl_id_size;
		gint _lvl_id_index;
		_tmp3_ = lvl_ids;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		_lvl_id_list = _tmp4_;
		_tmp5_ = _lvl_id_list;
		_tmp6_ = gee_collection_get_size ((GeeCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_lvl_id_size = _tmp7_;
		_lvl_id_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			GeeList* _tmp11_;
			gint _tmp12_;
			gpointer _tmp13_ = NULL;
			NetsukukuHCoord* lvl_id;
			NetsukukuHCoord* _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
			NetsukukuHCoord* _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
			GeeArrayList* _tmp22_;
			NetsukukuHCoord* _tmp23_;
			_tmp8_ = _lvl_id_index;
			_lvl_id_index = _tmp8_ + 1;
			_tmp9_ = _lvl_id_index;
			_tmp10_ = _lvl_id_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _lvl_id_list;
			_tmp12_ = _lvl_id_index;
			_tmp13_ = gee_list_get (_tmp11_, _tmp12_);
			lvl_id = (NetsukukuHCoord*) _tmp13_;
			_tmp14_ = lvl_id;
			_tmp15_ = netsukuku_hcoord_get_lvl (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = sender_lvlid;
			_tmp18_ = netsukuku_hcoord_get_lvl (_tmp17_);
			_tmp19_ = _tmp18_;
			if (_tmp16_ < _tmp19_) {
				NetsukukuHCoord* _tmp20_;
				NetsukukuHCoord* _tmp21_;
				_tmp20_ = sender_lvlid;
				_tmp21_ = _g_object_ref0 (_tmp20_);
				_g_object_unref0 (lvl_id);
				lvl_id = _tmp21_;
			}
			_tmp22_ = ret;
			_tmp23_ = lvl_id;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp22_, _tmp23_);
			_g_object_unref0 (lvl_id);
		}
		_g_object_unref0 (_lvl_id_list);
	}
	_tmp24_ = gee_array_list_new (NETSUKUKU_TYPE_HCOORD, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_hcoord_equal_func_gee_equal_data_func, NULL, NULL);
	ret_nodups = _tmp24_;
	prec = NULL;
	{
		GeeArrayList* _tmp25_;
		GeeArrayList* _tmp26_;
		GeeArrayList* _x_list;
		GeeArrayList* _tmp27_;
		gint _tmp28_;
		gint _tmp29_;
		gint _x_size;
		gint _x_index;
		_tmp25_ = ret;
		_tmp26_ = _g_object_ref0 (_tmp25_);
		_x_list = _tmp26_;
		_tmp27_ = _x_list;
		_tmp28_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp27_);
		_tmp29_ = _tmp28_;
		_x_size = _tmp29_;
		_x_index = -1;
		while (TRUE) {
			gint _tmp30_;
			gint _tmp31_;
			gint _tmp32_;
			GeeArrayList* _tmp33_;
			gint _tmp34_;
			gpointer _tmp35_ = NULL;
			NetsukukuHCoord* x;
			NetsukukuHCoord* _tmp36_;
			NetsukukuHCoord* _tmp37_;
			gboolean _tmp38_ = FALSE;
			_tmp30_ = _x_index;
			_x_index = _tmp30_ + 1;
			_tmp31_ = _x_index;
			_tmp32_ = _x_size;
			if (!(_tmp31_ < _tmp32_)) {
				break;
			}
			_tmp33_ = _x_list;
			_tmp34_ = _x_index;
			_tmp35_ = gee_abstract_list_get ((GeeAbstractList*) _tmp33_, _tmp34_);
			x = (NetsukukuHCoord*) _tmp35_;
			_tmp36_ = x;
			_tmp37_ = prec;
			_tmp38_ = netsukuku_hcoord_is_equal (_tmp36_, _tmp37_);
			if (!_tmp38_) {
				NetsukukuHCoord* _tmp39_;
				NetsukukuHCoord* _tmp40_;
				GeeArrayList* _tmp41_;
				NetsukukuHCoord* _tmp42_;
				_tmp39_ = x;
				_tmp40_ = _g_object_ref0 (_tmp39_);
				_g_object_unref0 (prec);
				prec = _tmp40_;
				_tmp41_ = ret_nodups;
				_tmp42_ = x;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp41_, _tmp42_);
			}
			_g_object_unref0 (x);
		}
		_g_object_unref0 (_x_list);
	}
	result = (GeeList*) ret_nodups;
	_g_object_unref0 (prec);
	_g_object_unref0 (ret);
	_g_object_unref0 (sender_lvlid);
	return result;
}


/** Given a list of pairs (lvl, id) being sent to a neighbour with a
          * given nip, returns the list of pairs (lvl, id) representing the same
          * list of nodes, as seen from the point of view of the neighbour.
          */
GeeList* netsukuku_map_list_lvl_id_to_nip (NetsukukuMap* self, GeeList* lvl_ids, NetsukukuNIP* to_nip) {
	GeeList* result = NULL;
	NetsukukuNIP* _tmp0_;
	NetsukukuHCoord* _tmp1_ = NULL;
	NetsukukuHCoord* to_lvlid;
	GeeArrayList* _tmp2_;
	GeeArrayList* ret;
	GeeArrayList* _tmp31_;
	GeeArrayList* ret_nodups;
	NetsukukuHCoord* prec;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (lvl_ids != NULL, NULL);
	g_return_val_if_fail (to_nip != NULL, NULL);
	_tmp0_ = to_nip;
	_tmp1_ = netsukuku_map_nip_to_lvlid (self, (NetsukukuPartialNIP*) _tmp0_);
	to_lvlid = _tmp1_;
	_tmp2_ = gee_array_list_new (NETSUKUKU_TYPE_HCOORD, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_hcoord_equal_func_gee_equal_data_func, NULL, NULL);
	ret = _tmp2_;
	{
		GeeList* _tmp3_;
		GeeList* _tmp4_;
		GeeList* _lvl_id_list;
		GeeList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _lvl_id_size;
		gint _lvl_id_index;
		_tmp3_ = lvl_ids;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		_lvl_id_list = _tmp4_;
		_tmp5_ = _lvl_id_list;
		_tmp6_ = gee_collection_get_size ((GeeCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_lvl_id_size = _tmp7_;
		_lvl_id_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			GeeList* _tmp11_;
			gint _tmp12_;
			gpointer _tmp13_ = NULL;
			NetsukukuHCoord* lvl_id;
			NetsukukuHCoord* _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
			NetsukukuHCoord* _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
			GeeArrayList* _tmp29_;
			NetsukukuHCoord* _tmp30_;
			_tmp8_ = _lvl_id_index;
			_lvl_id_index = _tmp8_ + 1;
			_tmp9_ = _lvl_id_index;
			_tmp10_ = _lvl_id_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _lvl_id_list;
			_tmp12_ = _lvl_id_index;
			_tmp13_ = gee_list_get (_tmp11_, _tmp12_);
			lvl_id = (NetsukukuHCoord*) _tmp13_;
			_tmp14_ = lvl_id;
			_tmp15_ = netsukuku_hcoord_get_lvl (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = to_lvlid;
			_tmp18_ = netsukuku_hcoord_get_lvl (_tmp17_);
			_tmp19_ = _tmp18_;
			if (_tmp16_ < _tmp19_) {
				NetsukukuHCoord* _tmp20_;
				gint _tmp21_;
				gint _tmp22_;
				NetsukukuNIP* _tmp23_;
				NetsukukuHCoord* _tmp24_;
				gint _tmp25_;
				gint _tmp26_;
				gint _tmp27_ = 0;
				NetsukukuHCoord* _tmp28_;
				_tmp20_ = to_lvlid;
				_tmp21_ = netsukuku_hcoord_get_lvl (_tmp20_);
				_tmp22_ = _tmp21_;
				_tmp23_ = self->priv->_me;
				_tmp24_ = to_lvlid;
				_tmp25_ = netsukuku_hcoord_get_lvl (_tmp24_);
				_tmp26_ = _tmp25_;
				_tmp27_ = netsukuku_partial_nip_position_at ((NetsukukuPartialNIP*) _tmp23_, _tmp26_);
				_tmp28_ = netsukuku_hcoord_new (_tmp22_, _tmp27_);
				_g_object_unref0 (lvl_id);
				lvl_id = _tmp28_;
			}
			_tmp29_ = ret;
			_tmp30_ = lvl_id;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp29_, _tmp30_);
			_g_object_unref0 (lvl_id);
		}
		_g_object_unref0 (_lvl_id_list);
	}
	_tmp31_ = gee_array_list_new (NETSUKUKU_TYPE_HCOORD, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_hcoord_equal_func_gee_equal_data_func, NULL, NULL);
	ret_nodups = _tmp31_;
	prec = NULL;
	{
		GeeArrayList* _tmp32_;
		GeeArrayList* _tmp33_;
		GeeArrayList* _x_list;
		GeeArrayList* _tmp34_;
		gint _tmp35_;
		gint _tmp36_;
		gint _x_size;
		gint _x_index;
		_tmp32_ = ret;
		_tmp33_ = _g_object_ref0 (_tmp32_);
		_x_list = _tmp33_;
		_tmp34_ = _x_list;
		_tmp35_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp34_);
		_tmp36_ = _tmp35_;
		_x_size = _tmp36_;
		_x_index = -1;
		while (TRUE) {
			gint _tmp37_;
			gint _tmp38_;
			gint _tmp39_;
			GeeArrayList* _tmp40_;
			gint _tmp41_;
			gpointer _tmp42_ = NULL;
			NetsukukuHCoord* x;
			NetsukukuHCoord* _tmp43_;
			NetsukukuHCoord* _tmp44_;
			gboolean _tmp45_ = FALSE;
			_tmp37_ = _x_index;
			_x_index = _tmp37_ + 1;
			_tmp38_ = _x_index;
			_tmp39_ = _x_size;
			if (!(_tmp38_ < _tmp39_)) {
				break;
			}
			_tmp40_ = _x_list;
			_tmp41_ = _x_index;
			_tmp42_ = gee_abstract_list_get ((GeeAbstractList*) _tmp40_, _tmp41_);
			x = (NetsukukuHCoord*) _tmp42_;
			_tmp43_ = x;
			_tmp44_ = prec;
			_tmp45_ = netsukuku_hcoord_is_equal (_tmp43_, _tmp44_);
			if (!_tmp45_) {
				NetsukukuHCoord* _tmp46_;
				NetsukukuHCoord* _tmp47_;
				GeeArrayList* _tmp48_;
				NetsukukuHCoord* _tmp49_;
				_tmp46_ = x;
				_tmp47_ = _g_object_ref0 (_tmp46_);
				_g_object_unref0 (prec);
				prec = _tmp47_;
				_tmp48_ = ret_nodups;
				_tmp49_ = x;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp48_, _tmp49_);
			}
			_g_object_unref0 (x);
		}
		_g_object_unref0 (_x_list);
	}
	result = (GeeList*) ret_nodups;
	_g_object_unref0 (prec);
	_g_object_unref0 (ret);
	_g_object_unref0 (to_lvlid);
	return result;
}


gint netsukuku_map_get_levels (NetsukukuMap* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_levels;
	result = _tmp0_;
	return result;
}


gint netsukuku_map_get_gsize (NetsukukuMap* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_gsize;
	result = _tmp0_;
	return result;
}


NetsukukuNIP* netsukuku_map_get_me (NetsukukuMap* self) {
	NetsukukuNIP* result;
	NetsukukuNIP* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_me;
	result = _tmp0_;
	return result;
}


static void g_cclosure_user_marshal_VOID__INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__INT_INT) (gpointer data1, gint arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_VOID__INT_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__INT_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_int (param_values + 1), g_value_get_int (param_values + 2), data2);
}


static void netsukuku_map_class_init (NetsukukuMapClass * klass) {
	netsukuku_map_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (NetsukukuMapPrivate));
	NETSUKUKU_MAP_CLASS (klass)->stop_operations = netsukuku_map_real_stop_operations;
	NETSUKUKU_MAP_CLASS (klass)->node_get = netsukuku_map_real_node_get;
	G_OBJECT_CLASS (klass)->get_property = _vala_netsukuku_map_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_netsukuku_map_set_property;
	G_OBJECT_CLASS (klass)->finalize = netsukuku_map_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETSUKUKU_MAP_T_TYPE, g_param_spec_gtype ("t-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETSUKUKU_MAP_T_DUP_FUNC, g_param_spec_pointer ("t-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETSUKUKU_MAP_T_DESTROY_FUNC, g_param_spec_pointer ("t-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETSUKUKU_MAP_LEVELS, g_param_spec_int ("levels", "levels", "levels", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETSUKUKU_MAP_GSIZE, g_param_spec_int ("gsize", "gsize", "gsize", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETSUKUKU_MAP_ME, g_param_spec_object ("me", "me", "me", NETSUKUKU_TYPE_NIP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("node_new", NETSUKUKU_TYPE_MAP, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_INT, G_TYPE_NONE, 2, G_TYPE_INT, G_TYPE_INT);
	g_signal_new ("node_deleted", NETSUKUKU_TYPE_MAP, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_INT, G_TYPE_NONE, 2, G_TYPE_INT, G_TYPE_INT);
}


static void netsukuku_map_instance_init (NetsukukuMap * self) {
	self->priv = NETSUKUKU_MAP_GET_PRIVATE (self);
	self->priv->check_all_nodes_handle = NULL;
	self->priv->stopped_operations = FALSE;
}


static void netsukuku_map_finalize (GObject* obj) {
	NetsukukuMap * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_MAP, NetsukukuMap);
	_g_object_unref0 (self->priv->_me);
	self->node = (_vala_array_free (self->node, self->node_length1 * self->node_length2, (GDestroyNotify) g_object_unref), NULL);
	self->priv->node_prev_free = (g_free (self->priv->node_prev_free), NULL);
	_g_object_unref0 (self->priv->check_all_nodes_handle);
	G_OBJECT_CLASS (netsukuku_map_parent_class)->finalize (obj);
}


/** A Map instance represents ...
      */
GType netsukuku_map_get_type (void) {
	static volatile gsize netsukuku_map_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_map_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuMapClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_map_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuMap), 0, (GInstanceInitFunc) netsukuku_map_instance_init, NULL };
		GType netsukuku_map_type_id;
		netsukuku_map_type_id = g_type_register_static (G_TYPE_OBJECT, "NetsukukuMap", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_map_type_id__volatile, netsukuku_map_type_id);
	}
	return netsukuku_map_type_id__volatile;
}


static void _vala_netsukuku_map_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	NetsukukuMap * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETSUKUKU_TYPE_MAP, NetsukukuMap);
	switch (property_id) {
		case NETSUKUKU_MAP_LEVELS:
		g_value_set_int (value, netsukuku_map_get_levels (self));
		break;
		case NETSUKUKU_MAP_GSIZE:
		g_value_set_int (value, netsukuku_map_get_gsize (self));
		break;
		case NETSUKUKU_MAP_ME:
		g_value_set_object (value, netsukuku_map_get_me (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_netsukuku_map_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	NetsukukuMap * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETSUKUKU_TYPE_MAP, NetsukukuMap);
	switch (property_id) {
		case NETSUKUKU_MAP_T_TYPE:
		self->priv->t_type = g_value_get_gtype (value);
		break;
		case NETSUKUKU_MAP_T_DUP_FUNC:
		self->priv->t_dup_func = g_value_get_pointer (value);
		break;
		case NETSUKUKU_MAP_T_DESTROY_FUNC:
		self->priv->t_destroy_func = g_value_get_pointer (value);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



