/*
 *  This file is part of Netsukuku.
 *  (c) Copyright 2011-2014 Luca Dionisi aka lukisi <luca.dionisi@gmail.com>
 *
 *  Netsukuku is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Netsukuku is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Netsukuku.  If not, see <http://www.gnu.org/licenses/>.
 */

using Gee;
using Netsukuku;
using Tasklets;
using zcd;

namespace Netsukuku
{
#if log_tasklet
    private string tasklet_id()
    {
        return @"[$(Tasklet.self().id)] ";
    }
#else
    private string tasklet_id()
    {
        return "";
    }
#endif
    internal void log_debug(string msg) {Posix.syslog(Posix.LOG_DEBUG, tasklet_id()+msg);}
    internal void log_info(string msg) {Posix.syslog(Posix.LOG_INFO, tasklet_id()+msg);}
    internal void log_notice(string msg) {Posix.syslog(Posix.LOG_NOTICE, tasklet_id()+msg);}
    internal void log_warn(string msg) {Posix.syslog(Posix.LOG_WARNING, tasklet_id()+msg);}
    internal void log_error(string msg) {Posix.syslog(Posix.LOG_ERR, tasklet_id()+msg);}
    internal void log_critical(string msg) {Posix.syslog(Posix.LOG_CRIT, tasklet_id()+msg);}

    namespace Crypto
    {
        public errordomain GCryptError {GENERIC}
        public uint32 fnv_32(uchar[] data) {return 0;}
    }

    public errordomain IncomingNodesError {GENERIC}

    public errordomain RPCError {
        FUNCTION_NOT_REMOTABLE,
        MALFORMED_PACKET,
        NETWORK_ERROR,
        NOT_VALID_MAP_YET,
        DROP,
        GENERIC
    }
    public ArrayList<int> valid_ids(int levels, int gsize, int lvl, PartialNIP partial_nip)
    {
        ArrayList<int> ret = new ArrayList<int>();
        for (int i = 0; i < gsize; i++) ret.add(i);
        return ret;
    }
    NetworkID the_common_netid;
    NetworkID get_common_netid()
    {
        if (the_common_netid == null)
        {
            GNodeID gid0 = new GNodeID(1,1,12323);
            ArrayList<GNodeID> gidlist = new ArrayList<GNodeID>();
            gidlist.add(gid0);
            the_common_netid = new NetworkID(gidlist);
        }
        return the_common_netid;
    }
    public string nip_to_str(int levels, int gsize, NIP nip) {return "";}
    public class Route : Object
    {
        public REM rem;
        public REM rem_at_gw;
        public Gee.List<HCoord> hops;
        public GNodeID gid;
        public Gee.List<HCoord> hops_with_gw;
    }
    public class RouteNode : Object
    {
        public bool is_empty() {return false;}
        public bool is_free() {return false;}
        public GNodeID? get_eldest_gid() {return null;}
        public int nroutes() {return 0;}
        public Route? best_route() {return null;}
        public Route? best_route_without(HCoord hop) {return null;}
        public Route? route_get_by_gw(AggregatedNeighbour aggregated_neighbour) {return null;}
    }
    public class MapRoute : Object
    {
        public MapRoute()
        {
            levels = 3;
            gsize = 4;
            me = new NIP({1,2,3});
        }
        public AddressManager address_manager;
        public GNodeID[] id_myself {get; private set;}
        public int gsize;
        public int levels;
        public NIP me;
        public HCoord? nip_to_lvlid(NIP nip_caller) {return null;}
        public RouteNode? node_get(int lvl, int pos)
        {
            if (lvl == 0 && pos == 2)
            {
                RouteNode ret = new RouteNode();
                return ret;
            }
            return null;
        }
        public Gee.List<HCoord> list_lvl_id_from_nip(Gee.List<HCoord> lvl_ids, NIP sender_nip) {return new ArrayList<HCoord>();}
        public Gee.List<HCoord> list_lvl_id_to_nip(Gee.List<HCoord> lvl_ids, NIP to_nip) {return new ArrayList<HCoord>();}
        public int nip_cmp(int[] nipA)
        {
            return NIP.nip_cmp(nipA, me.get_positions());
        }
        public void update_route_by_gw(HCoord dest, AggregatedNeighbour nr, REM rem_at_gw, Gee.List<HCoord> hops, GNodeID gid) {}
        public int busy_nodes_nb(int lvl) {return 1;}
        public void route_signal_rem_changed(int lvl, int dst) {}
        public void delete_routes_via_neighbour(AggregatedNeighbour aggregated_neighbour) {}
    }
    public class AddressManager : Object
    {
        public ArrayList<NetworkInterfaceManager> nics;
        public NetworkID get_main_netid() {return get_common_netid();}
        public bool is_in_my_network(NetworkID netid) {return netid == get_main_netid();}
        public IncomingNodes incoming_nodes;
        public bool do_i_act_as_gateway_for(NIP nip, int nodeid, NetworkID netid) {return true;}
        public int get_my_id() {return 0;}
        public FakeAddressManagerFakeRmt get_broadcast_client() {return new FakeAddressManagerFakeRmt();}
        public bool is_preferred_network(NetworkID netid) {return false;}
        public bool is_mature;
    }
    public class NIC : Object
    {
        public string mac;
    }
    public class NetworkInterfaceManager : Object
    {
        public NIC nic_class {get; private set;}
        public string nic_name {get; private set;}
        public bool to_be_managed;
        public bool to_be_copied;
        public bool initialized;
    }
    public class AggregatedNeighbourManager : Object
    {
        public signal void aggregated_neighbour_new(AggregatedNeighbour aggregated_neighbour);
        public signal void aggregated_neighbour_new_before(AggregatedNeighbour aggregated_neighbour);
        public signal void aggregated_neighbour_deleted(AggregatedNeighbour aggregated_neighbour);
        public signal void aggregated_neighbour_deleted_after(AggregatedNeighbour aggregated_neighbour);
        public signal void aggregated_neighbour_rem_chged(AggregatedNeighbour aggregated_neighbour, REM old_rem);
        public signal void aggregated_neighbour_rem_chged_before(AggregatedNeighbour aggregated_neighbour, REM old_rem);
        public signal void aggregated_neighbour_going_new(AggregatedNeighbour aggregated_neighbour);
        public signal void aggregated_neighbour_going_deleted(AggregatedNeighbour aggregated_neighbour);
        public signal void aggregated_neighbour_going_rem_chged(AggregatedNeighbour aggregated_neighbour);
        public signal void aggregated_neighbour_colliding_new(AggregatedNeighbour aggregated_neighbour);
        public signal void aggregated_neighbour_colliding_deleted(AggregatedNeighbour aggregated_neighbour);
        public signal void aggregated_neighbour_colliding_rem_chged(AggregatedNeighbour aggregated_neighbour, REM old_rem);
        public signal void aggregated_neighbour_colliding_going_new(AggregatedNeighbour aggregated_neighbour);
        public signal void aggregated_neighbour_colliding_going_deleted(AggregatedNeighbour aggregated_neighbour);
        public signal void aggregated_neighbour_colliding_going_rem_chged(AggregatedNeighbour aggregated_neighbour);
        public Gee.List<AggregatedNeighbour> neighbour_list(bool? b=null, NetworkID? with_this_netid=null) {assert(false);return new ArrayList<AggregatedNeighbour>();}
        public AggregatedNeighbour? key_to_neighbour(NIP nip, int nodeid) {assert(false);return null;}
    }
    public class AggregatedNeighbour : Object
    {
        public AggregatedNeighbour()
        {
            nip = new NIP({2,2,3});
            mod_seq_num = 0;
            netid = get_common_netid();
        }
        public NIP nip;
        public REM rem;
        public int mod_seq_num;
        public NetworkID netid;
        public string to_string() {return "";}
        public FakeAddressManagerFakeRmt neighbour_client;
        public int nodeid;
        public FakeAddressManagerFakeRmt create_neighbour_client(string? my_addr=null, bool response=true)
        {return new FakeAddressManagerFakeRmt();}
        public static bool equal_func(AggregatedNeighbour? a, AggregatedNeighbour? b) { return true; }
        public static uint hash_func(AggregatedNeighbour a) { return 0; }
    }
    public class FakeAddressManagerFakeRmt : AddressManagerFakeRmt
    {
        public FakeAddressManagerFakeRmt()
        {
            etp = this;
        }
        // fake .etp.new_sequence_number(maproute.me, address_manager.get_my_id(), my_curr_seq_num);
        public FakeAddressManagerFakeRmt etp;
        public void new_sequence_number(NIP nip, int nodeid, int seqnum) {}
        public void act_as_gateway(NIP nip_caller, int nodeid_caller, NetworkID netid_caller, Gee.List<string> macs) {assert(false);}
        public int request_size() {assert(false); return 0;}
        public ExtendedTracerPacket request_etp(int prev_mod_seq_num, NIP nip_caller,
                                int nodeid_caller, NetworkID netid_caller,
                                Gee.List<string> macs_caller) throws QspnError {assert(false); return null;}
        public override ISerializable rmt(RemoteCall data) {return null;}
    }
    public class IncomingNodes
    {
        public bool contains(NIP nip, int nodeid) {return false;}
        public RoutesSet? get_knowledge(NIP nip, int nodeid, int prev_seq_num) {return null;}
        public void update(NIP nip, int nodeid, Gee.List<string> macs, int? ttl=null) {}
        public void log_knowledge(NIP nip, int nodeid, int my_seq_num, RoutesSet destinations) {}
        public void purge() {}
    }
}

namespace Ntk.Test
{
    string logger;
    const bool output = false;

    public class QspnTester : Object
    {
        public void set_up ()
        {
            logger = "";
        }

        public void tear_down ()
        {
            logger = "";
        }

        public void test_etp_exec()
        {
            AggregatedNeighbourManager aggregated_neighbour_manager = new AggregatedNeighbourManager(); /*never really used*/
            MapRoute maproute = new MapRoute(); /*{1,2,3}, netid=common_netid*/
            AddressManager address_manager = new AddressManager();
            Etp etp = new Etp(aggregated_neighbour_manager, maproute, address_manager);

            // Here simulates a request of an ExtendedTracerPacket from a neighbour n;
            // The previous destinations known by me through n were "nothing"
            // The current are "nothing" + n itself (which is HCoord(0,2) for me)
            RoutesSet r_to_send = new RoutesSet(maproute.levels);
            r_to_send.add_replace(/*lvl*/0, /*pos*/2,
                                    new NullREM(), new ArrayList<HCoord>(HCoord.equal_func),
                                    new GNodeID(1,1,12345));
            // prepare TPL.
            TracerPacketList tpl = new TracerPacketList();
            tpl.append(2, new NullREM());
            // prepare ETP.
            ExtendedTracerPacket et_packet = new ExtendedTracerPacket();
            et_packet.r = r_to_send;
            et_packet.tpl = tpl;
            et_packet.seq_num = 1;

            // Represent neighbour n. Its property mod_seq_num is the last etp that I got from it. (0)
            //  Its netid matches my own.
            AggregatedNeighbour aggregated_neighbour = new AggregatedNeighbour(); /*{2,2,3}, netid=common_netid*/

            // Call of etp_exec. This should at least not crash.
            etp.etp_exec(aggregated_neighbour, et_packet);
        }

        public static int main(string[] args)
        {
            GLib.Test.init(ref args);
            Tasklet.init();
            GLib.Test.add_func ("/Qspn/EtpExec", () => {
                var x = new QspnTester();
                x.set_up();
                x.test_etp_exec();
                x.tear_down();
            });
            GLib.Test.run();
            Tasklet.kill();
            return 0;
        }
    }
}
