/* hook.c generated by valac 0.20.1, the Vala compiler
 * generated from hook.vala, do not modify */

/*
 *  This file is part of Netsukuku.
 *  (c) Copyright 2011 Luca Dionisi aka lukisi <luca.dionisi@gmail.com>
 *
 *  Netsukuku is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Netsukuku is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Netsukuku.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <netsukuku-rpc.h>
#include <zcd.h>


#define NETSUKUKU_TYPE_HOOKING_SOLUTION (netsukuku_hooking_solution_get_type ())
#define NETSUKUKU_HOOKING_SOLUTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_HOOKING_SOLUTION, NetsukukuHookingSolution))
#define NETSUKUKU_HOOKING_SOLUTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_HOOKING_SOLUTION, NetsukukuHookingSolutionClass))
#define NETSUKUKU_IS_HOOKING_SOLUTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_HOOKING_SOLUTION))
#define NETSUKUKU_IS_HOOKING_SOLUTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_HOOKING_SOLUTION))
#define NETSUKUKU_HOOKING_SOLUTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_HOOKING_SOLUTION, NetsukukuHookingSolutionClass))

typedef struct _NetsukukuHookingSolution NetsukukuHookingSolution;
typedef struct _NetsukukuHookingSolutionClass NetsukukuHookingSolutionClass;
typedef struct _NetsukukuHookingSolutionPrivate NetsukukuHookingSolutionPrivate;

#define NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR (netsukuku_aggregated_neighbour_get_type ())
#define NETSUKUKU_AGGREGATED_NEIGHBOUR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR, NetsukukuAggregatedNeighbour))
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR, NetsukukuAggregatedNeighbourClass))
#define NETSUKUKU_IS_AGGREGATED_NEIGHBOUR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR))
#define NETSUKUKU_IS_AGGREGATED_NEIGHBOUR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR))
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR, NetsukukuAggregatedNeighbourClass))

typedef struct _NetsukukuAggregatedNeighbour NetsukukuAggregatedNeighbour;
typedef struct _NetsukukuAggregatedNeighbourClass NetsukukuAggregatedNeighbourClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define NETSUKUKU_TYPE_HOOK (netsukuku_hook_get_type ())
#define NETSUKUKU_HOOK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_HOOK, NetsukukuHook))
#define NETSUKUKU_HOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_HOOK, NetsukukuHookClass))
#define NETSUKUKU_IS_HOOK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_HOOK))
#define NETSUKUKU_IS_HOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_HOOK))
#define NETSUKUKU_HOOK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_HOOK, NetsukukuHookClass))

typedef struct _NetsukukuHook NetsukukuHook;
typedef struct _NetsukukuHookClass NetsukukuHookClass;
typedef struct _NetsukukuHookPrivate NetsukukuHookPrivate;

#define NETSUKUKU_TYPE_MAP_ROUTE (netsukuku_map_route_get_type ())
#define NETSUKUKU_MAP_ROUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_MAP_ROUTE, NetsukukuMapRoute))
#define NETSUKUKU_MAP_ROUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_MAP_ROUTE, NetsukukuMapRouteClass))
#define NETSUKUKU_IS_MAP_ROUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_MAP_ROUTE))
#define NETSUKUKU_IS_MAP_ROUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_MAP_ROUTE))
#define NETSUKUKU_MAP_ROUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_MAP_ROUTE, NetsukukuMapRouteClass))

typedef struct _NetsukukuMapRoute NetsukukuMapRoute;
typedef struct _NetsukukuMapRouteClass NetsukukuMapRouteClass;

#define NETSUKUKU_TYPE_COORD (netsukuku_coord_get_type ())
#define NETSUKUKU_COORD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_COORD, NetsukukuCoord))
#define NETSUKUKU_COORD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_COORD, NetsukukuCoordClass))
#define NETSUKUKU_IS_COORD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_COORD))
#define NETSUKUKU_IS_COORD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_COORD))
#define NETSUKUKU_COORD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_COORD, NetsukukuCoordClass))

typedef struct _NetsukukuCoord NetsukukuCoord;
typedef struct _NetsukukuCoordClass NetsukukuCoordClass;

#define NETSUKUKU_TYPE_ADDRESS_MANAGER (netsukuku_address_manager_get_type ())
#define NETSUKUKU_ADDRESS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_ADDRESS_MANAGER, NetsukukuAddressManager))
#define NETSUKUKU_ADDRESS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_ADDRESS_MANAGER, NetsukukuAddressManagerClass))
#define NETSUKUKU_IS_ADDRESS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_ADDRESS_MANAGER))
#define NETSUKUKU_IS_ADDRESS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_ADDRESS_MANAGER))
#define NETSUKUKU_ADDRESS_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_ADDRESS_MANAGER, NetsukukuAddressManagerClass))

typedef struct _NetsukukuAddressManager NetsukukuAddressManager;
typedef struct _NetsukukuAddressManagerClass NetsukukuAddressManagerClass;
typedef struct _NetsukukuAggregatedNeighbourPrivate NetsukukuAggregatedNeighbourPrivate;

#define NETSUKUKU_TYPE_FAKE_AGGREGATEDNEIGHBOUR (netsukuku_fake_aggregatedneighbour_get_type ())
#define NETSUKUKU_FAKE_AGGREGATEDNEIGHBOUR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_FAKE_AGGREGATEDNEIGHBOUR, Netsukukufake_AggregatedNeighbour))
#define NETSUKUKU_FAKE_AGGREGATEDNEIGHBOUR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_FAKE_AGGREGATEDNEIGHBOUR, Netsukukufake_AggregatedNeighbourClass))
#define NETSUKUKU_IS_FAKE_AGGREGATEDNEIGHBOUR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_FAKE_AGGREGATEDNEIGHBOUR))
#define NETSUKUKU_IS_FAKE_AGGREGATEDNEIGHBOUR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_FAKE_AGGREGATEDNEIGHBOUR))
#define NETSUKUKU_FAKE_AGGREGATEDNEIGHBOUR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_FAKE_AGGREGATEDNEIGHBOUR, Netsukukufake_AggregatedNeighbourClass))

typedef struct _Netsukukufake_AggregatedNeighbour Netsukukufake_AggregatedNeighbour;
typedef struct _Netsukukufake_AggregatedNeighbourClass Netsukukufake_AggregatedNeighbourClass;
typedef struct _Netsukukufake_AggregatedNeighbourPrivate Netsukukufake_AggregatedNeighbourPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _NetsukukuAddressManagerPrivate NetsukukuAddressManagerPrivate;
typedef struct _NetsukukuMapRoutePrivate NetsukukuMapRoutePrivate;

struct _NetsukukuHookingSolution {
	GObject parent_instance;
	NetsukukuHookingSolutionPrivate * priv;
};

struct _NetsukukuHookingSolutionClass {
	GObjectClass parent_class;
};

struct _NetsukukuHookingSolutionPrivate {
	NetsukukuAggregatedNeighbour* _aggregated_neighbour;
	gint _lvl;
	gint _fn;
};

struct _NetsukukuHook {
	GObject parent_instance;
	NetsukukuHookPrivate * priv;
};

struct _NetsukukuHookClass {
	GObjectClass parent_class;
};

struct _NetsukukuHookPrivate {
	NetsukukuMapRoute* maproute;
	NetsukukuCoord* coord;
	NetsukukuAddressManager* addr_man;
};

struct _NetsukukuAggregatedNeighbour {
	GObject parent_instance;
	NetsukukuAggregatedNeighbourPrivate * priv;
	NetsukukuNIP* nip;
	Netsukukufake_AggregatedNeighbour* neighbour_client;
};

struct _NetsukukuAggregatedNeighbourClass {
	GObjectClass parent_class;
};

struct _Netsukukufake_AggregatedNeighbour {
	GObject parent_instance;
	Netsukukufake_AggregatedNeighbourPrivate * priv;
	Netsukukufake_AggregatedNeighbour* hook;
};

struct _Netsukukufake_AggregatedNeighbourClass {
	GObjectClass parent_class;
};

struct _NetsukukuAddressManager {
	GObject parent_instance;
	NetsukukuAddressManagerPrivate * priv;
	gboolean is_mature;
};

struct _NetsukukuAddressManagerClass {
	GObjectClass parent_class;
};

struct _NetsukukuMapRoute {
	GObject parent_instance;
	NetsukukuMapRoutePrivate * priv;
	gint levels;
};

struct _NetsukukuMapRouteClass {
	GObjectClass parent_class;
};

typedef enum  {
	NETSUKUKU_RPC_ERROR_FUNCTION_NOT_REMOTABLE,
	NETSUKUKU_RPC_ERROR_MALFORMED_PACKET,
	NETSUKUKU_RPC_ERROR_NETWORK_ERROR,
	NETSUKUKU_RPC_ERROR_NOT_VALID_MAP_YET,
	NETSUKUKU_RPC_ERROR_DROP,
	NETSUKUKU_RPC_ERROR_GENERIC
} NetsukukuRPCError;
#define NETSUKUKU_RPC_ERROR netsukuku_rpc_error_quark ()

static gpointer netsukuku_hooking_solution_parent_class = NULL;
static GeeComparableIface* netsukuku_hooking_solution_gee_comparable_parent_iface = NULL;
static gpointer netsukuku_hook_parent_class = NULL;
static NetsukukuIHookIface* netsukuku_hook_netsukuku_ihook_parent_iface = NULL;

GType netsukuku_hooking_solution_get_type (void) G_GNUC_CONST;
GType netsukuku_aggregated_neighbour_get_type (void) G_GNUC_CONST;
#define NETSUKUKU_HOOKING_SOLUTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), NETSUKUKU_TYPE_HOOKING_SOLUTION, NetsukukuHookingSolutionPrivate))
enum  {
	NETSUKUKU_HOOKING_SOLUTION_DUMMY_PROPERTY,
	NETSUKUKU_HOOKING_SOLUTION_AGGREGATED_NEIGHBOUR,
	NETSUKUKU_HOOKING_SOLUTION_LVL,
	NETSUKUKU_HOOKING_SOLUTION_FN
};
NetsukukuHookingSolution* netsukuku_hooking_solution_new (NetsukukuAggregatedNeighbour* aggregated_neighbour, gint lvl, gint fn);
NetsukukuHookingSolution* netsukuku_hooking_solution_construct (GType object_type, NetsukukuAggregatedNeighbour* aggregated_neighbour, gint lvl, gint fn);
static void netsukuku_hooking_solution_set_aggregated_neighbour (NetsukukuHookingSolution* self, NetsukukuAggregatedNeighbour* value);
static void netsukuku_hooking_solution_set_lvl (NetsukukuHookingSolution* self, gint value);
static void netsukuku_hooking_solution_set_fn (NetsukukuHookingSolution* self, gint value);
static gint netsukuku_hooking_solution_real_compare_to (GeeComparable* base, NetsukukuHookingSolution* b);
gint netsukuku_hooking_solution_get_lvl (NetsukukuHookingSolution* self);
gint netsukuku_hooking_solution_get_fn (NetsukukuHookingSolution* self);
gchar* netsukuku_hooking_solution_to_string (NetsukukuHookingSolution* self);
NetsukukuAggregatedNeighbour* netsukuku_hooking_solution_get_aggregated_neighbour (NetsukukuHookingSolution* self);
gchar* netsukuku_aggregated_neighbour_to_string (NetsukukuAggregatedNeighbour* self);
static void netsukuku_hooking_solution_finalize (GObject* obj);
static void _vala_netsukuku_hooking_solution_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_netsukuku_hooking_solution_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType netsukuku_hook_get_type (void) G_GNUC_CONST;
GType netsukuku_map_route_get_type (void) G_GNUC_CONST;
GType netsukuku_coord_get_type (void) G_GNUC_CONST;
GType netsukuku_address_manager_get_type (void) G_GNUC_CONST;
#define NETSUKUKU_HOOK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), NETSUKUKU_TYPE_HOOK, NetsukukuHookPrivate))
enum  {
	NETSUKUKU_HOOK_DUMMY_PROPERTY
};
NetsukukuHook* netsukuku_hook_new (NetsukukuMapRoute* maproute, NetsukukuCoord* coord, NetsukukuAddressManager* addr_man);
NetsukukuHook* netsukuku_hook_construct (GType object_type, NetsukukuMapRoute* maproute, NetsukukuCoord* coord, NetsukukuAddressManager* addr_man);
static gboolean netsukuku_hook_not_impl_equal_func (GObject* a, GObject* b);
static gint netsukuku_hook_reverse_compare (NetsukukuHookingSolution* a, NetsukukuHookingSolution* b);
NetsukukuHookReservation* netsukuku_hook_hook (NetsukukuHook* self, GeeList* neighbour_list, GError** error);
static gboolean _netsukuku_hook_not_impl_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self);
GType netsukuku_fake_aggregatedneighbour_get_type (void) G_GNUC_CONST;
GeeList* netsukuku_fake_aggregatedneighbour_list_non_saturated_levels (Netsukukufake_AggregatedNeighbour* self);
void netsukuku_log_debug (const gchar* msg);
static gint _netsukuku_hook_reverse_compare_gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self);
void netsukuku_log_info (const gchar* msg);
NetsukukuHookReservation* netsukuku_coord_enter_into (NetsukukuCoord* self, gint level_of_gnode, NetsukukuNIP* nip, NetsukukuAggregatedNeighbour* neighbour_to_contact);
static GeeList* netsukuku_hook_real_list_non_saturated_levels (NetsukukuIHook* base, GError** error);
static gboolean _netsukuku_pair_lvl_number_of_free_nodes_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self);
gint netsukuku_map_route_free_nodes_nb (NetsukukuMapRoute* self, gint lvl);
GQuark netsukuku_rpc_error_quark (void);
static void netsukuku_hook_finalize (GObject* obj);


NetsukukuHookingSolution* netsukuku_hooking_solution_construct (GType object_type, NetsukukuAggregatedNeighbour* aggregated_neighbour, gint lvl, gint fn) {
	NetsukukuHookingSolution * self = NULL;
	NetsukukuAggregatedNeighbour* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (aggregated_neighbour != NULL, NULL);
	self = (NetsukukuHookingSolution*) g_object_new (object_type, NULL);
	_tmp0_ = aggregated_neighbour;
	netsukuku_hooking_solution_set_aggregated_neighbour (self, _tmp0_);
	_tmp1_ = lvl;
	netsukuku_hooking_solution_set_lvl (self, _tmp1_);
	_tmp2_ = fn;
	netsukuku_hooking_solution_set_fn (self, _tmp2_);
	return self;
}


NetsukukuHookingSolution* netsukuku_hooking_solution_new (NetsukukuAggregatedNeighbour* aggregated_neighbour, gint lvl, gint fn) {
	return netsukuku_hooking_solution_construct (NETSUKUKU_TYPE_HOOKING_SOLUTION, aggregated_neighbour, lvl, fn);
}


static gint netsukuku_hooking_solution_real_compare_to (GeeComparable* base, NetsukukuHookingSolution* b) {
	NetsukukuHookingSolution * self;
	gint result = 0;
	gint _tmp0_;
	NetsukukuHookingSolution* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	NetsukukuHookingSolution* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	NetsukukuHookingSolution* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	NetsukukuHookingSolution* _tmp10_;
	gint _tmp11_;
	self = (NetsukukuHookingSolution*) base;
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = self->priv->_lvl;
	_tmp1_ = b;
	_tmp2_ = _tmp1_->priv->_lvl;
	if (_tmp0_ > _tmp2_) {
		result = 1;
		return result;
	}
	_tmp3_ = self->priv->_lvl;
	_tmp4_ = b;
	_tmp5_ = _tmp4_->priv->_lvl;
	if (_tmp3_ < _tmp5_) {
		result = -1;
		return result;
	}
	_tmp6_ = self->priv->_fn;
	_tmp7_ = b;
	_tmp8_ = _tmp7_->priv->_fn;
	if (_tmp6_ > _tmp8_) {
		result = 1;
		return result;
	}
	_tmp9_ = self->priv->_fn;
	_tmp10_ = b;
	_tmp11_ = _tmp10_->priv->_fn;
	if (_tmp9_ < _tmp11_) {
		result = -1;
		return result;
	}
	result = 0;
	return result;
}


gchar* netsukuku_hooking_solution_to_string (NetsukukuHookingSolution* self) {
	gchar* result = NULL;
	NetsukukuAggregatedNeighbour* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gint _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gint _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_aggregated_neighbour;
	_tmp1_ = netsukuku_aggregated_neighbour_to_string (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->_fn;
	_tmp4_ = g_strdup_printf ("%i", _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->_lvl;
	_tmp7_ = g_strdup_printf ("%i", _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strconcat ("<HookingSolution: neighbour ", _tmp2_, " has ", _tmp5_, " places in level ", _tmp8_, ">", NULL);
	_tmp10_ = _tmp9_;
	_g_free0 (_tmp8_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp2_);
	result = _tmp10_;
	return result;
}


NetsukukuAggregatedNeighbour* netsukuku_hooking_solution_get_aggregated_neighbour (NetsukukuHookingSolution* self) {
	NetsukukuAggregatedNeighbour* result;
	NetsukukuAggregatedNeighbour* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_aggregated_neighbour;
	result = _tmp0_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void netsukuku_hooking_solution_set_aggregated_neighbour (NetsukukuHookingSolution* self, NetsukukuAggregatedNeighbour* value) {
	NetsukukuAggregatedNeighbour* _tmp0_;
	NetsukukuAggregatedNeighbour* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_aggregated_neighbour);
	self->priv->_aggregated_neighbour = _tmp1_;
	g_object_notify ((GObject *) self, "aggregated-neighbour");
}


gint netsukuku_hooking_solution_get_lvl (NetsukukuHookingSolution* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_lvl;
	result = _tmp0_;
	return result;
}


static void netsukuku_hooking_solution_set_lvl (NetsukukuHookingSolution* self, gint value) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_lvl = _tmp0_;
	g_object_notify ((GObject *) self, "lvl");
}


gint netsukuku_hooking_solution_get_fn (NetsukukuHookingSolution* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_fn;
	result = _tmp0_;
	return result;
}


static void netsukuku_hooking_solution_set_fn (NetsukukuHookingSolution* self, gint value) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_fn = _tmp0_;
	g_object_notify ((GObject *) self, "fn");
}


static void netsukuku_hooking_solution_class_init (NetsukukuHookingSolutionClass * klass) {
	netsukuku_hooking_solution_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (NetsukukuHookingSolutionPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_netsukuku_hooking_solution_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_netsukuku_hooking_solution_set_property;
	G_OBJECT_CLASS (klass)->finalize = netsukuku_hooking_solution_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETSUKUKU_HOOKING_SOLUTION_AGGREGATED_NEIGHBOUR, g_param_spec_object ("aggregated-neighbour", "aggregated-neighbour", "aggregated-neighbour", NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETSUKUKU_HOOKING_SOLUTION_LVL, g_param_spec_int ("lvl", "lvl", "lvl", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETSUKUKU_HOOKING_SOLUTION_FN, g_param_spec_int ("fn", "fn", "fn", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void netsukuku_hooking_solution_gee_comparable_interface_init (GeeComparableIface * iface) {
	netsukuku_hooking_solution_gee_comparable_parent_iface = g_type_interface_peek_parent (iface);
	iface->compare_to = (gint (*)(GeeComparable*, gconstpointer)) netsukuku_hooking_solution_real_compare_to;
}


static void netsukuku_hooking_solution_instance_init (NetsukukuHookingSolution * self) {
	self->priv = NETSUKUKU_HOOKING_SOLUTION_GET_PRIVATE (self);
}


static void netsukuku_hooking_solution_finalize (GObject* obj) {
	NetsukukuHookingSolution * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_HOOKING_SOLUTION, NetsukukuHookingSolution);
	_g_object_unref0 (self->priv->_aggregated_neighbour);
	G_OBJECT_CLASS (netsukuku_hooking_solution_parent_class)->finalize (obj);
}


GType netsukuku_hooking_solution_get_type (void) {
	static volatile gsize netsukuku_hooking_solution_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_hooking_solution_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuHookingSolutionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_hooking_solution_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuHookingSolution), 0, (GInstanceInitFunc) netsukuku_hooking_solution_instance_init, NULL };
		static const GInterfaceInfo gee_comparable_info = { (GInterfaceInitFunc) netsukuku_hooking_solution_gee_comparable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType netsukuku_hooking_solution_type_id;
		netsukuku_hooking_solution_type_id = g_type_register_static (G_TYPE_OBJECT, "NetsukukuHookingSolution", &g_define_type_info, 0);
		g_type_add_interface_static (netsukuku_hooking_solution_type_id, GEE_TYPE_COMPARABLE, &gee_comparable_info);
		g_once_init_leave (&netsukuku_hooking_solution_type_id__volatile, netsukuku_hooking_solution_type_id);
	}
	return netsukuku_hooking_solution_type_id__volatile;
}


static void _vala_netsukuku_hooking_solution_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	NetsukukuHookingSolution * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETSUKUKU_TYPE_HOOKING_SOLUTION, NetsukukuHookingSolution);
	switch (property_id) {
		case NETSUKUKU_HOOKING_SOLUTION_AGGREGATED_NEIGHBOUR:
		g_value_set_object (value, netsukuku_hooking_solution_get_aggregated_neighbour (self));
		break;
		case NETSUKUKU_HOOKING_SOLUTION_LVL:
		g_value_set_int (value, netsukuku_hooking_solution_get_lvl (self));
		break;
		case NETSUKUKU_HOOKING_SOLUTION_FN:
		g_value_set_int (value, netsukuku_hooking_solution_get_fn (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_netsukuku_hooking_solution_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	NetsukukuHookingSolution * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETSUKUKU_TYPE_HOOKING_SOLUTION, NetsukukuHookingSolution);
	switch (property_id) {
		case NETSUKUKU_HOOKING_SOLUTION_AGGREGATED_NEIGHBOUR:
		netsukuku_hooking_solution_set_aggregated_neighbour (self, g_value_get_object (value));
		break;
		case NETSUKUKU_HOOKING_SOLUTION_LVL:
		netsukuku_hooking_solution_set_lvl (self, g_value_get_int (value));
		break;
		case NETSUKUKU_HOOKING_SOLUTION_FN:
		netsukuku_hooking_solution_set_fn (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


NetsukukuHook* netsukuku_hook_construct (GType object_type, NetsukukuMapRoute* maproute, NetsukukuCoord* coord, NetsukukuAddressManager* addr_man) {
	NetsukukuHook * self = NULL;
	NetsukukuMapRoute* _tmp0_;
	NetsukukuMapRoute* _tmp1_;
	NetsukukuCoord* _tmp2_;
	NetsukukuCoord* _tmp3_;
	NetsukukuAddressManager* _tmp4_;
	NetsukukuAddressManager* _tmp5_;
	g_return_val_if_fail (maproute != NULL, NULL);
	g_return_val_if_fail (coord != NULL, NULL);
	g_return_val_if_fail (addr_man != NULL, NULL);
	self = (NetsukukuHook*) g_object_new (object_type, NULL);
	_tmp0_ = maproute;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->maproute);
	self->priv->maproute = _tmp1_;
	_tmp2_ = coord;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->coord);
	self->priv->coord = _tmp3_;
	_tmp4_ = addr_man;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (self->priv->addr_man);
	self->priv->addr_man = _tmp5_;
	return self;
}


NetsukukuHook* netsukuku_hook_new (NetsukukuMapRoute* maproute, NetsukukuCoord* coord, NetsukukuAddressManager* addr_man) {
	return netsukuku_hook_construct (NETSUKUKU_TYPE_HOOK, maproute, coord, addr_man);
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static gboolean netsukuku_hook_not_impl_equal_func (GObject* a, GObject* b) {
	gboolean result = FALSE;
	gchar* _tmp0_;
	gchar* astr;
	GObject* _tmp1_;
	gchar* _tmp6_;
	gchar* bstr;
	GObject* _tmp7_;
	const gchar* _tmp12_;
	const gchar* _tmp13_ = NULL;
	const gchar* _tmp14_;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_;
	_tmp0_ = g_strdup ("null");
	astr = _tmp0_;
	_tmp1_ = a;
	if (_tmp1_ != NULL) {
		GObject* _tmp2_;
		GType _tmp3_ = 0UL;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		_tmp2_ = a;
		_tmp3_ = G_TYPE_FROM_INSTANCE (_tmp2_);
		_tmp4_ = g_type_name (_tmp3_);
		_tmp5_ = g_strdup (_tmp4_);
		_g_free0 (astr);
		astr = _tmp5_;
	}
	_tmp6_ = g_strdup ("null");
	bstr = _tmp6_;
	_tmp7_ = b;
	if (_tmp7_ != NULL) {
		GObject* _tmp8_;
		GType _tmp9_ = 0UL;
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		_tmp8_ = b;
		_tmp9_ = G_TYPE_FROM_INSTANCE (_tmp8_);
		_tmp10_ = g_type_name (_tmp9_);
		_tmp11_ = g_strdup (_tmp10_);
		_g_free0 (bstr);
		bstr = _tmp11_;
	}
	_tmp12_ = astr;
	_tmp13_ = string_to_string (_tmp12_);
	_tmp14_ = bstr;
	_tmp15_ = string_to_string (_tmp14_);
	_tmp16_ = g_strconcat ("equal_func not implemented: compare between ", _tmp13_, " and ", _tmp15_, NULL);
	_tmp17_ = _tmp16_;
	g_error ("hook.vala:74: %s", _tmp17_);
	_g_free0 (_tmp17_);
	_g_free0 (bstr);
	_g_free0 (astr);
	return result;
}


static gint netsukuku_hook_reverse_compare (NetsukukuHookingSolution* a, NetsukukuHookingSolution* b) {
	gint result = 0;
	NetsukukuHookingSolution* _tmp0_;
	NetsukukuHookingSolution* _tmp1_;
	gint _tmp2_ = 0;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = a;
	_tmp1_ = b;
	_tmp2_ = gee_comparable_compare_to ((GeeComparable*) _tmp0_, _tmp1_);
	result = -_tmp2_;
	return result;
}


/** The method returns a new valid address.
          * It could be in the current network or in another network.
          * We try to hook among the given neighbours.
          */
static gboolean _netsukuku_hook_not_impl_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gboolean result;
	result = netsukuku_hook_not_impl_equal_func (a, b);
	return result;
}


static gint _netsukuku_hook_reverse_compare_gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gint result;
	result = netsukuku_hook_reverse_compare (a, b);
	return result;
}


NetsukukuHookReservation* netsukuku_hook_hook (NetsukukuHook* self, GeeList* neighbour_list, GError** error) {
	NetsukukuHookReservation* result = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* hfn;
	gboolean has_someone_responded;
	gboolean _tmp43_;
	GeeArrayList* _tmp45_;
	gint _tmp46_;
	gint _tmp47_;
	GeeArrayList* _tmp75_;
	GError* _tmp125_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (neighbour_list != NULL, NULL);
	_tmp0_ = gee_array_list_new (NETSUKUKU_TYPE_HOOKING_SOLUTION, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_hook_not_impl_equal_func_gee_equal_data_func, NULL, NULL);
	hfn = _tmp0_;
	has_someone_responded = FALSE;
	{
		GeeList* _tmp1_;
		GeeList* _tmp2_;
		GeeList* _aggregated_neighbour_list;
		GeeList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _aggregated_neighbour_size;
		gint _aggregated_neighbour_index;
		_tmp1_ = neighbour_list;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		_aggregated_neighbour_list = _tmp2_;
		_tmp3_ = _aggregated_neighbour_list;
		_tmp4_ = gee_collection_get_size ((GeeCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_aggregated_neighbour_size = _tmp5_;
		_aggregated_neighbour_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			GeeList* _tmp9_;
			gint _tmp10_;
			gpointer _tmp11_ = NULL;
			NetsukukuAggregatedNeighbour* aggregated_neighbour;
			_tmp6_ = _aggregated_neighbour_index;
			_aggregated_neighbour_index = _tmp6_ + 1;
			_tmp7_ = _aggregated_neighbour_index;
			_tmp8_ = _aggregated_neighbour_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _aggregated_neighbour_list;
			_tmp10_ = _aggregated_neighbour_index;
			_tmp11_ = gee_list_get (_tmp9_, _tmp10_);
			aggregated_neighbour = (NetsukukuAggregatedNeighbour*) _tmp11_;
			{
				NetsukukuAggregatedNeighbour* _tmp12_;
				NetsukukuNIP* _tmp13_;
				NetsukukuNIP* _tmp14_;
				NetsukukuNIP* nrnip;
				NetsukukuAggregatedNeighbour* _tmp15_;
				Netsukukufake_AggregatedNeighbour* _tmp16_;
				Netsukukufake_AggregatedNeighbour* _tmp17_;
				GeeList* _tmp18_ = NULL;
				GeeList* resp;
				_tmp12_ = aggregated_neighbour;
				_tmp13_ = _tmp12_->nip;
				_tmp14_ = _g_object_ref0 (_tmp13_);
				nrnip = _tmp14_;
				_tmp15_ = aggregated_neighbour;
				_tmp16_ = _tmp15_->neighbour_client;
				_tmp17_ = _tmp16_->hook;
				_tmp18_ = netsukuku_fake_aggregatedneighbour_list_non_saturated_levels (_tmp17_);
				resp = _tmp18_;
				has_someone_responded = TRUE;
				{
					GeeList* _tmp19_;
					GeeList* _tmp20_;
					GeeList* _el_list;
					GeeList* _tmp21_;
					gint _tmp22_;
					gint _tmp23_;
					gint _el_size;
					gint _el_index;
					_tmp19_ = resp;
					_tmp20_ = _g_object_ref0 (_tmp19_);
					_el_list = _tmp20_;
					_tmp21_ = _el_list;
					_tmp22_ = gee_collection_get_size ((GeeCollection*) _tmp21_);
					_tmp23_ = _tmp22_;
					_el_size = _tmp23_;
					_el_index = -1;
					while (TRUE) {
						gint _tmp24_;
						gint _tmp25_;
						gint _tmp26_;
						GeeList* _tmp27_;
						gint _tmp28_;
						gpointer _tmp29_ = NULL;
						NetsukukuPairLvlNumberOfFreeNodes* el;
						GeeArrayList* _tmp30_;
						NetsukukuAggregatedNeighbour* _tmp31_;
						NetsukukuPairLvlNumberOfFreeNodes* _tmp32_;
						gint _tmp33_;
						NetsukukuPairLvlNumberOfFreeNodes* _tmp34_;
						gint _tmp35_;
						NetsukukuHookingSolution* _tmp36_;
						NetsukukuHookingSolution* _tmp37_;
						_tmp24_ = _el_index;
						_el_index = _tmp24_ + 1;
						_tmp25_ = _el_index;
						_tmp26_ = _el_size;
						if (!(_tmp25_ < _tmp26_)) {
							break;
						}
						_tmp27_ = _el_list;
						_tmp28_ = _el_index;
						_tmp29_ = gee_list_get (_tmp27_, _tmp28_);
						el = (NetsukukuPairLvlNumberOfFreeNodes*) _tmp29_;
						_tmp30_ = hfn;
						_tmp31_ = aggregated_neighbour;
						_tmp32_ = el;
						_tmp33_ = _tmp32_->lvl;
						_tmp34_ = el;
						_tmp35_ = _tmp34_->number_of_free_nodes;
						_tmp36_ = netsukuku_hooking_solution_new (_tmp31_, _tmp33_, _tmp35_);
						_tmp37_ = _tmp36_;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp30_, _tmp37_);
						_g_object_unref0 (_tmp37_);
						_g_object_unref0 (el);
					}
					_g_object_unref0 (_el_list);
				}
				_g_object_unref0 (resp);
				_g_object_unref0 (nrnip);
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* e = NULL;
				GError* _tmp38_;
				const gchar* _tmp39_;
				const gchar* _tmp40_ = NULL;
				gchar* _tmp41_ = NULL;
				gchar* _tmp42_;
				e = _inner_error_;
				_inner_error_ = NULL;
				_tmp38_ = e;
				_tmp39_ = _tmp38_->message;
				_tmp40_ = string_to_string (_tmp39_);
				_tmp41_ = g_strconcat ("Exception trying to get list_non_saturated_levels from a neighbour. ", _tmp40_, NULL);
				_tmp42_ = _tmp41_;
				netsukuku_log_debug (_tmp42_);
				_g_free0 (_tmp42_);
				_g_error_free0 (e);
			}
			__finally0:
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == NETSUKUKU_HOOKING_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (aggregated_neighbour);
					_g_object_unref0 (_aggregated_neighbour_list);
					_g_object_unref0 (hfn);
					return NULL;
				} else {
					_g_object_unref0 (aggregated_neighbour);
					_g_object_unref0 (_aggregated_neighbour_list);
					_g_object_unref0 (hfn);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_g_object_unref0 (aggregated_neighbour);
		}
		_g_object_unref0 (_aggregated_neighbour_list);
	}
	_tmp43_ = has_someone_responded;
	if (!_tmp43_) {
		GError* _tmp44_;
		_tmp44_ = g_error_new_literal (NETSUKUKU_HOOKING_ERROR, NETSUKUKU_HOOKING_ERROR_GENERIC, "False network collision was detected.");
		_inner_error_ = _tmp44_;
		if (_inner_error_->domain == NETSUKUKU_HOOKING_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (hfn);
			return NULL;
		} else {
			_g_object_unref0 (hfn);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp45_ = hfn;
	_tmp46_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp45_);
	_tmp47_ = _tmp46_;
	if (_tmp47_ == 0) {
		gchar* _tmp48_;
		gchar* str_records;
		const gchar* _tmp67_;
		gchar* _tmp68_;
		const gchar* _tmp69_;
		const gchar* _tmp70_ = NULL;
		gchar* _tmp71_ = NULL;
		gchar* _tmp72_;
		GError* _tmp73_;
		GError* _tmp74_;
		_tmp48_ = g_strdup ("[");
		str_records = _tmp48_;
		{
			GeeList* _tmp49_;
			GeeList* _tmp50_;
			GeeList* _aggregated_neighbour_list;
			GeeList* _tmp51_;
			gint _tmp52_;
			gint _tmp53_;
			gint _aggregated_neighbour_size;
			gint _aggregated_neighbour_index;
			_tmp49_ = neighbour_list;
			_tmp50_ = _g_object_ref0 (_tmp49_);
			_aggregated_neighbour_list = _tmp50_;
			_tmp51_ = _aggregated_neighbour_list;
			_tmp52_ = gee_collection_get_size ((GeeCollection*) _tmp51_);
			_tmp53_ = _tmp52_;
			_aggregated_neighbour_size = _tmp53_;
			_aggregated_neighbour_index = -1;
			while (TRUE) {
				gint _tmp54_;
				gint _tmp55_;
				gint _tmp56_;
				GeeList* _tmp57_;
				gint _tmp58_;
				gpointer _tmp59_ = NULL;
				NetsukukuAggregatedNeighbour* aggregated_neighbour;
				const gchar* _tmp60_;
				NetsukukuAggregatedNeighbour* _tmp61_;
				gchar* _tmp62_ = NULL;
				gchar* _tmp63_;
				gchar* _tmp64_ = NULL;
				gchar* _tmp65_;
				gchar* _tmp66_;
				_tmp54_ = _aggregated_neighbour_index;
				_aggregated_neighbour_index = _tmp54_ + 1;
				_tmp55_ = _aggregated_neighbour_index;
				_tmp56_ = _aggregated_neighbour_size;
				if (!(_tmp55_ < _tmp56_)) {
					break;
				}
				_tmp57_ = _aggregated_neighbour_list;
				_tmp58_ = _aggregated_neighbour_index;
				_tmp59_ = gee_list_get (_tmp57_, _tmp58_);
				aggregated_neighbour = (NetsukukuAggregatedNeighbour*) _tmp59_;
				_tmp60_ = str_records;
				_tmp61_ = aggregated_neighbour;
				_tmp62_ = netsukuku_aggregated_neighbour_to_string (_tmp61_);
				_tmp63_ = _tmp62_;
				_tmp64_ = g_strconcat (_tmp63_, ",", NULL);
				_tmp65_ = _tmp64_;
				_tmp66_ = g_strconcat (_tmp60_, _tmp65_, NULL);
				_g_free0 (str_records);
				str_records = _tmp66_;
				_g_free0 (_tmp65_);
				_g_free0 (_tmp63_);
				_g_object_unref0 (aggregated_neighbour);
			}
			_g_object_unref0 (_aggregated_neighbour_list);
		}
		_tmp67_ = str_records;
		_tmp68_ = g_strconcat (_tmp67_, "]", NULL);
		_g_free0 (str_records);
		str_records = _tmp68_;
		_tmp69_ = str_records;
		_tmp70_ = string_to_string (_tmp69_);
		_tmp71_ = g_strconcat ("This network portion is full: ", _tmp70_, NULL);
		_tmp72_ = _tmp71_;
		_tmp73_ = g_error_new_literal (NETSUKUKU_HOOKING_ERROR, NETSUKUKU_HOOKING_ERROR_GENERIC, _tmp72_);
		_tmp74_ = _tmp73_;
		_g_free0 (_tmp72_);
		_inner_error_ = _tmp74_;
		if (_inner_error_->domain == NETSUKUKU_HOOKING_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (str_records);
			_g_object_unref0 (hfn);
			return NULL;
		} else {
			_g_free0 (str_records);
			_g_object_unref0 (hfn);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_free0 (str_records);
	}
	_tmp75_ = hfn;
	gee_list_sort ((GeeList*) _tmp75_, _netsukuku_hook_reverse_compare_gcompare_data_func, NULL, NULL);
	{
		GeeArrayList* _tmp76_;
		GeeArrayList* _tmp77_;
		GeeArrayList* _hs_list;
		GeeArrayList* _tmp78_;
		gint _tmp79_;
		gint _tmp80_;
		gint _hs_size;
		gint _hs_index;
		_tmp76_ = hfn;
		_tmp77_ = _g_object_ref0 (_tmp76_);
		_hs_list = _tmp77_;
		_tmp78_ = _hs_list;
		_tmp79_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp78_);
		_tmp80_ = _tmp79_;
		_hs_size = _tmp80_;
		_hs_index = -1;
		while (TRUE) {
			gint _tmp81_;
			gint _tmp82_;
			gint _tmp83_;
			GeeArrayList* _tmp84_;
			gint _tmp85_;
			gpointer _tmp86_ = NULL;
			NetsukukuHookingSolution* hs;
			NetsukukuHookingSolution* _tmp87_;
			NetsukukuAggregatedNeighbour* _tmp88_;
			NetsukukuAggregatedNeighbour* _tmp89_;
			NetsukukuAggregatedNeighbour* _tmp90_;
			NetsukukuAggregatedNeighbour* neighbour_to_contact;
			NetsukukuAggregatedNeighbour* _tmp91_;
			NetsukukuNIP* _tmp92_;
			NetsukukuNIP* _tmp93_;
			NetsukukuNIP* nip;
			NetsukukuHookingSolution* _tmp94_;
			gint _tmp95_;
			gint _tmp96_;
			gint level_of_nodes;
			gint _tmp97_;
			gint level_of_gnode;
			NetsukukuNIP* _tmp98_;
			gint _tmp99_;
			NetsukukuPartialNIP* _tmp100_ = NULL;
			NetsukukuPartialNIP* partial_nip;
			NetsukukuPartialNIP* _tmp101_;
			gchar* _tmp102_ = NULL;
			gchar* _tmp103_;
			NetsukukuAggregatedNeighbour* _tmp104_;
			gchar* _tmp105_ = NULL;
			gchar* _tmp106_;
			gchar* _tmp107_ = NULL;
			gchar* _tmp108_;
			NetsukukuCoord* _tmp109_;
			gint _tmp110_;
			NetsukukuNIP* _tmp111_;
			NetsukukuAggregatedNeighbour* _tmp112_;
			NetsukukuHookReservation* _tmp113_ = NULL;
			NetsukukuHookReservation* hook_reservation;
			NetsukukuHookReservation* _tmp114_;
			NetsukukuPartialNIP* _tmp120_;
			gchar* _tmp121_ = NULL;
			gchar* _tmp122_;
			gchar* _tmp123_ = NULL;
			gchar* _tmp124_;
			_tmp81_ = _hs_index;
			_hs_index = _tmp81_ + 1;
			_tmp82_ = _hs_index;
			_tmp83_ = _hs_size;
			if (!(_tmp82_ < _tmp83_)) {
				break;
			}
			_tmp84_ = _hs_list;
			_tmp85_ = _hs_index;
			_tmp86_ = gee_abstract_list_get ((GeeAbstractList*) _tmp84_, _tmp85_);
			hs = (NetsukukuHookingSolution*) _tmp86_;
			_tmp87_ = hs;
			_tmp88_ = netsukuku_hooking_solution_get_aggregated_neighbour (_tmp87_);
			_tmp89_ = _tmp88_;
			_tmp90_ = _g_object_ref0 (_tmp89_);
			neighbour_to_contact = _tmp90_;
			_tmp91_ = neighbour_to_contact;
			_tmp92_ = _tmp91_->nip;
			_tmp93_ = _g_object_ref0 (_tmp92_);
			nip = _tmp93_;
			_tmp94_ = hs;
			_tmp95_ = netsukuku_hooking_solution_get_lvl (_tmp94_);
			_tmp96_ = _tmp95_;
			level_of_nodes = _tmp96_;
			_tmp97_ = level_of_nodes;
			level_of_gnode = _tmp97_ + 1;
			_tmp98_ = nip;
			_tmp99_ = level_of_gnode;
			_tmp100_ = netsukuku_partial_nip_get_gnode_at_level ((NetsukukuPartialNIP*) _tmp98_, _tmp99_);
			partial_nip = _tmp100_;
			_tmp101_ = partial_nip;
			_tmp102_ = netsukuku_partial_nip_to_string (_tmp101_);
			_tmp103_ = _tmp102_;
			_tmp104_ = neighbour_to_contact;
			_tmp105_ = netsukuku_aggregated_neighbour_to_string (_tmp104_);
			_tmp106_ = _tmp105_;
			_tmp107_ = g_strconcat ("Hook: try entering gnode ", _tmp103_, " via ", _tmp106_, NULL);
			_tmp108_ = _tmp107_;
			netsukuku_log_info (_tmp108_);
			_g_free0 (_tmp108_);
			_g_free0 (_tmp106_);
			_g_free0 (_tmp103_);
			_tmp109_ = self->priv->coord;
			_tmp110_ = level_of_gnode;
			_tmp111_ = nip;
			_tmp112_ = neighbour_to_contact;
			_tmp113_ = netsukuku_coord_enter_into (_tmp109_, _tmp110_, _tmp111_, _tmp112_);
			hook_reservation = _tmp113_;
			_tmp114_ = hook_reservation;
			if (_tmp114_ != NULL) {
				NetsukukuPartialNIP* _tmp115_;
				gchar* _tmp116_ = NULL;
				gchar* _tmp117_;
				gchar* _tmp118_ = NULL;
				gchar* _tmp119_;
				_tmp115_ = partial_nip;
				_tmp116_ = netsukuku_partial_nip_to_string (_tmp115_);
				_tmp117_ = _tmp116_;
				_tmp118_ = g_strconcat ("Hooking to ", _tmp117_, " succeded", NULL);
				_tmp119_ = _tmp118_;
				netsukuku_log_info (_tmp119_);
				_g_free0 (_tmp119_);
				_g_free0 (_tmp117_);
				result = hook_reservation;
				_g_object_unref0 (partial_nip);
				_g_object_unref0 (nip);
				_g_object_unref0 (neighbour_to_contact);
				_g_object_unref0 (hs);
				_g_object_unref0 (_hs_list);
				_g_object_unref0 (hfn);
				return result;
			}
			_tmp120_ = partial_nip;
			_tmp121_ = netsukuku_partial_nip_to_string (_tmp120_);
			_tmp122_ = _tmp121_;
			_tmp123_ = g_strconcat ("Hooking to ", _tmp122_, " failed.", NULL);
			_tmp124_ = _tmp123_;
			netsukuku_log_info (_tmp124_);
			_g_free0 (_tmp124_);
			_g_free0 (_tmp122_);
			_g_object_unref0 (hook_reservation);
			_g_object_unref0 (partial_nip);
			_g_object_unref0 (nip);
			_g_object_unref0 (neighbour_to_contact);
			_g_object_unref0 (hs);
		}
		_g_object_unref0 (_hs_list);
	}
	_tmp125_ = g_error_new_literal (NETSUKUKU_HOOKING_ERROR, NETSUKUKU_HOOKING_ERROR_GENERIC, "No good hooking solution.");
	_inner_error_ = _tmp125_;
	if (_inner_error_->domain == NETSUKUKU_HOOKING_ERROR) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (hfn);
		return NULL;
	} else {
		_g_object_unref0 (hfn);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_object_unref0 (hfn);
}


/** Returns a list of (lvl, number_of_free_nodes_at_lvl)
          */
static gboolean _netsukuku_pair_lvl_number_of_free_nodes_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gboolean result;
	result = netsukuku_pair_lvl_number_of_free_nodes_equal_func (a, b);
	return result;
}


static GeeList* netsukuku_hook_real_list_non_saturated_levels (NetsukukuIHook* base, GError** error) {
	NetsukukuHook * self;
	GeeList* result = NULL;
	GeeArrayList* _tmp0_;
	GeeList* ret;
	NetsukukuAddressManager* _tmp1_;
	gboolean _tmp2_;
	gchar* _tmp18_;
	gchar* str_ret;
	const gchar* _tmp37_;
	gchar* _tmp38_;
	const gchar* _tmp39_;
	const gchar* _tmp40_ = NULL;
	gchar* _tmp41_ = NULL;
	gchar* _tmp42_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuHook*) base;
	_tmp0_ = gee_array_list_new (NETSUKUKU_TYPE_PAIR_LVL_NUMBER_OF_FREE_NODES, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_pair_lvl_number_of_free_nodes_equal_func_gee_equal_data_func, NULL, NULL);
	ret = (GeeList*) _tmp0_;
	_tmp1_ = self->priv->addr_man;
	_tmp2_ = _tmp1_->is_mature;
	if (!_tmp2_) {
		result = ret;
		return result;
	}
	{
		NetsukukuMapRoute* _tmp3_;
		gint _tmp4_;
		gint lvl;
		_tmp3_ = self->priv->maproute;
		_tmp4_ = _tmp3_->levels;
		lvl = _tmp4_ - 1;
		{
			gboolean _tmp5_;
			_tmp5_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_;
				gint _tmp8_;
				_tmp6_ = _tmp5_;
				if (!_tmp6_) {
					gint _tmp7_;
					_tmp7_ = lvl;
					lvl = _tmp7_ - 1;
				}
				_tmp5_ = FALSE;
				_tmp8_ = lvl;
				if (!(_tmp8_ >= 0)) {
					break;
				}
				{
					NetsukukuMapRoute* _tmp9_;
					gint _tmp10_;
					gint _tmp11_ = 0;
					gint fn;
					gint _tmp12_;
					_tmp9_ = self->priv->maproute;
					_tmp10_ = lvl;
					_tmp11_ = netsukuku_map_route_free_nodes_nb (_tmp9_, _tmp10_);
					fn = _tmp11_;
					_tmp12_ = fn;
					if (_tmp12_ > 0) {
						GeeList* _tmp13_;
						gint _tmp14_;
						gint _tmp15_;
						NetsukukuPairLvlNumberOfFreeNodes* _tmp16_;
						NetsukukuPairLvlNumberOfFreeNodes* _tmp17_;
						_tmp13_ = ret;
						_tmp14_ = lvl;
						_tmp15_ = fn;
						_tmp16_ = netsukuku_pair_lvl_number_of_free_nodes_new (_tmp14_, _tmp15_);
						_tmp17_ = _tmp16_;
						gee_collection_add ((GeeCollection*) _tmp13_, _tmp17_);
						_g_object_unref0 (_tmp17_);
					}
				}
				goto __finally1;
				__catch1_netsukuku_rpc_error:
				{
					GError* e = NULL;
					e = _inner_error_;
					_inner_error_ = NULL;
					g_error ("hook.vala:156: %s", "shoud never happen when we call locally");
					_g_error_free0 (e);
				}
				__finally1:
				if (_inner_error_ != NULL) {
					_g_object_unref0 (ret);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
		}
	}
	_tmp18_ = g_strdup ("[");
	str_ret = _tmp18_;
	{
		GeeList* _tmp19_;
		GeeList* _tmp20_;
		GeeList* _el_list;
		GeeList* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gint _el_size;
		gint _el_index;
		_tmp19_ = ret;
		_tmp20_ = _g_object_ref0 (_tmp19_);
		_el_list = _tmp20_;
		_tmp21_ = _el_list;
		_tmp22_ = gee_collection_get_size ((GeeCollection*) _tmp21_);
		_tmp23_ = _tmp22_;
		_el_size = _tmp23_;
		_el_index = -1;
		while (TRUE) {
			gint _tmp24_;
			gint _tmp25_;
			gint _tmp26_;
			GeeList* _tmp27_;
			gint _tmp28_;
			gpointer _tmp29_ = NULL;
			NetsukukuPairLvlNumberOfFreeNodes* el;
			const gchar* _tmp30_;
			NetsukukuPairLvlNumberOfFreeNodes* _tmp31_;
			gchar* _tmp32_ = NULL;
			gchar* _tmp33_;
			gchar* _tmp34_ = NULL;
			gchar* _tmp35_;
			gchar* _tmp36_;
			_tmp24_ = _el_index;
			_el_index = _tmp24_ + 1;
			_tmp25_ = _el_index;
			_tmp26_ = _el_size;
			if (!(_tmp25_ < _tmp26_)) {
				break;
			}
			_tmp27_ = _el_list;
			_tmp28_ = _el_index;
			_tmp29_ = gee_list_get (_tmp27_, _tmp28_);
			el = (NetsukukuPairLvlNumberOfFreeNodes*) _tmp29_;
			_tmp30_ = str_ret;
			_tmp31_ = el;
			_tmp32_ = netsukuku_pair_lvl_number_of_free_nodes_to_string (_tmp31_);
			_tmp33_ = _tmp32_;
			_tmp34_ = g_strconcat (_tmp33_, ", ", NULL);
			_tmp35_ = _tmp34_;
			_tmp36_ = g_strconcat (_tmp30_, _tmp35_, NULL);
			_g_free0 (str_ret);
			str_ret = _tmp36_;
			_g_free0 (_tmp35_);
			_g_free0 (_tmp33_);
			_g_object_unref0 (el);
		}
		_g_object_unref0 (_el_list);
	}
	_tmp37_ = str_ret;
	_tmp38_ = g_strconcat (_tmp37_, "]", NULL);
	_g_free0 (str_ret);
	str_ret = _tmp38_;
	_tmp39_ = str_ret;
	_tmp40_ = string_to_string (_tmp39_);
	_tmp41_ = g_strconcat ("list_non_saturated_levels: returning ", _tmp40_, NULL);
	_tmp42_ = _tmp41_;
	netsukuku_log_debug (_tmp42_);
	_g_free0 (_tmp42_);
	result = ret;
	_g_free0 (str_ret);
	return result;
}


static void netsukuku_hook_class_init (NetsukukuHookClass * klass) {
	netsukuku_hook_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (NetsukukuHookPrivate));
	G_OBJECT_CLASS (klass)->finalize = netsukuku_hook_finalize;
}


static void netsukuku_hook_netsukuku_ihook_interface_init (NetsukukuIHookIface * iface) {
	netsukuku_hook_netsukuku_ihook_parent_iface = g_type_interface_peek_parent (iface);
	iface->list_non_saturated_levels = (GeeList* (*)(NetsukukuIHook*, GError**)) netsukuku_hook_real_list_non_saturated_levels;
}


static void netsukuku_hook_instance_init (NetsukukuHook * self) {
	self->priv = NETSUKUKU_HOOK_GET_PRIVATE (self);
}


static void netsukuku_hook_finalize (GObject* obj) {
	NetsukukuHook * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_HOOK, NetsukukuHook);
	_g_object_unref0 (self->priv->maproute);
	_g_object_unref0 (self->priv->coord);
	_g_object_unref0 (self->priv->addr_man);
	G_OBJECT_CLASS (netsukuku_hook_parent_class)->finalize (obj);
}


/** Class Hook
      *
      */
GType netsukuku_hook_get_type (void) {
	static volatile gsize netsukuku_hook_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_hook_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuHookClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_hook_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuHook), 0, (GInstanceInitFunc) netsukuku_hook_instance_init, NULL };
		static const GInterfaceInfo netsukuku_ihook_info = { (GInterfaceInitFunc) netsukuku_hook_netsukuku_ihook_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType netsukuku_hook_type_id;
		netsukuku_hook_type_id = g_type_register_static (G_TYPE_OBJECT, "NetsukukuHook", &g_define_type_info, 0);
		g_type_add_interface_static (netsukuku_hook_type_id, NETSUKUKU_TYPE_IHOOK, &netsukuku_ihook_info);
		g_once_init_leave (&netsukuku_hook_type_id__volatile, netsukuku_hook_type_id);
	}
	return netsukuku_hook_type_id__volatile;
}



