/*
 *  This file is part of Netsukuku.
 *  (c) Copyright 2011-2014 Luca Dionisi aka lukisi <luca.dionisi@gmail.com>
 *
 *  Netsukuku is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Netsukuku is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Netsukuku.  If not, see <http://www.gnu.org/licenses/>.
 */

using Gee;

namespace Netsukuku
{
    namespace AndnaUtilities
    {
        public NIP
        key_to_hashnode_converter
        (AndnaServiceHashnodeKey key,
         int levels,
         int gsize)
        {
            // NOTE: Given a key, a value for levels and a value for gsize, this
            // function should compute the same NIP in any platform
            // and any architecture.
            uint hash = @"$(key.hashed_domain)_$(key.spread_num)".hash();
            int[] positions = new int[levels];
            for (int lvl = 0; lvl < levels; lvl++)
            {
                uint pos = hash % gsize;
                positions[lvl] = (int)pos;
                hash /= gsize;
            }
            NIP ret = new NIP(positions);
            log_debug(@"AndnaUtilities: hash: '$(key.hashed_domain)" +
                      @"_$(key.spread_num)' becomes $(ret)");
            return ret;
        }

        public string crypto_hash(string hostname)
        {
            // We want a domain name system that is case-insensitive.
            string ci_hname = hostname.up();
            // We want the hashnode not to know much about an hostname.
            // MD5 will output 128 bit = 16 octets.
            uint8[] hash = Crypto.md5(ci_hname.data);
            // We would like a printable sequence.
            // Base64 tranforms 16 octets in 22 character plus padding.
            string ret = Base64.encode((uchar[])hash).substring(0, 22);
            log_debug(@"AndnaUtilities.crypto_hash: $(hostname) becomes $(ret)");
            return ret;
        }
    }
}

