/* rpc_interfaces.c generated by valac 0.20.1, the Vala compiler
 * generated from rpc_interfaces.vala, do not modify */

/*
 *  This file is part of Netsukuku.
 *  (c) Copyright 2014 Luca Dionisi aka lukisi <luca.dionisi@gmail.com>
 *
 *  Netsukuku is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Netsukuku is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Netsukuku.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <zcd.h>
#include <stdlib.h>
#include <string.h>
#include <netsukuku-rpc.h>
#include <gee.h>


#define ANDNS_TYPE_ANDNA_QUERY (andns_andna_query_get_type ())
#define ANDNS_ANDNA_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ANDNS_TYPE_ANDNA_QUERY, AndnsAndnaQuery))
#define ANDNS_ANDNA_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ANDNS_TYPE_ANDNA_QUERY, AndnsAndnaQueryClass))
#define ANDNS_IS_ANDNA_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ANDNS_TYPE_ANDNA_QUERY))
#define ANDNS_IS_ANDNA_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ANDNS_TYPE_ANDNA_QUERY))
#define ANDNS_ANDNA_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ANDNS_TYPE_ANDNA_QUERY, AndnsAndnaQueryClass))

typedef struct _AndnsAndnaQuery AndnsAndnaQuery;
typedef struct _AndnsAndnaQueryClass AndnsAndnaQueryClass;

#define ANDNS_TYPE_ANDNA_RESPONSE (andns_andna_response_get_type ())
#define ANDNS_ANDNA_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ANDNS_TYPE_ANDNA_RESPONSE, AndnsAndnaResponse))
#define ANDNS_ANDNA_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ANDNS_TYPE_ANDNA_RESPONSE, AndnsAndnaResponseClass))
#define ANDNS_IS_ANDNA_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ANDNS_TYPE_ANDNA_RESPONSE))
#define ANDNS_IS_ANDNA_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ANDNS_TYPE_ANDNA_RESPONSE))
#define ANDNS_ANDNA_RESPONSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ANDNS_TYPE_ANDNA_RESPONSE, AndnsAndnaResponseClass))

typedef struct _AndnsAndnaResponse AndnsAndnaResponse;
typedef struct _AndnsAndnaResponseClass AndnsAndnaResponseClass;

#define ANDNS_TYPE_ANDNA_RESPONSE_ANSWER (andns_andna_response_answer_get_type ())
#define ANDNS_ANDNA_RESPONSE_ANSWER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ANDNS_TYPE_ANDNA_RESPONSE_ANSWER, AndnsAndnaResponseAnswer))
#define ANDNS_ANDNA_RESPONSE_ANSWER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ANDNS_TYPE_ANDNA_RESPONSE_ANSWER, AndnsAndnaResponseAnswerClass))
#define ANDNS_IS_ANDNA_RESPONSE_ANSWER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ANDNS_TYPE_ANDNA_RESPONSE_ANSWER))
#define ANDNS_IS_ANDNA_RESPONSE_ANSWER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ANDNS_TYPE_ANDNA_RESPONSE_ANSWER))
#define ANDNS_ANDNA_RESPONSE_ANSWER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ANDNS_TYPE_ANDNA_RESPONSE_ANSWER, AndnsAndnaResponseAnswerClass))

typedef struct _AndnsAndnaResponseAnswer AndnsAndnaResponseAnswer;
typedef struct _AndnsAndnaResponseAnswerClass AndnsAndnaResponseAnswerClass;

#define ANDNS_TYPE_IANDNA_RESOLVE_ROOT_DISPATCHER (andns_iandna_resolve_root_dispatcher_get_type ())
#define ANDNS_IANDNA_RESOLVE_ROOT_DISPATCHER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ANDNS_TYPE_IANDNA_RESOLVE_ROOT_DISPATCHER, AndnsIAndnaResolveRootDispatcher))
#define ANDNS_IS_IANDNA_RESOLVE_ROOT_DISPATCHER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ANDNS_TYPE_IANDNA_RESOLVE_ROOT_DISPATCHER))
#define ANDNS_IANDNA_RESOLVE_ROOT_DISPATCHER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), ANDNS_TYPE_IANDNA_RESOLVE_ROOT_DISPATCHER, AndnsIAndnaResolveRootDispatcherIface))

typedef struct _AndnsIAndnaResolveRootDispatcher AndnsIAndnaResolveRootDispatcher;
typedef struct _AndnsIAndnaResolveRootDispatcherIface AndnsIAndnaResolveRootDispatcherIface;

#define ANDNS_TYPE_IANDNA_QUERY_HANDLER (andns_iandna_query_handler_get_type ())
#define ANDNS_IANDNA_QUERY_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ANDNS_TYPE_IANDNA_QUERY_HANDLER, AndnsIAndnaQueryHandler))
#define ANDNS_IS_IANDNA_QUERY_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ANDNS_TYPE_IANDNA_QUERY_HANDLER))
#define ANDNS_IANDNA_QUERY_HANDLER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), ANDNS_TYPE_IANDNA_QUERY_HANDLER, AndnsIAndnaQueryHandlerIface))

typedef struct _AndnsIAndnaQueryHandler AndnsIAndnaQueryHandler;
typedef struct _AndnsIAndnaQueryHandlerIface AndnsIAndnaQueryHandlerIface;

#define ANDNS_TYPE_ANDNA_QUERY_TYPE (andns_andna_query_type_get_type ())

#define ANDNS_TYPE_ANDNA_QUERY_PROTOCOL (andns_andna_query_protocol_get_type ())

#define ANDNS_TYPE_ANDNA_QUERY_IP_VERSION (andns_andna_query_ip_version_get_type ())

#define ANDNS_TYPE_ANDNA_QUERY_REALM (andns_andna_query_realm_get_type ())

#define ANDNS_TYPE_ANDNA_RESPONSE_CODE (andns_andna_response_code_get_type ())
typedef struct _AndnsAndnaQueryPrivate AndnsAndnaQueryPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _AndnsAndnaResponsePrivate AndnsAndnaResponsePrivate;
typedef struct _AndnsAndnaResponseAnswerPrivate AndnsAndnaResponseAnswerPrivate;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _AndnsIAndnaQueryHandlerIface {
	GTypeInterface parent_iface;
	AndnsAndnaResponse* (*resolve) (AndnsIAndnaQueryHandler* self, AndnsAndnaQuery* query, GError** error);
};

struct _AndnsIAndnaResolveRootDispatcherIface {
	GTypeInterface parent_iface;
	AndnsIAndnaQueryHandler* (*get_query_handler) (AndnsIAndnaResolveRootDispatcher* self, gint request_id);
};

typedef enum  {
	ANDNS_ANDNA_QUERY_TYPE_NAME_TO_IP = 0,
	ANDNS_ANDNA_QUERY_TYPE_IP_TO_NAME = 1,
	ANDNS_ANDNA_QUERY_TYPE_GLOBAL = 2
} AndnsAndnaQueryType;

typedef enum  {
	ANDNS_ANDNA_QUERY_PROTOCOL_TCP = 0,
	ANDNS_ANDNA_QUERY_PROTOCOL_UDP = 1
} AndnsAndnaQueryProtocol;

typedef enum  {
	ANDNS_ANDNA_QUERY_IP_VERSION_IPV4 = 0,
	ANDNS_ANDNA_QUERY_IP_VERSION_IPV6 = 1
} AndnsAndnaQueryIPVersion;

typedef enum  {
	ANDNS_ANDNA_QUERY_REALM_NTK = 1,
	ANDNS_ANDNA_QUERY_REALM_INT = 2
} AndnsAndnaQueryRealm;

typedef enum  {
	ANDNS_ANDNA_RESPONSE_CODE_NO_ERROR = 0,
	ANDNS_ANDNA_RESPONSE_CODE_MALFORMED = 1,
	ANDNS_ANDNA_RESPONSE_CODE_SERV_FAIL = 2,
	ANDNS_ANDNA_RESPONSE_CODE_NO_DOMAIN = 3,
	ANDNS_ANDNA_RESPONSE_CODE_NOT_IMPL = 4,
	ANDNS_ANDNA_RESPONSE_CODE_REFUSED = 5
} AndnsAndnaResponseCode;

struct _AndnsAndnaQuery {
	GObject parent_instance;
	AndnsAndnaQueryPrivate * priv;
	guint8 ipv4_ip[4];
	guint8 ipv6_ip[16];
};

struct _AndnsAndnaQueryClass {
	GObjectClass parent_class;
};

struct _AndnsAndnaQueryPrivate {
	AndnsAndnaQueryType _query_type;
	gboolean _recursion;
	gboolean _compression;
	AndnsAndnaQueryProtocol _protocol;
	AndnsAndnaQueryIPVersion _ip_version;
	AndnsAndnaQueryRealm _ip_realm;
	gchar* _hashed_domain;
	NetsukukuAndnaServiceKey* _service;
	gchar* _inet_hostname;
	gint _inet_service;
	gchar* _global_hashed_domain;
};

struct _AndnsAndnaResponse {
	GObject parent_instance;
	AndnsAndnaResponsePrivate * priv;
};

struct _AndnsAndnaResponseClass {
	GObjectClass parent_class;
};

struct _AndnsAndnaResponsePrivate {
	AndnsAndnaResponseCode _rcode;
	GeeArrayList* _answers;
};

struct _AndnsAndnaResponseAnswer {
	GObject parent_instance;
	AndnsAndnaResponseAnswerPrivate * priv;
	guint8 ipv4_ip[4];
	guint8 ipv6_ip[16];
	guint8 gl_ipv4_ip[4];
	guint8 gl_ipv6_ip[16];
};

struct _AndnsAndnaResponseAnswerClass {
	GObjectClass parent_class;
};

struct _AndnsAndnaResponseAnswerPrivate {
	gboolean _is_ip;
	gint _weight;
	gint _priority;
	gchar* _hashed_alias;
	guint16 _port_number;
	gchar* _hostname;
	gboolean _gl_is_main;
	gboolean _gl_is_ip;
	NetsukukuAndnaServiceKey* _gl_service;
	gint _gl_weight;
	gint _gl_priority;
	gchar* _gl_hashed_alias;
	guint16 _gl_port_number;
};


static gpointer andns_andna_query_parent_class = NULL;
static zcdISerializableIface* andns_andna_query_zcd_iserializable_parent_iface = NULL;
static gpointer andns_andna_response_parent_class = NULL;
static zcdISerializableIface* andns_andna_response_zcd_iserializable_parent_iface = NULL;
static gpointer andns_andna_response_answer_parent_class = NULL;
static zcdISerializableIface* andns_andna_response_answer_zcd_iserializable_parent_iface = NULL;

void andns_rpc_andns_init (void);
GType andns_andna_query_get_type (void) G_GNUC_CONST;
GType andns_andna_response_get_type (void) G_GNUC_CONST;
GType andns_andna_response_answer_get_type (void) G_GNUC_CONST;
GType andns_iandna_query_handler_get_type (void) G_GNUC_CONST;
GType andns_iandna_resolve_root_dispatcher_get_type (void) G_GNUC_CONST;
AndnsIAndnaQueryHandler* andns_iandna_resolve_root_dispatcher_get_query_handler (AndnsIAndnaResolveRootDispatcher* self, gint request_id);
AndnsAndnaResponse* andns_iandna_query_handler_resolve (AndnsIAndnaQueryHandler* self, AndnsAndnaQuery* query, GError** error);
GType andns_andna_query_type_get_type (void) G_GNUC_CONST;
GType andns_andna_query_protocol_get_type (void) G_GNUC_CONST;
GType andns_andna_query_ip_version_get_type (void) G_GNUC_CONST;
GType andns_andna_query_realm_get_type (void) G_GNUC_CONST;
GType andns_andna_response_code_get_type (void) G_GNUC_CONST;
#define ANDNS_ANDNA_QUERY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ANDNS_TYPE_ANDNA_QUERY, AndnsAndnaQueryPrivate))
enum  {
	ANDNS_ANDNA_QUERY_DUMMY_PROPERTY,
	ANDNS_ANDNA_QUERY_QUERY_TYPE,
	ANDNS_ANDNA_QUERY_RECURSION,
	ANDNS_ANDNA_QUERY_COMPRESSION,
	ANDNS_ANDNA_QUERY_PROTOCOL,
	ANDNS_ANDNA_QUERY_IP_VERSION,
	ANDNS_ANDNA_QUERY_IP_REALM,
	ANDNS_ANDNA_QUERY_HASHED_DOMAIN,
	ANDNS_ANDNA_QUERY_SERVICE,
	ANDNS_ANDNA_QUERY_INET_HOSTNAME,
	ANDNS_ANDNA_QUERY_INET_SERVICE,
	ANDNS_ANDNA_QUERY_GLOBAL_HASHED_DOMAIN
};
static AndnsAndnaQuery* andns_andna_query_new_priv (AndnsAndnaQueryType query_type, gboolean recursion, gboolean compression, AndnsAndnaQueryProtocol protocol, AndnsAndnaQueryIPVersion ip_version, AndnsAndnaQueryRealm ip_realm);
static AndnsAndnaQuery* andns_andna_query_construct_priv (GType object_type, AndnsAndnaQueryType query_type, gboolean recursion, gboolean compression, AndnsAndnaQueryProtocol protocol, AndnsAndnaQueryIPVersion ip_version, AndnsAndnaQueryRealm ip_realm);
static void andns_andna_query_set_query_type (AndnsAndnaQuery* self, AndnsAndnaQueryType value);
static void andns_andna_query_set_recursion (AndnsAndnaQuery* self, gboolean value);
static void andns_andna_query_set_compression (AndnsAndnaQuery* self, gboolean value);
static void andns_andna_query_set_protocol (AndnsAndnaQuery* self, AndnsAndnaQueryProtocol value);
static void andns_andna_query_set_ip_version (AndnsAndnaQuery* self, AndnsAndnaQueryIPVersion value);
static void andns_andna_query_set_ip_realm (AndnsAndnaQuery* self, AndnsAndnaQueryRealm value);
static void andns_andna_query_set_hashed_domain (AndnsAndnaQuery* self, const gchar* value);
static void andns_andna_query_set_service (AndnsAndnaQuery* self, NetsukukuAndnaServiceKey* value);
static void andns_andna_query_set_inet_hostname (AndnsAndnaQuery* self, const gchar* value);
static void andns_andna_query_set_global_hashed_domain (AndnsAndnaQuery* self, const gchar* value);
AndnsAndnaQuery* andns_andna_query_new_name_to_ip_ntk (gboolean recursion, gboolean compression, AndnsAndnaQueryProtocol protocol, AndnsAndnaQueryIPVersion ip_version, const gchar* hashed_domain, NetsukukuAndnaServiceKey* service);
AndnsAndnaQuery* andns_andna_query_construct_name_to_ip_ntk (GType object_type, gboolean recursion, gboolean compression, AndnsAndnaQueryProtocol protocol, AndnsAndnaQueryIPVersion ip_version, const gchar* hashed_domain, NetsukukuAndnaServiceKey* service);
AndnsAndnaQuery* andns_andna_query_new_ip_to_name_ntk (gboolean compression, AndnsAndnaQueryProtocol protocol, AndnsAndnaQueryIPVersion ip_version, guint8* ip, int ip_length1);
AndnsAndnaQuery* andns_andna_query_construct_ip_to_name_ntk (GType object_type, gboolean compression, AndnsAndnaQueryProtocol protocol, AndnsAndnaQueryIPVersion ip_version, guint8* ip, int ip_length1);
static GVariant* andns_andna_query_real_serialize_to_variant (zcdISerializable* base);
AndnsAndnaQueryType andns_andna_query_get_query_type (AndnsAndnaQuery* self);
AndnsAndnaQueryProtocol andns_andna_query_get_protocol (AndnsAndnaQuery* self);
AndnsAndnaQueryIPVersion andns_andna_query_get_ip_version (AndnsAndnaQuery* self);
AndnsAndnaQueryRealm andns_andna_query_get_ip_realm (AndnsAndnaQuery* self);
gboolean andns_andna_query_get_recursion (AndnsAndnaQuery* self);
gboolean andns_andna_query_get_compression (AndnsAndnaQuery* self);
const gchar* andns_andna_query_get_hashed_domain (AndnsAndnaQuery* self);
NetsukukuAndnaServiceKey* andns_andna_query_get_service (AndnsAndnaQuery* self);
const gchar* andns_andna_query_get_inet_hostname (AndnsAndnaQuery* self);
gint andns_andna_query_get_inet_service (AndnsAndnaQuery* self);
const gchar* andns_andna_query_get_global_hashed_domain (AndnsAndnaQuery* self);
static void andns_andna_query_real_deserialize_from_variant (zcdISerializable* base, GVariant* v, GError** error);
static void andns_andna_query_set_inet_service (AndnsAndnaQuery* self, gint value);
AndnsAndnaQuery* andns_andna_query_new (void);
AndnsAndnaQuery* andns_andna_query_construct (GType object_type);
static void andns_andna_query_finalize (GObject* obj);
static void _vala_andns_andna_query_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_andns_andna_query_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define ANDNS_ANDNA_RESPONSE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ANDNS_TYPE_ANDNA_RESPONSE, AndnsAndnaResponsePrivate))
enum  {
	ANDNS_ANDNA_RESPONSE_DUMMY_PROPERTY,
	ANDNS_ANDNA_RESPONSE_RCODE,
	ANDNS_ANDNA_RESPONSE_ANSWERS
};
AndnsAndnaResponse* andns_andna_response_new (AndnsAndnaResponseCode _rcode, GeeArrayList* _answers);
AndnsAndnaResponse* andns_andna_response_construct (GType object_type, AndnsAndnaResponseCode _rcode, GeeArrayList* _answers);
gboolean andns_andna_response_answer_equal_func (AndnsAndnaResponseAnswer* a, AndnsAndnaResponseAnswer* b);
static gboolean _andns_andna_response_answer_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self);
static void andns_andna_response_set_answers (AndnsAndnaResponse* self, GeeArrayList* value);
GeeArrayList* andns_andna_response_get_answers (AndnsAndnaResponse* self);
static void andns_andna_response_set_rcode (AndnsAndnaResponse* self, AndnsAndnaResponseCode value);
static GVariant* andns_andna_response_real_serialize_to_variant (zcdISerializable* base);
AndnsAndnaResponseCode andns_andna_response_get_rcode (AndnsAndnaResponse* self);
static void andns_andna_response_real_deserialize_from_variant (zcdISerializable* base, GVariant* v, GError** error);
static void andns_andna_response_finalize (GObject* obj);
static void _vala_andns_andna_response_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_andns_andna_response_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define ANDNS_ANDNA_RESPONSE_ANSWER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ANDNS_TYPE_ANDNA_RESPONSE_ANSWER, AndnsAndnaResponseAnswerPrivate))
enum  {
	ANDNS_ANDNA_RESPONSE_ANSWER_DUMMY_PROPERTY,
	ANDNS_ANDNA_RESPONSE_ANSWER_IS_IP,
	ANDNS_ANDNA_RESPONSE_ANSWER_WEIGHT,
	ANDNS_ANDNA_RESPONSE_ANSWER_PRIORITY,
	ANDNS_ANDNA_RESPONSE_ANSWER_HASHED_ALIAS,
	ANDNS_ANDNA_RESPONSE_ANSWER_HOSTNAME,
	ANDNS_ANDNA_RESPONSE_ANSWER_GL_IS_MAIN,
	ANDNS_ANDNA_RESPONSE_ANSWER_GL_IS_IP,
	ANDNS_ANDNA_RESPONSE_ANSWER_GL_SERVICE,
	ANDNS_ANDNA_RESPONSE_ANSWER_GL_WEIGHT,
	ANDNS_ANDNA_RESPONSE_ANSWER_GL_PRIORITY,
	ANDNS_ANDNA_RESPONSE_ANSWER_GL_HASHED_ALIAS
};
static AndnsAndnaResponseAnswer* andns_andna_response_answer_new_priv (void);
static AndnsAndnaResponseAnswer* andns_andna_response_answer_construct_priv (GType object_type);
static void andns_andna_response_answer_set_hashed_alias (AndnsAndnaResponseAnswer* self, const gchar* value);
static void andns_andna_response_answer_set_gl_service (AndnsAndnaResponseAnswer* self, NetsukukuAndnaServiceKey* value);
static void andns_andna_response_answer_set_hostname (AndnsAndnaResponseAnswer* self, const gchar* value);
static void andns_andna_response_answer_set_gl_hashed_alias (AndnsAndnaResponseAnswer* self, const gchar* value);
AndnsAndnaResponseAnswer* andns_andna_response_answer_new_name_to_ip (gint weight, gint priority, guint8* ipv4_ip, int ipv4_ip_length1, guint16 port_number);
AndnsAndnaResponseAnswer* andns_andna_response_answer_construct_name_to_ip (GType object_type, gint weight, gint priority, guint8* ipv4_ip, int ipv4_ip_length1, guint16 port_number);
static void andns_andna_response_answer_set_is_ip (AndnsAndnaResponseAnswer* self, gboolean value);
static void andns_andna_response_answer_set_weight (AndnsAndnaResponseAnswer* self, gint value);
static void andns_andna_response_answer_set_priority (AndnsAndnaResponseAnswer* self, gint value);
static void andns_andna_response_answer_set_port_number (AndnsAndnaResponseAnswer* self, guint16 value);
AndnsAndnaResponseAnswer* andns_andna_response_answer_new_name_to_ip_v6 (gint weight, gint priority, guint8* ipv6_ip, int ipv6_ip_length1, guint16 port_number);
AndnsAndnaResponseAnswer* andns_andna_response_answer_construct_name_to_ip_v6 (GType object_type, gint weight, gint priority, guint8* ipv6_ip, int ipv6_ip_length1, guint16 port_number);
AndnsAndnaResponseAnswer* andns_andna_response_answer_new_name_to_alias (gint weight, gint priority, const gchar* hashed_alias, guint16 port_number);
AndnsAndnaResponseAnswer* andns_andna_response_answer_construct_name_to_alias (GType object_type, gint weight, gint priority, const gchar* hashed_alias, guint16 port_number);
AndnsAndnaResponseAnswer* andns_andna_response_answer_new_ip_to_name (const gchar* hostname);
AndnsAndnaResponseAnswer* andns_andna_response_answer_construct_ip_to_name (GType object_type, const gchar* hostname);
static GVariant* andns_andna_response_answer_real_serialize_to_variant (zcdISerializable* base);
gboolean andns_andna_response_answer_get_is_ip (AndnsAndnaResponseAnswer* self);
gboolean andns_andna_response_answer_get_gl_is_ip (AndnsAndnaResponseAnswer* self);
gboolean andns_andna_response_answer_get_gl_is_main (AndnsAndnaResponseAnswer* self);
gint andns_andna_response_answer_get_weight (AndnsAndnaResponseAnswer* self);
gint andns_andna_response_answer_get_priority (AndnsAndnaResponseAnswer* self);
const gchar* andns_andna_response_answer_get_hashed_alias (AndnsAndnaResponseAnswer* self);
guint16 andns_andna_response_answer_get_port_number (AndnsAndnaResponseAnswer* self);
const gchar* andns_andna_response_answer_get_hostname (AndnsAndnaResponseAnswer* self);
NetsukukuAndnaServiceKey* andns_andna_response_answer_get_gl_service (AndnsAndnaResponseAnswer* self);
gint andns_andna_response_answer_get_gl_weight (AndnsAndnaResponseAnswer* self);
gint andns_andna_response_answer_get_gl_priority (AndnsAndnaResponseAnswer* self);
const gchar* andns_andna_response_answer_get_gl_hashed_alias (AndnsAndnaResponseAnswer* self);
guint16 andns_andna_response_answer_get_gl_port_number (AndnsAndnaResponseAnswer* self);
static void andns_andna_response_answer_real_deserialize_from_variant (zcdISerializable* base, GVariant* v, GError** error);
static void andns_andna_response_answer_set_gl_weight (AndnsAndnaResponseAnswer* self, gint value);
static void andns_andna_response_answer_set_gl_priority (AndnsAndnaResponseAnswer* self, gint value);
static void andns_andna_response_answer_set_gl_port_number (AndnsAndnaResponseAnswer* self, guint16 value);
static void andns_andna_response_answer_set_gl_is_ip (AndnsAndnaResponseAnswer* self, gboolean value);
static void andns_andna_response_answer_set_gl_is_main (AndnsAndnaResponseAnswer* self, gboolean value);
static guint8* _vala_array_dup1 (guint8* self, int length);
static guint8* _vala_array_dup2 (guint8* self, int length);
static guint8* _vala_array_dup3 (guint8* self, int length);
static guint8* _vala_array_dup4 (guint8* self, int length);
static guint8* _vala_array_dup5 (guint8* self, int length);
static guint8* _vala_array_dup6 (guint8* self, int length);
static guint8* _vala_array_dup7 (guint8* self, int length);
static guint8* _vala_array_dup8 (guint8* self, int length);
AndnsAndnaResponseAnswer* andns_andna_response_answer_new (void);
AndnsAndnaResponseAnswer* andns_andna_response_answer_construct (GType object_type);
static void andns_andna_response_answer_finalize (GObject* obj);
static void _vala_andns_andna_response_answer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_andns_andna_response_answer_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


void andns_rpc_andns_init (void) {
	g_type_class_peek (ANDNS_TYPE_ANDNA_QUERY);
	g_type_class_peek (ANDNS_TYPE_ANDNA_RESPONSE);
	g_type_class_peek (ANDNS_TYPE_ANDNA_RESPONSE_ANSWER);
}


AndnsIAndnaQueryHandler* andns_iandna_resolve_root_dispatcher_get_query_handler (AndnsIAndnaResolveRootDispatcher* self, gint request_id) {
	g_return_val_if_fail (self != NULL, NULL);
	return ANDNS_IANDNA_RESOLVE_ROOT_DISPATCHER_GET_INTERFACE (self)->get_query_handler (self, request_id);
}


static void andns_iandna_resolve_root_dispatcher_base_init (AndnsIAndnaResolveRootDispatcherIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


/** This is the interface for a root-dispatcher class
      */
GType andns_iandna_resolve_root_dispatcher_get_type (void) {
	static volatile gsize andns_iandna_resolve_root_dispatcher_type_id__volatile = 0;
	if (g_once_init_enter (&andns_iandna_resolve_root_dispatcher_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AndnsIAndnaResolveRootDispatcherIface), (GBaseInitFunc) andns_iandna_resolve_root_dispatcher_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType andns_iandna_resolve_root_dispatcher_type_id;
		andns_iandna_resolve_root_dispatcher_type_id = g_type_register_static (G_TYPE_INTERFACE, "AndnsIAndnaResolveRootDispatcher", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (andns_iandna_resolve_root_dispatcher_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&andns_iandna_resolve_root_dispatcher_type_id__volatile, andns_iandna_resolve_root_dispatcher_type_id);
	}
	return andns_iandna_resolve_root_dispatcher_type_id__volatile;
}


AndnsAndnaResponse* andns_iandna_query_handler_resolve (AndnsIAndnaQueryHandler* self, AndnsAndnaQuery* query, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return ANDNS_IANDNA_QUERY_HANDLER_GET_INTERFACE (self)->resolve (self, query, error);
}


static void andns_iandna_query_handler_base_init (AndnsIAndnaQueryHandlerIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


/** This is the interface for the remotable methods of the class Directory
      */
GType andns_iandna_query_handler_get_type (void) {
	static volatile gsize andns_iandna_query_handler_type_id__volatile = 0;
	if (g_once_init_enter (&andns_iandna_query_handler_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AndnsIAndnaQueryHandlerIface), (GBaseInitFunc) andns_iandna_query_handler_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType andns_iandna_query_handler_type_id;
		andns_iandna_query_handler_type_id = g_type_register_static (G_TYPE_INTERFACE, "AndnsIAndnaQueryHandler", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (andns_iandna_query_handler_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&andns_iandna_query_handler_type_id__volatile, andns_iandna_query_handler_type_id);
	}
	return andns_iandna_query_handler_type_id__volatile;
}


GType andns_andna_query_type_get_type (void) {
	static volatile gsize andns_andna_query_type_type_id__volatile = 0;
	if (g_once_init_enter (&andns_andna_query_type_type_id__volatile)) {
		static const GEnumValue values[] = {{ANDNS_ANDNA_QUERY_TYPE_NAME_TO_IP, "ANDNS_ANDNA_QUERY_TYPE_NAME_TO_IP", "name-to-ip"}, {ANDNS_ANDNA_QUERY_TYPE_IP_TO_NAME, "ANDNS_ANDNA_QUERY_TYPE_IP_TO_NAME", "ip-to-name"}, {ANDNS_ANDNA_QUERY_TYPE_GLOBAL, "ANDNS_ANDNA_QUERY_TYPE_GLOBAL", "global"}, {0, NULL, NULL}};
		GType andns_andna_query_type_type_id;
		andns_andna_query_type_type_id = g_enum_register_static ("AndnsAndnaQueryType", values);
		g_once_init_leave (&andns_andna_query_type_type_id__volatile, andns_andna_query_type_type_id);
	}
	return andns_andna_query_type_type_id__volatile;
}


GType andns_andna_query_protocol_get_type (void) {
	static volatile gsize andns_andna_query_protocol_type_id__volatile = 0;
	if (g_once_init_enter (&andns_andna_query_protocol_type_id__volatile)) {
		static const GEnumValue values[] = {{ANDNS_ANDNA_QUERY_PROTOCOL_TCP, "ANDNS_ANDNA_QUERY_PROTOCOL_TCP", "tcp"}, {ANDNS_ANDNA_QUERY_PROTOCOL_UDP, "ANDNS_ANDNA_QUERY_PROTOCOL_UDP", "udp"}, {0, NULL, NULL}};
		GType andns_andna_query_protocol_type_id;
		andns_andna_query_protocol_type_id = g_enum_register_static ("AndnsAndnaQueryProtocol", values);
		g_once_init_leave (&andns_andna_query_protocol_type_id__volatile, andns_andna_query_protocol_type_id);
	}
	return andns_andna_query_protocol_type_id__volatile;
}


GType andns_andna_query_ip_version_get_type (void) {
	static volatile gsize andns_andna_query_ip_version_type_id__volatile = 0;
	if (g_once_init_enter (&andns_andna_query_ip_version_type_id__volatile)) {
		static const GEnumValue values[] = {{ANDNS_ANDNA_QUERY_IP_VERSION_IPV4, "ANDNS_ANDNA_QUERY_IP_VERSION_IPV4", "ipv4"}, {ANDNS_ANDNA_QUERY_IP_VERSION_IPV6, "ANDNS_ANDNA_QUERY_IP_VERSION_IPV6", "ipv6"}, {0, NULL, NULL}};
		GType andns_andna_query_ip_version_type_id;
		andns_andna_query_ip_version_type_id = g_enum_register_static ("AndnsAndnaQueryIPVersion", values);
		g_once_init_leave (&andns_andna_query_ip_version_type_id__volatile, andns_andna_query_ip_version_type_id);
	}
	return andns_andna_query_ip_version_type_id__volatile;
}


GType andns_andna_query_realm_get_type (void) {
	static volatile gsize andns_andna_query_realm_type_id__volatile = 0;
	if (g_once_init_enter (&andns_andna_query_realm_type_id__volatile)) {
		static const GEnumValue values[] = {{ANDNS_ANDNA_QUERY_REALM_NTK, "ANDNS_ANDNA_QUERY_REALM_NTK", "ntk"}, {ANDNS_ANDNA_QUERY_REALM_INT, "ANDNS_ANDNA_QUERY_REALM_INT", "int"}, {0, NULL, NULL}};
		GType andns_andna_query_realm_type_id;
		andns_andna_query_realm_type_id = g_enum_register_static ("AndnsAndnaQueryRealm", values);
		g_once_init_leave (&andns_andna_query_realm_type_id__volatile, andns_andna_query_realm_type_id);
	}
	return andns_andna_query_realm_type_id__volatile;
}


GType andns_andna_response_code_get_type (void) {
	static volatile gsize andns_andna_response_code_type_id__volatile = 0;
	if (g_once_init_enter (&andns_andna_response_code_type_id__volatile)) {
		static const GEnumValue values[] = {{ANDNS_ANDNA_RESPONSE_CODE_NO_ERROR, "ANDNS_ANDNA_RESPONSE_CODE_NO_ERROR", "no-error"}, {ANDNS_ANDNA_RESPONSE_CODE_MALFORMED, "ANDNS_ANDNA_RESPONSE_CODE_MALFORMED", "malformed"}, {ANDNS_ANDNA_RESPONSE_CODE_SERV_FAIL, "ANDNS_ANDNA_RESPONSE_CODE_SERV_FAIL", "serv-fail"}, {ANDNS_ANDNA_RESPONSE_CODE_NO_DOMAIN, "ANDNS_ANDNA_RESPONSE_CODE_NO_DOMAIN", "no-domain"}, {ANDNS_ANDNA_RESPONSE_CODE_NOT_IMPL, "ANDNS_ANDNA_RESPONSE_CODE_NOT_IMPL", "not-impl"}, {ANDNS_ANDNA_RESPONSE_CODE_REFUSED, "ANDNS_ANDNA_RESPONSE_CODE_REFUSED", "refused"}, {0, NULL, NULL}};
		GType andns_andna_response_code_type_id;
		andns_andna_response_code_type_id = g_enum_register_static ("AndnsAndnaResponseCode", values);
		g_once_init_leave (&andns_andna_response_code_type_id__volatile, andns_andna_response_code_type_id);
	}
	return andns_andna_response_code_type_id__volatile;
}


static AndnsAndnaQuery* andns_andna_query_construct_priv (GType object_type, AndnsAndnaQueryType query_type, gboolean recursion, gboolean compression, AndnsAndnaQueryProtocol protocol, AndnsAndnaQueryIPVersion ip_version, AndnsAndnaQueryRealm ip_realm) {
	AndnsAndnaQuery * self = NULL;
	AndnsAndnaQueryType _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	AndnsAndnaQueryProtocol _tmp3_;
	AndnsAndnaQueryIPVersion _tmp4_;
	AndnsAndnaQueryRealm _tmp5_;
	NetsukukuAndnaServiceKey* _tmp6_;
	NetsukukuAndnaServiceKey* _tmp7_;
	self = (AndnsAndnaQuery*) g_object_new (object_type, NULL);
	_tmp0_ = query_type;
	andns_andna_query_set_query_type (self, _tmp0_);
	_tmp1_ = recursion;
	andns_andna_query_set_recursion (self, _tmp1_);
	_tmp2_ = compression;
	andns_andna_query_set_compression (self, _tmp2_);
	_tmp3_ = protocol;
	andns_andna_query_set_protocol (self, _tmp3_);
	_tmp4_ = ip_version;
	andns_andna_query_set_ip_version (self, _tmp4_);
	_tmp5_ = ip_realm;
	andns_andna_query_set_ip_realm (self, _tmp5_);
	andns_andna_query_set_hashed_domain (self, "");
	_tmp6_ = netsukuku_andna_service_key_get_NULL_SERV_KEY ();
	_tmp7_ = _tmp6_;
	andns_andna_query_set_service (self, _tmp7_);
	andns_andna_query_set_inet_hostname (self, "");
	andns_andna_query_set_global_hashed_domain (self, "");
	return self;
}


static AndnsAndnaQuery* andns_andna_query_new_priv (AndnsAndnaQueryType query_type, gboolean recursion, gboolean compression, AndnsAndnaQueryProtocol protocol, AndnsAndnaQueryIPVersion ip_version, AndnsAndnaQueryRealm ip_realm) {
	return andns_andna_query_construct_priv (ANDNS_TYPE_ANDNA_QUERY, query_type, recursion, compression, protocol, ip_version, ip_realm);
}


AndnsAndnaQuery* andns_andna_query_construct_name_to_ip_ntk (GType object_type, gboolean recursion, gboolean compression, AndnsAndnaQueryProtocol protocol, AndnsAndnaQueryIPVersion ip_version, const gchar* hashed_domain, NetsukukuAndnaServiceKey* service) {
	AndnsAndnaQuery * self = NULL;
	gboolean _tmp0_;
	gboolean _tmp1_;
	AndnsAndnaQueryProtocol _tmp2_;
	AndnsAndnaQueryIPVersion _tmp3_;
	const gchar* _tmp4_;
	NetsukukuAndnaServiceKey* _tmp5_;
	g_return_val_if_fail (hashed_domain != NULL, NULL);
	g_return_val_if_fail (service != NULL, NULL);
	_tmp0_ = recursion;
	_tmp1_ = compression;
	_tmp2_ = protocol;
	_tmp3_ = ip_version;
	self = (AndnsAndnaQuery*) andns_andna_query_construct_priv (object_type, ANDNS_ANDNA_QUERY_TYPE_NAME_TO_IP, _tmp0_, _tmp1_, _tmp2_, _tmp3_, ANDNS_ANDNA_QUERY_REALM_NTK);
	_tmp4_ = hashed_domain;
	andns_andna_query_set_hashed_domain (self, _tmp4_);
	_tmp5_ = service;
	andns_andna_query_set_service (self, _tmp5_);
	return self;
}


AndnsAndnaQuery* andns_andna_query_new_name_to_ip_ntk (gboolean recursion, gboolean compression, AndnsAndnaQueryProtocol protocol, AndnsAndnaQueryIPVersion ip_version, const gchar* hashed_domain, NetsukukuAndnaServiceKey* service) {
	return andns_andna_query_construct_name_to_ip_ntk (ANDNS_TYPE_ANDNA_QUERY, recursion, compression, protocol, ip_version, hashed_domain, service);
}


AndnsAndnaQuery* andns_andna_query_construct_ip_to_name_ntk (GType object_type, gboolean compression, AndnsAndnaQueryProtocol protocol, AndnsAndnaQueryIPVersion ip_version, guint8* ip, int ip_length1) {
	AndnsAndnaQuery * self = NULL;
	gboolean _tmp0_;
	AndnsAndnaQueryProtocol _tmp1_;
	AndnsAndnaQueryIPVersion _tmp2_;
	AndnsAndnaQueryIPVersion _tmp3_;
	_tmp0_ = compression;
	_tmp1_ = protocol;
	_tmp2_ = ip_version;
	self = (AndnsAndnaQuery*) andns_andna_query_construct_priv (object_type, ANDNS_ANDNA_QUERY_TYPE_IP_TO_NAME, FALSE, _tmp0_, _tmp1_, _tmp2_, ANDNS_ANDNA_QUERY_REALM_NTK);
	_tmp3_ = ip_version;
	if (_tmp3_ == ANDNS_ANDNA_QUERY_IP_VERSION_IPV4) {
		{
			gint i;
			i = 0;
			{
				gboolean _tmp4_;
				_tmp4_ = TRUE;
				while (TRUE) {
					gboolean _tmp5_;
					gint _tmp7_;
					gint _tmp8_;
					guint8* _tmp9_;
					gint _tmp9__length1;
					gint _tmp10_;
					guint8 _tmp11_;
					guint8 _tmp12_;
					_tmp5_ = _tmp4_;
					if (!_tmp5_) {
						gint _tmp6_;
						_tmp6_ = i;
						i = _tmp6_ + 1;
					}
					_tmp4_ = FALSE;
					_tmp7_ = i;
					if (!(_tmp7_ < 4)) {
						break;
					}
					_tmp8_ = i;
					_tmp9_ = ip;
					_tmp9__length1 = ip_length1;
					_tmp10_ = i;
					_tmp11_ = _tmp9_[_tmp10_];
					self->ipv4_ip[_tmp8_] = _tmp11_;
					_tmp12_ = self->ipv4_ip[_tmp8_];
				}
			}
		}
	} else {
		{
			gint i;
			i = 0;
			{
				gboolean _tmp13_;
				_tmp13_ = TRUE;
				while (TRUE) {
					gboolean _tmp14_;
					gint _tmp16_;
					gint _tmp17_;
					guint8* _tmp18_;
					gint _tmp18__length1;
					gint _tmp19_;
					guint8 _tmp20_;
					guint8 _tmp21_;
					_tmp14_ = _tmp13_;
					if (!_tmp14_) {
						gint _tmp15_;
						_tmp15_ = i;
						i = _tmp15_ + 1;
					}
					_tmp13_ = FALSE;
					_tmp16_ = i;
					if (!(_tmp16_ < 16)) {
						break;
					}
					_tmp17_ = i;
					_tmp18_ = ip;
					_tmp18__length1 = ip_length1;
					_tmp19_ = i;
					_tmp20_ = _tmp18_[_tmp19_];
					self->ipv6_ip[_tmp17_] = _tmp20_;
					_tmp21_ = self->ipv6_ip[_tmp17_];
				}
			}
		}
	}
	return self;
}


AndnsAndnaQuery* andns_andna_query_new_ip_to_name_ntk (gboolean compression, AndnsAndnaQueryProtocol protocol, AndnsAndnaQueryIPVersion ip_version, guint8* ip, int ip_length1) {
	return andns_andna_query_construct_ip_to_name_ntk (ANDNS_TYPE_ANDNA_QUERY, compression, protocol, ip_version, ip, ip_length1);
}


static GVariant* andns_andna_query_real_serialize_to_variant (zcdISerializable* base) {
	AndnsAndnaQuery * self;
	GVariant* result = NULL;
	AndnsAndnaQueryType _tmp0_;
	gint i_query_type;
	AndnsAndnaQueryProtocol _tmp1_;
	gint i_protocol;
	AndnsAndnaQueryIPVersion _tmp2_;
	gint i_ip_version;
	AndnsAndnaQueryRealm _tmp3_;
	gint i_ip_realm;
	gint _tmp4_ = 0;
	gboolean _tmp5_;
	gint _tmp6_;
	gint i_recursion;
	gint _tmp7_ = 0;
	gboolean _tmp8_;
	gint _tmp9_;
	gint i_compression;
	zcdSerializableBuffer* _tmp10_;
	zcdSerializableBuffer* b_ipv4_ip;
	zcdSerializableBuffer* _tmp11_;
	zcdSerializableBuffer* b_ipv6_ip;
	gint _tmp12_;
	GVariant* _tmp13_ = NULL;
	GVariant* v0;
	gint _tmp14_;
	GVariant* _tmp15_ = NULL;
	GVariant* v1;
	gint _tmp16_;
	GVariant* _tmp17_ = NULL;
	GVariant* v2;
	gint _tmp18_;
	GVariant* _tmp19_ = NULL;
	GVariant* v3;
	gint _tmp20_;
	GVariant* _tmp21_ = NULL;
	GVariant* v4;
	GVariant* _tmp22_ = NULL;
	GVariant* v5;
	const gchar* _tmp23_;
	GVariant* _tmp24_ = NULL;
	GVariant* v6;
	NetsukukuAndnaServiceKey* _tmp25_;
	GVariant* _tmp26_ = NULL;
	GVariant* v7;
	const gchar* _tmp27_;
	GVariant* _tmp28_ = NULL;
	GVariant* v8;
	gint _tmp29_;
	GVariant* _tmp30_ = NULL;
	GVariant* v9;
	GVariant* _tmp31_ = NULL;
	GVariant* vA;
	GVariant* _tmp32_ = NULL;
	GVariant* vB;
	const gchar* _tmp33_;
	GVariant* _tmp34_ = NULL;
	GVariant* vC;
	GVariant* _tmp35_ = NULL;
	GVariant* vtemp0;
	GVariant* _tmp36_ = NULL;
	GVariant* vtemp1;
	GVariant* _tmp37_ = NULL;
	GVariant* vret;
	self = (AndnsAndnaQuery*) base;
	_tmp0_ = self->priv->_query_type;
	i_query_type = (gint) _tmp0_;
	_tmp1_ = self->priv->_protocol;
	i_protocol = (gint) _tmp1_;
	_tmp2_ = self->priv->_ip_version;
	i_ip_version = (gint) _tmp2_;
	_tmp3_ = self->priv->_ip_realm;
	i_ip_realm = (gint) _tmp3_;
	_tmp5_ = self->priv->_recursion;
	if (_tmp5_) {
		_tmp4_ = 1;
	} else {
		_tmp4_ = 0;
	}
	_tmp6_ = _tmp4_;
	i_recursion = _tmp6_;
	_tmp8_ = self->priv->_compression;
	if (_tmp8_) {
		_tmp7_ = 1;
	} else {
		_tmp7_ = 0;
	}
	_tmp9_ = _tmp7_;
	i_compression = _tmp9_;
	_tmp10_ = zcd_serializable_buffer_new (self->ipv4_ip, 4);
	b_ipv4_ip = _tmp10_;
	_tmp11_ = zcd_serializable_buffer_new (self->ipv6_ip, 16);
	b_ipv6_ip = _tmp11_;
	_tmp12_ = i_query_type;
	_tmp13_ = zcd_serializer_int_to_variant (_tmp12_);
	v0 = _tmp13_;
	_tmp14_ = i_protocol;
	_tmp15_ = zcd_serializer_int_to_variant (_tmp14_);
	v1 = _tmp15_;
	_tmp16_ = i_ip_version;
	_tmp17_ = zcd_serializer_int_to_variant (_tmp16_);
	v2 = _tmp17_;
	_tmp18_ = i_ip_realm;
	_tmp19_ = zcd_serializer_int_to_variant (_tmp18_);
	v3 = _tmp19_;
	_tmp20_ = i_recursion;
	_tmp21_ = zcd_serializer_int_to_variant (_tmp20_);
	v4 = _tmp21_;
	_tmp22_ = zcd_serializer_int_to_variant (i_compression);
	v5 = _tmp22_;
	_tmp23_ = self->priv->_hashed_domain;
	_tmp24_ = zcd_serializer_string_to_variant (_tmp23_);
	v6 = _tmp24_;
	_tmp25_ = self->priv->_service;
	_tmp26_ = zcd_iserializable_serialize_to_variant ((zcdISerializable*) _tmp25_);
	v7 = _tmp26_;
	_tmp27_ = self->priv->_inet_hostname;
	_tmp28_ = zcd_serializer_string_to_variant (_tmp27_);
	v8 = _tmp28_;
	_tmp29_ = self->priv->_inet_service;
	_tmp30_ = zcd_serializer_int_to_variant (_tmp29_);
	v9 = _tmp30_;
	_tmp31_ = zcd_iserializable_serialize_to_variant ((zcdISerializable*) b_ipv4_ip);
	vA = _tmp31_;
	_tmp32_ = zcd_iserializable_serialize_to_variant ((zcdISerializable*) b_ipv6_ip);
	vB = _tmp32_;
	_tmp33_ = self->priv->_global_hashed_domain;
	_tmp34_ = zcd_serializer_string_to_variant (_tmp33_);
	vC = _tmp34_;
	_tmp35_ = zcd_serializer_tuple_to_variant_5 (v0, v1, v2, v3, v4);
	vtemp0 = _tmp35_;
	_tmp36_ = zcd_serializer_tuple_to_variant_5 (vtemp0, v5, v6, v7, v8);
	vtemp1 = _tmp36_;
	_tmp37_ = zcd_serializer_tuple_to_variant_5 (vtemp1, v9, vA, vB, vC);
	vret = _tmp37_;
	result = vret;
	_g_variant_unref0 (vtemp1);
	_g_variant_unref0 (vtemp0);
	_g_variant_unref0 (vC);
	_g_variant_unref0 (vB);
	_g_variant_unref0 (vA);
	_g_variant_unref0 (v9);
	_g_variant_unref0 (v8);
	_g_variant_unref0 (v7);
	_g_variant_unref0 (v6);
	_g_variant_unref0 (v5);
	_g_variant_unref0 (v4);
	_g_variant_unref0 (v3);
	_g_variant_unref0 (v2);
	_g_variant_unref0 (v1);
	_g_variant_unref0 (v0);
	_g_object_unref0 (b_ipv6_ip);
	_g_object_unref0 (b_ipv4_ip);
	return result;
}


static void andns_andna_query_real_deserialize_from_variant (zcdISerializable* base, GVariant* v, GError** error) {
	AndnsAndnaQuery * self;
	GVariant* v0 = NULL;
	GVariant* v1 = NULL;
	GVariant* v2 = NULL;
	GVariant* v3 = NULL;
	GVariant* v4 = NULL;
	GVariant* v5 = NULL;
	GVariant* v6 = NULL;
	GVariant* v7 = NULL;
	GVariant* v8 = NULL;
	GVariant* v9 = NULL;
	GVariant* vA = NULL;
	GVariant* vB = NULL;
	GVariant* vC = NULL;
	GVariant* vtemp0 = NULL;
	GVariant* vtemp1 = NULL;
	GVariant* _tmp0_;
	GVariant* _tmp1_ = NULL;
	GVariant* _tmp2_ = NULL;
	GVariant* _tmp3_ = NULL;
	GVariant* _tmp4_ = NULL;
	GVariant* _tmp5_ = NULL;
	GVariant* _tmp6_;
	GVariant* _tmp7_ = NULL;
	GVariant* _tmp8_ = NULL;
	GVariant* _tmp9_ = NULL;
	GVariant* _tmp10_ = NULL;
	GVariant* _tmp11_ = NULL;
	GVariant* _tmp12_;
	GVariant* _tmp13_ = NULL;
	GVariant* _tmp14_ = NULL;
	GVariant* _tmp15_ = NULL;
	GVariant* _tmp16_ = NULL;
	GVariant* _tmp17_ = NULL;
	GVariant* _tmp18_;
	gint _tmp19_ = 0;
	gint i_query_type;
	GVariant* _tmp20_;
	gint _tmp21_ = 0;
	gint i_protocol;
	GVariant* _tmp22_;
	gint _tmp23_ = 0;
	gint i_ip_version;
	GVariant* _tmp24_;
	gint _tmp25_ = 0;
	gint i_ip_realm;
	GVariant* _tmp26_;
	gint _tmp27_ = 0;
	gint i_recursion;
	GVariant* _tmp28_;
	gint _tmp29_ = 0;
	gint i_compression;
	GVariant* _tmp30_;
	gchar* _tmp31_ = NULL;
	gchar* _tmp32_;
	GObject* _tmp33_ = NULL;
	GObject* _tmp34_;
	NetsukukuAndnaServiceKey* _tmp35_;
	NetsukukuAndnaServiceKey* _tmp36_;
	GVariant* _tmp37_;
	GVariant* _tmp38_;
	gchar* _tmp39_ = NULL;
	gchar* _tmp40_;
	GVariant* _tmp41_;
	gint _tmp42_ = 0;
	GVariant* _tmp81_;
	gchar* _tmp82_ = NULL;
	gchar* _tmp83_;
	gint _tmp84_;
	gint _tmp85_;
	gint _tmp86_;
	gint _tmp87_;
	gint _tmp88_;
	gint _tmp89_;
	GError * _inner_error_ = NULL;
	self = (AndnsAndnaQuery*) base;
	g_return_if_fail (v != NULL);
	_tmp0_ = v;
	zcd_serializer_variant_to_tuple_5 (_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_, &_tmp4_, &_tmp5_);
	_g_variant_unref0 (vtemp1);
	vtemp1 = _tmp1_;
	_g_variant_unref0 (v9);
	v9 = _tmp2_;
	_g_variant_unref0 (vA);
	vA = _tmp3_;
	_g_variant_unref0 (vB);
	vB = _tmp4_;
	_g_variant_unref0 (vC);
	vC = _tmp5_;
	_tmp6_ = vtemp1;
	zcd_serializer_variant_to_tuple_5 (_tmp6_, &_tmp7_, &_tmp8_, &_tmp9_, &_tmp10_, &_tmp11_);
	_g_variant_unref0 (vtemp0);
	vtemp0 = _tmp7_;
	_g_variant_unref0 (v5);
	v5 = _tmp8_;
	_g_variant_unref0 (v6);
	v6 = _tmp9_;
	_g_variant_unref0 (v7);
	v7 = _tmp10_;
	_g_variant_unref0 (v8);
	v8 = _tmp11_;
	_tmp12_ = vtemp0;
	zcd_serializer_variant_to_tuple_5 (_tmp12_, &_tmp13_, &_tmp14_, &_tmp15_, &_tmp16_, &_tmp17_);
	_g_variant_unref0 (v0);
	v0 = _tmp13_;
	_g_variant_unref0 (v1);
	v1 = _tmp14_;
	_g_variant_unref0 (v2);
	v2 = _tmp15_;
	_g_variant_unref0 (v3);
	v3 = _tmp16_;
	_g_variant_unref0 (v4);
	v4 = _tmp17_;
	_tmp18_ = v0;
	_tmp19_ = zcd_serializer_variant_to_int (_tmp18_);
	i_query_type = _tmp19_;
	_tmp20_ = v1;
	_tmp21_ = zcd_serializer_variant_to_int (_tmp20_);
	i_protocol = _tmp21_;
	_tmp22_ = v2;
	_tmp23_ = zcd_serializer_variant_to_int (_tmp22_);
	i_ip_version = _tmp23_;
	_tmp24_ = v3;
	_tmp25_ = zcd_serializer_variant_to_int (_tmp24_);
	i_ip_realm = _tmp25_;
	_tmp26_ = v4;
	_tmp27_ = zcd_serializer_variant_to_int (_tmp26_);
	i_recursion = _tmp27_;
	_tmp28_ = v5;
	_tmp29_ = zcd_serializer_variant_to_int (_tmp28_);
	i_compression = _tmp29_;
	_tmp30_ = v6;
	_tmp31_ = zcd_serializer_variant_to_string (_tmp30_);
	_tmp32_ = _tmp31_;
	andns_andna_query_set_hashed_domain (self, _tmp32_);
	_g_free0 (_tmp32_);
	_tmp33_ = g_object_new (NETSUKUKU_TYPE_ANDNA_SERVICE_KEY, NULL);
	_tmp34_ = G_IS_INITIALLY_UNOWNED (_tmp33_) ? g_object_ref_sink (_tmp33_) : _tmp33_;
	_tmp35_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, NETSUKUKU_TYPE_ANDNA_SERVICE_KEY, NetsukukuAndnaServiceKey);
	andns_andna_query_set_service (self, _tmp35_);
	_g_object_unref0 (_tmp35_);
	_tmp36_ = self->priv->_service;
	_tmp37_ = v7;
	zcd_iserializable_deserialize_from_variant ((zcdISerializable*) _tmp36_, _tmp37_, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZCD_SERIALIZER_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_variant_unref0 (vtemp1);
			_g_variant_unref0 (vtemp0);
			_g_variant_unref0 (vC);
			_g_variant_unref0 (vB);
			_g_variant_unref0 (vA);
			_g_variant_unref0 (v9);
			_g_variant_unref0 (v8);
			_g_variant_unref0 (v7);
			_g_variant_unref0 (v6);
			_g_variant_unref0 (v5);
			_g_variant_unref0 (v4);
			_g_variant_unref0 (v3);
			_g_variant_unref0 (v2);
			_g_variant_unref0 (v1);
			_g_variant_unref0 (v0);
			return;
		} else {
			_g_variant_unref0 (vtemp1);
			_g_variant_unref0 (vtemp0);
			_g_variant_unref0 (vC);
			_g_variant_unref0 (vB);
			_g_variant_unref0 (vA);
			_g_variant_unref0 (v9);
			_g_variant_unref0 (v8);
			_g_variant_unref0 (v7);
			_g_variant_unref0 (v6);
			_g_variant_unref0 (v5);
			_g_variant_unref0 (v4);
			_g_variant_unref0 (v3);
			_g_variant_unref0 (v2);
			_g_variant_unref0 (v1);
			_g_variant_unref0 (v0);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp38_ = v8;
	_tmp39_ = zcd_serializer_variant_to_string (_tmp38_);
	_tmp40_ = _tmp39_;
	andns_andna_query_set_inet_hostname (self, _tmp40_);
	_g_free0 (_tmp40_);
	_tmp41_ = v9;
	_tmp42_ = zcd_serializer_variant_to_int (_tmp41_);
	andns_andna_query_set_inet_service (self, _tmp42_);
	{
		guint8* buf;
		GObject* _tmp43_ = NULL;
		GObject* _tmp44_;
		zcdSerializableBuffer* buf_ser;
		zcdSerializableBuffer* _tmp45_;
		GVariant* _tmp46_;
		buf = self->ipv4_ip;
		_tmp43_ = g_object_new (ZCD_TYPE_SERIALIZABLE_BUFFER, NULL);
		_tmp44_ = G_IS_INITIALLY_UNOWNED (_tmp43_) ? g_object_ref_sink (_tmp43_) : _tmp43_;
		buf_ser = G_TYPE_CHECK_INSTANCE_CAST (_tmp44_, ZCD_TYPE_SERIALIZABLE_BUFFER, zcdSerializableBuffer);
		_tmp45_ = buf_ser;
		_tmp46_ = vA;
		zcd_iserializable_deserialize_from_variant ((zcdISerializable*) _tmp45_, _tmp46_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_SERIALIZER_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (buf_ser);
				_g_variant_unref0 (vtemp1);
				_g_variant_unref0 (vtemp0);
				_g_variant_unref0 (vC);
				_g_variant_unref0 (vB);
				_g_variant_unref0 (vA);
				_g_variant_unref0 (v9);
				_g_variant_unref0 (v8);
				_g_variant_unref0 (v7);
				_g_variant_unref0 (v6);
				_g_variant_unref0 (v5);
				_g_variant_unref0 (v4);
				_g_variant_unref0 (v3);
				_g_variant_unref0 (v2);
				_g_variant_unref0 (v1);
				_g_variant_unref0 (v0);
				return;
			} else {
				_g_object_unref0 (buf_ser);
				_g_variant_unref0 (vtemp1);
				_g_variant_unref0 (vtemp0);
				_g_variant_unref0 (vC);
				_g_variant_unref0 (vB);
				_g_variant_unref0 (vA);
				_g_variant_unref0 (v9);
				_g_variant_unref0 (v8);
				_g_variant_unref0 (v7);
				_g_variant_unref0 (v6);
				_g_variant_unref0 (v5);
				_g_variant_unref0 (v4);
				_g_variant_unref0 (v3);
				_g_variant_unref0 (v2);
				_g_variant_unref0 (v1);
				_g_variant_unref0 (v0);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		{
			gint i;
			i = 0;
			{
				gboolean _tmp47_;
				_tmp47_ = TRUE;
				while (TRUE) {
					gboolean _tmp48_;
					gint _tmp50_;
					zcdSerializableBuffer* _tmp51_;
					guint8* _tmp52_;
					gint _tmp52__length1;
					guint8* _tmp53_;
					gint _tmp53__length1;
					guint8* _tmp54_;
					gint _tmp55_;
					zcdSerializableBuffer* _tmp56_;
					guint8* _tmp57_;
					gint _tmp57__length1;
					guint8* _tmp58_;
					gint _tmp58__length1;
					gint _tmp59_;
					guint8 _tmp60_;
					guint8 _tmp61_;
					_tmp48_ = _tmp47_;
					if (!_tmp48_) {
						gint _tmp49_;
						_tmp49_ = i;
						i = _tmp49_ + 1;
					}
					_tmp47_ = FALSE;
					_tmp50_ = i;
					_tmp51_ = buf_ser;
					_tmp52_ = zcd_serializable_buffer_get_buffer (_tmp51_, &_tmp52__length1);
					_tmp53_ = _tmp52_;
					_tmp53__length1 = _tmp52__length1;
					if (!(_tmp50_ < _tmp53__length1)) {
						break;
					}
					_tmp54_ = buf;
					_tmp55_ = i;
					_tmp56_ = buf_ser;
					_tmp57_ = zcd_serializable_buffer_get_buffer (_tmp56_, &_tmp57__length1);
					_tmp58_ = _tmp57_;
					_tmp58__length1 = _tmp57__length1;
					_tmp59_ = i;
					_tmp60_ = _tmp58_[_tmp59_];
					_tmp54_[_tmp55_] = _tmp60_;
					_tmp61_ = _tmp54_[_tmp55_];
				}
			}
		}
		_g_object_unref0 (buf_ser);
	}
	{
		guint8* buf;
		GObject* _tmp62_ = NULL;
		GObject* _tmp63_;
		zcdSerializableBuffer* buf_ser;
		zcdSerializableBuffer* _tmp64_;
		GVariant* _tmp65_;
		buf = self->ipv6_ip;
		_tmp62_ = g_object_new (ZCD_TYPE_SERIALIZABLE_BUFFER, NULL);
		_tmp63_ = G_IS_INITIALLY_UNOWNED (_tmp62_) ? g_object_ref_sink (_tmp62_) : _tmp62_;
		buf_ser = G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, ZCD_TYPE_SERIALIZABLE_BUFFER, zcdSerializableBuffer);
		_tmp64_ = buf_ser;
		_tmp65_ = vB;
		zcd_iserializable_deserialize_from_variant ((zcdISerializable*) _tmp64_, _tmp65_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_SERIALIZER_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (buf_ser);
				_g_variant_unref0 (vtemp1);
				_g_variant_unref0 (vtemp0);
				_g_variant_unref0 (vC);
				_g_variant_unref0 (vB);
				_g_variant_unref0 (vA);
				_g_variant_unref0 (v9);
				_g_variant_unref0 (v8);
				_g_variant_unref0 (v7);
				_g_variant_unref0 (v6);
				_g_variant_unref0 (v5);
				_g_variant_unref0 (v4);
				_g_variant_unref0 (v3);
				_g_variant_unref0 (v2);
				_g_variant_unref0 (v1);
				_g_variant_unref0 (v0);
				return;
			} else {
				_g_object_unref0 (buf_ser);
				_g_variant_unref0 (vtemp1);
				_g_variant_unref0 (vtemp0);
				_g_variant_unref0 (vC);
				_g_variant_unref0 (vB);
				_g_variant_unref0 (vA);
				_g_variant_unref0 (v9);
				_g_variant_unref0 (v8);
				_g_variant_unref0 (v7);
				_g_variant_unref0 (v6);
				_g_variant_unref0 (v5);
				_g_variant_unref0 (v4);
				_g_variant_unref0 (v3);
				_g_variant_unref0 (v2);
				_g_variant_unref0 (v1);
				_g_variant_unref0 (v0);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		{
			gint i;
			i = 0;
			{
				gboolean _tmp66_;
				_tmp66_ = TRUE;
				while (TRUE) {
					gboolean _tmp67_;
					gint _tmp69_;
					zcdSerializableBuffer* _tmp70_;
					guint8* _tmp71_;
					gint _tmp71__length1;
					guint8* _tmp72_;
					gint _tmp72__length1;
					guint8* _tmp73_;
					gint _tmp74_;
					zcdSerializableBuffer* _tmp75_;
					guint8* _tmp76_;
					gint _tmp76__length1;
					guint8* _tmp77_;
					gint _tmp77__length1;
					gint _tmp78_;
					guint8 _tmp79_;
					guint8 _tmp80_;
					_tmp67_ = _tmp66_;
					if (!_tmp67_) {
						gint _tmp68_;
						_tmp68_ = i;
						i = _tmp68_ + 1;
					}
					_tmp66_ = FALSE;
					_tmp69_ = i;
					_tmp70_ = buf_ser;
					_tmp71_ = zcd_serializable_buffer_get_buffer (_tmp70_, &_tmp71__length1);
					_tmp72_ = _tmp71_;
					_tmp72__length1 = _tmp71__length1;
					if (!(_tmp69_ < _tmp72__length1)) {
						break;
					}
					_tmp73_ = buf;
					_tmp74_ = i;
					_tmp75_ = buf_ser;
					_tmp76_ = zcd_serializable_buffer_get_buffer (_tmp75_, &_tmp76__length1);
					_tmp77_ = _tmp76_;
					_tmp77__length1 = _tmp76__length1;
					_tmp78_ = i;
					_tmp79_ = _tmp77_[_tmp78_];
					_tmp73_[_tmp74_] = _tmp79_;
					_tmp80_ = _tmp73_[_tmp74_];
				}
			}
		}
		_g_object_unref0 (buf_ser);
	}
	_tmp81_ = vC;
	_tmp82_ = zcd_serializer_variant_to_string (_tmp81_);
	_tmp83_ = _tmp82_;
	andns_andna_query_set_global_hashed_domain (self, _tmp83_);
	_g_free0 (_tmp83_);
	_tmp84_ = i_query_type;
	andns_andna_query_set_query_type (self, (AndnsAndnaQueryType) _tmp84_);
	_tmp85_ = i_protocol;
	andns_andna_query_set_protocol (self, (AndnsAndnaQueryProtocol) _tmp85_);
	_tmp86_ = i_ip_version;
	andns_andna_query_set_ip_version (self, (AndnsAndnaQueryIPVersion) _tmp86_);
	_tmp87_ = i_ip_realm;
	andns_andna_query_set_ip_realm (self, (AndnsAndnaQueryRealm) _tmp87_);
	_tmp88_ = i_recursion;
	andns_andna_query_set_recursion (self, _tmp88_ == 1);
	_tmp89_ = i_compression;
	andns_andna_query_set_compression (self, _tmp89_ == 1);
	_g_variant_unref0 (vtemp1);
	_g_variant_unref0 (vtemp0);
	_g_variant_unref0 (vC);
	_g_variant_unref0 (vB);
	_g_variant_unref0 (vA);
	_g_variant_unref0 (v9);
	_g_variant_unref0 (v8);
	_g_variant_unref0 (v7);
	_g_variant_unref0 (v6);
	_g_variant_unref0 (v5);
	_g_variant_unref0 (v4);
	_g_variant_unref0 (v3);
	_g_variant_unref0 (v2);
	_g_variant_unref0 (v1);
	_g_variant_unref0 (v0);
}


AndnsAndnaQuery* andns_andna_query_construct (GType object_type) {
	AndnsAndnaQuery * self = NULL;
	self = (AndnsAndnaQuery*) g_object_new (object_type, NULL);
	return self;
}


AndnsAndnaQuery* andns_andna_query_new (void) {
	return andns_andna_query_construct (ANDNS_TYPE_ANDNA_QUERY);
}


AndnsAndnaQueryType andns_andna_query_get_query_type (AndnsAndnaQuery* self) {
	AndnsAndnaQueryType result;
	AndnsAndnaQueryType _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_query_type;
	result = _tmp0_;
	return result;
}


static void andns_andna_query_set_query_type (AndnsAndnaQuery* self, AndnsAndnaQueryType value) {
	AndnsAndnaQueryType _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_query_type = _tmp0_;
	g_object_notify ((GObject *) self, "query-type");
}


gboolean andns_andna_query_get_recursion (AndnsAndnaQuery* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_recursion;
	result = _tmp0_;
	return result;
}


static void andns_andna_query_set_recursion (AndnsAndnaQuery* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_recursion = _tmp0_;
	g_object_notify ((GObject *) self, "recursion");
}


gboolean andns_andna_query_get_compression (AndnsAndnaQuery* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_compression;
	result = _tmp0_;
	return result;
}


static void andns_andna_query_set_compression (AndnsAndnaQuery* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_compression = _tmp0_;
	g_object_notify ((GObject *) self, "compression");
}


AndnsAndnaQueryProtocol andns_andna_query_get_protocol (AndnsAndnaQuery* self) {
	AndnsAndnaQueryProtocol result;
	AndnsAndnaQueryProtocol _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_protocol;
	result = _tmp0_;
	return result;
}


static void andns_andna_query_set_protocol (AndnsAndnaQuery* self, AndnsAndnaQueryProtocol value) {
	AndnsAndnaQueryProtocol _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_protocol = _tmp0_;
	g_object_notify ((GObject *) self, "protocol");
}


AndnsAndnaQueryIPVersion andns_andna_query_get_ip_version (AndnsAndnaQuery* self) {
	AndnsAndnaQueryIPVersion result;
	AndnsAndnaQueryIPVersion _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_ip_version;
	result = _tmp0_;
	return result;
}


static void andns_andna_query_set_ip_version (AndnsAndnaQuery* self, AndnsAndnaQueryIPVersion value) {
	AndnsAndnaQueryIPVersion _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_ip_version = _tmp0_;
	g_object_notify ((GObject *) self, "ip-version");
}


AndnsAndnaQueryRealm andns_andna_query_get_ip_realm (AndnsAndnaQuery* self) {
	AndnsAndnaQueryRealm result;
	AndnsAndnaQueryRealm _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_ip_realm;
	result = _tmp0_;
	return result;
}


static void andns_andna_query_set_ip_realm (AndnsAndnaQuery* self, AndnsAndnaQueryRealm value) {
	AndnsAndnaQueryRealm _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_ip_realm = _tmp0_;
	g_object_notify ((GObject *) self, "ip-realm");
}


const gchar* andns_andna_query_get_hashed_domain (AndnsAndnaQuery* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_hashed_domain;
	result = _tmp0_;
	return result;
}


static void andns_andna_query_set_hashed_domain (AndnsAndnaQuery* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_hashed_domain);
	self->priv->_hashed_domain = _tmp1_;
	g_object_notify ((GObject *) self, "hashed-domain");
}


NetsukukuAndnaServiceKey* andns_andna_query_get_service (AndnsAndnaQuery* self) {
	NetsukukuAndnaServiceKey* result;
	NetsukukuAndnaServiceKey* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_service;
	result = _tmp0_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void andns_andna_query_set_service (AndnsAndnaQuery* self, NetsukukuAndnaServiceKey* value) {
	NetsukukuAndnaServiceKey* _tmp0_;
	NetsukukuAndnaServiceKey* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_service);
	self->priv->_service = _tmp1_;
	g_object_notify ((GObject *) self, "service");
}


const gchar* andns_andna_query_get_inet_hostname (AndnsAndnaQuery* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_inet_hostname;
	result = _tmp0_;
	return result;
}


static void andns_andna_query_set_inet_hostname (AndnsAndnaQuery* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_inet_hostname);
	self->priv->_inet_hostname = _tmp1_;
	g_object_notify ((GObject *) self, "inet-hostname");
}


gint andns_andna_query_get_inet_service (AndnsAndnaQuery* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_inet_service;
	result = _tmp0_;
	return result;
}


static void andns_andna_query_set_inet_service (AndnsAndnaQuery* self, gint value) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_inet_service = _tmp0_;
	g_object_notify ((GObject *) self, "inet-service");
}


const gchar* andns_andna_query_get_global_hashed_domain (AndnsAndnaQuery* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_global_hashed_domain;
	result = _tmp0_;
	return result;
}


static void andns_andna_query_set_global_hashed_domain (AndnsAndnaQuery* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_global_hashed_domain);
	self->priv->_global_hashed_domain = _tmp1_;
	g_object_notify ((GObject *) self, "global-hashed-domain");
}


static void andns_andna_query_class_init (AndnsAndnaQueryClass * klass) {
	andns_andna_query_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (AndnsAndnaQueryPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_andns_andna_query_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_andns_andna_query_set_property;
	G_OBJECT_CLASS (klass)->finalize = andns_andna_query_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ANDNS_ANDNA_QUERY_QUERY_TYPE, g_param_spec_enum ("query-type", "query-type", "query-type", ANDNS_TYPE_ANDNA_QUERY_TYPE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ANDNS_ANDNA_QUERY_RECURSION, g_param_spec_boolean ("recursion", "recursion", "recursion", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ANDNS_ANDNA_QUERY_COMPRESSION, g_param_spec_boolean ("compression", "compression", "compression", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ANDNS_ANDNA_QUERY_PROTOCOL, g_param_spec_enum ("protocol", "protocol", "protocol", ANDNS_TYPE_ANDNA_QUERY_PROTOCOL, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ANDNS_ANDNA_QUERY_IP_VERSION, g_param_spec_enum ("ip-version", "ip-version", "ip-version", ANDNS_TYPE_ANDNA_QUERY_IP_VERSION, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ANDNS_ANDNA_QUERY_IP_REALM, g_param_spec_enum ("ip-realm", "ip-realm", "ip-realm", ANDNS_TYPE_ANDNA_QUERY_REALM, ANDNS_ANDNA_QUERY_REALM_NTK, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ANDNS_ANDNA_QUERY_HASHED_DOMAIN, g_param_spec_string ("hashed-domain", "hashed-domain", "hashed-domain", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ANDNS_ANDNA_QUERY_SERVICE, g_param_spec_object ("service", "service", "service", NETSUKUKU_TYPE_ANDNA_SERVICE_KEY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ANDNS_ANDNA_QUERY_INET_HOSTNAME, g_param_spec_string ("inet-hostname", "inet-hostname", "inet-hostname", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ANDNS_ANDNA_QUERY_INET_SERVICE, g_param_spec_int ("inet-service", "inet-service", "inet-service", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ANDNS_ANDNA_QUERY_GLOBAL_HASHED_DOMAIN, g_param_spec_string ("global-hashed-domain", "global-hashed-domain", "global-hashed-domain", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void andns_andna_query_zcd_iserializable_interface_init (zcdISerializableIface * iface) {
	andns_andna_query_zcd_iserializable_parent_iface = g_type_interface_peek_parent (iface);
	iface->serialize_to_variant = (GVariant* (*)(zcdISerializable*)) andns_andna_query_real_serialize_to_variant;
	iface->deserialize_from_variant = (void (*)(zcdISerializable*, GVariant*, GError**)) andns_andna_query_real_deserialize_from_variant;
}


static void andns_andna_query_instance_init (AndnsAndnaQuery * self) {
	self->priv = ANDNS_ANDNA_QUERY_GET_PRIVATE (self);
	self->priv->_ip_realm = ANDNS_ANDNA_QUERY_REALM_NTK;
}


static void andns_andna_query_finalize (GObject* obj) {
	AndnsAndnaQuery * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ANDNS_TYPE_ANDNA_QUERY, AndnsAndnaQuery);
	_g_free0 (self->priv->_hashed_domain);
	_g_object_unref0 (self->priv->_service);
	_g_free0 (self->priv->_inet_hostname);
	_g_free0 (self->priv->_global_hashed_domain);
	G_OBJECT_CLASS (andns_andna_query_parent_class)->finalize (obj);
}


/** A query.
      */
GType andns_andna_query_get_type (void) {
	static volatile gsize andns_andna_query_type_id__volatile = 0;
	if (g_once_init_enter (&andns_andna_query_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AndnsAndnaQueryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) andns_andna_query_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AndnsAndnaQuery), 0, (GInstanceInitFunc) andns_andna_query_instance_init, NULL };
		static const GInterfaceInfo zcd_iserializable_info = { (GInterfaceInitFunc) andns_andna_query_zcd_iserializable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType andns_andna_query_type_id;
		andns_andna_query_type_id = g_type_register_static (G_TYPE_OBJECT, "AndnsAndnaQuery", &g_define_type_info, 0);
		g_type_add_interface_static (andns_andna_query_type_id, ZCD_TYPE_ISERIALIZABLE, &zcd_iserializable_info);
		g_once_init_leave (&andns_andna_query_type_id__volatile, andns_andna_query_type_id);
	}
	return andns_andna_query_type_id__volatile;
}


static void _vala_andns_andna_query_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	AndnsAndnaQuery * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ANDNS_TYPE_ANDNA_QUERY, AndnsAndnaQuery);
	switch (property_id) {
		case ANDNS_ANDNA_QUERY_QUERY_TYPE:
		g_value_set_enum (value, andns_andna_query_get_query_type (self));
		break;
		case ANDNS_ANDNA_QUERY_RECURSION:
		g_value_set_boolean (value, andns_andna_query_get_recursion (self));
		break;
		case ANDNS_ANDNA_QUERY_COMPRESSION:
		g_value_set_boolean (value, andns_andna_query_get_compression (self));
		break;
		case ANDNS_ANDNA_QUERY_PROTOCOL:
		g_value_set_enum (value, andns_andna_query_get_protocol (self));
		break;
		case ANDNS_ANDNA_QUERY_IP_VERSION:
		g_value_set_enum (value, andns_andna_query_get_ip_version (self));
		break;
		case ANDNS_ANDNA_QUERY_IP_REALM:
		g_value_set_enum (value, andns_andna_query_get_ip_realm (self));
		break;
		case ANDNS_ANDNA_QUERY_HASHED_DOMAIN:
		g_value_set_string (value, andns_andna_query_get_hashed_domain (self));
		break;
		case ANDNS_ANDNA_QUERY_SERVICE:
		g_value_set_object (value, andns_andna_query_get_service (self));
		break;
		case ANDNS_ANDNA_QUERY_INET_HOSTNAME:
		g_value_set_string (value, andns_andna_query_get_inet_hostname (self));
		break;
		case ANDNS_ANDNA_QUERY_INET_SERVICE:
		g_value_set_int (value, andns_andna_query_get_inet_service (self));
		break;
		case ANDNS_ANDNA_QUERY_GLOBAL_HASHED_DOMAIN:
		g_value_set_string (value, andns_andna_query_get_global_hashed_domain (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_andns_andna_query_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	AndnsAndnaQuery * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ANDNS_TYPE_ANDNA_QUERY, AndnsAndnaQuery);
	switch (property_id) {
		case ANDNS_ANDNA_QUERY_QUERY_TYPE:
		andns_andna_query_set_query_type (self, g_value_get_enum (value));
		break;
		case ANDNS_ANDNA_QUERY_RECURSION:
		andns_andna_query_set_recursion (self, g_value_get_boolean (value));
		break;
		case ANDNS_ANDNA_QUERY_COMPRESSION:
		andns_andna_query_set_compression (self, g_value_get_boolean (value));
		break;
		case ANDNS_ANDNA_QUERY_PROTOCOL:
		andns_andna_query_set_protocol (self, g_value_get_enum (value));
		break;
		case ANDNS_ANDNA_QUERY_IP_VERSION:
		andns_andna_query_set_ip_version (self, g_value_get_enum (value));
		break;
		case ANDNS_ANDNA_QUERY_IP_REALM:
		andns_andna_query_set_ip_realm (self, g_value_get_enum (value));
		break;
		case ANDNS_ANDNA_QUERY_HASHED_DOMAIN:
		andns_andna_query_set_hashed_domain (self, g_value_get_string (value));
		break;
		case ANDNS_ANDNA_QUERY_SERVICE:
		andns_andna_query_set_service (self, g_value_get_object (value));
		break;
		case ANDNS_ANDNA_QUERY_INET_HOSTNAME:
		andns_andna_query_set_inet_hostname (self, g_value_get_string (value));
		break;
		case ANDNS_ANDNA_QUERY_INET_SERVICE:
		andns_andna_query_set_inet_service (self, g_value_get_int (value));
		break;
		case ANDNS_ANDNA_QUERY_GLOBAL_HASHED_DOMAIN:
		andns_andna_query_set_global_hashed_domain (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static gboolean _andns_andna_response_answer_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gboolean result;
	result = andns_andna_response_answer_equal_func (a, b);
	return result;
}


AndnsAndnaResponse* andns_andna_response_construct (GType object_type, AndnsAndnaResponseCode _rcode, GeeArrayList* _answers) {
	AndnsAndnaResponse * self = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	AndnsAndnaResponseCode _tmp4_;
	g_return_val_if_fail (_answers != NULL, NULL);
	self = (AndnsAndnaResponse*) g_object_new (object_type, NULL);
	_tmp0_ = gee_array_list_new (ANDNS_TYPE_ANDNA_RESPONSE_ANSWER, (GBoxedCopyFunc) g_object_ref, g_object_unref, _andns_andna_response_answer_equal_func_gee_equal_data_func, NULL, NULL);
	_tmp1_ = _tmp0_;
	andns_andna_response_set_answers (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = self->priv->_answers;
	_tmp3_ = _answers;
	gee_array_list_add_all (_tmp2_, (GeeCollection*) _tmp3_);
	_tmp4_ = _rcode;
	andns_andna_response_set_rcode (self, _tmp4_);
	return self;
}


AndnsAndnaResponse* andns_andna_response_new (AndnsAndnaResponseCode _rcode, GeeArrayList* _answers) {
	return andns_andna_response_construct (ANDNS_TYPE_ANDNA_RESPONSE, _rcode, _answers);
}


static GVariant* andns_andna_response_real_serialize_to_variant (zcdISerializable* base) {
	AndnsAndnaResponse * self;
	GVariant* result = NULL;
	AndnsAndnaResponseCode _tmp0_;
	gint i_rcode;
	gint _tmp1_;
	GVariant* _tmp2_ = NULL;
	GVariant* v0;
	GVariant* v1 = NULL;
	GVariant* _tmp19_;
	GVariant* _tmp20_ = NULL;
	GVariant* vret;
	self = (AndnsAndnaResponse*) base;
	_tmp0_ = self->priv->_rcode;
	i_rcode = (gint) _tmp0_;
	_tmp1_ = i_rcode;
	_tmp2_ = zcd_serializer_int_to_variant (_tmp1_);
	v0 = _tmp2_;
	{
		zcdListISerializable* _tmp3_;
		zcdListISerializable* lst;
		zcdListISerializable* _tmp17_;
		GVariant* _tmp18_ = NULL;
		_tmp3_ = zcd_list_iserializable_new ();
		lst = _tmp3_;
		{
			GeeArrayList* _tmp4_;
			GeeArrayList* _tmp5_;
			GeeArrayList* _o_list;
			GeeArrayList* _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			gint _o_size;
			gint _o_index;
			_tmp4_ = self->priv->_answers;
			_tmp5_ = _g_object_ref0 (_tmp4_);
			_o_list = _tmp5_;
			_tmp6_ = _o_list;
			_tmp7_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp6_);
			_tmp8_ = _tmp7_;
			_o_size = _tmp8_;
			_o_index = -1;
			while (TRUE) {
				gint _tmp9_;
				gint _tmp10_;
				gint _tmp11_;
				GeeArrayList* _tmp12_;
				gint _tmp13_;
				gpointer _tmp14_ = NULL;
				AndnsAndnaResponseAnswer* o;
				zcdListISerializable* _tmp15_;
				AndnsAndnaResponseAnswer* _tmp16_;
				_tmp9_ = _o_index;
				_o_index = _tmp9_ + 1;
				_tmp10_ = _o_index;
				_tmp11_ = _o_size;
				if (!(_tmp10_ < _tmp11_)) {
					break;
				}
				_tmp12_ = _o_list;
				_tmp13_ = _o_index;
				_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, _tmp13_);
				o = (AndnsAndnaResponseAnswer*) _tmp14_;
				_tmp15_ = lst;
				_tmp16_ = o;
				zcd_list_iserializable_add (_tmp15_, (zcdISerializable*) _tmp16_);
				_g_object_unref0 (o);
			}
			_g_object_unref0 (_o_list);
		}
		_tmp17_ = lst;
		_tmp18_ = zcd_iserializable_serialize_to_variant ((zcdISerializable*) _tmp17_);
		_g_variant_unref0 (v1);
		v1 = _tmp18_;
		_g_object_unref0 (lst);
	}
	_tmp19_ = v0;
	_tmp20_ = zcd_serializer_tuple_to_variant (_tmp19_, v1);
	vret = _tmp20_;
	result = vret;
	_g_variant_unref0 (v1);
	_g_variant_unref0 (v0);
	return result;
}


static void andns_andna_response_real_deserialize_from_variant (zcdISerializable* base, GVariant* v, GError** error) {
	AndnsAndnaResponse * self;
	GVariant* v0 = NULL;
	GVariant* v1 = NULL;
	GVariant* _tmp0_;
	GVariant* _tmp1_ = NULL;
	GVariant* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint i_rcode;
	GeeArrayList* _tmp4_;
	GeeArrayList* _tmp5_;
	GError * _inner_error_ = NULL;
	self = (AndnsAndnaResponse*) base;
	g_return_if_fail (v != NULL);
	_tmp0_ = v;
	zcd_serializer_variant_to_tuple (_tmp0_, &_tmp1_, &_tmp2_);
	_g_variant_unref0 (v0);
	v0 = _tmp1_;
	_g_variant_unref0 (v1);
	v1 = _tmp2_;
	_tmp3_ = zcd_serializer_variant_to_int (v0);
	i_rcode = _tmp3_;
	andns_andna_response_set_rcode (self, (AndnsAndnaResponseCode) i_rcode);
	_tmp4_ = gee_array_list_new (ANDNS_TYPE_ANDNA_RESPONSE_ANSWER, (GBoxedCopyFunc) g_object_ref, g_object_unref, _andns_andna_response_answer_equal_func_gee_equal_data_func, NULL, NULL);
	_tmp5_ = _tmp4_;
	andns_andna_response_set_answers (self, _tmp5_);
	_g_object_unref0 (_tmp5_);
	{
		GObject* _tmp6_ = NULL;
		GObject* _tmp7_;
		zcdListISerializable* lst;
		GeeList* _tmp8_;
		GeeList* _tmp9_;
		GeeList* typed_lst;
		GeeArrayList* _tmp10_;
		GeeList* _tmp11_;
		_tmp6_ = g_object_new (ZCD_TYPE_LIST_ISERIALIZABLE, NULL);
		_tmp7_ = G_IS_INITIALLY_UNOWNED (_tmp6_) ? g_object_ref_sink (_tmp6_) : _tmp6_;
		lst = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, ZCD_TYPE_LIST_ISERIALIZABLE, zcdListISerializable);
		zcd_iserializable_deserialize_from_variant ((zcdISerializable*) lst, v1, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_SERIALIZER_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (lst);
				_g_variant_unref0 (v1);
				_g_variant_unref0 (v0);
				return;
			} else {
				_g_object_unref0 (lst);
				_g_variant_unref0 (v1);
				_g_variant_unref0 (v0);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp8_ = lst->backed;
		_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_LIST, GeeList));
		typed_lst = _tmp9_;
		_tmp10_ = self->priv->_answers;
		_tmp11_ = typed_lst;
		gee_array_list_add_all (_tmp10_, (GeeCollection*) _tmp11_);
		_g_object_unref0 (typed_lst);
		_g_object_unref0 (lst);
	}
	_g_variant_unref0 (v1);
	_g_variant_unref0 (v0);
}


AndnsAndnaResponseCode andns_andna_response_get_rcode (AndnsAndnaResponse* self) {
	AndnsAndnaResponseCode result;
	AndnsAndnaResponseCode _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_rcode;
	result = _tmp0_;
	return result;
}


static void andns_andna_response_set_rcode (AndnsAndnaResponse* self, AndnsAndnaResponseCode value) {
	AndnsAndnaResponseCode _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_rcode = _tmp0_;
	g_object_notify ((GObject *) self, "rcode");
}


GeeArrayList* andns_andna_response_get_answers (AndnsAndnaResponse* self) {
	GeeArrayList* result;
	GeeArrayList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_answers;
	result = _tmp0_;
	return result;
}


static void andns_andna_response_set_answers (AndnsAndnaResponse* self, GeeArrayList* value) {
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_answers);
	self->priv->_answers = _tmp1_;
	g_object_notify ((GObject *) self, "answers");
}


static void andns_andna_response_class_init (AndnsAndnaResponseClass * klass) {
	andns_andna_response_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (AndnsAndnaResponsePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_andns_andna_response_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_andns_andna_response_set_property;
	G_OBJECT_CLASS (klass)->finalize = andns_andna_response_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ANDNS_ANDNA_RESPONSE_RCODE, g_param_spec_enum ("rcode", "rcode", "rcode", ANDNS_TYPE_ANDNA_RESPONSE_CODE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ANDNS_ANDNA_RESPONSE_ANSWERS, g_param_spec_object ("answers", "answers", "answers", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void andns_andna_response_zcd_iserializable_interface_init (zcdISerializableIface * iface) {
	andns_andna_response_zcd_iserializable_parent_iface = g_type_interface_peek_parent (iface);
	iface->serialize_to_variant = (GVariant* (*)(zcdISerializable*)) andns_andna_response_real_serialize_to_variant;
	iface->deserialize_from_variant = (void (*)(zcdISerializable*, GVariant*, GError**)) andns_andna_response_real_deserialize_from_variant;
}


static void andns_andna_response_instance_init (AndnsAndnaResponse * self) {
	self->priv = ANDNS_ANDNA_RESPONSE_GET_PRIVATE (self);
}


static void andns_andna_response_finalize (GObject* obj) {
	AndnsAndnaResponse * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ANDNS_TYPE_ANDNA_RESPONSE, AndnsAndnaResponse);
	_g_object_unref0 (self->priv->_answers);
	G_OBJECT_CLASS (andns_andna_response_parent_class)->finalize (obj);
}


/** A response (list of answers).
      */
GType andns_andna_response_get_type (void) {
	static volatile gsize andns_andna_response_type_id__volatile = 0;
	if (g_once_init_enter (&andns_andna_response_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AndnsAndnaResponseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) andns_andna_response_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AndnsAndnaResponse), 0, (GInstanceInitFunc) andns_andna_response_instance_init, NULL };
		static const GInterfaceInfo zcd_iserializable_info = { (GInterfaceInitFunc) andns_andna_response_zcd_iserializable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType andns_andna_response_type_id;
		andns_andna_response_type_id = g_type_register_static (G_TYPE_OBJECT, "AndnsAndnaResponse", &g_define_type_info, 0);
		g_type_add_interface_static (andns_andna_response_type_id, ZCD_TYPE_ISERIALIZABLE, &zcd_iserializable_info);
		g_once_init_leave (&andns_andna_response_type_id__volatile, andns_andna_response_type_id);
	}
	return andns_andna_response_type_id__volatile;
}


static void _vala_andns_andna_response_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	AndnsAndnaResponse * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ANDNS_TYPE_ANDNA_RESPONSE, AndnsAndnaResponse);
	switch (property_id) {
		case ANDNS_ANDNA_RESPONSE_RCODE:
		g_value_set_enum (value, andns_andna_response_get_rcode (self));
		break;
		case ANDNS_ANDNA_RESPONSE_ANSWERS:
		g_value_set_object (value, andns_andna_response_get_answers (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_andns_andna_response_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	AndnsAndnaResponse * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ANDNS_TYPE_ANDNA_RESPONSE, AndnsAndnaResponse);
	switch (property_id) {
		case ANDNS_ANDNA_RESPONSE_RCODE:
		andns_andna_response_set_rcode (self, g_value_get_enum (value));
		break;
		case ANDNS_ANDNA_RESPONSE_ANSWERS:
		andns_andna_response_set_answers (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static AndnsAndnaResponseAnswer* andns_andna_response_answer_construct_priv (GType object_type) {
	AndnsAndnaResponseAnswer * self = NULL;
	NetsukukuAndnaServiceKey* _tmp0_;
	NetsukukuAndnaServiceKey* _tmp1_;
	self = (AndnsAndnaResponseAnswer*) g_object_new (object_type, NULL);
	andns_andna_response_answer_set_hashed_alias (self, "");
	_tmp0_ = netsukuku_andna_service_key_get_NULL_SERV_KEY ();
	_tmp1_ = _tmp0_;
	andns_andna_response_answer_set_gl_service (self, _tmp1_);
	andns_andna_response_answer_set_hostname (self, "");
	andns_andna_response_answer_set_gl_hashed_alias (self, "");
	return self;
}


static AndnsAndnaResponseAnswer* andns_andna_response_answer_new_priv (void) {
	return andns_andna_response_answer_construct_priv (ANDNS_TYPE_ANDNA_RESPONSE_ANSWER);
}


AndnsAndnaResponseAnswer* andns_andna_response_answer_construct_name_to_ip (GType object_type, gint weight, gint priority, guint8* ipv4_ip, int ipv4_ip_length1, guint16 port_number) {
	AndnsAndnaResponseAnswer * self = NULL;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	guint16 _tmp13_;
	self = (AndnsAndnaResponseAnswer*) andns_andna_response_answer_construct_priv (object_type);
	andns_andna_response_answer_set_is_ip (self, TRUE);
	_tmp0_ = weight;
	andns_andna_response_answer_set_weight (self, _tmp0_);
	_tmp1_ = priority;
	andns_andna_response_answer_set_priority (self, _tmp1_);
	_tmp2_ = ipv4_ip;
	_tmp2__length1 = ipv4_ip_length1;
	_vala_assert (4 == _tmp2__length1, "this.ipv4_ip.length == ipv4_ip.length");
	{
		gint i;
		i = 0;
		{
			gboolean _tmp3_;
			_tmp3_ = TRUE;
			while (TRUE) {
				gboolean _tmp4_;
				gint _tmp6_;
				guint8* _tmp7_;
				gint _tmp7__length1;
				gint _tmp8_;
				guint8* _tmp9_;
				gint _tmp9__length1;
				gint _tmp10_;
				guint8 _tmp11_;
				guint8 _tmp12_;
				_tmp4_ = _tmp3_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp6_ = i;
				_tmp7_ = ipv4_ip;
				_tmp7__length1 = ipv4_ip_length1;
				if (!(_tmp6_ < _tmp7__length1)) {
					break;
				}
				_tmp8_ = i;
				_tmp9_ = ipv4_ip;
				_tmp9__length1 = ipv4_ip_length1;
				_tmp10_ = i;
				_tmp11_ = _tmp9_[_tmp10_];
				self->ipv4_ip[_tmp8_] = _tmp11_;
				_tmp12_ = self->ipv4_ip[_tmp8_];
			}
		}
	}
	_tmp13_ = port_number;
	andns_andna_response_answer_set_port_number (self, _tmp13_);
	return self;
}


AndnsAndnaResponseAnswer* andns_andna_response_answer_new_name_to_ip (gint weight, gint priority, guint8* ipv4_ip, int ipv4_ip_length1, guint16 port_number) {
	return andns_andna_response_answer_construct_name_to_ip (ANDNS_TYPE_ANDNA_RESPONSE_ANSWER, weight, priority, ipv4_ip, ipv4_ip_length1, port_number);
}


AndnsAndnaResponseAnswer* andns_andna_response_answer_construct_name_to_ip_v6 (GType object_type, gint weight, gint priority, guint8* ipv6_ip, int ipv6_ip_length1, guint16 port_number) {
	AndnsAndnaResponseAnswer * self = NULL;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	guint16 _tmp13_;
	self = (AndnsAndnaResponseAnswer*) andns_andna_response_answer_construct_priv (object_type);
	andns_andna_response_answer_set_is_ip (self, TRUE);
	_tmp0_ = weight;
	andns_andna_response_answer_set_weight (self, _tmp0_);
	_tmp1_ = priority;
	andns_andna_response_answer_set_priority (self, _tmp1_);
	_tmp2_ = ipv6_ip;
	_tmp2__length1 = ipv6_ip_length1;
	_vala_assert (16 == _tmp2__length1, "this.ipv6_ip.length == ipv6_ip.length");
	{
		gint i;
		i = 0;
		{
			gboolean _tmp3_;
			_tmp3_ = TRUE;
			while (TRUE) {
				gboolean _tmp4_;
				gint _tmp6_;
				guint8* _tmp7_;
				gint _tmp7__length1;
				gint _tmp8_;
				guint8* _tmp9_;
				gint _tmp9__length1;
				gint _tmp10_;
				guint8 _tmp11_;
				guint8 _tmp12_;
				_tmp4_ = _tmp3_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp6_ = i;
				_tmp7_ = ipv6_ip;
				_tmp7__length1 = ipv6_ip_length1;
				if (!(_tmp6_ < _tmp7__length1)) {
					break;
				}
				_tmp8_ = i;
				_tmp9_ = ipv6_ip;
				_tmp9__length1 = ipv6_ip_length1;
				_tmp10_ = i;
				_tmp11_ = _tmp9_[_tmp10_];
				self->ipv6_ip[_tmp8_] = _tmp11_;
				_tmp12_ = self->ipv6_ip[_tmp8_];
			}
		}
	}
	_tmp13_ = port_number;
	andns_andna_response_answer_set_port_number (self, _tmp13_);
	return self;
}


AndnsAndnaResponseAnswer* andns_andna_response_answer_new_name_to_ip_v6 (gint weight, gint priority, guint8* ipv6_ip, int ipv6_ip_length1, guint16 port_number) {
	return andns_andna_response_answer_construct_name_to_ip_v6 (ANDNS_TYPE_ANDNA_RESPONSE_ANSWER, weight, priority, ipv6_ip, ipv6_ip_length1, port_number);
}


AndnsAndnaResponseAnswer* andns_andna_response_answer_construct_name_to_alias (GType object_type, gint weight, gint priority, const gchar* hashed_alias, guint16 port_number) {
	AndnsAndnaResponseAnswer * self = NULL;
	gint _tmp0_;
	gint _tmp1_;
	const gchar* _tmp2_;
	guint16 _tmp3_;
	g_return_val_if_fail (hashed_alias != NULL, NULL);
	self = (AndnsAndnaResponseAnswer*) andns_andna_response_answer_construct_priv (object_type);
	andns_andna_response_answer_set_is_ip (self, FALSE);
	_tmp0_ = weight;
	andns_andna_response_answer_set_weight (self, _tmp0_);
	_tmp1_ = priority;
	andns_andna_response_answer_set_priority (self, _tmp1_);
	_tmp2_ = hashed_alias;
	andns_andna_response_answer_set_hashed_alias (self, _tmp2_);
	_tmp3_ = port_number;
	andns_andna_response_answer_set_port_number (self, _tmp3_);
	return self;
}


AndnsAndnaResponseAnswer* andns_andna_response_answer_new_name_to_alias (gint weight, gint priority, const gchar* hashed_alias, guint16 port_number) {
	return andns_andna_response_answer_construct_name_to_alias (ANDNS_TYPE_ANDNA_RESPONSE_ANSWER, weight, priority, hashed_alias, port_number);
}


AndnsAndnaResponseAnswer* andns_andna_response_answer_construct_ip_to_name (GType object_type, const gchar* hostname) {
	AndnsAndnaResponseAnswer * self = NULL;
	const gchar* _tmp0_;
	g_return_val_if_fail (hostname != NULL, NULL);
	self = (AndnsAndnaResponseAnswer*) andns_andna_response_answer_construct_priv (object_type);
	_tmp0_ = hostname;
	andns_andna_response_answer_set_hostname (self, _tmp0_);
	return self;
}


AndnsAndnaResponseAnswer* andns_andna_response_answer_new_ip_to_name (const gchar* hostname) {
	return andns_andna_response_answer_construct_ip_to_name (ANDNS_TYPE_ANDNA_RESPONSE_ANSWER, hostname);
}


static GVariant* andns_andna_response_answer_real_serialize_to_variant (zcdISerializable* base) {
	AndnsAndnaResponseAnswer * self;
	GVariant* result = NULL;
	gint _tmp0_ = 0;
	gboolean _tmp1_;
	gint _tmp2_;
	gint i_is_ip;
	gint _tmp3_ = 0;
	gboolean _tmp4_;
	gint _tmp5_;
	gint i_gl_is_ip;
	gint _tmp6_ = 0;
	gboolean _tmp7_;
	gint _tmp8_;
	gint i_gl_is_main;
	zcdSerializableBuffer* _tmp9_;
	zcdSerializableBuffer* b_ipv4_ip;
	zcdSerializableBuffer* _tmp10_;
	zcdSerializableBuffer* b_ipv6_ip;
	zcdSerializableBuffer* _tmp11_;
	zcdSerializableBuffer* b_gl_ipv4_ip;
	zcdSerializableBuffer* _tmp12_;
	zcdSerializableBuffer* b_gl_ipv6_ip;
	gint _tmp13_;
	GVariant* _tmp14_ = NULL;
	GVariant* v0;
	gint _tmp15_;
	GVariant* _tmp16_ = NULL;
	GVariant* v1;
	gint _tmp17_;
	GVariant* _tmp18_ = NULL;
	GVariant* v2;
	GVariant* _tmp19_ = NULL;
	GVariant* v3;
	GVariant* _tmp20_ = NULL;
	GVariant* v4;
	GVariant* _tmp21_ = NULL;
	GVariant* v5;
	const gchar* _tmp22_;
	GVariant* _tmp23_ = NULL;
	GVariant* v6;
	guint16 _tmp24_;
	GVariant* _tmp25_ = NULL;
	GVariant* v7;
	const gchar* _tmp26_;
	GVariant* _tmp27_ = NULL;
	GVariant* v8;
	GVariant* _tmp28_ = NULL;
	GVariant* v9;
	gint _tmp29_;
	GVariant* _tmp30_ = NULL;
	GVariant* vA;
	NetsukukuAndnaServiceKey* _tmp31_;
	GVariant* _tmp32_ = NULL;
	GVariant* vB;
	gint _tmp33_;
	GVariant* _tmp34_ = NULL;
	GVariant* vC;
	gint _tmp35_;
	GVariant* _tmp36_ = NULL;
	GVariant* vD;
	GVariant* _tmp37_ = NULL;
	GVariant* vE;
	GVariant* _tmp38_ = NULL;
	GVariant* vF;
	GVariant* _tmp39_ = NULL;
	GVariant* vG;
	const gchar* _tmp40_;
	GVariant* _tmp41_ = NULL;
	GVariant* vH;
	guint16 _tmp42_;
	GVariant* _tmp43_ = NULL;
	GVariant* vJ;
	GVariant* _tmp44_ = NULL;
	GVariant* vK;
	GVariant* _tmp45_ = NULL;
	GVariant* vtemp0;
	GVariant* _tmp46_ = NULL;
	GVariant* vtemp1;
	GVariant* _tmp47_ = NULL;
	GVariant* vtemp2;
	GVariant* _tmp48_ = NULL;
	GVariant* vtemp3;
	GVariant* _tmp49_ = NULL;
	GVariant* vret;
	self = (AndnsAndnaResponseAnswer*) base;
	_tmp1_ = self->priv->_is_ip;
	if (_tmp1_) {
		_tmp0_ = 1;
	} else {
		_tmp0_ = 0;
	}
	_tmp2_ = _tmp0_;
	i_is_ip = _tmp2_;
	_tmp4_ = self->priv->_gl_is_ip;
	if (_tmp4_) {
		_tmp3_ = 1;
	} else {
		_tmp3_ = 0;
	}
	_tmp5_ = _tmp3_;
	i_gl_is_ip = _tmp5_;
	_tmp7_ = self->priv->_gl_is_main;
	if (_tmp7_) {
		_tmp6_ = 1;
	} else {
		_tmp6_ = 0;
	}
	_tmp8_ = _tmp6_;
	i_gl_is_main = _tmp8_;
	_tmp9_ = zcd_serializable_buffer_new (self->ipv4_ip, 4);
	b_ipv4_ip = _tmp9_;
	_tmp10_ = zcd_serializable_buffer_new (self->ipv6_ip, 16);
	b_ipv6_ip = _tmp10_;
	_tmp11_ = zcd_serializable_buffer_new (self->gl_ipv4_ip, 4);
	b_gl_ipv4_ip = _tmp11_;
	_tmp12_ = zcd_serializable_buffer_new (self->gl_ipv6_ip, 16);
	b_gl_ipv6_ip = _tmp12_;
	_tmp13_ = i_is_ip;
	_tmp14_ = zcd_serializer_int_to_variant (_tmp13_);
	v0 = _tmp14_;
	_tmp15_ = self->priv->_weight;
	_tmp16_ = zcd_serializer_int_to_variant (_tmp15_);
	v1 = _tmp16_;
	_tmp17_ = self->priv->_priority;
	_tmp18_ = zcd_serializer_int_to_variant (_tmp17_);
	v2 = _tmp18_;
	_tmp19_ = zcd_iserializable_serialize_to_variant ((zcdISerializable*) b_ipv4_ip);
	v3 = _tmp19_;
	_tmp20_ = zcd_iserializable_serialize_to_variant ((zcdISerializable*) b_ipv6_ip);
	v4 = _tmp20_;
	_tmp21_ = zcd_serializer_int_to_variant (0);
	v5 = _tmp21_;
	_tmp22_ = self->priv->_hashed_alias;
	_tmp23_ = zcd_serializer_string_to_variant (_tmp22_);
	v6 = _tmp23_;
	_tmp24_ = self->priv->_port_number;
	_tmp25_ = zcd_serializer_int64_to_variant ((gint64) _tmp24_);
	v7 = _tmp25_;
	_tmp26_ = self->priv->_hostname;
	_tmp27_ = zcd_serializer_string_to_variant (_tmp26_);
	v8 = _tmp27_;
	_tmp28_ = zcd_serializer_int_to_variant (i_gl_is_main);
	v9 = _tmp28_;
	_tmp29_ = i_gl_is_ip;
	_tmp30_ = zcd_serializer_int_to_variant (_tmp29_);
	vA = _tmp30_;
	_tmp31_ = self->priv->_gl_service;
	_tmp32_ = zcd_iserializable_serialize_to_variant ((zcdISerializable*) _tmp31_);
	vB = _tmp32_;
	_tmp33_ = self->priv->_gl_weight;
	_tmp34_ = zcd_serializer_int_to_variant (_tmp33_);
	vC = _tmp34_;
	_tmp35_ = self->priv->_gl_priority;
	_tmp36_ = zcd_serializer_int_to_variant (_tmp35_);
	vD = _tmp36_;
	_tmp37_ = zcd_iserializable_serialize_to_variant ((zcdISerializable*) b_gl_ipv4_ip);
	vE = _tmp37_;
	_tmp38_ = zcd_iserializable_serialize_to_variant ((zcdISerializable*) b_gl_ipv6_ip);
	vF = _tmp38_;
	_tmp39_ = zcd_serializer_int_to_variant (0);
	vG = _tmp39_;
	_tmp40_ = self->priv->_gl_hashed_alias;
	_tmp41_ = zcd_serializer_string_to_variant (_tmp40_);
	vH = _tmp41_;
	_tmp42_ = self->priv->_gl_port_number;
	_tmp43_ = zcd_serializer_int64_to_variant ((gint64) _tmp42_);
	vJ = _tmp43_;
	_tmp44_ = zcd_serializer_int_to_variant (0);
	vK = _tmp44_;
	_tmp45_ = zcd_serializer_tuple_to_variant_5 (v0, v1, v2, v3, v4);
	vtemp0 = _tmp45_;
	_tmp46_ = zcd_serializer_tuple_to_variant_5 (v5, v6, v7, v8, v9);
	vtemp1 = _tmp46_;
	_tmp47_ = zcd_serializer_tuple_to_variant_5 (vA, vB, vC, vD, vE);
	vtemp2 = _tmp47_;
	_tmp48_ = zcd_serializer_tuple_to_variant_5 (vF, vG, vH, vJ, vK);
	vtemp3 = _tmp48_;
	_tmp49_ = zcd_serializer_tuple_to_variant_4 (vtemp0, vtemp1, vtemp2, vtemp3);
	vret = _tmp49_;
	result = vret;
	_g_variant_unref0 (vtemp3);
	_g_variant_unref0 (vtemp2);
	_g_variant_unref0 (vtemp1);
	_g_variant_unref0 (vtemp0);
	_g_variant_unref0 (vK);
	_g_variant_unref0 (vJ);
	_g_variant_unref0 (vH);
	_g_variant_unref0 (vG);
	_g_variant_unref0 (vF);
	_g_variant_unref0 (vE);
	_g_variant_unref0 (vD);
	_g_variant_unref0 (vC);
	_g_variant_unref0 (vB);
	_g_variant_unref0 (vA);
	_g_variant_unref0 (v9);
	_g_variant_unref0 (v8);
	_g_variant_unref0 (v7);
	_g_variant_unref0 (v6);
	_g_variant_unref0 (v5);
	_g_variant_unref0 (v4);
	_g_variant_unref0 (v3);
	_g_variant_unref0 (v2);
	_g_variant_unref0 (v1);
	_g_variant_unref0 (v0);
	_g_object_unref0 (b_gl_ipv6_ip);
	_g_object_unref0 (b_gl_ipv4_ip);
	_g_object_unref0 (b_ipv6_ip);
	_g_object_unref0 (b_ipv4_ip);
	return result;
}


static void andns_andna_response_answer_real_deserialize_from_variant (zcdISerializable* base, GVariant* v, GError** error) {
	AndnsAndnaResponseAnswer * self;
	GVariant* v0 = NULL;
	GVariant* v1 = NULL;
	GVariant* v2 = NULL;
	GVariant* v3 = NULL;
	GVariant* v4 = NULL;
	GVariant* v5 = NULL;
	GVariant* v6 = NULL;
	GVariant* v7 = NULL;
	GVariant* v8 = NULL;
	GVariant* v9 = NULL;
	GVariant* vA = NULL;
	GVariant* vB = NULL;
	GVariant* vC = NULL;
	GVariant* vD = NULL;
	GVariant* vE = NULL;
	GVariant* vF = NULL;
	GVariant* vG = NULL;
	GVariant* vH = NULL;
	GVariant* vJ = NULL;
	GVariant* vK = NULL;
	GVariant* vtemp0 = NULL;
	GVariant* vtemp1 = NULL;
	GVariant* vtemp2 = NULL;
	GVariant* vtemp3 = NULL;
	GVariant* _tmp0_;
	GVariant* _tmp1_ = NULL;
	GVariant* _tmp2_ = NULL;
	GVariant* _tmp3_ = NULL;
	GVariant* _tmp4_ = NULL;
	GVariant* _tmp5_;
	GVariant* _tmp6_ = NULL;
	GVariant* _tmp7_ = NULL;
	GVariant* _tmp8_ = NULL;
	GVariant* _tmp9_ = NULL;
	GVariant* _tmp10_ = NULL;
	GVariant* _tmp11_;
	GVariant* _tmp12_ = NULL;
	GVariant* _tmp13_ = NULL;
	GVariant* _tmp14_ = NULL;
	GVariant* _tmp15_ = NULL;
	GVariant* _tmp16_ = NULL;
	GVariant* _tmp17_;
	GVariant* _tmp18_ = NULL;
	GVariant* _tmp19_ = NULL;
	GVariant* _tmp20_ = NULL;
	GVariant* _tmp21_ = NULL;
	GVariant* _tmp22_ = NULL;
	GVariant* _tmp23_;
	GVariant* _tmp24_ = NULL;
	GVariant* _tmp25_ = NULL;
	GVariant* _tmp26_ = NULL;
	GVariant* _tmp27_ = NULL;
	GVariant* _tmp28_ = NULL;
	GVariant* _tmp29_;
	gint _tmp30_ = 0;
	gint i_is_ip;
	GVariant* _tmp31_;
	gint _tmp32_ = 0;
	GVariant* _tmp33_;
	gint _tmp34_ = 0;
	GVariant* _tmp73_;
	gchar* _tmp74_ = NULL;
	gchar* _tmp75_;
	GVariant* _tmp76_;
	gint64 _tmp77_ = 0LL;
	GVariant* _tmp78_;
	gchar* _tmp79_ = NULL;
	gchar* _tmp80_;
	GVariant* _tmp81_;
	gint _tmp82_ = 0;
	gint i_gl_is_main;
	GVariant* _tmp83_;
	gint _tmp84_ = 0;
	gint i_gl_is_ip;
	GObject* _tmp85_ = NULL;
	GObject* _tmp86_;
	NetsukukuAndnaServiceKey* _tmp87_;
	NetsukukuAndnaServiceKey* _tmp88_;
	GVariant* _tmp89_;
	GVariant* _tmp90_;
	gint _tmp91_ = 0;
	GVariant* _tmp92_;
	gint _tmp93_ = 0;
	GVariant* _tmp132_;
	gchar* _tmp133_ = NULL;
	gchar* _tmp134_;
	GVariant* _tmp135_;
	gint64 _tmp136_ = 0LL;
	gint _tmp137_;
	gint _tmp138_;
	gint _tmp139_;
	GError * _inner_error_ = NULL;
	self = (AndnsAndnaResponseAnswer*) base;
	g_return_if_fail (v != NULL);
	_tmp0_ = v;
	zcd_serializer_variant_to_tuple_4 (_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_, &_tmp4_);
	_g_variant_unref0 (vtemp0);
	vtemp0 = _tmp1_;
	_g_variant_unref0 (vtemp1);
	vtemp1 = _tmp2_;
	_g_variant_unref0 (vtemp2);
	vtemp2 = _tmp3_;
	_g_variant_unref0 (vtemp3);
	vtemp3 = _tmp4_;
	_tmp5_ = vtemp3;
	zcd_serializer_variant_to_tuple_5 (_tmp5_, &_tmp6_, &_tmp7_, &_tmp8_, &_tmp9_, &_tmp10_);
	_g_variant_unref0 (vF);
	vF = _tmp6_;
	_g_variant_unref0 (vG);
	vG = _tmp7_;
	_g_variant_unref0 (vH);
	vH = _tmp8_;
	_g_variant_unref0 (vJ);
	vJ = _tmp9_;
	_g_variant_unref0 (vK);
	vK = _tmp10_;
	_tmp11_ = vtemp2;
	zcd_serializer_variant_to_tuple_5 (_tmp11_, &_tmp12_, &_tmp13_, &_tmp14_, &_tmp15_, &_tmp16_);
	_g_variant_unref0 (vA);
	vA = _tmp12_;
	_g_variant_unref0 (vB);
	vB = _tmp13_;
	_g_variant_unref0 (vC);
	vC = _tmp14_;
	_g_variant_unref0 (vD);
	vD = _tmp15_;
	_g_variant_unref0 (vE);
	vE = _tmp16_;
	_tmp17_ = vtemp1;
	zcd_serializer_variant_to_tuple_5 (_tmp17_, &_tmp18_, &_tmp19_, &_tmp20_, &_tmp21_, &_tmp22_);
	_g_variant_unref0 (v5);
	v5 = _tmp18_;
	_g_variant_unref0 (v6);
	v6 = _tmp19_;
	_g_variant_unref0 (v7);
	v7 = _tmp20_;
	_g_variant_unref0 (v8);
	v8 = _tmp21_;
	_g_variant_unref0 (v9);
	v9 = _tmp22_;
	_tmp23_ = vtemp0;
	zcd_serializer_variant_to_tuple_5 (_tmp23_, &_tmp24_, &_tmp25_, &_tmp26_, &_tmp27_, &_tmp28_);
	_g_variant_unref0 (v0);
	v0 = _tmp24_;
	_g_variant_unref0 (v1);
	v1 = _tmp25_;
	_g_variant_unref0 (v2);
	v2 = _tmp26_;
	_g_variant_unref0 (v3);
	v3 = _tmp27_;
	_g_variant_unref0 (v4);
	v4 = _tmp28_;
	_tmp29_ = v0;
	_tmp30_ = zcd_serializer_variant_to_int (_tmp29_);
	i_is_ip = _tmp30_;
	_tmp31_ = v1;
	_tmp32_ = zcd_serializer_variant_to_int (_tmp31_);
	andns_andna_response_answer_set_weight (self, _tmp32_);
	_tmp33_ = v2;
	_tmp34_ = zcd_serializer_variant_to_int (_tmp33_);
	andns_andna_response_answer_set_priority (self, _tmp34_);
	{
		guint8* buf;
		GObject* _tmp35_ = NULL;
		GObject* _tmp36_;
		zcdSerializableBuffer* buf_ser;
		zcdSerializableBuffer* _tmp37_;
		GVariant* _tmp38_;
		buf = self->ipv4_ip;
		_tmp35_ = g_object_new (ZCD_TYPE_SERIALIZABLE_BUFFER, NULL);
		_tmp36_ = G_IS_INITIALLY_UNOWNED (_tmp35_) ? g_object_ref_sink (_tmp35_) : _tmp35_;
		buf_ser = G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, ZCD_TYPE_SERIALIZABLE_BUFFER, zcdSerializableBuffer);
		_tmp37_ = buf_ser;
		_tmp38_ = v3;
		zcd_iserializable_deserialize_from_variant ((zcdISerializable*) _tmp37_, _tmp38_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_SERIALIZER_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (buf_ser);
				_g_variant_unref0 (vtemp3);
				_g_variant_unref0 (vtemp2);
				_g_variant_unref0 (vtemp1);
				_g_variant_unref0 (vtemp0);
				_g_variant_unref0 (vK);
				_g_variant_unref0 (vJ);
				_g_variant_unref0 (vH);
				_g_variant_unref0 (vG);
				_g_variant_unref0 (vF);
				_g_variant_unref0 (vE);
				_g_variant_unref0 (vD);
				_g_variant_unref0 (vC);
				_g_variant_unref0 (vB);
				_g_variant_unref0 (vA);
				_g_variant_unref0 (v9);
				_g_variant_unref0 (v8);
				_g_variant_unref0 (v7);
				_g_variant_unref0 (v6);
				_g_variant_unref0 (v5);
				_g_variant_unref0 (v4);
				_g_variant_unref0 (v3);
				_g_variant_unref0 (v2);
				_g_variant_unref0 (v1);
				_g_variant_unref0 (v0);
				return;
			} else {
				_g_object_unref0 (buf_ser);
				_g_variant_unref0 (vtemp3);
				_g_variant_unref0 (vtemp2);
				_g_variant_unref0 (vtemp1);
				_g_variant_unref0 (vtemp0);
				_g_variant_unref0 (vK);
				_g_variant_unref0 (vJ);
				_g_variant_unref0 (vH);
				_g_variant_unref0 (vG);
				_g_variant_unref0 (vF);
				_g_variant_unref0 (vE);
				_g_variant_unref0 (vD);
				_g_variant_unref0 (vC);
				_g_variant_unref0 (vB);
				_g_variant_unref0 (vA);
				_g_variant_unref0 (v9);
				_g_variant_unref0 (v8);
				_g_variant_unref0 (v7);
				_g_variant_unref0 (v6);
				_g_variant_unref0 (v5);
				_g_variant_unref0 (v4);
				_g_variant_unref0 (v3);
				_g_variant_unref0 (v2);
				_g_variant_unref0 (v1);
				_g_variant_unref0 (v0);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		{
			gint i;
			i = 0;
			{
				gboolean _tmp39_;
				_tmp39_ = TRUE;
				while (TRUE) {
					gboolean _tmp40_;
					gint _tmp42_;
					zcdSerializableBuffer* _tmp43_;
					guint8* _tmp44_;
					gint _tmp44__length1;
					guint8* _tmp45_;
					gint _tmp45__length1;
					guint8* _tmp46_;
					gint _tmp47_;
					zcdSerializableBuffer* _tmp48_;
					guint8* _tmp49_;
					gint _tmp49__length1;
					guint8* _tmp50_;
					gint _tmp50__length1;
					gint _tmp51_;
					guint8 _tmp52_;
					guint8 _tmp53_;
					_tmp40_ = _tmp39_;
					if (!_tmp40_) {
						gint _tmp41_;
						_tmp41_ = i;
						i = _tmp41_ + 1;
					}
					_tmp39_ = FALSE;
					_tmp42_ = i;
					_tmp43_ = buf_ser;
					_tmp44_ = zcd_serializable_buffer_get_buffer (_tmp43_, &_tmp44__length1);
					_tmp45_ = _tmp44_;
					_tmp45__length1 = _tmp44__length1;
					if (!(_tmp42_ < _tmp45__length1)) {
						break;
					}
					_tmp46_ = buf;
					_tmp47_ = i;
					_tmp48_ = buf_ser;
					_tmp49_ = zcd_serializable_buffer_get_buffer (_tmp48_, &_tmp49__length1);
					_tmp50_ = _tmp49_;
					_tmp50__length1 = _tmp49__length1;
					_tmp51_ = i;
					_tmp52_ = _tmp50_[_tmp51_];
					_tmp46_[_tmp47_] = _tmp52_;
					_tmp53_ = _tmp46_[_tmp47_];
				}
			}
		}
		_g_object_unref0 (buf_ser);
	}
	{
		guint8* buf;
		GObject* _tmp54_ = NULL;
		GObject* _tmp55_;
		zcdSerializableBuffer* buf_ser;
		zcdSerializableBuffer* _tmp56_;
		GVariant* _tmp57_;
		buf = self->ipv6_ip;
		_tmp54_ = g_object_new (ZCD_TYPE_SERIALIZABLE_BUFFER, NULL);
		_tmp55_ = G_IS_INITIALLY_UNOWNED (_tmp54_) ? g_object_ref_sink (_tmp54_) : _tmp54_;
		buf_ser = G_TYPE_CHECK_INSTANCE_CAST (_tmp55_, ZCD_TYPE_SERIALIZABLE_BUFFER, zcdSerializableBuffer);
		_tmp56_ = buf_ser;
		_tmp57_ = v4;
		zcd_iserializable_deserialize_from_variant ((zcdISerializable*) _tmp56_, _tmp57_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_SERIALIZER_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (buf_ser);
				_g_variant_unref0 (vtemp3);
				_g_variant_unref0 (vtemp2);
				_g_variant_unref0 (vtemp1);
				_g_variant_unref0 (vtemp0);
				_g_variant_unref0 (vK);
				_g_variant_unref0 (vJ);
				_g_variant_unref0 (vH);
				_g_variant_unref0 (vG);
				_g_variant_unref0 (vF);
				_g_variant_unref0 (vE);
				_g_variant_unref0 (vD);
				_g_variant_unref0 (vC);
				_g_variant_unref0 (vB);
				_g_variant_unref0 (vA);
				_g_variant_unref0 (v9);
				_g_variant_unref0 (v8);
				_g_variant_unref0 (v7);
				_g_variant_unref0 (v6);
				_g_variant_unref0 (v5);
				_g_variant_unref0 (v4);
				_g_variant_unref0 (v3);
				_g_variant_unref0 (v2);
				_g_variant_unref0 (v1);
				_g_variant_unref0 (v0);
				return;
			} else {
				_g_object_unref0 (buf_ser);
				_g_variant_unref0 (vtemp3);
				_g_variant_unref0 (vtemp2);
				_g_variant_unref0 (vtemp1);
				_g_variant_unref0 (vtemp0);
				_g_variant_unref0 (vK);
				_g_variant_unref0 (vJ);
				_g_variant_unref0 (vH);
				_g_variant_unref0 (vG);
				_g_variant_unref0 (vF);
				_g_variant_unref0 (vE);
				_g_variant_unref0 (vD);
				_g_variant_unref0 (vC);
				_g_variant_unref0 (vB);
				_g_variant_unref0 (vA);
				_g_variant_unref0 (v9);
				_g_variant_unref0 (v8);
				_g_variant_unref0 (v7);
				_g_variant_unref0 (v6);
				_g_variant_unref0 (v5);
				_g_variant_unref0 (v4);
				_g_variant_unref0 (v3);
				_g_variant_unref0 (v2);
				_g_variant_unref0 (v1);
				_g_variant_unref0 (v0);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		{
			gint i;
			i = 0;
			{
				gboolean _tmp58_;
				_tmp58_ = TRUE;
				while (TRUE) {
					gboolean _tmp59_;
					gint _tmp61_;
					zcdSerializableBuffer* _tmp62_;
					guint8* _tmp63_;
					gint _tmp63__length1;
					guint8* _tmp64_;
					gint _tmp64__length1;
					guint8* _tmp65_;
					gint _tmp66_;
					zcdSerializableBuffer* _tmp67_;
					guint8* _tmp68_;
					gint _tmp68__length1;
					guint8* _tmp69_;
					gint _tmp69__length1;
					gint _tmp70_;
					guint8 _tmp71_;
					guint8 _tmp72_;
					_tmp59_ = _tmp58_;
					if (!_tmp59_) {
						gint _tmp60_;
						_tmp60_ = i;
						i = _tmp60_ + 1;
					}
					_tmp58_ = FALSE;
					_tmp61_ = i;
					_tmp62_ = buf_ser;
					_tmp63_ = zcd_serializable_buffer_get_buffer (_tmp62_, &_tmp63__length1);
					_tmp64_ = _tmp63_;
					_tmp64__length1 = _tmp63__length1;
					if (!(_tmp61_ < _tmp64__length1)) {
						break;
					}
					_tmp65_ = buf;
					_tmp66_ = i;
					_tmp67_ = buf_ser;
					_tmp68_ = zcd_serializable_buffer_get_buffer (_tmp67_, &_tmp68__length1);
					_tmp69_ = _tmp68_;
					_tmp69__length1 = _tmp68__length1;
					_tmp70_ = i;
					_tmp71_ = _tmp69_[_tmp70_];
					_tmp65_[_tmp66_] = _tmp71_;
					_tmp72_ = _tmp65_[_tmp66_];
				}
			}
		}
		_g_object_unref0 (buf_ser);
	}
	_tmp73_ = v6;
	_tmp74_ = zcd_serializer_variant_to_string (_tmp73_);
	_tmp75_ = _tmp74_;
	andns_andna_response_answer_set_hashed_alias (self, _tmp75_);
	_g_free0 (_tmp75_);
	_tmp76_ = v7;
	_tmp77_ = zcd_serializer_variant_to_int64 (_tmp76_);
	andns_andna_response_answer_set_port_number (self, (guint16) ((gint16) _tmp77_));
	_tmp78_ = v8;
	_tmp79_ = zcd_serializer_variant_to_string (_tmp78_);
	_tmp80_ = _tmp79_;
	andns_andna_response_answer_set_hostname (self, _tmp80_);
	_g_free0 (_tmp80_);
	_tmp81_ = v9;
	_tmp82_ = zcd_serializer_variant_to_int (_tmp81_);
	i_gl_is_main = _tmp82_;
	_tmp83_ = vA;
	_tmp84_ = zcd_serializer_variant_to_int (_tmp83_);
	i_gl_is_ip = _tmp84_;
	_tmp85_ = g_object_new (NETSUKUKU_TYPE_ANDNA_SERVICE_KEY, NULL);
	_tmp86_ = G_IS_INITIALLY_UNOWNED (_tmp85_) ? g_object_ref_sink (_tmp85_) : _tmp85_;
	_tmp87_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp86_, NETSUKUKU_TYPE_ANDNA_SERVICE_KEY, NetsukukuAndnaServiceKey);
	andns_andna_response_answer_set_gl_service (self, _tmp87_);
	_g_object_unref0 (_tmp87_);
	_tmp88_ = self->priv->_gl_service;
	_tmp89_ = vB;
	zcd_iserializable_deserialize_from_variant ((zcdISerializable*) _tmp88_, _tmp89_, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZCD_SERIALIZER_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_variant_unref0 (vtemp3);
			_g_variant_unref0 (vtemp2);
			_g_variant_unref0 (vtemp1);
			_g_variant_unref0 (vtemp0);
			_g_variant_unref0 (vK);
			_g_variant_unref0 (vJ);
			_g_variant_unref0 (vH);
			_g_variant_unref0 (vG);
			_g_variant_unref0 (vF);
			_g_variant_unref0 (vE);
			_g_variant_unref0 (vD);
			_g_variant_unref0 (vC);
			_g_variant_unref0 (vB);
			_g_variant_unref0 (vA);
			_g_variant_unref0 (v9);
			_g_variant_unref0 (v8);
			_g_variant_unref0 (v7);
			_g_variant_unref0 (v6);
			_g_variant_unref0 (v5);
			_g_variant_unref0 (v4);
			_g_variant_unref0 (v3);
			_g_variant_unref0 (v2);
			_g_variant_unref0 (v1);
			_g_variant_unref0 (v0);
			return;
		} else {
			_g_variant_unref0 (vtemp3);
			_g_variant_unref0 (vtemp2);
			_g_variant_unref0 (vtemp1);
			_g_variant_unref0 (vtemp0);
			_g_variant_unref0 (vK);
			_g_variant_unref0 (vJ);
			_g_variant_unref0 (vH);
			_g_variant_unref0 (vG);
			_g_variant_unref0 (vF);
			_g_variant_unref0 (vE);
			_g_variant_unref0 (vD);
			_g_variant_unref0 (vC);
			_g_variant_unref0 (vB);
			_g_variant_unref0 (vA);
			_g_variant_unref0 (v9);
			_g_variant_unref0 (v8);
			_g_variant_unref0 (v7);
			_g_variant_unref0 (v6);
			_g_variant_unref0 (v5);
			_g_variant_unref0 (v4);
			_g_variant_unref0 (v3);
			_g_variant_unref0 (v2);
			_g_variant_unref0 (v1);
			_g_variant_unref0 (v0);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp90_ = vC;
	_tmp91_ = zcd_serializer_variant_to_int (_tmp90_);
	andns_andna_response_answer_set_gl_weight (self, _tmp91_);
	_tmp92_ = vD;
	_tmp93_ = zcd_serializer_variant_to_int (_tmp92_);
	andns_andna_response_answer_set_gl_priority (self, _tmp93_);
	{
		guint8* buf;
		GObject* _tmp94_ = NULL;
		GObject* _tmp95_;
		zcdSerializableBuffer* buf_ser;
		zcdSerializableBuffer* _tmp96_;
		GVariant* _tmp97_;
		buf = self->gl_ipv4_ip;
		_tmp94_ = g_object_new (ZCD_TYPE_SERIALIZABLE_BUFFER, NULL);
		_tmp95_ = G_IS_INITIALLY_UNOWNED (_tmp94_) ? g_object_ref_sink (_tmp94_) : _tmp94_;
		buf_ser = G_TYPE_CHECK_INSTANCE_CAST (_tmp95_, ZCD_TYPE_SERIALIZABLE_BUFFER, zcdSerializableBuffer);
		_tmp96_ = buf_ser;
		_tmp97_ = vE;
		zcd_iserializable_deserialize_from_variant ((zcdISerializable*) _tmp96_, _tmp97_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_SERIALIZER_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (buf_ser);
				_g_variant_unref0 (vtemp3);
				_g_variant_unref0 (vtemp2);
				_g_variant_unref0 (vtemp1);
				_g_variant_unref0 (vtemp0);
				_g_variant_unref0 (vK);
				_g_variant_unref0 (vJ);
				_g_variant_unref0 (vH);
				_g_variant_unref0 (vG);
				_g_variant_unref0 (vF);
				_g_variant_unref0 (vE);
				_g_variant_unref0 (vD);
				_g_variant_unref0 (vC);
				_g_variant_unref0 (vB);
				_g_variant_unref0 (vA);
				_g_variant_unref0 (v9);
				_g_variant_unref0 (v8);
				_g_variant_unref0 (v7);
				_g_variant_unref0 (v6);
				_g_variant_unref0 (v5);
				_g_variant_unref0 (v4);
				_g_variant_unref0 (v3);
				_g_variant_unref0 (v2);
				_g_variant_unref0 (v1);
				_g_variant_unref0 (v0);
				return;
			} else {
				_g_object_unref0 (buf_ser);
				_g_variant_unref0 (vtemp3);
				_g_variant_unref0 (vtemp2);
				_g_variant_unref0 (vtemp1);
				_g_variant_unref0 (vtemp0);
				_g_variant_unref0 (vK);
				_g_variant_unref0 (vJ);
				_g_variant_unref0 (vH);
				_g_variant_unref0 (vG);
				_g_variant_unref0 (vF);
				_g_variant_unref0 (vE);
				_g_variant_unref0 (vD);
				_g_variant_unref0 (vC);
				_g_variant_unref0 (vB);
				_g_variant_unref0 (vA);
				_g_variant_unref0 (v9);
				_g_variant_unref0 (v8);
				_g_variant_unref0 (v7);
				_g_variant_unref0 (v6);
				_g_variant_unref0 (v5);
				_g_variant_unref0 (v4);
				_g_variant_unref0 (v3);
				_g_variant_unref0 (v2);
				_g_variant_unref0 (v1);
				_g_variant_unref0 (v0);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		{
			gint i;
			i = 0;
			{
				gboolean _tmp98_;
				_tmp98_ = TRUE;
				while (TRUE) {
					gboolean _tmp99_;
					gint _tmp101_;
					zcdSerializableBuffer* _tmp102_;
					guint8* _tmp103_;
					gint _tmp103__length1;
					guint8* _tmp104_;
					gint _tmp104__length1;
					guint8* _tmp105_;
					gint _tmp106_;
					zcdSerializableBuffer* _tmp107_;
					guint8* _tmp108_;
					gint _tmp108__length1;
					guint8* _tmp109_;
					gint _tmp109__length1;
					gint _tmp110_;
					guint8 _tmp111_;
					guint8 _tmp112_;
					_tmp99_ = _tmp98_;
					if (!_tmp99_) {
						gint _tmp100_;
						_tmp100_ = i;
						i = _tmp100_ + 1;
					}
					_tmp98_ = FALSE;
					_tmp101_ = i;
					_tmp102_ = buf_ser;
					_tmp103_ = zcd_serializable_buffer_get_buffer (_tmp102_, &_tmp103__length1);
					_tmp104_ = _tmp103_;
					_tmp104__length1 = _tmp103__length1;
					if (!(_tmp101_ < _tmp104__length1)) {
						break;
					}
					_tmp105_ = buf;
					_tmp106_ = i;
					_tmp107_ = buf_ser;
					_tmp108_ = zcd_serializable_buffer_get_buffer (_tmp107_, &_tmp108__length1);
					_tmp109_ = _tmp108_;
					_tmp109__length1 = _tmp108__length1;
					_tmp110_ = i;
					_tmp111_ = _tmp109_[_tmp110_];
					_tmp105_[_tmp106_] = _tmp111_;
					_tmp112_ = _tmp105_[_tmp106_];
				}
			}
		}
		_g_object_unref0 (buf_ser);
	}
	{
		guint8* buf;
		GObject* _tmp113_ = NULL;
		GObject* _tmp114_;
		zcdSerializableBuffer* buf_ser;
		zcdSerializableBuffer* _tmp115_;
		GVariant* _tmp116_;
		buf = self->gl_ipv6_ip;
		_tmp113_ = g_object_new (ZCD_TYPE_SERIALIZABLE_BUFFER, NULL);
		_tmp114_ = G_IS_INITIALLY_UNOWNED (_tmp113_) ? g_object_ref_sink (_tmp113_) : _tmp113_;
		buf_ser = G_TYPE_CHECK_INSTANCE_CAST (_tmp114_, ZCD_TYPE_SERIALIZABLE_BUFFER, zcdSerializableBuffer);
		_tmp115_ = buf_ser;
		_tmp116_ = vF;
		zcd_iserializable_deserialize_from_variant ((zcdISerializable*) _tmp115_, _tmp116_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_SERIALIZER_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (buf_ser);
				_g_variant_unref0 (vtemp3);
				_g_variant_unref0 (vtemp2);
				_g_variant_unref0 (vtemp1);
				_g_variant_unref0 (vtemp0);
				_g_variant_unref0 (vK);
				_g_variant_unref0 (vJ);
				_g_variant_unref0 (vH);
				_g_variant_unref0 (vG);
				_g_variant_unref0 (vF);
				_g_variant_unref0 (vE);
				_g_variant_unref0 (vD);
				_g_variant_unref0 (vC);
				_g_variant_unref0 (vB);
				_g_variant_unref0 (vA);
				_g_variant_unref0 (v9);
				_g_variant_unref0 (v8);
				_g_variant_unref0 (v7);
				_g_variant_unref0 (v6);
				_g_variant_unref0 (v5);
				_g_variant_unref0 (v4);
				_g_variant_unref0 (v3);
				_g_variant_unref0 (v2);
				_g_variant_unref0 (v1);
				_g_variant_unref0 (v0);
				return;
			} else {
				_g_object_unref0 (buf_ser);
				_g_variant_unref0 (vtemp3);
				_g_variant_unref0 (vtemp2);
				_g_variant_unref0 (vtemp1);
				_g_variant_unref0 (vtemp0);
				_g_variant_unref0 (vK);
				_g_variant_unref0 (vJ);
				_g_variant_unref0 (vH);
				_g_variant_unref0 (vG);
				_g_variant_unref0 (vF);
				_g_variant_unref0 (vE);
				_g_variant_unref0 (vD);
				_g_variant_unref0 (vC);
				_g_variant_unref0 (vB);
				_g_variant_unref0 (vA);
				_g_variant_unref0 (v9);
				_g_variant_unref0 (v8);
				_g_variant_unref0 (v7);
				_g_variant_unref0 (v6);
				_g_variant_unref0 (v5);
				_g_variant_unref0 (v4);
				_g_variant_unref0 (v3);
				_g_variant_unref0 (v2);
				_g_variant_unref0 (v1);
				_g_variant_unref0 (v0);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		{
			gint i;
			i = 0;
			{
				gboolean _tmp117_;
				_tmp117_ = TRUE;
				while (TRUE) {
					gboolean _tmp118_;
					gint _tmp120_;
					zcdSerializableBuffer* _tmp121_;
					guint8* _tmp122_;
					gint _tmp122__length1;
					guint8* _tmp123_;
					gint _tmp123__length1;
					guint8* _tmp124_;
					gint _tmp125_;
					zcdSerializableBuffer* _tmp126_;
					guint8* _tmp127_;
					gint _tmp127__length1;
					guint8* _tmp128_;
					gint _tmp128__length1;
					gint _tmp129_;
					guint8 _tmp130_;
					guint8 _tmp131_;
					_tmp118_ = _tmp117_;
					if (!_tmp118_) {
						gint _tmp119_;
						_tmp119_ = i;
						i = _tmp119_ + 1;
					}
					_tmp117_ = FALSE;
					_tmp120_ = i;
					_tmp121_ = buf_ser;
					_tmp122_ = zcd_serializable_buffer_get_buffer (_tmp121_, &_tmp122__length1);
					_tmp123_ = _tmp122_;
					_tmp123__length1 = _tmp122__length1;
					if (!(_tmp120_ < _tmp123__length1)) {
						break;
					}
					_tmp124_ = buf;
					_tmp125_ = i;
					_tmp126_ = buf_ser;
					_tmp127_ = zcd_serializable_buffer_get_buffer (_tmp126_, &_tmp127__length1);
					_tmp128_ = _tmp127_;
					_tmp128__length1 = _tmp127__length1;
					_tmp129_ = i;
					_tmp130_ = _tmp128_[_tmp129_];
					_tmp124_[_tmp125_] = _tmp130_;
					_tmp131_ = _tmp124_[_tmp125_];
				}
			}
		}
		_g_object_unref0 (buf_ser);
	}
	_tmp132_ = vH;
	_tmp133_ = zcd_serializer_variant_to_string (_tmp132_);
	_tmp134_ = _tmp133_;
	andns_andna_response_answer_set_gl_hashed_alias (self, _tmp134_);
	_g_free0 (_tmp134_);
	_tmp135_ = vJ;
	_tmp136_ = zcd_serializer_variant_to_int64 (_tmp135_);
	andns_andna_response_answer_set_gl_port_number (self, (guint16) ((gint16) _tmp136_));
	_tmp137_ = i_is_ip;
	andns_andna_response_answer_set_is_ip (self, _tmp137_ == 1);
	_tmp138_ = i_gl_is_ip;
	andns_andna_response_answer_set_gl_is_ip (self, _tmp138_ == 1);
	_tmp139_ = i_gl_is_main;
	andns_andna_response_answer_set_gl_is_main (self, _tmp139_ == 1);
	_g_variant_unref0 (vtemp3);
	_g_variant_unref0 (vtemp2);
	_g_variant_unref0 (vtemp1);
	_g_variant_unref0 (vtemp0);
	_g_variant_unref0 (vK);
	_g_variant_unref0 (vJ);
	_g_variant_unref0 (vH);
	_g_variant_unref0 (vG);
	_g_variant_unref0 (vF);
	_g_variant_unref0 (vE);
	_g_variant_unref0 (vD);
	_g_variant_unref0 (vC);
	_g_variant_unref0 (vB);
	_g_variant_unref0 (vA);
	_g_variant_unref0 (v9);
	_g_variant_unref0 (v8);
	_g_variant_unref0 (v7);
	_g_variant_unref0 (v6);
	_g_variant_unref0 (v5);
	_g_variant_unref0 (v4);
	_g_variant_unref0 (v3);
	_g_variant_unref0 (v2);
	_g_variant_unref0 (v1);
	_g_variant_unref0 (v0);
}


static guint8* _vala_array_dup1 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


static guint8* _vala_array_dup2 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


static guint8* _vala_array_dup3 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


static guint8* _vala_array_dup4 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


static guint8* _vala_array_dup5 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


static guint8* _vala_array_dup6 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


static guint8* _vala_array_dup7 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


static guint8* _vala_array_dup8 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


gboolean andns_andna_response_answer_equal_func (AndnsAndnaResponseAnswer* a, AndnsAndnaResponseAnswer* b) {
	gboolean result = FALSE;
	AndnsAndnaResponseAnswer* _tmp0_;
	gboolean _tmp1_;
	AndnsAndnaResponseAnswer* _tmp2_;
	gboolean _tmp3_;
	AndnsAndnaResponseAnswer* _tmp4_;
	gint _tmp5_;
	AndnsAndnaResponseAnswer* _tmp6_;
	gint _tmp7_;
	AndnsAndnaResponseAnswer* _tmp8_;
	gint _tmp9_;
	AndnsAndnaResponseAnswer* _tmp10_;
	gint _tmp11_;
	AndnsAndnaResponseAnswer* _tmp46_;
	const gchar* _tmp47_;
	AndnsAndnaResponseAnswer* _tmp48_;
	const gchar* _tmp49_;
	AndnsAndnaResponseAnswer* _tmp50_;
	guint16 _tmp51_;
	AndnsAndnaResponseAnswer* _tmp52_;
	guint16 _tmp53_;
	AndnsAndnaResponseAnswer* _tmp54_;
	const gchar* _tmp55_;
	AndnsAndnaResponseAnswer* _tmp56_;
	const gchar* _tmp57_;
	AndnsAndnaResponseAnswer* _tmp58_;
	gboolean _tmp59_;
	AndnsAndnaResponseAnswer* _tmp60_;
	gboolean _tmp61_;
	AndnsAndnaResponseAnswer* _tmp62_;
	gboolean _tmp63_;
	AndnsAndnaResponseAnswer* _tmp64_;
	gboolean _tmp65_;
	AndnsAndnaResponseAnswer* _tmp66_;
	NetsukukuAndnaServiceKey* _tmp67_;
	AndnsAndnaResponseAnswer* _tmp68_;
	NetsukukuAndnaServiceKey* _tmp69_;
	gboolean _tmp70_ = FALSE;
	AndnsAndnaResponseAnswer* _tmp71_;
	gint _tmp72_;
	AndnsAndnaResponseAnswer* _tmp73_;
	gint _tmp74_;
	AndnsAndnaResponseAnswer* _tmp75_;
	gint _tmp76_;
	AndnsAndnaResponseAnswer* _tmp77_;
	gint _tmp78_;
	AndnsAndnaResponseAnswer* _tmp113_;
	const gchar* _tmp114_;
	AndnsAndnaResponseAnswer* _tmp115_;
	const gchar* _tmp116_;
	AndnsAndnaResponseAnswer* _tmp117_;
	guint16 _tmp118_;
	AndnsAndnaResponseAnswer* _tmp119_;
	guint16 _tmp120_;
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	_tmp0_ = a;
	_tmp1_ = _tmp0_->priv->_is_ip;
	_tmp2_ = b;
	_tmp3_ = _tmp2_->priv->_is_ip;
	if (_tmp1_ != _tmp3_) {
		result = FALSE;
		return result;
	}
	_tmp4_ = a;
	_tmp5_ = _tmp4_->priv->_weight;
	_tmp6_ = b;
	_tmp7_ = _tmp6_->priv->_weight;
	if (_tmp5_ != _tmp7_) {
		result = FALSE;
		return result;
	}
	_tmp8_ = a;
	_tmp9_ = _tmp8_->priv->_priority;
	_tmp10_ = b;
	_tmp11_ = _tmp10_->priv->_priority;
	if (_tmp9_ != _tmp11_) {
		result = FALSE;
		return result;
	}
	{
		AndnsAndnaResponseAnswer* _tmp12_;
		guint8* _tmp13_;
		gint _tmp13__length1;
		guint8* a_buf;
		gint a_buf_length1;
		gint _a_buf_size_;
		AndnsAndnaResponseAnswer* _tmp14_;
		guint8* _tmp15_;
		gint _tmp15__length1;
		guint8* b_buf;
		gint b_buf_length1;
		gint _b_buf_size_;
		guint8* _tmp16_;
		gint _tmp16__length1;
		guint8* _tmp17_;
		gint _tmp17__length1;
		_tmp12_ = a;
		_tmp13_ = (_tmp12_->ipv4_ip != NULL) ? _vala_array_dup1 (_tmp12_->ipv4_ip, 4) : ((gpointer) _tmp12_->ipv4_ip);
		_tmp13__length1 = 4;
		a_buf = _tmp13_;
		a_buf_length1 = _tmp13__length1;
		_a_buf_size_ = a_buf_length1;
		_tmp14_ = b;
		_tmp15_ = (_tmp14_->ipv4_ip != NULL) ? _vala_array_dup2 (_tmp14_->ipv4_ip, 4) : ((gpointer) _tmp14_->ipv4_ip);
		_tmp15__length1 = 4;
		b_buf = _tmp15_;
		b_buf_length1 = _tmp15__length1;
		_b_buf_size_ = b_buf_length1;
		_tmp16_ = a_buf;
		_tmp16__length1 = a_buf_length1;
		_tmp17_ = b_buf;
		_tmp17__length1 = b_buf_length1;
		_vala_assert (_tmp16__length1 == _tmp17__length1, "a_buf.length == b_buf.length");
		{
			gint i;
			i = 0;
			{
				gboolean _tmp18_;
				_tmp18_ = TRUE;
				while (TRUE) {
					gboolean _tmp19_;
					gint _tmp21_;
					guint8* _tmp22_;
					gint _tmp22__length1;
					guint8* _tmp23_;
					gint _tmp23__length1;
					gint _tmp24_;
					guint8 _tmp25_;
					guint8* _tmp26_;
					gint _tmp26__length1;
					gint _tmp27_;
					guint8 _tmp28_;
					_tmp19_ = _tmp18_;
					if (!_tmp19_) {
						gint _tmp20_;
						_tmp20_ = i;
						i = _tmp20_ + 1;
					}
					_tmp18_ = FALSE;
					_tmp21_ = i;
					_tmp22_ = a_buf;
					_tmp22__length1 = a_buf_length1;
					if (!(_tmp21_ < _tmp22__length1)) {
						break;
					}
					_tmp23_ = a_buf;
					_tmp23__length1 = a_buf_length1;
					_tmp24_ = i;
					_tmp25_ = _tmp23_[_tmp24_];
					_tmp26_ = b_buf;
					_tmp26__length1 = b_buf_length1;
					_tmp27_ = i;
					_tmp28_ = _tmp26_[_tmp27_];
					if (_tmp25_ != _tmp28_) {
						result = FALSE;
						b_buf = (g_free (b_buf), NULL);
						a_buf = (g_free (a_buf), NULL);
						return result;
					}
				}
			}
		}
		b_buf = (g_free (b_buf), NULL);
		a_buf = (g_free (a_buf), NULL);
	}
	{
		AndnsAndnaResponseAnswer* _tmp29_;
		guint8* _tmp30_;
		gint _tmp30__length1;
		guint8* a_buf;
		gint a_buf_length1;
		gint _a_buf_size_;
		AndnsAndnaResponseAnswer* _tmp31_;
		guint8* _tmp32_;
		gint _tmp32__length1;
		guint8* b_buf;
		gint b_buf_length1;
		gint _b_buf_size_;
		guint8* _tmp33_;
		gint _tmp33__length1;
		guint8* _tmp34_;
		gint _tmp34__length1;
		_tmp29_ = a;
		_tmp30_ = (_tmp29_->ipv6_ip != NULL) ? _vala_array_dup3 (_tmp29_->ipv6_ip, 16) : ((gpointer) _tmp29_->ipv6_ip);
		_tmp30__length1 = 16;
		a_buf = _tmp30_;
		a_buf_length1 = _tmp30__length1;
		_a_buf_size_ = a_buf_length1;
		_tmp31_ = b;
		_tmp32_ = (_tmp31_->ipv6_ip != NULL) ? _vala_array_dup4 (_tmp31_->ipv6_ip, 16) : ((gpointer) _tmp31_->ipv6_ip);
		_tmp32__length1 = 16;
		b_buf = _tmp32_;
		b_buf_length1 = _tmp32__length1;
		_b_buf_size_ = b_buf_length1;
		_tmp33_ = a_buf;
		_tmp33__length1 = a_buf_length1;
		_tmp34_ = b_buf;
		_tmp34__length1 = b_buf_length1;
		_vala_assert (_tmp33__length1 == _tmp34__length1, "a_buf.length == b_buf.length");
		{
			gint i;
			i = 0;
			{
				gboolean _tmp35_;
				_tmp35_ = TRUE;
				while (TRUE) {
					gboolean _tmp36_;
					gint _tmp38_;
					guint8* _tmp39_;
					gint _tmp39__length1;
					guint8* _tmp40_;
					gint _tmp40__length1;
					gint _tmp41_;
					guint8 _tmp42_;
					guint8* _tmp43_;
					gint _tmp43__length1;
					gint _tmp44_;
					guint8 _tmp45_;
					_tmp36_ = _tmp35_;
					if (!_tmp36_) {
						gint _tmp37_;
						_tmp37_ = i;
						i = _tmp37_ + 1;
					}
					_tmp35_ = FALSE;
					_tmp38_ = i;
					_tmp39_ = a_buf;
					_tmp39__length1 = a_buf_length1;
					if (!(_tmp38_ < _tmp39__length1)) {
						break;
					}
					_tmp40_ = a_buf;
					_tmp40__length1 = a_buf_length1;
					_tmp41_ = i;
					_tmp42_ = _tmp40_[_tmp41_];
					_tmp43_ = b_buf;
					_tmp43__length1 = b_buf_length1;
					_tmp44_ = i;
					_tmp45_ = _tmp43_[_tmp44_];
					if (_tmp42_ != _tmp45_) {
						result = FALSE;
						b_buf = (g_free (b_buf), NULL);
						a_buf = (g_free (a_buf), NULL);
						return result;
					}
				}
			}
		}
		b_buf = (g_free (b_buf), NULL);
		a_buf = (g_free (a_buf), NULL);
	}
	_tmp46_ = a;
	_tmp47_ = _tmp46_->priv->_hashed_alias;
	_tmp48_ = b;
	_tmp49_ = _tmp48_->priv->_hashed_alias;
	if (g_strcmp0 (_tmp47_, _tmp49_) != 0) {
		result = FALSE;
		return result;
	}
	_tmp50_ = a;
	_tmp51_ = _tmp50_->priv->_port_number;
	_tmp52_ = b;
	_tmp53_ = _tmp52_->priv->_port_number;
	if (_tmp51_ != _tmp53_) {
		result = FALSE;
		return result;
	}
	_tmp54_ = a;
	_tmp55_ = _tmp54_->priv->_hostname;
	_tmp56_ = b;
	_tmp57_ = _tmp56_->priv->_hostname;
	if (g_strcmp0 (_tmp55_, _tmp57_) != 0) {
		result = FALSE;
		return result;
	}
	_tmp58_ = a;
	_tmp59_ = _tmp58_->priv->_gl_is_main;
	_tmp60_ = b;
	_tmp61_ = _tmp60_->priv->_gl_is_main;
	if (_tmp59_ != _tmp61_) {
		result = FALSE;
		return result;
	}
	_tmp62_ = a;
	_tmp63_ = _tmp62_->priv->_gl_is_ip;
	_tmp64_ = b;
	_tmp65_ = _tmp64_->priv->_gl_is_ip;
	if (_tmp63_ != _tmp65_) {
		result = FALSE;
		return result;
	}
	_tmp66_ = a;
	_tmp67_ = _tmp66_->priv->_gl_service;
	_tmp68_ = b;
	_tmp69_ = _tmp68_->priv->_gl_service;
	_tmp70_ = netsukuku_andna_service_key_equal_func (_tmp67_, _tmp69_);
	if (!_tmp70_) {
		result = FALSE;
		return result;
	}
	_tmp71_ = a;
	_tmp72_ = _tmp71_->priv->_gl_weight;
	_tmp73_ = b;
	_tmp74_ = _tmp73_->priv->_gl_weight;
	if (_tmp72_ != _tmp74_) {
		result = FALSE;
		return result;
	}
	_tmp75_ = a;
	_tmp76_ = _tmp75_->priv->_gl_priority;
	_tmp77_ = b;
	_tmp78_ = _tmp77_->priv->_gl_priority;
	if (_tmp76_ != _tmp78_) {
		result = FALSE;
		return result;
	}
	{
		AndnsAndnaResponseAnswer* _tmp79_;
		guint8* _tmp80_;
		gint _tmp80__length1;
		guint8* a_buf;
		gint a_buf_length1;
		gint _a_buf_size_;
		AndnsAndnaResponseAnswer* _tmp81_;
		guint8* _tmp82_;
		gint _tmp82__length1;
		guint8* b_buf;
		gint b_buf_length1;
		gint _b_buf_size_;
		guint8* _tmp83_;
		gint _tmp83__length1;
		guint8* _tmp84_;
		gint _tmp84__length1;
		_tmp79_ = a;
		_tmp80_ = (_tmp79_->gl_ipv4_ip != NULL) ? _vala_array_dup5 (_tmp79_->gl_ipv4_ip, 4) : ((gpointer) _tmp79_->gl_ipv4_ip);
		_tmp80__length1 = 4;
		a_buf = _tmp80_;
		a_buf_length1 = _tmp80__length1;
		_a_buf_size_ = a_buf_length1;
		_tmp81_ = b;
		_tmp82_ = (_tmp81_->gl_ipv4_ip != NULL) ? _vala_array_dup6 (_tmp81_->gl_ipv4_ip, 4) : ((gpointer) _tmp81_->gl_ipv4_ip);
		_tmp82__length1 = 4;
		b_buf = _tmp82_;
		b_buf_length1 = _tmp82__length1;
		_b_buf_size_ = b_buf_length1;
		_tmp83_ = a_buf;
		_tmp83__length1 = a_buf_length1;
		_tmp84_ = b_buf;
		_tmp84__length1 = b_buf_length1;
		_vala_assert (_tmp83__length1 == _tmp84__length1, "a_buf.length == b_buf.length");
		{
			gint i;
			i = 0;
			{
				gboolean _tmp85_;
				_tmp85_ = TRUE;
				while (TRUE) {
					gboolean _tmp86_;
					gint _tmp88_;
					guint8* _tmp89_;
					gint _tmp89__length1;
					guint8* _tmp90_;
					gint _tmp90__length1;
					gint _tmp91_;
					guint8 _tmp92_;
					guint8* _tmp93_;
					gint _tmp93__length1;
					gint _tmp94_;
					guint8 _tmp95_;
					_tmp86_ = _tmp85_;
					if (!_tmp86_) {
						gint _tmp87_;
						_tmp87_ = i;
						i = _tmp87_ + 1;
					}
					_tmp85_ = FALSE;
					_tmp88_ = i;
					_tmp89_ = a_buf;
					_tmp89__length1 = a_buf_length1;
					if (!(_tmp88_ < _tmp89__length1)) {
						break;
					}
					_tmp90_ = a_buf;
					_tmp90__length1 = a_buf_length1;
					_tmp91_ = i;
					_tmp92_ = _tmp90_[_tmp91_];
					_tmp93_ = b_buf;
					_tmp93__length1 = b_buf_length1;
					_tmp94_ = i;
					_tmp95_ = _tmp93_[_tmp94_];
					if (_tmp92_ != _tmp95_) {
						result = FALSE;
						b_buf = (g_free (b_buf), NULL);
						a_buf = (g_free (a_buf), NULL);
						return result;
					}
				}
			}
		}
		b_buf = (g_free (b_buf), NULL);
		a_buf = (g_free (a_buf), NULL);
	}
	{
		AndnsAndnaResponseAnswer* _tmp96_;
		guint8* _tmp97_;
		gint _tmp97__length1;
		guint8* a_buf;
		gint a_buf_length1;
		gint _a_buf_size_;
		AndnsAndnaResponseAnswer* _tmp98_;
		guint8* _tmp99_;
		gint _tmp99__length1;
		guint8* b_buf;
		gint b_buf_length1;
		gint _b_buf_size_;
		guint8* _tmp100_;
		gint _tmp100__length1;
		guint8* _tmp101_;
		gint _tmp101__length1;
		_tmp96_ = a;
		_tmp97_ = (_tmp96_->gl_ipv6_ip != NULL) ? _vala_array_dup7 (_tmp96_->gl_ipv6_ip, 16) : ((gpointer) _tmp96_->gl_ipv6_ip);
		_tmp97__length1 = 16;
		a_buf = _tmp97_;
		a_buf_length1 = _tmp97__length1;
		_a_buf_size_ = a_buf_length1;
		_tmp98_ = b;
		_tmp99_ = (_tmp98_->gl_ipv6_ip != NULL) ? _vala_array_dup8 (_tmp98_->gl_ipv6_ip, 16) : ((gpointer) _tmp98_->gl_ipv6_ip);
		_tmp99__length1 = 16;
		b_buf = _tmp99_;
		b_buf_length1 = _tmp99__length1;
		_b_buf_size_ = b_buf_length1;
		_tmp100_ = a_buf;
		_tmp100__length1 = a_buf_length1;
		_tmp101_ = b_buf;
		_tmp101__length1 = b_buf_length1;
		_vala_assert (_tmp100__length1 == _tmp101__length1, "a_buf.length == b_buf.length");
		{
			gint i;
			i = 0;
			{
				gboolean _tmp102_;
				_tmp102_ = TRUE;
				while (TRUE) {
					gboolean _tmp103_;
					gint _tmp105_;
					guint8* _tmp106_;
					gint _tmp106__length1;
					guint8* _tmp107_;
					gint _tmp107__length1;
					gint _tmp108_;
					guint8 _tmp109_;
					guint8* _tmp110_;
					gint _tmp110__length1;
					gint _tmp111_;
					guint8 _tmp112_;
					_tmp103_ = _tmp102_;
					if (!_tmp103_) {
						gint _tmp104_;
						_tmp104_ = i;
						i = _tmp104_ + 1;
					}
					_tmp102_ = FALSE;
					_tmp105_ = i;
					_tmp106_ = a_buf;
					_tmp106__length1 = a_buf_length1;
					if (!(_tmp105_ < _tmp106__length1)) {
						break;
					}
					_tmp107_ = a_buf;
					_tmp107__length1 = a_buf_length1;
					_tmp108_ = i;
					_tmp109_ = _tmp107_[_tmp108_];
					_tmp110_ = b_buf;
					_tmp110__length1 = b_buf_length1;
					_tmp111_ = i;
					_tmp112_ = _tmp110_[_tmp111_];
					if (_tmp109_ != _tmp112_) {
						result = FALSE;
						b_buf = (g_free (b_buf), NULL);
						a_buf = (g_free (a_buf), NULL);
						return result;
					}
				}
			}
		}
		b_buf = (g_free (b_buf), NULL);
		a_buf = (g_free (a_buf), NULL);
	}
	_tmp113_ = a;
	_tmp114_ = _tmp113_->priv->_gl_hashed_alias;
	_tmp115_ = b;
	_tmp116_ = _tmp115_->priv->_gl_hashed_alias;
	if (g_strcmp0 (_tmp114_, _tmp116_) != 0) {
		result = FALSE;
		return result;
	}
	_tmp117_ = a;
	_tmp118_ = _tmp117_->priv->_gl_port_number;
	_tmp119_ = b;
	_tmp120_ = _tmp119_->priv->_gl_port_number;
	if (_tmp118_ != _tmp120_) {
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


AndnsAndnaResponseAnswer* andns_andna_response_answer_construct (GType object_type) {
	AndnsAndnaResponseAnswer * self = NULL;
	self = (AndnsAndnaResponseAnswer*) g_object_new (object_type, NULL);
	return self;
}


AndnsAndnaResponseAnswer* andns_andna_response_answer_new (void) {
	return andns_andna_response_answer_construct (ANDNS_TYPE_ANDNA_RESPONSE_ANSWER);
}


gboolean andns_andna_response_answer_get_is_ip (AndnsAndnaResponseAnswer* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_ip;
	result = _tmp0_;
	return result;
}


static void andns_andna_response_answer_set_is_ip (AndnsAndnaResponseAnswer* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_is_ip = _tmp0_;
	g_object_notify ((GObject *) self, "is-ip");
}


gint andns_andna_response_answer_get_weight (AndnsAndnaResponseAnswer* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_weight;
	result = _tmp0_;
	return result;
}


static void andns_andna_response_answer_set_weight (AndnsAndnaResponseAnswer* self, gint value) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_weight = _tmp0_;
	g_object_notify ((GObject *) self, "weight");
}


gint andns_andna_response_answer_get_priority (AndnsAndnaResponseAnswer* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_priority;
	result = _tmp0_;
	return result;
}


static void andns_andna_response_answer_set_priority (AndnsAndnaResponseAnswer* self, gint value) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_priority = _tmp0_;
	g_object_notify ((GObject *) self, "priority");
}


const gchar* andns_andna_response_answer_get_hashed_alias (AndnsAndnaResponseAnswer* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_hashed_alias;
	result = _tmp0_;
	return result;
}


static void andns_andna_response_answer_set_hashed_alias (AndnsAndnaResponseAnswer* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_hashed_alias);
	self->priv->_hashed_alias = _tmp1_;
	g_object_notify ((GObject *) self, "hashed-alias");
}


guint16 andns_andna_response_answer_get_port_number (AndnsAndnaResponseAnswer* self) {
	guint16 result;
	guint16 _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_port_number;
	result = _tmp0_;
	return result;
}


static void andns_andna_response_answer_set_port_number (AndnsAndnaResponseAnswer* self, guint16 value) {
	guint16 _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_port_number = _tmp0_;
}


const gchar* andns_andna_response_answer_get_hostname (AndnsAndnaResponseAnswer* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_hostname;
	result = _tmp0_;
	return result;
}


static void andns_andna_response_answer_set_hostname (AndnsAndnaResponseAnswer* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_hostname);
	self->priv->_hostname = _tmp1_;
	g_object_notify ((GObject *) self, "hostname");
}


gboolean andns_andna_response_answer_get_gl_is_main (AndnsAndnaResponseAnswer* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_gl_is_main;
	result = _tmp0_;
	return result;
}


static void andns_andna_response_answer_set_gl_is_main (AndnsAndnaResponseAnswer* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_gl_is_main = _tmp0_;
	g_object_notify ((GObject *) self, "gl-is-main");
}


gboolean andns_andna_response_answer_get_gl_is_ip (AndnsAndnaResponseAnswer* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_gl_is_ip;
	result = _tmp0_;
	return result;
}


static void andns_andna_response_answer_set_gl_is_ip (AndnsAndnaResponseAnswer* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_gl_is_ip = _tmp0_;
	g_object_notify ((GObject *) self, "gl-is-ip");
}


NetsukukuAndnaServiceKey* andns_andna_response_answer_get_gl_service (AndnsAndnaResponseAnswer* self) {
	NetsukukuAndnaServiceKey* result;
	NetsukukuAndnaServiceKey* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_gl_service;
	result = _tmp0_;
	return result;
}


static void andns_andna_response_answer_set_gl_service (AndnsAndnaResponseAnswer* self, NetsukukuAndnaServiceKey* value) {
	NetsukukuAndnaServiceKey* _tmp0_;
	NetsukukuAndnaServiceKey* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_gl_service);
	self->priv->_gl_service = _tmp1_;
	g_object_notify ((GObject *) self, "gl-service");
}


gint andns_andna_response_answer_get_gl_weight (AndnsAndnaResponseAnswer* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_gl_weight;
	result = _tmp0_;
	return result;
}


static void andns_andna_response_answer_set_gl_weight (AndnsAndnaResponseAnswer* self, gint value) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_gl_weight = _tmp0_;
	g_object_notify ((GObject *) self, "gl-weight");
}


gint andns_andna_response_answer_get_gl_priority (AndnsAndnaResponseAnswer* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_gl_priority;
	result = _tmp0_;
	return result;
}


static void andns_andna_response_answer_set_gl_priority (AndnsAndnaResponseAnswer* self, gint value) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_gl_priority = _tmp0_;
	g_object_notify ((GObject *) self, "gl-priority");
}


const gchar* andns_andna_response_answer_get_gl_hashed_alias (AndnsAndnaResponseAnswer* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_gl_hashed_alias;
	result = _tmp0_;
	return result;
}


static void andns_andna_response_answer_set_gl_hashed_alias (AndnsAndnaResponseAnswer* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_gl_hashed_alias);
	self->priv->_gl_hashed_alias = _tmp1_;
	g_object_notify ((GObject *) self, "gl-hashed-alias");
}


guint16 andns_andna_response_answer_get_gl_port_number (AndnsAndnaResponseAnswer* self) {
	guint16 result;
	guint16 _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_gl_port_number;
	result = _tmp0_;
	return result;
}


static void andns_andna_response_answer_set_gl_port_number (AndnsAndnaResponseAnswer* self, guint16 value) {
	guint16 _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_gl_port_number = _tmp0_;
}


static void andns_andna_response_answer_class_init (AndnsAndnaResponseAnswerClass * klass) {
	andns_andna_response_answer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (AndnsAndnaResponseAnswerPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_andns_andna_response_answer_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_andns_andna_response_answer_set_property;
	G_OBJECT_CLASS (klass)->finalize = andns_andna_response_answer_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ANDNS_ANDNA_RESPONSE_ANSWER_IS_IP, g_param_spec_boolean ("is-ip", "is-ip", "is-ip", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ANDNS_ANDNA_RESPONSE_ANSWER_WEIGHT, g_param_spec_int ("weight", "weight", "weight", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ANDNS_ANDNA_RESPONSE_ANSWER_PRIORITY, g_param_spec_int ("priority", "priority", "priority", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ANDNS_ANDNA_RESPONSE_ANSWER_HASHED_ALIAS, g_param_spec_string ("hashed-alias", "hashed-alias", "hashed-alias", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ANDNS_ANDNA_RESPONSE_ANSWER_HOSTNAME, g_param_spec_string ("hostname", "hostname", "hostname", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ANDNS_ANDNA_RESPONSE_ANSWER_GL_IS_MAIN, g_param_spec_boolean ("gl-is-main", "gl-is-main", "gl-is-main", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ANDNS_ANDNA_RESPONSE_ANSWER_GL_IS_IP, g_param_spec_boolean ("gl-is-ip", "gl-is-ip", "gl-is-ip", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ANDNS_ANDNA_RESPONSE_ANSWER_GL_SERVICE, g_param_spec_object ("gl-service", "gl-service", "gl-service", NETSUKUKU_TYPE_ANDNA_SERVICE_KEY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ANDNS_ANDNA_RESPONSE_ANSWER_GL_WEIGHT, g_param_spec_int ("gl-weight", "gl-weight", "gl-weight", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ANDNS_ANDNA_RESPONSE_ANSWER_GL_PRIORITY, g_param_spec_int ("gl-priority", "gl-priority", "gl-priority", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ANDNS_ANDNA_RESPONSE_ANSWER_GL_HASHED_ALIAS, g_param_spec_string ("gl-hashed-alias", "gl-hashed-alias", "gl-hashed-alias", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void andns_andna_response_answer_zcd_iserializable_interface_init (zcdISerializableIface * iface) {
	andns_andna_response_answer_zcd_iserializable_parent_iface = g_type_interface_peek_parent (iface);
	iface->serialize_to_variant = (GVariant* (*)(zcdISerializable*)) andns_andna_response_answer_real_serialize_to_variant;
	iface->deserialize_from_variant = (void (*)(zcdISerializable*, GVariant*, GError**)) andns_andna_response_answer_real_deserialize_from_variant;
}


static void andns_andna_response_answer_instance_init (AndnsAndnaResponseAnswer * self) {
	self->priv = ANDNS_ANDNA_RESPONSE_ANSWER_GET_PRIVATE (self);
}


static void andns_andna_response_answer_finalize (GObject* obj) {
	AndnsAndnaResponseAnswer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ANDNS_TYPE_ANDNA_RESPONSE_ANSWER, AndnsAndnaResponseAnswer);
	_g_free0 (self->priv->_hashed_alias);
	_g_free0 (self->priv->_hostname);
	_g_object_unref0 (self->priv->_gl_service);
	_g_free0 (self->priv->_gl_hashed_alias);
	G_OBJECT_CLASS (andns_andna_response_answer_parent_class)->finalize (obj);
}


/** A answer.
      */
GType andns_andna_response_answer_get_type (void) {
	static volatile gsize andns_andna_response_answer_type_id__volatile = 0;
	if (g_once_init_enter (&andns_andna_response_answer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AndnsAndnaResponseAnswerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) andns_andna_response_answer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AndnsAndnaResponseAnswer), 0, (GInstanceInitFunc) andns_andna_response_answer_instance_init, NULL };
		static const GInterfaceInfo zcd_iserializable_info = { (GInterfaceInitFunc) andns_andna_response_answer_zcd_iserializable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType andns_andna_response_answer_type_id;
		andns_andna_response_answer_type_id = g_type_register_static (G_TYPE_OBJECT, "AndnsAndnaResponseAnswer", &g_define_type_info, 0);
		g_type_add_interface_static (andns_andna_response_answer_type_id, ZCD_TYPE_ISERIALIZABLE, &zcd_iserializable_info);
		g_once_init_leave (&andns_andna_response_answer_type_id__volatile, andns_andna_response_answer_type_id);
	}
	return andns_andna_response_answer_type_id__volatile;
}


static void _vala_andns_andna_response_answer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	AndnsAndnaResponseAnswer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ANDNS_TYPE_ANDNA_RESPONSE_ANSWER, AndnsAndnaResponseAnswer);
	switch (property_id) {
		case ANDNS_ANDNA_RESPONSE_ANSWER_IS_IP:
		g_value_set_boolean (value, andns_andna_response_answer_get_is_ip (self));
		break;
		case ANDNS_ANDNA_RESPONSE_ANSWER_WEIGHT:
		g_value_set_int (value, andns_andna_response_answer_get_weight (self));
		break;
		case ANDNS_ANDNA_RESPONSE_ANSWER_PRIORITY:
		g_value_set_int (value, andns_andna_response_answer_get_priority (self));
		break;
		case ANDNS_ANDNA_RESPONSE_ANSWER_HASHED_ALIAS:
		g_value_set_string (value, andns_andna_response_answer_get_hashed_alias (self));
		break;
		case ANDNS_ANDNA_RESPONSE_ANSWER_HOSTNAME:
		g_value_set_string (value, andns_andna_response_answer_get_hostname (self));
		break;
		case ANDNS_ANDNA_RESPONSE_ANSWER_GL_IS_MAIN:
		g_value_set_boolean (value, andns_andna_response_answer_get_gl_is_main (self));
		break;
		case ANDNS_ANDNA_RESPONSE_ANSWER_GL_IS_IP:
		g_value_set_boolean (value, andns_andna_response_answer_get_gl_is_ip (self));
		break;
		case ANDNS_ANDNA_RESPONSE_ANSWER_GL_SERVICE:
		g_value_set_object (value, andns_andna_response_answer_get_gl_service (self));
		break;
		case ANDNS_ANDNA_RESPONSE_ANSWER_GL_WEIGHT:
		g_value_set_int (value, andns_andna_response_answer_get_gl_weight (self));
		break;
		case ANDNS_ANDNA_RESPONSE_ANSWER_GL_PRIORITY:
		g_value_set_int (value, andns_andna_response_answer_get_gl_priority (self));
		break;
		case ANDNS_ANDNA_RESPONSE_ANSWER_GL_HASHED_ALIAS:
		g_value_set_string (value, andns_andna_response_answer_get_gl_hashed_alias (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_andns_andna_response_answer_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	AndnsAndnaResponseAnswer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ANDNS_TYPE_ANDNA_RESPONSE_ANSWER, AndnsAndnaResponseAnswer);
	switch (property_id) {
		case ANDNS_ANDNA_RESPONSE_ANSWER_IS_IP:
		andns_andna_response_answer_set_is_ip (self, g_value_get_boolean (value));
		break;
		case ANDNS_ANDNA_RESPONSE_ANSWER_WEIGHT:
		andns_andna_response_answer_set_weight (self, g_value_get_int (value));
		break;
		case ANDNS_ANDNA_RESPONSE_ANSWER_PRIORITY:
		andns_andna_response_answer_set_priority (self, g_value_get_int (value));
		break;
		case ANDNS_ANDNA_RESPONSE_ANSWER_HASHED_ALIAS:
		andns_andna_response_answer_set_hashed_alias (self, g_value_get_string (value));
		break;
		case ANDNS_ANDNA_RESPONSE_ANSWER_HOSTNAME:
		andns_andna_response_answer_set_hostname (self, g_value_get_string (value));
		break;
		case ANDNS_ANDNA_RESPONSE_ANSWER_GL_IS_MAIN:
		andns_andna_response_answer_set_gl_is_main (self, g_value_get_boolean (value));
		break;
		case ANDNS_ANDNA_RESPONSE_ANSWER_GL_IS_IP:
		andns_andna_response_answer_set_gl_is_ip (self, g_value_get_boolean (value));
		break;
		case ANDNS_ANDNA_RESPONSE_ANSWER_GL_SERVICE:
		andns_andna_response_answer_set_gl_service (self, g_value_get_object (value));
		break;
		case ANDNS_ANDNA_RESPONSE_ANSWER_GL_WEIGHT:
		andns_andna_response_answer_set_gl_weight (self, g_value_get_int (value));
		break;
		case ANDNS_ANDNA_RESPONSE_ANSWER_GL_PRIORITY:
		andns_andna_response_answer_set_gl_priority (self, g_value_get_int (value));
		break;
		case ANDNS_ANDNA_RESPONSE_ANSWER_GL_HASHED_ALIAS:
		andns_andna_response_answer_set_gl_hashed_alias (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



