/*-GNU-GPL-BEGIN-*
nepim - network pipemeter
Copyright (C) 2005 Everton da Silva Marques

nepim is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

nepim is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with nepim; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.
*-GNU-GPL-END-*/


/* $Id: usock.c,v 1.1 2005/07/26 11:41:50 evertonm Exp $ */

#include <stdlib.h>
#include <assert.h>

#include "usock.h"

void nepim_usock_set_init(nepim_usock_set_t *set)
{
  nepim_array_init(&set->array);
}

nepim_usock_t *nepim_usock_set_get(const nepim_usock_set_t *set, int index)
{
  return nepim_array_get(&set->array, index);
}

void nepim_usock_set_add(nepim_usock_set_t *set, int index)
{
  nepim_usock_t *us = malloc(sizeof(nepim_usock_t *));
  assert(us);

  us->readers = 0;
  us->writers = 0;

  nepim_array_add(&set->array, index, us);
}

void nepim_usock_set_del(nepim_usock_set_t *set, int index)
{
  nepim_usock_t *us = nepim_usock_set_get(set, index);
  assert(us);
  free(us);
  nepim_array_del(&set->array, index);
}

