/*-GNU-GPL-BEGIN-*
nepim - network pipemeter
Copyright (C) 2005 Everton da Silva Marques

nepim is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

nepim is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with nepim; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.
*-GNU-GPL-END-*/


/* $Id: session.h,v 1.1 2005/07/24 22:14:32 evertonm Exp $ */

#ifndef NEPIM_SESSION_H
#define NEPIM_SESSION_H

#include <sys/time.h>

#include "greet.h"

typedef enum { SESSION_PIPE, SESSION_SLOT } nepim_session_type;

typedef struct nepim_session_t nepim_session_t;

struct nepim_session_t {

  nepim_session_type type;
  union {
    int pipe_sd; /* map socket descriptor to pipe */
    int slot;    /* map slot index        to slot */
  } index;

  int must_send;
  long long max_bit_rate;
  int stat_interval;
  int test_duration;
  suseconds_t write_delay; /* usec, used when max_bit_rate > 0 */
  int duration_done;       /* boolean */

  int rate_remaining;      /* bytes, used when max_bit_rate > 0 */

  int total_reads;
  int total_writes;
  int interval_reads;
  int interval_writes;

  long long byte_total_sent;
  long long byte_total_recv;

  long long byte_interval_sent;
  long long byte_interval_recv;

  struct timeval tv_duration;
  struct timeval tv_interval;
  struct timeval tv_start;
  struct timeval tv_rate;
};

void nepim_session_init(nepim_session_t *session, const nepim_greet_t *opt,
			nepim_session_type type, int index);

#endif /* NEPIM_SESSION_H */

