/*-GNU-GPL-BEGIN-*
nepim - network pipemeter
Copyright (C) 2005 Everton da Silva Marques

nepim is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

nepim is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with nepim; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.
*-GNU-GPL-END-*/


/* $Id: greet.c,v 1.2 2005/07/27 11:36:33 evertonm Exp $ */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "conf.h"
#include "greet.h"

const char *GREET_SERVER_SEND   = "server_send=";
const char *GREET_BIT_RATE      = "bit_rate=";
const char *GREET_STAT_INTERVAL = "stat_interval=";
const char *GREET_TEST_DURATION = "test_duration=";
const char *GREET_WRITE_DELAY   = "write_delay=";

#define NEPIM_GREET_PARSE_OK     (0)
#define NEPIM_GREET_PARSE_FTOKEN (-1)
#define NEPIM_GREET_PARSE_HELLO  (-2)

int nepim_parse_greetings(nepim_greet_t *opt, 
			  const char *buf, const char *past_end)
{
  char tmp[past_end - buf + 1];
  const char *SEP = " ";
  const char *tok;
  char *ptr;

  const int GREET_SERVER_SEND_LEN   = strlen(GREET_SERVER_SEND);
  const int GREET_BIT_RATE_LEN      = strlen(GREET_BIT_RATE);
  const int GREET_STAT_INTERVAL_LEN = strlen(GREET_STAT_INTERVAL);
  const int GREET_TEST_DURATION_LEN = strlen(GREET_TEST_DURATION);
  const int GREET_WRITE_DELAY_LEN   = strlen(GREET_WRITE_DELAY);

  int server_send    = -2;
  long long bit_rate = -2;
  int stat_interval  = -2;
  int test_duration  = -2;
  long write_delay   = -2;

  memcpy(tmp, buf, past_end - buf + 1);

  tok = strtok_r(tmp, SEP, &ptr);

  if (!tok)
    return NEPIM_GREET_PARSE_FTOKEN;

  if (strncmp(tok, "hello", 5))
    return NEPIM_GREET_PARSE_HELLO;

  for (;;) {
    tok = strtok_r(0, SEP, &ptr);
    if (!tok)
      break;

    if (!strncmp(tok, GREET_SERVER_SEND, GREET_SERVER_SEND_LEN)) {
      server_send = atoi(tok + GREET_SERVER_SEND_LEN);
      continue;
    }

    if (!strncmp(tok, GREET_BIT_RATE, GREET_BIT_RATE_LEN)) {
      bit_rate = atoll(tok + GREET_BIT_RATE_LEN);
      continue;
    }

    if (!strncmp(tok, GREET_STAT_INTERVAL, GREET_STAT_INTERVAL_LEN)) {
      stat_interval = atoi(tok + GREET_STAT_INTERVAL_LEN);
      continue;
    }

    if (!strncmp(tok, GREET_TEST_DURATION, GREET_TEST_DURATION_LEN)) {
      test_duration = atoi(tok + GREET_TEST_DURATION_LEN);
      continue;
    }

    if (!strncmp(tok, GREET_WRITE_DELAY, GREET_WRITE_DELAY_LEN)) {
      write_delay = atoi(tok + GREET_WRITE_DELAY_LEN);
      continue;
    }

    fprintf(stderr, "%s %s: unknown greeting parameter: '%s'\n",
	    __FILE__, __PRETTY_FUNCTION__, tok);
  }

  if (write_delay < 0)
    write_delay = nepim_global.write_delay;

  opt->must_send     = server_send;
  opt->bit_rate      = bit_rate;
  opt->stat_interval = stat_interval;
  opt->test_duration = test_duration;
  opt->write_delay   = write_delay;

  return 0;
}
