/*-GNU-GPL-BEGIN-*
nepim - network pipemeter
Copyright (C) 2005 Everton da Silva Marques

nepim is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

nepim is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with nepim; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.
*-GNU-GPL-END-*/


/* $Id: common.h,v 1.8 2005/07/27 12:01:46 evertonm Exp $ */

#ifndef NEPIM_COMMON_H
#define NEPIM_COMMON_H

#include "pipe.h"
#include "slot.h"

#define NEPIM_MIN(a, b) (((a) < (b)) ? (a) : (b))

extern const char * const NEPIM_LABEL_PARTIAL;
extern const char * const NEPIM_LABEL_TOTAL;

const char *nepim_version();

void nepim_pipe_stat(FILE *out, const char *label, int sd,
		     long long bytes_recv, long long bytes_sent, 
		     float interval, long sec_start, 
		     long sec_duration, int reads, int writes);

void nepim_slot_stat(FILE *out, const char *label, int sd,
		     int local_slot, int remote_slot,
		     long long bytes_recv, long long bytes_sent, 
		     float interval, long sec_start, 
		     long sec_duration, int reads, int writes);

void report_broken_pipe_stat(FILE *out, const nepim_pipe_t *pipe);
void report_broken_slot_stat(FILE *out, const nepim_slot_t *slot);


#endif /* NEPIM_COMMON_H */
