/*-GNU-GPL-BEGIN-*
nepim - network pipemeter
Copyright (C) 2005 Everton da Silva Marques

nepim is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

nepim is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with nepim; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.
*-GNU-GPL-END-*/


/* $Id: pipe.c,v 1.2 2005/04/19 03:40:33 evertonm Exp $ */

#include <stdlib.h>
#include <stdio.h>
#include <assert.h>

#include "pipe.h"

void nepim_pipe_set_init(nepim_pipe_set_t *set)
{
  set->head = malloc(sizeof(nepim_pipe_t*));
  assert(set->head);
  set->capacity = 1;
  set->head[0] = 0;
}

nepim_pipe_t *nepim_pipe_set_get(const nepim_pipe_set_t *set, int sd)
{
  assert(sd >= 0);
  assert(sd < set->capacity);

  return set->head[sd];
}

void nepim_pipe_set_add(nepim_pipe_set_t *set, int sd, 
			int must_send, 
			long long max_bit_rate, 
			int stat_interval,
			int test_duration,
			suseconds_t write_delay)
{
  assert(sd >= 0);

  if (sd >= set->capacity) {
    int new_cap = sd + 1;
    set->head = realloc(set->head, new_cap * sizeof(nepim_pipe_t*));
    assert(set->head);

    {
      int i;
      for (i = set->capacity; i < new_cap; ++i)
	set->head[i] = 0;
    }

    set->capacity = new_cap;
  }

  assert(!set->head[sd]);

  {
    nepim_pipe_t *pipe = malloc(sizeof(nepim_pipe_t));

    assert(pipe);

    pipe->sd                 = sd;
    pipe->must_send          = must_send;
    pipe->max_bit_rate       = max_bit_rate;
    pipe->stat_interval      = stat_interval;
    pipe->test_duration      = test_duration;
    pipe->write_delay        = write_delay;
    pipe->duration_done      = 0;
    pipe->total_reads        = 0;
    pipe->total_writes       = 0;
    pipe->interval_reads     = 0;
    pipe->interval_writes    = 0;
    pipe->byte_total_sent    = 0;
    pipe->byte_total_recv    = 0;
    pipe->byte_interval_sent = 0;
    pipe->byte_interval_recv = 0;
    
    set->head[sd] = pipe;
  }
}

void nepim_pipe_set_del(nepim_pipe_set_t *set, int sd)
{
  assert(sd >= 0);
  assert(sd < set->capacity);
  assert(set->head[sd]);
  free(set->head[sd]);
  set->head[sd] = 0;
}

