/*-GNU-GPL-BEGIN-*
nepim - network pipemeter
Copyright (C) 2005 Everton da Silva Marques

nepim is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

nepim is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with nepim; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.
*-GNU-GPL-END-*/


/* $Id: common.c,v 1.9 2005/06/21 11:12:40 evertonm Exp $ */

#include <stdio.h>
#include <assert.h>

#include "common.h"


const char * const NEPIM_LABEL_PARTIAL      = "part";
const char * const NEPIM_LABEL_TOTAL        = "avg";
const char * const NEPIM_LABEL_TOTAL_BROKEN = "avg(broken)";


const char *nepim_version()
{
  return "0.8";
}

void nepim_dump_stat(FILE *out, const char *label, int sd, 
		     long long bytes_recv, long long bytes_sent, 
		     float interval, long sec_start, 
		     long sec_duration, int reads, int writes)
{
  float kbps_recv = bytes_recv / (interval * 125); /* 8/1000 = 1/125 */
  float kbps_sent = bytes_sent / (interval * 125); /* 8/1000 = 1/125 */
  float read_rate = reads / interval;
  float write_rate = writes / interval;
  struct timeval now;
  int result;
      
  result = gettimeofday(&now, 0);
  assert(!result);

  fprintf(out,
	  "%d: %s %ld/%ld kbps_in=%.2f kbps_out=%.2f rcv/s=%.2f snd/s=%.2f\n", 
	  sd,
	  label,
	  now.tv_sec - sec_start,
	  sec_duration,
	  kbps_recv,
	  kbps_sent,
	  read_rate,
	  write_rate);
}

void report_broken_pipe_stat(FILE *out, const nepim_pipe_t *pipe)
{
  struct timeval now;
  int result;
  float elapsed_sec;
  float elapsed_usec;
  float elapsed;
      
  result = gettimeofday(&now, 0);
  assert(!result);

  elapsed_sec = now.tv_sec - pipe->tv_start.tv_sec;
  elapsed_usec = now.tv_usec - pipe->tv_start.tv_usec;

  elapsed = elapsed_sec + elapsed_usec / 1000000;

  nepim_dump_stat(out, 
		  NEPIM_LABEL_TOTAL_BROKEN,
		  pipe->sd, 
		  pipe->byte_total_recv,
		  pipe->byte_total_sent,
		  elapsed, 
		  pipe->tv_start.tv_sec,
		  pipe->test_duration,
		  pipe->total_reads,
		  pipe->total_writes);
}
