/*-GNU-GPL-BEGIN-*
nepim - network pipemeter
Copyright (C) 2005 Everton da Silva Marques

nepim is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

nepim is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with nepim; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.
*-GNU-GPL-END-*/


/* $Id: pipe.h,v 1.3 2005/04/19 03:40:33 evertonm Exp $ */

#ifndef NEPIM_PIPE_H
#define NEPIM_PIPE_H

#include <sys/time.h>

typedef struct nepim_pipe_t nepim_pipe_t;
typedef struct nepim_pipe_set_t nepim_pipe_set_t;

struct nepim_pipe_t {
  int sd;
  int must_send;
  long long max_bit_rate;
  int stat_interval;
  int test_duration;
  suseconds_t write_delay; /* usec, max_bit_rate > 0 */
  int duration_done; /* boolean */

  int rate_remaining; /* bytes, max_bit_rate > 0 */

  int total_reads;
  int total_writes;
  int interval_reads;
  int interval_writes;

  long long byte_total_sent;
  long long byte_total_recv;

  long long byte_interval_sent;
  long long byte_interval_recv;

  struct timeval tv_duration;
  struct timeval tv_interval;
  struct timeval tv_start;
  struct timeval tv_rate;
};

struct nepim_pipe_set_t {
  nepim_pipe_t **head;
  int          capacity;
};

void nepim_pipe_set_init(nepim_pipe_set_t *set);

nepim_pipe_t *nepim_pipe_set_get(const nepim_pipe_set_t *set, int sd);

void nepim_pipe_set_add(nepim_pipe_set_t *set, int sd, 
			int must_send, 
			long long max_bit_rate, 
			int stat_interval,
			int test_duration,
			suseconds_t write_delay);

void nepim_pipe_set_del(nepim_pipe_set_t *set, int sd);

#endif /* NEPIM_PIPE_H */
