/*-GNU-GPL-BEGIN-*
nepim - network pipemeter
Copyright (C) 2005 Everton da Silva Marques

nepim is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

nepim is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with nepim; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.
*-GNU-GPL-END-*/


/* $Id: udp_server.c,v 1.2 2005/04/15 21:20:34 evertonm Exp $ */


#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <oop.h>

#include "conf.h"
#include "sock.h"


static void *on_udp_segment(oop_source *src, int sd,
			    oop_event event, void *unnused)
{
  fprintf(stderr, "FIXME: %s %s\n", __FILE__, __PRETTY_FUNCTION__);

  return OOP_CONTINUE;
}

void nepim_udp_listener(const char *hostname)
{
  struct addrinfo hints;
  struct addrinfo *ai_res;
  struct addrinfo *ai;
  int result;

  hints.ai_socktype = SOCK_DGRAM;
  hints.ai_protocol = IPPROTO_UDP;
  hints.ai_flags = AI_CANONNAME;
  hints.ai_family = PF_UNSPEC;
  hints.ai_addrlen = 0;
  hints.ai_addr = 0;
  hints.ai_canonname = 0;

  result = getaddrinfo(hostname, 0, &hints, &ai_res);
  if (result) {
    fprintf(stderr, "getaddrinfo(%s): %s\n",
            hostname, gai_strerror(result));
    return;
  }

  for (ai = ai_res; ai; ai = ai->ai_next) {
    int sd;

    fprintf(stderr, 
	    "UDP listener: host=%s,%d len=%d family=%d type=%d proto=%d\n",
	    hostname, nepim_global.port, 
	    ai->ai_addrlen, ai->ai_family, 
	    ai->ai_socktype, ai->ai_protocol);

    sd = nepim_create_socket(ai->ai_addr, ai->ai_addrlen,
			     ai->ai_family, ai->ai_socktype, 
			     ai->ai_protocol, nepim_global.port);
    if (sd < 0) {
      fprintf(stderr, 
	      "could not create UDP listener socket on %s,%d: %d\n",
	      hostname, nepim_global.port, sd);
      break;
    }

    nepim_global.oop_src->on_fd(nepim_global.oop_src,
			  	sd, OOP_READ,
				on_udp_segment, 0);

    fprintf(stderr, 
	    "running UDP listener socket %d on %s,%d\n",
	    sd, hostname, nepim_global.port);
  }

  freeaddrinfo(ai_res);
}



