/*-GNU-GPL-BEGIN-*
nepim - network pipemeter
Copyright (C) 2005 Everton da Silva Marques

nepim is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

nepim is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with nepim; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.
*-GNU-GPL-END-*/


/* $Id: sock.c,v 1.1.1.1 2005/04/09 22:51:48 evertonm Exp $ */

#include <assert.h>
#include <netdb.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdio.h>
#include <errno.h>
#include <string.h>

#include "sock.h"

static void set_port(struct sockaddr *addr, int family, int port)
{
  union {
    struct sockaddr_in inet;
    struct sockaddr_in6 inet6;
  } *sa = (void *) addr;

  switch(family) {
  case PF_INET:
    sa->inet.sin_port = htons(port);
    break;
  case PF_INET6:
    sa->inet6.sin6_port = htons(port);
    break;
  default:
    assert(0);
  }
}

int nepim_socket_block(int sd)
{
  long flags;

  flags = fcntl(sd, F_GETFL, 0);
  if (flags == -1)
    return -1;
  if (fcntl(sd, F_SETFL, flags & ~O_NONBLOCK))
    return -1;

  return 0;
}

int nepim_socket_nonblock(int sd)
{
  long flags;

  flags = fcntl(sd, F_GETFL, 0);
  if (flags == -1)
    return -1;
  if (fcntl(sd, F_SETFL, flags | O_NONBLOCK))
    return -1;

  return 0;
}

int create_listener_socket(struct sockaddr *addr,
			   int addr_len,
                           int family,
                           int type,
                           int protocol,
			   int port)
{
  int sd;

  sd = socket(family, type, protocol);
  if (sd < 0)
    return -1;

  if (nepim_socket_nonblock(sd)) {
    close(sd);
    return -2;
  }

  set_port(addr, family, port);

  if (bind(sd, addr, addr_len)) {
    close(sd);
    return -3;
  }

  if (listen(sd, 3)) {
    close(sd);
    return -4;
  }

  return sd;
}

int connect_client_socket(struct sockaddr *addr,
			  int addr_len,
			  int family,
			  int type,
			  int protocol,
			  int port)
{
  int sd;

  sd = socket(family, type, protocol);
  if (sd < 0)
    return -1;

  if (nepim_socket_block(sd)) {
    close(sd);
    return -1;
  }

  set_port(addr, family, port);

  if (connect(sd, addr, addr_len)) {
    close(sd);
    return -1;
  }

  if (nepim_socket_nonblock(sd)) {
    close(sd);
    return -1;
  }

  return sd;
}
