/*-GNU-GPL-BEGIN-*
nepim - network pipemeter
Copyright (C) 2005 Everton da Silva Marques

nepim is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

nepim is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with nepim; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.
*-GNU-GPL-END-*/


#ifndef NEPIM_CONF_H
#define NEPIM_CONF_H

#include <oop.h>

typedef struct nepim_global_t nepim_global_t;

struct nepim_global_t {
  const char *prog_name;
  const char *hostname;
  int         client_mode;
  int         udp_mode;
  int         duplex_mode;
  int         pipes;
  long long   bit_rate;
  int         stat_interval;
  int         test_duration;
  int         write_size;
  int         read_size;
  int         port;
  int         no_inet6;
  suseconds_t write_delay;

  oop_source_sys *oop_sys;
  oop_source     *oop_src;
};

extern nepim_global_t nepim_global;

#endif /* NEPIM_CONF_H */
