/*-GNU-GPL-BEGIN-*
nepim - network pipemeter - measuring network bandwidth between hosts
Copyright (C) 2005  Everton da Silva Marques

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or (at
your option) any later version.

This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING; if not, write to the
Free Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,
MA 02110-1301 USA
*-GNU-GPL-END-*/

/* $Id: pipe.c,v 1.7 2005/11/04 09:56:14 evertonm Exp $ */

#include <stdlib.h>
#include <stdio.h>
#include <assert.h>

#include "pipe.h"

void nepim_pipe_set_init(nepim_pipe_set_t *set)
{
  nepim_array_init(&set->array);
}

nepim_pipe_t *nepim_pipe_set_get(const nepim_pipe_set_t *set, int sd)
{
  return nepim_array_get(&set->array, sd);
}

void nepim_pipe_set_add(nepim_pipe_set_t *set, int sd, 
			const struct sockaddr *remote,
			socklen_t remote_len,
			const nepim_greet_t *opt)
{
  nepim_pipe_t *pipe = malloc(sizeof(*pipe));
  assert(pipe);

  pipe->sd = sd;
  nepim_session_init(&pipe->session, opt, 
		     remote, remote_len,
		     SESSION_PIPE, sd);

  nepim_array_add(&set->array, sd, pipe);
}

void nepim_pipe_set_del(nepim_pipe_set_t *set, int sd)
{
  nepim_pipe_t *pipe = nepim_pipe_set_get(set, sd);
  assert(pipe);
  free(pipe);
  nepim_array_del(&set->array, sd);
}

