/*-GNU-GPL-BEGIN-*
nepim - network pipemeter - measuring network bandwidth between hosts
Copyright (C) 2005  Everton da Silva Marques

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or (at
your option) any later version.

This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING; if not, write to the
Free Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,
MA 02110-1301 USA
*-GNU-GPL-END-*/

/* $Id: session.c,v 1.7 2005/11/04 09:56:15 evertonm Exp $ */

#include <string.h>
#include <assert.h>

#include "session.h"

void nepim_session_init(nepim_session_t *session, const nepim_greet_t *opt,
			const struct sockaddr *remote, socklen_t remote_len,
			nepim_session_type type, int index)
{
  switch(type) {
  case SESSION_PIPE:
    session->index.pipe_sd = index;
    break;
  case SESSION_SLOT:
    session->index.slot = index;
    break;
  default:
    assert(0);
  }

  session->type = type;

  assert(sizeof(session->remote) >= remote_len);
  memcpy(&session->remote, remote, remote_len);
  session->remote_len = remote_len;

  session->must_send             = opt->must_send;
  session->max_bit_rate          = opt->bit_rate;
  session->max_pkt_rate          = opt->pkt_rate;
  session->stat_interval         = opt->stat_interval;
  session->test_duration         = opt->test_duration;
  session->write_delay           = opt->write_delay;
  session->udp_keepalive_send    = opt->udp_keepalive_send;
  session->udp_keepalive_require = opt->udp_keepalive_require;

  session->duration_done      = 0;
  session->total_reads        = 0;
  session->total_writes       = 0;
  session->interval_reads     = 0;
  session->interval_writes    = 0;
  session->byte_total_sent    = 0;
  session->byte_total_recv    = 0;
  session->byte_interval_sent = 0;
  session->byte_interval_recv = 0;
}

void nepim_session_write_add(nepim_session_t *session, int len)
{
  assert(len >= 0);

  session->byte_total_sent    += len;
  session->byte_interval_sent += len;
  ++session->total_writes;
  ++session->interval_writes;
}

void nepim_session_read_add(nepim_session_t *session, int len)
{
  assert(len >= 0);

  session->byte_total_recv    += len;
  session->byte_interval_recv += len;
  ++session->total_reads;
  ++session->interval_reads;
}
