/*-GNU-GPL-BEGIN-*
nepim - network pipemeter
Copyright (C) 2005 Everton da Silva Marques

nepim is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

nepim is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with nepim; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.
*-GNU-GPL-END-*/


/* $Id: usock.c,v 1.8 2005/08/05 22:45:58 evertonm Exp $ */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>

#include "usock.h"

void nepim_usock_set_init(nepim_usock_set_t *set)
{
  nepim_array_init(&set->array);
}

nepim_usock_t *nepim_usock_set_get(const nepim_usock_set_t *set, int index)
{
  return nepim_array_get(&set->array, index);
}

void nepim_usock_set_add(nepim_usock_set_t *set, int index)
{
  nepim_usock_t *us = malloc(sizeof(*us));
  assert(us);

  us->readers = 0;
  us->writers = 0;
  us->write_soft_errors = 0;
  us->read_soft_errors = 0;
  us->good_writes = 0;
  us->good_reads = 0;

  nepim_array_add(&set->array, index, us);
}

void nepim_usock_set_del(nepim_usock_set_t *set, int index)
{
  nepim_usock_t *us = nepim_usock_set_get(set, index);
  assert(us);
  free(us);
  nepim_array_del(&set->array, index);
}

int nepim_usock_writer_add(nepim_usock_set_t *set, int index)
{
  int w;
  nepim_usock_t *us = nepim_usock_set_get(set, index);
  assert(us);
  assert(us->writers >= 0);

  w = us->writers;

  ++us->writers;

  return w;
}

int nepim_usock_writer_del(nepim_usock_set_t *set, int index)
{
  nepim_usock_t *us = nepim_usock_set_get(set, index);
  assert(us);
  assert(us->writers > 0);

  --us->writers;

  return us->writers;
}

int nepim_usock_reader_add(nepim_usock_set_t *set, int index)
{
  int w;
  nepim_usock_t *us = nepim_usock_set_get(set, index);
  assert(us);
  assert(us->readers >= 0);

  w = us->readers;

  ++us->readers;

  return w;
}

int nepim_usock_reader_del(nepim_usock_set_t *set, int index)
{
  nepim_usock_t *us = nepim_usock_set_get(set, index);
  assert(us);
  assert(us->readers > 0);

  --us->readers;

  return us->readers;
}

void nepim_usock_write_error(nepim_usock_set_t *set, int index,
			     int local_slot, int remote_slot,
			     int err_no)
{
  nepim_usock_t *us = nepim_usock_set_get(set, index);
  assert(us);
  assert(us->write_soft_errors >= 0);
  
  ++us->write_soft_errors;
  
  fprintf(stderr, 
	  "%d %d-%d: sendto: write_soft_errors=%d good_writes=%d errno=%d: %s\n", 
	  index, local_slot, remote_slot,
	  us->write_soft_errors, us->good_writes,
	  err_no, strerror(err_no));
}

void nepim_usock_read_error(nepim_usock_set_t *set, int index,
			    int err_no)
{
  nepim_usock_t *us = nepim_usock_set_get(set, index);
  assert(us);
  assert(us->read_soft_errors >= 0);
  
  ++us->read_soft_errors;
  
  fprintf(stderr, 
	  "%d: recvfrom: read_soft_errors=%d good_reads=%d errno=%d: %s\n", 
	  index, us->read_soft_errors, us->good_reads,
	  err_no, strerror(err_no));
}

void nepim_usock_write_good(nepim_usock_set_t *set, int index)
{
  nepim_usock_t *us = nepim_usock_set_get(set, index);
  assert(us);
  assert(us->good_writes >= 0);
  
  ++us->good_writes;
}

void nepim_usock_read_good(nepim_usock_set_t *set, int index)
{
  nepim_usock_t *us = nepim_usock_set_get(set, index);
  assert(us);
  assert(us->good_reads >= 0);
  
  ++us->good_reads;
}
