/*-GNU-GPL-BEGIN-*
nepim - network pipemeter
Copyright (C) 2005 Everton da Silva Marques

nepim is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

nepim is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with nepim; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.
*-GNU-GPL-END-*/


/* $Id: int.h,v 1.2 2005/08/11 17:55:54 evertonm Exp $ */


#ifndef NEPIM_INT_H
#define NEPIM_INT_H

#ifdef HAVE_STDINT
#include <stdint.h>
#elif HAVE_INTTYPES
#include <inttypes.h>
#else

#ifndef __uint8_t_defined
#define __uint8_t_defined
typedef unsigned char           uint8_t;
#endif

#ifndef __uint16_t_defined
#define __uint16_t_defined
typedef unsigned short int      uint16_t;
#endif

#ifndef __uint32_t_defined
#define __uint32_t_defined
typedef unsigned int            uint32_t;
#endif

#endif /* HAVE_STDINT */

void nepim_int_sanity();

uint16_t nepim_uint16_read(const char *buf);
uint32_t nepim_uint32_read(const char *buf);
void nepim_uint16_write(char *buf, uint16_t value);
void nepim_uint32_write(char *buf, uint32_t value);

#endif /* NEPIM_INT_H */
