/*-GNU-GPL-BEGIN-*
nepim - network pipemeter
Copyright (C) 2005 Everton da Silva Marques

nepim is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

nepim is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with nepim; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.
*-GNU-GPL-END-*/


/* $Id: common.h,v 1.17 2005/09/09 22:17:52 evertonm Exp $ */

#ifndef NEPIM_COMMON_H
#define NEPIM_COMMON_H

#include "pipe.h"
#include "slot.h"
#include "usec.h"

#define NEPIM_MIN(a, b)      (((a) < (b)) ? (a) : (b))
#define NEPIM_MAX(a, b)      (((a) > (b)) ? (a) : (b))
#define NEPIM_RANGE(v, a, b) NEPIM_MIN(NEPIM_MAX((v), (a)), (b))

extern const char * const NEPIM_LABEL_PARTIAL;
extern const char * const NEPIM_LABEL_TOTAL;

const char *nepim_version();

void nepim_pipe_stat(FILE *out, const char *label, int sd,
		     long long bytes_recv, long long bytes_sent, 
		     float interval, long sec_start, 
		     long sec_duration, int reads, int writes);

void nepim_slot_stat(FILE *out, const char *label, int sd,
		     int local_slot, int remote_slot,
		     long long bytes_recv, long long bytes_sent, 
		     float interval, long sec_start, 
		     long sec_duration, int reads, int writes,
		     int pkt_lost, int pkt_dup);

void report_broken_pipe_stat(FILE *out, const nepim_pipe_t *pipe);
void report_broken_slot_stat(FILE *out, const nepim_slot_t *slot);

void nepim_timer_usec_add(struct timeval *tv, susec_t usec);

long long nepim_bps2bytes(long long bps_bit_rate, susec_t usec_delay);
long long nepim_min_bps(susec_t usec_delay);
int nepim_pps2packets(int pps_pkt_rate, susec_t usec_delay);
int nepim_min_pps(susec_t usec_delay);

#endif /* NEPIM_COMMON_H */
