/*
 * calls.c - test for calls.c
 * 
 * Copyright (c) 1997 Phil Maker
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: calls.c,v 1.1.1.1 1997/11/23 11:45:50 pjm Exp $
 */

#include "calls.h"
#include "check.h"
#include <stdio.h>

void f(void *a) {
  printf("f(%d)", (int) a);
}

void g(void *a) {
  printf("g(%d)", (int) a);
}


int main() {
  CALL *empty = 0;
  CALL *one = 0;
  CALL *two = 0;
  CALL *many = 0;
  int i;

  CHECKMESSAGE("calls.c - call list");

  CHECKEMPTY(calls_exec(&empty,0,0));
  CHECKEMPTY(calls_add(&one,f,((void *) 1)));
  CHECKANSWER(calls_exec(&one,0,0),f(1));
  CHECKEMPTY(calls_exec(&empty,0,0));
  
  CHECKEMPTY(calls_add(&two,g,((void *) 10)));
  CHECKEMPTY(calls_add(&two,f,((void *) 11)));
  CHECKANSWER(calls_exec(&two,0,0),f(11)g(10));
  CHECKANSWER(calls_exec(&two,f,0),f(11));
  CHECKANSWER(calls_exec(&two,g,0),g(10));
  CHECKEMPTY(calls_exec(&two,g,((void *)11)));
  
  for(i = 1; i <= 5; i++) {
    CHECKEMPTY(calls_add(&many,g,((void *) i)));
  }
  CHECKEMPTY(calls_exec(&many,f,0));
  CHECKEMPTY(calls_exec(&many,g,(void *) 100));
  CHECKANSWER(calls_exec(&many,g,(void *) 5),g(5));
  CHECKANSWER(calls_exec(&many,g,(void *) 3),g(3));
  CHECKANSWER(calls_exec(&many,g,(void *) 1),g(1));
  CHECKANSWER(calls_exec(&many,0,(void *) 5),g(5));
  CHECKANSWER(calls_exec(&many,0,(void *) 3),g(3));
  CHECKANSWER(calls_exec(&many,0,(void *) 1),g(1));
  CHECKANSWER(calls_exec(&many,0,0),g(5)g(4)g(3)g(2)g(1));
  CHECKANSWER(calls_exec(&many,g,0),g(5)g(4)g(3)g(2)g(1));
  
  CHECKEMPTY(calls_add(&many,f,(void *)1000));
  CHECKANSWER(calls_exec(&many,0,0),f(1000)g(5)g(4)g(3)g(2)g(1));
  CHECKANSWER(calls_exec(&many,g,0),g(5)g(4)g(3)g(2)g(1));
  
  CHECKEMPTY(calls_delete(&many,g,((void *) 3)));
  CHECKANSWER(calls_exec(&many,0,0),f(1000)g(5)g(4)g(2)g(1));
  CHECKANSWER(calls_exec(&many,g,0),g(5)g(4)g(2)g(1));
  
  CHECKEMPTY(calls_delete(&many,f,((void *) 1000)));
  CHECKANSWER(calls_exec(&many,0,0),g(5)g(4)g(2)g(1));
  CHECKANSWER(calls_exec(&many,g,0),g(5)g(4)g(2)g(1));
  
  CHECKEMPTY(calls_delete(&many,0,0));
  CHECKEMPTY(calls_exec(&many,0,0));
  CHECKEMPTY(calls_exec(&many,f,0));
  CHECKEMPTY(calls_exec(&many,0,(void *) 1));
  
  CHECKEMPTY(calls_delete(&empty,0,0));
  CHECKEMPTY(calls_exec(&empty,0,0));
  CHECKEMPTY(calls_exec(&empty,f,0));
  CHECKEMPTY(calls_exec(&empty,0,(void *) 1));

  CHECKEMPTY(calls_delete(&one,0,0));
  CHECKEMPTY(calls_exec(&one,0,0));
  CHECKEMPTY(calls_exec(&one,f,0));
  CHECKEMPTY(calls_exec(&one,0,(void *) 1));

  CHECKEMPTY(calls_delete(&two,0,0));
  CHECKEMPTY(calls_exec(&two,0,0));
  CHECKEMPTY(calls_exec(&two,f,0));
  CHECKEMPTY(calls_exec(&two,0,(void *) 1));
  CHECKEMPTY(calls_delete(&two,0,0));
  CHECKEMPTY(calls_exec(&two,0,0));
  CHECKEMPTY(calls_exec(&two,f,0));
  CHECKEMPTY(calls_exec(&two,0,(void *) 1));

  return 0;
}


