/*
 * manyDI.c - bash test the debugger with 10,000 DI statements.
 * 
 * Note: gdb-4.14 seemed to have problems with this test, 4.16 is ok.
 *
 * Copyright (c) 1997 Phil Maker
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: manyDI.c,v 1.1 1997/05/10 15:12:26 pjm Exp $
 */

#include <stdio.h>

#define DI_DEFAULT_HANDLER(e,f,l,p) \
  @@call printf("fail")@@ \
  @@cont@@

#include "check.h"
#include "DI.h"

int i = 0;

int main() {
  CHECKMESSAGE("* manyDI.c - big mobs of DI statements");

  /* You can't use a macro for this unfortunately since we need */
  /* each DI(..) statement on its own line */
  /* (Oh well, I suppose this file will have a good compression ratio) */
  
  /* Also note that we can use the patch in ../gdb to remove all */
  /* those annoying breakpoint set messages */
  
  CHECKEMPTY(DI( 1 > i));
  CHECKEMPTY(DI( 2 > i));
  CHECKEMPTY(DI( 3 > i));
  CHECKEMPTY(DI( 4 > i));
  CHECKEMPTY(DI( 5 > i));
  CHECKEMPTY(DI( 6 > i));
  CHECKEMPTY(DI( 7 > i));
  CHECKEMPTY(DI( 8 > i));
  CHECKEMPTY(DI( 9 > i));
  CHECKEMPTY(DI( 10 > i));
  CHECKEMPTY(DI( 11 > i));
  CHECKEMPTY(DI( 12 > i));
  CHECKEMPTY(DI( 13 > i));
  CHECKEMPTY(DI( 14 > i));
  CHECKEMPTY(DI( 15 > i));
  CHECKEMPTY(DI( 16 > i));
  CHECKEMPTY(DI( 17 > i));
  CHECKEMPTY(DI( 18 > i));
  CHECKEMPTY(DI( 19 > i));
  CHECKEMPTY(DI( 20 > i));
  CHECKEMPTY(DI( 21 > i));
  CHECKEMPTY(DI( 22 > i));
  CHECKEMPTY(DI( 23 > i));
  CHECKEMPTY(DI( 24 > i));
  CHECKEMPTY(DI( 25 > i));
  CHECKEMPTY(DI( 26 > i));
  CHECKEMPTY(DI( 27 > i));
  CHECKEMPTY(DI( 28 > i));
  CHECKEMPTY(DI( 29 > i));
  CHECKEMPTY(DI( 30 > i));
  CHECKEMPTY(DI( 31 > i));
  CHECKEMPTY(DI( 32 > i));
  CHECKEMPTY(DI( 33 > i));
  CHECKEMPTY(DI( 34 > i));
  CHECKEMPTY(DI( 35 > i));
  CHECKEMPTY(DI( 36 > i));
  CHECKEMPTY(DI( 37 > i));
  CHECKEMPTY(DI( 38 > i));
  CHECKEMPTY(DI( 39 > i));
  CHECKEMPTY(DI( 40 > i));
  CHECKEMPTY(DI( 41 > i));
  CHECKEMPTY(DI( 42 > i));
  CHECKEMPTY(DI( 43 > i));
  CHECKEMPTY(DI( 44 > i));
  CHECKEMPTY(DI( 45 > i));
  CHECKEMPTY(DI( 46 > i));
  CHECKEMPTY(DI( 47 > i));
  CHECKEMPTY(DI( 48 > i));
  CHECKEMPTY(DI( 49 > i));
  CHECKEMPTY(DI( 50 > i));
  CHECKEMPTY(DI( 51 > i));
  CHECKEMPTY(DI( 52 > i));
  CHECKEMPTY(DI( 53 > i));
  CHECKEMPTY(DI( 54 > i));
  CHECKEMPTY(DI( 55 > i));
  CHECKEMPTY(DI( 56 > i));
  CHECKEMPTY(DI( 57 > i));
  CHECKEMPTY(DI( 58 > i));
  CHECKEMPTY(DI( 59 > i));
  CHECKEMPTY(DI( 60 > i));
  CHECKEMPTY(DI( 61 > i));
  CHECKEMPTY(DI( 62 > i));
  CHECKEMPTY(DI( 63 > i));
  CHECKEMPTY(DI( 64 > i));
  CHECKEMPTY(DI( 65 > i));
  CHECKEMPTY(DI( 66 > i));
  CHECKEMPTY(DI( 67 > i));
  CHECKEMPTY(DI( 68 > i));
  CHECKEMPTY(DI( 69 > i));
  CHECKEMPTY(DI( 70 > i));
  CHECKEMPTY(DI( 71 > i));
  CHECKEMPTY(DI( 72 > i));
  CHECKEMPTY(DI( 73 > i));
  CHECKEMPTY(DI( 74 > i));
  CHECKEMPTY(DI( 75 > i));
  CHECKEMPTY(DI( 76 > i));
  CHECKEMPTY(DI( 77 > i));
  CHECKEMPTY(DI( 78 > i));
  CHECKEMPTY(DI( 79 > i));
  CHECKEMPTY(DI( 80 > i));
  CHECKEMPTY(DI( 81 > i));
  CHECKEMPTY(DI( 82 > i));
  CHECKEMPTY(DI( 83 > i));
  CHECKEMPTY(DI( 84 > i));
  CHECKEMPTY(DI( 85 > i));
  CHECKEMPTY(DI( 86 > i));
  CHECKEMPTY(DI( 87 > i));
  CHECKEMPTY(DI( 88 > i));
  CHECKEMPTY(DI( 89 > i));
  CHECKEMPTY(DI( 90 > i));
  CHECKEMPTY(DI( 91 > i));
  CHECKEMPTY(DI( 92 > i));
  CHECKEMPTY(DI( 93 > i));
  CHECKEMPTY(DI( 94 > i));
  CHECKEMPTY(DI( 95 > i));
  CHECKEMPTY(DI( 96 > i));
  CHECKEMPTY(DI( 97 > i));
  CHECKEMPTY(DI( 98 > i));
  CHECKEMPTY(DI( 99 > i));
  CHECKEMPTY(DI( 100 > i));
  CHECKEMPTY(DI( 101 > i));
  CHECKEMPTY(DI( 102 > i));
  CHECKEMPTY(DI( 103 > i));
  CHECKEMPTY(DI( 104 > i));
  CHECKEMPTY(DI( 105 > i));
  CHECKEMPTY(DI( 106 > i));
  CHECKEMPTY(DI( 107 > i));
  CHECKEMPTY(DI( 108 > i));
  CHECKEMPTY(DI( 109 > i));
  CHECKEMPTY(DI( 110 > i));
  CHECKEMPTY(DI( 111 > i));
  CHECKEMPTY(DI( 112 > i));
  CHECKEMPTY(DI( 113 > i));
  CHECKEMPTY(DI( 114 > i));
  CHECKEMPTY(DI( 115 > i));
  CHECKEMPTY(DI( 116 > i));
  CHECKEMPTY(DI( 117 > i));
  CHECKEMPTY(DI( 118 > i));
  CHECKEMPTY(DI( 119 > i));
  CHECKEMPTY(DI( 120 > i));
  CHECKEMPTY(DI( 121 > i));
  CHECKEMPTY(DI( 122 > i));
  CHECKEMPTY(DI( 123 > i));
  CHECKEMPTY(DI( 124 > i));
  CHECKEMPTY(DI( 125 > i));
  CHECKEMPTY(DI( 126 > i));
  CHECKEMPTY(DI( 127 > i));
  CHECKEMPTY(DI( 128 > i));
  CHECKEMPTY(DI( 129 > i));
  CHECKEMPTY(DI( 130 > i));
  CHECKEMPTY(DI( 131 > i));
  CHECKEMPTY(DI( 132 > i));
  CHECKEMPTY(DI( 133 > i));
  CHECKEMPTY(DI( 134 > i));
  CHECKEMPTY(DI( 135 > i));
  CHECKEMPTY(DI( 136 > i));
  CHECKEMPTY(DI( 137 > i));
  CHECKEMPTY(DI( 138 > i));
  CHECKEMPTY(DI( 139 > i));
  CHECKEMPTY(DI( 140 > i));
  CHECKEMPTY(DI( 141 > i));
  CHECKEMPTY(DI( 142 > i));
  CHECKEMPTY(DI( 143 > i));
  CHECKEMPTY(DI( 144 > i));
  CHECKEMPTY(DI( 145 > i));
  CHECKEMPTY(DI( 146 > i));
  CHECKEMPTY(DI( 147 > i));
  CHECKEMPTY(DI( 148 > i));
  CHECKEMPTY(DI( 149 > i));
  CHECKEMPTY(DI( 150 > i));
  CHECKEMPTY(DI( 151 > i));
  CHECKEMPTY(DI( 152 > i));
  CHECKEMPTY(DI( 153 > i));
  CHECKEMPTY(DI( 154 > i));
  CHECKEMPTY(DI( 155 > i));
  CHECKEMPTY(DI( 156 > i));
  CHECKEMPTY(DI( 157 > i));
  CHECKEMPTY(DI( 158 > i));
  CHECKEMPTY(DI( 159 > i));
  CHECKEMPTY(DI( 160 > i));
  CHECKEMPTY(DI( 161 > i));
  CHECKEMPTY(DI( 162 > i));
  CHECKEMPTY(DI( 163 > i));
  CHECKEMPTY(DI( 164 > i));
  CHECKEMPTY(DI( 165 > i));
  CHECKEMPTY(DI( 166 > i));
  CHECKEMPTY(DI( 167 > i));
  CHECKEMPTY(DI( 168 > i));
  CHECKEMPTY(DI( 169 > i));
  CHECKEMPTY(DI( 170 > i));
  CHECKEMPTY(DI( 171 > i));
  CHECKEMPTY(DI( 172 > i));
  CHECKEMPTY(DI( 173 > i));
  CHECKEMPTY(DI( 174 > i));
  CHECKEMPTY(DI( 175 > i));
  CHECKEMPTY(DI( 176 > i));
  CHECKEMPTY(DI( 177 > i));
  CHECKEMPTY(DI( 178 > i));
  CHECKEMPTY(DI( 179 > i));
  CHECKEMPTY(DI( 180 > i));
  CHECKEMPTY(DI( 181 > i));
  CHECKEMPTY(DI( 182 > i));
  CHECKEMPTY(DI( 183 > i));
  CHECKEMPTY(DI( 184 > i));
  CHECKEMPTY(DI( 185 > i));
  CHECKEMPTY(DI( 186 > i));
  CHECKEMPTY(DI( 187 > i));
  CHECKEMPTY(DI( 188 > i));
  CHECKEMPTY(DI( 189 > i));
  CHECKEMPTY(DI( 190 > i));
  CHECKEMPTY(DI( 191 > i));
  CHECKEMPTY(DI( 192 > i));
  CHECKEMPTY(DI( 193 > i));
  CHECKEMPTY(DI( 194 > i));
  CHECKEMPTY(DI( 195 > i));
  CHECKEMPTY(DI( 196 > i));
  CHECKEMPTY(DI( 197 > i));
  CHECKEMPTY(DI( 198 > i));
  CHECKEMPTY(DI( 199 > i));
  CHECKEMPTY(DI( 200 > i));

  return 0;
}
