/*
 * check.h - some macros for writing the test cases.
 *
 *    This files uses the check.awk script to verify the answers; 
 *    it does NO checking by itself.
 *
 * 
 * Copyright (c) 1997 Phil Maker
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: check.h,v 1.2 1997/05/04 14:37:50 pjm Exp $
 */


#ifndef _check_h_
#define _check_h_ 1

/* Note: FS, RS are both also defined in check.awk, change both locations! */
#define FS "@" /* Field seperator in output */
#define RS "\n" /* Record seperator in output */

/*
 * _CHECK(mesg,code,answer) - output consists looks like:
 *
 *     code output FS answer expected FS mesg RS
 */

#define _CHECK(mesg,code,answer) \
{\
      code; \
      printf("%s", FS);\
      printf("%s%s", answer,FS); \
      printf("%s %s:%d %s", mesg, __FILE__, __LINE__,RS);\
}

#define CHECKANSWER(code,answer) \
        _CHECK("CHECK(" #code "," #answer ")",code,#answer)

#define CHECKMESSAGE(mesg) _CHECK("* " mesg,/*g*/,"")
     
#define CHECKEMPTY(code) _CHECK("CHECKEMPTY(" #code  ")",code,"")
#define CHECKFAIL(code) _CHECK("CHECKFAIL(" #code ")",code,"fail")

#define CHECKTRUE(code) \
_CHECK("CHECKTRUE(" #code ")", printf("%d", code), "1"); \
_CHECK("CHECKTRUE(" #code ")", printf("%d", !(code)), "0");

#define CHECKFALSE(code) \
_CHECK("CHECKFALSE(" #code ")", printf("%d", code), "0"); \
_CHECK("CHECKFALSE(" #code ")", printf("%d", !(code)), "1");

#endif /* _check_h_ */

