/*
 * now.c - basic C support for getting the current time.
 *
 * TODO: provide support for other timing routines, changes in headers, etc
 *
 * Copyright (c) 1997 Phil Maker
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: now.c,v 1.4 1997/05/19 09:06:34 pjm Exp $
 */

#include <sys/time.h>

static double base_time = 0.0;

double now(void) {
  struct timeval t;

  if(gettimeofday(&t,0)) {
    /* error handling: do we need a nana wide policy? */
    abort();
  } else {
    return (((double) t.tv_sec) + (((double) t.tv_usec) * 1e-6)) -
      base_time ;
  }
}

void now_reset(void) {
  struct timeval t;

  if(gettimeofday(&t,0)) {
    /* error handling: do we need a nana wide policy? */
    abort();
  } else {
    base_time = ((double) t.tv_sec) + (((double) t.tv_usec) * 1e-6);
  }
}

double now_delta(double *dp) {
  double t = now();
  double d = t - *dp;
  *dp = t;
  return d;
}


    



