/*
 * L.c -  check out L.h
 *
 * Copyright (c) 1997 Phil Maker
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: L.c,v 1.2 1997/05/04 14:37:43 pjm Exp $
 */


#include <stdio.h>
#include "check.h"

#define L_DEFAULT_PARAMS stdout
#define L_DEFAULT_GUARD L_enabled

#include "../src/L.h"

int L_enabled = 1;

int main() {

     CHECKMESSAGE("L.h: basic tests");
     CHECKANSWER(L("hello"),hello);
     CHECKANSWER(L("hello %d", 9+1),hello 10);
     CHECKANSWER(L("hello %d %s",9+1,"x"),hello 10 x);
     CHECKANSWER(L("hello %d\t%s",9+1,"x"),hello 10\tx);
     
     L_enabled = 0;
     CHECKEMPTY(L("hello"));
     CHECKEMPTY(L("hello %d", 9+1));

     return 0;
     
}
