////
// Test script for JavaScript Named Constant Generator (GENNC)
// Copyright (C) 2015 Johannes Willkomm 

assert = require('assert')

function importObject(obj, target) {
    for (k in obj) {
        target[k] = obj[k]
    }
}

var ENUM = {}
// require the generated script which creates the ENUM structure.
// using importObject we can accumulate several name collections in a
// single object
importObject(require('./managedenum.ncd.js'), ENUM)
importObject(require('./test-old-api-wrappers.js'), ENUM)

// when we import the constant and function names in the global
// namespace, we can even use the constant and function names just as
// in C/C++: CONSTANT_A, etc.
importObject(ENUM, global)

// print all entries with their names and values
for (k = 0; k < getNumManagedEnum(); ++k) {
    var val = getManagedEnum(k)
    var name = getManagedEnumName(val)
    console.log('Enum value number %d has name "%s" and value %d',
                k, name, val);
    assert(val == getManagedEnumValue(name))
    assert(val == getManagedEnumValue(name.toLowerCase()))
    assert(val == ManagedEnum.index[name])
    assert(val == ManagedEnum[ManagedEnum.prefix + name])
    assert(name == ManagedEnum.names_index[val])
}
