%%
% Test script for Matlab Named Constant Generator (GENNC)
% Author: Johannes Willkomm
%
% This file is part of Named Constant Generator.
% Copyright © 2009,2010,2011,2012,2013,2015 Johannes Willkomm 
% See the file gennc for copying conditions.


%%
% add directory with helper functions to path
addpath([getenv('GENNC_HOME') '/share/named-constant/matlab'])

%%
% run the generated function which creates the ENUM structure
gennc = createManagedEnum();

%%
% perform some sanity checks
assert(0 == gennc_lookup(gennc, 'constant_A'))
assert(0 == gennc_lookup(gennc, 'CONSTANT_A'))
assert(0 == gennc_lookup(gennc, 'a'))
assert(0 == gennc_lookup(gennc, 'A'))

assert(1 == gennc_lookup(gennc, 'constant_b'))
assert(1 == gennc_lookup(gennc, 'CONSTANT_b'))
assert(1 == gennc_lookup(gennc, 'b'))
assert(1 == gennc_lookup(gennc, 'B'))

assert(12 == gennc_lookup(gennc, 'constant_c'))
assert(12 == gennc_lookup(gennc, 'CONSTANT_c'))
assert(12 == gennc_lookup(gennc, 'c'))
assert(12 == gennc_lookup(gennc, 'C'))

%%
% print all entries with their names and values
fns = fieldnames(gennc.index);
for i=1:length(fieldnames(gennc.index))
  val = gennc.index.(fns{i});
  assert(val == gennc_lookup(gennc, fns{i}))
  assert(strcmp(gennc_get_name(gennc, val), fns{i}))
  fprintf(1, 'Enum value number %d has name "%s" and value %d\n',...
          i-1, gennc_get_name(gennc, val), gennc.index.(fns{i}));
end
