#! /bin/bash

#set -x

# checkParseTreeEqual() {
#     infile=$1
#     exp=$2
#     opts="$3"
#     p2x $opts -p ../../examples/configs/default ../../examples/in/$infile > res.xml
#     xsltproc -o res.txt ../../src/xsl/parens.xsl res.xml
#     res=$(cat res.txt)
#     echo "$infile: $(cat ../../examples/in/$infile)  =>  $res"
#     assertEquals "Parse tree is not in expected form: '$exp' != '$res'" "$exp" "$res"
# }

checkCompileAndRunTestProgram() {
    infile=$1
    cmp=$2
    name="${3:-ManagedEnum}"
    templ="${4:-mainp-template.c}"

    gennc -C $infile
    assertEquals "$?" "0"

    base=$(basename $infile .xml)
    sed -e "s/managedenum.ncd/$base/g" -e "s/ManagedEnum/$name/g" $templ > mainp-template-patched.c
    gcc -Wall -Wextra mainp-template-patched.c
    assertEquals "$?" "0"

    ./a.out > res.txt
    assertEquals "$?" "0"

    res=$(cat res.txt)

    assertEquals "$res" "$cmp"

    rm a.out res.txt $base.hh $base.enum.hh $base.cc
}

checkCompileAndRunCppTestProgram() {
    infile=$1
    cmp=$2
    name="${3:-ManagedEnum}"
    
    gennc -f $infile 
    assertEquals "$?" "0"

    base=$(basename $infile .xml)
    sed -e "s/managedenum.ncd/$base/g" -e "s/ManagedEnum/$name/g" mainp-template.cc > mainp-template-patched.cc
    g++ -Wall -Wextra mainp-template-patched.cc
    assertEquals "$?" "0"

    ./a.out > res.txt
    assertEquals "$?" "0"

    res=$(cat res.txt)

    assertEquals "$res" "$cmp"

    rm a.out res.txt $base.hh $base.enum.hh $base.cc
}

checkCompileAndRunCppClassTestProgram() {
    infile=$1
    cmp=$2
    name="${3:-ManagedEnum}"
    
    gennc -i -I -n TestClass $infile
    assertEquals "$?" "0"

    base=$(basename $infile .xml)
    sed -e "s/managedenum.ncd/$base/g" -e "s/ManagedEnum/$name/g" mainp-template2.cc > mainp-template-patched.cc
    g++ -Wall -Wextra mainp-template-patched.cc
    assertEquals "$?" "0"

    ./a.out > res.txt
    assertEquals "$?" "0"

    res=$(cat res.txt)

    assertEquals "$res" "$cmp"

    rm a.out res.txt $base.hh $base.enum.hh $base.cc
}

testCompileTestProg() {
    cmp=$(cat <<EOF
Enum value number 0 has name "NONE" and value 0
Enum value number 1 has name "IGNORE" and value 1
Enum value number 2 has name "EN_A" and value 17
Enum value number 3 has name "EN_B" and value 18
Enum value number 4 has name "EN_C" and value 20
Enum value number 5 has name "EN_D" and value 21
EOF
       )
    checkCompileAndRunTestProgram managedenum.ncd.xml "$cmp"
}

testCompileTestProg2() {
    cmp=$(cat <<EOF
Enum value number 0 has name "A" and value 0
Enum value number 1 has name "B" and value 1
Enum value number 2 has name "C" and value 12
Enum value number 3 has name "D" and value 13
Enum value number 4 has name "E" and value 4
EOF
       )
    checkCompileAndRunTestProgram ../example.ncd.xml "$cmp" demo mainp-template2.c
}
testCompileCppTestProg() {
    cmp=$(cat <<EOF
Enum value number 0 has name "NONE" and value 0
Enum value number 1 has name "IGNORE" and value 1
Enum value number 2 has name "EN_A" and value 17
Enum value number 3 has name "EN_B" and value 18
Enum value number 4 has name "EN_C" and value 20
Enum value number 5 has name "EN_D" and value 21
EOF
       )
    checkCompileAndRunCppTestProgram managedenum.ncd.xml "$cmp"
}

testCompileCppTestProg2() {
    cmp=$(cat <<EOF
Enum value number 0 has name "A" and value 0
Enum value number 1 has name "B" and value 1
Enum value number 2 has name "C" and value 12
Enum value number 3 has name "D" and value 13
Enum value number 4 has name "E" and value 4
EOF
       )
    checkCompileAndRunCppTestProgram ../example.ncd.xml "$cmp" demo
}

testCompileCppClassTestProg2() {
    cmp=$(cat <<EOF
Enum value number 0 has name "A" and value 0
Enum value number 1 has name "B" and value 1
Enum value number 2 has name "C" and value 12
Enum value number 3 has name "D" and value 13
Enum value number 4 has name "E" and value 4
EOF
       )
    checkCompileAndRunCppClassTestProgram ../example.ncd.xml "$cmp" demo
}

. shunit2
