<?xml version="1.0" encoding="utf-8"?>
<!-- 
This file is part of Named Constant Generator.
Copyright © 2009,2010,2011,2012,2013,2015 Johannes Willkomm 
See the file gennc for copying conditions.
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version="1.0">

  <xsl:output method="text"/>

  <xsl:param name="input-file-name"/>
  <xsl:param name="file-name" select="/*/@name"/>
  <xsl:param name="c-mode" select="false()"/>
  <xsl:param name="class-mode" select="not($c-mode)"/>
  <xsl:param name="ostream-operators" select="not($c-mode)"/>
  <xsl:param name="class-name" select="'Foo'"/>
  <xsl:param name="in-class" select="0"/>
  <xsl:param name="enum-in-class" select="0"/>
  <xsl:param name="strcmp-func" select="'strcasecmp'"/>

  <xsl:template match="/">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template name="file-header">
    <xsl:text>// This file has been automatically generated by&#xa;</xsl:text>
    <xsl:text>// gennc.sh $Id: gennc.xsl 110 2018-10-09 15:02:12Z jwillkomm $&#xa;</xsl:text>
    <xsl:text>// from definition file </xsl:text>
    <xsl:value-of select="$input-file-name"/>
    <xsl:text>. Class mode is </xsl:text>
    <xsl:value-of select="boolean(number($class-mode))"/>
    <xsl:text>.&#xa;</xsl:text>
  </xsl:template>

  <xsl:template name="c-header-guard">
    <xsl:param name="mode" select="'enum'"/>
    <xsl:param name="name" select="@name"/>
    <xsl:variable name="id">
      <xsl:choose>
        <xsl:when test="/*/@id = 'auto'">
          <xsl:value-of select="generate-id()"/>
        </xsl:when>
        <xsl:when test="string-length(/*/@id)">
          <xsl:value-of select="/*/@id"/>
        </xsl:when>
        <xsl:otherwise/>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="hg-name">
      <xsl:text>gennc_</xsl:text>
      <xsl:value-of select="$mode"/>
      <xsl:value-of select="$name"/>
      <xsl:text>_</xsl:text>
      <xsl:value-of select="$id"/>
      <xsl:text>_hh</xsl:text> 
    </xsl:variable>
    <xsl:text>#ifndef </xsl:text>
    <xsl:value-of select="$hg-name"/>
    <xsl:text>&#xa;</xsl:text>
    <xsl:text>#define </xsl:text>
    <xsl:value-of select="$hg-name"/>
    <xsl:text>&#xa;</xsl:text>
  </xsl:template>

  <xsl:template match="ncdef">
    <xsl:document href="{$file-name}.enum.hh" method="text"  encoding="us-ascii">
      <xsl:text>// -*- c++ -*- &#xa;</xsl:text>
      <xsl:call-template name="file-header"/>
      <xsl:call-template name="c-header-guard"/>
      <xsl:apply-templates select="." mode="gen-header"/>
      <xsl:text>#endif&#xa;</xsl:text>
      <xsl:text>&#xa;</xsl:text>
    </xsl:document>
    <xsl:document href="{$file-name}.hh" method="text"  encoding="us-ascii">
      <xsl:text>// -*- c++ -*- &#xa;</xsl:text>
      <xsl:call-template name="file-header"/>
      <xsl:call-template name="c-header-guard">
        <xsl:with-param name="mode" select="'func'"/>
      </xsl:call-template>
      <xsl:apply-templates select="." mode="gen-fun-defs"/>
      <xsl:apply-templates select="." mode="gen-ostream-operators"/>
      <xsl:text>#endif&#xa;</xsl:text>
      <xsl:text>&#xa;</xsl:text>
    </xsl:document>
    <xsl:document href="{$file-name}.cc" method="text"  encoding="us-ascii">
      <xsl:text>// -*- c++ -*- &#xa;</xsl:text>
      <xsl:call-template name="file-header"/>
      <xsl:apply-templates select="." mode="gen-impl"/>
      <xsl:text>&#xa;</xsl:text>
    </xsl:document>
  </xsl:template>

  <xsl:template match="*" mode="gen-header">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="text()" mode="gen-header"/>

  <xsl:template match="c" mode="gen-enum-entry">
    <xsl:value-of select="/*/@c-prefix"/>
    <xsl:value-of select="@name"/>
    <xsl:choose>
      <xsl:when test="count(@val)">
        <xsl:text> = </xsl:text>
        <xsl:value-of select="@val"/>
      </xsl:when>
      <xsl:when test="count(expr)">
        <xsl:text> = </xsl:text>
        <xsl:apply-templates select="expr"/>
      </xsl:when>
    </xsl:choose>
    <xsl:if test="position() != last()">
      <xsl:text>,</xsl:text>
    </xsl:if>
    <xsl:if test="comment">
      <xsl:text> &#x9;/** </xsl:text>
      <xsl:apply-templates select="comment"/>
      <xsl:text> */ </xsl:text>
    </xsl:if>
    <xsl:text>&#xa;</xsl:text>
  </xsl:template>

  <xsl:template match="c" mode="gen-index-switch-entry">
       case <xsl:value-of select="count(preceding::c)"/>: return <xsl:value-of 
         select="/*/@c-prefix"/><xsl:value-of select="@name"/>;</xsl:template>

  <xsl:template match="c" mode="gen-name-switch-entry">
       case <xsl:value-of select="/*/@c-prefix"/>
         <xsl:value-of select="@name"/>: return "<xsl:value-of select="@name"/>";</xsl:template>

  <xsl:template name="gen-c-string">
    <xsl:param name="str"/>
    <xsl:choose>
      <xsl:when test="contains($str, '&#xa;')">
        <xsl:text>"</xsl:text>
        <xsl:value-of select="substring-before($str, '&#xa;')"/>
        <xsl:text>\n"</xsl:text>
        <xsl:text>&#xa;</xsl:text>
        <xsl:call-template name="gen-c-string">
          <xsl:with-param name="str" select="substring-after($str, '&#xa;')"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:text>"</xsl:text>
        <xsl:value-of select="$str"/>
        <xsl:text>"</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="c" mode="gen-comment-switch-entry">
       case <xsl:value-of select="/*/@c-prefix"/>
          <xsl:value-of select="@name"/>: return <xsl:call-template name="gen-c-string">
            <xsl:with-param name="str" select="comment"/>
        </xsl:call-template>;</xsl:template>

  <xsl:template match="c" mode="gen-value-if-clause">
       } else if (<xsl:value-of select="$strcmp-func"/>("<xsl:value-of select="@name"/>", name) == 0<xsl:if test="/*/@c-prefix">
          || <xsl:value-of select="$strcmp-func"/>("<xsl:value-of select="concat(/*/@c-prefix, @name)"/>", name) == 0</xsl:if>) {
          return <xsl:value-of select="concat(/*/@c-prefix, @name)"/>;</xsl:template>

  <xsl:template match="*" mode="gen-value-type">
    <xsl:choose>
      <xsl:when test="$c-mode > 0">unsigned long</xsl:when>
      <xsl:otherwise><xsl:value-of select="@name"/></xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="*" mode="gen-value-signature">
    <xsl:variable name="type">
      <xsl:apply-templates select="." mode="gen-value-type"/>
    </xsl:variable>
    <xsl:value-of select="$type"/> get<xsl:value-of select="@name"/>
    <xsl:text>Value</xsl:text>
  </xsl:template>

  <xsl:template match="ncdef" mode="gen-fun-defs">
    <xsl:if test="not($class-mode > 0) or $c-mode > 0">
    char const *get<xsl:value-of select="@name"/>Name(unsigned long c);
    char const *get<xsl:value-of select="@name"/>Comment(unsigned long c);
    <xsl:apply-templates select="." mode="gen-value-signature"/>(char const *name, int *res<xsl:if test="not($c-mode > 0)"> = 0</xsl:if>);<xsl:text>&#xa;</xsl:text>
    <xsl:if test="not($c-mode > 0)">
    inline <xsl:apply-templates select="." mode="gen-value-signature"/>(std::string const &amp;t, int *res = 0) {
       return get<xsl:value-of select="@name"/>Value(t.c_str(), res);
    }<xsl:text>&#xa;</xsl:text>
    </xsl:if>
    unsigned long getNum<xsl:value-of select="@name"/>();
    <xsl:apply-templates select="." mode="gen-value-type"/> get<xsl:value-of select="@name"/>(int which);
    </xsl:if>
  </xsl:template>

  <xsl:template match="ncdef" mode="gen-ostream-operators">
    <xsl:if test="$ostream-operators > 0">
    inline std::ostream &amp;operator &lt;&lt; (std::ostream &amp;out, <xsl:if test="$class-mode > 0 and $in-class > 0 and $enum-in-class > 0"><xsl:value-of select="$class-name"/>::</xsl:if><xsl:value-of select="@name"/> t) {
       out &lt;&lt; <xsl:if test="$class-mode > 0"><xsl:value-of select="$class-name"/>::</xsl:if>get<xsl:value-of select="@name"/>Name(t);
       return out;
    }
    </xsl:if>
  </xsl:template>

  <xsl:template match="ncdef" mode="gen-header">
    enum <xsl:value-of select="@name"/> {
<xsl:apply-templates select="c" mode="gen-enum-entry"
/>    };
  </xsl:template>

  <xsl:template match="*" mode="gen-impl">
    <xsl:if test="not($c-mode > 0) and not($class-mode > 0 and $in-class > 0)">
#include &lt;string>
#include &lt;cstring>
#include &lt;iostream>
#include &lt;cstdlib>
#include &lt;stdio.h>
#include "<xsl:value-of select="$file-name"/>.enum.hh"
#include "<xsl:value-of select="$file-name"/>.hh"
    </xsl:if>
    <xsl:if test="$c-mode > 0">
#include &lt;stdlib.h>
#include &lt;string.h>
#include &lt;stdio.h>
    </xsl:if>
    <xsl:variable name="stc">
      <xsl:if test="number($class-mode) and not($c-mode > 0)">static </xsl:if>
    </xsl:variable>
    <xsl:value-of select="$stc"/>char const *get<xsl:value-of 
        select="@name"/>Name(unsigned long c) {
      switch(c) { <xsl:apply-templates select="c" mode="gen-name-switch-entry"/>
        default: break;
      }
      return "unknown value in enumeration <xsl:value-of select="@name"/>";
    }
    <xsl:value-of select="$stc"/>char const *get<xsl:value-of 
       select="@name"/>Comment(unsigned long c) {
      switch(c) { <xsl:apply-templates select="c" mode="gen-comment-switch-entry"/>
        default: break;
      }
      return "unknown value in enumeration <xsl:value-of select="@name"/>";
    }
    <xsl:variable name="default">
      <xsl:choose>
        <xsl:when test="$c-mode > 0">(unsigned long)(-1)</xsl:when>
        <xsl:otherwise><xsl:value-of select="/*/@c-prefix"/> <xsl:value-of select="c[1]/@name"/></xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:value-of select="$stc"/>
    <xsl:apply-templates select="." mode="gen-value-signature"/>(char const *name, int *res) {
       if (res) *res = 0;
       if (name == 0 || *name == 0) { return <xsl:value-of select="$default"/>;<xsl:apply-templates 
         select="c" mode="gen-value-if-clause"/>
       } else {
          if (! res) {
            fprintf(stderr, "error: unknown %s constant named `%s'\n",
              "<xsl:value-of select="@name"/>", name);
          } else {
             *res = 1;
          }
          return <xsl:value-of select="$default"/>;
       }
    }
    <xsl:value-of select="$stc"/>unsigned long getNum<xsl:value-of select="@name"/>() {
      return <xsl:value-of select="count(/*/c)"/>;
    }
    <xsl:value-of select="$stc"/><xsl:apply-templates select="." mode="gen-value-type"/> get<xsl:value-of select="@name"/>(int which) {
      switch(which) { <xsl:apply-templates select="c" mode="gen-index-switch-entry"/>
       default: break;
      }
      fprintf(stderr, "error: <xsl:value-of select="@name"/> constant index %d out of range\n",
              which);
      return <xsl:value-of select="/*/@c-prefix"/> <xsl:value-of select="c[1]/@name"/>;
    }
    <xsl:if test="$class-mode > 0 and not($c-mode > 0)">
    inline static <xsl:apply-templates select="." mode="gen-value-signature"/>(std::string const &amp;t, int *res = 0) {
       return get<xsl:value-of select="@name"/>Value(t.c_str(), res);
    }
    </xsl:if>
  </xsl:template>

  <xsl:template match="text()" mode="gen-impl"/>

</xsl:stylesheet>
<!-- $Id: gennc.xsl 110 2018-10-09 15:02:12Z jwillkomm $ -->
