<?xml version="1.0" encoding="utf-8"?>
<!-- 
This file is part of Named Constant Generator.
Copyright © 2009,2010,2011,2012,2013,2015 Johannes Willkomm 
See the file gennc for copying conditions.
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version="1.0">

  <xsl:output method="text"/>

  <xsl:param name="file-name" select="/*/@name"/>
  <xsl:param name="input-file-name"/>
  <xsl:param name="class-name" select="'Foo'"/>
  <xsl:param name="strcmp-func" select="'strcasecmp'"/>

  <xsl:template match="/">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template name="file-header">
    <xsl:text>// This file has been automatically generated by &#xa;</xsl:text>
    <xsl:text>// gennc.sh $Id: gennc-js.xsl 91 2016-01-25 19:18:51Z jwillkomm $&#xa;</xsl:text>
    <xsl:text>// from definition file </xsl:text>
    <xsl:value-of select="$input-file-name"/>
    <xsl:text>.&#xa;</xsl:text>
  </xsl:template>

  <xsl:template match="ncdef">
    <xsl:document href="{$file-name}.js" method="text"  encoding="us-ascii">
      <xsl:text>// -*- javascript -*- &#xa;</xsl:text>
      <xsl:call-template name="file-header"/>
      <xsl:apply-templates select="." mode="gen-js"/>
    </xsl:document>
  </xsl:template>

  <xsl:template match="text()" mode="gen-js"/>

  <xsl:template match="ncdef" mode="gen-js">
if (typeof window == "undefined") {
  var ENUM = require('./gennc-common.js')
}
ENUM.create<xsl:value-of select="@name"/> = function() {
 var k=0
 var prefix='<xsl:value-of select="/*/@c-prefix"/>'
 var index={
 <xsl:for-each select="c">
  <xsl:value-of select="@name"/>
  <xsl:text>: </xsl:text>
  <xsl:choose>
  <xsl:when test="string(@val)">(k=<xsl:value-of select="@val"/>)</xsl:when>
  <xsl:otherwise>++k</xsl:otherwise>
  </xsl:choose>,
 </xsl:for-each>}
 var comments<xsl:if test="c/comment[string-length(.)>0]">
 comments={
 <xsl:for-each select="c">
  <xsl:value-of select="@name"/>
  <xsl:text>: '</xsl:text>
  <xsl:value-of select="comment"/>',
 </xsl:for-each>}
 </xsl:if>
 var res=ENUM.createENUM(index, prefix, comments)
 return res
}
ENUM.<xsl:value-of select="@name"/>=ENUM.create<xsl:value-of select="@name"/>()
if (typeof window == 'undefined') {
 for (k in ENUM) {
  exports[k]=ENUM[k]
 }
}
  </xsl:template>

</xsl:stylesheet>
<!-- $Id: gennc-js.xsl 91 2016-01-25 19:18:51Z jwillkomm $ -->
