////
// Test script for JavaScript Named Constant Generator (GENNC)
// Copyright (C) 2015 Johannes Willkomm 

function importObject(obj, target) {
    for (k in obj) {
        target[k] = obj[k]
    }
}
function assert(cond, msg) {
    if (cond) {
    } else {
        process.exit(1)
    }
}

// require the generated script which creates the ENUM structure
var ENUM = {}
ENUM.ManagedEnum = require('./managedenum.ncd.js')

// import the constant names in the global namespace
importObject(ENUM.ManagedEnum, ENUM)
importObject(ENUM.ManagedEnum, global)

// check that the constant identifiers are really in the global
// namespace with the correct values
assert(0 == CONSTANT_A)
assert(1 == CONSTANT_B)
assert(12 == CONSTANT_C)
assert(13 == CONSTANT_D)
assert(4 == CONSTANT_E)

// print all entries with their names and values
for (k = 0; k < ENUM.getNumManagedEnum(); ++k) {
    var val = ENUM.getManagedEnum(k)
    var name = ENUM.getManagedEnumName(val)
    var val2 = ENUM.getManagedEnumValue(name)
    assert(val == val2)
    console.log('Enum value number %d has name "%s" and value %d',
                k, name, val);
}
