#! /bin/bash

#set -x

checkCompileAndRunTestProgram() {
    infile=$1
    cmp=$2
    name="${3:-ManagedEnum}"
    templ="${4:-mainscript.js}"
    
    gennc -m JavaScript $infile
    assertEquals "$?" "0"

    base=$(basename $infile .xml)
    sed -e "s/managedenum.ncd/$base/g" -e "s/ManagedEnum/$name/g" $templ > mainscriptpatched.js
    nodejs mainscriptpatched.js > res.txt
    assertEquals "$?" "0"

    res=$(cat res.txt)

    assertEquals "$res" "$cmp"

    rm res.txt $base.js
}

testCompileTestProg() {
    cmp=$(cat <<EOF
Enum value number 0 has name "A" and value 0
Enum value number 1 has name "B" and value 1
Enum value number 2 has name "C" and value 12
Enum value number 3 has name "D" and value 13
Enum value number 4 has name "E" and value 4
EOF
       )
    checkCompileAndRunTestProgram ../example.ncd.xml "$cmp" demo
}

testCompileTestProg2() {
    cmp=$(cat <<EOF
Enum value number 0 has name "A" and value 0
Enum value number 1 has name "B" and value 1
Enum value number 2 has name "C" and value 12
Enum value number 3 has name "D" and value 13
Enum value number 4 has name "E" and value 4
EOF
       )
    checkCompileAndRunTestProgram ../example.ncd.xml "$cmp" demo mainscript2.js
}

testCompileTestProg3() {
    cmp=$(cat <<EOF
Enum value number 0 has name "A" and value 0
Enum value number 1 has name "B" and value 1
Enum value number 2 has name "C" and value 12
Enum value number 3 has name "D" and value 13
Enum value number 4 has name "E" and value 4
EOF
       )
    checkCompileAndRunTestProgram ../example.ncd.xml "$cmp" demo mainscript3.js
}

. shunit2
