#! /bin/bash

#set -x

# checkParseTreeEqual() {
#     infile=$1
#     exp=$2
#     opts="$3"
#     p2x $opts -p ../../examples/configs/default ../../examples/in/$infile > res.xml
#     xsltproc -o res.txt ../../src/xsl/parens.xsl res.xml
#     res=$(cat res.txt)
#     echo "$infile: $(cat ../../examples/in/$infile)  =>  $res"
#     assertEquals "Parse tree is not in expected form: '$exp' != '$res'" "$exp" "$res"
# }

checkCompileAndRunTestProgram() {
    infile=$1
    cmp=$2
    name="${3:-ManagedEnum}"

    gennc -m Matlab $infile
    assertEquals "$?" "0"

    base=$(basename $infile .xml)
    sed -e "s/ManagedEnum/$name/g" mainscript.m > mainscriptpatched.m
    octave --quiet --eval "mainscriptpatched; quit" > res.txt
    assertEquals "$?" "0"

    res=$(cat res.txt)

    assertEquals "$res" "$cmp"

    rm res.txt create$name.m
}

checkCompileAndRunTestProgram2() {
    infile=$1
    cmp=$2
    name="${3:-ManagedEnum}"

    gennc -m Matlab $infile
    assertEquals "$?" "0"

    base=$(basename $infile .xml)
    sed -e "s/ManagedEnum/$name/g" mainscript2.m > mainscriptpatched.m
    octave --quiet --eval "mainscriptpatched; quit" > res.txt
    assertEquals "$?" "0"

    res=$(cat res.txt)

    assertEquals "$res" "$cmp"

    rm res.txt create$name.m
}

testCompileTestProg() {
    cmp=$(cat <<EOF
Enum value number 0 has name "A" and value 0
Enum value number 1 has name "B" and value 1
Enum value number 2 has name "C" and value 12
Enum value number 3 has name "D" and value 13
Enum value number 4 has name "E" and value 4
EOF
       )
    checkCompileAndRunTestProgram ../example.ncd.xml "$cmp" demo
}

testCompileTestProg2() {
    cmp=$(cat <<EOF
Enum value number 0 has name "A" and value 0
Enum value number 1 has name "B" and value 1
Enum value number 2 has name "C" and value 12
Enum value number 3 has name "D" and value 13
Enum value number 4 has name "E" and value 4
EOF
       )
    checkCompileAndRunTestProgram2 ../example.ncd.xml "$cmp" demo
}

. shunit2
