<?xml version="1.0" encoding="utf-8"?>
<!-- 
This file is part of Named Constant Generator.
Copyright © 2009,2010,2011,2012,2013,2015 Johannes Willkomm 
See the file gennc for copying conditions.
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version="1.0">

  <xsl:output method="text"/>

  <xsl:param name="file-name" select="/*/@name"/>
  <xsl:param name="input-file-name"/>
  <xsl:param name="class-name" select="'Foo'"/>
  <xsl:param name="strcmp-func" select="'strcasecmp'"/>

  <xsl:template match="/">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template name="file-header">
    <xsl:text>// This file has been automatically generated by &#xa;</xsl:text>
    <xsl:text>// gennc.sh $Id: gennc-js.xsl 50 2015-04-08 12:45:49Z jwillkomm $ &#xa;</xsl:text>
    <xsl:text>// from definition file </xsl:text>
    <xsl:value-of select="$input-file-name"/>
    <xsl:text>.&#xa;</xsl:text>
  </xsl:template>

  <xsl:template match="ncdef">
    <xsl:document href="{$file-name}.js" method="text"  encoding="us-ascii">
      <xsl:text>// -*- javascript -*- &#xa;</xsl:text>
      <xsl:call-template name="file-header"/>
      <xsl:apply-templates select="." mode="gen-js"/>
    </xsl:document>
  </xsl:template>

  <xsl:template match="text()" mode="gen-js"/>

  <xsl:template match="ncdef" mode="gen-js">
    var ENUM = ENUM || {}
    ENUM.create<xsl:value-of select="@name"/> = function() {
      var k = 0
      var prefix = '<xsl:value-of select="/*/@c-prefix"/>'
      var index = {
        <xsl:for-each select="c">
          <xsl:value-of select="@name"/>
          <xsl:text>: </xsl:text>
          <xsl:choose>
            <xsl:when test="string(@val)">(k = <xsl:value-of select="@val"/>)</xsl:when>
            <xsl:otherwise>++k</xsl:otherwise>
          </xsl:choose>,
        </xsl:for-each>
      }
      var findex = {
        <xsl:for-each select="c">
          <xsl:value-of select="/*/@c-prefix"/>
          <xsl:value-of select="@name"/>
          <xsl:text>: </xsl:text>
          <xsl:choose>
            <xsl:when test="string(@val)">(k = <xsl:value-of select="@val"/>)</xsl:when>
            <xsl:otherwise>++k</xsl:otherwise>
          </xsl:choose>,
        </xsl:for-each>
      }
      var comments = {
        <xsl:for-each select="c">
          <xsl:value-of select="@name"/>
          <xsl:text>: '</xsl:text>
          <xsl:value-of select="comment"/>',
        </xsl:for-each>
      }
      var names = []
      var names_index = {}
      for (n in index) {
        names.push(n)
        names_index[index[n]] = n
      }
      var names_l = names.map(function (n) { return n.toLowerCase(); })
      var res = findex
      res.prefix = prefix
      res.index = index
      res.full_index = findex
      res.names = names
      res.names_l = names_l
      res.names_index = names_index
      res.comments = comments
      return res
    }
    ENUM.<xsl:value-of select="@name"/> = ENUM.create<xsl:value-of select="@name"/>()
    ENUM.get<xsl:value-of select="@name"/>Name = function(code) {
      return ENUM.<xsl:value-of select="@name"/>.names_index[code]
    }
    ENUM.get<xsl:value-of select="@name"/>Comment = function(code) {
      var name = ENUM.get<xsl:value-of select="@name"/>Name(code)
      return ENUM.<xsl:value-of select="@name"/>.comments[name]
    }
    ENUM.get<xsl:value-of select="@name"/>Value = function(name) {
      if (name in ENUM.<xsl:value-of select="@name"/>.index) {
        return ENUM.<xsl:value-of select="@name"/>.index[name];
      } else {
         var pname = name.substring(ENUM.<xsl:value-of select="@name"/>.prefix.length)
         if (pname &amp;&amp; pname in ENUM.<xsl:value-of select="@name"/>.index) {
            return ENUM.<xsl:value-of select="@name"/>.index[pname]
         } else if (ENUM.<xsl:value-of select="@name"/>.names_l.indexOf(name) > -1) {
           return ENUM.<xsl:value-of select="@name"/>.index[ENUM.<xsl:value-of select="@name"/>.names[ENUM.<xsl:value-of select="@name"/>.names_l.indexOf(name)]]
         } else if (ENUM.<xsl:value-of select="@name"/>.names_l.indexOf(pname) > -1) {
           return ENUM.<xsl:value-of select="@name"/>.index[ENUM.<xsl:value-of select="@name"/>.names[ENUM.<xsl:value-of select="@name"/>.names_l.indexOf(pname)]]
         }
      }
    }
    ENUM.getNum<xsl:value-of select="@name"/> = function() {
      return ENUM.<xsl:value-of select="@name"/>.names.length
    }
    ENUM.get<xsl:value-of select="@name"/> = function(which) {
       var name = ENUM.<xsl:value-of select="@name"/>.names[which]
       return ENUM.get<xsl:value-of select="@name"/>Value(name)
    }
    <!-- var ncs = ENUM.<xsl:value-of select="@name"/> -->
    <!-- console.dir(ENUM.<xsl:value-of select="@name"/>) -->
    <!-- for (k = 0; k &lt; ENUM.getNum<xsl:value-of select="@name"/>(); ++k) { -->
    <!--   var code -->
      <!-- console.log('Code: ' + (code = ENUM.get<xsl:value-of select="@name"/>(k))) -->
      <!-- console.log('Name: ' + ENUM.get<xsl:value-of select="@name"/>Name(code)) -->
      <!-- console.log('Comment: ' + ENUM.get<xsl:value-of select="@name"/>Comment(code)) -->
    <!-- } -->
    <!-- console.log('TCode: ' + ENUM.get<xsl:value-of select="@name"/>Value('a')) -->
    <!-- console.log('TCode: ' + ENUM.get<xsl:value-of select="@name"/>Value('A')) -->
    <!-- console.log('TCode: ' + ENUM.get<xsl:value-of select="@name"/>Value('CONSTANT_a')) -->
    if (typeof window == 'undefined') {
       for (k in ENUM) {
          exports[k] = ENUM[k]
       }
       <!-- exports.ENUM = ENUM -->
    }
  </xsl:template>

</xsl:stylesheet>
<!-- $Id: gennc-js.xsl 50 2015-04-08 12:45:49Z jwillkomm $ -->
